// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.onnx;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.onnx.global.onnx.*;


// Data type utility, which maintains a global type string to TypeProto map.
// DataType (string pointer) is used as unique data type identifier for
// efficiency.
//
// Grammar for data type string:
// <type> ::= <data_type> |
//            tensor(<data_type>) |
//            seq(<type>) |
//            map(<data_type>, <type>)
// <data_type> :: = float | int32 | string | bool | uint8
//                | int8 | uint16 | int16 | int64 | float16 | double
//
// NOTE: <type> ::= <data_type> means the data is scalar (zero dimension).
//
// Example: float, tensor(float), etc.
//
@Namespace("onnx::Utils") @Properties(inherit = org.bytedeco.onnx.presets.onnx.class)
public class DataTypeUtils extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public DataTypeUtils() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DataTypeUtils(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DataTypeUtils(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public DataTypeUtils position(long position) {
        return (DataTypeUtils)super.position(position);
    }
    @Override public DataTypeUtils getPointer(long i) {
        return new DataTypeUtils((Pointer)this).offsetAddress(i);
    }

  // If the DataType input is invalid, this function will throw std::invalid_argument exception.
  // If ONNX_NO_EXCEPTIONS is set it will abort.
  public static native @StdString @ByVal @Cast({"char*", "std::string*"}) BytePointer ToType(@StdString BytePointer type_str);
  public static native @StdString @ByVal @Cast({"char*", "std::string*"}) BytePointer ToType(@StdString String type_str);

  // If the DataType input is invalid, this function will throw std::invalid_argument exception.
  // If ONNX_NO_EXCEPTIONS is set it will abort.
  public static native @StdString @ByVal @Cast({"char*", "std::string*"}) BytePointer ToType(@Const @ByRef TypeProto type_proto);

  // If the DataType input is invalid, this function will throw std::invalid_argument exception.
  // If ONNX_NO_EXCEPTIONS is set it will abort.
  public static native @Const @ByRef TypeProto ToTypeProto(@StdString @ByRef @Cast({"char*", "std::string*"}) BytePointer data_type);
  public static native @StdString BytePointer ToDataTypeString(int tensor_data_type);
}
