// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.onnx;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.onnx.global.onnx.*;


/**
 * \brief A class to record the schema of an op.
 *
 * OpSchema records the common interface of an op specified by its name.
 *
 * To register an OpSchema, one can use the macro ONNX_OPERATOR_SCHEMA(name) and
 * then append the various functions in the class. For example, for an op
 * that takes in two inputs, one output, and the first input and output
 * could be in-place, can be written as
 *
 *     ONNX_OPERATOR_SCHEMA(name)
 *         .NumInputs(2).NumOutputs(1).AllowConsumed({{0, 0}});
 *
 * To manufacture methods that may be used to register an OpSchema
 * non-statically, the following may be used:
 *
 *     ONNX_OPERATOR_SET_SCHEMA(name, version, OpSchema()
 *         .NumInputs(2).NumOutputs(1).AllowConsumed({{0, 0}}));
 */
@Namespace("onnx") @NoOffset @Properties(inherit = org.bytedeco.onnx.presets.onnx.class)
public class OpSchema extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public OpSchema(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public OpSchema(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public OpSchema position(long position) {
        return (OpSchema)super.position(position);
    }
    @Override public OpSchema getPointer(long i) {
        return new OpSchema((Pointer)this).offsetAddress(i);
    }

  @MemberGetter public static native int kUninitializedSinceVersion();
  public static final int kUninitializedSinceVersion = kUninitializedSinceVersion();
  // Formal parameter options.
  /** enum onnx::OpSchema::FormalParameterOption */
  public static final byte
    // The formal parameter is single and not optional.
    // Number of supplied actual parameters must be 1.
    Single = (byte)(0),
    // The formal parameter is single and optional.
    // Number of supplied actual parameters may be 0 or 1.
    Optional = (byte)(1),
    // The formal parameter is variadic.
    // Number of supplied actual parameters must be N or more, where
    // the minimum value N is indicated separately (default value 1).
    Variadic = (byte)(2);
  /** enum onnx::OpSchema::DifferentiationCategory */
  public static final byte
    // Whether this formal parameter is differentiable or not cannot
    // be statically determined. It also covers variadic formal
    // parameters which contain both of differentiable and
    // non-differentiable variables.
    Unknown = (byte)(0),
    // This formal parameter is differentiable. That is, this formal
    // parameter can be differentiable input of Gradient operator.
    Differentiable = (byte)(1),
    // This formal parameter is not differentiable. That is, this formal
    // parameter can not be differentiable input of Gradient operator.
    NonDifferentiable = (byte)(2);

  // Formal parameter represenation, including input/output name, typeStr,
  // description, and type constraints.
  @NoOffset public static class FormalParameter extends Pointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public FormalParameter(Pointer p) { super(p); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public FormalParameter(long size) { super((Pointer)null); allocateArray(size); }
      private native void allocateArray(long size);
      @Override public FormalParameter position(long position) {
          return (FormalParameter)super.position(position);
      }
      @Override public FormalParameter getPointer(long i) {
          return new FormalParameter((Pointer)this).offsetAddress(i);
      }
  
    // Constructor.
    public FormalParameter() { super((Pointer)null); allocate(); }
    private native void allocate();

    public FormalParameter(
            @StdString BytePointer name,
            @ByVal DataTypeSet allowed_type_set,
            @StdString BytePointer type_str,
            @StdString BytePointer description,
            @Cast("onnx::OpSchema::FormalParameterOption") byte param_option/*=onnx::OpSchema::Single*/,
            @Cast("bool") boolean is_homogeneous/*=true*/,
            int min_arity/*=1*/,
            @Cast("onnx::OpSchema::DifferentiationCategory") byte differentiation_category/*=onnx::OpSchema::Unknown*/) { super((Pointer)null); allocate(name, allowed_type_set, type_str, description, param_option, is_homogeneous, min_arity, differentiation_category); }
    private native void allocate(
            @StdString BytePointer name,
            @ByVal DataTypeSet allowed_type_set,
            @StdString BytePointer type_str,
            @StdString BytePointer description,
            @Cast("onnx::OpSchema::FormalParameterOption") byte param_option/*=onnx::OpSchema::Single*/,
            @Cast("bool") boolean is_homogeneous/*=true*/,
            int min_arity/*=1*/,
            @Cast("onnx::OpSchema::DifferentiationCategory") byte differentiation_category/*=onnx::OpSchema::Unknown*/);
    public FormalParameter(
            @StdString BytePointer name,
            @ByVal DataTypeSet allowed_type_set,
            @StdString BytePointer type_str,
            @StdString BytePointer description) { super((Pointer)null); allocate(name, allowed_type_set, type_str, description); }
    private native void allocate(
            @StdString BytePointer name,
            @ByVal DataTypeSet allowed_type_set,
            @StdString BytePointer type_str,
            @StdString BytePointer description);
    public FormalParameter(
            @StdString String name,
            @ByVal DataTypeSet allowed_type_set,
            @StdString String type_str,
            @StdString String description,
            @Cast("onnx::OpSchema::FormalParameterOption") byte param_option/*=onnx::OpSchema::Single*/,
            @Cast("bool") boolean is_homogeneous/*=true*/,
            int min_arity/*=1*/,
            @Cast("onnx::OpSchema::DifferentiationCategory") byte differentiation_category/*=onnx::OpSchema::Unknown*/) { super((Pointer)null); allocate(name, allowed_type_set, type_str, description, param_option, is_homogeneous, min_arity, differentiation_category); }
    private native void allocate(
            @StdString String name,
            @ByVal DataTypeSet allowed_type_set,
            @StdString String type_str,
            @StdString String description,
            @Cast("onnx::OpSchema::FormalParameterOption") byte param_option/*=onnx::OpSchema::Single*/,
            @Cast("bool") boolean is_homogeneous/*=true*/,
            int min_arity/*=1*/,
            @Cast("onnx::OpSchema::DifferentiationCategory") byte differentiation_category/*=onnx::OpSchema::Unknown*/);
    public FormalParameter(
            @StdString String name,
            @ByVal DataTypeSet allowed_type_set,
            @StdString String type_str,
            @StdString String description) { super((Pointer)null); allocate(name, allowed_type_set, type_str, description); }
    private native void allocate(
            @StdString String name,
            @ByVal DataTypeSet allowed_type_set,
            @StdString String type_str,
            @StdString String description);

    public FormalParameter(
            @StdString BytePointer name,
            @StdString BytePointer description,
            @StdString BytePointer type_str,
            @Cast("onnx::OpSchema::FormalParameterOption") byte param_option/*=onnx::OpSchema::Single*/,
            @Cast("bool") boolean is_homogeneous/*=true*/,
            int min_arity/*=1*/,
            @Cast("onnx::OpSchema::DifferentiationCategory") byte differentiation_category/*=onnx::OpSchema::Unknown*/) { super((Pointer)null); allocate(name, description, type_str, param_option, is_homogeneous, min_arity, differentiation_category); }
    private native void allocate(
            @StdString BytePointer name,
            @StdString BytePointer description,
            @StdString BytePointer type_str,
            @Cast("onnx::OpSchema::FormalParameterOption") byte param_option/*=onnx::OpSchema::Single*/,
            @Cast("bool") boolean is_homogeneous/*=true*/,
            int min_arity/*=1*/,
            @Cast("onnx::OpSchema::DifferentiationCategory") byte differentiation_category/*=onnx::OpSchema::Unknown*/);
    public FormalParameter(
            @StdString BytePointer name,
            @StdString BytePointer description,
            @StdString BytePointer type_str) { super((Pointer)null); allocate(name, description, type_str); }
    private native void allocate(
            @StdString BytePointer name,
            @StdString BytePointer description,
            @StdString BytePointer type_str);
    public FormalParameter(
            @StdString String name,
            @StdString String description,
            @StdString String type_str,
            @Cast("onnx::OpSchema::FormalParameterOption") byte param_option/*=onnx::OpSchema::Single*/,
            @Cast("bool") boolean is_homogeneous/*=true*/,
            int min_arity/*=1*/,
            @Cast("onnx::OpSchema::DifferentiationCategory") byte differentiation_category/*=onnx::OpSchema::Unknown*/) { super((Pointer)null); allocate(name, description, type_str, param_option, is_homogeneous, min_arity, differentiation_category); }
    private native void allocate(
            @StdString String name,
            @StdString String description,
            @StdString String type_str,
            @Cast("onnx::OpSchema::FormalParameterOption") byte param_option/*=onnx::OpSchema::Single*/,
            @Cast("bool") boolean is_homogeneous/*=true*/,
            int min_arity/*=1*/,
            @Cast("onnx::OpSchema::DifferentiationCategory") byte differentiation_category/*=onnx::OpSchema::Unknown*/);
    public FormalParameter(
            @StdString String name,
            @StdString String description,
            @StdString String type_str) { super((Pointer)null); allocate(name, description, type_str); }
    private native void allocate(
            @StdString String name,
            @StdString String description,
            @StdString String type_str);

    // Get formal parameter name.
    public native @StdString BytePointer GetName();

    // Get allowed data types.
    public native @Const @ByRef DataTypeSet GetTypes();

    // Get formal parameter type string.
    public native @StdString BytePointer GetTypeStr();

    // Get formal parameter description.
    public native @StdString BytePointer GetDescription();

    // Get the parameter option, it could be Single, Optional or Variadic.
    public native @Cast("onnx::OpSchema::FormalParameterOption") byte GetOption();

    // Get whether a variadic parameter requires all to be of same type
    public native @Cast("bool") boolean GetIsHomogeneous();

    // Get minimum arity. Applicable only in the Variadic case.
    public native int GetMinArity();

    // Get the differentiation property of this formal parameter.
    public native @Cast("onnx::OpSchema::DifferentiationCategory") byte GetDifferentiationCategory();
  }

  /** enum class onnx::OpSchema::SupportType */
  public static final byte
    COMMON = (byte)(0), // Supported by all frameworks that support this IR.
    EXPERIMENTAL = (byte)(1); // This OP is experimental and can be changed or removed in
                  // the future.

  public OpSchema() { super((Pointer)null); allocate(); }
  private native void allocate();
  public OpSchema(@StdString BytePointer name, @StdString BytePointer file, int line) { super((Pointer)null); allocate(name, file, line); }
  private native void allocate(@StdString BytePointer name, @StdString BytePointer file, int line);
  public OpSchema(@StdString String name, @StdString String file, int line) { super((Pointer)null); allocate(name, file, line); }
  private native void allocate(@StdString String name, @StdString String file, int line);

  /**
   * \brief Returns the file that the op schema is registered from.
   */
  public native @StdString BytePointer file();

  /**
   * \brief Returns the line in file that the op schema is registered from.
   */
  public native int line();

  /**
   * \brief Returns the support level of the op schema.
   */
  public native @Cast("onnx::OpSchema::SupportType") byte support_level();

  /**
   * \brief Returns the docstring of the op schema.
   */
  public native @Cast("const char*") BytePointer doc();

  // Check if input and output types fall into valid set and match each other
  public native void CheckInputOutputType(@ByRef InferenceContext arg0);

  /**
   * \brief Verifies if a NodeProto matches the pattern specified in
   * the schema.
   */
  public native void Verify(@Const @ByRef NodeProto node);

  // Functions to set the property of the operator schemas.
  // Sets the number of inputs, either a fixed number or a min and a max.

  /**
   * The earliest operator set version which this operator was
   * present in.  If an operator has had no BC-breaking changes,
   * this is simply the first operator set the operator was a member
   * of; if it has had BC-breaking changes, then for the semantics
   * /as described/ in the OpSchema entry, this version describes
   * the operator set which introduced the BC-breaking change.
   *
   * For example, suppose op Foo was added in v3, and had a BC-breaking
   * change in v6.  Then there will be an op schema entry for Foo with
   * SinceVersion(3), and another, updated op schema entry for Foo
   * with SinceVersion(6).
   */
  public native @ByRef @Function OpSchema SinceVersion(@Cast("onnx::OperatorSetVersion") int n); // aka int

  /**
   * Marks this op as deprecated as of it's since_version. This will cause the
   * Schema() lookup functions to return nullptr when the version is in the
   * deprecated range.
   */
  public native @ByRef OpSchema Deprecate();

  public native @Cast("bool") boolean Deprecated();

  /**
   * \brief Input could be one of the values specified in allowed_input_nums.
   */
  public native @ByRef OpSchema NumInputs(@ByVal IntSet allowed_input_nums);

  /**
   * \brief Output could be one of the values specified in allowed_output_nums.
   */
  public native @ByRef OpSchema NumOutputs(@ByVal IntSet allowed_output_nums);

  // Shape Inference
  //
  // Note that signatures are defined to allow for forward-declaring
  // any structs used from ir.h
  public native @ByRef OpSchema TypeAndShapeInferenceFunction(@ByVal InferenceFunction inferenceFunction);
  

  public native @ByRef OpSchema PartialDataPropagationFunction(@ByVal DataPropagationFunction dataProgationFunction);
  

  // Set the support level for the op schema.
  public native @ByRef OpSchema SetSupportLevel(@Cast("onnx::OpSchema::SupportType") byte supportType);

  // Functions to do documentation for the operator schema.
  // This may be disabled to save memory.
  public native @ByRef OpSchema SetDoc(@Cast("const char*") BytePointer doc);
  public native @ByRef OpSchema SetDoc(String doc);

  // Functions to specify name for the operator schema.
  public native @ByRef OpSchema SetName(@Cast("const char*") BytePointer name);
  public native @ByRef OpSchema SetName(String name);

  // Functions to specify code location for the operator schema.
  public native @ByRef OpSchema SetLocation(@Cast("const char*") BytePointer file, int line);
  public native @ByRef OpSchema SetLocation(String file, int line);

  // Functions to specify domain for the operator schema.
  // Default domain value (ONNX_DOMAIN) means it's ONNX domain.
  public native @ByRef OpSchema SetDomain(@Cast("const char*") BytePointer domain);
  public native @ByRef OpSchema SetDomain(String domain);

  @NoOffset public static class Attribute extends Pointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attribute(Pointer p) { super(p); }
  
    public Attribute(@StdString BytePointer name_, @StdString BytePointer description_, @Cast("onnx::AttributeProto::AttributeType") int type_, @Cast("bool") boolean required_) { super((Pointer)null); allocate(name_, description_, type_, required_); }
    private native void allocate(@StdString BytePointer name_, @StdString BytePointer description_, @Cast("onnx::AttributeProto::AttributeType") int type_, @Cast("bool") boolean required_);
    public Attribute(@StdString String name_, @StdString String description_, @Cast("onnx::AttributeProto::AttributeType") int type_, @Cast("bool") boolean required_) { super((Pointer)null); allocate(name_, description_, type_, required_); }
    private native void allocate(@StdString String name_, @StdString String description_, @Cast("onnx::AttributeProto::AttributeType") int type_, @Cast("bool") boolean required_);

    public Attribute(@StdString BytePointer name_, @StdString BytePointer description_, @ByVal AttributeProto default_value_) { super((Pointer)null); allocate(name_, description_, default_value_); }
    private native void allocate(@StdString BytePointer name_, @StdString BytePointer description_, @ByVal AttributeProto default_value_);
    public Attribute(@StdString String name_, @StdString String description_, @ByVal AttributeProto default_value_) { super((Pointer)null); allocate(name_, description_, default_value_); }
    private native void allocate(@StdString String name_, @StdString String description_, @ByVal AttributeProto default_value_);

    public native @StdString BytePointer name(); public native Attribute name(BytePointer setter);
    public native @StdString BytePointer description(); public native Attribute description(BytePointer setter);
    public native @Cast("onnx::AttributeProto::AttributeType") int type(); public native Attribute type(int setter);
    public native @Cast("bool") boolean required(); public native Attribute required(boolean setter);
    public native @ByRef AttributeProto default_value(); public native Attribute default_value(AttributeProto setter);
  }

  public native @ByRef OpSchema Attr(@ByVal Attribute attr);

// Register "optional" attribute with default value.
// #define ATTR_SETTER_WITH_DEFAULT_VALUE(TypeName)
//   OpSchema& Attr(
//       std::string name, std::string description, AttributeProto::AttributeType type, const TypeName& defaultValue);
//   /* non-STL wrapper to reduce binary size */
//   OpSchema& Attr(
//       const char* name, const char* description, AttributeProto::AttributeType type, const TypeName& defaultValue);
//   OpSchema& Attr(
//       std::string name,
//       std::string description,
//       AttributeProto::AttributeType type,
//       const std::vector<TypeName>& defaultValue);

  public native @ByRef OpSchema Attr(
        @StdString BytePointer name, @StdString BytePointer description, @Cast("onnx::AttributeProto::AttributeType") int type, @Cast("const int64_t") long defaultValue);
  public native @ByRef OpSchema Attr(
        @StdString String name, @StdString String description, @Cast("onnx::AttributeProto::AttributeType") int type, @Cast("const int64_t") long defaultValue);
  /* non-STL wrapper to reduce binary size */
  public native @ByRef OpSchema Attr(
        @StdString BytePointer name,
        @StdString BytePointer description,
        @Cast("onnx::AttributeProto::AttributeType") int type,
        @Const @ByRef LongVector defaultValue);
  public native @ByRef OpSchema Attr(
        @StdString String name,
        @StdString String description,
        @Cast("onnx::AttributeProto::AttributeType") int type,
        @Const @ByRef LongVector defaultValue);
  public native @ByRef OpSchema Attr(
        @StdString BytePointer name, @StdString BytePointer description, @Cast("onnx::AttributeProto::AttributeType") int type, float defaultValue);
  public native @ByRef OpSchema Attr(
        @StdString String name, @StdString String description, @Cast("onnx::AttributeProto::AttributeType") int type, float defaultValue);
  /* non-STL wrapper to reduce binary size */
  public native @ByRef OpSchema Attr(
        @StdString BytePointer name,
        @StdString BytePointer description,
        @Cast("onnx::AttributeProto::AttributeType") int type,
        @Const @ByRef FloatVector defaultValue);
  public native @ByRef OpSchema Attr(
        @StdString String name,
        @StdString String description,
        @Cast("onnx::AttributeProto::AttributeType") int type,
        @Const @ByRef FloatVector defaultValue);
  public native @ByRef OpSchema Attr(
        @StdString BytePointer name, @StdString BytePointer description, @Cast("onnx::AttributeProto::AttributeType") int type, @StdString BytePointer defaultValue);
  public native @ByRef OpSchema Attr(
        @StdString String name, @StdString String description, @Cast("onnx::AttributeProto::AttributeType") int type, @StdString String defaultValue);
  /* non-STL wrapper to reduce binary size */
  public native @ByRef OpSchema Attr(
        @StdString BytePointer name,
        @StdString BytePointer description,
        @Cast("onnx::AttributeProto::AttributeType") int type,
        @Const @ByRef StringVector defaultValue);
  public native @ByRef OpSchema Attr(
        @StdString String name,
        @StdString String description,
        @Cast("onnx::AttributeProto::AttributeType") int type,
        @Const @ByRef StringVector defaultValue);
  public native @ByRef OpSchema Attr(
        @StdString BytePointer name, @StdString BytePointer description, @Cast("onnx::AttributeProto::AttributeType") int type, @Const @ByRef TensorProto defaultValue);
  public native @ByRef OpSchema Attr(
        @StdString String name, @StdString String description, @Cast("onnx::AttributeProto::AttributeType") int type, @Const @ByRef TensorProto defaultValue);
  /* non-STL wrapper to reduce binary size */
  public native @ByRef OpSchema Attr(
        @StdString BytePointer name, @StdString BytePointer description, @Cast("onnx::AttributeProto::AttributeType") int type, @Const @ByRef GraphProto defaultValue);
  public native @ByRef OpSchema Attr(
        @StdString String name, @StdString String description, @Cast("onnx::AttributeProto::AttributeType") int type, @Const @ByRef GraphProto defaultValue);
  /* non-STL wrapper to reduce binary size */
  public native @ByRef OpSchema Attr(
        @StdString BytePointer name, @StdString BytePointer description, @Cast("onnx::AttributeProto::AttributeType") int type, @Const @ByRef TypeProto defaultValue);
  public native @ByRef OpSchema Attr(
        @StdString String name, @StdString String description, @Cast("onnx::AttributeProto::AttributeType") int type, @Const @ByRef TypeProto defaultValue);
  /* non-STL wrapper to reduce binary size */

  // Register "required" attribute without default value.
  public native @ByRef OpSchema Attr(@StdString BytePointer name, @StdString BytePointer description, @Cast("onnx::AttributeProto::AttributeType") int type, @Cast("bool") boolean required/*=true*/);
  public native @ByRef OpSchema Attr(@StdString BytePointer name, @StdString BytePointer description, @Cast("onnx::AttributeProto::AttributeType") int type);
  public native @ByRef OpSchema Attr(@StdString String name, @StdString String description, @Cast("onnx::AttributeProto::AttributeType") int type, @Cast("bool") boolean required/*=true*/);
  public native @ByRef OpSchema Attr(@StdString String name, @StdString String description, @Cast("onnx::AttributeProto::AttributeType") int type);

  // Non-STL wrapper to reduce binary size

  public native @ByRef OpSchema AllowUncheckedAttributes();

  // Type constraint.
  @NoOffset public static class TypeConstraintParam extends Pointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public TypeConstraintParam(Pointer p) { super(p); }
  
    public TypeConstraintParam(
            @StdString BytePointer type_param_str_,
            @ByVal StringVector allowed_type_strs_,
            @StdString BytePointer description_) { super((Pointer)null); allocate(type_param_str_, allowed_type_strs_, description_); }
    private native void allocate(
            @StdString BytePointer type_param_str_,
            @ByVal StringVector allowed_type_strs_,
            @StdString BytePointer description_);
    public TypeConstraintParam(
            @StdString String type_param_str_,
            @ByVal StringVector allowed_type_strs_,
            @StdString String description_) { super((Pointer)null); allocate(type_param_str_, allowed_type_strs_, description_); }
    private native void allocate(
            @StdString String type_param_str_,
            @ByVal StringVector allowed_type_strs_,
            @StdString String description_);

    // Type parameter string, for example, "T", "T1", etc.
    public native @StdString BytePointer type_param_str(); public native TypeConstraintParam type_param_str(BytePointer setter);
    // Allowed type strings for <*this> type parameter, for example,
    // "tensor(float)".
    public native @ByRef StringVector allowed_type_strs(); public native TypeConstraintParam allowed_type_strs(StringVector setter);
    // Type parameter description.
    public native @StdString BytePointer description(); public native TypeConstraintParam description(BytePointer setter);
  }

  // Grammar for type strings used in Input(), Output().
  // <type> ::= <data_type> |
  //            tensor(<data_type>) |
  //            seq(<type>) |
  //            map(<data_type>, <type>) |
  //            <type_parameter>
  // <data_type> :: = float | int32 | string | bool | uint8
  //                | int8 | uint16 | int16 | int64 | float16 | double
  // <type_parameter> ::= any type parameter string, say "T".
  //
  // NOTE: 1) <type_parameter> will always be together with a type constraints
  // specification.
  //       2) <type> ::= <data_type> means the data is scalar (zero dimension).
  //
  // Example:
  // ONNX_OPERATOR_SET_SCHEMA(Sum, 1, OpSchema()
  // .Input(0, "input_a", "the first input", "T")
  // .Input(1, "input_b", "the second input", "T")
  // .Output(0, "sum", "the sum of two numbers", "T")
  // .TypeConstraint("T", {"float", "double", "int32"}, "allowed data types for
  // sum."))
  //
  // Optional = true means that the input might have empty input value
  // (represented as "") in the graph even though the later inputs have values.
  // It's useful for complex situation when there are several independent
  // optional inputs.
  public native @ByRef OpSchema Input(int n, @ByVal FormalParameter formal_parameter);

  public native @ByRef OpSchema Input(
        int n,
        @StdString BytePointer name,
        @StdString BytePointer description,
        @StdString BytePointer type_str,
        @Cast("onnx::OpSchema::FormalParameterOption") byte param_option/*=onnx::OpSchema::Single*/,
        @Cast("bool") boolean is_homogeneous/*=true*/,
        int min_arity/*=1*/,
        @Cast("onnx::OpSchema::DifferentiationCategory") byte differentiation_category/*=onnx::OpSchema::Unknown*/);
  public native @ByRef OpSchema Input(
        int n,
        @StdString BytePointer name,
        @StdString BytePointer description,
        @StdString BytePointer type_str);
  public native @ByRef OpSchema Input(
        int n,
        @StdString String name,
        @StdString String description,
        @StdString String type_str,
        @Cast("onnx::OpSchema::FormalParameterOption") byte param_option/*=onnx::OpSchema::Single*/,
        @Cast("bool") boolean is_homogeneous/*=true*/,
        int min_arity/*=1*/,
        @Cast("onnx::OpSchema::DifferentiationCategory") byte differentiation_category/*=onnx::OpSchema::Unknown*/);
  public native @ByRef OpSchema Input(
        int n,
        @StdString String name,
        @StdString String description,
        @StdString String type_str);

  // Non-STL wrapper to reduce binary size

  public native @ByRef OpSchema Output(int n, @ByVal FormalParameter formal_parameter);

  public native @ByRef OpSchema Output(
        int n,
        @StdString BytePointer name,
        @StdString BytePointer description,
        @StdString BytePointer type_str,
        @Cast("onnx::OpSchema::FormalParameterOption") byte param_option/*=onnx::OpSchema::Single*/,
        @Cast("bool") boolean is_homogeneous/*=true*/,
        int min_arity/*=1*/,
        @Cast("onnx::OpSchema::DifferentiationCategory") byte differentiation_category/*=onnx::OpSchema::Unknown*/);
  public native @ByRef OpSchema Output(
        int n,
        @StdString BytePointer name,
        @StdString BytePointer description,
        @StdString BytePointer type_str);
  public native @ByRef OpSchema Output(
        int n,
        @StdString String name,
        @StdString String description,
        @StdString String type_str,
        @Cast("onnx::OpSchema::FormalParameterOption") byte param_option/*=onnx::OpSchema::Single*/,
        @Cast("bool") boolean is_homogeneous/*=true*/,
        int min_arity/*=1*/,
        @Cast("onnx::OpSchema::DifferentiationCategory") byte differentiation_category/*=onnx::OpSchema::Unknown*/);
  public native @ByRef OpSchema Output(
        int n,
        @StdString String name,
        @StdString String description,
        @StdString String type_str);

  // Non-STL wrapper to reduce binary size

  public native @ByRef OpSchema TypeConstraint(@StdString BytePointer type_str, @ByVal StringVector constraints, @StdString BytePointer description);
  public native @ByRef OpSchema TypeConstraint(@StdString String type_str, @ByVal StringVector constraints, @StdString String description);

  // Non-STL wrapper to reduce binary size

  // Convenience members for types

  // All high-precision numeric types.
  public static native @Const @ByRef StringVector numeric_types_for_math_reduction_ir9();

  public static native @Const @ByRef StringVector numeric_types_for_math_reduction_ir4();

  // Deprecated function, use numeric_types_for_math_reduction_ir4 instead. It will be removed in onnx==1.15.0.
  public static native @Const @ByRef StringVector numeric_types_for_math_reduction_with_bfloat();

  public static native @Const @ByRef StringVector numeric_types_for_math_reduction();

  public static native @Const @ByRef StringVector all_numeric_types_ir9();

  public static native @Const @ByRef StringVector all_numeric_types_ir4();

  // Deprecated function, use all_numeric_types_ir4 instead. It will be removed in onnx==1.15.0.
  public static native @Const @ByRef StringVector all_numeric_types_with_bfloat();

  public static native @Const @ByRef StringVector all_numeric_types();

  public static native @Const @ByRef StringVector all_numeric_sequence_types();

  public static native @Const @ByRef StringVector all_tensor_types();

  public static native @Const @ByRef StringVector all_tensor_types_ir4();

  // Deprecated function, use all_tensor_types_ir4 instead. It will be removed in onnx==1.15.0.
  public static native @Const @ByRef StringVector all_tensor_types_with_bfloat();

  public static native @Const @ByRef StringVector all_tensor_types_ir9();

  public static native @Const @ByRef StringVector all_tensor_sequence_types();

  public static native @Const @ByRef StringVector all_tensor_sequence_types_ir4();

  // Deprecated function, use all_tensor_sequence_types_ir4 instead. It will be removed in onnx==1.15.0.
  public static native @Const @ByRef StringVector all_tensor_sequence_types_with_bfloat();

  public static native @Const @ByRef StringVector all_tensor_sequence_types_ir9();

  public static native @Const @ByRef StringVector all_optional_types();

  public static native @Const @ByRef StringVector all_optional_types_ir4();

  // Deprecated function, use all_optional_types_ir4 instead. It will be removed in onnx==1.15.0.
  public static native @Const @ByRef StringVector all_optional_types_with_bfloat();
  public static native @Const @ByRef StringVector all_optional_types_ir9();

  // Calls the passed function with `this` as an argument. Useful for
  // adding docs for temlated/macro ops.
  public native @ByRef OpSchema FillUsing(@Const @ByRef VoidOpSchemaFn populator);

  

  public native @StdString BytePointer domain();

  public native @Const @ByRef StringAttributeMap attributes();

  // Get input formal parameters.
  public native @Const @ByRef FormalParameterVector inputs();

  // Get output formal parameters.
  public native @Const @ByRef FormalParameterVector outputs();

  public native @Const @ByRef TypeConstraintParamVector typeConstraintParams();

  public native @Cast("const onnx::TypeConstraintMap*") @ByRef SizeTStringMap typeConstraintMap();

  public native @StdString BytePointer Name();

  public native @Cast("onnx::OperatorSetVersion") @Function int SinceVersion();

  public native int since_version();

  public native @Cast("bool") boolean deprecated();

  public native int min_input();
  public native int max_input();
  public native int min_output();
  public native int max_output();

  public native @Cast("bool") boolean has_type_and_shape_inference_function();

  public native @Cast("bool") boolean has_data_propagation_function();

  public native @StdVector IntPointer function_opset_versions();

  public native @Cast("bool") boolean HasFunction();

  public native @ByRef OpSchema FunctionBody(@StdVector NodeProto func_nodes, int opset_version/*=onnx::OpSchema::kUninitializedSinceVersion*/);
  public native @ByRef OpSchema FunctionBody(@StdVector NodeProto func_nodes);

  public native @ByRef OpSchema FunctionBody(
        @StdVector NodeProto func_nodes,
        @StdVector OperatorSetIdProto opsets,
        int opset_version/*=onnx::OpSchema::kUninitializedSinceVersion*/);
  public native @ByRef OpSchema FunctionBody(
        @StdVector NodeProto func_nodes,
        @StdVector OperatorSetIdProto opsets);

  public native @ByRef OpSchema FunctionBody(@Cast("const char*") BytePointer func_body, int opset_version/*=onnx::OpSchema::kUninitializedSinceVersion*/);
  public native @ByRef OpSchema FunctionBody(@Cast("const char*") BytePointer func_body);
  public native @ByRef OpSchema FunctionBody(String func_body, int opset_version/*=onnx::OpSchema::kUninitializedSinceVersion*/);
  public native @ByRef OpSchema FunctionBody(String func_body);

  // since_version_ of an OpSchema tells the last opset version when an op is defined.
  // When the op's definition is changed, a new OpSchema (of the same op_type) is created
  // with a newer since_version_, reflecting the opset version at the time of change.
  // For a function op, operators used to define its function body may change
  // while there is no change to the function op definition itself.
  // When this happens, mutiple function bodies are provided, each for a specific opset version.
  //
  // Take LogSoftmax for example. Its latest opset version is 13.
  // In LogSoftmax's function body, ReduceMax (with since_version_ 1, 11, 12, 18) is used.
  // When a model containing LogSoftmax with opset_import version within 13 to 17 is loaded, function body
  // with opset_version 13 is used for inlining.
  // When the same model but opset_import version 18 is loaded, function body
  // with opset_version 18 is used for inlining.
  // Clearly function body for opset_import version 13 will not work
  // in a model with opset_import version 18 because the function body make worng use of ReduceMax(18).
  // Inside GetFunction we ensure that ops being used to construct a function body do not endure such
  // issue.
  public native @Const FunctionProto GetFunction(
        int requested_opset_version/*=onnx::OpSchema::kUninitializedSinceVersion*/,
        @Cast("bool") boolean validate/*=false*/);
  public native @Const FunctionProto GetFunction();

  public native @StdVector IntPointer context_dependent_function_opset_versions();

  public native @Cast("bool") boolean HasContextDependentFunction();

  public native @Cast("bool") boolean HasContextDependentFunctionWithOpsetVersion(int opset_version);

  

  public native @Cast("bool") boolean BuildContextDependentFunction(
        @Const @ByRef FunctionBodyBuildContext ctx,
        @ByRef FunctionProto function_proto,
        int requested_opset_version/*=onnx::OpSchema::kUninitializedSinceVersion*/);
  public native @Cast("bool") boolean BuildContextDependentFunction(
        @Const @ByRef FunctionBodyBuildContext ctx,
        @ByRef FunctionProto function_proto);

  // Verifies that the schema is valid and all specifications are compatible.
  // It will also parse all type strings specified for inputs/outputs into valid
  // TypeProto and create global unique string pointer as the DataType for
  // efficiency.
  public native void Finalize();

  // Build function with information stored in opschema
  public native void BuildFunction(@ByRef FunctionProto function_body);
}
