// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.onnx;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.onnx.global.onnx.*;


// A pass that is based on pattern matching. The majority of passes will
// implement this pass. In order for the pass to work the patternMatchPredicate
// function must be implemented witch matches a subgraph to the respective
// optimization pass. Lastly the runTransform method must also be implemented
// which simply implements the pass on any node which passes
// patternMatchPredicate.
@Namespace("onnx::optimization") @Properties(inherit = org.bytedeco.onnx.presets.onnx.class)
public class PredicateBasedPass extends Pass {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public PredicateBasedPass(Pointer p) { super(p); }


  public native @Cast("bool") boolean patternMatchPredicate(Node node);
  // Run transform is given the current node in the iterator, a reference to the
  // current graph as well as a reference describing how to treat the current
  // node in the iterator post transform. Run transform is then responsible for
  // running the actual transform as well as describing how to treat the
  // iterator node. By default the current node will not call destroy. Do not
  // internally delete node instead set the correct destroy_current type.
  public native @Cast("bool") boolean runTransform(Node node, @ByRef Graph graph, @Cast("onnx::optimization::NodeDestroyType*") @ByRef IntPointer destroy_current);
  public native @Cast("bool") boolean runTransform(Node node, @ByRef Graph graph, @Cast("onnx::optimization::NodeDestroyType*") @ByRef IntBuffer destroy_current);
  public native @Cast("bool") boolean runTransform(Node node, @ByRef Graph graph, @Cast("onnx::optimization::NodeDestroyType*") @ByRef int[] destroy_current);

  public native @SharedPtr PostPassAnalysis runPass(@ByRef Graph graph);
  public native @Cast("onnx::optimization::PassAnalysisType") int getPassAnalysisType();
}
