// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.opencl.global;

import org.bytedeco.opencl.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class OpenCL extends org.bytedeco.opencl.presets.OpenCL {
    static { Loader.load(); }

// Parsed from CL/opencl.h

/*******************************************************************************
 * Copyright (c) 2008-2021 The Khronos Group Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

// #ifndef __OPENCL_H
// #define __OPENCL_H

// #ifdef __cplusplus
// #endif

// #include <CL/cl.h>
// #include <CL/cl_gl.h>
// #include <CL/cl_ext.h>

// #ifdef __cplusplus
// #endif

// #endif  /* __OPENCL_H   */


// Parsed from CL/cl_version.h

/*******************************************************************************
 * Copyright (c) 2018-2020 The Khronos Group Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

// #ifndef __CL_VERSION_H
// #define __CL_VERSION_H

/* Detect which version to target */
// #if !defined(CL_TARGET_OPENCL_VERSION)
// #pragma message("cl_version.h: CL_TARGET_OPENCL_VERSION is not defined. Defaulting to 300 (OpenCL 3.0)")
public static final int CL_TARGET_OPENCL_VERSION = 300;
// #endif
// #if CL_TARGET_OPENCL_VERSION != 100 &&
//     CL_TARGET_OPENCL_VERSION != 110 &&
//     CL_TARGET_OPENCL_VERSION != 120 &&
//     CL_TARGET_OPENCL_VERSION != 200 &&
//     CL_TARGET_OPENCL_VERSION != 210 &&
//     CL_TARGET_OPENCL_VERSION != 220 &&
//     CL_TARGET_OPENCL_VERSION != 300
// #pragma message("cl_version: CL_TARGET_OPENCL_VERSION is not a valid value (100, 110, 120, 200, 210, 220, 300). Defaulting to 300 (OpenCL 3.0)")
// #undef CL_TARGET_OPENCL_VERSION
// #endif


/* OpenCL Version */
// #if CL_TARGET_OPENCL_VERSION >= 300 && !defined(CL_VERSION_3_0)
public static final int CL_VERSION_3_0 =  1;
// #endif
// #if CL_TARGET_OPENCL_VERSION >= 220 && !defined(CL_VERSION_2_2)
public static final int CL_VERSION_2_2 =  1;
// #endif
// #if CL_TARGET_OPENCL_VERSION >= 210 && !defined(CL_VERSION_2_1)
public static final int CL_VERSION_2_1 =  1;
// #endif
// #if CL_TARGET_OPENCL_VERSION >= 200 && !defined(CL_VERSION_2_0)
public static final int CL_VERSION_2_0 =  1;
// #endif
// #if CL_TARGET_OPENCL_VERSION >= 120 && !defined(CL_VERSION_1_2)
public static final int CL_VERSION_1_2 =  1;
// #endif
// #if CL_TARGET_OPENCL_VERSION >= 110 && !defined(CL_VERSION_1_1)
public static final int CL_VERSION_1_1 =  1;
// #endif
// #if CL_TARGET_OPENCL_VERSION >= 100 && !defined(CL_VERSION_1_0)
public static final int CL_VERSION_1_0 =  1;
// #endif

/* Allow deprecated APIs for older OpenCL versions. */
// #if CL_TARGET_OPENCL_VERSION <= 220 && !defined(CL_USE_DEPRECATED_OPENCL_2_2_APIS)
// #define CL_USE_DEPRECATED_OPENCL_2_2_APIS
// #endif
// #if CL_TARGET_OPENCL_VERSION <= 210 && !defined(CL_USE_DEPRECATED_OPENCL_2_1_APIS)
// #define CL_USE_DEPRECATED_OPENCL_2_1_APIS
// #endif
// #if CL_TARGET_OPENCL_VERSION <= 200 && !defined(CL_USE_DEPRECATED_OPENCL_2_0_APIS)
// #define CL_USE_DEPRECATED_OPENCL_2_0_APIS
// #endif
// #if CL_TARGET_OPENCL_VERSION <= 120 && !defined(CL_USE_DEPRECATED_OPENCL_1_2_APIS)
// #define CL_USE_DEPRECATED_OPENCL_1_2_APIS
// #endif
// #if CL_TARGET_OPENCL_VERSION <= 110 && !defined(CL_USE_DEPRECATED_OPENCL_1_1_APIS)
// #define CL_USE_DEPRECATED_OPENCL_1_1_APIS
// #endif
// #if CL_TARGET_OPENCL_VERSION <= 100 && !defined(CL_USE_DEPRECATED_OPENCL_1_0_APIS)
// #define CL_USE_DEPRECATED_OPENCL_1_0_APIS
// #endif

// #endif  /* __CL_VERSION_H */


// Parsed from CL/cl_platform.h

/*******************************************************************************
 * Copyright (c) 2008-2020 The Khronos Group Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

// #ifndef __CL_PLATFORM_H
// #define __CL_PLATFORM_H

// #include <CL/cl_version.h>

// #ifdef __cplusplus
// #endif

// #if defined(_WIN32)
//     #if !defined(CL_API_ENTRY)
//         #define CL_API_ENTRY
//     #endif
//     #if !defined(CL_API_CALL)
//         #define CL_API_CALL     __stdcall
//     #endif
//     #if !defined(CL_CALLBACK)
//         #define CL_CALLBACK     __stdcall
//     #endif
// #else
//     #if !defined(CL_API_ENTRY)
//         #define CL_API_ENTRY
//     #endif
//     #if !defined(CL_API_CALL)
//         #define CL_API_CALL
//     #endif
//     #if !defined(CL_CALLBACK)
//         #define CL_CALLBACK
//     #endif
// #endif

/*
 * Deprecation flags refer to the last version of the header in which the
 * feature was not deprecated.
 *
 * E.g. VERSION_1_1_DEPRECATED means the feature is present in 1.1 without
 * deprecation but is deprecated in versions later than 1.1.
 */

// #ifndef CL_API_SUFFIX_USER
// #define CL_API_SUFFIX_USER
// #endif

// #ifndef CL_API_PREFIX_USER
// #define CL_API_PREFIX_USER
// #endif

// #define CL_API_SUFFIX_COMMON CL_API_SUFFIX_USER
// #define CL_API_PREFIX_COMMON CL_API_PREFIX_USER

// #define CL_API_SUFFIX__VERSION_1_0 CL_API_SUFFIX_COMMON
// #define CL_API_SUFFIX__VERSION_1_1 CL_API_SUFFIX_COMMON
// #define CL_API_SUFFIX__VERSION_1_2 CL_API_SUFFIX_COMMON
// #define CL_API_SUFFIX__VERSION_2_0 CL_API_SUFFIX_COMMON
// #define CL_API_SUFFIX__VERSION_2_1 CL_API_SUFFIX_COMMON
// #define CL_API_SUFFIX__VERSION_2_2 CL_API_SUFFIX_COMMON
// #define CL_API_SUFFIX__VERSION_3_0 CL_API_SUFFIX_COMMON
// #define CL_API_SUFFIX__EXPERIMENTAL CL_API_SUFFIX_COMMON


// #ifdef __GNUC__
//   #define CL_API_SUFFIX_DEPRECATED __attribute__((deprecated))
//   #define CL_API_PREFIX_DEPRECATED
// #elif defined(_WIN32)
//   #define CL_API_SUFFIX_DEPRECATED
//   #define CL_API_PREFIX_DEPRECATED __declspec(deprecated)
// #else
//   #define CL_API_SUFFIX_DEPRECATED
//   #define CL_API_PREFIX_DEPRECATED
// #endif

// #ifdef CL_USE_DEPRECATED_OPENCL_1_0_APIS
// #else
//     #define CL_API_SUFFIX__VERSION_1_0_DEPRECATED CL_API_SUFFIX_COMMON CL_API_SUFFIX_DEPRECATED
//     #define CL_API_PREFIX__VERSION_1_0_DEPRECATED CL_API_PREFIX_COMMON CL_API_PREFIX_DEPRECATED
// #endif

// #ifdef CL_USE_DEPRECATED_OPENCL_1_1_APIS
// #else
//     #define CL_API_SUFFIX__VERSION_1_1_DEPRECATED CL_API_SUFFIX_COMMON CL_API_SUFFIX_DEPRECATED
//     #define CL_API_PREFIX__VERSION_1_1_DEPRECATED CL_API_PREFIX_COMMON CL_API_PREFIX_DEPRECATED
// #endif

// #ifdef CL_USE_DEPRECATED_OPENCL_1_2_APIS
// #else
//     #define CL_API_SUFFIX__VERSION_1_2_DEPRECATED CL_API_SUFFIX_COMMON CL_API_SUFFIX_DEPRECATED
//     #define CL_API_PREFIX__VERSION_1_2_DEPRECATED CL_API_PREFIX_COMMON CL_API_PREFIX_DEPRECATED
//  #endif

// #ifdef CL_USE_DEPRECATED_OPENCL_2_0_APIS
// #else
//     #define CL_API_SUFFIX__VERSION_2_0_DEPRECATED CL_API_SUFFIX_COMMON CL_API_SUFFIX_DEPRECATED
//     #define CL_API_PREFIX__VERSION_2_0_DEPRECATED CL_API_PREFIX_COMMON CL_API_PREFIX_DEPRECATED
// #endif

// #ifdef CL_USE_DEPRECATED_OPENCL_2_1_APIS
// #else
//     #define CL_API_SUFFIX__VERSION_2_1_DEPRECATED CL_API_SUFFIX_COMMON CL_API_SUFFIX_DEPRECATED
//     #define CL_API_PREFIX__VERSION_2_1_DEPRECATED CL_API_PREFIX_COMMON CL_API_PREFIX_DEPRECATED
// #endif

// #ifdef CL_USE_DEPRECATED_OPENCL_2_2_APIS
// #else
//     #define CL_API_SUFFIX__VERSION_2_2_DEPRECATED CL_API_SUFFIX_COMMON CL_API_SUFFIX_DEPRECATED
//     #define CL_API_PREFIX__VERSION_2_2_DEPRECATED CL_API_PREFIX_COMMON CL_API_PREFIX_DEPRECATED
// #endif

// #if (defined (_WIN32) && defined(_MSC_VER))

// #if defined(__clang__)
// #pragma clang diagnostic push
// #pragma clang diagnostic ignored "-Wlanguage-extension-token"
// #endif

/* intptr_t is used in cl.h and provided by stddef.h in Visual C++, but not in clang */
/* stdint.h was missing before Visual Studio 2010, include it for later versions and for clang */
// #if defined(__clang__) || _MSC_VER >= 1600
//     #include <stdint.h>
// #endif

/* scalar types  */

// #if defined(__clang__)
// #pragma clang diagnostic pop
// #endif

/* Macro names and corresponding values defined by OpenCL */
public static final int CL_CHAR_BIT =         8;
public static final int CL_SCHAR_MAX =        127;
public static final int CL_SCHAR_MIN =        (-127-1);
public static final int CL_CHAR_MAX =         CL_SCHAR_MAX;
public static final int CL_CHAR_MIN =         CL_SCHAR_MIN;
public static final int CL_UCHAR_MAX =        255;
public static final int CL_SHRT_MAX =         32767;
public static final int CL_SHRT_MIN =         (-32767-1);
public static final int CL_USHRT_MAX =        65535;
public static final int CL_INT_MAX =          2147483647;
public static final int CL_INT_MIN =          (-2147483647-1);
public static final int CL_UINT_MAX =         0xffffffff;
public static final long CL_LONG_MAX =         ((long) 0x7FFFFFFFFFFFFFFFL);
public static final long CL_LONG_MIN =         ((long) -0x7FFFFFFFFFFFFFFFL - 1L);
public static final long CL_ULONG_MAX =        ((long) 0xFFFFFFFFFFFFFFFFL);

public static final int CL_FLT_DIG =          6;
public static final int CL_FLT_MANT_DIG =     24;
public static final int CL_FLT_MAX_10_EXP =   +38;
public static final int CL_FLT_MAX_EXP =      +128;
public static final int CL_FLT_MIN_10_EXP =   -37;
public static final int CL_FLT_MIN_EXP =      -125;
public static final int CL_FLT_RADIX =        2;
public static final double CL_FLT_MAX =          340282346638528859811704183484516925440.0f;
public static final double CL_FLT_MIN =          1.175494350822287507969e-38f;
public static final double CL_FLT_EPSILON =      1.1920928955078125e-7f;

public static final int CL_HALF_DIG =          3;
public static final int CL_HALF_MANT_DIG =     11;
public static final int CL_HALF_MAX_10_EXP =   +4;
public static final int CL_HALF_MAX_EXP =      +16;
public static final int CL_HALF_MIN_10_EXP =   -4;
public static final int CL_HALF_MIN_EXP =      -13;
public static final int CL_HALF_RADIX =        2;
public static final double CL_HALF_MAX =          65504.0f;
public static final double CL_HALF_MIN =          6.103515625e-05f;
public static final double CL_HALF_EPSILON =      9.765625e-04f;

public static final int CL_DBL_DIG =          15;
public static final int CL_DBL_MANT_DIG =     53;
public static final int CL_DBL_MAX_10_EXP =   +308;
public static final int CL_DBL_MAX_EXP =      +1024;
public static final int CL_DBL_MIN_10_EXP =   -307;
public static final int CL_DBL_MIN_EXP =      -1021;
public static final int CL_DBL_RADIX =        2;
public static final double CL_DBL_MAX =          1.7976931348623158e+308;
public static final double CL_DBL_MIN =          2.225073858507201383090e-308;
public static final double CL_DBL_EPSILON =      2.220446049250313080847e-16;

public static final double CL_M_E =              2.7182818284590452354;
public static final double CL_M_LOG2E =          1.4426950408889634074;
public static final double CL_M_LOG10E =         0.43429448190325182765;
public static final double CL_M_LN2 =            0.69314718055994530942;
public static final double CL_M_LN10 =           2.30258509299404568402;
public static final double CL_M_PI =             3.14159265358979323846;
public static final double CL_M_PI_2 =           1.57079632679489661923;
public static final double CL_M_PI_4 =           0.78539816339744830962;
public static final double CL_M_1_PI =           0.31830988618379067154;
public static final double CL_M_2_PI =           0.63661977236758134308;
public static final double CL_M_2_SQRTPI =       1.12837916709551257390;
public static final double CL_M_SQRT2 =          1.41421356237309504880;
public static final double CL_M_SQRT1_2 =        0.70710678118654752440;

public static final double CL_M_E_F =            2.718281828f;
public static final double CL_M_LOG2E_F =        1.442695041f;
public static final double CL_M_LOG10E_F =       0.434294482f;
public static final double CL_M_LN2_F =          0.693147181f;
public static final double CL_M_LN10_F =         2.302585093f;
public static final double CL_M_PI_F =           3.141592654f;
public static final double CL_M_PI_2_F =         1.570796327f;
public static final double CL_M_PI_4_F =         0.785398163f;
public static final double CL_M_1_PI_F =         0.318309886f;
public static final double CL_M_2_PI_F =         0.636619772f;
public static final double CL_M_2_SQRTPI_F =     1.128379167f;
public static final double CL_M_SQRT2_F =        1.414213562f;
public static final double CL_M_SQRT1_2_F =      0.707106781f;

public static native @MemberGetter int CL_NAN();
public static final int CL_NAN = CL_NAN();
public static final double CL_HUGE_VALF =        ((float) 1e50);
// #define CL_HUGE_VAL         ((cl_double) 1e500)
public static final double CL_MAXFLOAT =         CL_FLT_MAX;
public static final double CL_INFINITY =         CL_HUGE_VALF;

// #else

// #include <stdint.h>

/* scalar types  */

/* Macro names and corresponding values defined by OpenCL */

// #if defined( __GNUC__ )
//    #define CL_HUGE_VAL      __builtin_huge_val()
// #else
//    #define CL_HUGE_VAL      ((cl_double) 1e500)
   
// #endif

// #endif

// #include <stddef.h>

/* Mirror types to GL types. Mirror types allow us to avoid deciding which 87s to load based on whether we are using GL or GLES here. */

/*
 * Vector types
 *
 *  Note:   OpenCL requires that all types be naturally aligned.
 *          This means that vector types must be naturally aligned.
 *          For example, a vector of four floats must be aligned to
 *          a 16 byte boundary (calculated as 4 * the natural 4-byte
 *          alignment of the float).  The alignment qualifiers here
 *          will only function properly if your compiler supports them
 *          and if you don't actively work to defeat them.  For example,
 *          in order for a cl_float4 to be 16 byte aligned in a struct,
 *          the start of the struct must itself be 16-byte aligned.
 *
 *          Maintaining proper alignment is the user's responsibility.
 */

/* Define basic vector types */
// #if defined( __VEC__ )
//   #if !defined(__clang__)
//      #include <altivec.h>   /* may be omitted depending on compiler. AltiVec spec provides no way to detect whether the header is required. */
//   #endif
   public static final int __CL_UCHAR16__ =  1;
   public static final int __CL_CHAR16__ =   1;
   public static final int __CL_USHORT8__ =  1;
   public static final int __CL_SHORT8__ =   1;
   public static final int __CL_UINT4__ =    1;
   public static final int __CL_INT4__ =     1;
   public static final int __CL_FLOAT4__ =   1;
// #endif

// #if defined( __SSE__ )
//     #if defined( __MINGW64__ )
//         #include <intrin.h>
//     #else
//         #include <xmmintrin.h>
//     #endif
//     #if defined( __GNUC__ )
//     #else
//     #endif
// #endif

// #if defined( __SSE2__ )
//     #if defined( __MINGW64__ )
//         #include <intrin.h>
//     #else
//         #include <emmintrin.h>
//     #endif
//     #if defined( __GNUC__ )
//     #else
//     #endif
    public static final int __CL_ULONG2__ =   1;
    public static final int __CL_LONG2__ =    1;
    public static final int __CL_DOUBLE2__ =  1;
// #endif

// #if defined( __MMX__ )
//     #include <mmintrin.h>
//     #if defined( __GNUC__ )
//     #else
//     #endif
    public static final int __CL_UCHAR8__ =   1;
    public static final int __CL_CHAR8__ =    1;
    public static final int __CL_USHORT4__ =  1;
    public static final int __CL_SHORT4__ =   1;
    public static final int __CL_INT2__ =     1;
    public static final int __CL_UINT2__ =    1;
    public static final int __CL_ULONG1__ =   1;
    public static final int __CL_LONG1__ =    1;
    public static final int __CL_FLOAT2__ =   1;
// #endif

// #if defined( __AVX__ )
//     #if defined( __MINGW64__ )
//         #include <intrin.h>
//     #else
//         #include <immintrin.h>
//     #endif
//     #if defined( __GNUC__ )
//     #else
//     #endif
    public static final int __CL_FLOAT8__ =   1;
    public static final int __CL_DOUBLE4__ =  1;
// #endif

/* Define capabilities for anonymous struct members. */
// #if !defined(__cplusplus) && defined(__STDC_VERSION__) && __STDC_VERSION__ >= 201112L
public static native @MemberGetter int __CL_HAS_ANON_STRUCT__();
public static final int __CL_HAS_ANON_STRUCT__ = __CL_HAS_ANON_STRUCT__();
// #define  __CL_ANON_STRUCT__
// #elif defined(_WIN32) && defined(_MSC_VER) && !defined(__STDC__)
// #define  __CL_ANON_STRUCT__
// #elif defined(__GNUC__) && ! defined(__STRICT_ANSI__)
// #define  __CL_ANON_STRUCT__ __extension__
// #elif defined(__clang__)
// #define  __CL_ANON_STRUCT__ __extension__
// #else
// #define  __CL_ANON_STRUCT__
// #endif

// #if defined(_WIN32) && defined(_MSC_VER) && __CL_HAS_ANON_STRUCT__
   /* Disable warning C4201: nonstandard extension used : nameless struct/union */
//     #pragma warning( push )
//     #pragma warning( disable : 4201 )
// #endif

/* Define alignment keys */
// #if defined( __GNUC__ ) || defined(__INTEGRITY)
//     #define CL_ALIGNED(_x)          __attribute__ ((aligned(_x)))
// #elif defined( _WIN32) && (_MSC_VER)
    /* Alignment keys neutered on windows because MSVC can't swallow function arguments with alignment requirements     */
    /* http://msdn.microsoft.com/en-us/library/373ak2y1%28VS.71%29.aspx                                                 */
    /* #include <crtdefs.h>                                                                                             */
    /* #define CL_ALIGNED(_x)          _CRT_ALIGN(_x)                                                                   */
//     #define CL_ALIGNED(_x)
// #else
//    #warning  Need to implement some method to align data here
//    #define  CL_ALIGNED(_x)
// Targeting ..\cl_char2.java


// Targeting ..\cl_char4.java



/* cl_char3 is identical in size, alignment and behavior to cl_char4. See section 6.1.5. */
// Targeting ..\cl_char8.java


// Targeting ..\cl_char16.java


// Targeting ..\cl_uchar2.java


// Targeting ..\cl_uchar4.java



/* cl_uchar3 is identical in size, alignment and behavior to cl_uchar4. See section 6.1.5. */
// Targeting ..\cl_uchar8.java


// Targeting ..\cl_uchar16.java


// Targeting ..\cl_short2.java


// Targeting ..\cl_short4.java



/* cl_short3 is identical in size, alignment and behavior to cl_short4. See section 6.1.5. */
// Targeting ..\cl_short8.java


// Targeting ..\cl_short16.java


// Targeting ..\cl_ushort2.java


// Targeting ..\cl_ushort4.java



/* cl_ushort3 is identical in size, alignment and behavior to cl_ushort4. See section 6.1.5. */
// Targeting ..\cl_ushort8.java


// Targeting ..\cl_ushort16.java


// Targeting ..\cl_half2.java


// Targeting ..\cl_half4.java



/* cl_half3 is identical in size, alignment and behavior to cl_half4. See section 6.1.5. */
// Targeting ..\cl_half8.java


// Targeting ..\cl_half16.java


// Targeting ..\cl_int2.java


// Targeting ..\cl_int4.java



/* cl_int3 is identical in size, alignment and behavior to cl_int4. See section 6.1.5. */
// Targeting ..\cl_int8.java


// Targeting ..\cl_int16.java


// Targeting ..\cl_uint2.java


// Targeting ..\cl_uint4.java



/* cl_uint3 is identical in size, alignment and behavior to cl_uint4. See section 6.1.5. */
// Targeting ..\cl_uint8.java


// Targeting ..\cl_uint16.java


// Targeting ..\cl_long2.java


// Targeting ..\cl_long4.java



/* cl_long3 is identical in size, alignment and behavior to cl_long4. See section 6.1.5. */
// Targeting ..\cl_long8.java


// Targeting ..\cl_long16.java


// Targeting ..\cl_ulong2.java


// Targeting ..\cl_ulong4.java



/* cl_ulong3 is identical in size, alignment and behavior to cl_ulong4. See section 6.1.5. */
// Targeting ..\cl_ulong8.java


// Targeting ..\cl_ulong16.java


// Targeting ..\cl_float2.java


// Targeting ..\cl_float4.java



/* cl_float3 is identical in size, alignment and behavior to cl_float4. See section 6.1.5. */
// Targeting ..\cl_float8.java


// Targeting ..\cl_float16.java


// Targeting ..\cl_double2.java


// Targeting ..\cl_double4.java



/* cl_double3 is identical in size, alignment and behavior to cl_double4. See section 6.1.5. */
// Targeting ..\cl_double8.java


// Targeting ..\cl_double16.java



/* Macro to facilitate debugging
 * Usage:
 *   Place CL_PROGRAM_STRING_DEBUG_INFO on the line before the first line of your source.
 *   The first line ends with:   CL_PROGRAM_STRING_DEBUG_INFO \"
 *   Each line thereafter of OpenCL C source must end with: \n\
 *   The last line ends in ";
 *
 *   Example:
 *
 *   const char *my_program = CL_PROGRAM_STRING_DEBUG_INFO "\
 *   kernel void foo( int a, float * b )             \n\
 *   {                                               \n\
 *      // my comment                                \n\
 *      *b[ get_global_id(0)] = a;                   \n\
 *   }                                               \n\
 *   ";
 *
 * This should correctly set up the line, (column) and file information for your source
 * string so you can do source level debugging.
 */
// #define  __CL_STRINGIFY( _x )               # _x
// #define  _CL_STRINGIFY( _x )                __CL_STRINGIFY( _x )
// #define  CL_PROGRAM_STRING_DEBUG_INFO       "#line "  _CL_STRINGIFY(__LINE__) " \"" __FILE__ "\" \n\n"

// #ifdef __cplusplus
// #endif

// #if defined(_WIN32) && defined(_MSC_VER) && __CL_HAS_ANON_STRUCT__
//     #pragma warning( pop )
// #endif

// #endif  /* __CL_PLATFORM_H  */


// Parsed from CL/cl.h

/*******************************************************************************
 * Copyright (c) 2008-2020 The Khronos Group Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

// #ifndef __OPENCL_CL_H
// #define __OPENCL_CL_H

// #include <CL/cl_version.h>
// #include <CL/cl_platform.h>

// #ifdef __cplusplus
// Targeting ..\_cl_platform_id.java


// Targeting ..\_cl_device_id.java


// Targeting ..\_cl_context.java


// Targeting ..\_cl_command_queue.java


// Targeting ..\_cl_mem.java


// Targeting ..\_cl_program.java


// Targeting ..\_cl_kernel.java


// Targeting ..\_cl_event.java


// Targeting ..\_cl_sampler.java

                     /* WARNING!  Unlike cl_ types in cl_platform.h, cl_bool is not guaranteed to be the same size as the bool in kernels. */
// #ifdef CL_VERSION_2_0
// #endif
// #ifdef CL_VERSION_1_2
// #endif
// #ifdef CL_VERSION_2_0
// #endif
// #ifdef CL_VERSION_2_0
// #endif
// #ifdef CL_VERSION_1_2
// #endif
// #ifdef CL_VERSION_1_1
// #endif
// #ifdef CL_VERSION_2_0
// #endif
// #ifdef CL_VERSION_1_2
// #endif
// #ifdef CL_VERSION_1_2
// #endif
// #ifdef CL_VERSION_2_1
// #endif
// #ifdef CL_VERSION_2_0
// #endif
// #ifdef CL_VERSION_3_0
// Targeting ..\cl_image_format.java


// Targeting ..\cl_image_desc.java


// Targeting ..\cl_buffer_region.java



// #endif

// #ifdef CL_VERSION_3_0

public static final int CL_NAME_VERSION_MAX_NAME_SIZE = 64;
// Targeting ..\cl_name_version.java



// #endif

/******************************************************************************/

/* Error Codes */
public static final int CL_SUCCESS =                                  0;
public static final int CL_DEVICE_NOT_FOUND =                         -1;
public static final int CL_DEVICE_NOT_AVAILABLE =                     -2;
public static final int CL_COMPILER_NOT_AVAILABLE =                   -3;
public static final int CL_MEM_OBJECT_ALLOCATION_FAILURE =            -4;
public static final int CL_OUT_OF_RESOURCES =                         -5;
public static final int CL_OUT_OF_HOST_MEMORY =                       -6;
public static final int CL_PROFILING_INFO_NOT_AVAILABLE =             -7;
public static final int CL_MEM_COPY_OVERLAP =                         -8;
public static final int CL_IMAGE_FORMAT_MISMATCH =                    -9;
public static final int CL_IMAGE_FORMAT_NOT_SUPPORTED =               -10;
public static final int CL_BUILD_PROGRAM_FAILURE =                    -11;
public static final int CL_MAP_FAILURE =                              -12;
// #ifdef CL_VERSION_1_1
public static final int CL_MISALIGNED_SUB_BUFFER_OFFSET =             -13;
public static final int CL_EXEC_STATUS_ERROR_FOR_EVENTS_IN_WAIT_LIST = -14;
// #endif
// #ifdef CL_VERSION_1_2
public static final int CL_COMPILE_PROGRAM_FAILURE =                  -15;
public static final int CL_LINKER_NOT_AVAILABLE =                     -16;
public static final int CL_LINK_PROGRAM_FAILURE =                     -17;
public static final int CL_DEVICE_PARTITION_FAILED =                  -18;
public static final int CL_KERNEL_ARG_INFO_NOT_AVAILABLE =            -19;
// #endif

public static final int CL_INVALID_VALUE =                            -30;
public static final int CL_INVALID_DEVICE_TYPE =                      -31;
public static final int CL_INVALID_PLATFORM =                         -32;
public static final int CL_INVALID_DEVICE =                           -33;
public static final int CL_INVALID_CONTEXT =                          -34;
public static final int CL_INVALID_QUEUE_PROPERTIES =                 -35;
public static final int CL_INVALID_COMMAND_QUEUE =                    -36;
public static final int CL_INVALID_HOST_PTR =                         -37;
public static final int CL_INVALID_MEM_OBJECT =                       -38;
public static final int CL_INVALID_IMAGE_FORMAT_DESCRIPTOR =          -39;
public static final int CL_INVALID_IMAGE_SIZE =                       -40;
public static final int CL_INVALID_SAMPLER =                          -41;
public static final int CL_INVALID_BINARY =                           -42;
public static final int CL_INVALID_BUILD_OPTIONS =                    -43;
public static final int CL_INVALID_PROGRAM =                          -44;
public static final int CL_INVALID_PROGRAM_EXECUTABLE =               -45;
public static final int CL_INVALID_KERNEL_NAME =                      -46;
public static final int CL_INVALID_KERNEL_DEFINITION =                -47;
public static final int CL_INVALID_KERNEL =                           -48;
public static final int CL_INVALID_ARG_INDEX =                        -49;
public static final int CL_INVALID_ARG_VALUE =                        -50;
public static final int CL_INVALID_ARG_SIZE =                         -51;
public static final int CL_INVALID_KERNEL_ARGS =                      -52;
public static final int CL_INVALID_WORK_DIMENSION =                   -53;
public static final int CL_INVALID_WORK_GROUP_SIZE =                  -54;
public static final int CL_INVALID_WORK_ITEM_SIZE =                   -55;
public static final int CL_INVALID_GLOBAL_OFFSET =                    -56;
public static final int CL_INVALID_EVENT_WAIT_LIST =                  -57;
public static final int CL_INVALID_EVENT =                            -58;
public static final int CL_INVALID_OPERATION =                        -59;
public static final int CL_INVALID_GL_OBJECT =                        -60;
public static final int CL_INVALID_BUFFER_SIZE =                      -61;
public static final int CL_INVALID_MIP_LEVEL =                        -62;
public static final int CL_INVALID_GLOBAL_WORK_SIZE =                 -63;
// #ifdef CL_VERSION_1_1
public static final int CL_INVALID_PROPERTY =                         -64;
// #endif
// #ifdef CL_VERSION_1_2
public static final int CL_INVALID_IMAGE_DESCRIPTOR =                 -65;
public static final int CL_INVALID_COMPILER_OPTIONS =                 -66;
public static final int CL_INVALID_LINKER_OPTIONS =                   -67;
public static final int CL_INVALID_DEVICE_PARTITION_COUNT =           -68;
// #endif
// #ifdef CL_VERSION_2_0
public static final int CL_INVALID_PIPE_SIZE =                        -69;
public static final int CL_INVALID_DEVICE_QUEUE =                     -70;
// #endif
// #ifdef CL_VERSION_2_2
public static final int CL_INVALID_SPEC_ID =                          -71;
public static final int CL_MAX_SIZE_RESTRICTION_EXCEEDED =            -72;
// #endif


/* cl_bool */
public static final int CL_FALSE =                                    0;
public static final int CL_TRUE =                                     1;
// #ifdef CL_VERSION_1_2
public static final int CL_BLOCKING =                                 CL_TRUE;
public static final int CL_NON_BLOCKING =                             CL_FALSE;
// #endif

/* cl_platform_info */
public static final int CL_PLATFORM_PROFILE =                         0x0900;
public static final int CL_PLATFORM_VERSION =                         0x0901;
public static final int CL_PLATFORM_NAME =                            0x0902;
public static final int CL_PLATFORM_VENDOR =                          0x0903;
public static final int CL_PLATFORM_EXTENSIONS =                      0x0904;
// #ifdef CL_VERSION_2_1
public static final int CL_PLATFORM_HOST_TIMER_RESOLUTION =           0x0905;
// #endif
// #ifdef CL_VERSION_3_0
public static final int CL_PLATFORM_NUMERIC_VERSION =                 0x0906;
public static final int CL_PLATFORM_EXTENSIONS_WITH_VERSION =         0x0907;
// #endif

/* cl_device_type - bitfield */
public static final int CL_DEVICE_TYPE_DEFAULT =                      (1 << 0);
public static final int CL_DEVICE_TYPE_CPU =                          (1 << 1);
public static final int CL_DEVICE_TYPE_GPU =                          (1 << 2);
public static final int CL_DEVICE_TYPE_ACCELERATOR =                  (1 << 3);
// #ifdef CL_VERSION_1_2
public static final int CL_DEVICE_TYPE_CUSTOM =                       (1 << 4);
// #endif
public static final int CL_DEVICE_TYPE_ALL =                          0xFFFFFFFF;

/* cl_device_info */
public static final int CL_DEVICE_TYPE =                                   0x1000;
public static final int CL_DEVICE_VENDOR_ID =                              0x1001;
public static final int CL_DEVICE_MAX_COMPUTE_UNITS =                      0x1002;
public static final int CL_DEVICE_MAX_WORK_ITEM_DIMENSIONS =               0x1003;
public static final int CL_DEVICE_MAX_WORK_GROUP_SIZE =                    0x1004;
public static final int CL_DEVICE_MAX_WORK_ITEM_SIZES =                    0x1005;
public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_CHAR =            0x1006;
public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_SHORT =           0x1007;
public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_INT =             0x1008;
public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_LONG =            0x1009;
public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_FLOAT =           0x100A;
public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_DOUBLE =          0x100B;
public static final int CL_DEVICE_MAX_CLOCK_FREQUENCY =                    0x100C;
public static final int CL_DEVICE_ADDRESS_BITS =                           0x100D;
public static final int CL_DEVICE_MAX_READ_IMAGE_ARGS =                    0x100E;
public static final int CL_DEVICE_MAX_WRITE_IMAGE_ARGS =                   0x100F;
public static final int CL_DEVICE_MAX_MEM_ALLOC_SIZE =                     0x1010;
public static final int CL_DEVICE_IMAGE2D_MAX_WIDTH =                      0x1011;
public static final int CL_DEVICE_IMAGE2D_MAX_HEIGHT =                     0x1012;
public static final int CL_DEVICE_IMAGE3D_MAX_WIDTH =                      0x1013;
public static final int CL_DEVICE_IMAGE3D_MAX_HEIGHT =                     0x1014;
public static final int CL_DEVICE_IMAGE3D_MAX_DEPTH =                      0x1015;
public static final int CL_DEVICE_IMAGE_SUPPORT =                          0x1016;
public static final int CL_DEVICE_MAX_PARAMETER_SIZE =                     0x1017;
public static final int CL_DEVICE_MAX_SAMPLERS =                           0x1018;
public static final int CL_DEVICE_MEM_BASE_ADDR_ALIGN =                    0x1019;
public static final int CL_DEVICE_MIN_DATA_TYPE_ALIGN_SIZE =               0x101A;
public static final int CL_DEVICE_SINGLE_FP_CONFIG =                       0x101B;
public static final int CL_DEVICE_GLOBAL_MEM_CACHE_TYPE =                  0x101C;
public static final int CL_DEVICE_GLOBAL_MEM_CACHELINE_SIZE =              0x101D;
public static final int CL_DEVICE_GLOBAL_MEM_CACHE_SIZE =                  0x101E;
public static final int CL_DEVICE_GLOBAL_MEM_SIZE =                        0x101F;
public static final int CL_DEVICE_MAX_CONSTANT_BUFFER_SIZE =               0x1020;
public static final int CL_DEVICE_MAX_CONSTANT_ARGS =                      0x1021;
public static final int CL_DEVICE_LOCAL_MEM_TYPE =                         0x1022;
public static final int CL_DEVICE_LOCAL_MEM_SIZE =                         0x1023;
public static final int CL_DEVICE_ERROR_CORRECTION_SUPPORT =               0x1024;
public static final int CL_DEVICE_PROFILING_TIMER_RESOLUTION =             0x1025;
public static final int CL_DEVICE_ENDIAN_LITTLE =                          0x1026;
public static final int CL_DEVICE_AVAILABLE =                              0x1027;
public static final int CL_DEVICE_COMPILER_AVAILABLE =                     0x1028;
public static final int CL_DEVICE_EXECUTION_CAPABILITIES =                 0x1029;
public static final int CL_DEVICE_QUEUE_PROPERTIES =                       0x102A;    /* deprecated */
// #ifdef CL_VERSION_2_0
public static final int CL_DEVICE_QUEUE_ON_HOST_PROPERTIES =               0x102A;
// #endif
public static final int CL_DEVICE_NAME =                                   0x102B;
public static final int CL_DEVICE_VENDOR =                                 0x102C;
public static final int CL_DRIVER_VERSION =                                0x102D;
public static final int CL_DEVICE_PROFILE =                                0x102E;
public static final int CL_DEVICE_VERSION =                                0x102F;
public static final int CL_DEVICE_EXTENSIONS =                             0x1030;
public static final int CL_DEVICE_PLATFORM =                               0x1031;
// #ifdef CL_VERSION_1_2
public static final int CL_DEVICE_DOUBLE_FP_CONFIG =                       0x1032;
// #endif
/* 0x1033 reserved for CL_DEVICE_HALF_FP_CONFIG which is already defined in "cl_ext.h" */
// #ifdef CL_VERSION_1_1
public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_HALF =            0x1034;
public static final int CL_DEVICE_HOST_UNIFIED_MEMORY =                    0x1035;   /* deprecated */
public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_CHAR =               0x1036;
public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_SHORT =              0x1037;
public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_INT =                0x1038;
public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_LONG =               0x1039;
public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_FLOAT =              0x103A;
public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_DOUBLE =             0x103B;
public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_HALF =               0x103C;
public static final int CL_DEVICE_OPENCL_C_VERSION =                       0x103D;
// #endif
// #ifdef CL_VERSION_1_2
public static final int CL_DEVICE_LINKER_AVAILABLE =                       0x103E;
public static final int CL_DEVICE_BUILT_IN_KERNELS =                       0x103F;
public static final int CL_DEVICE_IMAGE_MAX_BUFFER_SIZE =                  0x1040;
public static final int CL_DEVICE_IMAGE_MAX_ARRAY_SIZE =                   0x1041;
public static final int CL_DEVICE_PARENT_DEVICE =                          0x1042;
public static final int CL_DEVICE_PARTITION_MAX_SUB_DEVICES =              0x1043;
public static final int CL_DEVICE_PARTITION_PROPERTIES =                   0x1044;
public static final int CL_DEVICE_PARTITION_AFFINITY_DOMAIN =              0x1045;
public static final int CL_DEVICE_PARTITION_TYPE =                         0x1046;
public static final int CL_DEVICE_REFERENCE_COUNT =                        0x1047;
public static final int CL_DEVICE_PREFERRED_INTEROP_USER_SYNC =            0x1048;
public static final int CL_DEVICE_PRINTF_BUFFER_SIZE =                     0x1049;
// #endif
// #ifdef CL_VERSION_2_0
public static final int CL_DEVICE_IMAGE_PITCH_ALIGNMENT =                  0x104A;
public static final int CL_DEVICE_IMAGE_BASE_ADDRESS_ALIGNMENT =           0x104B;
public static final int CL_DEVICE_MAX_READ_WRITE_IMAGE_ARGS =              0x104C;
public static final int CL_DEVICE_MAX_GLOBAL_VARIABLE_SIZE =               0x104D;
public static final int CL_DEVICE_QUEUE_ON_DEVICE_PROPERTIES =             0x104E;
public static final int CL_DEVICE_QUEUE_ON_DEVICE_PREFERRED_SIZE =         0x104F;
public static final int CL_DEVICE_QUEUE_ON_DEVICE_MAX_SIZE =               0x1050;
public static final int CL_DEVICE_MAX_ON_DEVICE_QUEUES =                   0x1051;
public static final int CL_DEVICE_MAX_ON_DEVICE_EVENTS =                   0x1052;
public static final int CL_DEVICE_SVM_CAPABILITIES =                       0x1053;
public static final int CL_DEVICE_GLOBAL_VARIABLE_PREFERRED_TOTAL_SIZE =   0x1054;
public static final int CL_DEVICE_MAX_PIPE_ARGS =                          0x1055;
public static final int CL_DEVICE_PIPE_MAX_ACTIVE_RESERVATIONS =           0x1056;
public static final int CL_DEVICE_PIPE_MAX_PACKET_SIZE =                   0x1057;
public static final int CL_DEVICE_PREFERRED_PLATFORM_ATOMIC_ALIGNMENT =    0x1058;
public static final int CL_DEVICE_PREFERRED_GLOBAL_ATOMIC_ALIGNMENT =      0x1059;
public static final int CL_DEVICE_PREFERRED_LOCAL_ATOMIC_ALIGNMENT =       0x105A;
// #endif
// #ifdef CL_VERSION_2_1
public static final int CL_DEVICE_IL_VERSION =                             0x105B;
public static final int CL_DEVICE_MAX_NUM_SUB_GROUPS =                     0x105C;
public static final int CL_DEVICE_SUB_GROUP_INDEPENDENT_FORWARD_PROGRESS = 0x105D;
// #endif
// #ifdef CL_VERSION_3_0
public static final int CL_DEVICE_NUMERIC_VERSION =                        0x105E;
public static final int CL_DEVICE_EXTENSIONS_WITH_VERSION =                0x1060;
public static final int CL_DEVICE_ILS_WITH_VERSION =                       0x1061;
public static final int CL_DEVICE_BUILT_IN_KERNELS_WITH_VERSION =          0x1062;
public static final int CL_DEVICE_ATOMIC_MEMORY_CAPABILITIES =             0x1063;
public static final int CL_DEVICE_ATOMIC_FENCE_CAPABILITIES =              0x1064;
public static final int CL_DEVICE_NON_UNIFORM_WORK_GROUP_SUPPORT =         0x1065;
public static final int CL_DEVICE_OPENCL_C_ALL_VERSIONS =                  0x1066;
public static final int CL_DEVICE_PREFERRED_WORK_GROUP_SIZE_MULTIPLE =     0x1067;
public static final int CL_DEVICE_WORK_GROUP_COLLECTIVE_FUNCTIONS_SUPPORT = 0x1068;
public static final int CL_DEVICE_GENERIC_ADDRESS_SPACE_SUPPORT =          0x1069;
/* 0x106A to 0x106E - Reserved for upcoming KHR extension */
public static final int CL_DEVICE_OPENCL_C_FEATURES =                      0x106F;
public static final int CL_DEVICE_DEVICE_ENQUEUE_CAPABILITIES =            0x1070;
public static final int CL_DEVICE_PIPE_SUPPORT =                           0x1071;
public static final int CL_DEVICE_LATEST_CONFORMANCE_VERSION_PASSED =      0x1072;
// #endif

/* cl_device_fp_config - bitfield */
public static final int CL_FP_DENORM =                                (1 << 0);
public static final int CL_FP_INF_NAN =                               (1 << 1);
public static final int CL_FP_ROUND_TO_NEAREST =                      (1 << 2);
public static final int CL_FP_ROUND_TO_ZERO =                         (1 << 3);
public static final int CL_FP_ROUND_TO_INF =                          (1 << 4);
public static final int CL_FP_FMA =                                   (1 << 5);
// #ifdef CL_VERSION_1_1
public static final int CL_FP_SOFT_FLOAT =                            (1 << 6);
// #endif
// #ifdef CL_VERSION_1_2
public static final int CL_FP_CORRECTLY_ROUNDED_DIVIDE_SQRT =         (1 << 7);
// #endif

/* cl_device_mem_cache_type */
public static final int CL_NONE =                                     0x0;
public static final int CL_READ_ONLY_CACHE =                          0x1;
public static final int CL_READ_WRITE_CACHE =                         0x2;

/* cl_device_local_mem_type */
public static final int CL_LOCAL =                                    0x1;
public static final int CL_GLOBAL =                                   0x2;

/* cl_device_exec_capabilities - bitfield */
public static final int CL_EXEC_KERNEL =                              (1 << 0);
public static final int CL_EXEC_NATIVE_KERNEL =                       (1 << 1);

/* cl_command_queue_properties - bitfield */
public static final int CL_QUEUE_OUT_OF_ORDER_EXEC_MODE_ENABLE =      (1 << 0);
public static final int CL_QUEUE_PROFILING_ENABLE =                   (1 << 1);
// #ifdef CL_VERSION_2_0
public static final int CL_QUEUE_ON_DEVICE =                          (1 << 2);
public static final int CL_QUEUE_ON_DEVICE_DEFAULT =                  (1 << 3);
// #endif

/* cl_context_info */
public static final int CL_CONTEXT_REFERENCE_COUNT =                  0x1080;
public static final int CL_CONTEXT_DEVICES =                          0x1081;
public static final int CL_CONTEXT_PROPERTIES =                       0x1082;
// #ifdef CL_VERSION_1_1
public static final int CL_CONTEXT_NUM_DEVICES =                      0x1083;
// #endif

/* cl_context_properties */
public static final int CL_CONTEXT_PLATFORM =                         0x1084;
// #ifdef CL_VERSION_1_2
public static final int CL_CONTEXT_INTEROP_USER_SYNC =                0x1085;
// #endif

// #ifdef CL_VERSION_1_2

/* cl_device_partition_property */
public static final int CL_DEVICE_PARTITION_EQUALLY =                 0x1086;
public static final int CL_DEVICE_PARTITION_BY_COUNTS =               0x1087;
public static final int CL_DEVICE_PARTITION_BY_COUNTS_LIST_END =      0x0;
public static final int CL_DEVICE_PARTITION_BY_AFFINITY_DOMAIN =      0x1088;

// #endif

// #ifdef CL_VERSION_1_2

/* cl_device_affinity_domain */
public static final int CL_DEVICE_AFFINITY_DOMAIN_NUMA =               (1 << 0);
public static final int CL_DEVICE_AFFINITY_DOMAIN_L4_CACHE =           (1 << 1);
public static final int CL_DEVICE_AFFINITY_DOMAIN_L3_CACHE =           (1 << 2);
public static final int CL_DEVICE_AFFINITY_DOMAIN_L2_CACHE =           (1 << 3);
public static final int CL_DEVICE_AFFINITY_DOMAIN_L1_CACHE =           (1 << 4);
public static final int CL_DEVICE_AFFINITY_DOMAIN_NEXT_PARTITIONABLE = (1 << 5);

// #endif

// #ifdef CL_VERSION_2_0

/* cl_device_svm_capabilities */
public static final int CL_DEVICE_SVM_COARSE_GRAIN_BUFFER =           (1 << 0);
public static final int CL_DEVICE_SVM_FINE_GRAIN_BUFFER =             (1 << 1);
public static final int CL_DEVICE_SVM_FINE_GRAIN_SYSTEM =             (1 << 2);
public static final int CL_DEVICE_SVM_ATOMICS =                       (1 << 3);

// #endif

/* cl_command_queue_info */
public static final int CL_QUEUE_CONTEXT =                            0x1090;
public static final int CL_QUEUE_DEVICE =                             0x1091;
public static final int CL_QUEUE_REFERENCE_COUNT =                    0x1092;
public static final int CL_QUEUE_PROPERTIES =                         0x1093;
// #ifdef CL_VERSION_2_0
public static final int CL_QUEUE_SIZE =                               0x1094;
// #endif
// #ifdef CL_VERSION_2_1
public static final int CL_QUEUE_DEVICE_DEFAULT =                     0x1095;
// #endif
// #ifdef CL_VERSION_3_0
public static final int CL_QUEUE_PROPERTIES_ARRAY =                   0x1098;
// #endif

/* cl_mem_flags and cl_svm_mem_flags - bitfield */
public static final int CL_MEM_READ_WRITE =                           (1 << 0);
public static final int CL_MEM_WRITE_ONLY =                           (1 << 1);
public static final int CL_MEM_READ_ONLY =                            (1 << 2);
public static final int CL_MEM_USE_HOST_PTR =                         (1 << 3);
public static final int CL_MEM_ALLOC_HOST_PTR =                       (1 << 4);
public static final int CL_MEM_COPY_HOST_PTR =                        (1 << 5);
/* reserved                                         (1 << 6)    */
// #ifdef CL_VERSION_1_2
public static final int CL_MEM_HOST_WRITE_ONLY =                      (1 << 7);
public static final int CL_MEM_HOST_READ_ONLY =                       (1 << 8);
public static final int CL_MEM_HOST_NO_ACCESS =                       (1 << 9);
// #endif
// #ifdef CL_VERSION_2_0
public static final int CL_MEM_SVM_FINE_GRAIN_BUFFER =                (1 << 10);   /* used by cl_svm_mem_flags only */
public static final int CL_MEM_SVM_ATOMICS =                          (1 << 11);   /* used by cl_svm_mem_flags only */
public static final int CL_MEM_KERNEL_READ_AND_WRITE =                (1 << 12);
// #endif

// #ifdef CL_VERSION_1_2

/* cl_mem_migration_flags - bitfield */
public static final int CL_MIGRATE_MEM_OBJECT_HOST =                  (1 << 0);
public static final int CL_MIGRATE_MEM_OBJECT_CONTENT_UNDEFINED =     (1 << 1);

// #endif

/* cl_channel_order */
public static final int CL_R =                                        0x10B0;
public static final int CL_A =                                        0x10B1;
public static final int CL_RG =                                       0x10B2;
public static final int CL_RA =                                       0x10B3;
public static final int CL_RGB =                                      0x10B4;
public static final int CL_RGBA =                                     0x10B5;
public static final int CL_BGRA =                                     0x10B6;
public static final int CL_ARGB =                                     0x10B7;
public static final int CL_INTENSITY =                                0x10B8;
public static final int CL_LUMINANCE =                                0x10B9;
// #ifdef CL_VERSION_1_1
public static final int CL_Rx =                                       0x10BA;
public static final int CL_RGx =                                      0x10BB;
public static final int CL_RGBx =                                     0x10BC;
// #endif
// #ifdef CL_VERSION_1_2
public static final int CL_DEPTH =                                    0x10BD;
public static final int CL_DEPTH_STENCIL =                            0x10BE;
// #endif
// #ifdef CL_VERSION_2_0
public static final int CL_sRGB =                                     0x10BF;
public static final int CL_sRGBx =                                    0x10C0;
public static final int CL_sRGBA =                                    0x10C1;
public static final int CL_sBGRA =                                    0x10C2;
public static final int CL_ABGR =                                     0x10C3;
// #endif

/* cl_channel_type */
public static final int CL_SNORM_INT8 =                               0x10D0;
public static final int CL_SNORM_INT16 =                              0x10D1;
public static final int CL_UNORM_INT8 =                               0x10D2;
public static final int CL_UNORM_INT16 =                              0x10D3;
public static final int CL_UNORM_SHORT_565 =                          0x10D4;
public static final int CL_UNORM_SHORT_555 =                          0x10D5;
public static final int CL_UNORM_INT_101010 =                         0x10D6;
public static final int CL_SIGNED_INT8 =                              0x10D7;
public static final int CL_SIGNED_INT16 =                             0x10D8;
public static final int CL_SIGNED_INT32 =                             0x10D9;
public static final int CL_UNSIGNED_INT8 =                            0x10DA;
public static final int CL_UNSIGNED_INT16 =                           0x10DB;
public static final int CL_UNSIGNED_INT32 =                           0x10DC;
public static final int CL_HALF_FLOAT =                               0x10DD;
public static final int CL_FLOAT =                                    0x10DE;
// #ifdef CL_VERSION_1_2
public static final int CL_UNORM_INT24 =                              0x10DF;
// #endif
// #ifdef CL_VERSION_2_1
public static final int CL_UNORM_INT_101010_2 =                       0x10E0;
// #endif

/* cl_mem_object_type */
public static final int CL_MEM_OBJECT_BUFFER =                        0x10F0;
public static final int CL_MEM_OBJECT_IMAGE2D =                       0x10F1;
public static final int CL_MEM_OBJECT_IMAGE3D =                       0x10F2;
// #ifdef CL_VERSION_1_2
public static final int CL_MEM_OBJECT_IMAGE2D_ARRAY =                 0x10F3;
public static final int CL_MEM_OBJECT_IMAGE1D =                       0x10F4;
public static final int CL_MEM_OBJECT_IMAGE1D_ARRAY =                 0x10F5;
public static final int CL_MEM_OBJECT_IMAGE1D_BUFFER =                0x10F6;
// #endif
// #ifdef CL_VERSION_2_0
public static final int CL_MEM_OBJECT_PIPE =                          0x10F7;
// #endif

/* cl_mem_info */
public static final int CL_MEM_TYPE =                                 0x1100;
public static final int CL_MEM_FLAGS =                                0x1101;
public static final int CL_MEM_SIZE =                                 0x1102;
public static final int CL_MEM_HOST_PTR =                             0x1103;
public static final int CL_MEM_MAP_COUNT =                            0x1104;
public static final int CL_MEM_REFERENCE_COUNT =                      0x1105;
public static final int CL_MEM_CONTEXT =                              0x1106;
// #ifdef CL_VERSION_1_1
public static final int CL_MEM_ASSOCIATED_MEMOBJECT =                 0x1107;
public static final int CL_MEM_OFFSET =                               0x1108;
// #endif
// #ifdef CL_VERSION_2_0
public static final int CL_MEM_USES_SVM_POINTER =                     0x1109;
// #endif
// #ifdef CL_VERSION_3_0
public static final int CL_MEM_PROPERTIES =                           0x110A;
// #endif

/* cl_image_info */
public static final int CL_IMAGE_FORMAT =                             0x1110;
public static final int CL_IMAGE_ELEMENT_SIZE =                       0x1111;
public static final int CL_IMAGE_ROW_PITCH =                          0x1112;
public static final int CL_IMAGE_SLICE_PITCH =                        0x1113;
public static final int CL_IMAGE_WIDTH =                              0x1114;
public static final int CL_IMAGE_HEIGHT =                             0x1115;
public static final int CL_IMAGE_DEPTH =                              0x1116;
// #ifdef CL_VERSION_1_2
public static final int CL_IMAGE_ARRAY_SIZE =                         0x1117;
public static final int CL_IMAGE_BUFFER =                             0x1118;
public static final int CL_IMAGE_NUM_MIP_LEVELS =                     0x1119;
public static final int CL_IMAGE_NUM_SAMPLES =                        0x111A;
// #endif


/* cl_pipe_info */
// #ifdef CL_VERSION_2_0
public static final int CL_PIPE_PACKET_SIZE =                         0x1120;
public static final int CL_PIPE_MAX_PACKETS =                         0x1121;
// #endif
// #ifdef CL_VERSION_3_0
public static final int CL_PIPE_PROPERTIES =                          0x1122;
// #endif

/* cl_addressing_mode */
public static final int CL_ADDRESS_NONE =                             0x1130;
public static final int CL_ADDRESS_CLAMP_TO_EDGE =                    0x1131;
public static final int CL_ADDRESS_CLAMP =                            0x1132;
public static final int CL_ADDRESS_REPEAT =                           0x1133;
// #ifdef CL_VERSION_1_1
public static final int CL_ADDRESS_MIRRORED_REPEAT =                  0x1134;
// #endif

/* cl_filter_mode */
public static final int CL_FILTER_NEAREST =                           0x1140;
public static final int CL_FILTER_LINEAR =                            0x1141;

/* cl_sampler_info */
public static final int CL_SAMPLER_REFERENCE_COUNT =                  0x1150;
public static final int CL_SAMPLER_CONTEXT =                          0x1151;
public static final int CL_SAMPLER_NORMALIZED_COORDS =                0x1152;
public static final int CL_SAMPLER_ADDRESSING_MODE =                  0x1153;
public static final int CL_SAMPLER_FILTER_MODE =                      0x1154;
// #ifdef CL_VERSION_2_0
/* These enumerants are for the cl_khr_mipmap_image extension.
   They have since been added to cl_ext.h with an appropriate
   KHR suffix, but are left here for backwards compatibility. */
public static final int CL_SAMPLER_MIP_FILTER_MODE =                  0x1155;
public static final int CL_SAMPLER_LOD_MIN =                          0x1156;
public static final int CL_SAMPLER_LOD_MAX =                          0x1157;
// #endif
// #ifdef CL_VERSION_3_0
public static final int CL_SAMPLER_PROPERTIES =                       0x1158;
// #endif

/* cl_map_flags - bitfield */
public static final int CL_MAP_READ =                                 (1 << 0);
public static final int CL_MAP_WRITE =                                (1 << 1);
// #ifdef CL_VERSION_1_2
public static final int CL_MAP_WRITE_INVALIDATE_REGION =              (1 << 2);
// #endif

/* cl_program_info */
public static final int CL_PROGRAM_REFERENCE_COUNT =                  0x1160;
public static final int CL_PROGRAM_CONTEXT =                          0x1161;
public static final int CL_PROGRAM_NUM_DEVICES =                      0x1162;
public static final int CL_PROGRAM_DEVICES =                          0x1163;
public static final int CL_PROGRAM_SOURCE =                           0x1164;
public static final int CL_PROGRAM_BINARY_SIZES =                     0x1165;
public static final int CL_PROGRAM_BINARIES =                         0x1166;
// #ifdef CL_VERSION_1_2
public static final int CL_PROGRAM_NUM_KERNELS =                      0x1167;
public static final int CL_PROGRAM_KERNEL_NAMES =                     0x1168;
// #endif
// #ifdef CL_VERSION_2_1
public static final int CL_PROGRAM_IL =                               0x1169;
// #endif
// #ifdef CL_VERSION_2_2
public static final int CL_PROGRAM_SCOPE_GLOBAL_CTORS_PRESENT =       0x116A;
public static final int CL_PROGRAM_SCOPE_GLOBAL_DTORS_PRESENT =       0x116B;
// #endif

/* cl_program_build_info */
public static final int CL_PROGRAM_BUILD_STATUS =                     0x1181;
public static final int CL_PROGRAM_BUILD_OPTIONS =                    0x1182;
public static final int CL_PROGRAM_BUILD_LOG =                        0x1183;
// #ifdef CL_VERSION_1_2
public static final int CL_PROGRAM_BINARY_TYPE =                      0x1184;
// #endif
// #ifdef CL_VERSION_2_0
public static final int CL_PROGRAM_BUILD_GLOBAL_VARIABLE_TOTAL_SIZE = 0x1185;
// #endif

// #ifdef CL_VERSION_1_2

/* cl_program_binary_type */
public static final int CL_PROGRAM_BINARY_TYPE_NONE =                 0x0;
public static final int CL_PROGRAM_BINARY_TYPE_COMPILED_OBJECT =      0x1;
public static final int CL_PROGRAM_BINARY_TYPE_LIBRARY =              0x2;
public static final int CL_PROGRAM_BINARY_TYPE_EXECUTABLE =           0x4;

// #endif

/* cl_build_status */
public static final int CL_BUILD_SUCCESS =                            0;
public static final int CL_BUILD_NONE =                               -1;
public static final int CL_BUILD_ERROR =                              -2;
public static final int CL_BUILD_IN_PROGRESS =                        -3;

/* cl_kernel_info */
public static final int CL_KERNEL_FUNCTION_NAME =                     0x1190;
public static final int CL_KERNEL_NUM_ARGS =                          0x1191;
public static final int CL_KERNEL_REFERENCE_COUNT =                   0x1192;
public static final int CL_KERNEL_CONTEXT =                           0x1193;
public static final int CL_KERNEL_PROGRAM =                           0x1194;
// #ifdef CL_VERSION_1_2
public static final int CL_KERNEL_ATTRIBUTES =                        0x1195;
// #endif

// #ifdef CL_VERSION_1_2

/* cl_kernel_arg_info */
public static final int CL_KERNEL_ARG_ADDRESS_QUALIFIER =             0x1196;
public static final int CL_KERNEL_ARG_ACCESS_QUALIFIER =              0x1197;
public static final int CL_KERNEL_ARG_TYPE_NAME =                     0x1198;
public static final int CL_KERNEL_ARG_TYPE_QUALIFIER =                0x1199;
public static final int CL_KERNEL_ARG_NAME =                          0x119A;

// #endif

// #ifdef CL_VERSION_1_2

/* cl_kernel_arg_address_qualifier */
public static final int CL_KERNEL_ARG_ADDRESS_GLOBAL =                0x119B;
public static final int CL_KERNEL_ARG_ADDRESS_LOCAL =                 0x119C;
public static final int CL_KERNEL_ARG_ADDRESS_CONSTANT =              0x119D;
public static final int CL_KERNEL_ARG_ADDRESS_PRIVATE =               0x119E;

// #endif

// #ifdef CL_VERSION_1_2

/* cl_kernel_arg_access_qualifier */
public static final int CL_KERNEL_ARG_ACCESS_READ_ONLY =              0x11A0;
public static final int CL_KERNEL_ARG_ACCESS_WRITE_ONLY =             0x11A1;
public static final int CL_KERNEL_ARG_ACCESS_READ_WRITE =             0x11A2;
public static final int CL_KERNEL_ARG_ACCESS_NONE =                   0x11A3;

// #endif

// #ifdef CL_VERSION_1_2

/* cl_kernel_arg_type_qualifier */
public static final int CL_KERNEL_ARG_TYPE_NONE =                     0;
public static final int CL_KERNEL_ARG_TYPE_CONST =                    (1 << 0);
public static final int CL_KERNEL_ARG_TYPE_RESTRICT =                 (1 << 1);
public static final int CL_KERNEL_ARG_TYPE_VOLATILE =                 (1 << 2);
// #ifdef CL_VERSION_2_0
public static final int CL_KERNEL_ARG_TYPE_PIPE =                     (1 << 3);
// #endif

// #endif

/* cl_kernel_work_group_info */
public static final int CL_KERNEL_WORK_GROUP_SIZE =                   0x11B0;
public static final int CL_KERNEL_COMPILE_WORK_GROUP_SIZE =           0x11B1;
public static final int CL_KERNEL_LOCAL_MEM_SIZE =                    0x11B2;
public static final int CL_KERNEL_PREFERRED_WORK_GROUP_SIZE_MULTIPLE = 0x11B3;
public static final int CL_KERNEL_PRIVATE_MEM_SIZE =                  0x11B4;
// #ifdef CL_VERSION_1_2
public static final int CL_KERNEL_GLOBAL_WORK_SIZE =                  0x11B5;
// #endif

// #ifdef CL_VERSION_2_1

/* cl_kernel_sub_group_info */
public static final int CL_KERNEL_MAX_SUB_GROUP_SIZE_FOR_NDRANGE =    0x2033;
public static final int CL_KERNEL_SUB_GROUP_COUNT_FOR_NDRANGE =       0x2034;
public static final int CL_KERNEL_LOCAL_SIZE_FOR_SUB_GROUP_COUNT =    0x11B8;
public static final int CL_KERNEL_MAX_NUM_SUB_GROUPS =                0x11B9;
public static final int CL_KERNEL_COMPILE_NUM_SUB_GROUPS =            0x11BA;

// #endif

// #ifdef CL_VERSION_2_0

/* cl_kernel_exec_info */
public static final int CL_KERNEL_EXEC_INFO_SVM_PTRS =                0x11B6;
public static final int CL_KERNEL_EXEC_INFO_SVM_FINE_GRAIN_SYSTEM =   0x11B7;

// #endif

/* cl_event_info */
public static final int CL_EVENT_COMMAND_QUEUE =                      0x11D0;
public static final int CL_EVENT_COMMAND_TYPE =                       0x11D1;
public static final int CL_EVENT_REFERENCE_COUNT =                    0x11D2;
public static final int CL_EVENT_COMMAND_EXECUTION_STATUS =           0x11D3;
// #ifdef CL_VERSION_1_1
public static final int CL_EVENT_CONTEXT =                            0x11D4;
// #endif

/* cl_command_type */
public static final int CL_COMMAND_NDRANGE_KERNEL =                   0x11F0;
public static final int CL_COMMAND_TASK =                             0x11F1;
public static final int CL_COMMAND_NATIVE_KERNEL =                    0x11F2;
public static final int CL_COMMAND_READ_BUFFER =                      0x11F3;
public static final int CL_COMMAND_WRITE_BUFFER =                     0x11F4;
public static final int CL_COMMAND_COPY_BUFFER =                      0x11F5;
public static final int CL_COMMAND_READ_IMAGE =                       0x11F6;
public static final int CL_COMMAND_WRITE_IMAGE =                      0x11F7;
public static final int CL_COMMAND_COPY_IMAGE =                       0x11F8;
public static final int CL_COMMAND_COPY_IMAGE_TO_BUFFER =             0x11F9;
public static final int CL_COMMAND_COPY_BUFFER_TO_IMAGE =             0x11FA;
public static final int CL_COMMAND_MAP_BUFFER =                       0x11FB;
public static final int CL_COMMAND_MAP_IMAGE =                        0x11FC;
public static final int CL_COMMAND_UNMAP_MEM_OBJECT =                 0x11FD;
public static final int CL_COMMAND_MARKER =                           0x11FE;
public static final int CL_COMMAND_ACQUIRE_GL_OBJECTS =               0x11FF;
public static final int CL_COMMAND_RELEASE_GL_OBJECTS =               0x1200;
// #ifdef CL_VERSION_1_1
public static final int CL_COMMAND_READ_BUFFER_RECT =                 0x1201;
public static final int CL_COMMAND_WRITE_BUFFER_RECT =                0x1202;
public static final int CL_COMMAND_COPY_BUFFER_RECT =                 0x1203;
public static final int CL_COMMAND_USER =                             0x1204;
// #endif
// #ifdef CL_VERSION_1_2
public static final int CL_COMMAND_BARRIER =                          0x1205;
public static final int CL_COMMAND_MIGRATE_MEM_OBJECTS =              0x1206;
public static final int CL_COMMAND_FILL_BUFFER =                      0x1207;
public static final int CL_COMMAND_FILL_IMAGE =                       0x1208;
// #endif
// #ifdef CL_VERSION_2_0
public static final int CL_COMMAND_SVM_FREE =                         0x1209;
public static final int CL_COMMAND_SVM_MEMCPY =                       0x120A;
public static final int CL_COMMAND_SVM_MEMFILL =                      0x120B;
public static final int CL_COMMAND_SVM_MAP =                          0x120C;
public static final int CL_COMMAND_SVM_UNMAP =                        0x120D;
// #endif
// #ifdef CL_VERSION_3_0
public static final int CL_COMMAND_SVM_MIGRATE_MEM =                  0x120E;
// #endif

/* command execution status */
public static final int CL_COMPLETE =                                 0x0;
public static final int CL_RUNNING =                                  0x1;
public static final int CL_SUBMITTED =                                0x2;
public static final int CL_QUEUED =                                   0x3;

/* cl_buffer_create_type */
// #ifdef CL_VERSION_1_1
public static final int CL_BUFFER_CREATE_TYPE_REGION =                0x1220;
// #endif

/* cl_profiling_info */
public static final int CL_PROFILING_COMMAND_QUEUED =                 0x1280;
public static final int CL_PROFILING_COMMAND_SUBMIT =                 0x1281;
public static final int CL_PROFILING_COMMAND_START =                  0x1282;
public static final int CL_PROFILING_COMMAND_END =                    0x1283;
// #ifdef CL_VERSION_2_0
public static final int CL_PROFILING_COMMAND_COMPLETE =               0x1284;
// #endif

/* cl_device_atomic_capabilities - bitfield */
// #ifdef CL_VERSION_3_0
public static final int CL_DEVICE_ATOMIC_ORDER_RELAXED =          (1 << 0);
public static final int CL_DEVICE_ATOMIC_ORDER_ACQ_REL =          (1 << 1);
public static final int CL_DEVICE_ATOMIC_ORDER_SEQ_CST =          (1 << 2);
public static final int CL_DEVICE_ATOMIC_SCOPE_WORK_ITEM =        (1 << 3);
public static final int CL_DEVICE_ATOMIC_SCOPE_WORK_GROUP =       (1 << 4);
public static final int CL_DEVICE_ATOMIC_SCOPE_DEVICE =           (1 << 5);
public static final int CL_DEVICE_ATOMIC_SCOPE_ALL_DEVICES =      (1 << 6);
// #endif

/* cl_device_device_enqueue_capabilities - bitfield */
// #ifdef CL_VERSION_3_0
public static final int CL_DEVICE_QUEUE_SUPPORTED =               (1 << 0);
public static final int CL_DEVICE_QUEUE_REPLACEABLE_DEFAULT =     (1 << 1);
// #endif

/* cl_khronos_vendor_id */
public static final int CL_KHRONOS_VENDOR_ID_CODEPLAY =               0x10004;

// #ifdef CL_VERSION_3_0

/* cl_version */
public static final int CL_VERSION_MAJOR_BITS = (10);
public static final int CL_VERSION_MINOR_BITS = (10);
public static final int CL_VERSION_PATCH_BITS = (12);

public static final int CL_VERSION_MAJOR_MASK = ((1 << CL_VERSION_MAJOR_BITS) - 1);
public static final int CL_VERSION_MINOR_MASK = ((1 << CL_VERSION_MINOR_BITS) - 1);
public static final int CL_VERSION_PATCH_MASK = ((1 << CL_VERSION_PATCH_BITS) - 1);

// #define CL_VERSION_MAJOR(version)
//   ((version) >> (CL_VERSION_MINOR_BITS + CL_VERSION_PATCH_BITS))

// #define CL_VERSION_MINOR(version)
//   (((version) >> CL_VERSION_PATCH_BITS) & CL_VERSION_MINOR_MASK)

// #define CL_VERSION_PATCH(version) ((version) & CL_VERSION_PATCH_MASK)

// #define CL_MAKE_VERSION(major, minor, patch)
//   ((((major) & CL_VERSION_MAJOR_MASK)
//        << (CL_VERSION_MINOR_BITS + CL_VERSION_PATCH_BITS)) |
//    (((minor) & CL_VERSION_MINOR_MASK) << CL_VERSION_PATCH_BITS) |
//    ((patch) & CL_VERSION_PATCH_MASK))

// #endif

/********************************************************************************************************/

/* CL_NO_PROTOTYPES implies CL_NO_CORE_PROTOTYPES: */
// #if defined(CL_NO_PROTOTYPES) && !defined(CL_NO_CORE_PROTOTYPES)
// #define CL_NO_CORE_PROTOTYPES
// #endif

// #if !defined(CL_NO_CORE_PROTOTYPES)

/* Platform API */
public static native @Cast("cl_int") int clGetPlatformIDs(@Cast("cl_uint") int num_entries,
                 @Cast("cl_platform_id*") PointerPointer platforms,
                 @Cast("cl_uint*") IntPointer num_platforms);
public static native @Cast("cl_int") int clGetPlatformIDs(@Cast("cl_uint") int num_entries,
                 @ByPtrPtr _cl_platform_id platforms,
                 @Cast("cl_uint*") IntBuffer num_platforms);
public static native @Cast("cl_int") int clGetPlatformIDs(@Cast("cl_uint") int num_entries,
                 @Cast("cl_platform_id*") PointerPointer platforms,
                 @Cast("cl_uint*") int[] num_platforms);
public static native @Cast("cl_int") int clGetPlatformIDs(@Cast("cl_uint") int num_entries,
                 @ByPtrPtr _cl_platform_id platforms,
                 @Cast("cl_uint*") IntPointer num_platforms);
public static native @Cast("cl_int") int clGetPlatformIDs(@Cast("cl_uint") int num_entries,
                 @Cast("cl_platform_id*") PointerPointer platforms,
                 @Cast("cl_uint*") IntBuffer num_platforms);
public static native @Cast("cl_int") int clGetPlatformIDs(@Cast("cl_uint") int num_entries,
                 @ByPtrPtr _cl_platform_id platforms,
                 @Cast("cl_uint*") int[] num_platforms);

public static native @Cast("cl_int") int clGetPlatformInfo(_cl_platform_id platform,
                  @Cast("cl_platform_info") int param_name,
                  @Cast("size_t") long param_value_size,
                  Pointer param_value,
                  @Cast("size_t*") SizeTPointer param_value_size_ret);

/* Device APIs */
public static native @Cast("cl_int") int clGetDeviceIDs(_cl_platform_id platform,
               @Cast("cl_device_type") long device_type,
               @Cast("cl_uint") int num_entries,
               @Cast("cl_device_id*") PointerPointer devices,
               @Cast("cl_uint*") IntPointer num_devices);
public static native @Cast("cl_int") int clGetDeviceIDs(_cl_platform_id platform,
               @Cast("cl_device_type") long device_type,
               @Cast("cl_uint") int num_entries,
               @ByPtrPtr _cl_device_id devices,
               @Cast("cl_uint*") IntBuffer num_devices);
public static native @Cast("cl_int") int clGetDeviceIDs(_cl_platform_id platform,
               @Cast("cl_device_type") long device_type,
               @Cast("cl_uint") int num_entries,
               @Cast("cl_device_id*") PointerPointer devices,
               @Cast("cl_uint*") int[] num_devices);
public static native @Cast("cl_int") int clGetDeviceIDs(_cl_platform_id platform,
               @Cast("cl_device_type") long device_type,
               @Cast("cl_uint") int num_entries,
               @ByPtrPtr _cl_device_id devices,
               @Cast("cl_uint*") IntPointer num_devices);
public static native @Cast("cl_int") int clGetDeviceIDs(_cl_platform_id platform,
               @Cast("cl_device_type") long device_type,
               @Cast("cl_uint") int num_entries,
               @Cast("cl_device_id*") PointerPointer devices,
               @Cast("cl_uint*") IntBuffer num_devices);
public static native @Cast("cl_int") int clGetDeviceIDs(_cl_platform_id platform,
               @Cast("cl_device_type") long device_type,
               @Cast("cl_uint") int num_entries,
               @ByPtrPtr _cl_device_id devices,
               @Cast("cl_uint*") int[] num_devices);

public static native @Cast("cl_int") int clGetDeviceInfo(_cl_device_id device,
                @Cast("cl_device_info") int param_name,
                @Cast("size_t") long param_value_size,
                Pointer param_value,
                @Cast("size_t*") SizeTPointer param_value_size_ret);

// #ifdef CL_VERSION_1_2

public static native @Cast("cl_int") int clCreateSubDevices(_cl_device_id in_device,
                   @Cast("const cl_device_partition_property*") SizeTPointer properties,
                   @Cast("cl_uint") int num_devices,
                   @Cast("cl_device_id*") PointerPointer out_devices,
                   @Cast("cl_uint*") IntPointer num_devices_ret);
public static native @Cast("cl_int") int clCreateSubDevices(_cl_device_id in_device,
                   @Cast("const cl_device_partition_property*") SizeTPointer properties,
                   @Cast("cl_uint") int num_devices,
                   @ByPtrPtr _cl_device_id out_devices,
                   @Cast("cl_uint*") IntBuffer num_devices_ret);
public static native @Cast("cl_int") int clCreateSubDevices(_cl_device_id in_device,
                   @Cast("const cl_device_partition_property*") SizeTPointer properties,
                   @Cast("cl_uint") int num_devices,
                   @Cast("cl_device_id*") PointerPointer out_devices,
                   @Cast("cl_uint*") int[] num_devices_ret);
public static native @Cast("cl_int") int clCreateSubDevices(_cl_device_id in_device,
                   @Cast("const cl_device_partition_property*") SizeTPointer properties,
                   @Cast("cl_uint") int num_devices,
                   @ByPtrPtr _cl_device_id out_devices,
                   @Cast("cl_uint*") IntPointer num_devices_ret);
public static native @Cast("cl_int") int clCreateSubDevices(_cl_device_id in_device,
                   @Cast("const cl_device_partition_property*") SizeTPointer properties,
                   @Cast("cl_uint") int num_devices,
                   @Cast("cl_device_id*") PointerPointer out_devices,
                   @Cast("cl_uint*") IntBuffer num_devices_ret);
public static native @Cast("cl_int") int clCreateSubDevices(_cl_device_id in_device,
                   @Cast("const cl_device_partition_property*") SizeTPointer properties,
                   @Cast("cl_uint") int num_devices,
                   @ByPtrPtr _cl_device_id out_devices,
                   @Cast("cl_uint*") int[] num_devices_ret);

public static native @Cast("cl_int") int clRetainDevice(_cl_device_id device);

public static native @Cast("cl_int") int clReleaseDevice(_cl_device_id device);

// #endif

// #ifdef CL_VERSION_2_1

public static native @Cast("cl_int") int clSetDefaultDeviceCommandQueue(_cl_context context,
                               _cl_device_id device,
                               _cl_command_queue command_queue);

public static native @Cast("cl_int") int clGetDeviceAndHostTimer(_cl_device_id device,
                        @Cast("cl_ulong*") LongPointer device_timestamp,
                        @Cast("cl_ulong*") LongPointer host_timestamp);
public static native @Cast("cl_int") int clGetDeviceAndHostTimer(_cl_device_id device,
                        @Cast("cl_ulong*") LongBuffer device_timestamp,
                        @Cast("cl_ulong*") LongBuffer host_timestamp);
public static native @Cast("cl_int") int clGetDeviceAndHostTimer(_cl_device_id device,
                        @Cast("cl_ulong*") long[] device_timestamp,
                        @Cast("cl_ulong*") long[] host_timestamp);

public static native @Cast("cl_int") int clGetHostTimer(_cl_device_id device,
               @Cast("cl_ulong*") LongPointer host_timestamp);
public static native @Cast("cl_int") int clGetHostTimer(_cl_device_id device,
               @Cast("cl_ulong*") LongBuffer host_timestamp);
public static native @Cast("cl_int") int clGetHostTimer(_cl_device_id device,
               @Cast("cl_ulong*") long[] host_timestamp);
// Targeting ..\Pfn_notify_BytePointer_Pointer_long_Pointer.java


public static native _cl_context clCreateContext(@Cast("const cl_context_properties*") SizeTPointer properties,
                @Cast("cl_uint") int num_devices,
                @Cast("const cl_device_id*") PointerPointer devices,
                Pfn_notify_BytePointer_Pointer_long_Pointer pfn_notify,
                Pointer user_data,
                @Cast("cl_int*") IntPointer errcode_ret);
// Targeting ..\Pfn_notify_String_Pointer_long_Pointer.java


public static native _cl_context clCreateContext(@Cast("const cl_context_properties*") SizeTPointer properties,
                @Cast("cl_uint") int num_devices,
                @Cast("const cl_device_id*") @ByPtrPtr _cl_device_id devices,
                Pfn_notify_String_Pointer_long_Pointer pfn_notify,
                Pointer user_data,
                @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_context clCreateContext(@Cast("const cl_context_properties*") SizeTPointer properties,
                @Cast("cl_uint") int num_devices,
                @Cast("const cl_device_id*") PointerPointer devices,
                Pfn_notify_BytePointer_Pointer_long_Pointer pfn_notify,
                Pointer user_data,
                @Cast("cl_int*") int[] errcode_ret);
public static native _cl_context clCreateContext(@Cast("const cl_context_properties*") SizeTPointer properties,
                @Cast("cl_uint") int num_devices,
                @Cast("const cl_device_id*") @ByPtrPtr _cl_device_id devices,
                Pfn_notify_String_Pointer_long_Pointer pfn_notify,
                Pointer user_data,
                @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_context clCreateContext(@Cast("const cl_context_properties*") SizeTPointer properties,
                @Cast("cl_uint") int num_devices,
                @Cast("const cl_device_id*") PointerPointer devices,
                Pfn_notify_BytePointer_Pointer_long_Pointer pfn_notify,
                Pointer user_data,
                @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_context clCreateContext(@Cast("const cl_context_properties*") SizeTPointer properties,
                @Cast("cl_uint") int num_devices,
                @Cast("const cl_device_id*") @ByPtrPtr _cl_device_id devices,
                Pfn_notify_String_Pointer_long_Pointer pfn_notify,
                Pointer user_data,
                @Cast("cl_int*") int[] errcode_ret);

public static native _cl_context clCreateContextFromType(@Cast("const cl_context_properties*") SizeTPointer properties,
                        @Cast("cl_device_type") long device_type,
                        Pfn_notify_BytePointer_Pointer_long_Pointer pfn_notify,
                        Pointer user_data,
                        @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_context clCreateContextFromType(@Cast("const cl_context_properties*") SizeTPointer properties,
                        @Cast("cl_device_type") long device_type,
                        Pfn_notify_String_Pointer_long_Pointer pfn_notify,
                        Pointer user_data,
                        @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_context clCreateContextFromType(@Cast("const cl_context_properties*") SizeTPointer properties,
                        @Cast("cl_device_type") long device_type,
                        Pfn_notify_BytePointer_Pointer_long_Pointer pfn_notify,
                        Pointer user_data,
                        @Cast("cl_int*") int[] errcode_ret);
public static native _cl_context clCreateContextFromType(@Cast("const cl_context_properties*") SizeTPointer properties,
                        @Cast("cl_device_type") long device_type,
                        Pfn_notify_String_Pointer_long_Pointer pfn_notify,
                        Pointer user_data,
                        @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_context clCreateContextFromType(@Cast("const cl_context_properties*") SizeTPointer properties,
                        @Cast("cl_device_type") long device_type,
                        Pfn_notify_BytePointer_Pointer_long_Pointer pfn_notify,
                        Pointer user_data,
                        @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_context clCreateContextFromType(@Cast("const cl_context_properties*") SizeTPointer properties,
                        @Cast("cl_device_type") long device_type,
                        Pfn_notify_String_Pointer_long_Pointer pfn_notify,
                        Pointer user_data,
                        @Cast("cl_int*") int[] errcode_ret);

public static native @Cast("cl_int") int clRetainContext(_cl_context context);

public static native @Cast("cl_int") int clReleaseContext(_cl_context context);

public static native @Cast("cl_int") int clGetContextInfo(_cl_context context,
                 @Cast("cl_context_info") int param_name,
                 @Cast("size_t") long param_value_size,
                 Pointer param_value,
                 @Cast("size_t*") SizeTPointer param_value_size_ret);
// Targeting ..\Pfn_notify__cl_context_Pointer.java


public static native @Cast("cl_int") int clSetContextDestructorCallback(_cl_context context,
                               Pfn_notify__cl_context_Pointer pfn_notify,
                               Pointer user_data);

// #endif

/* Command Queue APIs */

// #ifdef CL_VERSION_2_0

public static native _cl_command_queue clCreateCommandQueueWithProperties(_cl_context context,
                                   _cl_device_id device,
                                   @Cast("const cl_queue_properties*") LongPointer properties,
                                   @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_command_queue clCreateCommandQueueWithProperties(_cl_context context,
                                   _cl_device_id device,
                                   @Cast("const cl_queue_properties*") LongBuffer properties,
                                   @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_command_queue clCreateCommandQueueWithProperties(_cl_context context,
                                   _cl_device_id device,
                                   @Cast("const cl_queue_properties*") long[] properties,
                                   @Cast("cl_int*") int[] errcode_ret);

// #endif

public static native @Cast("cl_int") int clRetainCommandQueue(_cl_command_queue command_queue);

public static native @Cast("cl_int") int clReleaseCommandQueue(_cl_command_queue command_queue);

public static native @Cast("cl_int") int clGetCommandQueueInfo(_cl_command_queue command_queue,
                      @Cast("cl_command_queue_info") int param_name,
                      @Cast("size_t") long param_value_size,
                      Pointer param_value,
                      @Cast("size_t*") SizeTPointer param_value_size_ret);

/* Memory Object APIs */
public static native _cl_mem clCreateBuffer(_cl_context context,
               @Cast("cl_mem_flags") long flags,
               @Cast("size_t") long size,
               Pointer host_ptr,
               @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_mem clCreateBuffer(_cl_context context,
               @Cast("cl_mem_flags") long flags,
               @Cast("size_t") long size,
               Pointer host_ptr,
               @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_mem clCreateBuffer(_cl_context context,
               @Cast("cl_mem_flags") long flags,
               @Cast("size_t") long size,
               Pointer host_ptr,
               @Cast("cl_int*") int[] errcode_ret);

// #ifdef CL_VERSION_1_1

public static native _cl_mem clCreateSubBuffer(_cl_mem buffer,
                  @Cast("cl_mem_flags") long flags,
                  @Cast("cl_buffer_create_type") int buffer_create_type,
                  @Const Pointer buffer_create_info,
                  @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_mem clCreateSubBuffer(_cl_mem buffer,
                  @Cast("cl_mem_flags") long flags,
                  @Cast("cl_buffer_create_type") int buffer_create_type,
                  @Const Pointer buffer_create_info,
                  @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_mem clCreateSubBuffer(_cl_mem buffer,
                  @Cast("cl_mem_flags") long flags,
                  @Cast("cl_buffer_create_type") int buffer_create_type,
                  @Const Pointer buffer_create_info,
                  @Cast("cl_int*") int[] errcode_ret);

// #endif

// #ifdef CL_VERSION_1_2

public static native _cl_mem clCreateImage(_cl_context context,
              @Cast("cl_mem_flags") long flags,
              @Const cl_image_format image_format,
              @Const cl_image_desc image_desc,
              Pointer host_ptr,
              @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_mem clCreateImage(_cl_context context,
              @Cast("cl_mem_flags") long flags,
              @Const cl_image_format image_format,
              @Const cl_image_desc image_desc,
              Pointer host_ptr,
              @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_mem clCreateImage(_cl_context context,
              @Cast("cl_mem_flags") long flags,
              @Const cl_image_format image_format,
              @Const cl_image_desc image_desc,
              Pointer host_ptr,
              @Cast("cl_int*") int[] errcode_ret);

// #endif

// #ifdef CL_VERSION_2_0

public static native _cl_mem clCreatePipe(_cl_context context,
             @Cast("cl_mem_flags") long flags,
             @Cast("cl_uint") int pipe_packet_size,
             @Cast("cl_uint") int pipe_max_packets,
             @Cast("const cl_pipe_properties*") SizeTPointer properties,
             @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_mem clCreatePipe(_cl_context context,
             @Cast("cl_mem_flags") long flags,
             @Cast("cl_uint") int pipe_packet_size,
             @Cast("cl_uint") int pipe_max_packets,
             @Cast("const cl_pipe_properties*") SizeTPointer properties,
             @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_mem clCreatePipe(_cl_context context,
             @Cast("cl_mem_flags") long flags,
             @Cast("cl_uint") int pipe_packet_size,
             @Cast("cl_uint") int pipe_max_packets,
             @Cast("const cl_pipe_properties*") SizeTPointer properties,
             @Cast("cl_int*") int[] errcode_ret);

// #endif

// #ifdef CL_VERSION_3_0

public static native _cl_mem clCreateBufferWithProperties(_cl_context context,
                             @Cast("const cl_mem_properties*") LongPointer properties,
                             @Cast("cl_mem_flags") long flags,
                             @Cast("size_t") long size,
                             Pointer host_ptr,
                             @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_mem clCreateBufferWithProperties(_cl_context context,
                             @Cast("const cl_mem_properties*") LongBuffer properties,
                             @Cast("cl_mem_flags") long flags,
                             @Cast("size_t") long size,
                             Pointer host_ptr,
                             @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_mem clCreateBufferWithProperties(_cl_context context,
                             @Cast("const cl_mem_properties*") long[] properties,
                             @Cast("cl_mem_flags") long flags,
                             @Cast("size_t") long size,
                             Pointer host_ptr,
                             @Cast("cl_int*") int[] errcode_ret);

public static native _cl_mem clCreateImageWithProperties(_cl_context context,
                            @Cast("const cl_mem_properties*") LongPointer properties,
                            @Cast("cl_mem_flags") long flags,
                            @Const cl_image_format image_format,
                            @Const cl_image_desc image_desc,
                            Pointer host_ptr,
                            @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_mem clCreateImageWithProperties(_cl_context context,
                            @Cast("const cl_mem_properties*") LongBuffer properties,
                            @Cast("cl_mem_flags") long flags,
                            @Const cl_image_format image_format,
                            @Const cl_image_desc image_desc,
                            Pointer host_ptr,
                            @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_mem clCreateImageWithProperties(_cl_context context,
                            @Cast("const cl_mem_properties*") long[] properties,
                            @Cast("cl_mem_flags") long flags,
                            @Const cl_image_format image_format,
                            @Const cl_image_desc image_desc,
                            Pointer host_ptr,
                            @Cast("cl_int*") int[] errcode_ret);

// #endif

public static native @Cast("cl_int") int clRetainMemObject(_cl_mem memobj);

public static native @Cast("cl_int") int clReleaseMemObject(_cl_mem memobj);

public static native @Cast("cl_int") int clGetSupportedImageFormats(_cl_context context,
                           @Cast("cl_mem_flags") long flags,
                           @Cast("cl_mem_object_type") int image_type,
                           @Cast("cl_uint") int num_entries,
                           cl_image_format image_formats,
                           @Cast("cl_uint*") IntPointer num_image_formats);
public static native @Cast("cl_int") int clGetSupportedImageFormats(_cl_context context,
                           @Cast("cl_mem_flags") long flags,
                           @Cast("cl_mem_object_type") int image_type,
                           @Cast("cl_uint") int num_entries,
                           cl_image_format image_formats,
                           @Cast("cl_uint*") IntBuffer num_image_formats);
public static native @Cast("cl_int") int clGetSupportedImageFormats(_cl_context context,
                           @Cast("cl_mem_flags") long flags,
                           @Cast("cl_mem_object_type") int image_type,
                           @Cast("cl_uint") int num_entries,
                           cl_image_format image_formats,
                           @Cast("cl_uint*") int[] num_image_formats);

public static native @Cast("cl_int") int clGetMemObjectInfo(_cl_mem memobj,
                   @Cast("cl_mem_info") int param_name,
                   @Cast("size_t") long param_value_size,
                   Pointer param_value,
                   @Cast("size_t*") SizeTPointer param_value_size_ret);

public static native @Cast("cl_int") int clGetImageInfo(_cl_mem image,
               @Cast("cl_image_info") int param_name,
               @Cast("size_t") long param_value_size,
               Pointer param_value,
               @Cast("size_t*") SizeTPointer param_value_size_ret);

// #ifdef CL_VERSION_2_0

public static native @Cast("cl_int") int clGetPipeInfo(_cl_mem pipe,
              @Cast("cl_pipe_info") int param_name,
              @Cast("size_t") long param_value_size,
              Pointer param_value,
              @Cast("size_t*") SizeTPointer param_value_size_ret);
// Targeting ..\Pfn_notify__cl_mem_Pointer.java


public static native @Cast("cl_int") int clSetMemObjectDestructorCallback(_cl_mem memobj,
                                 Pfn_notify__cl_mem_Pointer pfn_notify,
                                 Pointer user_data);

// #endif

/* SVM Allocation APIs */

// #ifdef CL_VERSION_2_0

public static native Pointer clSVMAlloc(_cl_context context,
           @Cast("cl_svm_mem_flags") long flags,
           @Cast("size_t") long size,
           @Cast("cl_uint") int alignment);

public static native void clSVMFree(_cl_context context,
          Pointer svm_pointer);

// #endif

/* Sampler APIs */

// #ifdef CL_VERSION_2_0

public static native _cl_sampler clCreateSamplerWithProperties(_cl_context context,
                              @Cast("const cl_sampler_properties*") LongPointer sampler_properties,
                              @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_sampler clCreateSamplerWithProperties(_cl_context context,
                              @Cast("const cl_sampler_properties*") LongBuffer sampler_properties,
                              @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_sampler clCreateSamplerWithProperties(_cl_context context,
                              @Cast("const cl_sampler_properties*") long[] sampler_properties,
                              @Cast("cl_int*") int[] errcode_ret);

// #endif

public static native @Cast("cl_int") int clRetainSampler(_cl_sampler sampler);

public static native @Cast("cl_int") int clReleaseSampler(_cl_sampler sampler);

public static native @Cast("cl_int") int clGetSamplerInfo(_cl_sampler sampler,
                 @Cast("cl_sampler_info") int param_name,
                 @Cast("size_t") long param_value_size,
                 Pointer param_value,
                 @Cast("size_t*") SizeTPointer param_value_size_ret);

/* Program Object APIs */
public static native _cl_program clCreateProgramWithSource(_cl_context context,
                          @Cast("cl_uint") int count,
                          @Cast("const char**") PointerPointer strings,
                          @Cast("const size_t*") SizeTPointer lengths,
                          @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_program clCreateProgramWithSource(_cl_context context,
                          @Cast("cl_uint") int count,
                          @Cast("const char**") @ByPtrPtr BytePointer strings,
                          @Cast("const size_t*") SizeTPointer lengths,
                          @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_program clCreateProgramWithSource(_cl_context context,
                          @Cast("cl_uint") int count,
                          @Cast("const char**") @ByPtrPtr ByteBuffer strings,
                          @Cast("const size_t*") SizeTPointer lengths,
                          @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_program clCreateProgramWithSource(_cl_context context,
                          @Cast("cl_uint") int count,
                          @Cast("const char**") @ByPtrPtr byte[] strings,
                          @Cast("const size_t*") SizeTPointer lengths,
                          @Cast("cl_int*") int[] errcode_ret);

public static native _cl_program clCreateProgramWithBinary(_cl_context context,
                          @Cast("cl_uint") int num_devices,
                          @Cast("const cl_device_id*") PointerPointer device_list,
                          @Cast("const size_t*") SizeTPointer lengths,
                          @Cast("const unsigned char**") PointerPointer binaries,
                          @Cast("cl_int*") IntPointer binary_status,
                          @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_program clCreateProgramWithBinary(_cl_context context,
                          @Cast("cl_uint") int num_devices,
                          @Cast("const cl_device_id*") PointerPointer device_list,
                          @Cast("const size_t*") SizeTPointer lengths,
                          @Cast("const unsigned char**") @ByPtrPtr BytePointer binaries,
                          @Cast("cl_int*") IntPointer binary_status,
                          @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_program clCreateProgramWithBinary(_cl_context context,
                          @Cast("cl_uint") int num_devices,
                          @Cast("const cl_device_id*") @ByPtrPtr _cl_device_id device_list,
                          @Cast("const size_t*") SizeTPointer lengths,
                          @Cast("const unsigned char**") @ByPtrPtr ByteBuffer binaries,
                          @Cast("cl_int*") IntBuffer binary_status,
                          @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_program clCreateProgramWithBinary(_cl_context context,
                          @Cast("cl_uint") int num_devices,
                          @Cast("const cl_device_id*") PointerPointer device_list,
                          @Cast("const size_t*") SizeTPointer lengths,
                          @Cast("const unsigned char**") @ByPtrPtr byte[] binaries,
                          @Cast("cl_int*") int[] binary_status,
                          @Cast("cl_int*") int[] errcode_ret);
public static native _cl_program clCreateProgramWithBinary(_cl_context context,
                          @Cast("cl_uint") int num_devices,
                          @Cast("const cl_device_id*") @ByPtrPtr _cl_device_id device_list,
                          @Cast("const size_t*") SizeTPointer lengths,
                          @Cast("const unsigned char**") @ByPtrPtr BytePointer binaries,
                          @Cast("cl_int*") IntPointer binary_status,
                          @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_program clCreateProgramWithBinary(_cl_context context,
                          @Cast("cl_uint") int num_devices,
                          @Cast("const cl_device_id*") PointerPointer device_list,
                          @Cast("const size_t*") SizeTPointer lengths,
                          @Cast("const unsigned char**") @ByPtrPtr ByteBuffer binaries,
                          @Cast("cl_int*") IntBuffer binary_status,
                          @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_program clCreateProgramWithBinary(_cl_context context,
                          @Cast("cl_uint") int num_devices,
                          @Cast("const cl_device_id*") @ByPtrPtr _cl_device_id device_list,
                          @Cast("const size_t*") SizeTPointer lengths,
                          @Cast("const unsigned char**") @ByPtrPtr byte[] binaries,
                          @Cast("cl_int*") int[] binary_status,
                          @Cast("cl_int*") int[] errcode_ret);

// #ifdef CL_VERSION_1_2

public static native _cl_program clCreateProgramWithBuiltInKernels(_cl_context context,
                                  @Cast("cl_uint") int num_devices,
                                  @Cast("const cl_device_id*") PointerPointer device_list,
                                  @Cast("const char*") BytePointer kernel_names,
                                  @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_program clCreateProgramWithBuiltInKernels(_cl_context context,
                                  @Cast("cl_uint") int num_devices,
                                  @Cast("const cl_device_id*") @ByPtrPtr _cl_device_id device_list,
                                  String kernel_names,
                                  @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_program clCreateProgramWithBuiltInKernels(_cl_context context,
                                  @Cast("cl_uint") int num_devices,
                                  @Cast("const cl_device_id*") PointerPointer device_list,
                                  @Cast("const char*") BytePointer kernel_names,
                                  @Cast("cl_int*") int[] errcode_ret);
public static native _cl_program clCreateProgramWithBuiltInKernels(_cl_context context,
                                  @Cast("cl_uint") int num_devices,
                                  @Cast("const cl_device_id*") @ByPtrPtr _cl_device_id device_list,
                                  String kernel_names,
                                  @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_program clCreateProgramWithBuiltInKernels(_cl_context context,
                                  @Cast("cl_uint") int num_devices,
                                  @Cast("const cl_device_id*") PointerPointer device_list,
                                  @Cast("const char*") BytePointer kernel_names,
                                  @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_program clCreateProgramWithBuiltInKernels(_cl_context context,
                                  @Cast("cl_uint") int num_devices,
                                  @Cast("const cl_device_id*") @ByPtrPtr _cl_device_id device_list,
                                  String kernel_names,
                                  @Cast("cl_int*") int[] errcode_ret);

// #endif

// #ifdef CL_VERSION_2_1

public static native _cl_program clCreateProgramWithIL(_cl_context context,
                     @Const Pointer il,
                     @Cast("size_t") long length,
                     @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_program clCreateProgramWithIL(_cl_context context,
                     @Const Pointer il,
                     @Cast("size_t") long length,
                     @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_program clCreateProgramWithIL(_cl_context context,
                     @Const Pointer il,
                     @Cast("size_t") long length,
                     @Cast("cl_int*") int[] errcode_ret);

// #endif

public static native @Cast("cl_int") int clRetainProgram(_cl_program program);

public static native @Cast("cl_int") int clReleaseProgram(_cl_program program);
// Targeting ..\Pfn_notify__cl_program_Pointer.java


public static native @Cast("cl_int") int clBuildProgram(_cl_program program,
               @Cast("cl_uint") int num_devices,
               @Cast("const cl_device_id*") PointerPointer device_list,
               @Cast("const char*") BytePointer options,
               Pfn_notify__cl_program_Pointer pfn_notify,
               Pointer user_data);
public static native @Cast("cl_int") int clBuildProgram(_cl_program program,
               @Cast("cl_uint") int num_devices,
               @Cast("const cl_device_id*") @ByPtrPtr _cl_device_id device_list,
               String options,
               Pfn_notify__cl_program_Pointer pfn_notify,
               Pointer user_data);

// #ifdef CL_VERSION_1_2

public static native @Cast("cl_int") int clCompileProgram(_cl_program program,
                 @Cast("cl_uint") int num_devices,
                 @Cast("const cl_device_id*") PointerPointer device_list,
                 @Cast("const char*") BytePointer options,
                 @Cast("cl_uint") int num_input_headers,
                 @Cast("const cl_program*") PointerPointer input_headers,
                 @Cast("const char**") PointerPointer header_include_names,
                 Pfn_notify__cl_program_Pointer pfn_notify,
                 Pointer user_data);
public static native @Cast("cl_int") int clCompileProgram(_cl_program program,
                 @Cast("cl_uint") int num_devices,
                 @Cast("const cl_device_id*") PointerPointer device_list,
                 @Cast("const char*") BytePointer options,
                 @Cast("cl_uint") int num_input_headers,
                 @Cast("const cl_program*") PointerPointer input_headers,
                 @Cast("const char**") @ByPtrPtr BytePointer header_include_names,
                 Pfn_notify__cl_program_Pointer pfn_notify,
                 Pointer user_data);
public static native @Cast("cl_int") int clCompileProgram(_cl_program program,
                 @Cast("cl_uint") int num_devices,
                 @Cast("const cl_device_id*") @ByPtrPtr _cl_device_id device_list,
                 String options,
                 @Cast("cl_uint") int num_input_headers,
                 @Cast("const cl_program*") @ByPtrPtr _cl_program input_headers,
                 @Cast("const char**") @ByPtrPtr ByteBuffer header_include_names,
                 Pfn_notify__cl_program_Pointer pfn_notify,
                 Pointer user_data);
public static native @Cast("cl_int") int clCompileProgram(_cl_program program,
                 @Cast("cl_uint") int num_devices,
                 @Cast("const cl_device_id*") PointerPointer device_list,
                 @Cast("const char*") BytePointer options,
                 @Cast("cl_uint") int num_input_headers,
                 @Cast("const cl_program*") PointerPointer input_headers,
                 @Cast("const char**") @ByPtrPtr byte[] header_include_names,
                 Pfn_notify__cl_program_Pointer pfn_notify,
                 Pointer user_data);
public static native @Cast("cl_int") int clCompileProgram(_cl_program program,
                 @Cast("cl_uint") int num_devices,
                 @Cast("const cl_device_id*") @ByPtrPtr _cl_device_id device_list,
                 String options,
                 @Cast("cl_uint") int num_input_headers,
                 @Cast("const cl_program*") @ByPtrPtr _cl_program input_headers,
                 @Cast("const char**") @ByPtrPtr BytePointer header_include_names,
                 Pfn_notify__cl_program_Pointer pfn_notify,
                 Pointer user_data);
public static native @Cast("cl_int") int clCompileProgram(_cl_program program,
                 @Cast("cl_uint") int num_devices,
                 @Cast("const cl_device_id*") PointerPointer device_list,
                 @Cast("const char*") BytePointer options,
                 @Cast("cl_uint") int num_input_headers,
                 @Cast("const cl_program*") PointerPointer input_headers,
                 @Cast("const char**") @ByPtrPtr ByteBuffer header_include_names,
                 Pfn_notify__cl_program_Pointer pfn_notify,
                 Pointer user_data);
public static native @Cast("cl_int") int clCompileProgram(_cl_program program,
                 @Cast("cl_uint") int num_devices,
                 @Cast("const cl_device_id*") @ByPtrPtr _cl_device_id device_list,
                 String options,
                 @Cast("cl_uint") int num_input_headers,
                 @Cast("const cl_program*") @ByPtrPtr _cl_program input_headers,
                 @Cast("const char**") @ByPtrPtr byte[] header_include_names,
                 Pfn_notify__cl_program_Pointer pfn_notify,
                 Pointer user_data);

public static native _cl_program clLinkProgram(_cl_context context,
              @Cast("cl_uint") int num_devices,
              @Cast("const cl_device_id*") PointerPointer device_list,
              @Cast("const char*") BytePointer options,
              @Cast("cl_uint") int num_input_programs,
              @Cast("const cl_program*") PointerPointer input_programs,
              Pfn_notify__cl_program_Pointer pfn_notify,
              Pointer user_data,
              @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_program clLinkProgram(_cl_context context,
              @Cast("cl_uint") int num_devices,
              @Cast("const cl_device_id*") @ByPtrPtr _cl_device_id device_list,
              String options,
              @Cast("cl_uint") int num_input_programs,
              @Cast("const cl_program*") @ByPtrPtr _cl_program input_programs,
              Pfn_notify__cl_program_Pointer pfn_notify,
              Pointer user_data,
              @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_program clLinkProgram(_cl_context context,
              @Cast("cl_uint") int num_devices,
              @Cast("const cl_device_id*") PointerPointer device_list,
              @Cast("const char*") BytePointer options,
              @Cast("cl_uint") int num_input_programs,
              @Cast("const cl_program*") PointerPointer input_programs,
              Pfn_notify__cl_program_Pointer pfn_notify,
              Pointer user_data,
              @Cast("cl_int*") int[] errcode_ret);
public static native _cl_program clLinkProgram(_cl_context context,
              @Cast("cl_uint") int num_devices,
              @Cast("const cl_device_id*") @ByPtrPtr _cl_device_id device_list,
              String options,
              @Cast("cl_uint") int num_input_programs,
              @Cast("const cl_program*") @ByPtrPtr _cl_program input_programs,
              Pfn_notify__cl_program_Pointer pfn_notify,
              Pointer user_data,
              @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_program clLinkProgram(_cl_context context,
              @Cast("cl_uint") int num_devices,
              @Cast("const cl_device_id*") PointerPointer device_list,
              @Cast("const char*") BytePointer options,
              @Cast("cl_uint") int num_input_programs,
              @Cast("const cl_program*") PointerPointer input_programs,
              Pfn_notify__cl_program_Pointer pfn_notify,
              Pointer user_data,
              @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_program clLinkProgram(_cl_context context,
              @Cast("cl_uint") int num_devices,
              @Cast("const cl_device_id*") @ByPtrPtr _cl_device_id device_list,
              String options,
              @Cast("cl_uint") int num_input_programs,
              @Cast("const cl_program*") @ByPtrPtr _cl_program input_programs,
              Pfn_notify__cl_program_Pointer pfn_notify,
              Pointer user_data,
              @Cast("cl_int*") int[] errcode_ret);

// #endif

// #ifdef CL_VERSION_2_2

public static native @Cast("cl_int") @Deprecated int clSetProgramReleaseCallback(_cl_program program,
                            Pfn_notify__cl_program_Pointer pfn_notify,
                            Pointer user_data);

public static native @Cast("cl_int") int clSetProgramSpecializationConstant(_cl_program program,
                                   @Cast("cl_uint") int spec_id,
                                   @Cast("size_t") long spec_size,
                                   @Const Pointer spec_value);

// #endif

// #ifdef CL_VERSION_1_2

public static native @Cast("cl_int") int clUnloadPlatformCompiler(_cl_platform_id platform);

// #endif

public static native @Cast("cl_int") int clGetProgramInfo(_cl_program program,
                 @Cast("cl_program_info") int param_name,
                 @Cast("size_t") long param_value_size,
                 Pointer param_value,
                 @Cast("size_t*") SizeTPointer param_value_size_ret);

public static native @Cast("cl_int") int clGetProgramBuildInfo(_cl_program program,
                      _cl_device_id device,
                      @Cast("cl_program_build_info") int param_name,
                      @Cast("size_t") long param_value_size,
                      Pointer param_value,
                      @Cast("size_t*") SizeTPointer param_value_size_ret);

/* Kernel Object APIs */
public static native _cl_kernel clCreateKernel(_cl_program program,
               @Cast("const char*") BytePointer kernel_name,
               @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_kernel clCreateKernel(_cl_program program,
               String kernel_name,
               @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_kernel clCreateKernel(_cl_program program,
               @Cast("const char*") BytePointer kernel_name,
               @Cast("cl_int*") int[] errcode_ret);
public static native _cl_kernel clCreateKernel(_cl_program program,
               String kernel_name,
               @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_kernel clCreateKernel(_cl_program program,
               @Cast("const char*") BytePointer kernel_name,
               @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_kernel clCreateKernel(_cl_program program,
               String kernel_name,
               @Cast("cl_int*") int[] errcode_ret);

public static native @Cast("cl_int") int clCreateKernelsInProgram(_cl_program program,
                         @Cast("cl_uint") int num_kernels,
                         @Cast("cl_kernel*") PointerPointer kernels,
                         @Cast("cl_uint*") IntPointer num_kernels_ret);
public static native @Cast("cl_int") int clCreateKernelsInProgram(_cl_program program,
                         @Cast("cl_uint") int num_kernels,
                         @ByPtrPtr _cl_kernel kernels,
                         @Cast("cl_uint*") IntBuffer num_kernels_ret);
public static native @Cast("cl_int") int clCreateKernelsInProgram(_cl_program program,
                         @Cast("cl_uint") int num_kernels,
                         @Cast("cl_kernel*") PointerPointer kernels,
                         @Cast("cl_uint*") int[] num_kernels_ret);
public static native @Cast("cl_int") int clCreateKernelsInProgram(_cl_program program,
                         @Cast("cl_uint") int num_kernels,
                         @ByPtrPtr _cl_kernel kernels,
                         @Cast("cl_uint*") IntPointer num_kernels_ret);
public static native @Cast("cl_int") int clCreateKernelsInProgram(_cl_program program,
                         @Cast("cl_uint") int num_kernels,
                         @Cast("cl_kernel*") PointerPointer kernels,
                         @Cast("cl_uint*") IntBuffer num_kernels_ret);
public static native @Cast("cl_int") int clCreateKernelsInProgram(_cl_program program,
                         @Cast("cl_uint") int num_kernels,
                         @ByPtrPtr _cl_kernel kernels,
                         @Cast("cl_uint*") int[] num_kernels_ret);

// #ifdef CL_VERSION_2_1

public static native _cl_kernel clCloneKernel(_cl_kernel source_kernel,
              @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_kernel clCloneKernel(_cl_kernel source_kernel,
              @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_kernel clCloneKernel(_cl_kernel source_kernel,
              @Cast("cl_int*") int[] errcode_ret);

// #endif

public static native @Cast("cl_int") int clRetainKernel(_cl_kernel kernel);

public static native @Cast("cl_int") int clReleaseKernel(_cl_kernel kernel);

public static native @Cast("cl_int") int clSetKernelArg(_cl_kernel kernel,
               @Cast("cl_uint") int arg_index,
               @Cast("size_t") long arg_size,
               @Const Pointer arg_value);

// #ifdef CL_VERSION_2_0

public static native @Cast("cl_int") int clSetKernelArgSVMPointer(_cl_kernel kernel,
                         @Cast("cl_uint") int arg_index,
                         @Const Pointer arg_value);

public static native @Cast("cl_int") int clSetKernelExecInfo(_cl_kernel kernel,
                    @Cast("cl_kernel_exec_info") int param_name,
                    @Cast("size_t") long param_value_size,
                    @Const Pointer param_value);

// #endif

public static native @Cast("cl_int") int clGetKernelInfo(_cl_kernel kernel,
                @Cast("cl_kernel_info") int param_name,
                @Cast("size_t") long param_value_size,
                Pointer param_value,
                @Cast("size_t*") SizeTPointer param_value_size_ret);

// #ifdef CL_VERSION_1_2

public static native @Cast("cl_int") int clGetKernelArgInfo(_cl_kernel kernel,
                   @Cast("cl_uint") int arg_indx,
                   @Cast("cl_kernel_arg_info") int param_name,
                   @Cast("size_t") long param_value_size,
                   Pointer param_value,
                   @Cast("size_t*") SizeTPointer param_value_size_ret);

// #endif

public static native @Cast("cl_int") int clGetKernelWorkGroupInfo(_cl_kernel kernel,
                         _cl_device_id device,
                         @Cast("cl_kernel_work_group_info") int param_name,
                         @Cast("size_t") long param_value_size,
                         Pointer param_value,
                         @Cast("size_t*") SizeTPointer param_value_size_ret);

// #ifdef CL_VERSION_2_1

public static native @Cast("cl_int") int clGetKernelSubGroupInfo(_cl_kernel kernel,
                        _cl_device_id device,
                        @Cast("cl_kernel_sub_group_info") int param_name,
                        @Cast("size_t") long input_value_size,
                        @Const Pointer input_value,
                        @Cast("size_t") long param_value_size,
                        Pointer param_value,
                        @Cast("size_t*") SizeTPointer param_value_size_ret);

// #endif

/* Event Object APIs */
public static native @Cast("cl_int") int clWaitForEvents(@Cast("cl_uint") int num_events,
                @Cast("const cl_event*") PointerPointer event_list);
public static native @Cast("cl_int") int clWaitForEvents(@Cast("cl_uint") int num_events,
                @Cast("const cl_event*") @ByPtrPtr _cl_event event_list);

public static native @Cast("cl_int") int clGetEventInfo(_cl_event event,
               @Cast("cl_event_info") int param_name,
               @Cast("size_t") long param_value_size,
               Pointer param_value,
               @Cast("size_t*") SizeTPointer param_value_size_ret);

// #ifdef CL_VERSION_1_1

public static native _cl_event clCreateUserEvent(_cl_context context,
                  @Cast("cl_int*") IntPointer errcode_ret);
public static native _cl_event clCreateUserEvent(_cl_context context,
                  @Cast("cl_int*") IntBuffer errcode_ret);
public static native _cl_event clCreateUserEvent(_cl_context context,
                  @Cast("cl_int*") int[] errcode_ret);

// #endif

public static native @Cast("cl_int") int clRetainEvent(_cl_event event);

public static native @Cast("cl_int") int clReleaseEvent(_cl_event event);

// #ifdef CL_VERSION_1_1

public static native @Cast("cl_int") int clSetUserEventStatus(_cl_event event,
                     @Cast("cl_int") int execution_status);
// Targeting ..\Pfn_notify__cl_event_int_Pointer.java


public static native @Cast("cl_int") int clSetEventCallback(_cl_event event,
                   @Cast("cl_int") int command_exec_callback_type,
                   Pfn_notify__cl_event_int_Pointer pfn_notify,
                   Pointer user_data);

// #endif

/* Profiling APIs */
public static native @Cast("cl_int") int clGetEventProfilingInfo(_cl_event event,
                        @Cast("cl_profiling_info") int param_name,
                        @Cast("size_t") long param_value_size,
                        Pointer param_value,
                        @Cast("size_t*") SizeTPointer param_value_size_ret);

/* Flush and Finish APIs */
public static native @Cast("cl_int") int clFlush(_cl_command_queue command_queue);

public static native @Cast("cl_int") int clFinish(_cl_command_queue command_queue);

/* Enqueued Commands APIs */
public static native @Cast("cl_int") int clEnqueueReadBuffer(_cl_command_queue command_queue,
                    _cl_mem buffer,
                    @Cast("cl_bool") int blocking_read,
                    @Cast("size_t") long offset,
                    @Cast("size_t") long size,
                    Pointer ptr,
                    @Cast("cl_uint") int num_events_in_wait_list,
                    @Cast("const cl_event*") PointerPointer event_wait_list,
                    @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueReadBuffer(_cl_command_queue command_queue,
                    _cl_mem buffer,
                    @Cast("cl_bool") int blocking_read,
                    @Cast("size_t") long offset,
                    @Cast("size_t") long size,
                    Pointer ptr,
                    @Cast("cl_uint") int num_events_in_wait_list,
                    @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                    @ByPtrPtr _cl_event event);

// #ifdef CL_VERSION_1_1

public static native @Cast("cl_int") int clEnqueueReadBufferRect(_cl_command_queue command_queue,
                        _cl_mem buffer,
                        @Cast("cl_bool") int blocking_read,
                        @Cast("const size_t*") SizeTPointer buffer_origin,
                        @Cast("const size_t*") SizeTPointer host_origin,
                        @Cast("const size_t*") SizeTPointer region,
                        @Cast("size_t") long buffer_row_pitch,
                        @Cast("size_t") long buffer_slice_pitch,
                        @Cast("size_t") long host_row_pitch,
                        @Cast("size_t") long host_slice_pitch,
                        Pointer ptr,
                        @Cast("cl_uint") int num_events_in_wait_list,
                        @Cast("const cl_event*") PointerPointer event_wait_list,
                        @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueReadBufferRect(_cl_command_queue command_queue,
                        _cl_mem buffer,
                        @Cast("cl_bool") int blocking_read,
                        @Cast("const size_t*") SizeTPointer buffer_origin,
                        @Cast("const size_t*") SizeTPointer host_origin,
                        @Cast("const size_t*") SizeTPointer region,
                        @Cast("size_t") long buffer_row_pitch,
                        @Cast("size_t") long buffer_slice_pitch,
                        @Cast("size_t") long host_row_pitch,
                        @Cast("size_t") long host_slice_pitch,
                        Pointer ptr,
                        @Cast("cl_uint") int num_events_in_wait_list,
                        @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                        @ByPtrPtr _cl_event event);

// #endif

public static native @Cast("cl_int") int clEnqueueWriteBuffer(_cl_command_queue command_queue,
                     _cl_mem buffer,
                     @Cast("cl_bool") int blocking_write,
                     @Cast("size_t") long offset,
                     @Cast("size_t") long size,
                     @Const Pointer ptr,
                     @Cast("cl_uint") int num_events_in_wait_list,
                     @Cast("const cl_event*") PointerPointer event_wait_list,
                     @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueWriteBuffer(_cl_command_queue command_queue,
                     _cl_mem buffer,
                     @Cast("cl_bool") int blocking_write,
                     @Cast("size_t") long offset,
                     @Cast("size_t") long size,
                     @Const Pointer ptr,
                     @Cast("cl_uint") int num_events_in_wait_list,
                     @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                     @ByPtrPtr _cl_event event);

// #ifdef CL_VERSION_1_1

public static native @Cast("cl_int") int clEnqueueWriteBufferRect(_cl_command_queue command_queue,
                         _cl_mem buffer,
                         @Cast("cl_bool") int blocking_write,
                         @Cast("const size_t*") SizeTPointer buffer_origin,
                         @Cast("const size_t*") SizeTPointer host_origin,
                         @Cast("const size_t*") SizeTPointer region,
                         @Cast("size_t") long buffer_row_pitch,
                         @Cast("size_t") long buffer_slice_pitch,
                         @Cast("size_t") long host_row_pitch,
                         @Cast("size_t") long host_slice_pitch,
                         @Const Pointer ptr,
                         @Cast("cl_uint") int num_events_in_wait_list,
                         @Cast("const cl_event*") PointerPointer event_wait_list,
                         @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueWriteBufferRect(_cl_command_queue command_queue,
                         _cl_mem buffer,
                         @Cast("cl_bool") int blocking_write,
                         @Cast("const size_t*") SizeTPointer buffer_origin,
                         @Cast("const size_t*") SizeTPointer host_origin,
                         @Cast("const size_t*") SizeTPointer region,
                         @Cast("size_t") long buffer_row_pitch,
                         @Cast("size_t") long buffer_slice_pitch,
                         @Cast("size_t") long host_row_pitch,
                         @Cast("size_t") long host_slice_pitch,
                         @Const Pointer ptr,
                         @Cast("cl_uint") int num_events_in_wait_list,
                         @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                         @ByPtrPtr _cl_event event);

// #endif

// #ifdef CL_VERSION_1_2

public static native @Cast("cl_int") int clEnqueueFillBuffer(_cl_command_queue command_queue,
                    _cl_mem buffer,
                    @Const Pointer pattern,
                    @Cast("size_t") long pattern_size,
                    @Cast("size_t") long offset,
                    @Cast("size_t") long size,
                    @Cast("cl_uint") int num_events_in_wait_list,
                    @Cast("const cl_event*") PointerPointer event_wait_list,
                    @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueFillBuffer(_cl_command_queue command_queue,
                    _cl_mem buffer,
                    @Const Pointer pattern,
                    @Cast("size_t") long pattern_size,
                    @Cast("size_t") long offset,
                    @Cast("size_t") long size,
                    @Cast("cl_uint") int num_events_in_wait_list,
                    @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                    @ByPtrPtr _cl_event event);

// #endif

public static native @Cast("cl_int") int clEnqueueCopyBuffer(_cl_command_queue command_queue,
                    _cl_mem src_buffer,
                    _cl_mem dst_buffer,
                    @Cast("size_t") long src_offset,
                    @Cast("size_t") long dst_offset,
                    @Cast("size_t") long size,
                    @Cast("cl_uint") int num_events_in_wait_list,
                    @Cast("const cl_event*") PointerPointer event_wait_list,
                    @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueCopyBuffer(_cl_command_queue command_queue,
                    _cl_mem src_buffer,
                    _cl_mem dst_buffer,
                    @Cast("size_t") long src_offset,
                    @Cast("size_t") long dst_offset,
                    @Cast("size_t") long size,
                    @Cast("cl_uint") int num_events_in_wait_list,
                    @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                    @ByPtrPtr _cl_event event);

// #ifdef CL_VERSION_1_1

public static native @Cast("cl_int") int clEnqueueCopyBufferRect(_cl_command_queue command_queue,
                        _cl_mem src_buffer,
                        _cl_mem dst_buffer,
                        @Cast("const size_t*") SizeTPointer src_origin,
                        @Cast("const size_t*") SizeTPointer dst_origin,
                        @Cast("const size_t*") SizeTPointer region,
                        @Cast("size_t") long src_row_pitch,
                        @Cast("size_t") long src_slice_pitch,
                        @Cast("size_t") long dst_row_pitch,
                        @Cast("size_t") long dst_slice_pitch,
                        @Cast("cl_uint") int num_events_in_wait_list,
                        @Cast("const cl_event*") PointerPointer event_wait_list,
                        @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueCopyBufferRect(_cl_command_queue command_queue,
                        _cl_mem src_buffer,
                        _cl_mem dst_buffer,
                        @Cast("const size_t*") SizeTPointer src_origin,
                        @Cast("const size_t*") SizeTPointer dst_origin,
                        @Cast("const size_t*") SizeTPointer region,
                        @Cast("size_t") long src_row_pitch,
                        @Cast("size_t") long src_slice_pitch,
                        @Cast("size_t") long dst_row_pitch,
                        @Cast("size_t") long dst_slice_pitch,
                        @Cast("cl_uint") int num_events_in_wait_list,
                        @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                        @ByPtrPtr _cl_event event);

// #endif

public static native @Cast("cl_int") int clEnqueueReadImage(_cl_command_queue command_queue,
                   _cl_mem image,
                   @Cast("cl_bool") int blocking_read,
                   @Cast("const size_t*") SizeTPointer origin,
                   @Cast("const size_t*") SizeTPointer region,
                   @Cast("size_t") long row_pitch,
                   @Cast("size_t") long slice_pitch,
                   Pointer ptr,
                   @Cast("cl_uint") int num_events_in_wait_list,
                   @Cast("const cl_event*") PointerPointer event_wait_list,
                   @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueReadImage(_cl_command_queue command_queue,
                   _cl_mem image,
                   @Cast("cl_bool") int blocking_read,
                   @Cast("const size_t*") SizeTPointer origin,
                   @Cast("const size_t*") SizeTPointer region,
                   @Cast("size_t") long row_pitch,
                   @Cast("size_t") long slice_pitch,
                   Pointer ptr,
                   @Cast("cl_uint") int num_events_in_wait_list,
                   @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                   @ByPtrPtr _cl_event event);

public static native @Cast("cl_int") int clEnqueueWriteImage(_cl_command_queue command_queue,
                    _cl_mem image,
                    @Cast("cl_bool") int blocking_write,
                    @Cast("const size_t*") SizeTPointer origin,
                    @Cast("const size_t*") SizeTPointer region,
                    @Cast("size_t") long input_row_pitch,
                    @Cast("size_t") long input_slice_pitch,
                    @Const Pointer ptr,
                    @Cast("cl_uint") int num_events_in_wait_list,
                    @Cast("const cl_event*") PointerPointer event_wait_list,
                    @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueWriteImage(_cl_command_queue command_queue,
                    _cl_mem image,
                    @Cast("cl_bool") int blocking_write,
                    @Cast("const size_t*") SizeTPointer origin,
                    @Cast("const size_t*") SizeTPointer region,
                    @Cast("size_t") long input_row_pitch,
                    @Cast("size_t") long input_slice_pitch,
                    @Const Pointer ptr,
                    @Cast("cl_uint") int num_events_in_wait_list,
                    @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                    @ByPtrPtr _cl_event event);

// #ifdef CL_VERSION_1_2

public static native @Cast("cl_int") int clEnqueueFillImage(_cl_command_queue command_queue,
                   _cl_mem image,
                   @Const Pointer fill_color,
                   @Cast("const size_t*") SizeTPointer origin,
                   @Cast("const size_t*") SizeTPointer region,
                   @Cast("cl_uint") int num_events_in_wait_list,
                   @Cast("const cl_event*") PointerPointer event_wait_list,
                   @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueFillImage(_cl_command_queue command_queue,
                   _cl_mem image,
                   @Const Pointer fill_color,
                   @Cast("const size_t*") SizeTPointer origin,
                   @Cast("const size_t*") SizeTPointer region,
                   @Cast("cl_uint") int num_events_in_wait_list,
                   @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                   @ByPtrPtr _cl_event event);

// #endif

public static native @Cast("cl_int") int clEnqueueCopyImage(_cl_command_queue command_queue,
                   _cl_mem src_image,
                   _cl_mem dst_image,
                   @Cast("const size_t*") SizeTPointer src_origin,
                   @Cast("const size_t*") SizeTPointer dst_origin,
                   @Cast("const size_t*") SizeTPointer region,
                   @Cast("cl_uint") int num_events_in_wait_list,
                   @Cast("const cl_event*") PointerPointer event_wait_list,
                   @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueCopyImage(_cl_command_queue command_queue,
                   _cl_mem src_image,
                   _cl_mem dst_image,
                   @Cast("const size_t*") SizeTPointer src_origin,
                   @Cast("const size_t*") SizeTPointer dst_origin,
                   @Cast("const size_t*") SizeTPointer region,
                   @Cast("cl_uint") int num_events_in_wait_list,
                   @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                   @ByPtrPtr _cl_event event);

public static native @Cast("cl_int") int clEnqueueCopyImageToBuffer(_cl_command_queue command_queue,
                           _cl_mem src_image,
                           _cl_mem dst_buffer,
                           @Cast("const size_t*") SizeTPointer src_origin,
                           @Cast("const size_t*") SizeTPointer region,
                           @Cast("size_t") long dst_offset,
                           @Cast("cl_uint") int num_events_in_wait_list,
                           @Cast("const cl_event*") PointerPointer event_wait_list,
                           @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueCopyImageToBuffer(_cl_command_queue command_queue,
                           _cl_mem src_image,
                           _cl_mem dst_buffer,
                           @Cast("const size_t*") SizeTPointer src_origin,
                           @Cast("const size_t*") SizeTPointer region,
                           @Cast("size_t") long dst_offset,
                           @Cast("cl_uint") int num_events_in_wait_list,
                           @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                           @ByPtrPtr _cl_event event);

public static native @Cast("cl_int") int clEnqueueCopyBufferToImage(_cl_command_queue command_queue,
                           _cl_mem src_buffer,
                           _cl_mem dst_image,
                           @Cast("size_t") long src_offset,
                           @Cast("const size_t*") SizeTPointer dst_origin,
                           @Cast("const size_t*") SizeTPointer region,
                           @Cast("cl_uint") int num_events_in_wait_list,
                           @Cast("const cl_event*") PointerPointer event_wait_list,
                           @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueCopyBufferToImage(_cl_command_queue command_queue,
                           _cl_mem src_buffer,
                           _cl_mem dst_image,
                           @Cast("size_t") long src_offset,
                           @Cast("const size_t*") SizeTPointer dst_origin,
                           @Cast("const size_t*") SizeTPointer region,
                           @Cast("cl_uint") int num_events_in_wait_list,
                           @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                           @ByPtrPtr _cl_event event);

public static native Pointer clEnqueueMapBuffer(_cl_command_queue command_queue,
                   _cl_mem buffer,
                   @Cast("cl_bool") int blocking_map,
                   @Cast("cl_map_flags") long map_flags,
                   @Cast("size_t") long offset,
                   @Cast("size_t") long size,
                   @Cast("cl_uint") int num_events_in_wait_list,
                   @Cast("const cl_event*") PointerPointer event_wait_list,
                   @Cast("cl_event*") PointerPointer event,
                   @Cast("cl_int*") IntPointer errcode_ret);
public static native Pointer clEnqueueMapBuffer(_cl_command_queue command_queue,
                   _cl_mem buffer,
                   @Cast("cl_bool") int blocking_map,
                   @Cast("cl_map_flags") long map_flags,
                   @Cast("size_t") long offset,
                   @Cast("size_t") long size,
                   @Cast("cl_uint") int num_events_in_wait_list,
                   @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                   @ByPtrPtr _cl_event event,
                   @Cast("cl_int*") IntBuffer errcode_ret);
public static native Pointer clEnqueueMapBuffer(_cl_command_queue command_queue,
                   _cl_mem buffer,
                   @Cast("cl_bool") int blocking_map,
                   @Cast("cl_map_flags") long map_flags,
                   @Cast("size_t") long offset,
                   @Cast("size_t") long size,
                   @Cast("cl_uint") int num_events_in_wait_list,
                   @Cast("const cl_event*") PointerPointer event_wait_list,
                   @Cast("cl_event*") PointerPointer event,
                   @Cast("cl_int*") int[] errcode_ret);
public static native Pointer clEnqueueMapBuffer(_cl_command_queue command_queue,
                   _cl_mem buffer,
                   @Cast("cl_bool") int blocking_map,
                   @Cast("cl_map_flags") long map_flags,
                   @Cast("size_t") long offset,
                   @Cast("size_t") long size,
                   @Cast("cl_uint") int num_events_in_wait_list,
                   @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                   @ByPtrPtr _cl_event event,
                   @Cast("cl_int*") IntPointer errcode_ret);
public static native Pointer clEnqueueMapBuffer(_cl_command_queue command_queue,
                   _cl_mem buffer,
                   @Cast("cl_bool") int blocking_map,
                   @Cast("cl_map_flags") long map_flags,
                   @Cast("size_t") long offset,
                   @Cast("size_t") long size,
                   @Cast("cl_uint") int num_events_in_wait_list,
                   @Cast("const cl_event*") PointerPointer event_wait_list,
                   @Cast("cl_event*") PointerPointer event,
                   @Cast("cl_int*") IntBuffer errcode_ret);
public static native Pointer clEnqueueMapBuffer(_cl_command_queue command_queue,
                   _cl_mem buffer,
                   @Cast("cl_bool") int blocking_map,
                   @Cast("cl_map_flags") long map_flags,
                   @Cast("size_t") long offset,
                   @Cast("size_t") long size,
                   @Cast("cl_uint") int num_events_in_wait_list,
                   @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                   @ByPtrPtr _cl_event event,
                   @Cast("cl_int*") int[] errcode_ret);

public static native Pointer clEnqueueMapImage(_cl_command_queue command_queue,
                  _cl_mem image,
                  @Cast("cl_bool") int blocking_map,
                  @Cast("cl_map_flags") long map_flags,
                  @Cast("const size_t*") SizeTPointer origin,
                  @Cast("const size_t*") SizeTPointer region,
                  @Cast("size_t*") SizeTPointer image_row_pitch,
                  @Cast("size_t*") SizeTPointer image_slice_pitch,
                  @Cast("cl_uint") int num_events_in_wait_list,
                  @Cast("const cl_event*") PointerPointer event_wait_list,
                  @Cast("cl_event*") PointerPointer event,
                  @Cast("cl_int*") IntPointer errcode_ret);
public static native Pointer clEnqueueMapImage(_cl_command_queue command_queue,
                  _cl_mem image,
                  @Cast("cl_bool") int blocking_map,
                  @Cast("cl_map_flags") long map_flags,
                  @Cast("const size_t*") SizeTPointer origin,
                  @Cast("const size_t*") SizeTPointer region,
                  @Cast("size_t*") SizeTPointer image_row_pitch,
                  @Cast("size_t*") SizeTPointer image_slice_pitch,
                  @Cast("cl_uint") int num_events_in_wait_list,
                  @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                  @ByPtrPtr _cl_event event,
                  @Cast("cl_int*") IntBuffer errcode_ret);
public static native Pointer clEnqueueMapImage(_cl_command_queue command_queue,
                  _cl_mem image,
                  @Cast("cl_bool") int blocking_map,
                  @Cast("cl_map_flags") long map_flags,
                  @Cast("const size_t*") SizeTPointer origin,
                  @Cast("const size_t*") SizeTPointer region,
                  @Cast("size_t*") SizeTPointer image_row_pitch,
                  @Cast("size_t*") SizeTPointer image_slice_pitch,
                  @Cast("cl_uint") int num_events_in_wait_list,
                  @Cast("const cl_event*") PointerPointer event_wait_list,
                  @Cast("cl_event*") PointerPointer event,
                  @Cast("cl_int*") int[] errcode_ret);
public static native Pointer clEnqueueMapImage(_cl_command_queue command_queue,
                  _cl_mem image,
                  @Cast("cl_bool") int blocking_map,
                  @Cast("cl_map_flags") long map_flags,
                  @Cast("const size_t*") SizeTPointer origin,
                  @Cast("const size_t*") SizeTPointer region,
                  @Cast("size_t*") SizeTPointer image_row_pitch,
                  @Cast("size_t*") SizeTPointer image_slice_pitch,
                  @Cast("cl_uint") int num_events_in_wait_list,
                  @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                  @ByPtrPtr _cl_event event,
                  @Cast("cl_int*") IntPointer errcode_ret);
public static native Pointer clEnqueueMapImage(_cl_command_queue command_queue,
                  _cl_mem image,
                  @Cast("cl_bool") int blocking_map,
                  @Cast("cl_map_flags") long map_flags,
                  @Cast("const size_t*") SizeTPointer origin,
                  @Cast("const size_t*") SizeTPointer region,
                  @Cast("size_t*") SizeTPointer image_row_pitch,
                  @Cast("size_t*") SizeTPointer image_slice_pitch,
                  @Cast("cl_uint") int num_events_in_wait_list,
                  @Cast("const cl_event*") PointerPointer event_wait_list,
                  @Cast("cl_event*") PointerPointer event,
                  @Cast("cl_int*") IntBuffer errcode_ret);
public static native Pointer clEnqueueMapImage(_cl_command_queue command_queue,
                  _cl_mem image,
                  @Cast("cl_bool") int blocking_map,
                  @Cast("cl_map_flags") long map_flags,
                  @Cast("const size_t*") SizeTPointer origin,
                  @Cast("const size_t*") SizeTPointer region,
                  @Cast("size_t*") SizeTPointer image_row_pitch,
                  @Cast("size_t*") SizeTPointer image_slice_pitch,
                  @Cast("cl_uint") int num_events_in_wait_list,
                  @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                  @ByPtrPtr _cl_event event,
                  @Cast("cl_int*") int[] errcode_ret);

public static native @Cast("cl_int") int clEnqueueUnmapMemObject(_cl_command_queue command_queue,
                        _cl_mem memobj,
                        Pointer mapped_ptr,
                        @Cast("cl_uint") int num_events_in_wait_list,
                        @Cast("const cl_event*") PointerPointer event_wait_list,
                        @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueUnmapMemObject(_cl_command_queue command_queue,
                        _cl_mem memobj,
                        Pointer mapped_ptr,
                        @Cast("cl_uint") int num_events_in_wait_list,
                        @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                        @ByPtrPtr _cl_event event);

// #ifdef CL_VERSION_1_2

public static native @Cast("cl_int") int clEnqueueMigrateMemObjects(_cl_command_queue command_queue,
                           @Cast("cl_uint") int num_mem_objects,
                           @Cast("const cl_mem*") PointerPointer mem_objects,
                           @Cast("cl_mem_migration_flags") long flags,
                           @Cast("cl_uint") int num_events_in_wait_list,
                           @Cast("const cl_event*") PointerPointer event_wait_list,
                           @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueMigrateMemObjects(_cl_command_queue command_queue,
                           @Cast("cl_uint") int num_mem_objects,
                           @Cast("const cl_mem*") @ByPtrPtr _cl_mem mem_objects,
                           @Cast("cl_mem_migration_flags") long flags,
                           @Cast("cl_uint") int num_events_in_wait_list,
                           @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                           @ByPtrPtr _cl_event event);

// #endif

public static native @Cast("cl_int") int clEnqueueNDRangeKernel(_cl_command_queue command_queue,
                       _cl_kernel kernel,
                       @Cast("cl_uint") int work_dim,
                       @Cast("const size_t*") SizeTPointer global_work_offset,
                       @Cast("const size_t*") SizeTPointer global_work_size,
                       @Cast("const size_t*") SizeTPointer local_work_size,
                       @Cast("cl_uint") int num_events_in_wait_list,
                       @Cast("const cl_event*") PointerPointer event_wait_list,
                       @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueNDRangeKernel(_cl_command_queue command_queue,
                       _cl_kernel kernel,
                       @Cast("cl_uint") int work_dim,
                       @Cast("const size_t*") SizeTPointer global_work_offset,
                       @Cast("const size_t*") SizeTPointer global_work_size,
                       @Cast("const size_t*") SizeTPointer local_work_size,
                       @Cast("cl_uint") int num_events_in_wait_list,
                       @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                       @ByPtrPtr _cl_event event);
// Targeting ..\User_func_Pointer.java


public static native @Cast("cl_int") int clEnqueueNativeKernel(_cl_command_queue command_queue,
                      User_func_Pointer user_func,
                      Pointer args,
                      @Cast("size_t") long cb_args,
                      @Cast("cl_uint") int num_mem_objects,
                      @Cast("const cl_mem*") PointerPointer mem_list,
                      @Cast("const void**") PointerPointer args_mem_loc,
                      @Cast("cl_uint") int num_events_in_wait_list,
                      @Cast("const cl_event*") PointerPointer event_wait_list,
                      @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueNativeKernel(_cl_command_queue command_queue,
                      User_func_Pointer user_func,
                      Pointer args,
                      @Cast("size_t") long cb_args,
                      @Cast("cl_uint") int num_mem_objects,
                      @Cast("const cl_mem*") PointerPointer mem_list,
                      @Cast("const void**") @ByPtrPtr Pointer args_mem_loc,
                      @Cast("cl_uint") int num_events_in_wait_list,
                      @Cast("const cl_event*") PointerPointer event_wait_list,
                      @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueNativeKernel(_cl_command_queue command_queue,
                      User_func_Pointer user_func,
                      Pointer args,
                      @Cast("size_t") long cb_args,
                      @Cast("cl_uint") int num_mem_objects,
                      @Cast("const cl_mem*") @ByPtrPtr _cl_mem mem_list,
                      @Cast("const void**") @ByPtrPtr Pointer args_mem_loc,
                      @Cast("cl_uint") int num_events_in_wait_list,
                      @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                      @ByPtrPtr _cl_event event);

// #ifdef CL_VERSION_1_2

public static native @Cast("cl_int") int clEnqueueMarkerWithWaitList(_cl_command_queue command_queue,
                            @Cast("cl_uint") int num_events_in_wait_list,
                            @Cast("const cl_event*") PointerPointer event_wait_list,
                            @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueMarkerWithWaitList(_cl_command_queue command_queue,
                            @Cast("cl_uint") int num_events_in_wait_list,
                            @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                            @ByPtrPtr _cl_event event);

public static native @Cast("cl_int") int clEnqueueBarrierWithWaitList(_cl_command_queue command_queue,
                             @Cast("cl_uint") int num_events_in_wait_list,
                             @Cast("const cl_event*") PointerPointer event_wait_list,
                             @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueBarrierWithWaitList(_cl_command_queue command_queue,
                             @Cast("cl_uint") int num_events_in_wait_list,
                             @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                             @ByPtrPtr _cl_event event);
// Targeting ..\Pfn_free_func__cl_command_queue_int_PointerPointer_Pointer.java


public static native @Cast("cl_int") int clEnqueueSVMFree(_cl_command_queue command_queue,
                 @Cast("cl_uint") int num_svm_pointers,
                 @Cast("void**") PointerPointer svm_pointers,
                 Pfn_free_func__cl_command_queue_int_PointerPointer_Pointer pfn_free_func,
                 Pointer user_data,
                 @Cast("cl_uint") int num_events_in_wait_list,
                 @Cast("const cl_event*") PointerPointer event_wait_list,
                 @Cast("cl_event*") PointerPointer event);
// Targeting ..\Pfn_free_func__cl_command_queue_int_Pointer_Pointer.java


public static native @Cast("cl_int") int clEnqueueSVMFree(_cl_command_queue command_queue,
                 @Cast("cl_uint") int num_svm_pointers,
                 @Cast("void**") @ByPtrPtr Pointer svm_pointers,
                 Pfn_free_func__cl_command_queue_int_Pointer_Pointer pfn_free_func,
                 Pointer user_data,
                 @Cast("cl_uint") int num_events_in_wait_list,
                 @Cast("const cl_event*") PointerPointer event_wait_list,
                 @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueSVMFree(_cl_command_queue command_queue,
                 @Cast("cl_uint") int num_svm_pointers,
                 @Cast("void**") @ByPtrPtr Pointer svm_pointers,
                 Pfn_free_func__cl_command_queue_int_Pointer_Pointer pfn_free_func,
                 Pointer user_data,
                 @Cast("cl_uint") int num_events_in_wait_list,
                 @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                 @ByPtrPtr _cl_event event);

public static native @Cast("cl_int") int clEnqueueSVMMemcpy(_cl_command_queue command_queue,
                   @Cast("cl_bool") int blocking_copy,
                   Pointer dst_ptr,
                   @Const Pointer src_ptr,
                   @Cast("size_t") long size,
                   @Cast("cl_uint") int num_events_in_wait_list,
                   @Cast("const cl_event*") PointerPointer event_wait_list,
                   @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueSVMMemcpy(_cl_command_queue command_queue,
                   @Cast("cl_bool") int blocking_copy,
                   Pointer dst_ptr,
                   @Const Pointer src_ptr,
                   @Cast("size_t") long size,
                   @Cast("cl_uint") int num_events_in_wait_list,
                   @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                   @ByPtrPtr _cl_event event);

public static native @Cast("cl_int") int clEnqueueSVMMemFill(_cl_command_queue command_queue,
                    Pointer svm_ptr,
                    @Const Pointer pattern,
                    @Cast("size_t") long pattern_size,
                    @Cast("size_t") long size,
                    @Cast("cl_uint") int num_events_in_wait_list,
                    @Cast("const cl_event*") PointerPointer event_wait_list,
                    @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueSVMMemFill(_cl_command_queue command_queue,
                    Pointer svm_ptr,
                    @Const Pointer pattern,
                    @Cast("size_t") long pattern_size,
                    @Cast("size_t") long size,
                    @Cast("cl_uint") int num_events_in_wait_list,
                    @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                    @ByPtrPtr _cl_event event);

public static native @Cast("cl_int") int clEnqueueSVMMap(_cl_command_queue command_queue,
                @Cast("cl_bool") int blocking_map,
                @Cast("cl_map_flags") long flags,
                Pointer svm_ptr,
                @Cast("size_t") long size,
                @Cast("cl_uint") int num_events_in_wait_list,
                @Cast("const cl_event*") PointerPointer event_wait_list,
                @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueSVMMap(_cl_command_queue command_queue,
                @Cast("cl_bool") int blocking_map,
                @Cast("cl_map_flags") long flags,
                Pointer svm_ptr,
                @Cast("size_t") long size,
                @Cast("cl_uint") int num_events_in_wait_list,
                @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                @ByPtrPtr _cl_event event);

public static native @Cast("cl_int") int clEnqueueSVMUnmap(_cl_command_queue command_queue,
                  Pointer svm_ptr,
                  @Cast("cl_uint") int num_events_in_wait_list,
                  @Cast("const cl_event*") PointerPointer event_wait_list,
                  @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueSVMUnmap(_cl_command_queue command_queue,
                  Pointer svm_ptr,
                  @Cast("cl_uint") int num_events_in_wait_list,
                  @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                  @ByPtrPtr _cl_event event);

// #endif

// #ifdef CL_VERSION_2_1

public static native @Cast("cl_int") int clEnqueueSVMMigrateMem(_cl_command_queue command_queue,
                       @Cast("cl_uint") int num_svm_pointers,
                       @Cast("const void**") PointerPointer svm_pointers,
                       @Cast("const size_t*") SizeTPointer sizes,
                       @Cast("cl_mem_migration_flags") long flags,
                       @Cast("cl_uint") int num_events_in_wait_list,
                       @Cast("const cl_event*") PointerPointer event_wait_list,
                       @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueSVMMigrateMem(_cl_command_queue command_queue,
                       @Cast("cl_uint") int num_svm_pointers,
                       @Cast("const void**") @ByPtrPtr Pointer svm_pointers,
                       @Cast("const size_t*") SizeTPointer sizes,
                       @Cast("cl_mem_migration_flags") long flags,
                       @Cast("cl_uint") int num_events_in_wait_list,
                       @Cast("const cl_event*") PointerPointer event_wait_list,
                       @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") int clEnqueueSVMMigrateMem(_cl_command_queue command_queue,
                       @Cast("cl_uint") int num_svm_pointers,
                       @Cast("const void**") @ByPtrPtr Pointer svm_pointers,
                       @Cast("const size_t*") SizeTPointer sizes,
                       @Cast("cl_mem_migration_flags") long flags,
                       @Cast("cl_uint") int num_events_in_wait_list,
                       @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
                       @ByPtrPtr _cl_event event);

// #endif

// #ifdef CL_VERSION_1_2

/* Extension function access
 *
 * Returns the extension function address for the given function name,
 * or NULL if a valid function can not be found.  The client must
 * check to make sure the address is not NULL, before using or
 * calling the returned function address.
 */
public static native Pointer clGetExtensionFunctionAddressForPlatform(_cl_platform_id platform,
                                         @Cast("const char*") BytePointer func_name);
public static native Pointer clGetExtensionFunctionAddressForPlatform(_cl_platform_id platform,
                                         String func_name);

// #endif

// #ifdef CL_USE_DEPRECATED_OPENCL_1_0_APIS
// #endif /* CL_USE_DEPRECATED_OPENCL_1_0_APIS */

/* Deprecated OpenCL 1.1 APIs */
public static native @Deprecated _cl_mem clCreateImage2D(_cl_context context,
                @Cast("cl_mem_flags") long flags,
                @Const cl_image_format image_format,
                @Cast("size_t") long image_width,
                @Cast("size_t") long image_height,
                @Cast("size_t") long image_row_pitch,
                Pointer host_ptr,
                @Cast("cl_int*") IntPointer errcode_ret);
public static native @Deprecated _cl_mem clCreateImage2D(_cl_context context,
                @Cast("cl_mem_flags") long flags,
                @Const cl_image_format image_format,
                @Cast("size_t") long image_width,
                @Cast("size_t") long image_height,
                @Cast("size_t") long image_row_pitch,
                Pointer host_ptr,
                @Cast("cl_int*") IntBuffer errcode_ret);
public static native @Deprecated _cl_mem clCreateImage2D(_cl_context context,
                @Cast("cl_mem_flags") long flags,
                @Const cl_image_format image_format,
                @Cast("size_t") long image_width,
                @Cast("size_t") long image_height,
                @Cast("size_t") long image_row_pitch,
                Pointer host_ptr,
                @Cast("cl_int*") int[] errcode_ret);

public static native @Deprecated _cl_mem clCreateImage3D(_cl_context context,
                @Cast("cl_mem_flags") long flags,
                @Const cl_image_format image_format,
                @Cast("size_t") long image_width,
                @Cast("size_t") long image_height,
                @Cast("size_t") long image_depth,
                @Cast("size_t") long image_row_pitch,
                @Cast("size_t") long image_slice_pitch,
                Pointer host_ptr,
                @Cast("cl_int*") IntPointer errcode_ret);
public static native @Deprecated _cl_mem clCreateImage3D(_cl_context context,
                @Cast("cl_mem_flags") long flags,
                @Const cl_image_format image_format,
                @Cast("size_t") long image_width,
                @Cast("size_t") long image_height,
                @Cast("size_t") long image_depth,
                @Cast("size_t") long image_row_pitch,
                @Cast("size_t") long image_slice_pitch,
                Pointer host_ptr,
                @Cast("cl_int*") IntBuffer errcode_ret);
public static native @Deprecated _cl_mem clCreateImage3D(_cl_context context,
                @Cast("cl_mem_flags") long flags,
                @Const cl_image_format image_format,
                @Cast("size_t") long image_width,
                @Cast("size_t") long image_height,
                @Cast("size_t") long image_depth,
                @Cast("size_t") long image_row_pitch,
                @Cast("size_t") long image_slice_pitch,
                Pointer host_ptr,
                @Cast("cl_int*") int[] errcode_ret);

public static native @Cast("cl_int") @Deprecated int clEnqueueMarker(_cl_command_queue command_queue,
                @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") @Deprecated int clEnqueueMarker(_cl_command_queue command_queue,
                @ByPtrPtr _cl_event event);

public static native @Cast("cl_int") @Deprecated int clEnqueueWaitForEvents(_cl_command_queue command_queue,
                        @Cast("cl_uint") int num_events,
                        @Cast("const cl_event*") PointerPointer event_list);
public static native @Cast("cl_int") @Deprecated int clEnqueueWaitForEvents(_cl_command_queue command_queue,
                        @Cast("cl_uint") int num_events,
                        @Cast("const cl_event*") @ByPtrPtr _cl_event event_list);

public static native @Cast("cl_int") @Deprecated int clEnqueueBarrier(_cl_command_queue command_queue);

public static native @Cast("cl_int") @Deprecated int clUnloadCompiler();

public static native @Deprecated Pointer clGetExtensionFunctionAddress(@Cast("const char*") BytePointer func_name);
public static native @Deprecated Pointer clGetExtensionFunctionAddress(String func_name);

/* Deprecated OpenCL 2.0 APIs */
public static native @Deprecated _cl_command_queue clCreateCommandQueue(_cl_context context,
                     _cl_device_id device,
                     @Cast("cl_command_queue_properties") long properties,
                     @Cast("cl_int*") IntPointer errcode_ret);
public static native @Deprecated _cl_command_queue clCreateCommandQueue(_cl_context context,
                     _cl_device_id device,
                     @Cast("cl_command_queue_properties") long properties,
                     @Cast("cl_int*") IntBuffer errcode_ret);
public static native @Deprecated _cl_command_queue clCreateCommandQueue(_cl_context context,
                     _cl_device_id device,
                     @Cast("cl_command_queue_properties") long properties,
                     @Cast("cl_int*") int[] errcode_ret);

public static native @Deprecated _cl_sampler clCreateSampler(_cl_context context,
                @Cast("cl_bool") int normalized_coords,
                @Cast("cl_addressing_mode") int addressing_mode,
                @Cast("cl_filter_mode") int filter_mode,
                @Cast("cl_int*") IntPointer errcode_ret);
public static native @Deprecated _cl_sampler clCreateSampler(_cl_context context,
                @Cast("cl_bool") int normalized_coords,
                @Cast("cl_addressing_mode") int addressing_mode,
                @Cast("cl_filter_mode") int filter_mode,
                @Cast("cl_int*") IntBuffer errcode_ret);
public static native @Deprecated _cl_sampler clCreateSampler(_cl_context context,
                @Cast("cl_bool") int normalized_coords,
                @Cast("cl_addressing_mode") int addressing_mode,
                @Cast("cl_filter_mode") int filter_mode,
                @Cast("cl_int*") int[] errcode_ret);

public static native @Cast("cl_int") @Deprecated int clEnqueueTask(_cl_command_queue command_queue,
              _cl_kernel kernel,
              @Cast("cl_uint") int num_events_in_wait_list,
              @Cast("const cl_event*") PointerPointer event_wait_list,
              @Cast("cl_event*") PointerPointer event);
public static native @Cast("cl_int") @Deprecated int clEnqueueTask(_cl_command_queue command_queue,
              _cl_kernel kernel,
              @Cast("cl_uint") int num_events_in_wait_list,
              @Cast("const cl_event*") @ByPtrPtr _cl_event event_wait_list,
              @ByPtrPtr _cl_event event);

// #endif /* !defined(CL_NO_CORE_PROTOTYPES) */

// #ifdef __cplusplus
// #endif

// #endif  /* __OPENCL_CL_H */


}
