// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.openpose;

import org.bytedeco.javacpp.annotation.Index;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.hdf5.*;
import static org.bytedeco.hdf5.global.hdf5.*;
import org.bytedeco.caffe.*;
import static org.bytedeco.caffe.global.caffe.*;

import static org.bytedeco.openpose.global.openpose.*;

    /**
     * WrapperStructInput: Input (images, video, webcam, etc.) configuration struct.
     * WrapperStructInput allows the user to set up the input frames generator.
     */
    @Namespace("op") @NoOffset @Properties(inherit = org.bytedeco.openpose.presets.openpose.class)
public class WrapperStructInput extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public WrapperStructInput(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public WrapperStructInput(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public WrapperStructInput position(long position) {
            return (WrapperStructInput)super.position(position);
        }
        @Override public WrapperStructInput getPointer(long i) {
            return new WrapperStructInput(this).position(position + i);
        }
    
        /**
         * Desired type of producer (FlirCamera, ImageDirectory, IPCamera, Video, Webcam, None, etc.).
         * Default: ProducerType::None.
         */
        public native ProducerType producerType(); public native WrapperStructInput producerType(ProducerType setter);

        /**
         * Path of the producer (image directory path for ImageDirectory, video path for Video,
         * camera index for Webcam and FlirCamera, URL for IPCamera, etc.).
         * Default: "".
         */
        public native @ByRef OpString producerString(); public native WrapperStructInput producerString(OpString setter);

        /**
         * First image to process.
         * Default: 0.
         */
        public native @Cast("unsigned long long") long frameFirst(); public native WrapperStructInput frameFirst(long setter);

        /**
         * Step or gap across processed frames.
         * Default: 1 (i.e., process all frames).
         * Example: A value of 5 would mean to process frames 0, 5, 10, etc.
         */
        public native @Cast("unsigned long long") long frameStep(); public native WrapperStructInput frameStep(long setter);

        /**
         * Last image to process.
         * Default: -1 (i.e., process all frames).
         */
        public native @Cast("unsigned long long") long frameLast(); public native WrapperStructInput frameLast(long setter);

        /**
         * Whether to skip or sleep in order to keep the same FPS as the frames producer.
         */
        public native @Cast("bool") boolean realTimeProcessing(); public native WrapperStructInput realTimeProcessing(boolean setter);

        /**
         * Whether to flip (mirror) the image.
         */
        public native @Cast("bool") boolean frameFlip(); public native WrapperStructInput frameFlip(boolean setter);

        /**
         * Image rotation.
         * Only 4 possible values: 0 (default, no rotation), 90, 180 or 270 degrees
         */
        public native int frameRotate(); public native WrapperStructInput frameRotate(int setter);

        /**
         * Whether to re-open the producer if it reaches the end (e.g., video or image directory after the last frame).
         */
        public native @Cast("bool") boolean framesRepeat(); public native WrapperStructInput framesRepeat(boolean setter);

        /**
         * Camera resolution (only for Webcam and FlirCamera).
         */
        public native @ByRef IntPoint cameraResolution(); public native WrapperStructInput cameraResolution(IntPoint setter);

        /**
         * Directory path for the camera parameters (intrinsic and extrinsic parameters) or optionally XML file
         * full path (if only 1 view).
         */
        public native @ByRef OpString cameraParameterPath(); public native WrapperStructInput cameraParameterPath(OpString setter);

        /**
         * Whether to undistort the image given the camera parameters.
         */
        public native @Cast("bool") boolean undistortImage(); public native WrapperStructInput undistortImage(boolean setter);

        /**
         * Number of camera views.
         * Complementary option for {@code --image_dir} or {@code --video}
         * It is -1 for Flir cameras (# cameras detected at runtime), as well as for any other frames source (-1 and 1
         * are equivalent for those). It could be greater than 1 only for prerecorded produced sources, such as video
         * and image directory.
         */
        public native int numberViews(); public native WrapperStructInput numberViews(int setter);

        /**
         * Constructor of the struct.
         * It has the recommended and default values we recommend for each element of the struct.
         * Since all the elements of the struct are public, they can also be manually filled.
         */
        public WrapperStructInput(
                    ProducerType producerType/*=op::ProducerType::None*/, @Const @ByRef(nullValue = "op::String(\"\")") OpString producerString,
                    @Cast("const unsigned long long") long frameFirst/*=0*/, @Cast("const unsigned long long") long frameStep/*=1*/,
                    @Cast("const unsigned long long") long frameLast/*=std::numeric_limits<unsigned long long>::max()*/,
                    @Cast("const bool") boolean realTimeProcessing/*=false*/, @Cast("const bool") boolean frameFlip/*=false*/, int frameRotate/*=0*/,
                    @Cast("const bool") boolean framesRepeat/*=false*/, @Const @ByRef(nullValue = "op::Point<int>{-1,-1}") IntPoint cameraResolution,
                    @Const @ByRef(nullValue = "op::String(\"models/cameraParameters/\")") OpString cameraParameterPath,
                    @Cast("const bool") boolean undistortImage/*=false*/, int numberViews/*=-1*/) { super((Pointer)null); allocate(producerType, producerString, frameFirst, frameStep, frameLast, realTimeProcessing, frameFlip, frameRotate, framesRepeat, cameraResolution, cameraParameterPath, undistortImage, numberViews); }
        private native void allocate(
                    ProducerType producerType/*=op::ProducerType::None*/, @Const @ByRef(nullValue = "op::String(\"\")") OpString producerString,
                    @Cast("const unsigned long long") long frameFirst/*=0*/, @Cast("const unsigned long long") long frameStep/*=1*/,
                    @Cast("const unsigned long long") long frameLast/*=std::numeric_limits<unsigned long long>::max()*/,
                    @Cast("const bool") boolean realTimeProcessing/*=false*/, @Cast("const bool") boolean frameFlip/*=false*/, int frameRotate/*=0*/,
                    @Cast("const bool") boolean framesRepeat/*=false*/, @Const @ByRef(nullValue = "op::Point<int>{-1,-1}") IntPoint cameraResolution,
                    @Const @ByRef(nullValue = "op::String(\"models/cameraParameters/\")") OpString cameraParameterPath,
                    @Cast("const bool") boolean undistortImage/*=false*/, int numberViews/*=-1*/);
        public WrapperStructInput() { super((Pointer)null); allocate(); }
        private native void allocate();
    }
