/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.openpose;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.openpose.Float3;
import org.bytedeco.openpose.presets.openpose;

@Name(value={"std::vector<std::array<float,3> >"})
@Properties(inherit={openpose.class})
public class Float3Vector
extends Pointer {
    public Float3Vector(Pointer p) {
        super(p);
    }

    public Float3Vector(Float3 value) {
        this(1L);
        this.put(0L, value);
    }

    public Float3Vector(Float3 ... array) {
        this(array.length);
        this.put(array);
    }

    public Float3Vector() {
        this.allocate();
    }

    public Float3Vector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native Float3Vector put(@ByRef Float3Vector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    @Index(function="at")
    @ByRef
    public native Float3 get(@Cast(value={"size_t"}) long var1);

    public native Float3Vector put(@Cast(value={"size_t"}) long var1, Float3 var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef Float3 var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Float3[] get() {
        Float3[] array = new Float3[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public Float3 pop_back() {
        long size = this.size();
        Float3 value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public Float3Vector push_back(Float3 value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public Float3Vector put(Float3 value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public Float3Vector put(Float3 ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native Float3 get();
    }
}

