// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.openpose;

import org.bytedeco.javacpp.annotation.Index;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.hdf5.*;
import static org.bytedeco.hdf5.global.hdf5.*;
import org.bytedeco.caffe.*;
import static org.bytedeco.caffe.global.caffe.*;

import static org.bytedeco.openpose.global.openpose.*;

    /**
     * WrapperStructOutput: Output ( writing rendered results and/or pose data, etc.) configuration struct.
     */
    @Namespace("op") @NoOffset @Properties(inherit = org.bytedeco.openpose.presets.openpose.class)
public class WrapperStructOutput extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public WrapperStructOutput(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public WrapperStructOutput(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public WrapperStructOutput position(long position) {
            return (WrapperStructOutput)super.position(position);
        }
        @Override public WrapperStructOutput getPointer(long i) {
            return new WrapperStructOutput((Pointer)this).position(position + i);
        }
    
        /**
         * Output verbose in the command line.
         * If -1, it will be disabled (default). If it is a positive integer number, it will print on"
         * the command line every {@code verbose} frames. If number in the range (0,1), it will print the"
         * progress every {@code verbose} times the total of frames.
         */
        public native double verbose(); public native WrapperStructOutput verbose(double setter);

        /**
         * Pose (x, y, score) locations saving folder location.
         * If it is empty (default), it is disabled.
         * Select format with writeKeypointFormat.
         */
        public native @ByRef OpString writeKeypoint(); public native WrapperStructOutput writeKeypoint(OpString setter);

        /**
         * Data format to save Pose (x, y, score) locations.
         * Options: DataFormat::Json (default), DataFormat::Xml and DataFormat::Yml (equivalent to DataFormat::Yaml)
         * JSON option only available for OpenCV >= 3.0.
         */
        public native DataFormat writeKeypointFormat(); public native WrapperStructOutput writeKeypointFormat(DataFormat setter);

        /**
         * Directory to write OpenPose output in JSON format.
         * If it is empty (default), it is disabled.
         * It includes:
         *     - {@code people} field with body, hand, and face pose keypoints in (x, y, score) format.
         *     - {@code part_candidates} field with body part candidates in (x, y, score) format (if enabled with
         *       {@code --part_candidates}).
         */
        public native @ByRef OpString writeJson(); public native WrapperStructOutput writeJson(OpString setter);

        /**
         * Pose (x, y, score) locations saving folder location in JSON COCO validation format.
         * If it is empty (default), it is disabled.
         */
        public native @ByRef OpString writeCocoJson(); public native WrapperStructOutput writeCocoJson(OpString setter);

        /**
         * It selects the COCO variants for cocoJsonSaver.
         * Add 1 for body, add 2 for foot, 4 for face, and/or 8 for hands. Use 0 to use all the possible candidates.
         * E.g., 7 would mean body+foot+face COCO JSON..
         */
        public native int writeCocoJsonVariants(); public native WrapperStructOutput writeCocoJsonVariants(int setter);

        /**
         * Experimental option (only makes effect on car JSON generation).
         * It selects the COCO variant for cocoJsonSaver.
         */
        public native int writeCocoJsonVariant(); public native WrapperStructOutput writeCocoJsonVariant(int setter);

        /**
         * Rendered image saving folder.
         * If it is empty (default), it is disabled.
         */
        public native @ByRef OpString writeImages(); public native WrapperStructOutput writeImages(OpString setter);

        /**
         * Rendered image saving folder format.
         * Check your OpenCV version documentation for a list of compatible formats.
         * E.g., png, jpg, etc.
         * If writeImages is empty (default), it makes no effect.
         */
        public native @ByRef OpString writeImagesFormat(); public native WrapperStructOutput writeImagesFormat(OpString setter);

        /**
         * Rendered images saving video path.
         * Please, use *.avi format.
         * If it is empty (default), it is disabled.
         */
        public native @ByRef OpString writeVideo(); public native WrapperStructOutput writeVideo(OpString setter);

        /**
         * Frame rate of the recorded video.
         * By default (-1.), it will try to get the input frames producer frame rate (e.g., input video or webcam frame
         * rate). If the input frames producer does not have a set FPS (e.g., image_dir or webcam if OpenCV not
         * compiled with its support), set this value accordingly (e.g., to the frame rate displayed by the OpenPose
         * GUI).
         */
        public native double writeVideoFps(); public native WrapperStructOutput writeVideoFps(double setter);

        /**
         * Whether to save the output video with audio. The input producer must be a video too.
         */
        public native @Cast("bool") boolean writeVideoWithAudio(); public native WrapperStructOutput writeVideoWithAudio(boolean setter);

        /**
         * Rendered heat maps saving folder.
         * In order to save the heatmaps, WrapperStructPose.heatMapTypes must also be filled.
         * If it is empty (default), it is disabled.
         */
        public native @ByRef OpString writeHeatMaps(); public native WrapperStructOutput writeHeatMaps(OpString setter);

        /**
         * Heat maps image saving format.
         * Analogous to writeImagesFormat.
         */
        public native @ByRef OpString writeHeatMapsFormat(); public native WrapperStructOutput writeHeatMapsFormat(OpString setter);

        /**
         * Rendered 3D images saving video path.
         * Please, use *.avi format.
         * If it is empty (default), it is disabled.
         */
        public native @ByRef OpString writeVideo3D(); public native WrapperStructOutput writeVideo3D(OpString setter);

        /**
         * Rendered Adam images saving video path.
         * Please, use *.avi format.
         * If it is empty (default), it is disabled.
         */
        public native @ByRef OpString writeVideoAdam(); public native WrapperStructOutput writeVideoAdam(OpString setter);

        /**
         * Path to save a 3-D joint angle BVH file.
         * Please, use *.bvh format.
         * If it is empty (default), it is disabled.
         */
        public native @ByRef OpString writeBvh(); public native WrapperStructOutput writeBvh(OpString setter);

        /**
         * Target server IP address for UDP client-server communication.
         */
        public native @ByRef OpString udpHost(); public native WrapperStructOutput udpHost(OpString setter);

        /**
         * Target server IP port for UDP client-server communication.
         */
        public native @ByRef OpString udpPort(); public native WrapperStructOutput udpPort(OpString setter);

        /**
         * Constructor of the struct.
         * It has the recommended and default values we recommend for each element of the struct.
         * Since all the elements of the struct are public, they can also be manually filled.
         */
        public WrapperStructOutput(
                    double verbose/*=-1*/, @Const @ByRef(nullValue = "op::String(\"\")") OpString writeKeypoint,
                    DataFormat writeKeypointFormat/*=op::DataFormat::Xml*/, @Const @ByRef(nullValue = "op::String(\"\")") OpString writeJson,
                    @Const @ByRef(nullValue = "op::String(\"\")") OpString writeCocoJson, int writeCocoJsonVariants/*=1*/,
                    int writeCocoJsonVariant/*=1*/, @Const @ByRef(nullValue = "op::String(\"\")") OpString writeImages,
                    @Const @ByRef(nullValue = "op::String(\"png\")") OpString writeImagesFormat, @Const @ByRef(nullValue = "op::String(\"\")") OpString writeVideo,
                    double writeVideoFps/*=-1.*/, @Cast("const bool") boolean writeVideoWithAudio/*=false*/,
                    @Const @ByRef(nullValue = "op::String(\"\")") OpString writeHeatMaps, @Const @ByRef(nullValue = "op::String(\"png\")") OpString writeHeatMapsFormat,
                    @Const @ByRef(nullValue = "op::String(\"\")") OpString writeVideo3D, @Const @ByRef(nullValue = "op::String(\"\")") OpString writeVideoAdam,
                    @Const @ByRef(nullValue = "op::String(\"\")") OpString writeBvh, @Const @ByRef(nullValue = "op::String(\"\")") OpString udpHost,
                    @Const @ByRef(nullValue = "op::String(\"8051\")") OpString udpPort) { super((Pointer)null); allocate(verbose, writeKeypoint, writeKeypointFormat, writeJson, writeCocoJson, writeCocoJsonVariants, writeCocoJsonVariant, writeImages, writeImagesFormat, writeVideo, writeVideoFps, writeVideoWithAudio, writeHeatMaps, writeHeatMapsFormat, writeVideo3D, writeVideoAdam, writeBvh, udpHost, udpPort); }
        private native void allocate(
                    double verbose/*=-1*/, @Const @ByRef(nullValue = "op::String(\"\")") OpString writeKeypoint,
                    DataFormat writeKeypointFormat/*=op::DataFormat::Xml*/, @Const @ByRef(nullValue = "op::String(\"\")") OpString writeJson,
                    @Const @ByRef(nullValue = "op::String(\"\")") OpString writeCocoJson, int writeCocoJsonVariants/*=1*/,
                    int writeCocoJsonVariant/*=1*/, @Const @ByRef(nullValue = "op::String(\"\")") OpString writeImages,
                    @Const @ByRef(nullValue = "op::String(\"png\")") OpString writeImagesFormat, @Const @ByRef(nullValue = "op::String(\"\")") OpString writeVideo,
                    double writeVideoFps/*=-1.*/, @Cast("const bool") boolean writeVideoWithAudio/*=false*/,
                    @Const @ByRef(nullValue = "op::String(\"\")") OpString writeHeatMaps, @Const @ByRef(nullValue = "op::String(\"png\")") OpString writeHeatMapsFormat,
                    @Const @ByRef(nullValue = "op::String(\"\")") OpString writeVideo3D, @Const @ByRef(nullValue = "op::String(\"\")") OpString writeVideoAdam,
                    @Const @ByRef(nullValue = "op::String(\"\")") OpString writeBvh, @Const @ByRef(nullValue = "op::String(\"\")") OpString udpHost,
                    @Const @ByRef(nullValue = "op::String(\"8051\")") OpString udpPort);
        public WrapperStructOutput() { super((Pointer)null); allocate(); }
        private native void allocate();
    }
