// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.openpose;

import org.bytedeco.javacpp.annotation.Index;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.hdf5.*;
import static org.bytedeco.hdf5.global.hdf5.*;
import org.bytedeco.caffe.*;
import static org.bytedeco.caffe.global.caffe.*;

import static org.bytedeco.openpose.global.openpose.*;

    /**
     * WrapperStructPose: Pose estimation and rendering configuration struct.
     * WrapperStructPose allows the user to set up the pose estimation and rendering parameters that will be used for
     * the OpenPose WrapperT template and Wrapper class.
     */
    @Namespace("op") @NoOffset @Properties(inherit = org.bytedeco.openpose.presets.openpose.class)
public class WrapperStructPose extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public WrapperStructPose(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public WrapperStructPose(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public WrapperStructPose position(long position) {
            return (WrapperStructPose)super.position(position);
        }
        @Override public WrapperStructPose getPointer(long i) {
            return new WrapperStructPose((Pointer)this).position(position + i);
        }
    
        /**
         * Whether to extract body.
         * It might be optionally disabled for very few cases (e.g., if only face keypoint detection is desired for
         * speedup while reducing its accuracy). Otherwise, it must be always enabled.
         */
        public native PoseMode poseMode(); public native WrapperStructPose poseMode(PoseMode setter);

        /**
         * CCN (Conv Net) input size.
         * The greater, the slower and more memory it will be needed, but it will potentially increase accuracy.
         * Both width and height must be divisible by 16.
         */
        public native @ByRef IntPoint netInputSize(); public native WrapperStructPose netInputSize(IntPoint setter);

        /**
         * Output size of the final rendered image.
         * It barely affects performance compared to netInputSize.
         * The final Datum.poseKeypoints can be scaled with respect to outputSize if {@code keypointScaleMode} is set to
         * ScaleMode::OutputResolution, even if the rendering is disabled.
         */
        public native @ByRef IntPoint outputSize(); public native WrapperStructPose outputSize(IntPoint setter);

        /**
         * Final scale of the Array<float> Datum.poseKeypoints and the writen pose data.
         * The final Datum.poseKeypoints can be scaled with respect to input size (ScaleMode::InputResolution), net
         * output size (ScaleMode::NetOutputResolution), output rendering size (ScaleMode::OutputResolution), from 0 to
         * 1 (ScaleMode::ZeroToOne(FixedAspect)), and -1 to 1 (ScaleMode::PlusMinusOne(FixedAspect)).
         */
        public native ScaleMode keypointScaleMode(); public native WrapperStructPose keypointScaleMode(ScaleMode setter);

        /**
         * Number of GPUs processing in parallel.
         * The greater, the faster the algorithm will run, but potentially higher lag will appear (which only affects
         * in real-time webcam scenarios).
         */
        public native int gpuNumber(); public native WrapperStructPose gpuNumber(int setter);

        /**
         * First GPU device.
         * Such as the GPUs used will be the ones in the range: [gpuNumberStart, gpuNumberStart + gpuNumber].
         */
        public native int gpuNumberStart(); public native WrapperStructPose gpuNumberStart(int setter);

        /**
         * Number of scales to process.
         * The greater, the slower and more memory it will be needed, but it will potentially increase accuracy.
         * This parameter is related with scaleGap, such as the final pose estimation will be an average of the
         * predicted results for each scale.
         */
        public native int scalesNumber(); public native WrapperStructPose scalesNumber(int setter);

        /**
         * Gap between successive scales.
         * The pose estimation will be estimation for the scales in the range [1, 1-scaleGap*scalesNumber], with a gap
         * of scaleGap.
         */
        public native float scaleGap(); public native WrapperStructPose scaleGap(float setter);

        /**
         * Whether to render the output (pose locations, body, background or PAF heat maps) with CPU or GPU.
         * Select {@code None} for no rendering, {@code Cpu} or {@code Gpu} por CPU and GPU rendering respectively.
         */
        public native RenderMode renderMode(); public native WrapperStructPose renderMode(RenderMode setter);

        /**
         * Pose model, it affects the number of body parts to render
         * Select PoseModel::BODY_25 for 25 body-part COCO + foot model; PoseModel::COCO_18 for 18 body-part COCO;
         * PoseModel::MPI_15 for 15 body-part MPI; PoseModel::MPI_15_4 for faster version of MPI; etc..
         */
        public native PoseModel poseModel(); public native WrapperStructPose poseModel(PoseModel setter);

        /**
         * Whether to blend the final results on top of the original image, or just render them on a flat background.
         */
        public native @Cast("bool") boolean blendOriginalFrame(); public native WrapperStructPose blendOriginalFrame(boolean setter);

        /**
         * Rendering blending alpha value of the pose point locations with respect to the background image.
         * Value in the range [0, 1]. 0 will only render the background, 1 will fully render the pose.
         */
        public native float alphaKeypoint(); public native WrapperStructPose alphaKeypoint(float setter);

        /**
         * Rendering blending alpha value of the heat maps (body part, background or PAF) with respect to the
         * background image.
         * Value in the range [0, 1]. 0 will only render the background, 1 will only render the heat map.
         */
        public native float alphaHeatMap(); public native WrapperStructPose alphaHeatMap(float setter);

        /**
         * Element to initially render.
         * Set 0 for pose, [1, #body parts] for each body part following the order on POSE_BODY_PART_MAPPING on
         * {@code include/pose/poseParameters.hpp}, #body parts+1 for background, #body parts+2 for all body parts
         * overlapped, #body parts+3 for all PAFs, and [#body parts+4, #body parts+4+#pair pairs] for each PAF
         * following the order on POSE_BODY_PART_PAIRS.
         */
        public native int defaultPartToRender(); public native WrapperStructPose defaultPartToRender(int setter);

        /**
         * Folder where the pose Caffe models are located.
         */
        public native @ByRef OpString modelFolder(); public native WrapperStructPose modelFolder(OpString setter);

        /**
         * Whether and which heat maps to save on the Array<float> Datum.heatmaps.
         * Use HeatMapType::Parts for body parts, HeatMapType::Background for the background, and HeatMapType::PAFs for
         * the Part Affinity Fields.
         */
        public native @ByRef HeatMapTypeVector heatMapTypes(); public native WrapperStructPose heatMapTypes(HeatMapTypeVector setter);

        /**
         * Scale of the Datum.heatmaps.
         * Select ScaleMode::ZeroToOne(FixedAspect) for range [0,1], ScaleMode::PlusMinusOne(FixedAspect) for [-1,1]
         * and ScaleMode::UnsignedChar for [0, 255].
         * If heatMapTypes.empty(), then this parameters makes no effect.
         */
        public native ScaleMode heatMapScaleMode(); public native WrapperStructPose heatMapScaleMode(ScaleMode setter);

        /**
         * Whether to add the body part candidates.
         * Candidates refer to all the detected body parts, before being assembled into people.
         */
        public native @Cast("bool") boolean addPartCandidates(); public native WrapperStructPose addPartCandidates(boolean setter);

        /**
         * Rendering threshold. Only estimated keypoints whose score confidences are higher than this value will be
         * rendered. Note: Rendered refers only to visual display in the OpenPose basic GUI, not in the saved results.
         * Generally, a high threshold (> 0.5) will only render very clear body parts; while small thresholds
         * (~0.1) will also output guessed and occluded keypoints, but also more false positives (i.e., wrong
         * detections).
         */
        public native float renderThreshold(); public native WrapperStructPose renderThreshold(float setter);

        /**
         * Maximum number of people to be detected.
         * This parameter will limit the maximum number of people detected, by keeping the people with the
         * {@code numberPeopleMax} top scores.
         * Useful if you know the exact number of people in the scene, so it can remove false positives (if all the
         * people have been detected.
         * However, it might also include false negatives by removing very small or highly occluded people.
         */
        public native int numberPeopleMax(); public native WrapperStructPose numberPeopleMax(int setter);

        /**
         * Whether to maximize the number of positives.
         * It reduces the thresholds to accept a person candidate. It highly increases both false and true positives.
         * I.e., it maximizes average recall but could harm average precision.
         */
        public native @Cast("bool") boolean maximizePositives(); public native WrapperStructPose maximizePositives(boolean setter);

        /**
         * Maximum processing frame rate.
         * By default (-1), OpenPose will process frames as fast as possible.
         * Example usage: If OpenPose is displaying images too quickly, this can reduce the speed so the user can
         * analyze better each frame from the GUI.
         */
        public native double fpsMax(); public native WrapperStructPose fpsMax(double setter);

        /**
         * Final path where the pose Caffe ProtoTxt file is located.
         * The combination modelFolder + protoTxtPath represents the whole path to the prototxt file.
         * If empty, it will use the default OpenPose ProtoTxt file.
         */
        public native @ByRef OpString protoTxtPath(); public native WrapperStructPose protoTxtPath(OpString setter);

        /**
         * Final path where the pose Caffe CaffeModel is located.
         * The combination modelFolder + caffeModelPath represents the whole path to the caffemodel file.
         * If empty, it will use the default OpenPose CaffeModel file.
         */
        public native @ByRef OpString caffeModelPath(); public native WrapperStructPose caffeModelPath(OpString setter);

        /**
         * The image upsampling scale. 8 is the stride of the network, so the ideal value to maximize the
         * speed/accuracy trade-off.
         */
        public native float upsamplingRatio(); public native WrapperStructPose upsamplingRatio(float setter);

        /**
         * Whether to internally enable Google Logging.
         * This option is only applicable if Caffe is used.
         * Only disable it if the user is already calling google::InitGoogleLogging() in his code.
         * If the user disables Google Logging and he does not call it by himself, then Caffe will start to pop up
         * all the verbose messages.
         */
        public native @Cast("bool") boolean enableGoogleLogging(); public native WrapperStructPose enableGoogleLogging(boolean setter);

        /**
         * Constructor of the struct.
         * It has the recommended and default values we recommend for each element of the struct.
         * Since all the elements of the struct are public, they can also be manually filled.
         */
        public WrapperStructPose(
                    PoseMode poseMode/*=op::PoseMode::Enabled*/, @Const @ByRef(nullValue = "op::Point<int>{-1, 368}") IntPoint netInputSize,
                    @Const @ByRef(nullValue = "op::Point<int>{-1, -1}") IntPoint outputSize,
                    ScaleMode keypointScaleMode/*=op::ScaleMode::InputResolution*/, int gpuNumber/*=-1*/,
                    int gpuNumberStart/*=0*/, int scalesNumber/*=1*/, float scaleGap/*=0.25f*/,
                    RenderMode renderMode/*=op::RenderMode::Auto*/, PoseModel poseModel/*=op::PoseModel::BODY_25*/,
                    @Cast("const bool") boolean blendOriginalFrame/*=true*/, float alphaKeypoint/*=POSE_DEFAULT_ALPHA_KEYPOINT*/,
                    float alphaHeatMap/*=POSE_DEFAULT_ALPHA_HEAT_MAP*/, int defaultPartToRender/*=0*/,
                    @Const @ByRef(nullValue = "op::String(\"models/\")") OpString modelFolder, @Const @ByRef(nullValue = "std::vector<op::HeatMapType>({})") HeatMapTypeVector heatMapTypes,
                    ScaleMode heatMapScaleMode/*=op::ScaleMode::UnsignedChar*/, @Cast("const bool") boolean addPartCandidates/*=false*/,
                    float renderThreshold/*=0.05f*/, int numberPeopleMax/*=-1*/, @Cast("const bool") boolean maximizePositives/*=false*/,
                    double fpsMax/*=-1.*/, @Const @ByRef(nullValue = "op::String(\"\")") OpString protoTxtPath, @Const @ByRef(nullValue = "op::String(\"\")") OpString caffeModelPath,
                    float upsamplingRatio/*=0.f*/, @Cast("const bool") boolean enableGoogleLogging/*=true*/) { super((Pointer)null); allocate(poseMode, netInputSize, outputSize, keypointScaleMode, gpuNumber, gpuNumberStart, scalesNumber, scaleGap, renderMode, poseModel, blendOriginalFrame, alphaKeypoint, alphaHeatMap, defaultPartToRender, modelFolder, heatMapTypes, heatMapScaleMode, addPartCandidates, renderThreshold, numberPeopleMax, maximizePositives, fpsMax, protoTxtPath, caffeModelPath, upsamplingRatio, enableGoogleLogging); }
        private native void allocate(
                    PoseMode poseMode/*=op::PoseMode::Enabled*/, @Const @ByRef(nullValue = "op::Point<int>{-1, 368}") IntPoint netInputSize,
                    @Const @ByRef(nullValue = "op::Point<int>{-1, -1}") IntPoint outputSize,
                    ScaleMode keypointScaleMode/*=op::ScaleMode::InputResolution*/, int gpuNumber/*=-1*/,
                    int gpuNumberStart/*=0*/, int scalesNumber/*=1*/, float scaleGap/*=0.25f*/,
                    RenderMode renderMode/*=op::RenderMode::Auto*/, PoseModel poseModel/*=op::PoseModel::BODY_25*/,
                    @Cast("const bool") boolean blendOriginalFrame/*=true*/, float alphaKeypoint/*=POSE_DEFAULT_ALPHA_KEYPOINT*/,
                    float alphaHeatMap/*=POSE_DEFAULT_ALPHA_HEAT_MAP*/, int defaultPartToRender/*=0*/,
                    @Const @ByRef(nullValue = "op::String(\"models/\")") OpString modelFolder, @Const @ByRef(nullValue = "std::vector<op::HeatMapType>({})") HeatMapTypeVector heatMapTypes,
                    ScaleMode heatMapScaleMode/*=op::ScaleMode::UnsignedChar*/, @Cast("const bool") boolean addPartCandidates/*=false*/,
                    float renderThreshold/*=0.05f*/, int numberPeopleMax/*=-1*/, @Cast("const bool") boolean maximizePositives/*=false*/,
                    double fpsMax/*=-1.*/, @Const @ByRef(nullValue = "op::String(\"\")") OpString protoTxtPath, @Const @ByRef(nullValue = "op::String(\"\")") OpString caffeModelPath,
                    float upsamplingRatio/*=0.f*/, @Cast("const bool") boolean enableGoogleLogging/*=true*/);
        public WrapperStructPose() { super((Pointer)null); allocate(); }
        private native void allocate();
    }
