// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.openpose;

import org.bytedeco.javacpp.annotation.Index;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.hdf5.*;
import static org.bytedeco.hdf5.global.hdf5.*;
import org.bytedeco.caffe.*;
import static org.bytedeco.caffe.global.caffe.*;

import static org.bytedeco.openpose.global.openpose.*;

    @Name("op::Rectangle<float>") @NoOffset @Properties(inherit = org.bytedeco.openpose.presets.openpose.class)
public class FloatRectangle extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public FloatRectangle(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public FloatRectangle(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public FloatRectangle position(long position) {
            return (FloatRectangle)super.position(position);
        }
        @Override public FloatRectangle getPointer(long i) {
            return new FloatRectangle((Pointer)this).offsetAddress(i);
        }
    
        public native float x(); public native FloatRectangle x(float setter);
        public native float y(); public native FloatRectangle y(float setter);
        public native float width(); public native FloatRectangle width(float setter);
        public native float height(); public native FloatRectangle height(float setter);

        public FloatRectangle(float x/*=0*/, float y/*=0*/, float width/*=0*/, float height/*=0*/) { super((Pointer)null); allocate(x, y, width, height); }
        private native void allocate(float x/*=0*/, float y/*=0*/, float width/*=0*/, float height/*=0*/);
        public FloatRectangle() { super((Pointer)null); allocate(); }
        private native void allocate();

        /**
         * Copy constructor.
         * It performs {@code fast copy}: For performance purpose, copying a Rectangle<T> or Datum or cv::Mat just copies
         * the reference, it still shares the same internal data.
         * Modifying the copied element will modify the original one.
         * Use clone() for a slower but real copy, similarly to cv::Mat and Rectangle<T>.
         * @param rectangle Rectangle to be copied.
         */
        public FloatRectangle(@Const @ByRef FloatRectangle rectangle) { super((Pointer)null); allocate(rectangle); }
        private native void allocate(@Const @ByRef FloatRectangle rectangle);

        /**
         * Copy assignment.
         * Similar to Rectangle<T>(const Rectangle<T>& rectangle).
         * @param rectangle Rectangle to be copied.
         * @return The resulting Rectangle.
         */
        public native @ByRef @Name("operator =") FloatRectangle put(@Const @ByRef FloatRectangle rectangle);

        /**
         * Move constructor.
         * It destroys the original Rectangle to be moved.
         * @param rectangle Rectangle to be moved.
         */

        /**
         * Move assignment.
         * Similar to Rectangle<T>(Rectangle<T>&& rectangle).
         * @param rectangle Rectangle to be moved.
         * @return The resulting Rectangle.
         */

        public native @ByVal FloatPoint center();

        public native @ByVal FloatPoint topLeft();

        public native @ByVal FloatPoint bottomRight();

        public native float area();

        public native void recenter(float newWidth, float newHeight);

        /**
         * It returns a string with the whole Rectangle<T> data. Useful for debugging.
         * The format is: {@code [x, y, width, height]}
         * @return A string with the Rectangle<T> values in the above format.
         */
        

        // ------------------------------ Basic Operators ------------------------------ //
        public native @ByRef @Name("operator *=") FloatRectangle multiplyPut(float value);

        public native @ByVal @Name("operator *") FloatRectangle multiply(float value);

        public native @ByRef @Name("operator /=") FloatRectangle dividePut(float value);

        public native @ByVal @Name("operator /") FloatRectangle divide(float value);
    }
