// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.openpose;

import org.bytedeco.javacpp.annotation.Index;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.hdf5.*;
import static org.bytedeco.hdf5.global.hdf5.*;
import org.bytedeco.caffe.*;
import static org.bytedeco.caffe.global.caffe.*;

import static org.bytedeco.openpose.global.openpose.*;

    /**
     * WrapperT: OpenPose all-in-one wrapper template class. Simplified into Wrapper for WrapperT<std::vector<Datum>>
     * WrapperT allows the user to set up the input (video, webcam, custom input, etc.), pose, face and/or hands
     * estimation and rendering, and output (integrated small GUI, custom output, etc.).
     *
     * This function can be used in 2 ways:
     *     - Synchronous mode: call the full constructor with your desired input and output workers.
     *     - Asynchronous mode: call the empty constructor WrapperT() + use the emplace and pop functions to push the
     *       original frames and retrieve the processed ones.
     *     - Mix of them:
     *         - Synchronous input + asynchronous output: call the constructor WrapperT(ThreadManagerMode::Synchronous,
     *           workersInput, {}, true)
     *         - Asynchronous input + synchronous output: call the constructor
     *           WrapperT(ThreadManagerMode::Synchronous, nullptr, workersOutput, irrelevantBoolean, true)
     */
    @Name("op::WrapperT<op::Datum,std::vector<std::shared_ptr<op::Datum> >,std::shared_ptr<std::vector<std::shared_ptr<op::Datum> > >,std::shared_ptr<op::Worker<std::shared_ptr<std::vector<std::shared_ptr<op::Datum> > > > > >") @NoOffset @Properties(inherit = org.bytedeco.openpose.presets.openpose.class)
public class OpWrapper extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public OpWrapper(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public OpWrapper(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public OpWrapper position(long position) {
            return (OpWrapper)super.position(position);
        }
        @Override public OpWrapper getPointer(long i) {
            return new OpWrapper((Pointer)this).offsetAddress(i);
        }
    
        /**
         * Constructor.
         * @param threadManagerMode Thread syncronization mode. If set to ThreadManagerMode::Synchronous, everything
         * will run inside the WrapperT. If ThreadManagerMode::Synchronous(In/Out), then input (frames producer) and/or
         * output (GUI, writing results, etc.) will be controlled outside the WrapperT class by the user. See
         * ThreadManagerMode for a detailed explanation of when to use each one.
         */
        public OpWrapper(ThreadManagerMode threadManagerMode/*=op::ThreadManagerMode::Synchronous*/) { super((Pointer)null); allocate(threadManagerMode); }
        private native void allocate(ThreadManagerMode threadManagerMode/*=op::ThreadManagerMode::Synchronous*/);
        public OpWrapper() { super((Pointer)null); allocate(); }
        private native void allocate();

        /**
         * Destructor.
         * It automatically frees resources.
         */

        /**
         * Disable multi-threading.
         * Useful for debugging and logging, all the Workers will run in the same thread.
         * Note that workerOnNewThread (argument for setWorker function) will not make any effect.
         */
        public native void disableMultiThreading();

        /**
         * Add an user-defined extra Worker for a desired task (input, output, ...).
         * @param workerType WorkerType to configure (e.g., Input, PreProcessing, PostProcessing, Output).
         * @param worker TWorker to be added.
         * @param workerOnNewThread Whether to add this TWorker on a new thread (if it is computationally demanding) or
         * simply reuse existing threads (for light functions). Set to true if the performance time is unknown.
         */
        public native void setWorker(WorkerType workerType, @Const @SharedPtr @ByRef DatumsWorker worker, @Cast("const bool") boolean workerOnNewThread/*=true*/);
        public native void setWorker(WorkerType workerType, @Const @SharedPtr @ByRef DatumsWorker worker);

        /**
         * It configures the pose parameters. Do not call for default values.
         */
        public native void configure(@Const @ByRef WrapperStructPose wrapperStructPose);

        /**
         * Analogous to configure(WrapperStructPose) but applied to face (WrapperStructFace)
         */
        public native void configure(@Const @ByRef WrapperStructFace wrapperStructFace);

        /**
         * Analogous to configure() but applied to hand (WrapperStructHand)
         */
        public native void configure(@Const @ByRef WrapperStructHand wrapperStructHand);

        /**
         * Analogous to configure() but applied to the extra options (WrapperStructExtra)
         */
        public native void configure(@Const @ByRef WrapperStructExtra wrapperStructExtra);

        /**
         * Analogous to configure() but applied to the input (WrapperStructInput)
         */
        public native void configure(@Const @ByRef WrapperStructInput wrapperStructInput);

        /**
         * Analogous to configure() but applied to the output (WrapperStructOutput)
         */
        public native void configure(@Const @ByRef WrapperStructOutput wrapperStructOutput);

        /**
         * Analogous to configure() but applied to the GUI (WrapperStructGui)
         */
        public native void configure(@Const @ByRef WrapperStructGui wrapperStructGui);

        /**
         * Function to start multi-threading.
         * Similar to start(), but exec() blocks the thread that calls the function (it saves 1 thread). Use exec()
         * instead of start() if the calling thread will otherwise be waiting for the WrapperT to end.
         */
        public native void exec();

        /**
         * Function to start multi-threading.
         * Similar to exec(), but start() does not block the thread that calls the function. It just opens new threads,
         * so it lets the user perform other tasks meanwhile on the calling thread.
         * VERY IMPORTANT NOTE: if the GUI is selected and OpenCV is compiled with Qt support, this option will not
         * work. Qt needs the main thread to plot visual results, so the final GUI (which uses OpenCV) would return an
         * exception similar to: {@code QMetaMethod::invoke: Unable to invoke methods with return values in queued
         * connections}. Use exec() in that case.
         */
        public native void start();

        /**
         * Function to stop multi-threading.
         * It can be called internally or externally.
         */
        public native void stop();

        /**
         * Whether the WrapperT is running.
         * It will return true after exec() or start() and before stop(), and false otherwise.
         * @return Boolean specifying whether the WrapperT is running.
         */
        public native @Cast("bool") boolean isRunning();

        /**
         * It sets the maximum number of elements in the queue.
         * For maximum speed, set to a very large number, but the trade-off would be:
         *  - Latency will hugely increase.
         *  - The program might go out of RAM memory (so the computer might freeze).
         * For minimum latency while keeping an optimal speed, set to -1, that will automatically
         * detect the ideal number based on how many elements are connected to that queue.
         * @param defaultMaxSizeQueues long long element with the maximum number of elements on the queue.
         */
        public native void setDefaultMaxSizeQueues(long defaultMaxSizeQueues/*=-1*/);
        public native void setDefaultMaxSizeQueues();

        /**
         * Emplace (move) an element on the first (input) queue.
         * Only valid if ThreadManagerMode::Asynchronous or ThreadManagerMode::AsynchronousIn.
         * If the input queue is full or the WrapperT was stopped, it will return false and not emplace it.
         * @param tDatums TDatumsSP element to be emplaced.
         * @return Boolean specifying whether the tDatums could be emplaced.
         */
        public native @Cast("bool") boolean tryEmplace(@SharedPtr @ByRef Datums tDatums);

        /**
         * Emplace (move) an element on the first (input) queue.
         * Similar to tryEmplace.
         * However, if the input queue is full, it will wait until it can emplace it.
         * If the WrapperT class is stopped before adding the element, it will return false and not emplace it.
         * @param tDatums TDatumsSP element to be emplaced.
         * @return Boolean specifying whether the tDatums could be emplaced.
         */
        public native @Cast("bool") boolean waitAndEmplace(@SharedPtr @ByRef Datums tDatums);

        /**
         * Similar to waitAndEmplace(const TDatumsSP& tDatums), but it takes a Matrix as input.
         * @param matrix Matrix with the image to be processed.
         * @return Boolean specifying whether the tDatums could be emplaced.
         */
        public native @Cast("bool") boolean waitAndEmplace(@ByRef Matrix matrix);

        /**
         * Push (copy) an element on the first (input) queue.
         * Same as tryEmplace, but it copies the data instead of moving it.
         * @param tDatums TDatumsSP element to be pushed.
         * @return Boolean specifying whether the tDatums could be pushed.
         */
        public native @Cast("bool") boolean tryPush(@Const @SharedPtr @ByRef Datums tDatums);

        /**
         * Push (copy) an element on the first (input) queue.
         * Same as waitAndEmplace, but it copies the data instead of moving it.
         * @param tDatums TDatumsSP element to be pushed.
         * @return Boolean specifying whether the tDatums could be pushed.
         */
        public native @Cast("bool") boolean waitAndPush(@Const @SharedPtr @ByRef Datums tDatums);

        /**
         * Similar to waitAndPush(const TDatumsSP& tDatums), but it takes a Matrix as input.
         * @param matrix Matrix with the image to be processed.
         * @return Boolean specifying whether the tDatums could be pushed.
         */
        public native @Cast("bool") boolean waitAndPush(@Const @ByRef Matrix matrix);

        /**
         * Pop (retrieve) an element from the last (output) queue.
         * Only valid if ThreadManagerMode::Asynchronous or ThreadManagerMode::AsynchronousOut.
         * If the output queue is empty or the WrapperT was stopped, it will return false and not retrieve it.
         * @param tDatums TDatumsSP element where the retrieved element will be placed.
         * @return Boolean specifying whether the tDatums could be retrieved.
         */
        public native @Cast("bool") boolean tryPop(@SharedPtr @ByRef Datums tDatums);

        /**
         * Pop (retrieve) an element from the last (output) queue.
         * Similar to tryPop.
         * However, if the output queue is empty, it will wait until it can pop an element.
         * If the WrapperT class is stopped before popping the element, it will return false and not retrieve it.
         * @param tDatums TDatumsSP element where the retrieved element will be placed.
         * @return Boolean specifying whether the tDatums could be retrieved.
         */
        public native @Cast("bool") boolean waitAndPop(@SharedPtr @ByRef Datums tDatums);

        /**
         * Runs both waitAndEmplace and waitAndPop.
         * @param tDatums TDatumsSP element where the retrieved element will be placed.
         * @return Boolean specifying whether the tDatums could be retrieved.
         */
        public native @Cast("bool") boolean emplaceAndPop(@SharedPtr @ByRef Datums tDatums);

        /**
         * Similar to emplaceAndPop(TDatumsSP& tDatums), but it takes a Matrix as input.
         * @param matrix Matrix with the image to be processed.
         * @return TDatumsSP element where the processed information will be placed.
         */
        public native @SharedPtr @ByVal Datums emplaceAndPop(@Const @ByRef Matrix matrix);
    }
