/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.procamtracker;

import java.awt.Color;
import java.awt.Point;
import org.bytedeco.javacpp.helper.opencv_core;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacv.BaseChildSettings;
import org.bytedeco.javacv.CanvasFrame;
import org.bytedeco.javacv.JavaCV;

public class VirtualBall {
    private Settings settings;
    private double[] roiPts;
    private double[] insidePosition;
    private double[] position;
    private double[] velocity;
    private double timeLeft;
    private opencv_core.CvPoint center = new opencv_core.CvPoint();

    public VirtualBall(Settings settings) {
        this.setSettings(settings);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
        this.roiPts = (double[])settings.initialRoiPts.clone();
        this.insidePosition = (double[])settings.initialPosition.clone();
        this.position = (double[])settings.initialPosition.clone();
        this.velocity = (double[])settings.initialVelocity.clone();
    }

    public static double[] intersectLines(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double d = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        double ua = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / d;
        ua = ua < 0.0 ? 0.0 : (ua > 1.0 ? 1.0 : ua);
        return new double[]{x1 + ua * (x2 - x1), y1 + ua * (y2 - y1)};
    }

    public static double closestPointOnLine(double x1, double y1, double x2, double y2, double x3, double y3) {
        return ((x3 - x1) * (x2 - x1) + (y3 - y1) * (y2 - y1)) / ((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static double distanceToLine(double x1, double y1, double x2, double y2, double x3, double y3) {
        double u = VirtualBall.closestPointOnLine(x1, y1, x2, y2, x3, y3);
        double rx = x1 + u * (x2 - x1) - x3;
        double ry = y1 + u * (y2 - y1) - y3;
        return Math.sqrt(rx * rx + ry * ry);
    }

    public static double[] boostFromMovingLine(double x1, double y1, double x2, double y2, double x1p, double y1p, double x2p, double y2p, double x3, double y3) {
        double u = VirtualBall.closestPointOnLine(x1, y1, x2, y2, x3, y3);
        double up = VirtualBall.closestPointOnLine(x1p, y1p, x2p, y2p, x3, y3);
        double cx1 = x1 + u * (x2 - x1);
        double cy1 = y1 + u * (y2 - y1);
        double cx1p = x1p + up * (x2p - x1p);
        double cy1p = y1p + up * (y2p - y1p);
        double boostx = 0.0;
        double boosty = 0.0;
        if ((x3 - cx1) * (cx1p - cx1) + (y3 - cy1) * (cy1p - cy1) > 0.0) {
            boostx = cx1p - cx1;
            boosty = cy1p - cy1;
        }
        return new double[]{boostx, boosty};
    }

    private boolean rollOffMovingLine(double x1, double y1, double x2, double y2, double x1p, double y1p, double x2p, double y2p) {
        double[] n = JavaCV.unitize(y1p - y2p, x2p - x1p);
        if ((this.insidePosition[0] - x1) * n[0] + (this.insidePosition[1] - y1) * n[1] < 0.0) {
            n[0] = -n[0];
            n[1] = -n[1];
        }
        if (n[0] * this.settings.gravity[0] + n[1] * this.settings.gravity[1] >= 0.0) {
            return false;
        }
        double vx = this.velocity[0] * this.timeLeft;
        double vy = this.velocity[1] * this.timeLeft;
        double x3 = this.position[0];
        double y3 = this.position[1];
        double x3p = this.position[0] + vx;
        double y3p = this.position[1] + vy;
        double dist = VirtualBall.distanceToLine(x1, y1, x2, y2, x3, y3);
        double distp = VirtualBall.distanceToLine(x1, y1, x2, y2, x3p, y3p);
        if (dist < this.settings.radius + 1.0 && dist > this.settings.radius - 1.0 && distp < this.settings.radius + 1.0 && distp > this.settings.radius - 1.0) {
            double[] l = JavaCV.unitize(x2p - x1p, y2p - y1p);
            double v = l[0] * (this.velocity[0] + this.settings.gravity[0]) + l[1] * (this.velocity[1] + this.settings.gravity[1]);
            v = v > 0.0 ? Math.max(0.0, v - this.settings.friction) : Math.min(0.0, v + this.settings.friction);
            this.velocity[0] = l[0] * v;
            this.velocity[1] = l[1] * v;
            double[] boost = VirtualBall.boostFromMovingLine(x1, y1, x2, y2, x1p, y1p, x2p, y2p, x3, y3);
            double b = Math.sqrt(boost[0] * boost[0] + boost[1] * boost[1]);
            if (b > this.settings.stickiness) {
                this.velocity[0] = this.velocity[0] + boost[0] * (1.0 + this.settings.radius / b);
                this.velocity[1] = this.velocity[1] + boost[1] * (1.0 + this.settings.radius / b);
            } else if (b > 0.0) {
                this.position[0] = this.position[0] + boost[0] * (1.0 + this.settings.radius / b);
                this.position[1] = this.position[1] + boost[1] * (1.0 + this.settings.radius / b);
            }
            vx = this.velocity[0] * this.timeLeft;
            vy = this.velocity[1] * this.timeLeft;
            x3p = this.position[0] + vx;
            y3p = this.position[1] + vy;
            if (VirtualBall.distanceToLine(x1p, y1p, x2p, y2p, x3p, y3p) < this.settings.radius * 0.999) {
                this.timeLeft = 0.0;
                this.velocity[0] = 0.0;
                this.velocity[1] = 0.0;
            }
            return true;
        }
        return false;
    }

    private boolean bounceOffMovingLine(double x1, double y1, double x2, double y2, double x1p, double y1p, double x2p, double y2p) {
        boolean bounced = false;
        double vx = this.velocity[0] * this.timeLeft;
        double vy = this.velocity[1] * this.timeLeft;
        double x3 = this.position[0];
        double y3 = this.position[1];
        double y3p = this.position[1] + vy;
        double x3p = this.position[0] + vx;
        if (Math.signum((x2p - x1p) * (y3p - y1p) - (y2p - y1p) * (x3p - x1p)) != Math.signum((x2 - x1) * (y3 - y1) - (y2 - y1) * (x3 - x1)) || VirtualBall.distanceToLine(x1p, y1p, x2p, y2p, x3p, y3p) < this.settings.radius * 0.999) {
            double[] boost;
            double b;
            double[] l = JavaCV.unitize(x2p - x1p, y2p - y1p);
            double[] n = JavaCV.unitize(y1p - y2p, x2p - x1p);
            if ((this.insidePosition[0] - x1) * n[0] + (this.insidePosition[1] - y1) * n[1] < 0.0) {
                n[0] = -n[0];
                n[1] = -n[1];
            }
            double[] p = VirtualBall.intersectLines(x1p + this.settings.radius * (n[0] + l[0]), y1p + this.settings.radius * (n[1] + l[1]), x2p + this.settings.radius * (n[0] - l[0]), y2p + this.settings.radius * (n[1] - l[1]), x3, y3, x3p, y3p);
            double dx = p[0] - this.position[0];
            double dy = p[1] - this.position[1];
            this.position[0] = p[0];
            this.position[1] = p[1];
            double timeTaken = Math.sqrt(dx * dx + dy * dy) / Math.sqrt(vx * vx + vy * vy);
            double vn = this.velocity[0] * n[0] + this.velocity[1] * n[1];
            if (timeTaken > 0.0 && vn < 0.0) {
                if (Math.sqrt(this.velocity[0] * this.velocity[0] + this.velocity[1] * this.velocity[1]) < 1.0) {
                    this.timeLeft = 0.0;
                    this.velocity[0] = 0.0;
                    this.velocity[1] = 0.0;
                } else {
                    this.timeLeft = timeTaken >= 1.0 ? 0.0 : (this.timeLeft -= timeTaken * this.timeLeft);
                    this.velocity[0] = (this.velocity[0] - 2.0 * n[0] * vn) * this.settings.elasticity;
                    this.velocity[1] = (this.velocity[1] - 2.0 * n[1] * vn) * this.settings.elasticity;
                    bounced = true;
                }
            }
            if ((b = Math.sqrt((boost = VirtualBall.boostFromMovingLine(x1, y1, x2, y2, x1p, y1p, x2p, y2p, x3, y3))[0] * boost[0] + boost[1] * boost[1])) > this.settings.stickiness) {
                this.velocity[0] = this.velocity[0] + boost[0] * (1.0 + this.settings.radius / b);
                this.velocity[1] = this.velocity[1] + boost[1] * (1.0 + this.settings.radius / b);
                bounced = true;
            } else if (b > 0.0) {
                this.position[0] = this.position[0] + boost[0] * (1.0 + this.settings.radius / b);
                this.position[1] = this.position[1] + boost[1] * (1.0 + this.settings.radius / b);
                bounced = true;
            }
        }
        return bounced;
    }

    public void draw(opencv_core.IplImage image, double[] roiPts) {
        assert (this.roiPts.length == roiPts.length);
        this.insidePosition[0] = this.position[0];
        this.insidePosition[1] = this.position[1];
        this.timeLeft = 1.0;
        boolean rolledOff = false;
        int l = roiPts.length;
        for (int i = 0; i < l && this.timeLeft > 0.0; i += 2) {
            double x1 = this.roiPts[i % l];
            double y1 = this.roiPts[(i + 1) % l];
            double x2 = this.roiPts[(i + 2) % l];
            double y2 = this.roiPts[(i + 3) % l];
            double x3 = roiPts[i % l];
            double y3 = roiPts[(i + 1) % l];
            double x4 = roiPts[(i + 2) % l];
            double y4 = roiPts[(i + 3) % l];
            if (!this.rollOffMovingLine(x1, y1, x2, y2, x3, y3, x4, y4)) continue;
            rolledOff = true;
            break;
        }
        if (!rolledOff) {
            this.velocity[0] = this.velocity[0] + this.settings.gravity[0];
            this.velocity[1] = this.velocity[1] + this.settings.gravity[1];
        }
        boolean bouncing = true;
        while (bouncing) {
            bouncing = false;
            for (int i = 0; i < l && this.timeLeft > 0.0; i += 2) {
                double x1 = this.roiPts[i % l];
                double y1 = this.roiPts[(i + 1) % l];
                double x2 = this.roiPts[(i + 2) % l];
                double y2 = this.roiPts[(i + 3) % l];
                double x3 = roiPts[i % l];
                double y3 = roiPts[(i + 1) % l];
                double x4 = roiPts[(i + 2) % l];
                double y4 = roiPts[(i + 3) % l];
                if (!this.bounceOffMovingLine(x1, y1, x2, y2, x3, y3, x4, y4)) continue;
                bouncing = true;
            }
        }
        if (this.timeLeft > 0.0) {
            this.position[0] = this.position[0] + this.velocity[0] * this.timeLeft;
            this.position[1] = this.position[1] + this.velocity[1] * this.timeLeft;
        }
        opencv_core.IplROI roi = image.roi();
        this.center.x((int)Math.round((this.position[0] - (double)(roi != null ? roi.xOffset() : 0)) * 65536.0));
        this.center.y((int)Math.round((this.position[1] - (double)(roi != null ? roi.yOffset() : 0)) * 65536.0));
        opencv_core.cvCircle((opencv_core.CvArr)image, (opencv_core.CvPoint)this.center, (int)((int)Math.round(this.settings.radius * 65536.0)), (opencv_core.CvScalar)(image.nChannels() == 4 ? this.settings.colorRGB : this.settings.colorBGR), (int)-1, (int)16, (int)16);
        this.roiPts = (double[])roiPts.clone();
    }

    public static void main(String[] args) throws Exception {
        CanvasFrame frame = new CanvasFrame("Virtual Ball Test");
        opencv_core.IplImage image = opencv_core.IplImage.create((int)640, (int)960, (int)8, (int)3);
        opencv_core.cvSetZero((opencv_core.CvArr)image);
        double[] roiPts = new double[]{0.0, 0.0, 640.0, 0.0, 640.0, 480.0, 0.0, 400.0};
        opencv_core.cvFillConvexPoly((opencv_core.CvArr)image, (opencv_core.CvPoint)new opencv_core.CvPoint().put((byte)16, roiPts), (int)(roiPts.length / 2), (opencv_core.CvScalar)opencv_core.CvScalar.WHITE, (int)16, (int)16);
        VirtualBall virtualBall = new VirtualBall(new Settings(roiPts));
        for (int i = 0; i < 1000; ++i) {
            Thread.sleep(100L);
            opencv_core.cvSetZero((opencv_core.CvArr)image);
            if (i == 50) {
                roiPts[5] = roiPts[5] - 100.0;
            }
            if (i > 100 && i < 1200) {
                roiPts[3] = roiPts[3] + 1.0;
                roiPts[5] = roiPts[5] + 1.0;
            }
            opencv_core.cvFillConvexPoly((opencv_core.CvArr)image, (opencv_core.CvPoint)new opencv_core.CvPoint().put((byte)16, roiPts), (int)(roiPts.length / 2), (opencv_core.CvScalar)opencv_core.CvScalar.WHITE, (int)16, (int)16);
            virtualBall.draw(image, roiPts);
            frame.showImage((opencv_core.AbstractArray)image);
        }
    }

    public static class Settings
    extends BaseChildSettings {
        double[] initialRoiPts;
        double[] initialPosition = new double[]{0.0, 0.0};
        double[] initialVelocity = new double[]{0.0, 0.0};
        double[] gravity = new double[]{0.0, 10.0};
        double elasticity = 0.9;
        double friction = 0.0;
        double stickiness = 5.0;
        double radius = 20.0;
        opencv_core.CvScalar colorBGR = opencv_core.cvScalar((double)0.0, (double)0.0, (double)255.0, (double)0.0);
        opencv_core.CvScalar colorRGB = opencv_core.cvScalar((double)255.0, (double)0.0, (double)0.0, (double)0.0);

        public Settings() {
        }

        public Settings(double[] roiPts) {
            this.setInitialRoiPts(roiPts);
        }

        public void setInitialRoiPts(double[] initialRoiPts) {
            this.initialRoiPts = (double[])initialRoiPts.clone();
            this.initialPosition[1] = 0.0;
            this.initialPosition[0] = 0.0;
            for (int i = 0; i < initialRoiPts.length; i += 2) {
                this.initialPosition[0] = this.initialPosition[0] + initialRoiPts[i];
                this.initialPosition[1] = this.initialPosition[1] + initialRoiPts[i + 1];
            }
            this.initialPosition[0] = this.initialPosition[0] / (double)(initialRoiPts.length / 2);
            this.initialPosition[1] = this.initialPosition[1] / (double)(initialRoiPts.length / 2);
        }

        public void setInitialPosition(double[] initialPosition) {
            this.initialPosition = initialPosition;
        }

        public Point getInitialVelocity() {
            Point p = new Point();
            p.setLocation(this.initialVelocity[0], this.initialVelocity[1]);
            return p;
        }

        public void setInitialVelocity(Point initialVelocity) {
            this.initialVelocity = new double[]{initialVelocity.getX(), initialVelocity.getY()};
        }

        public Point getGravity() {
            Point p = new Point();
            p.setLocation(this.gravity[0], this.gravity[1]);
            return p;
        }

        public void setGravity(Point gravity) {
            this.gravity = new double[]{gravity.getX(), gravity.getY()};
        }

        public double getElasticity() {
            return this.elasticity;
        }

        public void setElasticity(double elasticity) {
            this.elasticity = elasticity;
        }

        public double getFriction() {
            return this.friction;
        }

        public void setFriction(double friction) {
            this.friction = friction;
        }

        public double getStickiness() {
            return this.stickiness;
        }

        public void setStickiness(double stickiness) {
            this.stickiness = stickiness;
        }

        public double getRadius() {
            return this.radius;
        }

        public void setRadius(double radius) {
            this.radius = radius;
        }

        public Color getColor() {
            return new Color((float)this.colorRGB.val(0) / 255.0f, (float)this.colorRGB.val(1) / 255.0f, (float)this.colorRGB.val(2) / 255.0f);
        }

        public void setColor(Color color) {
            float[] rgb = color.getRGBComponents(null);
            this.colorRGB.val(0, (double)(rgb[0] * 255.0f));
            this.colorRGB.val(1, (double)(rgb[1] * 255.0f));
            this.colorRGB.val(2, (double)(rgb[2] * 255.0f));
            this.colorBGR.val(0, (double)(rgb[2] * 255.0f));
            this.colorBGR.val(1, (double)(rgb[1] * 255.0f));
            this.colorBGR.val(2, (double)(rgb[0] * 255.0f));
        }
    }
}

