/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_highgui;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameConverter;
import org.bytedeco.javacv.FrameGrabber;
import org.bytedeco.javacv.OpenCVFrameConverter;

public class IPCameraFrameGrabber
extends FrameGrabber {
    private static FrameGrabber.Exception loadingException = null;
    private URL url;
    private URLConnection connection;
    private InputStream input;
    private Map<String, List<String>> headerfields;
    private String boundryKey;
    private opencv_core.IplImage decoded = null;
    private FrameConverter converter = new OpenCVFrameConverter.ToIplImage();

    public static void tryLoad() throws FrameGrabber.Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(opencv_highgui.class);
        }
        catch (Throwable t) {
            loadingException = new FrameGrabber.Exception("Failed to load " + IPCameraFrameGrabber.class, t);
            throw loadingException;
        }
    }

    public IPCameraFrameGrabber(String urlstr) throws MalformedURLException {
        this.url = new URL(urlstr);
    }

    @Override
    public void start() {
        try {
            this.connection = this.url.openConnection();
            this.headerfields = this.connection.getHeaderFields();
            if (this.headerfields.containsKey("Content-Type")) {
                List<String> ct = this.headerfields.get("Content-Type");
                for (int i = 0; i < ct.size(); ++i) {
                    String key = ct.get(i);
                    int j = key.indexOf("boundary=");
                    if (j == -1) continue;
                    this.boundryKey = key.substring(j + 9);
                }
            }
            this.input = this.connection.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() throws FrameGrabber.Exception {
        try {
            this.input.close();
            this.input = null;
            this.connection = null;
            this.url = null;
            if (this.decoded != null) {
                opencv_core.cvReleaseImage(this.decoded);
            }
        }
        catch (IOException e) {
            throw new FrameGrabber.Exception(e.getMessage(), e);
        }
    }

    @Override
    public void trigger() throws FrameGrabber.Exception {
    }

    @Override
    public Frame grab() throws FrameGrabber.Exception {
        try {
            byte[] b = this.readImage();
            opencv_core.CvMat mat = opencv_core.cvMat(1, b.length, opencv_core.CV_8UC1, new BytePointer(b));
            if (this.decoded != null) {
                opencv_core.cvReleaseImage(this.decoded);
            }
            this.decoded = opencv_highgui.cvDecodeImage(mat);
            return this.converter.convert(this.decoded);
        }
        catch (IOException e) {
            throw new FrameGrabber.Exception(e.getMessage(), e);
        }
    }

    public BufferedImage grabBufferedImage() throws IOException {
        BufferedImage bi = ImageIO.read(new ByteArrayInputStream(this.readImage()));
        return bi;
    }

    byte[] readImage() throws IOException {
        int c;
        byte[] buffer = new byte[4096];
        int n = -1;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StringBuffer sb = new StringBuffer();
        int total = 0;
        while ((c = this.input.read()) != -1) {
            if (c <= 0) continue;
            sb.append((char)c);
            if (c != 13) continue;
            sb.append((char)this.input.read());
            c = this.input.read();
            sb.append((char)c);
            if (c != 13) continue;
            sb.append((char)this.input.read());
            break;
        }
        String subheader = sb.toString();
        int contentLength = -1;
        int c0 = subheader.indexOf("Content-Length: ");
        int c1 = subheader.indexOf(13, c0);
        if (c0 < 0) {
            return null;
        }
        contentLength = Integer.parseInt(subheader.substring(c0 += 16, c1).trim());
        if (contentLength > buffer.length) {
            buffer = new byte[contentLength];
        }
        n = -1;
        total = 0;
        while ((n = this.input.read(buffer, 0, contentLength - total)) != -1) {
            baos.write(buffer, 0, n);
            if ((total += n) != contentLength) continue;
        }
        baos.flush();
        this.input.read();
        this.input.read();
        this.input.read();
        this.input.read();
        return baos.toByteArray();
    }

    @Override
    public void release() throws FrameGrabber.Exception {
    }
}

