/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.CharBuffer;
import org.bytedeco.javacpp.CharPointer;
import org.bytedeco.javacpp.indexer.CharArrayIndexer;
import org.bytedeco.javacpp.indexer.CharBufferIndexer;
import org.bytedeco.javacpp.indexer.Indexer;

public abstract class CharIndexer
extends Indexer {
    protected CharIndexer(int[] sizes, int[] strides) {
        super(sizes, strides);
    }

    public static CharIndexer create(char[] array, int[] sizes, int[] strides) {
        return new CharArrayIndexer(array, sizes, strides);
    }

    public static CharIndexer create(CharBuffer buffer, int[] sizes, int[] strides) {
        return new CharBufferIndexer(buffer, sizes, strides);
    }

    public static CharIndexer create(CharPointer pointer, int[] sizes, int[] strides) {
        return CharIndexer.create(pointer, sizes, strides, true);
    }

    public static CharIndexer create(final CharPointer pointer, int[] sizes, int[] strides, boolean direct) {
        if (direct) {
            return new CharBufferIndexer(pointer.asBuffer(), sizes, strides);
        }
        final int position = pointer.position();
        char[] array = new char[pointer.limit() - position];
        pointer.get(array);
        return new CharArrayIndexer(array, sizes, strides){

            @Override
            public void release() {
                pointer.position(position).put(this.array);
                super.release();
            }
        };
    }

    public abstract char get(int var1);

    public CharIndexer get(int i, char[] c) {
        return this.get(i, c, 0, c.length);
    }

    public abstract CharIndexer get(int var1, char[] var2, int var3, int var4);

    public abstract char get(int var1, int var2);

    public CharIndexer get(int i, int j, char[] c) {
        return this.get(i, j, c, 0, c.length);
    }

    public abstract CharIndexer get(int var1, int var2, char[] var3, int var4, int var5);

    public abstract char get(int var1, int var2, int var3);

    public abstract char get(int ... var1);

    public CharIndexer get(int[] indices, char[] c) {
        return this.get(indices, c, 0, c.length);
    }

    public abstract CharIndexer get(int[] var1, char[] var2, int var3, int var4);

    public abstract CharIndexer put(int var1, char var2);

    public CharIndexer put(int i, char ... c) {
        return this.put(i, c, 0, c.length);
    }

    public abstract CharIndexer put(int var1, char[] var2, int var3, int var4);

    public abstract CharIndexer put(int var1, int var2, char var3);

    public CharIndexer put(int i, int j, char ... c) {
        return this.put(i, j, c, 0, c.length);
    }

    public abstract CharIndexer put(int var1, int var2, char[] var3, int var4, int var5);

    public abstract CharIndexer put(int var1, int var2, int var3, char var4);

    public abstract CharIndexer put(int[] var1, char var2);

    public CharIndexer put(int[] indices, char ... c) {
        return this.put(indices, c, 0, c.length);
    }

    public abstract CharIndexer put(int[] var1, char[] var2, int var3, int var4);

    @Override
    public double getDouble(int ... indices) {
        return this.get(indices);
    }
}

