/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.tools;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import org.bytedeco.javacpp.tools.Info;
import org.bytedeco.javacpp.tools.Token;
import org.bytedeco.javacpp.tools.Tokenizer;

public class InfoMap
extends HashMap<String, LinkedList<Info>> {
    InfoMap parent = null;
    static final String[] containers = new String[]{"std::deque", "std::list", "std::map", "std::queue", "std::set", "std::stack", "std::vector", "std::valarray"};
    static final String[] simpleTypes = new String[]{"signed", "unsigned", "char", "short", "int", "long", "bool", "float", "double"};
    static final InfoMap defaults;

    public InfoMap() {
        this.parent = defaults;
    }

    public InfoMap(InfoMap parent) {
        this.parent = parent;
    }

    static String normalize(String name, boolean unconst, boolean untemplate) {
        int i;
        if (name == null || name.length() == 0) {
            return name;
        }
        boolean foundConst = false;
        boolean simpleType = true;
        Object[] tokens = new Tokenizer(name).tokenize();
        int n = tokens.length;
        for (i = 0; i < n; ++i) {
            if (tokens[i].match(Token.CONST)) {
                foundConst = true;
                for (int j = i + 1; j < n; ++j) {
                    tokens[j - 1] = tokens[j];
                }
                --i;
                --n;
                continue;
            }
            if (Arrays.binarySearch(simpleTypes, ((Token)tokens[i]).value) >= 0) continue;
            simpleType = false;
            break;
        }
        if (simpleType) {
            Arrays.sort(tokens, 0, n);
            name = (foundConst ? "const " : "") + ((Token)tokens[0]).value;
            for (i = 1; i < n; ++i) {
                name = name + " " + ((Token)tokens[i]).value;
            }
        } else if (untemplate) {
            int i2;
            int count = 0;
            int template = -1;
            for (i2 = 0; i2 < n; ++i2) {
                if (((Token)tokens[i2]).match(Character.valueOf('<'))) {
                    if (count == 0) {
                        template = i2;
                    }
                    ++count;
                    continue;
                }
                if (!((Token)tokens[i2]).match(Character.valueOf('>')) || --count != 0 || i2 + 1 == n) continue;
                template = -1;
            }
            if (template >= 0) {
                name = foundConst ? "const " : "";
                for (i2 = 0; i2 < template; ++i2) {
                    name = name + ((Token)tokens[i2]).value;
                }
            }
        }
        if (unconst && foundConst) {
            name = name.substring(name.indexOf("const") + 5);
        }
        return name.trim();
    }

    public LinkedList<Info> get(String cppName) {
        return this.get(cppName, true);
    }

    public LinkedList<Info> get(String cppName, boolean partial) {
        LinkedList<Info> l;
        String key = InfoMap.normalize(cppName, false, false);
        LinkedList<Info> infoList = (LinkedList<Info>)super.get(key);
        if (infoList == null) {
            key = InfoMap.normalize(cppName, true, false);
            infoList = (LinkedList<Info>)super.get(key);
        }
        if (infoList == null && partial) {
            key = InfoMap.normalize(cppName, true, true);
            infoList = (LinkedList)super.get(key);
        }
        if (infoList == null) {
            infoList = new LinkedList<Info>();
        }
        if (this.parent != null && (l = this.parent.get(cppName, partial)) != null && l.size() > 0) {
            infoList = new LinkedList<Info>(infoList);
            infoList.addAll(l);
        }
        return infoList;
    }

    public Info get(int index, String cppName) {
        return this.get(index, cppName, true);
    }

    public Info get(int index, String cppName, boolean partial) {
        LinkedList<Info> infoList = this.get(cppName, partial);
        return infoList.size() > 0 ? infoList.get(index) : null;
    }

    public Info getFirst(String cppName) {
        return this.getFirst(cppName, true);
    }

    public Info getFirst(String cppName, boolean partial) {
        LinkedList<Info> infoList = this.get(cppName, partial);
        return infoList.size() > 0 ? infoList.getFirst() : null;
    }

    @Override
    public InfoMap put(int index, Info info) {
        String[] stringArray;
        if (info.cppNames != null) {
            stringArray = info.cppNames;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = null;
        }
        for (String cppName : stringArray) {
            String[] keys;
            block5: for (String key : keys = new String[]{InfoMap.normalize(cppName, false, false), InfoMap.normalize(cppName, false, true)}) {
                LinkedList<Info> infoList = (LinkedList<Info>)super.get(key);
                if (infoList == null) {
                    infoList = new LinkedList<Info>();
                    super.put(key, infoList);
                }
                if (infoList.contains(info)) continue;
                switch (index) {
                    case -1: {
                        infoList.add(info);
                        continue block5;
                    }
                    case 0: {
                        infoList.addFirst(info);
                        continue block5;
                    }
                    default: {
                        infoList.add(index, info);
                    }
                }
            }
        }
        return this;
    }

    public InfoMap put(Info info) {
        return this.put(-1, info);
    }

    public InfoMap putFirst(Info info) {
        return this.put(0, info);
    }

    static {
        Arrays.sort(simpleTypes);
        defaults = new InfoMap(null).put(new Info(" __attribute__", "__declspec").annotations(new String[0]).skip()).put(new Info("void").valueTypes("void").pointerTypes("Pointer")).put(new Info("va_list", "FILE", "std::exception", "std::istream", "std::ostream", "std::iostream", "std::ifstream", "std::ofstream", "std::fstream").cast().pointerTypes("Pointer")).put(new Info("int8_t", "jbyte", "signed char").valueTypes("byte").pointerTypes("BytePointer", "ByteBuffer", "byte[]")).put(new Info("uint8_t", "char", "unsigned char").cast().valueTypes("byte").pointerTypes("BytePointer", "ByteBuffer", "byte[]")).put(new Info("int16_t", "jshort", "short", "signed short", "short int", "signed short int").valueTypes("short").pointerTypes("ShortPointer", "ShortBuffer", "short[]")).put(new Info("uint16_t", "unsigned short", "unsigned short int").cast().valueTypes("short").pointerTypes("ShortPointer", "ShortBuffer", "short[]")).put(new Info("int32_t", "jint", "int", "signed int", "signed").valueTypes("int").pointerTypes("IntPointer", "IntBuffer", "int[]")).put(new Info("uint32_t", "unsigned int", "unsigned").cast().valueTypes("int").pointerTypes("IntPointer", "IntBuffer", "int[]")).put(new Info("int64_t", "__int64", "jlong", "long long", "signed long long", "long long int", "signed long long int").valueTypes("long").pointerTypes("LongPointer", "LongBuffer", "long[]")).put(new Info("uint64_t", "__uint64", "unsigned long long", "unsigned long long int").cast().valueTypes("long").pointerTypes("LongPointer", "LongBuffer", "long[]")).put(new Info("long", "signed long", "long int", "signed long int").valueTypes("long").pointerTypes("CLongPointer")).put(new Info("unsigned long", "unsigned long int").cast().valueTypes("long").pointerTypes("CLongPointer")).put(new Info("size_t", "ptrdiff_t").cast().valueTypes("long").pointerTypes("SizeTPointer")).put(new Info("float", "jfloat").valueTypes("float").pointerTypes("FloatPointer", "FloatBuffer", "float[]")).put(new Info("double", "jdouble").valueTypes("double").pointerTypes("DoublePointer", "DoubleBuffer", "double[]")).put(new Info("std::complex<float>").cast().pointerTypes("FloatPointer", "FloatBuffer", "float[]")).put(new Info("std::complex<double>").cast().pointerTypes("DoublePointer", "DoubleBuffer", "double[]")).put(new Info("bool", "jboolean").cast().valueTypes("boolean").pointerTypes("BoolPointer")).put(new Info("wchar_t", "WCHAR").cast().valueTypes("char").pointerTypes("CharPointer")).put(new Info("const char").valueTypes("byte").pointerTypes("@Cast(\"const char*\") BytePointer", "String")).put(new Info("std::string").annotations("@StdString").valueTypes("BytePointer", "String")).put(new Info("std::vector").annotations("@StdVector")).put(new Info("operator->").javaNames("access")).put(new Info("operator()").javaNames("apply")).put(new Info("operator[]").javaNames("get")).put(new Info("operator=").javaNames("put")).put(new Info("operator+").javaNames("add")).put(new Info("operator-").javaNames("subtract")).put(new Info("operator*").javaNames("multiply")).put(new Info("operator/").javaNames("divide")).put(new Info("operator%").javaNames("mod")).put(new Info("operator++").javaNames("increment")).put(new Info("operator--").javaNames("decrement")).put(new Info("operator==").javaNames("equals")).put(new Info("operator!=").javaNames("notEquals")).put(new Info("operator<").javaNames("lessThan")).put(new Info("operator>").javaNames("greaterThan")).put(new Info("operator<=").javaNames("lessThanEquals")).put(new Info("operator>=").javaNames("greaterThanEquals")).put(new Info("operator!").javaNames("not")).put(new Info("operator&&").javaNames("and")).put(new Info("operator||").javaNames("or")).put(new Info("operator&").javaNames("and")).put(new Info("operator|").javaNames("or")).put(new Info("operator^").javaNames("xor")).put(new Info("operator~").javaNames("not")).put(new Info("operator<<").javaNames("shiftLeft")).put(new Info("operator>>").javaNames("shiftRight")).put(new Info("operator+=").javaNames("addPut")).put(new Info("operator-=").javaNames("subtractPut")).put(new Info("operator*=").javaNames("multiplyPut")).put(new Info("operator/=").javaNames("dividePut")).put(new Info("operator%=").javaNames("modPut")).put(new Info("operator&=").javaNames("andPut")).put(new Info("operator|=").javaNames("orPut")).put(new Info("operator^=").javaNames("xorPut")).put(new Info("operator<<=").javaNames("shiftLeftPut")).put(new Info("operator>>=").javaNames("shiftRightPut")).put(new Info("allocate").javaNames("_allocate")).put(new Info("deallocate").javaNames("_deallocate")).put(new Info("address").javaNames("_address")).put(new Info("position").javaNames("_position")).put(new Info("limit").javaNames("_limit")).put(new Info("capacity").javaNames("_capacity"));
    }
}

