/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.procamtracker;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.bytedeco.javacpp.opencv_core;

public class Chronometer {
    private Rectangle roi;
    private long startTime;
    private BufferedImage chronoImage;
    private Graphics2D chronoGraphics;
    private Font bigFont;
    private Font smallFont;
    private FontMetrics bigFontMetrics;
    private Rectangle2D bounds;

    Chronometer(Rectangle roi, int imageType) {
        this(roi, imageType, -1L);
    }

    Chronometer(Rectangle roi, int imageType, long startTime) {
        FontMetrics bigFontMetrics;
        Font smallFont;
        Font bigFont;
        Rectangle2D bounds;
        this.roi = (Rectangle)roi.clone();
        this.startTime = startTime;
        this.chronoImage = new BufferedImage(roi.width, roi.height, imageType);
        this.chronoGraphics = (Graphics2D)this.chronoImage.getGraphics();
        int fontSize = 10;
        do {
            bigFont = new Font("Sans", 1, fontSize);
            smallFont = new Font("Sans", 1, fontSize * 9 / 10);
            bigFontMetrics = this.chronoGraphics.getFontMetrics(bigFont);
            bounds = bigFontMetrics.getStringBounds("0\u203200\u20330", this.chronoGraphics);
            ++fontSize;
        } while (bounds.getWidth() * 1.1 < (double)roi.width && bounds.getHeight() * 1.1 < (double)roi.height);
        this.bigFont = bigFont;
        this.smallFont = smallFont;
        this.bigFontMetrics = bigFontMetrics;
        this.bounds = bounds;
        this.chronoGraphics.setBackground(Color.WHITE);
        this.chronoGraphics.setColor(Color.BLACK);
        this.chronoGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public void draw(opencv_core.IplImage image) {
        long time;
        if (this.startTime < 0L) {
            this.startTime = System.currentTimeMillis();
            time = 0L;
        } else {
            time = System.currentTimeMillis() - this.startTime;
        }
        long minutes = time / 1000L / 60L;
        long seconds = time / 1000L - minutes * 60L;
        long deciseconds = time / 100L - seconds * 10L - minutes * 600L;
        this.chronoGraphics.clearRect(0, 0, this.chronoImage.getWidth(), this.chronoImage.getHeight());
        this.chronoGraphics.setFont(this.bigFont);
        int x = (int)(((double)this.roi.width - this.bounds.getWidth()) / 2.0 - this.bounds.getX());
        int y = (int)(((double)this.roi.height - this.bounds.getHeight()) / 2.0 - this.bounds.getY());
        this.chronoGraphics.drawString("" + minutes, x, y);
        this.chronoGraphics.drawString("\u2032", x += this.bigFontMetrics.stringWidth("0"), y);
        this.chronoGraphics.drawString((seconds < 10L ? "0" : "") + seconds, x += this.bigFontMetrics.stringWidth("\u2032"), y);
        this.chronoGraphics.drawString("\u2033", x += this.bigFontMetrics.stringWidth("00"), y);
        this.chronoGraphics.setFont(this.smallFont);
        this.chronoGraphics.drawString("" + deciseconds, x += this.bigFontMetrics.stringWidth("\u2033"), y);
        if (this.roi.x < 0) {
            this.roi.x += image.width();
        }
        if (this.roi.y < 0) {
            this.roi.y += image.height();
        }
        image.copyFrom(this.chronoImage, 1.0, image.nChannels() == 4, this.roi);
    }
}

