/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.procamtracker;

import java.awt.Component;
import java.awt.Dimension;
import org.netbeans.beaninfo.editors.StringArrayEditor;

public class DoubleArrayEditor
extends StringArrayEditor {
    public Object getValue() {
        return DoubleArrayEditor.stringsToDoubles((String[])super.getValue());
    }

    public void setValue(Object value) {
        if (value instanceof String[]) {
            super.setValue(value);
        } else {
            this.setValue(DoubleArrayEditor.doublesToStrings((double[])value));
        }
    }

    public static String[] doublesToStrings(double[] doubles) {
        if (doubles == null) {
            return null;
        }
        String[] strings = new String[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            strings[i] = Double.toString(doubles[i]);
        }
        return strings;
    }

    public static double[] stringsToDoubles(String[] strings) {
        if (strings == null) {
            return null;
        }
        double[] doubles = new double[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            try {
                doubles[i] = Double.parseDouble(strings[i]);
                continue;
            }
            catch (NumberFormatException e) {
                doubles[i] = Double.NaN;
            }
        }
        return doubles;
    }

    public String[] getStringArray() {
        return (String[])super.getValue();
    }

    public void setStringArray(String[] value) {
        super.setValue((Object)value);
    }

    public Component getCustomEditor() {
        Component c = super.getCustomEditor();
        c.setPreferredSize(new Dimension(200, 200));
        return c;
    }
}

