/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.procamtracker;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.helper.opencv_core;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_highgui;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.BaseChildSettings;
import org.bytedeco.javacv.BaseSettings;
import org.bytedeco.javacv.CanvasFrame;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.FrameGrabber;
import org.bytedeco.javacv.ImageTransformer;
import org.bytedeco.javacv.JavaCV;
import org.bytedeco.javacv.MarkedPlane;
import org.bytedeco.javacv.Marker;
import org.bytedeco.javacv.MarkerDetector;
import org.bytedeco.javacv.ObjectFinder;
import org.bytedeco.javacv.OpenCVFrameGrabber;
import org.bytedeco.javacv.Parallel;
import org.bytedeco.javacv.ProCamTransformer;
import org.bytedeco.javacv.ProjectiveDevice;
import org.bytedeco.javacv.ProjectiveTransformer;
import org.bytedeco.procamtracker.Chronometer;
import org.bytedeco.procamtracker.CleanBeanNode;
import org.bytedeco.procamtracker.VirtualBall;

public class RealityAugmentor {
    private Settings settings;
    private ObjectSettings objectSettings = null;
    private VirtualSettings virtualSettings = null;
    private ObjectFinder.Settings objectFinderSettings;
    private MarkerDetector.Settings markerDetectorSettings;
    private VirtualBall.Settings virtualBallSettings;
    private ProjectiveDevice camera;
    private ProjectiveDevice projector;
    private int channels;
    private double[] roiPts = null;
    private MarkerDetector markerDetector = null;
    private GraphicsDevice desktopScreen = null;
    private Robot robot = null;
    private BufferedImage handMouseCursor = null;
    private FrameGrabber videoToProject = null;
    private opencv_core.IplImage imageToProject = null;
    private opencv_core.IplImage textureImage = null;
    private Chronometer chronometer = null;
    private VirtualBall virtualBall = null;
    private ProjectiveTransformer composeWarper = new ProjectiveTransformer();
    private ProjectiveTransformer.Parameters[] composeParameters = new ProjectiveTransformer.Parameters[]{this.composeWarper.createParameters()};
    private opencv_core.CvMat srcPts = opencv_core.CvMat.create((int)4, (int)1, (int)6, (int)2);
    private opencv_core.CvMat dstPts = opencv_core.CvMat.create((int)4, (int)1, (int)6, (int)2);
    private opencv_core.CvMat tempH = opencv_core.CvMat.create((int)3, (int)3);
    private opencv_core.CvPoint tempPts = new opencv_core.CvPoint(4);
    private opencv_core.CvPoint corners = new opencv_core.CvPoint(4);
    private opencv_core.CvPoint corners2 = new opencv_core.CvPoint((Pointer)this.corners);
    private IntPointer tempNPts = new IntPointer(1).put(4);
    private opencv_core.CvRect roi = new opencv_core.CvRect();
    private opencv_core.CvRect maxroi = new opencv_core.CvRect();
    private opencv_core.CvBox2D box = new opencv_core.CvBox2D();
    private opencv_core.CvMat boxPts = opencv_core.CvMat.create((int)4, (int)1, (int)5, (int)2);
    private opencv_core.CvPoint2D32f boxPtsData = new opencv_core.CvPoint2D32f((Pointer)this.boxPts.data_fl());
    private double markerError = 0.0;
    private int markerErrorCount = 0;
    private static final Logger logger = Logger.getLogger(RealityAugmentor.class.getName());
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private Future<opencv_core.CvRect> future = null;

    public RealityAugmentor(Settings settings, ObjectFinder.Settings objectFinderSettings, MarkerDetector.Settings markerDetectorSettings, VirtualBall.Settings virtualBallSettings, ProjectiveDevice camera, ProjectiveDevice projector, int channels) throws Exception {
        this.setSettings(settings);
        this.objectFinderSettings = objectFinderSettings;
        this.markerDetectorSettings = markerDetectorSettings;
        this.virtualBallSettings = virtualBallSettings;
        this.camera = camera;
        this.projector = projector;
        this.channels = channels;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public ObjectSettings getObjectSettings() {
        return this.objectSettings;
    }

    public void setObjectSettings(ObjectSettings objectSettings) {
        this.objectSettings = objectSettings;
    }

    public VirtualSettings getVirtualSettings() {
        return this.virtualSettings;
    }

    public void setVirtualSettings(VirtualSettings virtualSettings) {
        this.virtualSettings = virtualSettings;
    }

    public void initVirtualSettings() throws Exception {
        this.desktopScreen = null;
        this.robot = null;
        this.handMouseCursor = null;
        this.videoToProject = null;
        this.imageToProject = null;
        this.chronometer = null;
        this.virtualBall = null;
        if (this.virtualSettings.desktopScreenNumber < 0 && this.virtualSettings.projectorImageFile == null && this.virtualSettings.projectorVideoFile == null) {
            this.imageToProject = opencv_core.IplImage.create((int)this.projector.imageWidth, (int)this.projector.imageHeight, (int)8, (int)this.channels);
            opencv_core.IplImage tempFloat = opencv_core.IplImage.create((int)this.projector.imageWidth, (int)this.projector.imageHeight, (int)32, (int)this.channels);
            this.projector.getRectifyingHomography(this.camera, this.tempH);
            JavaCV.fractalTriangleWave((opencv_core.IplImage)tempFloat, (opencv_core.CvMat)this.tempH);
            opencv_core.cvConvertScale((opencv_core.CvArr)tempFloat, (opencv_core.CvArr)this.imageToProject, (double)255.0, (double)0.0);
        } else if (this.virtualSettings.desktopScreenNumber >= 0) {
            this.desktopScreen = CanvasFrame.getScreenDevice((int)this.virtualSettings.desktopScreenNumber);
            this.robot = new Robot(this.desktopScreen);
            int w = this.virtualSettings.desktopScreenWidth;
            int h = this.virtualSettings.desktopScreenHeight;
            if (w <= 0 || h <= 0) {
                DisplayMode dm = this.desktopScreen.getDisplayMode();
                w = dm.getWidth();
                h = dm.getHeight();
            }
            try {
                this.videoToProject = new FFmpegFrameGrabber(":0." + this.virtualSettings.desktopScreenNumber);
                this.videoToProject.setFormat("x11grab");
                this.videoToProject.setImageWidth(w);
                this.videoToProject.setImageHeight(h);
                this.videoToProject.setFrameRate(30.0);
                switch (this.channels) {
                    case 1: {
                        this.videoToProject.setPixelFormat(8);
                        break;
                    }
                    case 3: {
                        this.videoToProject.setPixelFormat(3);
                        break;
                    }
                    case 4: {
                        this.videoToProject.setPixelFormat(28);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                this.videoToProject.start();
                this.imageToProject = null;
            }
            catch (FrameGrabber.Exception e) {
                this.videoToProject = null;
                this.imageToProject = opencv_core.IplImage.create((int)w, (int)h, (int)8, (int)this.channels);
            }
            this.handMouseCursor = ImageIO.read(this.getClass().getResource("icons/Choose.png"));
        } else if (this.virtualSettings.projectorVideoFile != null) {
            if (this.virtualSettings.projectorImageFile != null) {
                this.imageToProject = opencv_core.IplImage.createFrom((BufferedImage)ImageIO.read(this.virtualSettings.projectorImageFile), (double)1.0, (boolean)true);
                if (this.imageToProject == null) {
                    throw new Exception("Error: Could not load projectorImageFile named \"" + this.virtualSettings.projectorImageFile + "\".");
                }
                ByteBuffer buf = this.imageToProject.getByteBuffer();
                int width = this.imageToProject.width();
                int height = this.imageToProject.height();
                int step = this.imageToProject.widthStep();
                int channels = this.imageToProject.nChannels();
                for (int y = 0; y < height; ++y) {
                    int pixel = y * step;
                    int x = 0;
                    while (x < width) {
                        switch (channels) {
                            default: {
                                assert (false);
                            }
                            case 3: 
                            case 4: {
                                buf.put(pixel + 2, (byte)opencv_core.IplImage.decodeGamma22((int)buf.get(pixel + 2)));
                            }
                            case 2: {
                                buf.put(pixel + 1, (byte)opencv_core.IplImage.decodeGamma22((int)buf.get(pixel + 1)));
                            }
                            case 1: 
                        }
                        buf.put(pixel + 0, (byte)opencv_core.IplImage.decodeGamma22((int)buf.get(pixel + 0)));
                        ++x;
                        pixel += channels;
                    }
                }
            }
            try {
                this.videoToProject = new FFmpegFrameGrabber(this.virtualSettings.projectorVideoFile);
            }
            catch (Throwable t) {
                this.videoToProject = new OpenCVFrameGrabber(this.virtualSettings.projectorVideoFile);
            }
            if (this.videoToProject != null) {
                this.videoToProject.setImageMode(FrameGrabber.ImageMode.COLOR);
                switch (this.channels) {
                    case 1: {
                        this.videoToProject.setPixelFormat(8);
                        break;
                    }
                    case 3: {
                        this.videoToProject.setPixelFormat(3);
                        break;
                    }
                    case 4: {
                        this.videoToProject.setPixelFormat(28);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                if (this.imageToProject != null) {
                    this.videoToProject.setImageWidth(this.imageToProject.width());
                    this.videoToProject.setImageHeight(this.imageToProject.height());
                }
                this.videoToProject.start();
            }
        } else if (this.virtualSettings.projectorImageFile != null) {
            opencv_core.IplImage iplImage = this.channels == 4 ? opencv_highgui.cvLoadImageRGBA((String)this.virtualSettings.projectorImageFile.getAbsolutePath()) : (this.imageToProject = opencv_highgui.cvLoadImage((String)this.virtualSettings.projectorImageFile.getAbsolutePath(), (int)(this.channels == 3 ? 1 : 0)));
            if (this.imageToProject == null) {
                throw new Exception("Error: Could not load projectorImageFile named \"" + this.virtualSettings.projectorImageFile + "\".");
            }
            this.imageToProject.applyGamma(2.2);
        }
    }

    public double[] acquireRoi(CanvasFrame monitorWindow, double monitorWindowScale, opencv_core.IplImage cameraImage, int pyramidLevel) throws Exception {
        int w = cameraImage.width();
        int h = cameraImage.height();
        this.roiPts = null;
        this.markerError = 0.0;
        this.markerErrorCount = 0;
        for (ObjectSettings os : this.settings.toArray()) {
            File f = os.textureImageFile;
            RoiAcquisitionMethod ram = os.roiAcquisitionMethod;
            if (!(ram != RoiAcquisitionMethod.OBJECT_FINDER && ram != RoiAcquisitionMethod.MARKER_DETECTOR || f != null && (this.textureImage = opencv_highgui.cvLoadImage((String)f.getAbsolutePath())) != null)) {
                throw new Exception("Error: Could not load the object image file \"" + f + "\" for " + (Object)((Object)ram) + ".");
            }
            switch (ram) {
                case MOUSE_CLICKS: {
                    this.roiPts = this.acquireRoiFromMouseClicks(monitorWindow, monitorWindowScale);
                    break;
                }
                case OBJECT_FINDER: {
                    this.roiPts = this.acquireRoiFromObjectFinder(cameraImage);
                    break;
                }
                case MARKER_DETECTOR: {
                    this.roiPts = this.acquireRoiFromMarkerDetector(cameraImage);
                    break;
                }
                case WHOLE_FRAME: {
                    this.roiPts = new double[]{0.0, 0.0, w, 0.0, w, h, 0.0, h};
                    break;
                }
                case HALF_FRAME: {
                    double dw = (double)w * 0.5857864376269049 / 4.0;
                    double dh = (double)h * 0.5857864376269049 / 4.0;
                    this.roiPts = new double[]{dw, dh, (double)w - dw, dh, (double)w - dw, (double)h - dh, dw, (double)h - dh};
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (this.roiPts == null) continue;
            if (pyramidLevel > 0) {
                for (int i = 0; i < this.roiPts.length; ++i) {
                    this.roiPts[i] = this.roiPts[i] * (double)(1 << pyramidLevel);
                }
            }
            this.objectSettings = os;
            this.virtualSettings = null;
            for (VirtualSettings vs : this.objectSettings.toArray()) {
                Rectangle r = vs.objectHotSpot;
                if (r != null && r.width > 0 && r.height > 0) continue;
                this.setVirtualSettings(vs);
                this.initVirtualSettings();
            }
            break;
        }
        return this.roiPts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] acquireRoiFromMouseClicks(final CanvasFrame monitorWindow, final double monitorWindowScale) throws Exception {
        if (monitorWindow == null) {
            throw new Exception("Error: No monitor window. Could not acquire ROI from mouse clicks.");
        }
        Toolkit t = Toolkit.getDefaultToolkit();
        Dimension d = t.getBestCursorSize(15, 15);
        BufferedImage cursorImage = new BufferedImage(d.width, d.height, 2);
        Graphics2D g = cursorImage.createGraphics();
        int cx = d.width / 2;
        int cy = d.height / 2;
        g.setColor(Color.WHITE);
        g.drawRect(cx - 7, cy - 7, 14, 14);
        g.setColor(Color.BLACK);
        g.drawRect(cx - 6, cy - 6, 12, 12);
        g.setColor(Color.WHITE);
        g.drawRect(cx - 2, cy - 2, 4, 4);
        g.setColor(Color.BLACK);
        g.drawRect(cx - 1, cy - 1, 2, 2);
        if (d.width % 2 == 0) {
            ++cx;
        }
        if (d.height % 2 == 0) {
            ++cy;
        }
        Cursor cursor = t.createCustomCursor(cursorImage, new Point(cx, cy), null);
        monitorWindow.setCursor(cursor);
        final double[] roiPts = new double[8];
        final int[] count = new int[]{0};
        monitorWindow.getCanvas().addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                if (count[0] < 8) {
                    int n = count[0];
                    count[0] = n + 1;
                    roiPts[n] = (double)e.getX() / monitorWindowScale;
                    int n2 = count[0];
                    count[0] = n2 + 1;
                    roiPts[n2] = (double)e.getY() / monitorWindowScale;
                    Graphics2D g = monitorWindow.createGraphics();
                    g.setColor(Color.RED);
                    g.drawLine(e.getX() - 7, e.getY(), e.getX() + 7, e.getY());
                    g.drawLine(e.getX(), e.getY() - 7, e.getX(), e.getY() + 7);
                    monitorWindow.releaseGraphics(g);
                }
                if (count[0] < 8) return;
                double[] dArray = roiPts;
                synchronized (roiPts) {
                    monitorWindow.getCanvas().removeMouseListener(this);
                    monitorWindow.setCursor(null);
                    roiPts.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        double[] dArray = roiPts;
        synchronized (roiPts) {
            roiPts.wait();
            // ** MonitorExit[var13_12] (shouldn't be in output)
            return roiPts;
        }
    }

    private double[] acquireRoiFromObjectFinder(opencv_core.IplImage cameraImage) throws Exception {
        opencv_core.IplImage grey2;
        opencv_core.IplImage grey1;
        if (this.textureImage.depth() == 1) {
            grey1 = this.textureImage;
        } else {
            grey1 = opencv_core.IplImage.create((int)this.textureImage.width(), (int)this.textureImage.height(), (int)this.textureImage.depth(), (int)1);
            opencv_imgproc.cvCvtColor((opencv_core.CvArr)this.textureImage, (opencv_core.CvArr)grey1, (int)(this.textureImage.depth() == 4 ? 11 : 6));
        }
        if (cameraImage.depth() == 1) {
            grey2 = cameraImage;
        } else {
            grey2 = opencv_core.IplImage.create((int)cameraImage.width(), (int)cameraImage.height(), (int)cameraImage.depth(), (int)1);
            opencv_imgproc.cvCvtColor((opencv_core.CvArr)cameraImage, (opencv_core.CvArr)grey2, (int)(cameraImage.depth() == 4 ? 11 : 6));
        }
        this.objectFinderSettings.setObjectImage(grey1);
        ObjectFinder objectFinder = new ObjectFinder(this.objectFinderSettings);
        double[] roiPts = objectFinder.find(grey2);
        if (grey1 != this.textureImage) {
            grey1.release();
        }
        if (grey2 != cameraImage) {
            grey2.release();
        }
        return roiPts;
    }

    private double[] acquireRoiFromMarkerDetector(opencv_core.IplImage cameraImage) throws Exception {
        this.markerDetector = new MarkerDetector(this.markerDetectorSettings);
        Marker[] markersin = this.markerDetector.detect(this.textureImage, false);
        String infoLogString = "textureImage marker centers = ";
        block0: for (int i = 0; i < 4; ++i) {
            for (Marker m : markersin) {
                if (m.id != i) continue;
                double[] c = m.getCenter();
                infoLogString = infoLogString + m.id + ": (" + (float)c[0] + ", " + (float)c[1] + ")  ";
                continue block0;
            }
        }
        logger.info(infoLogString);
        if (markersin == null || markersin.length == 0) {
            return null;
        }
        MarkedPlane markedPlane = new MarkedPlane(this.textureImage.width(), this.textureImage.height(), markersin, 1.0);
        Marker[] markersout = this.markerDetector.detect(cameraImage, false);
        infoLogString = "initial marker centers = ";
        if (markersout == null || markersout.length == 0 || markedPlane.getTotalWarp(markersout, this.tempH, true) == Double.POSITIVE_INFINITY) {
            return null;
        }
        this.dstPts.put(new double[]{0.0, 0.0, this.textureImage.width(), 0.0, this.textureImage.width(), this.textureImage.height(), 0.0, this.textureImage.height()});
        opencv_core.cvPerspectiveTransform((opencv_core.CvArr)this.dstPts, (opencv_core.CvArr)this.dstPts, (opencv_core.CvMat)this.tempH);
        double[] roiPts = this.dstPts.get();
        block2: for (int i = 0; i < 4; ++i) {
            for (Marker m : markersout) {
                if (m.id != i) continue;
                double[] c = m.getCenter();
                infoLogString = infoLogString + m.id + ": (" + (float)c[0] + ", " + (float)c[1] + ")  ";
                this.srcPts.put(i * 2, c[0]);
                this.srcPts.put(i * 2 + 1, c[1]);
                continue block2;
            }
        }
        logger.info(infoLogString);
        return roiPts;
    }

    public opencv_core.IplImage nextFrameImage(int objectMouseX, int objectMouseY, boolean mouseClick) throws Exception {
        int w;
        opencv_core.IplImage frameImage = this.imageToProject;
        if (this.desktopScreen != null && this.robot != null) {
            w = this.videoToProject != null ? this.videoToProject.getImageWidth() : this.imageToProject.width();
            int h = this.videoToProject != null ? this.videoToProject.getImageHeight() : this.imageToProject.height();
            int desktopMouseX = objectMouseX * w / (this.textureImage != null ? this.textureImage.width() : this.projector.imageWidth);
            int desktopMouseY = objectMouseY * h / (this.textureImage != null ? this.textureImage.height() : this.projector.imageHeight);
            if (desktopMouseX >= 0 && desktopMouseY >= 0) {
                this.robot.mouseMove(desktopMouseX, desktopMouseY);
                if (mouseClick) {
                    this.robot.mousePress(16);
                    this.robot.waitForIdle();
                    this.robot.mouseRelease(16);
                    this.robot.waitForIdle();
                }
            }
            if (this.videoToProject != null) {
                frameImage = this.videoToProject.grab();
            } else {
                final int dstStep = this.imageToProject.widthStep();
                final int dstChannels = this.imageToProject.nChannels();
                final ByteBuffer dstBuf = this.imageToProject.getByteBuffer();
                final IntBuffer dstBufInt = dstChannels == 4 ? dstBuf.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer() : null;
                final int dstWidth = this.imageToProject.width();
                int dstHeight = this.imageToProject.height();
                BufferedImage screenCapture = this.robot.createScreenCapture(new Rectangle(dstWidth, dstHeight));
                if (desktopMouseX >= 0 && desktopMouseY >= 0) {
                    Graphics2D g = screenCapture.createGraphics();
                    g.drawImage((Image)this.handMouseCursor, desktopMouseX, desktopMouseY, null);
                }
                final int srcStep = ((SinglePixelPackedSampleModel)screenCapture.getSampleModel()).getScanlineStride();
                final int[] srcData = ((DataBufferInt)screenCapture.getRaster().getDataBuffer()).getData();
                Parallel.loop((int)0, (int)dstHeight, (Parallel.Looper)new Parallel.Looper(){

                    public void loop(int from, int to, int looperID) {
                        for (int y = from; y < to; ++y) {
                            int srcPixel = y * srcStep;
                            int dstPixel = y * dstStep;
                            int x = 0;
                            while (x < dstWidth) {
                                int rgb = srcData[srcPixel];
                                switch (dstChannels) {
                                    case 1: {
                                        int lumi = (opencv_core.IplImage.decodeGamma22((int)(rgb >> 16 & 0xFF)) + opencv_core.IplImage.decodeGamma22((int)(rgb >> 8 & 0xFF)) + opencv_core.IplImage.decodeGamma22((int)(rgb & 0xFF))) / 3;
                                        dstBuf.put(dstPixel, (byte)lumi);
                                        break;
                                    }
                                    case 3: {
                                        dstBuf.put(dstPixel + 0, (byte)opencv_core.IplImage.decodeGamma22((int)(rgb & 0xFF)));
                                        dstBuf.put(dstPixel + 1, (byte)opencv_core.IplImage.decodeGamma22((int)(rgb >> 8 & 0xFF)));
                                        dstBuf.put(dstPixel + 2, (byte)opencv_core.IplImage.decodeGamma22((int)(rgb >> 16 & 0xFF)));
                                        break;
                                    }
                                    case 4: {
                                        int rgba = opencv_core.IplImage.decodeGamma22((int)(rgb >> 16 & 0xFF)) | opencv_core.IplImage.decodeGamma22((int)(rgb >> 8 & 0xFF)) << 8 | opencv_core.IplImage.decodeGamma22((int)(rgb & 0xFF)) << 16 | 0xFF000000;
                                        dstBufInt.put(dstPixel / 4, rgba);
                                        break;
                                    }
                                    default: {
                                        assert (false);
                                        break;
                                    }
                                }
                                ++x;
                                ++srcPixel;
                                dstPixel += dstChannels;
                            }
                        }
                    }
                });
            }
        } else if (this.videoToProject != null) {
            frameImage = this.videoToProject.grab();
            if (frameImage == null) {
                this.videoToProject.restart();
                frameImage = this.videoToProject.grab();
            }
            if (this.imageToProject != null) {
                w = Math.min(this.imageToProject.width(), frameImage.width());
                int h = Math.min(this.imageToProject.height(), frameImage.height());
                opencv_core.IplROI srcRoi = this.imageToProject.roi();
                final int srcStep = this.imageToProject.widthStep();
                final int dstStep = frameImage.widthStep();
                final int srcChannels = this.imageToProject.nChannels();
                final int dstChannels = frameImage.nChannels();
                int srcIndex = 0;
                int dstIndex = 0;
                if (srcRoi != null) {
                    srcIndex = srcRoi.yOffset() * srcStep + srcRoi.xOffset() * srcChannels;
                    dstIndex = srcRoi.yOffset() * dstStep + srcRoi.xOffset() * dstChannels;
                    w = srcRoi.width();
                    h = srcRoi.height();
                }
                final ByteBuffer srcBuf = this.imageToProject.getByteBuffer(srcIndex);
                final ByteBuffer dstBuf = frameImage.getByteBuffer(dstIndex);
                final IntBuffer srcBufInt = srcChannels == 4 ? srcBuf.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer() : null;
                final IntBuffer dstBufInt = dstChannels == 4 ? dstBuf.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer() : null;
                final int width = w;
                int height = h;
                Parallel.loop((int)0, (int)height, (Parallel.Looper)new Parallel.Looper(){

                    public void loop(int from, int to, int looperID) {
                        for (int y = from; y < to; ++y) {
                            int srcPixel = y * srcStep;
                            int dstPixel = y * dstStep;
                            int x = 0;
                            while (x < width) {
                                int r = 0;
                                int g = 0;
                                int b = 0;
                                int a = 128;
                                switch (srcChannels) {
                                    case 1: {
                                        g = b = srcBuf.get(srcPixel) & 0xFF;
                                        r = b;
                                        break;
                                    }
                                    case 3: {
                                        b = srcBuf.get(srcPixel) & 0xFF;
                                        g = srcBuf.get(srcPixel + 1) & 0xFF;
                                        r = srcBuf.get(srcPixel + 2) & 0xFF;
                                        break;
                                    }
                                    case 4: {
                                        int rgba = srcBufInt.get(srcPixel / 4);
                                        r = rgba & 0xFF;
                                        g = rgba >> 8 & 0xFF;
                                        b = rgba >> 16 & 0xFF;
                                        a = rgba >> 24 & 0xFF;
                                        break;
                                    }
                                    default: {
                                        assert (false);
                                        break;
                                    }
                                }
                                switch (dstChannels) {
                                    case 1: {
                                        int lumi = (r + g + b) / 3;
                                        dstBuf.put(dstPixel, (byte)((lumi * a + opencv_core.IplImage.decodeGamma22((int)dstBuf.get(dstPixel)) * (255 - a)) / 255));
                                        break;
                                    }
                                    case 3: {
                                        dstBuf.put(dstPixel, (byte)((b * a + opencv_core.IplImage.decodeGamma22((int)dstBuf.get(dstPixel)) * (255 - a)) / 255));
                                        dstBuf.put(dstPixel + 1, (byte)((g * a + opencv_core.IplImage.decodeGamma22((int)dstBuf.get(dstPixel + 1)) * (255 - a)) / 255));
                                        dstBuf.put(dstPixel + 2, (byte)((r * a + opencv_core.IplImage.decodeGamma22((int)dstBuf.get(dstPixel + 2)) * (255 - a)) / 255));
                                        break;
                                    }
                                    case 4: {
                                        int rgba = dstBufInt.get(dstPixel / 4);
                                        r = (r * a + opencv_core.IplImage.decodeGamma22((int)(rgba & 0xFF)) * (255 - a)) / 255;
                                        g = (g * a + opencv_core.IplImage.decodeGamma22((int)(rgba >> 8 & 0xFF)) * (255 - a)) / 255;
                                        b = (b * a + opencv_core.IplImage.decodeGamma22((int)(rgba >> 16 & 0xFF)) * (255 - a)) / 255;
                                        a = 255;
                                        rgba = r | g << 8 | b << 16 | a << 24;
                                        dstBufInt.put(dstPixel / 4, rgba);
                                        break;
                                    }
                                    default: {
                                        assert (false);
                                        break;
                                    }
                                }
                                ++x;
                                srcPixel += srcChannels;
                                dstPixel += dstChannels;
                            }
                        }
                    }
                });
            }
        }
        Rectangle r = this.virtualSettings.chronometerBounds;
        if (r == null || r.width <= 0 || r.height <= 0) {
            this.chronometer = null;
        } else if (this.chronometer == null) {
            this.chronometer = new Chronometer(r, frameImage.getBufferedImageType());
        }
        if (this.chronometer != null) {
            this.chronometer.draw(frameImage);
        }
        return frameImage;
    }

    public boolean needsMouse() {
        if (this.virtualSettings != null && this.virtualSettings.desktopScreenNumber >= 0) {
            return true;
        }
        for (VirtualSettings vs : this.objectSettings.toArray()) {
            Rectangle r = vs.objectHotSpot;
            if (r == null || r.width <= 0 || r.height <= 0) continue;
            return true;
        }
        return false;
    }

    public void update(final opencv_core.IplImage projectorImage, final opencv_core.CvRect prevroi, final double imageMouseX, final double imageMouseY, final boolean mouseClick, final ProCamTransformer.Parameters parameters) throws Exception {
        this.future = this.executor.submit(new Callable<opencv_core.CvRect>(){

            @Override
            public opencv_core.CvRect call() throws Exception {
                int objectMouseX = -1;
                int objectMouseY = -1;
                if (imageMouseX >= 0.0 && imageMouseY >= 0.0 && RealityAugmentor.this.textureImage != null) {
                    int w = RealityAugmentor.this.textureImage.width();
                    int h = RealityAugmentor.this.textureImage.height();
                    double[] pts = new double[]{0.0, 0.0, w, 0.0, w, h, 0.0, h};
                    JavaCV.getPerspectiveTransform((double[])pts, (double[])RealityAugmentor.this.roiPts, (opencv_core.CvMat)RealityAugmentor.this.tempH);
                    RealityAugmentor.this.composeParameters[0].compose(parameters.getSurfaceParameters().getH(), false, RealityAugmentor.this.tempH, false);
                    RealityAugmentor.this.composeWarper.transform(RealityAugmentor.this.dstPts.put(new double[]{imageMouseX, imageMouseY}), RealityAugmentor.this.dstPts, (ImageTransformer.Parameters)RealityAugmentor.this.composeParameters[0], true);
                    objectMouseX = (int)Math.round(RealityAugmentor.this.dstPts.get(0));
                    objectMouseY = (int)Math.round(RealityAugmentor.this.dstPts.get(1));
                }
                if (mouseClick) {
                    for (VirtualSettings vs : RealityAugmentor.this.objectSettings.toArray()) {
                        Rectangle r = vs.objectHotSpot;
                        if (r == null || !r.contains(objectMouseX, objectMouseY)) continue;
                        RealityAugmentor.this.setVirtualSettings(vs);
                        RealityAugmentor.this.initVirtualSettings();
                        break;
                    }
                }
                int pw = projectorImage.width();
                int ph = projectorImage.height();
                double[] projPts = new double[]{0.0, 0.0, pw, 0.0, pw, ph, 0.0, ph};
                if (RealityAugmentor.this.virtualSettings == null) {
                    opencv_core.cvSet((opencv_core.CvArr)projectorImage, (opencv_core.CvScalar)opencv_core.CvScalar.WHITE);
                    RealityAugmentor.this.maxroi.x(0).y(0).width(pw).height(ph);
                    return null;
                }
                if (!((RealityAugmentor)RealityAugmentor.this).objectSettings.surfaceHasTexture) {
                    RealityAugmentor.this.projector.getFrontoParallelH(projPts, parameters.getN(), RealityAugmentor.this.tempH);
                    opencv_core.cvMatMul((opencv_core.CvArr)((RealityAugmentor)RealityAugmentor.this).projector.cameraMatrix, (opencv_core.CvArr)RealityAugmentor.this.tempH, (opencv_core.CvArr)RealityAugmentor.this.tempH);
                    opencv_core.cvInvert((opencv_core.CvArr)RealityAugmentor.this.tempH, (opencv_core.CvArr)RealityAugmentor.this.tempH);
                    opencv_core.cvPerspectiveTransform((opencv_core.CvArr)RealityAugmentor.this.dstPts.put(projPts), (opencv_core.CvArr)RealityAugmentor.this.dstPts, (opencv_core.CvMat)RealityAugmentor.this.tempH);
                    RealityAugmentor.this.box.angle(0.0f).size().width((float)pw).height((float)ph);
                    JavaCV.boundedRect((opencv_core.CvMat)RealityAugmentor.this.boxPts.put(RealityAugmentor.this.dstPts), (opencv_core.CvBox2D)RealityAugmentor.this.box);
                    opencv_imgproc.cvBoxPoints((opencv_core.CvBox2D)RealityAugmentor.this.box, (opencv_core.CvPoint2D32f)RealityAugmentor.this.boxPtsData);
                    opencv_core.CvPoint2D32f center = RealityAugmentor.this.box.center();
                    double centerX = center.x();
                    double centerY = center.y();
                    for (int i = 0; i < 4; ++i) {
                        double x = RealityAugmentor.this.boxPts.get(2 * i);
                        double y = RealityAugmentor.this.boxPts.get(2 * i + 1);
                        if (x > centerX) {
                            if (y > centerY) {
                                RealityAugmentor.this.dstPts.put(0, x).put(1, y);
                                continue;
                            }
                            RealityAugmentor.this.dstPts.put(6, x).put(7, y);
                            continue;
                        }
                        if (y > centerY) {
                            RealityAugmentor.this.dstPts.put(2, x).put(3, y);
                            continue;
                        }
                        RealityAugmentor.this.dstPts.put(4, x).put(5, y);
                    }
                    opencv_core.cvInvert((opencv_core.CvArr)RealityAugmentor.this.tempH, (opencv_core.CvArr)RealityAugmentor.this.tempH);
                    opencv_core.cvPerspectiveTransform((opencv_core.CvArr)RealityAugmentor.this.dstPts, (opencv_core.CvArr)RealityAugmentor.this.dstPts, (opencv_core.CvMat)RealityAugmentor.this.tempH);
                    JavaCV.getPerspectiveTransform((double[])projPts, (double[])RealityAugmentor.this.dstPts.get(), (opencv_core.CvMat)RealityAugmentor.this.tempH);
                    RealityAugmentor.this.composeParameters[0].set(RealityAugmentor.this.tempH, false);
                    if (imageMouseX >= 0.0 && imageMouseY >= 0.0) {
                        RealityAugmentor.this.composeParameters[0].compose((ImageTransformer.Parameters)parameters.getProjectorParameters(), false, (ImageTransformer.Parameters)RealityAugmentor.this.composeParameters[0], false);
                        RealityAugmentor.this.composeWarper.transform(RealityAugmentor.this.dstPts.put(new double[]{imageMouseX, imageMouseY}), RealityAugmentor.this.dstPts, (ImageTransformer.Parameters)RealityAugmentor.this.composeParameters[0], true);
                        objectMouseX = (int)Math.round(RealityAugmentor.this.dstPts.get(0));
                        objectMouseY = (int)Math.round(RealityAugmentor.this.dstPts.get(1));
                    }
                }
                opencv_core.IplImage frameImage = RealityAugmentor.this.nextFrameImage(objectMouseX, objectMouseY, mouseClick);
                if (((RealityAugmentor)RealityAugmentor.this).virtualSettings.projectionType == ProjectionType.TRACKED) {
                    int w = frameImage.width();
                    int h = frameImage.height();
                    double[] framePts = new double[]{0.0, 0.0, w, 0.0, w, h, 0.0, h};
                    if (((RealityAugmentor)RealityAugmentor.this).objectSettings.surfaceHasTexture) {
                        JavaCV.getPerspectiveTransform((double[])framePts, (double[])RealityAugmentor.this.roiPts, (opencv_core.CvMat)RealityAugmentor.this.tempH);
                        RealityAugmentor.this.composeParameters[0].compose((ImageTransformer.Parameters)parameters.getProjectorParameters(), true, (ImageTransformer.Parameters)parameters.getSurfaceParameters(), false);
                        RealityAugmentor.this.composeParameters[0].compose(RealityAugmentor.this.composeParameters[0].getH(), false, RealityAugmentor.this.tempH, false);
                    } else {
                        RealityAugmentor.this.composeParameters[0].set(RealityAugmentor.this.tempH, false);
                        JavaCV.getPerspectiveTransform((double[])framePts, (double[])projPts, (opencv_core.CvMat)RealityAugmentor.this.tempH);
                        RealityAugmentor.this.composeParameters[0].compose(RealityAugmentor.this.composeParameters[0].getH(), false, RealityAugmentor.this.tempH, false);
                    }
                    RealityAugmentor.this.composeWarper.transform(RealityAugmentor.this.dstPts.put(framePts), RealityAugmentor.this.dstPts, (ImageTransformer.Parameters)RealityAugmentor.this.composeParameters[0], false);
                    RealityAugmentor.this.composeWarper.setFillColor(opencv_core.CvScalar.WHITE);
                    if (prevroi == null) {
                        RealityAugmentor.this.composeWarper.transform(frameImage, projectorImage, null, 0, (ImageTransformer.Parameters)RealityAugmentor.this.composeParameters[0], false);
                    } else {
                        RealityAugmentor.this.roi.x(0).y(0).width(projectorImage.width()).height(projectorImage.height());
                        JavaCV.boundingRect((double[])RealityAugmentor.this.dstPts.get(), (opencv_core.CvRect)RealityAugmentor.this.roi, (int)3, (int)3, (int)16, (int)1);
                        RealityAugmentor.this.maxroi.x(Math.min(prevroi.x(), RealityAugmentor.this.roi.x()));
                        RealityAugmentor.this.maxroi.y(Math.min(prevroi.y(), RealityAugmentor.this.roi.y()));
                        RealityAugmentor.this.maxroi.width(Math.max(prevroi.x() + prevroi.width(), RealityAugmentor.this.roi.x() + RealityAugmentor.this.roi.width()) - RealityAugmentor.this.maxroi.x());
                        RealityAugmentor.this.maxroi.height(Math.max(prevroi.y() + prevroi.height(), RealityAugmentor.this.roi.y() + RealityAugmentor.this.roi.height()) - RealityAugmentor.this.maxroi.y());
                        RealityAugmentor.this.composeWarper.transform(frameImage, projectorImage, RealityAugmentor.this.maxroi, 0, (ImageTransformer.Parameters)RealityAugmentor.this.composeParameters[0], false);
                        prevroi.x(RealityAugmentor.this.roi.x()).y(RealityAugmentor.this.roi.y()).width(RealityAugmentor.this.roi.width()).height(RealityAugmentor.this.roi.height());
                    }
                } else {
                    RealityAugmentor.this.dstPts.put(new double[]{0.0, 0.0, pw, 0.0, pw, ph, 0.0, ph});
                    if (frameImage.width() == pw && frameImage.height() == ph) {
                        opencv_core.cvCopy((opencv_core.CvArr)frameImage, (opencv_core.CvArr)projectorImage);
                    } else {
                        opencv_imgproc.cvResize((opencv_core.CvArr)frameImage, (opencv_core.CvArr)projectorImage);
                    }
                    RealityAugmentor.this.maxroi.x(0).y(0).width(pw).height(ph);
                }
                if (!((RealityAugmentor)RealityAugmentor.this).virtualSettings.virtualBallEnabled) {
                    RealityAugmentor.this.virtualBall = null;
                } else if (RealityAugmentor.this.virtualBall == null) {
                    RealityAugmentor.this.virtualBallSettings.setInitialRoiPts(RealityAugmentor.this.dstPts.get());
                    RealityAugmentor.this.virtualBall = new VirtualBall(RealityAugmentor.this.virtualBallSettings);
                }
                if (RealityAugmentor.this.virtualBall != null) {
                    opencv_core.cvSetImageROI((opencv_core.IplImage)projectorImage, (opencv_core.CvRect)RealityAugmentor.this.roi);
                    RealityAugmentor.this.virtualBall.draw(projectorImage, RealityAugmentor.this.dstPts.get());
                }
                return prevroi == null ? null : RealityAugmentor.this.maxroi;
            }
        });
    }

    public opencv_core.CvRect getUpdateRect() throws Exception {
        return this.future.get();
    }

    public String drawRoi(opencv_core.IplImage monitorImage, int pyramidLevel, opencv_core.IplImage cameraImage, ProCamTransformer transformer, ProCamTransformer.Parameters parameters) {
        String infoLogString = "";
        if (this.objectSettings.roiAcquisitionMethod == RoiAcquisitionMethod.MARKER_DETECTOR && this.markerDetector != null) {
            boolean missing;
            Marker[] markers = new Marker[4];
            MarkerDetector.Settings ms = new MarkerDetector.Settings();
            ms.setThresholdKBlackMarkers(0.99);
            do {
                Marker[] detected;
                for (Marker m : detected = this.markerDetector.detect(cameraImage, false)) {
                    if (m.id >= markers.length || markers[m.id] != null) continue;
                    markers[m.id] = m;
                }
                missing = false;
                for (Marker m : markers) {
                    if (m != null) continue;
                    missing = true;
                }
                ms.setThresholdKBlackMarkers(ms.getThresholdKBlackMarkers() - 0.05);
                this.markerDetector.setSettings(ms);
            } while (missing && ms.getThresholdKBlackMarkers() > 0.0);
            transformer.transform(this.srcPts, this.dstPts, (ImageTransformer.Parameters)parameters, false);
            infoLogString = infoLogString + "  (";
            for (int j = 0; j < 4; ++j) {
                for (Marker m : markers) {
                    if (m == null || m.id != j) continue;
                    double[] center = m.getCenter();
                    double dx = center[0] * (double)(1 << this.camera.getMapsPyramidLevel()) - this.dstPts.get(j * 2);
                    double dy = center[1] * (double)(1 << this.camera.getMapsPyramidLevel()) - this.dstPts.get(j * 2 + 1);
                    double error = dx * dx + dy * dy;
                    infoLogString = infoLogString + (float)Math.sqrt(error) + (j < 3 ? ", " : "");
                    this.markerError += error;
                    ++this.markerErrorCount;
                    this.corners.put((byte)(16 - pyramidLevel + this.camera.getMapsPyramidLevel()), m.corners);
                    opencv_core.cvLine((opencv_core.CvArr)monitorImage, (opencv_core.CvPoint)this.corners.position(0), (opencv_core.CvPoint)this.corners2.position(2), (opencv_core.CvScalar)opencv_core.CV_RGB((double)monitorImage.highValue(), (double)0.0, (double)0.0), (int)1, (int)16, (int)16);
                    opencv_core.cvLine((opencv_core.CvArr)monitorImage, (opencv_core.CvPoint)this.corners.position(1), (opencv_core.CvPoint)this.corners2.position(3), (opencv_core.CvScalar)opencv_core.CV_RGB((double)monitorImage.highValue(), (double)0.0, (double)0.0), (int)1, (int)16, (int)16);
                    break;
                }
                this.tempPts.position(j);
                this.tempPts.x((int)Math.round(this.dstPts.get(j * 2) * (double)(1 << 16 - pyramidLevel)));
                this.tempPts.y((int)Math.round(this.dstPts.get(j * 2 + 1) * (double)(1 << 16 - pyramidLevel)));
            }
            infoLogString = infoLogString + ")  " + (float)Math.sqrt(this.markerError / (double)this.markerErrorCount);
            opencv_core.cvPolyLine((opencv_core.CvArr)monitorImage, (opencv_core.CvPoint)this.tempPts.position(0), (IntPointer)this.tempNPts, (int)1, (int)1, (opencv_core.CvScalar)opencv_core.CV_RGB((double)0.0, (double)monitorImage.highValue(), (double)0.0), (int)1, (int)16, (int)16);
        } else {
            transformer.transform(this.dstPts.put(this.roiPts), this.dstPts, (ImageTransformer.Parameters)parameters, false);
            this.tempPts.put((byte)(16 - pyramidLevel), this.dstPts.get());
            opencv_core.cvPolyLine((opencv_core.CvArr)monitorImage, (opencv_core.CvPoint)this.tempPts.position(0), (IntPointer)this.tempNPts, (int)1, (int)1, (opencv_core.CvScalar)opencv_core.CV_RGB((double)0.0, (double)monitorImage.highValue(), (double)0.0), (int)1, (int)16, (int)16);
        }
        return infoLogString;
    }

    public static class VirtualSettings
    extends BaseChildSettings
    implements CleanBeanNode.ActionableBean {
        String name = "VirtualSettings";
        Rectangle objectHotSpot = new Rectangle();
        int desktopScreenNumber = -1;
        int desktopScreenWidth = 640;
        int desktopScreenHeight = 452;
        File projectorImageFile = null;
        File projectorVideoFile = null;
        ProjectionType projectionType = ProjectionType.TRACKED;
        Rectangle chronometerBounds = new Rectangle(0, -50, 150, 50);
        boolean virtualBallEnabled = false;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.firePropertyChange("name", this.name, this.name);
        }

        public Rectangle getObjectHotStop() {
            return this.objectHotSpot;
        }

        public void setObjectHotStop(Rectangle objectHotSpot) {
            this.objectHotSpot = objectHotSpot;
        }

        public int getDesktopScreenNumber() {
            return this.desktopScreenNumber;
        }

        public void setDesktopScreenNumber(int desktopScreenNumber) {
            this.desktopScreenNumber = desktopScreenNumber;
        }

        public int getDesktopScreenWidth() {
            return this.desktopScreenWidth;
        }

        public void setDesktopScreenWidth(int desktopScreenWidth) {
            this.desktopScreenWidth = desktopScreenWidth;
        }

        public int getDesktopScreenHeight() {
            return this.desktopScreenHeight;
        }

        public void setDesktopScreenHeight(int desktopScreenHeight) {
            this.desktopScreenHeight = desktopScreenHeight;
        }

        public File getProjectorImageFile() {
            return this.projectorImageFile;
        }

        public void setProjectorImageFile(File projectorImageFile) {
            this.projectorImageFile = projectorImageFile;
        }

        public String getProjectorImageFilename() {
            return this.projectorImageFile == null ? "" : this.projectorImageFile.getPath();
        }

        public void setProjectorImageFilename(String projectorImageFilename) {
            this.projectorImageFile = projectorImageFilename == null || projectorImageFilename.length() == 0 ? null : new File(projectorImageFilename);
        }

        public File getProjectorVideoFile() {
            return this.projectorVideoFile;
        }

        public void setProjectorVideoFile(File projectorVideoFile) {
            this.projectorVideoFile = projectorVideoFile;
        }

        public String getProjectorVideoFilename() {
            return this.projectorVideoFile == null ? "" : this.projectorVideoFile.getPath();
        }

        public void setProjectorVideoFilename(String projectorVideoFilename) {
            this.projectorVideoFile = projectorVideoFilename == null || projectorVideoFilename.length() == 0 ? null : new File(projectorVideoFilename);
        }

        public ProjectionType getProjectionType() {
            return this.projectionType;
        }

        public void setProjectionType(ProjectionType projectionType) {
            this.projectionType = projectionType;
        }

        public Rectangle getChronometerBounds() {
            return this.chronometerBounds;
        }

        public void setChronometerBounds(Rectangle chronometerBounds) {
            this.chronometerBounds = chronometerBounds;
        }

        public boolean isVirtualBallEnabled() {
            return this.virtualBallEnabled;
        }

        public void setVirtualBallEnabled(boolean virtualBallEnabled) {
            this.virtualBallEnabled = virtualBallEnabled;
        }

        @Override
        public Action[] actions() {
            return new Action[]{new AbstractAction("Delete"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VirtualSettings.this.getBeanContext().remove(VirtualSettings.this);
                }
            }};
        }
    }

    public static enum ProjectionType {
        TRACKED,
        FIXED;

    }

    public static class ObjectSettings
    extends BaseSettings
    implements CleanBeanNode.ActionableBean {
        String name = "ObjectSettings";
        File textureImageFile = null;
        RoiAcquisitionMethod roiAcquisitionMethod = RoiAcquisitionMethod.MOUSE_CLICKS;
        boolean surfaceHasTexture = true;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.firePropertyChange("name", this.name, this.name);
        }

        public File getTextureImageFile() {
            return this.textureImageFile;
        }

        public void setTextureImageFile(File textureImageFile) {
            this.textureImageFile = textureImageFile;
        }

        public String getTextureImageFilename() {
            return this.textureImageFile == null ? "" : this.textureImageFile.getPath();
        }

        public void setTextureImageFilename(String textureImageFilename) {
            this.textureImageFile = textureImageFilename == null || textureImageFilename.length() == 0 ? null : new File(textureImageFilename);
        }

        public RoiAcquisitionMethod getRoiAcquisitionMethod() {
            return this.roiAcquisitionMethod;
        }

        public void setRoiAcquisitionMethod(RoiAcquisitionMethod roiAcquisitionMethod) {
            this.roiAcquisitionMethod = roiAcquisitionMethod;
        }

        public boolean isSurfaceHasTexture() {
            return this.surfaceHasTexture;
        }

        public void setSurfaceHasTexture(boolean surfaceHasTexture) {
            this.surfaceHasTexture = surfaceHasTexture;
        }

        public VirtualSettings[] toArray() {
            return (VirtualSettings[])this.toArray(new VirtualSettings[this.size()]);
        }

        @Override
        public Action[] actions() {
            return new Action[]{new AbstractAction("New VirtualSettings"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VirtualSettings vs = new VirtualSettings();
                    vs.setName("VirtualSettings " + ObjectSettings.this.size());
                    ObjectSettings.this.add(vs);
                }
            }, new AbstractAction("Delete"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ObjectSettings.this.getBeanContext().remove(ObjectSettings.this);
                }
            }};
        }
    }

    public static enum RoiAcquisitionMethod {
        MOUSE_CLICKS,
        OBJECT_FINDER,
        MARKER_DETECTOR,
        WHOLE_FRAME,
        HALF_FRAME;

    }

    public static class Settings
    extends BaseSettings
    implements CleanBeanNode.ActionableBean {
        public ObjectSettings[] toArray() {
            return (ObjectSettings[])this.toArray(new ObjectSettings[this.size()]);
        }

        @Override
        public Action[] actions() {
            return new Action[]{new AbstractAction("New ObjectSettings"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ObjectSettings os = new ObjectSettings();
                    os.setName("ObjectSettings " + Settings.this.size());
                    Settings.this.add(os);
                }
            }};
        }
    }
}

