/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.util.HashUtil;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class MemoryObject {
    private long addr;
    private long size;
    private int hash;
    private ByteBuffer buffer = null;

    public MemoryObject(long l, long l2) {
        this.addr = l;
        this.size = l2;
        this.hash = HashUtil.getAddrSizeHash32_EqualDist((long)l, (long)l2);
    }

    public void setBuffer(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "MemoryObject[addr 0x" + Long.toHexString(this.addr) + ", size 0x" + Long.toHexString(this.size) + ", hash32: 0x" + Integer.toHexString(this.hash) + "]";
    }

    public static MemoryObject getOrAddSafe(HashMap<MemoryObject, MemoryObject> hashMap, MemoryObject memoryObject) {
        MemoryObject memoryObject2 = hashMap.get(memoryObject);
        if (null == memoryObject2) {
            hashMap.put(memoryObject, memoryObject);
            memoryObject2 = memoryObject;
        }
        return memoryObject2;
    }
}

