/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.procamtracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyVetoException;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.media.opengl.GLProfile;
import javax.media.opengl.Threading;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacv.CameraDevice;
import org.bytedeco.javacv.FrameGrabber;
import org.bytedeco.javacv.GNImageAligner;
import org.bytedeco.javacv.HandMouse;
import org.bytedeco.javacv.JavaCvErrorCallback;
import org.bytedeco.javacv.MarkerDetector;
import org.bytedeco.javacv.ObjectFinder;
import org.bytedeco.javacv.ProjectorDevice;
import org.bytedeco.procamtracker.CleanBeanNode;
import org.bytedeco.procamtracker.DoubleArrayEditor;
import org.bytedeco.procamtracker.RealityAugmentor;
import org.bytedeco.procamtracker.TrackingWorker;
import org.bytedeco.procamtracker.VirtualBall;
import org.netbeans.beaninfo.editors.StringArrayEditor;
import org.netbeans.core.output2.NbIOProvider;
import org.netbeans.swing.plaf.Startup;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.IOContainer;
import org.openide.windows.InputOutput;

public class MainFrame
extends JFrame
implements ExplorerManager.Provider,
Lookup.Provider,
PropertyChangeListener {
    CameraDevice.Settings cameraSettings;
    ProjectorDevice.Settings projectorSettings;
    ObjectFinder.Settings objectFinderSettings;
    MarkerDetector.Settings markerDetectorSettings;
    GNImageAligner.Settings alignerSettings;
    HandMouse.Settings handMouseSettings;
    VirtualBall.Settings virtualBallSettings;
    RealityAugmentor.Settings realityAugmentorSettings;
    TrackingWorker.Settings trackingSettings;
    final File DEFAULT_SETTINGS_FILE = new File("settings.pct");
    File settingsFile = null;
    private ExplorerManager manager = new ExplorerManager();
    private Lookup lookup;
    private InputOutput messagesio;
    MyTrackingWorker trackingWorker = null;
    static File myDirectory;
    private JMenuItem aboutMenuItem;
    private BeanTreeView beanTreeView;
    private JMenu helpMenu;
    private JSplitPane horizontalSplitPane;
    private JMenuBar menuBar;
    private JSeparator menuSeparator2;
    private PropertySheetView propertySheetView;
    private JMenuItem readmeMenuItem;
    private JButton settingsLoadButton;
    private JButton settingsLoadDefaultsButton;
    private JMenuItem settingsLoadDefaultsMenuItem;
    private JMenuItem settingsLoadMenuItem;
    private JMenu settingsMenu;
    private JMenuItem settingsSaveAsMenuItem;
    private JButton settingsSaveButton;
    private JMenuItem settingsSaveMenuItem;
    private JLabel statusLabel;
    private JToolBar toolBar;
    private JToolBar.Separator toolBarSeparator1;
    private JMenu trackingMenu;
    private JButton trackingStartButton;
    private JMenuItem trackingStartMenuItem;
    private JButton trackingStopButton;
    private JMenuItem trackingStopMenuItem;
    private JSplitPane verticalSplitPane;

    public MainFrame(String[] args) throws Exception {
        ActionMap map = this.getRootPane().getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        InputMap keys = this.getRootPane().getInputMap(1);
        keys.put(KeyStroke.getKeyStroke("control C"), "copy-to-clipboard");
        keys.put(KeyStroke.getKeyStroke("control X"), "cut-to-clipboard");
        keys.put(KeyStroke.getKeyStroke("control V"), "paste-from-clipboard");
        keys.put(KeyStroke.getKeyStroke("DELETE"), "delete");
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map);
        this.settingsFile = args.length > 0 ? new File(args[0]) : null;
        try {
            Logger.getLogger("").addHandler(new Handler(){
                {
                    this.setFormatter(new SimpleFormatter());
                }

                @Override
                public void publish(final LogRecord record) {
                    int messageType;
                    String title;
                    if (record.getLevel().equals(Level.SEVERE)) {
                        title = "SEVERE Logging Message";
                        messageType = 0;
                    } else if (record.getLevel().equals(Level.WARNING)) {
                        title = "WARNING Logging Message";
                        messageType = 2;
                    } else if (record.getLevel().equals(Level.INFO)) {
                        title = "INFO Logging Message";
                        messageType = 1;
                    } else {
                        title = "Tracing Logging Message";
                        messageType = -1;
                    }
                    String[] messageLines = this.getFormatter().format(record).split("\r\n|\r|\n");
                    StringBuilder messageBuilder = new StringBuilder();
                    for (int i = 0; i < Math.min(5, messageLines.length); ++i) {
                        messageBuilder.append(messageLines[i] + '\n');
                    }
                    if (messageLines.length > 5) {
                        messageBuilder.append("...");
                    }
                    final String message = messageBuilder.toString();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (messageType == 1) {
                                MainFrame.this.messagesio.getOut().println(this.getFormatter().formatMessage(record));
                            } else {
                                JOptionPane.showMessageDialog(MainFrame.this, message, title, messageType);
                            }
                        }
                    });
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() throws SecurityException {
                }
            });
            opencv_core.cvRedirectError((opencv_core.CvErrorCallback)new JavaCvErrorCallback(){

                @Override
                public int call(int status, BytePointer func_name, BytePointer err_msg, BytePointer file_name, int line, Pointer userdata) {
                    super.call(status, func_name, err_msg, file_name, line, userdata);
                    if (MainFrame.this.trackingWorker != null) {
                        MainFrame.this.trackingWorker.cancel();
                    }
                    return 0;
                }
            }, null, null);
            this.initComponents();
            this.loadSettings(this.settingsFile);
        }
        catch (IOException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, "Could not load settings from \"" + this.settingsFile + "\"", ex);
            this.loadSettings(null);
        }
        catch (LinkageError e) {
            throw new Exception(e);
        }
        IOContainer container = IOContainer.getDefault();
        Field f = container.getClass().getDeclaredField("provider");
        f.setAccessible(true);
        IOContainer.Provider prov = (IOContainer.Provider)f.get(container);
        f = prov.getClass().getDeclaredField("frame");
        f.setAccessible(true);
        f.set(prov, this);
        this.verticalSplitPane.setRightComponent((JComponent)prov);
        this.beanTreeView.requestFocusInWindow();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    @Override
    public void removeNotify() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
        super.removeNotify();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.trackingWorker && evt.getPropertyName().equals("progress")) {
            switch ((Integer)evt.getNewValue()) {
                case 1: {
                    this.statusLabel.setText("Initializing...");
                    break;
                }
                case 2: {
                    this.statusLabel.setText("Tracking...");
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    void buildSettingsView() throws IntrospectionException, PropertyVetoException {
        HashMap<String, Class<? extends PropertyEditor>> editors = new HashMap<String, Class<? extends PropertyEditor>>();
        editors.put("frameGrabber", FrameGrabber.PropertyEditor.class);
        editors.put("triggerMode", null);
        editors.put("imageMode", null);
        editors.put("timeout", null);
        editors.put("parametersFilename", null);
        editors.put("deviceFilename", null);
        editors.put("useOpenGL", null);
        editors.put("objectImage", null);
        editors.put("gammaTgamma", null);
        editors.put("outputVideoFilename", null);
        editors.put("textureImageFilename", null);
        editors.put("projectorImageFilename", null);
        editors.put("projectorVideoFilename", null);
        editors.put("initialRoiPts", null);
        editors.put("initialPosition", null);
        if (this.cameraSettings == null) {
            this.cameraSettings = new CameraDevice.CalibratedSettings();
            this.cameraSettings.setFrameGrabber(FrameGrabber.getDefault());
        }
        this.cameraSettings.addPropertyChangeListener(this);
        CleanBeanNode<CameraDevice.Settings> cameraNode = new CleanBeanNode<CameraDevice.Settings>(this.cameraSettings, editors, "Camera");
        if (this.projectorSettings == null) {
            this.projectorSettings = new ProjectorDevice.CalibratedSettings();
        }
        this.projectorSettings.addPropertyChangeListener(this);
        CleanBeanNode<ProjectorDevice.Settings> projectorNode = new CleanBeanNode<ProjectorDevice.Settings>(this.projectorSettings, editors, "Projector");
        if (this.objectFinderSettings == null) {
            this.objectFinderSettings = new ObjectFinder.Settings();
        }
        this.objectFinderSettings.addPropertyChangeListener(this);
        CleanBeanNode<ObjectFinder.Settings> objectFinderNode = new CleanBeanNode<ObjectFinder.Settings>(this.objectFinderSettings, editors, "ObjectFinder");
        if (this.markerDetectorSettings == null) {
            this.markerDetectorSettings = new MarkerDetector.Settings();
        }
        this.markerDetectorSettings.addPropertyChangeListener(this);
        CleanBeanNode<MarkerDetector.Settings> markerDetectorNode = new CleanBeanNode<MarkerDetector.Settings>(this.markerDetectorSettings, editors, "MarkerDetector");
        if (this.alignerSettings == null) {
            this.alignerSettings = new GNImageAligner.Settings();
        }
        CleanBeanNode<GNImageAligner.Settings> alignerNode = new CleanBeanNode<GNImageAligner.Settings>(this.alignerSettings, editors, "GNImageAligner");
        if (this.handMouseSettings == null) {
            this.handMouseSettings = new HandMouse.Settings();
        }
        CleanBeanNode<HandMouse.Settings> handMouseNode = new CleanBeanNode<HandMouse.Settings>(this.handMouseSettings, editors, "HandMouse");
        if (this.virtualBallSettings == null) {
            this.virtualBallSettings = new VirtualBall.Settings();
        }
        CleanBeanNode<VirtualBall.Settings> virtualBallNode = new CleanBeanNode<VirtualBall.Settings>(this.virtualBallSettings, editors, "VirtualBall");
        if (this.realityAugmentorSettings == null) {
            this.realityAugmentorSettings = new RealityAugmentor.Settings();
            RealityAugmentor.ObjectSettings os = new RealityAugmentor.ObjectSettings();
            RealityAugmentor.VirtualSettings vs = new RealityAugmentor.VirtualSettings();
            os.add(vs);
            this.realityAugmentorSettings.add(os);
        }
        CleanBeanNode<RealityAugmentor.Settings> realityAugmentorNode = new CleanBeanNode<RealityAugmentor.Settings>(this.realityAugmentorSettings, editors, "RealityAugmentor");
        if (this.trackingSettings == null) {
            this.trackingSettings = new TrackingWorker.Settings();
        }
        CleanBeanNode<TrackingWorker.Settings> trackingNode = new CleanBeanNode<TrackingWorker.Settings>(this.trackingSettings, editors, "TrackingWorker");
        Children.Array children = new Children.Array();
        children.add(new Node[]{cameraNode, projectorNode, objectFinderNode, markerDetectorNode, alignerNode, handMouseNode, virtualBallNode, realityAugmentorNode, trackingNode});
        AbstractNode root = new AbstractNode((Children)children);
        root.setName("Settings");
        this.manager.setRootContext((Node)root);
    }

    void loadSettings(File file) throws IOException, IntrospectionException, PropertyVetoException {
        if (file == null) {
            this.cameraSettings = null;
            this.projectorSettings = null;
            this.objectFinderSettings = null;
            this.markerDetectorSettings = null;
            this.alignerSettings = null;
            this.handMouseSettings = null;
            this.virtualBallSettings = null;
            this.realityAugmentorSettings = null;
            this.trackingSettings = null;
            this.trackingWorker = null;
        } else {
            XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(file)));
            this.cameraSettings = (CameraDevice.Settings)decoder.readObject();
            this.projectorSettings = (ProjectorDevice.Settings)decoder.readObject();
            this.objectFinderSettings = (ObjectFinder.Settings)decoder.readObject();
            this.markerDetectorSettings = (MarkerDetector.Settings)decoder.readObject();
            this.alignerSettings = (GNImageAligner.Settings)decoder.readObject();
            this.handMouseSettings = (HandMouse.Settings)decoder.readObject();
            this.virtualBallSettings = (VirtualBall.Settings)decoder.readObject();
            this.realityAugmentorSettings = (RealityAugmentor.Settings)decoder.readObject();
            this.trackingSettings = (TrackingWorker.Settings)decoder.readObject();
            decoder.close();
        }
        this.settingsFile = file;
        if (this.settingsFile == null) {
            this.setTitle("ProCamTracker");
        } else {
            this.setTitle(this.settingsFile.getName() + " - ProCamTracker");
        }
        this.buildSettingsView();
        if (this.trackingWorker == null) {
            this.statusLabel.setText("Idling.");
        }
    }

    void saveSettings(File file) throws IOException {
        this.settingsFile = file;
        if (this.settingsFile == null) {
            this.setTitle("ProCamTracker");
        } else {
            this.setTitle(this.settingsFile.getName() + " - ProCamTracker");
        }
        XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(this.settingsFile)));
        encoder.writeObject(this.cameraSettings);
        encoder.writeObject(this.projectorSettings);
        encoder.writeObject(this.objectFinderSettings);
        encoder.writeObject(this.markerDetectorSettings);
        encoder.writeObject(this.alignerSettings);
        encoder.writeObject(this.handMouseSettings);
        encoder.writeObject(this.virtualBallSettings);
        encoder.writeObject(this.realityAugmentorSettings);
        encoder.writeObject(this.trackingSettings);
        encoder.close();
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.settingsLoadDefaultsButton = new JButton();
        this.settingsLoadButton = new JButton();
        this.settingsSaveButton = new JButton();
        this.toolBarSeparator1 = new JToolBar.Separator();
        this.trackingStartButton = new JButton();
        this.trackingStopButton = new JButton();
        this.verticalSplitPane = new JSplitPane();
        this.horizontalSplitPane = new JSplitPane();
        this.beanTreeView = new BeanTreeView();
        this.propertySheetView = new PropertySheetView();
        this.statusLabel = new JLabel();
        this.menuBar = new JMenuBar();
        this.settingsMenu = new JMenu();
        this.settingsLoadDefaultsMenuItem = new JMenuItem();
        this.settingsLoadMenuItem = new JMenuItem();
        this.settingsSaveMenuItem = new JMenuItem();
        this.settingsSaveAsMenuItem = new JMenuItem();
        this.trackingMenu = new JMenu();
        this.trackingStartMenuItem = new JMenuItem();
        this.trackingStopMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.readmeMenuItem = new JMenuItem();
        this.menuSeparator2 = new JSeparator();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("ProCamTracker");
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.settingsLoadDefaultsButton.setIcon(new ImageIcon(this.getClass().getResource("/org/bytedeco/procamtracker/icons/cleanCurrentProject.gif")));
        this.settingsLoadDefaultsButton.setToolTipText("Load Defaults");
        this.settingsLoadDefaultsButton.setFocusable(false);
        this.settingsLoadDefaultsButton.setHorizontalTextPosition(0);
        this.settingsLoadDefaultsButton.setVerticalTextPosition(3);
        this.settingsLoadDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.settingsLoadDefaultsButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.settingsLoadDefaultsButton);
        this.settingsLoadButton.setIcon(new ImageIcon(this.getClass().getResource("/org/bytedeco/procamtracker/icons/openProject.png")));
        this.settingsLoadButton.setToolTipText("Load Settings");
        this.settingsLoadButton.setFocusable(false);
        this.settingsLoadButton.setHorizontalTextPosition(0);
        this.settingsLoadButton.setVerticalTextPosition(3);
        this.settingsLoadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.settingsLoadButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.settingsLoadButton);
        this.settingsSaveButton.setIcon(new ImageIcon(this.getClass().getResource("/org/bytedeco/procamtracker/icons/save.png")));
        this.settingsSaveButton.setToolTipText("Save Settings");
        this.settingsSaveButton.setFocusable(false);
        this.settingsSaveButton.setHorizontalTextPosition(0);
        this.settingsSaveButton.setVerticalTextPosition(3);
        this.settingsSaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.settingsSaveButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.settingsSaveButton);
        this.toolBar.add(this.toolBarSeparator1);
        this.trackingStartButton.setIcon(new ImageIcon(this.getClass().getResource("/org/bytedeco/procamtracker/icons/runProject.png")));
        this.trackingStartButton.setToolTipText("Start Tracking");
        this.trackingStartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.trackingStartButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.trackingStartButton);
        this.trackingStopButton.setIcon(new ImageIcon(this.getClass().getResource("/org/bytedeco/procamtracker/icons/stop.png")));
        this.trackingStopButton.setToolTipText("Stop Tracking");
        this.trackingStopButton.setEnabled(false);
        this.trackingStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.trackingStopButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.trackingStopButton);
        this.verticalSplitPane.setOrientation(0);
        this.verticalSplitPane.setResizeWeight(0.6);
        this.horizontalSplitPane.setResizeWeight(0.5);
        this.beanTreeView.setBorder(BorderFactory.createEtchedBorder());
        this.horizontalSplitPane.setLeftComponent((Component)this.beanTreeView);
        this.propertySheetView.setBorder(BorderFactory.createEtchedBorder());
        this.propertySheetView.setDescriptionAreaVisible(false);
        try {
            this.propertySheetView.setSortingMode(1);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        this.horizontalSplitPane.setRightComponent((Component)this.propertySheetView);
        this.verticalSplitPane.setLeftComponent(this.horizontalSplitPane);
        this.statusLabel.setText("Status");
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.settingsMenu.setMnemonic('E');
        this.settingsMenu.setText("Settings");
        this.settingsLoadDefaultsMenuItem.setMnemonic('D');
        this.settingsLoadDefaultsMenuItem.setText("Load Defaults");
        this.settingsLoadDefaultsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.settingsLoadDefaultsMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.settingsLoadDefaultsMenuItem);
        this.settingsLoadMenuItem.setMnemonic('L');
        this.settingsLoadMenuItem.setText("Load...");
        this.settingsLoadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.settingsLoadMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.settingsLoadMenuItem);
        this.settingsSaveMenuItem.setMnemonic('S');
        this.settingsSaveMenuItem.setText("Save");
        this.settingsSaveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.settingsSaveMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.settingsSaveMenuItem);
        this.settingsSaveAsMenuItem.setMnemonic('A');
        this.settingsSaveAsMenuItem.setText("Save As...");
        this.settingsSaveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.settingsSaveAsMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.settingsSaveAsMenuItem);
        this.menuBar.add(this.settingsMenu);
        this.trackingMenu.setMnemonic('T');
        this.trackingMenu.setText("Tracking");
        this.trackingStartMenuItem.setMnemonic('T');
        this.trackingStartMenuItem.setText("Start     ");
        this.trackingStartMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.trackingStartMenuItemActionPerformed(evt);
            }
        });
        this.trackingMenu.add(this.trackingStartMenuItem);
        this.trackingStopMenuItem.setMnemonic('O');
        this.trackingStopMenuItem.setText("Stop      ");
        this.trackingStopMenuItem.setEnabled(false);
        this.trackingStopMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.trackingStopMenuItemActionPerformed(evt);
            }
        });
        this.trackingMenu.add(this.trackingStopMenuItem);
        this.menuBar.add(this.trackingMenu);
        this.helpMenu.setMnemonic('H');
        this.helpMenu.setText("Help");
        this.readmeMenuItem.setMnemonic('R');
        this.readmeMenuItem.setText("README");
        this.readmeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.readmeMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.readmeMenuItem);
        this.helpMenu.add(this.menuSeparator2);
        this.aboutMenuItem.setMnemonic('A');
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolBar, -1, 500, Short.MAX_VALUE).addComponent(this.verticalSplitPane, -1, 500, Short.MAX_VALUE).addComponent(this.statusLabel, -1, 500, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.toolBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.verticalSplitPane, -1, 350, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusLabel)));
        this.pack();
    }

    private void settingsLoadDefaultsMenuItemActionPerformed(ActionEvent evt) {
        int response;
        if (evt != null && (response = JOptionPane.showConfirmDialog(this, "Load defaults settings and lose current ones?", "Confirm Reset", 2, 3)) == 2) {
            return;
        }
        try {
            this.loadSettings(null);
        }
        catch (Exception ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void settingsLoadMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        if (this.settingsFile != null) {
            fc.setSelectedFile(this.settingsFile);
        } else {
            fc.setSelectedFile(this.DEFAULT_SETTINGS_FILE);
        }
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            try {
                this.loadSettings(file);
            }
            catch (Exception ex) {
                Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, "Could not load settings from \"" + file + "\"", ex);
            }
        }
    }

    private void settingsSaveMenuItemActionPerformed(ActionEvent evt) {
        if (this.settingsFile == null) {
            this.settingsSaveAsMenuItemActionPerformed(evt);
        } else {
            int response;
            if (this.settingsFile.exists() && (response = JOptionPane.showConfirmDialog(this, "Overwrite existing file \"" + this.settingsFile + "\"?", "Confirm Overwrite", 2, 3)) == 2) {
                this.settingsSaveAsMenuItemActionPerformed(evt);
                return;
            }
            try {
                this.saveSettings(this.settingsFile);
            }
            catch (IOException ex) {
                Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, "Could not save settings to \"" + this.settingsFile + "\"", ex);
            }
        }
    }

    private void settingsSaveAsMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        if (this.settingsFile != null) {
            fc.setSelectedFile(this.settingsFile);
        } else {
            fc.setSelectedFile(this.DEFAULT_SETTINGS_FILE);
        }
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            this.settingsFile = fc.getSelectedFile();
            this.settingsSaveMenuItemActionPerformed(evt);
        }
    }

    private void trackingStartMenuItemActionPerformed(ActionEvent evt) {
        if (this.trackingWorker == null || this.trackingWorker.getState() != SwingWorker.StateValue.STARTED) {
            this.trackingWorker = new MyTrackingWorker(this.trackingWorker);
            this.trackingWorker.addPropertyChangeListener(this);
            this.settingsMenu.setEnabled(false);
            this.trackingStartMenuItem.setEnabled(false);
            this.trackingStopMenuItem.setEnabled(true);
            this.settingsLoadDefaultsButton.setEnabled(false);
            this.settingsLoadButton.setEnabled(false);
            this.settingsSaveButton.setEnabled(false);
            this.trackingStartButton.setEnabled(false);
            this.trackingStopButton.setEnabled(true);
            this.beanTreeView.setEnabled(false);
            this.propertySheetView.setEnabled(false);
            try {
                this.manager.setSelectedNodes(new Node[]{this.manager.getRootContext()});
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.trackingWorker.cameraSettings = this.cameraSettings;
            this.trackingWorker.projectorSettings = this.projectorSettings;
            this.trackingWorker.objectFinderSettings = this.objectFinderSettings;
            this.trackingWorker.markerDetectorSettings = this.markerDetectorSettings;
            this.trackingWorker.alignerSettings = this.alignerSettings;
            this.trackingWorker.handMouseSettings = this.handMouseSettings;
            this.trackingWorker.virtualBallSettings = this.virtualBallSettings;
            this.trackingWorker.realityAugmentorSettings = this.realityAugmentorSettings;
            this.trackingWorker.trackingSettings = this.trackingSettings;
            try {
                this.trackingWorker.init();
                this.trackingWorker.execute();
            }
            catch (Exception ex) {
                Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, "Could not initialize tracking worker thread.", ex);
                this.trackingWorker.cancel();
            }
        } else assert (false);
    }

    private void trackingStopMenuItemActionPerformed(ActionEvent evt) {
        if (this.trackingWorker != null) {
            this.trackingWorker.cancel();
        } else assert (false);
    }

    private void readmeMenuItemActionPerformed(ActionEvent evt) {
        try {
            String line;
            JTextArea textArea = new JTextArea();
            Font font = textArea.getFont();
            textArea.setFont(new Font("Monospaced", font.getStyle(), font.getSize()));
            textArea.setEditable(false);
            String text = "";
            BufferedReader r = new BufferedReader(new FileReader(myDirectory + File.separator + "../README.md"));
            while ((line = r.readLine()) != null) {
                text = text + line + '\n';
            }
            textArea.setText(text);
            textArea.setCaretPosition(0);
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            textArea.setColumns(80);
            JScrollPane scrollPane = new JScrollPane(textArea);
            Dimension dim = textArea.getPreferredSize();
            dim.height = dim.width * 50 / 80;
            scrollPane.setPreferredSize(dim);
            JDialog dialog = new JOptionPane(scrollPane, -1).createDialog(this, "README");
            dialog.setResizable(true);
            dialog.setModalityType(Dialog.ModalityType.MODELESS);
            dialog.setVisible(true);
        }
        catch (Exception ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        String version = MainFrame.class.getPackage().getImplementationVersion();
        if (version == null) {
            version = "unknown";
        }
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setContentType("text/html");
        textPane.setText("<font face=sans-serif><strong><font size=+2>ProCamTracker</font></strong> version " + version + "<br>" + "Copyright (C) 2009-2014 Samuel Audet &lt;<a href=\"mailto:saudet@ok.ctrl.titech.ac.jp%28Samuel%20Audet%29\">saudet@ok.ctrl.titech.ac.jp</a>&gt;<br>" + "Web site: <a href=\"http://www.ok.ctrl.titech.ac.jp/~saudet/procamtracker/\">http://www.ok.ctrl.titech.ac.jp/~saudet/procamtracker/</a><br>" + "<br>" + "Licensed under the GNU General Public License version 2 (GPLv2).<br>" + "Please refer to LICENSE.txt or <a href=\"http://www.gnu.org/licenses/\">http://www.gnu.org/licenses/</a> for details.");
        textPane.setCaretPosition(0);
        Dimension dim = textPane.getPreferredSize();
        dim.height = dim.width * 3 / 4;
        textPane.setPreferredSize(dim);
        textPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (Exception ex) {
                        Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, "Could not launch browser to \"" + e.getURL() + "\"", ex);
                    }
                }
            }
        });
        JDialog dialog = new JOptionPane(textPane, -1).createDialog(this, "About");
        if (UIManager.getLookAndFeel().getClass().getName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel")) {
            Color c = dialog.getRootPane().getBackground();
            textPane.setBackground(new Color(c.getRGB()));
        } else {
            Color frameBackground = this.getBackground();
            textPane.setBackground(frameBackground);
        }
        dialog.setVisible(true);
    }

    private void settingsLoadDefaultsButtonActionPerformed(ActionEvent evt) {
        this.settingsLoadDefaultsMenuItemActionPerformed(evt);
    }

    private void settingsLoadButtonActionPerformed(ActionEvent evt) {
        this.settingsLoadMenuItemActionPerformed(evt);
    }

    private void settingsSaveButtonActionPerformed(ActionEvent evt) {
        this.settingsSaveMenuItemActionPerformed(evt);
    }

    private void trackingStartButtonActionPerformed(ActionEvent evt) {
        this.trackingStartMenuItemActionPerformed(evt);
    }

    private void trackingStopButtonActionPerformed(ActionEvent evt) {
        this.trackingStopMenuItemActionPerformed(evt);
    }

    public static void main(final String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Threading.disableSingleThreading();
            GLProfile.initSingleton();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        FrameGrabber.init();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    myDirectory = new File(MainFrame.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                    if (!myDirectory.isDirectory()) {
                        myDirectory = myDirectory.getParentFile();
                    }
                    String path = myDirectory.getAbsolutePath();
                    String lafClassName = UIManager.getSystemLookAndFeelClassName();
                    ArrayList<String> otherArgs = new ArrayList<String>();
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i].equals("--laf") && i + 1 < args.length) {
                            lafClassName = args[i + 1];
                            ++i;
                            continue;
                        }
                        otherArgs.add(args[i]);
                    }
                    Startup.run(Class.forName(lafClassName), (int)0, null);
                    String[] searchPath = PropertyEditorManager.getEditorSearchPath();
                    String[] newSearchPath = new String[searchPath.length + 1];
                    newSearchPath[0] = "org.netbeans.beaninfo.editors";
                    System.arraycopy(searchPath, 0, newSearchPath, 1, searchPath.length);
                    PropertyEditorManager.setEditorSearchPath(newSearchPath);
                    PropertyEditorManager.registerEditor(String[].class, StringArrayEditor.class);
                    PropertyEditorManager.registerEditor(double[].class, DoubleArrayEditor.class);
                    JFrame.setDefaultLookAndFeelDecorated(true);
                    JDialog.setDefaultLookAndFeelDecorated(true);
                    MainFrame w = new MainFrame(otherArgs.toArray(new String[0]));
                    w.setLocationByPlatform(true);
                    w.setVisible(true);
                    w.messagesio = new NbIOProvider().getIO("Messages", new Action[0], IOContainer.getDefault());
                    w.messagesio.select();
                }
                catch (Exception ex) {
                    Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, "Could not start ProCamTracker", ex);
                }
            }
        });
    }

    class MyTrackingWorker
    extends TrackingWorker {
        public MyTrackingWorker(MyTrackingWorker brother) {
            if (brother != null) {
                this.cameraDevice = brother.cameraDevice;
                this.projectorDevice = brother.projectorDevice;
            }
        }

        @Override
        protected void done() {
            super.done();
            MainFrame.this.settingsMenu.setEnabled(true);
            MainFrame.this.trackingStartMenuItem.setEnabled(true);
            MainFrame.this.trackingStopMenuItem.setEnabled(false);
            MainFrame.this.settingsLoadDefaultsButton.setEnabled(true);
            MainFrame.this.settingsLoadButton.setEnabled(true);
            MainFrame.this.settingsSaveButton.setEnabled(true);
            MainFrame.this.trackingStartButton.setEnabled(true);
            MainFrame.this.trackingStopButton.setEnabled(false);
            MainFrame.this.beanTreeView.setEnabled(true);
            MainFrame.this.propertySheetView.setEnabled(true);
            if (this.isCancelled()) {
                MainFrame.this.statusLabel.setText("Tracking stopped.");
                MainFrame.this.trackingWorker = null;
            } else {
                MainFrame.this.statusLabel.setText("Tracking done.");
            }
        }
    }
}

