/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util;

import com.jogamp.common.os.Platform;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.llb.impl.CLImpl;
import java.util.Map;

public class CLInfo {
    public static StringBuilder print(StringBuilder stringBuilder) {
        CLPlatform[] cLPlatformArray;
        stringBuilder.append("HOST_JRE: ").append(System.getProperty("java.runtime.version")).append("\n");
        stringBuilder.append("HOST_JVM: ").append(System.getProperty("java.vm.name")).append("\n");
        stringBuilder.append("HOST_ARCH: ").append(Platform.getArchName()).append("\n");
        stringBuilder.append("HOST_NUM_CORES: ").append(Runtime.getRuntime().availableProcessors()).append("\n");
        stringBuilder.append("HOST_OS: ").append(Platform.getOSName()).append("\n");
        stringBuilder.append("HOST_LITTLE_ENDIAN: ").append(Platform.isLittleEndian()).append("\n");
        CLPlatform.initialize();
        stringBuilder.append("CL_BINDING_UNAVAILABLE_FUNCTIONS: ");
        stringBuilder.append(((CLImpl)CLPlatform.getLowLevelCLInterface()).getAddressTable().getNullPointerFunctions());
        stringBuilder.append("\n");
        for (CLPlatform cLPlatform : cLPlatformArray = CLPlatform.listCLPlatforms()) {
            CLDevice[] cLDeviceArray;
            Map<String, String> map = cLPlatform.getProperties();
            stringBuilder.append("\n");
            CLInfo.printInfo(stringBuilder, "", map);
            for (CLDevice cLDevice : cLDeviceArray = cLPlatform.listCLDevices()) {
                Map<String, String> map2 = cLDevice.getProperties();
                stringBuilder.append("\n");
                CLInfo.printInfo(stringBuilder, " - ", map2);
            }
        }
        return stringBuilder;
    }

    private static void printInfo(StringBuilder stringBuilder, String string, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(string).append(entry.getKey()).append(": ").append(entry.getValue()).append(Platform.getNewline());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println(CLInfo.print(new StringBuilder()).toString());
    }
}

