/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util.concurrent;

import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.CLResource;
import java.util.Map;

public abstract class CLQueueContext
implements CLResource {
    public final CLCommandQueue queue;

    public CLQueueContext(CLCommandQueue cLCommandQueue) {
        this.queue = cLCommandQueue;
    }

    public CLCommandQueue getQueue() {
        return this.queue;
    }

    public CLContext getCLContext() {
        return this.queue.getContext();
    }

    public static class CLSimpleQueueContext
    extends CLQueueContext {
        public final CLProgram program;
        public final Map<String, CLKernel> kernels;

        public CLSimpleQueueContext(CLCommandQueue cLCommandQueue, CLProgram cLProgram) {
            super(cLCommandQueue);
            this.program = cLProgram;
            this.kernels = cLProgram.createCLKernels();
        }

        public Map<String, CLKernel> getKernels() {
            return this.kernels;
        }

        public CLKernel getKernel(String string) {
            return this.kernels.get(string);
        }

        public CLProgram getProgram() {
            return this.program;
        }

        @Override
        public void release() {
            this.program.release();
        }

        @Override
        public boolean isReleased() {
            return this.program.isReleased();
        }
    }
}

