/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.procamtracker;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.bytedeco.javacpp.helper.opencv_core;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacv.CanvasFrame;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.Java2DFrameConverter;
import org.bytedeco.javacv.OpenCVFrameConverter;

public class Chronometer {
    private Rectangle roi;
    private long startTime;
    private OpenCVFrameConverter converter;
    private BufferedImage chronoImage;
    private Graphics2D chronoGraphics;
    private Font bigFont;
    private Font smallFont;
    private FontMetrics bigFontMetrics;
    private Rectangle2D bounds;

    Chronometer(Rectangle roi, opencv_core.IplImage image) {
        this(roi, image, -1L);
    }

    Chronometer(Rectangle roi, opencv_core.IplImage image, long startTime) {
        FontMetrics bigFontMetrics;
        Font smallFont;
        Font bigFont;
        Rectangle2D bounds;
        this.roi = (Rectangle)roi.clone();
        this.startTime = startTime;
        this.converter = new OpenCVFrameConverter.ToIplImage();
        this.chronoImage = new BufferedImage(roi.width, roi.height, Java2DFrameConverter.getBufferedImageType((Frame)this.converter.convert(image)));
        this.chronoGraphics = (Graphics2D)this.chronoImage.getGraphics();
        int fontSize = 10;
        do {
            bigFont = new Font("Sans", 1, fontSize);
            smallFont = new Font("Sans", 1, fontSize * 9 / 10);
            bigFontMetrics = this.chronoGraphics.getFontMetrics(bigFont);
            bounds = bigFontMetrics.getStringBounds("0\u203200\u20330", this.chronoGraphics);
            ++fontSize;
        } while (bounds.getWidth() * 1.1 < (double)roi.width && bounds.getHeight() * 1.1 < (double)roi.height);
        this.bigFont = bigFont;
        this.smallFont = smallFont;
        this.bigFontMetrics = bigFontMetrics;
        this.bounds = bounds;
        this.chronoGraphics.setBackground(Color.WHITE);
        this.chronoGraphics.setColor(Color.BLACK);
        this.chronoGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public void draw(opencv_core.IplImage image) {
        long time;
        if (this.startTime < 0L) {
            this.startTime = System.currentTimeMillis();
            time = 0L;
        } else {
            time = System.currentTimeMillis() - this.startTime;
        }
        long minutes = time / 1000L / 60L;
        long seconds = time / 1000L - minutes * 60L;
        long deciseconds = time / 100L - seconds * 10L - minutes * 600L;
        this.chronoGraphics.clearRect(0, 0, this.chronoImage.getWidth(), this.chronoImage.getHeight());
        this.chronoGraphics.setFont(this.bigFont);
        int x = (int)(((double)this.roi.width - this.bounds.getWidth()) / 2.0 - this.bounds.getX());
        int y = (int)(((double)this.roi.height - this.bounds.getHeight()) / 2.0 - this.bounds.getY());
        this.chronoGraphics.drawString("" + minutes, x, y);
        this.chronoGraphics.drawString("\u2032", x += this.bigFontMetrics.stringWidth("0"), y);
        this.chronoGraphics.drawString((seconds < 10L ? "0" : "") + seconds, x += this.bigFontMetrics.stringWidth("\u2032"), y);
        this.chronoGraphics.drawString("\u2033", x += this.bigFontMetrics.stringWidth("00"), y);
        this.chronoGraphics.setFont(this.smallFont);
        this.chronoGraphics.drawString("" + deciseconds, x += this.bigFontMetrics.stringWidth("\u2033"), y);
        if (this.roi.x < 0) {
            this.roi.x += image.width();
        }
        if (this.roi.y < 0) {
            this.roi.y += image.height();
        }
        Java2DFrameConverter.copy((BufferedImage)this.chronoImage, (Frame)this.converter.convert(image), (double)1.0, (image.nChannels() == 4 ? 1 : 0) != 0, (Rectangle)this.roi);
    }

    public static void main(String[] args) throws Exception {
        CanvasFrame frame = new CanvasFrame("Chronometer Test");
        OpenCVFrameConverter.ToIplImage converter = new OpenCVFrameConverter.ToIplImage();
        opencv_core.IplImage image = opencv_core.IplImage.create((int)640, (int)480, (int)8, (int)3);
        opencv_core.cvSetZero((opencv_core.CvArr)image);
        Chronometer chronometer = new Chronometer(new Rectangle(100, 100, 100, 100), image);
        for (int i = 0; i < 1000; ++i) {
            Thread.sleep(100L);
            opencv_core.cvSetZero((opencv_core.CvArr)image);
            chronometer.draw(image);
            frame.showImage(converter.convert(image));
        }
    }
}

