/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.video;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Rect;
import org.opencv.core.RotatedRect;
import org.opencv.core.Size;
import org.opencv.core.TermCriteria;
import org.opencv.utils.Converters;
import org.opencv.video.BackgroundSubtractorKNN;
import org.opencv.video.BackgroundSubtractorMOG2;
import org.opencv.video.DualTVL1OpticalFlow;

public class Video {
    private static final int CV_LKFLOW_INITIAL_GUESSES = 4;
    private static final int CV_LKFLOW_GET_MIN_EIGENVALS = 8;
    public static final int OPTFLOW_USE_INITIAL_FLOW = 4;
    public static final int OPTFLOW_LK_GET_MIN_EIGENVALS = 8;
    public static final int OPTFLOW_FARNEBACK_GAUSSIAN = 256;
    public static final int MOTION_TRANSLATION = 0;
    public static final int MOTION_EUCLIDEAN = 1;
    public static final int MOTION_AFFINE = 2;
    public static final int MOTION_HOMOGRAPHY = 3;

    public static Mat estimateRigidTransform(Mat src, Mat dst, boolean fullAffine) {
        Mat retVal = new Mat(Video.estimateRigidTransform_0(src.nativeObj, dst.nativeObj, fullAffine));
        return retVal;
    }

    public static BackgroundSubtractorKNN createBackgroundSubtractorKNN(int history, double dist2Threshold, boolean detectShadows) {
        BackgroundSubtractorKNN retVal = BackgroundSubtractorKNN.__fromPtr__(Video.createBackgroundSubtractorKNN_0(history, dist2Threshold, detectShadows));
        return retVal;
    }

    public static BackgroundSubtractorKNN createBackgroundSubtractorKNN() {
        BackgroundSubtractorKNN retVal = BackgroundSubtractorKNN.__fromPtr__(Video.createBackgroundSubtractorKNN_1());
        return retVal;
    }

    public static BackgroundSubtractorMOG2 createBackgroundSubtractorMOG2(int history, double varThreshold, boolean detectShadows) {
        BackgroundSubtractorMOG2 retVal = BackgroundSubtractorMOG2.__fromPtr__(Video.createBackgroundSubtractorMOG2_0(history, varThreshold, detectShadows));
        return retVal;
    }

    public static BackgroundSubtractorMOG2 createBackgroundSubtractorMOG2() {
        BackgroundSubtractorMOG2 retVal = BackgroundSubtractorMOG2.__fromPtr__(Video.createBackgroundSubtractorMOG2_1());
        return retVal;
    }

    public static DualTVL1OpticalFlow createOptFlow_DualTVL1() {
        DualTVL1OpticalFlow retVal = DualTVL1OpticalFlow.__fromPtr__(Video.createOptFlow_DualTVL1_0());
        return retVal;
    }

    public static RotatedRect CamShift(Mat probImage, Rect window, TermCriteria criteria) {
        double[] window_out = new double[4];
        RotatedRect retVal = new RotatedRect(Video.CamShift_0(probImage.nativeObj, window.x, window.y, window.width, window.height, window_out, criteria.type, criteria.maxCount, criteria.epsilon));
        if (window != null) {
            window.x = (int)window_out[0];
            window.y = (int)window_out[1];
            window.width = (int)window_out[2];
            window.height = (int)window_out[3];
        }
        return retVal;
    }

    public static double findTransformECC(Mat templateImage, Mat inputImage, Mat warpMatrix, int motionType, TermCriteria criteria, Mat inputMask) {
        double retVal = Video.findTransformECC_0(templateImage.nativeObj, inputImage.nativeObj, warpMatrix.nativeObj, motionType, criteria.type, criteria.maxCount, criteria.epsilon, inputMask.nativeObj);
        return retVal;
    }

    public static double findTransformECC(Mat templateImage, Mat inputImage, Mat warpMatrix, int motionType) {
        double retVal = Video.findTransformECC_1(templateImage.nativeObj, inputImage.nativeObj, warpMatrix.nativeObj, motionType);
        return retVal;
    }

    public static double findTransformECC(Mat templateImage, Mat inputImage, Mat warpMatrix) {
        double retVal = Video.findTransformECC_2(templateImage.nativeObj, inputImage.nativeObj, warpMatrix.nativeObj);
        return retVal;
    }

    public static int buildOpticalFlowPyramid(Mat img, List<Mat> pyramid, Size winSize, int maxLevel, boolean withDerivatives, int pyrBorder, int derivBorder, boolean tryReuseInputImage) {
        Mat pyramid_mat = new Mat();
        int retVal = Video.buildOpticalFlowPyramid_0(img.nativeObj, pyramid_mat.nativeObj, winSize.width, winSize.height, maxLevel, withDerivatives, pyrBorder, derivBorder, tryReuseInputImage);
        Converters.Mat_to_vector_Mat(pyramid_mat, pyramid);
        pyramid_mat.release();
        return retVal;
    }

    public static int buildOpticalFlowPyramid(Mat img, List<Mat> pyramid, Size winSize, int maxLevel) {
        Mat pyramid_mat = new Mat();
        int retVal = Video.buildOpticalFlowPyramid_1(img.nativeObj, pyramid_mat.nativeObj, winSize.width, winSize.height, maxLevel);
        Converters.Mat_to_vector_Mat(pyramid_mat, pyramid);
        pyramid_mat.release();
        return retVal;
    }

    public static int meanShift(Mat probImage, Rect window, TermCriteria criteria) {
        double[] window_out = new double[4];
        int retVal = Video.meanShift_0(probImage.nativeObj, window.x, window.y, window.width, window.height, window_out, criteria.type, criteria.maxCount, criteria.epsilon);
        if (window != null) {
            window.x = (int)window_out[0];
            window.y = (int)window_out[1];
            window.width = (int)window_out[2];
            window.height = (int)window_out[3];
        }
        return retVal;
    }

    public static void calcOpticalFlowFarneback(Mat prev, Mat next, Mat flow, double pyr_scale, int levels, int winsize, int iterations, int poly_n, double poly_sigma, int flags) {
        Video.calcOpticalFlowFarneback_0(prev.nativeObj, next.nativeObj, flow.nativeObj, pyr_scale, levels, winsize, iterations, poly_n, poly_sigma, flags);
    }

    public static void calcOpticalFlowPyrLK(Mat prevImg, Mat nextImg, MatOfPoint2f prevPts, MatOfPoint2f nextPts, MatOfByte status, MatOfFloat err, Size winSize, int maxLevel, TermCriteria criteria, int flags, double minEigThreshold) {
        MatOfPoint2f prevPts_mat = prevPts;
        MatOfPoint2f nextPts_mat = nextPts;
        MatOfByte status_mat = status;
        MatOfFloat err_mat = err;
        Video.calcOpticalFlowPyrLK_0(prevImg.nativeObj, nextImg.nativeObj, prevPts_mat.nativeObj, nextPts_mat.nativeObj, status_mat.nativeObj, err_mat.nativeObj, winSize.width, winSize.height, maxLevel, criteria.type, criteria.maxCount, criteria.epsilon, flags, minEigThreshold);
    }

    public static void calcOpticalFlowPyrLK(Mat prevImg, Mat nextImg, MatOfPoint2f prevPts, MatOfPoint2f nextPts, MatOfByte status, MatOfFloat err, Size winSize, int maxLevel) {
        MatOfPoint2f prevPts_mat = prevPts;
        MatOfPoint2f nextPts_mat = nextPts;
        MatOfByte status_mat = status;
        MatOfFloat err_mat = err;
        Video.calcOpticalFlowPyrLK_1(prevImg.nativeObj, nextImg.nativeObj, prevPts_mat.nativeObj, nextPts_mat.nativeObj, status_mat.nativeObj, err_mat.nativeObj, winSize.width, winSize.height, maxLevel);
    }

    public static void calcOpticalFlowPyrLK(Mat prevImg, Mat nextImg, MatOfPoint2f prevPts, MatOfPoint2f nextPts, MatOfByte status, MatOfFloat err) {
        MatOfPoint2f prevPts_mat = prevPts;
        MatOfPoint2f nextPts_mat = nextPts;
        MatOfByte status_mat = status;
        MatOfFloat err_mat = err;
        Video.calcOpticalFlowPyrLK_2(prevImg.nativeObj, nextImg.nativeObj, prevPts_mat.nativeObj, nextPts_mat.nativeObj, status_mat.nativeObj, err_mat.nativeObj);
    }

    private static native long estimateRigidTransform_0(long var0, long var2, boolean var4);

    private static native long createBackgroundSubtractorKNN_0(int var0, double var1, boolean var3);

    private static native long createBackgroundSubtractorKNN_1();

    private static native long createBackgroundSubtractorMOG2_0(int var0, double var1, boolean var3);

    private static native long createBackgroundSubtractorMOG2_1();

    private static native long createOptFlow_DualTVL1_0();

    private static native double[] CamShift_0(long var0, int var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double var9);

    private static native double findTransformECC_0(long var0, long var2, long var4, int var6, int var7, int var8, double var9, long var11);

    private static native double findTransformECC_1(long var0, long var2, long var4, int var6);

    private static native double findTransformECC_2(long var0, long var2, long var4);

    private static native int buildOpticalFlowPyramid_0(long var0, long var2, double var4, double var6, int var8, boolean var9, int var10, int var11, boolean var12);

    private static native int buildOpticalFlowPyramid_1(long var0, long var2, double var4, double var6, int var8);

    private static native int meanShift_0(long var0, int var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double var9);

    private static native void calcOpticalFlowFarneback_0(long var0, long var2, long var4, double var6, int var8, int var9, int var10, int var11, double var12, int var14);

    private static native void calcOpticalFlowPyrLK_0(long var0, long var2, long var4, long var6, long var8, long var10, double var12, double var14, int var16, int var17, int var18, double var19, int var21, double var22);

    private static native void calcOpticalFlowPyrLK_1(long var0, long var2, long var4, long var6, long var8, long var10, double var12, double var14, int var16);

    private static native void calcOpticalFlowPyrLK_2(long var0, long var2, long var4, long var6, long var8, long var10);
}

