/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.Clusters;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class Stamps {
    private static final Logger LOG = Logger.getLogger(Stamps.class.getName());
    private static AtomicLong moduleJARs;
    private static File moduleNewestFile;
    private static File[] fallbackCache;
    private static boolean populated;
    private static Boolean clustersChanged;
    private Worker worker = new Worker();
    private static final Stamps MODULES_JARS;

    private Stamps() {
    }

    static void main(String ... args) {
        if (args.length == 1 && "reset".equals(args[0])) {
            moduleJARs = null;
            Clusters.clear();
            clustersChanged = null;
            fallbackCache = null;
            Stamps.stamp(false);
            return;
        }
        if (args.length == 1 && "init".equals(args[0])) {
            moduleJARs = null;
            Clusters.clear();
            clustersChanged = null;
            fallbackCache = null;
            Stamps.stamp(true);
            return;
        }
        if (args.length == 1 && "clear".equals(args[0])) {
            moduleJARs = null;
            Clusters.clear();
            clustersChanged = null;
            fallbackCache = null;
            return;
        }
    }

    public static Stamps getModulesJARs() {
        return MODULES_JARS;
    }

    public long lastModified() {
        return Stamps.moduleJARs();
    }

    public boolean exists(String cache) {
        return this.file(cache, null) != null;
    }

    public InputStream asStream(String cache) {
        ByteBuffer bb = this.asByteBuffer(cache, false, false);
        if (bb == null) {
            return null;
        }
        return new ByteArrayInputStream(bb.array());
    }

    public MappedByteBuffer asMappedByteBuffer(String cache) {
        return (MappedByteBuffer)this.asByteBuffer(cache, true, true);
    }

    public ByteBuffer asByteBuffer(String cache) {
        return this.asByteBuffer(cache, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final File file(String cache, int[] len) {
        if (Stamps.clustersChanged()) {
            return null;
        }
        Stamps.checkPopulateCache();
        Stamps stamps = this;
        synchronized (stamps) {
            if (this.worker.isProcessing(cache)) {
                LOG.log(Level.FINE, "Worker processing when asking for {0}", cache);
                return null;
            }
        }
        return Stamps.fileImpl(cache, len, Stamps.moduleJARs());
    }

    private ByteBuffer asByteBuffer(String cache, boolean direct, boolean mmap) {
        int[] len = new int[1];
        File cacheFile = this.file(cache, len);
        if (cacheFile == null) {
            return null;
        }
        try {
            ByteBuffer master;
            FileChannel fc = new FileInputStream(cacheFile).getChannel();
            if (mmap) {
                master = fc.map(FileChannel.MapMode.READ_ONLY, 0L, len[0]);
                master.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                master = direct ? ByteBuffer.allocateDirect(len[0]) : ByteBuffer.allocate(len[0]);
                int red = fc.read(master);
                if (red != len[0]) {
                    LOG.warning("Read less than expected: " + red + " expected: " + len + " for " + cacheFile);
                    return null;
                }
                master.flip();
            }
            fc.close();
            return master;
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Cannot read cache " + cacheFile, ex);
            return null;
        }
    }

    public void scheduleSave(Updater updater, String cache, boolean append) {
        boolean firstAdd = this.scheduleSaveImpl(updater, cache, append);
        LOG.log(firstAdd ? Level.FINE : Level.FINER, "Scheduling save for {0} cache", cache);
        Clusters.scheduleSave(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean scheduleSaveImpl(Updater updater, String cache, boolean append) {
        Worker worker = this.worker;
        synchronized (worker) {
            return this.worker.addStorage(new Store(updater, cache, append));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(int delay) {
        Worker worker = this.worker;
        synchronized (worker) {
            this.worker.start(delay);
        }
    }

    public void shutdown() {
        this.waitFor(true);
    }

    public void discardCaches() {
        Stamps.discardCachesImpl(moduleJARs);
    }

    private static void discardCachesImpl(AtomicLong al) {
        File user = Places.getUserDirectory();
        long now = System.currentTimeMillis();
        if (user != null) {
            File f = new File(user, ".lastModified");
            if (f.exists()) {
                f.setLastModified(now);
            } else {
                f.getParentFile().mkdirs();
                try {
                    f.createNewFile();
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "Cannot create " + f, ex);
                }
            }
        }
        if (al != null) {
            al.set(now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void waitFor(boolean noNotify) {
        Worker wait;
        Worker worker = this.worker;
        synchronized (worker) {
            this.flush(0);
            wait = this.worker;
        }
        wait.waitFor(noNotify);
    }

    static long moduleJARs() {
        AtomicLong local = moduleJARs;
        if (local == null) {
            local = new AtomicLong();
            AtomicReference<File> newestFile = new AtomicReference<File>();
            Stamps.stamp(true, local, newestFile);
            moduleJARs = local;
            moduleNewestFile = newestFile.get();
        }
        return local.longValue();
    }

    private static AtomicLong stamp(boolean checkStampFile) {
        AtomicLong result = new AtomicLong();
        AtomicReference<File> newestFile = new AtomicReference<File>();
        Stamps.stamp(checkStampFile, result, newestFile);
        return result;
    }

    private static void stamp(boolean checkStampFile, AtomicLong result, AtomicReference<File> newestFile) {
        StringBuilder sb = new StringBuilder();
        HashSet<File> processedDirs = new HashSet<File>();
        String[] relativeDirs = Clusters.relativeDirsWithHome();
        String home = System.getProperty("netbeans.home");
        if (home != null) {
            long stamp = Stamps.stampForCluster(new File(home), result, newestFile, processedDirs, checkStampFile, true, null);
            sb.append(relativeDirs[0]).append('=').append(stamp).append('\n');
        }
        String[] drs = Clusters.dirs();
        for (int i = 0; i < drs.length; ++i) {
            File clusterDir = new File(drs[i]);
            long stamp = Stamps.stampForCluster(clusterDir, result, newestFile, processedDirs, checkStampFile, true, null);
            if (stamp == -1L) continue;
            sb.append("cluster.").append(relativeDirs[i + 1]).append('=').append(stamp).append('\n');
        }
        File user = Places.getUserDirectory();
        if (user != null) {
            AtomicInteger crc = new AtomicInteger();
            Stamps.stampForCluster(user, result, newestFile, new HashSet<File>(), false, false, crc);
            sb.append("user=").append(result.longValue()).append('\n');
            sb.append("crc=").append(crc.intValue()).append('\n');
            sb.append("locale=").append(Locale.getDefault()).append('\n');
            sb.append("branding=").append(NbBundle.getBranding()).append('\n');
            sb.append("java.version=").append(System.getProperty("java.version")).append('\n');
            sb.append("java.vm.version=").append(System.getProperty("java.vm.version")).append('\n');
            File checkSum = new File(Places.getCacheDirectory(), "lastModified/all-checksum.txt");
            if (!Stamps.compareAndUpdateFile(checkSum, sb.toString(), result)) {
                Stamps.discardCachesImpl(result);
            }
        }
    }

    private static long stampForCluster(File cluster, AtomicLong result, AtomicReference<File> newestFile, Set<File> hashSet, boolean checkStampFile, boolean createStampFile, AtomicInteger crc) {
        long time;
        File stamp = new File(cluster, ".lastModified");
        if (checkStampFile && (time = stamp.lastModified()) > 0L) {
            if (time > result.longValue()) {
                newestFile.set(stamp);
                result.set(time);
            }
            return time;
        }
        if (Places.getUserDirectory() != null) {
            stamp = new File(new File(Places.getCacheDirectory(), "lastModified"), Stamps.clusterLocalStamp(cluster));
            if (checkStampFile && (time = stamp.lastModified()) > 0L) {
                if (time > result.longValue()) {
                    newestFile.set(stamp);
                    result.set(time);
                }
                return time;
            }
        } else {
            createStampFile = false;
        }
        File configDir = new File(new File(cluster, "config"), "Modules");
        File modulesDir = new File(cluster, "modules");
        AtomicReference<File> newestInCluster = new AtomicReference<File>();
        AtomicLong clusterResult = new AtomicLong();
        if (!(Stamps.highestStampForDir(configDir, newestInCluster, clusterResult, crc) && Stamps.highestStampForDir(modulesDir, newestInCluster, clusterResult, crc) || cluster.isDirectory())) {
            return -1L;
        }
        if (clusterResult.longValue() > result.longValue()) {
            newestFile.set(newestInCluster.get());
            result.set(clusterResult.longValue());
        }
        if (createStampFile) {
            try {
                stamp.getParentFile().mkdirs();
                stamp.createNewFile();
                stamp.setLastModified(clusterResult.longValue());
            }
            catch (IOException ex) {
                System.err.println("Cannot write timestamp to " + stamp);
            }
        }
        return clusterResult.longValue();
    }

    private static boolean highestStampForDir(File file, AtomicReference<File> newestFile, AtomicLong result, AtomicInteger crc) {
        if (file.getName().equals(".nbattrs")) {
            return true;
        }
        File[] children = file.listFiles();
        if (children == null) {
            long time;
            if (crc != null) {
                crc.addAndGet(file.getName().length());
            }
            if ((time = file.lastModified()) > result.longValue()) {
                newestFile.set(file);
                result.set(time);
            }
            return false;
        }
        for (File f : children) {
            Stamps.highestStampForDir(f, newestFile, result, crc);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean compareAndUpdateFile(File file, String content, AtomicLong result) {
        try {
            long lastMod;
            boolean writeFile;
            boolean areCachesOK;
            byte[] expected = content.getBytes("UTF-8");
            byte[] read = new byte[expected.length];
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                int len = is.read(read);
                areCachesOK = len == read.length && is.available() == 0 && Arrays.equals(expected, read);
                writeFile = !areCachesOK;
                lastMod = file.lastModified();
            }
            catch (FileNotFoundException notFoundEx) {
                areCachesOK = true;
                writeFile = true;
                lastMod = result.get();
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            if (writeFile) {
                file.getParentFile().mkdirs();
                FileOutputStream os = new FileOutputStream(file);
                os.write(expected);
                os.close();
                if (areCachesOK) {
                    file.setLastModified(lastMod);
                }
            } else if (lastMod > result.get()) {
                result.set(lastMod);
            }
            return areCachesOK;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private static void deleteCache(File cacheFile) throws IOException {
        int fileCounter = 0;
        if (cacheFile.exists()) {
            File tmpFile = new File(cacheFile.getParentFile(), cacheFile.getName() + "." + fileCounter++);
            tmpFile.delete();
            boolean renamed = false;
            Random r = null;
            for (int i = 0; i < 10 && !(renamed = cacheFile.renameTo(tmpFile)); ++i) {
                LOG.log(Level.INFO, "cannot rename (#{0}): {1}", new Object[]{i, cacheFile});
                System.gc();
                System.runFinalization();
                LOG.info("after GC");
                if (r == null) {
                    r = new Random();
                }
                try {
                    int ms = r.nextInt(1000) + 1;
                    Thread.sleep(ms);
                    LOG.log(Level.INFO, "Slept {0} ms", ms);
                    continue;
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.INFO, "Interrupted", ex);
                }
            }
            if (!renamed) {
                cacheFile.deleteOnExit();
                throw new IOException("Could not delete: " + cacheFile);
            }
            if (!tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
        }
    }

    private static File findFallbackCache(String cache) {
        String fallbackCacheLocation = System.getProperty("netbeans.fallback.cache");
        if ("none".equals(fallbackCacheLocation)) {
            return null;
        }
        if (fallbackCache == null) {
            File fallback;
            File fallbackFile;
            fallbackCache = new File[0];
            if (fallbackCacheLocation != null && (fallbackFile = new File(fallbackCacheLocation)).isDirectory()) {
                fallbackCache = new File[]{fallbackFile};
            }
            if (fallbackCache.length == 0 && Clusters.dirs().length >= 1 && (fallback = new File(new File(new File(Clusters.dirs()[0]), "var"), "cache")).isDirectory()) {
                fallbackCache = new File[]{fallback};
            }
        }
        if (fallbackCache.length == 0) {
            return null;
        }
        return new File(fallbackCache[0], cache);
    }

    static void checkPopulateCache() {
        if (populated) {
            return;
        }
        populated = true;
        File cache = Places.getCacheDirectory();
        String[] children = cache.list();
        if (children != null && children.length > 0) {
            return;
        }
        InputStream is = Stamps.getModulesJARs().asStream("populate.zip");
        if (is == null) {
            return;
        }
        ZipInputStream zip = null;
        FileOutputStream os = null;
        try {
            ZipEntry en;
            byte[] arr = new byte[4096];
            LOG.log(Level.FINE, "Found populate.zip about to extract it into {0}", cache);
            zip = new ZipInputStream(is);
            while ((en = zip.getNextEntry()) != null) {
                int len;
                if (en.isDirectory()) continue;
                File f = new File(cache, en.getName().replace('/', File.separatorChar));
                f.getParentFile().mkdirs();
                os = new FileOutputStream(f);
                while ((len = zip.read(arr)) != -1) {
                    os.write(arr, 0, len);
                }
                os.close();
            }
            zip.close();
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Failed to populate {0}", cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean clustersChanged() {
        block17: {
            if (clustersChanged != null) {
                return clustersChanged;
            }
            String clustersCache = "all-clusters.dat";
            File f = Stamps.fileImpl("all-clusters.dat", null, -1L);
            if (f != null) {
                FilterInputStream dis = null;
                try {
                    dis = new DataInputStream(new FileInputStream(f));
                    if (Clusters.compareDirs((DataInputStream)dis)) {
                        boolean bl = false;
                        return bl;
                    }
                    break block17;
                }
                catch (IOException ex) {
                    clustersChanged = true;
                    boolean bl = clustersChanged;
                    return bl;
                }
                finally {
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (IOException ex) {
                            LOG.log(Level.INFO, null, ex);
                        }
                    }
                }
            }
            clustersChanged = false;
            return clustersChanged;
        }
        clustersChanged = true;
        return clustersChanged;
    }

    private static File fileImpl(String cache, int[] len, long moduleJARs) {
        File cacheFile = new File(Places.getCacheDirectory(), cache);
        long last = cacheFile.lastModified();
        if (last <= 0L) {
            LOG.log(Level.FINE, "Cache does not exist when asking for {0}", cache);
            cacheFile = Stamps.findFallbackCache(cache);
            if (cacheFile == null || (last = cacheFile.lastModified()) <= 0L) {
                return null;
            }
            LOG.log(Level.FINE, "Found fallback cache at {0}", cacheFile);
        }
        if (moduleJARs > last) {
            LOG.log(Level.FINE, "Timestamp does not pass when asking for {0}. Newest file {1}", new Object[]{cache, moduleNewestFile});
            return null;
        }
        long longLen = cacheFile.length();
        if (longLen > Integer.MAX_VALUE) {
            LOG.log(Level.WARNING, "Cache file is too big: {0} bytes for {1}", new Object[]{longLen, cacheFile});
            return null;
        }
        if (len != null) {
            len[0] = (int)longLen;
        }
        LOG.log(Level.FINE, "Cache found: {0}", cache);
        return cacheFile;
    }

    static String clusterLocalStamp(File cluster) {
        return cluster.getName().replaceAll("\\.\\.", "__");
    }

    static String readRelativePath(DataInput dis) throws IOException {
        String index = dis.readUTF();
        if (index.isEmpty()) {
            return index;
        }
        String relative = dis.readUTF();
        if ("user".equals(index)) {
            return System.getProperty("netbeans.user").concat(relative);
        }
        if ("home".equals(index)) {
            return System.getProperty("netbeans.home").concat(relative);
        }
        if ("abs".equals(index)) {
            return relative;
        }
        int indx = Integer.parseInt(index);
        Object[] _dirs = Clusters.dirs();
        if (indx < 0 || indx >= _dirs.length) {
            throw new IOException("Bad index " + indx + " for " + Arrays.toString(_dirs));
        }
        return _dirs[indx].concat(relative);
    }

    static void writeRelativePath(String path, DataOutput dos) throws IOException {
        Stamps.produceRelativePath(path, dos);
    }

    private static void produceRelativePath(String path, Object out) throws IOException {
        if (path.isEmpty()) {
            if (out instanceof DataOutput) {
                DataOutput dos = (DataOutput)out;
                dos.writeUTF(path);
            }
            return;
        }
        if (Stamps.testWritePath(path, System.getProperty("netbeans.user"), "user", out)) {
            return;
        }
        int cnt = 0;
        for (String p : Clusters.dirs()) {
            if (Stamps.testWritePath(path, p, "" + cnt, out)) {
                return;
            }
            ++cnt;
        }
        if (Stamps.testWritePath(path, System.getProperty("netbeans.home"), "home", out)) {
            return;
        }
        LOG.log(Level.FINE, "Cannot find relative path for {0}", path);
        Stamps.doWritePath("abs", path, out);
    }

    private static boolean testWritePath(String path, String prefix, String codeName, Object out) throws IOException {
        if (prefix == null || prefix.isEmpty()) {
            return false;
        }
        if (path.startsWith(prefix)) {
            String relPath = path.substring(prefix.length());
            Stamps.doWritePath(codeName, relPath, out);
            return true;
        }
        return false;
    }

    private static void doWritePath(String codeName, String relPath, Object out) throws IOException {
        if (out instanceof DataOutput) {
            DataOutput dos = (DataOutput)out;
            dos.writeUTF(codeName);
            dos.writeUTF(relPath);
        } else {
            Collection coll = (Collection)out;
            coll.add(codeName);
            coll.add(relPath);
        }
    }

    static String findRelativePath(String file) {
        ArrayList arrayList = new ArrayList();
        try {
            Stamps.produceRelativePath(file, arrayList);
        }
        catch (IOException ex) {
            return file;
        }
        return (String)arrayList.get(1);
    }

    static {
        MODULES_JARS = new Stamps();
    }

    private final class Worker
    extends Thread {
        private final LinkedList<Store> storages;
        private final HashSet<String> processing;
        private AtomicInteger delay;
        private boolean noNotify;

        public Worker() {
            super("Flushing caches");
            this.storages = new LinkedList();
            this.processing = new HashSet();
            this.setPriority(1);
        }

        public synchronized void start(int time) {
            if (this.delay == null) {
                this.delay = new AtomicInteger(time);
                super.start();
            }
        }

        public synchronized boolean addStorage(Store s) {
            boolean addNew = true;
            this.processing.add(s.cache);
            Iterator it = this.storages.iterator();
            while (it.hasNext()) {
                Store store = (Store)it.next();
                if (!store.equals(s)) continue;
                it.remove();
                addNew = false;
            }
            this.storages.add(s);
            return addNew;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int before;
            for (int till = before = this.delay.get(); till >= 0; till -= 500) {
                try {
                    Worker worker = this;
                    synchronized (worker) {
                        this.wait(500L);
                    }
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.INFO, null, ex);
                }
                if (before != this.delay.get()) break;
            }
            if (before > 512) {
                this.delay.compareAndSet(before, 512);
            }
            long time = System.currentTimeMillis();
            LOG.log(Level.FINE, "Storing caches {0}", this.storages);
            HashSet<Store> notify = new HashSet<Store>();
            while (true) {
                Store store;
                Worker worker = this;
                synchronized (worker) {
                    store = this.storages.poll();
                    if (store == null) {
                        Stamps.this.worker = new Worker();
                        break;
                    }
                }
                if (!store.store(this.delay)) continue;
                notify.add(store);
            }
            long much = System.currentTimeMillis() - time;
            LOG.log(Level.FINE, "Done storing caches {0}", notify);
            LOG.log(Level.FINE, "Took {0} ms", much);
            this.processing.clear();
            for (Store store : notify) {
                if (this.noNotify) continue;
                store.updater.cacheReady();
            }
            LOG.log(Level.FINE, "Notified ready {0}", notify);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void waitFor(boolean noNotify) {
            try {
                this.noNotify = noNotify;
                this.delay.set(0);
                Worker worker = this;
                synchronized (worker) {
                    this.notifyAll();
                }
                this.join();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private boolean isProcessing(String cache) {
            return this.processing.contains(cache);
        }
    }

    private static final class Store
    extends OutputStream {
        final Updater updater;
        final String cache;
        final boolean append;
        OutputStream os;
        AtomicInteger delay;
        int count;

        public Store(Updater updater, String cache, boolean append) {
            this.updater = updater;
            this.cache = cache;
            this.append = append;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean store(AtomicInteger delay) {
            assert (this.os == null);
            File cacheDir = Places.getCacheDirectory();
            if (!cacheDir.isDirectory()) {
                LOG.log(Level.WARNING, "Nonexistent cache directory: {0}", cacheDir);
                return false;
            }
            File cacheFile = new File(cacheDir, this.cache);
            boolean delete = false;
            try {
                LOG.log(Level.FINE, "Cleaning cache {0}", cacheFile);
                if (!this.append) {
                    Stamps.deleteCache(cacheFile);
                }
                cacheFile.getParentFile().mkdirs();
                LOG.log(Level.FINE, "Storing cache {0}", cacheFile);
                this.os = new FileOutputStream(cacheFile, this.append);
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(this, 0x100000));
                this.delay = delay;
                this.updater.flushCaches(dos);
                dos.close();
                LOG.log(Level.FINE, "Done Storing cache {0}", cacheFile);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Error saving cache {0}", cacheFile);
                LOG.log(Level.INFO, ex.getMessage(), ex);
                delete = true;
            }
            finally {
                if (this.os != null) {
                    try {
                        this.os.close();
                    }
                    catch (IOException ex) {
                        LOG.log(Level.WARNING, "Error closing stream for " + cacheFile, ex);
                    }
                    this.os = null;
                }
                if (delete) {
                    cacheFile.delete();
                    cacheFile.deleteOnExit();
                } else {
                    cacheFile.setLastModified(Stamps.moduleJARs());
                }
            }
            return !delete;
        }

        @Override
        public void close() throws IOException {
            this.os.close();
        }

        @Override
        public void flush() throws IOException {
            this.os.flush();
        }

        @Override
        public void write(int b) throws IOException {
            this.os.write(b);
            this.count(1);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.os.write(b);
            this.count(b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.os.write(b, off, len);
            this.count(len);
        }

        private void count(int add) {
            this.count += add;
            if (this.count > 65536) {
                int wait = this.delay.get();
                if (wait > 0) {
                    try {
                        Thread.sleep(wait);
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                this.count = 0;
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Store other = (Store)obj;
            if (!this.updater.equals(other.updater)) {
                return false;
            }
            return this.cache.equals(other.cache);
        }

        public int hashCode() {
            int hash = 7;
            hash = 19 * hash + (this.updater != null ? this.updater.hashCode() : 0);
            hash = 19 * hash + (this.cache != null ? this.cache.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return this.cache;
        }
    }

    public static interface Updater {
        public void flushCaches(DataOutputStream var1) throws IOException;

        public void cacheReady();
    }
}

