/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.procamtracker;

import com.jogamp.opencl.CLImage2d;
import com.jogamp.opencl.CLImageFormat;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLObject;
import com.jogamp.opencl.gl.CLGLImage2d;
import com.jogamp.opengl.GLContext;
import java.awt.EventQueue;
import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacv.BaseChildSettings;
import org.bytedeco.javacv.BufferRing;
import org.bytedeco.javacv.CameraDevice;
import org.bytedeco.javacv.CanvasFrame;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameGrabber;
import org.bytedeco.javacv.FrameRecorder;
import org.bytedeco.javacv.GLCanvasFrame;
import org.bytedeco.javacv.GNImageAligner;
import org.bytedeco.javacv.GNImageAlignerCL;
import org.bytedeco.javacv.HandMouse;
import org.bytedeco.javacv.ImageTransformer;
import org.bytedeco.javacv.ImageTransformerCL;
import org.bytedeco.javacv.Java2DFrameConverter;
import org.bytedeco.javacv.JavaCV;
import org.bytedeco.javacv.JavaCVCL;
import org.bytedeco.javacv.MarkerDetector;
import org.bytedeco.javacv.ObjectFinder;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.bytedeco.javacv.ProCamTransformer;
import org.bytedeco.javacv.ProCamTransformerCL;
import org.bytedeco.javacv.ProjectiveDevice;
import org.bytedeco.javacv.ProjectorDevice;
import org.bytedeco.javacv.ReflectanceInitializer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.CvArr;
import org.bytedeco.opencv.opencv_core.CvMat;
import org.bytedeco.opencv.opencv_core.CvRect;
import org.bytedeco.opencv.opencv_core.IplImage;
import org.bytedeco.procamtracker.RealityAugmentor;
import org.bytedeco.procamtracker.VirtualBall;

public class TrackingWorker
extends SwingWorker {
    CameraDevice.Settings cameraSettings;
    ProjectorDevice.Settings projectorSettings;
    ObjectFinder.Settings objectFinderSettings;
    MarkerDetector.Settings markerDetectorSettings;
    GNImageAligner.Settings alignerSettings;
    HandMouse.Settings handMouseSettings;
    VirtualBall.Settings virtualBallSettings;
    RealityAugmentor.Settings realityAugmentorSettings;
    Settings trackingSettings;
    private String[] monitorWindowsTitles = new String[]{"Initial Alignment", "Transformed Object", "Camera Target", "Residual Image", "Relative Residual", "HandMouse Image"};
    private CanvasFrame[] monitorWindows = null;
    OpenCVFrameConverter.ToIplImage[] monitorConverters = null;
    JavaCVCL contextCL = null;
    CameraDevice cameraDevice = null;
    FrameGrabber frameGrabber = null;
    ProjectorDevice projectorDevice = null;
    CanvasFrame projectorFrame = null;
    OpenCVFrameConverter.ToIplImage grabberConverter = null;
    OpenCVFrameConverter.ToIplImage projectorConverter = null;
    private double[] roiPts = null;
    private ProCamTransformer transformer;
    private ProCamTransformer.Parameters parameters;
    private ProCamTransformer.Parameters lastParameters;
    private ProCamTransformer.Parameters tempParameters;
    private GNImageAligner aligner;
    private ReflectanceInitializer reflectanceInitializer;
    private HandMouse handMouse = null;
    private RealityAugmentor realityAugmentor = null;
    private IplImage[] projectorInitFloatImages;
    private IplImage[] projectorInitImages;
    private IplImage[] cameraInitImages;
    private IplImage[] cameraInitFloatImages;
    private IplImage[] monitorImages;
    private IplImage grabbedImage;
    private IplImage undistortedCameraImage;
    private IplImage distortedProjectorImage;
    private IplImage reflectanceImage;
    private CLImage2d grabbedImageCL;
    private CLImage2d undistortedCameraImageCL;
    private CLImage2d reflectanceImageCL;
    private CLImage2d cameraMapxCL;
    private CLImage2d cameraMapyCL;
    private CLImage2d projectorMapxCL;
    private CLImage2d projectorMapyCL;
    private CLGLImage2d distortedProjectorImageCL;
    private CvRect roi = new CvRect();
    private FrameRecorder frameRecorder = null;
    private OpenCVFrameConverter.ToIplImage recorderConverter = null;
    private BufferRing<ProjectorBuffer> projectorBufferRing;
    private static final Logger logger = Logger.getLogger(TrackingWorker.class.getName());
    public static final int INITIALIZING = 1;
    public static final int TRACKING = 2;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private Runnable doCamera = new Runnable(){

        @Override
        public void run() {
            int maxLevel = TrackingWorker.this.alignerSettings.getPyramidLevelMax();
            try {
                RealityAugmentor.VirtualSettings virtualSettings = TrackingWorker.this.realityAugmentor.getVirtualSettings();
                if (TrackingWorker.this.aligner == null || virtualSettings != null && virtualSettings.projectionType != RealityAugmentor.ProjectionType.FIXED) {
                    ProjectorBuffer pb = (ProjectorBuffer)TrackingWorker.this.projectorBufferRing.get(1);
                    if (TrackingWorker.this.trackingSettings.useOpenCL) {
                        ((ProCamTransformerCL)TrackingWorker.this.transformer).setProjectorImageCL(pb.imageCL, 0, maxLevel);
                    }
                    if (TrackingWorker.this.aligner == null || !TrackingWorker.this.trackingSettings.useOpenCL) {
                        TrackingWorker.this.transformer.setProjectorImage(pb.image, 0, maxLevel);
                    }
                }
                TrackingWorker.this.grabbedImage = TrackingWorker.this.grabberConverter.convert(TrackingWorker.this.frameGrabber.getDelayedFrame());
                if (TrackingWorker.this.grabbedImage == null) {
                    TrackingWorker.this.grabbedImage = TrackingWorker.this.grabberConverter.convert(TrackingWorker.this.frameGrabber.grab());
                }
                if (TrackingWorker.this.grabbedImage != null) {
                    double gamma = TrackingWorker.this.frameGrabber.getGamma();
                    if (gamma != 1.0) {
                        Buffer buffer = TrackingWorker.this.grabbedImage.createBuffer();
                        int depth = OpenCVFrameConverter.getFrameDepth((int)TrackingWorker.this.grabbedImage.depth());
                        int stride = TrackingWorker.this.grabbedImage.widthStep() * 8 / Math.abs(depth);
                        Java2DFrameConverter.applyGamma((Buffer)buffer, (int)depth, (int)stride, (double)gamma);
                    }
                    if (TrackingWorker.this.trackingSettings.useOpenCL) {
                        if (TrackingWorker.this.aligner != null && TrackingWorker.this.alignerSettings.getDisplacementMax() > 0.0) {
                            double[] pts = TrackingWorker.this.aligner.getTransformedRoiPts();
                            int width = ((TrackingWorker)TrackingWorker.this).grabbedImageCL.width;
                            int height = ((TrackingWorker)TrackingWorker.this).grabbedImageCL.height;
                            TrackingWorker.this.roi.x(0).y(0).width(width).height(height);
                            int padX = (int)Math.round(TrackingWorker.this.alignerSettings.getDisplacementMax() * (double)width);
                            int padY = (int)Math.round(TrackingWorker.this.alignerSettings.getDisplacementMax() * (double)height);
                            int align = 1 << maxLevel + 1;
                            JavaCV.boundingRect((double[])pts, (CvRect)TrackingWorker.this.roi, (int)(padX + 3), (int)(padY + 3), (int)align, (int)align);
                            opencv_core.cvSetImageROI((IplImage)TrackingWorker.this.grabbedImage, (CvRect)TrackingWorker.this.roi);
                        } else {
                            opencv_core.cvResetImageROI((IplImage)TrackingWorker.this.grabbedImage);
                        }
                        TrackingWorker.this.contextCL.writeImage(TrackingWorker.this.grabbedImageCL, TrackingWorker.this.grabbedImage, false);
                        opencv_core.cvResetImageROI((IplImage)TrackingWorker.this.grabbedImage);
                        TrackingWorker.this.contextCL.remap(TrackingWorker.this.grabbedImageCL, TrackingWorker.this.undistortedCameraImageCL, TrackingWorker.this.cameraMapxCL, TrackingWorker.this.cameraMapyCL, TrackingWorker.this.frameGrabber.getSensorPattern());
                        if (TrackingWorker.this.aligner != null) {
                            ((GNImageAlignerCL)TrackingWorker.this.aligner).setTargetImageCL(TrackingWorker.this.undistortedCameraImageCL);
                        }
                    } else {
                        TrackingWorker.this.cameraDevice.undistort(TrackingWorker.this.grabbedImage, TrackingWorker.this.undistortedCameraImage);
                        if (TrackingWorker.this.aligner != null) {
                            TrackingWorker.this.aligner.setTargetImage(TrackingWorker.this.undistortedCameraImage);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };
    private Runnable doProjector = new Runnable(){

        @Override
        public void run() {
            try {
                ProjectorBuffer pb = (ProjectorBuffer)TrackingWorker.this.projectorBufferRing.get(-1);
                CvRect maxroi = TrackingWorker.this.realityAugmentor.getUpdateRect();
                if (TrackingWorker.this.trackingSettings.useOpenCL) {
                    if (maxroi != null) {
                        opencv_core.cvSetImageROI((IplImage)pb.image, (CvRect)maxroi);
                    } else {
                        opencv_core.cvResetImageROI((IplImage)pb.image);
                    }
                    TrackingWorker.this.contextCL.writeImage(pb.imageCL, pb.image, false);
                }
                if (TrackingWorker.this.projectorFrame != null) {
                    if (TrackingWorker.this.trackingSettings.useOpenCL) {
                        TrackingWorker.this.contextCL.acquireGLObject((CLObject)TrackingWorker.this.distortedProjectorImageCL);
                        TrackingWorker.this.contextCL.remap(pb.imageCL, (CLImage2d)TrackingWorker.this.distortedProjectorImageCL, TrackingWorker.this.projectorMapxCL, TrackingWorker.this.projectorMapyCL);
                        TrackingWorker.this.contextCL.releaseGLObject((CLObject)TrackingWorker.this.distortedProjectorImageCL);
                        ((GLCanvasFrame)TrackingWorker.this.projectorFrame).showImage(TrackingWorker.this.distortedProjectorImageCL.getGLObjectID());
                    } else {
                        opencv_core.cvResetImageROI((IplImage)TrackingWorker.this.distortedProjectorImage);
                        opencv_core.cvResetImageROI((IplImage)pb.image);
                        TrackingWorker.this.projectorDevice.distort(pb.image, TrackingWorker.this.distortedProjectorImage);
                        if (maxroi != null) {
                            opencv_core.cvSetImageROI((IplImage)pb.image, (CvRect)maxroi);
                            opencv_core.cvSetImageROI((IplImage)TrackingWorker.this.distortedProjectorImage, (CvRect)maxroi);
                        }
                        TrackingWorker.this.projectorFrame.showImage(TrackingWorker.this.projectorConverter.convert(TrackingWorker.this.distortedProjectorImage));
                    }
                }
                if (TrackingWorker.this.aligner != null) {
                    long prevDelayedTime = TrackingWorker.this.frameGrabber.getDelayedTime();
                    TrackingWorker.this.frameGrabber.delayedGrab((long)(TrackingWorker.this.trackingSettings.proCamPhaseShift * 1000));
                    if ((double)prevDelayedTime > ((double)TrackingWorker.this.trackingSettings.proCamPhaseShift + 1000.0 / TrackingWorker.this.frameGrabber.getFrameRate()) * 1000.0) {
                        if (TrackingWorker.this.trackingSettings.useOpenCL) {
                            ((GLCanvasFrame)TrackingWorker.this.projectorFrame).showImage(TrackingWorker.this.distortedProjectorImageCL.getGLObjectID());
                        } else {
                            TrackingWorker.this.projectorFrame.showImage(TrackingWorker.this.projectorConverter.convert(TrackingWorker.this.distortedProjectorImage));
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };

    public boolean cancel() {
        return this.cancel(this.getProgress() == 1);
    }

    public void init() throws Exception {
        if (this.cameraDevice == null) {
            this.cameraDevice = new CameraDevice(this.cameraSettings);
        } else {
            this.cameraDevice.setSettings(this.cameraSettings);
        }
        this.projectorSettings.setUseOpenGL(this.trackingSettings.useOpenCL);
        if (this.projectorDevice == null) {
            this.projectorDevice = new ProjectorDevice(this.projectorSettings);
            if (this.trackingSettings.useOpenCL) {
                CvMat X = this.projectorDevice.colorMixingMatrix;
                double[] x = X.get();
                X.put(new double[]{x[8], x[7], x[6], x[5], x[4], x[3], x[2], x[1], x[0]});
            }
        } else {
            this.projectorDevice.setSettings(this.projectorSettings);
        }
        this.projectorFrame = this.projectorDevice.createCanvasFrame();
        this.projectorConverter = new OpenCVFrameConverter.ToIplImage();
        if (this.trackingSettings.getMonitorWindowsScale() > 0.0) {
            this.monitorWindows = new CanvasFrame[this.monitorWindowsTitles.length];
            this.monitorConverters = new OpenCVFrameConverter.ToIplImage[this.monitorWindowsTitles.length];
            for (int i = 0; i < this.monitorWindows.length; ++i) {
                this.monitorWindows[i] = new CanvasFrame(this.monitorWindowsTitles[i]);
                this.monitorWindows[i].setCanvasScale(this.trackingSettings.getMonitorWindowsScale());
                this.monitorConverters[i] = new OpenCVFrameConverter.ToIplImage();
            }
            this.monitorImages = new IplImage[this.alignerSettings.getPyramidLevelMax() + 1];
        } else {
            this.monitorWindows = null;
            this.monitorImages = null;
        }
    }

    private IplImage getMonitorImage(IplImage floatImage, IplImage maskImage, int pyramidLevel) {
        int[] nArray;
        int inChannels = floatImage.nChannels();
        int outChannels = 3;
        if (inChannels == 3) {
            int[] nArray2 = new int[3];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray = nArray2;
            nArray2[2] = 2;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 2;
            nArray3[1] = 1;
            nArray = nArray3;
            nArray3[2] = 0;
        }
        int[] order = nArray;
        if (this.monitorImages[pyramidLevel] == null) {
            this.monitorImages[pyramidLevel] = IplImage.create((int)floatImage.width(), (int)floatImage.height(), (int)8, (int)3);
        }
        FloatBuffer in = floatImage.getFloatBuffer();
        ByteBuffer mask = maskImage == null ? null : maskImage.getByteBuffer();
        ByteBuffer out = this.monitorImages[pyramidLevel].getByteBuffer();
        float[] buffer = new float[4];
        while (in.hasRemaining() && out.hasRemaining() && (mask == null || mask.hasRemaining())) {
            int z;
            int m = mask == null ? -1 : (int)mask.get();
            for (z = 0; z < inChannels; ++z) {
                buffer[z] = Math.max(0.0f, Math.min(1.0f, Math.abs(in.get())));
            }
            for (z = 0; z < 3; ++z) {
                out.put((byte)(m == 0 ? 0 : Math.round(buffer[order[z]] * 255.0f)));
            }
        }
        return this.monitorImages[pyramidLevel];
    }

    private boolean doTracking() throws Exception {
        int i;
        int minLevel = this.alignerSettings.getPyramidLevelMin();
        int maxLevel = this.alignerSettings.getPyramidLevelMax();
        this.setProgress(1);
        this.frameGrabber.setImageMode(FrameGrabber.ImageMode.COLOR);
        for (i = 0; i < this.projectorInitImages.length; ++i) {
            if (this.projectorFrame != null) {
                opencv_core.cvResetImageROI((IplImage)this.projectorInitImages[i]);
                this.projectorFrame.showImage(this.projectorConverter.convert(this.projectorInitImages[i]));
                this.projectorFrame.waitLatency();
            }
            this.frameGrabber.flush();
            this.grabbedImage = this.grabberConverter.convert(this.frameGrabber.grab());
            opencv_core.cvResetImageROI((IplImage)this.cameraInitImages[i]);
            if (this.grabbedImage.nChannels() == 3 && this.cameraInitImages[i].nChannels() == 4) {
                opencv_imgproc.cvCvtColor((CvArr)this.grabbedImage, (CvArr)this.cameraInitImages[i], (int)2);
                continue;
            }
            if (this.grabbedImage.nChannels() == 4 && this.cameraInitImages[i].nChannels() == 3) {
                opencv_imgproc.cvCvtColor((CvArr)this.grabbedImage, (CvArr)this.cameraInitImages[i], (int)3);
                continue;
            }
            opencv_core.cvCopy((CvArr)this.grabbedImage, (CvArr)this.cameraInitImages[i]);
        }
        for (i = 0; i < this.cameraInitImages.length; ++i) {
            double gamma = this.frameGrabber.getGamma();
            if (gamma == 1.0) continue;
            Buffer buffer = this.cameraInitImages[i].createBuffer();
            int depth = OpenCVFrameConverter.getFrameDepth((int)this.cameraInitImages[i].depth());
            int stride = this.cameraInitImages[i].widthStep() * 8 / Math.abs(depth);
            Java2DFrameConverter.applyGamma((Buffer)buffer, (int)depth, (int)stride, (double)gamma);
        }
        this.cameraDevice.setMapsPyramidLevel(0);
        IplImage cameraTempInit = this.cameraDevice.undistort(this.cameraInitImages[1]);
        if (this.monitorWindows != null) {
            boolean flipChannels = cameraTempInit.nChannels() == 4;
            this.monitorWindows[0].showImage(this.monitorConverters[0].convert(cameraTempInit), flipChannels);
        }
        this.roiPts = this.realityAugmentor.acquireRoi(this.monitorWindows == null ? null : this.monitorWindows[0], this.trackingSettings.getMonitorWindowsScale(), cameraTempInit, 0);
        if (this.roiPts == null) {
            return false;
        }
        RealityAugmentor.ObjectSettings objectSettings = this.realityAugmentor.getObjectSettings();
        boolean surfaceHasTexture = objectSettings != null && objectSettings.isSurfaceHasTexture();
        double[] referencePoints = surfaceHasTexture ? this.roiPts : null;
        this.cameraDevice.setMapsPyramidLevel(minLevel);
        opencv_core.cvResetImageROI((IplImage)this.undistortedCameraImage);
        for (int i2 = 0; i2 < this.cameraInitImages.length; ++i2) {
            this.cameraDevice.undistort(this.cameraInitImages[i2], this.undistortedCameraImage);
            opencv_core.cvResetImageROI((IplImage)this.cameraInitFloatImages[i2]);
            opencv_core.cvConvertScale((CvArr)this.undistortedCameraImage, (CvArr)this.cameraInitFloatImages[i2], (double)(1.0 / this.undistortedCameraImage.highValue()), (double)0.0);
            if (this.frameRecorder == null) continue;
            Frame frame = this.recorderConverter.convert(this.undistortedCameraImage);
            Java2DFrameConverter.applyGamma((Frame)frame, (double)0.45454545454545453);
            this.frameRecorder.record(frame);
        }
        double[] gainAmbientLight = new double[this.cameraInitFloatImages[0].nChannels() > 1 ? 4 : 2];
        opencv_core.cvResetImageROI((IplImage)this.reflectanceImage);
        this.reflectanceInitializer.initializeReflectance(this.cameraInitFloatImages, this.reflectanceImage, this.roiPts, gainAmbientLight);
        if (this.trackingSettings.useOpenCL) {
            this.contextCL.writeImage(this.reflectanceImageCL, this.reflectanceImage, false);
        }
        String infoLogString = "initial a = (";
        for (int i3 = 1; i3 < gainAmbientLight.length; ++i3) {
            infoLogString = infoLogString + Float.toString((float)gainAmbientLight[i3]);
            if (i3 >= gainAmbientLight.length - 1) continue;
            infoLogString = infoLogString + ", ";
        }
        logger.info(infoLogString + ")");
        logger.info("initializing plane parameters...");
        CvMat n0 = this.reflectanceInitializer.initializePlaneParameters(surfaceHasTexture ? this.reflectanceImage : null, this.cameraInitFloatImages[2], referencePoints, this.roiPts, gainAmbientLight);
        logger.info("initial n = " + (n0 == null ? null : n0.toString(12)));
        this.transformer = this.trackingSettings.useOpenCL ? new ProCamTransformerCL(this.contextCL, referencePoints, this.cameraDevice, this.projectorDevice, n0) : new ProCamTransformer(referencePoints, this.cameraDevice, this.projectorDevice, n0);
        this.parameters = this.transformer.createParameters();
        int gainAmbientLightStart = this.parameters.size() - gainAmbientLight.length;
        int gainAmbientLightEnd = this.parameters.size();
        for (int i4 = gainAmbientLightStart; i4 < gainAmbientLightEnd; ++i4) {
            this.parameters.set(i4, gainAmbientLight[i4 - gainAmbientLightStart]);
        }
        this.lastParameters = this.parameters.clone();
        this.tempParameters = this.parameters.clone();
        this.setProgress(2);
        if (this.trackingSettings.useOpenCL && this.frameGrabber.getSensorPattern() != -1L) {
            this.frameGrabber.setImageMode(FrameGrabber.ImageMode.RAW);
        }
        if (objectSettings != null && objectSettings.roiAcquisitionMethod == RealityAugmentor.RoiAcquisitionMethod.MARKER_DETECTOR) {
            logger.info("\niteratingTime  iterations  objectiveRMSE  markerErrors  markerErrorsRunningAverage\n----------------------------------------------------------------------------------");
        } else {
            logger.info("\niteratingTime  iterations  objectiveRMSE\n----------------------------------------");
        }
        this.aligner = null;
        this.projectorBufferRing.position(0);
        ProjectorBuffer pb0 = (ProjectorBuffer)this.projectorBufferRing.get();
        pb0.roi.x(0).y(0).width(pb0.image.width()).height(pb0.image.height());
        this.realityAugmentor.update(pb0.image, pb0.roi, -1.0, -1.0, false, this.parameters);
        this.realityAugmentor.getUpdateRect();
        opencv_core.cvResetImageROI((IplImage)pb0.image);
        if (this.trackingSettings.useOpenCL) {
            this.contextCL.writeImage(pb0.imageCL, pb0.image, false);
        }
        for (int i5 = 1; i5 < this.projectorBufferRing.capacity(); ++i5) {
            ProjectorBuffer pb = (ProjectorBuffer)this.projectorBufferRing.get(i5);
            pb.roi.x(0).y(0).width(pb.image.width()).height(pb.image.height());
            opencv_core.cvResetImageROI((IplImage)pb.image);
            opencv_core.cvCopy((CvArr)pb0.image, (CvArr)pb.image);
            if (!this.trackingSettings.useOpenCL) continue;
            this.contextCL.writeImage(pb.imageCL, pb.image, false);
        }
        this.doProjector.run();
        if (this.projectorFrame != null) {
            this.projectorFrame.waitLatency();
        }
        this.frameGrabber.flush();
        this.doCamera.run();
        if (this.monitorWindows != null) {
            this.transformer.transform(this.reflectanceImage, this.cameraInitFloatImages[0], null, minLevel, (ImageTransformer.Parameters)this.parameters, false);
            IplImage monitorImage = this.getMonitorImage(this.cameraInitFloatImages[0], null, minLevel);
            this.monitorWindows[0].showImage(this.monitorConverters[0].convert(monitorImage));
        }
        this.aligner = this.trackingSettings.useOpenCL ? new GNImageAlignerCL((ImageTransformerCL)((ProCamTransformerCL)this.transformer), (ImageTransformer.Parameters)this.parameters, surfaceHasTexture ? this.reflectanceImageCL : null, this.roiPts, this.undistortedCameraImageCL, this.alignerSettings) : new GNImageAligner((ImageTransformer)this.transformer, (ImageTransformer.Parameters)this.parameters, surfaceHasTexture ? this.reflectanceImage : null, this.roiPts, this.undistortedCameraImage, this.alignerSettings);
        long timeMax = this.trackingSettings.getIteratingTimeMax() * 1000000;
        double[] delta = new double[this.parameters.size() + 1];
        double[] iterationTime = new double[maxLevel + 1];
        double[] iterationTime2 = new double[maxLevel + 1];
        int[] iterationCount = new int[maxLevel + 1];
        int[] iterationCount2 = new int[maxLevel + 1];
        double totalIteratingTime2 = 0.0;
        int totalIterationCount2 = 0;
        double totalAuditTime = 0.0;
        double totalAuditTime2 = 0.0;
        double totalHandMouseTime = 0.0;
        double totalHandMouseTime2 = 0.0;
        double totalUpdateTime = 0.0;
        double totalUpdateTime2 = 0.0;
        double totalTime = 0.0;
        double totalTime2 = 0.0;
        int framesCount = 0;
        int lostCount = 0;
        while (!this.isCancelled() && this.grabbedImage != null && !Double.isNaN(this.aligner.getRMSE())) {
            int i6;
            long startTime = System.nanoTime();
            ++framesCount;
            boolean converged = false;
            long iteratingTime = 0L;
            int[] iterationsPerLevel = new int[maxLevel + 1];
            while (!converged) {
                int p = this.aligner.getPyramidLevel();
                long iterationStartTime = System.nanoTime();
                converged = this.aligner.iterate(delta);
                long iterationEndTime = System.nanoTime();
                long time = iterationEndTime - iterationStartTime;
                iteratingTime += time;
                int n = p;
                iterationsPerLevel[n] = iterationsPerLevel[n] + 1;
                int n2 = p;
                iterationTime[n2] = iterationTime[n2] + (double)time;
                int n3 = p;
                iterationTime2[n3] = iterationTime2[n3] + (double)(time * time);
                if (timeMax <= 0L || iteratingTime <= timeMax) continue;
                converged = true;
            }
            int iterations = 0;
            for (int i7 = 0; i7 < iterationsPerLevel.length; ++i7) {
                iterations += iterationsPerLevel[i7];
                int n = i7;
                iterationCount[n] = iterationCount[n] + iterationsPerLevel[i7];
                int n4 = i7;
                iterationCount2[n4] = iterationCount2[n4] + iterationsPerLevel[i7] * iterationsPerLevel[i7];
            }
            infoLogString = iteratingTime / 1000000L + "  " + iterations + "  " + (float)this.aligner.getRMSE();
            totalIteratingTime2 += (double)(iteratingTime * iteratingTime);
            totalIterationCount2 += iterations * iterations;
            this.parameters = (ProCamTransformer.Parameters)this.aligner.getParameters();
            long auditTime = System.nanoTime();
            boolean resetGainAmbientLight = false;
            int from = this.parameters.size() - this.transformer.getNumGains() - this.transformer.getNumBiases();
            int to = this.parameters.size();
            for (i6 = from; i6 < to; ++i6) {
                double p = this.parameters.get(i6);
                if (!(p < 0.0) && !(p > 2.0)) continue;
                resetGainAmbientLight = true;
                break;
            }
            if (resetGainAmbientLight) {
                for (i6 = from; i6 < to; ++i6) {
                    this.parameters.set(i6, this.lastParameters.get(i6));
                }
                this.aligner.setParameters((ImageTransformer.Parameters)this.parameters);
            }
            if (this.trackingSettings.pyramidLevelAudit >= 0) {
                int p = this.trackingSettings.pyramidLevelAudit;
                if (this.aligner.getPyramidLevel() != p) {
                    this.aligner.setPyramidLevel(p);
                }
                double RMSE = this.aligner.getRMSE();
                this.tempParameters.set((ImageTransformer.Parameters)this.parameters);
                this.aligner.setParameters((ImageTransformer.Parameters)this.lastParameters);
                double lastRMSE = this.aligner.getRMSE();
                if (RMSE < lastRMSE) {
                    this.aligner.setParameters((ImageTransformer.Parameters)this.tempParameters);
                }
            }
            if (this.trackingSettings.outlierRatioMax > 0.0 && (double)this.aligner.getOutlierCount() >= this.trackingSettings.outlierRatioMax * (double)this.aligner.getPixelCount()) {
                if (++lostCount > 1) {
                    break;
                }
            } else {
                lostCount = 0;
            }
            this.parameters = (ProCamTransformer.Parameters)this.aligner.getParameters();
            long handMouseTime = System.nanoTime();
            IplImage[] images = null;
            if (this.realityAugmentor.needsMouse()) {
                int p = this.trackingSettings.pyramidLevelHandMouse;
                if (this.aligner.getPyramidLevel() != p) {
                    this.aligner.setPyramidLevel(p);
                }
                if (images == null) {
                    images = this.aligner.getImages();
                }
                CvRect roi = this.aligner.getRoi();
                double[] roiPts = this.aligner.getTransformedRoiPts();
                this.handMouse.update(images, p, roi, roiPts);
            }
            long updateTime = System.nanoTime();
            boolean haveVisibleWindows = false;
            if (this.monitorWindows != null) {
                for (CanvasFrame w : this.monitorWindows) {
                    if (!w.isVisible()) continue;
                    haveVisibleWindows = true;
                    break;
                }
            }
            if (haveVisibleWindows) {
                int p = this.aligner.getPyramidLevel();
                double scale = this.trackingSettings.getMonitorWindowsScale() * (double)(1 << p);
                if (images == null) {
                    images = this.aligner.getImages();
                }
                IplImage target = images[1];
                IplImage transformed = images[2];
                IplImage residual = images[3];
                IplImage mask = images[4];
                IplImage monitorImage = this.getMonitorImage(transformed, mask, p);
                this.monitorWindows[1].setCanvasScale(scale);
                this.monitorWindows[1].showImage(this.monitorConverters[1].convert(monitorImage));
                monitorImage = this.getMonitorImage(target, null, p);
                this.cameraDevice.setMapsPyramidLevel(0);
                IplImage cameraTempImage = this.cameraDevice.undistort(this.grabbedImage);
                infoLogString = infoLogString + this.realityAugmentor.drawRoi(monitorImage, p, cameraTempImage, this.transformer, this.parameters);
                this.cameraDevice.setMapsPyramidLevel(minLevel);
                this.monitorWindows[2].setCanvasScale(scale);
                this.monitorWindows[2].showImage(this.monitorConverters[2].convert(monitorImage));
                if (this.frameRecorder != null) {
                    opencv_imgproc.cvResize((CvArr)monitorImage, (CvArr)this.undistortedCameraImage, (int)1);
                    Frame frame = this.recorderConverter.convert(this.undistortedCameraImage);
                    Java2DFrameConverter.applyGamma((Frame)frame, (double)0.45454545454545453);
                    this.frameRecorder.record(frame);
                }
                monitorImage = this.getMonitorImage(residual, mask, p);
                this.monitorWindows[3].setCanvasScale(scale);
                this.monitorWindows[3].showImage(this.monitorConverters[3].convert(monitorImage));
                IplImage relativeResidual = this.handMouse.getRelativeResidual();
                IplImage mouseImage = this.handMouse.getResultImage();
                if (relativeResidual != null) {
                    this.monitorWindows[4].setCanvasScale(scale);
                    this.monitorWindows[4].showImage(this.monitorConverters[4].convert(relativeResidual));
                }
                if (mouseImage != null) {
                    this.monitorWindows[5].setCanvasScale(scale);
                    this.monitorWindows[5].showImage(this.monitorConverters[5].convert(mouseImage));
                }
            }
            logger.info(infoLogString);
            RealityAugmentor.VirtualSettings virtualSettings = this.realityAugmentor.getVirtualSettings();
            if (virtualSettings != null && virtualSettings.projectionType == RealityAugmentor.ProjectionType.FIXED) {
                this.doCamera.run();
            } else if (this.trackingSettings.useOpenCL) {
                this.doCamera.run();
                this.doProjector.run();
            } else {
                Future<?> future = this.executor.submit(this.doCamera);
                this.doProjector.run();
                future.get();
            }
            this.lastParameters.set((ImageTransformer.Parameters)this.parameters);
            ProjectorBuffer pb = (ProjectorBuffer)this.projectorBufferRing.get();
            this.realityAugmentor.update(pb.image, pb.roi, this.handMouse.getX(), this.handMouse.getY(), this.handMouse.isClick(), this.lastParameters);
            this.projectorBufferRing.position(this.projectorBufferRing.position() + 1);
            long endTime = System.nanoTime();
            auditTime = handMouseTime - auditTime;
            handMouseTime = updateTime - handMouseTime;
            updateTime = endTime - updateTime;
            endTime -= startTime;
            totalAuditTime += (double)auditTime;
            totalAuditTime2 += (double)(auditTime * auditTime);
            totalHandMouseTime += (double)handMouseTime;
            totalHandMouseTime2 += (double)(handMouseTime * handMouseTime);
            totalUpdateTime += (double)updateTime;
            totalUpdateTime2 += (double)(updateTime * updateTime);
            totalTime += (double)endTime;
            totalTime2 += (double)(endTime * endTime);
        }
        double totalIteratingTime = 0.0;
        int totalIterationCount = 0;
        infoLogString = "\nalignmentStatistics\n===================\npyramidLevel  averageTime (ms)  averageIterations\n-------------------------------------------------\n";
        for (int i8 = 0; i8 < iterationTime.length; ++i8) {
            double meanTime = iterationTime[i8] / (double)iterationCount[i8];
            double sqmeanTime = iterationTime2[i8] / (double)iterationCount[i8];
            double meanIter = (double)iterationCount[i8] / (double)framesCount;
            double sqmeanIter = (double)iterationCount2[i8] / (double)framesCount;
            infoLogString = infoLogString + i8 + "    " + (iterationCount[i8] == 0 ? "0\u00b10" : (float)meanTime / 1000000.0f + "\u00b1" + (float)Math.sqrt(sqmeanTime - meanTime * meanTime) / 1000000.0f) + "    " + (float)meanIter + "\u00b1" + (float)Math.sqrt(sqmeanIter - meanIter * meanIter) + "\n";
            totalIteratingTime += iterationTime[i8];
            totalIterationCount += iterationCount[i8];
        }
        double meanTime = totalIteratingTime / (double)framesCount;
        double sqmeanTime = totalIteratingTime2 / (double)framesCount;
        double meanIter = (double)totalIterationCount / (double)framesCount;
        double sqmeanIter = (double)totalIterationCount2 / (double)framesCount;
        infoLogString = infoLogString + "all  " + (float)meanTime / 1000000.0f + "\u00b1" + (float)Math.sqrt(sqmeanTime - meanTime * meanTime) / 1000000.0f + "    " + (float)meanIter + "\u00b1" + (float)Math.sqrt(sqmeanIter - meanIter * meanIter) + "\n";
        logger.info(infoLogString);
        logger.info("auditTime = " + (float)(totalAuditTime /= (double)framesCount) / 1000000.0f + "\u00b1" + (float)Math.sqrt((totalAuditTime2 /= (double)framesCount) - totalAuditTime * totalAuditTime) / 1000000.0f + " ms");
        logger.info("handMouseTime = " + (float)(totalHandMouseTime /= (double)framesCount) / 1000000.0f + "\u00b1" + (float)Math.sqrt((totalHandMouseTime2 /= (double)framesCount) - totalHandMouseTime * totalHandMouseTime) / 1000000.0f + " ms");
        logger.info("updateTime = " + (float)totalUpdateTime / 1000000.0f + "\u00b1" + (float)Math.sqrt((totalUpdateTime2 /= (double)framesCount) - (totalUpdateTime /= (double)framesCount) * totalUpdateTime) / 1000000.0f + " ms");
        logger.info("totalTime = " + (float)(totalTime /= (double)framesCount) / 1000000.0f + "\u00b1" + (float)Math.sqrt((totalTime2 /= (double)framesCount) - totalTime * totalTime) / 1000000.0f + " ms");
        if (this.aligner instanceof GNImageAlignerCL) {
            ((GNImageAlignerCL)this.aligner).release();
        }
        this.frameGrabber.getDelayedFrame();
        return this.isCancelled() || this.grabbedImage == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object doInBackground() throws Exception {
        block27: {
            try {
                IplImage image;
                this.setProgress(1);
                this.frameGrabber = this.cameraDevice.createFrameGrabber();
                this.frameGrabber.setImageMode(FrameGrabber.ImageMode.COLOR);
                if (this.trackingSettings.useOpenCL) {
                    this.frameGrabber.setPixelFormat(26);
                }
                this.frameGrabber.start();
                this.grabberConverter = new OpenCVFrameConverter.ToIplImage();
                IplImage initImage = image = this.grabberConverter.convert(this.frameGrabber.grab());
                final int initWidth = initImage.width();
                final int initHeight = initImage.height();
                int initChannels = this.trackingSettings.useOpenCL ? 4 : initImage.nChannels();
                final int initDepth = initImage.depth();
                if (initWidth != this.cameraDevice.imageWidth || initHeight != this.cameraDevice.imageHeight) {
                    this.cameraDevice.rescale(initWidth, initHeight);
                }
                if (this.monitorWindows != null) {
                    final double initScale = this.trackingSettings.getMonitorWindowsScale();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = 0; i < TrackingWorker.this.monitorWindows.length; ++i) {
                                TrackingWorker.this.monitorWindows[i].setCanvasSize((int)Math.round((double)initWidth * initScale), (int)Math.round((double)initHeight * initScale));
                                TrackingWorker.this.monitorWindows[i].setTitle(TrackingWorker.this.monitorWindowsTitles[i] + " (" + initWidth + " x " + initHeight + "  " + (initDepth & Integer.MAX_VALUE) + " bpp  gamma = " + TrackingWorker.this.frameGrabber.getGamma() + ") - ProCamTracker");
                            }
                        }
                    });
                    CanvasFrame.tile((CanvasFrame[])this.monitorWindows);
                    CanvasFrame.global = this.monitorWindows[0];
                }
                int minLevel = this.alignerSettings.getPyramidLevelMin();
                this.undistortedCameraImage = IplImage.create((int)(initWidth >> minLevel), (int)(initHeight >> minLevel), (int)initDepth, (int)initChannels);
                this.distortedProjectorImage = IplImage.create((int)this.projectorDevice.imageWidth, (int)this.projectorDevice.imageHeight, (int)8, (int)initChannels);
                Object projectorBufferFactory = new BufferRing.BufferFactory<ProjectorBuffer>(){

                    public ProjectorBuffer create() {
                        return new ProjectorBuffer(TrackingWorker.this.distortedProjectorImage, false);
                    }
                };
                if (this.trackingSettings.useOpenCL) {
                    GLContext shareWith = null;
                    if (this.projectorFrame instanceof GLCanvasFrame) {
                        shareWith = ((GLCanvasFrame)this.projectorFrame).getGLCanvas().getContext();
                    }
                    this.contextCL = new JavaCVCL(shareWith);
                    this.grabbedImageCL = this.contextCL.getCLContext().createImage2d(initWidth, initHeight, new CLImageFormat(this.frameGrabber.getSensorPattern() != -1L ? CLImageFormat.ChannelOrder.R : CLImageFormat.ChannelOrder.RGBA, CLImageFormat.ChannelType.UNORM_INT8), new CLMemory.Mem[0]);
                    this.undistortedCameraImageCL = this.contextCL.getCLContext().createImage2d(this.undistortedCameraImage.width(), this.undistortedCameraImage.height(), new CLImageFormat(CLImageFormat.ChannelOrder.RGBA, CLImageFormat.ChannelType.FLOAT), new CLMemory.Mem[0]);
                    this.cameraDevice.setMapsPyramidLevel(minLevel);
                    this.cameraMapxCL = this.contextCL.writeImage(this.cameraMapxCL, this.cameraDevice.getUndistortMap1(), false);
                    this.cameraMapyCL = this.contextCL.writeImage(this.cameraMapyCL, this.cameraDevice.getUndistortMap2(), false);
                    if (this.projectorFrame != null) {
                        this.projectorMapxCL = this.contextCL.writeImage(this.projectorMapxCL, this.projectorDevice.getDistortMap1(), false);
                        this.projectorMapyCL = this.contextCL.writeImage(this.projectorMapyCL, this.projectorDevice.getDistortMap2(), false);
                        this.distortedProjectorImageCL = this.contextCL.createCLGLImageFrom(this.distortedProjectorImage, new CLMemory.Mem[0]);
                    }
                    projectorBufferFactory = new BufferRing.BufferFactory<ProjectorBuffer>(){

                        public ProjectorBuffer create() {
                            return new ProjectorBuffer(TrackingWorker.this.distortedProjectorImage, true);
                        }
                    };
                }
                this.projectorBufferRing = new BufferRing((BufferRing.BufferFactory)projectorBufferFactory, this.trackingSettings.projectorBufferingSize);
                this.realityAugmentor = new RealityAugmentor(this.realityAugmentorSettings, this.objectFinderSettings, this.markerDetectorSettings, this.virtualBallSettings, (ProjectiveDevice)this.cameraDevice, (ProjectiveDevice)this.projectorDevice, initChannels);
                this.handMouse = new HandMouse(this.handMouseSettings);
                GNImageAligner.Settings s = this.alignerSettings.clone();
                s.setAlphaTikhonov(0.0);
                s.setDeltaMin(0.0);
                s.setLineSearch(new double[]{1.0, 0.5, 0.25, 0.125, 0.0625, 0.03125, 0.015625, 0.0078125});
                s.setThresholdsOutlier(new double[]{0.0});
                s.setThresholdsZero(new double[]{0.0});
                this.reflectanceInitializer = new ReflectanceInitializer(this.cameraDevice, this.projectorDevice, initChannels, s);
                this.projectorInitFloatImages = this.reflectanceInitializer.getProjectorImages();
                this.projectorInitImages = new IplImage[this.projectorInitFloatImages.length];
                this.cameraInitImages = new IplImage[this.projectorInitFloatImages.length];
                this.cameraInitFloatImages = new IplImage[this.projectorInitFloatImages.length];
                for (int i = 0; i < this.projectorInitFloatImages.length; ++i) {
                    this.projectorInitImages[i] = IplImage.createCompatible((IplImage)this.distortedProjectorImage);
                    this.cameraInitImages[i] = IplImage.create((int)initWidth, (int)initHeight, (int)initDepth, (int)initChannels);
                    this.cameraInitFloatImages[i] = IplImage.create((int)this.undistortedCameraImage.width(), (int)this.undistortedCameraImage.height(), (int)32, (int)initChannels);
                    opencv_core.cvConvertScale((CvArr)this.projectorInitFloatImages[i], (CvArr)this.projectorInitImages[i], (double)255.0, (double)0.0);
                    this.projectorDevice.distort(this.projectorInitImages[i], this.distortedProjectorImage);
                    opencv_core.cvCopy((CvArr)this.distortedProjectorImage, (CvArr)this.projectorInitImages[i]);
                }
                this.reflectanceImage = IplImage.createCompatible((IplImage)this.cameraInitFloatImages[0]);
                if (this.trackingSettings.useOpenCL) {
                    this.reflectanceImageCL = this.contextCL.createCLImageFrom(this.reflectanceImage, new CLMemory.Mem[0]);
                }
                if (this.trackingSettings.outputVideoFile != null) {
                    this.frameRecorder = new FFmpegFrameRecorder(this.trackingSettings.outputVideoFile, this.undistortedCameraImage.width(), this.undistortedCameraImage.height());
                    this.frameRecorder.start();
                    this.recorderConverter = new OpenCVFrameConverter.ToIplImage();
                } else {
                    this.frameRecorder = null;
                    this.recorderConverter = null;
                }
                boolean done = false;
                while (!done) {
                    done = this.doTracking();
                    System.gc();
                    Pointer.deallocateReferences();
                }
            }
            catch (Throwable t) {
                if (this.isCancelled()) break block27;
                while (t.getCause() != null) {
                    t = t.getCause();
                }
                logger.log(Level.SEVERE, "Could not perform tracking.", t);
                this.cancel(false);
            }
        }
        try {
            if (this.frameGrabber != null) {
                this.frameGrabber.stop();
                this.frameGrabber.release();
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Could not release FrameGrabber.", ex);
        }
        finally {
            this.frameGrabber = null;
            this.grabberConverter = null;
        }
        try {
            if (this.frameRecorder != null) {
                this.frameRecorder.stop();
                this.frameRecorder.release();
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Could not release FrameRecorder.", ex);
        }
        finally {
            this.frameRecorder = null;
            this.recorderConverter = null;
        }
        if (this.trackingSettings.useOpenCL) {
            this.grabbedImageCL.release();
            this.undistortedCameraImageCL.release();
            this.contextCL.releaseCLGLImage(this.distortedProjectorImageCL);
            this.reflectanceImageCL.release();
            this.cameraMapxCL.release();
            this.cameraMapyCL.release();
            this.projectorMapxCL.release();
            this.projectorMapyCL.release();
            this.distortedProjectorImageCL = null;
            this.undistortedCameraImageCL = null;
            this.grabbedImageCL = null;
            this.reflectanceImageCL = null;
            this.projectorMapyCL = null;
            this.projectorMapxCL = null;
            this.cameraMapyCL = null;
            this.cameraMapxCL = null;
            this.contextCL.release();
            this.contextCL = null;
        }
        this.roiPts = null;
        this.transformer = null;
        this.tempParameters = null;
        this.lastParameters = null;
        this.parameters = null;
        this.aligner = null;
        this.reflectanceInitializer = null;
        this.handMouse = null;
        this.realityAugmentor = null;
        this.distortedProjectorImage = null;
        this.undistortedCameraImage = null;
        this.grabbedImage = null;
        this.projectorInitImages = null;
        this.projectorInitFloatImages = null;
        this.monitorImages = null;
        this.cameraInitFloatImages = null;
        this.cameraInitImages = null;
        this.reflectanceImage = null;
        this.projectorBufferRing.release();
        this.projectorBufferRing = null;
        System.gc();
        Pointer.deallocateReferences();
        return null;
    }

    @Override
    protected synchronized void done() {
        if (this.monitorWindows != null) {
            for (int i = 0; i < this.monitorWindows.length; ++i) {
                if (this.monitorWindows[i] == null) continue;
                this.monitorWindows[i].dispose();
                this.monitorWindows[i] = null;
            }
        }
        if (this.projectorFrame != null) {
            this.projectorFrame.dispose();
            this.projectorFrame = null;
            this.projectorConverter = null;
        }
        System.gc();
        Pointer.deallocateReferences();
    }

    class ProjectorBuffer
    implements BufferRing.ReleasableBuffer {
        public IplImage image;
        public CLImage2d imageCL;
        public CvRect roi;

        public ProjectorBuffer(IplImage template, boolean allocateCL) {
            if (allocateCL) {
                this.image = IplImage.createCompatible((IplImage)template);
                this.imageCL = TrackingWorker.this.contextCL.createCLImageFrom(this.image, new CLMemory.Mem[0]);
            } else {
                this.image = IplImage.createCompatible((IplImage)template);
                this.imageCL = null;
            }
            this.roi = opencv_core.cvRect((int)0, (int)0, (int)0, (int)0);
        }

        public void release() {
            if (this.image != null) {
                this.image.release();
            }
            if (this.imageCL != null) {
                this.imageCL.release();
            }
            if (this.roi != null) {
                this.roi.deallocate();
            }
        }
    }

    public static class Settings
    extends BaseChildSettings {
        int pyramidLevelAudit = 2;
        int pyramidLevelHandMouse = 2;
        int iteratingTimeMax = 50;
        double outlierRatioMax = 0.25;
        double monitorWindowsScale = 0.25;
        File outputVideoFile = null;
        boolean useOpenCL = false;
        int projectorBufferingSize = 4;
        int proCamPhaseShift = 17;

        public int getPyramidLevelAudit() {
            return this.pyramidLevelAudit;
        }

        public void setPyramidLevelAudit(int pyramidLevelAudit) {
            this.pyramidLevelAudit = pyramidLevelAudit;
        }

        public int getPyramidLevelHandMouse() {
            return this.pyramidLevelHandMouse;
        }

        public void setPyramidLevelHandMouse(int pyramidLevelHandMouse) {
            this.pyramidLevelHandMouse = pyramidLevelHandMouse;
        }

        public int getIteratingTimeMax() {
            return this.iteratingTimeMax;
        }

        public void setIteratingTimeMax(int iteratingTimeMax) {
            this.iteratingTimeMax = iteratingTimeMax;
        }

        public double getOutlierRatioMax() {
            return this.outlierRatioMax;
        }

        public void setOutlierRatioMax(double outlierRatioMax) {
            this.outlierRatioMax = outlierRatioMax;
        }

        public double getMonitorWindowsScale() {
            return this.monitorWindowsScale;
        }

        public void setMonitorWindowsScale(double monitorWindowsScale) {
            this.monitorWindowsScale = monitorWindowsScale;
        }

        public File getOutputVideoFile() {
            return this.outputVideoFile;
        }

        public void setOutputVideoFile(File outputVideoFile) {
            this.outputVideoFile = outputVideoFile;
        }

        public String getOutputVideoFilename() {
            return this.outputVideoFile == null ? "" : this.outputVideoFile.getPath();
        }

        public void setOutputVideoFilename(String outputVideoFilename) {
            this.outputVideoFile = outputVideoFilename == null || outputVideoFilename.length() == 0 ? null : new File(outputVideoFilename);
        }

        public boolean isUseOpenCL() {
            return this.useOpenCL;
        }

        public void setUseOpenCL(boolean useOpenCL) {
            this.useOpenCL = useOpenCL;
        }

        public int getProjectorBufferingSize() {
            return this.projectorBufferingSize;
        }

        public void setProjectorBufferingSize(int projectorBufferingSize) {
            this.projectorBufferingSize = projectorBufferingSize;
        }

        public int getProCamPhaseShift() {
            return this.proCamPhaseShift;
        }

        public void setProCamPhaseShift(int proCamPhaseShift) {
            this.proCamPhaseShift = proCamPhaseShift;
        }
    }
}

