// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.sentencepiece;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.sentencepiece.global.sentencepiece.*;


@Namespace("sentencepiece") @NoOffset @Properties(inherit = org.bytedeco.sentencepiece.presets.sentencepiece.class)
public class SentencePieceProcessor extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SentencePieceProcessor(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public SentencePieceProcessor(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public SentencePieceProcessor position(long position) {
        return (SentencePieceProcessor)super.position(position);
    }
    @Override public SentencePieceProcessor getPointer(long i) {
        return new SentencePieceProcessor((Pointer)this).offsetAddress(i);
    }

  public SentencePieceProcessor() { super((Pointer)null); allocate(); }
  private native void allocate();

  // Loads model from `filename`.
  // Returns false if `filename` cannot be loaded.
  public native @ByVal Status Load(@StdString String filename);

  // Loads model from `filename`.
  // Crash if `filename` cannot be loaded.
  public native void LoadOrDie(@StdString String filename);

  // Loads model from `model_proto`.
  // `model_proto` is copied.
  public native @ByVal Status Load(@Const @ByRef ModelProto model_proto);

  // Loads model from `model_proto`.
  // `model_proto` is moved.

  // Loads model from `serialized`, which is a string-serialized model proto.
  // Useful to load the model from a platform independent blob object.
  public native @ByVal Status LoadFromSerializedProto(@StdString String serialized);

  // Returns the status. Encode/Decode methods are valid when status is OK.
  public native @ByVal Status status();

  // Sets encode extra_option sequence.
  public native @ByVal Status SetEncodeExtraOptions(@StdString String extra_option);

  // Sets decode extra_option sequence.
  public native @ByVal Status SetDecodeExtraOptions(@StdString String extra_option);

  //////////////////////////////////////////////////////////////
  // Vocabulary restriction.
  // Background:
  // https://github.com/rsennrich/subword-nmt#best-practice-advice-for-byte-pair-encoding-in-nmt

  // Restricts the vocabulary set.
  // The input sentences are encoded into the tokens in `valid_vocab`.
  

  // Reverts the vocabulary restriction.
  public native @ByVal Status ResetVocabulary();

  // Loads the valid vocabulary set from `filename` in TSV format.
  // Format:  <token> <tab> <freq>.
  // Any token with frequency < threshold will be treated as OOV.
  public native @ByVal Status LoadVocabulary(@StdString String filename,
                                        int threshold);

  //////////////////////////////////////////////////////////////
  // Simple Encode and Decode API.
  //
  // Given a UTF8 input, encodes it into a sequence of sentence pieces.
  public native @ByVal Status Encode(@StdString String input,
                                StringVector pieces);

  // Given a UTF8 input, encodes it into a sequence of ids.
  public native @ByVal Status Encode(@StdString String input,
                                IntVector ids);

  // Given a sequence of pieces, decodes it into a detokenized output.
  public native @ByVal Status Decode(@Const @ByRef StringVector pieces,
                                @StdString @Cast({"char*", "std::string*"}) BytePointer detokenized);

  // Given a sequence of pieces, decodes it into a detokenized output.

  // Given a sequence of ids, decodes it into a detokenized output.
  public native @ByVal Status Decode(@Const @ByRef IntVector ids,
                                @StdString @Cast({"char*", "std::string*"}) BytePointer detokenized);

  //////////////////////////////////////////////////////////////
  // NBest API.
  //
  // Same as Encode, but returns nbest results.
  public native @ByVal Status NBestEncode(
        @StdString String input, int nbest_size,
        @StdVector StringVector pieces);

  // Same as Encode, but returns nbest results.
  public native @ByVal Status NBestEncode(@StdString String input, int nbest_size,
                                     @StdVector IntVector ids);

  //////////////////////////////////////////////////////////////
  // Sampling API.
  //
  // Unigram and BPE support sampling mode.
  // - Unigram (--model_type=unigram):
  // `nbest_size`: When `nbest_size` is positive value, approximately samples
  // one segmentation from nbest candidates. When `nbest_size` is negative
  // value, samples one segmentation from the hypotheses (Lattice) according to
  // the generation probabilities using forward-filtering and backward-sampling
  // algorithm.
  // `alpha`: Smoothing parameter (inverse temperature). The best segmentation
  // (Viterbi segmentation) is more likely sampled when setting larger alpha.
  // When alpha is 0.0, one segmentation is uniformly sampled from the nbest or
  // lattice. `nbest_size` and `alpha` correspond to parameters `l` and `alpha`
  // in https://arxiv.org/abs/1804.10959  (nbest_size < 0 means l = infinity)
  //
  // - BPE (--model_type=bpe):
  // `alpha`: The dropout probability `p` of bpe merge operations in
  // https://arxiv.org/abs/1910.13267 Nbest-based sampling is not supported so
  // nbest_size parameter is ignored in BPE.
  public native @ByVal Status SampleEncode(@StdString String input, int nbest_size,
                                      float alpha,
                                      StringVector pieces);

  // Same as above, but returns a sequence of ids.
  public native @ByVal Status SampleEncode(@StdString String input, int nbest_size,
                                      float alpha, IntVector ids);

  //////////////////////////////////////////////////////////////
  // SampleEncodeAndScore API.
  //
  // Sample `samples` many tokenisations from the segmentation lattice.
  // These methods are only available in model_type=unigram.
  //
  // `alpha`: smoothing parameter (inverse temperature). The same as `alpha` in
  // `Sample` method.
  // 'wor`: If `wor` is true, the samples are taken without replacement, and the
  // scores are the inclusion probabilities of the elements in the sample;
  // otherwise the samples are taken with replacement and the scores are the
  // log-probs of sample elements
  // `include_best`: If `include_best` is true, the best tokenisation is always
  // included in the sample, and the remaining elements are sampled excluding
  // the best.
  public native @ByVal Status SampleEncodeAndScore(
        @StdString String input, int num_samples, float alpha, @Cast("bool") boolean wor,
        @Cast("bool") boolean include_best,
        StringVectorFloatPairVector pieces);

  // Same as above, but returns a sequence of ids.
  public native @ByVal Status SampleEncodeAndScore(
        @StdString String input, int num_samples, float alpha, @Cast("bool") boolean wor,
        @Cast("bool") boolean include_best,
        IntVectorFloatPairVector ids);

  //////////////////////////////////////////////////////////////
  // Entropy API.
  //
  // This only available in model_type=unigram.
  // Calculate entropy of possible tokenisations
  public native @ByVal Status CalculateEntropy(@StdString String input, float alpha,
                                          FloatPointer entropy);
  public native @ByVal Status CalculateEntropy(@StdString String input, float alpha,
                                          FloatBuffer entropy);
  public native @ByVal Status CalculateEntropy(@StdString String input, float alpha,
                                          float[] entropy);

  //////////////////////////////////////////////////////////////
  // Advanced API returning SentencePieceText, which manages
  // utf8-byte alignments between user-input/detokenized text
  // and internal sentencepiece sequence.
  //
  // Given a UTF8 input, encodes it into SentencePieceText.
  //
  // When using these APIs, sentencepiece.pb.h header files must be included.
  // We can also use ImutableSentencePieceText as follows.
  //
  // ImmutableSentencePieceText spt;
  // Encode("hello", spt.mutable_proto()).IgnoreError();
  // std::cout << spt.pieces_size() << std::endl;
  public native @ByVal Status Encode(@StdString String input,
                                SentencePieceText spt);

  public native @ByVal Status NBestEncode(@StdString String input, int nbest_size,
                                     NBestSentencePieceText nbest_spt);

  public native @ByVal Status SampleEncode(@StdString String input, int nbest_size,
                                      float alpha, SentencePieceText spt);

  public native @ByVal Status SampleEncodeAndScore(
        @StdString String input, int num_samples, float alpha, @Cast("bool") boolean wor,
        @Cast("bool") boolean include_best, NBestSentencePieceText samples_spt);

  // DEPRECATED: Remove this API and use std::vector<std::string_view>
  public native @ByVal Status Decode(@Const @ByRef StringVector pieces,
                                SentencePieceText spt);

  public native @ByVal Status Decode(@Const @ByRef IntVector ids,
                                SentencePieceText spt);
// #ifdef SWIG
// #define SPP_SWIG_CHECK_AND_THROW
//   if (!status.ok()) throw status;
// #else
// #define SPP_SWIG_CHECK_AND_THROW
//   if (!status.ok()) {
//   }
// #endif  // SWIG

// #define DEFINE_SPP_DIRECT_FUNC_IMPL(FuncName, OutType, ...)
//   OutType output;
//   const auto status = FuncName(__VA_ARGS__, &output);
//   SPP_SWIG_CHECK_AND_THROW;
//   return output;

// #define DEFINE_SPP_SERIALIZED_PROTO_IMPL(FuncName, OutType, ...)
//   OutType output;
//   const auto status = FuncName(__VA_ARGS__, output.mutable_proto());
//   SPP_SWIG_CHECK_AND_THROW;
//   return output.SerializeAsString();

// #define DEFINE_SPP_IMMUTABLE_PROTO_IMPL(FuncName, OutType, ...)
//   OutType output;
//   const auto status = FuncName(__VA_ARGS__, output.mutable_proto());
//   SPP_SWIG_CHECK_AND_THROW;
//   return output;

  //////////////////////////////////////////////////////////////
  // Handy methods that return the result directly.
  // These functions ignore internal errors.
  public native @ByVal StringVector EncodeAsPieces(
        @StdString String input);

  public native @ByVal IntVector EncodeAsIds(@StdString String input);

  public native @StdVector StringVector NBestEncodeAsPieces(
        @StdString String input, int nbest_size);

  public native @StdVector IntVector NBestEncodeAsIds(
        @StdString String input, int nbest_size);

  public native @ByVal StringVector SampleEncodeAsPieces(@StdString String input,
                                                          int nbest_size,
                                                          float alpha);

  public native @ByVal IntVector SampleEncodeAsIds(@StdString String input,
                                               int nbest_size,
                                               float alpha);

  public native @ByVal StringVectorFloatPairVector SampleEncodeAndScoreAsPieces(@StdString String input, int num_samples,
                                 float alpha, @Cast("bool") boolean wor, @Cast("bool") boolean include_best);

  public native @ByVal IntVectorFloatPairVector SampleEncodeAndScoreAsIds(@StdString String input, int num_samples,
                              float alpha, @Cast("bool") boolean wor, @Cast("bool") boolean include_best);

  // DEPRECATED: Remove this API and use std::vector<std::string_view>
  public native @StdString String DecodePieces(
        @Const @ByRef StringVector pieces);

  public native @StdString String DecodeIds(@Const @ByRef IntVector ids);

  public native float CalculateEntropy(@StdString String text, float alpha);

  //////////////////////////////////////////////////////////////
  // SerializedProto API. (DEPRECATED). Use ImmutableProto API.
  // They are used in Python interface. Returns serialized proto.
  // In python module, we can get access to the full Proto after
  // deserialzing the returned byte sequence.
  public native @StdString String EncodeAsSerializedProto(@StdString String input);

  public native @StdString String SampleEncodeAsSerializedProto(@StdString String input,
                                                      int nbest_size,
                                                      float alpha);

  public native @StdString String NBestEncodeAsSerializedProto(@StdString String input,
                                                     int nbest_size);

  public native @StdString String SampleEncodeAndScoreAsSerializedProto(
        @StdString String input, int num_samples, float alpha, @Cast("bool") boolean wor,
        @Cast("bool") boolean include_best);

  // TODO(taku): Remove this API and use std::vector<std::string_view>
  public native @StdString String DecodePiecesAsSerializedProto(
        @Const @ByRef StringVector pieces);

  public native @StdString String DecodeIdsAsSerializedProto(
        @Const @ByRef IntVector ids);

  //////////////////////////////////////////////////////////////
  // ImmutableProto API.
  public native @ByVal ImmutableSentencePieceText EncodeAsImmutableProto(
        @StdString String input);

  public native @ByVal ImmutableSentencePieceText SampleEncodeAsImmutableProto(
        @StdString String input, int nbest_size, float alpha);

  public native @ByVal ImmutableNBestSentencePieceText NBestEncodeAsImmutableProto(
        @StdString String input, int nbest_size);

  public native @ByVal ImmutableNBestSentencePieceText SampleEncodeAndScoreAsImmutableProto(
        @StdString String input, int num_samples, float alpha, @Cast("bool") boolean wor,
        @Cast("bool") boolean include_best);

  // TODO(taku): Remove this API and use std::vector<std::string_view>
  public native @ByVal ImmutableSentencePieceText DecodePiecesAsImmutableProto(
        @Const @ByRef StringVector pieces);

  public native @ByVal ImmutableSentencePieceText DecodeIdsAsImmutableProto(
        @Const @ByRef IntVector ids);

// #undef DEFINE_SPP_DIRECT_FUNC_IMPL
// #undef DEFINE_SPP_SERIALIZED_PROTO_IMPL
// #undef DEFINE_SPP_IMMUTABLE_PROTO_IMPL

  //////////////////////////////////////////////////////////////
  // Normalization methods.

  // Normalize `input`.
  public native @ByVal Status Normalize(@StdString String input,
                                   @StdString @Cast({"char*", "std::string*"}) BytePointer normalized);

  // Normalize `input`. Stores the utf8-byte offset from
  // the normalized string to the original input.
  public native @ByVal Status Normalize(@StdString String input,
                                   @StdString @Cast({"char*", "std::string*"}) BytePointer normalized,
                                   @Cast("size_t*") @StdVector SizeTPointer norm_to_orig);

  public native @StdString String Normalize(@StdString String input);

  //////////////////////////////////////////////////////////////
  // Vocabulary management methods.
  //
  // Returns the size of sentence pieces, which is the same as
  // the size of vocabulary for NMT.
  public native int GetPieceSize();

  // Returns the vocab id of `piece`.
  // Returns UNK(0) if `piece` is unknown.
  public native int PieceToId(@StdString String piece);

  // Returns the string representation of vocab with `id`.
  public native @StdString String IdToPiece(int id);

  // Returns the score of `id`.
  // Usually score is an emission log probability of unigram language
  // model.
  public native float GetScore(int id);

  // Returns true if `id` is unknown symbol.
  public native @Cast("bool") boolean IsUnknown(int id);

  // Returns true if `id` is control symbol.
  public native @Cast("bool") boolean IsControl(int id);

  // Returns true if `id` is unused symbol.
  public native @Cast("bool") boolean IsUnused(int id);

  // Returns true if `id` is byte symbol.
  public native @Cast("bool") boolean IsByte(int id);

  // Returns the reserved id.
  // Returns -1 if not defined.

  // Returns unknown (<unk>) id.
  public native int unk_id();

  // Returns BOS (<s>) id.
  public native int bos_id();

  // Returns EOS (</s>) id.
  public native int eos_id();

  // Returns PAD (<pad>) id.
  public native int pad_id();

  //////////////////////////////////////////////////////////////
  // Model management.
  //
  // Allows injection of a mock model instance. `model` is moved.

  // Allows injection of a normalizer instance. `normalizer` is moved.

  // Returns immutable model proto. Useful to obtain extended
  // or experimental parameters encoded in model_proto.
  public native @Const @ByRef ModelProto model_proto();

  // returns immutable model proto as std::string.
  // Useful to save the state of this instance via Python's pickle object.
  public native @StdString String serialized_model_proto();

  // Returns mutable normalizer_spec.
  // Updating the intenral normalization during the encoding/decoding are not
  // recommended and may result in unexpected behavior. Use at your own risk.
  public native NormalizerSpec mutable_normalizer_spec();
}
