// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.sentencepiece;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.sentencepiece.global.sentencepiece.*;


@Namespace("sentencepiece") @Properties(inherit = org.bytedeco.sentencepiece.presets.sentencepiece.class)
public class SentencePieceTrainer extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SentencePieceTrainer(Pointer p) { super(p); }

  // Trains SentencePiece model with `trainer_spec`.
  // Default `normalizer_spec` is used.
  // When `sentence_iterator` is passed, load sentences from the iterator.
  public static native @ByVal Status Train(@Const @ByRef TrainerSpec trainer_spec,
                              SentenceIterator sentence_iterator/*=nullptr*/,
                              @StdString @Cast({"char*", "std::string*"}) BytePointer serialized_model_proto/*=nullptr*/);
  public static native @ByVal Status Train(@Const @ByRef TrainerSpec trainer_spec);

  // Trains SentencePiece model with `trainer_spec` and
  // `normalizer_spec`.
  // When `sentence_iterator` is passed, load sentences from the iterator.
  public static native @ByVal Status Train(@Const @ByRef TrainerSpec trainer_spec,
                              @Const @ByRef NormalizerSpec normalizer_spec,
                              SentenceIterator sentence_iterator/*=nullptr*/,
                              @StdString @Cast({"char*", "std::string*"}) BytePointer serialized_model_proto/*=nullptr*/);
  public static native @ByVal Status Train(@Const @ByRef TrainerSpec trainer_spec,
                              @Const @ByRef NormalizerSpec normalizer_spec);

  // Trains SentencePiece model with `trainer_spec`, `normalizer_spec`
  // and `denormalizer_spec`.
  // When `sentence_iterator` is passed, load sentences from the iterator.
  public static native @ByVal Status Train(@Const @ByRef TrainerSpec trainer_spec,
                              @Const @ByRef NormalizerSpec normalizer_spec,
                              @Const @ByRef NormalizerSpec denormalizer_spec,
                              SentenceIterator sentence_iterator/*=nullptr*/,
                              @StdString @Cast({"char*", "std::string*"}) BytePointer serialized_model_proto/*=nullptr*/);
  public static native @ByVal Status Train(@Const @ByRef TrainerSpec trainer_spec,
                              @Const @ByRef NormalizerSpec normalizer_spec,
                              @Const @ByRef NormalizerSpec denormalizer_spec);
  // Trains SentencePiece model with command-line string in `args`,
  // e.g.,
  // '--input=data --model_prefix=m --vocab_size=8192 model_type=unigram'
  // When `sentence_iterator` is passed, load sentences from the iterator.
  public static native @ByVal Status Train(@StdString String args,
                              SentenceIterator sentence_iterator/*=nullptr*/,
                              @StdString @Cast({"char*", "std::string*"}) BytePointer serialized_model_proto/*=nullptr*/);
  public static native @ByVal Status Train(@StdString String args);

  // Trains SentencePiece model with mapin `kwargs`.
  // e.g., {{"input", "data"}, {"model_prefix, "m"}, {"vocab_size", "8192"}...}
  public static native @ByVal Status Train(
        @Const @ByRef StringStringMap kwargs,
        SentenceIterator sentence_iterator/*=nullptr*/,
        @StdString @Cast({"char*", "std::string*"}) BytePointer serialized_model_proto/*=nullptr*/);
  public static native @ByVal Status Train(
        @Const @ByRef StringStringMap kwargs);

  // The same as above, but passes the list of sentences.
  public static native @ByVal Status Train(@StdString String args,
                              @Const @ByRef StringVector sentences,
                              @StdString @Cast({"char*", "std::string*"}) BytePointer serialized_model_proto/*=nullptr*/);
  public static native @ByVal Status Train(@StdString String args,
                              @Const @ByRef StringVector sentences);

  // The same as above, but passes the list of sentences.
  public static native @ByVal Status Train(
        @Const @ByRef StringStringMap kwargs,
        @Const @ByRef StringVector sentences,
        @StdString @Cast({"char*", "std::string*"}) BytePointer serialized_model_proto/*=nullptr*/);
  public static native @ByVal Status Train(
        @Const @ByRef StringStringMap kwargs,
        @Const @ByRef StringVector sentences);

  // Handy function to make a normalizer spec from the pre-compiled
  // normalization name. Do not use this method in production as it crashes
  // When `name` is invalid. Useful for unittesting.
  

  // Populates necessary fields (precompiled_charmap) from
  // `NormalizerSpec::name` or `NormalizerSpec::normalization_rule_tsv`.
  public static native @ByVal Status PopulateNormalizerSpec(NormalizerSpec normalizer_spec,
                                               @Cast("bool") boolean is_denormalizer/*=false*/);
  public static native @ByVal Status PopulateNormalizerSpec(NormalizerSpec normalizer_spec);

  // Overrides `trainer_spec`, `normalizer_spec`, `denormalizer_spec` with the
  // std::unordered_map in `kargs`.
  public static native @ByVal Status MergeSpecsFromArgs(
        @Const @ByRef StringStringMap kwargs,
        TrainerSpec trainer_spec, NormalizerSpec normalizer_spec,
        NormalizerSpec denormalizer_spec);

  // Overrides `trainer_spec`, `normalizer_spec`, `denormalizer_spec` with the
  // command line flags in `args`.
  public static native @ByVal Status MergeSpecsFromArgs(@StdString String args,
                                           TrainerSpec trainer_spec,
                                           NormalizerSpec normalizer_spec,
                                           NormalizerSpec denormalizer_spec);

  // Injects global pre-tokenizer that are applied in training time.
  // Pretokenizer is only used for extracting pieces.
  // TODO(taku): It would be better to inject per `trainer_spec`.
  public static native @ByVal Status SetPretokenizerForTraining(
        @Const PretokenizerForTrainingInterface pretokenizer);

  // Returns the current pretokenizer. if no pretokenizer is defined, returns
  // nullptr.
  public static native @Const PretokenizerForTrainingInterface GetPretokenizerForTraining();

  // Helper function to set `field_name=value` in `message`.
  // When `field_name` is repeated, multiple values can be passed
  // with comma-separated values. `field_name` must not be a nested message.
  // The body of these functions are automatically generated with
  // data/gen_spec_parser.pl
  public static native @ByVal Status SetProtoField(@StdString String name,
                                      @StdString String value,
                                      TrainerSpec message);

  public static native @ByVal Status SetProtoField(@StdString String name,
                                      @StdString String value,
                                      NormalizerSpec message);

  // Populates model type from string representation, e.g., "bpe".
  // Supported model: "unigram", "bpe", "word", "char".
  public static native @ByVal Status PopulateModelTypeFromString(@StdString String type,
                                                    TrainerSpec trainer_spec);
}
