// Targeted by JavaCPP version 1.5.1: DO NOT EDIT THIS FILE

package org.bytedeco.skia.global;

import org.bytedeco.skia.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

public class Skia extends org.bytedeco.skia.presets.Skia {
    static { Loader.load(); }

// Parsed from sk_types.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_types_DEFINED
// #define sk_types_DEFINED

// #include <stdint.h>
// #include <stddef.h>

// #ifdef __cplusplus
//     #define SK_C_PLUS_PLUS_BEGIN_GUARD    extern "C" {
//     #define SK_C_PLUS_PLUS_END_GUARD      }
// #else
//     #include <stdbool.h>
//     #define SK_C_PLUS_PLUS_BEGIN_GUARD
//     #define SK_C_PLUS_PLUS_END_GUARD
// #endif

// #if !defined(SK_C_API)
//     #if defined(SKIA_C_DLL)
//         #if defined(_MSC_VER)
//             #if SKIA_IMPLEMENTATION
//                 #define SK_C_API __declspec(dllexport)
//             #else
//                 #define SK_C_API __declspec(dllimport)
//             #endif
//         #else
//             #define SK_C_API __attribute__((visibility("default")))
//         #endif
//     #else
//         #define SK_C_API
//     #endif
// #endif

///////////////////////////////////////////////////////////////////////////////////////

/* This macro assumes all arguments are >=0 and <=255. */
// #define sk_color_set_argb(a, r, g, b)   (((a) << 24) | ((r) << 16) | ((g) << 8) | (b))
// #define sk_color_get_a(c)               (((c) >> 24) & 0xFF)
// #define sk_color_get_r(c)               (((c) >> 16) & 0xFF)
// #define sk_color_get_g(c)               (((c) >>  8) & 0xFF)
// #define sk_color_get_b(c)               (((c) >>  0) & 0xFF)

/** enum sk_colortype_t */
public static final int
    UNKNOWN_SK_COLORTYPE = 0,
    ALPHA_8_SK_COLORTYPE = 1,
    RGB_565_SK_COLORTYPE = 2,
    ARGB_4444_SK_COLORTYPE = 3,
    RGBA_8888_SK_COLORTYPE = 4,
    RGB_888X_SK_COLORTYPE = 5,
    BGRA_8888_SK_COLORTYPE = 6,
    RGBA_1010102_SK_COLORTYPE = 7,
    RGB_101010X_SK_COLORTYPE = 8,
    GRAY_8_SK_COLORTYPE = 9,
    RGBA_F16_SK_COLORTYPE = 10;

/** enum sk_alphatype_t */
public static final int
    UNKNOWN_SK_ALPHATYPE = 0,
    OPAQUE_SK_ALPHATYPE = 1,
    PREMUL_SK_ALPHATYPE = 2,
    UNPREMUL_SK_ALPHATYPE = 3;

/** enum sk_pixelgeometry_t */
public static final int
    UNKNOWN_SK_PIXELGEOMETRY = 0,
    RGB_H_SK_PIXELGEOMETRY = 1,
    BGR_H_SK_PIXELGEOMETRY = 2,
    RGB_V_SK_PIXELGEOMETRY = 3,
    BGR_V_SK_PIXELGEOMETRY = 4;

/** enum sk_surfaceprops_flags_t */
public static final int
    USE_DEVICE_INDEPENDENT_FONTS_SK_SURFACE_PROPS_FLAGS = 1 << 0;
// Targeting ../sk_surfaceprops_t.java


// Targeting ../sk_point_t.java


// Targeting ../sk_irect_t.java


// Targeting ../sk_rect_t.java


// Targeting ../sk_matrix_t.java


// Targeting ../sk_matrix44_t.java



/** enum sk_matrix44_type_mask_t */
public static final int
    IDENTITY_SK_MATRIX44_TYPE_MASK = 0,
    TRANSLATE_SK_MATRIX44_TYPE_MASK = 0x01,
    SCALE_SK_MATRIX44_TYPE_MASK = 0x02,
    AFFINE_SK_MATRIX44_TYPE_MASK = 0x04,
    PERSPECTIVE_SK_MATRIX44_TYPE_MASK = 0x08;
// Targeting ../sk_canvas_t.java


// Targeting ../sk_nodraw_canvas_t.java


// Targeting ../sk_nway_canvas_t.java


// Targeting ../sk_overdraw_canvas_t.java


// Targeting ../sk_data_t.java


// Targeting ../sk_image_t.java


// Targeting ../sk_maskfilter_t.java


// Targeting ../sk_paint_t.java


// Targeting ../sk_path_t.java


// Targeting ../sk_picture_t.java


// Targeting ../sk_picture_recorder_t.java


// Targeting ../sk_shader_t.java


// Targeting ../sk_surface_t.java


// Targeting ../sk_region_t.java



/** enum sk_blendmode_t */
public static final int
    CLEAR_SK_BLENDMODE = 0,
    SRC_SK_BLENDMODE = 1,
    DST_SK_BLENDMODE = 2,
    SRCOVER_SK_BLENDMODE = 3,
    DSTOVER_SK_BLENDMODE = 4,
    SRCIN_SK_BLENDMODE = 5,
    DSTIN_SK_BLENDMODE = 6,
    SRCOUT_SK_BLENDMODE = 7,
    DSTOUT_SK_BLENDMODE = 8,
    SRCATOP_SK_BLENDMODE = 9,
    DSTATOP_SK_BLENDMODE = 10,
    XOR_SK_BLENDMODE = 11,
    PLUS_SK_BLENDMODE = 12,
    MODULATE_SK_BLENDMODE = 13,
    SCREEN_SK_BLENDMODE = 14,
    OVERLAY_SK_BLENDMODE = 15,
    DARKEN_SK_BLENDMODE = 16,
    LIGHTEN_SK_BLENDMODE = 17,
    COLORDODGE_SK_BLENDMODE = 18,
    COLORBURN_SK_BLENDMODE = 19,
    HARDLIGHT_SK_BLENDMODE = 20,
    SOFTLIGHT_SK_BLENDMODE = 21,
    DIFFERENCE_SK_BLENDMODE = 22,
    EXCLUSION_SK_BLENDMODE = 23,
    MULTIPLY_SK_BLENDMODE = 24,
    HUE_SK_BLENDMODE = 25,
    SATURATION_SK_BLENDMODE = 26,
    COLOR_SK_BLENDMODE = 27,
    LUMINOSITY_SK_BLENDMODE = 28;
// Targeting ../sk_point3_t.java


// Targeting ../sk_ipoint_t.java


// Targeting ../sk_size_t.java


// Targeting ../sk_isize_t.java


// Targeting ../sk_fontmetrics_t.java



// Flags for fFlags member of sk_fontmetrics_t
public static final long FONTMETRICS_FLAGS_UNDERLINE_THICKNESS_IS_VALID = (1L << 0);
public static final long FONTMETRICS_FLAGS_UNDERLINE_POSITION_IS_VALID = (1L << 1);
// Targeting ../sk_string_t.java


// Targeting ../sk_bitmap_t.java


// Targeting ../sk_pixmap_t.java


// Targeting ../sk_colorfilter_t.java


// Targeting ../sk_imagefilter_t.java


// Targeting ../sk_imagefilter_croprect_t.java


// Targeting ../sk_typeface_t.java


// Targeting ../sk_fontmgr_t.java


// Targeting ../sk_fontstyle_t.java


// Targeting ../sk_fontstyleset_t.java


// Targeting ../sk_codec_t.java


// Targeting ../sk_colorspace_t.java


// Targeting ../sk_stream_t.java


// Targeting ../sk_stream_filestream_t.java


// Targeting ../sk_stream_asset_t.java


// Targeting ../sk_stream_memorystream_t.java


// Targeting ../sk_stream_streamrewindable_t.java


// Targeting ../sk_wstream_t.java


// Targeting ../sk_wstream_filestream_t.java


// Targeting ../sk_wstream_dynamicmemorystream_t.java


// Targeting ../sk_document_t.java



/** enum sk_encoding_t */
public static final int
    UTF8_ENCODING = 0,
    UTF16_ENCODING = 1,
    UTF32_ENCODING = 2;

/** enum sk_point_mode_t */
public static final int
    POINTS_SK_POINT_MODE = 0,
    LINES_SK_POINT_MODE = 1,
    POLYGON_SK_POINT_MODE = 2;

/** enum sk_text_align_t */
public static final int
    LEFT_SK_TEXT_ALIGN = 0,
    CENTER_SK_TEXT_ALIGN = 1,
    RIGHT_SK_TEXT_ALIGN = 2;

/** enum sk_text_encoding_t */
public static final int
    UTF8_SK_TEXT_ENCODING = 0,
    UTF16_SK_TEXT_ENCODING = 1,
    UTF32_SK_TEXT_ENCODING = 2,
    GLYPH_ID_SK_TEXT_ENCODING = 3;

/** enum sk_path_filltype_t */
public static final int
    WINDING_SK_PATH_FILLTYPE = 0,
    EVENODD_SK_PATH_FILLTYPE = 1,
    INVERSE_WINDING_SK_PATH_FILLTYPE = 2,
    INVERSE_EVENODD_SK_PATH_FILLTYPE = 3;

/** enum sk_font_style_slant_t */
public static final int
    UPRIGHT_SK_FONT_STYLE_SLANT = 0,
    ITALIC_SK_FONT_STYLE_SLANT  = 1,
    OBLIQUE_SK_FONT_STYLE_SLANT = 2;

/** enum sk_filter_quality_t */
public static final int
    NONE_SK_FILTER_QUALITY = 0,
    LOW_SK_FILTER_QUALITY = 1,
    MEDIUM_SK_FILTER_QUALITY = 2,
    HIGH_SK_FILTER_QUALITY = 3;

/** enum sk_crop_rect_flags_t */
public static final int
    HAS_LEFT_SK_CROP_RECT_FLAG   = 0x01,
    HAS_TOP_SK_CROP_RECT_FLAG    = 0x02,
    HAS_WIDTH_SK_CROP_RECT_FLAG  = 0x04,
    HAS_HEIGHT_SK_CROP_RECT_FLAG = 0x08,
    HAS_ALL_SK_CROP_RECT_FLAG    = 0x0F;

/** enum sk_drop_shadow_image_filter_shadow_mode_t */
public static final int
    DRAW_SHADOW_AND_FOREGROUND_SK_DROP_SHADOW_IMAGE_FILTER_SHADOW_MODE = 0,
    DRAW_SHADOW_ONLY_SK_DROP_SHADOW_IMAGE_FILTER_SHADOW_MODE = 1;

/** enum sk_displacement_map_effect_channel_selector_type_t */
public static final int
    UNKNOWN_SK_DISPLACEMENT_MAP_EFFECT_CHANNEL_SELECTOR_TYPE = 0,
    R_SK_DISPLACEMENT_MAP_EFFECT_CHANNEL_SELECTOR_TYPE = 1,
    G_SK_DISPLACEMENT_MAP_EFFECT_CHANNEL_SELECTOR_TYPE = 2,
    B_SK_DISPLACEMENT_MAP_EFFECT_CHANNEL_SELECTOR_TYPE = 3,
    A_SK_DISPLACEMENT_MAP_EFFECT_CHANNEL_SELECTOR_TYPE = 4;

/** enum sk_matrix_convolution_tilemode_t */
public static final int
    CLAMP_SK_MATRIX_CONVOLUTION_TILEMODE = 0,
    REPEAT_SK_MATRIX_CONVOLUTION_TILEMODE = 1,
    CLAMP_TO_BLACK_SK_MATRIX_CONVOLUTION_TILEMODE = 2;

/**
    The logical operations that can be performed when combining two regions.
*/
/** enum sk_region_op_t */
public static final int
    /** subtract the op region from the first region */
    DIFFERENCE_SK_REGION_OP = 0,
    /** intersect the two regions */
    INTERSECT_SK_REGION_OP = 1,
    /** union (inclusive-or) the two regions */
    UNION_SK_REGION_OP = 2,
    /** exclusive-or the two regions */
    XOR_SK_REGION_OP = 3,
    /** subtract the first region from the op region */
    REVERSE_DIFFERENCE_SK_REGION_OP = 4,
    /** replace the dst region with the op region */
    REPLACE_SK_REGION_OP = 5;

/** enum sk_clipop_t */
public static final int
    DIFFERENCE_SK_CLIPOP = 0,
    INTERSECT_SK_CLIPOP = 1;

/**
 *  Enum describing format of encoded data.
 */
/** enum sk_encoded_image_format_t */
public static final int
    BMP_SK_ENCODED_FORMAT = 0,
    GIF_SK_ENCODED_FORMAT = 1,
    ICO_SK_ENCODED_FORMAT = 2,
    JPEG_SK_ENCODED_FORMAT = 3,
    PNG_SK_ENCODED_FORMAT = 4,
    WBMP_SK_ENCODED_FORMAT = 5,
    WEBP_SK_ENCODED_FORMAT = 6,
    PKM_SK_ENCODED_FORMAT = 7,
    KTX_SK_ENCODED_FORMAT = 8,
    ASTC_SK_ENCODED_FORMAT = 9,
    DNG_SK_ENCODED_FORMAT = 10,
    HEIF_SK_ENCODED_FORMAT = 11;

/** enum sk_encodedorigin_t */
public static final int
    TOP_LEFT_SK_ENCODED_ORIGIN     = 1, // Default
    TOP_RIGHT_SK_ENCODED_ORIGIN    = 2, // Reflected across y-axis
    BOTTOM_RIGHT_SK_ENCODED_ORIGIN = 3, // Rotated 180
    BOTTOM_LEFT_SK_ENCODED_ORIGIN  = 4, // Reflected across x-axis
    LEFT_TOP_SK_ENCODED_ORIGIN     = 5, // Reflected across x-axis, Rotated 90 CCW
    RIGHT_TOP_SK_ENCODED_ORIGIN    = 6, // Rotated 90 CW
    RIGHT_BOTTOM_SK_ENCODED_ORIGIN = 7, // Reflected across x-axis, Rotated 90 CW
    LEFT_BOTTOM_SK_ENCODED_ORIGIN  = 8, // Rotated 90 CCW
    DEFAULT_SK_ENCODED_ORIGIN      = TOP_LEFT_SK_ENCODED_ORIGIN;

/** enum sk_codec_result_t */
public static final int
    SUCCESS_SK_CODEC_RESULT = 0,
    INCOMPLETE_INPUT_SK_CODEC_RESULT = 1,
    ERROR_IN_INPUT_SK_CODEC_RESULT = 2,
    INVALID_CONVERSION_SK_CODEC_RESULT = 3,
    INVALID_SCALE_SK_CODEC_RESULT = 4,
    INVALID_PARAMETERS_SK_CODEC_RESULT = 5,
    INVALID_INPUT_SK_CODEC_RESULT = 6,
    COULD_NOT_REWIND_SK_CODEC_RESULT = 7,
    INTERNAL_ERROR_SK_CODEC_RESULT = 8,
    UNIMPLEMENTED_SK_CODEC_RESULT = 9;

/** enum sk_codec_zero_initialized_t */
public static final int
    YES_SK_CODEC_ZERO_INITIALIZED = 0,
    NO_SK_CODEC_ZERO_INITIALIZED = 1;

/** enum sk_transfer_function_behavior_t */
public static final int
    RESPECT_SK_TRANSFER_FUNCTION_BEHAVIOR = 0,
    IGNORE_SK_TRANSFER_FUNCTION_BEHAVIOR = 1;
// Targeting ../sk_codec_options_t.java



/** enum sk_codec_scanline_order_t */
public static final int
    TOP_DOWN_SK_CODEC_SCANLINE_ORDER = 0,
    BOTTOM_UP_SK_CODEC_SCANLINE_ORDER = 1;

// The verbs that can be foudn on a path
/** enum sk_path_verb_t */
public static final int
    MOVE_SK_PATH_VERB = 0,
    LINE_SK_PATH_VERB = 1,
    QUAD_SK_PATH_VERB = 2,
    CONIC_SK_PATH_VERB = 3,
    CUBIC_SK_PATH_VERB = 4,
    CLOSE_SK_PATH_VERB = 5,
    DONE_SK_PATH_VERB = 6;
// Targeting ../sk_path_iterator_t.java


// Targeting ../sk_path_rawiterator_t.java



/** enum sk_path_add_mode_t */
public static final int
    APPEND_SK_PATH_ADD_MODE = 0,
    EXTEND_SK_PATH_ADD_MODE = 1;

/** enum sk_path_segment_mask_t */
public static final int
    LINE_SK_PATH_SEGMENT_MASK  = 1 << 0,
    QUAD_SK_PATH_SEGMENT_MASK  = 1 << 1,
    CONIC_SK_PATH_SEGMENT_MASK = 1 << 2,
    CUBIC_SK_PATH_SEGMENT_MASK = 1 << 3;

/** enum sk_path_effect_1d_style_t */
public static final int
    TRANSLATE_SK_PATH_EFFECT_1D_STYLE = 0,
    ROTATE_SK_PATH_EFFECT_1D_STYLE = 1,
    MORPH_SK_PATH_EFFECT_1D_STYLE = 2;

/** enum sk_path_effect_trim_mode_t */
public static final int
    NORMAL_SK_PATH_EFFECT_TRIM_MODE = 0,
    INVERTED_SK_PATH_EFFECT_TRIM_MODE = 1;
// Targeting ../sk_path_effect_t.java

  

/** enum sk_stroke_cap_t */
public static final int
    BUTT_SK_STROKE_CAP = 0,
    ROUND_SK_STROKE_CAP = 1,
    SQUARE_SK_STROKE_CAP = 2;

/** enum sk_stroke_join_t */
public static final int
    MITER_SK_STROKE_JOIN = 0,
    ROUND_SK_STROKE_JOIN = 1,
    BEVEL_SK_STROKE_JOIN = 2;

/** enum sk_shader_tilemode_t */
public static final int
    CLAMP_SK_SHADER_TILEMODE = 0,
    REPEAT_SK_SHADER_TILEMODE = 1,
    MIRROR_SK_SHADER_TILEMODE = 2;

/** enum sk_blurstyle_t */
public static final int
    /** fuzzy inside and outside */
    NORMAL_SK_BLUR_STYLE = 0,
    /** solid inside, fuzzy outside */
    SOLID_SK_BLUR_STYLE = 1,
    /** nothing inside, fuzzy outside */
    OUTER_SK_BLUR_STYLE = 2,
    /** fuzzy inside, nothing outside */
    INNER_SK_BLUR_STYLE = 3;

/** enum sk_path_direction_t */
public static final int
    CW_SK_PATH_DIRECTION = 0,
    CCW_SK_PATH_DIRECTION = 1;

/** enum sk_path_arc_size_t */
public static final int
    SMALL_SK_PATH_ARC_SIZE = 0,
    LARGE_SK_PATH_ARC_SIZE = 1;

/** enum sk_paint_style_t */
public static final int
    FILL_SK_PAINT_STYLE = 0,
    STROKE_SK_PAINT_STYLE = 1,
    STROKE_AND_FILL_SK_PAINT_STYLE = 2;

/** enum sk_paint_hinting_t */
public static final int
    NO_HINTING_SK_PAINT_HINTING = 0,
    SLIGHT_HINTING_SK_PAINT_HINTING = 1,
    NORMAL_HINTING_SK_PAINT_HINTING = 2,
    FULL_HINTING_SK_PAINT_HINTING = 3;
// Targeting ../sk_colortable_t.java


// Targeting ../sk_pixelref_factory_t.java



/** enum gr_surfaceorigin_t */
public static final int
    TOP_LEFT_GR_SURFACE_ORIGIN = 0,
    BOTTOM_LEFT_GR_SURFACE_ORIGIN = 1;

/** enum gr_pixelconfig_t */
public static final int
    UNKNOWN_GR_PIXEL_CONFIG = 0,
    ALPHA_8_GR_PIXEL_CONFIG = 1,
    GRAY_8_GR_PIXEL_CONFIG = 2,
    RGB_565_GR_PIXEL_CONFIG = 3,
    RGBA_4444_GR_PIXEL_CONFIG = 4,
    RGBA_8888_GR_PIXEL_CONFIG = 5,
    RGB_888_GR_PIXEL_CONFIG = 6,
    BGRA_8888_GR_PIXEL_CONFIG = 7,
    SRGBA_8888_GR_PIXEL_CONFIG = 8,
    SBGRA_8888_GR_PIXEL_CONFIG = 9,
    RGBA_1010102_GR_PIXEL_CONFIG = 10,
    RGBA_FLOAT_GR_PIXEL_CONFIG = 11,
    RG_FLOAT_GR_PIXEL_CONFIG = 12,
    ALPHA_HALF_GR_PIXEL_CONFIG = 13,
    RGBA_HALF_GR_PIXEL_CONFIG = 14;

/** enum sk_mask_format_t */
public static final int
    /** 1bit per pixel mask (e.g. monochrome) */
    BW_SK_MASK_FORMAT = 0,
    /** 8bits per pixel mask (e.g. antialiasing) */
    A8_SK_MASK_FORMAT = 1,
    /** 3 8bit per pixl planes: alpha, mul, add */
    THREE_D_SK_MASK_FORMAT = 2,
    /** SkPMColor */
    ARGB32_SK_MASK_FORMAT = 3,
    /** 565 alpha for r/g/b */
    LCD16_SK_MASK_FORMAT = 4;
// Targeting ../sk_mask_t.java



/** enum gr_context_flushbits_t */
public static final int
    NONE_GR_CONTEXT_FLUSHBITS = 0,
    DISCARD_GR_CONTEXT_FLUSHBITS = 0x2;
// Targeting ../gr_backendrendertarget_t.java


// Targeting ../gr_backendtexture_t.java


// Targeting ../gr_context_t.java



/** enum gr_backend_t */
public static final int
    METAL_GR_BACKEND = 0,
    OPENGL_GR_BACKEND = 1,
    VULKAN_GR_BACKEND = 2;
// Targeting ../gr_glinterface_t.java


// Targeting ../gr_gl_textureinfo_t.java


// Targeting ../gr_gl_framebufferinfo_t.java



/** enum sk_pathop_t */
public static final int
    DIFFERENCE_SK_PATHOP = 0,
    INTERSECT_SK_PATHOP = 1,
    UNION_SK_PATHOP = 2,
    XOR_SK_PATHOP = 3,
    REVERSE_DIFFERENCE_SK_PATHOP = 4;
// Targeting ../sk_opbuilder_t.java



/** enum sk_path_convexity_t */
public static final int
    UNKNOWN_SK_PATH_CONVEXITY = 0,
    CONVEX_SK_PATH_CONVEXITY = 1,
    CONCAVE_SK_PATH_CONVEXITY = 2;

/** enum sk_lattice_recttype_t */
public static final int
    DEFAULT_SK_LATTICE_RECT_TYPE = 0,
    TRANSPARENT_SK_LATTICE_RECT_TYPE = 1,
    FIXED_COLOR_SK_LATTICE_RECT_TYPE = 2;
// Targeting ../sk_lattice_t.java


// Targeting ../sk_pathmeasure_t.java



/** enum sk_pathmeasure_matrixflags_t */
public static final int
    GET_POSITION_SK_PATHMEASURE_MATRIXFLAGS = 0x01,
    GET_TANGENT_SK_PATHMEASURE_MATRIXFLAGS = 0x02,
    GET_POS_AND_TAN_SK_PATHMEASURE_MATRIXFLAGS = GET_POSITION_SK_PATHMEASURE_MATRIXFLAGS | GET_TANGENT_SK_PATHMEASURE_MATRIXFLAGS;
// Targeting ../sk_bitmap_release_proc.java


// Targeting ../sk_data_release_proc.java


// Targeting ../sk_image_raster_release_proc.java


// Targeting ../sk_image_texture_release_proc.java


// Targeting ../sk_surface_raster_release_proc.java



/** enum sk_image_caching_hint_t */
public static final int
    ALLOW_SK_IMAGE_CACHING_HINT = 0,
    DISALLOW_SK_IMAGE_CACHING_HINT = 1;

/** enum sk_bitmap_allocflags_t */
public static final int
    ZERO_PIXELS_SK_BITMAP_ALLOC_FLAGS = 1 << 0;
// Targeting ../sk_time_datetime_t.java


// Targeting ../sk_document_pdf_metadata_t.java



/** enum sk_colorspace_named_t */
public static final int
    SRGB_SK_COLORSPACE_NAMED = 0,
    ADOBE_RGB_SK_COLORSPACE_NAMED = 1,
    SRGB_LINEAR_SK_COLORSPACE_NAMED = 2;
// Targeting ../sk_imageinfo_t.java



/** enum sk_codecanimation_disposalmethod_t */
public static final int
    KEEP_SK_CODEC_ANIMATION_DISPOSAL_METHOD               = 1,
    RESTORE_BG_COLOR_SK_CODEC_ANIMATION_DISPOSAL_METHOD   = 2,
    RESTORE_PREVIOUS_SK_CODEC_ANIMATION_DISPOSAL_METHOD   = 3;
// Targeting ../sk_codec_frameinfo_t.java


// Targeting ../sk_xmlstreamwriter_t.java


// Targeting ../sk_xmlwriter_t.java


// Targeting ../sk_svgcanvas_t.java


// Targeting ../sk_3dview_t.java



/** enum sk_vertices_vertex_mode_t */
public static final int
    TRIANGLES_SK_VERTICES_VERTEX_MODE = 0,
    TRIANGLE_STRIP_SK_VERTICES_VERTEX_MODE = 1,
    TRIANGLE_FAN_SK_VERTICES_VERTEX_MODE = 2;
// Targeting ../sk_vertices_t.java



/** enum sk_colorspace_render_target_gamma_t */
public static final int
    LINEAR_SK_COLORSPACE_RENDER_TARGET_GAMMA = 0,
    SRGB_SK_COLORSPACE_RENDER_TARGET_GAMMA = 1;

/** enum sk_colorspace_gamut_t */
public static final int
    SRGB_SK_COLORSPACE_GAMUT = 0,
    ADOBE_RGB_SK_COLORSPACE_GAMUT = 1,
    DCIP3_D65_SK_COLORSPACE_GAMUT = 2,
    REC2020_SK_COLORSPACE_GAMUT = 3;
// Targeting ../sk_colorspace_transfer_fn_t.java


// Targeting ../sk_colorspaceprimaries_t.java



/** enum sk_highcontrastconfig_invertstyle_t */
public static final int
    NO_INVERT_SK_HIGH_CONTRAST_CONFIG_INVERT_STYLE = 0,
    INVERT_BRIGHTNESS_SK_HIGH_CONTRAST_CONFIG_INVERT_STYLE = 1,
    INVERT_LIGHTNESS_SK_HIGH_CONTRAST_CONFIG_INVERT_STYLE = 2;
// Targeting ../sk_highcontrastconfig_t.java



/** enum sk_pngencoder_filterflags_t */
public static final int
    ZERO_SK_PNGENCODER_FILTER_FLAGS  = 0x00,
    NONE_SK_PNGENCODER_FILTER_FLAGS  = 0x08,
    SUB_SK_PNGENCODER_FILTER_FLAGS   = 0x10,
    UP_SK_PNGENCODER_FILTER_FLAGS    = 0x20,
    AVG_SK_PNGENCODER_FILTER_FLAGS   = 0x40,
    PAETH_SK_PNGENCODER_FILTER_FLAGS = 0x80,
    ALL_SK_PNGENCODER_FILTER_FLAGS   = NONE_SK_PNGENCODER_FILTER_FLAGS |
                                       SUB_SK_PNGENCODER_FILTER_FLAGS |
                                       UP_SK_PNGENCODER_FILTER_FLAGS | 
                                       AVG_SK_PNGENCODER_FILTER_FLAGS | 
                                       PAETH_SK_PNGENCODER_FILTER_FLAGS;
// Targeting ../sk_pngencoder_options_t.java



/** enum sk_jpegencoder_downsample_t */
public static final int
    DOWNSAMPLE_420_SK_JPEGENCODER_DOWNSAMPLE = 0,
    DOWNSAMPLE_422_SK_JPEGENCODER_DOWNSAMPLE = 1,
    DOWNSAMPLE_444_SK_JPEGENCODER_DOWNSAMPLE = 2;

/** enum sk_jpegencoder_alphaoption_t */
public static final int
    IGNORE_SK_JPEGENCODER_ALPHA_OPTION = 0,
    BLEND_ON_BLACK_SK_JPEGENCODER_ALPHA_OPTION = 1;
// Targeting ../sk_jpegencoder_options_t.java



/** enum sk_webpencoder_compression_t */
public static final int
    LOSSY_SK_WEBPENCODER_COMPTRESSION = 0,
    LOSSLESS_SK_WEBPENCODER_COMPTRESSION = 1;
// Targeting ../sk_webpencoder_options_t.java


// Targeting ../sk_rrect_t.java



/** enum sk_rrect_type_t */
public static final int
    EMPTY_SK_RRECT_TYPE = 0,
    RECT_SK_RRECT_TYPE = 1,
    OVAL_SK_RRECT_TYPE = 2,
    SIMPLE_SK_RRECT_TYPE = 3,
    NINE_PATCH_SK_RRECT_TYPE = 4,
    COMPLEX_SK_RRECT_TYPE = 5;

/** enum sk_rrect_corner_t */
public static final int
    UPPER_LEFT_SK_RRECT_CORNER = 0,
    UPPER_RIGHT_SK_RRECT_CORNER = 1,
    LOWER_RIGHT_SK_RRECT_CORNER = 2,
    LOWER_LEFT_SK_RRECT_CORNER = 3;
// Targeting ../sk_textblob_t.java


// Targeting ../sk_textblob_builder_t.java


// Targeting ../sk_textblob_builder_runbuffer_t.java



// #endif


// Parsed from gr_context.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef gr_context_DEFINED
// #define gr_context_DEFINED

// #include "sk_types.h"

// GrContext

public static native gr_context_t gr_context_make_gl(@Const gr_glinterface_t glInterface);
// TODO: the overloads with GrContextOptions
// TODO: the Vulkan and Metal contexts

public static native void gr_context_unref(gr_context_t context);
public static native void gr_context_abandon_context(gr_context_t context);
public static native void gr_context_release_resources_and_abandon_context(gr_context_t context);
public static native void gr_context_get_resource_cache_limits(gr_context_t context, IntPointer maxResources, @Cast("size_t*") SizeTPointer maxResourceBytes);
public static native void gr_context_get_resource_cache_limits(gr_context_t context, IntBuffer maxResources, @Cast("size_t*") SizeTPointer maxResourceBytes);
public static native void gr_context_get_resource_cache_limits(gr_context_t context, int[] maxResources, @Cast("size_t*") SizeTPointer maxResourceBytes);
public static native void gr_context_set_resource_cache_limits(gr_context_t context, int maxResources, @Cast("size_t") long maxResourceBytes);
public static native void gr_context_get_resource_cache_usage(gr_context_t context, IntPointer maxResources, @Cast("size_t*") SizeTPointer maxResourceBytes);
public static native void gr_context_get_resource_cache_usage(gr_context_t context, IntBuffer maxResources, @Cast("size_t*") SizeTPointer maxResourceBytes);
public static native void gr_context_get_resource_cache_usage(gr_context_t context, int[] maxResources, @Cast("size_t*") SizeTPointer maxResourceBytes);
public static native int gr_context_get_max_surface_sample_count_for_color_type(gr_context_t context, @Cast("sk_colortype_t") int colorType);
public static native void gr_context_flush(gr_context_t context);
public static native void gr_context_reset_context(gr_context_t context, @Cast("uint32_t") int state);
public static native @Cast("gr_backend_t") int gr_context_get_backend(gr_context_t context);


// GrGLInterface

public static native @Const gr_glinterface_t gr_glinterface_create_native_interface();
public static native void gr_glinterface_unref(@Const gr_glinterface_t glInterface);
public static native @Cast("bool") boolean gr_glinterface_validate(@Const gr_glinterface_t glInterface);
public static native @Cast("bool") boolean gr_glinterface_has_extension(@Const gr_glinterface_t glInterface, @Cast("const char*") BytePointer extension);
public static native @Cast("bool") boolean gr_glinterface_has_extension(@Const gr_glinterface_t glInterface, String extension);


// GrBackendTexture

public static native gr_backendtexture_t gr_backendtexture_new_gl(int width, int height, @Cast("bool") boolean mipmapped, @Const gr_gl_textureinfo_t glInfo);
public static native void gr_backendtexture_delete(gr_backendtexture_t texture);

public static native @Cast("bool") boolean gr_backendtexture_is_valid(@Const gr_backendtexture_t texture);
public static native int gr_backendtexture_get_width(@Const gr_backendtexture_t texture);
public static native int gr_backendtexture_get_height(@Const gr_backendtexture_t texture);
public static native @Cast("bool") boolean gr_backendtexture_has_mipmaps(@Const gr_backendtexture_t texture);
public static native @Cast("gr_backend_t") int gr_backendtexture_get_backend(@Const gr_backendtexture_t texture);
public static native @Cast("bool") boolean gr_backendtexture_get_gl_textureinfo(@Const gr_backendtexture_t texture, gr_gl_textureinfo_t glInfo);


// GrBackendRenderTarget

public static native gr_backendrendertarget_t gr_backendrendertarget_new_gl(int width, int height, int samples, int stencils, @Const gr_gl_framebufferinfo_t glInfo);
public static native void gr_backendrendertarget_delete(gr_backendrendertarget_t rendertarget);

public static native @Cast("bool") boolean gr_backendrendertarget_is_valid(@Const gr_backendrendertarget_t rendertarget);
public static native int gr_backendrendertarget_get_width(@Const gr_backendrendertarget_t rendertarget);
public static native int gr_backendrendertarget_get_height(@Const gr_backendrendertarget_t rendertarget);
public static native int gr_backendrendertarget_get_samples(@Const gr_backendrendertarget_t rendertarget);
public static native int gr_backendrendertarget_get_stencils(@Const gr_backendrendertarget_t rendertarget);
public static native @Cast("gr_backend_t") int gr_backendrendertarget_get_backend(@Const gr_backendrendertarget_t rendertarget);
public static native @Cast("bool") boolean gr_backendrendertarget_get_gl_framebufferinfo(@Const gr_backendrendertarget_t rendertarget, gr_gl_framebufferinfo_t glInfo);


// #endif


// Parsed from sk_bitmap.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_bitmap_DEFINED
// #define sk_bitmap_DEFINED

// #include "sk_types.h"

public static native void sk_bitmap_destructor(sk_bitmap_t cbitmap);
public static native sk_bitmap_t sk_bitmap_new();
public static native void sk_bitmap_get_info(sk_bitmap_t cbitmap, sk_imageinfo_t info);
public static native Pointer sk_bitmap_get_pixels(sk_bitmap_t cbitmap, @Cast("size_t*") SizeTPointer length);
public static native @Cast("size_t") long sk_bitmap_get_row_bytes(sk_bitmap_t cbitmap);
public static native @Cast("size_t") long sk_bitmap_get_byte_count(sk_bitmap_t cbitmap);
public static native void sk_bitmap_reset(sk_bitmap_t cbitmap);
public static native @Cast("bool") boolean sk_bitmap_is_null(sk_bitmap_t cbitmap);
public static native @Cast("bool") boolean sk_bitmap_is_immutable(sk_bitmap_t cbitmap);
public static native void sk_bitmap_set_immutable(sk_bitmap_t cbitmap);
public static native @Cast("bool") boolean sk_bitmap_is_volatile(sk_bitmap_t cbitmap);
public static native void sk_bitmap_set_volatile(sk_bitmap_t cbitmap, @Cast("bool") boolean value);
public static native void sk_bitmap_erase(sk_bitmap_t cbitmap, @Cast("sk_color_t") int color);
public static native void sk_bitmap_erase_rect(sk_bitmap_t cbitmap, @Cast("sk_color_t") int color, sk_irect_t rect);
public static native @Cast("uint8_t") byte sk_bitmap_get_addr_8(sk_bitmap_t cbitmap, int x, int y);
public static native @Cast("uint16_t") short sk_bitmap_get_addr_16(sk_bitmap_t cbitmap, int x, int y);
public static native @Cast("uint32_t") int sk_bitmap_get_addr_32(sk_bitmap_t cbitmap, int x, int y);
public static native Pointer sk_bitmap_get_addr(sk_bitmap_t cbitmap, int x, int y);
public static native @Cast("sk_color_t") int sk_bitmap_get_pixel_color(sk_bitmap_t cbitmap, int x, int y);
public static native @Cast("sk_pmcolor_t") int sk_bitmap_get_index8_color(sk_bitmap_t cbitmap, int x, int y);
public static native void sk_bitmap_set_pixel_color(sk_bitmap_t cbitmap, int x, int y, @Cast("sk_color_t") int color);
public static native @Cast("bool") boolean sk_bitmap_ready_to_draw(sk_bitmap_t cbitmap);
public static native void sk_bitmap_get_pixel_colors(sk_bitmap_t cbitmap, @Cast("sk_color_t*") IntPointer colors);
public static native void sk_bitmap_get_pixel_colors(sk_bitmap_t cbitmap, @Cast("sk_color_t*") IntBuffer colors);
public static native void sk_bitmap_get_pixel_colors(sk_bitmap_t cbitmap, @Cast("sk_color_t*") int[] colors);
public static native void sk_bitmap_set_pixel_colors(sk_bitmap_t cbitmap, @Cast("const sk_color_t*") IntPointer colors);
public static native void sk_bitmap_set_pixel_colors(sk_bitmap_t cbitmap, @Cast("const sk_color_t*") IntBuffer colors);
public static native void sk_bitmap_set_pixel_colors(sk_bitmap_t cbitmap, @Cast("const sk_color_t*") int[] colors);
public static native @Cast("bool") boolean sk_bitmap_install_pixels(sk_bitmap_t cbitmap, @Const sk_imageinfo_t cinfo, Pointer pixels, @Cast("size_t") long rowBytes, sk_bitmap_release_proc releaseProc, Pointer context);
public static native @Cast("bool") boolean sk_bitmap_install_pixels_with_pixmap(sk_bitmap_t cbitmap, @Const sk_pixmap_t cpixmap);
public static native @Cast("bool") boolean sk_bitmap_install_mask_pixels(sk_bitmap_t cbitmap, @Const sk_mask_t cmask);
public static native @Cast("bool") boolean sk_bitmap_try_alloc_pixels(sk_bitmap_t cbitmap, @Const sk_imageinfo_t requestedInfo, @Cast("size_t") long rowBytes);
public static native @Cast("bool") boolean sk_bitmap_try_alloc_pixels_with_flags(sk_bitmap_t cbitmap, @Const sk_imageinfo_t requestedInfo, @Cast("uint32_t") int flags);
public static native void sk_bitmap_set_pixels(sk_bitmap_t cbitmap, Pointer pixels);
public static native @Cast("bool") boolean sk_bitmap_peek_pixels(sk_bitmap_t cbitmap, sk_pixmap_t cpixmap);
public static native @Cast("bool") boolean sk_bitmap_extract_subset(sk_bitmap_t cbitmap, sk_bitmap_t dst, sk_irect_t subset);
public static native @Cast("bool") boolean sk_bitmap_extract_alpha(sk_bitmap_t cbitmap, sk_bitmap_t dst, @Const sk_paint_t paint, sk_ipoint_t offset);
public static native void sk_bitmap_notify_pixels_changed(sk_bitmap_t cbitmap);
public static native void sk_bitmap_swap(sk_bitmap_t cbitmap, sk_bitmap_t cother);

// #endif


// Parsed from sk_canvas.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_canvas_DEFINED
// #define sk_canvas_DEFINED

// #include "sk_types.h"

public static native void sk_canvas_destroy(sk_canvas_t arg0);
public static native int sk_canvas_save(sk_canvas_t arg0);
public static native int sk_canvas_save_layer(sk_canvas_t arg0, @Const sk_rect_t arg1, @Const sk_paint_t arg2);
public static native void sk_canvas_restore(sk_canvas_t arg0);
public static native void sk_canvas_translate(sk_canvas_t arg0, float dx, float dy);
public static native void sk_canvas_scale(sk_canvas_t arg0, float sx, float sy);
public static native void sk_canvas_rotate_degrees(sk_canvas_t arg0, float degrees);
public static native void sk_canvas_rotate_radians(sk_canvas_t arg0, float radians);
public static native void sk_canvas_skew(sk_canvas_t arg0, float sx, float sy);
public static native void sk_canvas_concat(sk_canvas_t arg0, @Const sk_matrix_t arg1);
public static native @Cast("bool") boolean sk_canvas_quick_reject(sk_canvas_t arg0, @Const sk_rect_t arg1);
public static native void sk_canvas_clip_region(sk_canvas_t canvas, @Const sk_region_t region, @Cast("sk_clipop_t") int op);
public static native void sk_canvas_draw_paint(sk_canvas_t arg0, @Const sk_paint_t arg1);
public static native void sk_canvas_draw_rect(sk_canvas_t arg0, @Const sk_rect_t arg1, @Const sk_paint_t arg2);
public static native void sk_canvas_draw_rrect(sk_canvas_t arg0, @Const sk_rrect_t arg1, @Const sk_paint_t arg2);
public static native void sk_canvas_draw_region(sk_canvas_t arg0, @Const sk_region_t arg1, @Const sk_paint_t arg2);
public static native void sk_canvas_draw_circle(sk_canvas_t arg0, float cx, float cy, float rad, @Const sk_paint_t arg4);
public static native void sk_canvas_draw_oval(sk_canvas_t arg0, @Const sk_rect_t arg1, @Const sk_paint_t arg2);
public static native void sk_canvas_draw_path(sk_canvas_t arg0, @Const sk_path_t arg1, @Const sk_paint_t arg2);
public static native void sk_canvas_draw_image(sk_canvas_t arg0, @Const sk_image_t arg1, float x, float y, @Const sk_paint_t arg4);
public static native void sk_canvas_draw_image_rect(sk_canvas_t arg0, @Const sk_image_t arg1, @Const sk_rect_t src, @Const sk_rect_t dst, @Const sk_paint_t arg4);
public static native void sk_canvas_draw_picture(sk_canvas_t arg0, @Const sk_picture_t arg1, @Const sk_matrix_t arg2, @Const sk_paint_t arg3);
public static native void sk_canvas_clear(sk_canvas_t arg0, @Cast("sk_color_t") int arg1);
public static native void sk_canvas_discard(sk_canvas_t arg0);
public static native int sk_canvas_get_save_count(sk_canvas_t arg0);
public static native void sk_canvas_restore_to_count(sk_canvas_t arg0, int saveCount);
public static native void sk_canvas_draw_color(sk_canvas_t ccanvas, @Cast("sk_color_t") int color, @Cast("sk_blendmode_t") int mode);
public static native void sk_canvas_draw_points(sk_canvas_t arg0, @Cast("sk_point_mode_t") int arg1, @Cast("size_t") long arg2, @Const sk_point_t arg3, @Const sk_paint_t arg4);
public static native void sk_canvas_draw_point(sk_canvas_t arg0, float arg1, float arg2, @Const sk_paint_t arg3);
public static native void sk_canvas_draw_line(sk_canvas_t ccanvas, float x0, float y0, float x1, float y1, sk_paint_t cpaint);
public static native void sk_canvas_draw_text(sk_canvas_t arg0, @Cast("const char*") BytePointer text, @Cast("size_t") long byteLength, float x, float y, @Const sk_paint_t paint);
public static native void sk_canvas_draw_text(sk_canvas_t arg0, String text, @Cast("size_t") long byteLength, float x, float y, @Const sk_paint_t paint);
public static native void sk_canvas_draw_pos_text(sk_canvas_t arg0, @Cast("const char*") BytePointer text, @Cast("size_t") long byteLength, @Const sk_point_t arg3, @Const sk_paint_t paint);
public static native void sk_canvas_draw_pos_text(sk_canvas_t arg0, String text, @Cast("size_t") long byteLength, @Const sk_point_t arg3, @Const sk_paint_t paint);
public static native void sk_canvas_draw_text_on_path(sk_canvas_t arg0, @Cast("const char*") BytePointer text, @Cast("size_t") long byteLength, @Const sk_path_t path, float hOffset, float vOffset, @Const sk_paint_t paint);
public static native void sk_canvas_draw_text_on_path(sk_canvas_t arg0, String text, @Cast("size_t") long byteLength, @Const sk_path_t path, float hOffset, float vOffset, @Const sk_paint_t paint);
public static native void sk_canvas_draw_text_blob(sk_canvas_t arg0, sk_textblob_t text, float x, float y, @Const sk_paint_t paint);
public static native void sk_canvas_draw_bitmap(sk_canvas_t ccanvas, @Const sk_bitmap_t bitmap, float left, float top, @Const sk_paint_t paint);
public static native void sk_canvas_draw_bitmap_rect(sk_canvas_t ccanvas, @Const sk_bitmap_t bitmap, @Const sk_rect_t src, @Const sk_rect_t dst, @Const sk_paint_t paint);
public static native void sk_canvas_reset_matrix(sk_canvas_t ccanvas);
public static native void sk_canvas_set_matrix(sk_canvas_t ccanvas, @Const sk_matrix_t matrix);
public static native void sk_canvas_get_total_matrix(sk_canvas_t ccanvas, sk_matrix_t matrix);
public static native void sk_canvas_draw_round_rect(sk_canvas_t arg0, @Const sk_rect_t arg1, float rx, float ry, @Const sk_paint_t arg4);
public static native void sk_canvas_clip_rect_with_operation(sk_canvas_t t, @Const sk_rect_t crect, @Cast("sk_clipop_t") int op, @Cast("bool") boolean doAA);
public static native void sk_canvas_clip_path_with_operation(sk_canvas_t t, @Const sk_path_t crect, @Cast("sk_clipop_t") int op, @Cast("bool") boolean doAA);
public static native void sk_canvas_clip_rrect_with_operation(sk_canvas_t t, @Const sk_rrect_t crect, @Cast("sk_clipop_t") int op, @Cast("bool") boolean doAA);
public static native @Cast("bool") boolean sk_canvas_get_local_clip_bounds(sk_canvas_t t, sk_rect_t cbounds);
public static native @Cast("bool") boolean sk_canvas_get_device_clip_bounds(sk_canvas_t t, sk_irect_t cbounds);
public static native void sk_canvas_flush(sk_canvas_t ccanvas);
public static native sk_canvas_t sk_canvas_new_from_bitmap(@Const sk_bitmap_t bitmap);
public static native void sk_canvas_draw_annotation(sk_canvas_t t, @Const sk_rect_t rect, @Cast("const char*") BytePointer key, sk_data_t value);
public static native void sk_canvas_draw_annotation(sk_canvas_t t, @Const sk_rect_t rect, String key, sk_data_t value);
public static native void sk_canvas_draw_url_annotation(sk_canvas_t t, @Const sk_rect_t rect, sk_data_t value);
public static native void sk_canvas_draw_named_destination_annotation(sk_canvas_t t, @Const sk_point_t point, sk_data_t value);
public static native void sk_canvas_draw_link_destination_annotation(sk_canvas_t t, @Const sk_rect_t rect, sk_data_t value);
public static native void sk_canvas_draw_bitmap_lattice(sk_canvas_t t, @Const sk_bitmap_t bitmap, @Const sk_lattice_t lattice, @Const sk_rect_t dst, @Const sk_paint_t paint);
public static native void sk_canvas_draw_image_lattice(sk_canvas_t t, @Const sk_image_t image, @Const sk_lattice_t lattice, @Const sk_rect_t dst, @Const sk_paint_t paint);
public static native void sk_canvas_draw_bitmap_nine(sk_canvas_t t, @Const sk_bitmap_t bitmap, @Const sk_irect_t center, @Const sk_rect_t dst, @Const sk_paint_t paint);
public static native void sk_canvas_draw_image_nine(sk_canvas_t t, @Const sk_image_t image, @Const sk_irect_t center, @Const sk_rect_t dst, @Const sk_paint_t paint);
public static native void sk_canvas_draw_vertices(sk_canvas_t ccanvas, sk_vertices_t vertices, @Cast("sk_blendmode_t") int mode, @Const sk_paint_t paint);

public static native sk_nodraw_canvas_t sk_nodraw_canvas_new(int width, int height);
public static native void sk_nodraw_canvas_destroy(sk_nodraw_canvas_t arg0);

public static native sk_nway_canvas_t sk_nway_canvas_new(int width, int height);
public static native void sk_nway_canvas_destroy(sk_nway_canvas_t arg0);
public static native void sk_nway_canvas_add_canvas(sk_nway_canvas_t arg0, sk_canvas_t canvas);
public static native void sk_nway_canvas_remove_canvas(sk_nway_canvas_t arg0, sk_canvas_t canvas);
public static native void sk_nway_canvas_remove_all(sk_nway_canvas_t arg0);

public static native sk_overdraw_canvas_t sk_overdraw_canvas_new(sk_canvas_t canvas);
public static native void sk_overdraw_canvas_destroy(sk_overdraw_canvas_t canvas);

// #endif


// Parsed from sk_codec.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_codec_DEFINED
// #define sk_codec_DEFINED

// #include "sk_types.h"

public static native @Cast("size_t") long sk_codec_min_buffered_bytes_needed();

public static native sk_codec_t sk_codec_new_from_stream(sk_stream_t stream, @Cast("sk_codec_result_t*") IntPointer result);
public static native sk_codec_t sk_codec_new_from_stream(sk_stream_t stream, @Cast("sk_codec_result_t*") IntBuffer result);
public static native sk_codec_t sk_codec_new_from_stream(sk_stream_t stream, @Cast("sk_codec_result_t*") int[] result);
public static native sk_codec_t sk_codec_new_from_data(sk_data_t data);
public static native void sk_codec_destroy(sk_codec_t codec);
public static native void sk_codec_get_info(sk_codec_t codec, sk_imageinfo_t info);
public static native @Cast("sk_encodedorigin_t") int sk_codec_get_origin(sk_codec_t codec);
public static native void sk_codec_get_scaled_dimensions(sk_codec_t codec, float desiredScale, sk_isize_t dimensions);
public static native @Cast("bool") boolean sk_codec_get_valid_subset(sk_codec_t codec, sk_irect_t desiredSubset);
public static native @Cast("sk_encoded_image_format_t") int sk_codec_get_encoded_format(sk_codec_t codec);
public static native @Cast("sk_codec_result_t") int sk_codec_get_pixels(sk_codec_t codec, @Const sk_imageinfo_t info, Pointer pixels, @Cast("size_t") long rowBytes, @Const sk_codec_options_t options);
public static native @Cast("sk_codec_result_t") int sk_codec_start_incremental_decode(sk_codec_t codec, @Const sk_imageinfo_t info, Pointer pixels, @Cast("size_t") long rowBytes, @Const sk_codec_options_t options);
public static native @Cast("sk_codec_result_t") int sk_codec_incremental_decode(sk_codec_t codec, IntPointer rowsDecoded);
public static native @Cast("sk_codec_result_t") int sk_codec_incremental_decode(sk_codec_t codec, IntBuffer rowsDecoded);
public static native @Cast("sk_codec_result_t") int sk_codec_incremental_decode(sk_codec_t codec, int[] rowsDecoded);
public static native @Cast("sk_codec_result_t") int sk_codec_start_scanline_decode(sk_codec_t codec, @Const sk_imageinfo_t info, @Const sk_codec_options_t options);
public static native int sk_codec_get_scanlines(sk_codec_t codec, Pointer dst, int countLines, @Cast("size_t") long rowBytes);
public static native @Cast("bool") boolean sk_codec_skip_scanlines(sk_codec_t codec, int countLines);
public static native @Cast("sk_codec_scanline_order_t") int sk_codec_get_scanline_order(sk_codec_t codec);
public static native int sk_codec_next_scanline(sk_codec_t codec);
public static native int sk_codec_output_scanline(sk_codec_t codec, int inputScanline);
public static native int sk_codec_get_frame_count(sk_codec_t codec);
public static native void sk_codec_get_frame_info(sk_codec_t codec, sk_codec_frameinfo_t frameInfo);
public static native @Cast("bool") boolean sk_codec_get_frame_info_for_index(sk_codec_t codec, int index, sk_codec_frameinfo_t frameInfo);
public static native int sk_codec_get_repetition_count(sk_codec_t codec);

// #endif


// Parsed from sk_colorfilter.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_colorfilter_DEFINED
// #define sk_colorfilter_DEFINED

// #include "sk_types.h"

public static native void sk_colorfilter_unref(sk_colorfilter_t filter);
public static native sk_colorfilter_t sk_colorfilter_new_mode(@Cast("sk_color_t") int c, @Cast("sk_blendmode_t") int mode);
public static native sk_colorfilter_t sk_colorfilter_new_lighting(@Cast("sk_color_t") int mul, @Cast("sk_color_t") int add);
public static native sk_colorfilter_t sk_colorfilter_new_compose(sk_colorfilter_t outer, sk_colorfilter_t inner);
public static native sk_colorfilter_t sk_colorfilter_new_color_matrix(@Const FloatPointer array);
public static native sk_colorfilter_t sk_colorfilter_new_color_matrix(@Const FloatBuffer array);
public static native sk_colorfilter_t sk_colorfilter_new_color_matrix(@Const float[] array);
public static native sk_colorfilter_t sk_colorfilter_new_luma_color();
public static native sk_colorfilter_t sk_colorfilter_new_high_contrast(@Const sk_highcontrastconfig_t config);
public static native sk_colorfilter_t sk_colorfilter_new_table(@Cast("const uint8_t*") BytePointer table);
public static native sk_colorfilter_t sk_colorfilter_new_table(@Cast("const uint8_t*") ByteBuffer table);
public static native sk_colorfilter_t sk_colorfilter_new_table(@Cast("const uint8_t*") byte[] table);
public static native sk_colorfilter_t sk_colorfilter_new_table_argb(@Cast("const uint8_t*") BytePointer tableA, @Cast("const uint8_t*") BytePointer tableR, @Cast("const uint8_t*") BytePointer tableG, @Cast("const uint8_t*") BytePointer tableB);
public static native sk_colorfilter_t sk_colorfilter_new_table_argb(@Cast("const uint8_t*") ByteBuffer tableA, @Cast("const uint8_t*") ByteBuffer tableR, @Cast("const uint8_t*") ByteBuffer tableG, @Cast("const uint8_t*") ByteBuffer tableB);
public static native sk_colorfilter_t sk_colorfilter_new_table_argb(@Cast("const uint8_t*") byte[] tableA, @Cast("const uint8_t*") byte[] tableR, @Cast("const uint8_t*") byte[] tableG, @Cast("const uint8_t*") byte[] tableB);

// #endif


// Parsed from sk_colortable.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_colortable_DEFINED
// #define sk_colortable_DEFINED

// #include "sk_types.h"

public static native void sk_colortable_unref(sk_colortable_t ctable);
public static native sk_colortable_t sk_colortable_new(@Cast("const sk_pmcolor_t*") IntPointer colors, int count);
public static native sk_colortable_t sk_colortable_new(@Cast("const sk_pmcolor_t*") IntBuffer colors, int count);
public static native sk_colortable_t sk_colortable_new(@Cast("const sk_pmcolor_t*") int[] colors, int count);
public static native int sk_colortable_count(@Const sk_colortable_t ctable);
public static native void sk_colortable_read_colors(@Const sk_colortable_t ctable, @Cast("sk_pmcolor_t**") PointerPointer colors);
public static native void sk_colortable_read_colors(@Const sk_colortable_t ctable, @Cast("sk_pmcolor_t**") @ByPtrPtr IntPointer colors);
public static native void sk_colortable_read_colors(@Const sk_colortable_t ctable, @Cast("sk_pmcolor_t**") @ByPtrPtr IntBuffer colors);
public static native void sk_colortable_read_colors(@Const sk_colortable_t ctable, @Cast("sk_pmcolor_t**") @ByPtrPtr int[] colors);

// #endif


// Parsed from sk_data.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_data_DEFINED
// #define sk_data_DEFINED

// #include "sk_types.h"

public static native sk_data_t sk_data_new_empty();
public static native sk_data_t sk_data_new_with_copy(@Const Pointer src, @Cast("size_t") long length);
public static native sk_data_t sk_data_new_subset(@Const sk_data_t src, @Cast("size_t") long offset, @Cast("size_t") long length);
public static native void sk_data_ref(@Const sk_data_t arg0);
public static native void sk_data_unref(@Const sk_data_t arg0);
public static native @Cast("size_t") long sk_data_get_size(@Const sk_data_t arg0);
public static native @Const Pointer sk_data_get_data(@Const sk_data_t arg0);
public static native sk_data_t sk_data_new_from_file(@Cast("const char*") BytePointer path);
public static native sk_data_t sk_data_new_from_file(String path);
public static native sk_data_t sk_data_new_from_stream(sk_stream_t stream, @Cast("size_t") long length);
public static native @Cast("const uint8_t*") BytePointer sk_data_get_bytes(@Const sk_data_t arg0);
public static native sk_data_t sk_data_new_with_proc(@Const Pointer ptr, @Cast("size_t") long length, sk_data_release_proc proc, Pointer ctx);
public static native sk_data_t sk_data_new_uninitialized(@Cast("size_t") long size);

// #endif


// Parsed from sk_document.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_document_DEFINED
// #define sk_document_DEFINED

// #include "sk_types.h"

public static native void sk_document_unref(sk_document_t document);

public static native sk_document_t sk_document_create_pdf_from_stream(sk_wstream_t stream);
public static native sk_document_t sk_document_create_pdf_from_stream_with_metadata(sk_wstream_t stream, @Const sk_document_pdf_metadata_t metadata);

public static native sk_document_t sk_document_create_xps_from_stream(sk_wstream_t stream, float dpi);

public static native sk_canvas_t sk_document_begin_page(sk_document_t document, float width, float height, @Const sk_rect_t content);
public static native void sk_document_end_page(sk_document_t document);
public static native void sk_document_close(sk_document_t document);
public static native void sk_document_abort(sk_document_t document);

// #endif


// Parsed from sk_image.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_image_DEFINED
// #define sk_image_DEFINED

// #include "sk_types.h"

public static native sk_image_t sk_image_new_raster_copy(@Const sk_imageinfo_t arg0, @Const Pointer pixels, @Cast("size_t") long rowBytes);
public static native sk_image_t sk_image_new_raster_copy_with_pixmap(@Const sk_pixmap_t pixmap);
public static native sk_image_t sk_image_new_raster_data(@Const sk_imageinfo_t cinfo, sk_data_t pixels, @Cast("size_t") long rowBytes);
public static native sk_image_t sk_image_new_raster(@Const sk_pixmap_t pixmap, sk_image_raster_release_proc releaseProc, Pointer context);
public static native sk_image_t sk_image_new_from_bitmap(@Const sk_bitmap_t cbitmap);
public static native sk_image_t sk_image_new_from_encoded(sk_data_t encoded, @Const sk_irect_t subset);
public static native sk_image_t sk_image_new_from_texture(gr_context_t context, @Const gr_backendtexture_t texture, @Cast("gr_surfaceorigin_t") int origin, @Cast("sk_colortype_t") int colorType, @Cast("sk_alphatype_t") int alpha, sk_colorspace_t colorSpace, sk_image_texture_release_proc releaseProc, Pointer releaseContext);
public static native sk_image_t sk_image_new_from_adopted_texture(gr_context_t context, @Const gr_backendtexture_t texture, @Cast("gr_surfaceorigin_t") int origin, @Cast("sk_colortype_t") int colorType, @Cast("sk_alphatype_t") int alpha, sk_colorspace_t colorSpace);
public static native sk_image_t sk_image_new_from_picture(sk_picture_t picture, @Const sk_isize_t dimensions, @Const sk_matrix_t matrix, @Const sk_paint_t paint);

public static native sk_image_t sk_image_make_subset(@Const sk_image_t cimage, @Const sk_irect_t subset);
public static native sk_image_t sk_image_make_non_texture_image(@Const sk_image_t cimage);
public static native sk_image_t sk_image_make_with_filter(@Const sk_image_t cimage, @Const sk_imagefilter_t filter, @Const sk_irect_t subset, @Const sk_irect_t clipBounds, sk_irect_t outSubset, sk_ipoint_t outOffset);

public static native void sk_image_ref(@Const sk_image_t arg0);
public static native void sk_image_unref(@Const sk_image_t arg0);
public static native int sk_image_get_width(@Const sk_image_t arg0);
public static native int sk_image_get_height(@Const sk_image_t arg0);
public static native @Cast("uint32_t") int sk_image_get_unique_id(@Const sk_image_t arg0);
public static native @Cast("sk_alphatype_t") int sk_image_get_alpha_type(@Const sk_image_t arg0);
public static native @Cast("sk_colortype_t") int sk_image_get_color_type(@Const sk_image_t arg0);
public static native sk_colorspace_t sk_image_get_colorspace(@Const sk_image_t arg0);
public static native @Cast("bool") boolean sk_image_is_alpha_only(@Const sk_image_t arg0);
public static native sk_shader_t sk_image_make_shader(@Const sk_image_t arg0, @Cast("sk_shader_tilemode_t") int tileX, @Cast("sk_shader_tilemode_t") int tileY, @Const sk_matrix_t localMatrix);
public static native @Cast("bool") boolean sk_image_peek_pixels(@Const sk_image_t image, sk_pixmap_t pixmap);
public static native @Cast("bool") boolean sk_image_is_texture_backed(@Const sk_image_t image);
public static native @Cast("bool") boolean sk_image_is_lazy_generated(@Const sk_image_t image);
public static native @Cast("bool") boolean sk_image_read_pixels(@Const sk_image_t image, @Const sk_imageinfo_t dstInfo, Pointer dstPixels, @Cast("size_t") long dstRowBytes, int srcX, int srcY, @Cast("sk_image_caching_hint_t") int cachingHint);
public static native @Cast("bool") boolean sk_image_read_pixels_into_pixmap(@Const sk_image_t image, @Const sk_pixmap_t dst, int srcX, int srcY, @Cast("sk_image_caching_hint_t") int cachingHint);
public static native @Cast("bool") boolean sk_image_scale_pixels(@Const sk_image_t image, @Const sk_pixmap_t dst, @Cast("sk_filter_quality_t") int quality, @Cast("sk_image_caching_hint_t") int cachingHint);
public static native sk_data_t sk_image_ref_encoded(@Const sk_image_t arg0);
public static native sk_data_t sk_image_encode(@Const sk_image_t arg0);
public static native sk_data_t sk_image_encode_specific(@Const sk_image_t cimage, @Cast("sk_encoded_image_format_t") int encoder, int quality);

// #endif


// Parsed from sk_imagefilter.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_imagefilter_DEFINED
// #define sk_imagefilter_DEFINED

// #include "sk_types.h"

public static native sk_imagefilter_croprect_t sk_imagefilter_croprect_new();
public static native sk_imagefilter_croprect_t sk_imagefilter_croprect_new_with_rect(@Const sk_rect_t rect, @Cast("uint32_t") int flags);
public static native void sk_imagefilter_croprect_destructor(sk_imagefilter_croprect_t cropRect);
public static native void sk_imagefilter_croprect_get_rect(sk_imagefilter_croprect_t cropRect, sk_rect_t rect);
public static native @Cast("uint32_t") int sk_imagefilter_croprect_get_flags(sk_imagefilter_croprect_t cropRect);
public static native void sk_imagefilter_unref(sk_imagefilter_t arg0);
public static native sk_imagefilter_t sk_imagefilter_new_matrix(
    @Const sk_matrix_t matrix, 
    @Cast("sk_filter_quality_t") int quality, 
    sk_imagefilter_t input);
public static native sk_imagefilter_t sk_imagefilter_new_alpha_threshold(
    @Const sk_region_t region,
    float innerThreshold,
    float outerThreshold, 
    sk_imagefilter_t input);
public static native sk_imagefilter_t sk_imagefilter_new_blur(
    float sigmaX,
    float sigmaY,
    sk_imagefilter_t input,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_color_filter(
    sk_colorfilter_t cf,
    sk_imagefilter_t input,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_compose(
    sk_imagefilter_t outer,
    sk_imagefilter_t inner);
public static native sk_imagefilter_t sk_imagefilter_new_displacement_map_effect(
    @Cast("sk_displacement_map_effect_channel_selector_type_t") int xChannelSelector,
    @Cast("sk_displacement_map_effect_channel_selector_type_t") int yChannelSelector,
    float scale,
    sk_imagefilter_t displacement,
    sk_imagefilter_t color,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_drop_shadow(
    float dx,
    float dy,
    float sigmaX,
    float sigmaY,
    @Cast("sk_color_t") int color, 
    @Cast("sk_drop_shadow_image_filter_shadow_mode_t") int shadowMode,
    sk_imagefilter_t input,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_distant_lit_diffuse(
    @Const sk_point3_t direction,
    @Cast("sk_color_t") int lightColor,
    float surfaceScale,
    float kd,
    sk_imagefilter_t input,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_point_lit_diffuse(
    @Const sk_point3_t location,
    @Cast("sk_color_t") int lightColor,
    float surfaceScale, 
    float kd,
    sk_imagefilter_t input,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_spot_lit_diffuse(
    @Const sk_point3_t location,
    @Const sk_point3_t target,
    float specularExponent,
    float cutoffAngle,
    @Cast("sk_color_t") int lightColor, 
    float surfaceScale,
    float kd,
    sk_imagefilter_t input,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_distant_lit_specular(
    @Const sk_point3_t direction,
    @Cast("sk_color_t") int lightColor, 
    float surfaceScale,
    float ks,
    float shininess, 
    sk_imagefilter_t input,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_point_lit_specular(
    @Const sk_point3_t location,
    @Cast("sk_color_t") int lightColor, 
    float surfaceScale, 
    float ks,
    float shininess, 
    sk_imagefilter_t input,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_spot_lit_specular(
    @Const sk_point3_t location,
    @Const sk_point3_t target, 
    float specularExponent, 
    float cutoffAngle,
    @Cast("sk_color_t") int lightColor, 
    float surfaceScale,
    float ks,
    float shininess,
    sk_imagefilter_t input,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_magnifier(
    @Const sk_rect_t src, 
    float inset,
    sk_imagefilter_t input,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_matrix_convolution(
    @Const sk_isize_t kernelSize,
    @Const FloatPointer kernel,
    float gain,
    float bias,
    @Const sk_ipoint_t kernelOffset,
    @Cast("sk_matrix_convolution_tilemode_t") int tileMode,
    @Cast("bool") boolean convolveAlpha,
    sk_imagefilter_t input,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_matrix_convolution(
    @Const sk_isize_t kernelSize,
    @Const FloatBuffer kernel,
    float gain,
    float bias,
    @Const sk_ipoint_t kernelOffset,
    @Cast("sk_matrix_convolution_tilemode_t") int tileMode,
    @Cast("bool") boolean convolveAlpha,
    sk_imagefilter_t input,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_matrix_convolution(
    @Const sk_isize_t kernelSize,
    @Const float[] kernel,
    float gain,
    float bias,
    @Const sk_ipoint_t kernelOffset,
    @Cast("sk_matrix_convolution_tilemode_t") int tileMode,
    @Cast("bool") boolean convolveAlpha,
    sk_imagefilter_t input,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_merge(
    @Cast("sk_imagefilter_t**") PointerPointer filters,
    int count,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_merge(
    @ByPtrPtr sk_imagefilter_t filters,
    int count,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_dilate(
    int radiusX, 
    int radiusY, 
    sk_imagefilter_t input,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_erode(
    int radiusX,
    int radiusY,
    sk_imagefilter_t input,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_offset(
    float dx,
    float dy,
    sk_imagefilter_t input,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_picture(
    sk_picture_t picture);
public static native sk_imagefilter_t sk_imagefilter_new_picture_with_croprect(
    sk_picture_t picture,
    @Const sk_rect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_tile(
    @Const sk_rect_t src,
    @Const sk_rect_t dst,
    sk_imagefilter_t input);
public static native sk_imagefilter_t sk_imagefilter_new_xfermode(
    @Cast("sk_blendmode_t") int mode,
    sk_imagefilter_t background,
    sk_imagefilter_t foreground,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_arithmetic(
    float k1, float k2, float k3, float k4,
    @Cast("bool") boolean enforcePMColor,
    sk_imagefilter_t background,
    sk_imagefilter_t foreground,
    @Const sk_imagefilter_croprect_t cropRect);
public static native sk_imagefilter_t sk_imagefilter_new_image_source(
    sk_image_t image,
    @Const sk_rect_t srcRect,
    @Const sk_rect_t dstRect,
    @Cast("sk_filter_quality_t") int filterQuality);
public static native sk_imagefilter_t sk_imagefilter_new_image_source_default(
    sk_image_t image);
public static native sk_imagefilter_t sk_imagefilter_new_paint(
    @Const sk_paint_t paint,
    @Const sk_imagefilter_croprect_t cropRect);

// #endif


// Parsed from sk_mask.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Bluebeam Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_mask_DEFINED
// #define sk_mask_DEFINED

// #include "sk_types.h"

public static native @Cast("uint8_t*") BytePointer sk_mask_alloc_image(@Cast("size_t") long bytes);
public static native void sk_mask_free_image(Pointer image);
public static native @Cast("bool") boolean sk_mask_is_empty(sk_mask_t cmask);
public static native @Cast("size_t") long sk_mask_compute_image_size(sk_mask_t cmask);
public static native @Cast("size_t") long sk_mask_compute_total_image_size(sk_mask_t cmask);
public static native @Cast("uint8_t") byte sk_mask_get_addr_1(sk_mask_t cmask, int x, int y);
public static native @Cast("uint8_t") byte sk_mask_get_addr_8(sk_mask_t cmask, int x, int y);
public static native @Cast("uint16_t") short sk_mask_get_addr_lcd_16(sk_mask_t cmask, int x, int y);
public static native @Cast("uint32_t") int sk_mask_get_addr_32(sk_mask_t cmask, int x, int y);
public static native Pointer sk_mask_get_addr(sk_mask_t cmask, int x, int y);

// #endif


// Parsed from sk_maskfilter.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_maskfilter_DEFINED
// #define sk_maskfilter_DEFINED

// #include "sk_types.h"

public static native void sk_maskfilter_ref(sk_maskfilter_t arg0);
public static native void sk_maskfilter_unref(sk_maskfilter_t arg0);
public static native sk_maskfilter_t sk_maskfilter_new_blur(@Cast("sk_blurstyle_t") int arg0, float sigma);
public static native sk_maskfilter_t sk_maskfilter_new_blur_with_flags(@Cast("sk_blurstyle_t") int arg0, float sigma, @Const sk_rect_t occluder, @Cast("bool") boolean respectCTM);
public static native sk_maskfilter_t sk_maskfilter_new_table(@Cast("const uint8_t*") BytePointer table);
public static native sk_maskfilter_t sk_maskfilter_new_table(@Cast("const uint8_t*") ByteBuffer table);
public static native sk_maskfilter_t sk_maskfilter_new_table(@Cast("const uint8_t*") byte[] table);
public static native sk_maskfilter_t sk_maskfilter_new_gamma(float gamma);
public static native sk_maskfilter_t sk_maskfilter_new_clip(@Cast("uint8_t") byte min, @Cast("uint8_t") byte max);

// #endif


// Parsed from sk_matrix.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_matrix_DEFINED
// #define sk_matrix_DEFINED

// #include "sk_types.h"

public static native @Cast("bool") boolean sk_matrix_try_invert(sk_matrix_t matrix, sk_matrix_t result);
public static native void sk_matrix_concat(sk_matrix_t result, sk_matrix_t first, sk_matrix_t second);
public static native void sk_matrix_pre_concat(sk_matrix_t result, sk_matrix_t matrix);
public static native void sk_matrix_post_concat(sk_matrix_t result, sk_matrix_t matrix);
public static native void sk_matrix_map_rect(sk_matrix_t matrix, sk_rect_t dest, sk_rect_t source);
public static native void sk_matrix_map_points(sk_matrix_t matrix, sk_point_t dst, sk_point_t src, int count);
public static native void sk_matrix_map_vectors(sk_matrix_t matrix, sk_point_t dst, sk_point_t src, int count);
public static native void sk_matrix_map_xy(sk_matrix_t matrix, float x, float y, sk_point_t result);
public static native void sk_matrix_map_vector(sk_matrix_t matrix, float x, float y, sk_point_t result);
public static native float sk_matrix_map_radius(sk_matrix_t matrix, float radius);


public static native sk_3dview_t sk_3dview_new();
public static native void sk_3dview_destroy(sk_3dview_t cview);
public static native void sk_3dview_save(sk_3dview_t cview);
public static native void sk_3dview_restore(sk_3dview_t cview);
public static native void sk_3dview_translate(sk_3dview_t cview, float x, float y, float z);
public static native void sk_3dview_rotate_x_degrees(sk_3dview_t cview, float degrees);
public static native void sk_3dview_rotate_y_degrees(sk_3dview_t cview, float degrees);
public static native void sk_3dview_rotate_z_degrees(sk_3dview_t cview, float degrees);
public static native void sk_3dview_rotate_x_radians(sk_3dview_t cview, float radians);
public static native void sk_3dview_rotate_y_radians(sk_3dview_t cview, float radians);
public static native void sk_3dview_rotate_z_radians(sk_3dview_t cview, float radians);
public static native void sk_3dview_get_matrix(sk_3dview_t cview, sk_matrix_t cmatrix);
public static native void sk_3dview_apply_to_canvas(sk_3dview_t cview, sk_canvas_t ccanvas);
public static native float sk_3dview_dot_with_normal(sk_3dview_t cview, float dx, float dy, float dz);


public static native void sk_matrix44_destroy(sk_matrix44_t matrix);
public static native sk_matrix44_t sk_matrix44_new();
public static native sk_matrix44_t sk_matrix44_new_identity();
public static native sk_matrix44_t sk_matrix44_new_copy(@Const sk_matrix44_t src);
public static native sk_matrix44_t sk_matrix44_new_concat(@Const sk_matrix44_t a, @Const sk_matrix44_t b);
public static native sk_matrix44_t sk_matrix44_new_matrix(@Const sk_matrix_t src);
public static native @Cast("bool") boolean sk_matrix44_equals(sk_matrix44_t matrix, @Const sk_matrix44_t other);
public static native void sk_matrix44_to_matrix(sk_matrix44_t matrix, sk_matrix_t dst);
public static native @Cast("sk_matrix44_type_mask_t") int sk_matrix44_get_type(sk_matrix44_t matrix);
public static native void sk_matrix44_set_identity(sk_matrix44_t matrix);
public static native float sk_matrix44_get(sk_matrix44_t matrix, int row, int col);
public static native void sk_matrix44_set(sk_matrix44_t matrix, int row, int col, float value);
public static native void sk_matrix44_as_col_major(sk_matrix44_t matrix, FloatPointer dst);
public static native void sk_matrix44_as_col_major(sk_matrix44_t matrix, FloatBuffer dst);
public static native void sk_matrix44_as_col_major(sk_matrix44_t matrix, float[] dst);
public static native void sk_matrix44_as_row_major(sk_matrix44_t matrix, FloatPointer dst);
public static native void sk_matrix44_as_row_major(sk_matrix44_t matrix, FloatBuffer dst);
public static native void sk_matrix44_as_row_major(sk_matrix44_t matrix, float[] dst);
public static native void sk_matrix44_set_col_major(sk_matrix44_t matrix, FloatPointer dst);
public static native void sk_matrix44_set_col_major(sk_matrix44_t matrix, FloatBuffer dst);
public static native void sk_matrix44_set_col_major(sk_matrix44_t matrix, float[] dst);
public static native void sk_matrix44_set_row_major(sk_matrix44_t matrix, FloatPointer dst);
public static native void sk_matrix44_set_row_major(sk_matrix44_t matrix, FloatBuffer dst);
public static native void sk_matrix44_set_row_major(sk_matrix44_t matrix, float[] dst);
public static native void sk_matrix44_set_translate(sk_matrix44_t matrix, float dx, float dy, float dz);
public static native void sk_matrix44_pre_translate(sk_matrix44_t matrix, float dx, float dy, float dz);
public static native void sk_matrix44_post_translate(sk_matrix44_t matrix, float dx, float dy, float dz);
public static native void sk_matrix44_set_scale(sk_matrix44_t matrix, float sx, float sy, float sz);
public static native void sk_matrix44_pre_scale(sk_matrix44_t matrix, float sx, float sy, float sz);
public static native void sk_matrix44_post_scale(sk_matrix44_t matrix, float sx, float sy, float sz);
public static native void sk_matrix44_set_rotate_about_degrees(sk_matrix44_t matrix, float x, float y, float z, float degrees);
public static native void sk_matrix44_set_rotate_about_radians(sk_matrix44_t matrix, float x, float y, float z, float radians);
public static native void sk_matrix44_set_rotate_about_radians_unit(sk_matrix44_t matrix, float x, float y, float z, float radians);
public static native void sk_matrix44_set_concat(sk_matrix44_t matrix, @Const sk_matrix44_t a, @Const sk_matrix44_t b);
public static native void sk_matrix44_pre_concat(sk_matrix44_t matrix, @Const sk_matrix44_t m);
public static native void sk_matrix44_post_concat(sk_matrix44_t matrix, @Const sk_matrix44_t m);
public static native @Cast("bool") boolean sk_matrix44_invert(sk_matrix44_t matrix, sk_matrix44_t inverse);
public static native void sk_matrix44_transpose(sk_matrix44_t matrix);
public static native void sk_matrix44_map_scalars(sk_matrix44_t matrix, @Const FloatPointer src, FloatPointer dst);
public static native void sk_matrix44_map_scalars(sk_matrix44_t matrix, @Const FloatBuffer src, FloatBuffer dst);
public static native void sk_matrix44_map_scalars(sk_matrix44_t matrix, @Const float[] src, float[] dst);
public static native void sk_matrix44_map2(sk_matrix44_t matrix, @Const FloatPointer src2, int count, FloatPointer dst4);
public static native void sk_matrix44_map2(sk_matrix44_t matrix, @Const FloatBuffer src2, int count, FloatBuffer dst4);
public static native void sk_matrix44_map2(sk_matrix44_t matrix, @Const float[] src2, int count, float[] dst4);
public static native @Cast("bool") boolean sk_matrix44_preserves_2d_axis_alignment(sk_matrix44_t matrix, float epsilon);
public static native double sk_matrix44_determinant(sk_matrix44_t matrix);


// #endif


// Parsed from sk_paint.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_paint_DEFINED
// #define sk_paint_DEFINED

// #include "sk_types.h"

public static native sk_paint_t sk_paint_new();
public static native sk_paint_t sk_paint_clone(sk_paint_t arg0);
public static native void sk_paint_delete(sk_paint_t arg0);
public static native @Cast("bool") boolean sk_paint_is_antialias(@Const sk_paint_t arg0);
public static native void sk_paint_set_antialias(sk_paint_t arg0, @Cast("bool") boolean arg1);
public static native @Cast("sk_color_t") int sk_paint_get_color(@Const sk_paint_t arg0);
public static native void sk_paint_set_color(sk_paint_t arg0, @Cast("sk_color_t") int arg1);
public static native @Cast("sk_paint_style_t") int sk_paint_get_style(@Const sk_paint_t arg0);
public static native void sk_paint_set_style(sk_paint_t arg0, @Cast("sk_paint_style_t") int arg1);
public static native float sk_paint_get_stroke_width(@Const sk_paint_t arg0);
public static native void sk_paint_set_stroke_width(sk_paint_t arg0, float width);
public static native float sk_paint_get_stroke_miter(@Const sk_paint_t arg0);
public static native void sk_paint_set_stroke_miter(sk_paint_t arg0, float miter);
public static native @Cast("sk_stroke_cap_t") int sk_paint_get_stroke_cap(@Const sk_paint_t arg0);
public static native void sk_paint_set_stroke_cap(sk_paint_t arg0, @Cast("sk_stroke_cap_t") int arg1);
public static native @Cast("sk_stroke_join_t") int sk_paint_get_stroke_join(@Const sk_paint_t arg0);
public static native void sk_paint_set_stroke_join(sk_paint_t arg0, @Cast("sk_stroke_join_t") int arg1);
public static native void sk_paint_set_shader(sk_paint_t arg0, sk_shader_t arg1);
public static native void sk_paint_set_maskfilter(sk_paint_t arg0, sk_maskfilter_t arg1);
public static native void sk_paint_set_blendmode(sk_paint_t arg0, @Cast("sk_blendmode_t") int arg1);
public static native @Cast("bool") boolean sk_paint_is_dither(@Const sk_paint_t arg0);
public static native void sk_paint_set_dither(sk_paint_t arg0, @Cast("bool") boolean arg1);
public static native @Cast("bool") boolean sk_paint_is_verticaltext(@Const sk_paint_t arg0);
public static native void sk_paint_set_verticaltext(sk_paint_t arg0, @Cast("bool") boolean arg1);
public static native sk_shader_t sk_paint_get_shader(sk_paint_t arg0);
public static native sk_maskfilter_t sk_paint_get_maskfilter(sk_paint_t arg0);
public static native void sk_paint_set_colorfilter(sk_paint_t arg0, sk_colorfilter_t arg1);
public static native sk_colorfilter_t sk_paint_get_colorfilter(sk_paint_t arg0);
public static native void sk_paint_set_imagefilter(sk_paint_t arg0, sk_imagefilter_t arg1);
public static native sk_imagefilter_t sk_paint_get_imagefilter(sk_paint_t arg0);
public static native @Cast("sk_blendmode_t") int sk_paint_get_blendmode(sk_paint_t arg0);
public static native void sk_paint_set_filter_quality(sk_paint_t arg0, @Cast("sk_filter_quality_t") int arg1);
public static native @Cast("sk_filter_quality_t") int sk_paint_get_filter_quality(sk_paint_t arg0);
public static native sk_typeface_t sk_paint_get_typeface(sk_paint_t arg0);
public static native void sk_paint_set_typeface(sk_paint_t arg0, sk_typeface_t arg1);
public static native float sk_paint_get_textsize(sk_paint_t arg0);
public static native void sk_paint_set_textsize(sk_paint_t arg0, float arg1);
public static native @Cast("sk_text_align_t") int sk_paint_get_text_align(@Const sk_paint_t arg0);
public static native void sk_paint_set_text_align(sk_paint_t arg0, @Cast("sk_text_align_t") int arg1);
public static native @Cast("sk_text_encoding_t") int sk_paint_get_text_encoding(@Const sk_paint_t arg0);
public static native void sk_paint_set_text_encoding(sk_paint_t arg0, @Cast("sk_text_encoding_t") int arg1);
public static native float sk_paint_get_text_scale_x(@Const sk_paint_t cpaint);
public static native void sk_paint_set_text_scale_x(sk_paint_t cpaint, float scale);
public static native float sk_paint_get_text_skew_x(@Const sk_paint_t cpaint);
public static native void sk_paint_set_text_skew_x(sk_paint_t cpaint, float skew);
public static native @Cast("size_t") long sk_paint_break_text(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long length, float maxWidth, FloatPointer measuredWidth);
public static native @Cast("size_t") long sk_paint_break_text(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long length, float maxWidth, FloatBuffer measuredWidth);
public static native @Cast("size_t") long sk_paint_break_text(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long length, float maxWidth, float[] measuredWidth);
public static native float sk_paint_measure_text(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long length, sk_rect_t cbounds);
public static native sk_path_t sk_paint_get_text_path(sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long length, float x, float y);
public static native sk_path_t sk_paint_get_pos_text_path(sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long length, @Const sk_point_t pos);
public static native float sk_paint_get_fontmetrics(sk_paint_t cpaint, sk_fontmetrics_t cfontmetrics, float scale);
public static native sk_path_effect_t sk_paint_get_path_effect(sk_paint_t cpaint);
public static native void sk_paint_set_path_effect(sk_paint_t cpaint, sk_path_effect_t effect);  
public static native @Cast("bool") boolean sk_paint_is_linear_text(@Const sk_paint_t arg0);
public static native void sk_paint_set_linear_text(sk_paint_t arg0, @Cast("bool") boolean arg1);
public static native @Cast("bool") boolean sk_paint_is_subpixel_text(@Const sk_paint_t arg0);
public static native void sk_paint_set_subpixel_text(sk_paint_t arg0, @Cast("bool") boolean arg1);
public static native @Cast("bool") boolean sk_paint_is_lcd_render_text(@Const sk_paint_t arg0);
public static native void sk_paint_set_lcd_render_text(sk_paint_t arg0, @Cast("bool") boolean arg1);
public static native @Cast("bool") boolean sk_paint_is_embedded_bitmap_text(@Const sk_paint_t arg0);
public static native void sk_paint_set_embedded_bitmap_text(sk_paint_t arg0, @Cast("bool") boolean arg1);
public static native @Cast("sk_paint_hinting_t") int sk_paint_get_hinting(@Const sk_paint_t arg0);
public static native void sk_paint_set_hinting(sk_paint_t arg0, @Cast("sk_paint_hinting_t") int arg1);
public static native @Cast("bool") boolean sk_paint_is_autohinted(@Const sk_paint_t arg0);
public static native void sk_paint_set_autohinted(sk_paint_t arg0, @Cast("bool") boolean arg1);
public static native @Cast("bool") boolean sk_paint_is_fake_bold_text(@Const sk_paint_t arg0);
public static native void sk_paint_set_fake_bold_text(sk_paint_t arg0, @Cast("bool") boolean arg1);
public static native @Cast("bool") boolean sk_paint_is_dev_kern_text(@Const sk_paint_t arg0);
public static native void sk_paint_set_dev_kern_text(sk_paint_t arg0, @Cast("bool") boolean arg1);
public static native @Cast("bool") boolean sk_paint_get_fill_path(@Const sk_paint_t arg0, @Const sk_path_t src, sk_path_t dst, @Const sk_rect_t cullRect, float resScale);
public static native int sk_paint_text_to_glyphs(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long byteLength, @Cast("uint16_t*") ShortPointer glyphs);
public static native int sk_paint_text_to_glyphs(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long byteLength, @Cast("uint16_t*") ShortBuffer glyphs);
public static native int sk_paint_text_to_glyphs(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long byteLength, @Cast("uint16_t*") short[] glyphs);
public static native @Cast("bool") boolean sk_paint_contains_text(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long byteLength);
public static native int sk_paint_count_text(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long byteLength);
public static native int sk_paint_get_text_widths(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long byteLength, FloatPointer widths, sk_rect_t bounds);
public static native int sk_paint_get_text_widths(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long byteLength, FloatBuffer widths, sk_rect_t bounds);
public static native int sk_paint_get_text_widths(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long byteLength, float[] widths, sk_rect_t bounds);
public static native int sk_paint_get_text_intercepts(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long byteLength, float x, float y, @Const FloatPointer bounds, FloatPointer intervals);
public static native int sk_paint_get_text_intercepts(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long byteLength, float x, float y, @Const FloatBuffer bounds, FloatBuffer intervals);
public static native int sk_paint_get_text_intercepts(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long byteLength, float x, float y, @Const float[] bounds, float[] intervals);
public static native int sk_paint_get_pos_text_intercepts(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long byteLength, sk_point_t pos, @Const FloatPointer bounds, FloatPointer intervals);
public static native int sk_paint_get_pos_text_intercepts(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long byteLength, sk_point_t pos, @Const FloatBuffer bounds, FloatBuffer intervals);
public static native int sk_paint_get_pos_text_intercepts(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long byteLength, sk_point_t pos, @Const float[] bounds, float[] intervals);
public static native int sk_paint_get_pos_text_h_intercepts(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long byteLength, FloatPointer xpos, float y, @Const FloatPointer bounds, FloatPointer intervals);
public static native int sk_paint_get_pos_text_h_intercepts(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long byteLength, FloatBuffer xpos, float y, @Const FloatBuffer bounds, FloatBuffer intervals);
public static native int sk_paint_get_pos_text_h_intercepts(@Const sk_paint_t cpaint, @Const Pointer text, @Cast("size_t") long byteLength, float[] xpos, float y, @Const float[] bounds, float[] intervals);
public static native int sk_paint_get_pos_text_blob_intercepts(@Const sk_paint_t cpaint, sk_textblob_t blob, @Const FloatPointer bounds, FloatPointer intervals);
public static native int sk_paint_get_pos_text_blob_intercepts(@Const sk_paint_t cpaint, sk_textblob_t blob, @Const FloatBuffer bounds, FloatBuffer intervals);
public static native int sk_paint_get_pos_text_blob_intercepts(@Const sk_paint_t cpaint, sk_textblob_t blob, @Const float[] bounds, float[] intervals);

// #endif


// Parsed from sk_path.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_path_DEFINED
// #define sk_path_DEFINED

// #include "sk_types.h"

/* Path */
public static native sk_path_t sk_path_new();
public static native void sk_path_delete(sk_path_t arg0);
public static native void sk_path_move_to(sk_path_t arg0, float x, float y);
public static native void sk_path_line_to(sk_path_t arg0, float x, float y);
public static native void sk_path_quad_to(sk_path_t arg0, float x0, float y0, float x1, float y1);
public static native void sk_path_conic_to(sk_path_t arg0, float x0, float y0, float x1, float y1, float w);
public static native void sk_path_cubic_to(sk_path_t arg0, float x0, float y0, float x1, float y1, float x2, float y2);
public static native void sk_path_arc_to(sk_path_t arg0, float rx, float ry, float xAxisRotate, @Cast("sk_path_arc_size_t") int largeArc, @Cast("sk_path_direction_t") int sweep, float x, float y);
public static native void sk_path_rarc_to(sk_path_t arg0, float rx, float ry, float xAxisRotate, @Cast("sk_path_arc_size_t") int largeArc, @Cast("sk_path_direction_t") int sweep, float x, float y);
public static native void sk_path_arc_to_with_oval(sk_path_t arg0, @Const sk_rect_t oval, float startAngle, float sweepAngle, @Cast("bool") boolean forceMoveTo);
public static native void sk_path_arc_to_with_points(sk_path_t arg0, float x1, float y1, float x2, float y2, float radius);
public static native void sk_path_close(sk_path_t arg0);
public static native void sk_path_add_rect(sk_path_t arg0, @Const sk_rect_t arg1, @Cast("sk_path_direction_t") int arg2);
public static native void sk_path_add_rrect(sk_path_t arg0, @Const sk_rrect_t arg1, @Cast("sk_path_direction_t") int arg2);
public static native void sk_path_add_rrect_start(sk_path_t arg0, @Const sk_rrect_t arg1, @Cast("sk_path_direction_t") int arg2, @Cast("uint32_t") int arg3);
public static native void sk_path_add_rounded_rect(sk_path_t arg0, @Const sk_rect_t arg1, float arg2, float arg3, @Cast("sk_path_direction_t") int arg4);
public static native void sk_path_add_oval(sk_path_t arg0, @Const sk_rect_t arg1, @Cast("sk_path_direction_t") int arg2);
public static native void sk_path_add_circle(sk_path_t arg0, float x, float y, float radius, @Cast("sk_path_direction_t") int dir);
public static native void sk_path_get_bounds(@Const sk_path_t arg0, sk_rect_t arg1);
public static native void sk_path_compute_tight_bounds(@Const sk_path_t arg0, sk_rect_t arg1);
public static native void sk_path_rmove_to(sk_path_t arg0, float dx, float dy);
public static native void sk_path_rline_to(sk_path_t arg0, float dx, float yd);
public static native void sk_path_rquad_to(sk_path_t arg0, float dx0, float dy0, float dx1, float dy1);
public static native void sk_path_rconic_to(sk_path_t arg0, float dx0, float dy0, float dx1, float dy1, float w);
public static native void sk_path_rcubic_to(sk_path_t arg0, float dx0, float dy0, float dx1, float dy1, float dx2, float dy2);
public static native void sk_path_add_rect_start(sk_path_t cpath, @Const sk_rect_t crect, @Cast("sk_path_direction_t") int cdir, @Cast("uint32_t") int startIndex);
public static native void sk_path_add_arc(sk_path_t cpath, @Const sk_rect_t crect, float startAngle, float sweepAngle);
public static native @Cast("sk_path_filltype_t") int sk_path_get_filltype(sk_path_t arg0);
public static native void sk_path_set_filltype(sk_path_t arg0, @Cast("sk_path_filltype_t") int arg1);
public static native void sk_path_transform(sk_path_t cpath, @Const sk_matrix_t cmatrix);
public static native sk_path_t sk_path_clone(@Const sk_path_t cpath);
public static native void sk_path_add_path_offset(sk_path_t cpath, sk_path_t other, float dx, float dy, @Cast("sk_path_add_mode_t") int add_mode);
public static native void sk_path_add_path_matrix(sk_path_t cpath, sk_path_t other, sk_matrix_t matrix, @Cast("sk_path_add_mode_t") int add_mode);
public static native void sk_path_add_path(sk_path_t cpath, sk_path_t other, @Cast("sk_path_add_mode_t") int add_mode);
public static native void sk_path_add_path_reverse(sk_path_t cpath, sk_path_t other);
public static native void sk_path_reset(sk_path_t cpath);
public static native void sk_path_rewind(sk_path_t cpath);
public static native int sk_path_count_points(@Const sk_path_t cpath);
public static native int sk_path_count_verbs(@Const sk_path_t cpath);
public static native void sk_path_get_point(@Const sk_path_t cpath, int index, sk_point_t point);
public static native int sk_path_get_points(@Const sk_path_t cpath, sk_point_t points, int max);
public static native @Cast("bool") boolean sk_path_contains(@Const sk_path_t cpath, float x, float y);
public static native @Cast("sk_path_convexity_t") int sk_path_get_convexity(@Const sk_path_t cpath);
public static native void sk_path_set_convexity(sk_path_t cpath, @Cast("sk_path_convexity_t") int convexity);
public static native @Cast("bool") boolean sk_path_parse_svg_string(sk_path_t cpath, @Cast("const char*") BytePointer str);
public static native @Cast("bool") boolean sk_path_parse_svg_string(sk_path_t cpath, String str);
public static native void sk_path_to_svg_string(@Const sk_path_t cpath, sk_string_t str);
public static native @Cast("bool") boolean sk_path_get_last_point(@Const sk_path_t cpath, sk_point_t point);
public static native int sk_path_convert_conic_to_quads(@Const sk_point_t p0, @Const sk_point_t p1, @Const sk_point_t p2, float w, sk_point_t pts, int pow2);
public static native void sk_path_add_poly(sk_path_t cpath, @Const sk_point_t points, int count, @Cast("bool") boolean close);
public static native @Cast("uint32_t") int sk_path_get_segment_masks(sk_path_t cpath);
public static native @Cast("bool") boolean sk_path_is_oval(sk_path_t cpath, sk_rect_t bounds);
public static native @Cast("bool") boolean sk_path_is_rrect(sk_path_t cpath, sk_rrect_t bounds);
public static native @Cast("bool") boolean sk_path_is_line(sk_path_t cpath, sk_point_t line);
public static native @Cast("bool") boolean sk_path_is_rect(sk_path_t cpath, sk_rect_t rect, @Cast("bool*") BoolPointer isClosed, @Cast("sk_path_direction_t*") IntPointer direction);
public static native @Cast("bool") boolean sk_path_is_rect(sk_path_t cpath, sk_rect_t rect, @Cast("bool*") boolean[] isClosed, @Cast("sk_path_direction_t*") IntBuffer direction);
public static native @Cast("bool") boolean sk_path_is_rect(sk_path_t cpath, sk_rect_t rect, @Cast("bool*") BoolPointer isClosed, @Cast("sk_path_direction_t*") int[] direction);
public static native @Cast("bool") boolean sk_path_is_rect(sk_path_t cpath, sk_rect_t rect, @Cast("bool*") boolean[] isClosed, @Cast("sk_path_direction_t*") IntPointer direction);
public static native @Cast("bool") boolean sk_path_is_rect(sk_path_t cpath, sk_rect_t rect, @Cast("bool*") BoolPointer isClosed, @Cast("sk_path_direction_t*") IntBuffer direction);
public static native @Cast("bool") boolean sk_path_is_rect(sk_path_t cpath, sk_rect_t rect, @Cast("bool*") boolean[] isClosed, @Cast("sk_path_direction_t*") int[] direction);

/* Iterators */
public static native sk_path_iterator_t sk_path_create_iter(sk_path_t cpath, int forceClose);
public static native @Cast("sk_path_verb_t") int sk_path_iter_next(sk_path_iterator_t iterator, sk_point_t points, int doConsumeDegenerates, int exact);
public static native float sk_path_iter_conic_weight(sk_path_iterator_t iterator);
public static native int sk_path_iter_is_close_line(sk_path_iterator_t iterator);
public static native int sk_path_iter_is_closed_contour(sk_path_iterator_t iterator);
public static native void sk_path_iter_destroy(sk_path_iterator_t iterator);

/* Raw iterators */
public static native sk_path_rawiterator_t sk_path_create_rawiter(sk_path_t cpath);
public static native @Cast("sk_path_verb_t") int sk_path_rawiter_peek(sk_path_rawiterator_t iterator);
public static native @Cast("sk_path_verb_t") int sk_path_rawiter_next(sk_path_rawiterator_t iterator, sk_point_t points);
public static native float sk_path_rawiter_conic_weight(sk_path_rawiterator_t iterator);
public static native void sk_path_rawiter_destroy(sk_path_rawiterator_t iterator);

/* Path Ops */
public static native @Cast("bool") boolean sk_pathop_op(@Const sk_path_t one, @Const sk_path_t two, @Cast("sk_pathop_t") int op, sk_path_t result);
public static native @Cast("bool") boolean sk_pathop_simplify(@Const sk_path_t path, sk_path_t result);
public static native @Cast("bool") boolean sk_pathop_tight_bounds(@Const sk_path_t path, sk_rect_t result);

/* Path Op Builder */
public static native sk_opbuilder_t sk_opbuilder_new();
public static native void sk_opbuilder_destroy(sk_opbuilder_t builder);
public static native void sk_opbuilder_add(sk_opbuilder_t builder, @Const sk_path_t path, @Cast("sk_pathop_t") int op);
public static native @Cast("bool") boolean sk_opbuilder_resolve(sk_opbuilder_t builder, sk_path_t result);

/* Path Measure */
public static native sk_pathmeasure_t sk_pathmeasure_new();
public static native sk_pathmeasure_t sk_pathmeasure_new_with_path(@Const sk_path_t path, @Cast("bool") boolean forceClosed, float resScale);
public static native void sk_pathmeasure_destroy(sk_pathmeasure_t pathMeasure);
public static native void sk_pathmeasure_set_path(sk_pathmeasure_t pathMeasure, @Const sk_path_t path, @Cast("bool") boolean forceClosed);
public static native float sk_pathmeasure_get_length(sk_pathmeasure_t pathMeasure);
public static native @Cast("bool") boolean sk_pathmeasure_get_pos_tan(sk_pathmeasure_t pathMeasure, float distance, sk_point_t position, @Cast("sk_vector_t*") sk_point_t tangent);
public static native @Cast("bool") boolean sk_pathmeasure_get_matrix(sk_pathmeasure_t pathMeasure, float distance, sk_matrix_t matrix, @Cast("sk_pathmeasure_matrixflags_t") int flags);
public static native @Cast("bool") boolean sk_pathmeasure_get_segment(sk_pathmeasure_t pathMeasure, float start, float stop, sk_path_t dst, @Cast("bool") boolean startWithMoveTo);
public static native @Cast("bool") boolean sk_pathmeasure_is_closed(sk_pathmeasure_t pathMeasure);
public static native @Cast("bool") boolean sk_pathmeasure_next_contour(sk_pathmeasure_t pathMeasure);

// #endif


// Parsed from sk_patheffect.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_patheffect_DEFINED
// #define sk_patheffect_DEFINED

// #include "sk_types.h"

public static native void sk_path_effect_unref(sk_path_effect_t t); 
public static native sk_path_effect_t sk_path_effect_create_compose(sk_path_effect_t outer, sk_path_effect_t inner);
public static native sk_path_effect_t sk_path_effect_create_sum(sk_path_effect_t first, sk_path_effect_t second);
public static native sk_path_effect_t sk_path_effect_create_discrete(float segLength, float deviation, @Cast("uint32_t") int seedAssist);
public static native sk_path_effect_t sk_path_effect_create_corner(float radius);
public static native sk_path_effect_t sk_path_effect_create_1d_path(@Const sk_path_t path, float advance, float phase, @Cast("sk_path_effect_1d_style_t") int style);
public static native sk_path_effect_t sk_path_effect_create_2d_line(float width, @Const sk_matrix_t matrix);
public static native sk_path_effect_t sk_path_effect_create_2d_path(@Const sk_matrix_t matrix, @Const sk_path_t path);
public static native sk_path_effect_t sk_path_effect_create_dash(@Const FloatPointer intervals, int count, float phase);
public static native sk_path_effect_t sk_path_effect_create_dash(@Const FloatBuffer intervals, int count, float phase);
public static native sk_path_effect_t sk_path_effect_create_dash(@Const float[] intervals, int count, float phase);
public static native sk_path_effect_t sk_path_effect_create_trim(float start, float stop, @Cast("sk_path_effect_trim_mode_t") int mode);

// #endif


// Parsed from sk_picture.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_picture_DEFINED
// #define sk_picture_DEFINED

// #include "sk_types.h"

public static native sk_picture_recorder_t sk_picture_recorder_new();
public static native void sk_picture_recorder_delete(sk_picture_recorder_t arg0);
public static native sk_canvas_t sk_picture_recorder_begin_recording(sk_picture_recorder_t arg0, @Const sk_rect_t arg1);
public static native sk_picture_t sk_picture_recorder_end_recording(sk_picture_recorder_t arg0);
public static native sk_canvas_t sk_picture_get_recording_canvas(sk_picture_recorder_t crec);

public static native void sk_picture_ref(sk_picture_t arg0);
public static native void sk_picture_unref(sk_picture_t arg0);
public static native @Cast("uint32_t") int sk_picture_get_unique_id(sk_picture_t arg0);
public static native void sk_picture_get_cull_rect(sk_picture_t arg0, sk_rect_t arg1);

// #endif


// Parsed from sk_pixmap.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_pixmap_DEFINED
// #define sk_pixmap_DEFINED

// #include "sk_types.h"

public static native void sk_pixmap_destructor(sk_pixmap_t cpixmap);
public static native sk_pixmap_t sk_pixmap_new();
public static native sk_pixmap_t sk_pixmap_new_with_params(@Const sk_imageinfo_t cinfo, @Const Pointer addr, @Cast("size_t") long rowBytes);
public static native void sk_pixmap_reset(sk_pixmap_t cpixmap);
public static native void sk_pixmap_reset_with_params(sk_pixmap_t cpixmap, @Const sk_imageinfo_t cinfo, @Const Pointer addr, @Cast("size_t") long rowBytes);
public static native void sk_pixmap_get_info(@Const sk_pixmap_t cpixmap, sk_imageinfo_t cinfo);
public static native @Cast("size_t") long sk_pixmap_get_row_bytes(@Const sk_pixmap_t cpixmap);
public static native @Const Pointer sk_pixmap_get_pixels(@Const sk_pixmap_t cpixmap);
public static native @Const Pointer sk_pixmap_get_pixels_with_xy(@Const sk_pixmap_t cpixmap, int x, int y);
public static native @Cast("sk_color_t") int sk_pixmap_get_pixel_color(@Const sk_pixmap_t cpixmap, int x, int y);
public static native @Cast("bool") boolean sk_pixmap_encode_image(sk_wstream_t dst, @Const sk_pixmap_t src, @Cast("sk_encoded_image_format_t") int encoder, int quality);
public static native @Cast("bool") boolean sk_pixmap_read_pixels(@Const sk_pixmap_t cpixmap, @Const sk_imageinfo_t dstInfo, Pointer dstPixels, @Cast("size_t") long dstRowBytes, int srcX, int srcY, @Cast("sk_transfer_function_behavior_t") int behavior);
public static native @Cast("bool") boolean sk_pixmap_scale_pixels(@Const sk_pixmap_t cpixmap, @Const sk_pixmap_t dst, @Cast("sk_filter_quality_t") int quality);
public static native @Cast("bool") boolean sk_pixmap_extract_subset(@Const sk_pixmap_t cpixmap, sk_pixmap_t result, @Const sk_irect_t subset);
public static native @Cast("bool") boolean sk_pixmap_erase_color(@Const sk_pixmap_t cpixmap, @Cast("sk_color_t") int color, @Const sk_irect_t subset);

public static native @Cast("sk_color_t") int sk_color_unpremultiply(@Cast("const sk_pmcolor_t") int pmcolor);
public static native @Cast("sk_pmcolor_t") int sk_color_premultiply(@Cast("const sk_color_t") int color);
public static native void sk_color_unpremultiply_array(@Cast("const sk_pmcolor_t*") IntPointer pmcolors, int size, @Cast("sk_color_t*") IntPointer colors);
public static native void sk_color_unpremultiply_array(@Cast("const sk_pmcolor_t*") IntBuffer pmcolors, int size, @Cast("sk_color_t*") IntBuffer colors);
public static native void sk_color_unpremultiply_array(@Cast("const sk_pmcolor_t*") int[] pmcolors, int size, @Cast("sk_color_t*") int[] colors);
public static native void sk_color_premultiply_array(@Cast("const sk_color_t*") IntPointer colors, int size, @Cast("sk_pmcolor_t*") IntPointer pmcolors);
public static native void sk_color_premultiply_array(@Cast("const sk_color_t*") IntBuffer colors, int size, @Cast("sk_pmcolor_t*") IntBuffer pmcolors);
public static native void sk_color_premultiply_array(@Cast("const sk_color_t*") int[] colors, int size, @Cast("sk_pmcolor_t*") int[] pmcolors);
public static native void sk_color_get_bit_shift(IntPointer a, IntPointer r, IntPointer g, IntPointer b);
public static native void sk_color_get_bit_shift(IntBuffer a, IntBuffer r, IntBuffer g, IntBuffer b);
public static native void sk_color_get_bit_shift(int[] a, int[] r, int[] g, int[] b);

public static native void sk_swizzle_swap_rb(@Cast("uint32_t*") IntPointer dest, @Cast("const uint32_t*") IntPointer src, int count);
public static native void sk_swizzle_swap_rb(@Cast("uint32_t*") IntBuffer dest, @Cast("const uint32_t*") IntBuffer src, int count);
public static native void sk_swizzle_swap_rb(@Cast("uint32_t*") int[] dest, @Cast("const uint32_t*") int[] src, int count);

public static native @Cast("bool") boolean sk_webpencoder_encode(sk_wstream_t dst, @Const sk_pixmap_t src, @ByVal sk_webpencoder_options_t options);
public static native @Cast("bool") boolean sk_jpegencoder_encode(sk_wstream_t dst, @Const sk_pixmap_t src, @ByVal sk_jpegencoder_options_t options);
public static native @Cast("bool") boolean sk_pngencoder_encode(sk_wstream_t dst, @Const sk_pixmap_t src, @ByVal sk_pngencoder_options_t options);

// #endif


// Parsed from sk_region.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2016 Bluebeam Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_region_DEFINED
// #define sk_region_DEFINED

// #include "sk_types.h"

public static native sk_region_t sk_region_new();
public static native sk_region_t sk_region_new2(@Const sk_region_t region);
public static native void sk_region_delete(sk_region_t cpath); 
public static native void sk_region_contains(sk_region_t r, @Const sk_region_t region); 
public static native void sk_region_contains2(sk_region_t r, int x, int y);
public static native @Cast("bool") boolean sk_region_intersects(sk_region_t r, @Const sk_region_t src); 
public static native @Cast("bool") boolean sk_region_set_path(sk_region_t dst, @Const sk_path_t t, @Const sk_region_t clip);
public static native @Cast("bool") boolean sk_region_set_rect(sk_region_t dst, @Const sk_irect_t rect);
public static native @Cast("bool") boolean sk_region_set_region(sk_region_t r, @Const sk_region_t region);
public static native @Cast("bool") boolean sk_region_op(sk_region_t dst, int left, int top, int right, int bottom, @Cast("sk_region_op_t") int op);
public static native @Cast("bool") boolean sk_region_op2(sk_region_t dst, sk_region_t src, @Cast("sk_region_op_t") int op);
public static native void sk_region_get_bounds(sk_region_t r, sk_irect_t rect);

// #endif


// Parsed from sk_shader.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_shader_DEFINED
// #define sk_shader_DEFINED

// #include "sk_types.h"

public static native void sk_shader_ref(sk_shader_t arg0);
public static native void sk_shader_unref(sk_shader_t arg0);
public static native sk_shader_t sk_shader_new_linear_gradient(@Const sk_point_t points,
                                           @Cast("const sk_color_t*") IntPointer colors,
                                           @Const FloatPointer colorPos,
                                           int colorCount,
                                           @Cast("sk_shader_tilemode_t") int tileMode,
                                           @Const sk_matrix_t localMatrix);
public static native sk_shader_t sk_shader_new_linear_gradient(@Const sk_point_t points,
                                           @Cast("const sk_color_t*") IntBuffer colors,
                                           @Const FloatBuffer colorPos,
                                           int colorCount,
                                           @Cast("sk_shader_tilemode_t") int tileMode,
                                           @Const sk_matrix_t localMatrix);
public static native sk_shader_t sk_shader_new_linear_gradient(@Const sk_point_t points,
                                           @Cast("const sk_color_t*") int[] colors,
                                           @Const float[] colorPos,
                                           int colorCount,
                                           @Cast("sk_shader_tilemode_t") int tileMode,
                                           @Const sk_matrix_t localMatrix);
public static native sk_shader_t sk_shader_new_radial_gradient(@Const sk_point_t center,
                                           float radius,
                                           @Cast("const sk_color_t*") IntPointer colors,
                                           @Const FloatPointer colorPos,
                                           int colorCount,
                                           @Cast("sk_shader_tilemode_t") int tileMode,
                                           @Const sk_matrix_t localMatrix);
public static native sk_shader_t sk_shader_new_radial_gradient(@Const sk_point_t center,
                                           float radius,
                                           @Cast("const sk_color_t*") IntBuffer colors,
                                           @Const FloatBuffer colorPos,
                                           int colorCount,
                                           @Cast("sk_shader_tilemode_t") int tileMode,
                                           @Const sk_matrix_t localMatrix);
public static native sk_shader_t sk_shader_new_radial_gradient(@Const sk_point_t center,
                                           float radius,
                                           @Cast("const sk_color_t*") int[] colors,
                                           @Const float[] colorPos,
                                           int colorCount,
                                           @Cast("sk_shader_tilemode_t") int tileMode,
                                           @Const sk_matrix_t localMatrix);
public static native sk_shader_t sk_shader_new_sweep_gradient(@Const sk_point_t center,
                                          @Cast("const sk_color_t*") IntPointer colors,
                                          @Const FloatPointer colorPos,
                                          int colorCount,
                                          @Cast("sk_shader_tilemode_t") int tileMode,
                                          float startAngle,
                                          float endAngle,
                                          @Const sk_matrix_t localMatrix);
public static native sk_shader_t sk_shader_new_sweep_gradient(@Const sk_point_t center,
                                          @Cast("const sk_color_t*") IntBuffer colors,
                                          @Const FloatBuffer colorPos,
                                          int colorCount,
                                          @Cast("sk_shader_tilemode_t") int tileMode,
                                          float startAngle,
                                          float endAngle,
                                          @Const sk_matrix_t localMatrix);
public static native sk_shader_t sk_shader_new_sweep_gradient(@Const sk_point_t center,
                                          @Cast("const sk_color_t*") int[] colors,
                                          @Const float[] colorPos,
                                          int colorCount,
                                          @Cast("sk_shader_tilemode_t") int tileMode,
                                          float startAngle,
                                          float endAngle,
                                          @Const sk_matrix_t localMatrix);
public static native sk_shader_t sk_shader_new_two_point_conical_gradient(
        @Const sk_point_t start,
        float startRadius,
        @Const sk_point_t end,
        float endRadius,
        @Cast("const sk_color_t*") IntPointer colors,
        @Const FloatPointer colorPos,
        int colorCount,
        @Cast("sk_shader_tilemode_t") int tileMode,
        @Const sk_matrix_t localMatrix);
public static native sk_shader_t sk_shader_new_two_point_conical_gradient(
        @Const sk_point_t start,
        float startRadius,
        @Const sk_point_t end,
        float endRadius,
        @Cast("const sk_color_t*") IntBuffer colors,
        @Const FloatBuffer colorPos,
        int colorCount,
        @Cast("sk_shader_tilemode_t") int tileMode,
        @Const sk_matrix_t localMatrix);
public static native sk_shader_t sk_shader_new_two_point_conical_gradient(
        @Const sk_point_t start,
        float startRadius,
        @Const sk_point_t end,
        float endRadius,
        @Cast("const sk_color_t*") int[] colors,
        @Const float[] colorPos,
        int colorCount,
        @Cast("sk_shader_tilemode_t") int tileMode,
        @Const sk_matrix_t localMatrix);
public static native sk_shader_t sk_shader_new_empty();
public static native sk_shader_t sk_shader_new_color(@Cast("sk_color_t") int color);
public static native sk_shader_t sk_shader_new_bitmap(@Const sk_bitmap_t src,
                                         @Cast("sk_shader_tilemode_t") int tmx,
                                         @Cast("sk_shader_tilemode_t") int tmy,
                                         @Const sk_matrix_t localMatrix);
public static native sk_shader_t sk_shader_new_picture(sk_picture_t src,
                                         @Cast("sk_shader_tilemode_t") int tmx,
                                         @Cast("sk_shader_tilemode_t") int tmy,
                                         @Const sk_matrix_t localMatrix,
                                         @Const sk_rect_t tile);
public static native sk_shader_t sk_shader_new_local_matrix(sk_shader_t proxy, @Const sk_matrix_t localMatrix);
public static native sk_shader_t sk_shader_new_color_filter(sk_shader_t proxy, sk_colorfilter_t filter);
public static native sk_shader_t sk_shader_new_perlin_noise_fractal_noise(
    float baseFrequencyX,
    float baseFrequencyY,
    int numOctaves,
    float seed,
    @Const sk_isize_t tileSize);
public static native sk_shader_t sk_shader_new_perlin_noise_turbulence(
    float baseFrequencyX,
    float baseFrequencyY,
    int numOctaves,
    float seed,
    @Const sk_isize_t tileSize);
public static native sk_shader_t sk_shader_new_compose(
    sk_shader_t shaderA,
    sk_shader_t shaderB);
public static native sk_shader_t sk_shader_new_compose_with_mode(
    sk_shader_t shaderA,
    sk_shader_t shaderB,
    @Cast("sk_blendmode_t") int mode);

// #endif


// Parsed from sk_stream.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_stream_DEFINED
// #define sk_stream_DEFINED

// #include "sk_types.h"

public static native void sk_stream_asset_destroy(sk_stream_asset_t cstream);

////////////////////////////////////////////////////////////////////////////////

public static native sk_stream_filestream_t sk_filestream_new(@Cast("const char*") BytePointer path);
public static native sk_stream_filestream_t sk_filestream_new(String path);
public static native void sk_filestream_destroy(sk_stream_filestream_t cstream);
public static native @Cast("bool") boolean sk_filestream_is_valid(sk_stream_filestream_t cstream);

////////////////////////////////////////////////////////////////////////////////

public static native sk_stream_memorystream_t sk_memorystream_new();
public static native sk_stream_memorystream_t sk_memorystream_new_with_length(@Cast("size_t") long length);
public static native sk_stream_memorystream_t sk_memorystream_new_with_data(@Const Pointer data, @Cast("size_t") long length, @Cast("bool") boolean copyData);
public static native sk_stream_memorystream_t sk_memorystream_new_with_skdata(sk_data_t data);
public static native void sk_memorystream_set_memory(sk_stream_memorystream_t cmemorystream, @Const Pointer data, @Cast("size_t") long length, @Cast("bool") boolean copyData);
public static native void sk_memorystream_destroy(sk_stream_memorystream_t cstream);

////////////////////////////////////////////////////////////////////////////////

public static native @Cast("size_t") long sk_stream_read(sk_stream_t cstream, Pointer buffer, @Cast("size_t") long size);
public static native @Cast("size_t") long sk_stream_peek(sk_stream_t cstream, Pointer buffer, @Cast("size_t") long size);
public static native @Cast("size_t") long sk_stream_skip(sk_stream_t cstream, @Cast("size_t") long size);
public static native @Cast("bool") boolean sk_stream_is_at_end(sk_stream_t cstream);
public static native @Cast("bool") boolean sk_stream_read_s8(sk_stream_t cstream, BytePointer buffer);
public static native @Cast("bool") boolean sk_stream_read_s8(sk_stream_t cstream, ByteBuffer buffer);
public static native @Cast("bool") boolean sk_stream_read_s8(sk_stream_t cstream, byte[] buffer);
public static native @Cast("bool") boolean sk_stream_read_s16(sk_stream_t cstream, ShortPointer buffer);
public static native @Cast("bool") boolean sk_stream_read_s16(sk_stream_t cstream, ShortBuffer buffer);
public static native @Cast("bool") boolean sk_stream_read_s16(sk_stream_t cstream, short[] buffer);
public static native @Cast("bool") boolean sk_stream_read_s32(sk_stream_t cstream, IntPointer buffer);
public static native @Cast("bool") boolean sk_stream_read_s32(sk_stream_t cstream, IntBuffer buffer);
public static native @Cast("bool") boolean sk_stream_read_s32(sk_stream_t cstream, int[] buffer);
public static native @Cast("bool") boolean sk_stream_read_u8(sk_stream_t cstream, @Cast("uint8_t*") BytePointer buffer);
public static native @Cast("bool") boolean sk_stream_read_u8(sk_stream_t cstream, @Cast("uint8_t*") ByteBuffer buffer);
public static native @Cast("bool") boolean sk_stream_read_u8(sk_stream_t cstream, @Cast("uint8_t*") byte[] buffer);
public static native @Cast("bool") boolean sk_stream_read_u16(sk_stream_t cstream, @Cast("uint16_t*") ShortPointer buffer);
public static native @Cast("bool") boolean sk_stream_read_u16(sk_stream_t cstream, @Cast("uint16_t*") ShortBuffer buffer);
public static native @Cast("bool") boolean sk_stream_read_u16(sk_stream_t cstream, @Cast("uint16_t*") short[] buffer);
public static native @Cast("bool") boolean sk_stream_read_u32(sk_stream_t cstream, @Cast("uint32_t*") IntPointer buffer);
public static native @Cast("bool") boolean sk_stream_read_u32(sk_stream_t cstream, @Cast("uint32_t*") IntBuffer buffer);
public static native @Cast("bool") boolean sk_stream_read_u32(sk_stream_t cstream, @Cast("uint32_t*") int[] buffer);
public static native @Cast("bool") boolean sk_stream_read_bool(sk_stream_t cstream, @Cast("bool*") BoolPointer buffer);
public static native @Cast("bool") boolean sk_stream_read_bool(sk_stream_t cstream, @Cast("bool*") boolean[] buffer);
public static native @Cast("bool") boolean sk_stream_rewind(sk_stream_t cstream);
public static native @Cast("bool") boolean sk_stream_has_position(sk_stream_t cstream);
public static native @Cast("size_t") long sk_stream_get_position(sk_stream_t cstream);
public static native @Cast("bool") boolean sk_stream_seek(sk_stream_t cstream, @Cast("size_t") long position);
public static native @Cast("bool") boolean sk_stream_move(sk_stream_t cstream, long offset);
public static native @Cast("bool") boolean sk_stream_has_length(sk_stream_t cstream);
public static native @Cast("size_t") long sk_stream_get_length(sk_stream_t cstream);
public static native @Const Pointer sk_stream_get_memory_base(sk_stream_t cstream);

////////////////////////////////////////////////////////////////////////////////

public static native sk_wstream_filestream_t sk_filewstream_new(@Cast("const char*") BytePointer path);
public static native sk_wstream_filestream_t sk_filewstream_new(String path);
public static native void sk_filewstream_destroy(sk_wstream_filestream_t cstream);
public static native @Cast("bool") boolean sk_filewstream_is_valid(sk_wstream_filestream_t cstream);

public static native sk_wstream_dynamicmemorystream_t sk_dynamicmemorywstream_new();
public static native sk_stream_asset_t sk_dynamicmemorywstream_detach_as_stream(sk_wstream_dynamicmemorystream_t cstream);
public static native sk_data_t sk_dynamicmemorywstream_detach_as_data(sk_wstream_dynamicmemorystream_t cstream);
public static native void sk_dynamicmemorywstream_copy_to(sk_wstream_dynamicmemorystream_t cstream, Pointer data);
public static native @Cast("bool") boolean sk_dynamicmemorywstream_write_to_stream(sk_wstream_dynamicmemorystream_t cstream, sk_wstream_t dst);
public static native void sk_dynamicmemorywstream_destroy(sk_wstream_dynamicmemorystream_t cstream);

////////////////////////////////////////////////////////////////////////////////

public static native @Cast("bool") boolean sk_wstream_write(sk_wstream_t cstream, @Const Pointer buffer, @Cast("size_t") long size);
public static native @Cast("bool") boolean sk_wstream_newline(sk_wstream_t cstream);
public static native void sk_wstream_flush(sk_wstream_t cstream);
public static native @Cast("size_t") long sk_wstream_bytes_written(sk_wstream_t cstream);
public static native @Cast("bool") boolean sk_wstream_write_8(sk_wstream_t cstream, @Cast("uint8_t") byte value);
public static native @Cast("bool") boolean sk_wstream_write_16(sk_wstream_t cstream, @Cast("uint16_t") short value);
public static native @Cast("bool") boolean sk_wstream_write_32(sk_wstream_t cstream, @Cast("uint32_t") int value);
public static native @Cast("bool") boolean sk_wstream_write_text(sk_wstream_t cstream, @Cast("const char*") BytePointer value);
public static native @Cast("bool") boolean sk_wstream_write_text(sk_wstream_t cstream, String value);
public static native @Cast("bool") boolean sk_wstream_write_dec_as_text(sk_wstream_t cstream, int value);
public static native @Cast("bool") boolean sk_wstream_write_bigdec_as_text(sk_wstream_t cstream, @Cast("int64_t") long value, int minDigits);
public static native @Cast("bool") boolean sk_wstream_write_hex_as_text(sk_wstream_t cstream, @Cast("uint32_t") int value, int minDigits);
public static native @Cast("bool") boolean sk_wstream_write_scalar_as_text(sk_wstream_t cstream, float value);
public static native @Cast("bool") boolean sk_wstream_write_bool(sk_wstream_t cstream, @Cast("bool") boolean value);
public static native @Cast("bool") boolean sk_wstream_write_scalar(sk_wstream_t cstream, float value);
public static native @Cast("bool") boolean sk_wstream_write_packed_uint(sk_wstream_t cstream, @Cast("size_t") long value);
public static native @Cast("bool") boolean sk_wstream_write_stream(sk_wstream_t cstream, sk_stream_t input, @Cast("size_t") long length);
public static native int sk_wstream_get_size_of_packed_uint(@Cast("size_t") long value);

// #endif


// Parsed from sk_string.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_string_DEFINED
// #define sk_string_DEFINED

// #include "sk_types.h"

public static native sk_string_t sk_string_new_empty();
public static native sk_string_t sk_string_new_with_copy(@Cast("const char*") BytePointer src, @Cast("size_t") long length);
public static native sk_string_t sk_string_new_with_copy(String src, @Cast("size_t") long length);
public static native void sk_string_destructor(@Const sk_string_t arg0);
public static native @Cast("size_t") long sk_string_get_size(@Const sk_string_t arg0);
public static native @Cast("const char*") BytePointer sk_string_get_c_str(@Const sk_string_t arg0);

// #endif


// Parsed from sk_surface.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_surface_DEFINED
// #define sk_surface_DEFINED

// #include "sk_types.h"

public static native @Cast("sk_colortype_t") int sk_colortype_get_default_8888();

// surface

public static native sk_surface_t sk_surface_new_null(int width, int height);
public static native sk_surface_t sk_surface_new_raster(@Const sk_imageinfo_t arg0, @Cast("size_t") long rowBytes, @Const sk_surfaceprops_t arg2);
public static native sk_surface_t sk_surface_new_raster_direct(@Const sk_imageinfo_t arg0, Pointer pixels, @Cast("size_t") long rowBytes, sk_surface_raster_release_proc releaseProc, Pointer context, @Const sk_surfaceprops_t props);

public static native sk_surface_t sk_surface_new_backend_texture(gr_context_t context, @Const gr_backendtexture_t texture, @Cast("gr_surfaceorigin_t") int origin, int samples, @Cast("sk_colortype_t") int colorType, sk_colorspace_t colorspace, @Const sk_surfaceprops_t props);
public static native sk_surface_t sk_surface_new_backend_render_target(gr_context_t context, @Const gr_backendrendertarget_t target, @Cast("gr_surfaceorigin_t") int origin, @Cast("sk_colortype_t") int colorType, sk_colorspace_t colorspace, @Const sk_surfaceprops_t props);
public static native sk_surface_t sk_surface_new_backend_texture_as_render_target(gr_context_t context, @Const gr_backendtexture_t texture, @Cast("gr_surfaceorigin_t") int origin, int samples, @Cast("sk_colortype_t") int colorType, sk_colorspace_t colorspace, @Const sk_surfaceprops_t props);
public static native sk_surface_t sk_surface_new_render_target(gr_context_t context, @Cast("bool") boolean budgeted, @Const sk_imageinfo_t cinfo, int sampleCount, @Cast("gr_surfaceorigin_t") int origin, @Const sk_surfaceprops_t props, @Cast("bool") boolean shouldCreateWithMips);

public static native void sk_surface_unref(sk_surface_t arg0);
public static native sk_canvas_t sk_surface_get_canvas(sk_surface_t arg0);
public static native sk_image_t sk_surface_new_image_snapshot(sk_surface_t arg0);
public static native void sk_surface_draw(sk_surface_t surface, sk_canvas_t canvas, float x, float y, @Const sk_paint_t paint);
public static native @Cast("bool") boolean sk_surface_peek_pixels(sk_surface_t surface, sk_pixmap_t pixmap);
public static native @Cast("bool") boolean sk_surface_read_pixels(sk_surface_t surface, sk_imageinfo_t dstInfo, Pointer dstPixels, @Cast("size_t") long dstRowBytes, int srcX, int srcY);
public static native @Const sk_surfaceprops_t sk_surface_get_props(sk_surface_t surface);

// surface props

public static native sk_surfaceprops_t sk_surfaceprops_new(@Cast("uint32_t") int flags, @Cast("sk_pixelgeometry_t") int geometry);
public static native void sk_surfaceprops_delete(sk_surfaceprops_t props);
public static native @Cast("uint32_t") int sk_surfaceprops_get_flags(sk_surfaceprops_t props);
public static native @Cast("sk_pixelgeometry_t") int sk_surfaceprops_get_pixel_geometry(sk_surfaceprops_t props);

// #endif


// Parsed from sk_svg.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_svg_DEFINED
// #define sk_svg_DEFINED

// #include "sk_types.h"

public static native sk_canvas_t sk_svgcanvas_create(@Const sk_rect_t bounds, sk_xmlwriter_t writer);

// #endif


// Parsed from sk_typeface.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_typeface_DEFINED
// #define sk_typeface_DEFINED

// #include "sk_types.h"

// typeface

public static native sk_typeface_t sk_typeface_create_default();
public static native sk_typeface_t sk_typeface_ref_default();
public static native sk_typeface_t sk_typeface_create_from_name_with_font_style(@Cast("const char*") BytePointer familyName, sk_fontstyle_t style);
public static native sk_typeface_t sk_typeface_create_from_name_with_font_style(String familyName, sk_fontstyle_t style);
public static native void sk_typeface_unref(sk_typeface_t arg0);
public static native sk_typeface_t sk_typeface_create_from_file(@Cast("const char*") BytePointer path, int index);
public static native sk_typeface_t sk_typeface_create_from_file(String path, int index);
public static native sk_typeface_t sk_typeface_create_from_stream(sk_stream_asset_t stream, int index);
public static native int sk_typeface_chars_to_glyphs(sk_typeface_t typeface, @Cast("const char*") BytePointer chars, @Cast("sk_encoding_t") int encoding, @Cast("uint16_t*") ShortPointer glyphs, int glyphCount);
public static native int sk_typeface_chars_to_glyphs(sk_typeface_t typeface, String chars, @Cast("sk_encoding_t") int encoding, @Cast("uint16_t*") ShortBuffer glyphs, int glyphCount);
public static native int sk_typeface_chars_to_glyphs(sk_typeface_t typeface, @Cast("const char*") BytePointer chars, @Cast("sk_encoding_t") int encoding, @Cast("uint16_t*") short[] glyphs, int glyphCount);
public static native int sk_typeface_chars_to_glyphs(sk_typeface_t typeface, String chars, @Cast("sk_encoding_t") int encoding, @Cast("uint16_t*") ShortPointer glyphs, int glyphCount);
public static native int sk_typeface_chars_to_glyphs(sk_typeface_t typeface, @Cast("const char*") BytePointer chars, @Cast("sk_encoding_t") int encoding, @Cast("uint16_t*") ShortBuffer glyphs, int glyphCount);
public static native int sk_typeface_chars_to_glyphs(sk_typeface_t typeface, String chars, @Cast("sk_encoding_t") int encoding, @Cast("uint16_t*") short[] glyphs, int glyphCount);
public static native sk_stream_asset_t sk_typeface_open_stream(sk_typeface_t typeface, IntPointer ttcIndex);
public static native sk_stream_asset_t sk_typeface_open_stream(sk_typeface_t typeface, IntBuffer ttcIndex);
public static native sk_stream_asset_t sk_typeface_open_stream(sk_typeface_t typeface, int[] ttcIndex);
public static native int sk_typeface_get_units_per_em(sk_typeface_t typeface);
public static native sk_string_t sk_typeface_get_family_name(sk_typeface_t typeface);
public static native sk_fontstyle_t sk_typeface_get_fontstyle(sk_typeface_t typeface);
public static native int sk_typeface_get_font_weight(sk_typeface_t typeface);
public static native int sk_typeface_get_font_width(sk_typeface_t typeface);
public static native @Cast("sk_font_style_slant_t") int sk_typeface_get_font_slant(sk_typeface_t typeface);
public static native int sk_typeface_count_tables(sk_typeface_t typeface);
public static native int sk_typeface_get_table_tags(sk_typeface_t typeface, @Cast("sk_font_table_tag_t*") IntPointer tags);
public static native int sk_typeface_get_table_tags(sk_typeface_t typeface, @Cast("sk_font_table_tag_t*") IntBuffer tags);
public static native int sk_typeface_get_table_tags(sk_typeface_t typeface, @Cast("sk_font_table_tag_t*") int[] tags);
public static native @Cast("size_t") long sk_typeface_get_table_size(sk_typeface_t typeface, @Cast("sk_font_table_tag_t") int tag);
public static native @Cast("size_t") long sk_typeface_get_table_data(sk_typeface_t typeface, @Cast("sk_font_table_tag_t") int tag, @Cast("size_t") long offset, @Cast("size_t") long length, Pointer data);

// font manager

public static native sk_fontmgr_t sk_fontmgr_create_default();
public static native sk_fontmgr_t sk_fontmgr_ref_default();
public static native void sk_fontmgr_unref(sk_fontmgr_t arg0);
public static native int sk_fontmgr_count_families(sk_fontmgr_t arg0);
public static native void sk_fontmgr_get_family_name(sk_fontmgr_t arg0, int index, sk_string_t familyName);
public static native sk_fontstyleset_t sk_fontmgr_create_styleset(sk_fontmgr_t arg0, int index);
public static native sk_fontstyleset_t sk_fontmgr_match_family(sk_fontmgr_t arg0, @Cast("const char*") BytePointer familyName);
public static native sk_fontstyleset_t sk_fontmgr_match_family(sk_fontmgr_t arg0, String familyName);
public static native sk_typeface_t sk_fontmgr_match_family_style(sk_fontmgr_t arg0, @Cast("const char*") BytePointer familyName, sk_fontstyle_t style);
public static native sk_typeface_t sk_fontmgr_match_family_style(sk_fontmgr_t arg0, String familyName, sk_fontstyle_t style);
public static native sk_typeface_t sk_fontmgr_match_family_style_character(sk_fontmgr_t arg0, @Cast("const char*") BytePointer familyName, sk_fontstyle_t style, @Cast("const char**") PointerPointer bcp47, int bcp47Count, int character);
public static native sk_typeface_t sk_fontmgr_match_family_style_character(sk_fontmgr_t arg0, @Cast("const char*") BytePointer familyName, sk_fontstyle_t style, @Cast("const char**") @ByPtrPtr BytePointer bcp47, int bcp47Count, int character);
public static native sk_typeface_t sk_fontmgr_match_family_style_character(sk_fontmgr_t arg0, String familyName, sk_fontstyle_t style, @Cast("const char**") @ByPtrPtr ByteBuffer bcp47, int bcp47Count, int character);
public static native sk_typeface_t sk_fontmgr_match_family_style_character(sk_fontmgr_t arg0, @Cast("const char*") BytePointer familyName, sk_fontstyle_t style, @Cast("const char**") @ByPtrPtr byte[] bcp47, int bcp47Count, int character);
public static native sk_typeface_t sk_fontmgr_match_family_style_character(sk_fontmgr_t arg0, String familyName, sk_fontstyle_t style, @Cast("const char**") @ByPtrPtr BytePointer bcp47, int bcp47Count, int character);
public static native sk_typeface_t sk_fontmgr_match_family_style_character(sk_fontmgr_t arg0, @Cast("const char*") BytePointer familyName, sk_fontstyle_t style, @Cast("const char**") @ByPtrPtr ByteBuffer bcp47, int bcp47Count, int character);
public static native sk_typeface_t sk_fontmgr_match_family_style_character(sk_fontmgr_t arg0, String familyName, sk_fontstyle_t style, @Cast("const char**") @ByPtrPtr byte[] bcp47, int bcp47Count, int character);
public static native sk_typeface_t sk_fontmgr_match_face_style(sk_fontmgr_t arg0, @Const sk_typeface_t face, sk_fontstyle_t style);
public static native sk_typeface_t sk_fontmgr_create_from_data(sk_fontmgr_t arg0, sk_data_t data, int index);
public static native sk_typeface_t sk_fontmgr_create_from_stream(sk_fontmgr_t arg0, sk_stream_asset_t stream, int index);
public static native sk_typeface_t sk_fontmgr_create_from_file(sk_fontmgr_t arg0, @Cast("const char*") BytePointer path, int index);
public static native sk_typeface_t sk_fontmgr_create_from_file(sk_fontmgr_t arg0, String path, int index);

// font style

public static native sk_fontstyle_t sk_fontstyle_new(int weight, int width, @Cast("sk_font_style_slant_t") int slant);
public static native void sk_fontstyle_delete(sk_fontstyle_t fs);
public static native int sk_fontstyle_get_weight(@Const sk_fontstyle_t fs);
public static native int sk_fontstyle_get_width(@Const sk_fontstyle_t fs);
public static native @Cast("sk_font_style_slant_t") int sk_fontstyle_get_slant(@Const sk_fontstyle_t fs);

// font style set

public static native sk_fontstyleset_t sk_fontstyleset_create_empty();
public static native void sk_fontstyleset_unref(sk_fontstyleset_t fss);
public static native int sk_fontstyleset_get_count(sk_fontstyleset_t fss);
public static native void sk_fontstyleset_get_style(sk_fontstyleset_t fss, int index, sk_fontstyle_t fs, sk_string_t style);
public static native sk_typeface_t sk_fontstyleset_create_typeface(sk_fontstyleset_t fss, int index);
public static native sk_typeface_t sk_fontstyleset_match_style(sk_fontstyleset_t fss, sk_fontstyle_t style);

// #endif


// Parsed from sk_vertices.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_vertices_DEFINED
// #define sk_vertices_DEFINED

// #include "sk_types.h"

public static native void sk_vertices_unref(sk_vertices_t cvertices);
public static native sk_vertices_t sk_vertices_make_copy(@Cast("sk_vertices_vertex_mode_t") int vmode, int vertexCount, @Const sk_point_t positions, @Const sk_point_t texs, @Cast("const sk_color_t*") IntPointer colors, int indexCount, @Cast("const uint16_t*") ShortPointer indices);
public static native sk_vertices_t sk_vertices_make_copy(@Cast("sk_vertices_vertex_mode_t") int vmode, int vertexCount, @Const sk_point_t positions, @Const sk_point_t texs, @Cast("const sk_color_t*") IntBuffer colors, int indexCount, @Cast("const uint16_t*") ShortBuffer indices);
public static native sk_vertices_t sk_vertices_make_copy(@Cast("sk_vertices_vertex_mode_t") int vmode, int vertexCount, @Const sk_point_t positions, @Const sk_point_t texs, @Cast("const sk_color_t*") int[] colors, int indexCount, @Cast("const uint16_t*") short[] indices);

// #endif


// Parsed from sk_xml.h

/*
 * Copyright 2014 Google Inc.
 * Copyright 2015 Xamarin Inc.
 * Copyright 2017 Microsoft Corporation. All rights reserved.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// #ifndef sk_xml_DEFINED
// #define sk_xml_DEFINED

// #include "sk_types.h"

public static native sk_xmlstreamwriter_t sk_xmlstreamwriter_new(sk_wstream_t stream);
public static native void sk_xmlstreamwriter_delete(sk_xmlstreamwriter_t writer);

// #endif


}
