// Targeted by JavaCPP version 1.5: DO NOT EDIT THIS FILE

package org.bytedeco.spinnaker.Spinnaker_C;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.spinnaker.global.Spinnaker_C.*;


/**
* Options for saving JPEG images. Used in saving PPM images
* with a call to spinImageSaveJpeg().
*/
@Properties(inherit = org.bytedeco.spinnaker.presets.Spinnaker_C.class)
public class spinJPEGOption extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public spinJPEGOption() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public spinJPEGOption(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public spinJPEGOption(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public spinJPEGOption position(long position) {
        return (spinJPEGOption)super.position(position);
    }

    /** Whether to save as a progressive JPEG file. */
    public native @Cast("bool8_t") byte progressive(); public native spinJPEGOption progressive(byte setter);
    /**
    * JPEG image quality in range (0-100).
    * - 100 - Superb quality.
    * - 75  - Good quality.
    * - 50  - Normal quality.
    * - 10  - Poor quality.
    */
    public native @Cast("unsigned int") int quality(); public native spinJPEGOption quality(int setter);
    /** Reserved for future use. */
    public native @Cast("unsigned int") int reserved(int i); public native spinJPEGOption reserved(int i, int setter);
    @MemberGetter public native @Cast("unsigned int*") IntPointer reserved();
    /*
    _spinJPEGOption()
    {
        progressive = false;
        quality = 75;
        memset(reserved, 0, sizeof(reserved));
    }*/
}
