// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.spinnaker.Spinnaker_C;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.spinnaker.global.Spinnaker_C.*;


/*@}*/

/**
 * \defgroup SpinnakerStructC Spinnaker C Structures
 *
 * Spinnaker C structure definitions
 */
/*@{*/

/**
 * Options for saving PNG images. Used in saving PNG images
 * with a call to spinImageSavePng().
 */
@Properties(inherit = org.bytedeco.spinnaker.presets.Spinnaker_C.class)
public class spinPNGOption extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public spinPNGOption() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public spinPNGOption(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public spinPNGOption(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public spinPNGOption position(long position) {
        return (spinPNGOption)super.position(position);
    }

    /** Whether to save the PNG as interlaced. */
    public native @Cast("bool8_t") byte interlaced(); public native spinPNGOption interlaced(byte setter);
    /** Compression level (0-9). 0 is no compression, 9 is best compression. */
    public native @Cast("unsigned int") int compressionLevel(); public native spinPNGOption compressionLevel(int setter);
    /** Reserved for future use. */
    public native @Cast("unsigned int") int reserved(int i); public native spinPNGOption reserved(int i, int setter);
    @MemberGetter public native @Cast("unsigned int*") IntPointer reserved();
    /*
    _spinPNGOption()
    {
        interlaced = FALSE;
        compressionLevel = 6;
        memset(reserved, 0, sizeof(reserved));
    }*/
}
