// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.spinnaker.global;

import org.bytedeco.spinnaker.Spinnaker_C.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class Spinnaker_C extends org.bytedeco.spinnaker.presets.Spinnaker_C {
    static { Loader.load(); }

// Parsed from <SpinnakerPlatformC.h>

//=============================================================================
// Copyright (c) 2001-2019 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

// #ifndef FLIR_SPINNAKER_PLATFORM_C_H
// #define FLIR_SPINNAKER_PLATFORM_C_H

// #if defined(_WIN32) || defined(_WIN64)

// Windows 32-bit and 64-bit
// #if defined(_MSC_VER) && _MSC_VER >= 1600 /* VS2010 provides stdint.h */
// #include <stdint.h>
// #elif !defined _STDINT_H && !defined _STDINT
/* stdint.h is usually not available under Windows */
// #endif
// #else

// Linux and all others
// #include <stdint.h>
// #endif

// #include <stddef.h>

/* Function declaration modifiers */
// #if defined(_WIN32) || defined(_WIN64)

// Windows 32-bit and 64-bit
// #ifndef SPINC_NO_DECLSPEC_STATEMENTS
// #else
// #define SPINC_IMPORT_EXPORT
// #endif /* #  ifndef GCTLI_NO_DECLSPEC_STATEMENTS */
// #ifndef _M_X64
// #define SPINC_CALLTYPE __stdcall
// #else
// #define SPINC_CALLTYPE /* default */
// #endif
// #ifndef EXTERN_C
// #endif

// #elif defined(__GNUC__) && (__GNUC__ >= 4) && (defined(__linux__) || defined(__APPLE__))

// Linux
// #define SPINC_IMPORT_EXPORT __attribute__((visibility("default")))

// #ifdef __x86_64
// Linux x64
// #define SPINC_CALLTYPE /* default */
// #else
// #ifdef __aarch64__
// Linux arm64
// #define SPINC_CALLTYPE /* default */
// #elif defined(__ARM_ARCH)
// Linux armhf
// #define SPINC_CALLTYPE /* default */
// #else
// Linux x86 and APPLE
// #define SPINC_CALLTYPE __attribute__((stdcall))
// #endif
// #endif

// #ifndef EXTERN_C
// #endif

// #else

// #error Unknown platform, file needs adaptation
// #endif

// Helper to deprecate functions and methods
// For C++14
// #if __cplusplus >= 201402L
// #if defined(__has_cpp_attribute)
// #if __has_cpp_attribute(deprecated)
// #define SPINNAKERC_API_DEPRECATED(msg, func) [[deprecated(msg)]] SPINC_IMPORT_EXPORT spinError SPINC_CALLTYPE func
// #endif
// #endif
// For other C++ versions
// #else
// #ifdef __GNUC__
// #define SPINNAKERC_API_DEPRECATED(msg, func)
//     SPINC_IMPORT_EXPORT spinError SPINC_CALLTYPE func __attribute__((deprecated(msg)))
// #elif defined(_MSC_VER)
// #define SPINNAKERC_API_DEPRECATED(msg, func)
//     __declspec(deprecated(msg)) SPINC_IMPORT_EXPORT spinError SPINC_CALLTYPE func
// #endif
// #endif

/* C API Interface Functions */
// #define SPINNAKERC_API SPINC_IMPORT_EXPORT spinError SPINC_CALLTYPE

// #endif // FLIR_SPINNAKER_PLATFORM_C_H

// Parsed from <SpinnakerDefsC.h>

//=============================================================================
// Copyright (c) 2001-2019 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

// #ifndef FLIR_SPINNAKER_DEFS_C_H
// #define FLIR_SPINNAKER_DEFS_C_H

// #include "SpinnakerPlatformC.h"
// #include <memory.h>

/**
 * \defgroup SpinnakerDefsC Spinnaker C Definitions
 * \ingroup SpinnakerC
 *
 * Definitions for Spinnaker C API
 *
 * Holds enumerations, typedefs and structures that are used across the
 * Spinnaker C API wrapper.
 */
/*@{*/
@MemberGetter public static native @Cast("const bool8_t") byte False();
public static final byte False = False();
@MemberGetter public static native @Cast("const bool8_t") byte True();
public static final byte True = True();
// Targeting ..\Spinnaker_C\spinSystem.java


// Targeting ..\Spinnaker_C\spinInterfaceList.java


// Targeting ..\Spinnaker_C\spinInterface.java


// Targeting ..\Spinnaker_C\spinCameraList.java


// Targeting ..\Spinnaker_C\spinCamera.java


// Targeting ..\Spinnaker_C\spinImage.java


// Targeting ..\Spinnaker_C\spinImageStatistics.java


// Targeting ..\Spinnaker_C\spinDeviceEvent.java


// Targeting ..\Spinnaker_C\spinImageEvent.java


// Targeting ..\Spinnaker_C\spinArrivalEvent.java


// Targeting ..\Spinnaker_C\spinRemovalEvent.java


// Targeting ..\Spinnaker_C\spinInterfaceEvent.java


// Targeting ..\Spinnaker_C\spinLogEvent.java


// Targeting ..\Spinnaker_C\spinLogEventData.java


// Targeting ..\Spinnaker_C\spinDeviceEventData.java


// Targeting ..\Spinnaker_C\spinAVIRecorder.java


// Targeting ..\Spinnaker_C\spinVideo.java


// Targeting ..\Spinnaker_C\spinDeviceEventFunction.java


// Targeting ..\Spinnaker_C\spinImageEventFunction.java


// Targeting ..\Spinnaker_C\spinArrivalEventFunction.java


// Targeting ..\Spinnaker_C\spinRemovalEventFunction.java


// Targeting ..\Spinnaker_C\spinLogEventFunction.java



/*@}*/

/**
 * \defgroup SpinnakerEnumsC Spinnaker C Enumerations
 *
 * Spinnaker C enumumeration definitions
 */
/*@{*/

/**
 * The error codes used in Spinnaker C.  These codes are returned from every
 * function in Spinnaker C.
 */

/** The error codes in the range of -2000 to -2999 are reserved
 * for GenICam related errors.  The error codes in the range of -3000 to -3999
 * are reserved for image processing related errors.
 */
public enum _spinError {
    /**
     * An error code of 0 means that the function has run without error.
     */
    SPINNAKER_ERR_SUCCESS(0),

    /**
     * The error codes in the range of -1000 to -1999 are reserved for
     * Spinnaker exceptions.
     */
    SPINNAKER_ERR_ERROR(-1001),
    SPINNAKER_ERR_NOT_INITIALIZED(-1002),
    SPINNAKER_ERR_NOT_IMPLEMENTED(-1003),
    SPINNAKER_ERR_RESOURCE_IN_USE(-1004),
    SPINNAKER_ERR_ACCESS_DENIED(-1005),
    SPINNAKER_ERR_INVALID_HANDLE(-1006),
    SPINNAKER_ERR_INVALID_ID(-1007),
    SPINNAKER_ERR_NO_DATA(-1008),
    SPINNAKER_ERR_INVALID_PARAMETER(-1009),
    SPINNAKER_ERR_IO(-1010),
    SPINNAKER_ERR_TIMEOUT(-1011),
    SPINNAKER_ERR_ABORT(-1012),
    SPINNAKER_ERR_INVALID_BUFFER(-1013),
    SPINNAKER_ERR_NOT_AVAILABLE(-1014),
    SPINNAKER_ERR_INVALID_ADDRESS(-1015),
    SPINNAKER_ERR_BUFFER_TOO_SMALL(-1016),
    SPINNAKER_ERR_INVALID_INDEX(-1017),
    SPINNAKER_ERR_PARSING_CHUNK_DATA(-1018),
    SPINNAKER_ERR_INVALID_VALUE(-1019),
    SPINNAKER_ERR_RESOURCE_EXHAUSTED(-1020),
    SPINNAKER_ERR_OUT_OF_MEMORY(-1021),
    SPINNAKER_ERR_BUSY(-1022),

    /**
     * The error codes in the range of -2000 to -2999 are reserved for
     * Gen API related errors.
     */
    GENICAM_ERR_INVALID_ARGUMENT(-2001),
    GENICAM_ERR_OUT_OF_RANGE(-2002),
    GENICAM_ERR_PROPERTY(-2003),
    GENICAM_ERR_RUN_TIME(-2004),
    GENICAM_ERR_LOGICAL(-2005),
    GENICAM_ERR_ACCESS(-2006),
    GENICAM_ERR_TIMEOUT(-2007),
    GENICAM_ERR_DYNAMIC_CAST(-2008),
    GENICAM_ERR_GENERIC(-2009),
    GENICAM_ERR_BAD_ALLOCATION(-2010),

    /**
     * The error codes in the range of -3000 to -3999 are reserved for
     * image processing related errors.
     */
    SPINNAKER_ERR_IM_CONVERT(-3001),
    SPINNAKER_ERR_IM_COPY(-3002),
    SPINNAKER_ERR_IM_MALLOC(-3003),
    SPINNAKER_ERR_IM_NOT_SUPPORTED(-3004),
    SPINNAKER_ERR_IM_HISTOGRAM_RANGE(-3005),
    SPINNAKER_ERR_IM_HISTOGRAM_MEAN(-3006),
    SPINNAKER_ERR_IM_MIN_MAX(-3007),
    SPINNAKER_ERR_IM_COLOR_CONVERSION(-3008),

    /**
     * Error codes less than -10000 are reserved for user-defined custom
     * errors.
     */
    SPINNAKER_ERR_CUSTOM_ID(-10000);

    public final int value;
    private _spinError(int v) { this.value = v; }
    private _spinError(_spinError e) { this.value = e.value; }
    public _spinError intern() { for (_spinError e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 * Color processing algorithms. Please refer to our knowledge base at
 * article at
 * https://www.flir.com/support-center/iis/machine-vision/knowledge-base/different-color-processing-algorithms-in-flycapture2
 * for complete details for each algorithm.
 */
public enum _spinColorProcessingAlgorithm {
    /** Default method. */
    DEFAULT(0),
    /** No color processing. */
    NO_COLOR_PROCESSING(1),
    /**
     * Fastest but lowest quality. Equivalent to
     * FLYCAPTURE_NEAREST_NEIGHBOR_FAST in FlyCapture.
     */
    NEAREST_NEIGHBOR(2),
    /**
     * Nearest Neighbor with averaged green pixels. Higher quality but slower
     * compared to nearest neighbor without averaging.
     */
    NEAREST_NEIGHBOR_AVG(3),
    /** Weighted average of surrounding 4 pixels in a 2x2 neighborhood. */
    BILINEAR(4),
    /** Weights surrounding pixels based on localized edge orientation. */
    EDGE_SENSING(5),
    /** Well-balanced speed and quality. */
    HQ_LINEAR(6),
    /** Multi-threaded with similar results to edge sensing. */
    IPP(7),
    /** Best quality but much faster than rigorous. */
    DIRECTIONAL_FILTER(8),
    /** Slowest but produces good results. */
    RIGOROUS(9),
    /** Weighted pixel average from different directions. */
    WEIGHTED_DIRECTIONAL_FILTER(10);

    public final int value;
    private _spinColorProcessingAlgorithm(int v) { this.value = v; }
    private _spinColorProcessingAlgorithm(_spinColorProcessingAlgorithm e) { this.value = e.value; }
    public _spinColorProcessingAlgorithm intern() { for (_spinColorProcessingAlgorithm e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 * Channels that allow statistics to be calculated.
 */
public enum _spinStatisticsChannel {
    GREY(0),
    RED(1),
    GREEN(2),
    BLUE(3),
    HUE(4),
    SATURATION(5),
    LIGHTNESS(6),
    NUM_STATISTICS_CHANNELS(7);

    public final int value;
    private _spinStatisticsChannel(int v) { this.value = v; }
    private _spinStatisticsChannel(_spinStatisticsChannel e) { this.value = e.value; }
    public _spinStatisticsChannel intern() { for (_spinStatisticsChannel e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** File formats to be used for saving images to disk. */
public enum _spinImageFileFormat {
    /** Determine file format from file extension. */
    FROM_FILE_EXT(-1),
    /** Portable gray map. */
    PGM(0),
    /** Portable pixmap. */
    PPM(1),
    /** Bitmap. */
    BMP(2),
    /** JPEG. */
    JPEG(3),
    /** JPEG 2000. */
    JPEG2000(4),
    /** Tagged image file format. */
    TIFF(5),
    /** Portable network graphics. */
    PNG(6),
    /** Raw data. */
    RAW(7),
    IMAGE_FILE_FORMAT_FORCE_32BITS(0x7FFFFFFF);

    public final int value;
    private _spinImageFileFormat(int v) { this.value = v; }
    private _spinImageFileFormat(_spinImageFileFormat e) { this.value = e.value; }
    public _spinImageFileFormat intern() { for (_spinImageFileFormat e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 * This enum represents the namespace in which the TL specific pixel format
 * resides. This enum is returned from a captured image when calling
 * spinImageGetTLPixelFormatNamespace().  It can be used to interpret the raw
 * pixel format returned from spinImageGetTLPixelFormat().
 *
 * @see spinImageGetTLPixelFormat()
 *
 * @see spinImageGetTLPixelFormatNamespace()
 */
public enum _spinPixelFormatNamespaceID {
    SPINNAKER_PIXELFORMAT_NAMESPACE_UNKNOWN(0),    /* GenTL v1.2 */
    SPINNAKER_PIXELFORMAT_NAMESPACE_GEV(1),        /* GenTL v1.2 */
    SPINNAKER_PIXELFORMAT_NAMESPACE_IIDC(2),       /* GenTL v1.2 */
    SPINNAKER_PIXELFORMAT_NAMESPACE_PFNC_16BIT(3), /* GenTL v1.4 */
    SPINNAKER_PIXELFORMAT_NAMESPACE_PFNC_32BIT(4), /* GenTL v1.4 */

    SPINNAKER_PIXELFORMAT_NAMESPACE_CUSTOM_ID(1000);

    public final int value;
    private _spinPixelFormatNamespaceID(int v) { this.value = v; }
    private _spinPixelFormatNamespaceID(_spinPixelFormatNamespaceID e) { this.value = e.value; }
    public _spinPixelFormatNamespaceID intern() { for (_spinPixelFormatNamespaceID e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** Status of images returned from spinImageGetStatus() call. */
public enum _spinImageStatus {
    /** Image has an unknown error. */
    IMAGE_UNKNOWN_ERROR(-1),
    /** Image is returned from GetNextImage() call without any errors. */
    IMAGE_NO_ERROR(0),
    /** Image failed CRC check. */
    IMAGE_CRC_CHECK_FAILED(1),
    /** Received more data than the size of the image. */
    IMAGE_DATA_OVERFLOW(2),
    /** Image has missing packets */
    IMAGE_MISSING_PACKETS(3),
    /** Image leader is incomplete. */
    IMAGE_LEADER_BUFFER_SIZE_INCONSISTENT(4),
    /** Image trailer is incomplete. */
    IMAGE_TRAILER_BUFFER_SIZE_INCONSISTENT(5),
    /** Image has an inconsistent packet id. */
    IMAGE_PACKETID_INCONSISTENT(6),
    /** Image leader is missing. */
    IMAGE_MISSING_LEADER(7),
    /** Image trailer is missing. */
    IMAGE_MISSING_TRAILER(8),
    /** Image data is incomplete. */
    IMAGE_DATA_INCOMPLETE(9),
    /** Image info is corrupted. */
    IMAGE_INFO_INCONSISTENT(10),
    /** Image chunk data is invalid */
    IMAGE_CHUNK_DATA_INVALID(11),
    /** Image cannot be processed due to lack of system
                                                resources. */
    IMAGE_NO_SYSTEM_RESOURCES(12);

    public final int value;
    private _spinImageStatus(int v) { this.value = v; }
    private _spinImageStatus(_spinImageStatus e) { this.value = e.value; }
    public _spinImageStatus intern() { for (_spinImageStatus e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** log levels */
public enum _spinLogLevel {
    LOG_LEVEL_OFF(-1),     // Logging is off.
    LOG_LEVEL_FATAL(0),    // Not used by Spinnaker.
    LOG_LEVEL_ALERT(100),  // Not used by Spinnaker.
    LOG_LEVEL_CRIT(200),   // Not used by Spinnaker.
    LOG_LEVEL_ERROR(300),  // Failures that are non-recoverable without user intervention.
    LOG_LEVEL_WARN(400),   // Failures that are recoverable without user intervention.
    LOG_LEVEL_NOTICE(500), // Events such as camera arrival and removal, initialization and deinitialization, starting
                            // and stopping image acquisition, and feature modification.
    LOG_LEVEL_INFO(600),   // Information about recurring events that are generated regularly such as information on
                            // individual images.
    LOG_LEVEL_DEBUG(700),  // Information that can be used to troubleshoot the system.
    LOG_LEVEL_NOTSET(800); // Logs everything.

    public final int value;
    private _spinLogLevel(int v) { this.value = v; }
    private _spinLogLevel(_spinLogLevel e) { this.value = e.value; }
    public _spinLogLevel intern() { for (_spinLogLevel e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/* Enumeration of TLType dependent payload types. Introduced in GenTL v1.2 */
public enum _spinPayloadTypeInfoIDs {
    PAYLOAD_TYPE_UNKNOWN(0),         /* GenTL v1.2 */
    PAYLOAD_TYPE_IMAGE(1),           /* GenTL v1.2 */
    PAYLOAD_TYPE_RAW_DATA(2),        /* GenTL v1.2 */
    PAYLOAD_TYPE_FILE(3),            /* GenTL v1.2 */
    PAYLOAD_TYPE_CHUNK_DATA(4),      /* GenTL v1.2, Deprecated in GenTL 1.5*/
    PAYLOAD_TYPE_JPEG(5),            /* GenTL v1.4 */
    PAYLOAD_TYPE_JPEG2000(6),        /* GenTL v1.4 */
    PAYLOAD_TYPE_H264(7),            /* GenTL v1.4 */
    PAYLOAD_TYPE_CHUNK_ONLY(8),      /* GenTL v1.4 */
    PAYLOAD_TYPE_DEVICE_SPECIFIC(9), /* GenTL v1.4 */
    PAYLOAD_TYPE_MULTI_PART(10),     /* GenTL v1.5 */

    PAYLOAD_TYPE_CUSTOM_ID(1000), /* Starting value for GenTL Producer custom IDs. */
    PAYLOAD_TYPE_EXTENDED_CHUNK(1001);

    public final int value;
    private _spinPayloadTypeInfoIDs(int v) { this.value = v; }
    private _spinPayloadTypeInfoIDs(_spinPayloadTypeInfoIDs e) { this.value = e.value; }
    public _spinPayloadTypeInfoIDs intern() { for (_spinPayloadTypeInfoIDs e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ..\Spinnaker_C\spinPNGOption.java


// Targeting ..\Spinnaker_C\spinPPMOption.java


// Targeting ..\Spinnaker_C\spinPGMOption.java



/** Compression method used in saving TIFF images in the spinTIFFOption struct. */
public enum CompressionMethod {
    NONE(1),      // Save without any compression.
    PACKBITS(2),      // Save using PACKBITS compression.
    DEFLATE(3),       // Save using DEFLATE compression (ZLIB compression).
    ADOBE_DEFLATE(4), // Save using ADOBE DEFLATE compression

    // Save using CCITT Group 3 fax encoding. This is only valid for
    // 1-bit images only. Default to LZW for other bit depths.
    //
    CCITTFAX3(5),

    // Save using CCITT Group 4 fax encoding. This is only valid for
    // 1-bit images only. Default to LZW for other bit depths.

    CCITTFAX4(6),
    LZW(7), //< Save using LZW compression.
         //
         // Save using JPEG compression. This is only valid for 8-bit
         // greyscale and 24-bit only. Default to LZW for other bit depths.
         //
    JPG(8);

    public final int value;
    private CompressionMethod(int v) { this.value = v; }
    private CompressionMethod(CompressionMethod e) { this.value = e.value; }
    public CompressionMethod intern() { for (CompressionMethod e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ..\Spinnaker_C\spinTIFFOption.java


// Targeting ..\Spinnaker_C\spinJPEGOption.java


// Targeting ..\Spinnaker_C\spinJPG2Option.java


// Targeting ..\Spinnaker_C\spinBMPOption.java


// Targeting ..\Spinnaker_C\spinMJPGOption.java


// Targeting ..\Spinnaker_C\spinH264Option.java


// Targeting ..\Spinnaker_C\spinAVIOption.java


// Targeting ..\Spinnaker_C\spinLibraryVersion.java



/**
 * Possible Status Codes Returned from Action Command.
 */
public enum _actionCommandStatus {
    /** The device acknowledged the command. */
    ACTION_COMMAND_STATUS_OK(0),

    /* The device is not synchronized to a master clock to be used as time reference. Typically used when scheduled
       action commands cannot be scheduled for a future time since the reference time coming from IEEE 1588 is not
       locked. */
    ACTION_COMMAND_STATUS_NO_REF_TIME(0x8013),

    /* Returned when the scheduled action commands queue is full and the device cannot accept the additional request. */
    ACTION_COMMAND_STATUS_OVERFLOW(0x8015),

    /* The requested scheduled action command was requested at a point in time that is in the past. */
    ACTION_COMMAND_STATUS_ACTION_LATE(0x8016),

    /* Generic Error. Try enabling the Extended Status Code 2.0 bit on gvcp configuration register in order to receive
       more meaningful/detailed acknowledge messages from the device. */
    ACTION_COMMAND_STATUS_ERROR(0x8FFF);

    public final int value;
    private _actionCommandStatus(int v) { this.value = v; }
    private _actionCommandStatus(_actionCommandStatus e) { this.value = e.value; }
    public _actionCommandStatus intern() { for (_actionCommandStatus e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ..\Spinnaker_C\actionCommandResult.java



/*@}*/

/*@}*/

// #endif // FLIR_SPINNAKER_DEFS_C_H

// Parsed from <CameraDefsC.h>

//=============================================================================
// Copyright (c) 2001-2019 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================
   
/* Auto-generated file. Do not modify. */

// #ifndef FLIR_SPINNAKER_CAMERA_DEFS_C_H
// #define FLIR_SPINNAKER_CAMERA_DEFS_C_H

/**
* \defgroup SpinnakerDefsC Spinnaker C Definitions
* \ingroup SpinnakerC
*
* Definitions for Spinnaker C
*/
/*@{*/

/**
* \defgroup CameraDefsC_h Camera Enumerations
*/
/*@{*/

/**
*\brief The enum definitions for camera nodes.
*/

public enum _spinLUTSelectorEnums {
    /** 
        This LUT is for re-mapping pixels of all formats 
        (mono, Bayer, red, green and blue).
      */
    LUTSelector_LUT1(0),
    NUM_LUTSELECTOR(1);

    public final int value;
    private _spinLUTSelectorEnums(int v) { this.value = v; }
    private _spinLUTSelectorEnums(_spinLUTSelectorEnums e) { this.value = e.value; }
    public _spinLUTSelectorEnums intern() { for (_spinLUTSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinExposureModeEnums {
    /** 
        Timed exposure. The exposure time is set using the 
        ExposureTime or ExposureAuto features and the exposure starts with the
        FrameStart or LineStart.
      */
    ExposureMode_Timed(0),
    /** 
        Uses the width of the current Frame trigger signal pulse to control the
        exposure time.
      */
    ExposureMode_TriggerWidth(1),
    NUM_EXPOSUREMODE(2);

    public final int value;
    private _spinExposureModeEnums(int v) { this.value = v; }
    private _spinExposureModeEnums(_spinExposureModeEnums e) { this.value = e.value; }
    public _spinExposureModeEnums intern() { for (_spinExposureModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinAcquisitionModeEnums {
    /** */
    AcquisitionMode_Continuous(0),
    /** */
    AcquisitionMode_SingleFrame(1),
    /** */
    AcquisitionMode_MultiFrame(2),
    NUM_ACQUISITIONMODE(3);

    public final int value;
    private _spinAcquisitionModeEnums(int v) { this.value = v; }
    private _spinAcquisitionModeEnums(_spinAcquisitionModeEnums e) { this.value = e.value; }
    public _spinAcquisitionModeEnums intern() { for (_spinAcquisitionModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTriggerSourceEnums {
    /** */
    TriggerSource_Software(0),
    /** */
    TriggerSource_Line0(1),
    /** */
    TriggerSource_Line1(2),
    /** */
    TriggerSource_Line2(3),
    /** */
    TriggerSource_Line3(4),
    /** */
    TriggerSource_UserOutput0(5),
    /** */
    TriggerSource_UserOutput1(6),
    /** */
    TriggerSource_UserOutput2(7),
    /** */
    TriggerSource_UserOutput3(8),
    /** */
    TriggerSource_Counter0Start(9),
    /** */
    TriggerSource_Counter1Start(10),
    /** */
    TriggerSource_Counter0End(11),
    /** */
    TriggerSource_Counter1End(12),
    /** */
    TriggerSource_LogicBlock0(13),
    /** */
    TriggerSource_LogicBlock1(14),
    /** */
    TriggerSource_Action0(15),
    NUM_TRIGGERSOURCE(16);

    public final int value;
    private _spinTriggerSourceEnums(int v) { this.value = v; }
    private _spinTriggerSourceEnums(_spinTriggerSourceEnums e) { this.value = e.value; }
    public _spinTriggerSourceEnums intern() { for (_spinTriggerSourceEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTriggerActivationEnums {
    /** */
    TriggerActivation_LevelLow(0),
    /** */
    TriggerActivation_LevelHigh(1),
    /** */
    TriggerActivation_FallingEdge(2),
    /** */
    TriggerActivation_RisingEdge(3),
    /** */
    TriggerActivation_AnyEdge(4),
    NUM_TRIGGERACTIVATION(5);

    public final int value;
    private _spinTriggerActivationEnums(int v) { this.value = v; }
    private _spinTriggerActivationEnums(_spinTriggerActivationEnums e) { this.value = e.value; }
    public _spinTriggerActivationEnums intern() { for (_spinTriggerActivationEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinSensorShutterModeEnums {
    /** 
        The shutter opens and closes at the same time for all pixels.
        All the pixels are exposed for the same length of time at the same time.
      */
    SensorShutterMode_Global(0),
    /** 
        The shutter opens and closes sequentially for groups (typically lines) of pixels.
        All the pixels are exposed for the same length of time but not at the same time.
      */
    SensorShutterMode_Rolling(1),
    /** 
        The shutter opens at the same time for all pixels but ends in a sequential manner.
        The pixels are exposed for different lengths of time.
      */
    SensorShutterMode_GlobalReset(2),
    NUM_SENSORSHUTTERMODE(3);

    public final int value;
    private _spinSensorShutterModeEnums(int v) { this.value = v; }
    private _spinSensorShutterModeEnums(_spinSensorShutterModeEnums e) { this.value = e.value; }
    public _spinSensorShutterModeEnums intern() { for (_spinSensorShutterModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTriggerModeEnums {
    /** */
    TriggerMode_Off(0),
    /** */
    TriggerMode_On(1),
    NUM_TRIGGERMODE(2);

    public final int value;
    private _spinTriggerModeEnums(int v) { this.value = v; }
    private _spinTriggerModeEnums(_spinTriggerModeEnums e) { this.value = e.value; }
    public _spinTriggerModeEnums intern() { for (_spinTriggerModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTriggerOverlapEnums {
    /** */
    TriggerOverlap_Off(0),
    /** */
    TriggerOverlap_ReadOut(1),
    /** */
    TriggerOverlap_PreviousFrame(2),
    NUM_TRIGGEROVERLAP(3);

    public final int value;
    private _spinTriggerOverlapEnums(int v) { this.value = v; }
    private _spinTriggerOverlapEnums(_spinTriggerOverlapEnums e) { this.value = e.value; }
    public _spinTriggerOverlapEnums intern() { for (_spinTriggerOverlapEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTriggerSelectorEnums {
    /** */
    TriggerSelector_AcquisitionStart(0),
    /** */
    TriggerSelector_FrameStart(1),
    /** */
    TriggerSelector_FrameBurstStart(2),
    NUM_TRIGGERSELECTOR(3);

    public final int value;
    private _spinTriggerSelectorEnums(int v) { this.value = v; }
    private _spinTriggerSelectorEnums(_spinTriggerSelectorEnums e) { this.value = e.value; }
    public _spinTriggerSelectorEnums intern() { for (_spinTriggerSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinExposureAutoEnums {
    /** 
        Exposure time is manually controlled using ExposureTime
      */
    ExposureAuto_Off(0),
    /** 
        Exposure time is adapted once by the device. Once it has converged,
        it returns to the Off state.
      */
    ExposureAuto_Once(1),
    /** 
        Exposure time is constantly adapted by the device to maximize the
        dynamic range.
      */
    ExposureAuto_Continuous(2),
    NUM_EXPOSUREAUTO(3);

    public final int value;
    private _spinExposureAutoEnums(int v) { this.value = v; }
    private _spinExposureAutoEnums(_spinExposureAutoEnums e) { this.value = e.value; }
    public _spinExposureAutoEnums intern() { for (_spinExposureAutoEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinEventSelectorEnums {
    /** */
    EventSelector_Error(0),
    /** */
    EventSelector_ExposureEnd(1),
    /** */
    EventSelector_SerialPortReceive(2),
    NUM_EVENTSELECTOR(3);

    public final int value;
    private _spinEventSelectorEnums(int v) { this.value = v; }
    private _spinEventSelectorEnums(_spinEventSelectorEnums e) { this.value = e.value; }
    public _spinEventSelectorEnums intern() { for (_spinEventSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinEventNotificationEnums {
    /** */
    EventNotification_On(0),
    /** */
    EventNotification_Off(1),
    NUM_EVENTNOTIFICATION(2);

    public final int value;
    private _spinEventNotificationEnums(int v) { this.value = v; }
    private _spinEventNotificationEnums(_spinEventNotificationEnums e) { this.value = e.value; }
    public _spinEventNotificationEnums intern() { for (_spinEventNotificationEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinLogicBlockSelectorEnums {
    /** */
    LogicBlockSelector_LogicBlock0(0),
    /** */
    LogicBlockSelector_LogicBlock1(1),
    NUM_LOGICBLOCKSELECTOR(2);

    public final int value;
    private _spinLogicBlockSelectorEnums(int v) { this.value = v; }
    private _spinLogicBlockSelectorEnums(_spinLogicBlockSelectorEnums e) { this.value = e.value; }
    public _spinLogicBlockSelectorEnums intern() { for (_spinLogicBlockSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinLogicBlockLUTInputActivationEnums {
    /** */
    LogicBlockLUTInputActivation_LevelLow(0),
    /** */
    LogicBlockLUTInputActivation_LevelHigh(1),
    /** */
    LogicBlockLUTInputActivation_FallingEdge(2),
    /** */
    LogicBlockLUTInputActivation_RisingEdge(3),
    /** */
    LogicBlockLUTInputActivation_AnyEdge(4),
    NUM_LOGICBLOCKLUTINPUTACTIVATION(5);

    public final int value;
    private _spinLogicBlockLUTInputActivationEnums(int v) { this.value = v; }
    private _spinLogicBlockLUTInputActivationEnums(_spinLogicBlockLUTInputActivationEnums e) { this.value = e.value; }
    public _spinLogicBlockLUTInputActivationEnums intern() { for (_spinLogicBlockLUTInputActivationEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinLogicBlockLUTInputSelectorEnums {
    /** */
    LogicBlockLUTInputSelector_Input0(0),
    /** */
    LogicBlockLUTInputSelector_Input1(1),
    /** */
    LogicBlockLUTInputSelector_Input2(2),
    /** */
    LogicBlockLUTInputSelector_Input3(3),
    NUM_LOGICBLOCKLUTINPUTSELECTOR(4);

    public final int value;
    private _spinLogicBlockLUTInputSelectorEnums(int v) { this.value = v; }
    private _spinLogicBlockLUTInputSelectorEnums(_spinLogicBlockLUTInputSelectorEnums e) { this.value = e.value; }
    public _spinLogicBlockLUTInputSelectorEnums intern() { for (_spinLogicBlockLUTInputSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinLogicBlockLUTInputSourceEnums {
    /** Zero*/
    LogicBlockLUTInputSource_Zero(0),
    /** Line0*/
    LogicBlockLUTInputSource_Line0(1),
    /** Line1*/
    LogicBlockLUTInputSource_Line1(2),
    /** Line2*/
    LogicBlockLUTInputSource_Line2(3),
    /** Line3*/
    LogicBlockLUTInputSource_Line3(4),
    /** UserOutput0*/
    LogicBlockLUTInputSource_UserOutput0(5),
    /** UserOutput1*/
    LogicBlockLUTInputSource_UserOutput1(6),
    /** UserOutput2*/
    LogicBlockLUTInputSource_UserOutput2(7),
    /** UserOutput3*/
    LogicBlockLUTInputSource_UserOutput3(8),
    /** Counter0Start*/
    LogicBlockLUTInputSource_Counter0Start(9),
    /** Counter1Start*/
    LogicBlockLUTInputSource_Counter1Start(10),
    /** Counter0End*/
    LogicBlockLUTInputSource_Counter0End(11),
    /** Counter1End*/
    LogicBlockLUTInputSource_Counter1End(12),
    /** LogicBlock0*/
    LogicBlockLUTInputSource_LogicBlock0(13),
    /** LogicBlock1*/
    LogicBlockLUTInputSource_LogicBlock1(14),
    /** ExposureStart*/
    LogicBlockLUTInputSource_ExposureStart(15),
    /** ExposureEnd*/
    LogicBlockLUTInputSource_ExposureEnd(16),
    /** FrameTriggerWait*/
    LogicBlockLUTInputSource_FrameTriggerWait(17),
    /** AcquisitionActive*/
    LogicBlockLUTInputSource_AcquisitionActive(18),
    NUM_LOGICBLOCKLUTINPUTSOURCE(19);

    public final int value;
    private _spinLogicBlockLUTInputSourceEnums(int v) { this.value = v; }
    private _spinLogicBlockLUTInputSourceEnums(_spinLogicBlockLUTInputSourceEnums e) { this.value = e.value; }
    public _spinLogicBlockLUTInputSourceEnums intern() { for (_spinLogicBlockLUTInputSourceEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinLogicBlockLUTSelectorEnums {
    /** */
    LogicBlockLUTSelector_Value(0),
    /** */
    LogicBlockLUTSelector_Enable(1),
    NUM_LOGICBLOCKLUTSELECTOR(2);

    public final int value;
    private _spinLogicBlockLUTSelectorEnums(int v) { this.value = v; }
    private _spinLogicBlockLUTSelectorEnums(_spinLogicBlockLUTSelectorEnums e) { this.value = e.value; }
    public _spinLogicBlockLUTSelectorEnums intern() { for (_spinLogicBlockLUTSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinColorTransformationSelectorEnums {
    /** */
    ColorTransformationSelector_RGBtoRGB(0),
    /** */
    ColorTransformationSelector_RGBtoYUV(1),
    NUM_COLORTRANSFORMATIONSELECTOR(2);

    public final int value;
    private _spinColorTransformationSelectorEnums(int v) { this.value = v; }
    private _spinColorTransformationSelectorEnums(_spinColorTransformationSelectorEnums e) { this.value = e.value; }
    public _spinColorTransformationSelectorEnums intern() { for (_spinColorTransformationSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinRgbTransformLightSourceEnums {
    /** 
        Uses a matrix calibrated for a wide range of light sources.
      */
    RgbTransformLightSource_General(0),
    /** 
        Uses a matrix optimized for tungsten/incandescent light with color temperature 2800K.
      */
    RgbTransformLightSource_Tungsten2800K(1),
    /** 
        Uses a matrix optimized for a typical warm fluoresecent light with color temperature 3000K.
      */
    RgbTransformLightSource_WarmFluorescent3000K(2),
    /** 
        Uses a matrix optimized for a typical cool fluoresecent light with color temperature 4000K.
      */
    RgbTransformLightSource_CoolFluorescent4000K(3),
    /** 
        Uses a matrix optimized for noon Daylight with color temperature 5000K.
      */
    RgbTransformLightSource_Daylight5000K(4),
    /** 
        Uses a matrix optimized for a cloudy sky with color temperature 6500K.
      */
    RgbTransformLightSource_Cloudy6500K(5),
    /** 
        Uses a matrix optimized for shade with color temperature 8000K.
      */
    RgbTransformLightSource_Shade8000K(6),
    /** 
        Uses a custom matrix set by the user through the 
        ColorTransformationValueSelector and ColorTransformationValue controls.
      */
    RgbTransformLightSource_Custom(7),
    NUM_RGBTRANSFORMLIGHTSOURCE(8);

    public final int value;
    private _spinRgbTransformLightSourceEnums(int v) { this.value = v; }
    private _spinRgbTransformLightSourceEnums(_spinRgbTransformLightSourceEnums e) { this.value = e.value; }
    public _spinRgbTransformLightSourceEnums intern() { for (_spinRgbTransformLightSourceEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinColorTransformationValueSelectorEnums {
    /** */
    ColorTransformationValueSelector_Gain00(0),
    /** */
    ColorTransformationValueSelector_Gain01(1),
    /** */
    ColorTransformationValueSelector_Gain02(2),
    /** */
    ColorTransformationValueSelector_Gain10(3),
    /** */
    ColorTransformationValueSelector_Gain11(4),
    /** */
    ColorTransformationValueSelector_Gain12(5),
    /** */
    ColorTransformationValueSelector_Gain20(6),
    /** */
    ColorTransformationValueSelector_Gain21(7),
    /** */
    ColorTransformationValueSelector_Gain22(8),
    /** */
    ColorTransformationValueSelector_Offset0(9),
    /** */
    ColorTransformationValueSelector_Offset1(10),
    /** */
    ColorTransformationValueSelector_Offset2(11),
    NUM_COLORTRANSFORMATIONVALUESELECTOR(12);

    public final int value;
    private _spinColorTransformationValueSelectorEnums(int v) { this.value = v; }
    private _spinColorTransformationValueSelectorEnums(_spinColorTransformationValueSelectorEnums e) { this.value = e.value; }
    public _spinColorTransformationValueSelectorEnums intern() { for (_spinColorTransformationValueSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDeviceRegistersEndiannessEnums {
    /** */
    DeviceRegistersEndianness_Little(0),
    /** */
    DeviceRegistersEndianness_Big(1),
    NUM_DEVICEREGISTERSENDIANNESS(2);

    public final int value;
    private _spinDeviceRegistersEndiannessEnums(int v) { this.value = v; }
    private _spinDeviceRegistersEndiannessEnums(_spinDeviceRegistersEndiannessEnums e) { this.value = e.value; }
    public _spinDeviceRegistersEndiannessEnums intern() { for (_spinDeviceRegistersEndiannessEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDeviceScanTypeEnums {
    /** */
    DeviceScanType_Areascan(0),
    NUM_DEVICESCANTYPE(1);

    public final int value;
    private _spinDeviceScanTypeEnums(int v) { this.value = v; }
    private _spinDeviceScanTypeEnums(_spinDeviceScanTypeEnums e) { this.value = e.value; }
    public _spinDeviceScanTypeEnums intern() { for (_spinDeviceScanTypeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDeviceCharacterSetEnums {
    /** */
    DeviceCharacterSet_UTF8(0),
    /** */
    DeviceCharacterSet_ASCII(1),
    NUM_DEVICECHARACTERSET(2);

    public final int value;
    private _spinDeviceCharacterSetEnums(int v) { this.value = v; }
    private _spinDeviceCharacterSetEnums(_spinDeviceCharacterSetEnums e) { this.value = e.value; }
    public _spinDeviceCharacterSetEnums intern() { for (_spinDeviceCharacterSetEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDeviceTLTypeEnums {
    /** */
    DeviceTLType_GigEVision(0),
    /** */
    DeviceTLType_CameraLink(1),
    /** */
    DeviceTLType_CameraLinkHS(2),
    /** */
    DeviceTLType_CoaXPress(3),
    /** */
    DeviceTLType_USB3Vision(4),
    /** */
    DeviceTLType_Custom(5),
    NUM_DEVICETLTYPE(6);

    public final int value;
    private _spinDeviceTLTypeEnums(int v) { this.value = v; }
    private _spinDeviceTLTypeEnums(_spinDeviceTLTypeEnums e) { this.value = e.value; }
    public _spinDeviceTLTypeEnums intern() { for (_spinDeviceTLTypeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDevicePowerSupplySelectorEnums {
    /** */
    DevicePowerSupplySelector_External(0),
    NUM_DEVICEPOWERSUPPLYSELECTOR(1);

    public final int value;
    private _spinDevicePowerSupplySelectorEnums(int v) { this.value = v; }
    private _spinDevicePowerSupplySelectorEnums(_spinDevicePowerSupplySelectorEnums e) { this.value = e.value; }
    public _spinDevicePowerSupplySelectorEnums intern() { for (_spinDevicePowerSupplySelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDeviceTemperatureSelectorEnums {
    /** */
    DeviceTemperatureSelector_Sensor(0),
    NUM_DEVICETEMPERATURESELECTOR(1);

    public final int value;
    private _spinDeviceTemperatureSelectorEnums(int v) { this.value = v; }
    private _spinDeviceTemperatureSelectorEnums(_spinDeviceTemperatureSelectorEnums e) { this.value = e.value; }
    public _spinDeviceTemperatureSelectorEnums intern() { for (_spinDeviceTemperatureSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDeviceIndicatorModeEnums {
    /** */
    DeviceIndicatorMode_Inactive(0),
    /** */
    DeviceIndicatorMode_Active(1),
    /** */
    DeviceIndicatorMode_ErrorStatus(2),
    NUM_DEVICEINDICATORMODE(3);

    public final int value;
    private _spinDeviceIndicatorModeEnums(int v) { this.value = v; }
    private _spinDeviceIndicatorModeEnums(_spinDeviceIndicatorModeEnums e) { this.value = e.value; }
    public _spinDeviceIndicatorModeEnums intern() { for (_spinDeviceIndicatorModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinAutoExposureControlPriorityEnums {
    /** */
    AutoExposureControlPriority_Gain(0),
    /** */
    AutoExposureControlPriority_ExposureTime(1),
    NUM_AUTOEXPOSURECONTROLPRIORITY(2);

    public final int value;
    private _spinAutoExposureControlPriorityEnums(int v) { this.value = v; }
    private _spinAutoExposureControlPriorityEnums(_spinAutoExposureControlPriorityEnums e) { this.value = e.value; }
    public _spinAutoExposureControlPriorityEnums intern() { for (_spinAutoExposureControlPriorityEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinAutoExposureMeteringModeEnums {
    /** */
    AutoExposureMeteringMode_Average(0),
    /** */
    AutoExposureMeteringMode_Spot(1),
    /** */
    AutoExposureMeteringMode_Partial(2),
    /** */
    AutoExposureMeteringMode_CenterWeighted(3),
    /** */
    AutoExposureMeteringMode_HistgramPeak(4),
    NUM_AUTOEXPOSUREMETERINGMODE(5);

    public final int value;
    private _spinAutoExposureMeteringModeEnums(int v) { this.value = v; }
    private _spinAutoExposureMeteringModeEnums(_spinAutoExposureMeteringModeEnums e) { this.value = e.value; }
    public _spinAutoExposureMeteringModeEnums intern() { for (_spinAutoExposureMeteringModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinBalanceWhiteAutoProfileEnums {
    /** Indoor auto white balance Profile. Can be used to compensate for artificial lighting.*/
    BalanceWhiteAutoProfile_Indoor(0),
    /** Outdoor auto white balance profile. Designed for scenes with
        natural lighting.
      */
    BalanceWhiteAutoProfile_Outdoor(1),
    NUM_BALANCEWHITEAUTOPROFILE(2);

    public final int value;
    private _spinBalanceWhiteAutoProfileEnums(int v) { this.value = v; }
    private _spinBalanceWhiteAutoProfileEnums(_spinBalanceWhiteAutoProfileEnums e) { this.value = e.value; }
    public _spinBalanceWhiteAutoProfileEnums intern() { for (_spinBalanceWhiteAutoProfileEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinAutoAlgorithmSelectorEnums {
    /** Selects the Auto White Balance algorithm.*/
    AutoAlgorithmSelector_Awb(0),
    /** Selects the Auto Exposure algorithm.*/
    AutoAlgorithmSelector_Ae(1),
    NUM_AUTOALGORITHMSELECTOR(2);

    public final int value;
    private _spinAutoAlgorithmSelectorEnums(int v) { this.value = v; }
    private _spinAutoAlgorithmSelectorEnums(_spinAutoAlgorithmSelectorEnums e) { this.value = e.value; }
    public _spinAutoAlgorithmSelectorEnums intern() { for (_spinAutoAlgorithmSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinAutoExposureTargetGreyValueAutoEnums {
    /** Target grey value is manually controlled*/
    AutoExposureTargetGreyValueAuto_Off(0),
    /** Target grey value is constantly adapted by the device to maximize the dynamic range.*/
    AutoExposureTargetGreyValueAuto_Continuous(1),
    NUM_AUTOEXPOSURETARGETGREYVALUEAUTO(2);

    public final int value;
    private _spinAutoExposureTargetGreyValueAutoEnums(int v) { this.value = v; }
    private _spinAutoExposureTargetGreyValueAutoEnums(_spinAutoExposureTargetGreyValueAutoEnums e) { this.value = e.value; }
    public _spinAutoExposureTargetGreyValueAutoEnums intern() { for (_spinAutoExposureTargetGreyValueAutoEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinAutoExposureLightingModeEnums {
    /** */
    AutoExposureLightingMode_AutoDetect(0),
    /** */
    AutoExposureLightingMode_Backlight(1),
    /** */
    AutoExposureLightingMode_Frontlight(2),
    /** */
    AutoExposureLightingMode_Normal(3),
    NUM_AUTOEXPOSURELIGHTINGMODE(4);

    public final int value;
    private _spinAutoExposureLightingModeEnums(int v) { this.value = v; }
    private _spinAutoExposureLightingModeEnums(_spinAutoExposureLightingModeEnums e) { this.value = e.value; }
    public _spinAutoExposureLightingModeEnums intern() { for (_spinAutoExposureLightingModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinGevIEEE1588StatusEnums {
    /** Initializing*/
    GevIEEE1588Status_Initializing(0),
    /** Faulty*/
    GevIEEE1588Status_Faulty(1),
    /** Disabled*/
    GevIEEE1588Status_Disabled(2),
    /** Listening*/
    GevIEEE1588Status_Listening(3),
    /** Pre Master*/
    GevIEEE1588Status_PreMaster(4),
    /** Master*/
    GevIEEE1588Status_Master(5),
    /** Passive*/
    GevIEEE1588Status_Passive(6),
    /** Uncalibrated*/
    GevIEEE1588Status_Uncalibrated(7),
    /** Slave*/
    GevIEEE1588Status_Slave(8),
    NUM_GEVIEEE1588STATUS(9);

    public final int value;
    private _spinGevIEEE1588StatusEnums(int v) { this.value = v; }
    private _spinGevIEEE1588StatusEnums(_spinGevIEEE1588StatusEnums e) { this.value = e.value; }
    public _spinGevIEEE1588StatusEnums intern() { for (_spinGevIEEE1588StatusEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinGevIEEE1588ModeEnums {
    /** Automatic*/
    GevIEEE1588Mode_Auto(0),
    /** Slave Only*/
    GevIEEE1588Mode_SlaveOnly(1),
    NUM_GEVIEEE1588MODE(2);

    public final int value;
    private _spinGevIEEE1588ModeEnums(int v) { this.value = v; }
    private _spinGevIEEE1588ModeEnums(_spinGevIEEE1588ModeEnums e) { this.value = e.value; }
    public _spinGevIEEE1588ModeEnums intern() { for (_spinGevIEEE1588ModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinGevIEEE1588ClockAccuracyEnums {
    /** Unknown Accuracy*/
    GevIEEE1588ClockAccuracy_Unknown(0),
    NUM_GEVIEEE1588CLOCKACCURACY(1);

    public final int value;
    private _spinGevIEEE1588ClockAccuracyEnums(int v) { this.value = v; }
    private _spinGevIEEE1588ClockAccuracyEnums(_spinGevIEEE1588ClockAccuracyEnums e) { this.value = e.value; }
    public _spinGevIEEE1588ClockAccuracyEnums intern() { for (_spinGevIEEE1588ClockAccuracyEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinGevCCPEnums {
    /** */
    GevCCP_OpenAccess(0),
    /** */
    GevCCP_ExclusiveAccess(1),
    /** */
    GevCCP_ControlAccess(2),
    NUM_GEVCCP(3);

    public final int value;
    private _spinGevCCPEnums(int v) { this.value = v; }
    private _spinGevCCPEnums(_spinGevCCPEnums e) { this.value = e.value; }
    public _spinGevCCPEnums intern() { for (_spinGevCCPEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinGevSupportedOptionSelectorEnums {
    /** */
    GevSupportedOptionSelector_UserDefinedName(0),
    /** */
    GevSupportedOptionSelector_SerialNumber(1),
    /** */
    GevSupportedOptionSelector_HeartbeatDisable(2),
    /** */
    GevSupportedOptionSelector_LinkSpeed(3),
    /** */
    GevSupportedOptionSelector_CCPApplicationSocket(4),
    /** */
    GevSupportedOptionSelector_ManifestTable(5),
    /** */
    GevSupportedOptionSelector_TestData(6),
    /** */
    GevSupportedOptionSelector_DiscoveryAckDelay(7),
    /** */
    GevSupportedOptionSelector_DiscoveryAckDelayWritable(8),
    /** */
    GevSupportedOptionSelector_ExtendedStatusCodes(9),
    /** */
    GevSupportedOptionSelector_Action(10),
    /** */
    GevSupportedOptionSelector_PendingAck(11),
    /** */
    GevSupportedOptionSelector_EventData(12),
    /** */
    GevSupportedOptionSelector_Event(13),
    /** */
    GevSupportedOptionSelector_PacketResend(14),
    /** */
    GevSupportedOptionSelector_WriteMem(15),
    /** */
    GevSupportedOptionSelector_CommandsConcatenation(16),
    /** */
    GevSupportedOptionSelector_IPConfigurationLLA(17),
    /** */
    GevSupportedOptionSelector_IPConfigurationDHCP(18),
    /** */
    GevSupportedOptionSelector_IPConfigurationPersistentIP(19),
    /** */
    GevSupportedOptionSelector_StreamChannelSourceSocket(20),
    /** */
    GevSupportedOptionSelector_MessageChannelSourceSocket(21),
    NUM_GEVSUPPORTEDOPTIONSELECTOR(22);

    public final int value;
    private _spinGevSupportedOptionSelectorEnums(int v) { this.value = v; }
    private _spinGevSupportedOptionSelectorEnums(_spinGevSupportedOptionSelectorEnums e) { this.value = e.value; }
    public _spinGevSupportedOptionSelectorEnums intern() { for (_spinGevSupportedOptionSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinBlackLevelSelectorEnums {
    /** */
    BlackLevelSelector_All(0),
    /** */
    BlackLevelSelector_Analog(1),
    /** */
    BlackLevelSelector_Digital(2),
    NUM_BLACKLEVELSELECTOR(3);

    public final int value;
    private _spinBlackLevelSelectorEnums(int v) { this.value = v; }
    private _spinBlackLevelSelectorEnums(_spinBlackLevelSelectorEnums e) { this.value = e.value; }
    public _spinBlackLevelSelectorEnums intern() { for (_spinBlackLevelSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinBalanceWhiteAutoEnums {
    /** Sets operation mode to Off, which is manual control.*/
    BalanceWhiteAuto_Off(0),
    /** Sets operation mode to once. Once runs for a number of iterations and then sets White Balance Auto to Off.*/
    BalanceWhiteAuto_Once(1),
    /** Sets operation mode to continuous. Continuous automatically adjusts values if the colors are imbalanced.*/
    BalanceWhiteAuto_Continuous(2),
    NUM_BALANCEWHITEAUTO(3);

    public final int value;
    private _spinBalanceWhiteAutoEnums(int v) { this.value = v; }
    private _spinBalanceWhiteAutoEnums(_spinBalanceWhiteAutoEnums e) { this.value = e.value; }
    public _spinBalanceWhiteAutoEnums intern() { for (_spinBalanceWhiteAutoEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinGainAutoEnums {
    /** Gain is manually controlled*/
    GainAuto_Off(0),
    /** 
        Gain is adapted once by the device. Once it has converged, it returns to the Off state.
      */
    GainAuto_Once(1),
    /** 
        Gain is constantly adapted by the device to maximize the dynamic range.
      */
    GainAuto_Continuous(2),
    NUM_GAINAUTO(3);

    public final int value;
    private _spinGainAutoEnums(int v) { this.value = v; }
    private _spinGainAutoEnums(_spinGainAutoEnums e) { this.value = e.value; }
    public _spinGainAutoEnums intern() { for (_spinGainAutoEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinBalanceRatioSelectorEnums {
    /** 
        Selects the red balance ratio control for adjustment.  The red balance 
        ratio is relative to the green channel.
      */
    BalanceRatioSelector_Red(0),
    /** 
        Selects the blue balance ratio control for adjustment. The blue balance
        ratio is relative to the green channel.
      */
    BalanceRatioSelector_Blue(1),
    NUM_BALANCERATIOSELECTOR(2);

    public final int value;
    private _spinBalanceRatioSelectorEnums(int v) { this.value = v; }
    private _spinBalanceRatioSelectorEnums(_spinBalanceRatioSelectorEnums e) { this.value = e.value; }
    public _spinBalanceRatioSelectorEnums intern() { for (_spinBalanceRatioSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinGainSelectorEnums {
    /** */
    GainSelector_All(0),
    NUM_GAINSELECTOR(1);

    public final int value;
    private _spinGainSelectorEnums(int v) { this.value = v; }
    private _spinGainSelectorEnums(_spinGainSelectorEnums e) { this.value = e.value; }
    public _spinGainSelectorEnums intern() { for (_spinGainSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDefectCorrectionModeEnums {
    /** Pixels are replaced with the average of their neighbours.  This is the normal mode of operation.*/
    DefectCorrectionMode_Average(0),
    /** Pixels are replaced with the maximum pixel value (i.e., 255 for 8-bit images).  Can be used for debugging the table.*/
    DefectCorrectionMode_Highlight(1),
    /** Pixels are replaced by the value zero.  Can be used for testing the table.*/
    DefectCorrectionMode_Zero(2),
    NUM_DEFECTCORRECTIONMODE(3);

    public final int value;
    private _spinDefectCorrectionModeEnums(int v) { this.value = v; }
    private _spinDefectCorrectionModeEnums(_spinDefectCorrectionModeEnums e) { this.value = e.value; }
    public _spinDefectCorrectionModeEnums intern() { for (_spinDefectCorrectionModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinUserSetSelectorEnums {
    /** Factory default set.*/
    UserSetSelector_Default(0),
    /** User configurable set 0.*/
    UserSetSelector_UserSet0(1),
    /** User configurable set 1.*/
    UserSetSelector_UserSet1(2),
    NUM_USERSETSELECTOR(3);

    public final int value;
    private _spinUserSetSelectorEnums(int v) { this.value = v; }
    private _spinUserSetSelectorEnums(_spinUserSetSelectorEnums e) { this.value = e.value; }
    public _spinUserSetSelectorEnums intern() { for (_spinUserSetSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinUserSetDefaultEnums {
    /** Factory default set.*/
    UserSetDefault_Default(0),
    /** User configurable set 0.*/
    UserSetDefault_UserSet0(1),
    /** User configurable set 1.*/
    UserSetDefault_UserSet1(2),
    NUM_USERSETDEFAULT(3);

    public final int value;
    private _spinUserSetDefaultEnums(int v) { this.value = v; }
    private _spinUserSetDefaultEnums(_spinUserSetDefaultEnums e) { this.value = e.value; }
    public _spinUserSetDefaultEnums intern() { for (_spinUserSetDefaultEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinSerialPortBaudRateEnums {
    /** */
    SerialPortBaudRate_Baud300(0),
    /** */
    SerialPortBaudRate_Baud600(1),
    /** */
    SerialPortBaudRate_Baud1200(2),
    /** */
    SerialPortBaudRate_Baud2400(3),
    /** */
    SerialPortBaudRate_Baud4800(4),
    /** */
    SerialPortBaudRate_Baud9600(5),
    /** */
    SerialPortBaudRate_Baud14400(6),
    /** */
    SerialPortBaudRate_Baud19200(7),
    /** */
    SerialPortBaudRate_Baud38400(8),
    /** */
    SerialPortBaudRate_Baud57600(9),
    /** */
    SerialPortBaudRate_Baud115200(10),
    /** */
    SerialPortBaudRate_Baud230400(11),
    /** */
    SerialPortBaudRate_Baud460800(12),
    /** */
    SerialPortBaudRate_Baud921600(13),
    NUM_SERIALPORTBAUDRATE(14);

    public final int value;
    private _spinSerialPortBaudRateEnums(int v) { this.value = v; }
    private _spinSerialPortBaudRateEnums(_spinSerialPortBaudRateEnums e) { this.value = e.value; }
    public _spinSerialPortBaudRateEnums intern() { for (_spinSerialPortBaudRateEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinSerialPortParityEnums {
    /** */
    SerialPortParity_None(0),
    /** */
    SerialPortParity_Odd(1),
    /** */
    SerialPortParity_Even(2),
    /** */
    SerialPortParity_Mark(3),
    /** */
    SerialPortParity_Space(4),
    NUM_SERIALPORTPARITY(5);

    public final int value;
    private _spinSerialPortParityEnums(int v) { this.value = v; }
    private _spinSerialPortParityEnums(_spinSerialPortParityEnums e) { this.value = e.value; }
    public _spinSerialPortParityEnums intern() { for (_spinSerialPortParityEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinSerialPortSelectorEnums {
    /** */
    SerialPortSelector_SerialPort0(0),
    NUM_SERIALPORTSELECTOR(1);

    public final int value;
    private _spinSerialPortSelectorEnums(int v) { this.value = v; }
    private _spinSerialPortSelectorEnums(_spinSerialPortSelectorEnums e) { this.value = e.value; }
    public _spinSerialPortSelectorEnums intern() { for (_spinSerialPortSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinSerialPortStopBitsEnums {
    /** */
    SerialPortStopBits_Bits1(0),
    /** */
    SerialPortStopBits_Bits1AndAHalf(1),
    /** */
    SerialPortStopBits_Bits2(2),
    NUM_SERIALPORTSTOPBITS(3);

    public final int value;
    private _spinSerialPortStopBitsEnums(int v) { this.value = v; }
    private _spinSerialPortStopBitsEnums(_spinSerialPortStopBitsEnums e) { this.value = e.value; }
    public _spinSerialPortStopBitsEnums intern() { for (_spinSerialPortStopBitsEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinSerialPortSourceEnums {
    /** */
    SerialPortSource_Line0(0),
    /** */
    SerialPortSource_Line1(1),
    /** */
    SerialPortSource_Line2(2),
    /** */
    SerialPortSource_Line3(3),
    /** */
    SerialPortSource_Off(4),
    NUM_SERIALPORTSOURCE(5);

    public final int value;
    private _spinSerialPortSourceEnums(int v) { this.value = v; }
    private _spinSerialPortSourceEnums(_spinSerialPortSourceEnums e) { this.value = e.value; }
    public _spinSerialPortSourceEnums intern() { for (_spinSerialPortSourceEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinSequencerModeEnums {
    /** */
    SequencerMode_Off(0),
    /** */
    SequencerMode_On(1),
    NUM_SEQUENCERMODE(2);

    public final int value;
    private _spinSequencerModeEnums(int v) { this.value = v; }
    private _spinSequencerModeEnums(_spinSequencerModeEnums e) { this.value = e.value; }
    public _spinSequencerModeEnums intern() { for (_spinSequencerModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinSequencerConfigurationValidEnums {
    /** */
    SequencerConfigurationValid_No(0),
    /** */
    SequencerConfigurationValid_Yes(1),
    NUM_SEQUENCERCONFIGURATIONVALID(2);

    public final int value;
    private _spinSequencerConfigurationValidEnums(int v) { this.value = v; }
    private _spinSequencerConfigurationValidEnums(_spinSequencerConfigurationValidEnums e) { this.value = e.value; }
    public _spinSequencerConfigurationValidEnums intern() { for (_spinSequencerConfigurationValidEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinSequencerSetValidEnums {
    /** */
    SequencerSetValid_No(0),
    /** */
    SequencerSetValid_Yes(1),
    NUM_SEQUENCERSETVALID(2);

    public final int value;
    private _spinSequencerSetValidEnums(int v) { this.value = v; }
    private _spinSequencerSetValidEnums(_spinSequencerSetValidEnums e) { this.value = e.value; }
    public _spinSequencerSetValidEnums intern() { for (_spinSequencerSetValidEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinSequencerTriggerActivationEnums {
    /** */
    SequencerTriggerActivation_RisingEdge(0),
    /** */
    SequencerTriggerActivation_FallingEdge(1),
    /** */
    SequencerTriggerActivation_AnyEdge(2),
    /** */
    SequencerTriggerActivation_LevelHigh(3),
    /** */
    SequencerTriggerActivation_LevelLow(4),
    NUM_SEQUENCERTRIGGERACTIVATION(5);

    public final int value;
    private _spinSequencerTriggerActivationEnums(int v) { this.value = v; }
    private _spinSequencerTriggerActivationEnums(_spinSequencerTriggerActivationEnums e) { this.value = e.value; }
    public _spinSequencerTriggerActivationEnums intern() { for (_spinSequencerTriggerActivationEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinSequencerConfigurationModeEnums {
    /** */
    SequencerConfigurationMode_Off(0),
    /** */
    SequencerConfigurationMode_On(1),
    NUM_SEQUENCERCONFIGURATIONMODE(2);

    public final int value;
    private _spinSequencerConfigurationModeEnums(int v) { this.value = v; }
    private _spinSequencerConfigurationModeEnums(_spinSequencerConfigurationModeEnums e) { this.value = e.value; }
    public _spinSequencerConfigurationModeEnums intern() { for (_spinSequencerConfigurationModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinSequencerTriggerSourceEnums {
    /** */
    SequencerTriggerSource_Off(0),
    /** */
    SequencerTriggerSource_FrameStart(1),
    NUM_SEQUENCERTRIGGERSOURCE(2);

    public final int value;
    private _spinSequencerTriggerSourceEnums(int v) { this.value = v; }
    private _spinSequencerTriggerSourceEnums(_spinSequencerTriggerSourceEnums e) { this.value = e.value; }
    public _spinSequencerTriggerSourceEnums intern() { for (_spinSequencerTriggerSourceEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTransferQueueModeEnums {
    /** Blocks first In are transferred Out first.*/
    TransferQueueMode_FirstInFirstOut(0),
    NUM_TRANSFERQUEUEMODE(1);

    public final int value;
    private _spinTransferQueueModeEnums(int v) { this.value = v; }
    private _spinTransferQueueModeEnums(_spinTransferQueueModeEnums e) { this.value = e.value; }
    public _spinTransferQueueModeEnums intern() { for (_spinTransferQueueModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTransferOperationModeEnums {
    /** Continuous*/
    TransferOperationMode_Continuous(0),
    /** Multi Block*/
    TransferOperationMode_MultiBlock(1),
    NUM_TRANSFEROPERATIONMODE(2);

    public final int value;
    private _spinTransferOperationModeEnums(int v) { this.value = v; }
    private _spinTransferOperationModeEnums(_spinTransferOperationModeEnums e) { this.value = e.value; }
    public _spinTransferOperationModeEnums intern() { for (_spinTransferOperationModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTransferControlModeEnums {
    /** Basic*/
    TransferControlMode_Basic(0),
    /** Automatic*/
    TransferControlMode_Automatic(1),
    /** User Controlled*/
    TransferControlMode_UserControlled(2),
    NUM_TRANSFERCONTROLMODE(3);

    public final int value;
    private _spinTransferControlModeEnums(int v) { this.value = v; }
    private _spinTransferControlModeEnums(_spinTransferControlModeEnums e) { this.value = e.value; }
    public _spinTransferControlModeEnums intern() { for (_spinTransferControlModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkGainSelectorEnums {
    /** */
    ChunkGainSelector_All(0),
    /** */
    ChunkGainSelector_Red(1),
    /** */
    ChunkGainSelector_Green(2),
    /** */
    ChunkGainSelector_Blue(3),
    NUM_CHUNKGAINSELECTOR(4);

    public final int value;
    private _spinChunkGainSelectorEnums(int v) { this.value = v; }
    private _spinChunkGainSelectorEnums(_spinChunkGainSelectorEnums e) { this.value = e.value; }
    public _spinChunkGainSelectorEnums intern() { for (_spinChunkGainSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkSelectorEnums {
    /** */
    ChunkSelector_Image(0),
    /** */
    ChunkSelector_CRC(1),
    /** */
    ChunkSelector_FrameID(2),
    /** */
    ChunkSelector_OffsetX(3),
    /** */
    ChunkSelector_OffsetY(4),
    /** */
    ChunkSelector_Width(5),
    /** */
    ChunkSelector_Height(6),
    /** */
    ChunkSelector_ExposureTime(7),
    /** */
    ChunkSelector_Gain(8),
    /** */
    ChunkSelector_BlackLevel(9),
    /** */
    ChunkSelector_PixelFormat(10),
    /** */
    ChunkSelector_Timestamp(11),
    /** */
    ChunkSelector_SequencerSetActive(12),
    /** */
    ChunkSelector_SerialData(13),
    /** */
    ChunkSelector_ExposureEndLineStatusAll(14),
    NUM_CHUNKSELECTOR(15);

    public final int value;
    private _spinChunkSelectorEnums(int v) { this.value = v; }
    private _spinChunkSelectorEnums(_spinChunkSelectorEnums e) { this.value = e.value; }
    public _spinChunkSelectorEnums intern() { for (_spinChunkSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkBlackLevelSelectorEnums {
    /** */
    ChunkBlackLevelSelector_All(0),
    NUM_CHUNKBLACKLEVELSELECTOR(1);

    public final int value;
    private _spinChunkBlackLevelSelectorEnums(int v) { this.value = v; }
    private _spinChunkBlackLevelSelectorEnums(_spinChunkBlackLevelSelectorEnums e) { this.value = e.value; }
    public _spinChunkBlackLevelSelectorEnums intern() { for (_spinChunkBlackLevelSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkPixelFormatEnums {
    /** */
    ChunkPixelFormat_Mono8(0),
    /** */
    ChunkPixelFormat_Mono12Packed(1),
    /** */
    ChunkPixelFormat_Mono16(2),
    /** */
    ChunkPixelFormat_RGB8Packed(3),
    /** */
    ChunkPixelFormat_YUV422Packed(4),
    /** */
    ChunkPixelFormat_BayerGR8(5),
    /** */
    ChunkPixelFormat_BayerRG8(6),
    /** */
    ChunkPixelFormat_BayerGB8(7),
    /** */
    ChunkPixelFormat_BayerBG8(8),
    /** */
    ChunkPixelFormat_YCbCr601_422_8_CbYCrY(9),
    NUM_CHUNKPIXELFORMAT(10);

    public final int value;
    private _spinChunkPixelFormatEnums(int v) { this.value = v; }
    private _spinChunkPixelFormatEnums(_spinChunkPixelFormatEnums e) { this.value = e.value; }
    public _spinChunkPixelFormatEnums intern() { for (_spinChunkPixelFormatEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinFileOperationStatusEnums {
    /** File Operation was sucessful.*/
    FileOperationStatus_Success(0),
    /** File Operation failed.*/
    FileOperationStatus_Failure(1),
    /** An overflow occurred while executing the File Operation.*/
    FileOperationStatus_Overflow(2),
    NUM_FILEOPERATIONSTATUS(3);

    public final int value;
    private _spinFileOperationStatusEnums(int v) { this.value = v; }
    private _spinFileOperationStatusEnums(_spinFileOperationStatusEnums e) { this.value = e.value; }
    public _spinFileOperationStatusEnums intern() { for (_spinFileOperationStatusEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinFileOpenModeEnums {
    /** */
    FileOpenMode_Read(0),
    /** */
    FileOpenMode_Write(1),
    /** */
    FileOpenMode_ReadWrite(2),
    NUM_FILEOPENMODE(3);

    public final int value;
    private _spinFileOpenModeEnums(int v) { this.value = v; }
    private _spinFileOpenModeEnums(_spinFileOpenModeEnums e) { this.value = e.value; }
    public _spinFileOpenModeEnums intern() { for (_spinFileOpenModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinFileOperationSelectorEnums {
    /** */
    FileOperationSelector_Open(0),
    /** */
    FileOperationSelector_Close(1),
    /** */
    FileOperationSelector_Read(2),
    /** */
    FileOperationSelector_Write(3),
    /** */
    FileOperationSelector_Delete(4),
    NUM_FILEOPERATIONSELECTOR(5);

    public final int value;
    private _spinFileOperationSelectorEnums(int v) { this.value = v; }
    private _spinFileOperationSelectorEnums(_spinFileOperationSelectorEnums e) { this.value = e.value; }
    public _spinFileOperationSelectorEnums intern() { for (_spinFileOperationSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinFileSelectorEnums {
    /** */
    FileSelector_UserSetDefault(0),
    /** */
    FileSelector_UserSet0(1),
    /** */
    FileSelector_UserSet1(2),
    /** */
    FileSelector_UserFile1(3),
    /** */
    FileSelector_SerialPort0(4),
    NUM_FILESELECTOR(5);

    public final int value;
    private _spinFileSelectorEnums(int v) { this.value = v; }
    private _spinFileSelectorEnums(_spinFileSelectorEnums e) { this.value = e.value; }
    public _spinFileSelectorEnums intern() { for (_spinFileSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinBinningSelectorEnums {
    /** 
        The total amount of binning to be performed on the captured sensor data.
      */
    BinningSelector_All(0),
    /** 
        The portion of binning to be performed on the sensor directly.
      */
    BinningSelector_Sensor(1),
    /** 
        The portion of binning to be performed by the image signal processing
        engine (ISP) outside of the sensor. Note: the ISP can be disabled.
      */
    BinningSelector_ISP(2),
    NUM_BINNINGSELECTOR(3);

    public final int value;
    private _spinBinningSelectorEnums(int v) { this.value = v; }
    private _spinBinningSelectorEnums(_spinBinningSelectorEnums e) { this.value = e.value; }
    public _spinBinningSelectorEnums intern() { for (_spinBinningSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTestPatternGeneratorSelectorEnums {
    /** TestPattern feature controls the sensor{@code s test pattern generator.*/
    TestPatternGeneratorSelector_Sensor(0),
    /** TestPattern feature controls the test pattern inserted at the start of the image pipeline.*/
    TestPatternGeneratorSelector_PipelineStart(1),
    NUM_TESTPATTERNGENERATORSELECTOR(2);

    public final int value;
    private _spinTestPatternGeneratorSelectorEnums(int v) { this.value = v; }
    private _spinTestPatternGeneratorSelectorEnums(_spinTestPatternGeneratorSelectorEnums e) { this.value = e.value; }
    public _spinTestPatternGeneratorSelectorEnums intern() { for (_spinTestPatternGeneratorSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTestPatternEnums {
    /** Test pattern is disabled.*/
    TestPattern_Off(0),
    /** Pixel value increments by 1 for each pixel.*/
    TestPattern_Increment(1),
    /** A test pattern generated by the image sensor.  The pattern varies for different sensor models.*/
    TestPattern_SensorTestPattern(2),
    NUM_TESTPATTERN(3);

    public final int value;
    private _spinTestPatternEnums(int v) { this.value = v; }
    private _spinTestPatternEnums(_spinTestPatternEnums e) { this.value = e.value; }
    public _spinTestPatternEnums intern() { for (_spinTestPatternEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinPixelColorFilterEnums {
    /** No color filter.*/
    PixelColorFilter_None(0),
    /** Bayer Red Green filter.*/
    PixelColorFilter_BayerRG(1),
    /** Bayer Green Blue filter.*/
    PixelColorFilter_BayerGB(2),
    /** Bayer Green Red filter.*/
    PixelColorFilter_BayerGR(3),
    /** Bayer Blue Green filter.*/
    PixelColorFilter_BayerBG(4),
    NUM_PIXELCOLORFILTER(5);

    public final int value;
    private _spinPixelColorFilterEnums(int v) { this.value = v; }
    private _spinPixelColorFilterEnums(_spinPixelColorFilterEnums e) { this.value = e.value; }
    public _spinPixelColorFilterEnums intern() { for (_spinPixelColorFilterEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinAdcBitDepthEnums {
    /** */
    AdcBitDepth_Bit8(0),
    /** */
    AdcBitDepth_Bit10(1),
    /** */
    AdcBitDepth_Bit12(2),
    /** */
    AdcBitDepth_Bit14(3),
    NUM_ADCBITDEPTH(4);

    public final int value;
    private _spinAdcBitDepthEnums(int v) { this.value = v; }
    private _spinAdcBitDepthEnums(_spinAdcBitDepthEnums e) { this.value = e.value; }
    public _spinAdcBitDepthEnums intern() { for (_spinAdcBitDepthEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDecimationHorizontalModeEnums {
    /** The value of every Nth pixel is kept, others are discarded.*/
    DecimationHorizontalMode_Discard(0),
    NUM_DECIMATIONHORIZONTALMODE(1);

    public final int value;
    private _spinDecimationHorizontalModeEnums(int v) { this.value = v; }
    private _spinDecimationHorizontalModeEnums(_spinDecimationHorizontalModeEnums e) { this.value = e.value; }
    public _spinDecimationHorizontalModeEnums intern() { for (_spinDecimationHorizontalModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinBinningVerticalModeEnums {
    /** 
        The response from the combined vertical cells is added, resulting
        in increased sensitivity (a brighter image).
      */
    BinningVerticalMode_Sum(0),
    /** 
        The response from the combined vertical cells is averaged,
        resulting in increased signal/noise ratio. Not all sensors support average binning.
      */
    BinningVerticalMode_Average(1),
    NUM_BINNINGVERTICALMODE(2);

    public final int value;
    private _spinBinningVerticalModeEnums(int v) { this.value = v; }
    private _spinBinningVerticalModeEnums(_spinBinningVerticalModeEnums e) { this.value = e.value; }
    public _spinBinningVerticalModeEnums intern() { for (_spinBinningVerticalModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinPixelSizeEnums {
    /** 1 bit per pixel.*/
    PixelSize_Bpp1(0),
    /** 2 bits per pixel.*/
    PixelSize_Bpp2(1),
    /** 4 bits per pixel.*/
    PixelSize_Bpp4(2),
    /** 8 bits per pixel.*/
    PixelSize_Bpp8(3),
    /** 10 bits per pixel.*/
    PixelSize_Bpp10(4),
    /** 12 bits per pixel.*/
    PixelSize_Bpp12(5),
    /** 14 bits per pixel.*/
    PixelSize_Bpp14(6),
    /** 16 bits per pixel.*/
    PixelSize_Bpp16(7),
    /** 20 bits per pixel.*/
    PixelSize_Bpp20(8),
    /** 24 bits per pixel.*/
    PixelSize_Bpp24(9),
    /** 30 bits per pixel.*/
    PixelSize_Bpp30(10),
    /** 32 bits per pixel.*/
    PixelSize_Bpp32(11),
    /** 36 bits per pixel.*/
    PixelSize_Bpp36(12),
    /** 48 bits per pixel.*/
    PixelSize_Bpp48(13),
    /** 64 bits per pixel.*/
    PixelSize_Bpp64(14),
    /** 96 bits per pixel.*/
    PixelSize_Bpp96(15),
    NUM_PIXELSIZE(16);

    public final int value;
    private _spinPixelSizeEnums(int v) { this.value = v; }
    private _spinPixelSizeEnums(_spinPixelSizeEnums e) { this.value = e.value; }
    public _spinPixelSizeEnums intern() { for (_spinPixelSizeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDecimationSelectorEnums {
    /** The total amount of decimation to be performed on the captured image data.*/
    DecimationSelector_All(0),
    /** The portion of decimation to be performed on the sensor directly. Currently this is the only decimation layer available and hence is identical to the "All" layer.  All decimation modification should therefore be done via the "All" layer only.
      */
    DecimationSelector_Sensor(1),
    NUM_DECIMATIONSELECTOR(2);

    public final int value;
    private _spinDecimationSelectorEnums(int v) { this.value = v; }
    private _spinDecimationSelectorEnums(_spinDecimationSelectorEnums e) { this.value = e.value; }
    public _spinDecimationSelectorEnums intern() { for (_spinDecimationSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinImageCompressionModeEnums {
    /** */
    ImageCompressionMode_Off(0),
    /** */
    ImageCompressionMode_Lossless(1),
    NUM_IMAGECOMPRESSIONMODE(2);

    public final int value;
    private _spinImageCompressionModeEnums(int v) { this.value = v; }
    private _spinImageCompressionModeEnums(_spinImageCompressionModeEnums e) { this.value = e.value; }
    public _spinImageCompressionModeEnums intern() { for (_spinImageCompressionModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinBinningHorizontalModeEnums {
    /** 
        The response from the combined horizontal cells is added, 
        resulting in increased sensitivity (a brighter image).
      */
    BinningHorizontalMode_Sum(0),
    /** 
        The response from the combined horizontal cells is averaged,
        resulting in increased signal/noise ratio. Not all sensors support average binning.
      */
    BinningHorizontalMode_Average(1),
    NUM_BINNINGHORIZONTALMODE(2);

    public final int value;
    private _spinBinningHorizontalModeEnums(int v) { this.value = v; }
    private _spinBinningHorizontalModeEnums(_spinBinningHorizontalModeEnums e) { this.value = e.value; }
    public _spinBinningHorizontalModeEnums intern() { for (_spinBinningHorizontalModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinPixelFormatEnums {
    /** */
    PixelFormat_Mono8(0),
    /** */
    PixelFormat_Mono16(1),
    /** */
    PixelFormat_RGB8Packed(2),
    /** */
    PixelFormat_BayerGR8(3),
    /** */
    PixelFormat_BayerRG8(4),
    /** */
    PixelFormat_BayerGB8(5),
    /** */
    PixelFormat_BayerBG8(6),
    /** */
    PixelFormat_BayerGR16(7),
    /** */
    PixelFormat_BayerRG16(8),
    /** */
    PixelFormat_BayerGB16(9),
    /** */
    PixelFormat_BayerBG16(10),
    /** */
    PixelFormat_Mono12Packed(11),
    /** */
    PixelFormat_BayerGR12Packed(12),
    /** */
    PixelFormat_BayerRG12Packed(13),
    /** */
    PixelFormat_BayerGB12Packed(14),
    /** */
    PixelFormat_BayerBG12Packed(15),
    /** */
    PixelFormat_YUV411Packed(16),
    /** */
    PixelFormat_YUV422Packed(17),
    /** */
    PixelFormat_YUV444Packed(18),
    /** */
    PixelFormat_Mono12p(19),
    /** */
    PixelFormat_BayerGR12p(20),
    /** */
    PixelFormat_BayerRG12p(21),
    /** */
    PixelFormat_BayerGB12p(22),
    /** */
    PixelFormat_BayerBG12p(23),
    /** */
    PixelFormat_YCbCr8(24),
    /** */
    PixelFormat_YCbCr422_8(25),
    /** */
    PixelFormat_YCbCr411_8(26),
    /** */
    PixelFormat_BGR8(27),
    /** */
    PixelFormat_BGRa8(28),
    /** */
    PixelFormat_Mono10Packed(29),
    /** */
    PixelFormat_BayerGR10Packed(30),
    /** */
    PixelFormat_BayerRG10Packed(31),
    /** */
    PixelFormat_BayerGB10Packed(32),
    /** */
    PixelFormat_BayerBG10Packed(33),
    /** */
    PixelFormat_Mono10p(34),
    /** */
    PixelFormat_BayerGR10p(35),
    /** */
    PixelFormat_BayerRG10p(36),
    /** */
    PixelFormat_BayerGB10p(37),
    /** */
    PixelFormat_BayerBG10p(38),
    /** Monochrome 1-bit packed*/
    PixelFormat_Mono1p(39),
    /** Monochrome 2-bit packed*/
    PixelFormat_Mono2p(40),
    /** Monochrome 4-bit packed*/
    PixelFormat_Mono4p(41),
    /** Monochrome 8-bit signed*/
    PixelFormat_Mono8s(42),
    /** Monochrome 10-bit unpacked*/
    PixelFormat_Mono10(43),
    /** Monochrome 12-bit unpacked*/
    PixelFormat_Mono12(44),
    /** Monochrome 14-bit unpacked*/
    PixelFormat_Mono14(45),
    /** Monochrome 16-bit signed*/
    PixelFormat_Mono16s(46),
    /** Monochrome 32-bit float*/
    PixelFormat_Mono32f(47),
    /** Bayer Blue-Green 10-bit unpacked*/
    PixelFormat_BayerBG10(48),
    /** Bayer Blue-Green 12-bit unpacked*/
    PixelFormat_BayerBG12(49),
    /** Bayer Green-Blue 10-bit unpacked*/
    PixelFormat_BayerGB10(50),
    /** Bayer Green-Blue 12-bit unpacked*/
    PixelFormat_BayerGB12(51),
    /** Bayer Green-Red 10-bit unpacked*/
    PixelFormat_BayerGR10(52),
    /** Bayer Green-Red 12-bit unpacked*/
    PixelFormat_BayerGR12(53),
    /** Bayer Red-Green 10-bit unpacked*/
    PixelFormat_BayerRG10(54),
    /** Bayer Red-Green 12-bit unpacked*/
    PixelFormat_BayerRG12(55),
    /** Red-Green-Blue-alpha 8-bit*/
    PixelFormat_RGBa8(56),
    /** Red-Green-Blue-alpha 10-bit unpacked*/
    PixelFormat_RGBa10(57),
    /** Red-Green-Blue-alpha 10-bit packed*/
    PixelFormat_RGBa10p(58),
    /** Red-Green-Blue-alpha 12-bit unpacked*/
    PixelFormat_RGBa12(59),
    /** Red-Green-Blue-alpha 12-bit packed*/
    PixelFormat_RGBa12p(60),
    /** Red-Green-Blue-alpha 14-bit unpacked*/
    PixelFormat_RGBa14(61),
    /** Red-Green-Blue-alpha 16-bit*/
    PixelFormat_RGBa16(62),
    /** Red-Green-Blue 8-bit*/
    PixelFormat_RGB8(63),
    /** Red-Green-Blue 8-bit planar*/
    PixelFormat_RGB8_Planar(64),
    /** Red-Green-Blue 10-bit unpacked*/
    PixelFormat_RGB10(65),
    /** Red-Green-Blue 10-bit unpacked planar*/
    PixelFormat_RGB10_Planar(66),
    /** Red-Green-Blue 10-bit packed*/
    PixelFormat_RGB10p(67),
    /** Red-Green-Blue 10-bit packed into 32-bit*/
    PixelFormat_RGB10p32(68),
    /** Red-Green-Blue 12-bit unpacked*/
    PixelFormat_RGB12(69),
    /** Red-Green-Blue 12-bit unpacked planar*/
    PixelFormat_RGB12_Planar(70),
    /** Red-Green-Blue 12-bit packed  */
    PixelFormat_RGB12p(71),
    /** Red-Green-Blue 14-bit unpacked*/
    PixelFormat_RGB14(72),
    /** Red-Green-Blue 16-bit  */
    PixelFormat_RGB16(73),
    /** Red-Green-Blue 16-bit signed*/
    PixelFormat_RGB16s(74),
    /** Red-Green-Blue 32-bit float*/
    PixelFormat_RGB32f(75),
    /** Red-Green-Blue 16-bit planar*/
    PixelFormat_RGB16_Planar(76),
    /** Red-Green-Blue 5/6/5-bit packed*/
    PixelFormat_RGB565p(77),
    /** Blue-Green-Red-alpha 10-bit unpacked*/
    PixelFormat_BGRa10(78),
    /** Blue-Green-Red-alpha 10-bit packed*/
    PixelFormat_BGRa10p(79),
    /** Blue-Green-Red-alpha 12-bit unpacked*/
    PixelFormat_BGRa12(80),
    /** Blue-Green-Red-alpha 12-bit packed*/
    PixelFormat_BGRa12p(81),
    /** Blue-Green-Red-alpha 14-bit unpacked*/
    PixelFormat_BGRa14(82),
    /** Blue-Green-Red-alpha 16-bit*/
    PixelFormat_BGRa16(83),
    /** Red-Green-Blue-alpha 32-bit float*/
    PixelFormat_RGBa32f(84),
    /** Blue-Green-Red 10-bit unpacked*/
    PixelFormat_BGR10(85),
    /** Blue-Green-Red 10-bit packed*/
    PixelFormat_BGR10p(86),
    /** Blue-Green-Red 12-bit unpacked*/
    PixelFormat_BGR12(87),
    /** Blue-Green-Red 12-bit packed*/
    PixelFormat_BGR12p(88),
    /** Blue-Green-Red 14-bit unpacked*/
    PixelFormat_BGR14(89),
    /** Blue-Green-Red 16-bit*/
    PixelFormat_BGR16(90),
    /** Blue-Green-Red 5/6/5-bit packed*/
    PixelFormat_BGR565p(91),
    /** Red 8-bit*/
    PixelFormat_R8(92),
    /** Red 10-bit*/
    PixelFormat_R10(93),
    /** Red 12-bit*/
    PixelFormat_R12(94),
    /** Red 16-bit*/
    PixelFormat_R16(95),
    /** Green 8-bit*/
    PixelFormat_G8(96),
    /** Green 10-bit*/
    PixelFormat_G10(97),
    /** Green 12-bit*/
    PixelFormat_G12(98),
    /** Green 16-bit*/
    PixelFormat_G16(99),
    /** Blue 8-bit*/
    PixelFormat_B8(100),
    /** Blue 10-bit*/
    PixelFormat_B10(101),
    /** Blue 12-bit*/
    PixelFormat_B12(102),
    /** Blue 16-bit*/
    PixelFormat_B16(103),
    /** 3D coordinate A-B-C 8-bit*/
    PixelFormat_Coord3D_ABC8(104),
    /** 3D coordinate A-B-C 8-bit planar*/
    PixelFormat_Coord3D_ABC8_Planar(105),
    /** 3D coordinate A-B-C 10-bit packed*/
    PixelFormat_Coord3D_ABC10p(106),
    /** 3D coordinate A-B-C 10-bit packed planar*/
    PixelFormat_Coord3D_ABC10p_Planar(107),
    /** 3D coordinate A-B-C 12-bit packed*/
    PixelFormat_Coord3D_ABC12p(108),
    /** 3D coordinate A-B-C 12-bit packed planar*/
    PixelFormat_Coord3D_ABC12p_Planar(109),
    /** 3D coordinate A-B-C 16-bit*/
    PixelFormat_Coord3D_ABC16(110),
    /** 3D coordinate A-B-C 16-bit planar*/
    PixelFormat_Coord3D_ABC16_Planar(111),
    /** 3D coordinate A-B-C 32-bit floating point*/
    PixelFormat_Coord3D_ABC32f(112),
    /** 3D coordinate A-B-C 32-bit floating point planar*/
    PixelFormat_Coord3D_ABC32f_Planar(113),
    /** 3D coordinate A-C 8-bit*/
    PixelFormat_Coord3D_AC8(114),
    /** 3D coordinate A-C 8-bit planar*/
    PixelFormat_Coord3D_AC8_Planar(115),
    /** 3D coordinate A-C 10-bit packed*/
    PixelFormat_Coord3D_AC10p(116),
    /** 3D coordinate A-C 10-bit packed planar*/
    PixelFormat_Coord3D_AC10p_Planar(117),
    /** 3D coordinate A-C 12-bit packed*/
    PixelFormat_Coord3D_AC12p(118),
    /** 3D coordinate A-C 12-bit packed planar*/
    PixelFormat_Coord3D_AC12p_Planar(119),
    /** 3D coordinate A-C 16-bit*/
    PixelFormat_Coord3D_AC16(120),
    /** 3D coordinate A-C 16-bit planar*/
    PixelFormat_Coord3D_AC16_Planar(121),
    /** 3D coordinate A-C 32-bit floating point*/
    PixelFormat_Coord3D_AC32f(122),
    /** 3D coordinate A-C 32-bit floating point planar*/
    PixelFormat_Coord3D_AC32f_Planar(123),
    /** 3D coordinate A 8-bit*/
    PixelFormat_Coord3D_A8(124),
    /** 3D coordinate A 10-bit packed*/
    PixelFormat_Coord3D_A10p(125),
    /** 3D coordinate A 12-bit packed*/
    PixelFormat_Coord3D_A12p(126),
    /** 3D coordinate A 16-bit*/
    PixelFormat_Coord3D_A16(127),
    /** 3D coordinate A 32-bit floating point*/
    PixelFormat_Coord3D_A32f(128),
    /** 3D coordinate B 8-bit*/
    PixelFormat_Coord3D_B8(129),
    /** 3D coordinate B 10-bit packed*/
    PixelFormat_Coord3D_B10p(130),
    /** 3D coordinate B 12-bit packed*/
    PixelFormat_Coord3D_B12p(131),
    /** 3D coordinate B 16-bit*/
    PixelFormat_Coord3D_B16(132),
    /** 3D coordinate B 32-bit floating point*/
    PixelFormat_Coord3D_B32f(133),
    /** 3D coordinate C 8-bit*/
    PixelFormat_Coord3D_C8(134),
    /** 3D coordinate C 10-bit packed*/
    PixelFormat_Coord3D_C10p(135),
    /** 3D coordinate C 12-bit packed*/
    PixelFormat_Coord3D_C12p(136),
    /** 3D coordinate C 16-bit*/
    PixelFormat_Coord3D_C16(137),
    /** 3D coordinate C 32-bit floating point*/
    PixelFormat_Coord3D_C32f(138),
    /** Confidence 1-bit unpacked*/
    PixelFormat_Confidence1(139),
    /** Confidence 1-bit packed*/
    PixelFormat_Confidence1p(140),
    /** Confidence 8-bit*/
    PixelFormat_Confidence8(141),
    /** Confidence 16-bit*/
    PixelFormat_Confidence16(142),
    /** Confidence 32-bit floating point*/
    PixelFormat_Confidence32f(143),
    /** Bi-color Blue/Green - Red/Green 8-bit*/
    PixelFormat_BiColorBGRG8(144),
    /** Bi-color Blue/Green - Red/Green 10-bit unpacked*/
    PixelFormat_BiColorBGRG10(145),
    /** Bi-color Blue/Green - Red/Green 10-bit packed*/
    PixelFormat_BiColorBGRG10p(146),
    /** Bi-color Blue/Green - Red/Green 12-bit unpacked*/
    PixelFormat_BiColorBGRG12(147),
    /** Bi-color Blue/Green - Red/Green 12-bit packed*/
    PixelFormat_BiColorBGRG12p(148),
    /** Bi-color Red/Green - Blue/Green 8-bit*/
    PixelFormat_BiColorRGBG8(149),
    /** Bi-color Red/Green - Blue/Green 10-bit unpacked*/
    PixelFormat_BiColorRGBG10(150),
    /** Bi-color Red/Green - Blue/Green 10-bit packed*/
    PixelFormat_BiColorRGBG10p(151),
    /** Bi-color Red/Green - Blue/Green 12-bit unpacked*/
    PixelFormat_BiColorRGBG12(152),
    /** Bi-color Red/Green - Blue/Green 12-bit packed*/
    PixelFormat_BiColorRGBG12p(153),
    /** Sparse Color Filter #1 White-Blue-White-Green 8-bit*/
    PixelFormat_SCF1WBWG8(154),
    /** Sparse Color Filter #1 White-Blue-White-Green 10-bit unpacked*/
    PixelFormat_SCF1WBWG10(155),
    /** Sparse Color Filter #1 White-Blue-White-Green 10-bit packed*/
    PixelFormat_SCF1WBWG10p(156),
    /** Sparse Color Filter #1 White-Blue-White-Green 12-bit unpacked*/
    PixelFormat_SCF1WBWG12(157),
    /** Sparse Color Filter #1 White-Blue-White-Green 12-bit packed*/
    PixelFormat_SCF1WBWG12p(158),
    /** Sparse Color Filter #1 White-Blue-White-Green 14-bit unpacked*/
    PixelFormat_SCF1WBWG14(159),
    /** Sparse Color Filter #1 White-Blue-White-Green 16-bit unpacked*/
    PixelFormat_SCF1WBWG16(160),
    /** Sparse Color Filter #1 White-Green-White-Blue 8-bit*/
    PixelFormat_SCF1WGWB8(161),
    /** Sparse Color Filter #1 White-Green-White-Blue 10-bit unpacked*/
    PixelFormat_SCF1WGWB10(162),
    /** Sparse Color Filter #1 White-Green-White-Blue 10-bit packed*/
    PixelFormat_SCF1WGWB10p(163),
    /** Sparse Color Filter #1 White-Green-White-Blue 12-bit unpacked*/
    PixelFormat_SCF1WGWB12(164),
    /** Sparse Color Filter #1 White-Green-White-Blue 12-bit packed*/
    PixelFormat_SCF1WGWB12p(165),
    /** Sparse Color Filter #1 White-Green-White-Blue 14-bit unpacked*/
    PixelFormat_SCF1WGWB14(166),
    /** Sparse Color Filter #1 White-Green-White-Blue 16-bit*/
    PixelFormat_SCF1WGWB16(167),
    /** Sparse Color Filter #1 White-Green-White-Red 8-bit*/
    PixelFormat_SCF1WGWR8(168),
    /** Sparse Color Filter #1 White-Green-White-Red 10-bit unpacked*/
    PixelFormat_SCF1WGWR10(169),
    /** Sparse Color Filter #1 White-Green-White-Red 10-bit packed*/
    PixelFormat_SCF1WGWR10p(170),
    /** Sparse Color Filter #1 White-Green-White-Red 12-bit unpacked*/
    PixelFormat_SCF1WGWR12(171),
    /** Sparse Color Filter #1 White-Green-White-Red 12-bit packed*/
    PixelFormat_SCF1WGWR12p(172),
    /** Sparse Color Filter #1 White-Green-White-Red 14-bit unpacked*/
    PixelFormat_SCF1WGWR14(173),
    /** Sparse Color Filter #1 White-Green-White-Red 16-bit*/
    PixelFormat_SCF1WGWR16(174),
    /** Sparse Color Filter #1 White-Red-White-Green 8-bit*/
    PixelFormat_SCF1WRWG8(175),
    /** Sparse Color Filter #1 White-Red-White-Green 10-bit unpacked*/
    PixelFormat_SCF1WRWG10(176),
    /** Sparse Color Filter #1 White-Red-White-Green 10-bit packed*/
    PixelFormat_SCF1WRWG10p(177),
    /** Sparse Color Filter #1 White-Red-White-Green 12-bit unpacked*/
    PixelFormat_SCF1WRWG12(178),
    /** Sparse Color Filter #1 White-Red-White-Green 12-bit packed*/
    PixelFormat_SCF1WRWG12p(179),
    /** Sparse Color Filter #1 White-Red-White-Green 14-bit unpacked*/
    PixelFormat_SCF1WRWG14(180),
    /** Sparse Color Filter #1 White-Red-White-Green 16-bit*/
    PixelFormat_SCF1WRWG16(181),
    /** YCbCr 4:4:4 8-bit*/
    PixelFormat_YCbCr8_CbYCr(182),
    /** YCbCr 4:4:4 10-bit unpacked*/
    PixelFormat_YCbCr10_CbYCr(183),
    /** YCbCr 4:4:4 10-bit packed*/
    PixelFormat_YCbCr10p_CbYCr(184),
    /** YCbCr 4:4:4 12-bit unpacked*/
    PixelFormat_YCbCr12_CbYCr(185),
    /** YCbCr 4:4:4 12-bit packed*/
    PixelFormat_YCbCr12p_CbYCr(186),
    /** YCbCr 4:1:1 8-bit*/
    PixelFormat_YCbCr411_8_CbYYCrYY(187),
    /** YCbCr 4:2:2 8-bit*/
    PixelFormat_YCbCr422_8_CbYCrY(188),
    /** YCbCr 4:2:2 10-bit unpacked*/
    PixelFormat_YCbCr422_10(189),
    /** YCbCr 4:2:2 10-bit unpacked*/
    PixelFormat_YCbCr422_10_CbYCrY(190),
    /** YCbCr 4:2:2 10-bit packed*/
    PixelFormat_YCbCr422_10p(191),
    /** YCbCr 4:2:2 10-bit packed*/
    PixelFormat_YCbCr422_10p_CbYCrY(192),
    /** YCbCr 4:2:2 12-bit unpacked*/
    PixelFormat_YCbCr422_12(193),
    /** YCbCr 4:2:2 12-bit unpacked*/
    PixelFormat_YCbCr422_12_CbYCrY(194),
    /** YCbCr 4:2:2 12-bit packed*/
    PixelFormat_YCbCr422_12p(195),
    /** YCbCr 4:2:2 12-bit packed*/
    PixelFormat_YCbCr422_12p_CbYCrY(196),
    /** YCbCr 4:4:4 8-bit BT.601*/
    PixelFormat_YCbCr601_8_CbYCr(197),
    /** YCbCr 4:4:4 10-bit unpacked BT.601*/
    PixelFormat_YCbCr601_10_CbYCr(198),
    /** YCbCr 4:4:4 10-bit packed BT.601*/
    PixelFormat_YCbCr601_10p_CbYCr(199),
    /** YCbCr 4:4:4 12-bit unpacked BT.601*/
    PixelFormat_YCbCr601_12_CbYCr(200),
    /** YCbCr 4:4:4 12-bit packed BT.601*/
    PixelFormat_YCbCr601_12p_CbYCr(201),
    /** YCbCr 4:1:1 8-bit BT.601*/
    PixelFormat_YCbCr601_411_8_CbYYCrYY(202),
    /** YCbCr 4:2:2 8-bit BT.601*/
    PixelFormat_YCbCr601_422_8(203),
    /** YCbCr 4:2:2 8-bit BT.601*/
    PixelFormat_YCbCr601_422_8_CbYCrY(204),
    /** YCbCr 4:2:2 10-bit unpacked BT.601*/
    PixelFormat_YCbCr601_422_10(205),
    /** YCbCr 4:2:2 10-bit unpacked BT.601*/
    PixelFormat_YCbCr601_422_10_CbYCrY(206),
    /** YCbCr 4:2:2 10-bit packed BT.601*/
    PixelFormat_YCbCr601_422_10p(207),
    /** YCbCr 4:2:2 10-bit packed BT.601*/
    PixelFormat_YCbCr601_422_10p_CbYCrY(208),
    /** YCbCr 4:2:2 12-bit unpacked BT.601*/
    PixelFormat_YCbCr601_422_12(209),
    /** YCbCr 4:2:2 12-bit unpacked BT.601*/
    PixelFormat_YCbCr601_422_12_CbYCrY(210),
    /** YCbCr 4:2:2 12-bit packed BT.601*/
    PixelFormat_YCbCr601_422_12p(211),
    /** YCbCr 4:2:2 12-bit packed BT.601*/
    PixelFormat_YCbCr601_422_12p_CbYCrY(212),
    /** YCbCr 4:4:4 8-bit BT.709*/
    PixelFormat_YCbCr709_8_CbYCr(213),
    /** YCbCr 4:4:4 10-bit unpacked BT.709*/
    PixelFormat_YCbCr709_10_CbYCr(214),
    /** YCbCr 4:4:4 10-bit packed BT.709*/
    PixelFormat_YCbCr709_10p_CbYCr(215),
    /** YCbCr 4:4:4 12-bit unpacked BT.709*/
    PixelFormat_YCbCr709_12_CbYCr(216),
    /** YCbCr 4:4:4 12-bit packed BT.709*/
    PixelFormat_YCbCr709_12p_CbYCr(217),
    /** YCbCr 4:1:1 8-bit BT.709*/
    PixelFormat_YCbCr709_411_8_CbYYCrYY(218),
    /** YCbCr 4:2:2 8-bit BT.709*/
    PixelFormat_YCbCr709_422_8(219),
    /** YCbCr 4:2:2 8-bit BT.709*/
    PixelFormat_YCbCr709_422_8_CbYCrY(220),
    /** YCbCr 4:2:2 10-bit unpacked BT.709*/
    PixelFormat_YCbCr709_422_10(221),
    /** YCbCr 4:2:2 10-bit unpacked BT.709*/
    PixelFormat_YCbCr709_422_10_CbYCrY(222),
    /** YCbCr 4:2:2 10-bit packed BT.709*/
    PixelFormat_YCbCr709_422_10p(223),
    /** YCbCr 4:2:2 10-bit packed BT.709*/
    PixelFormat_YCbCr709_422_10p_CbYCrY(224),
    /** YCbCr 4:2:2 12-bit unpacked BT.709*/
    PixelFormat_YCbCr709_422_12(225),
    /** YCbCr 4:2:2 12-bit unpacked BT.709*/
    PixelFormat_YCbCr709_422_12_CbYCrY(226),
    /** YCbCr 4:2:2 12-bit packed BT.709*/
    PixelFormat_YCbCr709_422_12p(227),
    /** YCbCr 4:2:2 12-bit packed BT.709*/
    PixelFormat_YCbCr709_422_12p_CbYCrY(228),
    /** YUV 4:4:4 8-bit*/
    PixelFormat_YUV8_UYV(229),
    /** YUV 4:1:1 8-bit*/
    PixelFormat_YUV411_8_UYYVYY(230),
    /** YUV 4:2:2 8-bit*/
    PixelFormat_YUV422_8(231),
    /** YUV 4:2:2 8-bit*/
    PixelFormat_YUV422_8_UYVY(232),
    /** Monochrome Polarized 8-bit*/
    PixelFormat_Polarized8(233),
    /** Monochrome Polarized 10-bit packed*/
    PixelFormat_Polarized10p(234),
    /** Monochrome Polarized 12-bit packed*/
    PixelFormat_Polarized12p(235),
    /** Monochrome Polarized 16-bit*/
    PixelFormat_Polarized16(236),
    /** Polarized Bayer Red Green filter 8-bit*/
    PixelFormat_BayerRGPolarized8(237),
    /** Polarized Bayer Red Green filter 10-bit packed*/
    PixelFormat_BayerRGPolarized10p(238),
    /** Polarized Bayer Red Green filter 12-bit packed*/
    PixelFormat_BayerRGPolarized12p(239),
    /** Polarized Bayer Red Green filter 16-bit*/
    PixelFormat_BayerRGPolarized16(240),
    /** Lossless Compression Monochrome 8-bit*/
    PixelFormat_LLCMono8(241),
    /** Lossless Compression Bayer Red Green filter 8-bit*/
    PixelFormat_LLCBayerRG8(242),
    /** JPEG Monochrome 8-bit*/
    PixelFormat_JPEGMono8(243),
    /** JPEG Color 8-bit*/
    PixelFormat_JPEGColor8(244),
    /** Raw 16 bit.*/
    PixelFormat_Raw16(245),
    /** Raw bit.*/
    PixelFormat_Raw8(246),
    /** Red 12-bit JPEG.*/
    PixelFormat_R12_Jpeg(247),
    /** Green Red 12-bit JPEG.*/
    PixelFormat_GR12_Jpeg(248),
    /** Green Blue 12-bit JPEG.*/
    PixelFormat_GB12_Jpeg(249),
    /** Blue 12-bit packed JPEG.*/
    PixelFormat_B12_Jpeg(250),
    UNKNOWN_PIXELFORMAT(251),
    NUM_PIXELFORMAT(252);

    public final int value;
    private _spinPixelFormatEnums(int v) { this.value = v; }
    private _spinPixelFormatEnums(_spinPixelFormatEnums e) { this.value = e.value; }
    public _spinPixelFormatEnums intern() { for (_spinPixelFormatEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDecimationVerticalModeEnums {
    /** The value of every Nth pixel is kept, others are discarded.*/
    DecimationVerticalMode_Discard(0),
    NUM_DECIMATIONVERTICALMODE(1);

    public final int value;
    private _spinDecimationVerticalModeEnums(int v) { this.value = v; }
    private _spinDecimationVerticalModeEnums(_spinDecimationVerticalModeEnums e) { this.value = e.value; }
    public _spinDecimationVerticalModeEnums intern() { for (_spinDecimationVerticalModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinLineModeEnums {
    /** */
    LineMode_Input(0),
    /** */
    LineMode_Output(1),
    NUM_LINEMODE(2);

    public final int value;
    private _spinLineModeEnums(int v) { this.value = v; }
    private _spinLineModeEnums(_spinLineModeEnums e) { this.value = e.value; }
    public _spinLineModeEnums intern() { for (_spinLineModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinLineSourceEnums {
    /** */
    LineSource_Off(0),
    /** */
    LineSource_Line0(1),
    /** */
    LineSource_Line1(2),
    /** */
    LineSource_Line2(3),
    /** */
    LineSource_Line3(4),
    /** */
    LineSource_UserOutput0(5),
    /** */
    LineSource_UserOutput1(6),
    /** */
    LineSource_UserOutput2(7),
    /** */
    LineSource_UserOutput3(8),
    /** */
    LineSource_Counter0Active(9),
    /** */
    LineSource_Counter1Active(10),
    /** */
    LineSource_LogicBlock0(11),
    /** */
    LineSource_LogicBlock1(12),
    /** */
    LineSource_ExposureActive(13),
    /** */
    LineSource_FrameTriggerWait(14),
    /** */
    LineSource_SerialPort0(15),
    /** */
    LineSource_PPSSignal(16),
    /** */
    LineSource_AllPixel(17),
    /** */
    LineSource_AnyPixel(18),
    NUM_LINESOURCE(19);

    public final int value;
    private _spinLineSourceEnums(int v) { this.value = v; }
    private _spinLineSourceEnums(_spinLineSourceEnums e) { this.value = e.value; }
    public _spinLineSourceEnums intern() { for (_spinLineSourceEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinLineInputFilterSelectorEnums {
    /** */
    LineInputFilterSelector_Deglitch(0),
    /** */
    LineInputFilterSelector_Debounce(1),
    NUM_LINEINPUTFILTERSELECTOR(2);

    public final int value;
    private _spinLineInputFilterSelectorEnums(int v) { this.value = v; }
    private _spinLineInputFilterSelectorEnums(_spinLineInputFilterSelectorEnums e) { this.value = e.value; }
    public _spinLineInputFilterSelectorEnums intern() { for (_spinLineInputFilterSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinUserOutputSelectorEnums {
    /** */
    UserOutputSelector_UserOutput0(0),
    /** */
    UserOutputSelector_UserOutput1(1),
    /** */
    UserOutputSelector_UserOutput2(2),
    /** */
    UserOutputSelector_UserOutput3(3),
    NUM_USEROUTPUTSELECTOR(4);

    public final int value;
    private _spinUserOutputSelectorEnums(int v) { this.value = v; }
    private _spinUserOutputSelectorEnums(_spinUserOutputSelectorEnums e) { this.value = e.value; }
    public _spinUserOutputSelectorEnums intern() { for (_spinUserOutputSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinLineFormatEnums {
    /** */
    LineFormat_NoConnect(0),
    /** */
    LineFormat_TriState(1),
    /** */
    LineFormat_TTL(2),
    /** */
    LineFormat_LVDS(3),
    /** */
    LineFormat_RS422(4),
    /** */
    LineFormat_OptoCoupled(5),
    /** */
    LineFormat_OpenDrain(6),
    NUM_LINEFORMAT(7);

    public final int value;
    private _spinLineFormatEnums(int v) { this.value = v; }
    private _spinLineFormatEnums(_spinLineFormatEnums e) { this.value = e.value; }
    public _spinLineFormatEnums intern() { for (_spinLineFormatEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinLineSelectorEnums {
    /** */
    LineSelector_Line0(0),
    /** */
    LineSelector_Line1(1),
    /** */
    LineSelector_Line2(2),
    /** */
    LineSelector_Line3(3),
    NUM_LINESELECTOR(4);

    public final int value;
    private _spinLineSelectorEnums(int v) { this.value = v; }
    private _spinLineSelectorEnums(_spinLineSelectorEnums e) { this.value = e.value; }
    public _spinLineSelectorEnums intern() { for (_spinLineSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinExposureActiveModeEnums {
    /** */
    ExposureActiveMode_Line1(0),
    /** */
    ExposureActiveMode_AnyPixels(1),
    /** */
    ExposureActiveMode_AllPixels(2),
    NUM_EXPOSUREACTIVEMODE(3);

    public final int value;
    private _spinExposureActiveModeEnums(int v) { this.value = v; }
    private _spinExposureActiveModeEnums(_spinExposureActiveModeEnums e) { this.value = e.value; }
    public _spinExposureActiveModeEnums intern() { for (_spinExposureActiveModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinCounterTriggerActivationEnums {
    /** */
    CounterTriggerActivation_LevelLow(0),
    /** */
    CounterTriggerActivation_LevelHigh(1),
    /** */
    CounterTriggerActivation_FallingEdge(2),
    /** */
    CounterTriggerActivation_RisingEdge(3),
    /** */
    CounterTriggerActivation_AnyEdge(4),
    NUM_COUNTERTRIGGERACTIVATION(5);

    public final int value;
    private _spinCounterTriggerActivationEnums(int v) { this.value = v; }
    private _spinCounterTriggerActivationEnums(_spinCounterTriggerActivationEnums e) { this.value = e.value; }
    public _spinCounterTriggerActivationEnums intern() { for (_spinCounterTriggerActivationEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinCounterSelectorEnums {
    /** */
    CounterSelector_Counter0(0),
    /** */
    CounterSelector_Counter1(1),
    NUM_COUNTERSELECTOR(2);

    public final int value;
    private _spinCounterSelectorEnums(int v) { this.value = v; }
    private _spinCounterSelectorEnums(_spinCounterSelectorEnums e) { this.value = e.value; }
    public _spinCounterSelectorEnums intern() { for (_spinCounterSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinCounterStatusEnums {
    /** The counter is idle.*/
    CounterStatus_CounterIdle(0),
    /** The counter is waiting for a start trigger.*/
    CounterStatus_CounterTriggerWait(1),
    /** The counter is counting for the specified duration.*/
    CounterStatus_CounterActive(2),
    /** The counter reached the CounterDuration count.*/
    CounterStatus_CounterCompleted(3),
    /** The counter reached its maximum possible count.*/
    CounterStatus_CounterOverflow(4),
    NUM_COUNTERSTATUS(5);

    public final int value;
    private _spinCounterStatusEnums(int v) { this.value = v; }
    private _spinCounterStatusEnums(_spinCounterStatusEnums e) { this.value = e.value; }
    public _spinCounterStatusEnums intern() { for (_spinCounterStatusEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinCounterTriggerSourceEnums {
    /** Off*/
    CounterTriggerSource_Off(0),
    /** Line0*/
    CounterTriggerSource_Line0(1),
    /** Line1*/
    CounterTriggerSource_Line1(2),
    /** Line2*/
    CounterTriggerSource_Line2(3),
    /** Line3*/
    CounterTriggerSource_Line3(4),
    /** UserOutput0*/
    CounterTriggerSource_UserOutput0(5),
    /** UserOutput1*/
    CounterTriggerSource_UserOutput1(6),
    /** UserOutput2*/
    CounterTriggerSource_UserOutput2(7),
    /** UserOutput3*/
    CounterTriggerSource_UserOutput3(8),
    /** Counter0Start*/
    CounterTriggerSource_Counter0Start(9),
    /** Counter1Start*/
    CounterTriggerSource_Counter1Start(10),
    /** Counter0End*/
    CounterTriggerSource_Counter0End(11),
    /** Counter1End*/
    CounterTriggerSource_Counter1End(12),
    /** LogicBlock0*/
    CounterTriggerSource_LogicBlock0(13),
    /** LogicBlock1*/
    CounterTriggerSource_LogicBlock1(14),
    /** ExposureStart*/
    CounterTriggerSource_ExposureStart(15),
    /** ExposureEnd*/
    CounterTriggerSource_ExposureEnd(16),
    /** FrameTriggerWait*/
    CounterTriggerSource_FrameTriggerWait(17),
    NUM_COUNTERTRIGGERSOURCE(18);

    public final int value;
    private _spinCounterTriggerSourceEnums(int v) { this.value = v; }
    private _spinCounterTriggerSourceEnums(_spinCounterTriggerSourceEnums e) { this.value = e.value; }
    public _spinCounterTriggerSourceEnums intern() { for (_spinCounterTriggerSourceEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinCounterResetSourceEnums {
    /** Off*/
    CounterResetSource_Off(0),
    /** Line0*/
    CounterResetSource_Line0(1),
    /** Line1*/
    CounterResetSource_Line1(2),
    /** Line2*/
    CounterResetSource_Line2(3),
    /** Line3*/
    CounterResetSource_Line3(4),
    /** UserOutput0*/
    CounterResetSource_UserOutput0(5),
    /** UserOutput1*/
    CounterResetSource_UserOutput1(6),
    /** UserOutput2*/
    CounterResetSource_UserOutput2(7),
    /** UserOutput3*/
    CounterResetSource_UserOutput3(8),
    /** Counter0Start*/
    CounterResetSource_Counter0Start(9),
    /** Counter1Start*/
    CounterResetSource_Counter1Start(10),
    /** Counter0End*/
    CounterResetSource_Counter0End(11),
    /** Counter1End*/
    CounterResetSource_Counter1End(12),
    /** LogicBlock0*/
    CounterResetSource_LogicBlock0(13),
    /** LogicBlock1*/
    CounterResetSource_LogicBlock1(14),
    /** ExposureStart*/
    CounterResetSource_ExposureStart(15),
    /** ExposureEnd*/
    CounterResetSource_ExposureEnd(16),
    /** FrameTriggerWait*/
    CounterResetSource_FrameTriggerWait(17),
    NUM_COUNTERRESETSOURCE(18);

    public final int value;
    private _spinCounterResetSourceEnums(int v) { this.value = v; }
    private _spinCounterResetSourceEnums(_spinCounterResetSourceEnums e) { this.value = e.value; }
    public _spinCounterResetSourceEnums intern() { for (_spinCounterResetSourceEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinCounterEventSourceEnums {
    /** Off*/
    CounterEventSource_Off(0),
    /** MHzTick*/
    CounterEventSource_MHzTick(1),
    /** Line0*/
    CounterEventSource_Line0(2),
    /** Line1*/
    CounterEventSource_Line1(3),
    /** Line2*/
    CounterEventSource_Line2(4),
    /** Line3*/
    CounterEventSource_Line3(5),
    /** UserOutput0*/
    CounterEventSource_UserOutput0(6),
    /** UserOutput1*/
    CounterEventSource_UserOutput1(7),
    /** UserOutput2*/
    CounterEventSource_UserOutput2(8),
    /** UserOutput3*/
    CounterEventSource_UserOutput3(9),
    /** Counter0Start*/
    CounterEventSource_Counter0Start(10),
    /** Counter1Start*/
    CounterEventSource_Counter1Start(11),
    /** Counter0End*/
    CounterEventSource_Counter0End(12),
    /** Counter1End*/
    CounterEventSource_Counter1End(13),
    /** LogicBlock0*/
    CounterEventSource_LogicBlock0(14),
    /** LogicBlock1*/
    CounterEventSource_LogicBlock1(15),
    /** ExposureStart*/
    CounterEventSource_ExposureStart(16),
    /** ExposureEnd*/
    CounterEventSource_ExposureEnd(17),
    /** FrameTriggerWait*/
    CounterEventSource_FrameTriggerWait(18),
    NUM_COUNTEREVENTSOURCE(19);

    public final int value;
    private _spinCounterEventSourceEnums(int v) { this.value = v; }
    private _spinCounterEventSourceEnums(_spinCounterEventSourceEnums e) { this.value = e.value; }
    public _spinCounterEventSourceEnums intern() { for (_spinCounterEventSourceEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinCounterEventActivationEnums {
    /** */
    CounterEventActivation_LevelLow(0),
    /** */
    CounterEventActivation_LevelHigh(1),
    /** */
    CounterEventActivation_FallingEdge(2),
    /** */
    CounterEventActivation_RisingEdge(3),
    /** */
    CounterEventActivation_AnyEdge(4),
    NUM_COUNTEREVENTACTIVATION(5);

    public final int value;
    private _spinCounterEventActivationEnums(int v) { this.value = v; }
    private _spinCounterEventActivationEnums(_spinCounterEventActivationEnums e) { this.value = e.value; }
    public _spinCounterEventActivationEnums intern() { for (_spinCounterEventActivationEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinCounterResetActivationEnums {
    /** */
    CounterResetActivation_LevelLow(0),
    /** */
    CounterResetActivation_LevelHigh(1),
    /** */
    CounterResetActivation_FallingEdge(2),
    /** */
    CounterResetActivation_RisingEdge(3),
    /** */
    CounterResetActivation_AnyEdge(4),
    NUM_COUNTERRESETACTIVATION(5);

    public final int value;
    private _spinCounterResetActivationEnums(int v) { this.value = v; }
    private _spinCounterResetActivationEnums(_spinCounterResetActivationEnums e) { this.value = e.value; }
    public _spinCounterResetActivationEnums intern() { for (_spinCounterResetActivationEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDeviceTypeEnums {
    /** Data stream transmitter device.*/
    DeviceType_Transmitter(0),
    /** Data stream receiver device.*/
    DeviceType_Receiver(1),
    /** Data stream receiver and transmitter device.*/
    DeviceType_Transceiver(2),
    /** Controllable device (with no data stream handling).*/
    DeviceType_Peripheral(3),
    NUM_DEVICETYPE(4);

    public final int value;
    private _spinDeviceTypeEnums(int v) { this.value = v; }
    private _spinDeviceTypeEnums(_spinDeviceTypeEnums e) { this.value = e.value; }
    public _spinDeviceTypeEnums intern() { for (_spinDeviceTypeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDeviceConnectionStatusEnums {
    /** Connection is in use.*/
    DeviceConnectionStatus_Active(0),
    /** Connection is not in use.*/
    DeviceConnectionStatus_Inactive(1),
    NUM_DEVICECONNECTIONSTATUS(2);

    public final int value;
    private _spinDeviceConnectionStatusEnums(int v) { this.value = v; }
    private _spinDeviceConnectionStatusEnums(_spinDeviceConnectionStatusEnums e) { this.value = e.value; }
    public _spinDeviceConnectionStatusEnums intern() { for (_spinDeviceConnectionStatusEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDeviceLinkThroughputLimitModeEnums {
    /** Enables the DeviceLinkThroughputLimit feature.*/
    DeviceLinkThroughputLimitMode_On(0),
    /** Disables the DeviceLinkThroughputLimit feature.*/
    DeviceLinkThroughputLimitMode_Off(1),
    NUM_DEVICELINKTHROUGHPUTLIMITMODE(2);

    public final int value;
    private _spinDeviceLinkThroughputLimitModeEnums(int v) { this.value = v; }
    private _spinDeviceLinkThroughputLimitModeEnums(_spinDeviceLinkThroughputLimitModeEnums e) { this.value = e.value; }
    public _spinDeviceLinkThroughputLimitModeEnums intern() { for (_spinDeviceLinkThroughputLimitModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDeviceLinkHeartbeatModeEnums {
    /** Enables the Link heartbeat.*/
    DeviceLinkHeartbeatMode_On(0),
    /** Disables the Link heartbeat.*/
    DeviceLinkHeartbeatMode_Off(1),
    NUM_DEVICELINKHEARTBEATMODE(2);

    public final int value;
    private _spinDeviceLinkHeartbeatModeEnums(int v) { this.value = v; }
    private _spinDeviceLinkHeartbeatModeEnums(_spinDeviceLinkHeartbeatModeEnums e) { this.value = e.value; }
    public _spinDeviceLinkHeartbeatModeEnums intern() { for (_spinDeviceLinkHeartbeatModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDeviceStreamChannelTypeEnums {
    /** Data stream transmitter channel.*/
    DeviceStreamChannelType_Transmitter(0),
    /** Data stream receiver channel.*/
    DeviceStreamChannelType_Receiver(1),
    NUM_DEVICESTREAMCHANNELTYPE(2);

    public final int value;
    private _spinDeviceStreamChannelTypeEnums(int v) { this.value = v; }
    private _spinDeviceStreamChannelTypeEnums(_spinDeviceStreamChannelTypeEnums e) { this.value = e.value; }
    public _spinDeviceStreamChannelTypeEnums intern() { for (_spinDeviceStreamChannelTypeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDeviceStreamChannelEndiannessEnums {
    /** Stream channel data is big Endian.*/
    DeviceStreamChannelEndianness_Big(0),
    /** Stream channel data is little Endian.*/
    DeviceStreamChannelEndianness_Little(1),
    NUM_DEVICESTREAMCHANNELENDIANNESS(2);

    public final int value;
    private _spinDeviceStreamChannelEndiannessEnums(int v) { this.value = v; }
    private _spinDeviceStreamChannelEndiannessEnums(_spinDeviceStreamChannelEndiannessEnums e) { this.value = e.value; }
    public _spinDeviceStreamChannelEndiannessEnums intern() { for (_spinDeviceStreamChannelEndiannessEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDeviceClockSelectorEnums {
    /** Clock frequency of the image sensor of the camera.*/
    DeviceClockSelector_Sensor(0),
    /** Clock frequency of the camera A/D conversion stage.*/
    DeviceClockSelector_SensorDigitization(1),
    /** Frequency of the Camera Link clock.*/
    DeviceClockSelector_CameraLink(2),
    NUM_DEVICECLOCKSELECTOR(3);

    public final int value;
    private _spinDeviceClockSelectorEnums(int v) { this.value = v; }
    private _spinDeviceClockSelectorEnums(_spinDeviceClockSelectorEnums e) { this.value = e.value; }
    public _spinDeviceClockSelectorEnums intern() { for (_spinDeviceClockSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDeviceSerialPortSelectorEnums {
    /** Serial port associated to the Camera link connection.*/
    DeviceSerialPortSelector_CameraLink(0),
    NUM_DEVICESERIALPORTSELECTOR(1);

    public final int value;
    private _spinDeviceSerialPortSelectorEnums(int v) { this.value = v; }
    private _spinDeviceSerialPortSelectorEnums(_spinDeviceSerialPortSelectorEnums e) { this.value = e.value; }
    public _spinDeviceSerialPortSelectorEnums intern() { for (_spinDeviceSerialPortSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDeviceSerialPortBaudRateEnums {
    /** Serial port speed of 9600 baud.*/
    DeviceSerialPortBaudRate_Baud9600(0),
    /** Serial port speed of 19200 baud.*/
    DeviceSerialPortBaudRate_Baud19200(1),
    /** Serial port speed of 38400 baud.*/
    DeviceSerialPortBaudRate_Baud38400(2),
    /** Serial port speed of 57600 baud.*/
    DeviceSerialPortBaudRate_Baud57600(3),
    /** Serial port speed of 115200 baud.*/
    DeviceSerialPortBaudRate_Baud115200(4),
    /** Serial port speed of 230400 baud.*/
    DeviceSerialPortBaudRate_Baud230400(5),
    /** Serial port speed of 460800 baud.*/
    DeviceSerialPortBaudRate_Baud460800(6),
    /** Serial port speed of 921600 baud.*/
    DeviceSerialPortBaudRate_Baud921600(7),
    NUM_DEVICESERIALPORTBAUDRATE(8);

    public final int value;
    private _spinDeviceSerialPortBaudRateEnums(int v) { this.value = v; }
    private _spinDeviceSerialPortBaudRateEnums(_spinDeviceSerialPortBaudRateEnums e) { this.value = e.value; }
    public _spinDeviceSerialPortBaudRateEnums intern() { for (_spinDeviceSerialPortBaudRateEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinSensorTapsEnums {
    /** 1 tap.*/
    SensorTaps_One(0),
    /** 2 taps.*/
    SensorTaps_Two(1),
    /** 3 taps.*/
    SensorTaps_Three(2),
    /** 4 taps.*/
    SensorTaps_Four(3),
    /** 8 taps.*/
    SensorTaps_Eight(4),
    /** 10 taps.*/
    SensorTaps_Ten(5),
    NUM_SENSORTAPS(6);

    public final int value;
    private _spinSensorTapsEnums(int v) { this.value = v; }
    private _spinSensorTapsEnums(_spinSensorTapsEnums e) { this.value = e.value; }
    public _spinSensorTapsEnums intern() { for (_spinSensorTapsEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinSensorDigitizationTapsEnums {
    /** 1 tap.*/
    SensorDigitizationTaps_One(0),
    /** 2 taps.*/
    SensorDigitizationTaps_Two(1),
    /** 3 taps.*/
    SensorDigitizationTaps_Three(2),
    /** 4 taps.*/
    SensorDigitizationTaps_Four(3),
    /** 8 taps.*/
    SensorDigitizationTaps_Eight(4),
    /** 10 taps.*/
    SensorDigitizationTaps_Ten(5),
    NUM_SENSORDIGITIZATIONTAPS(6);

    public final int value;
    private _spinSensorDigitizationTapsEnums(int v) { this.value = v; }
    private _spinSensorDigitizationTapsEnums(_spinSensorDigitizationTapsEnums e) { this.value = e.value; }
    public _spinSensorDigitizationTapsEnums intern() { for (_spinSensorDigitizationTapsEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinRegionSelectorEnums {
    /** Selected feature will control the region 0.*/
    RegionSelector_Region0(0),
    /** Selected feature will control the region 1.*/
    RegionSelector_Region1(1),
    /** Selected feature will control the region 2.*/
    RegionSelector_Region2(2),
    /** Selected features will control all the regions at the same time.*/
    RegionSelector_All(3),
    NUM_REGIONSELECTOR(4);

    public final int value;
    private _spinRegionSelectorEnums(int v) { this.value = v; }
    private _spinRegionSelectorEnums(_spinRegionSelectorEnums e) { this.value = e.value; }
    public _spinRegionSelectorEnums intern() { for (_spinRegionSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinRegionModeEnums {
    /** Disable the usage of the Region.*/
    RegionMode_Off(0),
    /** Enable the usage of the Region.*/
    RegionMode_On(1),
    NUM_REGIONMODE(2);

    public final int value;
    private _spinRegionModeEnums(int v) { this.value = v; }
    private _spinRegionModeEnums(_spinRegionModeEnums e) { this.value = e.value; }
    public _spinRegionModeEnums intern() { for (_spinRegionModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinRegionDestinationEnums {
    /** The destination of the region is the data stream 0.*/
    RegionDestination_Stream0(0),
    /** The destination of the region is the data stream 1.*/
    RegionDestination_Stream1(1),
    /** The destination of the region is the data stream 2.*/
    RegionDestination_Stream2(2),
    NUM_REGIONDESTINATION(3);

    public final int value;
    private _spinRegionDestinationEnums(int v) { this.value = v; }
    private _spinRegionDestinationEnums(_spinRegionDestinationEnums e) { this.value = e.value; }
    public _spinRegionDestinationEnums intern() { for (_spinRegionDestinationEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinImageComponentSelectorEnums {
    /** The acquisition of intensity of the reflected light is controlled.*/
    ImageComponentSelector_Intensity(0),
    /** The acquisition of color of the reflected light is controlled*/
    ImageComponentSelector_Color(1),
    /** The acquisition of non-visible infrared light is controlled.*/
    ImageComponentSelector_Infrared(2),
    /** The acquisition of non-visible ultraviolet light is controlled.*/
    ImageComponentSelector_Ultraviolet(3),
    /** The acquisition of range (distance) data is controlled. The data produced may be only range (2.5D) or a point cloud 3D coordinates depending on the Scan3dControl.*/
    ImageComponentSelector_Range(4),
    /** The acquisition of stereo camera disparity data is controlled. Disparity is a more specific range format approximately inversely proportional to distance. Disparity is typically given in pixel units.*/
    ImageComponentSelector_Disparity(5),
    /** The acquisition of confidence map of the acquired image is controlled. Confidence data may be binary (0 - invalid) or an integer where 0 is invalid and increasing value is increased confidence in the data in the corresponding pixel. If floating point representation is used the confidence image is normalized to the range [0,1], for integer representation the maximum possible integer represents maximum confidence.*/
    ImageComponentSelector_Confidence(6),
    /** The acquisition of data measuring how much light is scattered around the reflected light. In processing this is used as an additional intensity image, often together with the standard intensity.*/
    ImageComponentSelector_Scatter(7),
    NUM_IMAGECOMPONENTSELECTOR(8);

    public final int value;
    private _spinImageComponentSelectorEnums(int v) { this.value = v; }
    private _spinImageComponentSelectorEnums(_spinImageComponentSelectorEnums e) { this.value = e.value; }
    public _spinImageComponentSelectorEnums intern() { for (_spinImageComponentSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinPixelFormatInfoSelectorEnums {
    /** Monochrome 1-bit packed*/
    PixelFormatInfoSelector_Mono1p(0),
    /** Monochrome 2-bit packed*/
    PixelFormatInfoSelector_Mono2p(1),
    /** Monochrome 4-bit packed*/
    PixelFormatInfoSelector_Mono4p(2),
    /** Monochrome 8-bit*/
    PixelFormatInfoSelector_Mono8(3),
    /** Monochrome 8-bit signed*/
    PixelFormatInfoSelector_Mono8s(4),
    /** Monochrome 10-bit unpacked*/
    PixelFormatInfoSelector_Mono10(5),
    /** Monochrome 10-bit packed*/
    PixelFormatInfoSelector_Mono10p(6),
    /** Monochrome 12-bit unpacked*/
    PixelFormatInfoSelector_Mono12(7),
    /** Monochrome 12-bit packed*/
    PixelFormatInfoSelector_Mono12p(8),
    /** Monochrome 14-bit unpacked*/
    PixelFormatInfoSelector_Mono14(9),
    /** Monochrome 16-bit*/
    PixelFormatInfoSelector_Mono16(10),
    /** Monochrome 16-bit signed*/
    PixelFormatInfoSelector_Mono16s(11),
    /** Monochrome 32-bit float*/
    PixelFormatInfoSelector_Mono32f(12),
    /** Bayer Blue-Green 8-bit*/
    PixelFormatInfoSelector_BayerBG8(13),
    /** Bayer Blue-Green 10-bit unpacked*/
    PixelFormatInfoSelector_BayerBG10(14),
    /** Bayer Blue-Green 10-bit packed*/
    PixelFormatInfoSelector_BayerBG10p(15),
    /** Bayer Blue-Green 12-bit unpacked*/
    PixelFormatInfoSelector_BayerBG12(16),
    /** Bayer Blue-Green 12-bit packed*/
    PixelFormatInfoSelector_BayerBG12p(17),
    /** Bayer Blue-Green 16-bit*/
    PixelFormatInfoSelector_BayerBG16(18),
    /** Bayer Green-Blue 8-bit*/
    PixelFormatInfoSelector_BayerGB8(19),
    /** Bayer Green-Blue 10-bit unpacked*/
    PixelFormatInfoSelector_BayerGB10(20),
    /** Bayer Green-Blue 10-bit packed*/
    PixelFormatInfoSelector_BayerGB10p(21),
    /** Bayer Green-Blue 12-bit unpacked*/
    PixelFormatInfoSelector_BayerGB12(22),
    /** Bayer Green-Blue 12-bit packed*/
    PixelFormatInfoSelector_BayerGB12p(23),
    /** Bayer Green-Blue 16-bit*/
    PixelFormatInfoSelector_BayerGB16(24),
    /** Bayer Green-Red 8-bit*/
    PixelFormatInfoSelector_BayerGR8(25),
    /** Bayer Green-Red 10-bit unpacked*/
    PixelFormatInfoSelector_BayerGR10(26),
    /** Bayer Green-Red 10-bit packed*/
    PixelFormatInfoSelector_BayerGR10p(27),
    /** Bayer Green-Red 12-bit unpacked*/
    PixelFormatInfoSelector_BayerGR12(28),
    /** Bayer Green-Red 12-bit packed*/
    PixelFormatInfoSelector_BayerGR12p(29),
    /** Bayer Green-Red 16-bit*/
    PixelFormatInfoSelector_BayerGR16(30),
    /** Bayer Red-Green 8-bit*/
    PixelFormatInfoSelector_BayerRG8(31),
    /** Bayer Red-Green 10-bit unpacked*/
    PixelFormatInfoSelector_BayerRG10(32),
    /** Bayer Red-Green 10-bit packed*/
    PixelFormatInfoSelector_BayerRG10p(33),
    /** Bayer Red-Green 12-bit unpacked*/
    PixelFormatInfoSelector_BayerRG12(34),
    /** Bayer Red-Green 12-bit packed*/
    PixelFormatInfoSelector_BayerRG12p(35),
    /** Bayer Red-Green 16-bit*/
    PixelFormatInfoSelector_BayerRG16(36),
    /** Red-Green-Blue-alpha 8-bit*/
    PixelFormatInfoSelector_RGBa8(37),
    /** Red-Green-Blue-alpha 10-bit unpacked*/
    PixelFormatInfoSelector_RGBa10(38),
    /** Red-Green-Blue-alpha 10-bit packed*/
    PixelFormatInfoSelector_RGBa10p(39),
    /** Red-Green-Blue-alpha 12-bit unpacked*/
    PixelFormatInfoSelector_RGBa12(40),
    /** Red-Green-Blue-alpha 12-bit packed*/
    PixelFormatInfoSelector_RGBa12p(41),
    /** Red-Green-Blue-alpha 14-bit unpacked*/
    PixelFormatInfoSelector_RGBa14(42),
    /** Red-Green-Blue-alpha 16-bit*/
    PixelFormatInfoSelector_RGBa16(43),
    /** Red-Green-Blue 8-bit*/
    PixelFormatInfoSelector_RGB8(44),
    /** Red-Green-Blue 8-bit planar*/
    PixelFormatInfoSelector_RGB8_Planar(45),
    /** Red-Green-Blue 10-bit unpacked*/
    PixelFormatInfoSelector_RGB10(46),
    /** Red-Green-Blue 10-bit unpacked planar*/
    PixelFormatInfoSelector_RGB10_Planar(47),
    /** Red-Green-Blue 10-bit packed*/
    PixelFormatInfoSelector_RGB10p(48),
    /** Red-Green-Blue 10-bit packed into 32-bit*/
    PixelFormatInfoSelector_RGB10p32(49),
    /** Red-Green-Blue 12-bit unpacked*/
    PixelFormatInfoSelector_RGB12(50),
    /** Red-Green-Blue 12-bit unpacked planar*/
    PixelFormatInfoSelector_RGB12_Planar(51),
    /** Red-Green-Blue 12-bit packed  */
    PixelFormatInfoSelector_RGB12p(52),
    /** Red-Green-Blue 14-bit unpacked*/
    PixelFormatInfoSelector_RGB14(53),
    /** Red-Green-Blue 16-bit  */
    PixelFormatInfoSelector_RGB16(54),
    /** Red-Green-Blue 16-bit signed*/
    PixelFormatInfoSelector_RGB16s(55),
    /** Red-Green-Blue 32-bit float*/
    PixelFormatInfoSelector_RGB32f(56),
    /** Red-Green-Blue 16-bit planar*/
    PixelFormatInfoSelector_RGB16_Planar(57),
    /** Red-Green-Blue 5/6/5-bit packed*/
    PixelFormatInfoSelector_RGB565p(58),
    /** Blue-Green-Red-alpha 8-bit*/
    PixelFormatInfoSelector_BGRa8(59),
    /** Blue-Green-Red-alpha 10-bit unpacked*/
    PixelFormatInfoSelector_BGRa10(60),
    /** Blue-Green-Red-alpha 10-bit packed*/
    PixelFormatInfoSelector_BGRa10p(61),
    /** Blue-Green-Red-alpha 12-bit unpacked*/
    PixelFormatInfoSelector_BGRa12(62),
    /** Blue-Green-Red-alpha 12-bit packed*/
    PixelFormatInfoSelector_BGRa12p(63),
    /** Blue-Green-Red-alpha 14-bit unpacked*/
    PixelFormatInfoSelector_BGRa14(64),
    /** Blue-Green-Red-alpha 16-bit*/
    PixelFormatInfoSelector_BGRa16(65),
    /** Red-Green-Blue-alpha 32-bit float*/
    PixelFormatInfoSelector_RGBa32f(66),
    /** Blue-Green-Red 8-bit*/
    PixelFormatInfoSelector_BGR8(67),
    /** Blue-Green-Red 10-bit unpacked*/
    PixelFormatInfoSelector_BGR10(68),
    /** Blue-Green-Red 10-bit packed*/
    PixelFormatInfoSelector_BGR10p(69),
    /** Blue-Green-Red 12-bit unpacked*/
    PixelFormatInfoSelector_BGR12(70),
    /** Blue-Green-Red 12-bit packed*/
    PixelFormatInfoSelector_BGR12p(71),
    /** Blue-Green-Red 14-bit unpacked*/
    PixelFormatInfoSelector_BGR14(72),
    /** Blue-Green-Red 16-bit*/
    PixelFormatInfoSelector_BGR16(73),
    /** Blue-Green-Red 5/6/5-bit packed*/
    PixelFormatInfoSelector_BGR565p(74),
    /** Red 8-bit*/
    PixelFormatInfoSelector_R8(75),
    /** Red 10-bit*/
    PixelFormatInfoSelector_R10(76),
    /** Red 12-bit*/
    PixelFormatInfoSelector_R12(77),
    /** Red 16-bit*/
    PixelFormatInfoSelector_R16(78),
    /** Green 8-bit*/
    PixelFormatInfoSelector_G8(79),
    /** Green 10-bit*/
    PixelFormatInfoSelector_G10(80),
    /** Green 12-bit*/
    PixelFormatInfoSelector_G12(81),
    /** Green 16-bit*/
    PixelFormatInfoSelector_G16(82),
    /** Blue 8-bit*/
    PixelFormatInfoSelector_B8(83),
    /** Blue 10-bit*/
    PixelFormatInfoSelector_B10(84),
    /** Blue 12-bit*/
    PixelFormatInfoSelector_B12(85),
    /** Blue 16-bit*/
    PixelFormatInfoSelector_B16(86),
    /** 3D coordinate A-B-C 8-bit*/
    PixelFormatInfoSelector_Coord3D_ABC8(87),
    /** 3D coordinate A-B-C 8-bit planar*/
    PixelFormatInfoSelector_Coord3D_ABC8_Planar(88),
    /** 3D coordinate A-B-C 10-bit packed*/
    PixelFormatInfoSelector_Coord3D_ABC10p(89),
    /** 3D coordinate A-B-C 10-bit packed planar*/
    PixelFormatInfoSelector_Coord3D_ABC10p_Planar(90),
    /** 3D coordinate A-B-C 12-bit packed*/
    PixelFormatInfoSelector_Coord3D_ABC12p(91),
    /** 3D coordinate A-B-C 12-bit packed planar*/
    PixelFormatInfoSelector_Coord3D_ABC12p_Planar(92),
    /** 3D coordinate A-B-C 16-bit*/
    PixelFormatInfoSelector_Coord3D_ABC16(93),
    /** 3D coordinate A-B-C 16-bit planar*/
    PixelFormatInfoSelector_Coord3D_ABC16_Planar(94),
    /** 3D coordinate A-B-C 32-bit floating point*/
    PixelFormatInfoSelector_Coord3D_ABC32f(95),
    /** 3D coordinate A-B-C 32-bit floating point planar*/
    PixelFormatInfoSelector_Coord3D_ABC32f_Planar(96),
    /** 3D coordinate A-C 8-bit*/
    PixelFormatInfoSelector_Coord3D_AC8(97),
    /** 3D coordinate A-C 8-bit planar*/
    PixelFormatInfoSelector_Coord3D_AC8_Planar(98),
    /** 3D coordinate A-C 10-bit packed*/
    PixelFormatInfoSelector_Coord3D_AC10p(99),
    /** 3D coordinate A-C 10-bit packed planar*/
    PixelFormatInfoSelector_Coord3D_AC10p_Planar(100),
    /** 3D coordinate A-C 12-bit packed*/
    PixelFormatInfoSelector_Coord3D_AC12p(101),
    /** 3D coordinate A-C 12-bit packed planar*/
    PixelFormatInfoSelector_Coord3D_AC12p_Planar(102),
    /** 3D coordinate A-C 16-bit*/
    PixelFormatInfoSelector_Coord3D_AC16(103),
    /** 3D coordinate A-C 16-bit planar*/
    PixelFormatInfoSelector_Coord3D_AC16_Planar(104),
    /** 3D coordinate A-C 32-bit floating point*/
    PixelFormatInfoSelector_Coord3D_AC32f(105),
    /** 3D coordinate A-C 32-bit floating point planar*/
    PixelFormatInfoSelector_Coord3D_AC32f_Planar(106),
    /** 3D coordinate A 8-bit*/
    PixelFormatInfoSelector_Coord3D_A8(107),
    /** 3D coordinate A 10-bit packed*/
    PixelFormatInfoSelector_Coord3D_A10p(108),
    /** 3D coordinate A 12-bit packed*/
    PixelFormatInfoSelector_Coord3D_A12p(109),
    /** 3D coordinate A 16-bit*/
    PixelFormatInfoSelector_Coord3D_A16(110),
    /** 3D coordinate A 32-bit floating point*/
    PixelFormatInfoSelector_Coord3D_A32f(111),
    /** 3D coordinate B 8-bit*/
    PixelFormatInfoSelector_Coord3D_B8(112),
    /** 3D coordinate B 10-bit packed*/
    PixelFormatInfoSelector_Coord3D_B10p(113),
    /** 3D coordinate B 12-bit packed*/
    PixelFormatInfoSelector_Coord3D_B12p(114),
    /** 3D coordinate B 16-bit*/
    PixelFormatInfoSelector_Coord3D_B16(115),
    /** 3D coordinate B 32-bit floating point*/
    PixelFormatInfoSelector_Coord3D_B32f(116),
    /** 3D coordinate C 8-bit*/
    PixelFormatInfoSelector_Coord3D_C8(117),
    /** 3D coordinate C 10-bit packed*/
    PixelFormatInfoSelector_Coord3D_C10p(118),
    /** 3D coordinate C 12-bit packed*/
    PixelFormatInfoSelector_Coord3D_C12p(119),
    /** 3D coordinate C 16-bit*/
    PixelFormatInfoSelector_Coord3D_C16(120),
    /** 3D coordinate C 32-bit floating point*/
    PixelFormatInfoSelector_Coord3D_C32f(121),
    /** Confidence 1-bit unpacked*/
    PixelFormatInfoSelector_Confidence1(122),
    /** Confidence 1-bit packed*/
    PixelFormatInfoSelector_Confidence1p(123),
    /** Confidence 8-bit*/
    PixelFormatInfoSelector_Confidence8(124),
    /** Confidence 16-bit*/
    PixelFormatInfoSelector_Confidence16(125),
    /** Confidence 32-bit floating point*/
    PixelFormatInfoSelector_Confidence32f(126),
    /** Bi-color Blue/Green - Red/Green 8-bit*/
    PixelFormatInfoSelector_BiColorBGRG8(127),
    /** Bi-color Blue/Green - Red/Green 10-bit unpacked*/
    PixelFormatInfoSelector_BiColorBGRG10(128),
    /** Bi-color Blue/Green - Red/Green 10-bit packed*/
    PixelFormatInfoSelector_BiColorBGRG10p(129),
    /** Bi-color Blue/Green - Red/Green 12-bit unpacked*/
    PixelFormatInfoSelector_BiColorBGRG12(130),
    /** Bi-color Blue/Green - Red/Green 12-bit packed*/
    PixelFormatInfoSelector_BiColorBGRG12p(131),
    /** Bi-color Red/Green - Blue/Green 8-bit*/
    PixelFormatInfoSelector_BiColorRGBG8(132),
    /** Bi-color Red/Green - Blue/Green 10-bit unpacked*/
    PixelFormatInfoSelector_BiColorRGBG10(133),
    /** Bi-color Red/Green - Blue/Green 10-bit packed*/
    PixelFormatInfoSelector_BiColorRGBG10p(134),
    /** Bi-color Red/Green - Blue/Green 12-bit unpacked*/
    PixelFormatInfoSelector_BiColorRGBG12(135),
    /** Bi-color Red/Green - Blue/Green 12-bit packed*/
    PixelFormatInfoSelector_BiColorRGBG12p(136),
    /** Sparse Color Filter #1 White-Blue-White-Green 8-bit*/
    PixelFormatInfoSelector_SCF1WBWG8(137),
    /** Sparse Color Filter #1 White-Blue-White-Green 10-bit unpacked*/
    PixelFormatInfoSelector_SCF1WBWG10(138),
    /** Sparse Color Filter #1 White-Blue-White-Green 10-bit packed*/
    PixelFormatInfoSelector_SCF1WBWG10p(139),
    /** Sparse Color Filter #1 White-Blue-White-Green 12-bit unpacked*/
    PixelFormatInfoSelector_SCF1WBWG12(140),
    /** Sparse Color Filter #1 White-Blue-White-Green 12-bit packed*/
    PixelFormatInfoSelector_SCF1WBWG12p(141),
    /** Sparse Color Filter #1 White-Blue-White-Green 14-bit unpacked*/
    PixelFormatInfoSelector_SCF1WBWG14(142),
    /** Sparse Color Filter #1 White-Blue-White-Green 16-bit unpacked*/
    PixelFormatInfoSelector_SCF1WBWG16(143),
    /** Sparse Color Filter #1 White-Green-White-Blue 8-bit*/
    PixelFormatInfoSelector_SCF1WGWB8(144),
    /** Sparse Color Filter #1 White-Green-White-Blue 10-bit unpacked*/
    PixelFormatInfoSelector_SCF1WGWB10(145),
    /** Sparse Color Filter #1 White-Green-White-Blue 10-bit packed*/
    PixelFormatInfoSelector_SCF1WGWB10p(146),
    /** Sparse Color Filter #1 White-Green-White-Blue 12-bit unpacked*/
    PixelFormatInfoSelector_SCF1WGWB12(147),
    /** Sparse Color Filter #1 White-Green-White-Blue 12-bit packed*/
    PixelFormatInfoSelector_SCF1WGWB12p(148),
    /** Sparse Color Filter #1 White-Green-White-Blue 14-bit unpacked*/
    PixelFormatInfoSelector_SCF1WGWB14(149),
    /** Sparse Color Filter #1 White-Green-White-Blue 16-bit*/
    PixelFormatInfoSelector_SCF1WGWB16(150),
    /** Sparse Color Filter #1 White-Green-White-Red 8-bit*/
    PixelFormatInfoSelector_SCF1WGWR8(151),
    /** Sparse Color Filter #1 White-Green-White-Red 10-bit unpacked*/
    PixelFormatInfoSelector_SCF1WGWR10(152),
    /** Sparse Color Filter #1 White-Green-White-Red 10-bit packed*/
    PixelFormatInfoSelector_SCF1WGWR10p(153),
    /** Sparse Color Filter #1 White-Green-White-Red 12-bit unpacked*/
    PixelFormatInfoSelector_SCF1WGWR12(154),
    /** Sparse Color Filter #1 White-Green-White-Red 12-bit packed*/
    PixelFormatInfoSelector_SCF1WGWR12p(155),
    /** Sparse Color Filter #1 White-Green-White-Red 14-bit unpacked*/
    PixelFormatInfoSelector_SCF1WGWR14(156),
    /** Sparse Color Filter #1 White-Green-White-Red 16-bit*/
    PixelFormatInfoSelector_SCF1WGWR16(157),
    /** Sparse Color Filter #1 White-Red-White-Green 8-bit*/
    PixelFormatInfoSelector_SCF1WRWG8(158),
    /** Sparse Color Filter #1 White-Red-White-Green 10-bit unpacked*/
    PixelFormatInfoSelector_SCF1WRWG10(159),
    /** Sparse Color Filter #1 White-Red-White-Green 10-bit packed*/
    PixelFormatInfoSelector_SCF1WRWG10p(160),
    /** Sparse Color Filter #1 White-Red-White-Green 12-bit unpacked*/
    PixelFormatInfoSelector_SCF1WRWG12(161),
    /** Sparse Color Filter #1 White-Red-White-Green 12-bit packed*/
    PixelFormatInfoSelector_SCF1WRWG12p(162),
    /** Sparse Color Filter #1 White-Red-White-Green 14-bit unpacked*/
    PixelFormatInfoSelector_SCF1WRWG14(163),
    /** Sparse Color Filter #1 White-Red-White-Green 16-bit*/
    PixelFormatInfoSelector_SCF1WRWG16(164),
    /** YCbCr 4:4:4 8-bit*/
    PixelFormatInfoSelector_YCbCr8(165),
    /** YCbCr 4:4:4 8-bit*/
    PixelFormatInfoSelector_YCbCr8_CbYCr(166),
    /** YCbCr 4:4:4 10-bit unpacked*/
    PixelFormatInfoSelector_YCbCr10_CbYCr(167),
    /** YCbCr 4:4:4 10-bit packed*/
    PixelFormatInfoSelector_YCbCr10p_CbYCr(168),
    /** YCbCr 4:4:4 12-bit unpacked*/
    PixelFormatInfoSelector_YCbCr12_CbYCr(169),
    /** YCbCr 4:4:4 12-bit packed*/
    PixelFormatInfoSelector_YCbCr12p_CbYCr(170),
    /** YCbCr 4:1:1 8-bit*/
    PixelFormatInfoSelector_YCbCr411_8(171),
    /** YCbCr 4:1:1 8-bit*/
    PixelFormatInfoSelector_YCbCr411_8_CbYYCrYY(172),
    /** YCbCr 4:2:2 8-bit*/
    PixelFormatInfoSelector_YCbCr422_8(173),
    /** YCbCr 4:2:2 8-bit*/
    PixelFormatInfoSelector_YCbCr422_8_CbYCrY(174),
    /** YCbCr 4:2:2 10-bit unpacked*/
    PixelFormatInfoSelector_YCbCr422_10(175),
    /** YCbCr 4:2:2 10-bit unpacked*/
    PixelFormatInfoSelector_YCbCr422_10_CbYCrY(176),
    /** YCbCr 4:2:2 10-bit packed*/
    PixelFormatInfoSelector_YCbCr422_10p(177),
    /** YCbCr 4:2:2 10-bit packed*/
    PixelFormatInfoSelector_YCbCr422_10p_CbYCrY(178),
    /** YCbCr 4:2:2 12-bit unpacked*/
    PixelFormatInfoSelector_YCbCr422_12(179),
    /** YCbCr 4:2:2 12-bit unpacked*/
    PixelFormatInfoSelector_YCbCr422_12_CbYCrY(180),
    /** YCbCr 4:2:2 12-bit packed*/
    PixelFormatInfoSelector_YCbCr422_12p(181),
    /** YCbCr 4:2:2 12-bit packed*/
    PixelFormatInfoSelector_YCbCr422_12p_CbYCrY(182),
    /** YCbCr 4:4:4 8-bit BT.601*/
    PixelFormatInfoSelector_YCbCr601_8_CbYCr(183),
    /** YCbCr 4:4:4 10-bit unpacked BT.601*/
    PixelFormatInfoSelector_YCbCr601_10_CbYCr(184),
    /** YCbCr 4:4:4 10-bit packed BT.601*/
    PixelFormatInfoSelector_YCbCr601_10p_CbYCr(185),
    /** YCbCr 4:4:4 12-bit unpacked BT.601*/
    PixelFormatInfoSelector_YCbCr601_12_CbYCr(186),
    /** YCbCr 4:4:4 12-bit packed BT.601*/
    PixelFormatInfoSelector_YCbCr601_12p_CbYCr(187),
    /** YCbCr 4:1:1 8-bit BT.601*/
    PixelFormatInfoSelector_YCbCr601_411_8_CbYYCrYY(188),
    /** YCbCr 4:2:2 8-bit BT.601*/
    PixelFormatInfoSelector_YCbCr601_422_8(189),
    /** YCbCr 4:2:2 8-bit BT.601*/
    PixelFormatInfoSelector_YCbCr601_422_8_CbYCrY(190),
    /** YCbCr 4:2:2 10-bit unpacked BT.601*/
    PixelFormatInfoSelector_YCbCr601_422_10(191),
    /** YCbCr 4:2:2 10-bit unpacked BT.601*/
    PixelFormatInfoSelector_YCbCr601_422_10_CbYCrY(192),
    /** YCbCr 4:2:2 10-bit packed BT.601*/
    PixelFormatInfoSelector_YCbCr601_422_10p(193),
    /** YCbCr 4:2:2 10-bit packed BT.601*/
    PixelFormatInfoSelector_YCbCr601_422_10p_CbYCrY(194),
    /** YCbCr 4:2:2 12-bit unpacked BT.601*/
    PixelFormatInfoSelector_YCbCr601_422_12(195),
    /** YCbCr 4:2:2 12-bit unpacked BT.601*/
    PixelFormatInfoSelector_YCbCr601_422_12_CbYCrY(196),
    /** YCbCr 4:2:2 12-bit packed BT.601*/
    PixelFormatInfoSelector_YCbCr601_422_12p(197),
    /** YCbCr 4:2:2 12-bit packed BT.601*/
    PixelFormatInfoSelector_YCbCr601_422_12p_CbYCrY(198),
    /** YCbCr 4:4:4 8-bit BT.709*/
    PixelFormatInfoSelector_YCbCr709_8_CbYCr(199),
    /** YCbCr 4:4:4 10-bit unpacked BT.709*/
    PixelFormatInfoSelector_YCbCr709_10_CbYCr(200),
    /** YCbCr 4:4:4 10-bit packed BT.709*/
    PixelFormatInfoSelector_YCbCr709_10p_CbYCr(201),
    /** YCbCr 4:4:4 12-bit unpacked BT.709*/
    PixelFormatInfoSelector_YCbCr709_12_CbYCr(202),
    /** YCbCr 4:4:4 12-bit packed BT.709*/
    PixelFormatInfoSelector_YCbCr709_12p_CbYCr(203),
    /** YCbCr 4:1:1 8-bit BT.709*/
    PixelFormatInfoSelector_YCbCr709_411_8_CbYYCrYY(204),
    /** YCbCr 4:2:2 8-bit BT.709*/
    PixelFormatInfoSelector_YCbCr709_422_8(205),
    /** YCbCr 4:2:2 8-bit BT.709*/
    PixelFormatInfoSelector_YCbCr709_422_8_CbYCrY(206),
    /** YCbCr 4:2:2 10-bit unpacked BT.709*/
    PixelFormatInfoSelector_YCbCr709_422_10(207),
    /** YCbCr 4:2:2 10-bit unpacked BT.709*/
    PixelFormatInfoSelector_YCbCr709_422_10_CbYCrY(208),
    /** YCbCr 4:2:2 10-bit packed BT.709*/
    PixelFormatInfoSelector_YCbCr709_422_10p(209),
    /** YCbCr 4:2:2 10-bit packed BT.709*/
    PixelFormatInfoSelector_YCbCr709_422_10p_CbYCrY(210),
    /** YCbCr 4:2:2 12-bit unpacked BT.709*/
    PixelFormatInfoSelector_YCbCr709_422_12(211),
    /** YCbCr 4:2:2 12-bit unpacked BT.709*/
    PixelFormatInfoSelector_YCbCr709_422_12_CbYCrY(212),
    /** YCbCr 4:2:2 12-bit packed BT.709*/
    PixelFormatInfoSelector_YCbCr709_422_12p(213),
    /** YCbCr 4:2:2 12-bit packed BT.709*/
    PixelFormatInfoSelector_YCbCr709_422_12p_CbYCrY(214),
    /** YUV 4:4:4 8-bit*/
    PixelFormatInfoSelector_YUV8_UYV(215),
    /** YUV 4:1:1 8-bit*/
    PixelFormatInfoSelector_YUV411_8_UYYVYY(216),
    /** YUV 4:2:2 8-bit*/
    PixelFormatInfoSelector_YUV422_8(217),
    /** YUV 4:2:2 8-bit*/
    PixelFormatInfoSelector_YUV422_8_UYVY(218),
    /** Monochrome Polarized 8-bit*/
    PixelFormatInfoSelector_Polarized8(219),
    /** Monochrome Polarized 10-bit packed*/
    PixelFormatInfoSelector_Polarized10p(220),
    /** Monochrome Polarized 12-bit packed*/
    PixelFormatInfoSelector_Polarized12p(221),
    /** Monochrome Polarized 16-bit*/
    PixelFormatInfoSelector_Polarized16(222),
    /** Polarized Bayer Red Green filter 8-bit*/
    PixelFormatInfoSelector_BayerRGPolarized8(223),
    /** Polarized Bayer Red Green filter 10-bit packed*/
    PixelFormatInfoSelector_BayerRGPolarized10p(224),
    /** Polarized Bayer Red Green filter 12-bit packed*/
    PixelFormatInfoSelector_BayerRGPolarized12p(225),
    /** Polarized Bayer Red Green filter 16-bit*/
    PixelFormatInfoSelector_BayerRGPolarized16(226),
    /** Lossless Compression Monochrome 8-bit*/
    PixelFormatInfoSelector_LLCMono8(227),
    /** Lossless Compression Bayer Red Green filter 8-bit*/
    PixelFormatInfoSelector_LLCBayerRG8(228),
    /** JPEG Monochrome 8-bit*/
    PixelFormatInfoSelector_JPEGMono8(229),
    /** JPEG Color 8-bit*/
    PixelFormatInfoSelector_JPEGColor8(230),
    NUM_PIXELFORMATINFOSELECTOR(231);

    public final int value;
    private _spinPixelFormatInfoSelectorEnums(int v) { this.value = v; }
    private _spinPixelFormatInfoSelectorEnums(_spinPixelFormatInfoSelectorEnums e) { this.value = e.value; }
    public _spinPixelFormatInfoSelectorEnums intern() { for (_spinPixelFormatInfoSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDeinterlacingEnums {
    /** The device doesn't perform de-interlacing.*/
    Deinterlacing_Off(0),
    /** The device performs de-interlacing by outputting each line of each field twice.*/
    Deinterlacing_LineDuplication(1),
    /** The device performs de-interlacing by interleaving the lines of all fields.*/
    Deinterlacing_Weave(2),
    NUM_DEINTERLACING(3);

    public final int value;
    private _spinDeinterlacingEnums(int v) { this.value = v; }
    private _spinDeinterlacingEnums(_spinDeinterlacingEnums e) { this.value = e.value; }
    public _spinDeinterlacingEnums intern() { for (_spinDeinterlacingEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinImageCompressionRateOptionEnums {
    /** Output stream follows a constant bit rate. Allows easy bandwidth management on the link.*/
    ImageCompressionRateOption_FixBitrate(0),
    /** Output stream has a constant image quality. Can be used when image processing algorithms are sensitive to image degradation caused by excessive data compression.*/
    ImageCompressionRateOption_FixQuality(1),
    NUM_IMAGECOMPRESSIONRATEOPTION(2);

    public final int value;
    private _spinImageCompressionRateOptionEnums(int v) { this.value = v; }
    private _spinImageCompressionRateOptionEnums(_spinImageCompressionRateOptionEnums e) { this.value = e.value; }
    public _spinImageCompressionRateOptionEnums intern() { for (_spinImageCompressionRateOptionEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinImageCompressionJPEGFormatOptionEnums {
    /** Selects lossless JPEG compression based on a predictive coding model.*/
    ImageCompressionJPEGFormatOption_Lossless(0),
    /** Indicates this is a baseline sequential (single-scan) DCT-based JPEG.*/
    ImageCompressionJPEGFormatOption_BaselineStandard(1),
    /** Provides optimized color and slightly better compression than baseline standard by using custom Huffman tables optimized after statistical analysis of the image content.*/
    ImageCompressionJPEGFormatOption_BaselineOptimized(2),
    /** Indicates this is a progressive (multi-scan) DCT-based JPEG.*/
    ImageCompressionJPEGFormatOption_Progressive(3),
    NUM_IMAGECOMPRESSIONJPEGFORMATOPTION(4);

    public final int value;
    private _spinImageCompressionJPEGFormatOptionEnums(int v) { this.value = v; }
    private _spinImageCompressionJPEGFormatOptionEnums(_spinImageCompressionJPEGFormatOptionEnums e) { this.value = e.value; }
    public _spinImageCompressionJPEGFormatOptionEnums intern() { for (_spinImageCompressionJPEGFormatOptionEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinAcquisitionStatusSelectorEnums {
    /** Device is currently waiting for a trigger for the capture of one or many frames.*/
    AcquisitionStatusSelector_AcquisitionTriggerWait(0),
    /** Device is currently doing an acquisition of one or many frames.*/
    AcquisitionStatusSelector_AcquisitionActive(1),
    /** Device is currently transferring an acquisition of one or many frames.*/
    AcquisitionStatusSelector_AcquisitionTransfer(2),
    /** Device is currently waiting for a frame start trigger.*/
    AcquisitionStatusSelector_FrameTriggerWait(3),
    /** Device is currently doing the capture of a frame.*/
    AcquisitionStatusSelector_FrameActive(4),
    /** Device is doing the exposure of a frame.*/
    AcquisitionStatusSelector_ExposureActive(5),
    NUM_ACQUISITIONSTATUSSELECTOR(6);

    public final int value;
    private _spinAcquisitionStatusSelectorEnums(int v) { this.value = v; }
    private _spinAcquisitionStatusSelectorEnums(_spinAcquisitionStatusSelectorEnums e) { this.value = e.value; }
    public _spinAcquisitionStatusSelectorEnums intern() { for (_spinAcquisitionStatusSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinExposureTimeModeEnums {
    /** The exposure time is common to all the color components. The common ExposureTime value to use can be set selecting it with ExposureTimeSelector[Common].*/
    ExposureTimeMode_Common(0),
    /** The exposure time is individual for each color component. Each individual ExposureTime values to use can be set by selecting them with ExposureTimeSelector.*/
    ExposureTimeMode_Individual(1),
    NUM_EXPOSURETIMEMODE(2);

    public final int value;
    private _spinExposureTimeModeEnums(int v) { this.value = v; }
    private _spinExposureTimeModeEnums(_spinExposureTimeModeEnums e) { this.value = e.value; }
    public _spinExposureTimeModeEnums intern() { for (_spinExposureTimeModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinExposureTimeSelectorEnums {
    /** Selects the common ExposureTime.*/
    ExposureTimeSelector_Common(0),
    /** Selects the red common ExposureTime.*/
    ExposureTimeSelector_Red(1),
    /** Selects the green ExposureTime.*/
    ExposureTimeSelector_Green(2),
    /** Selects the blue ExposureTime.*/
    ExposureTimeSelector_Blue(3),
    /** Selects the cyan common ExposureTime.*/
    ExposureTimeSelector_Cyan(4),
    /** Selects the magenta ExposureTime.*/
    ExposureTimeSelector_Magenta(5),
    /** Selects the yellow ExposureTime.*/
    ExposureTimeSelector_Yellow(6),
    /** Selects the infrared ExposureTime.*/
    ExposureTimeSelector_Infrared(7),
    /** Selects the ultraviolet ExposureTime.*/
    ExposureTimeSelector_Ultraviolet(8),
    /** Selects the first stage ExposureTime.*/
    ExposureTimeSelector_Stage1(9),
    /** Selects the second stage ExposureTime.*/
    ExposureTimeSelector_Stage2(10),
    NUM_EXPOSURETIMESELECTOR(11);

    public final int value;
    private _spinExposureTimeSelectorEnums(int v) { this.value = v; }
    private _spinExposureTimeSelectorEnums(_spinExposureTimeSelectorEnums e) { this.value = e.value; }
    public _spinExposureTimeSelectorEnums intern() { for (_spinExposureTimeSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinGainAutoBalanceEnums {
    /** Gain tap balancing is user controlled using Gain .*/
    GainAutoBalance_Off(0),
    /** Gain tap balancing is automatically adjusted once by the device. Once it has converged, it automatically returns to the Off state.*/
    GainAutoBalance_Once(1),
    /** Gain tap balancing is constantly adjusted by the device.*/
    GainAutoBalance_Continuous(2),
    NUM_GAINAUTOBALANCE(3);

    public final int value;
    private _spinGainAutoBalanceEnums(int v) { this.value = v; }
    private _spinGainAutoBalanceEnums(_spinGainAutoBalanceEnums e) { this.value = e.value; }
    public _spinGainAutoBalanceEnums intern() { for (_spinGainAutoBalanceEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinBlackLevelAutoEnums {
    /** Analog black level is user controlled using BlackLevel.*/
    BlackLevelAuto_Off(0),
    /** Analog black level is automatically adjusted once by the device. Once it has converged, it automatically returns to the Off state.*/
    BlackLevelAuto_Once(1),
    /** Analog black level is constantly adjusted by the device.*/
    BlackLevelAuto_Continuous(2),
    NUM_BLACKLEVELAUTO(3);

    public final int value;
    private _spinBlackLevelAutoEnums(int v) { this.value = v; }
    private _spinBlackLevelAutoEnums(_spinBlackLevelAutoEnums e) { this.value = e.value; }
    public _spinBlackLevelAutoEnums intern() { for (_spinBlackLevelAutoEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinBlackLevelAutoBalanceEnums {
    /** Black level tap balancing is user controlled using BlackLevel.*/
    BlackLevelAutoBalance_Off(0),
    /** Black level tap balancing is automatically adjusted once by the device. Once it has converged, it automatically returns to the Off state.*/
    BlackLevelAutoBalance_Once(1),
    /** Black level tap balancing is constantly adjusted by the device.*/
    BlackLevelAutoBalance_Continuous(2),
    NUM_BLACKLEVELAUTOBALANCE(3);

    public final int value;
    private _spinBlackLevelAutoBalanceEnums(int v) { this.value = v; }
    private _spinBlackLevelAutoBalanceEnums(_spinBlackLevelAutoBalanceEnums e) { this.value = e.value; }
    public _spinBlackLevelAutoBalanceEnums intern() { for (_spinBlackLevelAutoBalanceEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinWhiteClipSelectorEnums {
    /** White Clip will be applied to all channels or taps.*/
    WhiteClipSelector_All(0),
    /** White Clip will be applied to the red channel.*/
    WhiteClipSelector_Red(1),
    /** White Clip will be applied to the green channel.*/
    WhiteClipSelector_Green(2),
    /** White Clip will be applied to the blue channel.*/
    WhiteClipSelector_Blue(3),
    /** White Clip will be applied to Y channel.*/
    WhiteClipSelector_Y(4),
    /** White Clip will be applied to U channel.*/
    WhiteClipSelector_U(5),
    /** White Clip will be applied to V channel.*/
    WhiteClipSelector_V(6),
    /** White Clip will be applied to Tap 1.*/
    WhiteClipSelector_Tap1(7),
    /** White Clip will be applied to Tap 2.*/
    WhiteClipSelector_Tap2(8),
    NUM_WHITECLIPSELECTOR(9);

    public final int value;
    private _spinWhiteClipSelectorEnums(int v) { this.value = v; }
    private _spinWhiteClipSelectorEnums(_spinWhiteClipSelectorEnums e) { this.value = e.value; }
    public _spinWhiteClipSelectorEnums intern() { for (_spinWhiteClipSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTimerSelectorEnums {
    /** Selects the Timer 0.*/
    TimerSelector_Timer0(0),
    /** Selects the Timer 1.*/
    TimerSelector_Timer1(1),
    /** Selects the Timer 2.*/
    TimerSelector_Timer2(2),
    NUM_TIMERSELECTOR(3);

    public final int value;
    private _spinTimerSelectorEnums(int v) { this.value = v; }
    private _spinTimerSelectorEnums(_spinTimerSelectorEnums e) { this.value = e.value; }
    public _spinTimerSelectorEnums intern() { for (_spinTimerSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTimerStatusEnums {
    /** The Timer is idle.*/
    TimerStatus_TimerIdle(0),
    /** The Timer is waiting for a start trigger.*/
    TimerStatus_TimerTriggerWait(1),
    /** The Timer is counting for the specified duration.*/
    TimerStatus_TimerActive(2),
    /** The Timer reached the TimerDuration count.*/
    TimerStatus_TimerCompleted(3),
    NUM_TIMERSTATUS(4);

    public final int value;
    private _spinTimerStatusEnums(int v) { this.value = v; }
    private _spinTimerStatusEnums(_spinTimerStatusEnums e) { this.value = e.value; }
    public _spinTimerStatusEnums intern() { for (_spinTimerStatusEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTimerTriggerSourceEnums {
    /** Disables the Timer trigger.*/
    TimerTriggerSource_Off(0),
    /** Starts with the reception of the Acquisition Trigger.*/
    TimerTriggerSource_AcquisitionTrigger(1),
    /** Starts with the reception of the Acquisition Start.*/
    TimerTriggerSource_AcquisitionStart(2),
    /** Starts with the reception of the Acquisition End.*/
    TimerTriggerSource_AcquisitionEnd(3),
    /** Starts with the reception of the Frame Start Trigger.*/
    TimerTriggerSource_FrameTrigger(4),
    /** Starts with the reception of the Frame Start.*/
    TimerTriggerSource_FrameStart(5),
    /** Starts with the reception of the Frame End.*/
    TimerTriggerSource_FrameEnd(6),
    /** Starts with the reception of the Frame Burst Start.*/
    TimerTriggerSource_FrameBurstStart(7),
    /** Starts with the reception of the Frame Burst End.*/
    TimerTriggerSource_FrameBurstEnd(8),
    /** Starts with the reception of the Line Start Trigger.*/
    TimerTriggerSource_LineTrigger(9),
    /** Starts with the reception of the Line Start.*/
    TimerTriggerSource_LineStart(10),
    /** Starts with the reception of the Line End.*/
    TimerTriggerSource_LineEnd(11),
    /** Starts with the reception of the Exposure Start.*/
    TimerTriggerSource_ExposureStart(12),
    /** Starts with the reception of the Exposure End.*/
    TimerTriggerSource_ExposureEnd(13),
    /** Starts when the specidfied TimerTriggerActivation condition is met on the chosen I/O Line.*/
    TimerTriggerSource_Line0(14),
    /** Starts when the specidfied TimerTriggerActivation condition is met on the chosen I/O Line.*/
    TimerTriggerSource_Line1(15),
    /** Starts when the specidfied TimerTriggerActivation condition is met on the chosen I/O Line.*/
    TimerTriggerSource_Line2(16),
    /** Specifies which User Output bit signal to use as internal source for the trigger.*/
    TimerTriggerSource_UserOutput0(17),
    /** Specifies which User Output bit signal to use as internal source for the trigger.*/
    TimerTriggerSource_UserOutput1(18),
    /** Specifies which User Output bit signal to use as internal source for the trigger.*/
    TimerTriggerSource_UserOutput2(19),
    /** Starts with the reception of the Counter Start.*/
    TimerTriggerSource_Counter0Start(20),
    /** Starts with the reception of the Counter Start.*/
    TimerTriggerSource_Counter1Start(21),
    /** Starts with the reception of the Counter Start.*/
    TimerTriggerSource_Counter2Start(22),
    /** Starts with the reception of the Counter End.*/
    TimerTriggerSource_Counter0End(23),
    /** Starts with the reception of the Counter End.*/
    TimerTriggerSource_Counter1End(24),
    /** Starts with the reception of the Counter End.*/
    TimerTriggerSource_Counter2End(25),
    /** Starts with the reception of the Timer Start.*/
    TimerTriggerSource_Timer0Start(26),
    /** Starts with the reception of the Timer Start.*/
    TimerTriggerSource_Timer1Start(27),
    /** Starts with the reception of the Timer Start.*/
    TimerTriggerSource_Timer2Start(28),
    /** Starts with the reception of the Timer End. Note that a timer can retrigger itself to achieve a free running Timer.*/
    TimerTriggerSource_Timer0End(29),
    /** Starts with the reception of the Timer End. Note that a timer can retrigger itself to achieve a free running Timer.*/
    TimerTriggerSource_Timer1End(30),
    /** Starts with the reception of the Timer End. Note that a timer can retrigger itself to achieve a free running Timer.*/
    TimerTriggerSource_Timer2End(31),
    /** Starts with the reception of the Encoder output signal.*/
    TimerTriggerSource_Encoder0(32),
    /** Starts with the reception of the Encoder output signal.*/
    TimerTriggerSource_Encoder1(33),
    /** Starts with the reception of the Encoder output signal.*/
    TimerTriggerSource_Encoder2(34),
    /** Starts on the reception of the Software Signal.*/
    TimerTriggerSource_SoftwareSignal0(35),
    /** Starts on the reception of the Software Signal.*/
    TimerTriggerSource_SoftwareSignal1(36),
    /** Starts on the reception of the Software Signal.*/
    TimerTriggerSource_SoftwareSignal2(37),
    /** Starts with the assertion of the chosen action signal.*/
    TimerTriggerSource_Action0(38),
    /** Starts with the assertion of the chosen action signal.*/
    TimerTriggerSource_Action1(39),
    /** Starts with the assertion of the chosen action signal.*/
    TimerTriggerSource_Action2(40),
    /** Starts with the reception of the chosen Link Trigger.*/
    TimerTriggerSource_LinkTrigger0(41),
    /** Starts with the reception of the chosen Link Trigger.*/
    TimerTriggerSource_LinkTrigger1(42),
    /** Starts with the reception of the chosen Link Trigger.*/
    TimerTriggerSource_LinkTrigger2(43),
    NUM_TIMERTRIGGERSOURCE(44);

    public final int value;
    private _spinTimerTriggerSourceEnums(int v) { this.value = v; }
    private _spinTimerTriggerSourceEnums(_spinTimerTriggerSourceEnums e) { this.value = e.value; }
    public _spinTimerTriggerSourceEnums intern() { for (_spinTimerTriggerSourceEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTimerTriggerActivationEnums {
    /** Starts counting on the Rising Edge of the selected trigger signal.*/
    TimerTriggerActivation_RisingEdge(0),
    /** Starts counting on the Falling Edge of the selected trigger signal.*/
    TimerTriggerActivation_FallingEdge(1),
    /** Starts counting on the Falling or Rising Edge of the selected trigger signal.*/
    TimerTriggerActivation_AnyEdge(2),
    /** Counts as long as the selected trigger signal level is High.*/
    TimerTriggerActivation_LevelHigh(3),
    /** Counts as long as the selected trigger signal level is Low.*/
    TimerTriggerActivation_LevelLow(4),
    NUM_TIMERTRIGGERACTIVATION(5);

    public final int value;
    private _spinTimerTriggerActivationEnums(int v) { this.value = v; }
    private _spinTimerTriggerActivationEnums(_spinTimerTriggerActivationEnums e) { this.value = e.value; }
    public _spinTimerTriggerActivationEnums intern() { for (_spinTimerTriggerActivationEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinEncoderSelectorEnums {
    /** Selects Encoder 0.*/
    EncoderSelector_Encoder0(0),
    /** Selects Encoder 1.*/
    EncoderSelector_Encoder1(1),
    /** Selects Encoder 2.*/
    EncoderSelector_Encoder2(2),
    NUM_ENCODERSELECTOR(3);

    public final int value;
    private _spinEncoderSelectorEnums(int v) { this.value = v; }
    private _spinEncoderSelectorEnums(_spinEncoderSelectorEnums e) { this.value = e.value; }
    public _spinEncoderSelectorEnums intern() { for (_spinEncoderSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinEncoderSourceAEnums {
    /** Counter is stopped.*/
    EncoderSourceA_Off(0),
    /** Encoder Forward input is taken from the chosen I/O Line.*/
    EncoderSourceA_Line0(1),
    /** Encoder Forward input is taken from the chosen I/O Line.*/
    EncoderSourceA_Line1(2),
    /** Encoder Forward input is taken from the chosen I/O Line.*/
    EncoderSourceA_Line2(3),
    NUM_ENCODERSOURCEA(4);

    public final int value;
    private _spinEncoderSourceAEnums(int v) { this.value = v; }
    private _spinEncoderSourceAEnums(_spinEncoderSourceAEnums e) { this.value = e.value; }
    public _spinEncoderSourceAEnums intern() { for (_spinEncoderSourceAEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinEncoderSourceBEnums {
    /** Counter is stopped.*/
    EncoderSourceB_Off(0),
    /** Encoder Reverse input is taken from the chosen I/O Line..*/
    EncoderSourceB_Line0(1),
    /** Encoder Reverse input is taken from the chosen I/O Line..*/
    EncoderSourceB_Line1(2),
    /** Encoder Reverse input is taken from the chosen I/O Line..*/
    EncoderSourceB_Line2(3),
    NUM_ENCODERSOURCEB(4);

    public final int value;
    private _spinEncoderSourceBEnums(int v) { this.value = v; }
    private _spinEncoderSourceBEnums(_spinEncoderSourceBEnums e) { this.value = e.value; }
    public _spinEncoderSourceBEnums intern() { for (_spinEncoderSourceBEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinEncoderModeEnums {
    /** The counter increments or decrements 1 for every full quadrature cycle with jitter filtering.*/
    EncoderMode_FourPhase(0),
    /** The counter increments or decrements every quadrature phase for high resolution counting, but without jitter filtering.*/
    EncoderMode_HighResolution(1),
    NUM_ENCODERMODE(2);

    public final int value;
    private _spinEncoderModeEnums(int v) { this.value = v; }
    private _spinEncoderModeEnums(_spinEncoderModeEnums e) { this.value = e.value; }
    public _spinEncoderModeEnums intern() { for (_spinEncoderModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinEncoderOutputModeEnums {
    /** No output pulse are generated.*/
    EncoderOutputMode_Off(0),
    /** Output pulses are generated at all new positions in the positive direction. If the encoder reverses no output pulse are generated until it has again passed the position where the reversal started.*/
    EncoderOutputMode_PositionUp(1),
    /** Output pulses are generated at all new positions in the negative direction. If the encoder reverses no output pulse are generated until it has again passed the position where the reversal started.*/
    EncoderOutputMode_PositionDown(2),
    /** Output pulses are generated at all position increments in the positive direction while ignoring negative direction motion.*/
    EncoderOutputMode_DirectionUp(3),
    /** Output pulses are generated at all position increments in the negative direction while ignoring positive direction motion.*/
    EncoderOutputMode_DirectionDown(4),
    /** Output pulses are generated at all motion increments in both directions.*/
    EncoderOutputMode_Motion(5),
    NUM_ENCODEROUTPUTMODE(6);

    public final int value;
    private _spinEncoderOutputModeEnums(int v) { this.value = v; }
    private _spinEncoderOutputModeEnums(_spinEncoderOutputModeEnums e) { this.value = e.value; }
    public _spinEncoderOutputModeEnums intern() { for (_spinEncoderOutputModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinEncoderStatusEnums {
    /** The encoder counter last incremented.*/
    EncoderStatus_EncoderUp(0),
    /** The encoder counter last decremented.*/
    EncoderStatus_EncoderDown(1),
    /** The encoder is not active.*/
    EncoderStatus_EncoderIdle(2),
    /** No motion within the EncoderTimeout time.*/
    EncoderStatus_EncoderStatic(3),
    NUM_ENCODERSTATUS(4);

    public final int value;
    private _spinEncoderStatusEnums(int v) { this.value = v; }
    private _spinEncoderStatusEnums(_spinEncoderStatusEnums e) { this.value = e.value; }
    public _spinEncoderStatusEnums intern() { for (_spinEncoderStatusEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinEncoderResetSourceEnums {
    /** Disable the Encoder Reset trigger.*/
    EncoderResetSource_Off(0),
    /** Resets with the reception of the Acquisition Trigger.*/
    EncoderResetSource_AcquisitionTrigger(1),
    /** Resets with the reception of the Acquisition Start.*/
    EncoderResetSource_AcquisitionStart(2),
    /** Resets with the reception of the Acquisition End.*/
    EncoderResetSource_AcquisitionEnd(3),
    /** Resets with the reception of the Frame Start Trigger.*/
    EncoderResetSource_FrameTrigger(4),
    /** Resets with the reception of the Frame Start.*/
    EncoderResetSource_FrameStart(5),
    /** Resets with the reception of the Frame End.*/
    EncoderResetSource_FrameEnd(6),
    /** Resets with the reception of the Exposure Start.*/
    EncoderResetSource_ExposureStart(7),
    /** Resets with the reception of the Exposure End.*/
    EncoderResetSource_ExposureEnd(8),
    /** Resets by the chosen I/O Line.*/
    EncoderResetSource_Line0(9),
    /** Resets by the chosen I/O Line.*/
    EncoderResetSource_Line1(10),
    /** Resets by the chosen I/O Line.*/
    EncoderResetSource_Line2(11),
    /** Resets with the reception of the Counter Start.*/
    EncoderResetSource_Counter0Start(12),
    /** Resets with the reception of the Counter Start.*/
    EncoderResetSource_Counter1Start(13),
    /** Resets with the reception of the Counter Start.*/
    EncoderResetSource_Counter2Start(14),
    /** Resets with the reception of the Counter End.*/
    EncoderResetSource_Counter0End(15),
    /** Resets with the reception of the Counter End.*/
    EncoderResetSource_Counter1End(16),
    /** Resets with the reception of the Counter End.*/
    EncoderResetSource_Counter2End(17),
    /** Resets with the reception of the Timer Start.*/
    EncoderResetSource_Timer0Start(18),
    /** Resets with the reception of the Timer Start.*/
    EncoderResetSource_Timer1Start(19),
    /** Resets with the reception of the Timer Start.*/
    EncoderResetSource_Timer2Start(20),
    /** Resets with the reception of the Timer End.*/
    EncoderResetSource_Timer0End(21),
    /** Resets with the reception of the Timer End.*/
    EncoderResetSource_Timer1End(22),
    /** Resets with the reception of the Timer End.*/
    EncoderResetSource_Timer2End(23),
    /** Resets by the chosen User Output bit.*/
    EncoderResetSource_UserOutput0(24),
    /** Resets by the chosen User Output bit.*/
    EncoderResetSource_UserOutput1(25),
    /** Resets by the chosen User Output bit.*/
    EncoderResetSource_UserOutput2(26),
    /** Resets on the reception of the Software Signal.*/
    EncoderResetSource_SoftwareSignal0(27),
    /** Resets on the reception of the Software Signal.*/
    EncoderResetSource_SoftwareSignal1(28),
    /** Resets on the reception of the Software Signal.*/
    EncoderResetSource_SoftwareSignal2(29),
    /** Resets on assertions of the chosen action signal (Broadcasted signal on the transport layer).*/
    EncoderResetSource_Action0(30),
    /** Resets on assertions of the chosen action signal (Broadcasted signal on the transport layer).*/
    EncoderResetSource_Action1(31),
    /** Resets on assertions of the chosen action signal (Broadcasted signal on the transport layer).*/
    EncoderResetSource_Action2(32),
    /** Resets on the reception of the chosen Link Trigger (received from the transport layer).*/
    EncoderResetSource_LinkTrigger0(33),
    /** Resets on the reception of the chosen Link Trigger (received from the transport layer).*/
    EncoderResetSource_LinkTrigger1(34),
    /** Resets on the reception of the chosen Link Trigger (received from the transport layer).*/
    EncoderResetSource_LinkTrigger2(35),
    NUM_ENCODERRESETSOURCE(36);

    public final int value;
    private _spinEncoderResetSourceEnums(int v) { this.value = v; }
    private _spinEncoderResetSourceEnums(_spinEncoderResetSourceEnums e) { this.value = e.value; }
    public _spinEncoderResetSourceEnums intern() { for (_spinEncoderResetSourceEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinEncoderResetActivationEnums {
    /** Resets the Encoder on the Rising Edge of the signal.*/
    EncoderResetActivation_RisingEdge(0),
    /** Resets the Encoder on the Falling Edge of the signal.*/
    EncoderResetActivation_FallingEdge(1),
    /** Resets the Encoder on the Falling or rising Edge of the selected signal.*/
    EncoderResetActivation_AnyEdge(2),
    /** Resets the Encoder as long as the selected signal level is High.*/
    EncoderResetActivation_LevelHigh(3),
    /** Resets the Encoder as long as the selected signal level is Low.*/
    EncoderResetActivation_LevelLow(4),
    NUM_ENCODERRESETACTIVATION(5);

    public final int value;
    private _spinEncoderResetActivationEnums(int v) { this.value = v; }
    private _spinEncoderResetActivationEnums(_spinEncoderResetActivationEnums e) { this.value = e.value; }
    public _spinEncoderResetActivationEnums intern() { for (_spinEncoderResetActivationEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinSoftwareSignalSelectorEnums {
    /** Selects the software generated signal to control.*/
    SoftwareSignalSelector_SoftwareSignal0(0),
    /** Selects the software generated signal to control.*/
    SoftwareSignalSelector_SoftwareSignal1(1),
    /** Selects the software generated signal to control.*/
    SoftwareSignalSelector_SoftwareSignal2(2),
    NUM_SOFTWARESIGNALSELECTOR(3);

    public final int value;
    private _spinSoftwareSignalSelectorEnums(int v) { this.value = v; }
    private _spinSoftwareSignalSelectorEnums(_spinSoftwareSignalSelectorEnums e) { this.value = e.value; }
    public _spinSoftwareSignalSelectorEnums intern() { for (_spinSoftwareSignalSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinActionUnconditionalModeEnums {
    /** Unconditional mode is disabled.*/
    ActionUnconditionalMode_Off(0),
    /** Unconditional mode is enabled.*/
    ActionUnconditionalMode_On(1),
    NUM_ACTIONUNCONDITIONALMODE(2);

    public final int value;
    private _spinActionUnconditionalModeEnums(int v) { this.value = v; }
    private _spinActionUnconditionalModeEnums(_spinActionUnconditionalModeEnums e) { this.value = e.value; }
    public _spinActionUnconditionalModeEnums intern() { for (_spinActionUnconditionalModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinSourceSelectorEnums {
    /** Selects the data source 0.*/
    SourceSelector_Source0(0),
    /** Selects the data source 1.*/
    SourceSelector_Source1(1),
    /** Selects the data source 2.*/
    SourceSelector_Source2(2),
    /** Selects all the data sources.*/
    SourceSelector_All(3),
    NUM_SOURCESELECTOR(4);

    public final int value;
    private _spinSourceSelectorEnums(int v) { this.value = v; }
    private _spinSourceSelectorEnums(_spinSourceSelectorEnums e) { this.value = e.value; }
    public _spinSourceSelectorEnums intern() { for (_spinSourceSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTransferSelectorEnums {
    /** The transfer features control the data stream 0.*/
    TransferSelector_Stream0(0),
    /** The transfer features control the data stream 1.*/
    TransferSelector_Stream1(1),
    /** The transfer features control the data stream 2.*/
    TransferSelector_Stream2(2),
    /** The transfer features control all the data streams simulateneously.*/
    TransferSelector_All(3),
    NUM_TRANSFERSELECTOR(4);

    public final int value;
    private _spinTransferSelectorEnums(int v) { this.value = v; }
    private _spinTransferSelectorEnums(_spinTransferSelectorEnums e) { this.value = e.value; }
    public _spinTransferSelectorEnums intern() { for (_spinTransferSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTransferTriggerSelectorEnums {
    /** Selects a trigger to start the transfers.*/
    TransferTriggerSelector_TransferStart(0),
    /** Selects a trigger to stop the transfers.*/
    TransferTriggerSelector_TransferStop(1),
    /** Selects a trigger to abort the transfers.*/
    TransferTriggerSelector_TransferAbort(2),
    /** Selects a trigger to pause the transfers.*/
    TransferTriggerSelector_TransferPause(3),
    /** Selects a trigger to Resume the transfers.*/
    TransferTriggerSelector_TransferResume(4),
    /** Selects a trigger to Activate the transfers. This trigger type is used when TriggerActivation is set LevelHigh or levelLow.*/
    TransferTriggerSelector_TransferActive(5),
    /** Selects a trigger to start the transfer of a burst of frames specified by TransferBurstCount.*/
    TransferTriggerSelector_TransferBurstStart(6),
    /** Selects a trigger to end the transfer of a burst of frames.*/
    TransferTriggerSelector_TransferBurstStop(7),
    NUM_TRANSFERTRIGGERSELECTOR(8);

    public final int value;
    private _spinTransferTriggerSelectorEnums(int v) { this.value = v; }
    private _spinTransferTriggerSelectorEnums(_spinTransferTriggerSelectorEnums e) { this.value = e.value; }
    public _spinTransferTriggerSelectorEnums intern() { for (_spinTransferTriggerSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTransferTriggerModeEnums {
    /** Disables the selected trigger.*/
    TransferTriggerMode_Off(0),
    /** Enable the selected trigger.*/
    TransferTriggerMode_On(1),
    NUM_TRANSFERTRIGGERMODE(2);

    public final int value;
    private _spinTransferTriggerModeEnums(int v) { this.value = v; }
    private _spinTransferTriggerModeEnums(_spinTransferTriggerModeEnums e) { this.value = e.value; }
    public _spinTransferTriggerModeEnums intern() { for (_spinTransferTriggerModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTransferTriggerSourceEnums {
    /** Specifies which physical line (or pin) and associated I/O control block to use as external source for the transfer control trigger signal.*/
    TransferTriggerSource_Line0(0),
    /** Specifies which physical line (or pin) and associated I/O control block to use as external source for the transfer control trigger signal.*/
    TransferTriggerSource_Line1(1),
    /** Specifies which physical line (or pin) and associated I/O control block to use as external source for the transfer control trigger signal.*/
    TransferTriggerSource_Line2(2),
    /** Specifies which of the Counter signal to use as internal source for the transfer control trigger signal.*/
    TransferTriggerSource_Counter0Start(3),
    /** Specifies which of the Counter signal to use as internal source for the transfer control trigger signal.*/
    TransferTriggerSource_Counter1Start(4),
    /** Specifies which of the Counter signal to use as internal source for the transfer control trigger signal.*/
    TransferTriggerSource_Counter2Start(5),
    /** Specifies which of the Counter signal to use as internal source for the transfer control trigger signal.*/
    TransferTriggerSource_Counter0End(6),
    /** Specifies which of the Counter signal to use as internal source for the transfer control trigger signal.*/
    TransferTriggerSource_Counter1End(7),
    /** Specifies which of the Counter signal to use as internal source for the transfer control trigger signal.*/
    TransferTriggerSource_Counter2End(8),
    /** Specifies which Timer signal to use as internal source for the transfer control trigger signal.*/
    TransferTriggerSource_Timer0Start(9),
    /** Specifies which Timer signal to use as internal source for the transfer control trigger signal.*/
    TransferTriggerSource_Timer1Start(10),
    /** Specifies which Timer signal to use as internal source for the transfer control trigger signal.*/
    TransferTriggerSource_Timer2Start(11),
    /** Specifies which Timer signal to use as internal source for the transfer control trigger signal.*/
    TransferTriggerSource_Timer0End(12),
    /** Specifies which Timer signal to use as internal source for the transfer control trigger signal.*/
    TransferTriggerSource_Timer1End(13),
    /** Specifies which Timer signal to use as internal source for the transfer control trigger signal.*/
    TransferTriggerSource_Timer2End(14),
    /** Specifies which Software Signal to use as internal source for the transfer control trigger signal.*/
    TransferTriggerSource_SoftwareSignal0(15),
    /** Specifies which Software Signal to use as internal source for the transfer control trigger signal.*/
    TransferTriggerSource_SoftwareSignal1(16),
    /** Specifies which Software Signal to use as internal source for the transfer control trigger signal.*/
    TransferTriggerSource_SoftwareSignal2(17),
    /** Specifies which Action command to use as internal source for the transfer control trigger signal.*/
    TransferTriggerSource_Action0(18),
    /** Specifies which Action command to use as internal source for the transfer control trigger signal.*/
    TransferTriggerSource_Action1(19),
    /** Specifies which Action command to use as internal source for the transfer control trigger signal.*/
    TransferTriggerSource_Action2(20),
    NUM_TRANSFERTRIGGERSOURCE(21);

    public final int value;
    private _spinTransferTriggerSourceEnums(int v) { this.value = v; }
    private _spinTransferTriggerSourceEnums(_spinTransferTriggerSourceEnums e) { this.value = e.value; }
    public _spinTransferTriggerSourceEnums intern() { for (_spinTransferTriggerSourceEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTransferTriggerActivationEnums {
    /** Specifies that the trigger is considered valid on the rising edge of the source signal.*/
    TransferTriggerActivation_RisingEdge(0),
    /** Specifies that the trigger is considered valid on the falling edge of the source signal.*/
    TransferTriggerActivation_FallingEdge(1),
    /** Specifies that the trigger is considered valid on the falling or rising edge of the source signal.*/
    TransferTriggerActivation_AnyEdge(2),
    /** Specifies that the trigger is considered valid as long as the level of the source signal is high. This can apply to TransferActive and TransferPause trigger.*/
    TransferTriggerActivation_LevelHigh(3),
    /** Specifies that the trigger is considered valid as long as the level of the source signal is low. This can apply to TransferActive and TransferPause trigger.*/
    TransferTriggerActivation_LevelLow(4),
    NUM_TRANSFERTRIGGERACTIVATION(5);

    public final int value;
    private _spinTransferTriggerActivationEnums(int v) { this.value = v; }
    private _spinTransferTriggerActivationEnums(_spinTransferTriggerActivationEnums e) { this.value = e.value; }
    public _spinTransferTriggerActivationEnums intern() { for (_spinTransferTriggerActivationEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTransferStatusSelectorEnums {
    /** Data blocks are transmitted when enough data is available.*/
    TransferStatusSelector_Streaming(0),
    /** Data blocks transmission is suspended immediately.*/
    TransferStatusSelector_Paused(1),
    /** Data blocks transmission is stopping. The current block transmission will be completed and the transfer state will stop.*/
    TransferStatusSelector_Stopping(2),
    /** Data blocks transmission is stopped.*/
    TransferStatusSelector_Stopped(3),
    /** Data blocks queue is in overflow state.*/
    TransferStatusSelector_QueueOverflow(4),
    NUM_TRANSFERSTATUSSELECTOR(5);

    public final int value;
    private _spinTransferStatusSelectorEnums(int v) { this.value = v; }
    private _spinTransferStatusSelectorEnums(_spinTransferStatusSelectorEnums e) { this.value = e.value; }
    public _spinTransferStatusSelectorEnums intern() { for (_spinTransferStatusSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTransferComponentSelectorEnums {
    /** The TransferStreamChannel feature controls the index of the stream channel for the streaming of the red plane of the planar pixel formats.*/
    TransferComponentSelector_Red(0),
    /** The TransferStreamChannel feature controls the index of the stream channel for the streaming of the green plane of the planar pixel formats.*/
    TransferComponentSelector_Green(1),
    /** The TransferStreamChannel feature controls the index of the stream channel for the streaming of blue plane of the planar pixel formats.*/
    TransferComponentSelector_Blue(2),
    /** The TransferStreamChannel feature controls the index of the stream channel for the streaming of all the planes of the planar pixel formats simultaneously or non planar pixel formats.*/
    TransferComponentSelector_All(3),
    NUM_TRANSFERCOMPONENTSELECTOR(4);

    public final int value;
    private _spinTransferComponentSelectorEnums(int v) { this.value = v; }
    private _spinTransferComponentSelectorEnums(_spinTransferComponentSelectorEnums e) { this.value = e.value; }
    public _spinTransferComponentSelectorEnums intern() { for (_spinTransferComponentSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinScan3dDistanceUnitEnums {
    /** Distance values are in millimeter units (default).*/
    Scan3dDistanceUnit_Millimeter(0),
    /** Distance values are in inch units.*/
    Scan3dDistanceUnit_Inch(1),
    NUM_SCAN3DDISTANCEUNIT(2);

    public final int value;
    private _spinScan3dDistanceUnitEnums(int v) { this.value = v; }
    private _spinScan3dDistanceUnitEnums(_spinScan3dDistanceUnitEnums e) { this.value = e.value; }
    public _spinScan3dDistanceUnitEnums intern() { for (_spinScan3dDistanceUnitEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinScan3dCoordinateSystemEnums {
    /** Default value. 3-axis orthogonal, right-hand X-Y-Z.*/
    Scan3dCoordinateSystem_Cartesian(0),
    /** A Theta-Phi-Rho coordinate system.*/
    Scan3dCoordinateSystem_Spherical(1),
    /** A Theta-Y-Rho coordinate system.*/
    Scan3dCoordinateSystem_Cylindrical(2),
    NUM_SCAN3DCOORDINATESYSTEM(3);

    public final int value;
    private _spinScan3dCoordinateSystemEnums(int v) { this.value = v; }
    private _spinScan3dCoordinateSystemEnums(_spinScan3dCoordinateSystemEnums e) { this.value = e.value; }
    public _spinScan3dCoordinateSystemEnums intern() { for (_spinScan3dCoordinateSystemEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinScan3dOutputModeEnums {
    /** Uncalibrated 2.5D Depth map. The distance data does not represent a physical unit and may be non-linear. The data is a 2.5D range map only.*/
    Scan3dOutputMode_UncalibratedC(0),
    /** 3 Coordinates in grid organization. The full 3 coordinate data with the grid array organization from the sensor kept.*/
    Scan3dOutputMode_CalibratedABC_Grid(1),
    /** 3 Coordinates without organization. The full 3 coordinate data without any organization of data points. Typically only valid points transmitted giving varying image size.*/
    Scan3dOutputMode_CalibratedABC_PointCloud(2),
    /** 2 Coordinates with fixed B sampling. The data is sent as a A and C coordinates (X,Z or Theta,Rho). The B (Y) axis uses the scale and offset parameters for the B axis.*/
    Scan3dOutputMode_CalibratedAC(3),
    /** 2 Coordinates with varying sampling. The data is sent as a A and C coordinates (X,Z or Theta,Rho). The B (Y) axis comes from the encoder chunk value.*/
    Scan3dOutputMode_CalibratedAC_Linescan(4),
    /** Calibrated 2.5D Depth map. The distance data is expressed in the chosen distance unit. The data is a 2.5D range map. No information on X-Y axes available.*/
    Scan3dOutputMode_CalibratedC(5),
    /** Depth Map with varying B sampling. The distance data is expressed in the chosen distance unit. The data is a 2.5D range map. The B (Y) axis comes from the encoder chunk value.*/
    Scan3dOutputMode_CalibratedC_Linescan(6),
    /** Rectified 2.5D Depth map. The distance data has been rectified to a uniform sampling pattern in the X and Y direction. The data is a 2.5D range map only. If a complete 3D point cloud is rectified but transmitted as explicit coordinates it should be transmitted as one of the "CalibratedABC" formats.*/
    Scan3dOutputMode_RectifiedC(7),
    /** Rectified 2.5D Depth map with varying B sampling. The data is sent as rectified 1D profiles using Coord3D_C pixels. The B (Y) axis comes from the encoder chunk value.*/
    Scan3dOutputMode_RectifiedC_Linescan(8),
    /** Disparity 2.5D Depth map. The distance is inversely proportional to the pixel (disparity) value.*/
    Scan3dOutputMode_DisparityC(9),
    /** Disparity 2.5D Depth map with varying B sampling. The distance is inversely proportional to the pixel (disparity) value. The B (Y) axis comes from the encoder chunk value.*/
    Scan3dOutputMode_DisparityC_Linescan(10),
    NUM_SCAN3DOUTPUTMODE(11);

    public final int value;
    private _spinScan3dOutputModeEnums(int v) { this.value = v; }
    private _spinScan3dOutputModeEnums(_spinScan3dOutputModeEnums e) { this.value = e.value; }
    public _spinScan3dOutputModeEnums intern() { for (_spinScan3dOutputModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinScan3dCoordinateSystemReferenceEnums {
    /** Default value. Original fixed reference. The coordinate system fixed relative the camera reference point marker is used.*/
    Scan3dCoordinateSystemReference_Anchor(0),
    /** Transformed reference system. The transformed coordinate system is used according to the definition in the rotation and translation matrices.*/
    Scan3dCoordinateSystemReference_Transformed(1),
    NUM_SCAN3DCOORDINATESYSTEMREFERENCE(2);

    public final int value;
    private _spinScan3dCoordinateSystemReferenceEnums(int v) { this.value = v; }
    private _spinScan3dCoordinateSystemReferenceEnums(_spinScan3dCoordinateSystemReferenceEnums e) { this.value = e.value; }
    public _spinScan3dCoordinateSystemReferenceEnums intern() { for (_spinScan3dCoordinateSystemReferenceEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinScan3dCoordinateSelectorEnums {
    /** The first (X or Theta) coordinate*/
    Scan3dCoordinateSelector_CoordinateA(0),
    /** The second (Y or Phi) coordinate*/
    Scan3dCoordinateSelector_CoordinateB(1),
    /** The third (Z or Rho) coordinate.*/
    Scan3dCoordinateSelector_CoordinateC(2),
    NUM_SCAN3DCOORDINATESELECTOR(3);

    public final int value;
    private _spinScan3dCoordinateSelectorEnums(int v) { this.value = v; }
    private _spinScan3dCoordinateSelectorEnums(_spinScan3dCoordinateSelectorEnums e) { this.value = e.value; }
    public _spinScan3dCoordinateSelectorEnums intern() { for (_spinScan3dCoordinateSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinScan3dCoordinateTransformSelectorEnums {
    /** Rotation around X axis.*/
    Scan3dCoordinateTransformSelector_RotationX(0),
    /** Rotation around Y axis.*/
    Scan3dCoordinateTransformSelector_RotationY(1),
    /** Rotation around Z axis.*/
    Scan3dCoordinateTransformSelector_RotationZ(2),
    /** Translation along X axis.*/
    Scan3dCoordinateTransformSelector_TranslationX(3),
    /** Translation along Y axis.*/
    Scan3dCoordinateTransformSelector_TranslationY(4),
    /** Translation along Z axis.*/
    Scan3dCoordinateTransformSelector_TranslationZ(5),
    NUM_SCAN3DCOORDINATETRANSFORMSELECTOR(6);

    public final int value;
    private _spinScan3dCoordinateTransformSelectorEnums(int v) { this.value = v; }
    private _spinScan3dCoordinateTransformSelectorEnums(_spinScan3dCoordinateTransformSelectorEnums e) { this.value = e.value; }
    public _spinScan3dCoordinateTransformSelectorEnums intern() { for (_spinScan3dCoordinateTransformSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinScan3dCoordinateReferenceSelectorEnums {
    /** Rotation around X axis.*/
    Scan3dCoordinateReferenceSelector_RotationX(0),
    /** Rotation around Y axis.*/
    Scan3dCoordinateReferenceSelector_RotationY(1),
    /** Rotation around Z axis.*/
    Scan3dCoordinateReferenceSelector_RotationZ(2),
    /** X axis translation.*/
    Scan3dCoordinateReferenceSelector_TranslationX(3),
    /** Y axis translation.*/
    Scan3dCoordinateReferenceSelector_TranslationY(4),
    /** Z axis translation.*/
    Scan3dCoordinateReferenceSelector_TranslationZ(5),
    NUM_SCAN3DCOORDINATEREFERENCESELECTOR(6);

    public final int value;
    private _spinScan3dCoordinateReferenceSelectorEnums(int v) { this.value = v; }
    private _spinScan3dCoordinateReferenceSelectorEnums(_spinScan3dCoordinateReferenceSelectorEnums e) { this.value = e.value; }
    public _spinScan3dCoordinateReferenceSelectorEnums intern() { for (_spinScan3dCoordinateReferenceSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkImageComponentEnums {
    /** The image data is the intensity component.*/
    ChunkImageComponent_Intensity(0),
    /** The image data is color component.*/
    ChunkImageComponent_Color(1),
    /** The image data is infrared component.*/
    ChunkImageComponent_Infrared(2),
    /** The image data is the ultraviolet component.*/
    ChunkImageComponent_Ultraviolet(3),
    /** The image data is the range (distance) component.*/
    ChunkImageComponent_Range(4),
    /** The image data is the disparity component.*/
    ChunkImageComponent_Disparity(5),
    /** The image data is the confidence map component.*/
    ChunkImageComponent_Confidence(6),
    /** The image data is the scatter component.*/
    ChunkImageComponent_Scatter(7),
    NUM_CHUNKIMAGECOMPONENT(8);

    public final int value;
    private _spinChunkImageComponentEnums(int v) { this.value = v; }
    private _spinChunkImageComponentEnums(_spinChunkImageComponentEnums e) { this.value = e.value; }
    public _spinChunkImageComponentEnums intern() { for (_spinChunkImageComponentEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkCounterSelectorEnums {
    /** Selects the counter 0.*/
    ChunkCounterSelector_Counter0(0),
    /** Selects the counter 1.*/
    ChunkCounterSelector_Counter1(1),
    /** Selects the counter 2.*/
    ChunkCounterSelector_Counter2(2),
    NUM_CHUNKCOUNTERSELECTOR(3);

    public final int value;
    private _spinChunkCounterSelectorEnums(int v) { this.value = v; }
    private _spinChunkCounterSelectorEnums(_spinChunkCounterSelectorEnums e) { this.value = e.value; }
    public _spinChunkCounterSelectorEnums intern() { for (_spinChunkCounterSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkTimerSelectorEnums {
    /** Selects the first Timer.*/
    ChunkTimerSelector_Timer0(0),
    /** Selects the first Timer.*/
    ChunkTimerSelector_Timer1(1),
    /** Selects the second Timer.*/
    ChunkTimerSelector_Timer2(2),
    NUM_CHUNKTIMERSELECTOR(3);

    public final int value;
    private _spinChunkTimerSelectorEnums(int v) { this.value = v; }
    private _spinChunkTimerSelectorEnums(_spinChunkTimerSelectorEnums e) { this.value = e.value; }
    public _spinChunkTimerSelectorEnums intern() { for (_spinChunkTimerSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkEncoderSelectorEnums {
    /** Selects the first Encoder.*/
    ChunkEncoderSelector_Encoder0(0),
    /** Selects the first Encoder.*/
    ChunkEncoderSelector_Encoder1(1),
    /** Selects the second Encoder.*/
    ChunkEncoderSelector_Encoder2(2),
    NUM_CHUNKENCODERSELECTOR(3);

    public final int value;
    private _spinChunkEncoderSelectorEnums(int v) { this.value = v; }
    private _spinChunkEncoderSelectorEnums(_spinChunkEncoderSelectorEnums e) { this.value = e.value; }
    public _spinChunkEncoderSelectorEnums intern() { for (_spinChunkEncoderSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkEncoderStatusEnums {
    /** The encoder counter last incremented.*/
    ChunkEncoderStatus_EncoderUp(0),
    /** The encoder counter last decremented.*/
    ChunkEncoderStatus_EncoderDown(1),
    /** The encoder is not active.*/
    ChunkEncoderStatus_EncoderIdle(2),
    /** No motion within the EncoderTimeout time.*/
    ChunkEncoderStatus_EncoderStatic(3),
    NUM_CHUNKENCODERSTATUS(4);

    public final int value;
    private _spinChunkEncoderStatusEnums(int v) { this.value = v; }
    private _spinChunkEncoderStatusEnums(_spinChunkEncoderStatusEnums e) { this.value = e.value; }
    public _spinChunkEncoderStatusEnums intern() { for (_spinChunkEncoderStatusEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkExposureTimeSelectorEnums {
    /** Selects the common ExposureTime.*/
    ChunkExposureTimeSelector_Common(0),
    /** Selects the red common ExposureTime.*/
    ChunkExposureTimeSelector_Red(1),
    /** Selects the green ExposureTime.*/
    ChunkExposureTimeSelector_Green(2),
    /** Selects the blue ExposureTime.*/
    ChunkExposureTimeSelector_Blue(3),
    /** Selects the cyan common ExposureTime..*/
    ChunkExposureTimeSelector_Cyan(4),
    /** Selects the magenta ExposureTime..*/
    ChunkExposureTimeSelector_Magenta(5),
    /** Selects the yellow ExposureTime..*/
    ChunkExposureTimeSelector_Yellow(6),
    /** Selects the infrared ExposureTime.*/
    ChunkExposureTimeSelector_Infrared(7),
    /** Selects the ultraviolet ExposureTime.*/
    ChunkExposureTimeSelector_Ultraviolet(8),
    /** Selects the first stage ExposureTime.*/
    ChunkExposureTimeSelector_Stage1(9),
    /** Selects the second stage ExposureTime.*/
    ChunkExposureTimeSelector_Stage2(10),
    NUM_CHUNKEXPOSURETIMESELECTOR(11);

    public final int value;
    private _spinChunkExposureTimeSelectorEnums(int v) { this.value = v; }
    private _spinChunkExposureTimeSelectorEnums(_spinChunkExposureTimeSelectorEnums e) { this.value = e.value; }
    public _spinChunkExposureTimeSelectorEnums intern() { for (_spinChunkExposureTimeSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkSourceIDEnums {
    /** Image comes from the Source 0.*/
    ChunkSourceID_Source0(0),
    /** Image comes from the Source 1.*/
    ChunkSourceID_Source1(1),
    /** Image comes from the Source 2.*/
    ChunkSourceID_Source2(2),
    NUM_CHUNKSOURCEID(3);

    public final int value;
    private _spinChunkSourceIDEnums(int v) { this.value = v; }
    private _spinChunkSourceIDEnums(_spinChunkSourceIDEnums e) { this.value = e.value; }
    public _spinChunkSourceIDEnums intern() { for (_spinChunkSourceIDEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkRegionIDEnums {
    /** Image comes from the Region 0.*/
    ChunkRegionID_Region0(0),
    /** Image comes from the Region 1.*/
    ChunkRegionID_Region1(1),
    /** Image comes from the Region 2.*/
    ChunkRegionID_Region2(2),
    NUM_CHUNKREGIONID(3);

    public final int value;
    private _spinChunkRegionIDEnums(int v) { this.value = v; }
    private _spinChunkRegionIDEnums(_spinChunkRegionIDEnums e) { this.value = e.value; }
    public _spinChunkRegionIDEnums intern() { for (_spinChunkRegionIDEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkTransferStreamIDEnums {
    /** Data comes from Stream0.*/
    ChunkTransferStreamID_Stream0(0),
    /** Data comes from Stream1.*/
    ChunkTransferStreamID_Stream1(1),
    /** Data comes from Stream2.*/
    ChunkTransferStreamID_Stream2(2),
    /** Data comes from Stream3.*/
    ChunkTransferStreamID_Stream3(3),
    NUM_CHUNKTRANSFERSTREAMID(4);

    public final int value;
    private _spinChunkTransferStreamIDEnums(int v) { this.value = v; }
    private _spinChunkTransferStreamIDEnums(_spinChunkTransferStreamIDEnums e) { this.value = e.value; }
    public _spinChunkTransferStreamIDEnums intern() { for (_spinChunkTransferStreamIDEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkScan3dDistanceUnitEnums {
    /** Default value. Distance values are in millimeter units.*/
    ChunkScan3dDistanceUnit_Millimeter(0),
    /** Distance values are in inch units.*/
    ChunkScan3dDistanceUnit_Inch(1),
    NUM_CHUNKSCAN3DDISTANCEUNIT(2);

    public final int value;
    private _spinChunkScan3dDistanceUnitEnums(int v) { this.value = v; }
    private _spinChunkScan3dDistanceUnitEnums(_spinChunkScan3dDistanceUnitEnums e) { this.value = e.value; }
    public _spinChunkScan3dDistanceUnitEnums intern() { for (_spinChunkScan3dDistanceUnitEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkScan3dOutputModeEnums {
    /** Uncalibrated 2.5D Depth map. The distance data does not represent a physical unit and may be non-linear. The data is a 2.5D range map only.*/
    ChunkScan3dOutputMode_UncalibratedC(0),
    /** 3 Coordinates in grid organization. The full 3 coordinate data with the grid array organization from the sensor kept.*/
    ChunkScan3dOutputMode_CalibratedABC_Grid(1),
    /** 3 Coordinates without organization. The full 3 coordinate data without any organization of data points. Typically only valid points transmitted giving varying image size.*/
    ChunkScan3dOutputMode_CalibratedABC_PointCloud(2),
    /** 2 Coordinates with fixed B sampling. The data is sent as a A and C coordinates (X,Z or Theta,Rho). The B (Y) axis uses the scale and offset parameters for the B axis.*/
    ChunkScan3dOutputMode_CalibratedAC(3),
    /** 2 Coordinates with varying sampling. The data is sent as a A and C coordinates (X,Z or Theta,Rho). The B (Y) axis comes from the encoder chunk value.*/
    ChunkScan3dOutputMode_CalibratedAC_Linescan(4),
    /** Calibrated 2.5D Depth map. The distance data is expressed in the chosen distance unit. The data is a 2.5D range map. No information on X-Y axes available.*/
    ChunkScan3dOutputMode_CalibratedC(5),
    /** Depth Map with varying B sampling. The distance data is expressed in the chosen distance unit. The data is a 2.5D range map. The B (Y) axis comes from the encoder chunk value.*/
    ChunkScan3dOutputMode_CalibratedC_Linescan(6),
    /** Rectified 2.5D Depth map. The distance data has been rectified to a uniform sampling pattern in the X and Y direction. The data is a 2.5D range map only. If a complete 3D point cloud is rectified but transmitted as explicit coordinates it should be transmitted as one of the "CalibratedABC" formats.*/
    ChunkScan3dOutputMode_RectifiedC(7),
    /** Rectified 2.5D Depth map with varying B sampling. The data is sent as rectified 1D profiles using Coord3D_C pixels. The B (Y) axis comes from the encoder chunk value.*/
    ChunkScan3dOutputMode_RectifiedC_Linescan(8),
    /** Disparity 2.5D Depth map. The distance is inversely proportional to the pixel (disparity) value.*/
    ChunkScan3dOutputMode_DisparityC(9),
    /** Disparity 2.5D Depth map with varying B sampling. The distance is inversely proportional to the pixel (disparity) value. The B (Y) axis comes from the encoder chunk value.*/
    ChunkScan3dOutputMode_DisparityC_Linescan(10),
    NUM_CHUNKSCAN3DOUTPUTMODE(11);

    public final int value;
    private _spinChunkScan3dOutputModeEnums(int v) { this.value = v; }
    private _spinChunkScan3dOutputModeEnums(_spinChunkScan3dOutputModeEnums e) { this.value = e.value; }
    public _spinChunkScan3dOutputModeEnums intern() { for (_spinChunkScan3dOutputModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkScan3dCoordinateSystemEnums {
    /** Default value. 3-axis orthogonal, right-hand X-Y-Z.*/
    ChunkScan3dCoordinateSystem_Cartesian(0),
    /** A Theta-Phi-Rho coordinate system.*/
    ChunkScan3dCoordinateSystem_Spherical(1),
    /** A Theta-Y-Rho coordinate system.*/
    ChunkScan3dCoordinateSystem_Cylindrical(2),
    NUM_CHUNKSCAN3DCOORDINATESYSTEM(3);

    public final int value;
    private _spinChunkScan3dCoordinateSystemEnums(int v) { this.value = v; }
    private _spinChunkScan3dCoordinateSystemEnums(_spinChunkScan3dCoordinateSystemEnums e) { this.value = e.value; }
    public _spinChunkScan3dCoordinateSystemEnums intern() { for (_spinChunkScan3dCoordinateSystemEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkScan3dCoordinateSystemReferenceEnums {
    /** Default value. Original fixed reference. The coordinate system fixed relative the camera reference point marker is used.*/
    ChunkScan3dCoordinateSystemReference_Anchor(0),
    /** Transformed reference system. The transformed coordinate system is used according to the definition in the rotation and translation matrices.*/
    ChunkScan3dCoordinateSystemReference_Transformed(1),
    NUM_CHUNKSCAN3DCOORDINATESYSTEMREFERENCE(2);

    public final int value;
    private _spinChunkScan3dCoordinateSystemReferenceEnums(int v) { this.value = v; }
    private _spinChunkScan3dCoordinateSystemReferenceEnums(_spinChunkScan3dCoordinateSystemReferenceEnums e) { this.value = e.value; }
    public _spinChunkScan3dCoordinateSystemReferenceEnums intern() { for (_spinChunkScan3dCoordinateSystemReferenceEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkScan3dCoordinateSelectorEnums {
    /** The first (X or Theta) coordinate*/
    ChunkScan3dCoordinateSelector_CoordinateA(0),
    /** The second (Y or Phi) coordinate*/
    ChunkScan3dCoordinateSelector_CoordinateB(1),
    /** The third (Z or Rho) coordinate.*/
    ChunkScan3dCoordinateSelector_CoordinateC(2),
    NUM_CHUNKSCAN3DCOORDINATESELECTOR(3);

    public final int value;
    private _spinChunkScan3dCoordinateSelectorEnums(int v) { this.value = v; }
    private _spinChunkScan3dCoordinateSelectorEnums(_spinChunkScan3dCoordinateSelectorEnums e) { this.value = e.value; }
    public _spinChunkScan3dCoordinateSelectorEnums intern() { for (_spinChunkScan3dCoordinateSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkScan3dCoordinateTransformSelectorEnums {
    /** Rotation around X axis.*/
    ChunkScan3dCoordinateTransformSelector_RotationX(0),
    /** Rotation around Y axis.*/
    ChunkScan3dCoordinateTransformSelector_RotationY(1),
    /** Rotation around Z axis.*/
    ChunkScan3dCoordinateTransformSelector_RotationZ(2),
    /** Translation along X axis.*/
    ChunkScan3dCoordinateTransformSelector_TranslationX(3),
    /** Translation along Y axis.*/
    ChunkScan3dCoordinateTransformSelector_TranslationY(4),
    /** Translation along Z axis.*/
    ChunkScan3dCoordinateTransformSelector_TranslationZ(5),
    NUM_CHUNKSCAN3DCOORDINATETRANSFORMSELECTOR(6);

    public final int value;
    private _spinChunkScan3dCoordinateTransformSelectorEnums(int v) { this.value = v; }
    private _spinChunkScan3dCoordinateTransformSelectorEnums(_spinChunkScan3dCoordinateTransformSelectorEnums e) { this.value = e.value; }
    public _spinChunkScan3dCoordinateTransformSelectorEnums intern() { for (_spinChunkScan3dCoordinateTransformSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinChunkScan3dCoordinateReferenceSelectorEnums {
    /** Rotation around X axis.*/
    ChunkScan3dCoordinateReferenceSelector_RotationX(0),
    /** Rotation around Y axis.*/
    ChunkScan3dCoordinateReferenceSelector_RotationY(1),
    /** Rotation around Z axis.*/
    ChunkScan3dCoordinateReferenceSelector_RotationZ(2),
    /** X axis translation.*/
    ChunkScan3dCoordinateReferenceSelector_TranslationX(3),
    /** Y axis translation.*/
    ChunkScan3dCoordinateReferenceSelector_TranslationY(4),
    /** Z axis translation.*/
    ChunkScan3dCoordinateReferenceSelector_TranslationZ(5),
    NUM_CHUNKSCAN3DCOORDINATEREFERENCESELECTOR(6);

    public final int value;
    private _spinChunkScan3dCoordinateReferenceSelectorEnums(int v) { this.value = v; }
    private _spinChunkScan3dCoordinateReferenceSelectorEnums(_spinChunkScan3dCoordinateReferenceSelectorEnums e) { this.value = e.value; }
    public _spinChunkScan3dCoordinateReferenceSelectorEnums intern() { for (_spinChunkScan3dCoordinateReferenceSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinDeviceTapGeometryEnums {
    /** Geometry_1X_1Y*/
    DeviceTapGeometry_Geometry_1X_1Y(0),
    /** Geometry_1X2_1Y*/
    DeviceTapGeometry_Geometry_1X2_1Y(1),
    /** Geometry_1X2_1Y2*/
    DeviceTapGeometry_Geometry_1X2_1Y2(2),
    /** Geometry_2X_1Y*/
    DeviceTapGeometry_Geometry_2X_1Y(3),
    /** Geometry_2X_1Y2Geometry_2XE_1Y*/
    DeviceTapGeometry_Geometry_2X_1Y2Geometry_2XE_1Y(4),
    /** Geometry_2XE_1Y2*/
    DeviceTapGeometry_Geometry_2XE_1Y2(5),
    /** Geometry_2XM_1Y*/
    DeviceTapGeometry_Geometry_2XM_1Y(6),
    /** Geometry_2XM_1Y2*/
    DeviceTapGeometry_Geometry_2XM_1Y2(7),
    /** Geometry_1X_1Y2*/
    DeviceTapGeometry_Geometry_1X_1Y2(8),
    /** Geometry_1X_2YE*/
    DeviceTapGeometry_Geometry_1X_2YE(9),
    /** Geometry_1X3_1Y*/
    DeviceTapGeometry_Geometry_1X3_1Y(10),
    /** Geometry_3X_1Y*/
    DeviceTapGeometry_Geometry_3X_1Y(11),
    /** Geometry_1X*/
    DeviceTapGeometry_Geometry_1X(12),
    /** Geometry_1X2*/
    DeviceTapGeometry_Geometry_1X2(13),
    /** Geometry_2X*/
    DeviceTapGeometry_Geometry_2X(14),
    /** Geometry_2XE*/
    DeviceTapGeometry_Geometry_2XE(15),
    /** Geometry_2XM*/
    DeviceTapGeometry_Geometry_2XM(16),
    /** Geometry_1X3*/
    DeviceTapGeometry_Geometry_1X3(17),
    /** Geometry_3X*/
    DeviceTapGeometry_Geometry_3X(18),
    /** Geometry_1X4_1Y*/
    DeviceTapGeometry_Geometry_1X4_1Y(19),
    /** Geometry_4X_1Y*/
    DeviceTapGeometry_Geometry_4X_1Y(20),
    /** Geometry_2X2_1Y*/
    DeviceTapGeometry_Geometry_2X2_1Y(21),
    /** Geometry_2X2E_1YGeometry_2X2M_1Y*/
    DeviceTapGeometry_Geometry_2X2E_1YGeometry_2X2M_1Y(22),
    /** Geometry_1X2_2YE*/
    DeviceTapGeometry_Geometry_1X2_2YE(23),
    /** Geometry_2X_2YE*/
    DeviceTapGeometry_Geometry_2X_2YE(24),
    /** Geometry_2XE_2YE*/
    DeviceTapGeometry_Geometry_2XE_2YE(25),
    /** Geometry_2XM_2YE*/
    DeviceTapGeometry_Geometry_2XM_2YE(26),
    /** Geometry_1X4*/
    DeviceTapGeometry_Geometry_1X4(27),
    /** Geometry_4X*/
    DeviceTapGeometry_Geometry_4X(28),
    /** Geometry_2X2*/
    DeviceTapGeometry_Geometry_2X2(29),
    /** Geometry_2X2E*/
    DeviceTapGeometry_Geometry_2X2E(30),
    /** Geometry_2X2M*/
    DeviceTapGeometry_Geometry_2X2M(31),
    /** Geometry_1X8_1Y*/
    DeviceTapGeometry_Geometry_1X8_1Y(32),
    /** Geometry_8X_1Y*/
    DeviceTapGeometry_Geometry_8X_1Y(33),
    /** Geometry_4X2_1Y*/
    DeviceTapGeometry_Geometry_4X2_1Y(34),
    /** Geometry_2X2E_2YE*/
    DeviceTapGeometry_Geometry_2X2E_2YE(35),
    /** Geometry_1X8*/
    DeviceTapGeometry_Geometry_1X8(36),
    /** Geometry_8X*/
    DeviceTapGeometry_Geometry_8X(37),
    /** Geometry_4X2*/
    DeviceTapGeometry_Geometry_4X2(38),
    /** Geometry_4X2E*/
    DeviceTapGeometry_Geometry_4X2E(39),
    /** Geometry_4X2E_1Y*/
    DeviceTapGeometry_Geometry_4X2E_1Y(40),
    /** Geometry_1X10_1Y*/
    DeviceTapGeometry_Geometry_1X10_1Y(41),
    /** Geometry_10X_1Y*/
    DeviceTapGeometry_Geometry_10X_1Y(42),
    /** Geometry_1X10*/
    DeviceTapGeometry_Geometry_1X10(43),
    /** Geometry_10X*/
    DeviceTapGeometry_Geometry_10X(44),
    NUM_DEVICETAPGEOMETRY(45);

    public final int value;
    private _spinDeviceTapGeometryEnums(int v) { this.value = v; }
    private _spinDeviceTapGeometryEnums(_spinDeviceTapGeometryEnums e) { this.value = e.value; }
    public _spinDeviceTapGeometryEnums intern() { for (_spinDeviceTapGeometryEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinGevPhysicalLinkConfigurationEnums {
    /** Single Link*/
    GevPhysicalLinkConfiguration_SingleLink(0),
    /** Multi Link*/
    GevPhysicalLinkConfiguration_MultiLink(1),
    /** Static LAG*/
    GevPhysicalLinkConfiguration_StaticLAG(2),
    /** Dynamic LAG*/
    GevPhysicalLinkConfiguration_DynamicLAG(3),
    NUM_GEVPHYSICALLINKCONFIGURATION(4);

    public final int value;
    private _spinGevPhysicalLinkConfigurationEnums(int v) { this.value = v; }
    private _spinGevPhysicalLinkConfigurationEnums(_spinGevPhysicalLinkConfigurationEnums e) { this.value = e.value; }
    public _spinGevPhysicalLinkConfigurationEnums intern() { for (_spinGevPhysicalLinkConfigurationEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinGevCurrentPhysicalLinkConfigurationEnums {
    /** Single Link*/
    GevCurrentPhysicalLinkConfiguration_SingleLink(0),
    /** Multi Link*/
    GevCurrentPhysicalLinkConfiguration_MultiLink(1),
    /** Static LAG*/
    GevCurrentPhysicalLinkConfiguration_StaticLAG(2),
    /** Dynamic LAG*/
    GevCurrentPhysicalLinkConfiguration_DynamicLAG(3),
    NUM_GEVCURRENTPHYSICALLINKCONFIGURATION(4);

    public final int value;
    private _spinGevCurrentPhysicalLinkConfigurationEnums(int v) { this.value = v; }
    private _spinGevCurrentPhysicalLinkConfigurationEnums(_spinGevCurrentPhysicalLinkConfigurationEnums e) { this.value = e.value; }
    public _spinGevCurrentPhysicalLinkConfigurationEnums intern() { for (_spinGevCurrentPhysicalLinkConfigurationEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinGevIPConfigurationStatusEnums {
    /** None*/
    GevIPConfigurationStatus_None(0),
    /** Persistent IP*/
    GevIPConfigurationStatus_PersistentIP(1),
    /** DHCP*/
    GevIPConfigurationStatus_DHCP(2),
    /** LLA*/
    GevIPConfigurationStatus_LLA(3),
    /** Force IP*/
    GevIPConfigurationStatus_ForceIP(4),
    NUM_GEVIPCONFIGURATIONSTATUS(5);

    public final int value;
    private _spinGevIPConfigurationStatusEnums(int v) { this.value = v; }
    private _spinGevIPConfigurationStatusEnums(_spinGevIPConfigurationStatusEnums e) { this.value = e.value; }
    public _spinGevIPConfigurationStatusEnums intern() { for (_spinGevIPConfigurationStatusEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinGevGVCPExtendedStatusCodesSelectorEnums {
    /** Version 1 1*/
    GevGVCPExtendedStatusCodesSelector_Version1_1(0),
    /** Version 2 0*/
    GevGVCPExtendedStatusCodesSelector_Version2_0(1),
    NUM_GEVGVCPEXTENDEDSTATUSCODESSELECTOR(2);

    public final int value;
    private _spinGevGVCPExtendedStatusCodesSelectorEnums(int v) { this.value = v; }
    private _spinGevGVCPExtendedStatusCodesSelectorEnums(_spinGevGVCPExtendedStatusCodesSelectorEnums e) { this.value = e.value; }
    public _spinGevGVCPExtendedStatusCodesSelectorEnums intern() { for (_spinGevGVCPExtendedStatusCodesSelectorEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinGevGVSPExtendedIDModeEnums {
    /** Off*/
    GevGVSPExtendedIDMode_Off(0),
    /** On*/
    GevGVSPExtendedIDMode_On(1),
    NUM_GEVGVSPEXTENDEDIDMODE(2);

    public final int value;
    private _spinGevGVSPExtendedIDModeEnums(int v) { this.value = v; }
    private _spinGevGVSPExtendedIDModeEnums(_spinGevGVSPExtendedIDModeEnums e) { this.value = e.value; }
    public _spinGevGVSPExtendedIDModeEnums intern() { for (_spinGevGVSPExtendedIDModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinClConfigurationEnums {
    /** Standard base configuration described by the Camera Link standard.*/
    ClConfiguration_Base(0),
    /** Standard medium configuration described by the Camera Link standard.*/
    ClConfiguration_Medium(1),
    /** Standard full configuration described by the Camera Link standard.*/
    ClConfiguration_Full(2),
    /** The camera streams the data from multiple taps (that do not fit in the standard base configuration) through two Camera Link base ports. It is responsibility of the application or frame grabber to reconstruct the full image. Only one of the ports (fixed) serves as the "master" for serial communication and triggering.*/
    ClConfiguration_DualBase(3),
    /** Standard 80-bit configuration with 10 taps of 8 bits or 8 taps of 10 bits, as described by the Camera Link standard.*/
    ClConfiguration_EightyBit(4),
    NUM_CLCONFIGURATION(5);

    public final int value;
    private _spinClConfigurationEnums(int v) { this.value = v; }
    private _spinClConfigurationEnums(_spinClConfigurationEnums e) { this.value = e.value; }
    public _spinClConfigurationEnums intern() { for (_spinClConfigurationEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinClTimeSlotsCountEnums {
    /** One*/
    ClTimeSlotsCount_One(0),
    /** Two*/
    ClTimeSlotsCount_Two(1),
    /** Three*/
    ClTimeSlotsCount_Three(2),
    NUM_CLTIMESLOTSCOUNT(3);

    public final int value;
    private _spinClTimeSlotsCountEnums(int v) { this.value = v; }
    private _spinClTimeSlotsCountEnums(_spinClTimeSlotsCountEnums e) { this.value = e.value; }
    public _spinClTimeSlotsCountEnums intern() { for (_spinClTimeSlotsCountEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinCxpLinkConfigurationStatusEnums {
    /** The Link configuration of the Device is unknown. Either the configuration operation has failed or there is nothing connected.*/
    CxpLinkConfigurationStatus_None(0),
    /** The Device is in the process of configuring the Link. The Link cannot be used yet.*/
    CxpLinkConfigurationStatus_Pending(1),
    /** 1 Connection operating at CXP-1 speed (1.25 Gbps).*/
    CxpLinkConfigurationStatus_CXP1_X1(2),
    /** 1 Connection operating at CXP-2 speed (2.50 Gbps).*/
    CxpLinkConfigurationStatus_CXP2_X1(3),
    /** 1 Connection operating at CXP-3 speed (3.125 Gbps).*/
    CxpLinkConfigurationStatus_CXP3_X1(4),
    /** 1 Connection operating at CXP-5 speed (5.00 Gbps).*/
    CxpLinkConfigurationStatus_CXP5_X1(5),
    /** 1 Connection operating at CXP-6 speed (6.25 Gbps).*/
    CxpLinkConfigurationStatus_CXP6_X1(6),
    /** 2 Connections operating at CXP-1 speed (1.25 Gbps).*/
    CxpLinkConfigurationStatus_CXP1_X2(7),
    /** 2 Connections operating at CXP-2 speed (2.50 Gbps).*/
    CxpLinkConfigurationStatus_CXP2_X2(8),
    /** 2 Connections operating at CXP-3 speed (3.125 Gbps).*/
    CxpLinkConfigurationStatus_CXP3_X2(9),
    /** 2 Connections operating at CXP-4 speed (5.00 Gbps).*/
    CxpLinkConfigurationStatus_CXP5_X2(10),
    /** 3 Connections operating at CXP-5 speed (6.25 Gbps).*/
    CxpLinkConfigurationStatus_CXP6_X2(11),
    /** 3 Connections operating at CXP-1 speed (1.25 Gbps).*/
    CxpLinkConfigurationStatus_CXP1_X3(12),
    /** 3 Connections operating at CXP-2 speed (2.50 Gbps).*/
    CxpLinkConfigurationStatus_CXP2_X3(13),
    /** 3 Connections operating at CXP-3 speed (3.125 Gbps).*/
    CxpLinkConfigurationStatus_CXP3_X3(14),
    /** 3 Connections operating at CXP-5 speed (5.00 Gbps).*/
    CxpLinkConfigurationStatus_CXP5_X3(15),
    /** 3 Connections operating at CXP-6 speed (6.25 Gbps).*/
    CxpLinkConfigurationStatus_CXP6_X3(16),
    /** 4 Connections operating at CXP-1 speed (1.25 Gbps).*/
    CxpLinkConfigurationStatus_CXP1_X4(17),
    /** 4 Connections operating at CXP-2 speed (2.50 Gbps).*/
    CxpLinkConfigurationStatus_CXP2_X4(18),
    /** 4 Connections operating at CXP-3 speed (3.125 Gbps).*/
    CxpLinkConfigurationStatus_CXP3_X4(19),
    /** 4 Connections operating at CXP-5 speed (5.00 Gbps).*/
    CxpLinkConfigurationStatus_CXP5_X4(20),
    /** 4 Connections operating at CXP-6 speed (6.25 Gbps).*/
    CxpLinkConfigurationStatus_CXP6_X4(21),
    /** 5 Connections operating at CXP-1 speed (1.25 Gbps).*/
    CxpLinkConfigurationStatus_CXP1_X5(22),
    /** 5 Connections operating at CXP-2 speed (2.50 Gbps).*/
    CxpLinkConfigurationStatus_CXP2_X5(23),
    /** 5 Connections operating at CXP-3 speed (3.125 Gbps).*/
    CxpLinkConfigurationStatus_CXP3_X5(24),
    /** 5 Connections operating at CXP-5 speed (5.00 Gbps).*/
    CxpLinkConfigurationStatus_CXP5_X5(25),
    /** 5 Connections operating at CXP-6 speed (6.25 Gbps).*/
    CxpLinkConfigurationStatus_CXP6_X5(26),
    /** 6 Connections operating at CXP-1 speed (1.25 Gbps).*/
    CxpLinkConfigurationStatus_CXP1_X6(27),
    /** 6 Connections operating at CXP-2 speed (2.50 Gbps).*/
    CxpLinkConfigurationStatus_CXP2_X6(28),
    /** 6 Connections operating at CXP-3 speed (3.125 Gbps).*/
    CxpLinkConfigurationStatus_CXP3_X6(29),
    /** 6 Connections operating at CXP-5 speed (5.00 Gbps).*/
    CxpLinkConfigurationStatus_CXP5_X6(30),
    /** 6 Connections operating at CXP-6 speed (6.25 Gbps).*/
    CxpLinkConfigurationStatus_CXP6_X6(31),
    NUM_CXPLINKCONFIGURATIONSTATUS(32);

    public final int value;
    private _spinCxpLinkConfigurationStatusEnums(int v) { this.value = v; }
    private _spinCxpLinkConfigurationStatusEnums(_spinCxpLinkConfigurationStatusEnums e) { this.value = e.value; }
    public _spinCxpLinkConfigurationStatusEnums intern() { for (_spinCxpLinkConfigurationStatusEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinCxpLinkConfigurationPreferredEnums {
    /** 1 Connection operating at CXP-1 speed (1.25 Gbps).*/
    CxpLinkConfigurationPreferred_CXP1_X1(0),
    /** 1 Connection operating at CXP-2 speed (2.50 Gbps).*/
    CxpLinkConfigurationPreferred_CXP2_X1(1),
    /** 1 Connection operating at CXP-3 speed (3.125 Gbps).*/
    CxpLinkConfigurationPreferred_CXP3_X1(2),
    /** 1 Connection operating at CXP-5 speed (5.00 Gbps).*/
    CxpLinkConfigurationPreferred_CXP5_X1(3),
    /** 1 Connection operating at CXP-6 speed (6.25 Gbps).*/
    CxpLinkConfigurationPreferred_CXP6_X1(4),
    /** 2 Connections operating at CXP-1 speed (1.25 Gbps).*/
    CxpLinkConfigurationPreferred_CXP1_X2(5),
    /** 2 Connections operating at CXP-2 speed (2.50 Gbps).*/
    CxpLinkConfigurationPreferred_CXP2_X2(6),
    /** 2 Connections operating at CXP-3 speed (3.125 Gbps).*/
    CxpLinkConfigurationPreferred_CXP3_X2(7),
    /** 2 Connections operating at CXP-4 speed (5.00 Gbps).*/
    CxpLinkConfigurationPreferred_CXP5_X2(8),
    /** 3 Connections operating at CXP-5 speed (6.25 Gbps).*/
    CxpLinkConfigurationPreferred_CXP6_X2(9),
    /** 3 Connections operating at CXP-1 speed (1.25 Gbps).*/
    CxpLinkConfigurationPreferred_CXP1_X3(10),
    /** 3 Connections operating at CXP-2 speed (2.50 Gbps).*/
    CxpLinkConfigurationPreferred_CXP2_X3(11),
    /** 3 Connections operating at CXP-3 speed (3.125 Gbps).*/
    CxpLinkConfigurationPreferred_CXP3_X3(12),
    /** 3 Connections operating at CXP-5 speed (5.00 Gbps).*/
    CxpLinkConfigurationPreferred_CXP5_X3(13),
    /** 3 Connections operating at CXP-6 speed (6.25 Gbps).*/
    CxpLinkConfigurationPreferred_CXP6_X3(14),
    /** 4 Connections operating at CXP-1 speed (1.25 Gbps).*/
    CxpLinkConfigurationPreferred_CXP1_X4(15),
    /** 4 Connections operating at CXP-2 speed (2.50 Gbps).*/
    CxpLinkConfigurationPreferred_CXP2_X4(16),
    /** 4 Connections operating at CXP-3 speed (3.125 Gbps).*/
    CxpLinkConfigurationPreferred_CXP3_X4(17),
    /** 4 Connections operating at CXP-5 speed (5.00 Gbps).*/
    CxpLinkConfigurationPreferred_CXP5_X4(18),
    /** 4 Connections operating at CXP-6 speed (6.25 Gbps).*/
    CxpLinkConfigurationPreferred_CXP6_X4(19),
    /** 5 Connections operating at CXP-1 speed (1.25 Gbps).*/
    CxpLinkConfigurationPreferred_CXP1_X5(20),
    /** 5 Connections operating at CXP-2 speed (2.50 Gbps).*/
    CxpLinkConfigurationPreferred_CXP2_X5(21),
    /** 5 Connections operating at CXP-3 speed (3.125 Gbps).*/
    CxpLinkConfigurationPreferred_CXP3_X5(22),
    /** 5 Connections operating at CXP-5 speed (5.00 Gbps).*/
    CxpLinkConfigurationPreferred_CXP5_X5(23),
    /** 5 Connections operating at CXP-6 speed (6.25 Gbps).*/
    CxpLinkConfigurationPreferred_CXP6_X5(24),
    /** 6 Connections operating at CXP-1 speed (1.25 Gbps).*/
    CxpLinkConfigurationPreferred_CXP1_X6(25),
    /** 6 Connections operating at CXP-2 speed (2.50 Gbps).*/
    CxpLinkConfigurationPreferred_CXP2_X6(26),
    /** 6 Connections operating at CXP-3 speed (3.125 Gbps).*/
    CxpLinkConfigurationPreferred_CXP3_X6(27),
    /** 6 Connections operating at CXP-5 speed (5.00 Gbps).*/
    CxpLinkConfigurationPreferred_CXP5_X6(28),
    /** 6 Connections operating at CXP-6 speed (6.25 Gbps).*/
    CxpLinkConfigurationPreferred_CXP6_X6(29),
    NUM_CXPLINKCONFIGURATIONPREFERRED(30);

    public final int value;
    private _spinCxpLinkConfigurationPreferredEnums(int v) { this.value = v; }
    private _spinCxpLinkConfigurationPreferredEnums(_spinCxpLinkConfigurationPreferredEnums e) { this.value = e.value; }
    public _spinCxpLinkConfigurationPreferredEnums intern() { for (_spinCxpLinkConfigurationPreferredEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinCxpLinkConfigurationEnums {
    /** Sets Automatic discovery for the Link Configuration.*/
    CxpLinkConfiguration_Auto(0),
    /** Force the Link to 1 Connection operating at CXP-1 speed (1.25 Gbps).*/
    CxpLinkConfiguration_CXP1_X1(1),
    /** Force the Link to 1 Connection operating at CXP-2 speed (2.50 Gbps).*/
    CxpLinkConfiguration_CXP2_X1(2),
    /** Force the Link to 1 Connection operating at CXP-3 speed (3.125 Gbps).*/
    CxpLinkConfiguration_CXP3_X1(3),
    /** Force the Link to 1 Connection operating at CXP-5 speed (5.00 Gbps).*/
    CxpLinkConfiguration_CXP5_X1(4),
    /** Force the Link to 1 Connection operating at CXP-6 speed (6.25 Gbps).*/
    CxpLinkConfiguration_CXP6_X1(5),
    /** Force the Link to 2 Connections operating at CXP-1 speed (1.25 Gbps).*/
    CxpLinkConfiguration_CXP1_X2(6),
    /** Force the Link to 2 Connections operating at CXP-2 speed (2.50 Gbps).*/
    CxpLinkConfiguration_CXP2_X2(7),
    /** Force the Link to 2 Connections operating at CXP-3 speed (3.125 Gbps).*/
    CxpLinkConfiguration_CXP3_X2(8),
    /** Force the Link to 2 Connections operating at CXP-5 speed (5.00 Gbps).*/
    CxpLinkConfiguration_CXP5_X2(9),
    /** Force the Link to 3 Connections operating at CXP-6 speed (6.25 Gbps).*/
    CxpLinkConfiguration_CXP6_X2(10),
    /** Force the Link to 3 Connections operating at CXP-1 speed (1.25 Gbps).*/
    CxpLinkConfiguration_CXP1_X3(11),
    /** Force the Link to 3 Connections operating at CXP-2 speed (2.50 Gbps).*/
    CxpLinkConfiguration_CXP2_X3(12),
    /** Force the Link to 3 Connections operating at CXP-3 speed (3.125 Gbps).*/
    CxpLinkConfiguration_CXP3_X3(13),
    /** Force the Link to 3 Connections operating at CXP-5 speed (5.00 Gbps).*/
    CxpLinkConfiguration_CXP5_X3(14),
    /** Force the Link to 3 Connections operating at CXP-6 speed (6.25 Gbps).*/
    CxpLinkConfiguration_CXP6_X3(15),
    /** Force the Link to 4 Connections operating at CXP-1 speed (1.25 Gbps).*/
    CxpLinkConfiguration_CXP1_X4(16),
    /** Force the Link to 4 Connections operating at CXP-2 speed (2.50 Gbps).*/
    CxpLinkConfiguration_CXP2_X4(17),
    /** Force the Link to 4 Connections operating at CXP-3 speed (3.125 Gbps).*/
    CxpLinkConfiguration_CXP3_X4(18),
    /** Force the Link to 4 Connections operating at CXP-5 speed (5.00 Gbps).*/
    CxpLinkConfiguration_CXP5_X4(19),
    /** Force the Link to 4 Connections operating at CXP-6 speed (6.25 Gbps).*/
    CxpLinkConfiguration_CXP6_X4(20),
    /** Force the Link to 5 Connections operating at CXP-1 speed (1.25 Gbps).*/
    CxpLinkConfiguration_CXP1_X5(21),
    /** Force the Link to 5 Connections operating at CXP-2 speed (2.50 Gbps).*/
    CxpLinkConfiguration_CXP2_X5(22),
    /** Force the Link to 5 Connections operating at CXP-3 speed (3.125 Gbps).*/
    CxpLinkConfiguration_CXP3_X5(23),
    /** Force the Link to 5 Connections operating at CXP-5 speed (5.00 Gbps).*/
    CxpLinkConfiguration_CXP5_X5(24),
    /** Force the Link to 5 Connections operating at CXP-6 speed (6.25 Gbps).*/
    CxpLinkConfiguration_CXP6_X5(25),
    /** Force the Link to 6 Connections operating at CXP-1 speed (1.25 Gbps).*/
    CxpLinkConfiguration_CXP1_X6(26),
    /** Force the Link to 6 Connections operating at CXP-2 speed (2.50 Gbps).*/
    CxpLinkConfiguration_CXP2_X6(27),
    /** Force the Link to 6 Connections operating at CXP-3 speed (3.125 Gbps).*/
    CxpLinkConfiguration_CXP3_X6(28),
    /** Force the Link to 6 Connections operating at CXP-5 speed (5.00 Gbps).*/
    CxpLinkConfiguration_CXP5_X6(29),
    /** Force the Link to 6 Connections operating at CXP-6 speed (6.25 Gbps).*/
    CxpLinkConfiguration_CXP6_X6(30),
    NUM_CXPLINKCONFIGURATION(31);

    public final int value;
    private _spinCxpLinkConfigurationEnums(int v) { this.value = v; }
    private _spinCxpLinkConfigurationEnums(_spinCxpLinkConfigurationEnums e) { this.value = e.value; }
    public _spinCxpLinkConfigurationEnums intern() { for (_spinCxpLinkConfigurationEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinCxpConnectionTestModeEnums {
    /** Off*/
    CxpConnectionTestMode_Off(0),
    /** Mode 1*/
    CxpConnectionTestMode_Mode1(1),
    NUM_CXPCONNECTIONTESTMODE(2);

    public final int value;
    private _spinCxpConnectionTestModeEnums(int v) { this.value = v; }
    private _spinCxpConnectionTestModeEnums(_spinCxpConnectionTestModeEnums e) { this.value = e.value; }
    public _spinCxpConnectionTestModeEnums intern() { for (_spinCxpConnectionTestModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinCxpPoCxpStatusEnums {
    /** Normal automatic PoCXP operation.*/
    CxpPoCxpStatus_Auto(0),
    /** PoCXP is forced off.*/
    CxpPoCxpStatus_Off(1),
    /** The Link has shut down because of an over-current trip.*/
    CxpPoCxpStatus_Tripped(2),
    NUM_CXPPOCXPSTATUS(3);

    public final int value;
    private _spinCxpPoCxpStatusEnums(int v) { this.value = v; }
    private _spinCxpPoCxpStatusEnums(_spinCxpPoCxpStatusEnums e) { this.value = e.value; }
    public _spinCxpPoCxpStatusEnums intern() { for (_spinCxpPoCxpStatusEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/*@}*/

/*@}*/

// #endif // FLIR_SPINNAKER_CAMERA_DEFS_C_H

// Parsed from <ChunkDataDefC.h>

//=============================================================================
// Copyright (c) 2001-2019 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================
   
/* Auto-generated file. Do not modify. */

// #ifndef FLIR_SPINNAKER_CHUNKDATADEF_C_H
// #define FLIR_SPINNAKER_CHUNKDATADEF_C_H

// #include "SpinnakerPlatformC.h"
// Targeting ..\Spinnaker_C\spinChunkData.java



/*@}*/

/*@}*/

// #endif // FLIR_SPINNAKER_CHUNKDATADEF_C_H

// Parsed from <SpinnakerGenApiDefsC.h>

//=============================================================================
// Copyright (c) 2001-2019 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

// #ifndef FLIR_SPINNAKER_GENAPIDEFS_C_H
// #define FLIR_SPINNAKER_GENAPIDEFS_C_H
// Targeting ..\Spinnaker_C\spinNodeMapHandle.java


// Targeting ..\Spinnaker_C\spinNodeHandle.java


// Targeting ..\Spinnaker_C\spinNodeCallbackHandle.java


// Targeting ..\Spinnaker_C\spinNodeCallbackFunction.java



/*@}*/

/**
 * \defgroup SpinnakerGenApiEnumsC Spinnaker C GenICam Enumerations
 *
 * Enumeration definitions for Spinnaker C GenICam API
 */
/*@{*/

public enum _spinNodeType {
    ValueNode(0),
    BaseNode(1),
    IntegerNode(2),
    BooleanNode(3),
    FloatNode(4),
    CommandNode(5),
    StringNode(6),
    RegisterNode(7),
    EnumerationNode(8),
    EnumEntryNode(9),
    CategoryNode(10),
    PortNode(11),
    UnknownNode(-1);

    public final int value;
    private _spinNodeType(int v) { this.value = v; }
    private _spinNodeType(_spinNodeType e) { this.value = e.value; }
    public _spinNodeType intern() { for (_spinNodeType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

// signed or unsigned integers
public enum _spinSign {
    Signed(0),
    Unsigned(1),
    _UndefinedSign(2);

    public final int value;
    private _spinSign(int v) { this.value = v; }
    private _spinSign(_spinSign e) { this.value = e.value; }
    public _spinSign intern() { for (_spinSign e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

// access mode of a node
public enum _spinAccessMode {
    NI(0),
    NA(1),
    WO(2),
    RO(3),
    RW(4),
    _UndefinedAccesMode(5),
    _CycleDetectAccesMode(6);

    public final int value;
    private _spinAccessMode(int v) { this.value = v; }
    private _spinAccessMode(_spinAccessMode e) { this.value = e.value; }
    public _spinAccessMode intern() { for (_spinAccessMode e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

// recommended visibility of a node
public enum _spinVisibility {
    Beginner(0),
    Expert(1),
    Guru(2),
    Invisible(3),
    _UndefinedVisibility(99);

    public final int value;
    private _spinVisibility(int v) { this.value = v; }
    private _spinVisibility(_spinVisibility e) { this.value = e.value; }
    public _spinVisibility intern() { for (_spinVisibility e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

// caching mode of a register
public enum _spinCachingMode {
    NoCache(0),              // Do not use cache
    WriteThrough(1),         // Write to cache and register
    WriteAround(2),          // Write to register, write to cache on read
    _UndefinedCachingMode(3);// Not yet initialized

    public final int value;
    private _spinCachingMode(int v) { this.value = v; }
    private _spinCachingMode(_spinCachingMode e) { this.value = e.value; }
    public _spinCachingMode intern() { for (_spinCachingMode e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** recommended representation of a node value */
public enum _spinRepresentation {
    /** Slider with linear behavior */
    Linear(0),
    /** Slider with logarithmic behaviour */
    Logarithmic(1),
    /** Check box */
    Boolean(2),
    /** Decimal number in an edit control */
    PureNumber(3),
    /** Hex number in an edit control */
    HexNumber(4),
    /** IP-Address */
    IPV4Address(5),
    /** MAC-Address */
    MACAddress(6),
    _UndefinedRepresentation(7);

    public final int value;
    private _spinRepresentation(int v) { this.value = v; }
    private _spinRepresentation(_spinRepresentation e) { this.value = e.value; }
    public _spinRepresentation intern() { for (_spinRepresentation e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** Endianess of a value in a register */
public enum _spinEndianess {
    /** Register is big endian */
    BigEndian(0),
    /** Register is little endian */
    LittleEndian(1),
    /** Object is not yet initialized */
    _UndefinedEndian(2);

    public final int value;
    private _spinEndianess(int v) { this.value = v; }
    private _spinEndianess(_spinEndianess e) { this.value = e.value; }
    public _spinEndianess intern() { for (_spinEndianess e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** Defines if a node name is standard or custom */
public enum _spinNameSpace {
    /** name resides in custom namespace */
    Custom(0),
    /** name resides in one of the standard namespaces */
    Standard(1),
    /** Object is not yet initialized */
    _UndefinedNameSpace(2);

    public final int value;
    private _spinNameSpace(int v) { this.value = v; }
    private _spinNameSpace(_spinNameSpace e) { this.value = e.value; }
    public _spinNameSpace intern() { for (_spinNameSpace e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** Defines from which standard namespace a node name comes from */
public enum _spinStandardNameSpace {
    /** name resides in custom namespace */
    None(0),
    /** name resides in GigE Vision namespace */
    GEV(1),
    /** name resides in 1394 IIDC namespace */
    IIDC(2),
    /** name resides in camera link namespace */
    CL(3),
    /** name resides in USB namespace */
    USB(4),
    /** Object is not yet initialized */
    _UndefinedStandardNameSpace(5);

    public final int value;
    private _spinStandardNameSpace(int v) { this.value = v; }
    private _spinStandardNameSpace(_spinStandardNameSpace e) { this.value = e.value; }
    public _spinStandardNameSpace intern() { for (_spinStandardNameSpace e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** Defines the chices of a Yes/No alternaitve */
public enum _spinYesNo {
    /** yes */
    Yes(1),
    /** no */
    No(0),
    /** Object is not yet initialized */
    _UndefinedYesNo(2);

    public final int value;
    private _spinYesNo(int v) { this.value = v; }
    private _spinYesNo(_spinYesNo e) { this.value = e.value; }
    public _spinYesNo intern() { for (_spinYesNo e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** typedef for fomula type */
public enum _spinSlope {
    Increasing(0),      /**> strictly monotonous increasing */
    Decreasing(1),      /**> strictly monotonous decreasing */
    Varying(2),         /**> slope changes, e.g. at run-time */
    Automatic(3),       /**> slope is determined automatically by probing the function */
    /** Object is not yet initialized */
    _UndefinedESlope(4);

    public final int value;
    private _spinSlope(int v) { this.value = v; }
    private _spinSlope(_spinSlope e) { this.value = e.value; }
    public _spinSlope intern() { for (_spinSlope e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** typedef describing the different validity checks which can be performed on an XML file
/** The enum values for a bitfield of lenght uint32_t */
public enum _spinXMLValidation {
    xvLoad(0x00000001L),                 /**> Creates a dummy node map */
    xvCycles(0x00000002L),               /**> checks for write and dependency cycles (implies xvLoad) */
    xvSFNC(0x00000004L),                 /**> checks for conformance with the standard feature naming convention (SFNC) */
    xvDefault(0x00000000L),              /**> checks performed if nothing else is said */
    xvAll(0xffffffffL),                  /**> all possible checks */
    /** Object is not yet initialized */
    _UndefinedEXMLValidation(0x8000000L);

    public final long value;
    private _spinXMLValidation(long v) { this.value = v; }
    private _spinXMLValidation(_spinXMLValidation e) { this.value = e.value; }
    public _spinXMLValidation intern() { for (_spinXMLValidation e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** typedef for float notation */
public enum _spinDisplayNotation {
    fnAutomatic(0),               /**> the notation if either scientific or fixed depending on what is shorter */
    fnFixed(1),                   /**> the notation is fixed, e.g. 123.4 */
    fnScientific(2),              /**> the notation is scientific, e.g. 1.234e2 */
    /** Object is not yet initialized */
    _UndefinedEDisplayNotation(3);

    public final int value;
    private _spinDisplayNotation(int v) { this.value = v; }
    private _spinDisplayNotation(_spinDisplayNotation e) { this.value = e.value; }
    public _spinDisplayNotation intern() { for (_spinDisplayNotation e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** typedef for interface type */
public enum _spinInterfaceType {
    intfIValue(0),       /**> IValue interface */
    intfIBase(1),        /**> IBase interface */
    intfIInteger(2),     /**> IInteger interface */
    intfIBoolean(3),     /**> IBoolean interface */
    intfICommand(4),     /**> ICommand interface */
    intfIFloat(5),       /**> IFloat interface */
    intfIString(6),      /**> IString interface */
    intfIRegister(7),    /**> IRegister interface */
    intfICategory(8),    /**> ICategory interface */
    intfIEnumeration(9), /**> IEnumeration interface */
    intfIEnumEntry(10),   /**> IEnumEntry interface */
    intfIPort(11);        /**> IPort interface */

    public final int value;
    private _spinInterfaceType(int v) { this.value = v; }
    private _spinInterfaceType(_spinInterfaceType e) { this.value = e.value; }
    public _spinInterfaceType intern() { for (_spinInterfaceType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** typedef for link type */
public enum _spinLinkType {
    ctAllDependingNodes(0), /**> All nodes which will be invalidated if this node becomes invalid */
    ctAllTerminalNodes(1),  /**> All terminal nodes which may be written to by this node */
    ctInvalidators(2),      /**> List of references to nodes which may invalidate this node */
    ctReadingChildren(3),   /**> All child nodes which influence this node's AccessMode */
    ctWritingChildren(4),   /**> All child nodes which may be written to */
    ctDependingChildren(5); /**> All child nodes which will cause this node to be invalidated */

    public final int value;
    private _spinLinkType(int v) { this.value = v; }
    private _spinLinkType(_spinLinkType e) { this.value = e.value; }
    public _spinLinkType intern() { for (_spinLinkType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** typedef for increment mode */
public enum _spinIncMode {
    noIncrement(0),    // !> The feature has no increment
    fixedIncrement(1), // !> The feature has a fix increment
    listIncrement(2); // !> The feature has a list of valid value

    public final int value;
    private _spinIncMode(int v) { this.value = v; }
    private _spinIncMode(_spinIncMode e) { this.value = e.value; }
    public _spinIncMode intern() { for (_spinIncMode e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** typedef for link type */
public enum _spinInputDirection {
    idFrom(0), /**> Indicates a swiss knife that it is used as worker for a converter computing FROM */
    idTo(1),   /**> Indicates a swiss knife that it is used as worker for a converter computing TO */
    idNone(2); /**> SwissKnife is not used within a converter */

    public final int value;
    private _spinInputDirection(int v) { this.value = v; }
    private _spinInputDirection(_spinInputDirection e) { this.value = e.value; }
    public _spinInputDirection intern() { for (_spinInputDirection e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/*@}*/

/*@}*/

// #endif // FLIR_SPINNAKER_GENAPIDEFS_C_H

// Parsed from <SpinnakerGenApiC.h>

//=============================================================================
// Copyright (c) 2001-2019 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

// #ifndef PGR_SPINNAKER_GENAPI_C_H_
// #define PGR_SPINNAKER_GENAPI_C_H_

// #include "SpinnakerGenApiDefsC.h"
// #include "SpinnakerDefsC.h"
// #include "SpinnakerPlatformC.h"

/**
 * \defgroup SpinnakerCGenApi Spinnaker C GenICam API
 */
/*@{*/

// #ifdef __cplusplus
// #endif

    /**
     * \defgroup CNodeMapAccess Node Map Access
     *
     * \brief The functions in this section provide access to information,
     * objects, and functionality related to nodemaps. This includes nodes,
     * node counts, and polling.
     */
    /*@{*/

    /**
     * Retrieves a node from the nodemap by name
     * @see spinError
     *
     * @param hNodeMap The node map where the node is
     * @param pName The name of the node
     * @param phNode The node handle pointer in which the node is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeMapGetNode(spinNodeMapHandle hNodeMap, @Cast("const char*") BytePointer pName, @ByPtrPtr spinNodeHandle phNode);
    public static native @Cast("_spinError") int spinNodeMapGetNode(spinNodeMapHandle hNodeMap, String pName, @ByPtrPtr spinNodeHandle phNode);

    /**
     * Gets the number of nodes in the map
     * @see spinError
     *
     * @param hNodeMap The node map where the nodes to be counted are
     * @param pValue The unsigned integer pointer in which the number of nodes is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeMapGetNumNodes(spinNodeMapHandle hNodeMap, @Cast("size_t*") SizeTPointer pValue);

    /**
     * Retrieves a node from the nodemap by index
     * @see spinError
     *
     * @param hNodeMap The node map where the node is
     * @param index The index of the node
     * @param phNode The node handle pointer in which the node is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeMapGetNodeByIndex(spinNodeMapHandle hNodeMap, @Cast("size_t") long index, @ByPtrPtr spinNodeHandle phNode);

    /**
     * Fires nodes which have a polling time
     * @see spinError
     *
     * @param hNodeMap The nodemap to poll
     * @param timestamp The timestamp
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeMapPoll(spinNodeMapHandle hNodeMap, @Cast("int64_t") long timestamp);
    /*@}*/

    /**
     * \defgroup CNodeAccess Node Access
     *
     * \brief The functions in this section provide access to information and
     * objects retrieved from nodes. This includes node properties and callback
     * registration.
     */
    /*@{*/

    /**
     * Checks whether a node is implemented
     * @see spinError
     *
     * @param hNode The node to check
     * @param pbResult The boolean pointer to return whether or not the node is implemented
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeIsImplemented(spinNodeHandle hNode, @Cast("bool8_t*") BytePointer pbResult);
    public static native @Cast("_spinError") int spinNodeIsImplemented(spinNodeHandle hNode, @Cast("bool8_t*") ByteBuffer pbResult);
    public static native _spinError spinNodeIsImplemented(spinNodeHandle hNode, @Cast("bool8_t*") byte[] pbResult);

    /**
     * Checks whether a node is readable
     * @see spinError
     *
     * @param hNode The node to check
     * @param pbResult The boolean pointer to return whether or not the node is readable
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeIsReadable(spinNodeHandle hNode, @Cast("bool8_t*") BytePointer pbResult);
    public static native @Cast("_spinError") int spinNodeIsReadable(spinNodeHandle hNode, @Cast("bool8_t*") ByteBuffer pbResult);
    public static native _spinError spinNodeIsReadable(spinNodeHandle hNode, @Cast("bool8_t*") byte[] pbResult);

    /**
     * Checks whether a node is writable
     * @see spinError
     *
     * @param hNode The node to check
     * @param pbResult The boolean pointer to return whether or not the node is writable
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeIsWritable(spinNodeHandle hNode, @Cast("bool8_t*") BytePointer pbResult);
    public static native @Cast("_spinError") int spinNodeIsWritable(spinNodeHandle hNode, @Cast("bool8_t*") ByteBuffer pbResult);
    public static native _spinError spinNodeIsWritable(spinNodeHandle hNode, @Cast("bool8_t*") byte[] pbResult);

    /**
     * Checks whether a node is available
     * @see spinError
     *
     * @param hNode The node to check
     * @param pbResult The boolean pointer to return whether or not the node is available
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeIsAvailable(spinNodeHandle hNode, @Cast("bool8_t*") BytePointer pbResult);
    public static native @Cast("_spinError") int spinNodeIsAvailable(spinNodeHandle hNode, @Cast("bool8_t*") ByteBuffer pbResult);
    public static native _spinError spinNodeIsAvailable(spinNodeHandle hNode, @Cast("bool8_t*") byte[] pbResult);

    /**
     * Checks whether two nodes are equal
     *
     * @see spinError
     *
     * @param hNodeFirst The first node to check
     * @param hNodeSecond The second node to check
     * @param pbResult The boolean pointer to return whether or not the two nodes are equal
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeIsEqual(spinNodeHandle hNodeFirst, spinNodeHandle hNodeSecond, @Cast("bool8_t*") BytePointer pbResult);
    public static native @Cast("_spinError") int spinNodeIsEqual(spinNodeHandle hNodeFirst, spinNodeHandle hNodeSecond, @Cast("bool8_t*") ByteBuffer pbResult);
    public static native _spinError spinNodeIsEqual(spinNodeHandle hNodeFirst, spinNodeHandle hNodeSecond, @Cast("bool8_t*") byte[] pbResult);

    /**
     * Retrieves the access mode of a node (as an enum, spinAccessMode)
     * @see spinError
     * @see spinAccessMode
     *
     * @param hNode The node of the access mode to retrieve
     * @param pAccessMode The access mode enum pointer in which the access mode is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeGetAccessMode(spinNodeHandle hNode, @Cast("spinAccessMode*") IntPointer pAccessMode);
    public static native @Cast("_spinError") int spinNodeGetAccessMode(spinNodeHandle hNode, @Cast("spinAccessMode*") IntBuffer pAccessMode);
    public static native _spinError spinNodeGetAccessMode(spinNodeHandle hNode, @Cast("spinAccessMode*") int[] pAccessMode);

    /**
     * Retrieves the name of a node (no whitespace)
     * @see spinError
     *
     * @param hNode The node of the name to retrieve
     * @param pBuf The c-string character buffer in which the name of the node is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeGetName(spinNodeHandle hNode, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinNodeGetName(spinNodeHandle hNode, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinNodeGetName(spinNodeHandle hNode, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Retrieve the namespace of a node (as an enum, spinNameSpace)
     * @see spinError
     * @see spinNameSpace
     *
     * @param hNode The node of the namespace to retrieve
     * @param pNamespace The namespace enum pointer in which the namespace is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeGetNameSpace(spinNodeHandle hNode, @Cast("spinNameSpace*") IntPointer pNamespace);
    public static native @Cast("_spinError") int spinNodeGetNameSpace(spinNodeHandle hNode, @Cast("spinNameSpace*") IntBuffer pNamespace);
    public static native _spinError spinNodeGetNameSpace(spinNodeHandle hNode, @Cast("spinNameSpace*") int[] pNamespace);

    /**
     * Retrieves the recommended visibility of a node (as an enum, spinVisibility)
     * @see spinError
     * @see spinVisibility
     *
     * @param hNode The node of the visibility to retrieve
     * @param pVisibility The visibility enum pointer in which the visibility is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeGetVisibility(spinNodeHandle hNode, @Cast("spinVisibility*") IntPointer pVisibility);
    public static native @Cast("_spinError") int spinNodeGetVisibility(spinNodeHandle hNode, @Cast("spinVisibility*") IntBuffer pVisibility);
    public static native _spinError spinNodeGetVisibility(spinNodeHandle hNode, @Cast("spinVisibility*") int[] pVisibility);

    /**
     * Invalidates a node in case its values may have changed, rendering it no longer valid
     * @see spinError
     *
     * @param hNode The node whose values may have changed
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeInvalidateNode(spinNodeHandle hNode);

    /**
     * Retrieves the caching mode of a node (as an enum, spinCachingMode)
     * @see spinError
     * @see spinCachingMode
     *
     * @param hNode The node of the caching mode to retrieve
     * @param pCachingMode The caching mode enum pointer in which the caching mode is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeGetCachingMode(spinNodeHandle hNode, @Cast("spinCachingMode*") IntPointer pCachingMode);
    public static native @Cast("_spinError") int spinNodeGetCachingMode(spinNodeHandle hNode, @Cast("spinCachingMode*") IntBuffer pCachingMode);
    public static native _spinError spinNodeGetCachingMode(spinNodeHandle hNode, @Cast("spinCachingMode*") int[] pCachingMode);

    /**
     * Retrieves a short description of a node
     * @see spinError
     *
     * @param hNode The node of the tooltip to retrieve
     * @param pBuf The c-string character buffer in which the short description of the node is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeGetToolTip(spinNodeHandle hNode, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinNodeGetToolTip(spinNodeHandle hNode, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinNodeGetToolTip(spinNodeHandle hNode, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Retrieves a longer description of a node
     * @see spinError
     *
     * @param hNode The node of the description to retrieve
     * @param pBuf The c-string character buffer in which the longer descrition of the node is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeGetDescription(spinNodeHandle hNode, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinNodeGetDescription(spinNodeHandle hNode, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinNodeGetDescription(spinNodeHandle hNode, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Retrieves the display name of a node (whitespace possible)
     * @see spinError
     *
     * @param hNode The node of the display name to retrieve
     * @param pBuf The c-string character buffer in which the display name of the node is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeGetDisplayName(spinNodeHandle hNode, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinNodeGetDisplayName(spinNodeHandle hNode, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinNodeGetDisplayName(spinNodeHandle hNode, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Retrieves the type of a node (as an enum, spinNodeType)
     * @see spinError
     * @see spinNodeType
     *
     * @param hNode The node of the node type to retrieve
     * @param pType The node type enum pointer in which the type of node is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeGetType(spinNodeHandle hNode, @Cast("spinNodeType*") IntPointer pType);
    public static native @Cast("_spinError") int spinNodeGetType(spinNodeHandle hNode, @Cast("spinNodeType*") IntBuffer pType);
    public static native _spinError spinNodeGetType(spinNodeHandle hNode, @Cast("spinNodeType*") int[] pType);

    /**
     * Retrieve the polling time of a node
     * @see spinError
     *
     * @param hNode The node of the polling time to retrieve
     * @param pPollingTime The integer pointer in which the polling time is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeGetPollingTime(spinNodeHandle hNode, @Cast("int64_t*") LongPointer pPollingTime);
    public static native @Cast("_spinError") int spinNodeGetPollingTime(spinNodeHandle hNode, @Cast("int64_t*") LongBuffer pPollingTime);
    public static native _spinError spinNodeGetPollingTime(spinNodeHandle hNode, @Cast("int64_t*") long[] pPollingTime);

    /**
     * Registers a callback to a node
     * @see spinError
     *
     * @param hNode The node on which to register the callback
     * @param pCbFunction The function pointer of the function that will execute when the callback is triggered; must
     * match signature "void spinNodeCallbackFunction(spinNodeHandle hNode)"
     * @param phCb The callback handle pointer in which the callback is returned; used to unregister callbacks
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeRegisterCallback(
            spinNodeHandle hNode,
            spinNodeCallbackFunction pCbFunction,
            @ByPtrPtr spinNodeCallbackHandle phCb);

    /**
     * Unregisters a callback from a node
     * @see spinError
     *
     * @param hNode The node from which to unregister the callback
     * @param hCb The callback handle to unregister
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeDeregisterCallback(spinNodeHandle hNode, spinNodeCallbackHandle hCb);

    /**
     * Retrieves the imposed access mode of a node
     * @see spinError
     *
     * @param hNode The node of the imposed access mode to retrieve
     * @param imposedAccessMode The access mode enum pointer in which the imposed access mode is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeGetImposedAccessMode(spinNodeHandle hNode, @Cast("spinAccessMode") int imposedAccessMode);

    /**
     * Retrieves the imposed visibility of a node
     * @see spinError
     *
     * @param hNode The node of the visibility to impose
     * @param imposedVisibility The visibility enum pointer in which the imposed visibility is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeGetImposedVisibility(spinNodeHandle hNode, @Cast("spinVisibility") int imposedVisibility);
    /*@}*/

    /**
     * \defgroup CIValueAccess IValue Access
     *
     * \brief The functions in this section provide access to nodes as
     * value nodes. As value nodes are not an actual node type, the functions
     * are named as regular nodes. Functions include reading from and writing to
     * any node with a string.
     */
    /*@{*/

    /**
     * Retrieves the value of any node type as a c-string
     * @see spinError
     *
     * @param hNode The node of the value to read
     * @param pBuf The c-string character buffer in which the value of the node is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeToString(spinNodeHandle hNode, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinNodeToString(spinNodeHandle hNode, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinNodeToString(spinNodeHandle hNode, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Retrieves the value of any node type as a c-string; manually set whether to verify the node
     * @see spinError
     *
     * @param hNode The node of the value to read
     * @param bVerify The boolean of whether to verify the node
     * @param pBuf The c-string character buffer in which the value of the node is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeToStringEx(spinNodeHandle hNode, @Cast("bool8_t") byte bVerify, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinNodeToStringEx(spinNodeHandle hNode, @Cast("bool8_t") byte bVerify, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinNodeToStringEx(spinNodeHandle hNode, @Cast("bool8_t") byte bVerify, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Sets the value of any node type from a c-string; it is important to ensure that the value of the c-string is
     * appropriate to the node type
     * @see spinError
     *
     * @param hNode The node having its value changed
     * @param pBuf The c-string of the value to set
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeFromString(spinNodeHandle hNode, @Cast("const char*") BytePointer pBuf);
    public static native @Cast("_spinError") int spinNodeFromString(spinNodeHandle hNode, String pBuf);

    /**
     * Sets the value of any node type from a c-string; manually set whether to verify the node; ensure the value of the
     * c-string is appropriate to the node type
     * @see spinError
     *
     * @param hNode The node having its value changed
     * @param bVerify The boolean of whether to verify the node
     * @param pBuf The c-string of the value to set
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinNodeFromStringEx(spinNodeHandle hNode, @Cast("bool8_t") byte bVerify, @Cast("const char*") BytePointer pBuf);
    public static native @Cast("_spinError") int spinNodeFromStringEx(spinNodeHandle hNode, @Cast("bool8_t") byte bVerify, String pBuf);
    /*@}*/

    /**
     * \defgroup StringAccess String Access
     *
     * \brief The functions in this section provide access to string nodes using
     * character pointers and arrays. This includes getters and setters of
     * values and value lengths.
     */
    /*@{*/

    /**
     * Sets the value of a string node
     * @see spinError
     *
     * @param hNode The string node having its value changed
     * @param pBuf The c-string of the value to set
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinStringSetValue(spinNodeHandle hNode, @Cast("const char*") BytePointer pBuf);
    public static native @Cast("_spinError") int spinStringSetValue(spinNodeHandle hNode, String pBuf);

    /**
     * Sets the value of a string node; manually set whether to verify the node
     * @see spinError
     *
     * @param hNode The string node having its value changed
     * @param bVerify The boolean of whether to verify the node
     * @param pBuf The c-string of the value to set
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinStringSetValueEx(spinNodeHandle hNode, @Cast("bool8_t") byte bVerify, @Cast("const char*") BytePointer pBuf);
    public static native @Cast("_spinError") int spinStringSetValueEx(spinNodeHandle hNode, @Cast("bool8_t") byte bVerify, String pBuf);

    /**
     * Retrieves the value of a string node as a c-string
     * @see spinError
     *
     * @param hNode The string node of the value to read
     * @param pBuf The c-string character buffer in which the value of the node is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinStringGetValue(spinNodeHandle hNode, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinStringGetValue(spinNodeHandle hNode, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinStringGetValue(spinNodeHandle hNode, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Retrieves the value of a string node as a cstring; manually set whether to verify the node
     * @see spinError
     *
     * @param hNode The string node of the value to read
     * @param bVerify The boolean of whether to verify the node
     * @param pBuf The c-string character buffer in which the value of the node is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinStringGetValueEx(spinNodeHandle hNode, @Cast("bool8_t") byte bVerify, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinStringGetValueEx(spinNodeHandle hNode, @Cast("bool8_t") byte bVerify, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinStringGetValueEx(spinNodeHandle hNode, @Cast("bool8_t") byte bVerify, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Retrieves the maximum length of the c-string to be returned
     * @see spinError
     *
     * @param hNode The string node of the length to retrieve
     * @param pValue The integer pointer in which the maximum length of the c-string is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinStringGetMaxLength(spinNodeHandle hNode, @Cast("int64_t*") LongPointer pValue);
    public static native @Cast("_spinError") int spinStringGetMaxLength(spinNodeHandle hNode, @Cast("int64_t*") LongBuffer pValue);
    public static native _spinError spinStringGetMaxLength(spinNodeHandle hNode, @Cast("int64_t*") long[] pValue);
    /*@}*/

    /**
     * \defgroup CIIntegerAccess IInteger Access
     *
     * \brief The functions in this section provide access to integer nodes
     * using the int64_t data type. This includes value getters and setters,
     * min, max, and increment functions, and node representation.
     */
    /*@{*/

    /**
     * Sets the value of an integer node
     * @see spinError
     *
     * @param hNode The integer node having its value changed
     * @param value The integer value to set
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinIntegerSetValue(spinNodeHandle hNode, @Cast("int64_t") long value);

    /**
     * Sets the value of an integer node; manually set whether to verify the node
     * @see spinError
     *
     * @param hNode The integer node having its value changed
     * @param bVerify The boolean of whether to verify the node
     * @param value The integer value to set
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinIntegerSetValueEx(spinNodeHandle hNode, @Cast("bool8_t") byte bVerify, @Cast("int64_t") long value);

    /**
     * Retrieves the value of an integer node
     * @see spinError
     *
     * @param hNode The integer node of the value to read
     * @param pValue The integer pointer in which the value is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinIntegerGetValue(spinNodeHandle hNode, @Cast("int64_t*") LongPointer pValue);
    public static native @Cast("_spinError") int spinIntegerGetValue(spinNodeHandle hNode, @Cast("int64_t*") LongBuffer pValue);
    public static native _spinError spinIntegerGetValue(spinNodeHandle hNode, @Cast("int64_t*") long[] pValue);

    /**
     * Retrieves the value of an integer node; manually set whether to verify the node
     * @see spinError
     *
     * @param hNode The integer node of the value to read
     * @param bVerify The boolean of whether to verify the node
     * @param pValue The integer pointer in which the value is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinIntegerGetValueEx(spinNodeHandle hNode, @Cast("bool8_t") byte bVerify, @Cast("int64_t*") LongPointer pValue);
    public static native @Cast("_spinError") int spinIntegerGetValueEx(spinNodeHandle hNode, @Cast("bool8_t") byte bVerify, @Cast("int64_t*") LongBuffer pValue);
    public static native _spinError spinIntegerGetValueEx(spinNodeHandle hNode, @Cast("bool8_t") byte bVerify, @Cast("int64_t*") long[] pValue);

    /**
     * Retrieves the minimum value of an integer node; all potential values must be greater than or equal to the minimum
     * @see spinError
     *
     * @param hNode The integer node of the minimum value to retrieve
     * @param pValue The integer pointer in which the minimum value is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinIntegerGetMin(spinNodeHandle hNode, @Cast("int64_t*") LongPointer pValue);
    public static native @Cast("_spinError") int spinIntegerGetMin(spinNodeHandle hNode, @Cast("int64_t*") LongBuffer pValue);
    public static native _spinError spinIntegerGetMin(spinNodeHandle hNode, @Cast("int64_t*") long[] pValue);

    /**
     * Retrieves the maximum value of an integer node; all potential values must be lesser than or equal to the maximum
     * @see spinError
     *
     * @param hNode The integer node of the maximum value to retrieve
     * @param pValue The integer pointer in which the maximum value is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinIntegerGetMax(spinNodeHandle hNode, @Cast("int64_t*") LongPointer pValue);
    public static native @Cast("_spinError") int spinIntegerGetMax(spinNodeHandle hNode, @Cast("int64_t*") LongBuffer pValue);
    public static native _spinError spinIntegerGetMax(spinNodeHandle hNode, @Cast("int64_t*") long[] pValue);

    /**
     * Retrieves the increment of an integer node; all possible values must be divisible by the increment
     * @see spinError
     *
     * @param hNode The integer node of the increment to retrieve
     * @param pValue The integer pointer in which the increment is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinIntegerGetInc(spinNodeHandle hNode, @Cast("int64_t*") LongPointer pValue);
    public static native @Cast("_spinError") int spinIntegerGetInc(spinNodeHandle hNode, @Cast("int64_t*") LongBuffer pValue);
    public static native _spinError spinIntegerGetInc(spinNodeHandle hNode, @Cast("int64_t*") long[] pValue);

    /**
     * Retrieves the numerical representation of the value of a node; i.e. linear, logarithmic, hexidecimal, MAC
     * address, etc.
     * @see spinError
     *
     * @param hNode The integer node of the numerical representation to retrieve
     * @param pValue The representation enum pointer in which the type of numerical representation is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinIntegerGetRepresentation(spinNodeHandle hNode, @Cast("spinRepresentation*") IntPointer pValue);
    public static native @Cast("_spinError") int spinIntegerGetRepresentation(spinNodeHandle hNode, @Cast("spinRepresentation*") IntBuffer pValue);
    public static native _spinError spinIntegerGetRepresentation(spinNodeHandle hNode, @Cast("spinRepresentation*") int[] pValue);
    /*@}*/

    /**
     * \defgroup CIFloat IFloat Access
     *
     * \brief The functions in this section provide access to float nodes
     * using double as the data type. This includes value getters and setters,
     * min and max functions, and node representation.
     */
    /*@{*/

    /**
     * Sets the value of a float node
     * @see spinError
     *
     * @param hNode The float node having its value changed
     * @param value The float value to set
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinFloatSetValue(spinNodeHandle hNode, double value);

    /**
     * Sets the value of a float node; manually set whether to verify the node
     * @see spinError
     *
     * @param hNode The float node having its value changed
     * @param bVerify The boolean of whether to verify the node
     * @param value The float value to set
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinFloatSetValueEx(spinNodeHandle hNode, @Cast("bool8_t") byte bVerify, double value);

    /**
     * Retrieves the value of a float node
     * @see spinError
     *
     * @param hNode The float node of the value to read
     * @param pValue The double pointer in which the value is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinFloatGetValue(spinNodeHandle hNode, DoublePointer pValue);
    public static native @Cast("_spinError") int spinFloatGetValue(spinNodeHandle hNode, DoubleBuffer pValue);
    public static native _spinError spinFloatGetValue(spinNodeHandle hNode, double[] pValue);

    /**
     * Retrieves the value of a float node; manually set whether to verify the node
     * @see spinError
     *
     * @param hNode The float node of the value to read
     * @param pValue The double pointer in which the value is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinFloatGetValueEx(spinNodeHandle hNode, @Cast("bool8_t") byte bVerify, DoublePointer pValue);
    public static native @Cast("_spinError") int spinFloatGetValueEx(spinNodeHandle hNode, @Cast("bool8_t") byte bVerify, DoubleBuffer pValue);
    public static native _spinError spinFloatGetValueEx(spinNodeHandle hNode, @Cast("bool8_t") byte bVerify, double[] pValue);

    /**
     * Retrieves the minimum value of a float node; all potential values must be greater than or equal to the minimum
     * @see spinError
     *
     * @param hNode The float node of the minimum value to retrieve
     * @param pValue The double pointer in which the minimum value is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinFloatGetMin(spinNodeHandle hNode, DoublePointer pValue);
    public static native @Cast("_spinError") int spinFloatGetMin(spinNodeHandle hNode, DoubleBuffer pValue);
    public static native _spinError spinFloatGetMin(spinNodeHandle hNode, double[] pValue);

    /**
     * Retrieves the maximum value of a float node; all potential values must be lesser than or equal to the maximum
     * @see spinError
     *
     * @param hNode The float node of the maximum value to retrieve
     * @param pValue The double pointer in which the maximum value is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinFloatGetMax(spinNodeHandle hNode, DoublePointer pValue);
    public static native @Cast("_spinError") int spinFloatGetMax(spinNodeHandle hNode, DoubleBuffer pValue);
    public static native _spinError spinFloatGetMax(spinNodeHandle hNode, double[] pValue);

    /**
     * Retrieves the numerical representation of the value of a node; i.e. linear, logarithmic, hexidecimal, MAC
     * address, etc.
     * @see spinError
     *
     * @param hNode The float node of the numerical representation to retrieve
     * @param pValue The representation enum pointer in which the type of numerical representation is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinFloatGetRepresentation(spinNodeHandle hNode, @Cast("spinRepresentation*") IntPointer pValue);
    public static native @Cast("_spinError") int spinFloatGetRepresentation(spinNodeHandle hNode, @Cast("spinRepresentation*") IntBuffer pValue);
    public static native _spinError spinFloatGetRepresentation(spinNodeHandle hNode, @Cast("spinRepresentation*") int[] pValue);

    /**
     * Retrieves the units of the float node value
     * @see spinError
     *
     * @param hNode The float node of the units to retrieve
     * @param pBuf The c-string character buffer in which the value units are returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinFloatGetUnit(spinNodeHandle hNode, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinFloatGetUnit(spinNodeHandle hNode, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinFloatGetUnit(spinNodeHandle hNode, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    /*@}*/

    /**
     * \defgroup CIEnumeration IEnumeration Access
     *
     * \brief The functions in this section provide access to enum nodes.
     * This includes retrieving the number of entries, an entry by index or name,
     * retrieving the current entry node, or setting the node using an integer.
     */
    /*@{*/

    /**
     * Retrieves the number of entries of an enum node
     * @see spinError
     *
     * @param hNode The enum node where the entries to be counted are
     * @param pValue The unsigned integer pointer in which the number of entries is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinEnumerationGetNumEntries(spinNodeHandle hNode, @Cast("size_t*") SizeTPointer pValue);

    /**
     * Retrieves an entry node from an enum node using an index
     * @see spinError
     *
     * @param hNode The enum node from which the entry node is retrieved
     * @param index The index of the entry node
     * @param phEntry The node handle pointer in which the entry node is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinEnumerationGetEntryByIndex(spinNodeHandle hNode, @Cast("size_t") long index, @ByPtrPtr spinNodeHandle phEntry);

    /**
     * Retrieves an entry node from an enum node using the entry's symbolic
     * @see spinError
     *
     * @param hNode The enum node from which the entry node is retrieved
     * @param pName The name of the entry node
     * @param phEntry The node handle pointer in which the entry node is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinEnumerationGetEntryByName(spinNodeHandle hNode, @Cast("const char*") BytePointer pName, @ByPtrPtr spinNodeHandle phEntry);
    public static native @Cast("_spinError") int spinEnumerationGetEntryByName(spinNodeHandle hNode, String pName, @ByPtrPtr spinNodeHandle phEntry);

    /**
     * Retrieves the currently selected entry node from an enum node
     * @see spinError
     *
     * @param hNode The enum node from which the current entry node is retrieved
     * @param phEntry The node handle pointer in which the current entry node is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinEnumerationGetCurrentEntry(spinNodeHandle hNode, @ByPtrPtr spinNodeHandle phEntry);

    /**
     * Sets a new entry using its integer value retrieved from a call to spinEnumerationEntryGetIntValue(); note that
     * enumeration entry int and enum values are different - int values defined on camera, enum values found in
     * SpinnakerDefsC.h
     * @see spinEnumerationEntryGetIntValue()
     * @see spinError
     *
     * @param hNode The enum node having its entry changed
     * @param value The integer value of the entry node to set; this corresponds to the integer value internal to the
     * camera
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinEnumerationSetIntValue(spinNodeHandle hNode, @Cast("int64_t") long value);

    /**
     * Sets a new entry using its enum; note that enumeration entry int and enum values are different - int values
     * defined on camera, enum values found in SpinnakerDefsC.h
     * @see spinEnumerationEntryGetEnumValue()
     * @see spinError
     *
     * @param hNode The enum node have its entry changed
     * @param value The enum value of the entry node to set; this corresponds to its integer value created in the
     * library
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinEnumerationSetEnumValue(spinNodeHandle hNode, @Cast("size_t") long value);
    /*@}*/

    /**
     * \defgroup CIEnumEntry IEnumEntry Access
     *
     * \brief The functions in this section provide access to entry nodes
     * This includes retrieving the integer value or the symbolic of an entry.
     */
    /*@{*/

    /**
     * Retrieves the integer value of an entry node; note that enumeration entry int and enum values are different - int
     * values defined on camera, enum values found in SpinnakerDefsC.h
     * @see spinEnumerationSetIntValue()
     * @see spinError
     *
     * @param hNode The entry node of the integer value to retrieve
     * @param pValue The integer pointer in which the integer value of the entry is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinEnumerationEntryGetIntValue(spinNodeHandle hNode, @Cast("int64_t*") LongPointer pValue);
    public static native @Cast("_spinError") int spinEnumerationEntryGetIntValue(spinNodeHandle hNode, @Cast("int64_t*") LongBuffer pValue);
    public static native _spinError spinEnumerationEntryGetIntValue(spinNodeHandle hNode, @Cast("int64_t*") long[] pValue);

    /**
     * Retrieves the enum value (as an integer) of an entry node; note that enumeraiton entry int and enum values are
     * different - int values defined on camera, enum values found in SpinnakerDefsC.h
     * @see spinEnumerationSetEnumValue()
     * @see spinError
     *
     * @param hNode The entry node of the enum value to retrieve
     * @param pValue The unsigned integer pointer in which the enum value of the entry is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinEnumerationEntryGetEnumValue(spinNodeHandle hNode, @Cast("size_t*") SizeTPointer pValue);

    /**
     * Retrieves the symbolic of an entry node as a c-string
     * @see spinError
     *
     * @param hNode The entry node of the symbolic to retrieve
     * @param pBuf The c-string character buffer in which the symbolic of the entry node is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinEnumerationEntryGetSymbolic(spinNodeHandle hNode, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinEnumerationEntryGetSymbolic(spinNodeHandle hNode, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinEnumerationEntryGetSymbolic(spinNodeHandle hNode, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    /*@}*/

    /**
     * \defgroup CIBoolean IBoolean Access
     *
     * \brief The functions in this section provide access to boolean nodes
     * using the bool8_t data type, values represented with 'True' and 'False'.
     * This includes value getters and setters.
     */
    /*@{*/

    /**
     * Sets the value of a boolean node; boolean values are represented by 'True' (which equals '0') and 'False' (which
     * equals '1')
     * @see spinError
     *
     * @param hNode The boolean node having its value changed
     * @param value The boolean value to set
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinBooleanSetValue(spinNodeHandle hNode, @Cast("bool8_t") byte value);

    /**
     * Retrieves the value of a boolean node; boolean values are represented by 'True' (which equals '0') and 'False'
     * (which equals '1')
     * @see spinError
     *
     * @param hNode The boolean node of the value to read
     * @param pValue The boolean pointer in which the value is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinBooleanGetValue(spinNodeHandle hNode, @Cast("bool8_t*") BytePointer pbValue);
    public static native @Cast("_spinError") int spinBooleanGetValue(spinNodeHandle hNode, @Cast("bool8_t*") ByteBuffer pbValue);
    public static native _spinError spinBooleanGetValue(spinNodeHandle hNode, @Cast("bool8_t*") byte[] pbValue);
    /*@}*/

    /**
     * \defgroup CICommand ICommand Access
     *
     * \brief The functions in this section all provide access to
     * information and objects retrieved from nodes. This includes node
     * properties and callbacks.
     */
    /*@{*/

    /**
     * Executes the action associated to a command node
     * @see spinError
     *
     * @param hNode The command node to execute
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCommandExecute(spinNodeHandle hNode);

    /**
     * Retrieves whether or not the action of a command node has completed
     * @see spinError
     *
     * @param hNode The command node to check
     * @param pValue The boolean pointer to return whether or not the command has completed
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCommandIsDone(spinNodeHandle hNode, @Cast("bool8_t*") BytePointer pbValue);
    public static native @Cast("_spinError") int spinCommandIsDone(spinNodeHandle hNode, @Cast("bool8_t*") ByteBuffer pbValue);
    public static native _spinError spinCommandIsDone(spinNodeHandle hNode, @Cast("bool8_t*") byte[] pbValue);
    /*@}*/

    /**
     * \defgroup CICategory ICategory Access
     *
     * \brief The functions in this section all provide access to
     * information and objects retrieved from nodes. This includes node
     * properties and callbacks.
     */
    /*@{*/

    /**
     * Retrieves the number of a features (or child nodes) or a category node
     * @see spinError
     *
     * @param hNode The category node where the features to be counted are
     * @param pValue The unsigned integer pointer in which the number of features is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCategoryGetNumFeatures(spinNodeHandle hNode, @Cast("size_t*") SizeTPointer pValue);

    /**
     * Retrieves a node from a category node using an index
     * @see spinError
     *
     * @param hNode The category node of the node to retrieve
     * @param index The index of the feature node
     * @param phFeature The node handle pointer in which the feature node is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCategoryGetFeatureByIndex(spinNodeHandle hNode, @Cast("size_t") long index, @ByPtrPtr spinNodeHandle phFeature);
    /*@}*/

    /**
     * \defgroup CIRegister IRegister Access
     *
     * \brief The functions in this section provide access to register nodes.
     * This includes access to the node, its address and length, and reference.
     */
    /*@{*/

    /**
     * Retrieves the value of a register node
     * @see spinError
     *
     * @param hNode The register node of the value to retrieve
     * @param pBuf The unsigned integer buffer in which the value is returned
     * @param length The integer pointer in which the length of the register array is returned; the input value is the
     * maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinRegisterGet(spinNodeHandle hNode, @Cast("uint8_t*") BytePointer pBuf, @Cast("int64_t") long length);
    public static native @Cast("_spinError") int spinRegisterGet(spinNodeHandle hNode, @Cast("uint8_t*") ByteBuffer pBuf, @Cast("int64_t") long length);
    public static native _spinError spinRegisterGet(spinNodeHandle hNode, @Cast("uint8_t*") byte[] pBuf, @Cast("int64_t") long length);

    /**
     * Retrieves the value of a register node; manually set whether to verify the node and whether to ignore the cache
     * @see spinError
     *
     * @param hNode The register node of the value to retrieve
     * @param bVerify The boolean of whether to verify the node
     * @param IgnoreCache The boolean of whether to ignore the cache
     * @param pBuf The unsigned integer buffer in which the value is returned
     * @param length The integer pointer in which the length of the register array is returned; the input value is the
     * maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinRegisterGetEx(
            spinNodeHandle hNode,
            @Cast("bool8_t") byte bVerify,
            @Cast("bool8_t") byte bIgnoreCache,
            @Cast("uint8_t*") BytePointer pBuf,
            @Cast("int64_t") long length);
    public static native @Cast("_spinError") int spinRegisterGetEx(
            spinNodeHandle hNode,
            @Cast("bool8_t") byte bVerify,
            @Cast("bool8_t") byte bIgnoreCache,
            @Cast("uint8_t*") ByteBuffer pBuf,
            @Cast("int64_t") long length);
    public static native _spinError spinRegisterGetEx(
            spinNodeHandle hNode,
            @Cast("bool8_t") byte bVerify,
            @Cast("bool8_t") byte bIgnoreCache,
            @Cast("uint8_t*") byte[] pBuf,
            @Cast("int64_t") long length);

    /**
     * Retrieves the address of a register node
     * @see spinError
     *
     * @param hNode The register node of the address to retrieve
     * @param pAddress The integer pointer in which the address is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinRegisterGetAddress(spinNodeHandle hNode, @Cast("int64_t*") LongPointer pAddress);
    public static native @Cast("_spinError") int spinRegisterGetAddress(spinNodeHandle hNode, @Cast("int64_t*") LongBuffer pAddress);
    public static native _spinError spinRegisterGetAddress(spinNodeHandle hNode, @Cast("int64_t*") long[] pAddress);

    /**
     * Retrieves the length (in bytes) of the value of a register node
     * @see spinError
     *
     * @param hNode The register node of the length to retrieve
     * @param plength The integer in which the number of bytes is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinRegisterGetLength(spinNodeHandle hNode, @Cast("int64_t*") LongPointer pLength);
    public static native @Cast("_spinError") int spinRegisterGetLength(spinNodeHandle hNode, @Cast("int64_t*") LongBuffer pLength);
    public static native _spinError spinRegisterGetLength(spinNodeHandle hNode, @Cast("int64_t*") long[] pLength);

    /**
     * Sets the value of a register node
     * @see spinError
     *
     * @param hNode The register node of the value to set
     * @param pBuf The unsigned integer buffer of the value to set
     * @param length The number of bytes of the value to set
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinRegisterSet(spinNodeHandle hNode, @Cast("const uint8_t*") BytePointer pBuf, @Cast("int64_t") long length);
    public static native @Cast("_spinError") int spinRegisterSet(spinNodeHandle hNode, @Cast("const uint8_t*") ByteBuffer pBuf, @Cast("int64_t") long length);
    public static native _spinError spinRegisterSet(spinNodeHandle hNode, @Cast("const uint8_t*") byte[] pBuf, @Cast("int64_t") long length);

    /**
     * Sets the value of a register node; manually set whether to verify the node
     * @see spinError
     *
     * @param hNode The register node of the value to set
     * @param bVerify The boolean of whether to verify the node
     * @param pBuf The unsigned integer buffer of the value to set
     * @param length The number of bytes of the value to set
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    

    /**
     * Uses a second node as a reference for a register node
     * @see spinError
     *
     * @param hNode The register node that houses the reference
     * @param hRef The reference node
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinRegisterSetReference(spinNodeHandle hNode, spinNodeHandle hRef);
    /*@}*/

// #ifdef __cplusplus
// #endif

/*@}*/

// #endif /* PGR_SPINNAKER_GENAPI_C_H_ */

// Parsed from <SpinnakerC.h>

//=============================================================================
// Copyright (c) 2001-2019 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

// #ifndef FLIR_SPINNAKER_C_H
// #define FLIR_SPINNAKER_C_H

/**
 * SpinnakerPlatform C Include
 */
// #include "SpinnakerPlatformC.h"

/**
 * Spinnaker C Definition Includes
 */
// #include "SpinnakerDefsC.h"
// #include "CameraDefsC.h"
// #include "ChunkDataDefC.h"

/**
 * Spinnaker GenICam C Wrapper Includes
 */
// #include "SpinnakerGenApiDefsC.h"
// #include "SpinnakerGenApiC.h"

/**
 * Spinnaker QuickSpin C Includes
 */
// #include "QuickSpinC.h"

/**
 * \defgroup SpinnakerC Spinnaker C API
 */
/*@{*/

// #ifdef __cplusplus
// #endif
    /**
     * \defgroup CErrorHandling Error Handling
     *
     * \brief The functions in this section provide access to additional
     * information related to error returns.
     */
    /*@{*/

    /**
     * Retrieves the error code of the last error
     * @see spinError
     *
     * @param pError The error enum pointer in which the error message is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinErrorGetLast(@Cast("spinError*") IntPointer pError);
    public static native @Cast("_spinError") int spinErrorGetLast(@Cast("spinError*") IntBuffer pError);
    public static native _spinError spinErrorGetLast(@Cast("spinError*") int[] pError);

    /**
     * Retrieves the error message of the last error
     * @see spinError
     *
     * @param pBuf The c-string character buffer in which the error message is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinErrorGetLastMessage(@Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinErrorGetLastMessage(@Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinErrorGetLastMessage(@Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Retrieves the build date of the last error
     * @see spinError
     *
     * @param pBuf The c-string character buffer in which the build date is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinErrorGetLastBuildDate(@Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinErrorGetLastBuildDate(@Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinErrorGetLastBuildDate(@Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Retrieves the build time of the last error
     * @see spinError
     *
     * @param pBuf The c-string character buffer in which the build time is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinErrorGetLastBuildTime(@Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinErrorGetLastBuildTime(@Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinErrorGetLastBuildTime(@Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Retrieves the filename of the last error
     * @see spinError
     *
     * @param pBuf The c-string character buffer in which the file name is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinErrorGetLastFileName(@Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinErrorGetLastFileName(@Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinErrorGetLastFileName(@Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Retrieves the full error message of the last error
     * @see spinError
     *
     * @param pBuf The c-string character buffer in which the full error message is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinErrorGetLastFullMessage(@Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinErrorGetLastFullMessage(@Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinErrorGetLastFullMessage(@Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Retrieves the function name of the last error
     * @see spinError
     *
     * @param pBuf The c-string character buffer in which the function name is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinErrorGetLastFunctionName(@Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinErrorGetLastFunctionName(@Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinErrorGetLastFunctionName(@Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Retrieves the line number of the last error
     * @see spinError
     *
     * @param pBuf The c-string character buffer in which the line number is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinErrorGetLastLineNumber(@Cast("int64_t*") LongPointer pLineNum);
    public static native @Cast("_spinError") int spinErrorGetLastLineNumber(@Cast("int64_t*") LongBuffer pLineNum);
    public static native _spinError spinErrorGetLastLineNumber(@Cast("int64_t*") long[] pLineNum);
    /*@}*/

    /**
     * \defgroup CSystem System Access
     *
     * \brief The functions in this section provide access to information,
     * objects, and functionality of the system object. This includes the
     * system object, interface and camera lists, and interface and logging
     * events.
     */
    /*@{*/

    /**
     * Retrieves an instance of the system object; the system is a singleton, so there will only ever be one instance;
     * system instance must be destroyed by calling spinSystemReleaseInstance
     *
     * @see spinSystemReleaseInstance
     * @see spinError
     *
     * @param phSystem The system handle pointer in which the system instance is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemGetInstance(@ByPtrPtr spinSystem phSystem);

    /**
     * Releases the system; make sure handle is cleaned up properly by setting it to NULL
     * after system is released; the handle can only be used again after calling
     * spinSystemGetInstance
     *
     * @see spinSystemGetInstance
     * @see spinError
     *
     * @param hSystem The system handle
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemReleaseInstance(spinSystem hSystem);

    /**
     * Retrieves a list of detected (and enumerable) interfaces on the system;
     * interface lists must be created and destroyed
     *
     * @see spinInterfaceListCreateEmpty()
     * @see spinInterfaceListDestroy()
     * @see spinError
     *
     * @param hSystem The system, from which the interface list is retrieved
     * @param hInterfaceList The interface list to house the interfaces from the system
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemGetInterfaces(spinSystem hSystem, spinInterfaceList hInterfaceList);

    /**
     * Retrieves a list of detected (and enumerable) cameras on the system;
     * camera lists must be created and destroyed
     *
     * @see spinCameraListCreateEmpty()
     * @see spinCameraListDestroy()
     * @see spinError
     *
     * @param hSystem The system, from which the camera list is retrieved
     * @param hCameraList The camera list to house the cameras from the system
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemGetCameras(spinSystem hSystem, spinCameraList hCameraList);

    /**
     * Retrieves a list of detected (and enumerable) cameras on the system;
     * manually set whether to update the current interface and camera lists;
     * camera lists must be created and destroyed
     *
     * @see spinCameraListCreateEmpty()
     * @see spinCameraListDestroy()
     * @see spinError
     *
     * @param hSystem The system, from which the camera list is retrieved
     * @param bUpdateInterfaces The boolean of whether to update the interface list
     * @param bUpdateCameras The boolean of whether to update the camera list
     * @param hCameraList The camera list to house the cameras from the system
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemGetCamerasEx(
            spinSystem hSystem,
            @Cast("bool8_t") byte bUpdateInterfaces,
            @Cast("bool8_t") byte bUpdateCameras,
            spinCameraList hCameraList);

    /**
     * Sets the logging level for all logging events on the system
     * @see spinError
     *
     * @param hSystem The system, on which the logging level is set
     * @param logLevel The logging level to set
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemSetLoggingLevel(spinSystem hSystem, @Cast("spinnakerLogLevel") int logLevel);

    /**
     * Retrieves the logging level for all logging events on the system
     * @see spinError
     *
     * @param hSystem The system, from which the logging level is retrieved
     * @param logLevel The logging level enum pointer in which the current logging level is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemGetLoggingLevel(spinSystem hSystem, @Cast("spinnakerLogLevel*") IntPointer pLogLevel);
    public static native @Cast("_spinError") int spinSystemGetLoggingLevel(spinSystem hSystem, @Cast("spinnakerLogLevel*") IntBuffer pLogLevel);
    public static native _spinError spinSystemGetLoggingLevel(spinSystem hSystem, @Cast("spinnakerLogLevel*") int[] pLogLevel);

    /**
     * Registers a logging event to the system (events registered in this way must be unregistered)
     * @see spinError
     *
     * @param hSystem The system, on which the logging event is registered
     * @param hLogEvent The logging event to register on the system
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemRegisterLogEvent(spinSystem hSystem, spinLogEvent hLogEvent);

    /**
     * Unregisters a selected logging event from the system
     * @see spinError
     *
     * @param hSystem The system, from which the logging event is unregistered
     * @param hLogEvent The logging event to unregister from the system
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemUnregisterLogEvent(spinSystem hSystem, spinLogEvent hLogEvent);

    /**
     * Unregisters all logging events from the system
     * @see spinError
     *
     * @param hSystem The system, from which all logging events are unregistered
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemUnregisterAllLogEvents(spinSystem hSystem);

    /**
     * Checks whether a system is currently in use
     * @see spinError
     *
     * @param hSystem The system to check
     * @param pbIsInUse The boolean pointer to return whether the system is currently in use
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemIsInUse(spinSystem hSystem, @Cast("bool8_t*") BytePointer pbIsInUse);
    public static native @Cast("_spinError") int spinSystemIsInUse(spinSystem hSystem, @Cast("bool8_t*") ByteBuffer pbIsInUse);
    public static native _spinError spinSystemIsInUse(spinSystem hSystem, @Cast("bool8_t*") byte[] pbIsInUse);

    /**
     * Registers an arrival event to every interface on the system (events registered this way must be unregistered)
     * @see spinError
     *
     * @param hSystem The system, on which the arrival event is registered
     * @param hArrivalEvent The arrival event to register on the system
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemRegisterArrivalEvent(spinSystem hSystem, spinArrivalEvent hArrivalEvent);

    /**
     * Registers a removal event to the system to every interface on the system (events registered this way must be
     * unregistered)
     * @see spinError
     *
     * @param hSystem The system, on which the removal event is registered
     * @param hRemovalEvent The removal event to register on the system
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemRegisterRemovalEvent(spinSystem hSystem, spinRemovalEvent hRemovalEvent);

    /**
     * Unregisters an arrival event from the system
     * @see spinError
     *
     * @param hSystem The system, from which the arrival event is unregistered
     * @param hArrivalEvent The arrival event to unregister from the system
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemUnregisterArrivalEvent(spinSystem hSystem, spinArrivalEvent hArrivalEvent);

    /**
     * Unregisters a removal event from the system
     * @see spinError
     *
     * @param hSystem The system, from which the removal event is unregistered
     * @param hRemovalEvent The removal event to unregister from the system
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemUnregisterRemovalEvent(spinSystem hSystem, spinRemovalEvent hRemovalEvent);

    /**
     * Registers an interface event (arrival and removal) to every interface on the system (interface events registered
     * this way must be unregistered)
     * @see spinError
     *
     * @param hSystem The system, on which the interface event is registered
     * @param hInterfaceEvent The interface event (arrival and removal) to register on the system
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemRegisterInterfaceEvent(spinSystem hSystem, spinInterfaceEvent hInterfaceEvent);

    /**
     * Unregisters an interface event from the system
     * @see spinError
     *
     * @param hSystem The system, from which the interface event is unregistered
     * @param hInterfaceEvent The interface event (arrival and removal) to unregister from the system
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemUnregisterInterfaceEvent(spinSystem hSystem, spinInterfaceEvent hInterfaceEvent);

    /**
     * Updates the list of cameras on the system, informing whether there has been any changes
     * @see spinError
     *
     * @param hSystem The system, on which the list of attached cameras is updated
     * @param pbChanged The boolean pointer to return whether cameras have arrived on or been removed from the system
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemUpdateCameras(spinSystem hSystem, @Cast("bool8_t*") BytePointer pbChanged);
    public static native @Cast("_spinError") int spinSystemUpdateCameras(spinSystem hSystem, @Cast("bool8_t*") ByteBuffer pbChanged);
    public static native _spinError spinSystemUpdateCameras(spinSystem hSystem, @Cast("bool8_t*") byte[] pbChanged);

    /**
     * Updates the list of cameras on the system, informing whether there has been any changes; manually set whether to
     * update the current interface lists
     * @see spinError
     *
     * @param hSystem The system, on which the list of attached cameras is updated
     * @param bUpdateInterfaces The boolean of whether to update the interface list
     * @param pbChanged The boolean pointer to return whether cameras have arrived or been removed from the system
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemUpdateCamerasEx(spinSystem hSystem, @Cast("bool8_t") byte bUpdateInterfaces, @Cast("bool8_t*") BytePointer pbChanged);
    public static native @Cast("_spinError") int spinSystemUpdateCamerasEx(spinSystem hSystem, @Cast("bool8_t") byte bUpdateInterfaces, @Cast("bool8_t*") ByteBuffer pbChanged);
    public static native _spinError spinSystemUpdateCamerasEx(spinSystem hSystem, @Cast("bool8_t") byte bUpdateInterfaces, @Cast("bool8_t*") byte[] pbChanged);

    /**
     * Broadcast an Action Command to all devices on system
     * @see spinError
     *
     * @param hSystem The system on which to send the action command to all devices.
     * @param iDeviceKey The Action Command's device key
     * @param iGroupKey The Action Command's group key
     * @param iGroupMask The Action Command's group mask
     * @param iActionTime (Optional) Time when to assert a future action. Zero means immediate action.
     * @param piResultSize (Optional) The number of results in the results array. The value passed should be equal to
     * the expected number of devices that acknowledge the command. Returns the number of received results.
     * @param results (Optional) An Array with *piResultSize elements to hold the action command result status. The
     * buffer is filled starting from index 0. If received results are less than expected number of devices that
     * acknowledge the command, remaining results are not changed. If received results are more than expected number of
     * devices that acknowledge the command, extra results are ignored and not appended to array. This parameter is
     * ignored if piResultSize is 0. Thus this parameter can be NULL if pResultSize is 0 or NULL.
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemSendActionCommand(
            spinSystem hSystem,
            @Cast("size_t") long iDeviceKey,
            @Cast("size_t") long iGroupKey,
            @Cast("size_t") long iGroupMask,
            @Cast("size_t") long iActionTime,
            @Cast("size_t*") SizeTPointer piResultSize,
            actionCommandResult results);

    /**
     * Get current library version of Spinnaker.
     *
     * @return A struct containing the current version of Spinnaker(major, minor, type, build).
     */
    public static native _spinError spinSystemGetLibraryVersion(spinSystem hSystem, spinLibraryVersion hLibraryVersion);

    /**
     * Retrieves the transport layer nodemap from the system.
     * @see spinError
     *
     * @param hSystem The system handle.
     * @param phNodeMap The nodemap handle pointer in which the transport layer system nodemap is returned.
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinSystemGetTLNodeMap(spinSystem hSystem, @ByPtrPtr spinNodeMapHandle phNodeMap);
    /*@}*/

    /**
     * \defgroup CInterfaceList InterfaceList Access
     *
     * \brief The functions in this section provide access to information,
     * objects, and functionality of interface lists. This includes
     * updating, size and interface retrieval, and clearance.
     */
    /*@{*/

    /**
     * Creates an empty interface list (interface lists created this way must be destroyed)
     * @see spinError
     *
     * @param phInterfaceList The interface list handle pointer in which the empty interface list is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinInterfaceListCreateEmpty(@ByPtrPtr spinInterfaceList phInterfaceList);

    /**
     * Destroys an interface list
     * @see spinError
     *
     * @param hInterfaceList The interface list to destroy
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinInterfaceListDestroy(spinInterfaceList hInterfaceList);

    /**
     * Retrieves the number of interfaces in an interface list
     * @see spinError
     *
     * @param hInterfaceList The interface list where the interfaces to be counted are
     * @param pSize The unsigned integer pointer in which the number of interfaces is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     * @see spinError
     */
    public static native _spinError spinInterfaceListGetSize(spinInterfaceList hInterfaceList, @Cast("size_t*") SizeTPointer pSize);

    /**
     * Retrieves an interface from an interface list using an index (interfaces retrieved this way must be released)
     * @see spinError
     *
     * @param hInterfaceList The interface list of the interface to be retrieved
     * @param index The index of the interface
     * @param phInterface The interface handle pointer in which the interface is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinInterfaceListGet(spinInterfaceList hInterfaceList, @Cast("size_t") long index, @ByPtrPtr spinInterface phInterface);

    /**
     * Clears an interface list
     * @see spinError
     *
     * @param hInterfaceList The interface list to clear
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinInterfaceListClear(spinInterfaceList hInterfaceList);
    /*@}*/

    /**
     * \defgroup CCameraList CameraList Access
     *
     * \brief The functions in this section provide access to information,
     * objects, and functionality of camera lists. This includes updating,
     * size and camera retrieval, and clearance.
     */
    /*@{*/

    /**
     * Creates an empty camera list (camera lists created this way must be destroyed)
     * @see spinError
     *
     * @param phCameraList The camera list handle pointer in which the empty camera list is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraListCreateEmpty(@ByPtrPtr spinCameraList phCameraList);

    /**
     * Destroys a camera list
     * @see spinError
     *
     * @param hCameraList The camera list to destroy
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraListDestroy(spinCameraList hCameraList);

    /**
     * Retrieves the number of cameras on a camera list
     * @see spinError
     *
     * @param hCameraList The camera list where the cameras to be counted are
     * @param pSize The unsigned integer pointer in which the number of cameras is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraListGetSize(spinCameraList hCameraList, @Cast("size_t*") SizeTPointer pSize);

    /**
     * Retrieves a camera from a camera list using an index. This function will return
     * a SPINNAKER_ERR_INVALID_PARAMETER error if the input index is out of range.
     * @see spinError
     *
     * @param hCameraList The camera list of the camera to retrieve
     * @param index The index of the camera
     * @param phCamera The camera handle pointer in which the camera is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraListGet(spinCameraList hCameraList, @Cast("size_t") long index, @ByPtrPtr spinCamera phCamera);

    /**
     * Clears a camera list
     * @see spinError
     *
     * @param hCameraList The camera list to clear
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraListClear(spinCameraList hCameraList);

    /**
     * Removes a camera from a camera list using its index
     * @see spinError
     *
     * @param hCameraList The camera list of the camera to remove
     * @param index The index of the camera to remove
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraListRemove(spinCameraList hCameraList, @Cast("size_t") long index);

    /**
     * Appends all the cameras from one camera list to another
     * @see spinError
     *
     * @param hCameraListBase The camera list to receive the other
     * @param hCameraListToAppend The camera list to add to the other
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraListAppend(spinCameraList hCameraListBase, spinCameraList hCameraListToAppend);

    /**
     * Retrieves a camera from a camera list using its serial number. This
     * function will return a NULL spinCamera pointer if no matching camera
     * serial is found.
     * @see spinError
     *
     * @param hCameraList The camera list of the camera to retrieve
     * @param serial The serial number of the camera to retrieve
     * @param phCamera The camera handle pointer in which the camera is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraListGetBySerial(spinCameraList hCameraList, @Cast("const char*") BytePointer pSerial, @ByPtrPtr spinCamera phCamera);
    public static native @Cast("_spinError") int spinCameraListGetBySerial(spinCameraList hCameraList, String pSerial, @ByPtrPtr spinCamera phCamera);

    /**
     * Removes a camera from a camera list using its serial number
     * @see spinError
     *
     * @param hCameraList The camera of the camera to remove
     * @param pSerial The serial number of the camera to remove
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraListRemoveBySerial(spinCameraList hCameraList, @Cast("const char*") BytePointer pSerial);
    public static native @Cast("_spinError") int spinCameraListRemoveBySerial(spinCameraList hCameraList, String pSerial);
    /*@}*/

    /**
     * \defgroup CInterface Interface Access
     *
     * \brief The functions in this section provide access to information,
     * objects, and functionality of interfaces. This includes camera list
     * and nodemap retrieval, event registration, and interface release.
     */
    /*@{*/

    /**
     * Checks whether any cameras have been connected or disconnected on an interface
     * @see spinError
     *
     * @param hInterface The interface of the list of attached cameras to update
     * @param pbChanged The boolean pointer to return whether or not the cameras have changed
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinInterfaceUpdateCameras(spinInterface hInterface, @Cast("bool8_t*") BytePointer pbChanged);
    public static native @Cast("_spinError") int spinInterfaceUpdateCameras(spinInterface hInterface, @Cast("bool8_t*") ByteBuffer pbChanged);
    public static native _spinError spinInterfaceUpdateCameras(spinInterface hInterface, @Cast("bool8_t*") byte[] pbChanged);

    /**
     * Retrieves a camera list from an interface;
     * camera lists must be created and destroy
     *
     * @see spinCameraListCreateEmpty()
     * @see spinCameraListDestroy()
     * @see spinError
     *
     * @param hInterface The interface of the camera list to retrieve
     * @param hCameraList The camera list to house the cameras from the interface
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinInterfaceGetCameras(spinInterface hInterface, spinCameraList hCameraList);

    /**
     * Retrieves a camera list from an interface;
     * manually set whether to update the cameras;
     * camera lists must be created and destroyed
     *
     * @see spinCameraListCreateEmpty()
     * @see spinCameraListDestroy()
     * @see spinError
     *
     * @param hInterface The interface of the camera list to retrieve
     * @param bUpdateCameras The boolean of whether or not to update the cameras
     * @param hCameraList The camera list to house the cameras from the interface
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinInterfaceGetCamerasEx(
            spinInterface hInterface,
            @Cast("bool8_t") byte bUpdateCameras,
            spinCameraList hCameraList);

    /**
     * Retrieves the transport layer nodemap from an interface
     * @see spinError
     *
     * @param hInterface The interface of the nodemap to retrieve
     * @param phNodeMap The nodemap handle pointer in which the transport layer interface nodemap is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinInterfaceGetTLNodeMap(spinInterface hInterface, @ByPtrPtr spinNodeMapHandle phNodeMap);

    /**
     * Registers an arrival event on an interface (events registered in this way must be unregistered)
     * @see spinError
     *
     * @param hInterface The interface on which to register the arrival event
     * @param hArrivalEvent The arrival event to register
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinInterfaceRegisterArrivalEvent(spinInterface hInterface, spinArrivalEvent hArrivalEvent);

    /**
     * Registers a removal event on an interface (events registered in this way must be unregistered)
     * @see spinError
     *
     * @param hInterface the Interface on which to register the removal event
     * @param hRemovalEvent The removal event to register
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinInterfaceRegisterRemovalEvent(spinInterface hInterface, spinRemovalEvent hRemovalEvent);

    /**
     * Unregisters an arrival event from an interface
     * @see spinError
     *
     * @param hInterface The interface from which to unregister the arrival event
     * @param hArrivalEvent The arrival event to unregister
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinInterfaceUnregisterArrivalEvent(spinInterface hInterface, spinArrivalEvent hArrivalEvent);

    /**
     * Unregisters a removal event from an interface
     * @see spinError
     *
     * @param hInterface The interface from which to unregister the removal event
     * @param hRemovalEvent The removal event to unregister
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinInterfaceUnregisterRemovalEvent(spinInterface hInterface, spinRemovalEvent hRemovalEvent);

    /**
     * Registers an interface event (both arrival and removal) on an interface
     * @see spinError
     *
     * @param hInterface The interface on which to register the interface event
     * @param hInterfaceEvent The interface event to register
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinInterfaceRegisterInterfaceEvent(spinInterface hInterface, spinInterfaceEvent hInterfaceEvent);

    /**
     * Unregisters an interface event from an interface
     * @see spinError
     *
     * @param hInterface The interface from which to unregister the interface event
     * @param hInterfaceEvent The interface event to unregister
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinInterfaceUnregisterInterfaceEvent(spinInterface hInterface, spinInterfaceEvent hInterfaceEvent);

    /**
     * Releases an interface
     * @see spinError
     *
     * @param hInterface The interface to release
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinInterfaceRelease(spinInterface hInterface);

    /**
     * Checks whether an interface is in use
     * @see spinError
     *
     * @param hInterface The interface to check
     * @param pbIsInUse The boolean pointer to return whether or not the interface is in use
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinInterfaceIsInUse(spinInterface hInterface, @Cast("bool8_t*") BytePointer pbIsInUse);
    public static native @Cast("_spinError") int spinInterfaceIsInUse(spinInterface hInterface, @Cast("bool8_t*") ByteBuffer pbIsInUse);
    public static native _spinError spinInterfaceIsInUse(spinInterface hInterface, @Cast("bool8_t*") byte[] pbIsInUse);

    /**
     * Broadcast an Action Command to all devices on interface
     * @see spinError
     *
     * @param iDeviceKey The Action Command's device key
     * @param iGroupKey The Action Command's group key
     * @param iGroupMask The Action Command's group mask
     * @param iActionTime (Optional) Time when to assert a future action. Zero means immediate action.
     * @param piResultSize (Optional) The number of results in the results array. The value passed should be equal to
     * the expected number of devices that acknowledge the command. Returns the number of received results.
     * @param results (Optional) An Array with *piResultSize elements to hold the action command result status. The
     * buffer is filled starting from index 0. If received results are less than expected number of devices that
     * acknowledge the command, remaining results are not changed. If received results are more than expected number of
     * devices that acknowledge the command, extra results are ignored and not appended to array. This parameter is
     * ignored if piResultSize is 0. Thus this parameter can be NULL if pResultSize is 0 or NULL.
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinInterfaceSendActionCommand(
            spinInterface hInterface,
            @Cast("size_t") long iDeviceKey,
            @Cast("size_t") long iGroupKey,
            @Cast("size_t") long iGroupMask,
            @Cast("size_t") long iActionTime,
            @Cast("size_t*") SizeTPointer piResultSize,
            actionCommandResult results);
    /*@}*/

    /**
     * \defgroup CCamera Camera Access
     *
     * \brief The functions in this section provide access to information,
     * objects, and functionality of cameras. This includes nodemap retrieval,
     * acquisition and init commands, event registration, and camera property
     * retrieval.
     */
    /*@{*/

    /**
     * Initializes a camera, allowing for much more interaction
     * @see spinError
     *
     * @param hCamera The camera to initialize
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraInit(spinCamera hCamera);

    /**
     * Deinitializes a camera, greatly reducing functionality
     * @see spinError
     *
     * @param hCamera The camera to deinitialize
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraDeInit(spinCamera hCamera);

    /**
     * Retrieves the GenICam nodemap from a camera
     * @see spinError
     *
     * @param hCamera The camera from which the nodemap is retrieved
     * @param phNodeMap The nodemap handle pointer in which the nodemap is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraGetNodeMap(spinCamera hCamera, @ByPtrPtr spinNodeMapHandle phNodeMap);

    /**
     * Retrieves the transport layer device nodemap from a camera
     * @see spinError
     *
     * @param hCamera The camera from which the transport layer device nodemap is retrieved
     * @param phNodeMap The nodemap handle pointer in which the nodemap is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraGetTLDeviceNodeMap(spinCamera hCamera, @ByPtrPtr spinNodeMapHandle phNodeMap);

    /**
     * Retrieves the transport layer stream nodemap from a camera
     * @see spinError
     *
     * @param hCamera The camera from which the transport layer streaming nodemap is retrieved
     * @param phNodeMap The nodemap handle pointer in which the nodemap is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraGetTLStreamNodeMap(spinCamera hCamera, @ByPtrPtr spinNodeMapHandle phNodeMap);

    /**
     * Retrieves the access mode of a camera (as an enum, spinAccessMode)
     * @see spinError
     * @see spinAccessMode
     *
     * @param hCamera The camera of the access mode to retrieve
     * @param pAccessMode The access mode enum pointer in which the access mode is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraGetAccessMode(spinCamera hCamera, @Cast("spinAccessMode*") IntPointer pAccessMode);
    public static native @Cast("_spinError") int spinCameraGetAccessMode(spinCamera hCamera, @Cast("spinAccessMode*") IntBuffer pAccessMode);
    public static native _spinError spinCameraGetAccessMode(spinCamera hCamera, @Cast("spinAccessMode*") int[] pAccessMode);

    /*
     * Reads a remote port on a physical Camera. This function can be used to read
     * registers on Cameras.
     *
     * Caution: Only perform direct read/write to a register if the register isn't
     *          supported in the device nodemap. Otherwise the camera and nodemap
     *          may be left in an undefined state after the register read/write.
     *
     * @see WritePort()
     *
     * @param iAddress A 64 bit address to a register on the camera
     * @param pBuffer A pointer to a data buffer that will store result
     * @param iSize Number of bytes to read
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraReadPort(spinCamera hCamera, @Cast("uint64_t") int iAddress, Pointer pBuffer, @Cast("size_t") long iSize);

    /*
     * Writes a remote port on a physical Camera. This function can be used to write
     * registers on Cameras.
     *
     * Caution: Only perform direct read/write to a register if the register isn't
     *          supported in the device nodemap. Otherwise the camera and nodemap
     *          may be left in an undefined state after the register read/write.
     *
     * @see ReadPort()
     *
     * @param iAddress A 64 bit address to a register on the camera
     * @param pBuffer A pointer to a data buffer that will be written
     * @param iSize Number of bytes to write
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraWritePort(spinCamera hCamera, @Cast("uint64_t") int iAddress, Pointer pBuffer, @Cast("size_t") long iSize);

    /**
     * Has a camera start acquiring images
     * @see spinError
     *
     * @param hCamera The camera to begin acquiring images
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraBeginAcquisition(spinCamera hCamera);

    /**
     * Has a camera stop acquiring images
     * @see spinError
     *
     * @param hCamera The camera to stop acquiring images
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraEndAcquisition(spinCamera hCamera);

    /**
     * Retrieves an image from a camera
     * @see spinError
     *
     * @param hCamera The camera of the image to retrieve
     * @param phImage The image handle pointer in which the image is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraGetNextImage(spinCamera hCamera, @ByPtrPtr spinImage phImage);

    /**
     * Retrieves an image from a camera; manually set the timeout in milliseconds
     * @see spinError
     *
     * @param hCamera The camera of the image to retrieve
     * @param grabTimeout The timeout value for returned an image
     * @param phImage The image handle pointer in which the image is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraGetNextImageEx(spinCamera hCamera, @Cast("uint64_t") int grabTimeout, @ByPtrPtr spinImage phImage);

    /**
     * Retrieves a unique identifier for a camera
     * @see spinError
     *
     * @param hCamera The camera of the unique identifier
     * @param pBuf The c-string character buffer in which the unique identifier is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraGetUniqueID(spinCamera hCamera, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinCameraGetUniqueID(spinCamera hCamera, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinCameraGetUniqueID(spinCamera hCamera, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Checks whether a camera is currently acquiring images
     * @see spinError
     *
     * @param hCamera The camera to check
     * @param pbIsStreaming The boolean pointer to return whether or not the camera is currently streaming
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraIsStreaming(spinCamera hCamera, @Cast("bool8_t*") BytePointer pbIsStreaming);
    public static native @Cast("_spinError") int spinCameraIsStreaming(spinCamera hCamera, @Cast("bool8_t*") ByteBuffer pbIsStreaming);
    public static native _spinError spinCameraIsStreaming(spinCamera hCamera, @Cast("bool8_t*") byte[] pbIsStreaming);

    /**
     * Retrieves the GUI XML from a camera
     * @see spinError
     *
     * @param hCamera The camera of the GUI XML to retrieve
     * @param pBuf The c-string character buffer in which the GUI XML is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraGetGuiXml(spinCamera hCamera, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinCameraGetGuiXml(spinCamera hCamera, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinCameraGetGuiXml(spinCamera hCamera, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Registers a universal device event (every device event type) to a camera
     * @see spinError
     *
     * @param hCamera The camera on which to register the universal device event
     * @param hDeviceEvent The device event to register
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraRegisterDeviceEvent(spinCamera hCamera, spinDeviceEvent hDeviceEvent);

    /**
     * Registers a specific device event (only one device event type) to a camera
     * @see spinError
     *
     * @param hCamera The camera on which to register the specific device event
     * @param hDeviceEvent The device event to register
     * @param pName The name of the device event to register
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraRegisterDeviceEventEx(spinCamera hCamera, spinDeviceEvent hDeviceEvent, @Cast("const char*") BytePointer pName);
    public static native @Cast("_spinError") int spinCameraRegisterDeviceEventEx(spinCamera hCamera, spinDeviceEvent hDeviceEvent, String pName);

    /**
     * Unregisters a device event from a camera
     * @see spinError
     *
     * @param hCamera The camera from which to unregister the device event
     * @param hDeviceEvent The device event to unregister
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraUnregisterDeviceEvent(spinCamera hCamera, spinDeviceEvent hDeviceEvent);

    /**
     * Registers an image event to a camera
     * @see spinError
     *
     * @param hCamera The camera on which to register the image event
     * @param hImageEvent The image event to register
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraRegisterImageEvent(spinCamera hCamera, spinImageEvent hImageEvent);

    /**
     * Unregisters an image event from a camera
     * @see spinError
     *
     * @param hCamera The camera from which to unregister the image event
     * @param hImageEvent The image event to unregister
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraUnregisterImageEvent(spinCamera hCamera, spinImageEvent hImageEvent);

    /**
     * Releases a camera
     * @see spinError
     *
     * @param hCamera The camera to release
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraRelease(spinCamera hCamera);

    /**
     * Checks whether a camera is still valid for use
     * @see spinError
     *
     * @param hCamera The camera to check
     * @param pbValid The boolean pointer to return whether or not the camera is valid
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraIsValid(spinCamera hCamera, @Cast("bool8_t*") BytePointer pbValid);
    public static native @Cast("_spinError") int spinCameraIsValid(spinCamera hCamera, @Cast("bool8_t*") ByteBuffer pbValid);
    public static native _spinError spinCameraIsValid(spinCamera hCamera, @Cast("bool8_t*") byte[] pbValid);

    /**
     * Checks whether a camera is currently initialized
     * @see spinError
     *
     * @param hCamera The camera to check
     * @param pbInit The boolean pointer to return whether or not the camera is initialized
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraIsInitialized(spinCamera hCamera, @Cast("bool8_t*") BytePointer pbInit);
    public static native @Cast("_spinError") int spinCameraIsInitialized(spinCamera hCamera, @Cast("bool8_t*") ByteBuffer pbInit);
    public static native _spinError spinCameraIsInitialized(spinCamera hCamera, @Cast("bool8_t*") byte[] pbInit);
    /*@}*/

    /**
     * Returns the largest packet size that can be safely used on the interface that device is connected to.
     * @see spinError
     *
     * @param hCamera The camera to check
     * @param pMaxPacketSize The maximum packet size returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinCameraDiscoverMaxPacketSize(spinCamera hCamera, @Cast("unsigned int*") IntPointer pMaxPacketSize);
    public static native @Cast("_spinError") int spinCameraDiscoverMaxPacketSize(spinCamera hCamera, @Cast("unsigned int*") IntBuffer pMaxPacketSize);
    public static native _spinError spinCameraDiscoverMaxPacketSize(spinCamera hCamera, @Cast("unsigned int*") int[] pMaxPacketSize);
    /*@}*/

    /**
     * Forces the camera to be on the same subnet as its corresponding interface.
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    
    /*@}*/

    /**
     * \defgroup CImage Image Access
     *
     * \brief The functions in this section provide access to information
     * and functionality of images. This includes creation, destruction,
     * and saving as well as a wealth of information including things like
     * width, height, stride, and timestamp.
     */
    /*@{*/

    /**
     * Creates an empty image;
     * images created this way must be destroyed
     *
     * @see spinError
     *
     * @param phImage The image handle pointer in which the empty image is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageCreateEmpty(@ByPtrPtr spinImage phImage);

    /**
     * Creates an image from another;
     * images created this way must be destroyed
     *
     * @see spinError
     *
     * @param hSrcImage The image to be copied
     * @param phDestImage The image handle pointer of the image to be created
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageCreate(spinImage hSrcImage, @ByPtrPtr spinImage phDestImage);

    /**
     * Creates an image with some set properties;
     * images created this way must be destroyed
     *
     * @see spinError
     *
     * @param phImage The image handle pointer in which the image is returned
     * @param width The width to set
     * @param height The height to set
     * @param offsetX The offset along the X axis to set
     * @param offsetY The offset along the Y axis to set
     * @param pixelFormat The pixel format to set
     * @param pData The image data to set; can be set to null
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageCreateEx(
            @ByPtrPtr spinImage phImage,
            @Cast("size_t") long width,
            @Cast("size_t") long height,
            @Cast("size_t") long offsetX,
            @Cast("size_t") long offsetY,
            @Cast("spinPixelFormatEnums") int pixelFormat,
            Pointer pData);

    /**
     * Destroys an image
     * @see spinError
     *
     * @param hImage The image to destroy
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageDestroy(spinImage hImage);

    /**
     * Sets the default color processing algorithm of all images (if not otherwise set)
     * @see spinError
     *
     * @param algorithm The color processing algorithm used by default
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageSetDefaultColorProcessing(@Cast("spinColorProcessingAlgorithm") int algorithm);

    /**
     * Retrieves the default color processing algorithm
     * @see spinError
     *
     * @param pAlgorithm The color processing algorithm enum pointer in which the color processing algorithm is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetDefaultColorProcessing(@Cast("spinColorProcessingAlgorithm*") IntPointer pAlgorithm);
    public static native @Cast("_spinError") int spinImageGetDefaultColorProcessing(@Cast("spinColorProcessingAlgorithm*") IntBuffer pAlgorithm);
    public static native _spinError spinImageGetDefaultColorProcessing(@Cast("spinColorProcessingAlgorithm*") int[] pAlgorithm);

    /**
     * Retrieves the color processing algorithm of a specific image
     * @see spinError
     *
     * @param hImage The image of the color processing algorithm to retrieve
     * @param pAlgorithm The color processing algorithm pointer in which the color processing algorithm is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetColorProcessing(spinImage hImage, @Cast("spinColorProcessingAlgorithm*") IntPointer pAlgorithm);
    public static native @Cast("_spinError") int spinImageGetColorProcessing(spinImage hImage, @Cast("spinColorProcessingAlgorithm*") IntBuffer pAlgorithm);
    public static native _spinError spinImageGetColorProcessing(spinImage hImage, @Cast("spinColorProcessingAlgorithm*") int[] pAlgorithm);

    /**
     * Converts the pixel format of one image into a new image
     * @see spinError
     *
     * @param hSrcImage The image to be converted
     * @param pixelFormat The pixel format to be converted to
     * @param hDestImage The image handle pointer in which the converted image is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageConvert(spinImage hSrcImage, @Cast("spinPixelFormatEnums") int pixelFormat, spinImage hDestImage);

    /**
     * Converts the pixel format and color processing algorithm of one image into a new image
     * @see spinError
     *
     * @param hSrcImage The image to be converted
     * @param pixelFormat The pixel format to be converted to
     * @param algorithm The color processing algorithm to use for conversion
     * @param hDestImage The image handle pointer in which the converted image is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageConvertEx(
            spinImage hSrcImage,
            @Cast("spinPixelFormatEnums") int pixelFormat,
            @Cast("spinColorProcessingAlgorithm") int algorithm,
            spinImage hDestImage);

    /**
     * Resets an image with some set properties
     * @see spinError
     *
     * @param hImage The image to be reset
     * @param width The width to be reset to
     * @param height The height to be reset to
     * @param offsetX The offset to be reset to along the X axis
     * @param offsetY The offset to be reset to along the Y axis
     * @param pixelFormat The pixel format to be reset to
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageReset(
            spinImage hImage,
            @Cast("size_t") long width,
            @Cast("size_t") long height,
            @Cast("size_t") long offsetX,
            @Cast("size_t") long offsetY,
            @Cast("spinPixelFormatEnums") int pixelFormat);

    /**
     * Resets an image with some set properties and image data
     * @see spinError
     *
     * @param hImage The image to reset
     * @param width The width to be reset to
     * @param height The height to be reset to
     * @param offsetX The offset to be reset to along the X axis
     * @param offsetY The offset to be reset to along the Y axis
     * @param pixelFormat The pixel format to be reset to
     * @param pData The image data to reset to
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageResetEx(
            spinImage hImage,
            @Cast("size_t") long width,
            @Cast("size_t") long height,
            @Cast("size_t") long offsetX,
            @Cast("size_t") long offsetY,
            @Cast("spinPixelFormatEnums") int pixelFormat,
            Pointer pData);

    /**
     * Retrieves the ID of an image
     * @see spinError
     *
     * @param hImage The image of the ID to retrieve
     * @param pId The unsigned integer pointer in which the ID is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetID(spinImage hImage, @Cast("uint64_t*") IntPointer pId);
    public static native @Cast("_spinError") int spinImageGetID(spinImage hImage, @Cast("uint64_t*") IntBuffer pId);
    public static native _spinError spinImageGetID(spinImage hImage, @Cast("uint64_t*") int[] pId);

    /**
     * Retrieves the image data of an image
     * @see spinError
     *
     * @param hImage The image of the image data to retrieve
     * @param ppData The pointer to the void pointer in which the image data is retrieved
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetData(spinImage hImage, @Cast("void**") PointerPointer ppData);
    public static native _spinError spinImageGetData(spinImage hImage, @Cast("void**") @ByPtrPtr Pointer ppData);

    /**
     * Retrieves the private data of an image
     * @see spinError
     *
     * @param hImage The image of the private image data to retrieve
     * @param ppData The pointer to the void pointer in which the private image data is retrieved
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetPrivateData(spinImage hImage, @Cast("void**") PointerPointer ppData);
    public static native _spinError spinImageGetPrivateData(spinImage hImage, @Cast("void**") @ByPtrPtr Pointer ppData);

    /**
     * Retrieves the buffer size of an image
     * @see spinError
     *
     * @param hImage The image of image data buffer to retrieve
     * @param pSize The unsigned integer pointer in which the size of the image data if returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetBufferSize(spinImage hImage, @Cast("size_t*") SizeTPointer pSize);

    /**
     * Creates a deep copy of an image (the destination image must be created as an empty image prior to the deep copy)
     * @see spinError
     *
     * @param hSrcImage The image to be copied
     * @param hDestImage The image handle in which the image is copied
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageDeepCopy(spinImage hSrcImage, spinImage hDestImage);

    /**
     * Retrieves the width of an image
     * @see spinError
     *
     * @param hImage The image of the width to retrieve
     * @param pWidth The unsigned integer pointer in which the width is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetWidth(spinImage hImage, @Cast("size_t*") SizeTPointer pWidth);

    /**
     * Retrieves the height of an image
     * @see spinError
     *
     * @param hImage The image of the height to retrieve
     * @param pHeight The unsigned integer pointer in which the height is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetHeight(spinImage hImage, @Cast("size_t*") SizeTPointer pHeight);

    /**
     * Retrieves the offset of an image along its X axis
     * @see spinError
     *
     * @param hImage The image of the offset along the X axis to retrieve
     * @param pOffsetX The unsigned integer pointer in which the offset along the X axis is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetOffsetX(spinImage hImage, @Cast("size_t*") SizeTPointer pOffsetX);

    /**
     * Retrieves the offset of an image along its Y axis
     * @see spinError
     *
     * @param hImage The image of the offset along the Y axis to retrieve
     * @param pOffsetY The unsigned integer pointer in which the offset along the Y axis is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetOffsetY(spinImage hImage, @Cast("size_t*") SizeTPointer pOffsetY);

    /**
     * Retrieves the padding of an image along its X axis
     * @see spinError
     *
     * @param hImage The image of the padding along the X axis to retrieve
     * @param pPaddingX The unsigned integer pointer in which the padding along the X axis is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetPaddingX(spinImage hImage, @Cast("size_t*") SizeTPointer pPaddingX);

    /**
     * Retrieves the padding of an image along its Y axis
     * @see spinError
     *
     * @param hImage The image of the padding along the Y axis to retrieve
     * @param pPaddingY The unsigned integer pointer in which the padding along the Y axis is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetPaddingY(spinImage hImage, @Cast("size_t*") SizeTPointer pPaddingY);

    /**
     * Retrieves the frame ID of an image
     * @see spinError
     *
     * @param hImage The image of the frame ID to retrieve
     * @param pFrameID The unsigned integer pointer in which the frame ID is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetFrameID(spinImage hImage, @Cast("uint64_t*") IntPointer pFrameID);
    public static native @Cast("_spinError") int spinImageGetFrameID(spinImage hImage, @Cast("uint64_t*") IntBuffer pFrameID);
    public static native _spinError spinImageGetFrameID(spinImage hImage, @Cast("uint64_t*") int[] pFrameID);

    /**
     * Retrieves the timestamp of an image
     * @see spinError
     *
     * @param hImage The image of the timestamp to retrieve
     * @param pTimeStamp The unsigned integer pointer om which the timestamp is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetTimeStamp(spinImage hImage, @Cast("uint64_t*") IntPointer pTimeStamp);
    public static native @Cast("_spinError") int spinImageGetTimeStamp(spinImage hImage, @Cast("uint64_t*") IntBuffer pTimeStamp);
    public static native _spinError spinImageGetTimeStamp(spinImage hImage, @Cast("uint64_t*") int[] pTimeStamp);

    /**
     * Retrieves the payload type of an image (as an enum, spinPayloadTypeInfoIds)
     * @see spinError
     * @see spinPayloadTypeInfoIds
     *
     * @param hImage The image of the payload type to retrieve
     * @param pPayloadType The payload type enum pointer in which the payload type is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetPayloadType(spinImage hImage, @Cast("size_t*") SizeTPointer pPayloadType);

    /**
     * Retrieves the transport layer payload type of an image (as an enum, spinPayloadTypeInfoIds)
     * @see spinError
     * @see spinPayloadTypeInfoIds
     *
     * @param hImage The image of the TL payload type to retrieve
     * @param pPayloadType The payload type enum pointer in which the TL payload type is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetTLPayloadType(spinImage hImage, @Cast("spinPayloadTypeInfoIDs*") IntPointer pPayloadType);
    public static native @Cast("_spinError") int spinImageGetTLPayloadType(spinImage hImage, @Cast("spinPayloadTypeInfoIDs*") IntBuffer pPayloadType);
    public static native _spinError spinImageGetTLPayloadType(spinImage hImage, @Cast("spinPayloadTypeInfoIDs*") int[] pPayloadType);

    /**
     * Retrieves the pixel format of an image (as an enum, spinPixelFormatEnums)
     * @see spinError
     * @see spinPixelFormatEnums
     *
     * @param hImage The image of the pixel format to retrieve
     * @param pPixelFormat The pixel format enum pointer in which the pixel format is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetPixelFormat(spinImage hImage, @Cast("spinPixelFormatEnums*") IntPointer pPixelFormat);
    public static native @Cast("_spinError") int spinImageGetPixelFormat(spinImage hImage, @Cast("spinPixelFormatEnums*") IntBuffer pPixelFormat);
    public static native _spinError spinImageGetPixelFormat(spinImage hImage, @Cast("spinPixelFormatEnums*") int[] pPixelFormat);

    /**
     * Retrieves the transport layer pixel format of an image (as an unsigned integer)
     * @see spinError
     *
     * @param hImage The image of the TL pixel format to retrieve
     * @param pPixelFormat The unsigned integer pointer in which the TL pixel format is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetTLPixelFormat(spinImage hImage, @Cast("uint64_t*") IntPointer pPixelFormat);
    public static native @Cast("_spinError") int spinImageGetTLPixelFormat(spinImage hImage, @Cast("uint64_t*") IntBuffer pPixelFormat);
    public static native _spinError spinImageGetTLPixelFormat(spinImage hImage, @Cast("uint64_t*") int[] pPixelFormat);

    /**
     * Retrieves the transport layer pixel format namespace of an image (as an enum, spinPixelFormatNamespaceID)
     * @see spinError
     * @see spinPixelFormatNamespaceID
     *
     * @param hImage The image of the TL pixel format namespace to retrieve
     * @param pPixelFormatNamespace The pixel format namespace pointer in which the pixel format namespace is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetTLPixelFormatNamespace(
            spinImage hImage,
            @Cast("spinPixelFormatNamespaceID*") IntPointer pPixelFormatNamespace);
    public static native @Cast("_spinError") int spinImageGetTLPixelFormatNamespace(
            spinImage hImage,
            @Cast("spinPixelFormatNamespaceID*") IntBuffer pPixelFormatNamespace);
    public static native _spinError spinImageGetTLPixelFormatNamespace(
            spinImage hImage,
            @Cast("spinPixelFormatNamespaceID*") int[] pPixelFormatNamespace);

    /**
     * Retrieves the pixel format of an image (as a symbolic)
     * @see spinError
     *
     * @param hImage The image of the pixel format to retrieve
     * @param pBuf The c-string character buffer in which the pixel format symbolic is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetPixelFormatName(spinImage hImage, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinImageGetPixelFormatName(spinImage hImage, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinImageGetPixelFormatName(spinImage hImage, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Checks whether an image is incomplete
     * @see spinError
     *
     * @param hImage The image to check
     * @param pbIsIncomplete The boolean pointer to return whether or not the image is incomplete
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageIsIncomplete(spinImage hImage, @Cast("bool8_t*") BytePointer pbIsIncomplete);
    public static native @Cast("_spinError") int spinImageIsIncomplete(spinImage hImage, @Cast("bool8_t*") ByteBuffer pbIsIncomplete);
    public static native _spinError spinImageIsIncomplete(spinImage hImage, @Cast("bool8_t*") byte[] pbIsIncomplete);

    /**
     * Retrieves the valid payload size of an image
     * @see spinError
     *
     * @param hImage The image of the payload size to retrieve
     * @param pSize The unsigned integer pointer in which the size of the valid payload is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetValidPayloadSize(spinImage hImage, @Cast("size_t*") SizeTPointer pSize);

    /**
     * Saves an image using a specified file format (using an enum, spinImageFileFormat)
     * @see spinError
     * @see spinImageFileFormat
     *
     * @param hImage The image to be saved
     * @param pFilename The filename to use to save the image (with or without the appropriate file extension)
     * \Param format The file format to use to save the image
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageSave(spinImage hImage, @Cast("const char*") BytePointer pFilename, @Cast("spinImageFileFormat") int format);
    public static native @Cast("_spinError") int spinImageSave(spinImage hImage, String pFilename, @Cast("spinImageFileFormat") int format);

    /**
     * Saves an image using a specified file format (using the extension of the filename)
     * @see spinError
     *
     * @param hImage The image to be saved
     * @param pFilename The filename to use to save the image (with or without the appropriate file extension)
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageSaveFromExt(spinImage hImage, @Cast("const char*") BytePointer pFilename);
    public static native @Cast("_spinError") int spinImageSaveFromExt(spinImage hImage, String pFilename);

    /**
     * Saves an image as a PNG image
     * @see spinError
     *
     * @param hImage The image to be saved
     * @param pFilename The filename to use to save the image (with or without the appropriate file extension)
     * @param pOption The image options related to saving as PNG; includes compression level and whether to save as
     * interlaced
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageSavePng(spinImage hImage, @Cast("const char*") BytePointer pFilename, @Const spinPNGOption pOption);
    public static native @Cast("_spinError") int spinImageSavePng(spinImage hImage, String pFilename, @Const spinPNGOption pOption);

    /**
     * Saves an image as a PPM image
     * @see spinError
     *
     * @param hImage The image to be saved
     * @param pFilename The filename to use to save the image (with or without the appropriate file extension)
     * @param pOption The image options related to saving as PPM; includes whether to save as binary
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageSavePpm(spinImage hImage, @Cast("const char*") BytePointer pFilename, @Const spinPPMOption pOption);
    public static native @Cast("_spinError") int spinImageSavePpm(spinImage hImage, String pFilename, @Const spinPPMOption pOption);

    /**
     * Saves an image as an PGM image
     * @see spinError
     *
     * @param hImage The image to be saved
     * @param pFilename The filename to use to save the image (with or without the appropriate file extension)
     * @param pOption The image options related to saving as PGM; includes whether to save as binary
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageSavePgm(spinImage hImage, @Cast("const char*") BytePointer pFilename, @Const spinPGMOption pOption);
    public static native @Cast("_spinError") int spinImageSavePgm(spinImage hImage, String pFilename, @Const spinPGMOption pOption);

    /**
     * Saves an image as a TIFF image
     * @see spinError
     *
     * @param hImage The image to be saved
     * @param pFilename The filename to use to save the image (with or without the appropriate file extension)
     * @param pOption The image options related to saving as TIFF; includes compression method
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageSaveTiff(spinImage hImage, @Cast("const char*") BytePointer pFilename, @Const spinTIFFOption pOption);
    public static native @Cast("_spinError") int spinImageSaveTiff(spinImage hImage, String pFilename, @Const spinTIFFOption pOption);

    /**
     * Saves an image as a JPEG image
     * @see spinError
     *
     * @param hImage The image to be saved
     * @param pFilename The filename to use to save the image (with or without the appropriate file extension)
     * @param pOption The image options related to saving as JPEG; includes quality and whether to save as progressive
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageSaveJpeg(spinImage hImage, @Cast("const char*") BytePointer pFilename, @Const spinJPEGOption pOption);
    public static native @Cast("_spinError") int spinImageSaveJpeg(spinImage hImage, String pFilename, @Const spinJPEGOption pOption);

    /**
     * Saves an image as a JPEG 2000 image
     * @see spinError
     *
     * @param hImage The image to be saved
     * @param pFilename The filename to use to save the image (with or without the appropriate file extension)
     * @param pOption The image options related to saving as JPEG 2000; includes quality
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageSaveJpg2(spinImage hImage, @Cast("const char*") BytePointer pFilename, @Const spinJPG2Option pOption);
    public static native @Cast("_spinError") int spinImageSaveJpg2(spinImage hImage, String pFilename, @Const spinJPG2Option pOption);

    /**
     * Saves an image as a BMP image
     * @see spinError
     *
     * @param hImage The image to be saved
     * @param pFilename The filename to use to save the image (with or without the appropriate file extension)
     * @param pOption The image options related to saving as BMP; includes whether to save as indexed 8-bit
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageSaveBmp(spinImage hImage, @Cast("const char*") BytePointer pFilename, @Const spinBMPOption pOption);
    public static native @Cast("_spinError") int spinImageSaveBmp(spinImage hImage, String pFilename, @Const spinBMPOption pOption);

    /**
     * Retrieves the chunk layout ID of an image
     * @see spinError
     *
     * @param hImage The image to be saved
     * @param pId The unsigned integer pointer in which the chunk layout ID is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetChunkLayoutID(spinImage hImage, @Cast("uint64_t*") IntPointer pId);
    public static native @Cast("_spinError") int spinImageGetChunkLayoutID(spinImage hImage, @Cast("uint64_t*") IntBuffer pId);
    public static native _spinError spinImageGetChunkLayoutID(spinImage hImage, @Cast("uint64_t*") int[] pId);

    /**
     * Calculates the image statistics of an image
     * @see spinError
     *
     * @param hImage The image to be saved
     * @param hStatistics The image statistics context in which the calculated statistics are returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageCalculateStatistics(spinImage hImage, spinImageStatistics hStatistics);

    /**
     * Retrieves the image status of an image
     * @see spinError
     *
     * @param hImage The image to be saved
     * @param pStatus The status enum pointer in which the image status is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetStatus(spinImage hImage, @Cast("spinImageStatus*") IntPointer pStatus);
    public static native @Cast("_spinError") int spinImageGetStatus(spinImage hImage, @Cast("spinImageStatus*") IntBuffer pStatus);
    public static native _spinError spinImageGetStatus(spinImage hImage, @Cast("spinImageStatus*") int[] pStatus);

    /**
     * Retrieves the description of image status
     * @see spinError
     *
     * @param status The status enum
     * @param pBuf The c-string character buffer in which the explanation of image status enum is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length; if pBuf is NULL, minimum length of string buffer is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetStatusDescription(@Cast("spinImageStatus") int status, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinImageGetStatusDescription(@Cast("spinImageStatus") int status, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinImageGetStatusDescription(@Cast("spinImageStatus") int status, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Releases an image
     * @see spinError
     *
     * @param hImage The image to be saved
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageRelease(spinImage hImage);

    /**
     * Checks whether an image has CRC
     * @see spinError
     *
     * @param hImage The image to be saved
     * @param pbHasCRC The boolean pointer to return whether the image has CRC available
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageHasCRC(spinImage hImage, @Cast("bool8_t*") BytePointer pbHasCRC);
    public static native @Cast("_spinError") int spinImageHasCRC(spinImage hImage, @Cast("bool8_t*") ByteBuffer pbHasCRC);
    public static native _spinError spinImageHasCRC(spinImage hImage, @Cast("bool8_t*") byte[] pbHasCRC);

    /**
     * Checks whether the CRC of an image is correct
     * @see spinError
     *
     * @param hImage The image to be saved
     * @param pbCheckCRC The boolean pointer to return whether the image CRC passes
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageCheckCRC(spinImage hImage, @Cast("bool8_t*") BytePointer pbCheckCRC);
    public static native @Cast("_spinError") int spinImageCheckCRC(spinImage hImage, @Cast("bool8_t*") ByteBuffer pbCheckCRC);
    public static native _spinError spinImageCheckCRC(spinImage hImage, @Cast("bool8_t*") byte[] pbCheckCRC);

    /**
     * Retrieves the number of bits per pixel of an image
     * @see spinError
     *
     * @param hImage The image to be saved
     * @param pBitsPerPixel The unsigned integer pointer in which the number of bits per pixel is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetBitsPerPixel(spinImage hImage, @Cast("size_t*") SizeTPointer pBitsPerPixel);

    /**
     * Retrieves the size of an image
     * @see spinError
     *
     * @param hImage The image to be saved
     * @param pImageSize The unsigned integer pointer in which the size of the image is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetSize(spinImage hImage, @Cast("size_t*") SizeTPointer pImageSize);

    /**
     * Retrieves the stride of an image
     * @see spinError
     *
     * @param hImage The image to be saved
     * @param pStride The unsigned integer pointer in which the stride is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageGetStride(spinImage hImage, @Cast("size_t*") SizeTPointer pStride);
    /*@}*/

    /**
     * \defgroup CEvent Event Access
     *
     * \brief The functions in this section allow for the creation and
     * destruction of events.
     */
    /*@{*/

    /**
     * Creates a device event
     * @see spinError
     *
     * @param phDeviceEvent The device event handle pointer in which the device event context is created
     * @param pFunction The function to be called at device event occurrences; signature to match:
     * void(*spinDeviceEventFunction)(const spinDeviceEventData hEventData, const char* pEventName, void* pUserData)
     * @param pUserData Properties that can be passed into the event function
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinDeviceEventCreate(
            @ByPtrPtr spinDeviceEvent phDeviceEvent,
            spinDeviceEventFunction pFunction,
            Pointer pUserData);

    /**
     * Destroys a device event
     * @see spinError
     *
     * @param hDeviceEvent The device event to destroy
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinDeviceEventDestroy(spinDeviceEvent hDeviceEvent);

    /**
     * Creates an image event
     * @see spinError
     *
     * @param phImageEvent The image event handle pointer in which the image event context is created
     * @param pFunction The function to be called at image event occurrences; signature to match:
     * void(*spinImageEventFunction)(const spinImage hImage, void* pUserData)
     * @param pUserData Properties that can be passed into the event function
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageEventCreate(
            @ByPtrPtr spinImageEvent phImageEvent,
            spinImageEventFunction pFunction,
            Pointer pUserData);

    /**
     * Destroys an image event
     * @see spinError
     *
     * @param hImageEvent The image event to destroy
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageEventDestroy(spinImageEvent hImageEvent);

    /**
     * Creates an arrival event
     * @see spinError
     *
     * @param phArrivalEvent The arrival event handle pointer in which the arrival event context is created
     * @param pFunction The function to be called at device event occurrences; signature to match:
     * void(*spinArrivalEventFunction)(void* pUserData)
     * @param pUserData Properties that can be passed into the event function
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinArrivalEventCreate(
            @ByPtrPtr spinArrivalEvent phArrivalEvent,
            spinArrivalEventFunction pFunction,
            Pointer pUserData);

    /**
     * Destroys an arrival event
     * @see spinError
     *
     * @param hArrivalEvent The arrival event to destroy
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinArrivalEventDestroy(spinArrivalEvent hArrivalEvent);

    /**
    * Creates a removal event
    * @see spinError
    *
    * @param phRemovalEvent The removal event handle pointer in which the removal event context is created
    * @param pFunction The function to be called at device event occurrences; signature to match:
    void(*spinRemovalEventFunction)(uint64_t deviceSerialNumber, void* pUserData)
    <p>
    * @param pUserData Properties that can be passed into the event function
    *
    * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
    */
    public static native _spinError spinRemovalEventCreate(
            @ByPtrPtr spinRemovalEvent phRemovalEvent,
            spinRemovalEventFunction pFunction,
            Pointer pUserData);

    /**
     * Destroys a removal event
     * @see spinError
     *
     * @param hRemovalEvent The removal event to destroy
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinRemovalEventDestroy(spinRemovalEvent hRemovalEvent);

    /**
     * Creates an interface event (both arrival and removal)
     * @see spinError
     *
     * @param phInterfaceEvent The interface event handle pointer in which the interface event context is created
     * @param pArrivalFunction The function to be called at arrival event occurrences; signature to match:
     * void(*spinArrivalEventFunction)(void* pUserData)
     * @param hRemovalFunction The function to be called at removal event occurrences; signature to match:
     * void(*spinRemovalEventFunction)(uint64_t deviceSerialNumber, void* pUserData)
     * @param pUserData Properties that can be passed into the event function
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinInterfaceEventCreate(
            @ByPtrPtr spinInterfaceEvent phInterfaceEvent,
            spinArrivalEventFunction pArrivalFunction,
            spinRemovalEventFunction pRemovalFunction,
            Pointer pUserData);

    /**
     * Destroys an interface event (both arrival and removal)
     * @see spinError
     *
     * @param hInterfaceEvent The interface event to destroy
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinInterfaceEventDestroy(spinInterfaceEvent hInterfaceEvent);

    /**
     * Creates a log event
     * @see spinError
     *
     * @param phLogEvent The log event handle pointer in which the log event context is created
     * @param pFunction The function to be called at device event occurrences; signature to match:
     * void(*spinLogEventFunction)(const spinLogEventData hEventData, void* pUserData)
     * @param pUserData Properties that can be passed into the event function
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinLogEventCreate(@ByPtrPtr spinLogEvent phLogEvent, spinLogEventFunction pFunction, Pointer pUserData);

    /**
     * Destroys a log event
     * @see spinError
     *
     * @param hLogEvent The log event to destroy
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinLogEventDestroy(spinLogEvent hLogEvent);
    /*@}*/

    /**
     * \defgroup CImageStatistics ImageStatistics Access
     *
     * \brief The functions in this section provide access to information and
     * functionality related to image statistics. This includes context
     * creation and destruction, the enabling and disabling of channels, and
     * value retrieval.
     */
    /*@{*/

    /**
     * Creates an image statistics context
     *
     * @param phStatistics The statistics handle pointer in which the image statistics context is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageStatisticsCreate(@ByPtrPtr spinImageStatistics phStatistics);

    /**
     * Destroys an image statistics context
     * @see spinError
     *
     * @param hStatistics The image statistics context to destroy
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageStatisticsDestroy(spinImageStatistics hStatistics);

    /**
     * Enables all channels of an image statistics context
     * @see spinError
     *
     * @param hStatistics The image statistics context to enable all channels
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageStatisticsEnableAll(spinImageStatistics hStatistics);

    /**
     * Disables all channels of an image statistics context
     * @see spinError
     *
     * @param hStatistics The image statistics context to disable all channels
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageStatisticsDisableAll(spinImageStatistics hStatistics);

    /**
     * Disables all channels of an image statistics context except grey-scale
     * @see spinError
     *
     * @param hStatistics The image statistics context to enable only grey
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageStatisticsEnableGreyOnly(spinImageStatistics hStatistics);

    /**
     * Disables all channels of an image statistics context except red, blue, and green
     * @see spinError
     *
     * @param hStatistics The image statistics context to enable only RGB
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageStatisticsEnableRgbOnly(spinImageStatistics hStatistics);

    /**
     * Disables all channels of an image statistics context except hue, saturation, and lightness
     * @see spinError
     *
     * @param hStatistics The image statistics context to enable only HSL
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageStatisticsEnableHslOnly(spinImageStatistics hStatistics);

    /**
     * Checks whether an image statistics context is enabled
     * @see spinError
     *
     * @param hStatistics The image statistics context of the channel
     * @param channel The channel to check
     * @param pbEnabled The boolean pointer to return whether or not the channel is enabled
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageStatisticsGetChannelStatus(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @Cast("bool8_t*") BytePointer pbEnabled);
    public static native @Cast("_spinError") int spinImageStatisticsGetChannelStatus(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @Cast("bool8_t*") ByteBuffer pbEnabled);
    public static native _spinError spinImageStatisticsGetChannelStatus(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @Cast("bool8_t*") byte[] pbEnabled);

    /**
     * Sets the status of an image statistics channel
     * @see spinError
     *
     * @param hStatistics The image statistics context of the channel
     * @param channel The channel to enable/disable
     * @param bEnable The boolean value to set; true enables, false disables
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageStatisticsSetChannelStatus(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @Cast("bool8_t") byte bEnable);

    /**
     * Retrieves the range of an image statistics channel
     * @see spinError
     *
     * @param hStatistics The image statistics context of the channel
     * @param channel The channel of the range to retrieve
     * @param pMin The unsigned integer pointer in which the minimum value of the range is returned
     * @param pMax The unsigned integer pointer in which the maximum value of the range is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageStatisticsGetRange(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @Cast("unsigned int*") IntPointer pMin,
            @Cast("unsigned int*") IntPointer pMax);
    public static native @Cast("_spinError") int spinImageStatisticsGetRange(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @Cast("unsigned int*") IntBuffer pMin,
            @Cast("unsigned int*") IntBuffer pMax);
    public static native _spinError spinImageStatisticsGetRange(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @Cast("unsigned int*") int[] pMin,
            @Cast("unsigned int*") int[] pMax);

    /**
     * Retrieves the pixel value range of an image statistics channel
     * @see spinError
     *
     * @param hStatistics The image statistics context of the channel
     * @param channel The channel of the pixel value range to retrieve
     * @param pMin The unsigned integer pointer in which the minimum value of the pixel value range is returned
     * @param pMax The unsigned integer pointer in which the maximum value of the pixel value range is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageStatisticsGetPixelValueRange(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @Cast("unsigned int*") IntPointer pMin,
            @Cast("unsigned int*") IntPointer pMax);
    public static native @Cast("_spinError") int spinImageStatisticsGetPixelValueRange(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @Cast("unsigned int*") IntBuffer pMin,
            @Cast("unsigned int*") IntBuffer pMax);
    public static native _spinError spinImageStatisticsGetPixelValueRange(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @Cast("unsigned int*") int[] pMin,
            @Cast("unsigned int*") int[] pMax);

    /**
     * Retrieves the number of pixel values of an image statistics channel
     * @see spinError
     *
     * @param hStatistics The image statistics context of the channel
     * @param channel The channel where the pixel values to be counted are
     * @param iNumValues The unsigned integer pointer in which the number of pixel values is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageStatisticsGetNumPixelValues(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @Cast("unsigned int*") IntPointer pNumValues);
    public static native @Cast("_spinError") int spinImageStatisticsGetNumPixelValues(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @Cast("unsigned int*") IntBuffer pNumValues);
    public static native _spinError spinImageStatisticsGetNumPixelValues(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @Cast("unsigned int*") int[] pNumValues);

    /**
     * Retrieves the mean of pixel values of an image statistics channel
     * @see spinError
     *
     * @param hStatistics The image statistics context of the channel
     * @param channel The channel of the mean pixel value to be retrieved
     * @param pMean The float pointer in which the mean pixel value is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageStatisticsGetMean(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            FloatPointer pMean);
    public static native @Cast("_spinError") int spinImageStatisticsGetMean(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            FloatBuffer pMean);
    public static native _spinError spinImageStatisticsGetMean(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            float[] pMean);

    /**
     * Retrieves a histogram of an image statistics channel
     * @see spinError
     *
     * @param hStatistics The image statistics context of the channel
     * @param channel The channel of the histogram to be returned
     * @param pHistogram The pointer to the integer pointer in which the histogram data is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageStatisticsGetHistogram(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @Cast("int**") PointerPointer ppHistogram);
    public static native _spinError spinImageStatisticsGetHistogram(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @ByPtrPtr IntPointer ppHistogram);
    public static native @Cast("_spinError") int spinImageStatisticsGetHistogram(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @ByPtrPtr IntBuffer ppHistogram);
    public static native _spinError spinImageStatisticsGetHistogram(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @ByPtrPtr int[] ppHistogram);

    /**
     * Retrieves all available information of an image statistics channel
     * @see spinError
     *
     * @param hStatistics The image statistics context of the channel
     * @param channel The channel of the information to retrieve
     * @param pRangeMin The unsigned integer pointer in which the minimum value of the range is returned
     * @param pRangeMax The unsigned integer pointer in which the maximum value of the range is returned
     * @param pPixelValueMin The unsigned integer pointer in which the minimum pixel value of the range is returned
     * @param pPixelValueMax The unsigned integer pointer in which the maximum pixel value of the range is returned
     * @param pNumPixelValues The unsigned integer pointer in which the number of pixel values is returned
     * @param pPixelValueMean The float pointer in which the mean pixel value is returned
     * @param ppiHistogram The pointer to the pointer in which the histogram data is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageStatisticsGetAll(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @Cast("unsigned int*") IntPointer pRangeMin,
            @Cast("unsigned int*") IntPointer pRangeMax,
            @Cast("unsigned int*") IntPointer pPixelValueMin,
            @Cast("unsigned int*") IntPointer pPixelValueMax,
            @Cast("unsigned int*") IntPointer pNumPixelValues,
            FloatPointer pPixelValueMean,
            @Cast("int**") PointerPointer ppHistogram);
    public static native _spinError spinImageStatisticsGetAll(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @Cast("unsigned int*") IntPointer pRangeMin,
            @Cast("unsigned int*") IntPointer pRangeMax,
            @Cast("unsigned int*") IntPointer pPixelValueMin,
            @Cast("unsigned int*") IntPointer pPixelValueMax,
            @Cast("unsigned int*") IntPointer pNumPixelValues,
            FloatPointer pPixelValueMean,
            @ByPtrPtr IntPointer ppHistogram);
    public static native @Cast("_spinError") int spinImageStatisticsGetAll(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @Cast("unsigned int*") IntBuffer pRangeMin,
            @Cast("unsigned int*") IntBuffer pRangeMax,
            @Cast("unsigned int*") IntBuffer pPixelValueMin,
            @Cast("unsigned int*") IntBuffer pPixelValueMax,
            @Cast("unsigned int*") IntBuffer pNumPixelValues,
            FloatBuffer pPixelValueMean,
            @ByPtrPtr IntBuffer ppHistogram);
    public static native _spinError spinImageStatisticsGetAll(
            spinImageStatistics hStatistics,
            @Cast("spinStatisticsChannel") int channel,
            @Cast("unsigned int*") int[] pRangeMin,
            @Cast("unsigned int*") int[] pRangeMax,
            @Cast("unsigned int*") int[] pPixelValueMin,
            @Cast("unsigned int*") int[] pPixelValueMax,
            @Cast("unsigned int*") int[] pNumPixelValues,
            float[] pPixelValueMean,
            @ByPtrPtr int[] ppHistogram);
    /*@}*/

    /**
     * \defgroup CLoggingEventData Logging Event Data Access
     *
     * \brief The functions in this section allow for the retrieval
     * of logging event data.
     */
    /*@{*/

    /**
     * Retrieves the category name of a log event
     * @see spinError
     *
     * @param hLogEventData The log event data received from the log event
     * @param pBuf The c-string character buffer in which the category name of the log event is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinLogDataGetCategoryName(spinLogEventData hLogEventData, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinLogDataGetCategoryName(spinLogEventData hLogEventData, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinLogDataGetCategoryName(spinLogEventData hLogEventData, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Retrieves the priority of a log event
     * @see spinError
     *
     * @param hLogEventData The log event data received from the log event
     * @param pValue The integer pointer in which the priority value is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinLogDataGetPriority(spinLogEventData hLogEventData, @Cast("int64_t*") LongPointer pValue);
    public static native @Cast("_spinError") int spinLogDataGetPriority(spinLogEventData hLogEventData, @Cast("int64_t*") LongBuffer pValue);
    public static native _spinError spinLogDataGetPriority(spinLogEventData hLogEventData, @Cast("int64_t*") long[] pValue);

    /**
     * Retrieves the priority name of a log event
     * @see spinError
     *
     * @param hLogEventData The log event data received from the log event
     * @param pBuf The c-string character buffer in which the priority name of the log event is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinLogDataGetPriorityName(spinLogEventData hLogEventData, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinLogDataGetPriorityName(spinLogEventData hLogEventData, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinLogDataGetPriorityName(spinLogEventData hLogEventData, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Retrieves the timestamp of a log event
     * @see spinError
     *
     * @param hLogEventData The log event data received from the log event
     * @param pBuf The c-string character buffer in which the timestamp of the log event is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinLogDataGetTimestamp(spinLogEventData hLogEventData, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinLogDataGetTimestamp(spinLogEventData hLogEventData, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinLogDataGetTimestamp(spinLogEventData hLogEventData, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Retrieves the NDC of a log event
     * @see spinError
     *
     * @param hLogEventData The log event data received from the log event
     * @param pBuf The c-string character buffer in which the NDC of the log event is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinLogDataGetNDC(spinLogEventData hLogEventData, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinLogDataGetNDC(spinLogEventData hLogEventData, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinLogDataGetNDC(spinLogEventData hLogEventData, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Retrieves the thread name of a log event
     * @see spinError
     *
     * @param hLogEventData The log event data received from the log event
     * @param pBuf The c-string character buffer in which the thread name of the log event is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinLogDataGetThreadName(spinLogEventData hLogEventData, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinLogDataGetThreadName(spinLogEventData hLogEventData, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinLogDataGetThreadName(spinLogEventData hLogEventData, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /**
     * Retrieves the log message of a log event
     * @see spinError
     *
     * @param hLogEventData The log event data received from the log event
     * @param pBuf The c-string character buffer in which the log message of the log event is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinLogDataGetLogMessage(spinLogEventData hLogEventData, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinLogDataGetLogMessage(spinLogEventData hLogEventData, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinLogDataGetLogMessage(spinLogEventData hLogEventData, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /*@}*/

    /**
     * \defgroup CDeviceEventData Device Event Data Access
     *
     * \brief The functions in this section allow for the retrieval
     * of device event data.
     */
    /*@{*/

    /**
     * Retrieves the event ID of a device event
     * @see spinError
     *
     * @param hDeviceEventData The log event data received from the log event
     * @param pEventId The unsigned integer pointer in which the event ID is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinDeviceEventGetId(spinDeviceEventData hDeviceEventData, @Cast("uint64_t*") IntPointer pEventId);
    public static native @Cast("_spinError") int spinDeviceEventGetId(spinDeviceEventData hDeviceEventData, @Cast("uint64_t*") IntBuffer pEventId);
    public static native _spinError spinDeviceEventGetId(spinDeviceEventData hDeviceEventData, @Cast("uint64_t*") int[] pEventId);

    /**
     * Retrieves the payload data of a device event
     * @see spinError
     *
     * @param hDeviceEventData The log event data received from the log event
     * @param pBuf The unsigned integer pointer in which the event payload is returned
     * @param pBufSize The unsigned integer pointer in which the size of the payload is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinDeviceEventGetPayloadData(
            spinDeviceEventData hDeviceEventData,
            @Cast("const uint8_t*") BytePointer pBuf,
            @Cast("size_t*") SizeTPointer pBufSize);
    public static native @Cast("_spinError") int spinDeviceEventGetPayloadData(
            spinDeviceEventData hDeviceEventData,
            @Cast("const uint8_t*") ByteBuffer pBuf,
            @Cast("size_t*") SizeTPointer pBufSize);
    public static native _spinError spinDeviceEventGetPayloadData(
            spinDeviceEventData hDeviceEventData,
            @Cast("const uint8_t*") byte[] pBuf,
            @Cast("size_t*") SizeTPointer pBufSize);

    /**
     * Retrieves the payload data size of a device event
     * @see spinError
     *
     * @param hDeviceEventData The log event data received from the log event
     * @param pBufSize The unsigned integer pointer in which the size of the payload is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinDeviceEventGetPayloadDataSize(spinDeviceEventData hDeviceEventData, @Cast("size_t*") SizeTPointer pBufSize);

    /**
     * Retrieves the event name of a device event
     * @see spinError
     *
     * @param hDeviceEventData The log event data received from the log event
     * @param pBuf The c-string character buffer in which the name of the device event is returned
     * @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is
     * the maximum length
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinDeviceEventGetName(spinDeviceEventData hDeviceEventData, @Cast("char*") BytePointer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native @Cast("_spinError") int spinDeviceEventGetName(spinDeviceEventData hDeviceEventData, @Cast("char*") ByteBuffer pBuf, @Cast("size_t*") SizeTPointer pBufLen);
    public static native _spinError spinDeviceEventGetName(spinDeviceEventData hDeviceEventData, @Cast("char*") byte[] pBuf, @Cast("size_t*") SizeTPointer pBufLen);

    /*@}*/

    /**
     * \defgroup CAVIRecorder AVIRecorder Access
     *
     * \brief The functions in this section provide access to AVI recording
     * capabilities, which include opening, building, and closing video
     * files.
     *
     * NOTE: This class is deprecated and replaced by SpinVideo. Refer to SpinVideoC.h instead.
     */
    /*@{*/

    /*
     * Opens an empty video file to create an uncompressed AVI video
     * @see spinError
     *
     * @param phRecorder The AVI recorder handle pointer in which the AVI recorder is returned
     * @param pName The filename to save the video as; do not include the extension
     * @param option The video options related to saving as uncompressed AVI; includes frame rate
     *
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    

    /*
     * Opens an empty video file to create an MJPG file
     * @see spinError
     *
     * @param phRecorder The AVI recorder handle pointer in which the AVI recorder is returned
     * @param pName The filename to save the video as; do not include the extension
     * @param option The video options related to saving as MJPG; includes frame rate and quality
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    

    /*
     * Opens an empty video file to create an H264 MP4 file
     * @see spinError
     *
     * @param phRecorder The AVI recorder handle pointer in which the AVI recorder is returned
     * @param pName The filename to save the video as; do not include the extension
     * @param option The video options related to saving as MJPG; includes frame rate, bitrate, height, and width
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    

    /*
     * Appends an image to the end of an open video file
     * @see spinError
     *
     * @param hRecorder The AVI recorder to append the image to
     * @param hImage The image to append
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    

    /**
     * Set the maximum file size (in megabytes) of a AVI/MP4 file. A new AVI/MP4 file
     * is created automatically when file size limit is reached. Setting
     * a maximum size of 0 indicates no limit on file size.
     *
     * @param spinAVIRecorder The AVI recorder to append the image to
     * @param size The maximum AVI file size in MB.
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    

    /*
     * Closes a video file to complete its creation
     * @see spinError
     *
     * @param hRecorder The AVI recorder to close
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    

    /*@}*/

    // Chunk data from Image
    /**
     * \defgroup CChunkData Chunk data access
     *
     * \brief The functions in this section provide access to chunk data
     * stored on images.
     */
    /*@{*/

    /*
     * Retrieves an integer value of a piece of chunk data
     * @see spinError
     *
     * @param hImage The image of the chunk data to retrieve
     * @param pName The name of the piece of chunk data to retrieve
     * @param pValue The integer pointer in which the piece of chunk data is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageChunkDataGetIntValue(spinImage hImage, @Cast("const char*") BytePointer pName, @Cast("int64_t*") LongPointer pValue);
    public static native @Cast("_spinError") int spinImageChunkDataGetIntValue(spinImage hImage, String pName, @Cast("int64_t*") LongBuffer pValue);
    public static native _spinError spinImageChunkDataGetIntValue(spinImage hImage, @Cast("const char*") BytePointer pName, @Cast("int64_t*") long[] pValue);
    public static native @Cast("_spinError") int spinImageChunkDataGetIntValue(spinImage hImage, String pName, @Cast("int64_t*") LongPointer pValue);
    public static native _spinError spinImageChunkDataGetIntValue(spinImage hImage, @Cast("const char*") BytePointer pName, @Cast("int64_t*") LongBuffer pValue);
    public static native @Cast("_spinError") int spinImageChunkDataGetIntValue(spinImage hImage, String pName, @Cast("int64_t*") long[] pValue);

    /*
     * Retrieves a float value of a piece of chunk data
     * @see spinError
     *
     * @param hImage The image of the chunk data to retrieve
     * @param pName The name of the piece of chunk data to retrieve
     * @param pValue The float pointer in which the piece of chunk data is returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinImageChunkDataGetFloatValue(spinImage hImage, @Cast("const char*") BytePointer pName, DoublePointer pValue);
    public static native @Cast("_spinError") int spinImageChunkDataGetFloatValue(spinImage hImage, String pName, DoubleBuffer pValue);
    public static native _spinError spinImageChunkDataGetFloatValue(spinImage hImage, @Cast("const char*") BytePointer pName, double[] pValue);
    public static native @Cast("_spinError") int spinImageChunkDataGetFloatValue(spinImage hImage, String pName, DoublePointer pValue);
    public static native _spinError spinImageChunkDataGetFloatValue(spinImage hImage, @Cast("const char*") BytePointer pName, DoubleBuffer pValue);
    public static native @Cast("_spinError") int spinImageChunkDataGetFloatValue(spinImage hImage, String pName, double[] pValue);

    /*@}*/

// #ifdef __cplusplus
// #endif

/*@}*/

// #endif /* FLIR_SPINNAKER_C_H */

// Parsed from <SpinVideoC.h>

//=============================================================================
// Copyright (c) 2001-2019 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

// #ifndef FLIR_SPIN_VIDEO_C_H
// #define FLIR_SPIN_VIDEO_C_H

/**
 * SpinnakerPlatform C Include
 */
// #include "SpinnakerPlatformC.h"

/**
 * Spinnaker C Definition Includes
 */
// #include "SpinnakerDefsC.h"

/**
 * \defgroup SpinnakerC Spinnaker C API
 */
/*@{*/

// #ifdef __cplusplus
// #endif

    /**
     * \defgroup CSpinVideo SpinVideo Recording Access
     *
     * \brief The functions in this section provide access to video recording
     * capabilities, which include opening, building, and closing video
     * files.
     */
    /*@{*/

    /*
     * Opens an empty video file to create an uncompressed video
     * @see spinError
     *
     * @param phSpinVideo The spinVideo handle pointer in which the spin video recorder is returned
     * @param pName The filename to save the video as; do not include the extension
     * @param option The video options related to saving as uncompressed video; includes frame rate
     *
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinVideoOpenUncompressed(@ByPtrPtr spinVideo phSpinVideo, @Cast("const char*") BytePointer pName, @ByVal spinAVIOption option);
    public static native @Cast("_spinError") int spinVideoOpenUncompressed(@ByPtrPtr spinVideo phSpinVideo, String pName, @ByVal spinAVIOption option);

    /*
     * Opens an empty video file to create an MJPG file
     * @see spinError
     *
     * @param phSpinVideo The spinVideo handle pointer in which the spin video recorder is returned
     * @param pName The filename to save the video as; do not include the extension
     * @param option The video options related to saving as MJPG; includes frame rate and quality
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinVideoOpenMJPG(@ByPtrPtr spinVideo phSpinVideo, @Cast("const char*") BytePointer pName, @ByVal spinMJPGOption option);
    public static native @Cast("_spinError") int spinVideoOpenMJPG(@ByPtrPtr spinVideo phSpinVideo, String pName, @ByVal spinMJPGOption option);

    /*
     * Opens an empty video file to create an H264 MP4 file
     * @see spinError
     *
     * @param phSpinVideo The spinVideo handle pointer in which the spin video recorder is returned
     * @param pName The filename to save the video as; do not include the extension
     * @param option The video options related to saving as MJPG; includes frame rate, bitrate, height, and width
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinVideoOpenH264(@ByPtrPtr spinVideo phSpinVideo, @Cast("const char*") BytePointer pName, @ByVal spinH264Option option);
    public static native @Cast("_spinError") int spinVideoOpenH264(@ByPtrPtr spinVideo phSpinVideo, String pName, @ByVal spinH264Option option);

    /*
     * Appends an image to the end of an open video file
     * @see spinError
     *
     * @param hSpinVideo The spin video recorder to append the image to
     * @param hImage The image to append
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinVideoAppend(spinVideo hSpinVideo, spinImage hImage);

    /**
     * Set the maximum file size (in megabytes) of a AVI/MP4 file. A new AVI/MP4 file
     * is created automatically when file size limit is reached. Setting
     * a maximum size of 0 indicates no limit on file size.
     *
     * @param hSpinVideo The spin video recorder to append the image to
     * @param size The maximum video file size in MB.
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinVideoSetMaximumFileSize(spinVideo hSpinVideo, @Cast("unsigned int") int size);

    /*
     * Closes a video file to complete its creation
     * @see spinError
     *
     * @param hSpinVideo The spin video recorder to close
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError spinVideoClose(spinVideo hSpinVideo);
    /*@}*/

    /*@}*/

// #ifdef __cplusplus
// #endif

/*@}*/

// #endif /* FLIR_SPIN_VIDEO_C_H */

// Parsed from <QuickSpinDefsC.h>

//=============================================================================
// Copyright (c) 2001-2019 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================
   
/* Auto-generated file. Do not modify. */

// #ifndef FLIR_SPINNAKER_QUICKSPINDEFS_C_H
// #define FLIR_SPINNAKER_QUICKSPINDEFS_C_H

// #include "SpinnakerGenApiDefsC.h"
// Targeting ..\Spinnaker_C\quickSpin.java



// #endif // FLIR_SPINNAKER_QUICKSPINDEFS_C_H


// Parsed from <QuickSpinC.h>

//=============================================================================
// Copyright (c) 2001-2019 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

// #ifndef FLIR_SPINNAKER_QUICKSPIN_C_H
// #define FLIR_SPINNAKER_QUICKSPIN_C_H

// #include "SpinnakerDefsC.h"
// #include "QuickSpinDefsC.h"

// #include "TransportLayerSystemC.h"
// #include "TransportLayerDeviceC.h"
// #include "TransportLayerInterfaceC.h"
// #include "TransportLayerStreamC.h"
// #include "TransportLayerDefsC.h"

/**
 * \defgroup CQuickSpin Spinnaker C QuickSpin API
 *
 */
/*@{*/

// #ifdef __cplusplus
// #endif

    /**
     * \defgroup CQuickSpinAccess QuickSpin Access
     *
     * \brief The functions in this section initialize the various QuickSpin
     * structs for the C API.
     */
    /*@{*/

    /*
     * Pre-fetches all nodes housed on the GenICam nodemap (device initialization required)
     * @see spinError
     *
     * @param hCamera The camera of the nodes to fetch
     * @param pQuickSpin The struct pointer in which the GenICam nodes are returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError quickSpinInit(spinCamera hCamera, quickSpin pQuickSpin);

    /*
     * Pre-features all nodes housed on the GenICam, transport layer device, and transport layer stream nodemaps (device
     * initialization required)
     * @see spinError
     *
     * @param hCamera The camera of the nodes to fetch
     * @param pQuickSpin The struct pointer in which the GenICam nodes are returned (accepts NULL)
     * @param pQuickSpinTLDevice The struct pointer in which the transport layer device nodes are returned (accepts
     * NULL)
     * @param pQuickSpinTLStream The struct pointer in which the transport layer stream nodes are returned (accepts
     * NULL)
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError quickSpinInitEx(
            spinCamera hCamera,
            quickSpin pQuickSpin,
            quickSpinTLDevice pQuickSpinTLDevice,
            quickSpinTLStream pQuickSpinTLStream);

    /*
     * Pre-fetches all nodes housed on the transport layer device nodemap (device initialization not necessary)
     * @see spinError
     *
     * @param hCamera The camera of the nodes to fetch
     * @param pQuickSpinTLDevice The struct pointer in which the transport layer device nodes are returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError quickSpinTLDeviceInit(spinCamera hCamera, quickSpinTLDevice pQuickSpinTLDevice);

    /*
     * Pre-fetches all nodes housed on the transport layer stream nodemap (device initialization not necessary)
     * @see spinError
     *
     * @param hCamera The camera of the nodes to fetch
     * @param pQuickSpinTLStream The struct pointer in which the transport layer stream nodes are returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError quickSpinTLStreamInit(spinCamera hCamera, quickSpinTLStream pQuickSpinTLStream);

    /*
     * Pre-fetches all nodes housed on the transport layer interface nodemap (device initialization not necessary)
     * @see spinError
     *
     * @param hInterface The interface of the nodes to fetch
     * @param pQuickSpinTLInterface The struct pointer in which the transport layer interface nodes are returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError quickSpinTLInterfaceInit(spinInterface hInterface, quickSpinTLInterface pQuickSpinTLInterface);

    /*
     * Pre-fetches all nodes housed on the transport layer system nodemap
     * @see spinError
     *
     * @param hSystem The system of the nodes to fetch
     * @param pQuickSpinTLSystem The struct pointer in which the transport layer system nodes are returned
     *
     * @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error
     */
    public static native _spinError quickSpinTLSystemInit(spinSystem hSystem, quickSpinTLSystem pQuickSpinTLSystem);

    /*@}*/

// #ifdef __cplusplus
// #endif

/*@}*/

// #endif // PGR_SPINNAKER_QUICKSPIN_C_H

// Parsed from <TransportLayerDefsC.h>

//=============================================================================
// Copyright (c) 2001-2019 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================
   
/* Auto-generated file. Do not modify. */

// #ifndef FLIR_SPINNAKERC_TRANSPORTLAYERDEFSC_H
// #define FLIR_SPINNAKERC_TRANSPORTLAYERDEFSC_H

/**
* \defgroup CQuickSpin Spinnaker C QuickSpin API
*/
/*@{*/

/**	
* \defgroup TransportLayerDefsC_h Transport Layer Enumerations
*/
/*@{*/

/**
*\brief The enumeration definitions for transport layer nodes.
*/

public enum _spinTLStreamTypeEnums {
	/** Stream Type - Mixed*/
	StreamType_Mixed(0),
	/** Stream Type - Custom*/
	StreamType_Custom(1),
	/** Stream Type - GEV*/
	StreamType_GEV(2),
	/** Stream Type - CL*/
	StreamType_CL(3),
	/** Stream Type - IIDC*/
	StreamType_IIDC(4),
	/** Stream Type - UVC*/
	StreamType_UVC(5),
	/** Stream Type - CXP*/
	StreamType_CXP(6),
	/** Stream Type - CLHS*/
	StreamType_CLHS(7),
	/** Stream Type - U3V*/
	StreamType_U3V(8),
	/** Stream Type - ETHERNET*/
	StreamType_ETHERNET(9),
	/** Stream Type - PCI*/
	StreamType_PCI(10),
	NUMSTREAMTYPE(11);

    public final int value;
    private _spinTLStreamTypeEnums(int v) { this.value = v; }
    private _spinTLStreamTypeEnums(_spinTLStreamTypeEnums e) { this.value = e.value; }
    public _spinTLStreamTypeEnums intern() { for (_spinTLStreamTypeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTLStreamDefaultBufferCountModeEnums {
	/** DEPRECATED. The number of buffers used for the stream are set by the user.*/
	StreamDefaultBufferCountMode_Manual(0),
	/** DEPRECATED. The number of buffers used for the stream is automatically calculated.*/
	StreamDefaultBufferCountMode_Auto(1),
	NUMSTREAMDEFAULTBUFFERCOUNTMODE(2);

    public final int value;
    private _spinTLStreamDefaultBufferCountModeEnums(int v) { this.value = v; }
    private _spinTLStreamDefaultBufferCountModeEnums(_spinTLStreamDefaultBufferCountModeEnums e) { this.value = e.value; }
    public _spinTLStreamDefaultBufferCountModeEnums intern() { for (_spinTLStreamDefaultBufferCountModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTLStreamBufferCountModeEnums {
	/** The number of buffers used for the stream are set by the user.*/
	StreamBufferCountMode_Manual(0),
	/** The number of buffers used for the stream is automatically calculated based on the device frame rate.*/
	StreamBufferCountMode_Auto(1),
	NUMSTREAMBUFFERCOUNTMODE(2);

    public final int value;
    private _spinTLStreamBufferCountModeEnums(int v) { this.value = v; }
    private _spinTLStreamBufferCountModeEnums(_spinTLStreamBufferCountModeEnums e) { this.value = e.value; }
    public _spinTLStreamBufferCountModeEnums intern() { for (_spinTLStreamBufferCountModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTLStreamBufferHandlingModeEnums {
	/** The application always gets the buffer from the head of the output buffer queue (thus, the oldest available one). If the output buffer queue is empty, the application waits for a newly acquired buffer until the timeout expires.*/
	StreamBufferHandlingMode_OldestFirst(0),
	/** The application always gets the buffer from the head of the output buffer queue (thus, the oldest available one). If the output buffer queue is empty, the application waits for a newly acquired buffer until the timeout expires. If a new buffer arrives it will overwrite the existing buffer from the head of the queue (behaves like a circular buffer).*/
	StreamBufferHandlingMode_OldestFirstOverwrite(1),
	/** The application always gets the buffer from the tail of the output buffer queue (thus, the newest available one). If the output buffer queue is empty, the application waits for a newly acquired buffer until the timeout expires.*/
	StreamBufferHandlingMode_NewestFirst(2),
	/** DEPRECATED.  This is replaced by NewestOnly.*/
	StreamBufferHandlingMode_NewestFirstOverwrite(3),
	/** The application always gets the latest completed buffer (the newest one).  If the Output Buffer Queue is empty, the application waits for a newly acquired buffer until the timeout expires.  This buffer handling mode is typically used in a live display GUI where it is important that there is no lag between camera and display.*/
	StreamBufferHandlingMode_NewestOnly(4),
	NUMSTREAMBUFFERHANDLINGMODE(5);

    public final int value;
    private _spinTLStreamBufferHandlingModeEnums(int v) { this.value = v; }
    private _spinTLStreamBufferHandlingModeEnums(_spinTLStreamBufferHandlingModeEnums e) { this.value = e.value; }
    public _spinTLStreamBufferHandlingModeEnums intern() { for (_spinTLStreamBufferHandlingModeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTLDeviceTypeEnums {
	/** TL - Mixed*/
	DeviceType_Mixed(0),
	/** TL - Custom*/
	DeviceType_Custom(1),
	/** TL - GEV*/
	DeviceType_GEV(2),
	/** TL - CL*/
	DeviceType_CL(3),
	/** TL - IIDC*/
	DeviceType_IIDC(4),
	/** TL - UVC*/
	DeviceType_UVC(5),
	/** TL - CXP*/
	DeviceType_CXP(6),
	/** TL - CLHS*/
	DeviceType_CLHS(7),
	/** TL - U3V*/
	DeviceType_U3V(8),
	/** TL - ETHERNET*/
	DeviceType_ETHERNET(9),
	/** TL - PCI*/
	DeviceType_PCI(10),
	NUMDEVICETYPE(11);

    public final int value;
    private _spinTLDeviceTypeEnums(int v) { this.value = v; }
    private _spinTLDeviceTypeEnums(_spinTLDeviceTypeEnums e) { this.value = e.value; }
    public _spinTLDeviceTypeEnums intern() { for (_spinTLDeviceTypeEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTLDeviceAccessStatusEnums {
	/** Not known to producer.*/
	DeviceAccessStatus_Unknown(0),
	/** Full access*/
	DeviceAccessStatus_ReadWrite(1),
	/** Read-only access*/
	DeviceAccessStatus_ReadOnly(2),
	/** Not available to connect*/
	DeviceAccessStatus_NoAccess(3),
	/** The device is already opened by another entity*/
	DeviceAccessStatus_Busy(4),
	/** Open in Read/Write mode by this GenTL host*/
	DeviceAccessStatus_OpenReadWrite(5),
	/** Open in Read access mode by this GenTL host*/
	DeviceAccessStatus_OpenReadOnly(6),
	NUMDEVICEACCESSSTATUS(7);

    public final int value;
    private _spinTLDeviceAccessStatusEnums(int v) { this.value = v; }
    private _spinTLDeviceAccessStatusEnums(_spinTLDeviceAccessStatusEnums e) { this.value = e.value; }
    public _spinTLDeviceAccessStatusEnums intern() { for (_spinTLDeviceAccessStatusEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTLGevCCPEnums {
	/** Open access privilege.*/
	GevCCP_EnumEntry_GevCCP_OpenAccess(0),
	/** Exclusive access privilege.*/
	GevCCP_EnumEntry_GevCCP_ExclusiveAccess(1),
	/** Control access privilege.*/
	GevCCP_EnumEntry_GevCCP_ControlAccess(2),
	NUMGEVCCP(3);

    public final int value;
    private _spinTLGevCCPEnums(int v) { this.value = v; }
    private _spinTLGevCCPEnums(_spinTLGevCCPEnums e) { this.value = e.value; }
    public _spinTLGevCCPEnums intern() { for (_spinTLGevCCPEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTLGUIXMLLocationEnums {
	/** Load XML from device*/
	GUIXMLLocation_Device(0),
	/** Load XML from host*/
	GUIXMLLocation_Host(1),
	NUMGUIXMLLOCATION(2);

    public final int value;
    private _spinTLGUIXMLLocationEnums(int v) { this.value = v; }
    private _spinTLGUIXMLLocationEnums(_spinTLGUIXMLLocationEnums e) { this.value = e.value; }
    public _spinTLGUIXMLLocationEnums intern() { for (_spinTLGUIXMLLocationEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTLGenICamXMLLocationEnums {
	/** Load GenICam XML from device*/
	GenICamXMLLocation_Device(0),
	/** Load GenICam XML from host*/
	GenICamXMLLocation_Host(1),
	NUMGENICAMXMLLOCATION(2);

    public final int value;
    private _spinTLGenICamXMLLocationEnums(int v) { this.value = v; }
    private _spinTLGenICamXMLLocationEnums(_spinTLGenICamXMLLocationEnums e) { this.value = e.value; }
    public _spinTLGenICamXMLLocationEnums intern() { for (_spinTLGenICamXMLLocationEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTLDeviceEndianessMechanismEnums {
	/** Handling the device endianness according to GenICam Schema 1.0*/
	DeviceEndianessMechanism_Legacy(0),
	/** Handling the device endianness according to GenICam Schema 1.1 and later*/
	DeviceEndianessMechanism_Standard(1),
	NUMDEVICEENDIANESSMECHANISM(2);

    public final int value;
    private _spinTLDeviceEndianessMechanismEnums(int v) { this.value = v; }
    private _spinTLDeviceEndianessMechanismEnums(_spinTLDeviceEndianessMechanismEnums e) { this.value = e.value; }
    public _spinTLDeviceEndianessMechanismEnums intern() { for (_spinTLDeviceEndianessMechanismEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTLDeviceCurrentSpeedEnums {
	/** Unknown-Speed.*/
	DeviceCurrentSpeed_UnknownSpeed(0),
	/** Low-Speed.*/
	DeviceCurrentSpeed_LowSpeed(1),
	/** Full-Speed.*/
	DeviceCurrentSpeed_FullSpeed(2),
	/** High-Speed.*/
	DeviceCurrentSpeed_HighSpeed(3),
	/** Super-Speed.*/
	DeviceCurrentSpeed_SuperSpeed(4),
	NUMDEVICECURRENTSPEED(5);

    public final int value;
    private _spinTLDeviceCurrentSpeedEnums(int v) { this.value = v; }
    private _spinTLDeviceCurrentSpeedEnums(_spinTLDeviceCurrentSpeedEnums e) { this.value = e.value; }
    public _spinTLDeviceCurrentSpeedEnums intern() { for (_spinTLDeviceCurrentSpeedEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTLPOEStatusEnums {
	/** Not Supported*/
	POEStatus_NotSupported(0),
	/** Power is Off*/
	POEStatus_PowerOff(1),
	/** Power is On*/
	POEStatus_PowerOn(2),
	NUMPOESTATUS(3);

    public final int value;
    private _spinTLPOEStatusEnums(int v) { this.value = v; }
    private _spinTLPOEStatusEnums(_spinTLPOEStatusEnums e) { this.value = e.value; }
    public _spinTLPOEStatusEnums intern() { for (_spinTLPOEStatusEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum _spinTLFilterDriverStatusEnums {
	/** Not Supported*/
	FilterDriverStatus_NotSupported(0),
	/** FLIR Light Weight Filter Driver is disabled*/
	FilterDriverStatus_Disabled(1),
	/** FLIR Light Weight Filter Driver is enabled*/
	FilterDriverStatus_Enabled(2),
	NUMFILTERDRIVERSTATUS(3);

    public final int value;
    private _spinTLFilterDriverStatusEnums(int v) { this.value = v; }
    private _spinTLFilterDriverStatusEnums(_spinTLFilterDriverStatusEnums e) { this.value = e.value; }
    public _spinTLFilterDriverStatusEnums intern() { for (_spinTLFilterDriverStatusEnums e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/*@}*/

/*@}*/

// #endif // FLIR_SPINNAKER_TRANSPORTLAYERDEFSC_H

// Parsed from <TransportLayerDeviceC.h>

//=============================================================================
// Copyright (c) 2001-2019 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================
   
/* Auto-generated file. Do not modify. */

// #include "QuickSpinC.h"

// #ifndef FLIR_SPINNAKERC_TLDEVICE_H
// #define FLIR_SPINNAKERC_TLDEVICE_H
// Targeting ..\Spinnaker_C\quickSpinTLDevice.java



/*@}*/

// #endif // FLIR_SPINNAKERC_TLDEVICE_H

// Parsed from <TransportLayerInterfaceC.h>

//=============================================================================
// Copyright (c) 2001-2019 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================
   
/* Auto-generated file. Do not modify. */

// #include "QuickSpinC.h"

// #ifndef FLIR_SPINNAKERC_TLINTERFACE_H
// #define FLIR_SPINNAKERC_TLINTERFACE_H
// Targeting ..\Spinnaker_C\quickSpinTLInterface.java



/*@}*/

// #endif // FLIR_SPINNAKERC_TLINTERFACE_H

// Parsed from <TransportLayerStreamC.h>

//=============================================================================
// Copyright (c) 2001-2019 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================
   
/* Auto-generated file. Do not modify. */

// #include "QuickSpinC.h"

// #ifndef FLIR_SPINNAKERC_TLSTREAM_H
// #define FLIR_SPINNAKERC_TLSTREAM_H
// Targeting ..\Spinnaker_C\quickSpinTLStream.java



/*@}*/

// #endif // FLIR_SPINNAKERC_TLSTREAM_H

// Parsed from <TransportLayerSystemC.h>

//=============================================================================
// Copyright (c) 2001-2019 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================
   
/* Auto-generated file. Do not modify. */

// #include "QuickSpinC.h"

// #ifndef FLIR_SPINNAKERC_TLSYSTEM_H
// #define FLIR_SPINNAKERC_TLSYSTEM_H
// Targeting ..\Spinnaker_C\quickSpinTLSystem.java



/*@}*/

// #endif // FLIR_SPINNAKERC_TLSYSTEM_H

}
