// Targeted by JavaCPP version 1.5.2: DO NOT EDIT THIS FILE

package org.bytedeco.systems.windows;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.systems.global.windows.*;


// end_wdm end_ntosp
// begin_ntddk

//
// Context Frame
//
//  This frame has a several purposes: 1) it is used as an argument to
//  NtContinue, 2) it is used to constuct a call frame for APC delivery,
//  and 3) it is used in the user level thread creation routines.
//
//
// The flags field within this record controls the contents of a CONTEXT
// record.
//
// If the context record is used as an input parameter, then for each
// portion of the context record controlled by a flag whose value is
// set, it is assumed that that portion of the context record contains
// valid context. If the context record is being used to modify a threads
// context, then only that portion of the threads context is modified.
//
// If the context record is used as an output parameter to capture the
// context of a thread, then only those portions of the thread's context
// corresponding to set flags will be returned.
//
// CONTEXT_CONTROL specifies SegSs, Rsp, SegCs, Rip, and EFlags.
//
// CONTEXT_INTEGER specifies Rax, Rcx, Rdx, Rbx, Rbp, Rsi, Rdi, and R8-R15.
//
// CONTEXT_SEGMENTS specifies SegDs, SegEs, SegFs, and SegGs.
//
// CONTEXT_FLOATING_POINT specifies Xmm0-Xmm15.
//
// CONTEXT_DEBUG_REGISTERS specifies Dr0-Dr3 and Dr6-Dr7.
//

@Properties(inherit = org.bytedeco.systems.presets.windows.class)
public class CONTEXT extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CONTEXT() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CONTEXT(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CONTEXT(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CONTEXT position(long position) {
        return (CONTEXT)super.position(position);
    }


    //
    // Register parameter home addresses.
    //
    // N.B. These fields are for convience - they could be used to extend the
    //      context record in the future.
    //

    public native @Cast("DWORD64") long P1Home(); public native CONTEXT P1Home(long setter);
    public native @Cast("DWORD64") long P2Home(); public native CONTEXT P2Home(long setter);
    public native @Cast("DWORD64") long P3Home(); public native CONTEXT P3Home(long setter);
    public native @Cast("DWORD64") long P4Home(); public native CONTEXT P4Home(long setter);
    public native @Cast("DWORD64") long P5Home(); public native CONTEXT P5Home(long setter);
    public native @Cast("DWORD64") long P6Home(); public native CONTEXT P6Home(long setter);

    //
    // Control flags.
    //

    public native @Cast("DWORD") int ContextFlags(); public native CONTEXT ContextFlags(int setter);
    public native @Cast("DWORD") int MxCsr(); public native CONTEXT MxCsr(int setter);

    //
    // Segment Registers and processor flags.
    //

    public native @Cast("WORD") short SegCs(); public native CONTEXT SegCs(short setter);
    public native @Cast("WORD") short SegDs(); public native CONTEXT SegDs(short setter);
    public native @Cast("WORD") short SegEs(); public native CONTEXT SegEs(short setter);
    public native @Cast("WORD") short SegFs(); public native CONTEXT SegFs(short setter);
    public native @Cast("WORD") short SegGs(); public native CONTEXT SegGs(short setter);
    public native @Cast("WORD") short SegSs(); public native CONTEXT SegSs(short setter);
    public native @Cast("DWORD") int EFlags(); public native CONTEXT EFlags(int setter);

    //
    // Debug registers
    //

    public native @Cast("DWORD64") long Dr0(); public native CONTEXT Dr0(long setter);
    public native @Cast("DWORD64") long Dr1(); public native CONTEXT Dr1(long setter);
    public native @Cast("DWORD64") long Dr2(); public native CONTEXT Dr2(long setter);
    public native @Cast("DWORD64") long Dr3(); public native CONTEXT Dr3(long setter);
    public native @Cast("DWORD64") long Dr6(); public native CONTEXT Dr6(long setter);
    public native @Cast("DWORD64") long Dr7(); public native CONTEXT Dr7(long setter);

    //
    // Integer registers.
    //

    public native @Cast("DWORD64") long Rax(); public native CONTEXT Rax(long setter);
    public native @Cast("DWORD64") long Rcx(); public native CONTEXT Rcx(long setter);
    public native @Cast("DWORD64") long Rdx(); public native CONTEXT Rdx(long setter);
    public native @Cast("DWORD64") long Rbx(); public native CONTEXT Rbx(long setter);
    public native @Cast("DWORD64") long Rsp(); public native CONTEXT Rsp(long setter);
    public native @Cast("DWORD64") long Rbp(); public native CONTEXT Rbp(long setter);
    public native @Cast("DWORD64") long Rsi(); public native CONTEXT Rsi(long setter);
    public native @Cast("DWORD64") long Rdi(); public native CONTEXT Rdi(long setter);
    public native @Cast("DWORD64") long R8(); public native CONTEXT R8(long setter);
    public native @Cast("DWORD64") long R9(); public native CONTEXT R9(long setter);
    public native @Cast("DWORD64") long R10(); public native CONTEXT R10(long setter);
    public native @Cast("DWORD64") long R11(); public native CONTEXT R11(long setter);
    public native @Cast("DWORD64") long R12(); public native CONTEXT R12(long setter);
    public native @Cast("DWORD64") long R13(); public native CONTEXT R13(long setter);
    public native @Cast("DWORD64") long R14(); public native CONTEXT R14(long setter);
    public native @Cast("DWORD64") long R15(); public native CONTEXT R15(long setter);

    //
    // Program counter.
    //

    public native @Cast("DWORD64") long Rip(); public native CONTEXT Rip(long setter);

    //
    // Floating point state.
    //
        public native @ByRef @Cast("XMM_SAVE_AREA32*") XSAVE_FORMAT FltSave(); public native CONTEXT FltSave(XSAVE_FORMAT setter);
            public native @ByRef M128A Header(int i); public native CONTEXT Header(int i, M128A setter);
            @MemberGetter public native M128A Header();
            public native @ByRef M128A Legacy(int i); public native CONTEXT Legacy(int i, M128A setter);
            @MemberGetter public native M128A Legacy();
            public native @ByRef M128A Xmm0(); public native CONTEXT Xmm0(M128A setter);
            public native @ByRef M128A Xmm1(); public native CONTEXT Xmm1(M128A setter);
            public native @ByRef M128A Xmm2(); public native CONTEXT Xmm2(M128A setter);
            public native @ByRef M128A Xmm3(); public native CONTEXT Xmm3(M128A setter);
            public native @ByRef M128A Xmm4(); public native CONTEXT Xmm4(M128A setter);
            public native @ByRef M128A Xmm5(); public native CONTEXT Xmm5(M128A setter);
            public native @ByRef M128A Xmm6(); public native CONTEXT Xmm6(M128A setter);
            public native @ByRef M128A Xmm7(); public native CONTEXT Xmm7(M128A setter);
            public native @ByRef M128A Xmm8(); public native CONTEXT Xmm8(M128A setter);
            public native @ByRef M128A Xmm9(); public native CONTEXT Xmm9(M128A setter);
            public native @ByRef M128A Xmm10(); public native CONTEXT Xmm10(M128A setter);
            public native @ByRef M128A Xmm11(); public native CONTEXT Xmm11(M128A setter);
            public native @ByRef M128A Xmm12(); public native CONTEXT Xmm12(M128A setter);
            public native @ByRef M128A Xmm13(); public native CONTEXT Xmm13(M128A setter);
            public native @ByRef M128A Xmm14(); public native CONTEXT Xmm14(M128A setter);
            public native @ByRef M128A Xmm15(); public native CONTEXT Xmm15(M128A setter);  

    //
    // Vector registers.
    //

    public native @ByRef M128A VectorRegister(int i); public native CONTEXT VectorRegister(int i, M128A setter);
    @MemberGetter public native M128A VectorRegister();
    public native @Cast("DWORD64") long VectorControl(); public native CONTEXT VectorControl(long setter);

    //
    // Special debug control registers.
    //

    public native @Cast("DWORD64") long DebugControl(); public native CONTEXT DebugControl(long setter);
    public native @Cast("DWORD64") long LastBranchToRip(); public native CONTEXT LastBranchToRip(long setter);
    public native @Cast("DWORD64") long LastBranchFromRip(); public native CONTEXT LastBranchFromRip(long setter);
    public native @Cast("DWORD64") long LastExceptionToRip(); public native CONTEXT LastExceptionToRip(long setter);
    public native @Cast("DWORD64") long LastExceptionFromRip(); public native CONTEXT LastExceptionFromRip(long setter);
}
