// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.systems.global;

import org.bytedeco.systems.macosx.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class macosx extends org.bytedeco.systems.presets.macosx {
    static { Loader.load(); }

// Parsed from cpuid.h

/*===---- cpuid.h - X86 cpu model detection --------------------------------===
 *
 * Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
 * See https://llvm.org/LICENSE.txt for license information.
 * SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
 *
 *===-----------------------------------------------------------------------===
 */

// #if !(__x86_64__ || __i386__)
// #error this header is for x86 only
// #endif

/* Responses identification request with %eax 0 */
/* AMD:     "AuthenticAMD" */
public static final int signature_AMD_ebx = 0x68747541;
public static final int signature_AMD_edx = 0x69746e65;
public static final int signature_AMD_ecx = 0x444d4163;
/* CENTAUR: "CentaurHauls" */
public static final int signature_CENTAUR_ebx = 0x746e6543;
public static final int signature_CENTAUR_edx = 0x48727561;
public static final int signature_CENTAUR_ecx = 0x736c7561;
/* CYRIX:   "CyrixInstead" */
public static final int signature_CYRIX_ebx = 0x69727943;
public static final int signature_CYRIX_edx = 0x736e4978;
public static final int signature_CYRIX_ecx = 0x64616574;
/* INTEL:   "GenuineIntel" */
public static final int signature_INTEL_ebx = 0x756e6547;
public static final int signature_INTEL_edx = 0x49656e69;
public static final int signature_INTEL_ecx = 0x6c65746e;
/* TM1:     "TransmetaCPU" */
public static final int signature_TM1_ebx = 0x6e617254;
public static final int signature_TM1_edx = 0x74656d73;
public static final int signature_TM1_ecx = 0x55504361;
/* TM2:     "GenuineTMx86" */
public static final int signature_TM2_ebx = 0x756e6547;
public static final int signature_TM2_edx = 0x54656e69;
public static final int signature_TM2_ecx = 0x3638784d;
/* NSC:     "Geode by NSC" */
public static final int signature_NSC_ebx = 0x646f6547;
public static final int signature_NSC_edx = 0x79622065;
public static final int signature_NSC_ecx = 0x43534e20;
/* NEXGEN:  "NexGenDriven" */
public static final int signature_NEXGEN_ebx = 0x4778654e;
public static final int signature_NEXGEN_edx = 0x72446e65;
public static final int signature_NEXGEN_ecx = 0x6e657669;
/* RISE:    "RiseRiseRise" */
public static final int signature_RISE_ebx = 0x65736952;
public static final int signature_RISE_edx = 0x65736952;
public static final int signature_RISE_ecx = 0x65736952;
/* SIS:     "SiS SiS SiS " */
public static final int signature_SIS_ebx = 0x20536953;
public static final int signature_SIS_edx = 0x20536953;
public static final int signature_SIS_ecx = 0x20536953;
/* UMC:     "UMC UMC UMC " */
public static final int signature_UMC_ebx = 0x20434d55;
public static final int signature_UMC_edx = 0x20434d55;
public static final int signature_UMC_ecx = 0x20434d55;
/* VIA:     "VIA VIA VIA " */
public static final int signature_VIA_ebx = 0x20414956;
public static final int signature_VIA_edx = 0x20414956;
public static final int signature_VIA_ecx = 0x20414956;
/* VORTEX:  "Vortex86 SoC" */
public static final int signature_VORTEX_ebx = 0x74726f56;
public static final int signature_VORTEX_edx = 0x36387865;
public static final int signature_VORTEX_ecx = 0x436f5320;

/* Features in %ecx for leaf 1 */
public static final int bit_SSE3 =        0x00000001;
public static final int bit_PCLMULQDQ =   0x00000002;
public static final int bit_PCLMUL =      bit_PCLMULQDQ;   /* for gcc compat */
public static final int bit_DTES64 =      0x00000004;
public static final int bit_MONITOR =     0x00000008;
public static final int bit_DSCPL =       0x00000010;
public static final int bit_VMX =         0x00000020;
public static final int bit_SMX =         0x00000040;
public static final int bit_EIST =        0x00000080;
public static final int bit_TM2 =         0x00000100;
public static final int bit_SSSE3 =       0x00000200;
public static final int bit_CNXTID =      0x00000400;
public static final int bit_FMA =         0x00001000;
public static final int bit_CMPXCHG16B =  0x00002000;
public static final int bit_xTPR =        0x00004000;
public static final int bit_PDCM =        0x00008000;
public static final int bit_PCID =        0x00020000;
public static final int bit_DCA =         0x00040000;
public static final int bit_SSE41 =       0x00080000;
public static final int bit_SSE4_1 =      bit_SSE41;       /* for gcc compat */
public static final int bit_SSE42 =       0x00100000;
public static final int bit_SSE4_2 =      bit_SSE42;       /* for gcc compat */
public static final int bit_x2APIC =      0x00200000;
public static final int bit_MOVBE =       0x00400000;
public static final int bit_POPCNT =      0x00800000;
public static final int bit_TSCDeadline = 0x01000000;
public static final int bit_AESNI =       0x02000000;
public static final int bit_AES =         bit_AESNI;       /* for gcc compat */
public static final int bit_XSAVE =       0x04000000;
public static final int bit_OSXSAVE =     0x08000000;
public static final int bit_AVX =         0x10000000;
public static final int bit_F16C =        0x20000000;
public static final int bit_RDRND =       0x40000000;

/* Features in %edx for leaf 1 */
public static final int bit_FPU =         0x00000001;
public static final int bit_VME =         0x00000002;
public static final int bit_DE =          0x00000004;
public static final int bit_PSE =         0x00000008;
public static final int bit_TSC =         0x00000010;
public static final int bit_MSR =         0x00000020;
public static final int bit_PAE =         0x00000040;
public static final int bit_MCE =         0x00000080;
public static final int bit_CX8 =         0x00000100;
public static final int bit_CMPXCHG8B =   bit_CX8;         /* for gcc compat */
public static final int bit_APIC =        0x00000200;
public static final int bit_SEP =         0x00000800;
public static final int bit_MTRR =        0x00001000;
public static final int bit_PGE =         0x00002000;
public static final int bit_MCA =         0x00004000;
public static final int bit_CMOV =        0x00008000;
public static final int bit_PAT =         0x00010000;
public static final int bit_PSE36 =       0x00020000;
public static final int bit_PSN =         0x00040000;
public static final int bit_CLFSH =       0x00080000;
public static final int bit_DS =          0x00200000;
public static final int bit_ACPI =        0x00400000;
public static final int bit_MMX =         0x00800000;
public static final int bit_FXSR =        0x01000000;
public static final int bit_FXSAVE =      bit_FXSR;        /* for gcc compat */
public static final int bit_SSE =         0x02000000;
public static final int bit_SSE2 =        0x04000000;
public static final int bit_SS =          0x08000000;
public static final int bit_HTT =         0x10000000;
public static final int bit_TM =          0x20000000;
public static final int bit_PBE =         0x80000000;

/* Features in %ebx for leaf 7 sub-leaf 0 */
public static final int bit_FSGSBASE =    0x00000001;
public static final int bit_SGX =         0x00000004;
public static final int bit_BMI =         0x00000008;
public static final int bit_HLE =         0x00000010;
public static final int bit_AVX2 =        0x00000020;
public static final int bit_SMEP =        0x00000080;
public static final int bit_BMI2 =        0x00000100;
public static final int bit_ENH_MOVSB =   0x00000200;
public static final int bit_INVPCID =     0x00000400;
public static final int bit_RTM =         0x00000800;
public static final int bit_MPX =         0x00004000;
public static final int bit_AVX512F =     0x00010000;
public static final int bit_AVX512DQ =    0x00020000;
public static final int bit_RDSEED =      0x00040000;
public static final int bit_ADX =         0x00080000;
public static final int bit_AVX512IFMA =  0x00200000;
public static final int bit_CLFLUSHOPT =  0x00800000;
public static final int bit_CLWB =        0x01000000;
public static final int bit_AVX512PF =    0x04000000;
public static final int bit_AVX512ER =    0x08000000;
public static final int bit_AVX512CD =    0x10000000;
public static final int bit_SHA =         0x20000000;
public static final int bit_AVX512BW =    0x40000000;
public static final int bit_AVX512VL =    0x80000000;

/* Features in %ecx for leaf 7 sub-leaf 0 */
public static final int bit_PREFTCHWT1 =       0x00000001;
public static final int bit_AVX512VBMI =       0x00000002;
public static final int bit_PKU =              0x00000004;
public static final int bit_OSPKE =            0x00000010;
public static final int bit_WAITPKG =          0x00000020;
public static final int bit_AVX512VBMI2 =      0x00000040;
public static final int bit_SHSTK =            0x00000080;
public static final int bit_GFNI =             0x00000100;
public static final int bit_VAES =             0x00000200;
public static final int bit_VPCLMULQDQ =       0x00000400;
public static final int bit_AVX512VNNI =       0x00000800;
public static final int bit_AVX512BITALG =     0x00001000;
public static final int bit_AVX512VPOPCNTDQ =  0x00004000;
public static final int bit_RDPID =            0x00400000;
public static final int bit_CLDEMOTE =         0x02000000;
public static final int bit_MOVDIRI =          0x08000000;
public static final int bit_MOVDIR64B =        0x10000000;
public static final int bit_ENQCMD =           0x20000000;

/* Features in %edx for leaf 7 sub-leaf 0 */
public static final int bit_AVX5124VNNIW =  0x00000004;
public static final int bit_AVX5124FMAPS =  0x00000008;
public static final int bit_PCONFIG =       0x00040000;
public static final int bit_IBT =           0x00100000;

/* Features in %eax for leaf 7 sub-leaf 1 */
public static final int bit_AVX512BF16 =    0x00000020;

/* Features in %eax for leaf 13 sub-leaf 1 */
public static final int bit_XSAVEOPT =    0x00000001;
public static final int bit_XSAVEC =      0x00000002;
public static final int bit_XSAVES =      0x00000008;

/* Features in %eax for leaf 0x14 sub-leaf 0 */
public static final int bit_PTWRITE =     0x00000010;

/* Features in %ecx for leaf 0x80000001 */
public static final int bit_LAHF_LM =     0x00000001;
public static final int bit_ABM =         0x00000020;
public static final int bit_LZCNT =       bit_ABM;        /* for gcc compat */
public static final int bit_SSE4a =       0x00000040;
public static final int bit_PRFCHW =      0x00000100;
public static final int bit_XOP =         0x00000800;
public static final int bit_LWP =         0x00008000;
public static final int bit_FMA4 =        0x00010000;
public static final int bit_TBM =         0x00200000;
public static final int bit_MWAITX =      0x20000000;

/* Features in %edx for leaf 0x80000001 */
public static final int bit_MMXEXT =      0x00400000;
public static final int bit_LM =          0x20000000;
public static final int bit_3DNOWP =      0x40000000;
public static final int bit_3DNOW =       0x80000000;

/* Features in %ebx for leaf 0x80000008 */
public static final int bit_CLZERO =      0x00000001;
public static final int bit_WBNOINVD =    0x00000200;


// #if __i386__
public static native void __cpuid(int __leaf, @ByRef IntPointer __eax, @ByRef IntPointer __ebx, @ByRef IntPointer __ecx, @ByRef IntPointer __edx);
public static native void __cpuid(int __leaf, @ByRef IntBuffer __eax, @ByRef IntBuffer __ebx, @ByRef IntBuffer __ecx, @ByRef IntBuffer __edx);
public static native void __cpuid(int __leaf, @ByRef int[] __eax, @ByRef int[] __ebx, @ByRef int[] __ecx, @ByRef int[] __edx);

public static native void __cpuid_count(int __leaf, int __count, @ByRef IntPointer __eax, @ByRef IntPointer __ebx, @ByRef IntPointer __ecx, @ByRef IntPointer __edx);
public static native void __cpuid_count(int __leaf, int __count, @ByRef IntBuffer __eax, @ByRef IntBuffer __ebx, @ByRef IntBuffer __ecx, @ByRef IntBuffer __edx);
public static native void __cpuid_count(int __leaf, int __count, @ByRef int[] __eax, @ByRef int[] __ebx, @ByRef int[] __ecx, @ByRef int[] __edx);
// #else
/* x86-64 uses %rbx as the base register, so preserve it. */
// #endif

public static native int __get_cpuid_max(@Cast("unsigned int") int __leaf, @Cast("unsigned int*") IntPointer __sig);
public static native int __get_cpuid_max(@Cast("unsigned int") int __leaf, @Cast("unsigned int*") IntBuffer __sig);
public static native int __get_cpuid_max(@Cast("unsigned int") int __leaf, @Cast("unsigned int*") int[] __sig);

public static native int __get_cpuid(@Cast("unsigned int") int __leaf, @Cast("unsigned int*") IntPointer __eax,
                                 @Cast("unsigned int*") IntPointer __ebx, @Cast("unsigned int*") IntPointer __ecx,
                                 @Cast("unsigned int*") IntPointer __edx);
public static native int __get_cpuid(@Cast("unsigned int") int __leaf, @Cast("unsigned int*") IntBuffer __eax,
                                 @Cast("unsigned int*") IntBuffer __ebx, @Cast("unsigned int*") IntBuffer __ecx,
                                 @Cast("unsigned int*") IntBuffer __edx);
public static native int __get_cpuid(@Cast("unsigned int") int __leaf, @Cast("unsigned int*") int[] __eax,
                                 @Cast("unsigned int*") int[] __ebx, @Cast("unsigned int*") int[] __ecx,
                                 @Cast("unsigned int*") int[] __edx);

public static native int __get_cpuid_count(@Cast("unsigned int") int __leaf,
                                       @Cast("unsigned int") int __subleaf,
                                       @Cast("unsigned int*") IntPointer __eax, @Cast("unsigned int*") IntPointer __ebx,
                                       @Cast("unsigned int*") IntPointer __ecx, @Cast("unsigned int*") IntPointer __edx);
public static native int __get_cpuid_count(@Cast("unsigned int") int __leaf,
                                       @Cast("unsigned int") int __subleaf,
                                       @Cast("unsigned int*") IntBuffer __eax, @Cast("unsigned int*") IntBuffer __ebx,
                                       @Cast("unsigned int*") IntBuffer __ecx, @Cast("unsigned int*") IntBuffer __edx);
public static native int __get_cpuid_count(@Cast("unsigned int") int __leaf,
                                       @Cast("unsigned int") int __subleaf,
                                       @Cast("unsigned int*") int[] __eax, @Cast("unsigned int*") int[] __ebx,
                                       @Cast("unsigned int*") int[] __ecx, @Cast("unsigned int*") int[] __edx);


// Parsed from dlfcn.h

/*
 * Copyright (c) 2004-2008 Apple Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */

/*
  Based on the dlcompat work done by:
		Jorge Acereda  <jacereda@users.sourceforge.net> &
		Peter O'Gorman <ogorman@users.sourceforge.net>
*/

// #ifndef _DLFCN_H_
// #define _DLFCN_H_

// #ifdef __cplusplus
// #endif

// #include <sys/cdefs.h>

// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
// #include <stdbool.h>
// #include <Availability.h>

// #ifdef __DRIVERKIT_19_0
//  #define __DYLDDL_DRIVERKIT_UNAVAILABLE __API_UNAVAILABLE(driverkit)
// #else
//  #define __DYLDDL_DRIVERKIT_UNAVAILABLE
// Targeting ../macosx/Dl_info.java



public static native int dladdr(@Const Pointer arg0, Dl_info arg1);
// #else
// #endif /* not POSIX */

public static native int dlclose(Pointer __handle);
public static native @Cast("char*") BytePointer dlerror();
public static native Pointer dlopen(@Cast("const char*") BytePointer __path, int __mode);
public static native Pointer dlopen(String __path, int __mode);
public static native Pointer dlsym(Pointer __handle, @Cast("const char*") BytePointer __symbol);
public static native Pointer dlsym(Pointer __handle, String __symbol);

// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static native @Cast("bool") boolean dlopen_preflight(@Cast("const char*") BytePointer __path);
public static native @Cast("bool") boolean dlopen_preflight(String __path);
// #endif /* not POSIX */


public static final int RTLD_LAZY =	0x1;
public static final int RTLD_NOW =	0x2;
public static final int RTLD_LOCAL =	0x4;
public static final int RTLD_GLOBAL =	0x8;

// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int RTLD_NOLOAD =	0x10;
public static final int RTLD_NODELETE =	0x80;
public static final int RTLD_FIRST =	0x100;	/* Mac OS X 10.5 and later */

/*
 * Special handle arguments for dlsym().
 */
public static native @MemberGetter Pointer RTLD_NEXT();
public static final Pointer RTLD_NEXT = RTLD_NEXT();	/* Search subsequent objects. */
public static native @MemberGetter Pointer RTLD_DEFAULT();
public static final Pointer RTLD_DEFAULT = RTLD_DEFAULT();	/* Use default search algorithm. */
public static native @MemberGetter Pointer RTLD_SELF();
public static final Pointer RTLD_SELF = RTLD_SELF();	/* Search this and subsequent objects (Mac OS X 10.5 and later) */
public static native @MemberGetter Pointer RTLD_MAIN_ONLY();
public static final Pointer RTLD_MAIN_ONLY = RTLD_MAIN_ONLY();	/* Search main executable only (Mac OS X 10.5 and later) */
// #endif /* not POSIX */

// #ifdef __cplusplus
// #endif

// #endif /* _DLFCN_H_ */


// Parsed from nl_types.h

/*	$NetBSD: nl_types.h,v 1.9 2000/10/03 19:53:32 sommerfeld Exp $	*/

/*-
 * Copyright (c) 1996 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by J.T. Conklin.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $FreeBSD: src/include/nl_types.h,v 1.11 2005/02/27 16:20:53 phantom Exp $
 */

// #ifndef _NL_TYPES_H_
// #define _NL_TYPES_H_

// #include <sys/cdefs.h>
// #include <sys/types.h>
// #include <_types.h>

// #ifdef _NLS_PRIVATE

// #endif	/* _NLS_PRIVATE */

public static final int NL_SETD =		1;
public static final int NL_CAT_LOCALE =	1;
// Targeting ../macosx/__nl_cat_d.java



// #include <_types/_nl_item.h>

public static native __nl_cat_d catopen(@Cast("const char*") BytePointer arg0, int arg1);
public static native __nl_cat_d catopen(String arg0, int arg1);
public static native @Cast("char*") BytePointer catgets(__nl_cat_d arg0, int arg1, int arg2, @Cast("const char*") BytePointer arg3);
public static native @Cast("char*") ByteBuffer catgets(__nl_cat_d arg0, int arg1, int arg2, String arg3);
public static native int catclose(__nl_cat_d arg0);
// #endif	/* _NL_TYPES_H_ */


// Parsed from _xlocale.h

/*
 * Copyright (c) 2005 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */

// #ifndef __XLOCALE_H_
// #define __XLOCALE_H_

// #include <sys/cdefs.h>
// Targeting ../macosx/_xlocale.java

 /* forward reference */

public static native int ___mb_cur_max();
public static native int ___mb_cur_max_l(_xlocale arg0);
// #endif /* __XLOCALE_H_ */


// Parsed from xlocale.h

/*
 * Copyright (c) 2005 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */

// #ifndef _XLOCALE_H_
// #define _XLOCALE_H_

// #include <sys/cdefs.h>

// #ifndef _USE_EXTENDED_LOCALES_
// #define _USE_EXTENDED_LOCALES_
// #endif /* _USE_EXTENDED_LOCALES_ */

// #include <_locale.h>
// #include <_xlocale.h>

public static native @MemberGetter int LC_ALL_MASK();
public static final int LC_ALL_MASK = LC_ALL_MASK();
public static final int LC_COLLATE_MASK =			(1 << 0);
public static final int LC_CTYPE_MASK =			(1 << 1);
public static final int LC_MESSAGES_MASK =		(1 << 2);
public static final int LC_MONETARY_MASK =		(1 << 3);
public static final int LC_NUMERIC_MASK =			(1 << 4);
public static final int LC_TIME_MASK =			(1 << 5);

public static final int _LC_NUM_MASK =			6;
public static final int _LC_LAST_MASK =			(1 << (_LC_NUM_MASK - 1));

public static native @MemberGetter _xlocale LC_GLOBAL_LOCALE();
public static final _xlocale LC_GLOBAL_LOCALE = LC_GLOBAL_LOCALE();
public static native @MemberGetter _xlocale LC_C_LOCALE();
public static final _xlocale LC_C_LOCALE = LC_C_LOCALE();

// #ifdef MB_CUR_MAX
// #undef MB_CUR_MAX
public static native @MemberGetter int MB_CUR_MAX();
public static final int MB_CUR_MAX = MB_CUR_MAX();
// #ifndef MB_CUR_MAX_L
// #define MB_CUR_MAX_L(x)			(___mb_cur_max_l(x))
// #endif /* !MB_CUR_MAX_L */
// #endif /* MB_CUR_MAX */

@MemberGetter public static native _xlocale _c_locale();

public static native _xlocale duplocale(_xlocale arg0);
public static native int freelocale(_xlocale arg0);
public static native lconv localeconv_l(_xlocale arg0);
public static native _xlocale newlocale(int arg0, @Cast("const char*") BytePointer arg1, _xlocale arg2);
public static native _xlocale newlocale(int arg0, String arg1, _xlocale arg2);
public static native @Cast("const char*") BytePointer querylocale(int arg0, _xlocale arg1);
public static native _xlocale uselocale(_xlocale arg0);
// #ifdef _CTYPE_H_
// #include <xlocale/_ctype.h>
// #endif /* _CTYPE_H_ */
// #ifdef __WCTYPE_H_
// #include <xlocale/__wctype.h>
// #endif /* __WCTYPE_H_ */
// #ifdef _INTTYPES_H_
// #include <xlocale/_inttypes.h>
// #endif /* _INTTYPES_H_ */
// #ifdef _LANGINFO_H_
// #include <xlocale/_langinfo.h>
// #endif /* _LANGINFO_H_ */
// #ifdef _MONETARY_H_
// #include <xlocale/_monetary.h>
// #endif /* _MONETARY_H_ */
// #ifdef _REGEX_H_
// #include <xlocale/_regex.h>
// #endif /* _REGEX_H_ */
// #ifdef _STDIO_H_
// #include <xlocale/_stdio.h>
// #endif /* _STDIO_H_ */
// #ifdef _STDLIB_H_
// #include <xlocale/_stdlib.h>
// #endif /* _STDLIB_H_ */
// #ifdef _STRING_H_
// #include <xlocale/_string.h>
// #endif /*STRING_CTYPE_H_ */
// #ifdef _TIME_H_
// #include <xlocale/_time.h>
// #endif /* _TIME_H_ */
// #ifdef _WCHAR_H_
// #include <xlocale/_wchar.h>
// #endif /*WCHAR_CTYPE_H_ */
// #ifdef _WCTYPE_H_
// #include <xlocale/_wctype.h>
// #endif /* _WCTYPE_H_ */

// #endif /* _XLOCALE_H_ */


// Parsed from _locale.h

/*
 * Copyright (c) 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)locale.h	8.1 (Berkeley) 6/2/93
 * $FreeBSD: /repoman/r/ncvs/src/include/locale.h,v 1.7 2002/10/09 09:19:27 tjr Exp $
 */

// #ifndef __LOCALE_H_
// #define __LOCALE_H_

// #include <sys/cdefs.h>
// #include <_types.h>
// Targeting ../macosx/lconv.java



// #include <sys/_types/_null.h>

public static native lconv localeconv();
// #endif /* __LOCALE_H_ */


// Parsed from langinfo.h

/*-
 * Copyright (c) 2001 Alexey Zelkin <phantom@FreeBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: /repoman/r/ncvs/src/include/langinfo.h,v 1.6 2002/09/18 05:54:25 mike Exp $
 */

// #ifndef _LANGINFO_H_
// #define	_LANGINFO_H_

// #include <_types.h>
// #include <_types/_nl_item.h>

public static final int CODESET =		0;	/* codeset name */
public static final int D_T_FMT =		1;	/* string for formatting date and time */
public static final int D_FMT =		2;	/* date format string */
public static final int T_FMT =		3;	/* time format string */
public static final int T_FMT_AMPM =	4;	/* a.m. or p.m. time formatting string */
public static final int AM_STR =		5;	/* Ante Meridian affix */
public static final int PM_STR =		6;	/* Post Meridian affix */

/* week day names */
public static final int DAY_1 =		7;
public static final int DAY_2 =		8;
public static final int DAY_3 =		9;
public static final int DAY_4 =		10;
public static final int DAY_5 =		11;
public static final int DAY_6 =		12;
public static final int DAY_7 =		13;

/* abbreviated week day names */
public static final int ABDAY_1 =		14;
public static final int ABDAY_2 =		15;
public static final int ABDAY_3 =		16;
public static final int ABDAY_4 =		17;
public static final int ABDAY_5 =		18;
public static final int ABDAY_6 =		19;
public static final int ABDAY_7 =		20;

/* month names */
public static final int MON_1 =		21;
public static final int MON_2 =		22;
public static final int MON_3 =		23;
public static final int MON_4 =		24;
public static final int MON_5 =		25;
public static final int MON_6 =		26;
public static final int MON_7 =		27;
public static final int MON_8 =		28;
public static final int MON_9 =		29;
public static final int MON_10 =		30;
public static final int MON_11 =		31;
public static final int MON_12 =		32;

/* abbreviated month names */
public static final int ABMON_1 =		33;
public static final int ABMON_2 =		34;
public static final int ABMON_3 =		35;
public static final int ABMON_4 =		36;
public static final int ABMON_5 =		37;
public static final int ABMON_6 =		38;
public static final int ABMON_7 =		39;
public static final int ABMON_8 =		40;
public static final int ABMON_9 =		41;
public static final int ABMON_10 =	42;
public static final int ABMON_11 =	43;
public static final int ABMON_12 =	44;

public static final int ERA =		45;	/* era description segments */
public static final int ERA_D_FMT =	46;	/* era date format string */
public static final int ERA_D_T_FMT =	47;	/* era date and time format string */
public static final int ERA_T_FMT =	48;	/* era time format string */
public static final int ALT_DIGITS =	49;	/* alternative symbols for digits */

public static final int RADIXCHAR =	50;	/* radix char */
public static final int THOUSEP =		51;	/* separator for thousands */

public static final int YESEXPR =		52;	/* affirmative response expression */
public static final int NOEXPR =		53;	/* negative response expression */

// #if (__DARWIN_C_LEVEL > __DARWIN_C_ANSI && __DARWIN_C_LEVEL < 200112L) || __DARWIN_C_LEVEL == __DARWIN_C_FULL
public static final int YESSTR =		54;	/* affirmative response for yes/no queries */
public static final int NOSTR =		55;	/* negative response for yes/no queries */
// #endif

public static final int CRNCYSTR =	56;	/* currency symbol */

// #if !defined(_ANSI_SOURCE) && (!defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE))
public static final int D_MD_ORDER =	57;	/* month/day order (local extension) */
// #endif

public static native @Cast("char*") BytePointer nl_langinfo(@Cast("nl_item") int arg0);
// #ifdef _USE_EXTENDED_LOCALES_
// #endif /* _USE_EXTENDED_LOCALES_ */

// #endif /* !_LANGINFO_H_ */


// Parsed from locale.h

/*
 * Copyright (c) 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)locale.h	8.1 (Berkeley) 6/2/93
 * $FreeBSD: /repoman/r/ncvs/src/include/locale.h,v 1.7 2002/10/09 09:19:27 tjr Exp $
 */

// #ifndef _LOCALE_H_
// #define _LOCALE_H_

// #include <_locale.h>

public static final int LC_ALL =		0;
public static final int LC_COLLATE =	1;
public static final int LC_CTYPE =	2;
public static final int LC_MONETARY =	3;
public static final int LC_NUMERIC =	4;
public static final int LC_TIME =		5;
public static final int LC_MESSAGES =	6;

public static final int _LC_LAST =	7;		/* marks end */

public static native @Cast("char*") BytePointer setlocale(int arg0, @Cast("const char*") BytePointer arg1);
public static native @Cast("char*") ByteBuffer setlocale(int arg0, String arg1);
// #endif /* _LOCALE_H_ */


// Parsed from sys/uio.h

/*
 * Copyright (c) 2000-2019 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
/* Copyright (c) 1995 NeXT Computer, Inc. All Rights Reserved */
/*
 * Copyright (c) 1982, 1986, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)uio.h	8.5 (Berkeley) 2/22/94
 */

// #ifndef _SYS_UIO_H_
// #define _SYS_UIO_H_

// #include <Availability.h>
// #include <sys/cdefs.h>
// #include <sys/_types.h>
// #include <sys/_types/_off_t.h>

/*
 * [XSI] The ssize_t and size_t types shall be defined as described
 * in <sys/types.h>.
 */
// #include <sys/_types/_size_t.h>
// #include <sys/_types/_ssize_t.h>

/*
 * [XSI] Structure whose address is passed as the second parameter to the
 * readv(), preadv(), writev() and pwritev() functions.
 */
// #include <sys/_types/_iovec_t.h>


// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
/*
 * IO direction for uio_t.
 *	UIO_READ - data moves into iovec(s) associated with uio_t
 *	UIO_WRITE - data moves out of iovec(s) associated with uio_t
 */
/** enum uio_rw */
public static final int UIO_READ = 0, UIO_WRITE = 1;
// #endif



public static native @Cast("ssize_t") long readv(int arg0, @Const iovec arg1, int arg2);
public static native @Cast("ssize_t") long writev(int arg0, @Const iovec arg1, int arg2);

// #if (!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE)) || defined(_DARWIN_C_SOURCE)

public static native @Cast("ssize_t") long preadv(int arg0, @Const iovec arg1, int arg2, @Cast("off_t") long arg3);
public static native @Cast("ssize_t") long pwritev(int arg0, @Const iovec arg1, int arg2, @Cast("off_t") long arg3);

// #endif /* #if (!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE)) || defined(_DARWIN_C_SOURCE) */

// #endif /* !_SYS_UIO_H_ */


// Parsed from sys/_types/_iovec_t.h

/*
 * Copyright (c) 2003-2012 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
// #ifndef _STRUCT_IOVEC
// #define _STRUCT_IOVEC
// #include <sys/_types/_size_t.h>
// Targeting ../macosx/iovec.java


// #endif /* _STRUCT_IOVEC */


// Parsed from sys/socket.h

/*
 * Copyright (c) 2000-2019 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
/* Copyright (c) 1998, 1999 Apple Computer, Inc. All Rights Reserved */
/* Copyright (c) 1995 NeXT Computer, Inc. All Rights Reserved */
/*
 * Copyright (c) 1982, 1985, 1986, 1988, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)socket.h	8.4 (Berkeley) 2/21/94
 * $FreeBSD: src/sys/sys/socket.h,v 1.39.2.7 2001/07/03 11:02:01 ume Exp $
 */
/*
 * NOTICE: This file was modified by SPARTA, Inc. in 2005 to introduce
 * support for mandatory and extensible security protections.  This notice
 * is included in support of clause 2.2 (b) of the Apple Public License,
 * Version 2.0.
 */

// #ifndef _SYS_SOCKET_H_
// #define _SYS_SOCKET_H_

// #include <sys/types.h>
// #include <sys/cdefs.h>
// #include <machine/_param.h>
// #include <net/net_kev.h>


// #include <Availability.h>

/*
 * Definitions related to sockets: types, address families, options.
 */

/*
 * Data types.
 */

// #include <sys/_types/_gid_t.h>
// #include <sys/_types/_off_t.h>
// #include <sys/_types/_pid_t.h>
// #include <sys/_types/_sa_family_t.h>
// #include <sys/_types/_socklen_t.h>

/* XXX Not explicitly defined by POSIX, but function return types are */
// #include <sys/_types/_size_t.h>

/* XXX Not explicitly defined by POSIX, but function return types are */
// #include <sys/_types/_ssize_t.h>

/*
 * [XSI] The iovec structure shall be defined as described in <sys/uio.h>.
 */
// #include <sys/_types/_iovec_t.h>

/*
 * Types
 */
public static final int SOCK_STREAM =     1;               /* stream socket */
public static final int SOCK_DGRAM =      2;               /* datagram socket */
public static final int SOCK_RAW =        3;               /* raw-protocol interface */
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int SOCK_RDM =        4;               /* reliably-delivered message */
// #endif  /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */
public static final int SOCK_SEQPACKET =  5;               /* sequenced packet stream */

/*
 * Option flags per-socket.
 */
public static final int SO_DEBUG =        0x0001;          /* turn on debugging info recording */
public static final int SO_ACCEPTCONN =   0x0002;          /* socket has had listen() */
public static final int SO_REUSEADDR =    0x0004;          /* allow local address reuse */
public static final int SO_KEEPALIVE =    0x0008;          /* keep connections alive */
public static final int SO_DONTROUTE =    0x0010;          /* just use interface addresses */
public static final int SO_BROADCAST =    0x0020;          /* permit sending of broadcast msgs */
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int SO_USELOOPBACK =  0x0040;          /* bypass hardware when possible */
public static final int SO_LINGER =       0x0080;          /* linger on close if data present (in ticks) */
// #else
// #endif  /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */
public static final int SO_OOBINLINE =    0x0100;          /* leave received OOB data in line */
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int SO_REUSEPORT =    0x0200;          /* allow local address & port reuse */
public static final int SO_TIMESTAMP =    0x0400;          /* timestamp received dgram traffic */
public static final int SO_TIMESTAMP_MONOTONIC =  0x0800;  /* Monotonically increasing timestamp on rcvd dgram */
// #ifndef __APPLE__
// #else
public static final int SO_DONTTRUNC =    0x2000;          /* APPLE: Retain unread data */
                                        /*  (ATOMIC proto) */
public static final int SO_WANTMORE =     0x4000;          /* APPLE: Give hint when more data ready */
public static final int SO_WANTOOBFLAG =  0x8000;          /* APPLE: Want OOB in MSG_FLAG on receive */


// #endif  /* (!__APPLE__) */
// #endif  /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */

/*
 * Additional options, not kept in so_options.
 */
public static final int SO_SNDBUF =       0x1001;          /* send buffer size */
public static final int SO_RCVBUF =       0x1002;          /* receive buffer size */
public static final int SO_SNDLOWAT =     0x1003;          /* send low-water mark */
public static final int SO_RCVLOWAT =     0x1004;          /* receive low-water mark */
public static final int SO_SNDTIMEO =     0x1005;          /* send timeout */
public static final int SO_RCVTIMEO =     0x1006;          /* receive timeout */
public static final int SO_ERROR =        0x1007;          /* get error status and clear */
public static final int SO_TYPE =         0x1008;          /* get socket type */
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int SO_LABEL =        0x1010;          /* deprecated */
public static final int SO_PEERLABEL =    0x1011;          /* deprecated */
// #ifdef __APPLE__
public static final int SO_NREAD =        0x1020;          /* APPLE: get 1st-packet byte count */
public static final int SO_NKE =          0x1021;          /* APPLE: Install socket-level NKE */
public static final int SO_NOSIGPIPE =    0x1022;          /* APPLE: No SIGPIPE on EPIPE */
public static final int SO_NOADDRERR =    0x1023;          /* APPLE: Returns EADDRNOTAVAIL when src is not available anymore */
public static final int SO_NWRITE =       0x1024;          /* APPLE: Get number of bytes currently in send socket buffer */
public static final int SO_REUSESHAREUID =        0x1025;          /* APPLE: Allow reuse of port/socket by different userids */
// #ifdef __APPLE_API_PRIVATE
public static final int SO_NOTIFYCONFLICT =       0x1026;  /* APPLE: send notification if there is a bind on a port which is already in use */
public static final int SO_UPCALLCLOSEWAIT =      0x1027;  /* APPLE: block on close until an upcall returns */
// #endif
public static final int SO_LINGER_SEC =   0x1080;          /* linger on close if data present (in seconds) */
public static final int SO_RANDOMPORT =   0x1082;  /* APPLE: request local port randomization */
public static final int SO_NP_EXTENSIONS =        0x1083;  /* To turn off some POSIX behavior */
// #endif

public static final int SO_NUMRCVPKT =            0x1112;  /* number of datagrams in receive socket buffer */
public static final int SO_NET_SERVICE_TYPE =     0x1116;  /* Network service type */


public static final int SO_NETSVC_MARKING_LEVEL =    0x1119;  /* Get QoS marking in effect for socket */

/*
 * Network Service Type for option SO_NET_SERVICE_TYPE
 *
 * The vast majority of sockets should use Best Effort that is the default
 * Network Service Type. Other Network Service Types have to be used only if
 * the traffic actually matches the description of the Network Service Type.
 *
 * Network Service Types do not represent priorities but rather describe
 * different categories of delay, jitter and loss parameters.
 * Those parameters may influence protocols from layer 4 protocols like TCP
 * to layer 2 protocols like Wi-Fi. The Network Service Type can determine
 * how the traffic is queued and scheduled by the host networking stack and
 * by other entities on the network like switches and routers. For example
 * for Wi-Fi, the Network Service Type can select the marking of the
 * layer 2 packet with the appropriate WMM Access Category.
 *
 * There is no point in attempting to game the system and use
 * a Network Service Type that does not correspond to the actual
 * traffic characteristic but one that seems to have a higher precedence.
 * The reason is that for service classes that have lower tolerance
 * for delay and jitter, the queues size is lower than for service
 * classes that are more tolerant to delay and jitter.
 *
 * For example using a voice service type for bulk data transfer will lead
 * to disastrous results as soon as congestion happens because the voice
 * queue overflows and packets get dropped. This is not only bad for the bulk
 * data transfer but it is also bad for VoIP apps that legitimately are using
 * the voice  service type.
 *
 * The characteristics of the Network Service Types are based on the service
 * classes defined in RFC 4594 "Configuration Guidelines for DiffServ Service
 * Classes"
 *
 * When system detects the outgoing interface belongs to a DiffServ domain
 * that follows the recommendation of the IETF draft "Guidelines for DiffServ to
 * IEEE 802.11 Mapping", the packet will marked at layer 3 with a DSCP value
 * that corresponds to Network Service Type.
 *
 * NET_SERVICE_TYPE_BE
 *	"Best Effort", unclassified/standard.  This is the default service
 *	class and cover the majority of the traffic.
 *
 * NET_SERVICE_TYPE_BK
 *	"Background", high delay tolerant, loss tolerant. elastic flow,
 *	variable size & long-lived. E.g: non-interactive network bulk transfer
 *	like synching or backup.
 *
 * NET_SERVICE_TYPE_RD
 *	"Responsive Data", a notch higher than "Best Effort", medium delay
 *	tolerant, elastic & inelastic flow, bursty, long-lived. E.g. email,
 *	instant messaging, for which there is a sense of interactivity and
 *	urgency (user waiting for output).
 *
 * NET_SERVICE_TYPE_OAM
 *	"Operations, Administration, and Management", medium delay tolerant,
 *	low-medium loss tolerant, elastic & inelastic flows, variable size.
 *	E.g. VPN tunnels.
 *
 * NET_SERVICE_TYPE_AV
 *	"Multimedia Audio/Video Streaming", medium delay tolerant, low-medium
 *	loss tolerant, elastic flow, constant packet interval, variable rate
 *	and size. E.g. video and audio playback with buffering.
 *
 * NET_SERVICE_TYPE_RV
 *	"Responsive Multimedia Audio/Video", low delay tolerant, low-medium
 *	loss tolerant, elastic flow, variable packet interval, rate and size.
 *	E.g. screen sharing.
 *
 * NET_SERVICE_TYPE_VI
 *	"Interactive Video", low delay tolerant, low-medium loss tolerant,
 *	elastic flow, constant packet interval, variable rate & size. E.g.
 *	video telephony.
 *
 * NET_SERVICE_TYPE_SIG
 *	"Signaling", low delay tolerant, low loss tolerant, inelastic flow,
 *	jitter tolerant, rate is bursty but short, variable size. E.g. SIP.
 *
 * NET_SERVICE_TYPE_VO
 *	"Interactive Voice", very low delay tolerant, very low loss tolerant,
 *	inelastic flow, constant packet rate, somewhat fixed size.
 *	E.g. VoIP.
 */

public static final int NET_SERVICE_TYPE_BE =     0; /* Best effort */
public static final int NET_SERVICE_TYPE_BK =     1; /* Background system initiated */
public static final int NET_SERVICE_TYPE_SIG =    2; /* Signaling */
public static final int NET_SERVICE_TYPE_VI =     3; /* Interactive Video */
public static final int NET_SERVICE_TYPE_VO =     4; /* Interactive Voice */
public static final int NET_SERVICE_TYPE_RV =     5; /* Responsive Multimedia Audio/Video */
public static final int NET_SERVICE_TYPE_AV =     6; /* Multimedia Audio/Video Streaming */
public static final int NET_SERVICE_TYPE_OAM =    7; /* Operations, Administration, and Management */
public static final int NET_SERVICE_TYPE_RD =     8; /* Responsive Data */


/* These are supported values for SO_NETSVC_MARKING_LEVEL */
public static final int NETSVC_MRKNG_UNKNOWN =            0;       /* The outgoing network interface is not known */
public static final int NETSVC_MRKNG_LVL_L2 =             1;       /* Default marking at layer 2 (for example Wi-Fi WMM) */
public static final int NETSVC_MRKNG_LVL_L3L2_ALL =       2;       /* Layer 3 DSCP marking and layer 2 marking for all Network Service Types */
public static final int NETSVC_MRKNG_LVL_L3L2_BK =        3;       /* The system policy limits layer 3 DSCP marking and layer 2 marking
	                                         * to background Network Service Types */
public static native @MemberGetter long SAE_ASSOCID_ANY();
public static final long SAE_ASSOCID_ANY = SAE_ASSOCID_ANY();
public static native @MemberGetter long SAE_ASSOCID_ALL();
public static final long SAE_ASSOCID_ALL = SAE_ASSOCID_ALL();
public static native @MemberGetter long SAE_CONNID_ANY();
public static final long SAE_CONNID_ANY = SAE_CONNID_ANY();
public static native @MemberGetter long SAE_CONNID_ALL();
public static final long SAE_CONNID_ALL = SAE_CONNID_ALL();

/* connectx() flag parameters */
public static final int CONNECT_RESUME_ON_READ_WRITE =    0x1; /* resume connect() on read/write */
public static final int CONNECT_DATA_IDEMPOTENT =         0x2; /* data is idempotent */
public static final int CONNECT_DATA_AUTHENTICATED =      0x4;
// Targeting ../macosx/sa_endpoints_t.java


// Targeting ../macosx/linger.java


// Targeting ../macosx/so_np_extensions.java



public static final int SONPX_SETOPTSHUT =        0x000000001;     /* flag for allowing setsockopt after shutdown */



// #endif
// #endif

/*
 * Level number for (get/set)sockopt() to apply to socket itself.
 */
public static final int SOL_SOCKET =      0xffff;          /* options for socket level */


/*
 * Address families.
 */
public static final int AF_UNSPEC =       0;               /* unspecified */
public static final int AF_UNIX =         1;               /* local to host (pipes) */
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int AF_LOCAL =        AF_UNIX;         /* backward compatibility */
// #endif  /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */
public static final int AF_INET =         2;               /* internetwork: UDP, TCP, etc. */
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int AF_IMPLINK =      3;               /* arpanet imp addresses */
public static final int AF_PUP =          4;               /* pup protocols: e.g. BSP */
public static final int AF_CHAOS =        5;               /* mit CHAOS protocols */
public static final int AF_NS =           6;               /* XEROX NS protocols */
public static final int AF_ISO =          7;               /* ISO protocols */
public static final int AF_OSI =          AF_ISO;
public static final int AF_ECMA =         8;               /* European computer manufacturers */
public static final int AF_DATAKIT =      9;               /* datakit protocols */
public static final int AF_CCITT =        10;              /* CCITT protocols, X.25 etc */
public static final int AF_SNA =          11;              /* IBM SNA */
public static final int AF_DECnet =       12;              /* DECnet */
public static final int AF_DLI =          13;              /* DEC Direct data link interface */
public static final int AF_LAT =          14;              /* LAT */
public static final int AF_HYLINK =       15;              /* NSC Hyperchannel */
public static final int AF_APPLETALK =    16;              /* Apple Talk */
public static final int AF_ROUTE =        17;              /* Internal Routing Protocol */
public static final int AF_LINK =         18;              /* Link layer interface */
public static final int pseudo_AF_XTP =   19;              /* eXpress Transfer Protocol (no AF) */
public static final int AF_COIP =         20;              /* connection-oriented IP, aka ST II */
public static final int AF_CNT =          21;              /* Computer Network Technology */
public static final int pseudo_AF_RTIP =  22;              /* Help Identify RTIP packets */
public static final int AF_IPX =          23;              /* Novell Internet Protocol */
public static final int AF_SIP =          24;              /* Simple Internet Protocol */
public static final int pseudo_AF_PIP =   25;              /* Help Identify PIP packets */
public static final int AF_NDRV =         27;              /* Network Driver 'raw' access */
public static final int AF_ISDN =         28;              /* Integrated Services Digital Network */
public static final int AF_E164 =         AF_ISDN;         /* CCITT E.164 recommendation */
public static final int pseudo_AF_KEY =   29;              /* Internal key-management function */
// #endif  /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */
public static final int AF_INET6 =        30;              /* IPv6 */
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int AF_NATM =         31;              /* native ATM access */
public static final int AF_SYSTEM =       32;              /* Kernel event messages */
public static final int AF_NETBIOS =      33;              /* NetBIOS */
public static final int AF_PPP =          34;              /* PPP communication protocol */
public static final int pseudo_AF_HDRCMPLT = 35;           /* Used by BPF to not rewrite headers
	                                 *  in interface output routine */
public static final int AF_RESERVED_36 =  36;              /* Reserved for internal usage */
public static final int AF_IEEE80211 =    37;              /* IEEE 802.11 protocol */
public static final int AF_UTUN =         38;
public static final int AF_VSOCK =        40;              /* VM Sockets */
public static final int AF_MAX =          41;
// Targeting ../macosx/sockaddr.java



// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int SOCK_MAXADDRLEN = 255;
// Targeting ../macosx/sockproto.java


// #endif  /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */

/*
 * RFC 2553: protocol-independent placeholder for socket addresses
 */
public static final int _SS_MAXSIZE =     128;
public static native @MemberGetter int _SS_ALIGNSIZE();
public static final int _SS_ALIGNSIZE = _SS_ALIGNSIZE();
public static native @MemberGetter int _SS_PAD1SIZE();
public static final int _SS_PAD1SIZE = _SS_PAD1SIZE();
public static native @MemberGetter int _SS_PAD2SIZE();
public static final int _SS_PAD2SIZE = _SS_PAD2SIZE();
// Targeting ../macosx/sockaddr_storage.java



/*
 * Protocol families, same as address families for now.
 */
public static final int PF_UNSPEC =       AF_UNSPEC;
public static final int PF_LOCAL =        AF_LOCAL;
public static final int PF_UNIX =         PF_LOCAL;        /* backward compatibility */
public static final int PF_INET =         AF_INET;
public static final int PF_IMPLINK =      AF_IMPLINK;
public static final int PF_PUP =          AF_PUP;
public static final int PF_CHAOS =        AF_CHAOS;
public static final int PF_NS =           AF_NS;
public static final int PF_ISO =          AF_ISO;
public static final int PF_OSI =          AF_ISO;
public static final int PF_ECMA =         AF_ECMA;
public static final int PF_DATAKIT =      AF_DATAKIT;
public static final int PF_CCITT =        AF_CCITT;
public static final int PF_SNA =          AF_SNA;
public static final int PF_DECnet =       AF_DECnet;
public static final int PF_DLI =          AF_DLI;
public static final int PF_LAT =          AF_LAT;
public static final int PF_HYLINK =       AF_HYLINK;
public static final int PF_APPLETALK =    AF_APPLETALK;
public static final int PF_ROUTE =        AF_ROUTE;
public static final int PF_LINK =         AF_LINK;
public static final int PF_XTP =          pseudo_AF_XTP;   /* really just proto family, no AF */
public static final int PF_COIP =         AF_COIP;
public static final int PF_CNT =          AF_CNT;
public static final int PF_SIP =          AF_SIP;
public static final int PF_IPX =          AF_IPX;          /* same format as AF_NS */
public static final int PF_RTIP =         pseudo_AF_RTIP;  /* same format as AF_INET */
public static final int PF_PIP =          pseudo_AF_PIP;
public static final int PF_NDRV =         AF_NDRV;
public static final int PF_ISDN =         AF_ISDN;
public static final int PF_KEY =          pseudo_AF_KEY;
public static final int PF_INET6 =        AF_INET6;
public static final int PF_NATM =         AF_NATM;
public static final int PF_SYSTEM =       AF_SYSTEM;
public static final int PF_NETBIOS =      AF_NETBIOS;
public static final int PF_PPP =          AF_PPP;
public static final int PF_RESERVED_36 =  AF_RESERVED_36;
public static final int PF_UTUN =         AF_UTUN;
public static final int PF_VSOCK =        AF_VSOCK;
public static final int PF_MAX =          AF_MAX;

/*
 * These do not have socket-layer support:
 */
public static native @MemberGetter int PF_VLAN();
public static final int PF_VLAN = PF_VLAN();  /* 'vlan' */
public static native @MemberGetter int PF_BOND();
public static final int PF_BOND = PF_BOND();  /* 'bond' */

/*
 * Definitions for network related sysctl, CTL_NET.
 *
 * Second level is protocol family.
 * Third level is protocol number.
 *
 * Further levels are defined by the individual families below.
 */
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int NET_MAXID =       AF_MAX;
// #endif /* (_POSIX_C_SOURCE && !_DARWIN_C_SOURCE) */


// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
/*
 * PF_ROUTE - Routing table
 *
 * Three additional levels are defined:
 *	Fourth: address family, 0 is wildcard
 *	Fifth: type of info, defined below
 *	Sixth: flag(s) to mask with for NET_RT_FLAGS
 */
public static final int NET_RT_DUMP =             1;       /* dump; may limit to a.f. */
public static final int NET_RT_FLAGS =            2;       /* by flags, e.g. RESOLVING */
public static final int NET_RT_IFLIST =           3;       /* survey interface list */
public static final int NET_RT_STAT =             4;       /* routing statistics */
public static final int NET_RT_TRASH =            5;       /* routes not in table but not freed */
public static final int NET_RT_IFLIST2 =          6;       /* interface list with addresses */
public static final int NET_RT_DUMP2 =            7;       /* dump; may limit to a.f. */
/*
 * Allows read access non-local host's MAC address
 * if the process has neighbor cache entitlement.
 */
public static final int NET_RT_FLAGS_PRIV =       10;
public static final int NET_RT_MAXID =            11;
// #endif /* (_POSIX_C_SOURCE && !_DARWIN_C_SOURCE) */




/*
 * Maximum queue length specifiable by listen.
 */
public static final int SOMAXCONN =       128;
// Targeting ../macosx/msghdr.java





public static final int MSG_OOB =         0x1;             /* process out-of-band data */
public static final int MSG_PEEK =        0x2;             /* peek at incoming message */
public static final int MSG_DONTROUTE =   0x4;             /* send without using routing tables */
public static final int MSG_EOR =         0x8;             /* data completes record */
public static final int MSG_TRUNC =       0x10;            /* data discarded before delivery */
public static final int MSG_CTRUNC =      0x20;            /* control data lost before delivery */
public static final int MSG_WAITALL =     0x40;            /* wait for full request or error */
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int MSG_DONTWAIT =    0x80;            /* this message should be nonblocking */
public static final int MSG_EOF =         0x100;           /* data completes connection */
// #ifdef __APPLE__
// #ifdef __APPLE_API_OBSOLETE
public static final int MSG_WAITSTREAM =  0x200;           /* wait up to full request.. may return partial */
// #endif
public static final int MSG_FLUSH =       0x400;           /* Start of 'hold' seq; dump so_temp, deprecated */
public static final int MSG_HOLD =        0x800;           /* Hold frag in so_temp, deprecated */
public static final int MSG_SEND =        0x1000;          /* Send the packet in so_temp, deprecated */
public static final int MSG_HAVEMORE =    0x2000;          /* Data ready to be read */
public static final int MSG_RCVMORE =     0x4000;          /* Data remains in current pkt */
// #endif
public static final int MSG_NEEDSA =      0x10000;         /* Fail receive if socket address cannot be allocated */
// #endif  /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */

// #if __DARWIN_C_LEVEL >= 200809L
public static final int MSG_NOSIGNAL =    0x80000;
// Targeting ../macosx/cmsghdr.java



// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
// #ifndef __APPLE__
// #endif
// #endif  /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */

/* given pointer to struct cmsghdr, return pointer to data */
// #define CMSG_DATA(cmsg)         ((unsigned char *)(cmsg) +
// 	__DARWIN_ALIGN32(sizeof(struct cmsghdr)))

/*
 * RFC 2292 requires to check msg_controllen, in case that the kernel returns
 * an empty list for some reasons.
 */
// #define CMSG_FIRSTHDR(mhdr)
// 	((mhdr)->msg_controllen >= sizeof(struct cmsghdr) ?
// 	    (struct cmsghdr *)(mhdr)->msg_control :
// 	    (struct cmsghdr *)0L)


/*
 * Given pointer to struct cmsghdr, return pointer to next cmsghdr
 * RFC 2292 says that CMSG_NXTHDR(mhdr, NULL) is equivalent to CMSG_FIRSTHDR(mhdr)
 */
// #define CMSG_NXTHDR(mhdr, cmsg)
// 	((char *)(cmsg) == (char *)0L ? CMSG_FIRSTHDR(mhdr) :
// 	    ((((unsigned char *)(cmsg) +
// 	    __DARWIN_ALIGN32((__uint32_t)(cmsg)->cmsg_len) +
// 	    __DARWIN_ALIGN32(sizeof(struct cmsghdr))) >
// 	    ((unsigned char *)(mhdr)->msg_control +
// 	    (mhdr)->msg_controllen)) ?
// 	        (struct cmsghdr *)0L /* NULL */ :
// 	        (struct cmsghdr *)(void *)((unsigned char *)(cmsg) +
// 	            __DARWIN_ALIGN32((__uint32_t)(cmsg)->cmsg_len))))

// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
/* RFC 2292 additions */
// #define CMSG_SPACE(l)           (__DARWIN_ALIGN32(sizeof(struct cmsghdr)) + __DARWIN_ALIGN32(l))
// #define CMSG_LEN(l)             (__DARWIN_ALIGN32(sizeof(struct cmsghdr)) + (l))

// #endif  /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */

/* "Socket"-level control message types: */
public static final int SCM_RIGHTS =                      0x01;    /* access rights (array of int) */
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int SCM_TIMESTAMP =                   0x02;    /* timestamp (struct timeval) */
public static final int SCM_CREDS =                       0x03;    /* process creds (struct cmsgcred) */
public static final int SCM_TIMESTAMP_MONOTONIC =         0x04;    /* timestamp (uint64_t) */


// #endif  /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */

/*
 * howto arguments for shutdown(2), specified by Posix.1g.
 */
public static final int SHUT_RD =         0;               /* shut down the reading side */
public static final int SHUT_WR =         1;               /* shut down the writing side */
public static final int SHUT_RDWR =       2;
// Targeting ../macosx/sf_hdtr.java




// #endif  /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */


public static native int accept(int arg0, sockaddr arg1, @Cast("socklen_t*") IntPointer arg2);
public static native int accept(int arg0, sockaddr arg1, @Cast("socklen_t*") IntBuffer arg2);
public static native int accept(int arg0, sockaddr arg1, @Cast("socklen_t*") int[] arg2);
public static native int bind(int arg0, @Const sockaddr arg1, @Cast("socklen_t") int arg2);
public static native int connect(int arg0, @Const sockaddr arg1, @Cast("socklen_t") int arg2);
public static native int getpeername(int arg0, sockaddr arg1, @Cast("socklen_t*") IntPointer arg2);
public static native int getpeername(int arg0, sockaddr arg1, @Cast("socklen_t*") IntBuffer arg2);
public static native int getpeername(int arg0, sockaddr arg1, @Cast("socklen_t*") int[] arg2);
public static native int getsockname(int arg0, sockaddr arg1, @Cast("socklen_t*") IntPointer arg2);
public static native int getsockname(int arg0, sockaddr arg1, @Cast("socklen_t*") IntBuffer arg2);
public static native int getsockname(int arg0, sockaddr arg1, @Cast("socklen_t*") int[] arg2);
public static native int getsockopt(int arg0, int arg1, int arg2, Pointer arg3, @Cast("socklen_t*") IntPointer arg4);
public static native int getsockopt(int arg0, int arg1, int arg2, Pointer arg3, @Cast("socklen_t*") IntBuffer arg4);
public static native int getsockopt(int arg0, int arg1, int arg2, Pointer arg3, @Cast("socklen_t*") int[] arg4);
public static native int listen(int arg0, int arg1);
public static native @Cast("ssize_t") long recv(int arg0, Pointer arg1, @Cast("size_t") long arg2, int arg3);
public static native @Cast("ssize_t") long recvfrom(int arg0, Pointer arg1, @Cast("size_t") long arg2, int arg3, sockaddr arg4,
    @Cast("socklen_t*") IntPointer arg5);
public static native @Cast("ssize_t") long recvfrom(int arg0, Pointer arg1, @Cast("size_t") long arg2, int arg3, sockaddr arg4,
    @Cast("socklen_t*") IntBuffer arg5);
public static native @Cast("ssize_t") long recvfrom(int arg0, Pointer arg1, @Cast("size_t") long arg2, int arg3, sockaddr arg4,
    @Cast("socklen_t*") int[] arg5);
public static native @Cast("ssize_t") long recvmsg(int arg0, msghdr arg1, int arg2);
public static native @Cast("ssize_t") long send(int arg0, @Const Pointer arg1, @Cast("size_t") long arg2, int arg3);
public static native @Cast("ssize_t") long sendmsg(int arg0, @Const msghdr arg1, int arg2);
public static native @Cast("ssize_t") long sendto(int arg0, @Const Pointer arg1, @Cast("size_t") long arg2,
    int arg3, @Const sockaddr arg4, @Cast("socklen_t") int arg5);
public static native int setsockopt(int arg0, int arg1, int arg2, @Const Pointer arg3, @Cast("socklen_t") int arg4);
public static native int shutdown(int arg0, int arg1);
public static native int sockatmark(int arg0);
public static native int socket(int arg0, int arg1, int arg2);
public static native int socketpair(int arg0, int arg1, int arg2, IntPointer arg3);
public static native int socketpair(int arg0, int arg1, int arg2, IntBuffer arg3);
public static native int socketpair(int arg0, int arg1, int arg2, int[] arg3);

// #if !defined(_POSIX_C_SOURCE)
public static native int sendfile(int arg0, int arg1, @Cast("off_t") long arg2, @Cast("off_t*") LongPointer arg3, sf_hdtr arg4, int arg5);
public static native int sendfile(int arg0, int arg1, @Cast("off_t") long arg2, @Cast("off_t*") LongBuffer arg3, sf_hdtr arg4, int arg5);
public static native int sendfile(int arg0, int arg1, @Cast("off_t") long arg2, @Cast("off_t*") long[] arg3, sf_hdtr arg4, int arg5);
// #endif  /* !_POSIX_C_SOURCE */

// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static native void pfctlinput(int arg0, sockaddr arg1);




// #endif  /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */
// #endif /* !_SYS_SOCKET_H_ */


// Parsed from sys/errno.h

/*
 * Copyright (c) 2000-2012 Apple, Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
/* Copyright (c) 1995 NeXT Computer, Inc. All Rights Reserved */
/*
 * Copyright (c) 1982, 1986, 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)errno.h	8.5 (Berkeley) 1/21/94
 */

// #ifndef _SYS_ERRNO_H_
// #define _SYS_ERRNO_H_

// #include <sys/cdefs.h>


// #if defined(__STDC_WANT_LIB_EXT1__) && __STDC_WANT_LIB_EXT1__ >= 1
// #include <sys/_types/_errno_t.h>
// #endif

public static native IntPointer __error();
public static native @MemberGetter int errno();
public static final int errno = errno();
/*
 * Error codes
 */

public static final int EPERM =           1;               /* Operation not permitted */
public static final int ENOENT =          2;               /* No such file or directory */
public static final int ESRCH =           3;               /* No such process */
public static final int EINTR =           4;               /* Interrupted system call */
public static final int EIO =             5;               /* Input/output error */
public static final int ENXIO =           6;               /* Device not configured */
public static final int E2BIG =           7;               /* Argument list too long */
public static final int ENOEXEC =         8;               /* Exec format error */
public static final int EBADF =           9;               /* Bad file descriptor */
public static final int ECHILD =          10;              /* No child processes */
public static final int EDEADLK =         11;              /* Resource deadlock avoided */
                                        /* 11 was EAGAIN */
public static final int ENOMEM =          12;              /* Cannot allocate memory */
public static final int EACCES =          13;              /* Permission denied */
public static final int EFAULT =          14;              /* Bad address */
// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static final int ENOTBLK =         15;              /* Block device required */
// #endif
public static final int EBUSY =           16;              /* Device / Resource busy */
public static final int EEXIST =          17;              /* File exists */
public static final int EXDEV =           18;              /* Cross-device link */
public static final int ENODEV =          19;              /* Operation not supported by device */
public static final int ENOTDIR =         20;              /* Not a directory */
public static final int EISDIR =          21;              /* Is a directory */
public static final int EINVAL =          22;              /* Invalid argument */
public static final int ENFILE =          23;              /* Too many open files in system */
public static final int EMFILE =          24;              /* Too many open files */
public static final int ENOTTY =          25;              /* Inappropriate ioctl for device */
public static final int ETXTBSY =         26;              /* Text file busy */
public static final int EFBIG =           27;              /* File too large */
public static final int ENOSPC =          28;              /* No space left on device */
public static final int ESPIPE =          29;              /* Illegal seek */
public static final int EROFS =           30;              /* Read-only file system */
public static final int EMLINK =          31;              /* Too many links */
public static final int EPIPE =           32;              /* Broken pipe */

/* math software */
public static final int EDOM =            33;              /* Numerical argument out of domain */
public static final int ERANGE =          34;              /* Result too large */

/* non-blocking and interrupt i/o */
public static final int EAGAIN =          35;              /* Resource temporarily unavailable */
public static final int EWOULDBLOCK =     EAGAIN;          /* Operation would block */
public static final int EINPROGRESS =     36;              /* Operation now in progress */
public static final int EALREADY =        37;              /* Operation already in progress */

/* ipc/network software -- argument errors */
public static final int ENOTSOCK =        38;              /* Socket operation on non-socket */
public static final int EDESTADDRREQ =    39;              /* Destination address required */
public static final int EMSGSIZE =        40;              /* Message too long */
public static final int EPROTOTYPE =      41;              /* Protocol wrong type for socket */
public static final int ENOPROTOOPT =     42;              /* Protocol not available */
public static final int EPROTONOSUPPORT = 43;              /* Protocol not supported */
// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static final int ESOCKTNOSUPPORT = 44;              /* Socket type not supported */
// #endif
public static final int ENOTSUP =         45;              /* Operation not supported */
// #if !__DARWIN_UNIX03 && !defined(KERNEL)
/*
 * This is the same for binary and source copmpatability, unless compiling
 * the kernel itself, or compiling __DARWIN_UNIX03; if compiling for the
 * kernel, the correct value will be returned.  If compiling non-POSIX
 * source, the kernel return value will be converted by a stub in libc, and
 * if compiling source with __DARWIN_UNIX03, the conversion in libc is not
 * done, and the caller gets the expected (discrete) value.
 */
public static final int EOPNOTSUPP =       ENOTSUP;        /* Operation not supported on socket */
// #endif /* !__DARWIN_UNIX03 && !KERNEL */

// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static final int EPFNOSUPPORT =    46;              /* Protocol family not supported */
// #endif
public static final int EAFNOSUPPORT =    47;              /* Address family not supported by protocol family */
public static final int EADDRINUSE =      48;              /* Address already in use */
public static final int EADDRNOTAVAIL =   49;              /* Can't assign requested address */

/* ipc/network software -- operational errors */
public static final int ENETDOWN =        50;              /* Network is down */
public static final int ENETUNREACH =     51;              /* Network is unreachable */
public static final int ENETRESET =       52;              /* Network dropped connection on reset */
public static final int ECONNABORTED =    53;              /* Software caused connection abort */
public static final int ECONNRESET =      54;              /* Connection reset by peer */
public static final int ENOBUFS =         55;              /* No buffer space available */
public static final int EISCONN =         56;              /* Socket is already connected */
public static final int ENOTCONN =        57;              /* Socket is not connected */
// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static final int ESHUTDOWN =       58;              /* Can't send after socket shutdown */
public static final int ETOOMANYREFS =    59;              /* Too many references: can't splice */
// #endif
public static final int ETIMEDOUT =       60;              /* Operation timed out */
public static final int ECONNREFUSED =    61;              /* Connection refused */

public static final int ELOOP =           62;              /* Too many levels of symbolic links */
public static final int ENAMETOOLONG =    63;              /* File name too long */

/* should be rearranged */
// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static final int EHOSTDOWN =       64;              /* Host is down */
// #endif
public static final int EHOSTUNREACH =    65;              /* No route to host */
public static final int ENOTEMPTY =       66;              /* Directory not empty */

/* quotas & mush */
// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static final int EPROCLIM =        67;              /* Too many processes */
public static final int EUSERS =          68;              /* Too many users */
// #endif
public static final int EDQUOT =          69;              /* Disc quota exceeded */

/* Network File System */
public static final int ESTALE =          70;              /* Stale NFS file handle */
// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static final int EREMOTE =         71;              /* Too many levels of remote in path */
public static final int EBADRPC =         72;              /* RPC struct is bad */
public static final int ERPCMISMATCH =    73;              /* RPC version wrong */
public static final int EPROGUNAVAIL =    74;              /* RPC prog. not avail */
public static final int EPROGMISMATCH =   75;              /* Program version wrong */
public static final int EPROCUNAVAIL =    76;              /* Bad procedure for program */
// #endif

public static final int ENOLCK =          77;              /* No locks available */
public static final int ENOSYS =          78;              /* Function not implemented */

// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static final int EFTYPE =          79;              /* Inappropriate file type or format */
public static final int EAUTH =           80;              /* Authentication error */
public static final int ENEEDAUTH =       81;              /* Need authenticator */

/* Intelligent device errors */
public static final int EPWROFF =         82;      /* Device power is off */
public static final int EDEVERR =         83;      /* Device error, e.g. paper out */
// #endif

public static final int EOVERFLOW =       84;              /* Value too large to be stored in data type */

/* Program loading errors */
// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static final int EBADEXEC =        85;      /* Bad executable */
public static final int EBADARCH =        86;      /* Bad CPU type in executable */
public static final int ESHLIBVERS =      87;      /* Shared library version mismatch */
public static final int EBADMACHO =       88;      /* Malformed Macho file */
// #endif

public static final int ECANCELED =       89;              /* Operation canceled */

public static final int EIDRM =           90;              /* Identifier removed */
public static final int ENOMSG =          91;              /* No message of desired type */
public static final int EILSEQ =          92;              /* Illegal byte sequence */
// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static final int ENOATTR =         93;              /* Attribute not found */
// #endif

public static final int EBADMSG =         94;              /* Bad message */
public static final int EMULTIHOP =       95;              /* Reserved */
public static final int ENODATA =         96;              /* No message available on STREAM */
public static final int ENOLINK =         97;              /* Reserved */
public static final int ENOSR =           98;              /* No STREAM resources */
public static final int ENOSTR =          99;              /* Not a STREAM */
public static final int EPROTO =          100;             /* Protocol error */
public static final int ETIME =           101;             /* STREAM ioctl timeout */

// #if __DARWIN_UNIX03 || defined(KERNEL)
/* This value is only discrete when compiling __DARWIN_UNIX03, or KERNEL */             /* Operation not supported on socket */
// #endif /* __DARWIN_UNIX03 || KERNEL */

public static final int ENOPOLICY =       103;             /* No such policy registered */

// #if __DARWIN_C_LEVEL >= 200809L
public static final int ENOTRECOVERABLE = 104;             /* State not recoverable */
public static final int EOWNERDEAD =      105;             /* Previous owner died */
// #endif

// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static final int EQFULL =          106;             /* Interface output queue is full */
public static final int ELAST =           106;             /* Must be equal largest errno */
// #endif

// #endif /* _SYS_ERRNO_H_ */


// Parsed from string.h

/*
 * Copyright (c) 2000, 2007, 2010 Apple Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_LICENSE_HEADER_END@
 */
/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)string.h	8.1 (Berkeley) 6/2/93
 */

// #ifndef _STRING_H_
// #define	_STRING_H_

// #include <_types.h>
// #include <sys/cdefs.h>
// #include <Availability.h>
// #include <sys/_types/_size_t.h>
// #include <sys/_types/_null.h>

/* ANSI-C */

public static native Pointer memchr(Pointer __s, int __c, @Cast("size_t") long __n);
public static native int memcmp(@Const Pointer __s1, @Const Pointer __s2, @Cast("size_t") long __n);
public static native Pointer memcpy(Pointer __dst, @Const Pointer __src, @Cast("size_t") long __n);
public static native Pointer memmove(Pointer __dst, @Const Pointer __src, @Cast("size_t") long __len);
public static native Pointer memset(Pointer __b, int __c, @Cast("size_t") long __len);
public static native @Cast("char*") BytePointer strcat(@Cast("char*") BytePointer __s1, @Cast("const char*") BytePointer __s2);
public static native @Cast("char*") ByteBuffer strcat(@Cast("char*") ByteBuffer __s1, String __s2);
public static native @Cast("char*") byte[] strcat(@Cast("char*") byte[] __s1, @Cast("const char*") BytePointer __s2);
public static native @Cast("char*") BytePointer strcat(@Cast("char*") BytePointer __s1, String __s2);
public static native @Cast("char*") ByteBuffer strcat(@Cast("char*") ByteBuffer __s1, @Cast("const char*") BytePointer __s2);
public static native @Cast("char*") byte[] strcat(@Cast("char*") byte[] __s1, String __s2);
public static native @Cast("char*") BytePointer strchr(@Cast("const char*") BytePointer __s, int __c);
public static native @Cast("char*") ByteBuffer strchr(String __s, int __c);
public static native int strcmp(@Cast("const char*") BytePointer __s1, @Cast("const char*") BytePointer __s2);
public static native int strcmp(String __s1, String __s2);
public static native int strcoll(@Cast("const char*") BytePointer __s1, @Cast("const char*") BytePointer __s2);
public static native int strcoll(String __s1, String __s2);
public static native @Cast("char*") BytePointer strcpy(@Cast("char*") BytePointer __dst, @Cast("const char*") BytePointer __src);
public static native @Cast("char*") ByteBuffer strcpy(@Cast("char*") ByteBuffer __dst, String __src);
public static native @Cast("char*") byte[] strcpy(@Cast("char*") byte[] __dst, @Cast("const char*") BytePointer __src);
public static native @Cast("char*") BytePointer strcpy(@Cast("char*") BytePointer __dst, String __src);
public static native @Cast("char*") ByteBuffer strcpy(@Cast("char*") ByteBuffer __dst, @Cast("const char*") BytePointer __src);
public static native @Cast("char*") byte[] strcpy(@Cast("char*") byte[] __dst, String __src);
public static native @Cast("size_t") long strcspn(@Cast("const char*") BytePointer __s, @Cast("const char*") BytePointer __charset);
public static native @Cast("size_t") long strcspn(String __s, String __charset);
public static native @Cast("char*") BytePointer strerror(int __errnum);
public static native @Cast("size_t") long strlen(@Cast("const char*") BytePointer __s);
public static native @Cast("size_t") long strlen(String __s);
public static native @Cast("char*") BytePointer strncat(@Cast("char*") BytePointer __s1, @Cast("const char*") BytePointer __s2, @Cast("size_t") long __n);
public static native @Cast("char*") ByteBuffer strncat(@Cast("char*") ByteBuffer __s1, String __s2, @Cast("size_t") long __n);
public static native @Cast("char*") byte[] strncat(@Cast("char*") byte[] __s1, @Cast("const char*") BytePointer __s2, @Cast("size_t") long __n);
public static native @Cast("char*") BytePointer strncat(@Cast("char*") BytePointer __s1, String __s2, @Cast("size_t") long __n);
public static native @Cast("char*") ByteBuffer strncat(@Cast("char*") ByteBuffer __s1, @Cast("const char*") BytePointer __s2, @Cast("size_t") long __n);
public static native @Cast("char*") byte[] strncat(@Cast("char*") byte[] __s1, String __s2, @Cast("size_t") long __n);
public static native int strncmp(@Cast("const char*") BytePointer __s1, @Cast("const char*") BytePointer __s2, @Cast("size_t") long __n);
public static native int strncmp(String __s1, String __s2, @Cast("size_t") long __n);
public static native @Cast("char*") BytePointer strncpy(@Cast("char*") BytePointer __dst, @Cast("const char*") BytePointer __src, @Cast("size_t") long __n);
public static native @Cast("char*") ByteBuffer strncpy(@Cast("char*") ByteBuffer __dst, String __src, @Cast("size_t") long __n);
public static native @Cast("char*") byte[] strncpy(@Cast("char*") byte[] __dst, @Cast("const char*") BytePointer __src, @Cast("size_t") long __n);
public static native @Cast("char*") BytePointer strncpy(@Cast("char*") BytePointer __dst, String __src, @Cast("size_t") long __n);
public static native @Cast("char*") ByteBuffer strncpy(@Cast("char*") ByteBuffer __dst, @Cast("const char*") BytePointer __src, @Cast("size_t") long __n);
public static native @Cast("char*") byte[] strncpy(@Cast("char*") byte[] __dst, String __src, @Cast("size_t") long __n);
public static native @Cast("char*") BytePointer strpbrk(@Cast("const char*") BytePointer __s, @Cast("const char*") BytePointer __charset);
public static native @Cast("char*") ByteBuffer strpbrk(String __s, String __charset);
public static native @Cast("char*") BytePointer strrchr(@Cast("const char*") BytePointer __s, int __c);
public static native @Cast("char*") ByteBuffer strrchr(String __s, int __c);
public static native @Cast("size_t") long strspn(@Cast("const char*") BytePointer __s, @Cast("const char*") BytePointer __charset);
public static native @Cast("size_t") long strspn(String __s, String __charset);
public static native @Cast("char*") BytePointer strstr(@Cast("const char*") BytePointer __big, @Cast("const char*") BytePointer __little);
public static native @Cast("char*") ByteBuffer strstr(String __big, String __little);
public static native @Cast("char*") BytePointer strtok(@Cast("char*") BytePointer __str, @Cast("const char*") BytePointer __sep);
public static native @Cast("char*") ByteBuffer strtok(@Cast("char*") ByteBuffer __str, String __sep);
public static native @Cast("char*") byte[] strtok(@Cast("char*") byte[] __str, @Cast("const char*") BytePointer __sep);
public static native @Cast("char*") BytePointer strtok(@Cast("char*") BytePointer __str, String __sep);
public static native @Cast("char*") ByteBuffer strtok(@Cast("char*") ByteBuffer __str, @Cast("const char*") BytePointer __sep);
public static native @Cast("char*") byte[] strtok(@Cast("char*") byte[] __str, String __sep);
public static native @Cast("size_t") long strxfrm(@Cast("char*") BytePointer __s1, @Cast("const char*") BytePointer __s2, @Cast("size_t") long __n);
public static native @Cast("size_t") long strxfrm(@Cast("char*") ByteBuffer __s1, String __s2, @Cast("size_t") long __n);
public static native @Cast("size_t") long strxfrm(@Cast("char*") byte[] __s1, @Cast("const char*") BytePointer __s2, @Cast("size_t") long __n);
public static native @Cast("size_t") long strxfrm(@Cast("char*") BytePointer __s1, String __s2, @Cast("size_t") long __n);
public static native @Cast("size_t") long strxfrm(@Cast("char*") ByteBuffer __s1, @Cast("const char*") BytePointer __s2, @Cast("size_t") long __n);
public static native @Cast("size_t") long strxfrm(@Cast("char*") byte[] __s1, String __s2, @Cast("size_t") long __n);
/* Additional functionality provided by:
 * POSIX.1c-1995,
 * POSIX.1i-1995,
 * and the omnibus ISO/IEC 9945-1: 1996
 */

// #if __DARWIN_C_LEVEL >= 199506L
public static native @Cast("char*") BytePointer strtok_r(@Cast("char*") BytePointer __str, @Cast("const char*") BytePointer __sep, @Cast("char**") PointerPointer __lasts);
public static native @Cast("char*") BytePointer strtok_r(@Cast("char*") BytePointer __str, @Cast("const char*") BytePointer __sep, @Cast("char**") @ByPtrPtr BytePointer __lasts);
public static native @Cast("char*") ByteBuffer strtok_r(@Cast("char*") ByteBuffer __str, String __sep, @Cast("char**") @ByPtrPtr ByteBuffer __lasts);
public static native @Cast("char*") byte[] strtok_r(@Cast("char*") byte[] __str, @Cast("const char*") BytePointer __sep, @Cast("char**") @ByPtrPtr byte[] __lasts);
public static native @Cast("char*") BytePointer strtok_r(@Cast("char*") BytePointer __str, String __sep, @Cast("char**") @ByPtrPtr BytePointer __lasts);
public static native @Cast("char*") ByteBuffer strtok_r(@Cast("char*") ByteBuffer __str, @Cast("const char*") BytePointer __sep, @Cast("char**") @ByPtrPtr ByteBuffer __lasts);
public static native @Cast("char*") byte[] strtok_r(@Cast("char*") byte[] __str, String __sep, @Cast("char**") @ByPtrPtr byte[] __lasts);
// #endif /* __DARWIN_C_LEVEL >= 199506L */



/* Additional functionality provided by:
 * POSIX.1-2001
 */

// #if __DARWIN_C_LEVEL >= 200112L
public static native int strerror_r(int __errnum, @Cast("char*") BytePointer __strerrbuf, @Cast("size_t") long __buflen);
public static native int strerror_r(int __errnum, @Cast("char*") ByteBuffer __strerrbuf, @Cast("size_t") long __buflen);
public static native int strerror_r(int __errnum, @Cast("char*") byte[] __strerrbuf, @Cast("size_t") long __buflen);
public static native @Cast("char*") BytePointer strdup(@Cast("const char*") BytePointer __s1);
public static native @Cast("char*") ByteBuffer strdup(String __s1);
public static native Pointer memccpy(Pointer __dst, @Const Pointer __src, int __c, @Cast("size_t") long __n);
// #endif /* __DARWIN_C_LEVEL >= 200112L */



/* Additional functionality provided by:
 * POSIX.1-2008
 */

// #if __DARWIN_C_LEVEL >= 200809L
public static native @Cast("char*") BytePointer stpcpy(@Cast("char*") BytePointer __dst, @Cast("const char*") BytePointer __src);
public static native @Cast("char*") ByteBuffer stpcpy(@Cast("char*") ByteBuffer __dst, String __src);
public static native @Cast("char*") byte[] stpcpy(@Cast("char*") byte[] __dst, @Cast("const char*") BytePointer __src);
public static native @Cast("char*") BytePointer stpcpy(@Cast("char*") BytePointer __dst, String __src);
public static native @Cast("char*") ByteBuffer stpcpy(@Cast("char*") ByteBuffer __dst, @Cast("const char*") BytePointer __src);
public static native @Cast("char*") byte[] stpcpy(@Cast("char*") byte[] __dst, String __src);
public static native @Cast("char*") BytePointer stpncpy(@Cast("char*") BytePointer __dst, @Cast("const char*") BytePointer __src, @Cast("size_t") long __n);
public static native @Cast("char*") ByteBuffer stpncpy(@Cast("char*") ByteBuffer __dst, String __src, @Cast("size_t") long __n);
public static native @Cast("char*") byte[] stpncpy(@Cast("char*") byte[] __dst, @Cast("const char*") BytePointer __src, @Cast("size_t") long __n);
public static native @Cast("char*") BytePointer stpncpy(@Cast("char*") BytePointer __dst, String __src, @Cast("size_t") long __n);
public static native @Cast("char*") ByteBuffer stpncpy(@Cast("char*") ByteBuffer __dst, @Cast("const char*") BytePointer __src, @Cast("size_t") long __n);
public static native @Cast("char*") byte[] stpncpy(@Cast("char*") byte[] __dst, String __src, @Cast("size_t") long __n);
public static native @Cast("char*") BytePointer strndup(@Cast("const char*") BytePointer __s1, @Cast("size_t") long __n);
public static native @Cast("char*") ByteBuffer strndup(String __s1, @Cast("size_t") long __n);
public static native @Cast("size_t") long strnlen(@Cast("const char*") BytePointer __s1, @Cast("size_t") long __n);
public static native @Cast("size_t") long strnlen(String __s1, @Cast("size_t") long __n);
public static native @Cast("char*") BytePointer strsignal(int __sig);
// #endif /* __DARWIN_C_LEVEL >= 200809L */

/* C11 Annex K */

// #if defined(__STDC_WANT_LIB_EXT1__) && __STDC_WANT_LIB_EXT1__ >= 1
// #include <sys/_types/_rsize_t.h>
// #include <sys/_types/_errno_t.h>

public static native @Cast("errno_t") int memset_s(Pointer __s, @Cast("rsize_t") long __smax, int __c, @Cast("rsize_t") long __n);
// #endif

/* Darwin extensions */

// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
// #include <sys/_types/_ssize_t.h>

public static native Pointer memmem(@Const Pointer __big, @Cast("size_t") long __big_len, @Const Pointer __little, @Cast("size_t") long __little_len);
public static native void memset_pattern4(Pointer __b, @Const Pointer __pattern4, @Cast("size_t") long __len);
public static native void memset_pattern8(Pointer __b, @Const Pointer __pattern8, @Cast("size_t") long __len);
public static native void memset_pattern16(Pointer __b, @Const Pointer __pattern16, @Cast("size_t") long __len);

public static native @Cast("char*") BytePointer strcasestr(@Cast("const char*") BytePointer __big, @Cast("const char*") BytePointer __little);
public static native @Cast("char*") ByteBuffer strcasestr(String __big, String __little);
public static native @Cast("char*") BytePointer strnstr(@Cast("const char*") BytePointer __big, @Cast("const char*") BytePointer __little, @Cast("size_t") long __len);
public static native @Cast("char*") ByteBuffer strnstr(String __big, String __little, @Cast("size_t") long __len);
public static native @Cast("size_t") long strlcat(@Cast("char*") BytePointer __dst, @Cast("const char*") BytePointer __source, @Cast("size_t") long __size);
public static native @Cast("size_t") long strlcat(@Cast("char*") ByteBuffer __dst, String __source, @Cast("size_t") long __size);
public static native @Cast("size_t") long strlcat(@Cast("char*") byte[] __dst, @Cast("const char*") BytePointer __source, @Cast("size_t") long __size);
public static native @Cast("size_t") long strlcat(@Cast("char*") BytePointer __dst, String __source, @Cast("size_t") long __size);
public static native @Cast("size_t") long strlcat(@Cast("char*") ByteBuffer __dst, @Cast("const char*") BytePointer __source, @Cast("size_t") long __size);
public static native @Cast("size_t") long strlcat(@Cast("char*") byte[] __dst, String __source, @Cast("size_t") long __size);
public static native @Cast("size_t") long strlcpy(@Cast("char*") BytePointer __dst, @Cast("const char*") BytePointer __source, @Cast("size_t") long __size);
public static native @Cast("size_t") long strlcpy(@Cast("char*") ByteBuffer __dst, String __source, @Cast("size_t") long __size);
public static native @Cast("size_t") long strlcpy(@Cast("char*") byte[] __dst, @Cast("const char*") BytePointer __source, @Cast("size_t") long __size);
public static native @Cast("size_t") long strlcpy(@Cast("char*") BytePointer __dst, String __source, @Cast("size_t") long __size);
public static native @Cast("size_t") long strlcpy(@Cast("char*") ByteBuffer __dst, @Cast("const char*") BytePointer __source, @Cast("size_t") long __size);
public static native @Cast("size_t") long strlcpy(@Cast("char*") byte[] __dst, String __source, @Cast("size_t") long __size);
public static native void strmode(int __mode, @Cast("char*") BytePointer __bp);
public static native void strmode(int __mode, @Cast("char*") ByteBuffer __bp);
public static native void strmode(int __mode, @Cast("char*") byte[] __bp);
public static native @Cast("char*") BytePointer strsep(@Cast("char**") PointerPointer __stringp, @Cast("const char*") BytePointer __delim);
public static native @Cast("char*") BytePointer strsep(@Cast("char**") @ByPtrPtr BytePointer __stringp, @Cast("const char*") BytePointer __delim);
public static native @Cast("char*") ByteBuffer strsep(@Cast("char**") @ByPtrPtr ByteBuffer __stringp, String __delim);
public static native @Cast("char*") byte[] strsep(@Cast("char**") @ByPtrPtr byte[] __stringp, @Cast("const char*") BytePointer __delim);
public static native @Cast("char*") BytePointer strsep(@Cast("char**") @ByPtrPtr BytePointer __stringp, String __delim);
public static native @Cast("char*") ByteBuffer strsep(@Cast("char**") @ByPtrPtr ByteBuffer __stringp, @Cast("const char*") BytePointer __delim);
public static native @Cast("char*") byte[] strsep(@Cast("char**") @ByPtrPtr byte[] __stringp, String __delim);

/* SUS places swab() in unistd.h.  It is listed here for source compatibility */
public static native void swab(@Const Pointer arg0, Pointer arg1, @Cast("ssize_t") long arg2);

public static native int timingsafe_bcmp(@Const Pointer __b1, @Const Pointer __b2, @Cast("size_t") long __len);

public static native int strsignal_r(int __sig, @Cast("char*") BytePointer __strsignalbuf, @Cast("size_t") long __buflen);
public static native int strsignal_r(int __sig, @Cast("char*") ByteBuffer __strsignalbuf, @Cast("size_t") long __buflen);
public static native int strsignal_r(int __sig, @Cast("char*") byte[] __strsignalbuf, @Cast("size_t") long __buflen);
/* Some functions historically defined in string.h were placed in strings.h
 * by SUS.  We are using "strings.h" instead of <strings.h> to avoid an issue
 * where /Developer/Headers/FlatCarbon/Strings.h could be included instead on
 * case-insensitive file systems.
 */
// #include "strings.h"
// #endif /* __DARWIN_C_LEVEL >= __DARWIN_C_FULL */


// #ifdef _USE_EXTENDED_LOCALES_
// #endif /* _USE_EXTENDED_LOCALES_ */

// #if defined (__GNUC__) && _FORTIFY_SOURCE > 0 && !defined (__cplusplus)
/* Security checking functions.  */
// #include <secure/_string.h>
// #endif

// #endif /* _STRING_H_ */


// Parsed from stdlib.h

/*
 * Copyright (c) 2000, 2002 - 2008 Apple Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)stdlib.h	8.5 (Berkeley) 5/19/95
 */

// #ifndef _STDLIB_H_
// #define _STDLIB_H_

// #include <Availability.h>
// #include <sys/cdefs.h>

// #include <_types.h>
// #if !defined(_ANSI_SOURCE)
// #include <sys/wait.h>
// #if (!defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE))
// #include <alloca.h>
// #endif /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */
// #endif /* !_ANSI_SOURCE */

/* DO NOT REMOVE THIS COMMENT: fixincludes needs to see:
 * _GCC_SIZE_T */
// #include <sys/_types/_size_t.h>

// #if !defined(_ANSI_SOURCE) && (!defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE))
// #include <sys/_types/_ct_rune_t.h>
// #include <sys/_types/_rune_t.h>
// #endif	/* !_ANSI_SOURCE && (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */

// #include <sys/_types/_wchar_t.h>
// Targeting ../macosx/div_t.java


// Targeting ../macosx/ldiv_t.java


// Targeting ../macosx/lldiv_t.java


// #endif /* !__DARWIN_NO_LONG_LONG */

// #include <sys/_types/_null.h>

public static final int EXIT_FAILURE =	1;
public static final int EXIT_SUCCESS =	0;

public static final int RAND_MAX =	0x7fffffff;

// #ifdef _USE_EXTENDED_LOCALES_
// #endif /* _USE_EXTENDED_LOCALES_ */

// #ifndef MB_CUR_MAX
// #endif /* MB_CUR_MAX */

// #if !defined(_ANSI_SOURCE) && (!defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE))
//     && defined(_USE_EXTENDED_LOCALES_) && !defined(MB_CUR_MAX_L)
// #define	MB_CUR_MAX_L(x)	(___mb_cur_max_l(x))
// #endif

// #include <malloc/_malloc.h>

public static native void abort();
public static native int abs(int arg0);
// Targeting ../macosx/_Nonnull.java


public static native int atexit(_Nonnull _Nonnull);
public static native double atof(@Cast("const char*") BytePointer arg0);
public static native double atof(String arg0);
public static native int atoi(@Cast("const char*") BytePointer arg0);
public static native int atoi(String arg0);
public static native long atol(@Cast("const char*") BytePointer arg0);
public static native long atol(String arg0);
// #if !__DARWIN_NO_LONG_LONG
public static native long atoll(@Cast("const char*") BytePointer arg0);
public static native long atoll(String arg0);
// Targeting ../macosx/_Nonnull__compar_Pointer_Pointer.java


public static native Pointer bsearch(@Const Pointer __key, @Const Pointer __base, @Cast("size_t") long __nel,
	    @Cast("size_t") long __width, _Nonnull__compar_Pointer_Pointer _Nonnull__compar);
/* calloc is now declared in _malloc.h */
public static native @ByVal div_t div(int arg0, int arg1);
public static native void exit(int arg0);
/* free is now declared in _malloc.h */
public static native @Cast("char*") BytePointer getenv(@Cast("const char*") BytePointer arg0);
public static native @Cast("char*") ByteBuffer getenv(String arg0);
public static native long labs(long arg0);
public static native @ByVal ldiv_t ldiv(long arg0, long arg1);
// #if !__DARWIN_NO_LONG_LONG
public static native long llabs(long arg0);
public static native @ByVal lldiv_t lldiv(long arg0, long arg1);
// #endif /* !__DARWIN_NO_LONG_LONG */
/* malloc is now declared in _malloc.h */
public static native int mblen(@Cast("const char*") BytePointer __s, @Cast("size_t") long __n);
public static native int mblen(String __s, @Cast("size_t") long __n);
public static native @Cast("size_t") long mbstowcs(@Cast("wchar_t*") CharPointer arg0, @Cast("const char*") BytePointer arg1, @Cast("size_t") long arg2);
public static native @Cast("size_t") long mbstowcs(@Cast("wchar_t*") IntPointer arg0, String arg1, @Cast("size_t") long arg2);
public static native int mbtowc(@Cast("wchar_t*") CharPointer arg0, @Cast("const char*") BytePointer arg1, @Cast("size_t") long arg2);
public static native int mbtowc(@Cast("wchar_t*") IntPointer arg0, String arg1, @Cast("size_t") long arg2);
/* posix_memalign is now declared in _malloc.h */
public static native void qsort(Pointer __base, @Cast("size_t") long __nel, @Cast("size_t") long __width,
	    _Nonnull__compar_Pointer_Pointer _Nonnull__compar);
public static native int rand();
/* realloc is now declared in _malloc.h */
public static native void srand(@Cast("unsigned") int arg0);
public static native double strtod(@Cast("const char*") BytePointer arg0, @Cast("char**") PointerPointer arg1);
public static native double strtod(@Cast("const char*") BytePointer arg0, @Cast("char**") @ByPtrPtr BytePointer arg1);
public static native double strtod(String arg0, @Cast("char**") @ByPtrPtr ByteBuffer arg1);
public static native double strtod(@Cast("const char*") BytePointer arg0, @Cast("char**") @ByPtrPtr byte[] arg1);
public static native double strtod(String arg0, @Cast("char**") @ByPtrPtr BytePointer arg1);
public static native double strtod(@Cast("const char*") BytePointer arg0, @Cast("char**") @ByPtrPtr ByteBuffer arg1);
public static native double strtod(String arg0, @Cast("char**") @ByPtrPtr byte[] arg1);
public static native float strtof(@Cast("const char*") BytePointer arg0, @Cast("char**") PointerPointer arg1);
public static native float strtof(@Cast("const char*") BytePointer arg0, @Cast("char**") @ByPtrPtr BytePointer arg1);
public static native float strtof(String arg0, @Cast("char**") @ByPtrPtr ByteBuffer arg1);
public static native float strtof(@Cast("const char*") BytePointer arg0, @Cast("char**") @ByPtrPtr byte[] arg1);
public static native float strtof(String arg0, @Cast("char**") @ByPtrPtr BytePointer arg1);
public static native float strtof(@Cast("const char*") BytePointer arg0, @Cast("char**") @ByPtrPtr ByteBuffer arg1);
public static native float strtof(String arg0, @Cast("char**") @ByPtrPtr byte[] arg1);
public static native long strtol(@Cast("const char*") BytePointer __str, @Cast("char**") PointerPointer __endptr, int __base);
public static native long strtol(@Cast("const char*") BytePointer __str, @Cast("char**") @ByPtrPtr BytePointer __endptr, int __base);
public static native long strtol(String __str, @Cast("char**") @ByPtrPtr ByteBuffer __endptr, int __base);
public static native long strtol(@Cast("const char*") BytePointer __str, @Cast("char**") @ByPtrPtr byte[] __endptr, int __base);
public static native long strtol(String __str, @Cast("char**") @ByPtrPtr BytePointer __endptr, int __base);
public static native long strtol(@Cast("const char*") BytePointer __str, @Cast("char**") @ByPtrPtr ByteBuffer __endptr, int __base);
public static native long strtol(String __str, @Cast("char**") @ByPtrPtr byte[] __endptr, int __base);
public static native @Cast("long double") double strtold(@Cast("const char*") BytePointer arg0, @Cast("char**") PointerPointer arg1);
public static native @Cast("long double") double strtold(@Cast("const char*") BytePointer arg0, @Cast("char**") @ByPtrPtr BytePointer arg1);
public static native @Cast("long double") double strtold(String arg0, @Cast("char**") @ByPtrPtr ByteBuffer arg1);
public static native @Cast("long double") double strtold(@Cast("const char*") BytePointer arg0, @Cast("char**") @ByPtrPtr byte[] arg1);
public static native @Cast("long double") double strtold(String arg0, @Cast("char**") @ByPtrPtr BytePointer arg1);
public static native @Cast("long double") double strtold(@Cast("const char*") BytePointer arg0, @Cast("char**") @ByPtrPtr ByteBuffer arg1);
public static native @Cast("long double") double strtold(String arg0, @Cast("char**") @ByPtrPtr byte[] arg1);
// #if !__DARWIN_NO_LONG_LONG
public static native long strtoll(@Cast("const char*") BytePointer __str, @Cast("char**") PointerPointer __endptr, int __base);
public static native long strtoll(@Cast("const char*") BytePointer __str, @Cast("char**") @ByPtrPtr BytePointer __endptr, int __base);
public static native long strtoll(String __str, @Cast("char**") @ByPtrPtr ByteBuffer __endptr, int __base);
public static native long strtoll(@Cast("const char*") BytePointer __str, @Cast("char**") @ByPtrPtr byte[] __endptr, int __base);
public static native long strtoll(String __str, @Cast("char**") @ByPtrPtr BytePointer __endptr, int __base);
public static native long strtoll(@Cast("const char*") BytePointer __str, @Cast("char**") @ByPtrPtr ByteBuffer __endptr, int __base);
public static native long strtoll(String __str, @Cast("char**") @ByPtrPtr byte[] __endptr, int __base);
// #endif /* !__DARWIN_NO_LONG_LONG */
public static native @Cast("unsigned long") long strtoul(@Cast("const char*") BytePointer __str, @Cast("char**") PointerPointer __endptr, int __base);
public static native @Cast("unsigned long") long strtoul(@Cast("const char*") BytePointer __str, @Cast("char**") @ByPtrPtr BytePointer __endptr, int __base);
public static native @Cast("unsigned long") long strtoul(String __str, @Cast("char**") @ByPtrPtr ByteBuffer __endptr, int __base);
public static native @Cast("unsigned long") long strtoul(@Cast("const char*") BytePointer __str, @Cast("char**") @ByPtrPtr byte[] __endptr, int __base);
public static native @Cast("unsigned long") long strtoul(String __str, @Cast("char**") @ByPtrPtr BytePointer __endptr, int __base);
public static native @Cast("unsigned long") long strtoul(@Cast("const char*") BytePointer __str, @Cast("char**") @ByPtrPtr ByteBuffer __endptr, int __base);
public static native @Cast("unsigned long") long strtoul(String __str, @Cast("char**") @ByPtrPtr byte[] __endptr, int __base);
// #if !__DARWIN_NO_LONG_LONG
public static native @Cast("unsigned long long") long strtoull(@Cast("const char*") BytePointer __str, @Cast("char**") PointerPointer __endptr, int __base);
public static native @Cast("unsigned long long") long strtoull(@Cast("const char*") BytePointer __str, @Cast("char**") @ByPtrPtr BytePointer __endptr, int __base);
public static native @Cast("unsigned long long") long strtoull(String __str, @Cast("char**") @ByPtrPtr ByteBuffer __endptr, int __base);
public static native @Cast("unsigned long long") long strtoull(@Cast("const char*") BytePointer __str, @Cast("char**") @ByPtrPtr byte[] __endptr, int __base);
public static native @Cast("unsigned long long") long strtoull(String __str, @Cast("char**") @ByPtrPtr BytePointer __endptr, int __base);
public static native @Cast("unsigned long long") long strtoull(@Cast("const char*") BytePointer __str, @Cast("char**") @ByPtrPtr ByteBuffer __endptr, int __base);
public static native @Cast("unsigned long long") long strtoull(String __str, @Cast("char**") @ByPtrPtr byte[] __endptr, int __base);
// #endif /* !__DARWIN_NO_LONG_LONG */

// #if TARGET_OS_IPHONE
// #define __swift_unavailable_on(osx_msg, ios_msg) __swift_unavailable(ios_msg)
// #else
// #define __swift_unavailable_on(osx_msg, ios_msg) __swift_unavailable(osx_msg)
// #endif



// #undef __swift_unavailable_on

public static native @Cast("size_t") long wcstombs(@Cast("char*") BytePointer arg0, @Cast("const wchar_t*") CharPointer arg1, @Cast("size_t") long arg2);
public static native @Cast("size_t") long wcstombs(@Cast("char*") ByteBuffer arg0, @Cast("const wchar_t*") IntPointer arg1, @Cast("size_t") long arg2);
public static native @Cast("size_t") long wcstombs(@Cast("char*") byte[] arg0, @Cast("const wchar_t*") CharPointer arg1, @Cast("size_t") long arg2);
public static native @Cast("size_t") long wcstombs(@Cast("char*") BytePointer arg0, @Cast("const wchar_t*") IntPointer arg1, @Cast("size_t") long arg2);
public static native @Cast("size_t") long wcstombs(@Cast("char*") ByteBuffer arg0, @Cast("const wchar_t*") CharPointer arg1, @Cast("size_t") long arg2);
public static native @Cast("size_t") long wcstombs(@Cast("char*") byte[] arg0, @Cast("const wchar_t*") IntPointer arg1, @Cast("size_t") long arg2);
public static native int wctomb(@Cast("char*") BytePointer arg0, @Cast("wchar_t") char arg1);
public static native int wctomb(@Cast("char*") ByteBuffer arg0, @Cast("wchar_t") int arg1);
public static native int wctomb(@Cast("char*") byte[] arg0, @Cast("wchar_t") char arg1);
public static native int wctomb(@Cast("char*") BytePointer arg0, @Cast("wchar_t") int arg1);
public static native int wctomb(@Cast("char*") ByteBuffer arg0, @Cast("wchar_t") char arg1);
public static native int wctomb(@Cast("char*") byte[] arg0, @Cast("wchar_t") int arg1);

// #ifndef _ANSI_SOURCE
public static native void _Exit(int arg0);
public static native long a64l(@Cast("const char*") BytePointer arg0);
public static native long a64l(String arg0);
public static native double drand48();
public static native @Cast("char*") BytePointer ecvt(double arg0, int arg1, IntPointer arg2, IntPointer arg3);
public static native @Cast("char*") ByteBuffer ecvt(double arg0, int arg1, IntBuffer arg2, IntBuffer arg3);
public static native @Cast("char*") byte[] ecvt(double arg0, int arg1, int[] arg2, int[] arg3); /* LEGACY */
public static native double erand48(@Cast("unsigned short*") ShortPointer arg0);
public static native double erand48(@Cast("unsigned short*") ShortBuffer arg0);
public static native double erand48(@Cast("unsigned short*") short[] arg0);
public static native @Cast("char*") BytePointer fcvt(double arg0, int arg1, IntPointer arg2, IntPointer arg3);
public static native @Cast("char*") ByteBuffer fcvt(double arg0, int arg1, IntBuffer arg2, IntBuffer arg3);
public static native @Cast("char*") byte[] fcvt(double arg0, int arg1, int[] arg2, int[] arg3); /* LEGACY */
public static native @Cast("char*") BytePointer gcvt(double arg0, int arg1, @Cast("char*") BytePointer arg2);
public static native @Cast("char*") ByteBuffer gcvt(double arg0, int arg1, @Cast("char*") ByteBuffer arg2);
public static native @Cast("char*") byte[] gcvt(double arg0, int arg1, @Cast("char*") byte[] arg2); /* LEGACY */
public static native int getsubopt(@Cast("char**") PointerPointer arg0, @Cast("char*const*") PointerPointer arg1, @Cast("char**") PointerPointer arg2);
public static native int getsubopt(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("char*const*") @ByPtrPtr BytePointer arg1, @Cast("char**") @ByPtrPtr BytePointer arg2);
public static native int getsubopt(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("char*const*") @ByPtrPtr ByteBuffer arg1, @Cast("char**") @ByPtrPtr ByteBuffer arg2);
public static native int getsubopt(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("char*const*") @ByPtrPtr byte[] arg1, @Cast("char**") @ByPtrPtr byte[] arg2);
public static native int grantpt(int arg0);
// #if __DARWIN_UNIX03
public static native @Cast("char*") BytePointer initstate(@Cast("unsigned") int arg0, @Cast("char*") BytePointer arg1, @Cast("size_t") long arg2);
public static native @Cast("char*") ByteBuffer initstate(@Cast("unsigned") int arg0, @Cast("char*") ByteBuffer arg1, @Cast("size_t") long arg2);
public static native @Cast("char*") byte[] initstate(@Cast("unsigned") int arg0, @Cast("char*") byte[] arg1, @Cast("size_t") long arg2); /* no  __DARWIN_ALIAS needed */
// #else /* !__DARWIN_UNIX03 */
// #endif /* __DARWIN_UNIX03 */
public static native long jrand48(@Cast("unsigned short*") ShortPointer arg0);
public static native long jrand48(@Cast("unsigned short*") ShortBuffer arg0);
public static native long jrand48(@Cast("unsigned short*") short[] arg0);
public static native @Cast("char*") BytePointer l64a(long arg0);
public static native void lcong48(@Cast("unsigned short*") ShortPointer arg0);
public static native void lcong48(@Cast("unsigned short*") ShortBuffer arg0);
public static native void lcong48(@Cast("unsigned short*") short[] arg0);
public static native long lrand48();
public static native @Cast("char*") BytePointer mktemp(@Cast("char*") BytePointer arg0);
public static native @Cast("char*") ByteBuffer mktemp(@Cast("char*") ByteBuffer arg0);
public static native @Cast("char*") byte[] mktemp(@Cast("char*") byte[] arg0);
public static native int mkstemp(@Cast("char*") BytePointer arg0);
public static native int mkstemp(@Cast("char*") ByteBuffer arg0);
public static native int mkstemp(@Cast("char*") byte[] arg0);
public static native long mrand48();
public static native long nrand48(@Cast("unsigned short*") ShortPointer arg0);
public static native long nrand48(@Cast("unsigned short*") ShortBuffer arg0);
public static native long nrand48(@Cast("unsigned short*") short[] arg0);
public static native int posix_openpt(int arg0);
public static native @Cast("char*") BytePointer ptsname(int arg0);

// #if (!defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE))
public static native int ptsname_r(int fildes, @Cast("char*") BytePointer buffer, @Cast("size_t") long buflen);
public static native int ptsname_r(int fildes, @Cast("char*") ByteBuffer buffer, @Cast("size_t") long buflen);
public static native int ptsname_r(int fildes, @Cast("char*") byte[] buffer, @Cast("size_t") long buflen);
// #endif

public static native int putenv(@Cast("char*") BytePointer arg0);
public static native int putenv(@Cast("char*") ByteBuffer arg0);
public static native int putenv(@Cast("char*") byte[] arg0);
public static native long random();
public static native int rand_r(@Cast("unsigned*") IntPointer arg0);
public static native int rand_r(@Cast("unsigned*") IntBuffer arg0);
public static native int rand_r(@Cast("unsigned*") int[] arg0);
// #if (__DARWIN_UNIX03 && !defined(_POSIX_C_SOURCE)) || defined(_DARWIN_C_SOURCE) || defined(_DARWIN_BETTER_REALPATH)
public static native @Cast("char*") BytePointer realpath(@Cast("const char*") BytePointer arg0, @Cast("char*") BytePointer arg1);
public static native @Cast("char*") ByteBuffer realpath(String arg0, @Cast("char*") ByteBuffer arg1);
public static native @Cast("char*") byte[] realpath(@Cast("const char*") BytePointer arg0, @Cast("char*") byte[] arg1);
public static native @Cast("char*") BytePointer realpath(String arg0, @Cast("char*") BytePointer arg1);
public static native @Cast("char*") ByteBuffer realpath(@Cast("const char*") BytePointer arg0, @Cast("char*") ByteBuffer arg1);
public static native @Cast("char*") byte[] realpath(String arg0, @Cast("char*") byte[] arg1);
// #else /* (!__DARWIN_UNIX03 || _POSIX_C_SOURCE) && !_DARWIN_C_SOURCE && !_DARWIN_BETTER_REALPATH */
// #endif /* (__DARWIN_UNIX03 && _POSIX_C_SOURCE) || _DARWIN_C_SOURCE || _DARWIN_BETTER_REALPATH */
public static native @Cast("unsigned short*") ShortPointer seed48(@Cast("unsigned short*") ShortPointer arg0);
public static native @Cast("unsigned short*") ShortBuffer seed48(@Cast("unsigned short*") ShortBuffer arg0);
public static native @Cast("unsigned short*") short[] seed48(@Cast("unsigned short*") short[] arg0);
public static native int setenv(@Cast("const char*") BytePointer __name, @Cast("const char*") BytePointer __value, int __overwrite);
public static native int setenv(String __name, String __value, int __overwrite);
// #if __DARWIN_UNIX03
public static native void setkey(@Cast("const char*") BytePointer arg0);
public static native void setkey(String arg0);
// #else /* !__DARWIN_UNIX03 */
// #endif /* __DARWIN_UNIX03 */
public static native @Cast("char*") BytePointer setstate(@Cast("const char*") BytePointer arg0);
public static native @Cast("char*") ByteBuffer setstate(String arg0);
public static native void srand48(long arg0);
// #if __DARWIN_UNIX03
public static native void srandom(@Cast("unsigned") int arg0);
// #else /* !__DARWIN_UNIX03 */
// #endif /* __DARWIN_UNIX03 */
public static native int unlockpt(int arg0);
// #if __DARWIN_UNIX03
public static native int unsetenv(@Cast("const char*") BytePointer arg0);
public static native int unsetenv(String arg0);
// #else /* !__DARWIN_UNIX03 */
// #endif /* __DARWIN_UNIX03 */
// #endif	/* !_ANSI_SOURCE */

// #if !defined(_ANSI_SOURCE) && (!defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE))
// #include <machine/types.h>
// #include <sys/_types/_dev_t.h>
// #include <sys/_types/_mode_t.h>
// #include <_types/_uint32_t.h>

public static native @Cast("uint32_t") int arc4random();
public static native void arc4random_addrandom(@Cast("unsigned char*") BytePointer arg0, int arg1);
public static native void arc4random_addrandom(@Cast("unsigned char*") ByteBuffer arg0, int arg1);
public static native void arc4random_addrandom(@Cast("unsigned char*") byte[] arg0, int arg1);
public static native void arc4random_buf(Pointer __buf, @Cast("size_t") long __nbytes);
public static native void arc4random_stir();
public static native @Cast("uint32_t") int arc4random_uniform(@Cast("uint32_t") int __upper_bound);
// #ifdef __BLOCKS__
// #endif /* __BLOCKS__ */

	 /* getcap(3) functions */
public static native @Cast("char*") BytePointer cgetcap(@Cast("char*") BytePointer arg0, @Cast("const char*") BytePointer arg1, int arg2);
public static native @Cast("char*") ByteBuffer cgetcap(@Cast("char*") ByteBuffer arg0, String arg1, int arg2);
public static native @Cast("char*") byte[] cgetcap(@Cast("char*") byte[] arg0, @Cast("const char*") BytePointer arg1, int arg2);
public static native @Cast("char*") BytePointer cgetcap(@Cast("char*") BytePointer arg0, String arg1, int arg2);
public static native @Cast("char*") ByteBuffer cgetcap(@Cast("char*") ByteBuffer arg0, @Cast("const char*") BytePointer arg1, int arg2);
public static native @Cast("char*") byte[] cgetcap(@Cast("char*") byte[] arg0, String arg1, int arg2);
public static native int cgetclose();
public static native int cgetent(@Cast("char**") PointerPointer arg0, @Cast("char**") PointerPointer arg1, @Cast("const char*") BytePointer arg2);
public static native int cgetent(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("char**") @ByPtrPtr BytePointer arg1, @Cast("const char*") BytePointer arg2);
public static native int cgetent(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("char**") @ByPtrPtr ByteBuffer arg1, String arg2);
public static native int cgetent(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("char**") @ByPtrPtr byte[] arg1, @Cast("const char*") BytePointer arg2);
public static native int cgetent(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("char**") @ByPtrPtr BytePointer arg1, String arg2);
public static native int cgetent(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("char**") @ByPtrPtr ByteBuffer arg1, @Cast("const char*") BytePointer arg2);
public static native int cgetent(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("char**") @ByPtrPtr byte[] arg1, String arg2);
public static native int cgetfirst(@Cast("char**") PointerPointer arg0, @Cast("char**") PointerPointer arg1);
public static native int cgetfirst(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("char**") @ByPtrPtr BytePointer arg1);
public static native int cgetfirst(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("char**") @ByPtrPtr ByteBuffer arg1);
public static native int cgetfirst(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("char**") @ByPtrPtr byte[] arg1);
public static native int cgetmatch(@Cast("const char*") BytePointer arg0, @Cast("const char*") BytePointer arg1);
public static native int cgetmatch(String arg0, String arg1);
public static native int cgetnext(@Cast("char**") PointerPointer arg0, @Cast("char**") PointerPointer arg1);
public static native int cgetnext(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("char**") @ByPtrPtr BytePointer arg1);
public static native int cgetnext(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("char**") @ByPtrPtr ByteBuffer arg1);
public static native int cgetnext(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("char**") @ByPtrPtr byte[] arg1);
public static native int cgetnum(@Cast("char*") BytePointer arg0, @Cast("const char*") BytePointer arg1, CLongPointer arg2);
public static native int cgetnum(@Cast("char*") ByteBuffer arg0, String arg1, CLongPointer arg2);
public static native int cgetnum(@Cast("char*") byte[] arg0, @Cast("const char*") BytePointer arg1, CLongPointer arg2);
public static native int cgetnum(@Cast("char*") BytePointer arg0, String arg1, CLongPointer arg2);
public static native int cgetnum(@Cast("char*") ByteBuffer arg0, @Cast("const char*") BytePointer arg1, CLongPointer arg2);
public static native int cgetnum(@Cast("char*") byte[] arg0, String arg1, CLongPointer arg2);
public static native int cgetset(@Cast("const char*") BytePointer arg0);
public static native int cgetset(String arg0);
public static native int cgetstr(@Cast("char*") BytePointer arg0, @Cast("const char*") BytePointer arg1, @Cast("char**") PointerPointer arg2);
public static native int cgetstr(@Cast("char*") BytePointer arg0, @Cast("const char*") BytePointer arg1, @Cast("char**") @ByPtrPtr BytePointer arg2);
public static native int cgetstr(@Cast("char*") ByteBuffer arg0, String arg1, @Cast("char**") @ByPtrPtr ByteBuffer arg2);
public static native int cgetstr(@Cast("char*") byte[] arg0, @Cast("const char*") BytePointer arg1, @Cast("char**") @ByPtrPtr byte[] arg2);
public static native int cgetstr(@Cast("char*") BytePointer arg0, String arg1, @Cast("char**") @ByPtrPtr BytePointer arg2);
public static native int cgetstr(@Cast("char*") ByteBuffer arg0, @Cast("const char*") BytePointer arg1, @Cast("char**") @ByPtrPtr ByteBuffer arg2);
public static native int cgetstr(@Cast("char*") byte[] arg0, String arg1, @Cast("char**") @ByPtrPtr byte[] arg2);
public static native int cgetustr(@Cast("char*") BytePointer arg0, @Cast("const char*") BytePointer arg1, @Cast("char**") PointerPointer arg2);
public static native int cgetustr(@Cast("char*") BytePointer arg0, @Cast("const char*") BytePointer arg1, @Cast("char**") @ByPtrPtr BytePointer arg2);
public static native int cgetustr(@Cast("char*") ByteBuffer arg0, String arg1, @Cast("char**") @ByPtrPtr ByteBuffer arg2);
public static native int cgetustr(@Cast("char*") byte[] arg0, @Cast("const char*") BytePointer arg1, @Cast("char**") @ByPtrPtr byte[] arg2);
public static native int cgetustr(@Cast("char*") BytePointer arg0, String arg1, @Cast("char**") @ByPtrPtr BytePointer arg2);
public static native int cgetustr(@Cast("char*") ByteBuffer arg0, @Cast("const char*") BytePointer arg1, @Cast("char**") @ByPtrPtr ByteBuffer arg2);
public static native int cgetustr(@Cast("char*") byte[] arg0, String arg1, @Cast("char**") @ByPtrPtr byte[] arg2);

public static native int daemon(int arg0, int arg1);
public static native @Cast("char*") BytePointer devname(@Cast("dev_t") int arg0, @Cast("mode_t") short arg1);
public static native @Cast("char*") BytePointer devname_r(@Cast("dev_t") int arg0, @Cast("mode_t") short arg1, @Cast("char*") BytePointer buf, int len);
public static native @Cast("char*") ByteBuffer devname_r(@Cast("dev_t") int arg0, @Cast("mode_t") short arg1, @Cast("char*") ByteBuffer buf, int len);
public static native @Cast("char*") byte[] devname_r(@Cast("dev_t") int arg0, @Cast("mode_t") short arg1, @Cast("char*") byte[] buf, int len);
public static native @Cast("char*") BytePointer getbsize(IntPointer arg0, CLongPointer arg1);
public static native @Cast("char*") ByteBuffer getbsize(IntBuffer arg0, CLongPointer arg1);
public static native @Cast("char*") byte[] getbsize(int[] arg0, CLongPointer arg1);
public static native int getloadavg(DoublePointer arg0, int arg1);
public static native int getloadavg(DoubleBuffer arg0, int arg1);
public static native int getloadavg(double[] arg0, int arg1);
public static native @Cast("const char*") BytePointer getprogname();
public static native void setprogname(@Cast("const char*") BytePointer arg0);
public static native void setprogname(String arg0);

// #ifdef __BLOCKS__
// #endif /* __BLOCKS__ */

public static native int heapsort(Pointer __base, @Cast("size_t") long __nel, @Cast("size_t") long __width,
	    _Nonnull__compar_Pointer_Pointer _Nonnull__compar);
// #ifdef __BLOCKS__
// #endif /* __BLOCKS__ */
public static native int mergesort(Pointer __base, @Cast("size_t") long __nel, @Cast("size_t") long __width,
	    _Nonnull__compar_Pointer_Pointer _Nonnull__compar);
// #ifdef __BLOCKS__
// #endif /* __BLOCKS__ */
public static native void psort(Pointer __base, @Cast("size_t") long __nel, @Cast("size_t") long __width,
	    _Nonnull__compar_Pointer_Pointer _Nonnull__compar);
// Targeting ../macosx/_Nonnull__compar_Pointer_Pointer_Pointer.java


public static native void psort_r(Pointer __base, @Cast("size_t") long __nel, @Cast("size_t") long __width, Pointer arg3,
	    _Nonnull__compar_Pointer_Pointer_Pointer _Nonnull__compar);
// #ifdef __BLOCKS__
// #endif /* __BLOCKS__ */
public static native void qsort_r(Pointer __base, @Cast("size_t") long __nel, @Cast("size_t") long __width, Pointer arg3,
	    _Nonnull__compar_Pointer_Pointer_Pointer _Nonnull__compar);
public static native int radixsort(@Cast("const unsigned char**") PointerPointer __base, int __nel, @Cast("const unsigned char*") BytePointer __table,
	    @Cast("unsigned") int __endbyte);
public static native int radixsort(@Cast("const unsigned char**") @ByPtrPtr BytePointer __base, int __nel, @Cast("const unsigned char*") BytePointer __table,
	    @Cast("unsigned") int __endbyte);
public static native int radixsort(@Cast("const unsigned char**") @ByPtrPtr ByteBuffer __base, int __nel, @Cast("const unsigned char*") ByteBuffer __table,
	    @Cast("unsigned") int __endbyte);
public static native int radixsort(@Cast("const unsigned char**") @ByPtrPtr byte[] __base, int __nel, @Cast("const unsigned char*") byte[] __table,
	    @Cast("unsigned") int __endbyte);
public static native int rpmatch(@Cast("const char*") BytePointer arg0);
public static native int rpmatch(String arg0);
public static native int sradixsort(@Cast("const unsigned char**") PointerPointer __base, int __nel, @Cast("const unsigned char*") BytePointer __table,
	    @Cast("unsigned") int __endbyte);
public static native int sradixsort(@Cast("const unsigned char**") @ByPtrPtr BytePointer __base, int __nel, @Cast("const unsigned char*") BytePointer __table,
	    @Cast("unsigned") int __endbyte);
public static native int sradixsort(@Cast("const unsigned char**") @ByPtrPtr ByteBuffer __base, int __nel, @Cast("const unsigned char*") ByteBuffer __table,
	    @Cast("unsigned") int __endbyte);
public static native int sradixsort(@Cast("const unsigned char**") @ByPtrPtr byte[] __base, int __nel, @Cast("const unsigned char*") byte[] __table,
	    @Cast("unsigned") int __endbyte);
public static native void sranddev();
public static native void srandomdev();
public static native Pointer reallocf(Pointer __ptr, @Cast("size_t") long __size);
public static native long strtonum(@Cast("const char*") BytePointer __numstr, long __minval, long __maxval, @Cast("const char**") PointerPointer __errstrp);
public static native long strtonum(@Cast("const char*") BytePointer __numstr, long __minval, long __maxval, @Cast("const char**") @ByPtrPtr BytePointer __errstrp);
public static native long strtonum(String __numstr, long __minval, long __maxval, @Cast("const char**") @ByPtrPtr ByteBuffer __errstrp);
public static native long strtonum(@Cast("const char*") BytePointer __numstr, long __minval, long __maxval, @Cast("const char**") @ByPtrPtr byte[] __errstrp);
public static native long strtonum(String __numstr, long __minval, long __maxval, @Cast("const char**") @ByPtrPtr BytePointer __errstrp);
public static native long strtonum(@Cast("const char*") BytePointer __numstr, long __minval, long __maxval, @Cast("const char**") @ByPtrPtr ByteBuffer __errstrp);
public static native long strtonum(String __numstr, long __minval, long __maxval, @Cast("const char**") @ByPtrPtr byte[] __errstrp);
// #if !__DARWIN_NO_LONG_LONG
public static native long strtoq(@Cast("const char*") BytePointer __str, @Cast("char**") PointerPointer __endptr, int __base);
public static native long strtoq(@Cast("const char*") BytePointer __str, @Cast("char**") @ByPtrPtr BytePointer __endptr, int __base);
public static native long strtoq(String __str, @Cast("char**") @ByPtrPtr ByteBuffer __endptr, int __base);
public static native long strtoq(@Cast("const char*") BytePointer __str, @Cast("char**") @ByPtrPtr byte[] __endptr, int __base);
public static native long strtoq(String __str, @Cast("char**") @ByPtrPtr BytePointer __endptr, int __base);
public static native long strtoq(@Cast("const char*") BytePointer __str, @Cast("char**") @ByPtrPtr ByteBuffer __endptr, int __base);
public static native long strtoq(String __str, @Cast("char**") @ByPtrPtr byte[] __endptr, int __base);
public static native @Cast("unsigned long long") long strtouq(@Cast("const char*") BytePointer __str, @Cast("char**") PointerPointer __endptr, int __base);
public static native @Cast("unsigned long long") long strtouq(@Cast("const char*") BytePointer __str, @Cast("char**") @ByPtrPtr BytePointer __endptr, int __base);
public static native @Cast("unsigned long long") long strtouq(String __str, @Cast("char**") @ByPtrPtr ByteBuffer __endptr, int __base);
public static native @Cast("unsigned long long") long strtouq(@Cast("const char*") BytePointer __str, @Cast("char**") @ByPtrPtr byte[] __endptr, int __base);
public static native @Cast("unsigned long long") long strtouq(String __str, @Cast("char**") @ByPtrPtr BytePointer __endptr, int __base);
public static native @Cast("unsigned long long") long strtouq(@Cast("const char*") BytePointer __str, @Cast("char**") @ByPtrPtr ByteBuffer __endptr, int __base);
public static native @Cast("unsigned long long") long strtouq(String __str, @Cast("char**") @ByPtrPtr byte[] __endptr, int __base);
// #endif /* !__DARWIN_NO_LONG_LONG */
public static native @Cast("char*") BytePointer suboptarg(); public static native void suboptarg(BytePointer setter);		/* getsubopt(3) external variable */
/* valloc is now declared in _malloc.h */
// #endif	/* !_ANSI_SOURCE && !_POSIX_SOURCE */

/* Poison the following routines if -fshort-wchar is set */
// #if !defined(__cplusplus) && defined(__WCHAR_MAX__) && __WCHAR_MAX__ <= 0xffff
// #pragma GCC poison mbstowcs mbtowc wcstombs wctomb
// #endif
// #ifdef _USE_EXTENDED_LOCALES_
// #endif /* _USE_EXTENDED_LOCALES_ */

// #endif /* _STDLIB_H_ */


// Parsed from sys/_types/_timespec.h

/*
 * Copyright (c) 2003-2012 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
// #ifndef _STRUCT_TIMESPEC
// #define _STRUCT_TIMESPEC        struct timespec

// #include <machine/types.h>
// Targeting ../macosx/timespec.java


// #endif /* _STRUCT_TIMESPEC */


// Parsed from sys/_types/_timeval.h

/*
 * Copyright (c) 2003-2012 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
// #ifndef _STRUCT_TIMEVAL
// #define _STRUCT_TIMEVAL         struct timeval

// #include <machine/types.h> /* __darwin_time_t */
// #include <sys/_types.h>
// Targeting ../macosx/timeval.java


// #endif /* _STRUCT_TIMEVAL */


// Parsed from sys/time.h

/*
 * Copyright (c) 2000-2006 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
/* Copyright (c) 1995 NeXT Computer, Inc. All Rights Reserved */
/*
 * Copyright (c) 1982, 1986, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)time.h	8.2 (Berkeley) 7/10/94
 */

// #ifndef _SYS_TIME_H_
// #define _SYS_TIME_H_

// #include <sys/cdefs.h>
// #include <sys/_types.h>
// #include <Availability.h>

/*
 * [XSI] The fd_set type shall be defined as described in <sys/select.h>.
 * The timespec structure shall be defined as described in <time.h>
 */
// #include <sys/_types/_fd_def.h>
// #include <sys/_types/_timespec.h>
// #include <sys/_types/_timeval.h>

// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
// #include <sys/_types/_timeval64.h>
// #endif /* !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE) */


// #include <sys/_types/_time_t.h>
// #include <sys/_types/_suseconds_t.h>
// Targeting ../macosx/itimerval.java



/*
 * Names of the interval timers, and structure
 * defining a timer setting.
 */
public static final int ITIMER_REAL =     0;
public static final int ITIMER_VIRTUAL =  1;
public static final int ITIMER_PROF =     2;

/*
 * Select uses bit masks of file descriptors in longs.  These macros
 * manipulate such bit fields (the filesystem macros use chars).  The
 * extra protection here is to permit application redefinition above
 * the default size.
 */
// #include <sys/_types/_fd_setsize.h>
// #include <sys/_types/_fd_set.h>
// #include <sys/_types/_fd_clr.h>
// #include <sys/_types/_fd_isset.h>
// #include <sys/_types/_fd_zero.h>

// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)

// #include <sys/_types/_fd_copy.h>

// #define TIMEVAL_TO_TIMESPEC(tv, ts) {
// 	(ts)->tv_sec = (tv)->tv_sec;
// 	(ts)->tv_nsec = (tv)->tv_usec * 1000;
// }
// #define TIMESPEC_TO_TIMEVAL(tv, ts) {
// 	(tv)->tv_sec = (ts)->tv_sec;
// 	(tv)->tv_usec = (ts)->tv_nsec / 1000;
// }
// Targeting ../macosx/timezone.java


public static final int DST_NONE =        0;       /* not on dst */
public static final int DST_USA =         1;       /* USA style dst */
public static final int DST_AUST =        2;       /* Australian style dst */
public static final int DST_WET =         3;       /* Western European dst */
public static final int DST_MET =         4;       /* Middle European dst */
public static final int DST_EET =         5;       /* Eastern European dst */
public static final int DST_CAN =         6;       /* Canada */

/* Operations on timevals. */
// #define timerclear(tvp)         (tvp)->tv_sec = (tvp)->tv_usec = 0
// #define timerisset(tvp)         ((tvp)->tv_sec || (tvp)->tv_usec)
// #define timercmp(tvp, uvp, cmp)
// 	(((tvp)->tv_sec == (uvp)->tv_sec) ?
// 	    ((tvp)->tv_usec cmp (uvp)->tv_usec) :
// 	    ((tvp)->tv_sec cmp (uvp)->tv_sec))
// #define timeradd(tvp, uvp, vvp)
// 	do {
// 	        (vvp)->tv_sec = (tvp)->tv_sec + (uvp)->tv_sec;
// 	        (vvp)->tv_usec = (tvp)->tv_usec + (uvp)->tv_usec;
// 	        if ((vvp)->tv_usec >= 1000000) {
// 	                (vvp)->tv_sec++;
// 	                (vvp)->tv_usec -= 1000000;
// 	        }
// 	} while (0)
// #define timersub(tvp, uvp, vvp)
// 	do {
// 	        (vvp)->tv_sec = (tvp)->tv_sec - (uvp)->tv_sec;
// 	        (vvp)->tv_usec = (tvp)->tv_usec - (uvp)->tv_usec;
// 	        if ((vvp)->tv_usec < 0) {
// 	                (vvp)->tv_sec--;
// 	                (vvp)->tv_usec += 1000000;
// 	        }
// 	} while (0)

// #define timevalcmp(l, r, cmp)   timercmp(l, r, cmp)
// Targeting ../macosx/clockinfo.java


// #endif /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */



// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
// #include <time.h>
// #endif /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */

// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static native int adjtime(@Const timeval arg0, timeval arg1);
public static native int futimes(int arg0, @Const timeval arg1);
public static native int lutimes(@Cast("const char*") BytePointer arg0, @Const timeval arg1);
public static native int lutimes(String arg0, @Const timeval arg1);
public static native int settimeofday(@Const timeval arg0, @Const timezone arg1);
// #endif /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */

public static native int getitimer(int arg0, itimerval arg1);
public static native int gettimeofday(timeval arg0, Pointer arg1);

// #include <sys/_select.h>        /* select() prototype */

public static native int setitimer(int arg0, @Const itimerval arg1,
    itimerval arg2);
public static native int utimes(@Cast("const char*") BytePointer arg0, @Const timeval arg1);
public static native int utimes(String arg0, @Const timeval arg1);

// #endif /* !_SYS_TIME_H_ */


// Parsed from time.h

/*
 * Copyright (c) 2000 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
 * Copyright (c) 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)time.h	8.3 (Berkeley) 1/21/94
 */

// #ifndef _TIME_H_
// #define	_TIME_H_

// #include <_types.h>
// #include <sys/cdefs.h>
// #include <Availability.h>
// #include <sys/_types/_clock_t.h>
// #include <sys/_types/_null.h>
// #include <sys/_types/_size_t.h>
// #include <sys/_types/_time_t.h>
// #include <sys/_types/_timespec.h>
// Targeting ../macosx/tm.java



// #if __DARWIN_UNIX03
public static native @MemberGetter long CLOCKS_PER_SEC();
public static final long CLOCKS_PER_SEC = CLOCKS_PER_SEC();	/* [XSI] */
// #else /* !__DARWIN_UNIX03 */
// #endif /* __DARWIN_UNIX03 */

// #ifndef _ANSI_SOURCE
public static native @Cast("char*") BytePointer tzname(int i); public static native void tzname(int i, BytePointer setter);
@MemberGetter public static native @Cast("char**") PointerPointer tzname();
// #endif

public static native int getdate_err(); public static native void getdate_err(int setter);
// #if __DARWIN_UNIX03
public static native long timezone(); public static native void timezone(long setter);
// #endif /* __DARWIN_UNIX03 */
public static native int daylight(); public static native void daylight(int setter);

public static native @Cast("char*") BytePointer asctime(@Const tm arg0);
public static native @Cast("clock_t") long clock();
public static native @Cast("char*") BytePointer ctime(@Cast("const time_t*") Pointer arg0);
public static native double difftime(@ByVal @Cast("time_t*") Pointer arg0, @ByVal @Cast("time_t*") Pointer arg1);
public static native tm getdate(@Cast("const char*") BytePointer arg0);
public static native tm getdate(String arg0);
public static native tm gmtime(@Cast("const time_t*") Pointer arg0);
public static native tm localtime(@Cast("const time_t*") Pointer arg0);
public static native @ByVal @Cast("time_t*") Pointer mktime(tm arg0);
public static native @Cast("size_t") long strftime(@Cast("char*") BytePointer arg0, @Cast("size_t") long arg1, @Cast("const char*") BytePointer arg2, @Const tm arg3);
public static native @Cast("size_t") long strftime(@Cast("char*") ByteBuffer arg0, @Cast("size_t") long arg1, String arg2, @Const tm arg3);
public static native @Cast("size_t") long strftime(@Cast("char*") byte[] arg0, @Cast("size_t") long arg1, @Cast("const char*") BytePointer arg2, @Const tm arg3);
public static native @Cast("size_t") long strftime(@Cast("char*") BytePointer arg0, @Cast("size_t") long arg1, String arg2, @Const tm arg3);
public static native @Cast("size_t") long strftime(@Cast("char*") ByteBuffer arg0, @Cast("size_t") long arg1, @Cast("const char*") BytePointer arg2, @Const tm arg3);
public static native @Cast("size_t") long strftime(@Cast("char*") byte[] arg0, @Cast("size_t") long arg1, String arg2, @Const tm arg3);
public static native @Cast("char*") BytePointer strptime(@Cast("const char*") BytePointer arg0, @Cast("const char*") BytePointer arg1, tm arg2);
public static native @Cast("char*") ByteBuffer strptime(String arg0, String arg1, tm arg2);
public static native @ByVal @Cast("time_t*") Pointer time(@Cast("time_t*") Pointer arg0);

// #ifndef _ANSI_SOURCE
public static native void tzset();
// #endif /* not ANSI */

/* [TSF] Thread safe functions */
public static native @Cast("char*") BytePointer asctime_r(@Const tm arg0, @Cast("char*") BytePointer arg1);
public static native @Cast("char*") ByteBuffer asctime_r(@Const tm arg0, @Cast("char*") ByteBuffer arg1);
public static native @Cast("char*") byte[] asctime_r(@Const tm arg0, @Cast("char*") byte[] arg1);
public static native @Cast("char*") BytePointer ctime_r(@Cast("const time_t*") Pointer arg0, @Cast("char*") BytePointer arg1);
public static native @Cast("char*") ByteBuffer ctime_r(@Cast("const time_t*") Pointer arg0, @Cast("char*") ByteBuffer arg1);
public static native @Cast("char*") byte[] ctime_r(@Cast("const time_t*") Pointer arg0, @Cast("char*") byte[] arg1);
public static native tm gmtime_r(@Cast("const time_t*") Pointer arg0, tm arg1);
public static native tm localtime_r(@Cast("const time_t*") Pointer arg0, tm arg1);

// #if !defined(_ANSI_SOURCE) && (!defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE))
public static native @ByVal @Cast("time_t*") Pointer posix2time(@ByVal @Cast("time_t*") Pointer arg0);
// #if !__DARWIN_UNIX03
// #endif /* !__DARWIN_UNIX03 */
public static native void tzsetwall();
public static native @ByVal @Cast("time_t*") Pointer time2posix(@ByVal @Cast("time_t*") Pointer arg0);
public static native @ByVal @Cast("time_t*") Pointer timelocal(tm arg0);
public static native @ByVal @Cast("time_t*") Pointer timegm(tm arg0);
// #endif /* neither ANSI nor POSIX */

// #if !defined(_ANSI_SOURCE)
public static native int nanosleep(@Const timespec __rqtp, timespec __rmtp);
// #endif

// #if !defined(_DARWIN_FEATURE_CLOCK_GETTIME) || _DARWIN_FEATURE_CLOCK_GETTIME != 0
// #if __DARWIN_C_LEVEL >= 199309L
// #if __has_feature(enumerator_attributes)
// #define __CLOCK_AVAILABILITY __OSX_AVAILABLE(10.12) __IOS_AVAILABLE(10.0) __TVOS_AVAILABLE(10.0) __WATCHOS_AVAILABLE(3.0)
// #else
// #define __CLOCK_AVAILABILITY
// #endif

/** enum clockid_t */
public static final int
_CLOCK_REALTIME = 0;
public static final int CLOCK_REALTIME = _CLOCK_REALTIME;
public static final int
_CLOCK_MONOTONIC = 6;
public static final int CLOCK_MONOTONIC = _CLOCK_MONOTONIC;
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int
_CLOCK_MONOTONIC_RAW = 4;
public static final int CLOCK_MONOTONIC_RAW = _CLOCK_MONOTONIC_RAW;
public static final int
_CLOCK_MONOTONIC_RAW_APPROX = 5;
public static final int CLOCK_MONOTONIC_RAW_APPROX = _CLOCK_MONOTONIC_RAW_APPROX;
public static final int
_CLOCK_UPTIME_RAW = 8;
public static final int CLOCK_UPTIME_RAW = _CLOCK_UPTIME_RAW;
public static final int
_CLOCK_UPTIME_RAW_APPROX = 9;
public static final int CLOCK_UPTIME_RAW_APPROX = _CLOCK_UPTIME_RAW_APPROX;
// #endif
public static final int
_CLOCK_PROCESS_CPUTIME_ID = 12;
public static final int CLOCK_PROCESS_CPUTIME_ID = _CLOCK_PROCESS_CPUTIME_ID;
public static final int
_CLOCK_THREAD_CPUTIME_ID = 16;
public static final int CLOCK_THREAD_CPUTIME_ID = _CLOCK_THREAD_CPUTIME_ID;

public static native int clock_getres(@Cast("clockid_t") int __clock_id, timespec __res);

public static native int clock_gettime(@Cast("clockid_t") int __clock_id, timespec __tp);

// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static native @Cast("__uint64_t") long clock_gettime_nsec_np(@Cast("clockid_t") int __clock_id);
// #endif

public static native int clock_settime(@Cast("clockid_t") int __clock_id, @Const timespec __tp);

// #undef __CLOCK_AVAILABILITY
// #endif /* __DARWIN_C_LEVEL */
// #endif /* _DARWIN_FEATURE_CLOCK_GETTIME */

// #if (__DARWIN_C_LEVEL >= __DARWIN_C_FULL) &&
//         ((defined(__STDC_VERSION__) && __STDC_VERSION__ >= 201112L) ||
//         (defined(__cplusplus) && __cplusplus >= 201703L))
/* ISO/IEC 9899:201x 7.27.2.5 The timespec_get function */
public static final int TIME_UTC =	1;	/* time elapsed since epoch */

// #endif

// #ifdef _USE_EXTENDED_LOCALES_
// #endif /* _USE_EXTENDED_LOCALES_ */

// #endif /* !_TIME_H_ */


// Parsed from utime.h

/*
 * Copyright (c) 2000 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)utime.h	8.1 (Berkeley) 6/2/93
 */

// #ifndef	_UTIME_H_
// #define	_UTIME_H_

// #include <_types.h>
// #include <sys/_types/_time_t.h>
// Targeting ../macosx/utimbuf.java



// #include <sys/cdefs.h>

public static native int utime(@Cast("const char*") BytePointer arg0, @Const utimbuf arg1);
public static native int utime(String arg0, @Const utimbuf arg1);
// #endif /* !_UTIME_H_ */


// Parsed from sys/_types/_s_ifmt.h

/*
 * Copyright (c) 2003-2012 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */

/*
 * [XSI] The symbolic names for file modes for use as values of mode_t
 * shall be defined as described in <sys/stat.h>
 */
// #ifndef S_IFMT
/* File type */
public static final int S_IFMT =          0170000;         /* [XSI] type of file mask */
public static final int S_IFIFO =         0010000;         /* [XSI] named pipe (fifo) */
public static final int S_IFCHR =         0020000;         /* [XSI] character special */
public static final int S_IFDIR =         0040000;         /* [XSI] directory */
public static final int S_IFBLK =         0060000;         /* [XSI] block special */
public static final int S_IFREG =         0100000;         /* [XSI] regular */
public static final int S_IFLNK =         0120000;         /* [XSI] symbolic link */
public static final int S_IFSOCK =        0140000;         /* [XSI] socket */
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int S_IFWHT =         0160000;         /* OBSOLETE: whiteout */
// #endif

/* File mode */
/* Read, write, execute/search by owner */
public static final int S_IRWXU =         0000700;         /* [XSI] RWX mask for owner */
public static final int S_IRUSR =         0000400;         /* [XSI] R for owner */
public static final int S_IWUSR =         0000200;         /* [XSI] W for owner */
public static final int S_IXUSR =         0000100;         /* [XSI] X for owner */
/* Read, write, execute/search by group */
public static final int S_IRWXG =         0000070;         /* [XSI] RWX mask for group */
public static final int S_IRGRP =         0000040;         /* [XSI] R for group */
public static final int S_IWGRP =         0000020;         /* [XSI] W for group */
public static final int S_IXGRP =         0000010;         /* [XSI] X for group */
/* Read, write, execute/search by others */
public static final int S_IRWXO =         0000007;         /* [XSI] RWX mask for other */
public static final int S_IROTH =         0000004;         /* [XSI] R for other */
public static final int S_IWOTH =         0000002;         /* [XSI] W for other */
public static final int S_IXOTH =         0000001;         /* [XSI] X for other */

public static final int S_ISUID =         0004000;         /* [XSI] set user id on execution */
public static final int S_ISGID =         0002000;         /* [XSI] set group id on execution */
public static final int S_ISVTX =         0001000;         /* [XSI] directory restrcted delete */

// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int S_ISTXT =         S_ISVTX;         /* sticky bit: not supported */
public static final int S_IREAD =         S_IRUSR;         /* backward compatability */
public static final int S_IWRITE =        S_IWUSR;         /* backward compatability */
public static final int S_IEXEC =         S_IXUSR;         /* backward compatability */
// #endif
// #endif  /* !S_IFMT */


// Parsed from sys/_types/_filesec_t.h

/*
 * Copyright (c) 2003-2012 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
// #ifndef _FILESEC_T
// #define _FILESEC_T
// Targeting ../macosx/_filesec.java


// #endif /* _FILESEC_T */


// Parsed from sys/stat.h

/*
 * Copyright (c) 2000-2014 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
/* Copyright (c) 1995 NeXT Computer, Inc. All Rights Reserved */
/*-
 * Copyright (c) 1982, 1986, 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)stat.h	8.9 (Berkeley) 8/17/94
 */


// #ifndef _SYS_STAT_H_
// #define _SYS_STAT_H_

// #include <sys/_types.h>
// #include <sys/cdefs.h>
// #include <Availability.h>

/* [XSI] The timespec structure may be defined as described in <time.h> */
// #include <sys/_types/_timespec.h>

/*
 * [XSI] The blkcnt_t, blksize_t, dev_t, ino_t, mode_t, nlink_t, uid_t,
 * gid_t, off_t, and time_t types shall be defined as described in
 * <sys/types.h>.
 */
// #include <sys/_types/_blkcnt_t.h>
// #include <sys/_types/_blksize_t.h>
// #include <sys/_types/_dev_t.h>                  /* device number */
// #include <sys/_types/_ino_t.h>

// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
// #include <sys/_types/_ino64_t.h>
// #endif /* !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE) */

// #include <sys/_types/_mode_t.h>
// #include <sys/_types/_nlink_t.h>
// #include <sys/_types/_uid_t.h>
// #include <sys/_types/_gid_t.h>
// #include <sys/_types/_off_t.h>
// #include <sys/_types/_time_t.h>
// Targeting ../macosx/ostat.java



// #define __DARWIN_STRUCT_STAT64_TIMES
// 	struct timespec st_atimespec;           /* time of last access */
// 	struct timespec st_mtimespec;           /* time of last data modification */
// 	struct timespec st_ctimespec;           /* time of last status change */
// 	struct timespec st_birthtimespec;       /* time of file creation(birth) */

// #else /* (_POSIX_C_SOURCE && !_DARWIN_C_SOURCE) */

// #endif /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */

/*
 * This structure is used as the second parameter to the fstat64(),
 * lstat64(), and stat64() functions, and for struct stat when
 * __DARWIN_64_BIT_INO_T is set. __DARWIN_STRUCT_STAT64 is defined
 * above, depending on whether we use struct timespec or the direct
 * components.
 *
 * This is simillar to stat except for 64bit inode number
 * number instead of 32bit ino_t and the addition of create(birth) time.
 */
// #define __DARWIN_STRUCT_STAT64 {
// 	dev_t		st_dev;                 /* [XSI] ID of device containing file */
// 	mode_t		st_mode;                /* [XSI] Mode of file (see below) */
// 	nlink_t		st_nlink;               /* [XSI] Number of hard links */
// 	__darwin_ino64_t st_ino;                /* [XSI] File serial number */
// 	uid_t		st_uid;                 /* [XSI] User ID of the file */
// 	gid_t		st_gid;                 /* [XSI] Group ID of the file */
// 	dev_t		st_rdev;                /* [XSI] Device ID */
// 	__DARWIN_STRUCT_STAT64_TIMES
// 	off_t		st_size;                /* [XSI] file size, in bytes */
// 	blkcnt_t	st_blocks;              /* [XSI] blocks allocated for file */
// 	blksize_t	st_blksize;             /* [XSI] optimal blocksize for I/O */
// 	__uint32_t	st_flags;               /* user defined flags for file */
// 	__uint32_t	st_gen;                 /* file generation number */
// 	__int32_t	st_lspare;              /* RESERVED: DO NOT USE! */
// 	__int64_t	st_qspare[2];           /* RESERVED: DO NOT USE! */
// }
// Targeting ../macosx/stat.java



// #else /* !__DARWIN_64_BIT_INO_T */
// Targeting ../macosx/stat64.java



// #endif /* !__DARWIN_ONLY_64_BIT_INO_T */

// #endif /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */




// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
// #endif /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */

/*
 * [XSI] The following are symbolic names for the values of type mode_t.  They
 * are bitmap values.
 */
// #include <sys/_types/_s_ifmt.h>

/*
 * [XSI] The following macros shall be provided to test whether a file is
 * of the specified type.  The value m supplied to the macros is the value
 * of st_mode from a stat structure.  The macro shall evaluate to a non-zero
 * value if the test is true; 0 if the test is false.
 */
// #define S_ISBLK(m)      (((m) & S_IFMT) == S_IFBLK)     /* block special */
// #define S_ISCHR(m)      (((m) & S_IFMT) == S_IFCHR)     /* char special */
// #define S_ISDIR(m)      (((m) & S_IFMT) == S_IFDIR)     /* directory */
// #define S_ISFIFO(m)     (((m) & S_IFMT) == S_IFIFO)     /* fifo or socket */
// #define S_ISREG(m)      (((m) & S_IFMT) == S_IFREG)     /* regular file */
// #define S_ISLNK(m)      (((m) & S_IFMT) == S_IFLNK)     /* symbolic link */
// #define S_ISSOCK(m)     (((m) & S_IFMT) == S_IFSOCK)    /* socket */
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
// #define S_ISWHT(m)      (((m) & S_IFMT) == S_IFWHT)     /* OBSOLETE: whiteout */
// #endif

/*
 * [XSI] The implementation may implement message queues, semaphores, or
 * shared memory objects as distinct file types.  The following macros
 * shall be provided to test whether a file is of the specified type.
 * The value of the buf argument supplied to the macros is a pointer to
 * a stat structure.  The macro shall evaluate to a non-zero value if
 * the specified object is implemented as a distinct file type and the
 * specified file type is contained in the stat structure referenced by
 * buf.  Otherwise, the macro shall evaluate to zero.
 *
 * NOTE:	The current implementation does not do this, although
 *		this may change in future revisions, and co currently only
 *		provides these macros to ensure source compatability with
 *		implementations which do.
 */
// #define S_TYPEISMQ(buf)         (0)     /* Test for a message queue */
// #define S_TYPEISSEM(buf)        (0)     /* Test for a semaphore */
// #define S_TYPEISSHM(buf)        (0)     /* Test for a shared memory object */

/*
 * [TYM] The implementation may implement typed memory objects as distinct
 * file types, and the following macro shall test whether a file is of the
 * specified type.  The value of the buf argument supplied to the macros is
 * a pointer to a stat structure.  The macro shall evaluate to a non-zero
 * value if the specified object is implemented as a distinct file type and
 * the specified file type is contained in the stat structure referenced by
 * buf.  Otherwise, the macro shall evaluate to zero.
 *
 * NOTE:	The current implementation does not do this, although
 *		this may change in future revisions, and co currently only
 *		provides this macro to ensure source compatability with
 *		implementations which do.
 */
// #define S_TYPEISTMO(buf)        (0)     /* Test for a typed memory object */


// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int ACCESSPERMS =     (S_IRWXU|S_IRWXG|S_IRWXO);       /* 0777 */
                                                        /* 7777 */
public static final int ALLPERMS =        (S_ISUID|S_ISGID|S_ISTXT|S_IRWXU|S_IRWXG|S_IRWXO);
/* 0666 */
public static final int DEFFILEMODE =     (S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH);

public static final int S_BLKSIZE =       512;             /* block size used in the stat struct */

/*
 * Definitions of flags stored in file flags word.
 *
 * Super-user and owner changeable flags.
 */
public static final int UF_SETTABLE =     0x0000ffff;      /* mask of owner changeable flags */
public static final int UF_NODUMP =       0x00000001;      /* do not dump file */
public static final int UF_IMMUTABLE =    0x00000002;      /* file may not be changed */
public static final int UF_APPEND =       0x00000004;      /* writes to file may only append */
public static final int UF_OPAQUE =       0x00000008;      /* directory is opaque wrt. union */
/*
 * The following bit is reserved for FreeBSD.  It is not implemented
 * in Mac OS X.
 */
/* #define UF_NOUNLINK	0x00000010 */	/* file may not be removed or renamed */
public static final int UF_COMPRESSED =   0x00000020;      /* file is compressed (some file-systems) */

/* UF_TRACKED is used for dealing with document IDs.  We no longer issue
 *  notifications for deletes or renames for files which have UF_TRACKED set. */
public static final int UF_TRACKED =              0x00000040;

public static final int UF_DATAVAULT =    0x00000080;      /* entitlement required for reading */
                                        /* and writing */

/* Bits 0x0100 through 0x4000 are currently undefined. */
public static final int UF_HIDDEN =       0x00008000;      /* hint that this item should not be */
                                        /* displayed in a GUI */
/*
 * Super-user changeable flags.
 */
public static final int SF_SUPPORTED =    0x009f0000;      /* mask of superuser supported flags */
public static final int SF_SETTABLE =     0x3fff0000;      /* mask of superuser changeable flags */
public static final int SF_SYNTHETIC =    0xc0000000;      /* mask of system read-only synthetic flags */
public static final int SF_ARCHIVED =     0x00010000;      /* file is archived */
public static final int SF_IMMUTABLE =    0x00020000;      /* file may not be changed */
public static final int SF_APPEND =       0x00040000;      /* writes to file may only append */
public static final int SF_RESTRICTED =   0x00080000;      /* entitlement required for writing */
public static final int SF_NOUNLINK =     0x00100000;      /* Item may not be removed, renamed or mounted on */

/*
 * The following two bits are reserved for FreeBSD.  They are not
 * implemented in Mac OS X.
 */
/* #define SF_SNAPSHOT	0x00200000 */	/* snapshot inode */
/* NOTE: There is no SF_HIDDEN bit. */

public static final int SF_FIRMLINK =     0x00800000;      /* file is a firmlink */

/*
 * Synthetic flags.
 *
 * These are read-only.  We keep them out of SF_SUPPORTED so that
 * attempts to set them will fail.
 */
public static final int SF_DATALESS =     0x40000000;     /* file is dataless object */


// #endif

// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
/*
 * Extended flags ("EF") returned by ATTR_CMNEXT_EXT_FLAGS from getattrlist/getattrlistbulk
 */
public static final int EF_MAY_SHARE_BLOCKS =     0x00000001;      /* file may share blocks with another file */
public static final int EF_NO_XATTRS =            0x00000002;      /* file has no xattrs at all */
public static final int EF_IS_SYNC_ROOT =         0x00000004;      /* file is a sync root for iCloud */
public static final int EF_IS_PURGEABLE =         0x00000008;      /* file is purgeable */
public static final int EF_IS_SPARSE =            0x00000010;      /* file has at least one sparse region */
public static final int EF_IS_SYNTHETIC =         0x00000020;      /* a synthetic directory/symlink */
// #endif



/* [XSI] */
public static native int chmod(@Cast("const char*") BytePointer arg0, @Cast("mode_t") short arg1);
public static native int chmod(String arg0, @Cast("mode_t") short arg1);
public static native int fchmod(int arg0, @Cast("mode_t") short arg1);
public static native int fstat(int arg0, stat arg1);
public static native int lstat(@Cast("const char*") BytePointer arg0, stat arg1);
public static native int lstat(String arg0, stat arg1);
public static native int mkdir(@Cast("const char*") BytePointer arg0, @Cast("mode_t") short arg1);
public static native int mkdir(String arg0, @Cast("mode_t") short arg1);
public static native int mkfifo(@Cast("const char*") BytePointer arg0, @Cast("mode_t") short arg1);
public static native int mkfifo(String arg0, @Cast("mode_t") short arg1);
public static native int stat(@Cast("const char*") BytePointer arg0, stat arg1);
public static native int stat(String arg0, stat arg1);
public static native int mknod(@Cast("const char*") BytePointer arg0, @Cast("mode_t") short arg1, @Cast("dev_t") int arg2);
public static native int mknod(String arg0, @Cast("mode_t") short arg1, @Cast("dev_t") int arg2);
public static native @Cast("mode_t") short umask(@Cast("mode_t") short arg0);

// #if __DARWIN_C_LEVEL >= 200809L
public static native int fchmodat(int arg0, @Cast("const char*") BytePointer arg1, @Cast("mode_t") short arg2, int arg3);
public static native int fchmodat(int arg0, String arg1, @Cast("mode_t") short arg2, int arg3);
public static native int fstatat(int arg0, @Cast("const char*") BytePointer arg1, stat arg2, int arg3);
public static native int fstatat(int arg0, String arg1, stat arg2, int arg3);
public static native int mkdirat(int arg0, @Cast("const char*") BytePointer arg1, @Cast("mode_t") short arg2);
public static native int mkdirat(int arg0, String arg1, @Cast("mode_t") short arg2);

public static final int UTIME_NOW =       -1;
public static final int UTIME_OMIT =      -2;

public static native int futimens(int __fd, @Const timespec __times);
public static native int utimensat(int __fd, @Cast("const char*") BytePointer __path, @Const timespec __times,
    int __flag);
public static native int utimensat(int __fd, String __path, @Const timespec __times,
    int __flag);
// #endif

// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)

// #include <sys/_types/_filesec_t.h>

public static native int chflags(@Cast("const char*") BytePointer arg0, @Cast("__uint32_t") int arg1);
public static native int chflags(String arg0, @Cast("__uint32_t") int arg1);
public static native int chmodx_np(@Cast("const char*") BytePointer arg0, _filesec arg1);
public static native int chmodx_np(String arg0, _filesec arg1);
public static native int fchflags(int arg0, @Cast("__uint32_t") int arg1);
public static native int fchmodx_np(int arg0, _filesec arg1);
public static native int fstatx_np(int arg0, stat arg1, _filesec arg2);
public static native int lchflags(@Cast("const char*") BytePointer arg0, @Cast("__uint32_t") int arg1);
public static native int lchflags(String arg0, @Cast("__uint32_t") int arg1);
public static native int lchmod(@Cast("const char*") BytePointer arg0, @Cast("mode_t") short arg1);
public static native int lchmod(String arg0, @Cast("mode_t") short arg1);
public static native int lstatx_np(@Cast("const char*") BytePointer arg0, stat arg1, _filesec arg2);
public static native int lstatx_np(String arg0, stat arg1, _filesec arg2);
public static native int mkdirx_np(@Cast("const char*") BytePointer arg0, _filesec arg1);
public static native int mkdirx_np(String arg0, _filesec arg1);
public static native int mkfifox_np(@Cast("const char*") BytePointer arg0, _filesec arg1);
public static native int mkfifox_np(String arg0, _filesec arg1);
public static native int statx_np(@Cast("const char*") BytePointer arg0, stat arg1, _filesec arg2);
public static native int statx_np(String arg0, stat arg1, _filesec arg2);
public static native int umaskx_np(_filesec arg0);

// #if !__DARWIN_ONLY_64_BIT_INO_T
/* The following deprecated routines are simillar to stat and friends except provide struct stat64 instead of struct stat  */
public static native int fstatx64_np(int arg0, stat64 arg1, _filesec arg2);
public static native int lstatx64_np(@Cast("const char*") BytePointer arg0, stat64 arg1, _filesec arg2);
public static native int lstatx64_np(String arg0, stat64 arg1, _filesec arg2);
public static native int statx64_np(@Cast("const char*") BytePointer arg0, stat64 arg1, _filesec arg2);
public static native int statx64_np(String arg0, stat64 arg1, _filesec arg2);
public static native int fstat64(int arg0, stat64 arg1);
public static native int lstat64(@Cast("const char*") BytePointer arg0, stat64 arg1);
public static native int lstat64(String arg0, stat64 arg1);
public static native int stat64(@Cast("const char*") BytePointer arg0, stat64 arg1);
public static native int stat64(String arg0, stat64 arg1);
// #endif /* !__DARWIN_ONLY_64_BIT_INO_T */
// #endif /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */

// #endif /* !_SYS_STAT_H_ */


// Parsed from fcntl.h

/*
 * Copyright (c) 2000 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
// #include <sys/fcntl.h>


// Parsed from sys/file.h

/*
 * Copyright (c) 2000-2008 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
/* Copyright (c) 1995, 1997 Apple Computer, Inc. All Rights Reserved */
/*
 * Copyright (c) 1982, 1986, 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)file.h	8.3 (Berkeley) 1/9/95
 */

// #ifndef _SYS_FILE_H_
// #define _SYS_FILE_H_

// #include <sys/appleapiopts.h>
// #include <sys/types.h>
// #include <sys/fcntl.h>
// #include <sys/unistd.h>
// #include <sys/queue.h>
// #include <sys/cdefs.h>


// #ifndef _KAUTH_CRED_T
// #define _KAUTH_CRED_T
// Targeting ../macosx/ucred.java


// Targeting ../macosx/posix_cred.java


// #endif  /* !_KAUTH_CRED_T */

// #endif /* !_SYS_FILE_H_ */


// Parsed from grp.h

/*-
 * Copyright (c) 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)grp.h	8.2 (Berkeley) 1/21/94
 */
/* Portions copyright (c) 2000-2018 Apple Inc. All rights reserved. */ 

// #ifndef _GRP_H_
// #define	_GRP_H_

// #include <_types.h>
// #include <sys/_types/_gid_t.h>	/* [XBD] */
// #include <sys/_types/_size_t.h> /* SUSv4 */

// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final String _PATH_GROUP =		"/etc/group";
// Targeting ../macosx/group.java



// #include <sys/cdefs.h>

/* [XBD] */
public static native group getgrgid(@Cast("gid_t") int arg0);
public static native group getgrnam(@Cast("const char*") BytePointer arg0);
public static native group getgrnam(String arg0);
/* [TSF] */
public static native int getgrgid_r(@Cast("gid_t") int arg0, group arg1, @Cast("char*") BytePointer arg2, @Cast("size_t") long arg3, @Cast("group**") PointerPointer arg4);
public static native int getgrgid_r(@Cast("gid_t") int arg0, group arg1, @Cast("char*") BytePointer arg2, @Cast("size_t") long arg3, @ByPtrPtr group arg4);
public static native int getgrgid_r(@Cast("gid_t") int arg0, group arg1, @Cast("char*") ByteBuffer arg2, @Cast("size_t") long arg3, @ByPtrPtr group arg4);
public static native int getgrgid_r(@Cast("gid_t") int arg0, group arg1, @Cast("char*") byte[] arg2, @Cast("size_t") long arg3, @ByPtrPtr group arg4);
public static native int getgrnam_r(@Cast("const char*") BytePointer arg0, group arg1, @Cast("char*") BytePointer arg2, @Cast("size_t") long arg3, @Cast("group**") PointerPointer arg4);
public static native int getgrnam_r(@Cast("const char*") BytePointer arg0, group arg1, @Cast("char*") BytePointer arg2, @Cast("size_t") long arg3, @ByPtrPtr group arg4);
public static native int getgrnam_r(String arg0, group arg1, @Cast("char*") ByteBuffer arg2, @Cast("size_t") long arg3, @ByPtrPtr group arg4);
public static native int getgrnam_r(@Cast("const char*") BytePointer arg0, group arg1, @Cast("char*") byte[] arg2, @Cast("size_t") long arg3, @ByPtrPtr group arg4);
public static native int getgrnam_r(String arg0, group arg1, @Cast("char*") BytePointer arg2, @Cast("size_t") long arg3, @ByPtrPtr group arg4);
public static native int getgrnam_r(@Cast("const char*") BytePointer arg0, group arg1, @Cast("char*") ByteBuffer arg2, @Cast("size_t") long arg3, @ByPtrPtr group arg4);
public static native int getgrnam_r(String arg0, group arg1, @Cast("char*") byte[] arg2, @Cast("size_t") long arg3, @ByPtrPtr group arg4);
/* [XSI] */
public static native group getgrent();
public static native void setgrent();
public static native void endgrent();
// #if (!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE)) || defined(_DARWIN_C_SOURCE)
// #include <uuid/uuid.h>
public static native @Cast("char*") BytePointer group_from_gid(@Cast("gid_t") int arg0, int arg1);
public static native group getgruuid(@Cast("unsigned char*") BytePointer arg0);
public static native group getgruuid(@Cast("unsigned char*") ByteBuffer arg0);
public static native group getgruuid(@Cast("unsigned char*") byte[] arg0);
public static native int getgruuid_r(@Cast("unsigned char*") BytePointer arg0, group arg1, @Cast("char*") BytePointer arg2, @Cast("size_t") long arg3, @Cast("group**") PointerPointer arg4);
public static native int getgruuid_r(@Cast("unsigned char*") BytePointer arg0, group arg1, @Cast("char*") BytePointer arg2, @Cast("size_t") long arg3, @ByPtrPtr group arg4);
public static native int getgruuid_r(@Cast("unsigned char*") ByteBuffer arg0, group arg1, @Cast("char*") ByteBuffer arg2, @Cast("size_t") long arg3, @ByPtrPtr group arg4);
public static native int getgruuid_r(@Cast("unsigned char*") byte[] arg0, group arg1, @Cast("char*") byte[] arg2, @Cast("size_t") long arg3, @ByPtrPtr group arg4);
// #endif

// #if !defined(_XOPEN_SOURCE) || defined(_DARWIN_C_SOURCE)
// #if (!defined(LIBINFO_INSTALL_API) || !LIBINFO_INSTALL_API)
public static native void setgrfile(@Cast("const char*") BytePointer arg0);
public static native void setgrfile(String arg0);
// #endif
public static native int setgroupent(int arg0);
// #endif

// #endif /* !_GRP_H_ */


// Parsed from pwd.h

/*-
 * Copyright (c) 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 * Portions Copyright(C) 1995, Jason Downs.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)pwd.h	8.2 (Berkeley) 1/21/94
 */
/* Portions copyright (c) 2000-2011 Apple Inc. All rights reserved. */

// #ifndef _PWD_H_
// #define	_PWD_H_

// #include <_types.h>
// #include <sys/_types/_gid_t.h>
// #include <sys/_types/_size_t.h>
// #include <sys/_types/_uid_t.h>

// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final String _PATH_PWD =		"/etc";
public static final String _PATH_PASSWD =		"/etc/passwd";
public static final String _PASSWD =			"passwd";
public static final String _PATH_MASTERPASSWD =	"/etc/master.passwd";
public static final String _PATH_MASTERPASSWD_LOCK =	"/etc/ptmp";
public static final String _MASTERPASSWD =		"master.passwd";

public static final String _PATH_MP_DB =		"/etc/pwd.db";
public static final String _MP_DB =			"pwd.db";
public static final String _PATH_SMP_DB =		"/etc/spwd.db";
public static final String _SMP_DB =			"spwd.db";

public static final String _PATH_PWD_MKDB =		"/usr/sbin/pwd_mkdb";

public static final int _PW_KEYBYNAME =		'1';	/* stored by name */
public static final int _PW_KEYBYNUM =		'2';	/* stored by entry in the "file" */
public static final int _PW_KEYBYUID =		'3';	/* stored by uid */

public static final int _PASSWORD_EFMT1 =		'_';	/* extended encryption format */

public static final int _PASSWORD_LEN =		128;	/* max length, not counting NULL */

public static final int _PASSWORD_NOUID =		0x01;	/* flag for no specified uid. */
public static final int _PASSWORD_NOGID =		0x02;	/* flag for no specified gid. */
public static final int _PASSWORD_NOCHG =		0x04;	/* flag for no specified change. */
public static final int _PASSWORD_NOEXP =		0x08;	/* flag for no specified expire. */

public static final int _PASSWORD_WARNDAYS =	14;	/* days to warn about expiry */
public static final int _PASSWORD_CHGNOW =	-1;
// Targeting ../macosx/passwd.java



// #include <sys/cdefs.h>

public static native passwd getpwuid(@Cast("uid_t") int arg0);
public static native passwd getpwnam(@Cast("const char*") BytePointer arg0);
public static native passwd getpwnam(String arg0);
public static native int getpwuid_r(@Cast("uid_t") int arg0, passwd arg1, @Cast("char*") BytePointer arg2, @Cast("size_t") long arg3, @Cast("passwd**") PointerPointer arg4);
public static native int getpwuid_r(@Cast("uid_t") int arg0, passwd arg1, @Cast("char*") BytePointer arg2, @Cast("size_t") long arg3, @ByPtrPtr passwd arg4);
public static native int getpwuid_r(@Cast("uid_t") int arg0, passwd arg1, @Cast("char*") ByteBuffer arg2, @Cast("size_t") long arg3, @ByPtrPtr passwd arg4);
public static native int getpwuid_r(@Cast("uid_t") int arg0, passwd arg1, @Cast("char*") byte[] arg2, @Cast("size_t") long arg3, @ByPtrPtr passwd arg4);
public static native int getpwnam_r(@Cast("const char*") BytePointer arg0, passwd arg1, @Cast("char*") BytePointer arg2, @Cast("size_t") long arg3, @Cast("passwd**") PointerPointer arg4);
public static native int getpwnam_r(@Cast("const char*") BytePointer arg0, passwd arg1, @Cast("char*") BytePointer arg2, @Cast("size_t") long arg3, @ByPtrPtr passwd arg4);
public static native int getpwnam_r(String arg0, passwd arg1, @Cast("char*") ByteBuffer arg2, @Cast("size_t") long arg3, @ByPtrPtr passwd arg4);
public static native int getpwnam_r(@Cast("const char*") BytePointer arg0, passwd arg1, @Cast("char*") byte[] arg2, @Cast("size_t") long arg3, @ByPtrPtr passwd arg4);
public static native int getpwnam_r(String arg0, passwd arg1, @Cast("char*") BytePointer arg2, @Cast("size_t") long arg3, @ByPtrPtr passwd arg4);
public static native int getpwnam_r(@Cast("const char*") BytePointer arg0, passwd arg1, @Cast("char*") ByteBuffer arg2, @Cast("size_t") long arg3, @ByPtrPtr passwd arg4);
public static native int getpwnam_r(String arg0, passwd arg1, @Cast("char*") byte[] arg2, @Cast("size_t") long arg3, @ByPtrPtr passwd arg4);
public static native passwd getpwent();
public static native void setpwent();
public static native void endpwent();
// #if (!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE)) || defined(_DARWIN_C_SOURCE)
// #include <uuid/uuid.h>
public static native int setpassent(int arg0);
public static native @Cast("char*") BytePointer user_from_uid(@Cast("uid_t") int arg0, int arg1);
public static native passwd getpwuuid(@Cast("unsigned char*") BytePointer arg0);
public static native passwd getpwuuid(@Cast("unsigned char*") ByteBuffer arg0);
public static native passwd getpwuuid(@Cast("unsigned char*") byte[] arg0);
public static native int getpwuuid_r(@Cast("unsigned char*") BytePointer arg0, passwd arg1, @Cast("char*") BytePointer arg2, @Cast("size_t") long arg3, @Cast("passwd**") PointerPointer arg4);
public static native int getpwuuid_r(@Cast("unsigned char*") BytePointer arg0, passwd arg1, @Cast("char*") BytePointer arg2, @Cast("size_t") long arg3, @ByPtrPtr passwd arg4);
public static native int getpwuuid_r(@Cast("unsigned char*") ByteBuffer arg0, passwd arg1, @Cast("char*") ByteBuffer arg2, @Cast("size_t") long arg3, @ByPtrPtr passwd arg4);
public static native int getpwuuid_r(@Cast("unsigned char*") byte[] arg0, passwd arg1, @Cast("char*") byte[] arg2, @Cast("size_t") long arg3, @ByPtrPtr passwd arg4);
// #endif

// #endif /* !_PWD_H_ */


// Parsed from sys/_types/_sigaltstack.h

/*
 * Copyright (c) 2003-2012 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */

/* Structure used in sigaltstack call. */
// #ifndef _STRUCT_SIGALTSTACK

// #include <sys/cdefs.h> /* __DARWIN_UNIX03 */

// #if __DARWIN_UNIX03
// #define _STRUCT_SIGALTSTACK     struct __darwin_sigaltstack
// #else /* !__DARWIN_UNIX03 */
// #endif /* __DARWIN_UNIX03 */

// #include <machine/types.h>
// Targeting ../macosx/stack_t.java

 /* [???] signal stack */

// #endif /* _STRUCT_SIGALTSTACK */


// Parsed from sys/signal.h

/*
 * Copyright (c) 2000-2006 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
/* Copyright (c) 1995 NeXT Computer, Inc. All Rights Reserved */
/*
 * Copyright (c) 1982, 1986, 1989, 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)signal.h	8.2 (Berkeley) 1/21/94
 */

// #ifndef _SYS_SIGNAL_H_
// #define _SYS_SIGNAL_H_

// #include <sys/cdefs.h>
// #include <sys/appleapiopts.h>
// #include <Availability.h>

public static final int __DARWIN_NSIG =   32;      /* counting 0; could be 33 (mask is 1-32) */

// #if !defined(_ANSI_SOURCE) && (!defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE))
public static native @MemberGetter long NSIG();
public static final long NSIG = NSIG();
// #endif

// #include <machine/signal.h>     /* sigcontext; codes for SIGILL, SIGFPE */

public static final int SIGHUP =  1;       /* hangup */
public static final int SIGINT =  2;       /* interrupt */
public static final int SIGQUIT = 3;       /* quit */
public static final int SIGILL =  4;       /* illegal instruction (not reset when caught) */
public static final int SIGTRAP = 5;       /* trace trap (not reset when caught) */
public static final int SIGABRT = 6;       /* abort() */
// #if  (defined(_POSIX_C_SOURCE) && !defined(_DARWIN_C_SOURCE))
public static final int SIGPOLL = 7;       /* pollable event ([XSR] generated, not supported) */
// #else   /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */
public static final int SIGIOT =  SIGABRT; /* compatibility */
public static final int SIGEMT =  7;       /* EMT instruction */
// #endif  /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */
public static final int SIGFPE =  8;       /* floating point exception */
public static final int SIGKILL = 9;       /* kill (cannot be caught or ignored) */
public static final int SIGBUS =  10;      /* bus error */
public static final int SIGSEGV = 11;      /* segmentation violation */
public static final int SIGSYS =  12;      /* bad argument to system call */
public static final int SIGPIPE = 13;      /* write on a pipe with no one to read it */
public static final int SIGALRM = 14;      /* alarm clock */
public static final int SIGTERM = 15;      /* software termination signal from kill */
public static final int SIGURG =  16;      /* urgent condition on IO channel */
public static final int SIGSTOP = 17;      /* sendable stop signal not from tty */
public static final int SIGTSTP = 18;      /* stop signal from tty */
public static final int SIGCONT = 19;      /* continue a stopped process */
public static final int SIGCHLD = 20;      /* to parent on child stop or exit */
public static final int SIGTTIN = 21;      /* to readers pgrp upon background tty read */
public static final int SIGTTOU = 22;      /* like TTIN for output if (tp->t_local&LTOSTOP) */
// #if  (!defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE))
public static final int SIGIO =   23;      /* input/output possible signal */
// #endif
public static final int SIGXCPU = 24;      /* exceeded CPU time limit */
public static final int SIGXFSZ = 25;      /* exceeded file size limit */
public static final int SIGVTALRM = 26;    /* virtual time alarm */
public static final int SIGPROF = 27;      /* profiling time alarm */
// #if  (!defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE))
public static final int SIGWINCH = 28;     /* window size changes */
public static final int SIGINFO = 29;      /* information request */
// #endif
public static final int SIGUSR1 = 30;      /* user defined signal 1 */
public static final int SIGUSR2 = 31;      /* user defined signal 2 */

// #if defined(_ANSI_SOURCE) || __DARWIN_UNIX03 || defined(__cplusplus)
/*
 * Language spec sez we must list exactly one parameter, even though we
 * actually supply three.  Ugh!
 * SIG_HOLD is chosen to avoid KERN_SIG_* values in <sys/signalvar.h>
 */
@Cast("void*") public static native @MemberGetter Pointer SIG_DFL();
public static final Pointer SIG_DFL = SIG_DFL();
@Cast("void*") public static native @MemberGetter Pointer SIG_IGN();
public static final Pointer SIG_IGN = SIG_IGN();
@Cast("void*") public static native @MemberGetter Pointer SIG_HOLD();
public static final Pointer SIG_HOLD = SIG_HOLD();
@Cast("void*") public static native @MemberGetter Pointer SIG_ERR();
public static final Pointer SIG_ERR = SIG_ERR();
// #else
/* DO NOT REMOVE THE COMMENTED OUT int: fixincludes needs to see them */
// #endif

// #ifndef _ANSI_SOURCE
// #include <sys/_types.h>

// #include <machine/_mcontext.h>

// #include <sys/_pthread/_pthread_attr_t.h>

// #include <sys/_types/_sigaltstack.h>
// #include <sys/_types/_ucontext.h>

// #include <sys/_types/_pid_t.h>
// #include <sys/_types/_sigset_t.h>
// #include <sys/_types/_size_t.h>
// #include <sys/_types/_uid_t.h>
// Targeting ../macosx/sigval.java



public static final int SIGEV_NONE =      0;       /* No async notification */
public static final int SIGEV_SIGNAL =    1;       /* aio - completion notification */
public static final int SIGEV_THREAD =    3;
// Targeting ../macosx/sigevent.java


// Targeting ../macosx/siginfo_t.java




/*
 * When the signal is SIGILL or SIGFPE, si_addr contains the address of
 * the faulting instruction.
 * When the signal is SIGSEGV or SIGBUS, si_addr contains the address of
 * the faulting memory reference. Although for x86 there are cases of SIGSEGV
 * for which si_addr cannot be determined and is NULL.
 * If the signal is SIGCHLD, the si_pid field will contain the child process ID,
 *  si_status contains the exit value or signal and
 *  si_uid contains the real user ID of the process that sent the signal.
 */

/* Values for si_code */

/* Codes for SIGILL */
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int ILL_NOOP =        0;       /* if only I knew... */
// #endif
public static final int ILL_ILLOPC =      1;       /* [XSI] illegal opcode */
public static final int ILL_ILLTRP =      2;       /* [XSI] illegal trap */
public static final int ILL_PRVOPC =      3;       /* [XSI] privileged opcode */
public static final int ILL_ILLOPN =      4;       /* [XSI] illegal operand -NOTIMP */
public static final int ILL_ILLADR =      5;       /* [XSI] illegal addressing mode -NOTIMP */
public static final int ILL_PRVREG =      6;       /* [XSI] privileged register -NOTIMP */
public static final int ILL_COPROC =      7;       /* [XSI] coprocessor error -NOTIMP */
public static final int ILL_BADSTK =      8;       /* [XSI] internal stack error -NOTIMP */

/* Codes for SIGFPE */
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int FPE_NOOP =        0;       /* if only I knew... */
// #endif
public static final int FPE_FLTDIV =      1;       /* [XSI] floating point divide by zero */
public static final int FPE_FLTOVF =      2;       /* [XSI] floating point overflow */
public static final int FPE_FLTUND =      3;       /* [XSI] floating point underflow */
public static final int FPE_FLTRES =      4;       /* [XSI] floating point inexact result */
public static final int FPE_FLTINV =      5;       /* [XSI] invalid floating point operation */
public static final int FPE_FLTSUB =      6;       /* [XSI] subscript out of range -NOTIMP */
public static final int FPE_INTDIV =      7;       /* [XSI] integer divide by zero */
public static final int FPE_INTOVF =      8;       /* [XSI] integer overflow */

/* Codes for SIGSEGV */
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int SEGV_NOOP =       0;       /* if only I knew... */
// #endif
public static final int SEGV_MAPERR =     1;       /* [XSI] address not mapped to object */
public static final int SEGV_ACCERR =     2;       /* [XSI] invalid permission for mapped object */

/* Codes for SIGBUS */
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int BUS_NOOP =        0;       /* if only I knew... */
// #endif
public static final int BUS_ADRALN =      1;       /* [XSI] Invalid address alignment */
public static final int BUS_ADRERR =      2;       /* [XSI] Nonexistent physical address -NOTIMP */
public static final int BUS_OBJERR =      3;       /* [XSI] Object-specific HW error - NOTIMP */

/* Codes for SIGTRAP */
public static final int TRAP_BRKPT =      1;       /* [XSI] Process breakpoint -NOTIMP */
public static final int TRAP_TRACE =      2;       /* [XSI] Process trace trap -NOTIMP */

/* Codes for SIGCHLD */
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int CLD_NOOP =        0;       /* if only I knew... */
// #endif
public static final int CLD_EXITED =      1;       /* [XSI] child has exited */
public static final int CLD_KILLED =      2;       /* [XSI] terminated abnormally, no core file */
public static final int CLD_DUMPED =      3;       /* [XSI] terminated abnormally, core file */
public static final int CLD_TRAPPED =     4;       /* [XSI] traced child has trapped */
public static final int CLD_STOPPED =     5;       /* [XSI] child has stopped */
public static final int CLD_CONTINUED =   6;       /* [XSI] stopped child has continued */

/* Codes for SIGPOLL */
public static final int POLL_IN =         1;       /* [XSR] Data input available */
public static final int POLL_OUT =        2;       /* [XSR] Output buffers available */
public static final int POLL_MSG =        3;       /* [XSR] Input message available */
public static final int POLL_ERR =        4;       /* [XSR] I/O error */
public static final int POLL_PRI =        5;       /* [XSR] High priority input available */
public static final int POLL_HUP =        6;
// Targeting ../macosx/__sigaction_u.java


// Targeting ../macosx/__sigaction.java


// Targeting ../macosx/sigaction.java





/* if SA_SIGINFO is set, sa_sigaction is to be used instead of sa_handler. */

public static final int SA_ONSTACK =      0x0001;  /* take signal on signal stack */
public static final int SA_RESTART =      0x0002;  /* restart system on signal return */
public static final int SA_RESETHAND =    0x0004;  /* reset to SIG_DFL when taking signal */
public static final int SA_NOCLDSTOP =    0x0008;  /* do not generate SIGCHLD on child stop */
public static final int SA_NODEFER =      0x0010;  /* don't mask the signal we're delivering */
public static final int SA_NOCLDWAIT =    0x0020;  /* don't keep zombies around */
public static final int SA_SIGINFO =      0x0040;  /* signal handler with SA_SIGINFO args */
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int SA_USERTRAMP =    0x0100;  /* do not bounce off kernel's sigtramp */
/* This will provide 64bit register set in a 32bit user address space */
public static final int SA_64REGSET =     0x0200;  /* signal handler with SA_SIGINFO args with 64bit regs information */
// #endif /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */

/* the following are the only bits we support from user space, the
 * rest are for kernel use only.
 */
public static final int SA_USERSPACE_MASK = (SA_ONSTACK | SA_RESTART | SA_RESETHAND | SA_NOCLDSTOP | SA_NODEFER | SA_NOCLDWAIT | SA_SIGINFO);

/*
 * Flags for sigprocmask:
 */
public static final int SIG_BLOCK =       1;       /* block specified signal set */
public static final int SIG_UNBLOCK =     2;       /* unblock specified signal set */
public static final int SIG_SETMASK =     3;       /* set specified signal set */

/* POSIX 1003.1b required values. */
public static final int SI_USER =         0x10001; /* [CX] signal from kill() */
public static final int SI_QUEUE =        0x10002; /* [CX] signal from sigqueue() */
public static final int SI_TIMER =        0x10003; /* [CX] timer expiration */
public static final int SI_ASYNCIO =      0x10004; /* [CX] aio request completion */
public static final int SI_MESGQ =        0x10005;
// Targeting ../macosx/sig_t.java

     /* type of signal function */
// #endif

/*
 * Structure used in sigaltstack call.
 */

public static final int SS_ONSTACK =      0x0001;  /* take signal on signal stack */
public static final int SS_DISABLE =      0x0004;  /* disable taking signals on alternate stack */
public static final int MINSIGSTKSZ =     32768;   /* (32K)minimum allowable stack */
public static final int SIGSTKSZ =        131072;
// Targeting ../macosx/sigvec.java



public static final int SV_ONSTACK =      SA_ONSTACK;
public static final int SV_INTERRUPT =    SA_RESTART;      /* same bit, opposite sense */
public static final int SV_RESETHAND =    SA_RESETHAND;
public static final int SV_NODEFER =      SA_NODEFER;
public static final int SV_NOCLDSTOP =    SA_NOCLDSTOP;
public static final int SV_SIGINFO =      SA_SIGINFO;

// #define sv_onstack sv_flags
// Targeting ../macosx/sigstack.java



// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
/*
 * Macro for converting signal number to a mask suitable for
 * sigblock().
 */
// #define sigmask(m)      (1 << ((m)-1))


@Cast("void*") public static native @MemberGetter Pointer BADSIG();
public static final Pointer BADSIG = BADSIG();
// Targeting ../macosx/Arg1_int.java


public static native void signal(int arg0, Arg1_int arg1);
// #endif  /* !_SYS_SIGNAL_H_ */


// Parsed from signal.h

/*
 * Copyright (c) 2000 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*-
 * Copyright (c) 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)signal.h	8.3 (Berkeley) 3/30/94
 */

// #ifndef _USER_SIGNAL_H
// #define _USER_SIGNAL_H

// #include <sys/cdefs.h>
// #include <_types.h>
// #include <sys/signal.h>

// #include <sys/_pthread/_pthread_types.h>
// #include <sys/_pthread/_pthread_t.h>

// #if !defined(_ANSI_SOURCE) && (!defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE))
@MemberGetter public static native @Cast("const char*") BytePointer sys_signame(int i);
@MemberGetter public static native @Cast("const char*__const*") PointerPointer sys_signame();
@MemberGetter public static native @Cast("const char*") BytePointer sys_siglist(int i);
@MemberGetter public static native @Cast("const char*__const*") PointerPointer sys_siglist();
// #endif

public static native int raise(int arg0);
// #ifndef	_ANSI_SOURCE
public static native void bsd_signal(int arg0, Arg1_int arg1);
public static native int kill(@Cast("pid_t") int arg0, int arg1);
public static native int killpg(@Cast("pid_t") int arg0, int arg1);
public static native int pthread_kill(@ByVal @Cast("pthread_t*") Pointer arg0, int arg1);
public static native int pthread_sigmask(int arg0, @Cast("const sigset_t*") IntPointer arg1, @Cast("sigset_t*") IntPointer arg2);
public static native int pthread_sigmask(int arg0, @Cast("const sigset_t*") IntBuffer arg1, @Cast("sigset_t*") IntBuffer arg2);
public static native int pthread_sigmask(int arg0, @Cast("const sigset_t*") int[] arg1, @Cast("sigset_t*") int[] arg2);
public static native int sigaction(int arg0, @Const sigaction arg1,
	    sigaction arg2);
public static native int sigaddset(@Cast("sigset_t*") IntPointer arg0, int arg1);
public static native int sigaddset(@Cast("sigset_t*") IntBuffer arg0, int arg1);
public static native int sigaddset(@Cast("sigset_t*") int[] arg0, int arg1);
public static native int sigaltstack(@Const stack_t arg0, stack_t arg1);
public static native int sigdelset(@Cast("sigset_t*") IntPointer arg0, int arg1);
public static native int sigdelset(@Cast("sigset_t*") IntBuffer arg0, int arg1);
public static native int sigdelset(@Cast("sigset_t*") int[] arg0, int arg1);
public static native int sigemptyset(@Cast("sigset_t*") IntPointer arg0);
public static native int sigemptyset(@Cast("sigset_t*") IntBuffer arg0);
public static native int sigemptyset(@Cast("sigset_t*") int[] arg0);
public static native int sigfillset(@Cast("sigset_t*") IntPointer arg0);
public static native int sigfillset(@Cast("sigset_t*") IntBuffer arg0);
public static native int sigfillset(@Cast("sigset_t*") int[] arg0);
public static native int sighold(int arg0);
public static native int sigignore(int arg0);
public static native int siginterrupt(int arg0, int arg1);
public static native int sigismember(@Cast("const sigset_t*") IntPointer arg0, int arg1);
public static native int sigismember(@Cast("const sigset_t*") IntBuffer arg0, int arg1);
public static native int sigismember(@Cast("const sigset_t*") int[] arg0, int arg1);
public static native int sigpause(int arg0);
public static native int sigpending(@Cast("sigset_t*") IntPointer arg0);
public static native int sigpending(@Cast("sigset_t*") IntBuffer arg0);
public static native int sigpending(@Cast("sigset_t*") int[] arg0);
public static native int sigprocmask(int arg0, @Cast("const sigset_t*") IntPointer arg1, @Cast("sigset_t*") IntPointer arg2);
public static native int sigprocmask(int arg0, @Cast("const sigset_t*") IntBuffer arg1, @Cast("sigset_t*") IntBuffer arg2);
public static native int sigprocmask(int arg0, @Cast("const sigset_t*") int[] arg1, @Cast("sigset_t*") int[] arg2);
public static native int sigrelse(int arg0);
public static native void sigset(int arg0, Arg1_int arg1);
public static native int sigsuspend(@Cast("const sigset_t*") IntPointer arg0);
public static native int sigsuspend(@Cast("const sigset_t*") IntBuffer arg0);
public static native int sigsuspend(@Cast("const sigset_t*") int[] arg0);
public static native int sigwait(@Cast("const sigset_t*") IntPointer arg0, IntPointer arg1);
public static native int sigwait(@Cast("const sigset_t*") IntBuffer arg0, IntBuffer arg1);
public static native int sigwait(@Cast("const sigset_t*") int[] arg0, int[] arg1);
// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static native void psignal(@Cast("unsigned int") int arg0, @Cast("const char*") BytePointer arg1);
public static native void psignal(@Cast("unsigned int") int arg0, String arg1);
public static native int sigblock(int arg0);
public static native int sigsetmask(int arg0);
public static native int sigvec(int arg0, sigvec arg1, sigvec arg2);
// #endif	/* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */
/* List definitions after function declarations, or Reiser cpp gets upset. */
public static native int __sigbits(int __signo);

// #define	sigaddset(set, signo)	(*(set) |= __sigbits(signo), 0)
// #define	sigdelset(set, signo)	(*(set) &= ~__sigbits(signo), 0)
// #define	sigismember(set, signo)	((*(set) & __sigbits(signo)) != 0)
// #define	sigemptyset(set)	(*(set) = 0, 0)
// #define	sigfillset(set)		(*(set) = ~(sigset_t)0, 0)
// #endif	/* !_ANSI_SOURCE */

// #endif	/* !_USER_SIGNAL_H */


// Parsed from sched.h

/*
 * Copyright (c) 2000-2003 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */

// #ifndef _SCHED_H_
// #define _SCHED_H_

// #include <sys/cdefs.h>
// #include <pthread/pthread_impl.h>
// Targeting ../macosx/sched_param.java


// #else
// #endif

public static native int sched_yield();
public static native int sched_get_priority_min(int arg0);
public static native int sched_get_priority_max(int arg0);
// #endif /* _SCHED_H_ */



// Parsed from mach/machine.h

/*
 * Copyright (c) 2007-2016 Apple, Inc. All rights reserved.
 * Copyright (c) 2000 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
/*
 * Mach Operating System
 * Copyright (c) 1991,1990,1989,1988,1987 Carnegie Mellon University
 * All Rights Reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * Carnegie Mellon requests users of this software to return to
 *
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*	File:	machine.h
 *	Author:	Avadis Tevanian, Jr.
 *	Date:	1986
 *
 *	Machine independent machine abstraction.
 */

// #ifndef _MACH_MACHINE_H_
// #define _MACH_MACHINE_H_

// #ifndef __ASSEMBLER__

// #include <stdint.h>
// #include <mach/machine/vm_types.h>
// #include <mach/boolean.h>

public static final int CPU_STATE_MAX =           4;

public static final int CPU_STATE_USER =          0;
public static final int CPU_STATE_SYSTEM =        1;
public static final int CPU_STATE_IDLE =          2;
public static final int CPU_STATE_NICE =          3;



/*
 * Capability bits used in the definition of cpu_type.
 */
public static final int CPU_ARCH_MASK =           0xff000000;      /* mask for architecture bits */
public static final int CPU_ARCH_ABI64 =          0x01000000;      /* 64 bit ABI */
public static final int CPU_ARCH_ABI64_32 =       0x02000000;      /* ABI for 64-bit hardware with 32-bit types; LP32 */

/*
 *	Machine types known by all.
 */

public static final int CPU_TYPE_ANY =            ((int) -1);

public static final int CPU_TYPE_VAX =            ((int) 1);
/* skip				((cpu_type_t) 2)	*/
/* skip				((cpu_type_t) 3)	*/
/* skip				((cpu_type_t) 4)	*/
/* skip				((cpu_type_t) 5)	*/
public static final int CPU_TYPE_MC680x0 =        ((int) 6);
public static final int CPU_TYPE_X86 =            ((int) 7);
public static final int CPU_TYPE_I386 =           CPU_TYPE_X86;            /* compatibility */
public static final int CPU_TYPE_X86_64 =         (CPU_TYPE_X86 | CPU_ARCH_ABI64);

/* skip CPU_TYPE_MIPS		((cpu_type_t) 8)	*/
/* skip                         ((cpu_type_t) 9)	*/
public static final int CPU_TYPE_MC98000 =        ((int) 10);
public static final int CPU_TYPE_HPPA =           ((int) 11);
public static final int CPU_TYPE_ARM =            ((int) 12);
public static final int CPU_TYPE_ARM64 =          (CPU_TYPE_ARM | CPU_ARCH_ABI64);
public static final int CPU_TYPE_ARM64_32 =       (CPU_TYPE_ARM | CPU_ARCH_ABI64_32);
public static final int CPU_TYPE_MC88000 =        ((int) 13);
public static final int CPU_TYPE_SPARC =          ((int) 14);
public static final int CPU_TYPE_I860 =           ((int) 15);
/* skip	CPU_TYPE_ALPHA		((cpu_type_t) 16)	*/
/* skip				((cpu_type_t) 17)	*/
public static final int CPU_TYPE_POWERPC =                ((int) 18);
public static final int CPU_TYPE_POWERPC64 =              (CPU_TYPE_POWERPC | CPU_ARCH_ABI64);
/* skip				((cpu_type_t) 19)	*/
/* skip				((cpu_type_t) 20 */
/* skip				((cpu_type_t) 21 */
/* skip				((cpu_type_t) 22 */

/*
 *	Machine subtypes (these are defined here, instead of in a machine
 *	dependent directory, so that any program can get all definitions
 *	regardless of where is it compiled).
 */

/*
 * Capability bits used in the definition of cpu_subtype.
 */
public static final int CPU_SUBTYPE_MASK =        0xff000000;      /* mask for feature flags */
public static final int CPU_SUBTYPE_LIB64 =       0x80000000;      /* 64 bit libraries */
public static final int CPU_SUBTYPE_PTRAUTH_ABI = 0x80000000;      /* pointer authentication with versioned ABI */

/*
 *      When selecting a slice, ANY will pick the slice with the best
 *      grading for the selected cpu_type_t, unlike the "ALL" subtypes,
 *      which are the slices that can run on any hardware for that cpu type.
 */
public static final int CPU_SUBTYPE_ANY =         ((int) -1);

/*
 *	Object files that are hand-crafted to run on any
 *	implementation of an architecture are tagged with
 *	CPU_SUBTYPE_MULTIPLE.  This functions essentially the same as
 *	the "ALL" subtype of an architecture except that it allows us
 *	to easily find object files that may need to be modified
 *	whenever a new implementation of an architecture comes out.
 *
 *	It is the responsibility of the implementor to make sure the
 *	software handles unsupported implementations elegantly.
 */
public static final int CPU_SUBTYPE_MULTIPLE =            ((int) -1);
public static final int CPU_SUBTYPE_LITTLE_ENDIAN =       ((int) 0);
public static final int CPU_SUBTYPE_BIG_ENDIAN =          ((int) 1);

/*
 *     Machine threadtypes.
 *     This is none - not defined - for most machine types/subtypes.
 */
public static final int CPU_THREADTYPE_NONE =             ((int) 0);

/*
 *	VAX subtypes (these do *not* necessary conform to the actual cpu
 *	ID assigned by DEC available via the SID register).
 */

public static final int CPU_SUBTYPE_VAX_ALL =     ((int) 0);
public static final int CPU_SUBTYPE_VAX780 =      ((int) 1);
public static final int CPU_SUBTYPE_VAX785 =      ((int) 2);
public static final int CPU_SUBTYPE_VAX750 =      ((int) 3);
public static final int CPU_SUBTYPE_VAX730 =      ((int) 4);
public static final int CPU_SUBTYPE_UVAXI =       ((int) 5);
public static final int CPU_SUBTYPE_UVAXII =      ((int) 6);
public static final int CPU_SUBTYPE_VAX8200 =     ((int) 7);
public static final int CPU_SUBTYPE_VAX8500 =     ((int) 8);
public static final int CPU_SUBTYPE_VAX8600 =     ((int) 9);
public static final int CPU_SUBTYPE_VAX8650 =     ((int) 10);
public static final int CPU_SUBTYPE_VAX8800 =     ((int) 11);
public static final int CPU_SUBTYPE_UVAXIII =     ((int) 12);

/*
 *      680x0 subtypes
 *
 * The subtype definitions here are unusual for historical reasons.
 * NeXT used to consider 68030 code as generic 68000 code.  For
 * backwards compatability:
 *
 *	CPU_SUBTYPE_MC68030 symbol has been preserved for source code
 *	compatability.
 *
 *	CPU_SUBTYPE_MC680x0_ALL has been defined to be the same
 *	subtype as CPU_SUBTYPE_MC68030 for binary comatability.
 *
 *	CPU_SUBTYPE_MC68030_ONLY has been added to allow new object
 *	files to be tagged as containing 68030-specific instructions.
 */

public static final int CPU_SUBTYPE_MC680x0_ALL =         ((int) 1);
public static final int CPU_SUBTYPE_MC68030 =             ((int) 1); /* compat */
public static final int CPU_SUBTYPE_MC68040 =             ((int) 2);
public static final int CPU_SUBTYPE_MC68030_ONLY =        ((int) 3);

/*
 *	I386 subtypes
 */

// #define CPU_SUBTYPE_INTEL(f, m) ((cpu_subtype_t) (f) + ((m) << 4))

public static native @MemberGetter int CPU_SUBTYPE_I386_ALL();
public static final int CPU_SUBTYPE_I386_ALL = CPU_SUBTYPE_I386_ALL();
public static native @MemberGetter int CPU_SUBTYPE_386();
public static final int CPU_SUBTYPE_386 = CPU_SUBTYPE_386();
public static native @MemberGetter int CPU_SUBTYPE_486();
public static final int CPU_SUBTYPE_486 = CPU_SUBTYPE_486();
public static native @MemberGetter int CPU_SUBTYPE_486SX();
public static final int CPU_SUBTYPE_486SX = CPU_SUBTYPE_486SX(); // 8 << 4 = 128
public static native @MemberGetter int CPU_SUBTYPE_586();
public static final int CPU_SUBTYPE_586 = CPU_SUBTYPE_586();
public static native @MemberGetter int CPU_SUBTYPE_PENT();
public static final int CPU_SUBTYPE_PENT = CPU_SUBTYPE_PENT();
public static native @MemberGetter int CPU_SUBTYPE_PENTPRO();
public static final int CPU_SUBTYPE_PENTPRO = CPU_SUBTYPE_PENTPRO();
public static native @MemberGetter int CPU_SUBTYPE_PENTII_M3();
public static final int CPU_SUBTYPE_PENTII_M3 = CPU_SUBTYPE_PENTII_M3();
public static native @MemberGetter int CPU_SUBTYPE_PENTII_M5();
public static final int CPU_SUBTYPE_PENTII_M5 = CPU_SUBTYPE_PENTII_M5();
public static native @MemberGetter int CPU_SUBTYPE_CELERON();
public static final int CPU_SUBTYPE_CELERON = CPU_SUBTYPE_CELERON();
public static native @MemberGetter int CPU_SUBTYPE_CELERON_MOBILE();
public static final int CPU_SUBTYPE_CELERON_MOBILE = CPU_SUBTYPE_CELERON_MOBILE();
public static native @MemberGetter int CPU_SUBTYPE_PENTIUM_3();
public static final int CPU_SUBTYPE_PENTIUM_3 = CPU_SUBTYPE_PENTIUM_3();
public static native @MemberGetter int CPU_SUBTYPE_PENTIUM_3_M();
public static final int CPU_SUBTYPE_PENTIUM_3_M = CPU_SUBTYPE_PENTIUM_3_M();
public static native @MemberGetter int CPU_SUBTYPE_PENTIUM_3_XEON();
public static final int CPU_SUBTYPE_PENTIUM_3_XEON = CPU_SUBTYPE_PENTIUM_3_XEON();
public static native @MemberGetter int CPU_SUBTYPE_PENTIUM_M();
public static final int CPU_SUBTYPE_PENTIUM_M = CPU_SUBTYPE_PENTIUM_M();
public static native @MemberGetter int CPU_SUBTYPE_PENTIUM_4();
public static final int CPU_SUBTYPE_PENTIUM_4 = CPU_SUBTYPE_PENTIUM_4();
public static native @MemberGetter int CPU_SUBTYPE_PENTIUM_4_M();
public static final int CPU_SUBTYPE_PENTIUM_4_M = CPU_SUBTYPE_PENTIUM_4_M();
public static native @MemberGetter int CPU_SUBTYPE_ITANIUM();
public static final int CPU_SUBTYPE_ITANIUM = CPU_SUBTYPE_ITANIUM();
public static native @MemberGetter int CPU_SUBTYPE_ITANIUM_2();
public static final int CPU_SUBTYPE_ITANIUM_2 = CPU_SUBTYPE_ITANIUM_2();
public static native @MemberGetter int CPU_SUBTYPE_XEON();
public static final int CPU_SUBTYPE_XEON = CPU_SUBTYPE_XEON();
public static native @MemberGetter int CPU_SUBTYPE_XEON_MP();
public static final int CPU_SUBTYPE_XEON_MP = CPU_SUBTYPE_XEON_MP();

// #define CPU_SUBTYPE_INTEL_FAMILY(x)     ((x) & 15)
public static final int CPU_SUBTYPE_INTEL_FAMILY_MAX =    15;

// #define CPU_SUBTYPE_INTEL_MODEL(x)      ((x) >> 4)
public static final int CPU_SUBTYPE_INTEL_MODEL_ALL =     0;

/*
 *	X86 subtypes.
 */

public static final int CPU_SUBTYPE_X86_ALL =             ((int)3);
public static final int CPU_SUBTYPE_X86_64_ALL =          ((int)3);
public static final int CPU_SUBTYPE_X86_ARCH1 =           ((int)4);
public static final int CPU_SUBTYPE_X86_64_H =            ((int)8);      /* Haswell feature subset */


public static final int CPU_THREADTYPE_INTEL_HTT =        ((int) 1);

/*
 *	Mips subtypes.
 */

public static final int CPU_SUBTYPE_MIPS_ALL =    ((int) 0);
public static final int CPU_SUBTYPE_MIPS_R2300 =  ((int) 1);
public static final int CPU_SUBTYPE_MIPS_R2600 =  ((int) 2);
public static final int CPU_SUBTYPE_MIPS_R2800 =  ((int) 3);
public static final int CPU_SUBTYPE_MIPS_R2000a = ((int) 4);     /* pmax */
public static final int CPU_SUBTYPE_MIPS_R2000 =  ((int) 5);
public static final int CPU_SUBTYPE_MIPS_R3000a = ((int) 6);     /* 3max */
public static final int CPU_SUBTYPE_MIPS_R3000 =  ((int) 7);

/*
 *	MC98000 (PowerPC) subtypes
 */
public static final int CPU_SUBTYPE_MC98000_ALL = ((int) 0);
public static final int CPU_SUBTYPE_MC98601 =     ((int) 1);

/*
 *	HPPA subtypes for Hewlett-Packard HP-PA family of
 *	risc processors. Port by NeXT to 700 series.
 */

public static final int CPU_SUBTYPE_HPPA_ALL =            ((int) 0);
public static final int CPU_SUBTYPE_HPPA_7100 =           ((int) 0); /* compat */
public static final int CPU_SUBTYPE_HPPA_7100LC =         ((int) 1);

/*
 *	MC88000 subtypes.
 */
public static final int CPU_SUBTYPE_MC88000_ALL = ((int) 0);
public static final int CPU_SUBTYPE_MC88100 =     ((int) 1);
public static final int CPU_SUBTYPE_MC88110 =     ((int) 2);

/*
 *	SPARC subtypes
 */
public static final int CPU_SUBTYPE_SPARC_ALL =           ((int) 0);

/*
 *	I860 subtypes
 */
public static final int CPU_SUBTYPE_I860_ALL =    ((int) 0);
public static final int CPU_SUBTYPE_I860_860 =    ((int) 1);

/*
 *	PowerPC subtypes
 */
public static final int CPU_SUBTYPE_POWERPC_ALL =         ((int) 0);
public static final int CPU_SUBTYPE_POWERPC_601 =         ((int) 1);
public static final int CPU_SUBTYPE_POWERPC_602 =         ((int) 2);
public static final int CPU_SUBTYPE_POWERPC_603 =         ((int) 3);
public static final int CPU_SUBTYPE_POWERPC_603e =        ((int) 4);
public static final int CPU_SUBTYPE_POWERPC_603ev =       ((int) 5);
public static final int CPU_SUBTYPE_POWERPC_604 =         ((int) 6);
public static final int CPU_SUBTYPE_POWERPC_604e =        ((int) 7);
public static final int CPU_SUBTYPE_POWERPC_620 =         ((int) 8);
public static final int CPU_SUBTYPE_POWERPC_750 =         ((int) 9);
public static final int CPU_SUBTYPE_POWERPC_7400 =        ((int) 10);
public static final int CPU_SUBTYPE_POWERPC_7450 =        ((int) 11);
public static final int CPU_SUBTYPE_POWERPC_970 =         ((int) 100);

/*
 *	ARM subtypes
 */
public static final int CPU_SUBTYPE_ARM_ALL =             ((int) 0);
public static final int CPU_SUBTYPE_ARM_V4T =             ((int) 5);
public static final int CPU_SUBTYPE_ARM_V6 =              ((int) 6);
public static final int CPU_SUBTYPE_ARM_V5TEJ =           ((int) 7);
public static final int CPU_SUBTYPE_ARM_XSCALE =          ((int) 8);
public static final int CPU_SUBTYPE_ARM_V7 =              ((int) 9);  /* ARMv7-A and ARMv7-R */
public static final int CPU_SUBTYPE_ARM_V7F =             ((int) 10); /* Cortex A9 */
public static final int CPU_SUBTYPE_ARM_V7S =             ((int) 11); /* Swift */
public static final int CPU_SUBTYPE_ARM_V7K =             ((int) 12);
public static final int CPU_SUBTYPE_ARM_V8 =              ((int) 13);
public static final int CPU_SUBTYPE_ARM_V6M =             ((int) 14); /* Not meant to be run under xnu */
public static final int CPU_SUBTYPE_ARM_V7M =             ((int) 15); /* Not meant to be run under xnu */
public static final int CPU_SUBTYPE_ARM_V7EM =            ((int) 16); /* Not meant to be run under xnu */
public static final int CPU_SUBTYPE_ARM_V8M =             ((int) 17); /* Not meant to be run under xnu */

/*
 *  ARM64 subtypes
 */
public static final int CPU_SUBTYPE_ARM64_ALL =           ((int) 0);
public static final int CPU_SUBTYPE_ARM64_V8 =            ((int) 1);
public static final int CPU_SUBTYPE_ARM64E =              ((int) 2);

/* CPU subtype feature flags for ptrauth on arm64e platforms */
public static final int CPU_SUBTYPE_ARM64_PTR_AUTH_MASK = 0x0f000000;
// #define CPU_SUBTYPE_ARM64_PTR_AUTH_VERSION(x) (((x) & CPU_SUBTYPE_ARM64_PTR_AUTH_MASK) >> 24)

/*
 *  ARM64_32 subtypes
 */
public static final int CPU_SUBTYPE_ARM64_32_ALL =        ((int) 0);
public static final int CPU_SUBTYPE_ARM64_32_V8 = ((int) 1);

// #endif /* !__ASSEMBLER__ */

/*
 *	CPU families (sysctl hw.cpufamily)
 *
 * These are meant to identify the CPU's marketing name - an
 * application can map these to (possibly) localized strings.
 * NB: the encodings of the CPU families are intentionally arbitrary.
 * There is no ordering, and you should never try to deduce whether
 * or not some feature is available based on the family.
 * Use feature flags (eg, hw.optional.altivec) to test for optional
 * functionality.
 */
public static final int CPUFAMILY_UNKNOWN =               0;
public static final int CPUFAMILY_POWERPC_G3 =            0xcee41549;
public static final int CPUFAMILY_POWERPC_G4 =            0x77c184ae;
public static final int CPUFAMILY_POWERPC_G5 =            0xed76d8aa;
public static final int CPUFAMILY_INTEL_6_13 =            0xaa33392b;
public static final int CPUFAMILY_INTEL_PENRYN =          0x78ea4fbc;
public static final int CPUFAMILY_INTEL_NEHALEM =         0x6b5a4cd2;
public static final int CPUFAMILY_INTEL_WESTMERE =        0x573b5eec;
public static final int CPUFAMILY_INTEL_SANDYBRIDGE =     0x5490b78c;
public static final int CPUFAMILY_INTEL_IVYBRIDGE =       0x1f65e835;
public static final int CPUFAMILY_INTEL_HASWELL =         0x10b282dc;
public static final int CPUFAMILY_INTEL_BROADWELL =       0x582ed09c;
public static final int CPUFAMILY_INTEL_SKYLAKE =         0x37fc219f;
public static final int CPUFAMILY_INTEL_KABYLAKE =        0x0f817246;
public static final int CPUFAMILY_INTEL_ICELAKE =         0x38435547;
// #if !defined(RC_HIDE_XNU_COMETLAKE)
public static final int CPUFAMILY_INTEL_COMETLAKE =       0x1cf8a03e;
// #endif /* not RC_HIDE_XNU_COMETLAKE */
public static final int CPUFAMILY_ARM_9 =                 0xe73283ae;
public static final int CPUFAMILY_ARM_11 =                0x8ff620d8;
public static final int CPUFAMILY_ARM_XSCALE =            0x53b005f5;
public static final int CPUFAMILY_ARM_12 =                0xbd1b0ae9;
public static final int CPUFAMILY_ARM_13 =                0x0cc90e64;
public static final int CPUFAMILY_ARM_14 =                0x96077ef1;
public static final int CPUFAMILY_ARM_15 =                0xa8511bca;
public static final int CPUFAMILY_ARM_SWIFT =             0x1e2d6381;
public static final int CPUFAMILY_ARM_CYCLONE =           0x37a09642;
public static final int CPUFAMILY_ARM_TYPHOON =           0x2c91a47e;
public static final int CPUFAMILY_ARM_TWISTER =           0x92fb37c8;
public static final int CPUFAMILY_ARM_HURRICANE =         0x67ceee93;
public static final int CPUFAMILY_ARM_MONSOON_MISTRAL =   0xe81e7ef6;
public static final int CPUFAMILY_ARM_VORTEX_TEMPEST =    0x07d34b9f;
public static final int CPUFAMILY_ARM_LIGHTNING_THUNDER = 0x462504d2;
public static final int CPUFAMILY_ARM_FIRESTORM_ICESTORM = 0x1b588bb3;

public static final int CPUSUBFAMILY_UNKNOWN =            0;
public static final int CPUSUBFAMILY_ARM_HP =             1;
public static final int CPUSUBFAMILY_ARM_HG =             2;
public static final int CPUSUBFAMILY_ARM_M =              3;
public static final int CPUSUBFAMILY_ARM_HS =             4;
public static final int CPUSUBFAMILY_ARM_HC_HD =          5;

/* The following synonyms are deprecated: */
public static final int CPUFAMILY_INTEL_6_23 =    CPUFAMILY_INTEL_PENRYN;
public static final int CPUFAMILY_INTEL_6_26 =    CPUFAMILY_INTEL_NEHALEM;


// #endif  /* _MACH_MACHINE_H_ */


// Parsed from spawn.h

/*
 * Copyright (c) 2006, 2010 Apple Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_LICENSE_HEADER_END@
 */


// #ifndef _SPAWN_H_
// #define _SPAWN_H_

/*
 * [SPN] Support for _POSIX_SPAWN
 */

// #include <sys/cdefs.h>
// #include <_types.h>
// #include <sys/spawn.h> /* shared types */

// #include <Availability.h>

/*
 * [SPN] Inclusion of the <spawn.h> header may make visible symbols defined
 * in the <sched.h>, <signal.h>, and <sys/types.h> headers.
 */
// #include <sys/_types/_pid_t.h>
// #include <sys/_types/_sigset_t.h>
// #include <sys/_types/_mode_t.h>
// Targeting ../macosx/posix_spawnattr_t.java


// Targeting ../macosx/posix_spawn_file_actions_t.java



/*
 * gcc under c99 mode won't compile "[ __restrict]" by itself.  As a workaround,
 * a dummy argument name is added.
 */

public static native int posix_spawn(@Cast("pid_t*") IntPointer arg0, @Cast("const char*") BytePointer arg1,
    @Cast("const posix_spawn_file_actions_t*") @ByPtrPtr posix_spawn_file_actions_t arg2,
    @Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg3,
    @Cast("char*const*") PointerPointer __argv,
    @Cast("char*const*") PointerPointer __envp);
public static native int posix_spawn(@Cast("pid_t*") IntPointer arg0, @Cast("const char*") BytePointer arg1,
    @Cast("const posix_spawn_file_actions_t*") @ByPtrPtr posix_spawn_file_actions_t arg2,
    @Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg3,
    @Cast("char*const*") @ByPtrPtr BytePointer __argv,
    @Cast("char*const*") @ByPtrPtr BytePointer __envp);
public static native int posix_spawn(@Cast("pid_t*") IntBuffer arg0, String arg1,
    @Cast("const posix_spawn_file_actions_t*") PointerPointer arg2,
    @Cast("const posix_spawnattr_t*") PointerPointer arg3,
    @Cast("char*const*") @ByPtrPtr ByteBuffer __argv,
    @Cast("char*const*") @ByPtrPtr ByteBuffer __envp);
public static native int posix_spawn(@Cast("pid_t*") int[] arg0, @Cast("const char*") BytePointer arg1,
    @Cast("const posix_spawn_file_actions_t*") @ByPtrPtr posix_spawn_file_actions_t arg2,
    @Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg3,
    @Cast("char*const*") @ByPtrPtr byte[] __argv,
    @Cast("char*const*") @ByPtrPtr byte[] __envp);
public static native int posix_spawn(@Cast("pid_t*") IntPointer arg0, String arg1,
    @Cast("const posix_spawn_file_actions_t*") PointerPointer arg2,
    @Cast("const posix_spawnattr_t*") PointerPointer arg3,
    @Cast("char*const*") @ByPtrPtr BytePointer __argv,
    @Cast("char*const*") @ByPtrPtr BytePointer __envp);
public static native int posix_spawn(@Cast("pid_t*") IntBuffer arg0, @Cast("const char*") BytePointer arg1,
    @Cast("const posix_spawn_file_actions_t*") @ByPtrPtr posix_spawn_file_actions_t arg2,
    @Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg3,
    @Cast("char*const*") @ByPtrPtr ByteBuffer __argv,
    @Cast("char*const*") @ByPtrPtr ByteBuffer __envp);
public static native int posix_spawn(@Cast("pid_t*") int[] arg0, String arg1,
    @Cast("const posix_spawn_file_actions_t*") PointerPointer arg2,
    @Cast("const posix_spawnattr_t*") PointerPointer arg3,
    @Cast("char*const*") @ByPtrPtr byte[] __argv,
    @Cast("char*const*") @ByPtrPtr byte[] __envp);

public static native int posix_spawnp(@Cast("pid_t*") IntPointer arg0, @Cast("const char*") BytePointer arg1,
    @Cast("const posix_spawn_file_actions_t*") @ByPtrPtr posix_spawn_file_actions_t arg2,
    @Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg3,
    @Cast("char*const*") PointerPointer __argv,
    @Cast("char*const*") PointerPointer __envp);
public static native int posix_spawnp(@Cast("pid_t*") IntPointer arg0, @Cast("const char*") BytePointer arg1,
    @Cast("const posix_spawn_file_actions_t*") @ByPtrPtr posix_spawn_file_actions_t arg2,
    @Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg3,
    @Cast("char*const*") @ByPtrPtr BytePointer __argv,
    @Cast("char*const*") @ByPtrPtr BytePointer __envp);
public static native int posix_spawnp(@Cast("pid_t*") IntBuffer arg0, String arg1,
    @Cast("const posix_spawn_file_actions_t*") PointerPointer arg2,
    @Cast("const posix_spawnattr_t*") PointerPointer arg3,
    @Cast("char*const*") @ByPtrPtr ByteBuffer __argv,
    @Cast("char*const*") @ByPtrPtr ByteBuffer __envp);
public static native int posix_spawnp(@Cast("pid_t*") int[] arg0, @Cast("const char*") BytePointer arg1,
    @Cast("const posix_spawn_file_actions_t*") @ByPtrPtr posix_spawn_file_actions_t arg2,
    @Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg3,
    @Cast("char*const*") @ByPtrPtr byte[] __argv,
    @Cast("char*const*") @ByPtrPtr byte[] __envp);
public static native int posix_spawnp(@Cast("pid_t*") IntPointer arg0, String arg1,
    @Cast("const posix_spawn_file_actions_t*") PointerPointer arg2,
    @Cast("const posix_spawnattr_t*") PointerPointer arg3,
    @Cast("char*const*") @ByPtrPtr BytePointer __argv,
    @Cast("char*const*") @ByPtrPtr BytePointer __envp);
public static native int posix_spawnp(@Cast("pid_t*") IntBuffer arg0, @Cast("const char*") BytePointer arg1,
    @Cast("const posix_spawn_file_actions_t*") @ByPtrPtr posix_spawn_file_actions_t arg2,
    @Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg3,
    @Cast("char*const*") @ByPtrPtr ByteBuffer __argv,
    @Cast("char*const*") @ByPtrPtr ByteBuffer __envp);
public static native int posix_spawnp(@Cast("pid_t*") int[] arg0, String arg1,
    @Cast("const posix_spawn_file_actions_t*") PointerPointer arg2,
    @Cast("const posix_spawnattr_t*") PointerPointer arg3,
    @Cast("char*const*") @ByPtrPtr byte[] __argv,
    @Cast("char*const*") @ByPtrPtr byte[] __envp);

public static native int posix_spawn_file_actions_addclose(@Cast("posix_spawn_file_actions_t*") @ByPtrPtr posix_spawn_file_actions_t arg0, int arg1);
public static native int posix_spawn_file_actions_addclose(@Cast("posix_spawn_file_actions_t*") PointerPointer arg0, int arg1);

public static native int posix_spawn_file_actions_adddup2(@Cast("posix_spawn_file_actions_t*") @ByPtrPtr posix_spawn_file_actions_t arg0, int arg1,
    int arg2);
public static native int posix_spawn_file_actions_adddup2(@Cast("posix_spawn_file_actions_t*") PointerPointer arg0, int arg1,
    int arg2);

public static native int posix_spawn_file_actions_addopen(
	@Cast("posix_spawn_file_actions_t*") @ByPtrPtr posix_spawn_file_actions_t arg0, int arg1,
	@Cast("const char*") BytePointer arg2, int arg3, @Cast("mode_t") short arg4);
public static native int posix_spawn_file_actions_addopen(
	@Cast("posix_spawn_file_actions_t*") PointerPointer arg0, int arg1,
	String arg2, int arg3, @Cast("mode_t") short arg4);

public static native int posix_spawn_file_actions_destroy(@Cast("posix_spawn_file_actions_t*") @ByPtrPtr posix_spawn_file_actions_t arg0);
public static native int posix_spawn_file_actions_destroy(@Cast("posix_spawn_file_actions_t*") PointerPointer arg0);

public static native int posix_spawn_file_actions_init(@Cast("posix_spawn_file_actions_t*") @ByPtrPtr posix_spawn_file_actions_t arg0);
public static native int posix_spawn_file_actions_init(@Cast("posix_spawn_file_actions_t*") PointerPointer arg0);

public static native int posix_spawnattr_destroy(@Cast("posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0);
public static native int posix_spawnattr_destroy(@Cast("posix_spawnattr_t*") PointerPointer arg0);

public static native int posix_spawnattr_getsigdefault(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("sigset_t*") IntPointer arg1);
public static native int posix_spawnattr_getsigdefault(@Cast("const posix_spawnattr_t*") PointerPointer arg0,
    @Cast("sigset_t*") IntBuffer arg1);
public static native int posix_spawnattr_getsigdefault(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("sigset_t*") int[] arg1);
public static native int posix_spawnattr_getsigdefault(@Cast("const posix_spawnattr_t*") PointerPointer arg0,
    @Cast("sigset_t*") IntPointer arg1);
public static native int posix_spawnattr_getsigdefault(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("sigset_t*") IntBuffer arg1);
public static native int posix_spawnattr_getsigdefault(@Cast("const posix_spawnattr_t*") PointerPointer arg0,
    @Cast("sigset_t*") int[] arg1);

public static native int posix_spawnattr_getflags(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    ShortPointer arg1);
public static native int posix_spawnattr_getflags(@Cast("const posix_spawnattr_t*") PointerPointer arg0,
    ShortBuffer arg1);
public static native int posix_spawnattr_getflags(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    short[] arg1);
public static native int posix_spawnattr_getflags(@Cast("const posix_spawnattr_t*") PointerPointer arg0,
    ShortPointer arg1);
public static native int posix_spawnattr_getflags(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    ShortBuffer arg1);
public static native int posix_spawnattr_getflags(@Cast("const posix_spawnattr_t*") PointerPointer arg0,
    short[] arg1);

public static native int posix_spawnattr_getpgroup(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("pid_t*") IntPointer arg1);
public static native int posix_spawnattr_getpgroup(@Cast("const posix_spawnattr_t*") PointerPointer arg0,
    @Cast("pid_t*") IntBuffer arg1);
public static native int posix_spawnattr_getpgroup(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("pid_t*") int[] arg1);
public static native int posix_spawnattr_getpgroup(@Cast("const posix_spawnattr_t*") PointerPointer arg0,
    @Cast("pid_t*") IntPointer arg1);
public static native int posix_spawnattr_getpgroup(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("pid_t*") IntBuffer arg1);
public static native int posix_spawnattr_getpgroup(@Cast("const posix_spawnattr_t*") PointerPointer arg0,
    @Cast("pid_t*") int[] arg1);

public static native int posix_spawnattr_getsigmask(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("sigset_t*") IntPointer arg1);
public static native int posix_spawnattr_getsigmask(@Cast("const posix_spawnattr_t*") PointerPointer arg0,
    @Cast("sigset_t*") IntBuffer arg1);
public static native int posix_spawnattr_getsigmask(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("sigset_t*") int[] arg1);
public static native int posix_spawnattr_getsigmask(@Cast("const posix_spawnattr_t*") PointerPointer arg0,
    @Cast("sigset_t*") IntPointer arg1);
public static native int posix_spawnattr_getsigmask(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("sigset_t*") IntBuffer arg1);
public static native int posix_spawnattr_getsigmask(@Cast("const posix_spawnattr_t*") PointerPointer arg0,
    @Cast("sigset_t*") int[] arg1);

public static native int posix_spawnattr_init(@Cast("posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0);
public static native int posix_spawnattr_init(@Cast("posix_spawnattr_t*") PointerPointer arg0);

public static native int posix_spawnattr_setsigdefault(@Cast("posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("const sigset_t*") IntPointer arg1);
public static native int posix_spawnattr_setsigdefault(@Cast("posix_spawnattr_t*") PointerPointer arg0,
    @Cast("const sigset_t*") IntBuffer arg1);
public static native int posix_spawnattr_setsigdefault(@Cast("posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("const sigset_t*") int[] arg1);
public static native int posix_spawnattr_setsigdefault(@Cast("posix_spawnattr_t*") PointerPointer arg0,
    @Cast("const sigset_t*") IntPointer arg1);
public static native int posix_spawnattr_setsigdefault(@Cast("posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("const sigset_t*") IntBuffer arg1);
public static native int posix_spawnattr_setsigdefault(@Cast("posix_spawnattr_t*") PointerPointer arg0,
    @Cast("const sigset_t*") int[] arg1);

public static native int posix_spawnattr_setflags(@Cast("posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0, short arg1);
public static native int posix_spawnattr_setflags(@Cast("posix_spawnattr_t*") PointerPointer arg0, short arg1);

public static native int posix_spawnattr_setpgroup(@Cast("posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0, @Cast("pid_t") int arg1);
public static native int posix_spawnattr_setpgroup(@Cast("posix_spawnattr_t*") PointerPointer arg0, @Cast("pid_t") int arg1);

public static native int posix_spawnattr_setsigmask(@Cast("posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("const sigset_t*") IntPointer arg1);
public static native int posix_spawnattr_setsigmask(@Cast("posix_spawnattr_t*") PointerPointer arg0,
    @Cast("const sigset_t*") IntBuffer arg1);
public static native int posix_spawnattr_setsigmask(@Cast("posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("const sigset_t*") int[] arg1);
public static native int posix_spawnattr_setsigmask(@Cast("posix_spawnattr_t*") PointerPointer arg0,
    @Cast("const sigset_t*") IntPointer arg1);
public static native int posix_spawnattr_setsigmask(@Cast("posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("const sigset_t*") IntBuffer arg1);
public static native int posix_spawnattr_setsigmask(@Cast("posix_spawnattr_t*") PointerPointer arg0,
    @Cast("const sigset_t*") int[] arg1);

// #if 0   /* _POSIX_PRIORITY_SCHEDULING [PS] : not supported */
// #endif  /* 0 */

// #if     !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
/*
 * Darwin-specific extensions below
 */
// #include <mach/exception_types.h>
// #include <mach/machine.h>
// #include <mach/port.h>

// #include <sys/_types/_size_t.h>

public static native int posix_spawnattr_getbinpref_np(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") IntPointer arg2, @Cast("size_t*") SizeTPointer arg3);
public static native int posix_spawnattr_getbinpref_np(@Cast("const posix_spawnattr_t*") PointerPointer arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") IntBuffer arg2, @Cast("size_t*") SizeTPointer arg3);
public static native int posix_spawnattr_getbinpref_np(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") int[] arg2, @Cast("size_t*") SizeTPointer arg3);
public static native int posix_spawnattr_getbinpref_np(@Cast("const posix_spawnattr_t*") PointerPointer arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") IntPointer arg2, @Cast("size_t*") SizeTPointer arg3);
public static native int posix_spawnattr_getbinpref_np(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") IntBuffer arg2, @Cast("size_t*") SizeTPointer arg3);
public static native int posix_spawnattr_getbinpref_np(@Cast("const posix_spawnattr_t*") PointerPointer arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") int[] arg2, @Cast("size_t*") SizeTPointer arg3);

public static native int posix_spawnattr_getarchpref_np(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") IntPointer arg2, @Cast("cpu_subtype_t*") IntPointer arg3, @Cast("size_t*") SizeTPointer arg4);
public static native int posix_spawnattr_getarchpref_np(@Cast("const posix_spawnattr_t*") PointerPointer arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") IntBuffer arg2, @Cast("cpu_subtype_t*") IntBuffer arg3, @Cast("size_t*") SizeTPointer arg4);
public static native int posix_spawnattr_getarchpref_np(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") int[] arg2, @Cast("cpu_subtype_t*") int[] arg3, @Cast("size_t*") SizeTPointer arg4);
public static native int posix_spawnattr_getarchpref_np(@Cast("const posix_spawnattr_t*") PointerPointer arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") IntPointer arg2, @Cast("cpu_subtype_t*") IntPointer arg3, @Cast("size_t*") SizeTPointer arg4);
public static native int posix_spawnattr_getarchpref_np(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") IntBuffer arg2, @Cast("cpu_subtype_t*") IntBuffer arg3, @Cast("size_t*") SizeTPointer arg4);
public static native int posix_spawnattr_getarchpref_np(@Cast("const posix_spawnattr_t*") PointerPointer arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") int[] arg2, @Cast("cpu_subtype_t*") int[] arg3, @Cast("size_t*") SizeTPointer arg4);

public static native int posix_spawnattr_setauditsessionport_np(@Cast("posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("mach_port_t") int arg1);
public static native int posix_spawnattr_setauditsessionport_np(@Cast("posix_spawnattr_t*") PointerPointer arg0,
    @Cast("mach_port_t") int arg1);

public static native int posix_spawnattr_setbinpref_np(@Cast("posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") IntPointer arg2, @Cast("size_t*") SizeTPointer arg3);
public static native int posix_spawnattr_setbinpref_np(@Cast("posix_spawnattr_t*") PointerPointer arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") IntBuffer arg2, @Cast("size_t*") SizeTPointer arg3);
public static native int posix_spawnattr_setbinpref_np(@Cast("posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") int[] arg2, @Cast("size_t*") SizeTPointer arg3);
public static native int posix_spawnattr_setbinpref_np(@Cast("posix_spawnattr_t*") PointerPointer arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") IntPointer arg2, @Cast("size_t*") SizeTPointer arg3);
public static native int posix_spawnattr_setbinpref_np(@Cast("posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") IntBuffer arg2, @Cast("size_t*") SizeTPointer arg3);
public static native int posix_spawnattr_setbinpref_np(@Cast("posix_spawnattr_t*") PointerPointer arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") int[] arg2, @Cast("size_t*") SizeTPointer arg3);

public static native int posix_spawnattr_setarchpref_np(@Cast("posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") IntPointer arg2, @Cast("cpu_subtype_t*") IntPointer arg3, @Cast("size_t*") SizeTPointer arg4);
public static native int posix_spawnattr_setarchpref_np(@Cast("posix_spawnattr_t*") PointerPointer arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") IntBuffer arg2, @Cast("cpu_subtype_t*") IntBuffer arg3, @Cast("size_t*") SizeTPointer arg4);
public static native int posix_spawnattr_setarchpref_np(@Cast("posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") int[] arg2, @Cast("cpu_subtype_t*") int[] arg3, @Cast("size_t*") SizeTPointer arg4);
public static native int posix_spawnattr_setarchpref_np(@Cast("posix_spawnattr_t*") PointerPointer arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") IntPointer arg2, @Cast("cpu_subtype_t*") IntPointer arg3, @Cast("size_t*") SizeTPointer arg4);
public static native int posix_spawnattr_setarchpref_np(@Cast("posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") IntBuffer arg2, @Cast("cpu_subtype_t*") IntBuffer arg3, @Cast("size_t*") SizeTPointer arg4);
public static native int posix_spawnattr_setarchpref_np(@Cast("posix_spawnattr_t*") PointerPointer arg0,
    @Cast("size_t") long arg1, @Cast("cpu_type_t*") int[] arg2, @Cast("cpu_subtype_t*") int[] arg3, @Cast("size_t*") SizeTPointer arg4);

public static native int posix_spawnattr_setexceptionports_np(@Cast("posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("exception_mask_t") int arg1, @Cast("mach_port_t") int arg2,
    @Cast("exception_behavior_t") int arg3, @Cast("thread_state_flavor_t") int arg4);
public static native int posix_spawnattr_setexceptionports_np(@Cast("posix_spawnattr_t*") PointerPointer arg0,
    @Cast("exception_mask_t") int arg1, @Cast("mach_port_t") int arg2,
    @Cast("exception_behavior_t") int arg3, @Cast("thread_state_flavor_t") int arg4);

public static native int posix_spawnattr_setspecialport_np(@Cast("posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t arg0,
    @Cast("mach_port_t") int arg1, int arg2);
public static native int posix_spawnattr_setspecialport_np(@Cast("posix_spawnattr_t*") PointerPointer arg0,
    @Cast("mach_port_t") int arg1, int arg2);



public static native int posix_spawnattr_setnosmt_np(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t attr);
public static native int posix_spawnattr_setnosmt_np(@Cast("const posix_spawnattr_t*") PointerPointer attr);

/*
 * Set CPU Security Mitigation on the spawned process
 * This attribute affects all threads and is inherited on fork and exec
 */
public static native int posix_spawnattr_set_csm_np(@Cast("const posix_spawnattr_t*") @ByPtrPtr posix_spawnattr_t attr, @Cast("uint32_t") int flags);
public static native int posix_spawnattr_set_csm_np(@Cast("const posix_spawnattr_t*") PointerPointer attr, @Cast("uint32_t") int flags);
/*
 * flags for CPU Security Mitigation attribute
 * POSIX_SPAWN_NP_CSM_ALL should be used in most cases,
 * the individual flags are provided only for performance evaluation etc
 */
public static final int POSIX_SPAWN_NP_CSM_ALL =         0x0001;
public static final int POSIX_SPAWN_NP_CSM_NOSMT =       0x0002;
public static final int POSIX_SPAWN_NP_CSM_TECS =        0x0004;

public static native int posix_spawn_file_actions_addinherit_np(@Cast("posix_spawn_file_actions_t*") @ByPtrPtr posix_spawn_file_actions_t arg0,
    int arg1);
public static native int posix_spawn_file_actions_addinherit_np(@Cast("posix_spawn_file_actions_t*") PointerPointer arg0,
    int arg1);

public static native int posix_spawn_file_actions_addchdir_np(@Cast("posix_spawn_file_actions_t*") @ByPtrPtr posix_spawn_file_actions_t arg0,
    @Cast("const char*") BytePointer arg1);
public static native int posix_spawn_file_actions_addchdir_np(@Cast("posix_spawn_file_actions_t*") PointerPointer arg0,
    String arg1);

public static native int posix_spawn_file_actions_addfchdir_np(@Cast("posix_spawn_file_actions_t*") @ByPtrPtr posix_spawn_file_actions_t arg0,
    int arg1);
public static native int posix_spawn_file_actions_addfchdir_np(@Cast("posix_spawn_file_actions_t*") PointerPointer arg0,
    int arg1);

// #endif /* (!_POSIX_C_SOURCE || _DARWIN_C_SOURCE) */
// #endif  /* _SPAWN_H_ */


// Parsed from sys/_types/_seek_set.h

/*
 * Copyright (c) 2003-2012 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */

// #include <sys/cdefs.h>

/* whence values for lseek(2) */
// #ifndef SEEK_SET
public static final int SEEK_SET =        0;       /* set file offset to offset */
public static final int SEEK_CUR =        1;       /* set file offset to current plus offset */
public static final int SEEK_END =        2;       /* set file offset to EOF plus offset */
// #endif  /* !SEEK_SET */

// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
// #ifndef SEEK_HOLE
public static final int SEEK_HOLE =       3;       /* set file offset to the start of the next hole greater than or equal to the supplied offset */
// #endif

// #ifndef SEEK_DATA
public static final int SEEK_DATA =       4;       /* set file offset to the start of the next non-hole file region greater than or equal to the supplied offset */
// #endif
// #endif /* __DARWIN_C_LEVEL >= __DARWIN_C_FULL */


// Parsed from sys/unistd.h

/*
 * Copyright (c) 2000-2013 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
/* Copyright (c) 1995 NeXT Computer, Inc. All Rights Reserved */
/*
 * Copyright (c) 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)unistd.h	8.2 (Berkeley) 1/7/94
 */

// #ifndef _SYS_UNISTD_H_
// #define _SYS_UNISTD_H_

// #include <sys/cdefs.h>

/*
 * Although we have saved user/group IDs, we do not use them in setuid
 * as described in POSIX 1003.1, because the feature does not work for
 * root.  We use the saved IDs in seteuid/setegid, which are not currently
 * part of the POSIX 1003.1 specification.
 */
// #ifdef  _NOT_AVAILABLE
// #define _POSIX_SAVED_IDS        /* saved set-user-ID and set-group-ID */
// #endif

public static final long _POSIX_VERSION =          200112L;
public static native @MemberGetter long _POSIX2_VERSION();
public static final long _POSIX2_VERSION = _POSIX2_VERSION();

/* execution-time symbolic constants */
/* may disable terminal special characters */
// #include <sys/_types/_posix_vdisable.h>

public static final int _POSIX_THREAD_KEYS_MAX = 128;

/* access function */
public static final int F_OK =            0;       /* test for existence of file */
public static final int X_OK =            (1<<0);  /* test for execute or search permission */
public static final int W_OK =            (1<<1);  /* test for write permission */
public static final int R_OK =            (1<<2);  /* test for read permission */

// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
/*
 * Extended access functions.
 * Note that we depend on these matching the definitions in sys/kauth.h,
 * but with the bits shifted left by 8.
 */
public static final int _READ_OK =        (1<<9);  /* read file data / read directory */
public static final int _WRITE_OK =       (1<<10); /* write file data / add file to directory */
public static final int _EXECUTE_OK =     (1<<11); /* execute file / search in directory*/
public static final int _DELETE_OK =      (1<<12); /* delete file / delete directory */
public static final int _APPEND_OK =      (1<<13); /* append to file / add subdirectory to directory */
public static final int _RMFILE_OK =      (1<<14); /* - / remove file from directory */
public static final int _RATTR_OK =       (1<<15); /* read basic attributes */
public static final int _WATTR_OK =       (1<<16); /* write basic attributes */
public static final int _REXT_OK =        (1<<17); /* read extended attributes */
public static final int _WEXT_OK =        (1<<18); /* write extended attributes */
public static final int _RPERM_OK =       (1<<19); /* read permissions */
public static final int _WPERM_OK =       (1<<20); /* write permissions */
public static final int _CHOWN_OK =       (1<<21); /* change ownership */

public static final int _ACCESS_EXTENDED_MASK = (_READ_OK | _WRITE_OK | _EXECUTE_OK | 
	                        _DELETE_OK | _APPEND_OK | 
	                        _RMFILE_OK | _REXT_OK | 
	                        _WEXT_OK | _RATTR_OK | _WATTR_OK | _RPERM_OK | 
	                        _WPERM_OK | _CHOWN_OK);
// #endif

/* whence values for lseek(2) */
// #include <sys/_types/_seek_set.h>

// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
/* whence values for lseek(2); renamed by POSIX 1003.1 */
public static final int L_SET =           SEEK_SET;
public static final int L_INCR =          SEEK_CUR;
public static final int L_XTND =          SEEK_END;
// Targeting ../macosx/accessx_descriptor.java


public static final int ACCESSX_MAX_DESCRIPTORS = 100;
public static final int ACCESSX_MAX_TABLESIZE =   (16 * 1024);
// #endif

/* configurable pathname variables */
public static final int _PC_LINK_MAX =             1;
public static final int _PC_MAX_CANON =            2;
public static final int _PC_MAX_INPUT =            3;
public static final int _PC_NAME_MAX =             4;
public static final int _PC_PATH_MAX =             5;
public static final int _PC_PIPE_BUF =             6;
public static final int _PC_CHOWN_RESTRICTED =     7;
public static final int _PC_NO_TRUNC =             8;
public static final int _PC_VDISABLE =             9;

// #if !defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)
public static final int _PC_NAME_CHARS_MAX =       10;
public static final int _PC_CASE_SENSITIVE =               11;
public static final int _PC_CASE_PRESERVING =              12;
public static final int _PC_EXTENDED_SECURITY_NP =        13;
public static final int _PC_AUTH_OPAQUE_NP =      14;
// #endif

public static final int _PC_2_SYMLINKS =          15;      /* Symlink supported in directory */
public static final int _PC_ALLOC_SIZE_MIN =      16;      /* Minimum storage actually allocated */
public static final int _PC_ASYNC_IO =            17;      /* Async I/O [AIO] supported? */
public static final int _PC_FILESIZEBITS =        18;      /* # of bits to represent file size */
public static final int _PC_PRIO_IO =             19;      /* Priority I/O [PIO] supported? */
public static final int _PC_REC_INCR_XFER_SIZE =  20;      /* Recommended increment for next two */
public static final int _PC_REC_MAX_XFER_SIZE =   21;      /* Recommended max file transfer size */
public static final int _PC_REC_MIN_XFER_SIZE =   22;      /* Recommended min file transfer size */
public static final int _PC_REC_XFER_ALIGN =      23;      /* Recommended buffer alignment */
public static final int _PC_SYMLINK_MAX =         24;      /* Max # of bytes in symlink name */
public static final int _PC_SYNC_IO =             25;      /* Sync I/O [SIO] supported? */
public static final int _PC_XATTR_SIZE_BITS =     26;      /* # of bits to represent maximum xattr size */
public static final int _PC_MIN_HOLE_SIZE =       27;      /* Recommended minimum hole size for sparse files */

/* configurable system strings */
public static final int _CS_PATH =                 1;

// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL

// #include <machine/_types.h>
// #include <sys/_types/_size_t.h>
// #include <_types/_uint64_t.h>
// #include <_types/_uint32_t.h>
// #include <Availability.h>

public static native int getattrlistbulk(int arg0, Pointer arg1, Pointer arg2, @Cast("size_t") long arg3, @Cast("uint64_t") long arg4);
public static native int getattrlistat(int arg0, @Cast("const char*") BytePointer arg1, Pointer arg2, Pointer arg3, @Cast("size_t") long arg4, @Cast("unsigned long") long arg5);
public static native int getattrlistat(int arg0, String arg1, Pointer arg2, Pointer arg3, @Cast("size_t") long arg4, @Cast("unsigned long") long arg5);
public static native int setattrlistat(int arg0, @Cast("const char*") BytePointer arg1, Pointer arg2, Pointer arg3, @Cast("size_t") long arg4, @Cast("uint32_t") int arg5);
public static native int setattrlistat(int arg0, String arg1, Pointer arg2, Pointer arg3, @Cast("size_t") long arg4, @Cast("uint32_t") int arg5);

// #endif /* __DARWIN_C_LEVEL >= __DARWIN_C_FULL */

// #if __DARWIN_C_LEVEL >= 200809L

// #include <machine/_types.h>
// #include <sys/_types/_size_t.h>
// #include <sys/_types/_ssize_t.h>
// #include <sys/_types.h>
// #include <sys/_types/_uid_t.h>
// #include <sys/_types/_gid_t.h>
// #include <Availability.h>

public static native int faccessat(int arg0, @Cast("const char*") BytePointer arg1, int arg2, int arg3);
public static native int faccessat(int arg0, String arg1, int arg2, int arg3);
public static native int fchownat(int arg0, @Cast("const char*") BytePointer arg1, @Cast("uid_t") int arg2, @Cast("gid_t") int arg3, int arg4);
public static native int fchownat(int arg0, String arg1, @Cast("uid_t") int arg2, @Cast("gid_t") int arg3, int arg4);
public static native int linkat(int arg0, @Cast("const char*") BytePointer arg1, int arg2, @Cast("const char*") BytePointer arg3, int arg4);
public static native int linkat(int arg0, String arg1, int arg2, String arg3, int arg4);
public static native @Cast("ssize_t") long readlinkat(int arg0, @Cast("const char*") BytePointer arg1, @Cast("char*") BytePointer arg2, @Cast("size_t") long arg3);
public static native @Cast("ssize_t") long readlinkat(int arg0, String arg1, @Cast("char*") ByteBuffer arg2, @Cast("size_t") long arg3);
public static native @Cast("ssize_t") long readlinkat(int arg0, @Cast("const char*") BytePointer arg1, @Cast("char*") byte[] arg2, @Cast("size_t") long arg3);
public static native @Cast("ssize_t") long readlinkat(int arg0, String arg1, @Cast("char*") BytePointer arg2, @Cast("size_t") long arg3);
public static native @Cast("ssize_t") long readlinkat(int arg0, @Cast("const char*") BytePointer arg1, @Cast("char*") ByteBuffer arg2, @Cast("size_t") long arg3);
public static native @Cast("ssize_t") long readlinkat(int arg0, String arg1, @Cast("char*") byte[] arg2, @Cast("size_t") long arg3);
public static native int symlinkat(@Cast("const char*") BytePointer arg0, int arg1, @Cast("const char*") BytePointer arg2);
public static native int symlinkat(String arg0, int arg1, String arg2);
public static native int unlinkat(int arg0, @Cast("const char*") BytePointer arg1, int arg2);
public static native int unlinkat(int arg0, String arg1, int arg2);

// #endif /* __DARWIN_C_LEVEL >= 200809L */

// #endif /* !_SYS_UNISTD_H_ */


// Parsed from unistd.h

/*
 * Copyright (c) 2000, 2002-2006, 2008-2010, 2012 Apple Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*-
 * Copyright (c) 1998-1999 Apple Computer, Inc. All Rights Reserved
 * Copyright (c) 1991, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)unistd.h	8.12 (Berkeley) 4/27/95
 *
 *  Copyright (c)  1998 Apple Compter, Inc.
 *  All Rights Reserved
 */

/* History:
        7/14/99 EKN at Apple fixed getdirentriesattr from getdirentryattr
        3/26/98 CHW at Apple added real interface to searchfs call
  	3/5/98  CHW at Apple added hfs semantic system calls headers
*/

// #ifndef _UNISTD_H_
// #define	_UNISTD_H_

// #include <_types.h>
// #include <sys/unistd.h>
// #include <Availability.h>
// #include <sys/_types/_gid_t.h>
// #include <sys/_types/_intptr_t.h>
// #include <sys/_types/_off_t.h>
// #include <sys/_types/_pid_t.h>
/* DO NOT REMOVE THIS COMMENT: fixincludes needs to see:
 * _GCC_SIZE_T */
// #include <sys/_types/_size_t.h>
// #include <sys/_types/_ssize_t.h>
// #include <sys/_types/_uid_t.h>
// #include <sys/_types/_useconds_t.h>
// #include <sys/_types/_null.h>

public static final int STDIN_FILENO =	0;	/* standard input file descriptor */
public static final int STDOUT_FILENO =	1;	/* standard output file descriptor */
public static final int STDERR_FILENO =	2;	/* standard error file descriptor */


/* Version test macros */
/* _POSIX_VERSION and _POSIX2_VERSION from sys/unistd.h */
public static final int _XOPEN_VERSION =			600;		/* [XSI] */
public static final int _XOPEN_XCU_VERSION =		4;		/* Older standard */


/* Please keep this list in the same order as the applicable standard */
public static final int _POSIX_ADVISORY_INFO =		(-1);		/* [ADV] */
public static final int _POSIX_ASYNCHRONOUS_IO =		(-1);		/* [AIO] */
public static final int _POSIX_BARRIERS =			(-1);		/* [BAR] */
public static final long _POSIX_CHOWN_RESTRICTED =		200112L;
public static final int _POSIX_CLOCK_SELECTION =		(-1);		/* [CS] */
public static final int _POSIX_CPUTIME =			(-1);		/* [CPT] */
public static final long _POSIX_FSYNC =			200112L;		/* [FSC] */
public static final long _POSIX_IPV6 =			200112L;
public static final long _POSIX_JOB_CONTROL =		200112L;
public static final long _POSIX_MAPPED_FILES =		200112L;		/* [MF] */
public static final int _POSIX_MEMLOCK =			(-1);		/* [ML] */
public static final int _POSIX_MEMLOCK_RANGE =		(-1);		/* [MR] */
public static final long _POSIX_MEMORY_PROTECTION =	200112L;		/* [MPR] */
public static final int _POSIX_MESSAGE_PASSING =		(-1);		/* [MSG] */
public static final int _POSIX_MONOTONIC_CLOCK =		(-1);		/* [MON] */
public static final long _POSIX_NO_TRUNC =			200112L;
public static final int _POSIX_PRIORITIZED_IO =		(-1);		/* [PIO] */
public static final int _POSIX_PRIORITY_SCHEDULING =	(-1);		/* [PS] */
public static final int _POSIX_RAW_SOCKETS =		(-1);		/* [RS] */
public static final long _POSIX_READER_WRITER_LOCKS =	200112L;		/* [THR] */
public static final int _POSIX_REALTIME_SIGNALS =		(-1);		/* [RTS] */
public static final long _POSIX_REGEXP =			200112L;
public static final long _POSIX_SAVED_IDS =		200112L;		/* XXX required */
public static final int _POSIX_SEMAPHORES =		(-1);		/* [SEM] */
public static final int _POSIX_SHARED_MEMORY_OBJECTS =	(-1);		/* [SHM] */
public static final long _POSIX_SHELL =			200112L;
public static final int _POSIX_SPAWN =			(-1);		/* [SPN] */
public static final int _POSIX_SPIN_LOCKS =		(-1);		/* [SPI] */
public static final int _POSIX_SPORADIC_SERVER =		(-1);		/* [SS] */
public static final int _POSIX_SYNCHRONIZED_IO =		(-1);		/* [SIO] */
public static final long _POSIX_THREAD_ATTR_STACKADDR =	200112L;		/* [TSA] */
public static final long _POSIX_THREAD_ATTR_STACKSIZE =	200112L;		/* [TSS] */
public static final int _POSIX_THREAD_CPUTIME =		(-1);		/* [TCT] */
public static final int _POSIX_THREAD_PRIO_INHERIT =	(-1);		/* [TPI] */
public static final int _POSIX_THREAD_PRIO_PROTECT =	(-1);		/* [TPP] */
public static final int _POSIX_THREAD_PRIORITY_SCHEDULING =	(-1);	/* [TPS] */
public static final long _POSIX_THREAD_PROCESS_SHARED =	200112L;		/* [TSH] */
public static final long _POSIX_THREAD_SAFE_FUNCTIONS =	200112L;		/* [TSF] */
public static final int _POSIX_THREAD_SPORADIC_SERVER =	(-1);		/* [TSP] */
public static final long _POSIX_THREADS =			200112L;		/* [THR] */
public static final int _POSIX_TIMEOUTS =			(-1);		/* [TMO] */
public static final int _POSIX_TIMERS =			(-1);		/* [TMR] */
public static final int _POSIX_TRACE =			(-1);		/* [TRC] */
public static final int _POSIX_TRACE_EVENT_FILTER =	(-1);		/* [TEF] */
public static final int _POSIX_TRACE_INHERIT =		(-1);		/* [TRI] */
public static final int _POSIX_TRACE_LOG =		(-1);		/* [TRL] */
public static final int _POSIX_TYPED_MEMORY_OBJECTS =	(-1);		/* [TYM] */
// #ifndef _POSIX_VDISABLE
public static final int _POSIX_VDISABLE =			0xff;		/* same as sys/termios.h */
// #endif /* _POSIX_VDISABLE */

// #if __DARWIN_C_LEVEL >= 199209L
public static native @MemberGetter long _POSIX2_C_BIND();
public static final long _POSIX2_C_BIND = _POSIX2_C_BIND();
public static native @MemberGetter long _POSIX2_C_DEV();
public static final long _POSIX2_C_DEV = _POSIX2_C_DEV();		/* c99 command */
public static final long _POSIX2_CHAR_TERM =		200112L;
public static final int _POSIX2_FORT_DEV =		(-1);		/* fort77 command */
public static final long _POSIX2_FORT_RUN =		200112L;
public static native @MemberGetter long _POSIX2_LOCALEDEF();
public static final long _POSIX2_LOCALEDEF = _POSIX2_LOCALEDEF();		/* localedef command */
public static final int _POSIX2_PBS =			(-1);
public static final int _POSIX2_PBS_ACCOUNTING =		(-1);
public static final int _POSIX2_PBS_CHECKPOINT =		(-1);
public static final int _POSIX2_PBS_LOCATE =		(-1);
public static final int _POSIX2_PBS_MESSAGE =		(-1);
public static final int _POSIX2_PBS_TRACK =		(-1);
public static native @MemberGetter long _POSIX2_SW_DEV();
public static final long _POSIX2_SW_DEV = _POSIX2_SW_DEV();
public static final long _POSIX2_UPE =			200112L;	/* XXXX no fc, newgrp, tabs */
// #endif /* __DARWIN_C_LEVEL */

public static final int __ILP32_OFF32 =          (-1);
public static final int __ILP32_OFFBIG =         (-1);

public static final int __LP64_OFF64 =           (1);
public static final int __LPBIG_OFFBIG =         (1);

// #if __DARWIN_C_LEVEL >= 200112L
public static final int _POSIX_V6_ILP32_OFF32 =		__ILP32_OFF32;
public static final int _POSIX_V6_ILP32_OFFBIG =		__ILP32_OFFBIG;
public static final int _POSIX_V6_LP64_OFF64 =		__LP64_OFF64;
public static final int _POSIX_V6_LPBIG_OFFBIG =		__LPBIG_OFFBIG;
// #endif /* __DARWIN_C_LEVEL >= 200112L */

// #if __DARWIN_C_LEVEL >= 200809L
public static final int _POSIX_V7_ILP32_OFF32 =		__ILP32_OFF32;
public static final int _POSIX_V7_ILP32_OFFBIG =		__ILP32_OFFBIG;
public static final int _POSIX_V7_LP64_OFF64 =		__LP64_OFF64;
public static final int _POSIX_V7_LPBIG_OFFBIG =		__LPBIG_OFFBIG;
// #endif /* __DARWIN_C_LEVEL >= 200809L */

// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static final int _V6_ILP32_OFF32 =             __ILP32_OFF32;
public static final int _V6_ILP32_OFFBIG =            __ILP32_OFFBIG;
public static final int _V6_LP64_OFF64 =              __LP64_OFF64;
public static final int _V6_LPBIG_OFFBIG =            __LPBIG_OFFBIG;
// #endif /* __DARWIN_C_LEVEL >= __DARWIN_C_FULL */

// #if (__DARWIN_C_LEVEL >= 199506L && __DARWIN_C_LEVEL < 200809L) || __DARWIN_C_LEVEL >= __DARWIN_C_FULL
/* Removed in Issue 7 */
public static final int _XBS5_ILP32_OFF32 =		    __ILP32_OFF32;
public static final int _XBS5_ILP32_OFFBIG =		    __ILP32_OFFBIG;
public static final int _XBS5_LP64_OFF64 =		    __LP64_OFF64;
public static final int _XBS5_LPBIG_OFFBIG =		    __LPBIG_OFFBIG;
// #endif /* __DARWIN_C_LEVEL < 200809L */

// #if __DARWIN_C_LEVEL >= 199506L /* This really should be XSI */ 
public static final int _XOPEN_CRYPT =			(1);
public static final int _XOPEN_ENH_I18N =			(1);		/* XXX required */
public static final int _XOPEN_LEGACY =			(-1);	/* no ftime gcvt, wcswcs */
public static final int _XOPEN_REALTIME =			(-1);	/* no q'ed signals, mq_* */
public static final int _XOPEN_REALTIME_THREADS =		(-1);	/* no posix_spawn, et. al. */
public static final int _XOPEN_SHM =			(1);
public static final int _XOPEN_STREAMS =			(-1);   /* Issue 6 */
public static final int _XOPEN_UNIX =			(1);
// #endif /* XSI */

/* configurable system variables */
public static final int _SC_ARG_MAX =			 1;
public static final int _SC_CHILD_MAX =			 2;
public static final int _SC_CLK_TCK =			 3;
public static final int _SC_NGROUPS_MAX =			 4;
public static final int _SC_OPEN_MAX =			 5;
public static final int _SC_JOB_CONTROL =			 6;
public static final int _SC_SAVED_IDS =			 7;
public static final int _SC_VERSION =			 8;
public static final int _SC_BC_BASE_MAX =			 9;
public static final int _SC_BC_DIM_MAX =			10;
public static final int _SC_BC_SCALE_MAX =		11;
public static final int _SC_BC_STRING_MAX =		12;
public static final int _SC_COLL_WEIGHTS_MAX =		13;
public static final int _SC_EXPR_NEST_MAX =		14;
public static final int _SC_LINE_MAX =			15;
public static final int _SC_RE_DUP_MAX =			16;
public static final int _SC_2_VERSION =			17;
public static final int _SC_2_C_BIND =			18;
public static final int _SC_2_C_DEV =			19;
public static final int _SC_2_CHAR_TERM =			20;
public static final int _SC_2_FORT_DEV =			21;
public static final int _SC_2_FORT_RUN =			22;
public static final int _SC_2_LOCALEDEF =			23;
public static final int _SC_2_SW_DEV =			24;
public static final int _SC_2_UPE =			25;
public static final int _SC_STREAM_MAX =			26;
public static final int _SC_TZNAME_MAX =			27;

// #if __DARWIN_C_LEVEL >= 199309L
public static final int _SC_ASYNCHRONOUS_IO =		28;
public static final int _SC_PAGESIZE =			29;
public static final int _SC_MEMLOCK =			30;
public static final int _SC_MEMLOCK_RANGE =		31;
public static final int _SC_MEMORY_PROTECTION =		32;
public static final int _SC_MESSAGE_PASSING =		33;
public static final int _SC_PRIORITIZED_IO =		34;
public static final int _SC_PRIORITY_SCHEDULING =		35;
public static final int _SC_REALTIME_SIGNALS =		36;
public static final int _SC_SEMAPHORES =			37;
public static final int _SC_FSYNC =			38;
public static final int _SC_SHARED_MEMORY_OBJECTS = 	39;
public static final int _SC_SYNCHRONIZED_IO =		40;
public static final int _SC_TIMERS =			41;
public static final int _SC_AIO_LISTIO_MAX =		42;
public static final int _SC_AIO_MAX =			43;
public static final int _SC_AIO_PRIO_DELTA_MAX =		44;
public static final int _SC_DELAYTIMER_MAX =		45;
public static final int _SC_MQ_OPEN_MAX =			46;
public static final int _SC_MAPPED_FILES =		47;	/* swap _SC_PAGESIZE vs. BSD */
public static final int _SC_RTSIG_MAX =			48;
public static final int _SC_SEM_NSEMS_MAX =		49;
public static final int _SC_SEM_VALUE_MAX =		50;
public static final int _SC_SIGQUEUE_MAX =		51;
public static final int _SC_TIMER_MAX =			52;
// #endif /* __DARWIN_C_LEVEL >= 199309L */

// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static final int _SC_NPROCESSORS_CONF =		57;
public static final int _SC_NPROCESSORS_ONLN =		58;
// #endif /* __DARWIN_C_LEVEL >= __DARWIN_C_FULL */

// #if __DARWIN_C_LEVEL >= 200112L
public static final int _SC_2_PBS =			59;
public static final int _SC_2_PBS_ACCOUNTING =		60;
public static final int _SC_2_PBS_CHECKPOINT =		61;
public static final int _SC_2_PBS_LOCATE =		62;
public static final int _SC_2_PBS_MESSAGE =		63;
public static final int _SC_2_PBS_TRACK =			64;
public static final int _SC_ADVISORY_INFO =		65;
public static final int _SC_BARRIERS =			66;
public static final int _SC_CLOCK_SELECTION =		67;
public static final int _SC_CPUTIME =			68;
public static final int _SC_FILE_LOCKING =		69;
public static final int _SC_GETGR_R_SIZE_MAX =		70;
public static final int _SC_GETPW_R_SIZE_MAX =		71;
public static final int _SC_HOST_NAME_MAX =		72;
public static final int _SC_LOGIN_NAME_MAX =		73;
public static final int _SC_MONOTONIC_CLOCK =		74;
public static final int _SC_MQ_PRIO_MAX =			75;
public static final int _SC_READER_WRITER_LOCKS =		76;
public static final int _SC_REGEXP =			77;
public static final int _SC_SHELL =			78;
public static final int _SC_SPAWN =			79;
public static final int _SC_SPIN_LOCKS =			80;
public static final int _SC_SPORADIC_SERVER =		81;
public static final int _SC_THREAD_ATTR_STACKADDR =	82;
public static final int _SC_THREAD_ATTR_STACKSIZE =	83;
public static final int _SC_THREAD_CPUTIME =		84;
public static final int _SC_THREAD_DESTRUCTOR_ITERATIONS = 85;
public static final int _SC_THREAD_KEYS_MAX =		86;
public static final int _SC_THREAD_PRIO_INHERIT =		87;
public static final int _SC_THREAD_PRIO_PROTECT =		88;
public static final int _SC_THREAD_PRIORITY_SCHEDULING =	89;
public static final int _SC_THREAD_PROCESS_SHARED =	90;
public static final int _SC_THREAD_SAFE_FUNCTIONS =	91;
public static final int _SC_THREAD_SPORADIC_SERVER =	92;
public static final int _SC_THREAD_STACK_MIN =		93;
public static final int _SC_THREAD_THREADS_MAX =		94;
public static final int _SC_TIMEOUTS =			95;
public static final int _SC_THREADS =			96;
public static final int _SC_TRACE =			97;
public static final int _SC_TRACE_EVENT_FILTER =		98;
public static final int _SC_TRACE_INHERIT =		99;
public static final int _SC_TRACE_LOG =			100;
public static final int _SC_TTY_NAME_MAX =		101;
public static final int _SC_TYPED_MEMORY_OBJECTS =	102;
public static final int _SC_V6_ILP32_OFF32 =		103;
public static final int _SC_V6_ILP32_OFFBIG =		104;
public static final int _SC_V6_LP64_OFF64 =		105;
public static final int _SC_V6_LPBIG_OFFBIG =		106;
public static final int _SC_IPV6 =			118;
public static final int _SC_RAW_SOCKETS =			119;
public static final int _SC_SYMLOOP_MAX =			120;
// #endif /* __DARWIN_C_LEVEL >= 200112L */

// #if __DARWIN_C_LEVEL >= 199506L /* Really XSI */
public static final int _SC_ATEXIT_MAX =			107;
public static final int _SC_IOV_MAX =			56;
public static final int _SC_PAGE_SIZE =			_SC_PAGESIZE;
public static final int _SC_XOPEN_CRYPT =			108;
public static final int _SC_XOPEN_ENH_I18N =		109;
public static final int _SC_XOPEN_LEGACY =		110;      /* Issue 6 */
public static final int _SC_XOPEN_REALTIME =		111;      /* Issue 6 */
public static final int _SC_XOPEN_REALTIME_THREADS =	112;  /* Issue 6 */
public static final int _SC_XOPEN_SHM =			113;
public static final int _SC_XOPEN_STREAMS =		114;      /* Issue 6 */
public static final int _SC_XOPEN_UNIX =			115;
public static final int _SC_XOPEN_VERSION =		116;
public static final int _SC_XOPEN_XCU_VERSION =		121;
// #endif /* XSI */

// #if (__DARWIN_C_LEVEL >= 199506L && __DARWIN_C_LEVEL < 200809L) || __DARWIN_C_LEVEL >= __DARWIN_C_FULL
/* Removed in Issue 7 */
public static final int _SC_XBS5_ILP32_OFF32 =		122;
public static final int _SC_XBS5_ILP32_OFFBIG =		123;
public static final int _SC_XBS5_LP64_OFF64 =		124;
public static final int _SC_XBS5_LPBIG_OFFBIG =		125;
// #endif /* __DARWIN_C_LEVEL <= 200809L */

// #if __DARWIN_C_LEVEL >= 200112L
public static final int _SC_SS_REPL_MAX =			126;
public static final int _SC_TRACE_EVENT_NAME_MAX =	127;
public static final int _SC_TRACE_NAME_MAX =		128;
public static final int _SC_TRACE_SYS_MAX =		129;
public static final int _SC_TRACE_USER_EVENT_MAX =	130;
// #endif

// #if __DARWIN_C_LEVEL < 200112L || __DARWIN_C_LEVEL >= __DARWIN_C_FULL
/* Removed in Issue 6 */
public static final int _SC_PASS_MAX =			131;
// #endif

/* 132-199 available for future use */
// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static final int _SC_PHYS_PAGES =			200;
// #endif /* __DARWIN_C_LEVEL >= __DARWIN_C_FULL */

// #if __DARWIN_C_LEVEL >= 199209L
// #ifndef _CS_PATH /* Defined in <sys/unistd.h> */
// #endif
// #endif

// #if __DARWIN_C_LEVEL >= 200112
public static final int _CS_POSIX_V6_ILP32_OFF32_CFLAGS =		2;
public static final int _CS_POSIX_V6_ILP32_OFF32_LDFLAGS =	3;
public static final int _CS_POSIX_V6_ILP32_OFF32_LIBS =		4;
public static final int _CS_POSIX_V6_ILP32_OFFBIG_CFLAGS =	5;
public static final int _CS_POSIX_V6_ILP32_OFFBIG_LDFLAGS =	6;
public static final int _CS_POSIX_V6_ILP32_OFFBIG_LIBS =		7;
public static final int _CS_POSIX_V6_LP64_OFF64_CFLAGS =		8;
public static final int _CS_POSIX_V6_LP64_OFF64_LDFLAGS =		9;
public static final int _CS_POSIX_V6_LP64_OFF64_LIBS =		10;
public static final int _CS_POSIX_V6_LPBIG_OFFBIG_CFLAGS =	11;
public static final int _CS_POSIX_V6_LPBIG_OFFBIG_LDFLAGS =	12;
public static final int _CS_POSIX_V6_LPBIG_OFFBIG_LIBS =		13;
public static final int _CS_POSIX_V6_WIDTH_RESTRICTED_ENVS =	14;
// #endif

// #if (__DARWIN_C_LEVEL >= 199506L && __DARWIN_C_LEVEL < 200809L) || __DARWIN_C_LEVEL >= __DARWIN_C_FULL
/* Removed in Issue 7 */
public static final int _CS_XBS5_ILP32_OFF32_CFLAGS =		20;
public static final int _CS_XBS5_ILP32_OFF32_LDFLAGS =		21;
public static final int _CS_XBS5_ILP32_OFF32_LIBS =		22;
public static final int _CS_XBS5_ILP32_OFF32_LINTFLAGS =		23;
public static final int _CS_XBS5_ILP32_OFFBIG_CFLAGS =		24;
public static final int _CS_XBS5_ILP32_OFFBIG_LDFLAGS =		25;
public static final int _CS_XBS5_ILP32_OFFBIG_LIBS =		26;
public static final int _CS_XBS5_ILP32_OFFBIG_LINTFLAGS =		27;
public static final int _CS_XBS5_LP64_OFF64_CFLAGS =		28;
public static final int _CS_XBS5_LP64_OFF64_LDFLAGS =		29;
public static final int _CS_XBS5_LP64_OFF64_LIBS =		30;
public static final int _CS_XBS5_LP64_OFF64_LINTFLAGS =		31;
public static final int _CS_XBS5_LPBIG_OFFBIG_CFLAGS =		32;
public static final int _CS_XBS5_LPBIG_OFFBIG_LDFLAGS =		33;
public static final int _CS_XBS5_LPBIG_OFFBIG_LIBS =		34;
public static final int _CS_XBS5_LPBIG_OFFBIG_LINTFLAGS =		35;
// #endif

// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static final int _CS_DARWIN_USER_DIR =			65536;
public static final int _CS_DARWIN_USER_TEMP_DIR =		65537;
public static final int _CS_DARWIN_USER_CACHE_DIR =		65538;
// #endif /* __DARWIN_C_LEVEL >= __DARWIN_C_FULL */


// #ifdef _DARWIN_UNLIMITED_GETGROUPS
// #if defined(__IPHONE_OS_VERSION_MIN_REQUIRED) && __IPHONE_OS_VERSION_MIN_REQUIRED < __IPHONE_3_2
// #error "_DARWIN_UNLIMITED_GETGROUPS specified, but -miphoneos-version-min version does not support it."
// #elif defined(__MAC_OS_X_VERSION_MIN_REQUIRED) && __MAC_OS_X_VERSION_MIN_REQUIRED < __MAC_10_6
// #error "_DARWIN_UNLIMITED_GETGROUPS specified, but -mmacosx-version-min version does not support it."
// #endif
// #endif

/* POSIX.1-1990 */

public static native void _exit(int arg0);
public static native int access(@Cast("const char*") BytePointer arg0, int arg1);
public static native int access(String arg0, int arg1);
public static native @Cast("unsigned int") int alarm(@Cast("unsigned int") int arg0);
public static native int chdir(@Cast("const char*") BytePointer arg0);
public static native int chdir(String arg0);
public static native int chown(@Cast("const char*") BytePointer arg0, @Cast("uid_t") int arg1, @Cast("gid_t") int arg2);
public static native int chown(String arg0, @Cast("uid_t") int arg1, @Cast("gid_t") int arg2);

public static native @Name("close") int _close(int arg0);

public static native int dup(int arg0);
public static native int dup2(int arg0, int arg1);
public static native int execl(@Cast("const char*") BytePointer __path, @Cast("const char*") BytePointer __arg0);
public static native int execl(String __path, String __arg0);
public static native int execle(@Cast("const char*") BytePointer __path, @Cast("const char*") BytePointer __arg0);
public static native int execle(String __path, String __arg0);
public static native int execlp(@Cast("const char*") BytePointer __file, @Cast("const char*") BytePointer __arg0);
public static native int execlp(String __file, String __arg0);
public static native int execv(@Cast("const char*") BytePointer __path, @Cast("char*const*") PointerPointer __argv);
public static native int execv(@Cast("const char*") BytePointer __path, @Cast("char*const*") @ByPtrPtr BytePointer __argv);
public static native int execv(String __path, @Cast("char*const*") @ByPtrPtr ByteBuffer __argv);
public static native int execv(@Cast("const char*") BytePointer __path, @Cast("char*const*") @ByPtrPtr byte[] __argv);
public static native int execv(String __path, @Cast("char*const*") @ByPtrPtr BytePointer __argv);
public static native int execv(@Cast("const char*") BytePointer __path, @Cast("char*const*") @ByPtrPtr ByteBuffer __argv);
public static native int execv(String __path, @Cast("char*const*") @ByPtrPtr byte[] __argv);
public static native int execve(@Cast("const char*") BytePointer __file, @Cast("char*const*") PointerPointer __argv, @Cast("char*const*") PointerPointer __envp);
public static native int execve(@Cast("const char*") BytePointer __file, @Cast("char*const*") @ByPtrPtr BytePointer __argv, @Cast("char*const*") @ByPtrPtr BytePointer __envp);
public static native int execve(String __file, @Cast("char*const*") @ByPtrPtr ByteBuffer __argv, @Cast("char*const*") @ByPtrPtr ByteBuffer __envp);
public static native int execve(@Cast("const char*") BytePointer __file, @Cast("char*const*") @ByPtrPtr byte[] __argv, @Cast("char*const*") @ByPtrPtr byte[] __envp);
public static native int execve(String __file, @Cast("char*const*") @ByPtrPtr BytePointer __argv, @Cast("char*const*") @ByPtrPtr BytePointer __envp);
public static native int execve(@Cast("const char*") BytePointer __file, @Cast("char*const*") @ByPtrPtr ByteBuffer __argv, @Cast("char*const*") @ByPtrPtr ByteBuffer __envp);
public static native int execve(String __file, @Cast("char*const*") @ByPtrPtr byte[] __argv, @Cast("char*const*") @ByPtrPtr byte[] __envp);
public static native int execvp(@Cast("const char*") BytePointer __file, @Cast("char*const*") PointerPointer __argv);
public static native int execvp(@Cast("const char*") BytePointer __file, @Cast("char*const*") @ByPtrPtr BytePointer __argv);
public static native int execvp(String __file, @Cast("char*const*") @ByPtrPtr ByteBuffer __argv);
public static native int execvp(@Cast("const char*") BytePointer __file, @Cast("char*const*") @ByPtrPtr byte[] __argv);
public static native int execvp(String __file, @Cast("char*const*") @ByPtrPtr BytePointer __argv);
public static native int execvp(@Cast("const char*") BytePointer __file, @Cast("char*const*") @ByPtrPtr ByteBuffer __argv);
public static native int execvp(String __file, @Cast("char*const*") @ByPtrPtr byte[] __argv);
public static native @Cast("pid_t") int fork();
public static native long fpathconf(int arg0, int arg1);
public static native @Cast("char*") BytePointer getcwd(@Cast("char*") BytePointer arg0, @Cast("size_t") long arg1);
public static native @Cast("char*") ByteBuffer getcwd(@Cast("char*") ByteBuffer arg0, @Cast("size_t") long arg1);
public static native @Cast("char*") byte[] getcwd(@Cast("char*") byte[] arg0, @Cast("size_t") long arg1);
public static native @Cast("gid_t") int getegid();
public static native @Cast("uid_t") int geteuid();
public static native @Cast("gid_t") int getgid();
// #if defined(_DARWIN_UNLIMITED_GETGROUPS) || defined(_DARWIN_C_SOURCE)
public static native int getgroups(int arg0, @Cast("gid_t*") IntPointer arg1);
public static native int getgroups(int arg0, @Cast("gid_t*") IntBuffer arg1);
public static native int getgroups(int arg0, @Cast("gid_t*") int[] arg1);
// #else /* !_DARWIN_UNLIMITED_GETGROUPS && !_DARWIN_C_SOURCE */
// #endif /* _DARWIN_UNLIMITED_GETGROUPS || _DARWIN_C_SOURCE */
public static native @Cast("char*") BytePointer getlogin();
public static native @Cast("pid_t") int getpgrp();
public static native @Cast("pid_t") int getpid();
public static native @Cast("pid_t") int getppid();
public static native @Cast("uid_t") int getuid();
public static native int isatty(int arg0);
public static native int link(@Cast("const char*") BytePointer arg0, @Cast("const char*") BytePointer arg1);
public static native int link(String arg0, String arg1);
public static native @Cast("off_t") long lseek(int arg0, @Cast("off_t") long arg1, int arg2);
public static native long pathconf(@Cast("const char*") BytePointer arg0, int arg1);
public static native long pathconf(String arg0, int arg1);

public static native int pause();

public static native int pipe(IntPointer arg0);
public static native int pipe(IntBuffer arg0);
public static native int pipe(int[] arg0);

public static native @Cast("ssize_t") long read(int arg0, Pointer arg1, @Cast("size_t") long arg2);

public static native int rmdir(@Cast("const char*") BytePointer arg0);
public static native int rmdir(String arg0);
public static native int setgid(@Cast("gid_t") int arg0);
public static native int setpgid(@Cast("pid_t") int arg0, @Cast("pid_t") int arg1);
public static native @Cast("pid_t") int setsid();
public static native int setuid(@Cast("uid_t") int arg0);

public static native @Cast("unsigned int") int sleep(@Cast("unsigned int") int arg0);

public static native long sysconf(int arg0);
public static native @Cast("pid_t") int tcgetpgrp(int arg0);
public static native int tcsetpgrp(int arg0, @Cast("pid_t") int arg1);
public static native @Cast("char*") BytePointer ttyname(int arg0);

// #if __DARWIN_UNIX03
public static native int ttyname_r(int arg0, @Cast("char*") BytePointer arg1, @Cast("size_t") long arg2);
public static native int ttyname_r(int arg0, @Cast("char*") ByteBuffer arg1, @Cast("size_t") long arg2);
public static native int ttyname_r(int arg0, @Cast("char*") byte[] arg1, @Cast("size_t") long arg2);
// #else /* !__DARWIN_UNIX03 */
// #endif /* __DARWIN_UNIX03 */

public static native int unlink(@Cast("const char*") BytePointer arg0);
public static native int unlink(String arg0);

public static native @Cast("ssize_t") long write(int __fd, @Const Pointer __buf, @Cast("size_t") long __nbyte);
/* Additional functionality provided by:
 * POSIX.2-1992 C Language Binding Option
 */

// #if __DARWIN_C_LEVEL >= 199209L
public static native @Cast("size_t") long confstr(int arg0, @Cast("char*") BytePointer arg1, @Cast("size_t") long arg2);
public static native @Cast("size_t") long confstr(int arg0, @Cast("char*") ByteBuffer arg1, @Cast("size_t") long arg2);
public static native @Cast("size_t") long confstr(int arg0, @Cast("char*") byte[] arg1, @Cast("size_t") long arg2);

public static native int getopt(int arg0, @Cast("char*const*") PointerPointer arg1, @Cast("const char*") BytePointer arg2);
public static native int getopt(int arg0, @Cast("char*const*") @ByPtrPtr BytePointer arg1, @Cast("const char*") BytePointer arg2);
public static native int getopt(int arg0, @Cast("char*const*") @ByPtrPtr ByteBuffer arg1, String arg2);
public static native int getopt(int arg0, @Cast("char*const*") @ByPtrPtr byte[] arg1, @Cast("const char*") BytePointer arg2);
public static native int getopt(int arg0, @Cast("char*const*") @ByPtrPtr BytePointer arg1, String arg2);
public static native int getopt(int arg0, @Cast("char*const*") @ByPtrPtr ByteBuffer arg1, @Cast("const char*") BytePointer arg2);
public static native int getopt(int arg0, @Cast("char*const*") @ByPtrPtr byte[] arg1, String arg2);

public static native @Cast("char*") BytePointer optarg(); public static native void optarg(BytePointer setter);			/* getopt(3) external variables */
public static native int optind(); public static native void optind(int setter);
public static native int opterr(); public static native void opterr(int setter);
public static native int optopt(); public static native void optopt(int setter);
// #endif /* __DARWIN_C_LEVEL >= 199209L */



/* Additional functionality provided by:
 * POSIX.1c-1995,
 * POSIX.1i-1995,
 * and the omnibus ISO/IEC 9945-1: 1996
 */

// #if __DARWIN_C_LEVEL >= 199506L
// #include <_ctermid.h>
                               /* These F_* are really XSI or Issue 6 */
public static final int F_ULOCK =         0;      /* unlock locked section */
public static final int F_LOCK =          1;      /* lock a section for exclusive use */
public static final int F_TLOCK =         2;      /* test and lock a section for exclusive use */
public static final int F_TEST =          3;      /* test a section for locks by other procs */

 /* Begin XSI */
/* Removed in Issue 6 */
// #if !defined(_POSIX_C_SOURCE) || _POSIX_C_SOURCE < 200112L
// #if !defined(_POSIX_C_SOURCE)
public static native @Deprecated Pointer brk(@Const Pointer arg0);
public static native int chroot(@Cast("const char*") BytePointer arg0);
public static native int chroot(String arg0);
// #endif

public static native @Cast("char*") BytePointer crypt(@Cast("const char*") BytePointer arg0, @Cast("const char*") BytePointer arg1);
public static native @Cast("char*") ByteBuffer crypt(String arg0, String arg1);
// #if __DARWIN_UNIX03
public static native void encrypt(@Cast("char*") BytePointer arg0, int arg1);
public static native void encrypt(@Cast("char*") ByteBuffer arg0, int arg1);
public static native void encrypt(@Cast("char*") byte[] arg0, int arg1);
// #else /* !__DARWIN_UNIX03 */
// #endif /* __DARWIN_UNIX03 */
public static native int fchdir(int arg0);
public static native long gethostid();
public static native @Cast("pid_t") int getpgid(@Cast("pid_t") int arg0);
public static native @Cast("pid_t") int getsid(@Cast("pid_t") int arg0);

/* Removed in Issue 6 */
// #if !defined(_POSIX_C_SOURCE) || _POSIX_C_SOURCE < 200112L
public static native int getdtablesize();
public static native int getpagesize();
public static native @Cast("char*") BytePointer getpass(@Cast("const char*") BytePointer arg0);
public static native @Cast("char*") ByteBuffer getpass(String arg0);
// #endif

/* Removed in Issue 7 */
// #if !defined(_POSIX_C_SOURCE) || _POSIX_C_SOURCE < 200809L
 /* obsoleted by getcwd() */
// #endif

public static native int lchown(@Cast("const char*") BytePointer arg0, @Cast("uid_t") int arg1, @Cast("gid_t") int arg2);
public static native int lchown(String arg0, @Cast("uid_t") int arg1, @Cast("gid_t") int arg2);

public static native int lockf(int arg0, int arg1, @Cast("off_t") long arg2);

public static native int nice(int arg0);

public static native @Cast("ssize_t") long pread(int __fd, Pointer __buf, @Cast("size_t") long __nbyte, @Cast("off_t") long __offset);

public static native @Cast("ssize_t") long pwrite(int __fd, @Const Pointer __buf, @Cast("size_t") long __nbyte, @Cast("off_t") long __offset);

/* Removed in Issue 6 */
// #if !defined(_POSIX_C_SOURCE) || _POSIX_C_SOURCE < 200112L
/* Note that Issue 5 changed the argument as intprt_t,
 * but we keep it as int for binary compatability. */
// #if !defined(_POSIX_C_SOURCE)
public static native @Deprecated Pointer sbrk(int arg0);
// #endif

// #if __DARWIN_UNIX03
public static native @Cast("pid_t") int setpgrp();
// #else /* !__DARWIN_UNIX03 */
// #endif /* __DARWIN_UNIX03 */

public static native int setregid(@Cast("gid_t") int arg0, @Cast("gid_t") int arg1);

public static native int setreuid(@Cast("uid_t") int arg0, @Cast("uid_t") int arg1);
public static native void sync();
public static native int truncate(@Cast("const char*") BytePointer arg0, @Cast("off_t") long arg1);
public static native int truncate(String arg0, @Cast("off_t") long arg1);
public static native @Cast("useconds_t") int ualarm(@Cast("useconds_t") int arg0, @Cast("useconds_t") int arg1);
public static native int usleep(@Cast("useconds_t") int arg0);
public static native @Cast("pid_t") int vfork();
/* End XSI */

public static native int fsync(int arg0);

public static native int ftruncate(int arg0, @Cast("off_t") long arg1);
public static native int getlogin_r(@Cast("char*") BytePointer arg0, @Cast("size_t") long arg1);
public static native int getlogin_r(@Cast("char*") ByteBuffer arg0, @Cast("size_t") long arg1);
public static native int getlogin_r(@Cast("char*") byte[] arg0, @Cast("size_t") long arg1);
// #endif /* __DARWIN_C_LEVEL >= 199506L */



/* Additional functionality provided by:
 * POSIX.1-2001
 * ISO C99
 */

// #if __DARWIN_C_LEVEL >= 200112L
public static native int fchown(int arg0, @Cast("uid_t") int arg1, @Cast("gid_t") int arg2);
public static native int gethostname(@Cast("char*") BytePointer arg0, @Cast("size_t") long arg1);
public static native int gethostname(@Cast("char*") ByteBuffer arg0, @Cast("size_t") long arg1);
public static native int gethostname(@Cast("char*") byte[] arg0, @Cast("size_t") long arg1);
public static native @Cast("ssize_t") long readlink(@Cast("const char*") BytePointer arg0, @Cast("char*") BytePointer arg1, @Cast("size_t") long arg2);
public static native @Cast("ssize_t") long readlink(String arg0, @Cast("char*") ByteBuffer arg1, @Cast("size_t") long arg2);
public static native @Cast("ssize_t") long readlink(@Cast("const char*") BytePointer arg0, @Cast("char*") byte[] arg1, @Cast("size_t") long arg2);
public static native @Cast("ssize_t") long readlink(String arg0, @Cast("char*") BytePointer arg1, @Cast("size_t") long arg2);
public static native @Cast("ssize_t") long readlink(@Cast("const char*") BytePointer arg0, @Cast("char*") ByteBuffer arg1, @Cast("size_t") long arg2);
public static native @Cast("ssize_t") long readlink(String arg0, @Cast("char*") byte[] arg1, @Cast("size_t") long arg2);
public static native int setegid(@Cast("gid_t") int arg0);
public static native int seteuid(@Cast("uid_t") int arg0);
public static native int symlink(@Cast("const char*") BytePointer arg0, @Cast("const char*") BytePointer arg1);
public static native int symlink(String arg0, String arg1);
// #endif /* __DARWIN_C_LEVEL >= 200112L */



/* Darwin extensions */

// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
// #include <sys/select.h>

// #include <sys/_types/_dev_t.h>
// #include <sys/_types/_mode_t.h>
// #include <sys/_types/_uuid_t.h>
public static native int accessx_np(@Const accessx_descriptor arg0, @Cast("size_t") long arg1, IntPointer arg2, @Cast("uid_t") int arg3);
public static native int accessx_np(@Const accessx_descriptor arg0, @Cast("size_t") long arg1, IntBuffer arg2, @Cast("uid_t") int arg3);
public static native int accessx_np(@Const accessx_descriptor arg0, @Cast("size_t") long arg1, int[] arg2, @Cast("uid_t") int arg3);
public static native int acct(@Cast("const char*") BytePointer arg0);
public static native int acct(String arg0);
public static native int add_profil(@Cast("char*") BytePointer arg0, @Cast("size_t") long arg1, @Cast("unsigned long") long arg2, @Cast("unsigned int") int arg3);
public static native int add_profil(@Cast("char*") ByteBuffer arg0, @Cast("size_t") long arg1, @Cast("unsigned long") long arg2, @Cast("unsigned int") int arg3);
public static native int add_profil(@Cast("char*") byte[] arg0, @Cast("size_t") long arg1, @Cast("unsigned long") long arg2, @Cast("unsigned int") int arg3);
public static native void endusershell();
public static native int execvP(@Cast("const char*") BytePointer __file, @Cast("const char*") BytePointer __searchpath, @Cast("char*const*") PointerPointer __argv);
public static native int execvP(@Cast("const char*") BytePointer __file, @Cast("const char*") BytePointer __searchpath, @Cast("char*const*") @ByPtrPtr BytePointer __argv);
public static native int execvP(String __file, String __searchpath, @Cast("char*const*") @ByPtrPtr ByteBuffer __argv);
public static native int execvP(@Cast("const char*") BytePointer __file, @Cast("const char*") BytePointer __searchpath, @Cast("char*const*") @ByPtrPtr byte[] __argv);
public static native int execvP(String __file, String __searchpath, @Cast("char*const*") @ByPtrPtr BytePointer __argv);
public static native int execvP(@Cast("const char*") BytePointer __file, @Cast("const char*") BytePointer __searchpath, @Cast("char*const*") @ByPtrPtr ByteBuffer __argv);
public static native int execvP(String __file, String __searchpath, @Cast("char*const*") @ByPtrPtr byte[] __argv);
public static native @Cast("char*") BytePointer fflagstostr(@Cast("unsigned long") long arg0);
public static native int getdomainname(@Cast("char*") BytePointer arg0, int arg1);
public static native int getdomainname(@Cast("char*") ByteBuffer arg0, int arg1);
public static native int getdomainname(@Cast("char*") byte[] arg0, int arg1);
public static native int getgrouplist(@Cast("const char*") BytePointer arg0, int arg1, IntPointer arg2, IntPointer arg3);
public static native int getgrouplist(String arg0, int arg1, IntBuffer arg2, IntBuffer arg3);
public static native int getgrouplist(@Cast("const char*") BytePointer arg0, int arg1, int[] arg2, int[] arg3);
public static native int getgrouplist(String arg0, int arg1, IntPointer arg2, IntPointer arg3);
public static native int getgrouplist(@Cast("const char*") BytePointer arg0, int arg1, IntBuffer arg2, IntBuffer arg3);
public static native int getgrouplist(String arg0, int arg1, int[] arg2, int[] arg3);
// #if defined(__has_include)
// #if __has_include(<gethostuuid_private.h>)
// #include <gethostuuid_private.h>
// #else
// #include <gethostuuid.h>
// #endif
// #else
// #include <gethostuuid.h>
// #endif
public static native @Cast("mode_t") short getmode(@Const Pointer arg0, @Cast("mode_t") short arg1);
public static native int getpeereid(int arg0, @Cast("uid_t*") IntPointer arg1, @Cast("gid_t*") IntPointer arg2);
public static native int getpeereid(int arg0, @Cast("uid_t*") IntBuffer arg1, @Cast("gid_t*") IntBuffer arg2);
public static native int getpeereid(int arg0, @Cast("uid_t*") int[] arg1, @Cast("gid_t*") int[] arg2);
public static native int getsgroups_np(IntPointer arg0, @Cast("unsigned char*") BytePointer arg1);
public static native int getsgroups_np(IntBuffer arg0, @Cast("unsigned char*") ByteBuffer arg1);
public static native int getsgroups_np(int[] arg0, @Cast("unsigned char*") byte[] arg1);
public static native @Cast("char*") BytePointer getusershell();
public static native int getwgroups_np(IntPointer arg0, @Cast("unsigned char*") BytePointer arg1);
public static native int getwgroups_np(IntBuffer arg0, @Cast("unsigned char*") ByteBuffer arg1);
public static native int getwgroups_np(int[] arg0, @Cast("unsigned char*") byte[] arg1);
public static native int initgroups(@Cast("const char*") BytePointer arg0, int arg1);
public static native int initgroups(String arg0, int arg1);
public static native int issetugid();
public static native @Cast("char*") BytePointer mkdtemp(@Cast("char*") BytePointer arg0);
public static native @Cast("char*") ByteBuffer mkdtemp(@Cast("char*") ByteBuffer arg0);
public static native @Cast("char*") byte[] mkdtemp(@Cast("char*") byte[] arg0);
public static native int mkpath_np(@Cast("const char*") BytePointer path, @Cast("mode_t") short omode);
public static native int mkpath_np(String path, @Cast("mode_t") short omode); /* returns errno */
public static native int mkpathat_np(int dfd, @Cast("const char*") BytePointer path, @Cast("mode_t") short omode);
public static native int mkpathat_np(int dfd, String path, @Cast("mode_t") short omode);
public static native int mkstemps(@Cast("char*") BytePointer arg0, int arg1);
public static native int mkstemps(@Cast("char*") ByteBuffer arg0, int arg1);
public static native int mkstemps(@Cast("char*") byte[] arg0, int arg1);
public static native int mkostemp(@Cast("char*") BytePointer path, int oflags);
public static native int mkostemp(@Cast("char*") ByteBuffer path, int oflags);
public static native int mkostemp(@Cast("char*") byte[] path, int oflags);
public static native int mkostemps(@Cast("char*") BytePointer path, int slen, int oflags);
public static native int mkostemps(@Cast("char*") ByteBuffer path, int slen, int oflags);
public static native int mkostemps(@Cast("char*") byte[] path, int slen, int oflags);
/* Non-portable mkstemp that uses open_dprotected_np */

public static native @Cast("char*") BytePointer mkdtempat_np(int dfd, @Cast("char*") BytePointer path);
public static native @Cast("char*") ByteBuffer mkdtempat_np(int dfd, @Cast("char*") ByteBuffer path);
public static native @Cast("char*") byte[] mkdtempat_np(int dfd, @Cast("char*") byte[] path);
public static native int mkstempsat_np(int dfd, @Cast("char*") BytePointer path, int slen);
public static native int mkstempsat_np(int dfd, @Cast("char*") ByteBuffer path, int slen);
public static native int mkstempsat_np(int dfd, @Cast("char*") byte[] path, int slen);
public static native int mkostempsat_np(int dfd, @Cast("char*") BytePointer path, int slen, int oflags);
public static native int mkostempsat_np(int dfd, @Cast("char*") ByteBuffer path, int slen, int oflags);
public static native int mkostempsat_np(int dfd, @Cast("char*") byte[] path, int slen, int oflags);
public static native int nfssvc(int arg0, Pointer arg1);
public static native int profil(@Cast("char*") BytePointer arg0, @Cast("size_t") long arg1, @Cast("unsigned long") long arg2, @Cast("unsigned int") int arg3);
public static native int profil(@Cast("char*") ByteBuffer arg0, @Cast("size_t") long arg1, @Cast("unsigned long") long arg2, @Cast("unsigned int") int arg3);
public static native int profil(@Cast("char*") byte[] arg0, @Cast("size_t") long arg1, @Cast("unsigned long") long arg2, @Cast("unsigned int") int arg3);

public static native int pthread_setugid_np(@Cast("uid_t") int arg0, @Cast("gid_t") int arg1);
public static native int pthread_getugid_np( @Cast("uid_t*") IntPointer arg0, @Cast("gid_t*") IntPointer arg1);
public static native int pthread_getugid_np( @Cast("uid_t*") IntBuffer arg0, @Cast("gid_t*") IntBuffer arg1);
public static native int pthread_getugid_np( @Cast("uid_t*") int[] arg0, @Cast("gid_t*") int[] arg1);

public static native int reboot(int arg0);
public static native int revoke(@Cast("const char*") BytePointer arg0);
public static native int revoke(String arg0);

public static native @Deprecated int rcmd(@Cast("char**") PointerPointer arg0, int arg1, @Cast("const char*") BytePointer arg2, @Cast("const char*") BytePointer arg3, @Cast("const char*") BytePointer arg4, IntPointer arg5);
public static native @Deprecated int rcmd(@Cast("char**") @ByPtrPtr BytePointer arg0, int arg1, @Cast("const char*") BytePointer arg2, @Cast("const char*") BytePointer arg3, @Cast("const char*") BytePointer arg4, IntPointer arg5);
public static native @Deprecated int rcmd(@Cast("char**") @ByPtrPtr ByteBuffer arg0, int arg1, String arg2, String arg3, String arg4, IntBuffer arg5);
public static native @Deprecated int rcmd(@Cast("char**") @ByPtrPtr byte[] arg0, int arg1, @Cast("const char*") BytePointer arg2, @Cast("const char*") BytePointer arg3, @Cast("const char*") BytePointer arg4, int[] arg5);
public static native @Deprecated int rcmd(@Cast("char**") @ByPtrPtr BytePointer arg0, int arg1, String arg2, String arg3, String arg4, IntPointer arg5);
public static native @Deprecated int rcmd(@Cast("char**") @ByPtrPtr ByteBuffer arg0, int arg1, @Cast("const char*") BytePointer arg2, @Cast("const char*") BytePointer arg3, @Cast("const char*") BytePointer arg4, IntBuffer arg5);
public static native @Deprecated int rcmd(@Cast("char**") @ByPtrPtr byte[] arg0, int arg1, String arg2, String arg3, String arg4, int[] arg5);
public static native @Deprecated int rcmd_af(@Cast("char**") PointerPointer arg0, int arg1, @Cast("const char*") BytePointer arg2, @Cast("const char*") BytePointer arg3, @Cast("const char*") BytePointer arg4, IntPointer arg5,
		int arg6);
public static native @Deprecated int rcmd_af(@Cast("char**") @ByPtrPtr BytePointer arg0, int arg1, @Cast("const char*") BytePointer arg2, @Cast("const char*") BytePointer arg3, @Cast("const char*") BytePointer arg4, IntPointer arg5,
		int arg6);
public static native @Deprecated int rcmd_af(@Cast("char**") @ByPtrPtr ByteBuffer arg0, int arg1, String arg2, String arg3, String arg4, IntBuffer arg5,
		int arg6);
public static native @Deprecated int rcmd_af(@Cast("char**") @ByPtrPtr byte[] arg0, int arg1, @Cast("const char*") BytePointer arg2, @Cast("const char*") BytePointer arg3, @Cast("const char*") BytePointer arg4, int[] arg5,
		int arg6);
public static native @Deprecated int rcmd_af(@Cast("char**") @ByPtrPtr BytePointer arg0, int arg1, String arg2, String arg3, String arg4, IntPointer arg5,
		int arg6);
public static native @Deprecated int rcmd_af(@Cast("char**") @ByPtrPtr ByteBuffer arg0, int arg1, @Cast("const char*") BytePointer arg2, @Cast("const char*") BytePointer arg3, @Cast("const char*") BytePointer arg4, IntBuffer arg5,
		int arg6);
public static native @Deprecated int rcmd_af(@Cast("char**") @ByPtrPtr byte[] arg0, int arg1, String arg2, String arg3, String arg4, int[] arg5,
		int arg6);
public static native @Deprecated int rresvport(IntPointer arg0);
public static native @Deprecated int rresvport(IntBuffer arg0);
public static native @Deprecated int rresvport(int[] arg0);
public static native @Deprecated int rresvport_af(IntPointer arg0, int arg1);
public static native @Deprecated int rresvport_af(IntBuffer arg0, int arg1);
public static native @Deprecated int rresvport_af(int[] arg0, int arg1);
public static native @Deprecated int iruserok(@Cast("unsigned long") long arg0, int arg1, @Cast("const char*") BytePointer arg2, @Cast("const char*") BytePointer arg3);
public static native @Deprecated int iruserok(@Cast("unsigned long") long arg0, int arg1, String arg2, String arg3);
public static native @Deprecated int iruserok_sa(@Const Pointer arg0, int arg1, int arg2, @Cast("const char*") BytePointer arg3, @Cast("const char*") BytePointer arg4);
public static native @Deprecated int iruserok_sa(@Const Pointer arg0, int arg1, int arg2, String arg3, String arg4);
public static native @Deprecated int ruserok(@Cast("const char*") BytePointer arg0, int arg1, @Cast("const char*") BytePointer arg2, @Cast("const char*") BytePointer arg3);
public static native @Deprecated int ruserok(String arg0, int arg1, String arg2, String arg3);

public static native int setdomainname(@Cast("const char*") BytePointer arg0, int arg1);
public static native int setdomainname(String arg0, int arg1);
public static native int setgroups(int arg0, @Cast("const gid_t*") IntPointer arg1);
public static native int setgroups(int arg0, @Cast("const gid_t*") IntBuffer arg1);
public static native int setgroups(int arg0, @Cast("const gid_t*") int[] arg1);
public static native void sethostid(long arg0);
public static native int sethostname(@Cast("const char*") BytePointer arg0, int arg1);
public static native int sethostname(String arg0, int arg1);
// #if __DARWIN_UNIX03
// #else /* !__DARWIN_UNIX03 */
// #endif /* __DARWIN_UNIX03 */
public static native int setlogin(@Cast("const char*") BytePointer arg0);
public static native int setlogin(String arg0);
public static native Pointer setmode(@Cast("const char*") BytePointer arg0);
public static native Pointer setmode(String arg0);
public static native int setrgid(@Cast("gid_t") int arg0);
public static native int setruid(@Cast("uid_t") int arg0);
public static native int setsgroups_np(int arg0, @Cast("unsigned char*") BytePointer arg1);
public static native int setsgroups_np(int arg0, @Cast("unsigned char*") ByteBuffer arg1);
public static native int setsgroups_np(int arg0, @Cast("unsigned char*") byte[] arg1);
public static native void setusershell();
public static native int setwgroups_np(int arg0, @Cast("unsigned char*") BytePointer arg1);
public static native int setwgroups_np(int arg0, @Cast("unsigned char*") ByteBuffer arg1);
public static native int setwgroups_np(int arg0, @Cast("unsigned char*") byte[] arg1);
public static native int strtofflags(@Cast("char**") PointerPointer arg0, @Cast("unsigned long*") CLongPointer arg1, @Cast("unsigned long*") CLongPointer arg2);
public static native int strtofflags(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("unsigned long*") CLongPointer arg1, @Cast("unsigned long*") CLongPointer arg2);
public static native int strtofflags(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("unsigned long*") CLongPointer arg1, @Cast("unsigned long*") CLongPointer arg2);
public static native int strtofflags(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("unsigned long*") CLongPointer arg1, @Cast("unsigned long*") CLongPointer arg2);
public static native int swapon(@Cast("const char*") BytePointer arg0);
public static native int swapon(String arg0);
public static native int ttyslot();
public static native int undelete(@Cast("const char*") BytePointer arg0);
public static native int undelete(String arg0);
public static native int unwhiteout(@Cast("const char*") BytePointer arg0);
public static native int unwhiteout(String arg0);
public static native Pointer valloc(@Cast("size_t") long arg0);			

public static native int syscall(int arg0);			/* getsubopt(3) external variable */

/*  HFS & HFS Plus semantics system calls go here */
// #ifdef __LP64__
public static native int fgetattrlist(int arg0,Pointer arg1,Pointer arg2,@Cast("size_t") long arg3,@Cast("unsigned int") int arg4);
public static native int fsetattrlist(int arg0,Pointer arg1,Pointer arg2,@Cast("size_t") long arg3,@Cast("unsigned int") int arg4);
public static native int getattrlist(@Cast("const char*") BytePointer arg0,Pointer arg1,Pointer arg2,@Cast("size_t") long arg3,@Cast("unsigned int") int arg4);
public static native int getattrlist(String arg0,Pointer arg1,Pointer arg2,@Cast("size_t") long arg3,@Cast("unsigned int") int arg4);
public static native int setattrlist(@Cast("const char*") BytePointer arg0,Pointer arg1,Pointer arg2,@Cast("size_t") long arg3,@Cast("unsigned int") int arg4);
public static native int setattrlist(String arg0,Pointer arg1,Pointer arg2,@Cast("size_t") long arg3,@Cast("unsigned int") int arg4);
public static native int exchangedata(@Cast("const char*") BytePointer arg0,@Cast("const char*") BytePointer arg1,@Cast("unsigned int") int arg2);
public static native int exchangedata(String arg0,String arg1,@Cast("unsigned int") int arg2);
public static native int getdirentriesattr(int arg0,Pointer arg1,Pointer arg2,@Cast("size_t") long arg3,@Cast("unsigned int*") IntPointer arg4,@Cast("unsigned int*") IntPointer arg5,@Cast("unsigned int*") IntPointer arg6,@Cast("unsigned int") int arg7);
public static native int getdirentriesattr(int arg0,Pointer arg1,Pointer arg2,@Cast("size_t") long arg3,@Cast("unsigned int*") IntBuffer arg4,@Cast("unsigned int*") IntBuffer arg5,@Cast("unsigned int*") IntBuffer arg6,@Cast("unsigned int") int arg7);
public static native int getdirentriesattr(int arg0,Pointer arg1,Pointer arg2,@Cast("size_t") long arg3,@Cast("unsigned int*") int[] arg4,@Cast("unsigned int*") int[] arg5,@Cast("unsigned int*") int[] arg6,@Cast("unsigned int") int arg7);
// Targeting ../macosx/fssearchblock.java


// Targeting ../macosx/searchstate.java



public static native int searchfs(@Cast("const char*") BytePointer arg0, fssearchblock arg1, @Cast("unsigned long*") CLongPointer arg2, @Cast("unsigned int") int arg3, @Cast("unsigned int") int arg4, searchstate arg5);
public static native int searchfs(String arg0, fssearchblock arg1, @Cast("unsigned long*") CLongPointer arg2, @Cast("unsigned int") int arg3, @Cast("unsigned int") int arg4, searchstate arg5);
public static native int fsctl(@Cast("const char*") BytePointer arg0,@Cast("unsigned long") long arg1,Pointer arg2,@Cast("unsigned int") int arg3);
public static native int fsctl(String arg0,@Cast("unsigned long") long arg1,Pointer arg2,@Cast("unsigned int") int arg3);
public static native int ffsctl(int arg0,@Cast("unsigned long") long arg1,Pointer arg2,@Cast("unsigned int") int arg3);

public static final int SYNC_VOLUME_FULLSYNC =	0x01;	/* Flush data and metadata to platter, not just to disk cache */
public static final int SYNC_VOLUME_WAIT =	0x02;	/* Wait for sync to complete */

public static native int fsync_volume_np(int arg0, int arg1);
public static native int sync_volume_np(@Cast("const char*") BytePointer arg0, int arg1);
public static native int sync_volume_np(String arg0, int arg1);

public static native int optreset(); public static native void optreset(int setter);

// #endif /* __DARWIN_C_LEVEL >= __DARWIN_C_FULL */

// #endif /* _UNISTD_H_ */


// Parsed from sys/poll.h

/*
 * Copyright (c) 2000-2004 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
/*-
 * Copyright (c) 1997 Peter Wemm <peter@freebsd.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

// #ifndef _SYS_POLL_H_
// #define _SYS_POLL_H_

/*
 * This file is intended to be compatible with the traditional poll.h.
 */

/*
 * Requestable events.  If poll(2) finds any of these set, they are
 * copied to revents on return.
 */
public static final int POLLIN =          0x0001;          /* any readable data available */
public static final int POLLPRI =         0x0002;          /* OOB/Urgent readable data */
public static final int POLLOUT =         0x0004;          /* file descriptor is writeable */
public static final int POLLRDNORM =      0x0040;          /* non-OOB/URG data available */
public static final int POLLWRNORM =      POLLOUT;         /* no write type differentiation */
public static final int POLLRDBAND =      0x0080;          /* OOB/Urgent readable data */
public static final int POLLWRBAND =      0x0100;          /* OOB/Urgent data can be written */

/*
 * FreeBSD extensions: polling on a regular file might return one
 * of these events (currently only supported on local filesystems).
 */
public static final int POLLEXTEND =      0x0200;          /* file may have been extended */
public static final int POLLATTRIB =      0x0400;          /* file attributes may have changed */
public static final int POLLNLINK =       0x0800;          /* (un)link/rename may have happened */
public static final int POLLWRITE =       0x1000;          /* file's contents may have changed */

/*
 * These events are set if they occur regardless of whether they were
 * requested.
 */
public static final int POLLERR =         0x0008;          /* some poll error occurred */
public static final int POLLHUP =         0x0010;          /* file descriptor was "hung up" */
public static final int POLLNVAL =        0x0020;          /* requested events "invalid" */

public static final int POLLSTANDARD =    (POLLIN|POLLPRI|POLLOUT|POLLRDNORM|POLLRDBAND|
	                 POLLWRBAND|POLLERR|POLLHUP|POLLNVAL);
// Targeting ../macosx/pollfd.java




// #include <sys/cdefs.h>

/*
 * This is defined here (instead of <poll.h>) because this is where
 * traditional SVR4 code will look to find it.
 */
public static native int poll(pollfd arg0, @Cast("nfds_t") int arg1, int arg2);

// #endif /* !_SYS_POLL_H_ */


// Parsed from sys/reboot.h

/*
 * Copyright (c) 2000-2006 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
/* Copyright (c) 1995 NeXT Computer, Inc. All Rights Reserved */
/*
 * Copyright (c) 1982, 1986, 1988, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)reboot.h	8.3 (Berkeley) 12/13/94
 */

// #ifndef _SYS_REBOOT_H_
// #define _SYS_REBOOT_H_

// #include <sys/appleapiopts.h>
// #include <sys/cdefs.h>
// #include <stdint.h>

/*
 * Arguments to reboot system call.
 */

// #ifdef __APPLE_API_PRIVATE
public static final int RB_AUTOBOOT =     0;       /* flags for system auto-booting itself */

public static final int RB_ASKNAME =      0x01;    /* ask for file name to reboot from */
public static final int RB_SINGLE =       0x02;    /* reboot to single user only */
public static final int RB_NOSYNC =       0x04;    /* dont sync before reboot */
public static final int RB_HALT =         0x08;    /* don't reboot, just halt */
public static final int RB_INITNAME =     0x10;    /* name given for /etc/init */
public static final int RB_DFLTROOT =     0x20;    /* use compiled-in rootdev */
public static final int RB_ALTBOOT =      0x40;    /* use /boot.old vs /boot */
public static final int RB_UNIPROC =      0x80;    /* don't start slaves */
public static final int RB_SAFEBOOT =     0x100;   /* booting safe */
public static final int RB_UPSDELAY = 0x200;   /* Delays restart by 5 minutes */
public static final int RB_QUICK =        0x400;   /* quick and ungraceful reboot with file system caches flushed*/
public static final int RB_PANIC =        0x800;   /* panic the kernel */
public static final int RB_PANIC_ZPRINT = 0x1000;   /* add zprint info to panic string */

/* userspace reboot control */
public static native int usrctl(@Cast("uint32_t") int flags);
/* The normal reboot syscall. */
/* Used with RB_PANIC to panic the kernel from userspace with a message.
 * Requires an entitlement on Release. */
public static native int reboot_np(int howto, @Cast("const char*") BytePointer message);
public static native int reboot_np(int howto, String message);
// #endif /* __APPLE_API_PRIVATE */

// #ifdef __APPLE_API_OBSOLETE
/*
 * Constants for converting boot-style device number to type,
 * adaptor (uba, mba, etc), unit number and partition number.
 * Type (== major device number) is in the low byte
 * for backward compatibility.  Except for that of the "magic
 * number", each mask applies to the shifted value.
 * Format:
 *	 (4) (4) (4) (4)  (8)     (8)
 *	--------------------------------
 *	|MA | AD| CT| UN| PART  | TYPE |
 *	--------------------------------
 */
public static final int B_ADAPTORSHIFT =  24;
public static final int B_ADAPTORMASK =   0x0f;
// #define B_ADAPTOR(val)          (((val) >> B_ADAPTORSHIFT) & B_ADAPTORMASK)
public static final int B_CONTROLLERSHIFT =       20;
public static final int B_CONTROLLERMASK =        0xf;
// #define B_CONTROLLER(val)       (((val)>>B_CONTROLLERSHIFT) & B_CONTROLLERMASK)
public static final int B_UNITSHIFT =     16;
public static final int B_UNITMASK =      0xff;
// #define B_UNIT(val)             (((val) >> B_UNITSHIFT) & B_UNITMASK)
public static final int B_PARTITIONSHIFT = 8;
public static final int B_PARTITIONMASK = 0xff;
// #define B_PARTITION(val)        (((val) >> B_PARTITIONSHIFT) & B_PARTITIONMASK)
public static final int B_TYPESHIFT =     0;
public static final int B_TYPEMASK =      0xff;
// #define B_TYPE(val)             (((val) >> B_TYPESHIFT) & B_TYPEMASK)
public static final int B_MAGICMASK =     0xf0000000;
public static final int B_DEVMAGIC =      0xa0000000;

// #define MAKEBOOTDEV(type, adaptor, controller, unit, partition)
// 	(((type) << B_TYPESHIFT) | ((adaptor) << B_ADAPTORSHIFT) |
// 	((controller) << B_CONTROLLERSHIFT) | ((unit) << B_UNITSHIFT) |
// 	((partition) << B_PARTITIONSHIFT) | B_DEVMAGIC)

// #endif /* __APPLE_API_OBSOLETE */



// #endif  /* _SYS_REBOOT_H_ */


// Parsed from sys/resource.h

/*
 * Copyright (c) 2000-2018 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
/* Copyright (c) 1995 NeXT Computer, Inc. All Rights Reserved */
/*
 * Copyright (c) 1982, 1986, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)resource.h	8.2 (Berkeley) 1/4/94
 */

// #ifndef _SYS_RESOURCE_H_
// #define _SYS_RESOURCE_H_

// #include <sys/appleapiopts.h>
// #include <sys/cdefs.h>
// #include <sys/_types.h>

// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
// #include <stdint.h>
// #endif /* __DARWIN_C_LEVEL >= __DARWIN_C_FULL */

// #include <Availability.h>

/* [XSI] The timeval structure shall be defined as described in
 * <sys/time.h>
 */
// #include <sys/_types/_timeval.h>

/* The id_t type shall be defined as described in <sys/types.h> */
// #include <sys/_types/_id_t.h>


/*
 * Resource limit type (low 63 bits, excluding the sign bit)
 */


/*****
 * PRIORITY
 */

/*
 * Possible values of the first parameter to getpriority()/setpriority(),
 * used to indicate the type of the second parameter.
 */
public static final int PRIO_PROCESS =    0;               /* Second argument is a PID */
public static final int PRIO_PGRP =       1;               /* Second argument is a GID */
public static final int PRIO_USER =       2;               /* Second argument is a UID */

// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static final int PRIO_DARWIN_THREAD =      3;               /* Second argument is always 0 (current thread) */
public static final int PRIO_DARWIN_PROCESS =     4;               /* Second argument is a PID */


/*
 * Range limitations for the value of the third parameter to setpriority().
 */
public static final int PRIO_MIN =        -20;
public static final int PRIO_MAX =        20;

/*
 * use PRIO_DARWIN_BG to set the current thread into "background" state
 * which lowers CPU, disk IO, and networking priorites until thread terminates
 * or "background" state is revoked
 */
public static final int PRIO_DARWIN_BG = 0x1000;

/*
 * use PRIO_DARWIN_NONUI to restrict a process's ability to make calls to
 * the GPU. (deprecated)
 */
public static final int PRIO_DARWIN_NONUI = 0x1001;

// #endif  /* __DARWIN_C_LEVEL >= __DARWIN_C_FULL */



/*****
 * RESOURCE USAGE
 */

/*
 * Possible values of the first parameter to getrusage(), used to indicate
 * the scope of the information to be returned.
 */
public static final int RUSAGE_SELF =     0;               /* Current process information */
public static final int RUSAGE_CHILDREN = -1;
// Targeting ../macosx/rusage.java



// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
/*
 * Flavors for proc_pid_rusage().
 */
public static final int RUSAGE_INFO_V0 =  0;
public static final int RUSAGE_INFO_V1 =  1;
public static final int RUSAGE_INFO_V2 =  2;
public static final int RUSAGE_INFO_V3 =  3;
public static final int RUSAGE_INFO_V4 =  4;
public static final int RUSAGE_INFO_V5 =  5;
public static final int RUSAGE_INFO_CURRENT =     RUSAGE_INFO_V5;

/*
 * Flags for RUSAGE_INFO_V5
 */
public static final int RU_PROC_RUNS_RESLIDE =    0x00000001;
// Targeting ../macosx/rusage_info_t.java


// Targeting ../macosx/rusage_info_v0.java


// Targeting ../macosx/rusage_info_v1.java


// Targeting ../macosx/rusage_info_v2.java


// Targeting ../macosx/rusage_info_v3.java


// Targeting ../macosx/rusage_info_v4.java


// Targeting ../macosx/rusage_info_v5.java


// Targeting ../macosx/rusage_info_current.java



// #endif /* __DARWIN_C_LEVEL >= __DARWIN_C_FULL */



/*****
 * RESOURCE LIMITS
 */

/*
 * Symbolic constants for resource limits; since all limits are representable
 * as a type rlim_t, we are permitted to define RLIM_SAVED_* in terms of
 * RLIM_INFINITY.
 */
public static native @MemberGetter long RLIM_INFINITY();
public static final long RLIM_INFINITY = RLIM_INFINITY();     /* no limit */
public static native @MemberGetter long RLIM_SAVED_MAX();
public static final long RLIM_SAVED_MAX = RLIM_SAVED_MAX();   /* Unrepresentable hard limit */
public static native @MemberGetter long RLIM_SAVED_CUR();
public static final long RLIM_SAVED_CUR = RLIM_SAVED_CUR();   /* Unrepresentable soft limit */

/*
 * Possible values of the first parameter to getrlimit()/setrlimit(), to
 * indicate for which resource the operation is being performed.
 */
public static final int RLIMIT_CPU =      0;               /* cpu time per process */
public static final int RLIMIT_FSIZE =    1;               /* file size */
public static final int RLIMIT_DATA =     2;               /* data segment size */
public static final int RLIMIT_STACK =    3;               /* stack size */
public static final int RLIMIT_CORE =     4;               /* core file size */
public static final int RLIMIT_AS =       5;               /* address space (resident set size) */
// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static final int RLIMIT_RSS =      RLIMIT_AS;       /* source compatibility alias */
public static final int RLIMIT_MEMLOCK =  6;               /* locked-in-memory address space */
public static final int RLIMIT_NPROC =    7;               /* number of processes */
// #endif  /* __DARWIN_C_LEVEL >= __DARWIN_C_FULL */
public static final int RLIMIT_NOFILE =   8;               /* number of open files */
// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static final int RLIM_NLIMITS =    9;               /* total number of resource limits */
// #endif  /* __DARWIN_C_LEVEL >= __DARWIN_C_FULL */
public static final int _RLIMIT_POSIX_FLAG =      0x1000;
// Targeting ../macosx/rlimit.java



// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
/*
 * proc_rlimit_control()
 *
 * Resource limit flavors
 */
public static final int RLIMIT_WAKEUPS_MONITOR =          0x1; /* Configure the wakeups monitor. */
public static final int RLIMIT_CPU_USAGE_MONITOR =        0x2; /* Configure the CPU usage monitor. */
public static final int RLIMIT_THREAD_CPULIMITS =         0x3; /* Configure a blocking, per-thread, CPU limits. */
public static final int RLIMIT_FOOTPRINT_INTERVAL =       0x4; /* Configure memory footprint interval tracking */

/*
 * Flags for wakeups monitor control.
 */
public static final int WAKEMON_ENABLE =                  0x01;
public static final int WAKEMON_DISABLE =                 0x02;
public static final int WAKEMON_GET_PARAMS =              0x04;
public static final int WAKEMON_SET_DEFAULTS =            0x08;
public static final int WAKEMON_MAKE_FATAL =              0x10; /* Configure the task so that violations are fatal. */

/*
 * Flags for CPU usage monitor control.
 */
public static final int CPUMON_MAKE_FATAL =               0x1000;

/*
 * Flags for memory footprint interval tracking.
 */
public static final int FOOTPRINT_INTERVAL_RESET =        0x1;
// Targeting ../macosx/proc_rlimit_control_wakeupmon.java





/* I/O type */
public static final int IOPOL_TYPE_DISK = 0;
public static final int IOPOL_TYPE_VFS_ATIME_UPDATES = 2;
public static final int IOPOL_TYPE_VFS_MATERIALIZE_DATALESS_FILES = 3;
public static final int IOPOL_TYPE_VFS_STATFS_NO_DATA_VOLUME = 4;
public static final int IOPOL_TYPE_VFS_TRIGGER_RESOLVE = 5;
public static final int IOPOL_TYPE_VFS_IGNORE_CONTENT_PROTECTION = 6;

/* scope */
public static final int IOPOL_SCOPE_PROCESS =   0;
public static final int IOPOL_SCOPE_THREAD =    1;
public static final int IOPOL_SCOPE_DARWIN_BG = 2;

/* I/O Priority */
public static final int IOPOL_DEFAULT =           0;
public static final int IOPOL_IMPORTANT =         1;
public static final int IOPOL_PASSIVE =           2;
public static final int IOPOL_THROTTLE =          3;
public static final int IOPOL_UTILITY =           4;
public static final int IOPOL_STANDARD =          5;

/* compatibility with older names */
public static final int IOPOL_APPLICATION =       IOPOL_STANDARD;
public static final int IOPOL_NORMAL =            IOPOL_IMPORTANT;


public static final int IOPOL_ATIME_UPDATES_DEFAULT =     0;
public static final int IOPOL_ATIME_UPDATES_OFF =         1;

public static final int IOPOL_MATERIALIZE_DATALESS_FILES_DEFAULT = 0;
public static final int IOPOL_MATERIALIZE_DATALESS_FILES_OFF =     1;
public static final int IOPOL_MATERIALIZE_DATALESS_FILES_ON =      2;

public static final int IOPOL_VFS_STATFS_NO_DATA_VOLUME_DEFAULT = 0;
public static final int IOPOL_VFS_STATFS_FORCE_NO_DATA_VOLUME =   1;

public static final int IOPOL_VFS_TRIGGER_RESOLVE_DEFAULT = 0;
public static final int IOPOL_VFS_TRIGGER_RESOLVE_OFF =     1;

public static final int IOPOL_VFS_CONTENT_PROTECTION_DEFAULT = 0;
public static final int IOPOL_VFS_CONTENT_PROTECTION_IGNORE =  1;

// #endif /* __DARWIN_C_LEVEL >= __DARWIN_C_FULL */


public static native int getpriority(int arg0, @Cast("id_t") int arg1);
// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static native int getiopolicy_np(int arg0, int arg1);
// #endif /* __DARWIN_C_LEVEL >= __DARWIN_C_FULL */
public static native int getrlimit(int arg0, rlimit arg1);
public static native int getrusage(int arg0, rusage arg1);
public static native int setpriority(int arg0, @Cast("id_t") int arg1, int arg2);
// #if __DARWIN_C_LEVEL >= __DARWIN_C_FULL
public static native int setiopolicy_np(int arg0, int arg1, int arg2);
// #endif /* __DARWIN_C_LEVEL >= __DARWIN_C_FULL */
public static native int setrlimit(int arg0, @Const rlimit arg1);
// #endif  /* !_SYS_RESOURCE_H_ */


// Parsed from sys/sysctl.h

/*
 * Copyright (c) 2000-2019 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
/* Copyright (c) 1995 NeXT Computer, Inc. All Rights Reserved */
/*
 * Copyright (c) 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Mike Karels at Berkeley Software Design, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)sysctl.h	8.1 (Berkeley) 6/2/93
 */
/*
 * NOTICE: This file was modified by SPARTA, Inc. in 2005 to introduce
 * support for mandatory and extensible security protections.  This notice
 * is included in support of clause 2.2 (b) of the Apple Public License,
 * Version 2.0.
 */

// #ifndef _SYS_SYSCTL_H_
// #define _SYS_SYSCTL_H_

/*
 * These are for the eproc structure defined below.
 */
// #include <sys/cdefs.h>

// #include <sys/appleapiopts.h>
// #include <sys/time.h>
// #include <sys/ucred.h>
// #include <sys/proc.h>
// #include <sys/vm.h>


/*
 * Definitions for sysctl call.  The sysctl call uses a hierarchical name
 * for objects that can be examined or modified.  The name is expressed as
 * a sequence of integers.  Like a file path name, the meaning of each
 * component depends on its place in the hierarchy.  The top-level and kern
 * identifiers are defined here, and other identifiers are defined in the
 * respective subsystem header files.
 */

public static final int CTL_MAXNAME =     12;
// Targeting ../macosx/ctlname.java



public static final int CTLTYPE =         0xf;     /* Mask for the type */
public static final int CTLTYPE_NODE =    1;       /* name is a node */
public static final int CTLTYPE_INT =     2;       /* name describes an integer */
public static final int CTLTYPE_STRING =  3;       /* name describes a string */
public static final int CTLTYPE_QUAD =    4;       /* name describes a 64-bit number */
public static final int CTLTYPE_OPAQUE =  5;       /* name describes a structure */
public static final int CTLTYPE_STRUCT =  CTLTYPE_OPAQUE;  /* name describes a structure */

public static final int CTLFLAG_RD =      0x80000000;      /* Allow reads of variable */
public static final int CTLFLAG_WR =      0x40000000;      /* Allow writes to the variable */
public static final int CTLFLAG_RW =      (CTLFLAG_RD|CTLFLAG_WR);
public static final int CTLFLAG_NOLOCK =  0x20000000;      /* XXX Don't Lock */
public static final int CTLFLAG_ANYBODY = 0x10000000;      /* All users can set this var */
public static final int CTLFLAG_SECURE =  0x08000000;      /* Permit set only if securelevel<=0 */
public static final int CTLFLAG_MASKED =  0x04000000;      /* deprecated variable, do not display */
public static final int CTLFLAG_NOAUTO =  0x02000000;      /* do not auto-register */
public static final int CTLFLAG_KERN =    0x01000000;      /* valid inside the kernel */
public static final int CTLFLAG_LOCKED =  0x00800000;      /* node will handle locking itself */
public static final int CTLFLAG_OID2 =    0x00400000;      /* struct sysctl_oid has version info */

/*
 * USE THIS instead of a hardwired number from the categories below
 * to get dynamically assigned sysctl entries using the linker-set
 * technology. This is the way nearly all new sysctl variables should
 * be implemented.
 *
 * e.g. SYSCTL_INT(_parent, OID_AUTO, name, CTLFLAG_RW, &variable, 0, "");
 *
 * Note that linker set technology will automatically register all nodes
 * declared like this on kernel initialization, UNLESS they are defined
 * in I/O-Kit. In this case, you have to call sysctl_register_oid()
 * manually - just like in a KEXT.
 */
public static final int OID_AUTO =        (-1);
public static final int OID_AUTO_START = 100; /* conventional */


// #define SYSCTL_DEF_ENABLED

// #ifdef SYSCTL_DEF_ENABLED



// #endif /* SYSCTL_DEF_ENABLED */


// #endif  /* !_SYS_SYSCTL_H_ */


// Parsed from sys/wait.h

/*
 * Copyright (c) 2000 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
/* Copyright (c) 1995 NeXT Computer, Inc. All Rights Reserved */
/*
 * Copyright (c) 1982, 1986, 1989, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)wait.h	8.2 (Berkeley) 7/10/94
 */

// #ifndef _SYS_WAIT_H_
// #define _SYS_WAIT_H_

// #include <sys/cdefs.h>
// #include <sys/_types.h>

/*
 * This file holds definitions relevent to the wait4 system call
 * and the alternate interfaces that use it (wait, wait3, waitpid).
 */

/*
 * [XSI] The type idtype_t shall be defined as an enumeration type whose
 * possible values shall include at least P_ALL, P_PID, and P_PGID.
 */
/** enum idtype_t */
public static final int
	P_ALL = 0,
	P_PID = 1,
	P_PGID = 2;

/*
 * [XSI] The id_t and pid_t types shall be defined as described
 * in <sys/types.h>
 */
// #include <sys/_types/_pid_t.h>
// #include <sys/_types/_id_t.h>

/*
 * [XSI] The siginfo_t type shall be defined as described in <signal.h>
 * [XSI] The rusage structure shall be defined as described in <sys/resource.h>
 * [XSI] Inclusion of the <sys/wait.h> header may also make visible all
 * symbols from <signal.h> and <sys/resource.h>
 *
 * NOTE:	This requirement is currently being satisfied by the direct
 *		inclusion of <sys/signal.h> and <sys/resource.h>, below.
 *
 *		Software should not depend on the exposure of anything other
 *		than the types siginfo_t and struct rusage as a result of
 *		this inclusion.  If you depend on any types or manifest
 *		values othe than siginfo_t and struct rusage from either of
 *		those files, you should explicitly include them yourself, as
 *		well, or in future releases your stware may not compile
 *		without modification.
 */
// #include <sys/signal.h>         /* [XSI] for siginfo_t */
// #include <sys/resource.h>       /* [XSI] for struct rusage */

/*
 * Option bits for the third argument of wait4.  WNOHANG causes the
 * wait to not hang if there are no stopped or terminated processes, rather
 * returning an error indication in this case (pid==0).  WUNTRACED
 * indicates that the caller should receive status about untraced children
 * which stop due to signals.  If children are stopped and a wait without
 * this option is done, it is as though they were still running... nothing
 * about them is returned.
 */
public static final int WNOHANG =         0x00000001;  /* [XSI] no hang in wait/no child to reap */
public static final int WUNTRACED =       0x00000002;  /* [XSI] notify on stop, untraced child */

/*
 * Macros to test the exit status returned by wait
 * and extract the relevant values.
 */
// #if defined(_POSIX_C_SOURCE) && !defined(_DARWIN_C_SOURCE)
// #define _W_INT(i)       (i)
// #else
// #define _W_INT(w)       (*(int *)&(w))  /* convert union wait to int */
public static native @MemberGetter int WCOREFLAG();
public static final int WCOREFLAG = WCOREFLAG();
// #endif /* (_POSIX_C_SOURCE && !_DARWIN_C_SOURCE) */

/* These macros are permited, as they are in the implementation namespace */
// #define _WSTATUS(x)     (_W_INT(x) & 0177)
public static final int _WSTOPPED =       0177;            /* _WSTATUS if process is stopped */

/*
 * [XSI] The <sys/wait.h> header shall define the following macros for
 * analysis of process status values
 */
// #if __DARWIN_UNIX03
// #define WEXITSTATUS(x)  ((_W_INT(x) >> 8) & 0x000000ff)
// #else /* !__DARWIN_UNIX03 */
// #endif /* !__DARWIN_UNIX03 */
/* 0x13 == SIGCONT */
// #define WSTOPSIG(x)     (_W_INT(x) >> 8)
// #define WIFCONTINUED(x) (_WSTATUS(x) == _WSTOPPED && WSTOPSIG(x) == 0x13)
// #define WIFSTOPPED(x)   (_WSTATUS(x) == _WSTOPPED && WSTOPSIG(x) != 0x13)
// #define WIFEXITED(x)    (_WSTATUS(x) == 0)
// #define WIFSIGNALED(x)  (_WSTATUS(x) != _WSTOPPED && _WSTATUS(x) != 0)
// #define WTERMSIG(x)     (_WSTATUS(x))
// #if (!defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE))
// #define WCOREDUMP(x)    (_W_INT(x) & WCOREFLAG)

// #define W_EXITCODE(ret, sig)    ((ret) << 8 | (sig))
// #define W_STOPCODE(sig)         ((sig) << 8 | _WSTOPPED)
// #endif /* (!defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)) */

/*
 * [XSI] The following symbolic constants shall be defined as possible
 * values for the fourth argument to waitid().
 */
/* WNOHANG already defined for wait4() */
/* WUNTRACED defined for wait4() but not for waitid() */
public static final int WEXITED =         0x00000004;  /* [XSI] Processes which have exitted */
// #if __DARWIN_UNIX03
/* waitid() parameter */
public static final int WSTOPPED =        0x00000008;  /* [XSI] Any child stopped by signal */
// #endif
public static final int WCONTINUED =      0x00000010;  /* [XSI] Any child stopped then continued */
public static final int WNOWAIT =         0x00000020;  /* [XSI] Leave process returned waitable */


// #if (!defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE))
/* POSIX extensions and 4.2/4.3 compatability: */

/*
 * Tokens for special values of the "pid" parameter to wait4.
 */
public static final int WAIT_ANY =        (-1);    /* any process */
public static final int WAIT_MYPGRP =     0;       /* any process in my process group */

// #include <machine/endian.h>
// Targeting ../macosx/wait.java



// #endif /* (!defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)) */

// #if !(__DARWIN_UNIX03 - 0)
/*
 * Stopped state value; cannot use waitid() parameter of the same name
 * in the same scope
 */
// #endif /* !__DARWIN_UNIX03 */

public static native @Cast("pid_t") int wait(IntPointer arg0);
public static native @Cast("pid_t") int wait(IntBuffer arg0);
public static native @Cast("pid_t") int wait(int[] arg0);
public static native @Cast("pid_t") int waitpid(@Cast("pid_t") int arg0, IntPointer arg1, int arg2);
public static native @Cast("pid_t") int waitpid(@Cast("pid_t") int arg0, IntBuffer arg1, int arg2);
public static native @Cast("pid_t") int waitpid(@Cast("pid_t") int arg0, int[] arg1, int arg2);
// #ifndef _ANSI_SOURCE
public static native int waitid(@Cast("idtype_t") int arg0, @Cast("id_t") int arg1, siginfo_t arg2, int arg3);
// #endif /* !_ANSI_SOURCE */
// #if  (!defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE))
public static native @Cast("pid_t") int wait3(IntPointer arg0, int arg1, rusage arg2);
public static native @Cast("pid_t") int wait3(IntBuffer arg0, int arg1, rusage arg2);
public static native @Cast("pid_t") int wait3(int[] arg0, int arg1, rusage arg2);
public static native @Cast("pid_t") int wait4(@Cast("pid_t") int arg0, IntPointer arg1, int arg2, rusage arg3);
public static native @Cast("pid_t") int wait4(@Cast("pid_t") int arg0, IntBuffer arg1, int arg2, rusage arg3);
public static native @Cast("pid_t") int wait4(@Cast("pid_t") int arg0, int[] arg1, int arg2, rusage arg3);
// #endif /* (!defined(_POSIX_C_SOURCE) || defined(_DARWIN_C_SOURCE)) */
// #endif /* !_SYS_WAIT_H_ */


}
