// Generated by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE


#ifdef _WIN32
    #define _JAVASOFT_JNI_MD_H_

    #define JNIEXPORT __declspec(dllexport)
    #define JNIIMPORT __declspec(dllimport)
    #define JNICALL __stdcall

    typedef int jint;
    typedef long long jlong;
    typedef signed char jbyte;
#elif defined(__GNUC__) && !defined(__ANDROID__)
    #define _JAVASOFT_JNI_MD_H_

    #define JNIEXPORT __attribute__((visibility("default")))
    #define JNIIMPORT
    #define JNICALL

    typedef int jint;
    typedef long long jlong;
    typedef signed char jbyte;
#endif

#include <jni.h>

#ifdef __ANDROID__
    #include <android/log.h>
#elif defined(__APPLE__) && defined(__OBJC__)
    #include <TargetConditionals.h>
    #include <Foundation/Foundation.h>
#elif defined(__APPLE__)
    #include <TargetConditionals.h>
#endif

#ifdef __linux__
    #include <malloc.h>
    #include <sys/types.h>
    #include <sys/stat.h>
    #include <sys/syscall.h>
    #include <sys/sysinfo.h>
    #include <fcntl.h>
    #include <unistd.h>
    #include <dlfcn.h>
    #include <link.h>
    #include <pthread.h>
#elif defined(__APPLE__)
    #include <sys/types.h>
    #include <sys/sysctl.h>
    #include <mach/mach_init.h>
    #include <mach/mach_host.h>
    #include <mach/task.h>
    #include <unistd.h>
    #include <dlfcn.h>
    #include <mach-o/dyld.h>
    #include <pthread.h>
#elif defined(_WIN32) && !defined(NO_WINDOWS_H)
    #define NOMINMAX
    #include <windows.h>
    #include <psapi.h>
#elif defined(_WIN32)
    extern "C" unsigned long __stdcall GetCurrentThreadId();
#endif

#if defined(__ANDROID__) || TARGET_OS_IPHONE
    #define NewWeakGlobalRef(obj) NewGlobalRef(obj)
    #define DeleteWeakGlobalRef(obj) DeleteGlobalRef(obj)
#endif

#include <limits.h>
#include <stddef.h>
#ifndef _WIN32
    #include <stdint.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <exception>
#include <memory>
#include <new>

#if defined(NATIVE_ALLOCATOR) && defined(NATIVE_DEALLOCATOR)
    void* operator new(std::size_t size, const std::nothrow_t&) throw() {
        return NATIVE_ALLOCATOR(size);
    }
    void* operator new[](std::size_t size, const std::nothrow_t&) throw() {
        return NATIVE_ALLOCATOR(size);
    }
    void* operator new(std::size_t size) throw(std::bad_alloc) {
        return NATIVE_ALLOCATOR(size);
    }
    void* operator new[](std::size_t size) throw(std::bad_alloc) {
        return NATIVE_ALLOCATOR(size);
    }
    void operator delete(void* ptr) throw() {
        NATIVE_DEALLOCATOR(ptr);
    }
    void operator delete[](void* ptr) throw() {
        NATIVE_DEALLOCATOR(ptr);
    }
#endif

#define jlong_to_ptr(a) ((void*)(uintptr_t)(a))
#define ptr_to_jlong(a) ((jlong)(uintptr_t)(a))

#if defined(_MSC_VER)
    #define JavaCPP_noinline __declspec(noinline)
    #define JavaCPP_hidden /* hidden by default */
#elif defined(__GNUC__)
    #define JavaCPP_noinline __attribute__((noinline)) __attribute__ ((unused))
    #define JavaCPP_hidden   __attribute__((visibility("hidden"))) __attribute__ ((unused))
#else
    #define JavaCPP_noinline
    #define JavaCPP_hidden
#endif
#if __cplusplus >= 201103L || _MSC_VER >= 1900
    #define JavaCPP_override override
#else
    #define JavaCPP_override
#endif

static JavaVM* JavaCPP_vm = NULL;
static bool JavaCPP_haveAllocObject = false;
static bool JavaCPP_haveNonvirtual = false;
static const char* JavaCPP_classNames[21] = {
        "org/bytedeco/javacpp/Loader",
        "org/bytedeco/javacpp/Pointer",
        "org/bytedeco/javacpp/BytePointer",
        "org/bytedeco/javacpp/ShortPointer",
        "org/bytedeco/javacpp/IntPointer",
        "org/bytedeco/javacpp/LongPointer",
        "org/bytedeco/javacpp/FloatPointer",
        "org/bytedeco/javacpp/DoublePointer",
        "org/bytedeco/javacpp/CharPointer",
        "org/bytedeco/javacpp/BooleanPointer",
        "org/bytedeco/javacpp/PointerPointer",
        "org/bytedeco/javacpp/BoolPointer",
        "org/bytedeco/javacpp/CLongPointer",
        "org/bytedeco/javacpp/SizeTPointer",
        "java/lang/UnsatisfiedLinkError",
        "java/lang/String",
        "org/bytedeco/javacpp/Pointer$NativeDeallocator",
        "java/nio/Buffer",
        "java/lang/Object",
        "java/nio/charset/Charset",
        "java/lang/NullPointerException" };
static jclass JavaCPP_classes[21] = { NULL };
static jfieldID JavaCPP_addressFID = NULL;
static jfieldID JavaCPP_positionFID = NULL;
static jfieldID JavaCPP_limitFID = NULL;
static jfieldID JavaCPP_capacityFID = NULL;
static jfieldID JavaCPP_deallocatorFID = NULL;
static jfieldID JavaCPP_ownerAddressFID = NULL;
static jmethodID JavaCPP_initMID = NULL;
static jmethodID JavaCPP_arrayMID = NULL;
static jmethodID JavaCPP_arrayOffsetMID = NULL;
static jfieldID JavaCPP_bufferPositionFID = NULL;
static jfieldID JavaCPP_bufferLimitFID = NULL;
static jfieldID JavaCPP_bufferCapacityFID = NULL;
static jmethodID JavaCPP_stringMID = NULL;
static jmethodID JavaCPP_getBytesMID = NULL;
static jmethodID JavaCPP_toStringMID = NULL;
#ifdef STRING_BYTES_CHARSET
#ifdef MODIFIED_UTF8_STRING
#pragma message ("warning: STRING_BYTES_CHARSET and MODIFIED_UTF8_STRING are mutually exclusive.")
#endif
static jobject JavaCPP_stringBytesCharset = NULL;
static jmethodID JavaCPP_stringWithCharsetMID = NULL;
static jmethodID JavaCPP_getBytesWithCharsetMID = NULL;
#endif

static inline void JavaCPP_log(const char* fmt, ...) {
    va_list ap;
    va_start(ap, fmt);
#ifdef __ANDROID__
    __android_log_vprint(ANDROID_LOG_ERROR, "javacpp", fmt, ap);
#elif defined(__APPLE__) && defined(__OBJC__)
    NSLogv([NSString stringWithUTF8String:fmt], ap);
#else
    vfprintf(stderr, fmt, ap);
    fprintf(stderr, "\n");
    fflush(stderr);
#endif
    va_end(ap);
}

#if !defined(NO_JNI_DETACH_THREAD) && defined(_WIN32)
#if __cplusplus >= 201103L || _MSC_VER >= 1900
   static thread_local
#else
   static __declspec(thread)
#endif
   struct JavaCPP_thread_local {
       JNIEnv* env = NULL;
       ~JavaCPP_thread_local() {
           if (env && JavaCPP_vm) {
               JavaCPP_vm->DetachCurrentThread();
           }
       }
   } JavaCPP_thread_local; 
#elif !defined(NO_JNI_DETACH_THREAD) && (defined(__linux__) || defined(__APPLE__))
    static pthread_key_t JavaCPP_current_env;
    static JavaCPP_noinline void JavaCPP_detach_env(void *data) {
        if (JavaCPP_vm) {
            JavaCPP_vm->DetachCurrentThread();
        }
    }
    static JavaCPP_noinline void JavaCPP_create_pthread_key(void) {
        pthread_key_create(&JavaCPP_current_env, JavaCPP_detach_env);
    }
#endif

static inline jboolean JavaCPP_trimMemory() {
#if defined(__linux__) && !defined(__ANDROID__)
    return (jboolean)malloc_trim(0);
#else
    return 0;
#endif
}

static inline jlong JavaCPP_physicalBytes(jlong maxSize = 0) {
    jlong size = 0;
#ifdef __linux__
    static int fd = open("/proc/self/statm", O_RDONLY, 0);
    if (fd >= 0) {
        char line[256];
        char* s;
        int n;
        if ((n = pread(fd, line, sizeof(line), 0)) > 0 && (s = (char*)memchr(line, ' ', n)) != NULL) {
            size = (jlong)atoll(s + 1);
            if ((s = (char*)memchr(s + 1, ' ', n)) != NULL) {
                size -= (jlong)atoll(s + 1);
            }
        }
        size *= (jlong)getpagesize();
        // no close(fd);
    }
#elif defined(__APPLE__)
    task_vm_info_data_t info;
    mach_msg_type_number_t count = TASK_VM_INFO_COUNT;
    if (task_info(current_task(), TASK_VM_INFO, (task_info_t)&info, &count) == KERN_SUCCESS) {
        size = (jlong)info.internal;
    }
#elif defined(_WIN32)
    PROCESS_MEMORY_COUNTERS counters;
    if (GetProcessMemoryInfo(GetCurrentProcess(), &counters, sizeof(counters))) {
        jlong size2 = (jlong)counters.WorkingSetSize;
        if (size2 <= maxSize) return size2;
    }
    DWORD length = sizeof(PSAPI_WORKING_SET_INFORMATION);
    PSAPI_WORKING_SET_INFORMATION *info = (PSAPI_WORKING_SET_INFORMATION*)malloc(length);
    BOOL success = QueryWorkingSet(GetCurrentProcess(), info, length);
    while (!success && GetLastError() == ERROR_BAD_LENGTH) {
        length = sizeof(PSAPI_WORKING_SET_INFORMATION) + info->NumberOfEntries * sizeof(PSAPI_WORKING_SET_BLOCK);
        info = (PSAPI_WORKING_SET_INFORMATION*)realloc(info, length);
        success = QueryWorkingSet(GetCurrentProcess(), info, length);
    }
    if (success && info != NULL) {
        for (DWORD i = 0; i < info->NumberOfEntries; i++) {
            size += !info->WorkingSetInfo[i].Shared;
        }
    }
    SYSTEM_INFO sysinfo;
    GetSystemInfo(&sysinfo);
    size *= (jlong)sysinfo.dwPageSize;
    free(info);
#endif
    return size;
}

static inline jlong JavaCPP_totalPhysicalBytes() {
    jlong size = 0;
#ifdef __linux__
    struct sysinfo info;
    if (sysinfo(&info) == 0) {
        size = (jlong)info.totalram * info.mem_unit;
    }
#elif defined(__APPLE__)
    size_t length = sizeof(size);
    sysctlbyname("hw.memsize", &size, &length, NULL, 0);
#elif defined(_WIN32)
    MEMORYSTATUSEX status;
    status.dwLength = sizeof(status);
    if (GlobalMemoryStatusEx(&status)) {
        size = status.ullTotalPhys;
    }
#endif
    return size;
}

static inline jlong JavaCPP_availablePhysicalBytes() {
    jlong size = 0;
#ifdef __linux__
    int fd = open("/proc/meminfo", O_RDONLY, 0);
    if (fd >= 0) {
        char temp[4096];
        char *s;
        int n;
        if ((n = read(fd, temp, sizeof(temp))) > 0 && (s = (char*)memmem(temp, n, "MemAvailable:", 13)) != NULL) {
            size = (jlong)(atoll(s + 13) * 1024);
        }
        close(fd);
    }
    if (size == 0) {
        struct sysinfo info;
        if (sysinfo(&info) == 0) {
            size = (jlong)info.freeram * info.mem_unit;
        }
    }
#elif defined(__APPLE__)
    vm_statistics_data_t info;
    mach_msg_type_number_t count = HOST_VM_INFO_COUNT;
    if (host_statistics(mach_host_self(), HOST_VM_INFO, (host_info_t)&info, &count) == KERN_SUCCESS) {
        size = (jlong)info.free_count * getpagesize();
    }
#elif defined(_WIN32)
    MEMORYSTATUSEX status;
    status.dwLength = sizeof(status);
    if (GlobalMemoryStatusEx(&status)) {
        size = status.ullAvailPhys;
    }
#endif
    return size;
}

static inline jlong JavaCPP_getDirectBufferAddress(JNIEnv *env, jclass cls, jobject obj) {
    return (jlong)env->GetDirectBufferAddress(obj);
}

static inline jint JavaCPP_totalProcessors() {
    jint total = 0;
#ifdef __linux__
    total = sysconf(_SC_NPROCESSORS_CONF);
#elif defined(__APPLE__)
    size_t length = sizeof(total);
    sysctlbyname("hw.logicalcpu_max", &total, &length, NULL, 0);
#elif defined(_WIN32)
    SYSTEM_INFO info;
    GetSystemInfo(&info);
    total = info.dwNumberOfProcessors;
#endif
    return total;
}

static inline jint JavaCPP_totalCores() {
    jint total = 0;
#ifdef __linux__
    const int n = sysconf(_SC_NPROCESSORS_CONF);
    int pids[n], cids[n];
    for (int i = 0; i < n; i++) {
        int fd = 0, pid = 0, cid = 0;
        char temp[256];
        sprintf(temp, "/sys/devices/system/cpu/cpu%d/topology/physical_package_id", i);
        if ((fd = open(temp, O_RDONLY, 0)) >= 0) {
            if (read(fd, temp, sizeof(temp)) > 0) {
                pid = atoi(temp);
            }
            close(fd);
        }
        sprintf(temp, "/sys/devices/system/cpu/cpu%d/topology/core_id", i);
        if ((fd = open(temp, O_RDONLY, 0)) >= 0) {
            if (read(fd, temp, sizeof(temp)) > 0) {
                cid = atoi(temp);
            }
            close(fd);
        }
        bool found = false;
        for (int j = 0; j < total; j++) {
            if (pids[j] == pid && cids[j] == cid) {
                found = true;
                break;
            }
        }
        if (!found) {
            pids[total] = pid;
            cids[total] = cid;
            total++;
        }
    }
#elif defined(__APPLE__)
    size_t length = sizeof(total);
    sysctlbyname("hw.physicalcpu_max", &total, &length, NULL, 0);
#elif defined(_WIN32)
    SYSTEM_LOGICAL_PROCESSOR_INFORMATION *info = NULL;
    DWORD length = 0;
    BOOL success = GetLogicalProcessorInformation(info, &length);
    while (!success && GetLastError() == ERROR_INSUFFICIENT_BUFFER) {
        info = (SYSTEM_LOGICAL_PROCESSOR_INFORMATION*)realloc(info, length);
        success = GetLogicalProcessorInformation(info, &length);
    }
    if (success && info != NULL) {
        length /= sizeof(SYSTEM_LOGICAL_PROCESSOR_INFORMATION);
        for (DWORD i = 0; i < length; i++) {
            if (info[i].Relationship == RelationProcessorCore) {
                total++;
            }
        }
    }
    free(info);
#endif
    return total;
}

static inline jint JavaCPP_totalChips() {
    jint total = 0;
#ifdef __linux__
    const int n = sysconf(_SC_NPROCESSORS_CONF);
    int pids[n];
    for (int i = 0; i < n; i++) {
        int fd = 0, pid = 0;
        char temp[256];
        sprintf(temp, "/sys/devices/system/cpu/cpu%d/topology/physical_package_id", i);
        if ((fd = open(temp, O_RDONLY, 0)) >= 0) {
            if (read(fd, temp, sizeof(temp)) > 0) {
                pid = atoi(temp);
            }
            close(fd);
        }
        bool found = false;
        for (int j = 0; j < total; j++) {
            if (pids[j] == pid) {
                found = true;
                break;
            }
        }
        if (!found) {
            pids[total] = pid;
            total++;
        }
    }
#elif defined(__APPLE__)
    size_t length = sizeof(total);
    sysctlbyname("hw.packages", &total, &length, NULL, 0);
#elif defined(_WIN32)
    SYSTEM_LOGICAL_PROCESSOR_INFORMATION *info = NULL;
    DWORD length = 0;
    BOOL success = GetLogicalProcessorInformation(info, &length);
    while (!success && GetLastError() == ERROR_INSUFFICIENT_BUFFER) {
        info = (SYSTEM_LOGICAL_PROCESSOR_INFORMATION*)realloc(info, length);
        success = GetLogicalProcessorInformation(info, &length);
    }
    if (success && info != NULL) {
        length /= sizeof(SYSTEM_LOGICAL_PROCESSOR_INFORMATION);
        for (DWORD i = 0; i < length; i++) {
            if (info[i].Relationship == RelationProcessorPackage) {
                total++;
            }
        }
    }
    free(info);
#endif
    return total;
}

#if defined(__linux__) && !(defined(__ANDROID__) && defined(__arm__))
static int JavaCPP_dlcallback(dl_phdr_info *info, size_t size, void *data) {
    void *handle = dlopen(info->dlpi_name, RTLD_LAZY);
    if (handle != NULL) {
        void *address = dlsym(handle, ((char**)data)[0]);
        dlclose(handle);
        if (address != NULL) {
            ((void**)data)[1] = address;
            return 1;
        }
    }
    return 0;
}
#endif

static JavaCPP_noinline jclass JavaCPP_getClass(JNIEnv* env, int i);
static inline void JavaCPP_loadGlobal(JNIEnv* env, jclass cls, const char* filename) {
#ifdef _WIN32
    HMODULE handle = LoadLibrary(filename);
    if (handle == NULL) {
        char temp[256];
        sprintf(temp, "LoadLibrary() failed with 0x%lx", GetLastError());
        env->ThrowNew(JavaCPP_getClass(env, 14), temp);
    }
#else
    void *handle = dlopen(filename, RTLD_LAZY | RTLD_GLOBAL);
    if (handle == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 14), dlerror());
    }
#endif
}

static inline void* JavaCPP_addressof(const char* name) {
    void *address = NULL;
#ifdef __linux__
    address = dlsym(RTLD_DEFAULT, name);
#if !(defined(__ANDROID__) && defined(__arm__))
    if (address == NULL) {
        void *data[] = { (char*)name, NULL };
        dl_iterate_phdr(JavaCPP_dlcallback, data);
        address = data[1];
    }
#endif
#elif defined(__APPLE__)
    address = dlsym(RTLD_DEFAULT, name);
    if (address == NULL) {
        for (uint32_t i = 0; i < _dyld_image_count(); i++) {
            const char *libname = _dyld_get_image_name(i);
            if (libname != NULL) {
                void *handle = dlopen(libname, RTLD_LAZY);
                if (handle != NULL) {
                    address = dlsym(handle, name);
                    dlclose(handle);
                    if (address != NULL) {
                        break;
                    }
                }
            }
        }
    }
#elif defined(_WIN32)
    HANDLE process = GetCurrentProcess();
    HMODULE *modules = NULL;
    DWORD length = 0, needed = 0;
    BOOL success = EnumProcessModules(process, modules, length, &needed);
    while (success && needed > length) {
        modules = (HMODULE*)realloc(modules, length = needed);
        success = EnumProcessModules(process, modules, length, &needed);
    }
    if (success && modules != NULL) {
        length = needed / sizeof(HMODULE);
        for (DWORD i = 0; i < length; i++) {
            address = (void*)GetProcAddress(modules[i], name);
            if (address != NULL) {
                break;
            }
        }
    }
    free(modules);
#endif
    return address;
}

static inline JavaVM* JavaCPP_getJavaVM() {
    return JavaCPP_vm;
}

static inline jobject JavaCPP_newGlobalRef(JNIEnv *env, jclass cls, jobject obj) {
    return env->NewGlobalRef(obj);
}

static inline jobject JavaCPP_accessGlobalRef(JNIEnv *env, jclass cls, jobject globalRef) {
    return globalRef;
}

static inline void JavaCPP_deleteGlobalRef(JNIEnv *env, jclass cls, jobject globalRef) {
    env->DeleteGlobalRef(globalRef);
}

static JavaCPP_noinline jclass JavaCPP_getClass(JNIEnv* env, int i) {
    if (JavaCPP_classes[i] == NULL && env->PushLocalFrame(1) == 0) {
        jclass cls = env->FindClass(JavaCPP_classNames[i]);
        if (cls == NULL || env->ExceptionCheck()) {
            JavaCPP_log("Error loading class %s.", JavaCPP_classNames[i]);
            return NULL;
        }
        JavaCPP_classes[i] = (jclass)env->NewWeakGlobalRef(cls);
        if (JavaCPP_classes[i] == NULL || env->ExceptionCheck()) {
            JavaCPP_log("Error creating global reference of class %s.", JavaCPP_classNames[i]);
            return NULL;
        }
        env->PopLocalFrame(NULL);
    }
    return JavaCPP_classes[i];
}

static JavaCPP_noinline jfieldID JavaCPP_getFieldID(JNIEnv* env, int i, const char* name, const char* sig) {
    jclass cls = JavaCPP_getClass(env, i);
    if (cls == NULL) {
        return NULL;
    }
    jfieldID fid = env->GetFieldID(cls, name, sig);
    if (fid == NULL || env->ExceptionCheck()) {
        JavaCPP_log("Error getting field ID of %s/%s", JavaCPP_classNames[i], name);
        return NULL;
    }
    return fid;
}

static JavaCPP_noinline jmethodID JavaCPP_getMethodID(JNIEnv* env, int i, const char* name, const char* sig) {
    jclass cls = JavaCPP_getClass(env, i);
    if (cls == NULL) {
        return NULL;
    }
    jmethodID mid = env->GetMethodID(cls, name, sig);
    if (mid == NULL || env->ExceptionCheck()) {
        JavaCPP_log("Error getting method ID of %s/%s", JavaCPP_classNames[i], name);
        return NULL;
    }
    return mid;
}

static JavaCPP_noinline jmethodID JavaCPP_getStaticMethodID(JNIEnv* env, int i, const char* name, const char* sig) {
    jclass cls = JavaCPP_getClass(env, i);
    if (cls == NULL) {
        return NULL;
    }
    jmethodID mid = env->GetStaticMethodID(cls, name, sig);
    if (mid == NULL || env->ExceptionCheck()) {
        JavaCPP_log("Error getting static method ID of %s/%s", JavaCPP_classNames[i], name);
        return NULL;
    }
    return mid;
}

static JavaCPP_noinline jobject JavaCPP_createPointer(JNIEnv* env, int i, jclass cls = NULL) {
    if (cls == NULL && (cls = JavaCPP_getClass(env, i)) == NULL) {
        return NULL;
    }
    if (JavaCPP_haveAllocObject) {
        return env->AllocObject(cls);
    } else {
        jmethodID mid = env->GetMethodID(cls, "<init>", "(Lorg/bytedeco/javacpp/Pointer;)V");
        if (mid == NULL || env->ExceptionCheck()) {
            JavaCPP_log("Error getting Pointer constructor of %s, while VM does not support AllocObject()", JavaCPP_classNames[i]);
            return NULL;
        }
        return env->NewObject(cls, mid, NULL);
    }
}

static JavaCPP_noinline void JavaCPP_initPointer(JNIEnv* env, jobject obj, const void* ptr, jlong size, void* owner, void (*deallocator)(void*)) {
    if (owner != NULL && deallocator != NULL) {
        jvalue args[4];
        args[0].j = ptr_to_jlong(ptr);
        args[1].j = size;
        args[2].j = ptr_to_jlong(owner);
        args[3].j = ptr_to_jlong(deallocator);
        if (JavaCPP_haveNonvirtual) {
            env->CallNonvirtualVoidMethodA(obj, JavaCPP_getClass(env, 1), JavaCPP_initMID, args);
        } else {
            env->CallVoidMethodA(obj, JavaCPP_initMID, args);
        }
    } else {
        env->SetLongField(obj, JavaCPP_addressFID, ptr_to_jlong(ptr));
        env->SetLongField(obj, JavaCPP_limitFID, (jlong)size);
        env->SetLongField(obj, JavaCPP_capacityFID, (jlong)size);
    }
}

#include <string>
static JavaCPP_noinline jstring JavaCPP_createStringFromBytes(JNIEnv* env, const char* ptr, size_t length) {
    if (ptr == NULL) {
        return NULL;
    }
#ifdef MODIFIED_UTF8_STRING
    return env->NewStringUTF(ptr);
#else
    jbyteArray bytes = env->NewByteArray(length < INT_MAX ? length : INT_MAX);
    env->SetByteArrayRegion(bytes, 0, length < INT_MAX ? length : INT_MAX, (signed char*)ptr);
#ifdef STRING_BYTES_CHARSET
    jstring s = (jstring)env->NewObject(JavaCPP_getClass(env, 15), JavaCPP_stringWithCharsetMID, bytes, JavaCPP_stringBytesCharset);
#else
    jstring s = (jstring)env->NewObject(JavaCPP_getClass(env, 15), JavaCPP_stringMID, bytes);
#endif // STRING_BYTES_CHARSET
    env->DeleteLocalRef(bytes);
    return s;
#endif // MODIFIED_UTF8_STRING
}

static JavaCPP_noinline jstring JavaCPP_createStringFromBytes(JNIEnv* env, const char* ptr) {
    if (ptr == NULL) {
        return NULL;
    }
    return JavaCPP_createStringFromBytes(env, ptr, std::char_traits<char>::length(ptr));
}

static JavaCPP_noinline jstring JavaCPP_createStringFromUTF16(JNIEnv* env, const unsigned short* ptr, size_t length) {
    if (ptr == NULL) {
        return NULL;
    }
    return env->NewString(ptr, length);
}

static JavaCPP_noinline jstring JavaCPP_createStringFromUTF16(JNIEnv* env, const unsigned short* ptr) {
    if (ptr == NULL) {
        return NULL;
    }
    return JavaCPP_createStringFromUTF16(env, ptr, std::char_traits<unsigned short>::length(ptr));
}

static JavaCPP_noinline const char* JavaCPP_getStringBytes(JNIEnv* env, jstring str) {
    if (str == NULL) {
        return NULL;
    }
#ifdef MODIFIED_UTF8_STRING
    return env->GetStringUTFChars(str, NULL);
#else
#ifdef STRING_BYTES_CHARSET
    jbyteArray bytes = (jbyteArray)env->CallObjectMethod(str, JavaCPP_getBytesWithCharsetMID, JavaCPP_stringBytesCharset);
#else
    jbyteArray bytes = (jbyteArray)env->CallObjectMethod(str, JavaCPP_getBytesMID);
#endif // STRING_BYTES_CHARSET
    if (bytes == NULL || env->ExceptionCheck()) {
        JavaCPP_log("Error getting bytes from string.");
        return NULL;
    }
    jsize length = env->GetArrayLength(bytes);
    signed char* ptr = new (std::nothrow) signed char[length + 1];
    if (ptr != NULL) {
        env->GetByteArrayRegion(bytes, 0, length, ptr);
        ptr[length] = 0;
    }
    return (const char*)ptr;
#endif // MODIFIED_UTF8_STRING
}

static JavaCPP_noinline void JavaCPP_releaseStringBytes(JNIEnv* env, jstring str, const char* ptr) {
#ifdef MODIFIED_UTF8_STRING
    if (str != NULL && ptr != NULL) {
        env->ReleaseStringUTFChars(str, ptr);
    }
#else
    delete[] ptr;
#endif
}

static JavaCPP_noinline const unsigned short* JavaCPP_getStringUTF16(JNIEnv* env, jstring str) {
    if (str == NULL) {
        return NULL;
    }
    const jsize length = env->GetStringLength(str);
    unsigned short* ptr = new (std::nothrow) unsigned short[length + 1];
    if (ptr != NULL) {
        env->GetStringRegion(str, 0, length, ptr);
        ptr[length] = 0;
    }
    return ptr;
}

static JavaCPP_noinline void JavaCPP_releaseStringUTF16(JNIEnv*, const unsigned short* ptr) {
    delete[] ptr;
}

class JavaCPP_hidden JavaCPP_exception : public std::exception {
public:
    JavaCPP_exception(const char* str) throw() {
        if (str == NULL) {
            strcpy(msg, "Unknown exception.");
        } else {
            strncpy(msg, str, sizeof(msg));
            msg[sizeof(msg) - 1] = 0;
        }
    }
    virtual const char* what() const throw() { return msg; }
    char msg[1024];
};




static void JavaCPP_org_bytedeco_javacpp_BytePointer_deallocateArray(void* p) { delete[] (signed char*)p; }
static void JavaCPP_org_bytedeco_javacpp_ShortPointer_deallocateArray(void* p) { delete[] (short*)p; }
static void JavaCPP_org_bytedeco_javacpp_IntPointer_deallocateArray(void* p) { delete[] (int*)p; }
static void JavaCPP_org_bytedeco_javacpp_LongPointer_deallocateArray(void* p) { delete[] (jlong*)p; }
static void JavaCPP_org_bytedeco_javacpp_FloatPointer_deallocateArray(void* p) { delete[] (float*)p; }
static void JavaCPP_org_bytedeco_javacpp_DoublePointer_deallocateArray(void* p) { delete[] (double*)p; }
static void JavaCPP_org_bytedeco_javacpp_CharPointer_deallocateArray(void* p) { delete[] (unsigned short*)p; }
static void JavaCPP_org_bytedeco_javacpp_BooleanPointer_deallocateArray(void* p) { delete[] (unsigned char*)p; }
static void JavaCPP_org_bytedeco_javacpp_PointerPointer_deallocateArray(void* p) { delete[] (void**)p; }
static void JavaCPP_org_bytedeco_javacpp_BoolPointer_deallocateArray(void* p) { delete[] (bool*)p; }
static void JavaCPP_org_bytedeco_javacpp_CLongPointer_deallocateArray(void* p) { delete[] (long*)p; }
static void JavaCPP_org_bytedeco_javacpp_SizeTPointer_deallocateArray(void* p) { delete[] (size_t*)p; }

static const char* JavaCPP_members[21][2] = {
        { NULL },
        { "sizeof" },
        { "sizeof" },
        { "sizeof" },
        { "sizeof" },
        { "sizeof" },
        { "sizeof" },
        { "sizeof" },
        { "sizeof" },
        { "sizeof" },
        { "sizeof" },
        { "sizeof" },
        { "sizeof" },
        { "sizeof" },
        { NULL },
        { NULL },
        { NULL },
        { NULL },
        { NULL },
        { NULL },
        { NULL } };
static int JavaCPP_offsets[21][2] = {
        { -1 },
        { sizeof(void*) },
        { sizeof(signed char) },
        { sizeof(short) },
        { sizeof(int) },
        { sizeof(jlong) },
        { sizeof(float) },
        { sizeof(double) },
        { sizeof(unsigned short) },
        { sizeof(unsigned char) },
        { sizeof(void*) },
        { sizeof(bool) },
        { sizeof(long) },
        { sizeof(size_t) },
        { -1 },
        { -1 },
        { -1 },
        { -1 },
        { -1 },
        { -1 },
        { -1 } };
static int JavaCPP_memberOffsetSizes[21] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };

extern "C" {

JNIEXPORT jint JNICALL JNI_OnLoad_jnijavacpp(JavaVM* vm, void* reserved) {
    JNIEnv* env;
    if (vm->GetEnv((void**)&env, JNI_VERSION_1_6) != JNI_OK) {
        JavaCPP_log("Could not get JNIEnv for JNI_VERSION_1_6 inside JNI_OnLoad_jnijavacpp().");
        return JNI_ERR;
    }
    if (JavaCPP_vm == vm) {
        return env->GetVersion();
    }
    JavaCPP_vm = vm;
    JavaCPP_haveAllocObject = env->functions->AllocObject != NULL;
    JavaCPP_haveNonvirtual = env->functions->CallNonvirtualVoidMethodA != NULL;
    jmethodID putMemberOffsetMID = JavaCPP_getStaticMethodID(env, 0, "putMemberOffset", "(Ljava/lang/String;Ljava/lang/String;I)Ljava/lang/Class;");
    if (putMemberOffsetMID == NULL) {
        return JNI_ERR;
    }
    for (int i = 0; i < 21 && !env->ExceptionCheck(); i++) {
        for (int j = 0; j < JavaCPP_memberOffsetSizes[i] && !env->ExceptionCheck(); j++) {
            if (env->PushLocalFrame(3) == 0) {
                jvalue args[3];
                args[0].l = env->NewStringUTF(JavaCPP_classNames[i]);
                args[1].l = JavaCPP_members[i][j] == NULL ? NULL : env->NewStringUTF(JavaCPP_members[i][j]);
                args[2].i = JavaCPP_offsets[i][j];
                jclass cls = (jclass)env->CallStaticObjectMethodA(JavaCPP_getClass(env, 0), putMemberOffsetMID, args);
                if (env->ExceptionCheck()) {
                    JavaCPP_log("Error putting member offsets for class %s.", JavaCPP_classNames[i]);
                    return JNI_ERR;
                }
                JavaCPP_classes[i] = cls == NULL ? NULL : (jclass)env->NewWeakGlobalRef(cls);
                if (env->ExceptionCheck()) {
                    JavaCPP_log("Error creating global reference of class %s.", JavaCPP_classNames[i]);
                    return JNI_ERR;
                }
                env->PopLocalFrame(NULL);
            }
        }
    }
    JavaCPP_addressFID = JavaCPP_getFieldID(env, 1, "address", "J");
    if (JavaCPP_addressFID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_positionFID = JavaCPP_getFieldID(env, 1, "position", "J");
    if (JavaCPP_positionFID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_limitFID = JavaCPP_getFieldID(env, 1, "limit", "J");
    if (JavaCPP_limitFID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_capacityFID = JavaCPP_getFieldID(env, 1, "capacity", "J");
    if (JavaCPP_capacityFID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_deallocatorFID = JavaCPP_getFieldID(env, 1, "deallocator", "Lorg/bytedeco/javacpp/Pointer$Deallocator;");
    if (JavaCPP_deallocatorFID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_ownerAddressFID = JavaCPP_getFieldID(env, 16, "ownerAddress", "J");
    if (JavaCPP_ownerAddressFID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_initMID = JavaCPP_getMethodID(env, 1, "init", "(JJJJ)V");
    if (JavaCPP_initMID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_arrayMID = JavaCPP_getMethodID(env, 17, "array", "()Ljava/lang/Object;");
    if (JavaCPP_arrayMID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_arrayOffsetMID = JavaCPP_getMethodID(env, 17, "arrayOffset", "()I");
    if (JavaCPP_arrayOffsetMID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_bufferPositionFID = JavaCPP_getFieldID(env, 17, "position", "I");
    if (JavaCPP_bufferPositionFID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_bufferLimitFID = JavaCPP_getFieldID(env, 17, "limit", "I");
    if (JavaCPP_bufferLimitFID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_bufferCapacityFID = JavaCPP_getFieldID(env, 17, "capacity", "I");
    if (JavaCPP_bufferCapacityFID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_stringMID = JavaCPP_getMethodID(env, 15, "<init>", "([B)V");
    if (JavaCPP_stringMID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_getBytesMID = JavaCPP_getMethodID(env, 15, "getBytes", "()[B");
    if (JavaCPP_getBytesMID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_toStringMID = JavaCPP_getMethodID(env, 18, "toString", "()Ljava/lang/String;");
    if (JavaCPP_toStringMID == NULL) {
        return JNI_ERR;
    }
#ifdef STRING_BYTES_CHARSET
    jmethodID charsetForNameMID = JavaCPP_getStaticMethodID(env, 19, "forName", "(Ljava/lang/String;)Ljava/nio/charset/Charset;");
    if (charsetForNameMID == NULL) {
        return JNI_ERR;
    }
    jstring charsetName = env->NewStringUTF(STRING_BYTES_CHARSET);
    if (charsetName == NULL || env->ExceptionCheck()) {
        JavaCPP_log("Error creating java.lang.String from '%s'", STRING_BYTES_CHARSET);
        return JNI_ERR;
    }
    JavaCPP_stringBytesCharset = env->CallStaticObjectMethod(JavaCPP_getClass(env, 19), charsetForNameMID, charsetName);
    if (JavaCPP_stringBytesCharset == NULL || env->ExceptionCheck()) {
        JavaCPP_log("Error when calling Charset.forName() for '%s'", STRING_BYTES_CHARSET);
        return JNI_ERR;
    }
    JavaCPP_stringBytesCharset = env->NewGlobalRef(JavaCPP_stringBytesCharset);
    if (JavaCPP_stringBytesCharset == NULL) {
        JavaCPP_log("Error creating global reference for java.nio.charset.Charset instance");
        return JNI_ERR;
    }
    JavaCPP_stringWithCharsetMID = JavaCPP_getMethodID(env, 15, "<init>", "([BLjava/nio/charset/Charset;)V");
    if (JavaCPP_stringWithCharsetMID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_getBytesWithCharsetMID = JavaCPP_getMethodID(env, 15, "getBytes", "(Ljava/nio/charset/Charset;)[B");
    if (JavaCPP_getBytesWithCharsetMID == NULL) {
        return JNI_ERR;
    }
#endif // STRING_BYTES_CHARSET
    return env->GetVersion();
}


JNIEXPORT void JNICALL JNI_OnUnload_jnijavacpp(JavaVM* vm, void* reserved) {
    JNIEnv* env;
    if (vm->GetEnv((void**)&env, JNI_VERSION_1_6) != JNI_OK) {
        JavaCPP_log("Could not get JNIEnv for JNI_VERSION_1_6 inside JNI_OnUnLoad_jnijavacpp().");
        return;
    }
    for (int i = 0; i < 21; i++) {
        env->DeleteWeakGlobalRef((jweak)JavaCPP_classes[i]);
        JavaCPP_classes[i] = NULL;
    }
#ifdef STRING_BYTES_CHARSET
    env->DeleteGlobalRef(JavaCPP_stringBytesCharset);
    JavaCPP_stringBytesCharset = NULL;
#endif
    JavaCPP_vm = NULL;
}

JNIEXPORT jint JNICALL Java_org_bytedeco_javacpp_Loader_totalProcessors(JNIEnv* env, jclass cls) {
    jint rarg = 0;
    int rval = JavaCPP_totalProcessors();
    rarg = (jint)rval;
    return rarg;
}
JNIEXPORT jint JNICALL Java_org_bytedeco_javacpp_Loader_totalCores(JNIEnv* env, jclass cls) {
    jint rarg = 0;
    int rval = JavaCPP_totalCores();
    rarg = (jint)rval;
    return rarg;
}
JNIEXPORT jint JNICALL Java_org_bytedeco_javacpp_Loader_totalChips(JNIEnv* env, jclass cls) {
    jint rarg = 0;
    int rval = JavaCPP_totalChips();
    rarg = (jint)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_Loader_addressof(JNIEnv* env, jclass cls, jstring arg0) {
    const char* ptr0 = JavaCPP_getStringBytes(env, arg0);
    jobject rarg = NULL;
    void* rptr;
    rptr = JavaCPP_addressof(ptr0);
    if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    JavaCPP_releaseStringBytes(env, arg0, ptr0);
    return rarg;
}
JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_Loader_loadGlobal(JNIEnv* env, jclass cls, jstring arg0) {
    const char* ptr0 = JavaCPP_getStringBytes(env, arg0);
    JavaCPP_loadGlobal(env, cls, ptr0);
    JavaCPP_releaseStringBytes(env, arg0, ptr0);
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_Loader_getJavaVM(JNIEnv* env, jclass cls) {
    jobject rarg = NULL;
    JavaVM* rptr;
    rptr = (JavaVM*)JavaCPP_getJavaVM();
    if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_Loader_newGlobalRef(JNIEnv* env, jclass cls, jobject arg0) {
    jobject ptr0 = arg0;
    jobject rarg = NULL;
    jobject rptr;
    rptr = (jobject)JavaCPP_newGlobalRef(env, cls, ptr0);
    if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_Loader_accessGlobalRef(JNIEnv* env, jclass cls, jobject arg0) {
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jobject rarg = NULL;
    jobject rptr;
    rptr = JavaCPP_accessGlobalRef(env, cls, (jobject)ptr0);
    rarg = rptr;
    return rarg;
}
JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_Loader_deleteGlobalRef(JNIEnv* env, jclass cls, jobject arg0) {
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    JavaCPP_deleteGlobalRef(env, cls, (jobject)ptr0);
}




JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_Pointer_00024NativeDeallocator_deallocate(JNIEnv* env, jobject obj, jlong arg0, jlong arg1) {
    void* allocatedAddress = jlong_to_ptr(arg0);
    void (*deallocatorAddress)(void*) = (void(*)(void*))jlong_to_ptr(arg1);
    if (deallocatorAddress != NULL && allocatedAddress != NULL) {
        (*deallocatorAddress)(allocatedAddress);
    }

}




JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_Pointer_free(JNIEnv* env, jclass cls, jobject arg0) {
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    free(ptr0);
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_Pointer_memcpy(JNIEnv* env, jclass cls, jobject arg0, jobject arg1, jlong arg2) {
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    char* ptr1 = arg1 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = NULL;
    void* rptr;
    rptr = memcpy(ptr0, ptr1, arg2);
    if (rptr == ptr0) {
        rarg = arg0;
    } else if (rptr == ptr1) {
        rarg = arg1;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_Pointer_memmove(JNIEnv* env, jclass cls, jobject arg0, jobject arg1, jlong arg2) {
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    char* ptr1 = arg1 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = NULL;
    void* rptr;
    rptr = memmove(ptr0, ptr1, arg2);
    if (rptr == ptr0) {
        rarg = arg0;
    } else if (rptr == ptr1) {
        rarg = arg1;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_Pointer_memset(JNIEnv* env, jclass cls, jobject arg0, jint arg1, jlong arg2) {
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jobject rarg = NULL;
    void* rptr;
    rptr = memset(ptr0, arg1, arg2);
    if (rptr == ptr0) {
        rarg = arg0;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jint JNICALL Java_org_bytedeco_javacpp_Pointer_memcmp(JNIEnv* env, jclass cls, jobject arg0, jobject arg1, jlong arg2) {
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    char* ptr1 = arg1 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jint rarg = 0;
    int rval = memcmp(ptr0, ptr1, arg2);
    rarg = (jint)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_Pointer_malloc(JNIEnv* env, jclass cls, jlong arg0) {
    jobject rarg = NULL;
    void* rptr;
    rptr = malloc(arg0);
    if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_Pointer_calloc(JNIEnv* env, jclass cls, jlong arg0, jlong arg1) {
    jobject rarg = NULL;
    void* rptr;
    rptr = calloc(arg0, arg1);
    if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_Pointer_realloc(JNIEnv* env, jclass cls, jobject arg0, jlong arg1) {
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jobject rarg = NULL;
    void* rptr;
    rptr = realloc(ptr0, arg1);
    if (rptr == ptr0) {
        rarg = arg0;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jboolean JNICALL Java_org_bytedeco_javacpp_Pointer_trimMemory(JNIEnv* env, jclass cls) {
    jboolean rarg = 0;
    unsigned char rval = JavaCPP_trimMemory();
    rarg = (jboolean)rval;
    return rarg;
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_Pointer_physicalBytes(JNIEnv* env, jclass cls) {
    jlong rarg = 0;
    jlong rval = JavaCPP_physicalBytes();
    rarg = (jlong)rval;
    return rarg;
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_Pointer_physicalBytesInaccurate(JNIEnv* env, jclass cls, jlong arg0) {
    jlong rarg = 0;
    jlong rval = JavaCPP_physicalBytes(arg0);
    rarg = (jlong)rval;
    return rarg;
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_Pointer_totalPhysicalBytes(JNIEnv* env, jclass cls) {
    jlong rarg = 0;
    jlong rval = JavaCPP_totalPhysicalBytes();
    rarg = (jlong)rval;
    return rarg;
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_Pointer_availablePhysicalBytes(JNIEnv* env, jclass cls) {
    jlong rarg = 0;
    jlong rval = JavaCPP_availablePhysicalBytes();
    rarg = (jlong)rval;
    return rarg;
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_Pointer_getDirectBufferAddress(JNIEnv* env, jclass cls, jobject arg0) {
    jobject ptr0 = arg0;
    jlong rarg = 0;
    jlong rval = JavaCPP_getDirectBufferAddress(env, cls, ptr0);
    rarg = (jlong)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_Pointer_asDirectBuffer(JNIEnv* env, jobject obj) {
    char* ptr = (char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    jlong limit = env->GetLongField(obj, JavaCPP_limitFID);
    jlong capacity = env->GetLongField(obj, JavaCPP_capacityFID);
    jobject rarg = NULL;
    char* rptr;
    rptr = ptr;
    jlong rposition = position;
    jlong rlimit = limit;
    jlong rcapacity = capacity;
    if (rptr != NULL) {
        jlong rcapacityptr = rcapacity * sizeof(rptr[0]);
        rarg = env->NewDirectByteBuffer((void*)rptr, rcapacityptr < INT_MAX ? rcapacityptr : INT_MAX);
        jlong rpositionptr = rposition * sizeof(rptr[0]);
        jlong rlimitptr = rlimit * sizeof(rptr[0]);
        env->SetIntField(rarg, JavaCPP_bufferPositionFID, rpositionptr < INT_MAX ? rpositionptr : INT_MAX);
        env->SetIntField(rarg, JavaCPP_bufferLimitFID, rlimitptr < INT_MAX ? rlimitptr : INT_MAX);
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_Pointer_memchr(JNIEnv* env, jclass cls, jobject arg0, jint arg1, jlong arg2) {
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jobject rarg = NULL;
    void* rptr;
    rptr = memchr(ptr0, arg1, arg2);
    if (rptr == ptr0) {
        rarg = arg0;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_Pointer_allocate(JNIEnv* env, jobject obj, jobject arg0) {
    char* ptr0 = arg0 == NULL ? NULL : (char*)env->GetDirectBufferAddress(arg0);
    jlong position0 = arg0 == NULL ? 0 : env->GetIntField(arg0, JavaCPP_bufferPositionFID);
    ptr0 += position0;
    void* rptr = ptr0;
    jlong rcapacity = 1;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, NULL);
}

JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strerror(JNIEnv* env, jclass cls, jint arg0) {
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strerror(arg0);
    if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 2);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_BytePointer_strlen(JNIEnv* env, jclass cls, jobject arg0) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jlong rarg = 0;
    size_t rval = (size_t)strlen((char*)ptr0);
    rarg = (jlong)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strcpy(JNIEnv* env, jclass cls, jobject arg0, jobject arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strcpy((char*)ptr0, (char*)ptr1);
    if (rptr == (char*)ptr0) {
        rarg = arg0;
    } else if (rptr == (char*)ptr1) {
        rarg = arg1;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 2);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strncpy(JNIEnv* env, jclass cls, jobject arg0, jobject arg1, jlong arg2) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strncpy((char*)ptr0, (char*)ptr1, (size_t)arg2);
    if (rptr == (char*)ptr0) {
        rarg = arg0;
    } else if (rptr == (char*)ptr1) {
        rarg = arg1;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 2);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strcat(JNIEnv* env, jclass cls, jobject arg0, jobject arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strcat((char*)ptr0, (char*)ptr1);
    if (rptr == (char*)ptr0) {
        rarg = arg0;
    } else if (rptr == (char*)ptr1) {
        rarg = arg1;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 2);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strncat(JNIEnv* env, jclass cls, jobject arg0, jobject arg1, jlong arg2) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strncat((char*)ptr0, (char*)ptr1, (size_t)arg2);
    if (rptr == (char*)ptr0) {
        rarg = arg0;
    } else if (rptr == (char*)ptr1) {
        rarg = arg1;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 2);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jint JNICALL Java_org_bytedeco_javacpp_BytePointer_strcmp(JNIEnv* env, jclass cls, jobject arg0, jobject arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jint rarg = 0;
    int rval = strcmp((char*)ptr0, (char*)ptr1);
    rarg = (jint)rval;
    return rarg;
}
JNIEXPORT jint JNICALL Java_org_bytedeco_javacpp_BytePointer_strncmp(JNIEnv* env, jclass cls, jobject arg0, jobject arg1, jlong arg2) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jint rarg = 0;
    int rval = strncmp((char*)ptr0, (char*)ptr1, (size_t)arg2);
    rarg = (jint)rval;
    return rarg;
}
JNIEXPORT jint JNICALL Java_org_bytedeco_javacpp_BytePointer_strcoll(JNIEnv* env, jclass cls, jobject arg0, jobject arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jint rarg = 0;
    int rval = strcoll((char*)ptr0, (char*)ptr1);
    rarg = (jint)rval;
    return rarg;
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_BytePointer_strxfrm(JNIEnv* env, jclass cls, jobject arg0, jobject arg1, jlong arg2) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jlong rarg = 0;
    size_t rval = (size_t)strxfrm((char*)ptr0, (char*)ptr1, (size_t)arg2);
    rarg = (jlong)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strchr(JNIEnv* env, jclass cls, jobject arg0, jint arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strchr((char*)ptr0, arg1);
    if (rptr == (char*)ptr0) {
        rarg = arg0;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 2);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strrchr(JNIEnv* env, jclass cls, jobject arg0, jint arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strrchr((char*)ptr0, arg1);
    if (rptr == (char*)ptr0) {
        rarg = arg0;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 2);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_BytePointer_strcspn(JNIEnv* env, jclass cls, jobject arg0, jobject arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jlong rarg = 0;
    size_t rval = (size_t)strcspn((char*)ptr0, (char*)ptr1);
    rarg = (jlong)rval;
    return rarg;
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_BytePointer_strspn(JNIEnv* env, jclass cls, jobject arg0, jobject arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jlong rarg = 0;
    size_t rval = (size_t)strspn((char*)ptr0, (char*)ptr1);
    rarg = (jlong)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strpbrk(JNIEnv* env, jclass cls, jobject arg0, jobject arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strpbrk((char*)ptr0, (char*)ptr1);
    if (rptr == (char*)ptr0) {
        rarg = arg0;
    } else if (rptr == (char*)ptr1) {
        rarg = arg1;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 2);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strstr(JNIEnv* env, jclass cls, jobject arg0, jobject arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strstr((char*)ptr0, (char*)ptr1);
    if (rptr == (char*)ptr0) {
        rarg = arg0;
    } else if (rptr == (char*)ptr1) {
        rarg = arg1;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 2);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strtok(JNIEnv* env, jclass cls, jobject arg0, jobject arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strtok((char*)ptr0, (char*)ptr1);
    if (rptr == (char*)ptr0) {
        rarg = arg0;
    } else if (rptr == (char*)ptr1) {
        rarg = arg1;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 2);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_BytePointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    signed char* rptr = new (std::nothrow) signed char[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_BytePointer_deallocateArray);
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_getPointerValue(JNIEnv* env, jobject obj, jlong arg0) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = NULL;
    void* rptr;
    rptr = (void*)*(void**)&ptr[arg0];
    if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_putPointerValue(JNIEnv* env, jobject obj, jlong arg0, jobject arg1) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    char* ptr1 = arg1 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = obj;
    *(void**)&ptr[arg0] = ptr1;
    return rarg;
}
JNIEXPORT jboolean JNICALL Java_org_bytedeco_javacpp_BytePointer_getBool(JNIEnv* env, jobject obj, jlong arg0) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jboolean rarg = 0;
    bool rval = (bool)*(bool*)&ptr[arg0];
    rarg = (jboolean)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_putBool(JNIEnv* env, jobject obj, jlong arg0, jboolean arg1) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    *(bool*)&ptr[arg0] = arg1;
    return rarg;
}
JNIEXPORT jbyte JNICALL Java_org_bytedeco_javacpp_BytePointer_get__J(JNIEnv* env, jobject obj, jlong arg0) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jbyte rarg = 0;
    signed char rval = ptr[arg0];
    rarg = (jbyte)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_get___3BII(JNIEnv* env, jobject obj, jbyteArray arg0, jint arg1, jint arg2) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    signed char* ptr0 = arg0 == NULL ? NULL : (jbyte*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr0 + arg1, ptr, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_put___3BII(JNIEnv* env, jobject obj, jbyteArray arg0, jint arg1, jint arg2) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    signed char* ptr0 = arg0 == NULL ? NULL : (jbyte*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr, ptr0 + arg1, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_put__JB(JNIEnv* env, jobject obj, jlong arg0, jbyte arg1) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = arg1;
    return rarg;
}
JNIEXPORT jshort JNICALL Java_org_bytedeco_javacpp_BytePointer_getShort(JNIEnv* env, jobject obj, jlong arg0) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jshort rarg = 0;
    short rval = (short)*(short*)&ptr[arg0];
    rarg = (jshort)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_putShort(JNIEnv* env, jobject obj, jlong arg0, jshort arg1) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    *(short*)&ptr[arg0] = arg1;
    return rarg;
}
JNIEXPORT jchar JNICALL Java_org_bytedeco_javacpp_BytePointer_getChar(JNIEnv* env, jobject obj, jlong arg0) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jchar rarg = 0;
    short rval = (short)*(short*)&ptr[arg0];
    rarg = (jchar)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_putChar(JNIEnv* env, jobject obj, jlong arg0, jchar arg1) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    *(short*)&ptr[arg0] = arg1;
    return rarg;
}
JNIEXPORT jint JNICALL Java_org_bytedeco_javacpp_BytePointer_getInt(JNIEnv* env, jobject obj, jlong arg0) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jint rarg = 0;
    int rval = (int)*(int*)&ptr[arg0];
    rarg = (jint)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_putInt(JNIEnv* env, jobject obj, jlong arg0, jint arg1) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    *(int*)&ptr[arg0] = arg1;
    return rarg;
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_BytePointer_getLong(JNIEnv* env, jobject obj, jlong arg0) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jlong rarg = 0;
    long long rval = (long long)*(long long*)&ptr[arg0];
    rarg = (jlong)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_putLong(JNIEnv* env, jobject obj, jlong arg0, jlong arg1) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    *(long long*)&ptr[arg0] = arg1;
    return rarg;
}
JNIEXPORT jfloat JNICALL Java_org_bytedeco_javacpp_BytePointer_getFloat(JNIEnv* env, jobject obj, jlong arg0) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jfloat rarg = 0;
    float rval = (float)*(float*)&ptr[arg0];
    rarg = (jfloat)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_putFloat(JNIEnv* env, jobject obj, jlong arg0, jfloat arg1) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    *(float*)&ptr[arg0] = arg1;
    return rarg;
}
JNIEXPORT jdouble JNICALL Java_org_bytedeco_javacpp_BytePointer_getDouble(JNIEnv* env, jobject obj, jlong arg0) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jdouble rarg = 0;
    double rval = (double)*(double*)&ptr[arg0];
    rarg = (jdouble)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_putDouble(JNIEnv* env, jobject obj, jlong arg0, jdouble arg1) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    *(double*)&ptr[arg0] = arg1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_ShortPointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    short* rptr = new (std::nothrow) short[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_ShortPointer_deallocateArray);
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_ShortPointer_get___3SII(JNIEnv* env, jobject obj, jshortArray arg0, jint arg1, jint arg2) {
    short* ptr = (short*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    short* ptr0 = arg0 == NULL ? NULL : (jshort*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr0 + arg1, ptr, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jshort JNICALL Java_org_bytedeco_javacpp_ShortPointer_get__J(JNIEnv* env, jobject obj, jlong arg0) {
    short* ptr = (short*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jshort rarg = 0;
    short rval = ptr[arg0];
    rarg = (jshort)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_ShortPointer_put___3SII(JNIEnv* env, jobject obj, jshortArray arg0, jint arg1, jint arg2) {
    short* ptr = (short*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    short* ptr0 = arg0 == NULL ? NULL : (jshort*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr, ptr0 + arg1, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_ShortPointer_put__JS(JNIEnv* env, jobject obj, jlong arg0, jshort arg1) {
    short* ptr = (short*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = arg1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_IntPointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    int* rptr = new (std::nothrow) int[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_IntPointer_deallocateArray);
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_IntPointer_get___3III(JNIEnv* env, jobject obj, jintArray arg0, jint arg1, jint arg2) {
    int* ptr = (int*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    int* ptr0 = arg0 == NULL ? NULL : (jint*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr0 + arg1, ptr, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jint JNICALL Java_org_bytedeco_javacpp_IntPointer_get__J(JNIEnv* env, jobject obj, jlong arg0) {
    int* ptr = (int*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jint rarg = 0;
    int rval = ptr[arg0];
    rarg = (jint)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_IntPointer_put___3III(JNIEnv* env, jobject obj, jintArray arg0, jint arg1, jint arg2) {
    int* ptr = (int*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    int* ptr0 = arg0 == NULL ? NULL : (jint*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr, ptr0 + arg1, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_IntPointer_put__JI(JNIEnv* env, jobject obj, jlong arg0, jint arg1) {
    int* ptr = (int*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = arg1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_LongPointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    jlong* rptr = new (std::nothrow) jlong[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_LongPointer_deallocateArray);
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_LongPointer_get___3JII(JNIEnv* env, jobject obj, jlongArray arg0, jint arg1, jint arg2) {
    jlong* ptr = (jlong*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jlong* ptr0 = arg0 == NULL ? NULL : (jlong*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr0 + arg1, ptr, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_LongPointer_get__J(JNIEnv* env, jobject obj, jlong arg0) {
    jlong* ptr = (jlong*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jlong rarg = 0;
    jlong rval = ptr[arg0];
    rarg = (jlong)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_LongPointer_put___3JII(JNIEnv* env, jobject obj, jlongArray arg0, jint arg1, jint arg2) {
    jlong* ptr = (jlong*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jlong* ptr0 = arg0 == NULL ? NULL : (jlong*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr, ptr0 + arg1, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_LongPointer_put__JJ(JNIEnv* env, jobject obj, jlong arg0, jlong arg1) {
    jlong* ptr = (jlong*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = arg1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_FloatPointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    float* rptr = new (std::nothrow) float[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_FloatPointer_deallocateArray);
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_FloatPointer_get___3FII(JNIEnv* env, jobject obj, jfloatArray arg0, jint arg1, jint arg2) {
    float* ptr = (float*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    float* ptr0 = arg0 == NULL ? NULL : (jfloat*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr0 + arg1, ptr, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jfloat JNICALL Java_org_bytedeco_javacpp_FloatPointer_get__J(JNIEnv* env, jobject obj, jlong arg0) {
    float* ptr = (float*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jfloat rarg = 0;
    float rval = ptr[arg0];
    rarg = (jfloat)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_FloatPointer_put___3FII(JNIEnv* env, jobject obj, jfloatArray arg0, jint arg1, jint arg2) {
    float* ptr = (float*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    float* ptr0 = arg0 == NULL ? NULL : (jfloat*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr, ptr0 + arg1, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_FloatPointer_put__JF(JNIEnv* env, jobject obj, jlong arg0, jfloat arg1) {
    float* ptr = (float*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = arg1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_DoublePointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    double* rptr = new (std::nothrow) double[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_DoublePointer_deallocateArray);
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_DoublePointer_get___3DII(JNIEnv* env, jobject obj, jdoubleArray arg0, jint arg1, jint arg2) {
    double* ptr = (double*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    double* ptr0 = arg0 == NULL ? NULL : (jdouble*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr0 + arg1, ptr, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jdouble JNICALL Java_org_bytedeco_javacpp_DoublePointer_get__J(JNIEnv* env, jobject obj, jlong arg0) {
    double* ptr = (double*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jdouble rarg = 0;
    double rval = ptr[arg0];
    rarg = (jdouble)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_DoublePointer_put___3DII(JNIEnv* env, jobject obj, jdoubleArray arg0, jint arg1, jint arg2) {
    double* ptr = (double*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    double* ptr0 = arg0 == NULL ? NULL : (jdouble*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr, ptr0 + arg1, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_DoublePointer_put__JD(JNIEnv* env, jobject obj, jlong arg0, jdouble arg1) {
    double* ptr = (double*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = arg1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_CharPointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    unsigned short* rptr = new (std::nothrow) unsigned short[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_CharPointer_deallocateArray);
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_CharPointer_get___3CII(JNIEnv* env, jobject obj, jcharArray arg0, jint arg1, jint arg2) {
    unsigned short* ptr = (unsigned short*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    unsigned short* ptr0 = arg0 == NULL ? NULL : (jchar*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr0 + arg1, ptr, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jchar JNICALL Java_org_bytedeco_javacpp_CharPointer_get__J(JNIEnv* env, jobject obj, jlong arg0) {
    unsigned short* ptr = (unsigned short*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jchar rarg = 0;
    unsigned short rval = ptr[arg0];
    rarg = (jchar)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_CharPointer_put___3CII(JNIEnv* env, jobject obj, jcharArray arg0, jint arg1, jint arg2) {
    unsigned short* ptr = (unsigned short*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    unsigned short* ptr0 = arg0 == NULL ? NULL : (jchar*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr, ptr0 + arg1, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_CharPointer_put__JC(JNIEnv* env, jobject obj, jlong arg0, jchar arg1) {
    unsigned short* ptr = (unsigned short*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = arg1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_BooleanPointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    unsigned char* rptr = new (std::nothrow) unsigned char[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_BooleanPointer_deallocateArray);
}
JNIEXPORT jboolean JNICALL Java_org_bytedeco_javacpp_BooleanPointer_get__J(JNIEnv* env, jobject obj, jlong arg0) {
    unsigned char* ptr = (unsigned char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jboolean rarg = 0;
    unsigned char rval = ptr[arg0];
    rarg = (jboolean)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BooleanPointer_get___3ZII(JNIEnv* env, jobject obj, jbooleanArray arg0, jint arg1, jint arg2) {
    unsigned char* ptr = (unsigned char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    unsigned char* ptr0 = arg0 == NULL ? NULL : (jboolean*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr0 + arg1, ptr, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BooleanPointer_put___3ZII(JNIEnv* env, jobject obj, jbooleanArray arg0, jint arg1, jint arg2) {
    unsigned char* ptr = (unsigned char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    unsigned char* ptr0 = arg0 == NULL ? NULL : (jboolean*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr, ptr0 + arg1, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BooleanPointer_put__JZ(JNIEnv* env, jobject obj, jlong arg0, jboolean arg1) {
    unsigned char* ptr = (unsigned char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = arg1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_PointerPointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    void** rptr = new (std::nothrow) void*[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_PointerPointer_deallocateArray);
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_PointerPointer_get(JNIEnv* env, jobject obj, jclass arg0, jlong arg1) {
    void** ptr = (void**)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = NULL;
    void* rptr;
    rptr = ptr[arg1];
    if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1, arg0);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_PointerPointer_put(JNIEnv* env, jobject obj, jlong arg0, jobject arg1) {
    void** ptr = (void**)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    char* ptr1 = arg1 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = obj;
    ptr[arg0] = ptr1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_BoolPointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    bool* rptr = new (std::nothrow) bool[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_BoolPointer_deallocateArray);
}
JNIEXPORT jboolean JNICALL Java_org_bytedeco_javacpp_BoolPointer_get(JNIEnv* env, jobject obj, jlong arg0) {
    bool* ptr = (bool*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jboolean rarg = 0;
    bool rval = (bool)*(bool*)&ptr[arg0];
    rarg = (jboolean)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BoolPointer_put(JNIEnv* env, jobject obj, jlong arg0, jboolean arg1) {
    bool* ptr = (bool*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = (bool)arg1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_CLongPointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    long* rptr = new (std::nothrow) long[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_CLongPointer_deallocateArray);
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_CLongPointer_get(JNIEnv* env, jobject obj, jlong arg0) {
    long* ptr = (long*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jlong rarg = 0;
    long rval = (long)*(long*)&ptr[arg0];
    rarg = (jlong)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_CLongPointer_put(JNIEnv* env, jobject obj, jlong arg0, jlong arg1) {
    long* ptr = (long*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = (long)arg1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_SizeTPointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    size_t* rptr = new (std::nothrow) size_t[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_SizeTPointer_deallocateArray);
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_SizeTPointer_get(JNIEnv* env, jobject obj, jlong arg0) {
    size_t* ptr = (size_t*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jlong rarg = 0;
    size_t rval = (size_t)*(size_t*)&ptr[arg0];
    rarg = (jlong)rval;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_SizeTPointer_put(JNIEnv* env, jobject obj, jlong arg0, jlong arg1) {
    size_t* ptr = (size_t*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 20), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = (size_t)arg1;
    return rarg;
}

}

