// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tritonserver.global;

import org.bytedeco.tritonserver.tritonserver.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

public class tritonserver extends org.bytedeco.tritonserver.presets.tritonserver {
    static { Loader.load(); }

// Parsed from tritonserver.h

// Copyright 2020-2023, NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of NVIDIA CORPORATION nor the names of its
//    contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// #pragma once

/** \file */

// #include <stdbool.h>
// #include <stddef.h>
// #include <stdint.h>

// #ifdef __cplusplus
// #endif

// #ifdef _COMPILING_TRITONSERVER
// #if defined(_MSC_VER)
// #define TRITONSERVER_DECLSPEC __declspec(dllexport)
// #elif defined(__GNUC__)
// #define TRITONSERVER_DECLSPEC __attribute__((__visibility__("default")))
// #else
// #define TRITONSERVER_DECLSPEC
// #endif
// #else
// #if defined(_MSC_VER)
// #define TRITONSERVER_DECLSPEC __declspec(dllimport)
// #else
// #define TRITONSERVER_DECLSPEC
// Targeting ../tritonserver/TRITONSERVER_BufferAttributes.java


// Targeting ../tritonserver/TRITONSERVER_Error.java


// Targeting ../tritonserver/TRITONSERVER_InferenceRequest.java


// Targeting ../tritonserver/TRITONSERVER_InferenceResponse.java


// Targeting ../tritonserver/TRITONSERVER_InferenceTrace.java


// Targeting ../tritonserver/TRITONSERVER_Message.java


// Targeting ../tritonserver/TRITONSERVER_Metrics.java


// Targeting ../tritonserver/TRITONSERVER_Parameter.java


// Targeting ../tritonserver/TRITONSERVER_ResponseAllocator.java


// Targeting ../tritonserver/TRITONSERVER_Server.java


// Targeting ../tritonserver/TRITONSERVER_ServerOptions.java


// Targeting ../tritonserver/TRITONSERVER_Metric.java


// Targeting ../tritonserver/TRITONSERVER_MetricFamily.java



/**
 *  TRITONSERVER API Version
 * 
 *  The TRITONSERVER API is versioned with major and minor version
 *  numbers. Any change to the API that does not impact backwards
 *  compatibility (for example, adding a non-required function)
 *  increases the minor version number. Any change that breaks
 *  backwards compatibility (for example, deleting or changing the
 *  behavior of a function) increases the major version number. A
 *  client should check that the API version used to compile the
 *  client is compatible with the API version of the Triton shared
 *  library that it is linking against. This is typically done by code
 *  similar to the following which makes sure that the major versions
 *  are equal and that the minor version of the Triton shared library
 *  is >= the minor version used to build the client.
 * 
 *    uint32_t api_version_major, api_version_minor;
 *    TRITONSERVER_ApiVersion(&api_version_major, &api_version_minor);
 *    if ((api_version_major != TRITONSERVER_API_VERSION_MAJOR) ||
 *        (api_version_minor < TRITONSERVER_API_VERSION_MINOR)) {
 *      return TRITONSERVER_ErrorNew(
 *        TRITONSERVER_ERROR_UNSUPPORTED,
 *        "triton server API version does not support this client");
 *    }
 *  */
public static final int TRITONSERVER_API_VERSION_MAJOR = 1;

///
public static final int TRITONSERVER_API_VERSION_MINOR = 27;

/** Get the TRITONBACKEND API version supported by the Triton shared
 *  library. This value can be compared against the
 *  TRITONSERVER_API_VERSION_MAJOR and TRITONSERVER_API_VERSION_MINOR
 *  used to build the client to ensure that Triton shared library is
 *  compatible with the client.
 * 
 *  @param major Returns the TRITONSERVER API major version supported
 *  by Triton.
 *  @param minor Returns the TRITONSERVER API minor version supported
 *  by Triton.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONSERVER_ApiVersion(
    @Cast("uint32_t*") IntPointer major, @Cast("uint32_t*") IntPointer minor);
public static native TRITONSERVER_Error TRITONSERVER_ApiVersion(
    @Cast("uint32_t*") IntBuffer major, @Cast("uint32_t*") IntBuffer minor);
public static native TRITONSERVER_Error TRITONSERVER_ApiVersion(
    @Cast("uint32_t*") int[] major, @Cast("uint32_t*") int[] minor);

/** TRITONSERVER_DataType
 * 
 *  Tensor data types recognized by TRITONSERVER.
 *  */
/** enum TRITONSERVER_DataType */
public static final int
  TRITONSERVER_TYPE_INVALID = 0,
  TRITONSERVER_TYPE_BOOL = 1,
  TRITONSERVER_TYPE_UINT8 = 2,
  TRITONSERVER_TYPE_UINT16 = 3,
  TRITONSERVER_TYPE_UINT32 = 4,
  TRITONSERVER_TYPE_UINT64 = 5,
  TRITONSERVER_TYPE_INT8 = 6,
  TRITONSERVER_TYPE_INT16 = 7,
  TRITONSERVER_TYPE_INT32 = 8,
  TRITONSERVER_TYPE_INT64 = 9,
  TRITONSERVER_TYPE_FP16 = 10,
  TRITONSERVER_TYPE_FP32 = 11,
  TRITONSERVER_TYPE_FP64 = 12,
  TRITONSERVER_TYPE_BYTES = 13,
  TRITONSERVER_TYPE_BF16 = 14;

/** Get the string representation of a data type. The returned string
 *  is not owned by the caller and so should not be modified or freed.
 * 
 *  @param datatype The data type.
 *  @return The string representation of the data type. */

///
public static native String TRITONSERVER_DataTypeString(
    @Cast("TRITONSERVER_DataType") int datatype);

/** Get the Triton datatype corresponding to a string representation
 *  of a datatype.
 * 
 *  @param dtype The datatype string representation.
 *  @return The Triton data type or TRITONSERVER_TYPE_INVALID if the
 *  string does not represent a data type. */

///
public static native @Cast("TRITONSERVER_DataType") int TRITONSERVER_StringToDataType(String dtype);
public static native @Cast("TRITONSERVER_DataType") int TRITONSERVER_StringToDataType(@Cast("const char*") BytePointer dtype);

/** Get the size of a Triton datatype in bytes. Zero is returned for
 *  TRITONSERVER_TYPE_BYTES because it have variable size. Zero is
 *  returned for TRITONSERVER_TYPE_INVALID.
 * 
 *  @param dtype The datatype.
 *  @return The size of the datatype. */

///
///
public static native @Cast("uint32_t") int TRITONSERVER_DataTypeByteSize(@Cast("TRITONSERVER_DataType") int datatype);

/** TRITONSERVER_MemoryType
 * 
 *  Types of memory recognized by TRITONSERVER.
 *  */
/** enum TRITONSERVER_MemoryType */
public static final int
  TRITONSERVER_MEMORY_CPU = 0,
  TRITONSERVER_MEMORY_CPU_PINNED = 1,
  TRITONSERVER_MEMORY_GPU = 2;

/** Get the string representation of a memory type. The returned
 *  string is not owned by the caller and so should not be modified or
 *  freed.
 * 
 *  @param memtype The memory type.
 *  @return The string representation of the memory type. */

///
///
public static native String TRITONSERVER_MemoryTypeString(
    @Cast("TRITONSERVER_MemoryType") int memtype);

/** TRITONSERVER_ParameterType
 * 
 *  Types of parameters recognized by TRITONSERVER.
 *  */
/** enum TRITONSERVER_ParameterType */
public static final int
  TRITONSERVER_PARAMETER_STRING = 0,
  TRITONSERVER_PARAMETER_INT = 1,
  TRITONSERVER_PARAMETER_BOOL = 2,
  TRITONSERVER_PARAMETER_BYTES = 3;

/** Get the string representation of a parameter type. The returned
 *  string is not owned by the caller and so should not be modified or
 *  freed.
 * 
 *  @param paramtype The parameter type.
 *  @return The string representation of the parameter type. */

///
public static native String TRITONSERVER_ParameterTypeString(
    @Cast("TRITONSERVER_ParameterType") int paramtype);

/** Create a new parameter object. The caller takes ownership of the
 *  TRITONSERVER_Parameter object and must call TRITONSERVER_ParameterDelete to
 *  release the object. The object will maintain its own copy of the 'value'
 * 
 *  @param name The parameter name.
 *  @param type The parameter type.
 *  @param value The pointer to the value.
 *  @return A new TRITONSERVER_Parameter object. 'nullptr' will be returned if
 *  'type' is 'TRITONSERVER_PARAMETER_BYTES'. The caller should use
 *  TRITONSERVER_ParameterBytesNew to create parameter with bytes type. */

///
public static native TRITONSERVER_Parameter TRITONSERVER_ParameterNew(
    String name, @Cast("const TRITONSERVER_ParameterType") int type, @Const Pointer value);
public static native TRITONSERVER_Parameter TRITONSERVER_ParameterNew(
    @Cast("const char*") BytePointer name, @Cast("const TRITONSERVER_ParameterType") int type, @Const Pointer value);

/** Create a new parameter object with type TRITONSERVER_PARAMETER_BYTES.
 *  The caller takes ownership of the TRITONSERVER_Parameter object and must
 *  call TRITONSERVER_ParameterDelete to release the object. The object only
 *  maintains a shallow copy of the 'byte_ptr' so the data content must be
 *  valid until the parameter object is deleted.
 * 
 *  @param name The parameter name.
 *  @param byte_ptr The pointer to the data content.
 *  @param size The size of the data content.
 *  @return A new TRITONSERVER_Error object. */

///
public static native TRITONSERVER_Parameter TRITONSERVER_ParameterBytesNew(
    String name, @Const Pointer byte_ptr, @Cast("const uint64_t") long size);
public static native TRITONSERVER_Parameter TRITONSERVER_ParameterBytesNew(
    @Cast("const char*") BytePointer name, @Const Pointer byte_ptr, @Cast("const uint64_t") long size);

/** Delete an parameter object.
 * 
 *  @param parameter The parameter object. */

///
///
public static native void TRITONSERVER_ParameterDelete(
    TRITONSERVER_Parameter parameter);

/** TRITONSERVER_InstanceGroupKind
 * 
 *  Kinds of instance groups recognized by TRITONSERVER.
 *  */
/** enum TRITONSERVER_InstanceGroupKind */
public static final int
  TRITONSERVER_INSTANCEGROUPKIND_AUTO = 0,
  TRITONSERVER_INSTANCEGROUPKIND_CPU = 1,
  TRITONSERVER_INSTANCEGROUPKIND_GPU = 2,
  TRITONSERVER_INSTANCEGROUPKIND_MODEL = 3;

/** Get the string representation of an instance-group kind. The
 *  returned string is not owned by the caller and so should not be
 *  modified or freed.
 * 
 *  @param kind The instance-group kind.
 *  @return The string representation of the kind. */

///
///
public static native String TRITONSERVER_InstanceGroupKindString(
    @Cast("TRITONSERVER_InstanceGroupKind") int kind);

/** TRITONSERVER_Logging
 * 
 *  Types/levels of logging.
 *  */
/** enum TRITONSERVER_LogLevel */
public static final int
  TRITONSERVER_LOG_INFO = 0,
  TRITONSERVER_LOG_WARN = 1,
  TRITONSERVER_LOG_ERROR = 2,
  TRITONSERVER_LOG_VERBOSE = 3;

/**
 *  Format of logging.
 * 
 *  TRITONSERVER_LOG_DEFAULT: the log severity (L) and timestamp will be
 *  logged as "LMMDD hh:mm:ss.ssssss".
 * 
 *  TRITONSERVER_LOG_ISO8601: the log format will be "YYYY-MM-DDThh:mm:ssZ L".
 *  */
/** enum TRITONSERVER_LogFormat */
public static final int
  TRITONSERVER_LOG_DEFAULT = 0,
  TRITONSERVER_LOG_ISO8601 = 1;

/** Is a log level enabled?
 * 
 *  @param level The log level.
 *  @return True if the log level is enabled, false if not enabled. */

///
public static native @Cast("bool") boolean TRITONSERVER_LogIsEnabled(
    @Cast("TRITONSERVER_LogLevel") int level);

/** Log a message at a given log level if that level is enabled.
 * 
 *  @param level The log level.
 *  @param filename The file name of the location of the log message.
 *  @param line The line number of the log message.
 *  @param msg The log message.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONSERVER_LogMessage(
    @Cast("TRITONSERVER_LogLevel") int level, String filename, int line,
    String msg);
public static native TRITONSERVER_Error TRITONSERVER_LogMessage(
    @Cast("TRITONSERVER_LogLevel") int level, @Cast("const char*") BytePointer filename, int line,
    @Cast("const char*") BytePointer msg);

/** TRITONSERVER_Error
 * 
 *  Errors are reported by a TRITONSERVER_Error object. A NULL
 *  TRITONSERVER_Error indicates no error, a non-NULL TRITONSERVER_Error
 *  indicates error and the code and message for the error can be
 *  retrieved from the object.
 * 
 *  The caller takes ownership of a TRITONSERVER_Error object returned by
 *  the API and must call TRITONSERVER_ErrorDelete to release the object.
 * 
 <p>
 *  The TRITONSERVER_Error error codes */
/** enum TRITONSERVER_Error_Code */
public static final int
  TRITONSERVER_ERROR_UNKNOWN = 0,
  TRITONSERVER_ERROR_INTERNAL = 1,
  TRITONSERVER_ERROR_NOT_FOUND = 2,
  TRITONSERVER_ERROR_INVALID_ARG = 3,
  TRITONSERVER_ERROR_UNAVAILABLE = 4,
  TRITONSERVER_ERROR_UNSUPPORTED = 5,
  TRITONSERVER_ERROR_ALREADY_EXISTS = 6,
  TRITONSERVER_ERROR_CANCELLED = 7;

/** Create a new error object. The caller takes ownership of the
 *  TRITONSERVER_Error object and must call TRITONSERVER_ErrorDelete to
 *  release the object.
 * 
 *  @param code The error code.
 *  @param msg The error message.
 *  @return A new TRITONSERVER_Error object. */

///
public static native TRITONSERVER_Error TRITONSERVER_ErrorNew(
    @Cast("TRITONSERVER_Error_Code") int code, String msg);
public static native TRITONSERVER_Error TRITONSERVER_ErrorNew(
    @Cast("TRITONSERVER_Error_Code") int code, @Cast("const char*") BytePointer msg);

/** Delete an error object.
 * 
 *  @param error The error object. */

///
public static native void TRITONSERVER_ErrorDelete(
    TRITONSERVER_Error error);

/** Get the error code.
 * 
 *  @param error The error object.
 *  @return The error code. */

///
public static native @Cast("TRITONSERVER_Error_Code") int TRITONSERVER_ErrorCode(TRITONSERVER_Error error);

/** Get the string representation of an error code. The returned
 *  string is not owned by the caller and so should not be modified or
 *  freed. The lifetime of the returned string extends only as long as
 *  'error' and must not be accessed once 'error' is deleted.
 * 
 *  @param error The error object.
 *  @return The string representation of the error code. */

///
public static native String TRITONSERVER_ErrorCodeString(
    TRITONSERVER_Error error);

/** Get the error message. The returned string is not owned by the
 *  caller and so should not be modified or freed. The lifetime of the
 *  returned string extends only as long as 'error' and must not be
 *  accessed once 'error' is deleted.
 * 
 *  @param error The error object.
 *  @return The error message. */

///
///
///
public static native String TRITONSERVER_ErrorMessage(
    TRITONSERVER_Error error);
// Targeting ../tritonserver/TRITONSERVER_ResponseAllocatorAllocFn_t.java


// Targeting ../tritonserver/TRITONSERVER_ResponseAllocatorBufferAttributesFn_t.java


// Targeting ../tritonserver/TRITONSERVER_ResponseAllocatorQueryFn_t.java


// Targeting ../tritonserver/TRITONSERVER_ResponseAllocatorReleaseFn_t.java


// Targeting ../tritonserver/TRITONSERVER_ResponseAllocatorStartFn_t.java



/** Create a new response allocator object.
 * 
 *  The response allocator object is used by Triton to allocate
 *  buffers to hold the output tensors in inference responses. Most
 *  models generate a single response for each inference request
 *  (TRITONSERVER_TXN_ONE_TO_ONE). For these models the order of
 *  callbacks will be:
 * 
 *    TRITONSERVER_ServerInferAsync called
 *     - start_fn : optional (and typically not required)
 *     - alloc_fn : called once for each output tensor in response
 *    TRITONSERVER_InferenceResponseDelete called
 *     - release_fn: called once for each output tensor in response
 * 
 *  For models that generate multiple responses for each inference
 *  request (TRITONSERVER_TXN_DECOUPLED), the start_fn callback can be
 *  used to determine sets of alloc_fn callbacks that belong to the
 *  same response:
 * 
 *    TRITONSERVER_ServerInferAsync called
 *     - start_fn
 *     - alloc_fn : called once for each output tensor in response
 *     - start_fn
 *     - alloc_fn : called once for each output tensor in response
 *       ...
 *    For each response, TRITONSERVER_InferenceResponseDelete called
 *     - release_fn: called once for each output tensor in the response
 * 
 *  In all cases the start_fn, alloc_fn and release_fn callback
 *  functions must be thread-safe. Typically making these functions
 *  thread-safe does not require explicit locking. The recommended way
 *  to implement these functions is to have each inference request
 *  provide a 'response_allocator_userp' object that is unique to that
 *  request with TRITONSERVER_InferenceRequestSetResponseCallback. The
 *  callback functions then operate only on this unique state. Locking
 *  is required only when the callback function needs to access state
 *  that is shared across inference requests (for example, a common
 *  allocation pool).
 * 
 *  @param allocator Returns the new response allocator object.
 *  @param alloc_fn The function to call to allocate buffers for result
 *  tensors.
 *  @param release_fn The function to call when the server no longer
 *  holds a reference to an allocated buffer.
 *  @param start_fn The function to call to indicate that the
 *  subsequent 'alloc_fn' calls are for a new response. This callback
 *  is optional (use nullptr to indicate that it should not be
 *  invoked).
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONSERVER_ResponseAllocatorNew(
    @Cast("TRITONSERVER_ResponseAllocator**") PointerPointer allocator,
    TRITONSERVER_ResponseAllocatorAllocFn_t alloc_fn,
    TRITONSERVER_ResponseAllocatorReleaseFn_t release_fn,
    TRITONSERVER_ResponseAllocatorStartFn_t start_fn);
public static native TRITONSERVER_Error TRITONSERVER_ResponseAllocatorNew(
    @ByPtrPtr TRITONSERVER_ResponseAllocator allocator,
    TRITONSERVER_ResponseAllocatorAllocFn_t alloc_fn,
    TRITONSERVER_ResponseAllocatorReleaseFn_t release_fn,
    TRITONSERVER_ResponseAllocatorStartFn_t start_fn);

/** Set the buffer attributes function for a response allocator object.
 *  The function will be called after alloc_fn to set the buffer attributes
 *  associated with the output buffer.
 * 
 *  The thread-safy requirement for buffer_attributes_fn is the same as other
 *  allocator callbacks.
 * 
 *  @param allocator The response allocator object.
 *  @param buffer_attributes_fn The function to call to get the buffer
 *  attributes information for an allocated buffer.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONSERVER_ResponseAllocatorSetBufferAttributesFunction(
    TRITONSERVER_ResponseAllocator allocator,
    TRITONSERVER_ResponseAllocatorBufferAttributesFn_t buffer_attributes_fn);

/** Set the query function to a response allocator object. Usually the
 *  function will be called before alloc_fn to understand what is the
 *  allocator's preferred memory type and memory type ID at the current
 *  situation to make different execution decision.
 * 
 *  The thread-safy requirement for query_fn is the same as other allocator
 *  callbacks.
 * 
 *  @param allocator The response allocator object.
 *  @param query_fn The function to call to query allocator's preferred memory
 *  type and memory type ID.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ResponseAllocatorSetQueryFunction(
    TRITONSERVER_ResponseAllocator allocator,
    TRITONSERVER_ResponseAllocatorQueryFn_t query_fn);

/** Delete a response allocator.
 * 
 *  @param allocator The response allocator object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONSERVER_ResponseAllocatorDelete(
    TRITONSERVER_ResponseAllocator allocator);

/** TRITONSERVER_Message
 * 
 *  Object representing a Triton Server message.
 * 
 <p>
 *  Create a new message object from serialized JSON string.
 * 
 *  @param message The message object.
 *  @param base The base of the serialized JSON.
 *  @param byte_size The size, in bytes, of the serialized message.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_MessageNewFromSerializedJson(
    @Cast("TRITONSERVER_Message**") PointerPointer message, String base, @Cast("size_t") long byte_size);
public static native TRITONSERVER_Error TRITONSERVER_MessageNewFromSerializedJson(
    @ByPtrPtr TRITONSERVER_Message message, String base, @Cast("size_t") long byte_size);
public static native TRITONSERVER_Error TRITONSERVER_MessageNewFromSerializedJson(
    @ByPtrPtr TRITONSERVER_Message message, @Cast("const char*") BytePointer base, @Cast("size_t") long byte_size);

/** Delete a message object.
 * 
 *  @param message The message object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_MessageDelete(
    TRITONSERVER_Message message);

/** Get the base and size of the buffer containing the serialized
 *  message in JSON format. The buffer is owned by the
 *  TRITONSERVER_Message object and should not be modified or freed by
 *  the caller. The lifetime of the buffer extends only as long as
 *  'message' and must not be accessed once 'message' is deleted.
 * 
 *  @param message The message object.
 *  @param base Returns the base of the serialized message.
 *  @param byte_size Returns the size, in bytes, of the serialized
 *  message.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONSERVER_MessageSerializeToJson(
    TRITONSERVER_Message message, @Cast("const char**") PointerPointer base, @Cast("size_t*") SizeTPointer byte_size);
public static native TRITONSERVER_Error TRITONSERVER_MessageSerializeToJson(
    TRITONSERVER_Message message, @Cast("const char**") @ByPtrPtr BytePointer base, @Cast("size_t*") SizeTPointer byte_size);
public static native TRITONSERVER_Error TRITONSERVER_MessageSerializeToJson(
    TRITONSERVER_Message message, @Cast("const char**") @ByPtrPtr ByteBuffer base, @Cast("size_t*") SizeTPointer byte_size);
public static native TRITONSERVER_Error TRITONSERVER_MessageSerializeToJson(
    TRITONSERVER_Message message, @Cast("const char**") @ByPtrPtr byte[] base, @Cast("size_t*") SizeTPointer byte_size);

/** TRITONSERVER_Metrics
 * 
 *  Object representing metrics.
 * 
 <p>
 *  Metric format types */
/** enum TRITONSERVER_MetricFormat */
public static final int
  TRITONSERVER_METRIC_PROMETHEUS = 0;

/** Delete a metrics object.
 * 
 *  @param metrics The metrics object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONSERVER_MetricsDelete(
    TRITONSERVER_Metrics metrics);

/** Get a buffer containing the metrics in the specified format. For
 *  each format the buffer contains the following:
 * 
 *    TRITONSERVER_METRIC_PROMETHEUS: 'base' points to a single multiline
 *    string (char*) that gives a text representation of the metrics in
 *    prometheus format. 'byte_size' returns the length of the string
 *    in bytes.
 * 
 *  The buffer is owned by the 'metrics' object and should not be
 *  modified or freed by the caller. The lifetime of the buffer
 *  extends only as long as 'metrics' and must not be accessed once
 *  'metrics' is deleted.
 * 
 *  @param metrics The metrics object.
 *  @param format The format to use for the returned metrics.
 *  @param base Returns a pointer to the base of the formatted
 *  metrics, as described above.
 *  @param byte_size Returns the size, in bytes, of the formatted
 *  metrics.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
///
public static native TRITONSERVER_Error TRITONSERVER_MetricsFormatted(
    TRITONSERVER_Metrics metrics, @Cast("TRITONSERVER_MetricFormat") int format,
    @Cast("const char**") PointerPointer base, @Cast("size_t*") SizeTPointer byte_size);
public static native TRITONSERVER_Error TRITONSERVER_MetricsFormatted(
    TRITONSERVER_Metrics metrics, @Cast("TRITONSERVER_MetricFormat") int format,
    @Cast("const char**") @ByPtrPtr BytePointer base, @Cast("size_t*") SizeTPointer byte_size);
public static native TRITONSERVER_Error TRITONSERVER_MetricsFormatted(
    TRITONSERVER_Metrics metrics, @Cast("TRITONSERVER_MetricFormat") int format,
    @Cast("const char**") @ByPtrPtr ByteBuffer base, @Cast("size_t*") SizeTPointer byte_size);
public static native TRITONSERVER_Error TRITONSERVER_MetricsFormatted(
    TRITONSERVER_Metrics metrics, @Cast("TRITONSERVER_MetricFormat") int format,
    @Cast("const char**") @ByPtrPtr byte[] base, @Cast("size_t*") SizeTPointer byte_size);

/** TRITONSERVER_InferenceTrace
 * 
 *  Object that represents tracing for an inference request.
 * 
 <p>
 *  Trace levels. The trace level controls the type of trace
 *  activities that are reported for an inference request.
 * 
 *  Trace level values are power-of-2 and can be combined to trace
 *  multiple types of activities. For example, use
 *  (TRITONSERVER_TRACE_LEVEL_TIMESTAMPS |
 *  TRITONSERVER_TRACE_LEVEL_TENSORS) to trace both timestamps and
 *  tensors for an inference request.
 * 
 *  TRITONSERVER_TRACE_LEVEL_MIN and TRITONSERVER_TRACE_LEVEL_MAX are
 *  deprecated and should not be used. */
/** enum TRITONSERVER_InferenceTraceLevel */
public static final int
  /** Tracing disabled. No trace activities are reported. */
  TRITONSERVER_TRACE_LEVEL_DISABLED = 0,
  /** Deprecated. Use TRITONSERVER_TRACE_LEVEL_TIMESTAMPS. */
  TRITONSERVER_TRACE_LEVEL_MIN = 1,
  /** Deprecated. Use TRITONSERVER_TRACE_LEVEL_TIMESTAMPS. */
  TRITONSERVER_TRACE_LEVEL_MAX = 2,
  /** Record timestamps for the inference request. */
  TRITONSERVER_TRACE_LEVEL_TIMESTAMPS = 0x4,
  /** Record input and output tensor values for the inference request. */
  TRITONSERVER_TRACE_LEVEL_TENSORS = 0x8;

/** Get the string representation of a trace level. The returned
 *  string is not owned by the caller and so should not be modified or
 *  freed.
 * 
 *  @param level The trace level.
 *  @return The string representation of the trace level. */
public static native String TRITONSERVER_InferenceTraceLevelString(
    @Cast("TRITONSERVER_InferenceTraceLevel") int level);

/** Trace activities */
/** enum TRITONSERVER_InferenceTraceActivity */
public static final int
  TRITONSERVER_TRACE_REQUEST_START = 0,
  TRITONSERVER_TRACE_QUEUE_START = 1,
  TRITONSERVER_TRACE_COMPUTE_START = 2,
  TRITONSERVER_TRACE_COMPUTE_INPUT_END = 3,
  TRITONSERVER_TRACE_COMPUTE_OUTPUT_START = 4,
  TRITONSERVER_TRACE_COMPUTE_END = 5,
  TRITONSERVER_TRACE_REQUEST_END = 6,
  TRITONSERVER_TRACE_TENSOR_QUEUE_INPUT = 7,
  TRITONSERVER_TRACE_TENSOR_BACKEND_INPUT = 8,
  TRITONSERVER_TRACE_TENSOR_BACKEND_OUTPUT = 9;

/** Get the string representation of a trace activity. The returned
 *  string is not owned by the caller and so should not be modified or
 *  freed.
 * 
 *  @param activity The trace activity.
 *  @return The string representation of the trace activity. */
public static native String TRITONSERVER_InferenceTraceActivityString(
    @Cast("TRITONSERVER_InferenceTraceActivity") int activity);
// Targeting ../tritonserver/TRITONSERVER_InferenceTraceActivityFn_t.java


// Targeting ../tritonserver/TRITONSERVER_InferenceTraceTensorActivityFn_t.java


// Targeting ../tritonserver/TRITONSERVER_InferenceTraceReleaseFn_t.java



/** Create a new inference trace object. The caller takes ownership of
 *  the TRITONSERVER_InferenceTrace object and must call
 *  TRITONSERVER_InferenceTraceDelete to release the object.
 * 
 *  The activity callback function will be called to report activity
 *  for 'trace' as well as for any child traces that are spawned by
 *  'trace', and so the activity callback must check the trace object
 *  to determine specifically what activity is being reported.
 * 
 *  The release callback is called for both 'trace' and for any child
 *  traces spawned by 'trace'.
 * 
 *  @param trace Returns the new inference trace object.
 *  @param level The tracing level.
 *  @param parent_id The parent trace id for this trace. A value of 0
 *  indicates that there is not parent trace.
 *  @param activity_fn The callback function where activity for the
 *  trace is reported.
 *  @param release_fn The callback function called when all activity
 *  is complete for the trace.
 *  @param trace_userp User-provided pointer that is delivered to
 *  the activity and release callback functions.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceNew(
    @Cast("TRITONSERVER_InferenceTrace**") PointerPointer trace,
    @Cast("TRITONSERVER_InferenceTraceLevel") int level, @Cast("uint64_t") long parent_id,
    TRITONSERVER_InferenceTraceActivityFn_t activity_fn,
    TRITONSERVER_InferenceTraceReleaseFn_t release_fn, Pointer trace_userp);
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceNew(
    @ByPtrPtr TRITONSERVER_InferenceTrace trace,
    @Cast("TRITONSERVER_InferenceTraceLevel") int level, @Cast("uint64_t") long parent_id,
    TRITONSERVER_InferenceTraceActivityFn_t activity_fn,
    TRITONSERVER_InferenceTraceReleaseFn_t release_fn, Pointer trace_userp);

/** Create a new inference trace object. The caller takes ownership of
 *  the TRITONSERVER_InferenceTrace object and must call
 *  TRITONSERVER_InferenceTraceDelete to release the object.
 * 
 *  The timeline and tensor activity callback function will be called to report
 *  activity for 'trace' as well as for any child traces that are spawned by
 *  'trace', and so the activity callback must check the trace object
 *  to determine specifically what activity is being reported.
 * 
 *  The release callback is called for both 'trace' and for any child
 *  traces spawned by 'trace'.
 * 
 *  @param trace Returns the new inference trace object.
 *  @param level The tracing level.
 *  @param parent_id The parent trace id for this trace. A value of 0
 *  indicates that there is not parent trace.
 *  @param activity_fn The callback function where timeline activity for the
 *  trace is reported.
 *  @param tensor_activity_fn The callback function where tensor activity for
 *  the trace is reported.
 *  @param release_fn The callback function called when all activity
 *  is complete for the trace.
 *  @param trace_userp User-provided pointer that is delivered to
 *  the activity and release callback functions.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceTensorNew(
    @Cast("TRITONSERVER_InferenceTrace**") PointerPointer trace,
    @Cast("TRITONSERVER_InferenceTraceLevel") int level, @Cast("uint64_t") long parent_id,
    TRITONSERVER_InferenceTraceActivityFn_t activity_fn,
    TRITONSERVER_InferenceTraceTensorActivityFn_t tensor_activity_fn,
    TRITONSERVER_InferenceTraceReleaseFn_t release_fn, Pointer trace_userp);
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceTensorNew(
    @ByPtrPtr TRITONSERVER_InferenceTrace trace,
    @Cast("TRITONSERVER_InferenceTraceLevel") int level, @Cast("uint64_t") long parent_id,
    TRITONSERVER_InferenceTraceActivityFn_t activity_fn,
    TRITONSERVER_InferenceTraceTensorActivityFn_t tensor_activity_fn,
    TRITONSERVER_InferenceTraceReleaseFn_t release_fn, Pointer trace_userp);

/** Delete a trace object.
 * 
 *  @param trace The trace object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceDelete(TRITONSERVER_InferenceTrace trace);

/** Get the id associated with a trace. Every trace is assigned an id
 *  that is unique across all traces created for a Triton server.
 * 
 *  @param trace The trace.
 *  @param id Returns the id associated with the trace.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceId(
    TRITONSERVER_InferenceTrace trace, @Cast("uint64_t*") LongPointer id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceId(
    TRITONSERVER_InferenceTrace trace, @Cast("uint64_t*") LongBuffer id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceId(
    TRITONSERVER_InferenceTrace trace, @Cast("uint64_t*") long[] id);

/** Get the parent id associated with a trace. The parent id indicates
 *  a parent-child relationship between two traces. A parent id value
 *  of 0 indicates that there is no parent trace.
 * 
 *  @param trace The trace.
 *  @param id Returns the parent id associated with the trace.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceParentId(
    TRITONSERVER_InferenceTrace trace, @Cast("uint64_t*") LongPointer parent_id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceParentId(
    TRITONSERVER_InferenceTrace trace, @Cast("uint64_t*") LongBuffer parent_id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceParentId(
    TRITONSERVER_InferenceTrace trace, @Cast("uint64_t*") long[] parent_id);

/** Get the name of the model associated with a trace. The caller does
 *  not own the returned string and must not modify or delete it. The
 *  lifetime of the returned string extends only as long as 'trace'.
 * 
 *  @param trace The trace.
 *  @param model_name Returns the name of the model associated with
 *  the trace.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceModelName(
    TRITONSERVER_InferenceTrace trace, @Cast("const char**") PointerPointer model_name);
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceModelName(
    TRITONSERVER_InferenceTrace trace, @Cast("const char**") @ByPtrPtr BytePointer model_name);
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceModelName(
    TRITONSERVER_InferenceTrace trace, @Cast("const char**") @ByPtrPtr ByteBuffer model_name);
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceModelName(
    TRITONSERVER_InferenceTrace trace, @Cast("const char**") @ByPtrPtr byte[] model_name);

/** Get the version of the model associated with a trace.
 * 
 *  @param trace The trace.
 *  @param model_version Returns the version of the model associated
 *  with the trace.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceModelVersion(
    TRITONSERVER_InferenceTrace trace, @Cast("int64_t*") LongPointer model_version);
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceModelVersion(
    TRITONSERVER_InferenceTrace trace, @Cast("int64_t*") LongBuffer model_version);
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceModelVersion(
    TRITONSERVER_InferenceTrace trace, @Cast("int64_t*") long[] model_version);

/** Get the request id associated with a trace. The caller does
 *  not own the returned string and must not modify or delete it. The
 *  lifetime of the returned string extends only as long as 'trace'.
 * 
 *  @param trace The trace.
 *  @param request_id Returns the version of the model associated
 *  with the trace.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceRequestId(
    TRITONSERVER_InferenceTrace trace, @Cast("const char**") PointerPointer request_id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceRequestId(
    TRITONSERVER_InferenceTrace trace, @Cast("const char**") @ByPtrPtr BytePointer request_id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceRequestId(
    TRITONSERVER_InferenceTrace trace, @Cast("const char**") @ByPtrPtr ByteBuffer request_id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceRequestId(
    TRITONSERVER_InferenceTrace trace, @Cast("const char**") @ByPtrPtr byte[] request_id);

/** Get the child trace, spawned from the parent trace. The caller owns
 *  the returned object and must call TRITONSERVER_InferenceTraceDelete
 *  to release the object, unless ownership is transferred through
 *  other APIs (see TRITONSERVER_ServerInferAsync).
 * 
 *  @param trace The trace.
 *  @param child_trace Returns the child trace, spawned from the trace.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceSpawnChildTrace(
    TRITONSERVER_InferenceTrace trace,
    @Cast("TRITONSERVER_InferenceTrace**") PointerPointer child_trace);
public static native TRITONSERVER_Error TRITONSERVER_InferenceTraceSpawnChildTrace(
    TRITONSERVER_InferenceTrace trace,
    @ByPtrPtr TRITONSERVER_InferenceTrace child_trace);

/** TRITONSERVER_InferenceRequest
 * 
 *  Object representing an inference request. The inference request
 *  provides the meta-data and input tensor values needed for an
 *  inference and returns the inference result meta-data and output
 *  tensors. An inference request object can be modified and reused
 *  multiple times.
 * 
 <p>
 *  Inference request flags. The enum values must be power-of-2 values. */
/** enum TRITONSERVER_RequestFlag */
public static final int
  TRITONSERVER_REQUEST_FLAG_SEQUENCE_START = 1,
  TRITONSERVER_REQUEST_FLAG_SEQUENCE_END = 2;

/** Inference request release flags. The enum values must be
 *  power-of-2 values. */
/** enum TRITONSERVER_RequestReleaseFlag */
public static final int
  TRITONSERVER_REQUEST_RELEASE_ALL = 1,
  TRITONSERVER_REQUEST_RELEASE_RESCHEDULE = 2;

/** Inference response complete flags. The enum values must be
 *  power-of-2 values. */
/** enum TRITONSERVER_ResponseCompleteFlag */
public static final int
  TRITONSERVER_RESPONSE_COMPLETE_FINAL = 1;
// Targeting ../tritonserver/TRITONSERVER_InferenceRequestReleaseFn_t.java


// Targeting ../tritonserver/TRITONSERVER_InferenceResponseCompleteFn_t.java



/** Create a new inference request object.
 * 
 *  @param inference_request Returns the new request object.
 *  @param server the inference server object.
 *  @param model_name The name of the model to use for the request.
 *  @param model_version The version of the model to use for the
 *  request. If -1 then the server will choose a version based on the
 *  model's policy.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestNew(
    @Cast("TRITONSERVER_InferenceRequest**") PointerPointer inference_request,
    TRITONSERVER_Server server, String model_name,
    @Cast("const int64_t") long model_version);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestNew(
    @ByPtrPtr TRITONSERVER_InferenceRequest inference_request,
    TRITONSERVER_Server server, String model_name,
    @Cast("const int64_t") long model_version);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestNew(
    @ByPtrPtr TRITONSERVER_InferenceRequest inference_request,
    TRITONSERVER_Server server, @Cast("const char*") BytePointer model_name,
    @Cast("const int64_t") long model_version);

/** Delete an inference request object.
 * 
 *  @param inference_request The request object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestDelete(
    TRITONSERVER_InferenceRequest inference_request);

/** Get the ID for a request. The returned ID is owned by
 *  'inference_request' and must not be modified or freed by the
 *  caller.
 * 
 *  @param inference_request The request object.
 *  @param id Returns the ID.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestId(
    TRITONSERVER_InferenceRequest inference_request, @Cast("const char**") PointerPointer id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestId(
    TRITONSERVER_InferenceRequest inference_request, @Cast("const char**") @ByPtrPtr BytePointer id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestId(
    TRITONSERVER_InferenceRequest inference_request, @Cast("const char**") @ByPtrPtr ByteBuffer id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestId(
    TRITONSERVER_InferenceRequest inference_request, @Cast("const char**") @ByPtrPtr byte[] id);

/** Set the ID for a request.
 * 
 *  @param inference_request The request object.
 *  @param id The ID.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestSetId(
    TRITONSERVER_InferenceRequest inference_request, String id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestSetId(
    TRITONSERVER_InferenceRequest inference_request, @Cast("const char*") BytePointer id);

/** Get the flag(s) associated with a request. On return 'flags' holds
 *  a bitwise-or of all flag values, see TRITONSERVER_RequestFlag for
 *  available flags.
 * 
 *  @param inference_request The request object.
 *  @param flags Returns the flags.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestFlags(
    TRITONSERVER_InferenceRequest inference_request, @Cast("uint32_t*") IntPointer flags);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestFlags(
    TRITONSERVER_InferenceRequest inference_request, @Cast("uint32_t*") IntBuffer flags);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestFlags(
    TRITONSERVER_InferenceRequest inference_request, @Cast("uint32_t*") int[] flags);

/** Set the flag(s) associated with a request. 'flags' should hold a
 *  bitwise-or of all flag values, see TRITONSERVER_RequestFlag for
 *  available flags.
 * 
 *  @param inference_request The request object.
 *  @param flags The flags.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestSetFlags(
    TRITONSERVER_InferenceRequest inference_request, @Cast("uint32_t") int flags);

/** Get the correlation ID of the inference request as an unsigned integer.
 *  Default is 0, which indicates that the request has no correlation ID.
 *  If the correlation id associated with the inference request is a string,
 *  this function will return a failure. The correlation ID is used
 *  to indicate two or more inference request are related to each other.
 *  How this relationship is handled by the inference server is determined by
 *  the model's scheduling policy.
 * 
 *  @param inference_request The request object.
 *  @param correlation_id Returns the correlation ID.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestCorrelationId(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("uint64_t*") LongPointer correlation_id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestCorrelationId(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("uint64_t*") LongBuffer correlation_id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestCorrelationId(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("uint64_t*") long[] correlation_id);

/** Get the correlation ID of the inference request as a string.
 *  Default is empty "", which indicates that the request has no correlation ID.
 *  If the correlation id associated with the inference request is an unsigned
 *  integer, then this function will return a failure. The correlation ID
 *  is used to indicate two or more inference request are related to each other.
 *  How this relationship is handled by the inference server is determined by
 *  the model's scheduling policy.
 * 
 *  @param inference_request The request object.
 *  @param correlation_id Returns the correlation ID.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestCorrelationIdString(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("const char**") PointerPointer correlation_id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestCorrelationIdString(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("const char**") @ByPtrPtr BytePointer correlation_id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestCorrelationIdString(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("const char**") @ByPtrPtr ByteBuffer correlation_id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestCorrelationIdString(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("const char**") @ByPtrPtr byte[] correlation_id);

/** Set the correlation ID of the inference request to be an unsigned integer.
 *  Default is 0, which indicates that the request has no correlation ID.
 *  The correlation ID is used to indicate two or more inference request
 *  are related to each other. How this relationship is handled by the
 *  inference server is determined by the model's scheduling policy.
 * 
 *  @param inference_request The request object.
 *  @param correlation_id The correlation ID.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestSetCorrelationId(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("uint64_t") long correlation_id);

/** Set the correlation ID of the inference request to be a string.
 *  The correlation ID is used to indicate two or more inference
 *  request are related to each other. How this relationship is
 *  handled by the inference server is determined by the model's
 *  scheduling policy.
 * 
 *  @param inference_request The request object.
 *  @param correlation_id The correlation ID.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestSetCorrelationIdString(
    TRITONSERVER_InferenceRequest inference_request,
    String correlation_id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestSetCorrelationIdString(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("const char*") BytePointer correlation_id);

/** Cancel an inference request. Requests are canceled on a best
 *  effort basis and no guarantee is provided that cancelling a
 *  request will result in early termination. Note that the
 *  inference request cancellation status will be reset after
 *  TRITONSERVER_InferAsync is run. This means that if you cancel
 *  the request before calling TRITONSERVER_InferAsync
 *  the request will not be cancelled.
 * 
 *  @param inference_request The request object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestCancel(
    TRITONSERVER_InferenceRequest inference_request);

/** Query whether the request is cancelled or not.
 * 
 *  If possible the backend should terminate any processing and
 *  send an error response with cancelled status.
 * 
 *  @param inference_request The request object.
 *  @param is_cancelled Returns whether the inference request is cancelled or
 *  not.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestIsCancelled(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("bool*") boolean[] is_cancelled);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestIsCancelled(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("bool*") BoolPointer is_cancelled);

/** Deprecated. See TRITONSERVER_InferenceRequestPriorityUInt64 instead.
 * 
 *  Get the priority for a request. The default is 0 indicating that
 *  the request does not specify a priority and so will use the
 *  model's default priority.
 * 
 *  @param inference_request The request object.
 *  @param priority Returns the priority level.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestPriority(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("uint32_t*") IntPointer priority);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestPriority(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("uint32_t*") IntBuffer priority);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestPriority(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("uint32_t*") int[] priority);

/** Get the priority for a request. The default is 0 indicating that
 *  the request does not specify a priority and so will use the
 *  model's default priority.
 * 
 *  @param inference_request The request object.
 *  @param priority Returns the priority level.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestPriorityUInt64(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("uint64_t*") LongPointer priority);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestPriorityUInt64(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("uint64_t*") LongBuffer priority);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestPriorityUInt64(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("uint64_t*") long[] priority);

/** Deprecated. See TRITONSERVER_InferenceRequestSetPriorityUInt64 instead.
 * 
 *  Set the priority for a request. The default is 0 indicating that
 *  the request does not specify a priority and so will use the
 *  model's default priority.
 * 
 *  @param inference_request The request object.
 *  @param priority The priority level.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestSetPriority(
    TRITONSERVER_InferenceRequest inference_request, @Cast("uint32_t") int priority);

/** Set the priority for a request. The default is 0 indicating that
 *  the request does not specify a priority and so will use the
 *  model's default priority.
 * 
 *  @param inference_request The request object.
 *  @param priority The priority level.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestSetPriorityUInt64(
    TRITONSERVER_InferenceRequest inference_request, @Cast("uint64_t") long priority);

/** Get the timeout for a request, in microseconds. The default is 0
 *  which indicates that the request has no timeout.
 * 
 *  @param inference_request The request object.
 *  @param timeout_us Returns the timeout, in microseconds.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestTimeoutMicroseconds(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("uint64_t*") LongPointer timeout_us);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestTimeoutMicroseconds(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("uint64_t*") LongBuffer timeout_us);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestTimeoutMicroseconds(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("uint64_t*") long[] timeout_us);

/** Set the timeout for a request, in microseconds. The default is 0
 *  which indicates that the request has no timeout.
 * 
 *  @param inference_request The request object.
 *  @param timeout_us The timeout, in microseconds.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestSetTimeoutMicroseconds(
    TRITONSERVER_InferenceRequest inference_request,
    @Cast("uint64_t") long timeout_us);

/** Add an input to a request.
 * 
 *  @param inference_request The request object.
 *  @param name The name of the input.
 *  @param datatype The type of the input. Valid type names are BOOL,
 *  UINT8, UINT16, UINT32, UINT64, INT8, INT16, INT32, INT64, FP16,
 *  FP32, FP64, and BYTES.
 *  @param shape The shape of the input.
 *  @param dim_count The number of dimensions of 'shape'.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestAddInput(
    TRITONSERVER_InferenceRequest inference_request, String name,
    @Cast("const TRITONSERVER_DataType") int datatype, @Cast("const int64_t*") LongPointer shape,
    @Cast("uint64_t") long dim_count);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestAddInput(
    TRITONSERVER_InferenceRequest inference_request, @Cast("const char*") BytePointer name,
    @Cast("const TRITONSERVER_DataType") int datatype, @Cast("const int64_t*") LongBuffer shape,
    @Cast("uint64_t") long dim_count);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestAddInput(
    TRITONSERVER_InferenceRequest inference_request, String name,
    @Cast("const TRITONSERVER_DataType") int datatype, @Cast("const int64_t*") long[] shape,
    @Cast("uint64_t") long dim_count);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestAddInput(
    TRITONSERVER_InferenceRequest inference_request, @Cast("const char*") BytePointer name,
    @Cast("const TRITONSERVER_DataType") int datatype, @Cast("const int64_t*") LongPointer shape,
    @Cast("uint64_t") long dim_count);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestAddInput(
    TRITONSERVER_InferenceRequest inference_request, String name,
    @Cast("const TRITONSERVER_DataType") int datatype, @Cast("const int64_t*") LongBuffer shape,
    @Cast("uint64_t") long dim_count);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestAddInput(
    TRITONSERVER_InferenceRequest inference_request, @Cast("const char*") BytePointer name,
    @Cast("const TRITONSERVER_DataType") int datatype, @Cast("const int64_t*") long[] shape,
    @Cast("uint64_t") long dim_count);

/** Add a raw input to a request. The name recognized by the model, data type
 *  and shape of the input will be deduced from model configuration.
 *  This function must be called at most once on request with no other input to
 *  ensure the deduction is accurate.
 * 
 *  @param inference_request The request object.
 *  @param name The name of the input. This name is only used as a reference
 *  of the raw input in other Tritonserver APIs. It doesn't associate with the
 *  name used in the model.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestAddRawInput(
    TRITONSERVER_InferenceRequest inference_request, String name);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestAddRawInput(
    TRITONSERVER_InferenceRequest inference_request, @Cast("const char*") BytePointer name);

/** Remove an input from a request.
 * 
 *  @param inference_request The request object.
 *  @param name The name of the input.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestRemoveInput(
    TRITONSERVER_InferenceRequest inference_request, String name);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestRemoveInput(
    TRITONSERVER_InferenceRequest inference_request, @Cast("const char*") BytePointer name);

/** Remove all inputs from a request.
 * 
 *  @param inference_request The request object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestRemoveAllInputs(
    TRITONSERVER_InferenceRequest inference_request);

/** Assign a buffer of data to an input. The buffer will be appended
 *  to any existing buffers for that input. The 'inference_request'
 *  object takes ownership of the buffer and so the caller should not
 *  modify or free the buffer until that ownership is released by
 *  'inference_request' being deleted or by the input being removed
 *  from 'inference_request'.
 * 
 *  @param inference_request The request object.
 *  @param name The name of the input.
 *  @param base The base address of the input data.
 *  @param byte_size The size, in bytes, of the input data.
 *  @param memory_type The memory type of the input data.
 *  @param memory_type_id The memory type id of the input data.
 *  @return a TRITONSERVER_Error indicating success or failure. */
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestAppendInputData(
    TRITONSERVER_InferenceRequest inference_request, String name,
    @Const Pointer base, @Cast("size_t") long byte_size, @Cast("TRITONSERVER_MemoryType") int memory_type,
    @Cast("int64_t") long memory_type_id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestAppendInputData(
    TRITONSERVER_InferenceRequest inference_request, @Cast("const char*") BytePointer name,
    @Const Pointer base, @Cast("size_t") long byte_size, @Cast("TRITONSERVER_MemoryType") int memory_type,
    @Cast("int64_t") long memory_type_id);

/** Assign a buffer of data to an input for execution on all model instances
 *  with the specified host policy. The buffer will be appended to any existing
 *  buffers for that input on all devices with this host policy. The
 *  'inference_request' object takes ownership of the buffer and so the caller
 *  should not modify or free the buffer until that ownership is released by
 *  'inference_request' being deleted or by the input being removed from
 *  'inference_request'. If the execution is scheduled on a device that does not
 *  have a input buffer specified using this function, then the input buffer
 *  specified with TRITONSERVER_InferenceRequestAppendInputData will be used so
 *  a non-host policy specific version of data must be added using that API.
 *  @param inference_request The request object.
 *  @param name The name of the input.
 *  @param base The base address of the input data.
 *  @param byte_size The size, in bytes, of the input data.
 *  @param memory_type The memory type of the input data.
 *  @param memory_type_id The memory type id of the input data.
 *  @param host_policy_name All model instances executing with this host_policy
 *  will use this input buffer for execution.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestAppendInputDataWithHostPolicy(
    TRITONSERVER_InferenceRequest inference_request, String name,
    @Const Pointer base, @Cast("size_t") long byte_size, @Cast("TRITONSERVER_MemoryType") int memory_type,
    @Cast("int64_t") long memory_type_id, String host_policy_name);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestAppendInputDataWithHostPolicy(
    TRITONSERVER_InferenceRequest inference_request, @Cast("const char*") BytePointer name,
    @Const Pointer base, @Cast("size_t") long byte_size, @Cast("TRITONSERVER_MemoryType") int memory_type,
    @Cast("int64_t") long memory_type_id, @Cast("const char*") BytePointer host_policy_name);

/** Assign a buffer of data to an input. The buffer will be appended
 *  to any existing buffers for that input. The 'inference_request'
 *  object takes ownership of the buffer and so the caller should not
 *  modify or free the buffer until that ownership is released by
 *  'inference_request' being deleted or by the input being removed
 *  from 'inference_request'.
 * 
 *  @param inference_request The request object.
 *  @param name The name of the input.
 *  @param base The base address of the input data.
 *  @param buffer_attributes The buffer attributes of the input.
 *  @return a TRITONSERVER_Error indicating success or failure. */
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestAppendInputDataWithBufferAttributes(
    TRITONSERVER_InferenceRequest inference_request, String name,
    @Const Pointer base, TRITONSERVER_BufferAttributes buffer_attributes);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestAppendInputDataWithBufferAttributes(
    TRITONSERVER_InferenceRequest inference_request, @Cast("const char*") BytePointer name,
    @Const Pointer base, TRITONSERVER_BufferAttributes buffer_attributes);

/** Clear all input data from an input, releasing ownership of the
 *  buffer(s) that were appended to the input with
 *  TRITONSERVER_InferenceRequestAppendInputData or
 *  TRITONSERVER_InferenceRequestAppendInputDataWithHostPolicy
 *  @param inference_request The request object.
 *  @param name The name of the input. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestRemoveAllInputData(
    TRITONSERVER_InferenceRequest inference_request, String name);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestRemoveAllInputData(
    TRITONSERVER_InferenceRequest inference_request, @Cast("const char*") BytePointer name);

/** Add an output request to an inference request.
 * 
 *  @param inference_request The request object.
 *  @param name The name of the output.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestAddRequestedOutput(
    TRITONSERVER_InferenceRequest inference_request, String name);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestAddRequestedOutput(
    TRITONSERVER_InferenceRequest inference_request, @Cast("const char*") BytePointer name);

/** Remove an output request from an inference request.
 * 
 *  @param inference_request The request object.
 *  @param name The name of the output.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestRemoveRequestedOutput(
    TRITONSERVER_InferenceRequest inference_request, String name);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestRemoveRequestedOutput(
    TRITONSERVER_InferenceRequest inference_request, @Cast("const char*") BytePointer name);

/** Remove all output requests from an inference request.
 * 
 *  @param inference_request The request object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestRemoveAllRequestedOutputs(
    TRITONSERVER_InferenceRequest inference_request);

/** Set the release callback for an inference request. The release
 *  callback is called by Triton to return ownership of the request
 *  object.
 * 
 *  @param inference_request The request object.
 *  @param request_release_fn The function called to return ownership
 *  of the 'inference_request' object.
 *  @param request_release_userp User-provided pointer that is
 *  delivered to the 'request_release_fn' callback.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestSetReleaseCallback(
    TRITONSERVER_InferenceRequest inference_request,
    TRITONSERVER_InferenceRequestReleaseFn_t request_release_fn,
    Pointer request_release_userp);

/** Set the allocator and response callback for an inference
 *  request. The allocator is used to allocate buffers for any output
 *  tensors included in responses that are produced for this
 *  request. The response callback is called to return response
 *  objects representing responses produced for this request.
 * 
 *  @param inference_request The request object.
 *  @param response_allocator The TRITONSERVER_ResponseAllocator to use
 *  to allocate buffers to hold inference results.
 *  @param response_allocator_userp User-provided pointer that is
 *  delivered to the response allocator's start and allocation functions.
 *  @param response_fn The function called to deliver an inference
 *  response for this request.
 *  @param response_userp User-provided pointer that is delivered to
 *  the 'response_fn' callback.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestSetResponseCallback(
    TRITONSERVER_InferenceRequest inference_request,
    TRITONSERVER_ResponseAllocator response_allocator,
    Pointer response_allocator_userp,
    TRITONSERVER_InferenceResponseCompleteFn_t response_fn,
    Pointer response_userp);

/** Set a string parameter in the request.
 * 
 *  @param request The request.
 *  @param key The name of the parameter.
 *  @param value The value of the parameter.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestSetStringParameter(
    TRITONSERVER_InferenceRequest request, String key,
    String value);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestSetStringParameter(
    TRITONSERVER_InferenceRequest request, @Cast("const char*") BytePointer key,
    @Cast("const char*") BytePointer value);

/** Set an integer parameter in the request.
 * 
 *  @param request The request.
 *  @param key The name of the parameter.
 *  @param value The value of the parameter.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestSetIntParameter(
    TRITONSERVER_InferenceRequest request, String key,
    @Cast("const int64_t") long value);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestSetIntParameter(
    TRITONSERVER_InferenceRequest request, @Cast("const char*") BytePointer key,
    @Cast("const int64_t") long value);

/** Set a boolean parameter in the request.
 * 
 *  @param request The request.
 *  @param key The name of the parameter.
 *  @param value The value of the parameter.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestSetBoolParameter(
    TRITONSERVER_InferenceRequest request, String key,
    @Cast("const bool") boolean value);
public static native TRITONSERVER_Error TRITONSERVER_InferenceRequestSetBoolParameter(
    TRITONSERVER_InferenceRequest request, @Cast("const char*") BytePointer key,
    @Cast("const bool") boolean value);

/** TRITONSERVER_InferenceResponse
 * 
 *  Object representing an inference response. The inference response
 *  provides the meta-data and output tensor values calculated by the
 *  inference.
 * 
 <p>
 *  Delete an inference response object.
 * 
 *  @param inference_response The response object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseDelete(
    TRITONSERVER_InferenceResponse inference_response);

/** Return the error status of an inference response. Return a
 *  TRITONSERVER_Error object on failure, return nullptr on success.
 *  The returned error object is owned by 'inference_response' and so
 *  should not be deleted by the caller.
 * 
 *  @param inference_response The response object.
 *  @return a TRITONSERVER_Error indicating the success or failure
 *  status of the response. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseError(
    TRITONSERVER_InferenceResponse inference_response);

/** Get model used to produce a response. The caller does not own the
 *  returned model name value and must not modify or delete it. The
 *  lifetime of all returned values extends until 'inference_response'
 *  is deleted.
 * 
 *  @param inference_response The response object.
 *  @param model_name Returns the name of the model.
 *  @param model_version Returns the version of the model.
 *  this response.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseModel(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const char**") PointerPointer model_name, @Cast("int64_t*") LongPointer model_version);
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseModel(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const char**") @ByPtrPtr BytePointer model_name, @Cast("int64_t*") LongPointer model_version);
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseModel(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const char**") @ByPtrPtr ByteBuffer model_name, @Cast("int64_t*") LongBuffer model_version);
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseModel(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const char**") @ByPtrPtr byte[] model_name, @Cast("int64_t*") long[] model_version);

/** Get the ID of the request corresponding to a response. The caller
 *  does not own the returned ID and must not modify or delete it. The
 *  lifetime of all returned values extends until 'inference_response'
 *  is deleted.
 * 
 *  @param inference_response The response object.
 *  @param request_id Returns the ID of the request corresponding to
 *  this response.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseId(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const char**") PointerPointer request_id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseId(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const char**") @ByPtrPtr BytePointer request_id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseId(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const char**") @ByPtrPtr ByteBuffer request_id);
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseId(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const char**") @ByPtrPtr byte[] request_id);

/** Get the number of parameters available in the response.
 * 
 *  @param inference_response The response object.
 *  @param count Returns the number of parameters.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseParameterCount(
    TRITONSERVER_InferenceResponse inference_response, @Cast("uint32_t*") IntPointer count);
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseParameterCount(
    TRITONSERVER_InferenceResponse inference_response, @Cast("uint32_t*") IntBuffer count);
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseParameterCount(
    TRITONSERVER_InferenceResponse inference_response, @Cast("uint32_t*") int[] count);

/** Get all information about a parameter. The caller does not own any
 *  of the returned values and must not modify or delete them. The
 *  lifetime of all returned values extends until 'inference_response'
 *  is deleted.
 * 
 *  The 'vvalue' returns a void* pointer that must be cast
 *  appropriately based on 'type'. For example:
 * 
 *    void* vvalue;
 *    TRITONSERVER_ParameterType type;
 *    TRITONSERVER_InferenceResponseParameter(
 *                      response, index, &name, &type, &vvalue);
 *    switch (type) {
 *      case TRITONSERVER_PARAMETER_BOOL:
 *        bool value = *(reinterpret_cast<bool*>(vvalue));
 *        ...
 *      case TRITONSERVER_PARAMETER_INT:
 *        int64_t value = *(reinterpret_cast<int64_t*>(vvalue));
 *        ...
 *      case TRITONSERVER_PARAMETER_STRING:
 *        const char* value = reinterpret_cast<const char*>(vvalue);
 *        ...
 * 
 *  @param inference_response The response object.
 *  @param index The index of the parameter, must be 0 <= index <
 *  count, where 'count' is the value returned by
 *  TRITONSERVER_InferenceResponseParameterCount.
 *  @param name Returns the name of the parameter.
 *  @param type Returns the type of the parameter.
 *  @param vvalue Returns a pointer to the parameter value.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseParameter(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const uint32_t") int index, @Cast("const char**") PointerPointer name, @Cast("TRITONSERVER_ParameterType*") IntPointer type,
    @Cast("const void**") PointerPointer vvalue);
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseParameter(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const uint32_t") int index, @Cast("const char**") @ByPtrPtr BytePointer name, @Cast("TRITONSERVER_ParameterType*") IntPointer type,
    @Cast("const void**") @ByPtrPtr Pointer vvalue);
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseParameter(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const uint32_t") int index, @Cast("const char**") @ByPtrPtr ByteBuffer name, @Cast("TRITONSERVER_ParameterType*") IntBuffer type,
    @Cast("const void**") @ByPtrPtr Pointer vvalue);
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseParameter(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const uint32_t") int index, @Cast("const char**") @ByPtrPtr byte[] name, @Cast("TRITONSERVER_ParameterType*") int[] type,
    @Cast("const void**") @ByPtrPtr Pointer vvalue);

/** Get the number of outputs available in the response.
 * 
 *  @param inference_response The response object.
 *  @param count Returns the number of output tensors.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseOutputCount(
    TRITONSERVER_InferenceResponse inference_response, @Cast("uint32_t*") IntPointer count);
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseOutputCount(
    TRITONSERVER_InferenceResponse inference_response, @Cast("uint32_t*") IntBuffer count);
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseOutputCount(
    TRITONSERVER_InferenceResponse inference_response, @Cast("uint32_t*") int[] count);

/** Get all information about an output tensor.  The tensor data is
 *  returned as the base pointer to the data and the size, in bytes,
 *  of the data. The caller does not own any of the returned values
 *  and must not modify or delete them. The lifetime of all returned
 *  values extends until 'inference_response' is deleted.
 * 
 *  @param inference_response The response object.
 *  @param index The index of the output tensor, must be 0 <= index <
 *  count, where 'count' is the value returned by
 *  TRITONSERVER_InferenceResponseOutputCount.
 *  @param name Returns the name of the output.
 *  @param datatype Returns the type of the output.
 *  @param shape Returns the shape of the output.
 *  @param dim_count Returns the number of dimensions of the returned
 *  shape.
 *  @param base Returns the tensor data for the output.
 *  @param byte_size Returns the size, in bytes, of the data.
 *  @param memory_type Returns the memory type of the data.
 *  @param memory_type_id Returns the memory type id of the data.
 *  @param userp The user-specified value associated with the buffer
 *  in TRITONSERVER_ResponseAllocatorAllocFn_t.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseOutput(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const uint32_t") int index, @Cast("const char**") PointerPointer name, @Cast("TRITONSERVER_DataType*") IntPointer datatype,
    @Cast("const int64_t**") PointerPointer shape, @Cast("uint64_t*") LongPointer dim_count, @Cast("const void**") PointerPointer base,
    @Cast("size_t*") SizeTPointer byte_size, @Cast("TRITONSERVER_MemoryType*") IntPointer memory_type,
    @Cast("int64_t*") LongPointer memory_type_id, @Cast("void**") PointerPointer userp);
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseOutput(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const uint32_t") int index, @Cast("const char**") @ByPtrPtr BytePointer name, @Cast("TRITONSERVER_DataType*") IntPointer datatype,
    @Cast("const int64_t**") @ByPtrPtr LongPointer shape, @Cast("uint64_t*") LongPointer dim_count, @Cast("const void**") @ByPtrPtr Pointer base,
    @Cast("size_t*") SizeTPointer byte_size, @Cast("TRITONSERVER_MemoryType*") IntPointer memory_type,
    @Cast("int64_t*") LongPointer memory_type_id, @Cast("void**") @ByPtrPtr Pointer userp);
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseOutput(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const uint32_t") int index, @Cast("const char**") @ByPtrPtr ByteBuffer name, @Cast("TRITONSERVER_DataType*") IntBuffer datatype,
    @Cast("const int64_t**") @ByPtrPtr LongBuffer shape, @Cast("uint64_t*") LongBuffer dim_count, @Cast("const void**") @ByPtrPtr Pointer base,
    @Cast("size_t*") SizeTPointer byte_size, @Cast("TRITONSERVER_MemoryType*") IntBuffer memory_type,
    @Cast("int64_t*") LongBuffer memory_type_id, @Cast("void**") @ByPtrPtr Pointer userp);
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseOutput(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const uint32_t") int index, @Cast("const char**") @ByPtrPtr byte[] name, @Cast("TRITONSERVER_DataType*") int[] datatype,
    @Cast("const int64_t**") @ByPtrPtr long[] shape, @Cast("uint64_t*") long[] dim_count, @Cast("const void**") @ByPtrPtr Pointer base,
    @Cast("size_t*") SizeTPointer byte_size, @Cast("TRITONSERVER_MemoryType*") int[] memory_type,
    @Cast("int64_t*") long[] memory_type_id, @Cast("void**") @ByPtrPtr Pointer userp);

/** Get a classification label associated with an output for a given
 *  index.  The caller does not own the returned label and must not
 *  modify or delete it. The lifetime of all returned label extends
 *  until 'inference_response' is deleted.
 * 
 *  @param inference_response The response object.
 *  @param index The index of the output tensor, must be 0 <= index <
 *  count, where 'count' is the value returned by
 *  TRITONSERVER_InferenceResponseOutputCount.
 *  @param class_index The index of the class.
 *  @param name Returns the label corresponding to 'class_index' or
 *  nullptr if no label.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseOutputClassificationLabel(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const uint32_t") int index, @Cast("const size_t") long class_index, @Cast("const char**") PointerPointer label);
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseOutputClassificationLabel(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const uint32_t") int index, @Cast("const size_t") long class_index, @Cast("const char**") @ByPtrPtr BytePointer label);
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseOutputClassificationLabel(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const uint32_t") int index, @Cast("const size_t") long class_index, @Cast("const char**") @ByPtrPtr ByteBuffer label);
public static native TRITONSERVER_Error TRITONSERVER_InferenceResponseOutputClassificationLabel(
    TRITONSERVER_InferenceResponse inference_response,
    @Cast("const uint32_t") int index, @Cast("const size_t") long class_index, @Cast("const char**") @ByPtrPtr byte[] label);

/** TRITONSERVER_BufferAttributes
 * 
 *  API to create, modify, or retrieve attributes associated with a buffer.
 * 
 <p>
 *  Create a new buffer attributes object. The caller takes ownership of
 *  the TRITONSERVER_BufferAttributes object and must call
 *  TRITONSERVER_BufferAttributesDelete to release the object.
 * 
 *  @param buffer_attributes Returns the new buffer attributes object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_BufferAttributesNew(
    @Cast("TRITONSERVER_BufferAttributes**") PointerPointer buffer_attributes);
public static native TRITONSERVER_Error TRITONSERVER_BufferAttributesNew(
    @ByPtrPtr TRITONSERVER_BufferAttributes buffer_attributes);

/** Delete a buffer attributes object.
 * 
 *  @param buffer_attributes The buffer_attributes object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_BufferAttributesDelete(
    TRITONSERVER_BufferAttributes buffer_attributes);

/** Set the memory type id field of the buffer attributes.
 * 
 *  @param buffer_attributes The buffer attributes object.
 *  @param memory_type_id Memory type id to assign to the buffer attributes
 *  object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_BufferAttributesSetMemoryTypeId(
    TRITONSERVER_BufferAttributes buffer_attributes,
    @Cast("int64_t") long memory_type_id);

/** Set the memory type field of the buffer attributes.
 * 
 *  @param buffer_attributes The buffer attributes object.
 *  @param memory_type Memory type to assign to the buffer attributes object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_BufferAttributesSetMemoryType(
    TRITONSERVER_BufferAttributes buffer_attributes,
    @Cast("TRITONSERVER_MemoryType") int memory_type);

/** Set the CudaIpcHandle field of the buffer attributes.
 * 
 *  @param buffer_attributes The buffer attributes object.
 *  @param cuda_ipc_handle The CudaIpcHandle to assign to the buffer attributes
 *  object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_BufferAttributesSetCudaIpcHandle(
    TRITONSERVER_BufferAttributes buffer_attributes,
    Pointer cuda_ipc_handle);

/** Set the byte size field of the buffer attributes.
 * 
 *  @param buffer_attributes The buffer attributes object.
 *  @param byte_size Byte size to assign to the buffer attributes object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_BufferAttributesSetByteSize(
    TRITONSERVER_BufferAttributes buffer_attributes, @Cast("size_t") long byte_size);

/** Get the memory type id field of the buffer attributes.
 * 
 *  @param buffer_attributes The buffer attributes object.
 *  @param memory_type_id Returns the memory type id associated with the buffer
 *  attributes object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_BufferAttributesMemoryTypeId(
    TRITONSERVER_BufferAttributes buffer_attributes,
    @Cast("int64_t*") LongPointer memory_type_id);
public static native TRITONSERVER_Error TRITONSERVER_BufferAttributesMemoryTypeId(
    TRITONSERVER_BufferAttributes buffer_attributes,
    @Cast("int64_t*") LongBuffer memory_type_id);
public static native TRITONSERVER_Error TRITONSERVER_BufferAttributesMemoryTypeId(
    TRITONSERVER_BufferAttributes buffer_attributes,
    @Cast("int64_t*") long[] memory_type_id);

/** Get the memory type field of the buffer attributes.
 * 
 *  @param buffer_attributes The buffer attributes object.
 *  @param memory_type Returns the memory type associated with the buffer
 *  attributes object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_BufferAttributesMemoryType(
    TRITONSERVER_BufferAttributes buffer_attributes,
    @Cast("TRITONSERVER_MemoryType*") IntPointer memory_type);
public static native TRITONSERVER_Error TRITONSERVER_BufferAttributesMemoryType(
    TRITONSERVER_BufferAttributes buffer_attributes,
    @Cast("TRITONSERVER_MemoryType*") IntBuffer memory_type);
public static native TRITONSERVER_Error TRITONSERVER_BufferAttributesMemoryType(
    TRITONSERVER_BufferAttributes buffer_attributes,
    @Cast("TRITONSERVER_MemoryType*") int[] memory_type);

/** Get the CudaIpcHandle field of the buffer attributes object.
 * 
 *  @param buffer_attributes The buffer attributes object.
 *  @param cuda_ipc_handle Returns the memory type associated with the buffer
 *  attributes object. If the cudaIpcHandle does not exist for the buffer,
 *  nullptr will be returned.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_BufferAttributesCudaIpcHandle(
    TRITONSERVER_BufferAttributes buffer_attributes,
    @Cast("void**") PointerPointer cuda_ipc_handle);
public static native TRITONSERVER_Error TRITONSERVER_BufferAttributesCudaIpcHandle(
    TRITONSERVER_BufferAttributes buffer_attributes,
    @Cast("void**") @ByPtrPtr Pointer cuda_ipc_handle);

/** Get the byte size field of the buffer attributes.
 * 
 *  @param buffer_attributes The buffer attributes object.
 *  @param byte_size Returns the byte size associated with the buffer attributes
 *  object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONSERVER_BufferAttributesByteSize(
    TRITONSERVER_BufferAttributes buffer_attributes, @Cast("size_t*") SizeTPointer byte_size);


/** TRITONSERVER_ServerOptions
 * 
 *  Options to use when creating an inference server.
 * 
 <p>
 *  Model control modes */
/** enum TRITONSERVER_ModelControlMode */
public static final int
  TRITONSERVER_MODEL_CONTROL_NONE = 0,
  TRITONSERVER_MODEL_CONTROL_POLL = 1,
  TRITONSERVER_MODEL_CONTROL_EXPLICIT = 2;

/** Rate limit modes */
/** enum TRITONSERVER_RateLimitMode */
public static final int
  TRITONSERVER_RATE_LIMIT_OFF = 0,
  TRITONSERVER_RATE_LIMIT_EXEC_COUNT = 1;

/** Create a new server options object. The caller takes ownership of
 *  the TRITONSERVER_ServerOptions object and must call
 *  TRITONSERVER_ServerOptionsDelete to release the object.
 * 
 *  @param options Returns the new server options object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsNew(
    @Cast("TRITONSERVER_ServerOptions**") PointerPointer options);
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsNew(
    @ByPtrPtr TRITONSERVER_ServerOptions options);

/** Delete a server options object.
 * 
 *  @param options The server options object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsDelete(TRITONSERVER_ServerOptions options);

/** Set the textual ID for the server in a server options. The ID is a
 *  name that identifies the server.
 * 
 *  @param options The server options object.
 *  @param server_id The server identifier.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetServerId(
    TRITONSERVER_ServerOptions options, String server_id);
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetServerId(
    TRITONSERVER_ServerOptions options, @Cast("const char*") BytePointer server_id);

/** Set the model repository path in a server options. The path must be
 *  the full absolute path to the model repository. This function can be called
 *  multiple times with different paths to set multiple model repositories.
 *  Note that if a model is not unique across all model repositories
 *  at any time, the model will not be available.
 * 
 *  @param options The server options object.
 *  @param model_repository_path The full path to the model repository.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetModelRepositoryPath(
    TRITONSERVER_ServerOptions options,
    String model_repository_path);
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetModelRepositoryPath(
    TRITONSERVER_ServerOptions options,
    @Cast("const char*") BytePointer model_repository_path);

/** Set the model control mode in a server options. For each mode the models
 *  will be managed as the following:
 * 
 *    TRITONSERVER_MODEL_CONTROL_NONE: the models in model repository will be
 *    loaded on startup. After startup any changes to the model repository will
 *    be ignored. Calling TRITONSERVER_ServerPollModelRepository will result in
 *    an error.
 * 
 *    TRITONSERVER_MODEL_CONTROL_POLL: the models in model repository will be
 *    loaded on startup. The model repository can be polled periodically using
 *    TRITONSERVER_ServerPollModelRepository and the server will load, unload,
 *    and updated models according to changes in the model repository.
 * 
 *    TRITONSERVER_MODEL_CONTROL_EXPLICIT: the models in model repository will
 *    not be loaded on startup. The corresponding model control APIs must be
 *    called to load / unload a model in the model repository.
 * 
 *  @param options The server options object.
 *  @param mode The mode to use for the model control.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetModelControlMode(
    TRITONSERVER_ServerOptions options,
    @Cast("TRITONSERVER_ModelControlMode") int mode);

/** Set the model to be loaded at startup in a server options. The model must be
 *  present in one, and only one, of the specified model repositories.
 *  This function can be called multiple times with different model name
 *  to set multiple startup models.
 *  Note that it only takes affect on TRITONSERVER_MODEL_CONTROL_EXPLICIT mode.
 * 
 *  @param options The server options object.
 *  @param mode_name The name of the model to load on startup.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetStartupModel(
    TRITONSERVER_ServerOptions options, String model_name);
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetStartupModel(
    TRITONSERVER_ServerOptions options, @Cast("const char*") BytePointer model_name);

/** Enable or disable strict model configuration handling in a server
 *  options.
 * 
 *  @param options The server options object.
 *  @param strict True to enable strict model configuration handling,
 *  false to disable.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetStrictModelConfig(
    TRITONSERVER_ServerOptions options, @Cast("bool") boolean strict);

/** Set the rate limit mode in a server options.
 * 
 *    TRITONSERVER_RATE_LIMIT_EXEC_COUNT: The rate limiting prioritizes the
 *    inference execution using the number of times each instance has got a
 *    chance to run. The execution gets to run only when its resource
 *    constraints are satisfied.
 * 
 *    TRITONSERVER_RATE_LIMIT_OFF: The rate limiting is turned off and the
 *    inference gets executed whenever an instance is available.
 * 
 *  @param options The server options object.
 *  @param mode The mode to use for the rate limiting. By default, execution
 *  count is used to determine the priorities.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetRateLimiterMode(
    TRITONSERVER_ServerOptions options,
    @Cast("TRITONSERVER_RateLimitMode") int mode);

/** Add resource count for rate limiting.
 * 
 *  @param options The server options object.
 *  @param name The name of the resource.
 *  @param count The count of the resource.
 *  @param device The device identifier for the resource. A value of -1
 *  indicates that the specified number of resources are available on every
 *  device. The device value is ignored for a global resource. The server
 *  will use the rate limiter configuration specified for instance groups
 *  in model config to determine whether resource is global. In case of
 *  conflicting resource type in different model configurations, server
 *  will raise an appropriate error while loading model.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsAddRateLimiterResource(
    TRITONSERVER_ServerOptions options, String resource_name,
    @Cast("const size_t") long resource_count, int device);
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsAddRateLimiterResource(
    TRITONSERVER_ServerOptions options, @Cast("const char*") BytePointer resource_name,
    @Cast("const size_t") long resource_count, int device);

/** Set the total pinned memory byte size that the server can allocate
 *  in a server options. The pinned memory pool will be shared across
 *  Triton itself and the backends that use
 *  TRITONBACKEND_MemoryManager to allocate memory.
 * 
 *  @param options The server options object.
 *  @param size The pinned memory pool byte size.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetPinnedMemoryPoolByteSize(
    TRITONSERVER_ServerOptions options, @Cast("uint64_t") long size);

/** Set the total CUDA memory byte size that the server can allocate
 *  on given GPU device in a server options. The pinned memory pool
 *  will be shared across Triton itself and the backends that use
 *  TRITONBACKEND_MemoryManager to allocate memory.
 * 
 *  @param options The server options object.
 *  @param gpu_device The GPU device to allocate the memory pool.
 *  @param size The CUDA memory pool byte size.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetCudaMemoryPoolByteSize(
    TRITONSERVER_ServerOptions options, int gpu_device, @Cast("uint64_t") long size);

/** Set the size of the virtual address space that will be used
 *  for growable memory in implicit state.
 * 
 *  @param options The server options object.
 *  @param gpu_device The GPU device to set the CUDA virtual address space size
 *  @param size The size of the CUDA virtual address space.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetCudaVirtualAddressSize(
    TRITONSERVER_ServerOptions options, int gpu_device,
    @Cast("size_t") long cuda_virtual_address_size);

/** Deprecated. See TRITONSERVER_ServerOptionsSetCacheConfig instead.
 * 
 *  Set the total response cache byte size that the server can allocate in CPU
 *  memory. The response cache will be shared across all inference requests and
 *  across all models.
 * 
 *  @param options The server options object.
 *  @param size The total response cache byte size.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetResponseCacheByteSize(
    TRITONSERVER_ServerOptions options, @Cast("uint64_t") long size);

/** Set the cache config that will be used to initialize the cache
 *  implementation for "cache_name".
 * 
 *  It is expected that the "cache_name" provided matches a directory inside
 *  the "cache_dir" used for TRITONSERVER_ServerOptionsSetCacheDirectory. The
 *  default "cache_dir" is "/opt/tritonserver/caches", so for a "cache_name" of
 *  "local", Triton would expect to find the "local" cache implementation at
 *  "/opt/tritonserver/caches/local/libtritoncache_local.so"
 * 
 *  Altogether an example for the "local" cache implementation would look like:
 *    std::string cache_name = "local";
 *    std::string config_json = R"({"size": 1048576})"
 *    auto err = TRITONSERVER_ServerOptionsSetCacheConfig(
 *      options, cache_name, config_json);
 * 
 *  @param options The server options object.
 *  @param cache_name The name of the cache. Example names would be
 *  "local", "redis", or the name of a custom cache implementation.
 *  @param config_json The string representation of config JSON that is
 *  used to initialize the cache implementation.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetCacheConfig(
    TRITONSERVER_ServerOptions options, String cache_name,
    String config_json);
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetCacheConfig(
    TRITONSERVER_ServerOptions options, @Cast("const char*") BytePointer cache_name,
    @Cast("const char*") BytePointer config_json);

/** Set the directory containing cache shared libraries. This
 *  directory is searched when looking for cache implementations.
 * 
 *  @param options The server options object.
 *  @param cache_dir The full path of the cache directory.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetCacheDirectory(
    TRITONSERVER_ServerOptions options, String cache_dir);
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetCacheDirectory(
    TRITONSERVER_ServerOptions options, @Cast("const char*") BytePointer cache_dir);

/** Set the minimum support CUDA compute capability in a server
 *  options.
 * 
 *  @param options The server options object.
 *  @param cc The minimum CUDA compute capability.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetMinSupportedComputeCapability(
    TRITONSERVER_ServerOptions options, double cc);

/** Enable or disable exit-on-error in a server options.
 * 
 *  @param options The server options object.
 *  @param exit True to enable exiting on initialization error, false
 *  to continue.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetExitOnError(
    TRITONSERVER_ServerOptions options, @Cast("bool") boolean exit);

/** Enable or disable strict readiness handling in a server options.
 * 
 *  @param options The server options object.
 *  @param strict True to enable strict readiness handling, false to
 *  disable.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetStrictReadiness(
    TRITONSERVER_ServerOptions options, @Cast("bool") boolean strict);

/** Set the exit timeout, in seconds, for the server in a server
 *  options.
 * 
 *  @param options The server options object.
 *  @param timeout The exit timeout, in seconds.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetExitTimeout(
    TRITONSERVER_ServerOptions options, @Cast("unsigned int") int timeout);

/** Set the number of threads used in buffer manager in a server options.
 * 
 *  @param options The server options object.
 *  @param thread_count The number of threads.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetBufferManagerThreadCount(
    TRITONSERVER_ServerOptions options, @Cast("unsigned int") int thread_count);

/** Set the number of threads to concurrently load models in a server options.
 * 
 *  @param options The server options object.
 *  @param thread_count The number of threads.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetModelLoadThreadCount(
    TRITONSERVER_ServerOptions options, @Cast("unsigned int") int thread_count);

/** Enable model namespacing to allow serving models with the same name if
 *  they are in different namespaces.
 * 
 *  @param options The server options object.
 *  @param enable_namespace Whether to enable model namespacing or not.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetModelNamespacing(
    TRITONSERVER_ServerOptions options, @Cast("bool") boolean enable_namespace);

/** Provide a log output file.
 * 
 *  @param options The server options object.
 *  @param file a string defining the file where the log outputs will be saved.
 *  An empty string for the file name will cause triton to direct logging
 *  facilities to the console
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetLogFile(
    TRITONSERVER_ServerOptions options, String file);
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetLogFile(
    TRITONSERVER_ServerOptions options, @Cast("const char*") BytePointer file);

/** Enable or disable info level logging.
 * 
 *  @param options The server options object.
 *  @param log True to enable info logging, false to disable.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetLogInfo(
    TRITONSERVER_ServerOptions options, @Cast("bool") boolean log);

/** Enable or disable warning level logging.
 * 
 *  @param options The server options object.
 *  @param log True to enable warning logging, false to disable.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetLogWarn(
    TRITONSERVER_ServerOptions options, @Cast("bool") boolean log);

/** Enable or disable error level logging.
 * 
 *  @param options The server options object.
 *  @param log True to enable error logging, false to disable.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetLogError(
    TRITONSERVER_ServerOptions options, @Cast("bool") boolean log);

/** Set the logging format.
 * 
 *  @param options The server options object.
 *  @param format The logging format.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetLogFormat(
    TRITONSERVER_ServerOptions options,
    @Cast("const TRITONSERVER_LogFormat") int format);

/** Set verbose logging level. Level zero disables verbose logging.
 * 
 *  @param options The server options object.
 *  @param level The verbose logging level.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetLogVerbose(
    TRITONSERVER_ServerOptions options, int level);

/** Enable or disable metrics collection in a server options.
 * 
 *  @param options The server options object.
 *  @param metrics True to enable metrics, false to disable.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetMetrics(
    TRITONSERVER_ServerOptions options, @Cast("bool") boolean metrics);

/** Enable or disable GPU metrics collection in a server options. GPU
 *  metrics are collected if both this option and
 *  TRITONSERVER_ServerOptionsSetMetrics are true.
 * 
 *  @param options The server options object.
 *  @param gpu_metrics True to enable GPU metrics, false to disable.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetGpuMetrics(
    TRITONSERVER_ServerOptions options, @Cast("bool") boolean gpu_metrics);

/** Enable or disable CPU metrics collection in a server options. CPU
 *  metrics are collected if both this option and
 *  TRITONSERVER_ServerOptionsSetMetrics are true.
 * 
 *  @param options The server options object.
 *  @param cpu_metrics True to enable CPU metrics, false to disable.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetCpuMetrics(
    TRITONSERVER_ServerOptions options, @Cast("bool") boolean cpu_metrics);

/** Set the interval for metrics collection in a server options.
 *  This is 2000 milliseconds by default.
 * 
 *  @param options The server options object.
 *  @param metrics_interval_ms The time interval in ms between
 *  successive metrics updates.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetMetricsInterval(
    TRITONSERVER_ServerOptions options, @Cast("uint64_t") long metrics_interval_ms);

/** Set the directory containing backend shared libraries. This
 *  directory is searched last after the version and model directory
 *  in the model repository when looking for the backend shared
 *  library for a model. If the backend is named 'be' the directory
 *  searched is 'backend_dir'/be/libtriton_be.so.
 * 
 *  @param options The server options object.
 *  @param backend_dir The full path of the backend directory.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetBackendDirectory(
    TRITONSERVER_ServerOptions options, String backend_dir);
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetBackendDirectory(
    TRITONSERVER_ServerOptions options, @Cast("const char*") BytePointer backend_dir);

/** Set the directory containing repository agent shared libraries. This
 *  directory is searched when looking for the repository agent shared
 *  library for a model. If the repo agent is named 'ra' the directory
 *  searched is 'repoagent_dir'/ra/libtritonrepoagent_ra.so.
 * 
 *  @param options The server options object.
 *  @param repoagent_dir The full path of the repository agent directory.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetRepoAgentDirectory(
    TRITONSERVER_ServerOptions options, String repoagent_dir);
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetRepoAgentDirectory(
    TRITONSERVER_ServerOptions options, @Cast("const char*") BytePointer repoagent_dir);

/** Specify the limit on memory usage as a fraction on the device identified by
 *  'kind' and 'device_id'. If model loading on the device is requested and the
 *  current memory usage exceeds the limit, the load will be rejected. If not
 *  specified, the limit will not be set.
 * 
 *  Currently support TRITONSERVER_INSTANCEGROUPKIND_GPU
 * 
 *  @param options The server options object.
 *  @param kind The kind of the device.
 *  @param device_id The id of the device.
 *  @param fraction The limit on memory usage as a fraction
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetModelLoadDeviceLimit(
    TRITONSERVER_ServerOptions options,
    @Cast("const TRITONSERVER_InstanceGroupKind") int kind, int device_id,
    double fraction);

/** Set a configuration setting for a named backend in a server
 *  options.
 * 
 *  @param options The server options object.
 *  @param backend_name The name of the backend.
 *  @param setting The name of the setting.
 *  @param value The setting value.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetBackendConfig(
    TRITONSERVER_ServerOptions options, String backend_name,
    String setting, String value);
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetBackendConfig(
    TRITONSERVER_ServerOptions options, @Cast("const char*") BytePointer backend_name,
    @Cast("const char*") BytePointer setting, @Cast("const char*") BytePointer value);

/** Set a host policy setting for a given policy name in a server options.
 * 
 *  @param options The server options object.
 *  @param policy_name The name of the policy.
 *  @param setting The name of the setting.
 *  @param value The setting value.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetHostPolicy(
    TRITONSERVER_ServerOptions options, String policy_name,
    String setting, String value);
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetHostPolicy(
    TRITONSERVER_ServerOptions options, @Cast("const char*") BytePointer policy_name,
    @Cast("const char*") BytePointer setting, @Cast("const char*") BytePointer value);

/** Set a configuration setting for metrics in server options.
 * 
 *  @param options The server options object.
 *  @param name The name of the configuration group. An empty string indicates
 *              a global configuration option.
 *  @param setting The name of the setting.
 *  @param value The setting value.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetMetricsConfig(
    TRITONSERVER_ServerOptions options, String name,
    String setting, String value);
public static native TRITONSERVER_Error TRITONSERVER_ServerOptionsSetMetricsConfig(
    TRITONSERVER_ServerOptions options, @Cast("const char*") BytePointer name,
    @Cast("const char*") BytePointer setting, @Cast("const char*") BytePointer value);

/** TRITONSERVER_Server
 * 
 *  An inference server.
 * 
 <p>
 *  Model batch flags. The enum values must be power-of-2 values. */
/** enum TRITONSERVER_ModelBatchFlag */
public static final int
  TRITONSERVER_BATCH_UNKNOWN = 1,
  TRITONSERVER_BATCH_FIRST_DIM = 2;

/** Model index flags. The enum values must be power-of-2 values. */
/** enum TRITONSERVER_ModelIndexFlag */
public static final int
  TRITONSERVER_INDEX_FLAG_READY = 1;

/** Model transaction policy flags. The enum values must be
 *  power-of-2 values. */
/** enum TRITONSERVER_ModelTxnPropertyFlag */
public static final int
  TRITONSERVER_TXN_ONE_TO_ONE = 1,
  TRITONSERVER_TXN_DECOUPLED = 2;

/** Create a new server object. The caller takes ownership of the
 *  TRITONSERVER_Server object and must call TRITONSERVER_ServerDelete
 *  to release the object.
 * 
 *  @param server Returns the new inference server object.
 *  @param options The inference server options object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerNew(
    @Cast("TRITONSERVER_Server**") PointerPointer server,
    TRITONSERVER_ServerOptions options);
public static native TRITONSERVER_Error TRITONSERVER_ServerNew(
    @ByPtrPtr TRITONSERVER_Server server,
    TRITONSERVER_ServerOptions options);

/** Delete a server object. If server is not already stopped it is
 *  stopped before being deleted.
 * 
 *  @param server The inference server object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerDelete(
    TRITONSERVER_Server server);

/** Stop a server object. A server can't be restarted once it is
 *  stopped.
 * 
 *  @param server The inference server object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerStop(
    TRITONSERVER_Server server);

/** Register a new model repository. Not available in polling mode.
 * 
 *  @param server The inference server object.
 *  @param repository_path The full path to the model repository.
 *  @param name_mapping List of name_mapping parameters. Each mapping has
 *  the model directory name as its key, overridden model name as its value.
 *  @param model_count Number of mappings provided.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerRegisterModelRepository(
    TRITONSERVER_Server server, String repository_path,
    @Cast("const TRITONSERVER_Parameter**") PointerPointer name_mapping,
    @Cast("const uint32_t") int mapping_count);
public static native TRITONSERVER_Error TRITONSERVER_ServerRegisterModelRepository(
    TRITONSERVER_Server server, String repository_path,
    @Const @ByPtrPtr TRITONSERVER_Parameter name_mapping,
    @Cast("const uint32_t") int mapping_count);
public static native TRITONSERVER_Error TRITONSERVER_ServerRegisterModelRepository(
    TRITONSERVER_Server server, @Cast("const char*") BytePointer repository_path,
    @Const @ByPtrPtr TRITONSERVER_Parameter name_mapping,
    @Cast("const uint32_t") int mapping_count);

/** Unregister a model repository. Not available in polling mode.
 * 
 *  @param server The inference server object.
 *  @param repository_path The full path to the model repository.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerUnregisterModelRepository(
    TRITONSERVER_Server server, String repository_path);
public static native TRITONSERVER_Error TRITONSERVER_ServerUnregisterModelRepository(
    TRITONSERVER_Server server, @Cast("const char*") BytePointer repository_path);

/** Check the model repository for changes and update server state
 *  based on those changes.
 * 
 *  @param server The inference server object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerPollModelRepository(TRITONSERVER_Server server);

/** Is the server live?
 * 
 *  @param server The inference server object.
 *  @param live Returns true if server is live, false otherwise.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerIsLive(
    TRITONSERVER_Server server, @Cast("bool*") boolean[] live);
public static native TRITONSERVER_Error TRITONSERVER_ServerIsLive(
    TRITONSERVER_Server server, @Cast("bool*") BoolPointer live);

/** Is the server ready?
 * 
 *  @param server The inference server object.
 *  @param ready Returns true if server is ready, false otherwise.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerIsReady(
    TRITONSERVER_Server server, @Cast("bool*") boolean[] ready);
public static native TRITONSERVER_Error TRITONSERVER_ServerIsReady(
    TRITONSERVER_Server server, @Cast("bool*") BoolPointer ready);

/** Is the model ready?
 * 
 *  @param server The inference server object.
 *  @param model_name The name of the model to get readiness for.
 *  @param model_version The version of the model to get readiness
 *  for.  If -1 then the server will choose a version based on the
 *  model's policy.
 *  @param ready Returns true if server is ready, false otherwise.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONSERVER_ServerModelIsReady(
    TRITONSERVER_Server server, String model_name,
    @Cast("const int64_t") long model_version, @Cast("bool*") boolean[] ready);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelIsReady(
    TRITONSERVER_Server server, @Cast("const char*") BytePointer model_name,
    @Cast("const int64_t") long model_version, @Cast("bool*") BoolPointer ready);

/** Get the batch properties of the model. The properties are
 *  communicated by a flags value and an (optional) object returned by
 *  'voidp'.
 * 
 *    - TRITONSERVER_BATCH_UNKNOWN: Triton cannot determine the
 *      batching properties of the model. This means that the model
 *      does not support batching in any way that is usable by
 *      Triton. The returned 'voidp' value is nullptr.
 * 
 *    - TRITONSERVER_BATCH_FIRST_DIM: The model supports batching
 *      along the first dimension of every input and output
 *      tensor. Triton schedulers that perform batching can
 *      automatically batch inference requests along this dimension.
 *      The returned 'voidp' value is nullptr.
 * 
 *  @param server The inference server object.
 *  @param model_name The name of the model.
 *  @param model_version The version of the model.  If -1 then the
 *  server will choose a version based on the model's policy.
 *  @param flags Returns flags indicating the batch properties of the
 *  model.
 *  @param voidp If non-nullptr, returns a point specific to the
 *  'flags' value.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONSERVER_ServerModelBatchProperties(
    TRITONSERVER_Server server, String model_name,
    @Cast("const int64_t") long model_version, @Cast("uint32_t*") IntPointer flags, @Cast("void**") PointerPointer voidp);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelBatchProperties(
    TRITONSERVER_Server server, String model_name,
    @Cast("const int64_t") long model_version, @Cast("uint32_t*") IntPointer flags, @Cast("void**") @ByPtrPtr Pointer voidp);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelBatchProperties(
    TRITONSERVER_Server server, @Cast("const char*") BytePointer model_name,
    @Cast("const int64_t") long model_version, @Cast("uint32_t*") IntBuffer flags, @Cast("void**") @ByPtrPtr Pointer voidp);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelBatchProperties(
    TRITONSERVER_Server server, String model_name,
    @Cast("const int64_t") long model_version, @Cast("uint32_t*") int[] flags, @Cast("void**") @ByPtrPtr Pointer voidp);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelBatchProperties(
    TRITONSERVER_Server server, @Cast("const char*") BytePointer model_name,
    @Cast("const int64_t") long model_version, @Cast("uint32_t*") IntPointer flags, @Cast("void**") @ByPtrPtr Pointer voidp);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelBatchProperties(
    TRITONSERVER_Server server, String model_name,
    @Cast("const int64_t") long model_version, @Cast("uint32_t*") IntBuffer flags, @Cast("void**") @ByPtrPtr Pointer voidp);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelBatchProperties(
    TRITONSERVER_Server server, @Cast("const char*") BytePointer model_name,
    @Cast("const int64_t") long model_version, @Cast("uint32_t*") int[] flags, @Cast("void**") @ByPtrPtr Pointer voidp);

/** Get the transaction policy of the model. The policy is
 *  communicated by a flags value.
 * 
 *    - TRITONSERVER_TXN_ONE_TO_ONE: The model generates exactly
 *      one response per request.
 * 
 *    - TRITONSERVER_TXN_DECOUPLED: The model may generate zero
 *      to many responses per request.
 * 
 *  @param server The inference server object.
 *  @param model_name The name of the model.
 *  @param model_version The version of the model.  If -1 then the
 *  server will choose a version based on the model's policy.
 *  @param txn_flags Returns flags indicating the transaction policy of the
 *  model.
 *  @param voidp If non-nullptr, returns a point specific to the 'flags' value.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerModelTransactionProperties(
    TRITONSERVER_Server server, String model_name,
    @Cast("const int64_t") long model_version, @Cast("uint32_t*") IntPointer txn_flags, @Cast("void**") PointerPointer voidp);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelTransactionProperties(
    TRITONSERVER_Server server, String model_name,
    @Cast("const int64_t") long model_version, @Cast("uint32_t*") IntPointer txn_flags, @Cast("void**") @ByPtrPtr Pointer voidp);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelTransactionProperties(
    TRITONSERVER_Server server, @Cast("const char*") BytePointer model_name,
    @Cast("const int64_t") long model_version, @Cast("uint32_t*") IntBuffer txn_flags, @Cast("void**") @ByPtrPtr Pointer voidp);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelTransactionProperties(
    TRITONSERVER_Server server, String model_name,
    @Cast("const int64_t") long model_version, @Cast("uint32_t*") int[] txn_flags, @Cast("void**") @ByPtrPtr Pointer voidp);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelTransactionProperties(
    TRITONSERVER_Server server, @Cast("const char*") BytePointer model_name,
    @Cast("const int64_t") long model_version, @Cast("uint32_t*") IntPointer txn_flags, @Cast("void**") @ByPtrPtr Pointer voidp);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelTransactionProperties(
    TRITONSERVER_Server server, String model_name,
    @Cast("const int64_t") long model_version, @Cast("uint32_t*") IntBuffer txn_flags, @Cast("void**") @ByPtrPtr Pointer voidp);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelTransactionProperties(
    TRITONSERVER_Server server, @Cast("const char*") BytePointer model_name,
    @Cast("const int64_t") long model_version, @Cast("uint32_t*") int[] txn_flags, @Cast("void**") @ByPtrPtr Pointer voidp);

/** Get the metadata of the server as a TRITONSERVER_Message object.
 *  The caller takes ownership of the message object and must call
 *  TRITONSERVER_MessageDelete to release the object.
 * 
 *  @param server The inference server object.
 *  @param server_metadata Returns the server metadata message.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerMetadata(
    TRITONSERVER_Server server,
    @Cast("TRITONSERVER_Message**") PointerPointer server_metadata);
public static native TRITONSERVER_Error TRITONSERVER_ServerMetadata(
    TRITONSERVER_Server server,
    @ByPtrPtr TRITONSERVER_Message server_metadata);

/** Get the metadata of a model as a TRITONSERVER_Message
 *  object.  The caller takes ownership of the message object and must
 *  call TRITONSERVER_MessageDelete to release the object.
 * 
 *  @param server The inference server object.
 *  @param model_name The name of the model.
 *  @param model_version The version of the model.
 *  If -1 then the server will choose a version based on the model's
 *  policy.
 *  @param model_metadata Returns the model metadata message.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerModelMetadata(
    TRITONSERVER_Server server, String model_name,
    @Cast("const int64_t") long model_version, @Cast("TRITONSERVER_Message**") PointerPointer model_metadata);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelMetadata(
    TRITONSERVER_Server server, String model_name,
    @Cast("const int64_t") long model_version, @ByPtrPtr TRITONSERVER_Message model_metadata);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelMetadata(
    TRITONSERVER_Server server, @Cast("const char*") BytePointer model_name,
    @Cast("const int64_t") long model_version, @ByPtrPtr TRITONSERVER_Message model_metadata);

/** Get the statistics of a model as a TRITONSERVER_Message
 *  object. The caller takes ownership of the object and must call
 *  TRITONSERVER_MessageDelete to release the object.
 * 
 *  @param server The inference server object.
 *  @param model_name The name of the model.
 *  If empty, then statistics for all available models will be returned,
 *  and the server will choose a version based on those models' policies.
 *  @param model_version The version of the model.  If -1 then the
 *  server will choose a version based on the model's policy.
 *  @param model_stats Returns the model statistics message.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerModelStatistics(
    TRITONSERVER_Server server, String model_name,
    @Cast("const int64_t") long model_version, @Cast("TRITONSERVER_Message**") PointerPointer model_stats);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelStatistics(
    TRITONSERVER_Server server, String model_name,
    @Cast("const int64_t") long model_version, @ByPtrPtr TRITONSERVER_Message model_stats);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelStatistics(
    TRITONSERVER_Server server, @Cast("const char*") BytePointer model_name,
    @Cast("const int64_t") long model_version, @ByPtrPtr TRITONSERVER_Message model_stats);

/** Get the configuration of a model as a TRITONSERVER_Message object.
 *  The caller takes ownership of the message object and must call
 *  TRITONSERVER_MessageDelete to release the object.
 * 
 *  @param server The inference server object.
 *  @param model_name The name of the model.
 *  @param model_version The version of the model.  If -1 then the
 *  server will choose a version based on the model's policy.
 *  @param config_version The model configuration will be returned in
 *  a format matching this version. If the configuration cannot be
 *  represented in the requested version's format then an error will
 *  be returned. Currently only version 1 is supported.
 *  @param model_config Returns the model config message.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONSERVER_ServerModelConfig(
    TRITONSERVER_Server server, String model_name,
    @Cast("const int64_t") long model_version, @Cast("const uint32_t") int config_version,
    @Cast("TRITONSERVER_Message**") PointerPointer model_config);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelConfig(
    TRITONSERVER_Server server, String model_name,
    @Cast("const int64_t") long model_version, @Cast("const uint32_t") int config_version,
    @ByPtrPtr TRITONSERVER_Message model_config);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelConfig(
    TRITONSERVER_Server server, @Cast("const char*") BytePointer model_name,
    @Cast("const int64_t") long model_version, @Cast("const uint32_t") int config_version,
    @ByPtrPtr TRITONSERVER_Message model_config);

/** Get the index of all unique models in the model repositories as a
 *  TRITONSERVER_Message object. The caller takes ownership of the
 *  message object and must call TRITONSERVER_MessageDelete to release
 *  the object.
 * 
 *  If TRITONSERVER_INDEX_FLAG_READY is set in 'flags' only the models
 *  that are loaded into the server and ready for inferencing are
 *  returned.
 * 
 *  @param server The inference server object.
 *  @param flags TRITONSERVER_ModelIndexFlag flags that control how to
 *  collect the index.
 *  @param model_index Return the model index message that holds the
 *  index of all models contained in the server's model repository(s).
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerModelIndex(
    TRITONSERVER_Server server, @Cast("uint32_t") int flags,
    @Cast("TRITONSERVER_Message**") PointerPointer model_index);
public static native TRITONSERVER_Error TRITONSERVER_ServerModelIndex(
    TRITONSERVER_Server server, @Cast("uint32_t") int flags,
    @ByPtrPtr TRITONSERVER_Message model_index);

/** Load the requested model or reload the model if it is already
 *  loaded. The function does not return until the model is loaded or
 *  fails to load. Returned error indicates if model loaded
 *  successfully or not.
 * 
 *  @param server The inference server object.
 *  @param model_name The name of the model.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerLoadModel(
    TRITONSERVER_Server server, String model_name);
public static native TRITONSERVER_Error TRITONSERVER_ServerLoadModel(
    TRITONSERVER_Server server, @Cast("const char*") BytePointer model_name);

/** Load the requested model or reload the model if it is already
 *  loaded, with load parameters provided. The function does not return until
 *  the model is loaded or fails to load. Returned error indicates if model
 *  loaded successfully or not.
 *  Currently the below parameter names are recognized:
 *  - "config" : string parameter that contains a JSON representation of the
 *  model configuration. This config will be used for loading the model instead
 *  of the one in the model directory.
 * 
 *  @param server The inference server object.
 *  @param model_name The name of the model.
 *  @param parameters The array of load parameters.
 *  @param parameter_count The number of parameters.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerLoadModelWithParameters(
    TRITONSERVER_Server server, String model_name,
    @Cast("const TRITONSERVER_Parameter**") PointerPointer parameters,
    @Cast("const uint64_t") long parameter_count);
public static native TRITONSERVER_Error TRITONSERVER_ServerLoadModelWithParameters(
    TRITONSERVER_Server server, String model_name,
    @Const @ByPtrPtr TRITONSERVER_Parameter parameters,
    @Cast("const uint64_t") long parameter_count);
public static native TRITONSERVER_Error TRITONSERVER_ServerLoadModelWithParameters(
    TRITONSERVER_Server server, @Cast("const char*") BytePointer model_name,
    @Const @ByPtrPtr TRITONSERVER_Parameter parameters,
    @Cast("const uint64_t") long parameter_count);

/** Unload the requested model. Unloading a model that is not loaded
 *  on server has no affect and success code will be returned.
 *  The function does not wait for the requested model to be fully unload
 *  and success code will be returned.
 *  Returned error indicates if model unloaded successfully or not.
 * 
 *  @param server The inference server object.
 *  @param model_name The name of the model.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerUnloadModel(
    TRITONSERVER_Server server, String model_name);
public static native TRITONSERVER_Error TRITONSERVER_ServerUnloadModel(
    TRITONSERVER_Server server, @Cast("const char*") BytePointer model_name);

/** Unload the requested model, and also unload any dependent model that
 *  was loaded along with the requested model (for example, the models composing
 *  an ensemble). Unloading a model that is not loaded
 *  on server has no affect and success code will be returned.
 *  The function does not wait for the requested model and all dependent
 *  models to be fully unload and success code will be returned.
 *  Returned error indicates if model unloaded successfully or not.
 * 
 *  @param server The inference server object.
 *  @param model_name The name of the model.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_ServerUnloadModelAndDependents(
    TRITONSERVER_Server server, String model_name);
public static native TRITONSERVER_Error TRITONSERVER_ServerUnloadModelAndDependents(
    TRITONSERVER_Server server, @Cast("const char*") BytePointer model_name);

/** Get the current metrics for the server. The caller takes ownership
 *  of the metrics object and must call TRITONSERVER_MetricsDelete to
 *  release the object.
 * 
 *  @param server The inference server object.
 *  @param metrics Returns the metrics.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONSERVER_ServerMetrics(
    TRITONSERVER_Server server, @Cast("TRITONSERVER_Metrics**") PointerPointer metrics);
public static native TRITONSERVER_Error TRITONSERVER_ServerMetrics(
    TRITONSERVER_Server server, @ByPtrPtr TRITONSERVER_Metrics metrics);

/** Perform inference using the meta-data and inputs supplied by the
 *  'inference_request'. If the function returns success, then the
 *  caller releases ownership of 'inference_request' and must not
 *  access it in any way after this call, until ownership is returned
 *  via the 'request_release_fn' callback registered in the request
 *  object with TRITONSERVER_InferenceRequestSetReleaseCallback.
 * 
 *  The function unconditionally takes ownership of 'trace' and so the
 *  caller must not access it in any way after this call (except in
 *  the trace activity callbacks) until ownership is returned via the
 *  trace's release_fn callback.
 * 
 *  Responses produced for this request are returned using the
 *  allocator and callback registered with the request by
 *  TRITONSERVER_InferenceRequestSetResponseCallback.
 * 
 *  @param server The inference server object.
 *  @param inference_request The request object.
 *  @param trace The trace object for this request, or nullptr if no
 *  tracing.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONSERVER_ServerInferAsync(
    TRITONSERVER_Server server,
    TRITONSERVER_InferenceRequest inference_request,
    TRITONSERVER_InferenceTrace trace);

/** TRITONSERVER_MetricKind
 * 
 *  Types of metrics recognized by TRITONSERVER.
 *  */
/** enum TRITONSERVER_MetricKind */
public static final int
  TRITONSERVER_METRIC_KIND_COUNTER = 0,
  TRITONSERVER_METRIC_KIND_GAUGE = 1;

/** Create a new metric family object. The caller takes ownership of the
 *  TRITONSERVER_MetricFamily object and must call
 *  TRITONSERVER_MetricFamilyDelete to release the object.
 * 
 *  @param family Returns the new metric family object.
 *  @param kind The type of metric family to create.
 *  @param name The name of the metric family seen when calling the metrics
 *  endpoint.
 *  @param description The description of the metric family seen when
 *  calling the metrics endpoint.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_MetricFamilyNew(
    @Cast("TRITONSERVER_MetricFamily**") PointerPointer family,
    @Cast("const TRITONSERVER_MetricKind") int kind, String name,
    String description);
public static native TRITONSERVER_Error TRITONSERVER_MetricFamilyNew(
    @ByPtrPtr TRITONSERVER_MetricFamily family,
    @Cast("const TRITONSERVER_MetricKind") int kind, String name,
    String description);
public static native TRITONSERVER_Error TRITONSERVER_MetricFamilyNew(
    @ByPtrPtr TRITONSERVER_MetricFamily family,
    @Cast("const TRITONSERVER_MetricKind") int kind, @Cast("const char*") BytePointer name,
    @Cast("const char*") BytePointer description);

/** Delete a metric family object.
 *  A TRITONSERVER_MetricFamily* object should be deleted AFTER its
 *  corresponding TRITONSERVER_Metric* objects have been deleted.
 *  Attempting to delete a family before its metrics will return an error.
 * 
 *  @param family The metric family object to delete.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_MetricFamilyDelete(TRITONSERVER_MetricFamily family);

/** Create a new metric object. The caller takes ownership of the
 *  TRITONSERVER_Metric object and must call
 *  TRITONSERVER_MetricDelete to release the object. The caller is also
 *  responsible for ownership of the labels passed in. Each label can be deleted
 *  immediately after creating the metric with TRITONSERVER_ParameterDelete
 *  if not re-using the labels.
 * 
 *  @param metric Returns the new metric object.
 *  @param family The metric family to add this new metric to.
 *  @param labels The array of labels to associate with this new metric.
 *  @param label_count The number of labels.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_MetricNew(
    @Cast("TRITONSERVER_Metric**") PointerPointer metric,
    TRITONSERVER_MetricFamily family,
    @Cast("const TRITONSERVER_Parameter**") PointerPointer labels, @Cast("const uint64_t") long label_count);
public static native TRITONSERVER_Error TRITONSERVER_MetricNew(
    @ByPtrPtr TRITONSERVER_Metric metric,
    TRITONSERVER_MetricFamily family,
    @Const @ByPtrPtr TRITONSERVER_Parameter labels, @Cast("const uint64_t") long label_count);

/** Delete a metric object.
 *  All TRITONSERVER_Metric* objects should be deleted BEFORE their
 *  corresponding TRITONSERVER_MetricFamily* objects have been deleted.
 *  If a family is deleted before its metrics, an error will be returned.
 * 
 *  @param metric The metric object to delete.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_MetricDelete(
    TRITONSERVER_Metric metric);

/** Get the current value of a metric object.
 *  Supports metrics of kind TRITONSERVER_METRIC_KIND_COUNTER
 *  and TRITONSERVER_METRIC_KIND_GAUGE, and returns
 *  TRITONSERVER_ERROR_UNSUPPORTED for unsupported TRITONSERVER_MetricKind.
 * 
 *  @param metric The metric object to query.
 *  @param value Returns the current value of the metric object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_MetricValue(
    TRITONSERVER_Metric metric, DoublePointer value);
public static native TRITONSERVER_Error TRITONSERVER_MetricValue(
    TRITONSERVER_Metric metric, DoubleBuffer value);
public static native TRITONSERVER_Error TRITONSERVER_MetricValue(
    TRITONSERVER_Metric metric, double[] value);

/** Increment the current value of metric by value.
 *  Supports metrics of kind TRITONSERVER_METRIC_KIND_GAUGE for any value,
 *  and TRITONSERVER_METRIC_KIND_COUNTER for non-negative values. Returns
 *  TRITONSERVER_ERROR_UNSUPPORTED for unsupported TRITONSERVER_MetricKind
 *  and TRITONSERVER_ERROR_INVALID_ARG for negative values on a
 *  TRITONSERVER_METRIC_KIND_COUNTER metric.
 * 
 *  @param metric The metric object to update.
 *  @param value The amount to increment the metric's value by.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_MetricIncrement(
    TRITONSERVER_Metric metric, double value);

/** Set the current value of metric to value.
 *  Supports metrics of kind TRITONSERVER_METRIC_KIND_GAUGE and returns
 *  TRITONSERVER_ERROR_UNSUPPORTED for unsupported TRITONSERVER_MetricKind.
 * 
 *  @param metric The metric object to update.
 *  @param value The amount to set metric's value to.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONSERVER_MetricSet(
    TRITONSERVER_Metric metric, double value);

/** Get the TRITONSERVER_MetricKind of metric and its corresponding family.
 * 
 *  @param metric The metric object to query.
 *  @param kind Returns the TRITONSERVER_MetricKind of metric.
 *  @return a TRITONSERVER_Error indicating success or failure. */
public static native TRITONSERVER_Error TRITONSERVER_GetMetricKind(
    TRITONSERVER_Metric metric, @Cast("TRITONSERVER_MetricKind*") IntPointer kind);
public static native TRITONSERVER_Error TRITONSERVER_GetMetricKind(
    TRITONSERVER_Metric metric, @Cast("TRITONSERVER_MetricKind*") IntBuffer kind);
public static native TRITONSERVER_Error TRITONSERVER_GetMetricKind(
    TRITONSERVER_Metric metric, @Cast("TRITONSERVER_MetricKind*") int[] kind);

// #ifdef __cplusplus
// #endif


// Parsed from tritonbackend.h

// Copyright 2020-2023, NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of NVIDIA CORPORATION nor the names of its
//    contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// #pragma once

// #include <stddef.h>
// #include <stdint.h>

// #include "triton/core/tritonserver.h"

// #ifdef __cplusplus
// #endif

// #ifdef _COMPILING_TRITONBACKEND
// #if defined(_MSC_VER)
// #define TRITONBACKEND_DECLSPEC __declspec(dllexport)
// #define TRITONBACKEND_ISPEC __declspec(dllimport)
// #elif defined(__GNUC__)
// #define TRITONBACKEND_DECLSPEC __attribute__((__visibility__("default")))
// #define TRITONBACKEND_ISPEC
// #else
// #define TRITONBACKEND_DECLSPEC
// #define TRITONBACKEND_ISPEC
// #endif
// #else
// #if defined(_MSC_VER)
// #define TRITONBACKEND_DECLSPEC __declspec(dllimport)
// #define TRITONBACKEND_ISPEC __declspec(dllexport)
// #else
// #define TRITONBACKEND_DECLSPEC
// #define TRITONBACKEND_ISPEC
// Targeting ../tritonserver/TRITONBACKEND_MemoryManager.java


// Targeting ../tritonserver/TRITONBACKEND_Input.java


// Targeting ../tritonserver/TRITONBACKEND_Output.java


// Targeting ../tritonserver/TRITONBACKEND_State.java


// Targeting ../tritonserver/TRITONBACKEND_Request.java


// Targeting ../tritonserver/TRITONBACKEND_ResponseFactory.java


// Targeting ../tritonserver/TRITONBACKEND_Response.java


// Targeting ../tritonserver/TRITONBACKEND_Backend.java


// Targeting ../tritonserver/TRITONBACKEND_Model.java


// Targeting ../tritonserver/TRITONBACKEND_ModelInstance.java


// Targeting ../tritonserver/TRITONBACKEND_BackendAttribute.java


// Targeting ../tritonserver/TRITONBACKEND_Batcher.java



/**
 *  TRITONBACKEND API Version
 * 
 *  The TRITONBACKEND API is versioned with major and minor version
 *  numbers. Any change to the API that does not impact backwards
 *  compatibility (for example, adding a non-required function)
 *  increases the minor version number. Any change that breaks
 *  backwards compatibility (for example, deleting or changing the
 *  behavior of a function) increases the major version number. A
 *  backend should check that the API version used to compile the
 *  backend is compatible with the API version of the Triton server
 *  that it is running in. This is typically done by code similar to
 *  the following which makes sure that the major versions are equal
 *  and that the minor version of Triton is >= the minor version used
 *  to build the backend.
 * 
 *    uint32_t api_version_major, api_version_minor;
 *    TRITONBACKEND_ApiVersion(&api_version_major, &api_version_minor);
 *    if ((api_version_major != TRITONBACKEND_API_VERSION_MAJOR) ||
 *        (api_version_minor < TRITONBACKEND_API_VERSION_MINOR)) {
 *      return TRITONSERVER_ErrorNew(
 *        TRITONSERVER_ERROR_UNSUPPORTED,
 *        "triton backend API version does not support this backend");
 *    }
 *  */
public static final int TRITONBACKEND_API_VERSION_MAJOR = 1;

///
public static final int TRITONBACKEND_API_VERSION_MINOR = 17;

/** Get the TRITONBACKEND API version supported by Triton. This value
 *  can be compared against the TRITONBACKEND_API_VERSION_MAJOR and
 *  TRITONBACKEND_API_VERSION_MINOR used to build the backend to
 *  ensure that Triton is compatible with the backend.
 * 
 *  @param major Returns the TRITONBACKEND API major version supported
 *  by Triton.
 *  @param minor Returns the TRITONBACKEND API minor version supported
 *  by Triton.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONBACKEND_ApiVersion(
    @Cast("uint32_t*") IntPointer major, @Cast("uint32_t*") IntPointer minor);
public static native TRITONSERVER_Error TRITONBACKEND_ApiVersion(
    @Cast("uint32_t*") IntBuffer major, @Cast("uint32_t*") IntBuffer minor);
public static native TRITONSERVER_Error TRITONBACKEND_ApiVersion(
    @Cast("uint32_t*") int[] major, @Cast("uint32_t*") int[] minor);

/** TRITONBACKEND_ArtifactType
 * 
 *  The ways that the files that make up a backend or model are
 *  communicated to the backend.
 * 
 *    TRITONBACKEND_ARTIFACT_FILESYSTEM: The model or backend
 *      artifacts are made available to Triton via a locally
 *      accessible filesystem. The backend can access these files
 *      using an appropriate system API.
 *  */
/** enum TRITONBACKEND_ArtifactType */
public static final int
  TRITONBACKEND_ARTIFACT_FILESYSTEM = 0;


/**
 *  TRITONBACKEND_MemoryManager
 * 
 *  Object representing an memory manager that is capable of
 *  allocating and otherwise managing different memory types. For
 *  improved performance Triton maintains pools for GPU and CPU-pinned
 *  memory and the memory manager allows backends to access those
 *  pools.
 * 
 <p>
 *  Allocate a contiguous block of memory of a specific type using a
 *  memory manager. Two error codes have specific interpretations for
 *  this function:
 * 
 *    TRITONSERVER_ERROR_UNSUPPORTED: Indicates that Triton is
 *      incapable of allocating the requested memory type and memory
 *      type ID. Requests for the memory type and ID will always fail
 *      no matter 'byte_size' of the request.
 * 
 *    TRITONSERVER_ERROR_UNAVAILABLE: Indicates that Triton can
 *       allocate the memory type and ID but that currently it cannot
 *       allocate a contiguous block of memory of the requested
 *       'byte_size'.
 * 
 *  @param manager The memory manager.
 *  @param buffer Returns the allocated memory.
 *  @param memory_type The type of memory to allocate.
 *  @param memory_type_id The ID associated with the memory type to
 *  allocate. For GPU memory this indicates the device ID of the GPU
 *  to allocate from.
 *  @param byte_size The size of memory to allocate, in bytes.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_MemoryManagerAllocate(
    TRITONBACKEND_MemoryManager manager, @Cast("void**") PointerPointer buffer,
    @Cast("const TRITONSERVER_MemoryType") int memory_type, @Cast("const int64_t") long memory_type_id,
    @Cast("const uint64_t") long byte_size);
public static native TRITONSERVER_Error TRITONBACKEND_MemoryManagerAllocate(
    TRITONBACKEND_MemoryManager manager, @Cast("void**") @ByPtrPtr Pointer buffer,
    @Cast("const TRITONSERVER_MemoryType") int memory_type, @Cast("const int64_t") long memory_type_id,
    @Cast("const uint64_t") long byte_size);

/** Free a buffer that was previously allocated with
 *  TRITONBACKEND_MemoryManagerAllocate. The call must provide the
 *  same values for 'memory_type' and 'memory_type_id' as were used
 *  when the buffer was allocate or else the behavior is undefined.
 * 
 *  @param manager The memory manager.
 *  @param buffer The allocated memory buffer to free.
 *  @param memory_type The type of memory of the buffer.
 *  @param memory_type_id The ID associated with the memory type of
 *  the buffer.
 *  @return a TRITONSERVER_Error indicating success or failure. */


///
///
///
///
public static native TRITONSERVER_Error TRITONBACKEND_MemoryManagerFree(
    TRITONBACKEND_MemoryManager manager, Pointer buffer,
    @Cast("const TRITONSERVER_MemoryType") int memory_type, @Cast("const int64_t") long memory_type_id);

/**
 *  TRITONBACKEND_Input
 * 
 *  Object representing an input tensor.
 * 
 <p>
 *  Get the name and properties of an input tensor. The returned
 *  strings and other properties are owned by the input, not the
 *  caller, and so should not be modified or freed.
 * 
 *  @param input The input tensor.
 *  @param name If non-nullptr, returns the tensor name.
 *  @param datatype If non-nullptr, returns the tensor datatype.
 *  @param shape If non-nullptr, returns the tensor shape.
 *  @param dim_count If non-nullptr, returns the number of dimensions
 *  in the tensor shape.
 *  @param byte_size If non-nullptr, returns the size of the available
 *  data for the tensor, in bytes. This size reflects the actual data
 *  available, and does not necessarily match what is
 *  expected/required for the tensor given its shape and datatype. It
 *  is the responsibility of the backend to handle mismatches in these
 *  sizes appropriately.
 *  @param buffer_count If non-nullptr, returns the number of buffers
 *  holding the contents of the tensor. These buffers are accessed
 *  using TRITONBACKEND_InputBuffer.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_InputProperties(
    TRITONBACKEND_Input input, @Cast("const char**") PointerPointer name,
    @Cast("TRITONSERVER_DataType*") IntPointer datatype, @Cast("const int64_t**") PointerPointer shape,
    @Cast("uint32_t*") IntPointer dims_count, @Cast("uint64_t*") LongPointer byte_size, @Cast("uint32_t*") IntPointer buffer_count);
public static native TRITONSERVER_Error TRITONBACKEND_InputProperties(
    TRITONBACKEND_Input input, @Cast("const char**") @ByPtrPtr BytePointer name,
    @Cast("TRITONSERVER_DataType*") IntPointer datatype, @Cast("const int64_t**") @ByPtrPtr LongPointer shape,
    @Cast("uint32_t*") IntPointer dims_count, @Cast("uint64_t*") LongPointer byte_size, @Cast("uint32_t*") IntPointer buffer_count);
public static native TRITONSERVER_Error TRITONBACKEND_InputProperties(
    TRITONBACKEND_Input input, @Cast("const char**") @ByPtrPtr ByteBuffer name,
    @Cast("TRITONSERVER_DataType*") IntBuffer datatype, @Cast("const int64_t**") @ByPtrPtr LongBuffer shape,
    @Cast("uint32_t*") IntBuffer dims_count, @Cast("uint64_t*") LongBuffer byte_size, @Cast("uint32_t*") IntBuffer buffer_count);
public static native TRITONSERVER_Error TRITONBACKEND_InputProperties(
    TRITONBACKEND_Input input, @Cast("const char**") @ByPtrPtr byte[] name,
    @Cast("TRITONSERVER_DataType*") int[] datatype, @Cast("const int64_t**") @ByPtrPtr long[] shape,
    @Cast("uint32_t*") int[] dims_count, @Cast("uint64_t*") long[] byte_size, @Cast("uint32_t*") int[] buffer_count);

/** Get the name and properties of an input tensor associated with a given
 *  host policy. If there are no input buffers for the specified  host policy,
 *  the properties of the fallback input buffers are returned. The returned
 *  strings and other properties are owned by the input, not the caller, and so
 *  should not be modified or freed.
 * 
 *  @param input The input tensor.
 *  @param host_policy_name The host policy name. Fallback input properties
 *  will be return if nullptr is provided.
 *  @param name If non-nullptr, returns the tensor name.
 *  @param datatype If non-nullptr, returns the tensor datatype.
 *  @param shape If non-nullptr, returns the tensor shape.
 *  @param dim_count If non-nullptr, returns the number of dimensions
 *  in the tensor shape.
 *  @param byte_size If non-nullptr, returns the size of the available
 *  data for the tensor, in bytes. This size reflects the actual data
 *  available, and does not necessarily match what is
 *  expected/required for the tensor given its shape and datatype. It
 *  is the responsibility of the backend to handle mismatches in these
 *  sizes appropriately.
 *  @param buffer_count If non-nullptr, returns the number of buffers
 *  holding the contents of the tensor. These buffers are accessed
 *  using TRITONBACKEND_InputBufferForHostPolicy.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_InputPropertiesForHostPolicy(
    TRITONBACKEND_Input input, String host_policy_name, @Cast("const char**") PointerPointer name,
    @Cast("TRITONSERVER_DataType*") IntPointer datatype, @Cast("const int64_t**") PointerPointer shape,
    @Cast("uint32_t*") IntPointer dims_count, @Cast("uint64_t*") LongPointer byte_size, @Cast("uint32_t*") IntPointer buffer_count);
public static native TRITONSERVER_Error TRITONBACKEND_InputPropertiesForHostPolicy(
    TRITONBACKEND_Input input, String host_policy_name, @Cast("const char**") @ByPtrPtr BytePointer name,
    @Cast("TRITONSERVER_DataType*") IntPointer datatype, @Cast("const int64_t**") @ByPtrPtr LongPointer shape,
    @Cast("uint32_t*") IntPointer dims_count, @Cast("uint64_t*") LongPointer byte_size, @Cast("uint32_t*") IntPointer buffer_count);
public static native TRITONSERVER_Error TRITONBACKEND_InputPropertiesForHostPolicy(
    TRITONBACKEND_Input input, @Cast("const char*") BytePointer host_policy_name, @Cast("const char**") @ByPtrPtr ByteBuffer name,
    @Cast("TRITONSERVER_DataType*") IntBuffer datatype, @Cast("const int64_t**") @ByPtrPtr LongBuffer shape,
    @Cast("uint32_t*") IntBuffer dims_count, @Cast("uint64_t*") LongBuffer byte_size, @Cast("uint32_t*") IntBuffer buffer_count);
public static native TRITONSERVER_Error TRITONBACKEND_InputPropertiesForHostPolicy(
    TRITONBACKEND_Input input, String host_policy_name, @Cast("const char**") @ByPtrPtr byte[] name,
    @Cast("TRITONSERVER_DataType*") int[] datatype, @Cast("const int64_t**") @ByPtrPtr long[] shape,
    @Cast("uint32_t*") int[] dims_count, @Cast("uint64_t*") long[] byte_size, @Cast("uint32_t*") int[] buffer_count);
public static native TRITONSERVER_Error TRITONBACKEND_InputPropertiesForHostPolicy(
    TRITONBACKEND_Input input, @Cast("const char*") BytePointer host_policy_name, @Cast("const char**") @ByPtrPtr BytePointer name,
    @Cast("TRITONSERVER_DataType*") IntPointer datatype, @Cast("const int64_t**") @ByPtrPtr LongPointer shape,
    @Cast("uint32_t*") IntPointer dims_count, @Cast("uint64_t*") LongPointer byte_size, @Cast("uint32_t*") IntPointer buffer_count);
public static native TRITONSERVER_Error TRITONBACKEND_InputPropertiesForHostPolicy(
    TRITONBACKEND_Input input, String host_policy_name, @Cast("const char**") @ByPtrPtr ByteBuffer name,
    @Cast("TRITONSERVER_DataType*") IntBuffer datatype, @Cast("const int64_t**") @ByPtrPtr LongBuffer shape,
    @Cast("uint32_t*") IntBuffer dims_count, @Cast("uint64_t*") LongBuffer byte_size, @Cast("uint32_t*") IntBuffer buffer_count);
public static native TRITONSERVER_Error TRITONBACKEND_InputPropertiesForHostPolicy(
    TRITONBACKEND_Input input, @Cast("const char*") BytePointer host_policy_name, @Cast("const char**") @ByPtrPtr byte[] name,
    @Cast("TRITONSERVER_DataType*") int[] datatype, @Cast("const int64_t**") @ByPtrPtr long[] shape,
    @Cast("uint32_t*") int[] dims_count, @Cast("uint64_t*") long[] byte_size, @Cast("uint32_t*") int[] buffer_count);

/** Get a buffer holding (part of) the tensor data for an input. For a
 *  given input the number of buffers composing the input are found
 *  from 'buffer_count' returned by TRITONBACKEND_InputProperties. The
 *  returned buffer is owned by the input and so should not be
 *  modified or freed by the caller. The lifetime of the buffer
 *  matches that of the input and so the buffer should not be accessed
 *  after the input tensor object is released.
 * 
 *  @param input The input tensor.
 *  @param index The index of the buffer. Must be 0 <= index <
 *  buffer_count, where buffer_count is the value returned by
 *  TRITONBACKEND_InputProperties.
 *  @param buffer Returns a pointer to a contiguous block of data for
 *  the named input.
 *  @param buffer_byte_size Returns the size, in bytes, of 'buffer'.
 *  @param memory_type Acts as both input and output. On input gives
 *  the buffer memory type preferred by the function caller.  Returns
 *  the actual memory type of 'buffer'.
 *  @param memory_type_id Acts as both input and output. On input
 *  gives the buffer memory type id preferred by the function caller.
 *  Returns the actual memory type id of 'buffer'.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_InputBuffer(
    TRITONBACKEND_Input input, @Cast("const uint32_t") int index, @Cast("const void**") PointerPointer buffer,
    @Cast("uint64_t*") LongPointer buffer_byte_size, @Cast("TRITONSERVER_MemoryType*") IntPointer memory_type,
    @Cast("int64_t*") LongPointer memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_InputBuffer(
    TRITONBACKEND_Input input, @Cast("const uint32_t") int index, @Cast("const void**") @ByPtrPtr Pointer buffer,
    @Cast("uint64_t*") LongPointer buffer_byte_size, @Cast("TRITONSERVER_MemoryType*") IntPointer memory_type,
    @Cast("int64_t*") LongPointer memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_InputBuffer(
    TRITONBACKEND_Input input, @Cast("const uint32_t") int index, @Cast("const void**") @ByPtrPtr Pointer buffer,
    @Cast("uint64_t*") LongBuffer buffer_byte_size, @Cast("TRITONSERVER_MemoryType*") IntBuffer memory_type,
    @Cast("int64_t*") LongBuffer memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_InputBuffer(
    TRITONBACKEND_Input input, @Cast("const uint32_t") int index, @Cast("const void**") @ByPtrPtr Pointer buffer,
    @Cast("uint64_t*") long[] buffer_byte_size, @Cast("TRITONSERVER_MemoryType*") int[] memory_type,
    @Cast("int64_t*") long[] memory_type_id);

/** Get a buffer holding (part of) the tensor data for an input for a specific
 *  host policy. If there are no input buffers specified for this host policy,
 *  the fallback input buffer is returned.
 *  For a given input the number of buffers composing the input are found
 *  from 'buffer_count' returned by TRITONBACKEND_InputPropertiesForHostPolicy.
 *  The returned buffer is owned by the input and so should not be modified or
 *  freed by the caller. The lifetime of the buffer matches that of the input
 *  and so the buffer should not be accessed after the input tensor object is
 *  released.
 * 
 *  @param input The input tensor.
 *  @param host_policy_name The host policy name. Fallback input buffer
 *  will be return if nullptr is provided.
 *  @param index The index of the buffer. Must be 0 <= index <
 *  buffer_count, where buffer_count is the value returned by
 *  TRITONBACKEND_InputPropertiesForHostPolicy.
 *  @param buffer Returns a pointer to a contiguous block of data for
 *  the named input.
 *  @param buffer_byte_size Returns the size, in bytes, of 'buffer'.
 *  @param memory_type Acts as both input and output. On input gives
 *  the buffer memory type preferred by the function caller.  Returns
 *  the actual memory type of 'buffer'.
 *  @param memory_type_id Acts as both input and output. On input
 *  gives the buffer memory type id preferred by the function caller.
 *  Returns the actual memory type id of 'buffer'.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_InputBufferForHostPolicy(
    TRITONBACKEND_Input input, String host_policy_name,
    @Cast("const uint32_t") int index, @Cast("const void**") PointerPointer buffer, @Cast("uint64_t*") LongPointer buffer_byte_size,
    @Cast("TRITONSERVER_MemoryType*") IntPointer memory_type, @Cast("int64_t*") LongPointer memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_InputBufferForHostPolicy(
    TRITONBACKEND_Input input, String host_policy_name,
    @Cast("const uint32_t") int index, @Cast("const void**") @ByPtrPtr Pointer buffer, @Cast("uint64_t*") LongPointer buffer_byte_size,
    @Cast("TRITONSERVER_MemoryType*") IntPointer memory_type, @Cast("int64_t*") LongPointer memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_InputBufferForHostPolicy(
    TRITONBACKEND_Input input, @Cast("const char*") BytePointer host_policy_name,
    @Cast("const uint32_t") int index, @Cast("const void**") @ByPtrPtr Pointer buffer, @Cast("uint64_t*") LongBuffer buffer_byte_size,
    @Cast("TRITONSERVER_MemoryType*") IntBuffer memory_type, @Cast("int64_t*") LongBuffer memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_InputBufferForHostPolicy(
    TRITONBACKEND_Input input, String host_policy_name,
    @Cast("const uint32_t") int index, @Cast("const void**") @ByPtrPtr Pointer buffer, @Cast("uint64_t*") long[] buffer_byte_size,
    @Cast("TRITONSERVER_MemoryType*") int[] memory_type, @Cast("int64_t*") long[] memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_InputBufferForHostPolicy(
    TRITONBACKEND_Input input, @Cast("const char*") BytePointer host_policy_name,
    @Cast("const uint32_t") int index, @Cast("const void**") @ByPtrPtr Pointer buffer, @Cast("uint64_t*") LongPointer buffer_byte_size,
    @Cast("TRITONSERVER_MemoryType*") IntPointer memory_type, @Cast("int64_t*") LongPointer memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_InputBufferForHostPolicy(
    TRITONBACKEND_Input input, String host_policy_name,
    @Cast("const uint32_t") int index, @Cast("const void**") @ByPtrPtr Pointer buffer, @Cast("uint64_t*") LongBuffer buffer_byte_size,
    @Cast("TRITONSERVER_MemoryType*") IntBuffer memory_type, @Cast("int64_t*") LongBuffer memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_InputBufferForHostPolicy(
    TRITONBACKEND_Input input, @Cast("const char*") BytePointer host_policy_name,
    @Cast("const uint32_t") int index, @Cast("const void**") @ByPtrPtr Pointer buffer, @Cast("uint64_t*") long[] buffer_byte_size,
    @Cast("TRITONSERVER_MemoryType*") int[] memory_type, @Cast("int64_t*") long[] memory_type_id);

/** Get the buffer attributes associated with the given input buffer. For a
 *  given input the number of buffers composing the input are found from
 *  'buffer_count' returned by TRITONBACKEND_InputProperties. The returned
 *  'buffer_attributes' is owned by the input and so should not be modified or
 *  freed by the caller. The lifetime of the 'buffer_attributes' matches that of
 *  the input and so the 'buffer_attributes' should not be accessed after the
 *  input tensor object is released.
 * 
 *  @param input The input tensor.
 *  @param index The index of the buffer. Must be 0 <= index < buffer_count,
 *  where buffer_count is the value returned by TRITONBACKEND_InputProperties.
 *  @param buffer Returns a pointer to a contiguous block of data for
 *  the named input.
 *  @param buffer_attributes Returns the attributes for the given buffer.
 *  @return a TRITONSERVER_Error indicating success or failure. */


///
///
///
///
public static native TRITONSERVER_Error TRITONBACKEND_InputBufferAttributes(
    TRITONBACKEND_Input input, @Cast("const uint32_t") int index, @Cast("const void**") PointerPointer buffer,
    @Cast("TRITONSERVER_BufferAttributes**") PointerPointer buffer_attributes);
public static native TRITONSERVER_Error TRITONBACKEND_InputBufferAttributes(
    TRITONBACKEND_Input input, @Cast("const uint32_t") int index, @Cast("const void**") @ByPtrPtr Pointer buffer,
    @ByPtrPtr TRITONSERVER_BufferAttributes buffer_attributes);

/**
 *  TRITONBACKEND_Output
 * 
 *  Object representing a response output tensor.
 * 
 <p>
 *  Get a buffer to use to hold the tensor data for the output. The
 *  returned buffer is owned by the output and so should not be freed
 *  by the caller. The caller can and should fill the buffer with the
 *  output data for the tensor. The lifetime of the buffer matches
 *  that of the output and so the buffer should not be accessed after
 *  the output tensor object is released.
 * 
 *  @param buffer Returns a pointer to a buffer where the contents of
 *  the output tensor should be placed.
 *  @param buffer_byte_size The size, in bytes, of the buffer required
 *  by the caller.
 *  @param memory_type Acts as both input and output. On input gives
 *  the buffer memory type preferred by the caller.  Returns the
 *  actual memory type of 'buffer'.
 *  @param memory_type_id Acts as both input and output. On input
 *  gives the buffer memory type id preferred by the caller. Returns
 *  the actual memory type id of 'buffer'.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_OutputBuffer(
    TRITONBACKEND_Output output, @Cast("void**") PointerPointer buffer,
    @Cast("const uint64_t") long buffer_byte_size, @Cast("TRITONSERVER_MemoryType*") IntPointer memory_type,
    @Cast("int64_t*") LongPointer memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_OutputBuffer(
    TRITONBACKEND_Output output, @Cast("void**") @ByPtrPtr Pointer buffer,
    @Cast("const uint64_t") long buffer_byte_size, @Cast("TRITONSERVER_MemoryType*") IntPointer memory_type,
    @Cast("int64_t*") LongPointer memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_OutputBuffer(
    TRITONBACKEND_Output output, @Cast("void**") @ByPtrPtr Pointer buffer,
    @Cast("const uint64_t") long buffer_byte_size, @Cast("TRITONSERVER_MemoryType*") IntBuffer memory_type,
    @Cast("int64_t*") LongBuffer memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_OutputBuffer(
    TRITONBACKEND_Output output, @Cast("void**") @ByPtrPtr Pointer buffer,
    @Cast("const uint64_t") long buffer_byte_size, @Cast("TRITONSERVER_MemoryType*") int[] memory_type,
    @Cast("int64_t*") long[] memory_type_id);

/** Get the buffer attributes associated with the given output buffer. The
 *  returned 'buffer_attributes' is owned by the output and so should not be
 *  modified or freed by the caller. The lifetime of the 'buffer_attributes'
 *  matches that of the output and so the 'buffer_attributes' should not be
 *  accessed after the output tensor object is released. This function must be
 *  called after the TRITONBACKEND_OutputBuffer otherwise it might contain
 *  incorrect data.
 * 
 *  @param output The output tensor.
 *  @param buffer_attributes Returns the attributes for the output buffer.
 *  @return a TRITONSERVER_Error indicating success or failure. */


///
///
///
///
public static native TRITONSERVER_Error TRITONBACKEND_OutputBufferAttributes(
    TRITONBACKEND_Output output,
    @Cast("TRITONSERVER_BufferAttributes**") PointerPointer buffer_attributes);
public static native TRITONSERVER_Error TRITONBACKEND_OutputBufferAttributes(
    TRITONBACKEND_Output output,
    @ByPtrPtr TRITONSERVER_BufferAttributes buffer_attributes);

/**
 *  TRITONBACKEND_Request
 * 
 *  Object representing an inference request.
 * 
 <p>
 *  Get the ID of the request. Can be nullptr if request doesn't have
 *  an ID. The returned string is owned by the request, not the
 *  caller, and so should not be modified or freed.
 * 
 *  @param request The inference request.
 *  @param id Returns the ID.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONBACKEND_RequestId(
    TRITONBACKEND_Request request, @Cast("const char**") PointerPointer id);
public static native TRITONSERVER_Error TRITONBACKEND_RequestId(
    TRITONBACKEND_Request request, @Cast("const char**") @ByPtrPtr BytePointer id);
public static native TRITONSERVER_Error TRITONBACKEND_RequestId(
    TRITONBACKEND_Request request, @Cast("const char**") @ByPtrPtr ByteBuffer id);
public static native TRITONSERVER_Error TRITONBACKEND_RequestId(
    TRITONBACKEND_Request request, @Cast("const char**") @ByPtrPtr byte[] id);

/** Query whether the request is cancelled or not.
 * 
 *  If possible the backend should terminate any processing and
 *  send an error response with cancelled status.
 * 
 *  @param request The inference request.
 *  @param is_cancelled Returns true if the request is cancelled otherwise it
 *  would return false.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONBACKEND_RequestIsCancelled(
    TRITONBACKEND_Request request, @Cast("bool*") boolean[] is_cancelled);
public static native TRITONSERVER_Error TRITONBACKEND_RequestIsCancelled(
    TRITONBACKEND_Request request, @Cast("bool*") BoolPointer is_cancelled);

/** Query whether the response factory is cancelled or not.
 * 
 *  If possible the backend should terminate any processing and
 *  send an error response with cancelled status.
 * 
 *  @param factory The response factory
 *  @param is_cancelled Returns true if the request is cancelled otherwise it
 *  would return false.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ResponseFactoryIsCancelled(
    TRITONBACKEND_ResponseFactory factory, @Cast("bool*") boolean[] is_cancelled);
public static native TRITONSERVER_Error TRITONBACKEND_ResponseFactoryIsCancelled(
    TRITONBACKEND_ResponseFactory factory, @Cast("bool*") BoolPointer is_cancelled);

/** Get the correlation ID of the request if it is an unsigned integer.
 *  Zero indicates that the request does not have a correlation ID.
 *  Returns failure if correlation ID for given request is not an unsigned
 *  integer.
 * 
 *  @param request The inference request.
 *  @param id Returns the correlation ID.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_RequestCorrelationId(
    TRITONBACKEND_Request request, @Cast("uint64_t*") LongPointer id);
public static native TRITONSERVER_Error TRITONBACKEND_RequestCorrelationId(
    TRITONBACKEND_Request request, @Cast("uint64_t*") LongBuffer id);
public static native TRITONSERVER_Error TRITONBACKEND_RequestCorrelationId(
    TRITONBACKEND_Request request, @Cast("uint64_t*") long[] id);

/** Get the timeout of the request. A value of 0 indicates no timeout was
 *  specified for the request. provided, the timeout will default to zero.
 * 
 *  @param request The inference request.
 *  @param timeout Returns the timeout value for the request.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_InferenceRequestTimeoutMicroseconds(
    TRITONBACKEND_Request request, @Cast("uint64_t*") LongPointer timeout);
public static native TRITONSERVER_Error TRITONBACKEND_InferenceRequestTimeoutMicroseconds(
    TRITONBACKEND_Request request, @Cast("uint64_t*") LongBuffer timeout);
public static native TRITONSERVER_Error TRITONBACKEND_InferenceRequestTimeoutMicroseconds(
    TRITONBACKEND_Request request, @Cast("uint64_t*") long[] timeout);

/** Get the correlation ID of the request if it is a string.
 *  Empty string indicates that the request does not have a correlation ID.
 *  Returns error if correlation ID for given request is not a string.
 * 
 *  @param request The inference request.
 *  @param id Returns the correlation ID.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_RequestCorrelationIdString(
    TRITONBACKEND_Request request, @Cast("const char**") PointerPointer id);
public static native TRITONSERVER_Error TRITONBACKEND_RequestCorrelationIdString(
    TRITONBACKEND_Request request, @Cast("const char**") @ByPtrPtr BytePointer id);
public static native TRITONSERVER_Error TRITONBACKEND_RequestCorrelationIdString(
    TRITONBACKEND_Request request, @Cast("const char**") @ByPtrPtr ByteBuffer id);
public static native TRITONSERVER_Error TRITONBACKEND_RequestCorrelationIdString(
    TRITONBACKEND_Request request, @Cast("const char**") @ByPtrPtr byte[] id);

/** Get the flag(s) associated with a request. On return 'flags' holds
 *  a bitwise-or of all flag values, see TRITONSERVER_RequestFlag for
 *  available flags.
 * 
 *  @param request The inference request.
 *  @param flags Returns the flags.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_RequestFlags(
    TRITONBACKEND_Request request, @Cast("uint32_t*") IntPointer flags);
public static native TRITONSERVER_Error TRITONBACKEND_RequestFlags(
    TRITONBACKEND_Request request, @Cast("uint32_t*") IntBuffer flags);
public static native TRITONSERVER_Error TRITONBACKEND_RequestFlags(
    TRITONBACKEND_Request request, @Cast("uint32_t*") int[] flags);

/** Get the number of parameters specified in the inference request.
 * 
 *  @param request The inference request.
 *  @param count Returns the number of parameters.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONBACKEND_RequestParameterCount(
    TRITONBACKEND_Request request, @Cast("uint32_t*") IntPointer count);
public static native TRITONSERVER_Error TRITONBACKEND_RequestParameterCount(
    TRITONBACKEND_Request request, @Cast("uint32_t*") IntBuffer count);
public static native TRITONSERVER_Error TRITONBACKEND_RequestParameterCount(
    TRITONBACKEND_Request request, @Cast("uint32_t*") int[] count);

/** Get a request parameters by index. The order of parameters in a given
 *  request is not necessarily consistent with other requests, even if
 *  the requests are in the same batch. As a result, you can not
 *  assume that an index obtained from one request will point to the
 *  same parameter in a different request.
 * 
 *  The lifetime of the returned parameter object matches that of the
 *  request and so the parameter object should not be accessed after the
 *  request object is released.
 * 
 *  @param request The inference request.
 *  @param index The index of the parameter. Must be 0 <= index <
 *  count, where count is the value returned by
 *  TRITONBACKEND_RequestParameterCount.
 *  @param key Returns the key of the parameter.
 *  @param type Returns the type of the parameter.
 *  @param vvalue Returns a pointer to the parameter value.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_RequestParameter(
    TRITONBACKEND_Request request, @Cast("const uint32_t") int index, @Cast("const char**") PointerPointer key,
    @Cast("TRITONSERVER_ParameterType*") IntPointer type, @Cast("const void**") PointerPointer vvalue);
public static native TRITONSERVER_Error TRITONBACKEND_RequestParameter(
    TRITONBACKEND_Request request, @Cast("const uint32_t") int index, @Cast("const char**") @ByPtrPtr BytePointer key,
    @Cast("TRITONSERVER_ParameterType*") IntPointer type, @Cast("const void**") @ByPtrPtr Pointer vvalue);
public static native TRITONSERVER_Error TRITONBACKEND_RequestParameter(
    TRITONBACKEND_Request request, @Cast("const uint32_t") int index, @Cast("const char**") @ByPtrPtr ByteBuffer key,
    @Cast("TRITONSERVER_ParameterType*") IntBuffer type, @Cast("const void**") @ByPtrPtr Pointer vvalue);
public static native TRITONSERVER_Error TRITONBACKEND_RequestParameter(
    TRITONBACKEND_Request request, @Cast("const uint32_t") int index, @Cast("const char**") @ByPtrPtr byte[] key,
    @Cast("TRITONSERVER_ParameterType*") int[] type, @Cast("const void**") @ByPtrPtr Pointer vvalue);

/** Get the number of input tensors specified in the request.
 * 
 *  @param request The inference request.
 *  @param count Returns the number of input tensors.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_RequestInputCount(
    TRITONBACKEND_Request request, @Cast("uint32_t*") IntPointer count);
public static native TRITONSERVER_Error TRITONBACKEND_RequestInputCount(
    TRITONBACKEND_Request request, @Cast("uint32_t*") IntBuffer count);
public static native TRITONSERVER_Error TRITONBACKEND_RequestInputCount(
    TRITONBACKEND_Request request, @Cast("uint32_t*") int[] count);

/** Get the name of an input tensor. The caller does not own
 *  the returned string and must not modify or delete it. The lifetime
 *  of the returned string extends only as long as 'request'.
 * 
 *  @param request The inference request.
 *  @param index The index of the input tensor. Must be 0 <= index <
 *  count, where count is the value returned by
 *  TRITONBACKEND_RequestInputCount.
 *  @param input_name Returns the name of the input tensor
 *  corresponding to the index.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_RequestInputName(
    TRITONBACKEND_Request request, @Cast("const uint32_t") int index,
    @Cast("const char**") PointerPointer input_name);
public static native TRITONSERVER_Error TRITONBACKEND_RequestInputName(
    TRITONBACKEND_Request request, @Cast("const uint32_t") int index,
    @Cast("const char**") @ByPtrPtr BytePointer input_name);
public static native TRITONSERVER_Error TRITONBACKEND_RequestInputName(
    TRITONBACKEND_Request request, @Cast("const uint32_t") int index,
    @Cast("const char**") @ByPtrPtr ByteBuffer input_name);
public static native TRITONSERVER_Error TRITONBACKEND_RequestInputName(
    TRITONBACKEND_Request request, @Cast("const uint32_t") int index,
    @Cast("const char**") @ByPtrPtr byte[] input_name);

/** Get a named request input. The lifetime of the returned input
 *  object matches that of the request and so the input object should
 *  not be accessed after the request object is released.
 * 
 *  @param request The inference request.
 *  @param name The name of the input.
 *  @param input Returns the input corresponding to the name.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONBACKEND_RequestInput(
    TRITONBACKEND_Request request, String name,
    @Cast("TRITONBACKEND_Input**") PointerPointer input);
public static native TRITONSERVER_Error TRITONBACKEND_RequestInput(
    TRITONBACKEND_Request request, String name,
    @ByPtrPtr TRITONBACKEND_Input input);
public static native TRITONSERVER_Error TRITONBACKEND_RequestInput(
    TRITONBACKEND_Request request, @Cast("const char*") BytePointer name,
    @ByPtrPtr TRITONBACKEND_Input input);

/** Get a request input by index. The order of inputs in a given
 *  request is not necessarily consistent with other requests, even if
 *  the requests are in the same batch. As a result, you can not
 *  assume that an index obtained from one request will point to the
 *  same input in a different request.
 * 
 *  The lifetime of the returned input object matches that of the
 *  request and so the input object should not be accessed after the
 *  request object is released.
 * 
 *  @param request The inference request.
 *  @param index The index of the input tensor. Must be 0 <= index <
 *  count, where count is the value returned by
 *  TRITONBACKEND_RequestInputCount.
 *  @param input Returns the input corresponding to the index.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_RequestInputByIndex(
    TRITONBACKEND_Request request, @Cast("const uint32_t") int index,
    @Cast("TRITONBACKEND_Input**") PointerPointer input);
public static native TRITONSERVER_Error TRITONBACKEND_RequestInputByIndex(
    TRITONBACKEND_Request request, @Cast("const uint32_t") int index,
    @ByPtrPtr TRITONBACKEND_Input input);

/** Get the number of output tensors requested to be returned in the
 *  request.
 * 
 *  @param request The inference request.
 *  @param count Returns the number of output tensors.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_RequestOutputCount(
    TRITONBACKEND_Request request, @Cast("uint32_t*") IntPointer count);
public static native TRITONSERVER_Error TRITONBACKEND_RequestOutputCount(
    TRITONBACKEND_Request request, @Cast("uint32_t*") IntBuffer count);
public static native TRITONSERVER_Error TRITONBACKEND_RequestOutputCount(
    TRITONBACKEND_Request request, @Cast("uint32_t*") int[] count);

/** Get the name of a requested output tensor. The caller does not own
 *  the returned string and must not modify or delete it. The lifetime
 *  of the returned string extends only as long as 'request'.
 * 
 *  @param request The inference request.
 *  @param index The index of the requested output tensor. Must be 0
 *  <= index < count, where count is the value returned by
 *  TRITONBACKEND_RequestOutputCount.
 *  @param output_name Returns the name of the requested output tensor
 *  corresponding to the index.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_RequestOutputName(
    TRITONBACKEND_Request request, @Cast("const uint32_t") int index,
    @Cast("const char**") PointerPointer output_name);
public static native TRITONSERVER_Error TRITONBACKEND_RequestOutputName(
    TRITONBACKEND_Request request, @Cast("const uint32_t") int index,
    @Cast("const char**") @ByPtrPtr BytePointer output_name);
public static native TRITONSERVER_Error TRITONBACKEND_RequestOutputName(
    TRITONBACKEND_Request request, @Cast("const uint32_t") int index,
    @Cast("const char**") @ByPtrPtr ByteBuffer output_name);
public static native TRITONSERVER_Error TRITONBACKEND_RequestOutputName(
    TRITONBACKEND_Request request, @Cast("const uint32_t") int index,
    @Cast("const char**") @ByPtrPtr byte[] output_name);

/** Returns the preferred memory type and memory type ID of the output buffer
 *  for the request. As much as possible, Triton will attempt to return
 *  the same memory_type and memory_type_id values that will be returned by
 *  the subsequent call to TRITONBACKEND_OutputBuffer, however, the backend must
 *  be capable of handling cases where the values differ.
 * 
 *  @param request The request.
 *  @param name The name of the output tensor. This is optional
 *  and it should be set to nullptr to indicate that the tensor name has
 *  not determined.
 *  @param byte_size The expected size of the buffer. This is optional
 *  and it should be set to nullptr to indicate that the byte size has
 *  not determined.
 *  @param memory_type Acts as both input and output. On input gives
 *  the memory type preferred by the caller. Returns memory type preferred
 *  by Triton, taken account of the caller preferred type.
 *  @param memory_type_id Acts as both input and output. On input gives
 *  the memory type ID preferred by the caller. Returns memory type ID preferred
 *  by Triton, taken account of the caller preferred type ID.
 *  @return a TRITONSERVER_Error object if a failure occurs.
 *  A TRITONSERVER_ERROR_UNAVAILABLE error indicates that the properties are not
 *  available, other error codes indicate an error. */

///
public static native TRITONSERVER_Error TRITONBACKEND_RequestOutputBufferProperties(
    TRITONBACKEND_Request request, String name, @Cast("size_t*") SizeTPointer byte_size,
    @Cast("TRITONSERVER_MemoryType*") IntPointer memory_type, @Cast("int64_t*") LongPointer memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_RequestOutputBufferProperties(
    TRITONBACKEND_Request request, @Cast("const char*") BytePointer name, @Cast("size_t*") SizeTPointer byte_size,
    @Cast("TRITONSERVER_MemoryType*") IntBuffer memory_type, @Cast("int64_t*") LongBuffer memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_RequestOutputBufferProperties(
    TRITONBACKEND_Request request, String name, @Cast("size_t*") SizeTPointer byte_size,
    @Cast("TRITONSERVER_MemoryType*") int[] memory_type, @Cast("int64_t*") long[] memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_RequestOutputBufferProperties(
    TRITONBACKEND_Request request, @Cast("const char*") BytePointer name, @Cast("size_t*") SizeTPointer byte_size,
    @Cast("TRITONSERVER_MemoryType*") IntPointer memory_type, @Cast("int64_t*") LongPointer memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_RequestOutputBufferProperties(
    TRITONBACKEND_Request request, String name, @Cast("size_t*") SizeTPointer byte_size,
    @Cast("TRITONSERVER_MemoryType*") IntBuffer memory_type, @Cast("int64_t*") LongBuffer memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_RequestOutputBufferProperties(
    TRITONBACKEND_Request request, @Cast("const char*") BytePointer name, @Cast("size_t*") SizeTPointer byte_size,
    @Cast("TRITONSERVER_MemoryType*") int[] memory_type, @Cast("int64_t*") long[] memory_type_id);

/** Release the request. The request should be released when it is no
 *  longer needed by the backend. If this call returns with an error
 *  (i.e. non-nullptr) then the request was not released and ownership
 *  remains with the backend. If this call returns with success, the
 *  'request' object is no longer owned by the backend and must not be
 *  used. Any tensor names, data types, shapes, input tensors,
 *  etc. returned by TRITONBACKEND_Request* functions for this request
 *  are no longer valid. If a persistent copy of that data is required
 *  it must be created before calling this function.
 * 
 *  @param request The inference request.
 *  @param release_flags Flags indicating what type of request release
 *  should be performed. @see TRITONSERVER_RequestReleaseFlag. @see
 *  TRITONSERVER_InferenceRequestReleaseFn_t.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_RequestRelease(
    TRITONBACKEND_Request request, @Cast("uint32_t") int release_flags);

/** Get the trace associated with a request. The returned trace is owned by the
 *  request, not the caller, and so should not be modified or freed.
 *  If the request is not being traced, then {@code nullptr} will be returned.
 * 
 *  @param request The inference request.
 *  @param trace Returns the trace associated with the request.
 *  @return a TRITONSERVER_Error indicating success or failure. */


///
///
///
public static native TRITONSERVER_Error TRITONBACKEND_RequestTrace(
    TRITONBACKEND_Request request, @Cast("TRITONSERVER_InferenceTrace**") PointerPointer trace);
public static native TRITONSERVER_Error TRITONBACKEND_RequestTrace(
    TRITONBACKEND_Request request, @ByPtrPtr TRITONSERVER_InferenceTrace trace);

/**
 *  TRITONBACKEND_ResponseFactory
 * 
 *  Object representing an inference response factory. Using a
 *  response factory is not required; instead a response can be
 *  generated directly from a TRITONBACKEND_Request object using
 *  TRITONBACKEND_ResponseNew(). A response factory allows a request
 *  to be released before all responses have been sent. Releasing a
 *  request as early as possible releases all input tensor data and
 *  therefore may be desirable in some cases.
 <p>
 *  Create the response factory associated with a request.
 * 
 *  @param factory Returns the new response factory.
 *  @param request The inference request.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ResponseFactoryNew(
    @Cast("TRITONBACKEND_ResponseFactory**") PointerPointer factory, TRITONBACKEND_Request request);
public static native TRITONSERVER_Error TRITONBACKEND_ResponseFactoryNew(
    @ByPtrPtr TRITONBACKEND_ResponseFactory factory, TRITONBACKEND_Request request);

/** Destroy a response factory.
 * 
 *  @param factory The response factory.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ResponseFactoryDelete(
    TRITONBACKEND_ResponseFactory factory);

/** Send response flags without a corresponding response.
 * 
 *  @param factory The response factory.
 *  @param send_flags Flags to send. @see
 *  TRITONSERVER_ResponseCompleteFlag. @see
 *  TRITONSERVER_InferenceResponseCompleteFn_t.
 *  @return a TRITONSERVER_Error indicating success or failure. */


///
///
///
///
///
public static native TRITONSERVER_Error TRITONBACKEND_ResponseFactorySendFlags(
    TRITONBACKEND_ResponseFactory factory, @Cast("const uint32_t") int send_flags);

/**
 *  TRITONBACKEND_Response
 * 
 *  Object representing an inference response. For a given request,
 *  the backend must carefully manage the lifecycle of responses
 *  generated for that request to ensure that the output tensor
 *  buffers are allocated correctly. When a response is created with
 *  TRITONBACKEND_ResponseNew or TRITONBACKEND_ResponseNewFromFactory,
 *  all the outputs and corresponding buffers must be created for that
 *  response using TRITONBACKEND_ResponseOutput and
 *  TRITONBACKEND_OutputBuffer *before* another response is created
 *  for the request. For a given response, outputs can be created in
 *  any order but they must be created sequentially/synchronously (for
 *  example, the backend cannot use multiple threads to simultaneously
 *  add multiple outputs to a response).
 * 
 *  The above requirement applies only to responses being generated
 *  for a given request. The backend may generate responses in
 *  parallel on multiple threads as long as those responses are for
 *  different requests.
 * 
 *  This order of response creation must be strictly followed. But,
 *  once response(s) are created they do not need to be sent
 *  immediately, nor do they need to be sent in the order they were
 *  created. The backend may even delete a created response instead of
 *  sending it by using TRITONBACKEND_ResponseDelete.
 <p>
 *  Create a response for a request.
 * 
 *  @param response Returns the new response.
 *  @param request The request.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ResponseNew(
    @Cast("TRITONBACKEND_Response**") PointerPointer response, TRITONBACKEND_Request request);
public static native TRITONSERVER_Error TRITONBACKEND_ResponseNew(
    @ByPtrPtr TRITONBACKEND_Response response, TRITONBACKEND_Request request);

/** Create a response using a factory.
 * 
 *  @param response Returns the new response.
 *  @param factory The response factory.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ResponseNewFromFactory(
    @Cast("TRITONBACKEND_Response**") PointerPointer response, TRITONBACKEND_ResponseFactory factory);
public static native TRITONSERVER_Error TRITONBACKEND_ResponseNewFromFactory(
    @ByPtrPtr TRITONBACKEND_Response response, TRITONBACKEND_ResponseFactory factory);

/** Destroy a response. It is not necessary to delete a response if
 *  TRITONBACKEND_ResponseSend is called as that function transfers
 *  ownership of the response object to Triton.
 * 
 *  @param response The response.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ResponseDelete(
    TRITONBACKEND_Response response);

/** Set a string parameter in the response.
 * 
 *  @param response The response.
 *  @param name The name of the parameter.
 *  @param value The value of the parameter.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ResponseSetStringParameter(
    TRITONBACKEND_Response response, String name, String value);
public static native TRITONSERVER_Error TRITONBACKEND_ResponseSetStringParameter(
    TRITONBACKEND_Response response, @Cast("const char*") BytePointer name, @Cast("const char*") BytePointer value);

/** Set an integer parameter in the response.
 * 
 *  @param response The response.
 *  @param name The name of the parameter.
 *  @param value The value of the parameter.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ResponseSetIntParameter(
    TRITONBACKEND_Response response, String name, @Cast("const int64_t") long value);
public static native TRITONSERVER_Error TRITONBACKEND_ResponseSetIntParameter(
    TRITONBACKEND_Response response, @Cast("const char*") BytePointer name, @Cast("const int64_t") long value);

/** Set a boolean parameter in the response.
 * 
 *  @param response The response.
 *  @param name The name of the parameter.
 *  @param value The value of the parameter.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ResponseSetBoolParameter(
    TRITONBACKEND_Response response, String name, @Cast("const bool") boolean value);
public static native TRITONSERVER_Error TRITONBACKEND_ResponseSetBoolParameter(
    TRITONBACKEND_Response response, @Cast("const char*") BytePointer name, @Cast("const bool") boolean value);

/** Create an output tensor in the response. The lifetime of the
 *  returned output tensor object matches that of the response and so
 *  the output tensor object should not be accessed after the response
 *  object is deleted.
 * 
 *  @param response The response.
 *  @param output Returns the new response output.
 *  @param name The name of the output tensor.
 *  @param datatype The datatype of the output tensor.
 *  @param shape The shape of the output tensor.
 *  @param dims_count The number of dimensions in the output tensor
 *  shape.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ResponseOutput(
    TRITONBACKEND_Response response, @Cast("TRITONBACKEND_Output**") PointerPointer output,
    String name, @Cast("const TRITONSERVER_DataType") int datatype,
    @Cast("const int64_t*") LongPointer shape, @Cast("const uint32_t") int dims_count);
public static native TRITONSERVER_Error TRITONBACKEND_ResponseOutput(
    TRITONBACKEND_Response response, @ByPtrPtr TRITONBACKEND_Output output,
    String name, @Cast("const TRITONSERVER_DataType") int datatype,
    @Cast("const int64_t*") LongPointer shape, @Cast("const uint32_t") int dims_count);
public static native TRITONSERVER_Error TRITONBACKEND_ResponseOutput(
    TRITONBACKEND_Response response, @ByPtrPtr TRITONBACKEND_Output output,
    @Cast("const char*") BytePointer name, @Cast("const TRITONSERVER_DataType") int datatype,
    @Cast("const int64_t*") LongBuffer shape, @Cast("const uint32_t") int dims_count);
public static native TRITONSERVER_Error TRITONBACKEND_ResponseOutput(
    TRITONBACKEND_Response response, @ByPtrPtr TRITONBACKEND_Output output,
    String name, @Cast("const TRITONSERVER_DataType") int datatype,
    @Cast("const int64_t*") long[] shape, @Cast("const uint32_t") int dims_count);
public static native TRITONSERVER_Error TRITONBACKEND_ResponseOutput(
    TRITONBACKEND_Response response, @ByPtrPtr TRITONBACKEND_Output output,
    @Cast("const char*") BytePointer name, @Cast("const TRITONSERVER_DataType") int datatype,
    @Cast("const int64_t*") LongPointer shape, @Cast("const uint32_t") int dims_count);
public static native TRITONSERVER_Error TRITONBACKEND_ResponseOutput(
    TRITONBACKEND_Response response, @ByPtrPtr TRITONBACKEND_Output output,
    String name, @Cast("const TRITONSERVER_DataType") int datatype,
    @Cast("const int64_t*") LongBuffer shape, @Cast("const uint32_t") int dims_count);
public static native TRITONSERVER_Error TRITONBACKEND_ResponseOutput(
    TRITONBACKEND_Response response, @ByPtrPtr TRITONBACKEND_Output output,
    @Cast("const char*") BytePointer name, @Cast("const TRITONSERVER_DataType") int datatype,
    @Cast("const int64_t*") long[] shape, @Cast("const uint32_t") int dims_count);

/** Send a response. Calling this function transfers ownership of the
 *  response object to Triton. The caller must not access or delete
 *  the response object after calling this function.
 * 
 *  @param response The response.
 *  @param send_flags Flags associated with the response. @see
 *  TRITONSERVER_ResponseCompleteFlag. @see
 *  TRITONSERVER_InferenceResponseCompleteFn_t.
 *  @param error The TRITONSERVER_Error to send if the response is an
 *  error, or nullptr if the response is successful.
 *  @return a TRITONSERVER_Error indicating success or failure. */


///
///
///
///
public static native TRITONSERVER_Error TRITONBACKEND_ResponseSend(
    TRITONBACKEND_Response response, @Cast("const uint32_t") int send_flags,
    TRITONSERVER_Error error);

/**
 *  TRITONBACKEND_State
 * 
 *  Object representing a state.
 * 
 <p>
 *  Create a state in the request. The returned state object is only valid
 *  before the TRITONBACKEND_StateUpdate is called. The state should not be
 *  freed by the caller. If TRITONBACKEND_StateUpdate is not called, the
 *  lifetime of the state matches the lifetime of the request. If the state name
 *  does not exist in the "state" section of the model configuration, the state
 *  will not be created and an error will be returned. If this function is
 *  called when sequence batching is not enabled or there is no 'states' section
 *  in the sequence batching section of the model configuration, this call will
 *  return an error.
 * 
 *  @param state Returns the new state.
 *  @param request The request.
 *  @param name The name of the state.
 *  @param datatype The datatype of the state.
 *  @param shape The shape of the state.
 *  @param dims_count The number of dimensions in the state shape.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_StateNew(
    @Cast("TRITONBACKEND_State**") PointerPointer state, TRITONBACKEND_Request request,
    String name, @Cast("const TRITONSERVER_DataType") int datatype,
    @Cast("const int64_t*") LongPointer shape, @Cast("const uint32_t") int dims_count);
public static native TRITONSERVER_Error TRITONBACKEND_StateNew(
    @ByPtrPtr TRITONBACKEND_State state, TRITONBACKEND_Request request,
    String name, @Cast("const TRITONSERVER_DataType") int datatype,
    @Cast("const int64_t*") LongPointer shape, @Cast("const uint32_t") int dims_count);
public static native TRITONSERVER_Error TRITONBACKEND_StateNew(
    @ByPtrPtr TRITONBACKEND_State state, TRITONBACKEND_Request request,
    @Cast("const char*") BytePointer name, @Cast("const TRITONSERVER_DataType") int datatype,
    @Cast("const int64_t*") LongBuffer shape, @Cast("const uint32_t") int dims_count);
public static native TRITONSERVER_Error TRITONBACKEND_StateNew(
    @ByPtrPtr TRITONBACKEND_State state, TRITONBACKEND_Request request,
    String name, @Cast("const TRITONSERVER_DataType") int datatype,
    @Cast("const int64_t*") long[] shape, @Cast("const uint32_t") int dims_count);
public static native TRITONSERVER_Error TRITONBACKEND_StateNew(
    @ByPtrPtr TRITONBACKEND_State state, TRITONBACKEND_Request request,
    @Cast("const char*") BytePointer name, @Cast("const TRITONSERVER_DataType") int datatype,
    @Cast("const int64_t*") LongPointer shape, @Cast("const uint32_t") int dims_count);
public static native TRITONSERVER_Error TRITONBACKEND_StateNew(
    @ByPtrPtr TRITONBACKEND_State state, TRITONBACKEND_Request request,
    String name, @Cast("const TRITONSERVER_DataType") int datatype,
    @Cast("const int64_t*") LongBuffer shape, @Cast("const uint32_t") int dims_count);
public static native TRITONSERVER_Error TRITONBACKEND_StateNew(
    @ByPtrPtr TRITONBACKEND_State state, TRITONBACKEND_Request request,
    @Cast("const char*") BytePointer name, @Cast("const TRITONSERVER_DataType") int datatype,
    @Cast("const int64_t*") long[] shape, @Cast("const uint32_t") int dims_count);

/** Update the state for the sequence. Calling this function will replace the
 *  state stored for this sequence in Triton with 'state' provided in the
 *  function argument. If this function is called when sequence batching is not
 *  enabled or there is no 'states' section in the sequence batching section of
 *  the model configuration, this call will return an error. The backend is not
 *  required to call this function. If the backend doesn't call
 *  TRITONBACKEND_StateUpdate function, this particular state for the sequence
 *  will not be updated and the next inference request in the sequence will use
 *  the same state as the current inference request.
 * 
 *  @param state The state.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_StateUpdate(
    TRITONBACKEND_State state);

/** Get a buffer to use to hold the tensor data for the state. The returned
 *  buffer is owned by the state and so should not be freed by the caller. The
 *  caller can and should fill the buffer with the state data. The buffer must
 *  not be accessed by the backend after TRITONBACKEND_StateUpdate is called.
 *  The caller should fill the buffer before calling TRITONBACKEND_StateUpdate.
 * 
 *  @param state The state.
 *  @param buffer Returns a pointer to a buffer where the contents of the state
 *  should be placed.
 *  @param buffer_byte_size The size, in bytes, of the buffer required
 *  by the caller.
 *  @param memory_type Acts as both input and output. On input gives
 *  the buffer memory type preferred by the caller.  Returns the
 *  actual memory type of 'buffer'.
 *  @param memory_type_id Acts as both input and output. On input
 *  gives the buffer memory type id preferred by the caller. Returns
 *  the actual memory type id of 'buffer'.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_StateBuffer(
    TRITONBACKEND_State state, @Cast("void**") PointerPointer buffer, @Cast("const uint64_t") long buffer_byte_size,
    @Cast("TRITONSERVER_MemoryType*") IntPointer memory_type, @Cast("int64_t*") LongPointer memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_StateBuffer(
    TRITONBACKEND_State state, @Cast("void**") @ByPtrPtr Pointer buffer, @Cast("const uint64_t") long buffer_byte_size,
    @Cast("TRITONSERVER_MemoryType*") IntPointer memory_type, @Cast("int64_t*") LongPointer memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_StateBuffer(
    TRITONBACKEND_State state, @Cast("void**") @ByPtrPtr Pointer buffer, @Cast("const uint64_t") long buffer_byte_size,
    @Cast("TRITONSERVER_MemoryType*") IntBuffer memory_type, @Cast("int64_t*") LongBuffer memory_type_id);
public static native TRITONSERVER_Error TRITONBACKEND_StateBuffer(
    TRITONBACKEND_State state, @Cast("void**") @ByPtrPtr Pointer buffer, @Cast("const uint64_t") long buffer_byte_size,
    @Cast("TRITONSERVER_MemoryType*") int[] memory_type, @Cast("int64_t*") long[] memory_type_id);

/** Get the buffer attributes associated with the given state buffer.
 *  The returned 'buffer_attributes' is owned by the state and so should not be
 *  modified or freed by the caller. The lifetime of the 'buffer_attributes'
 *  matches that of the state.
 * 
 *  @param state The state.
 *  @param buffer_attributes Returns the buffer attributes for the given state.
 *  @return a TRITONSERVER_Error indicating success or failure. */


///
///
///
///
///
///
///
public static native TRITONSERVER_Error TRITONBACKEND_StateBufferAttributes(
    TRITONBACKEND_State state,
    @Cast("TRITONSERVER_BufferAttributes**") PointerPointer buffer_attributes);
public static native TRITONSERVER_Error TRITONBACKEND_StateBufferAttributes(
    TRITONBACKEND_State state,
    @ByPtrPtr TRITONSERVER_BufferAttributes buffer_attributes);

/**
 *  TRITONBACKEND_Backend
 * 
 *  Object representing a backend.
 * 
 <p>
 *  TRITONBACKEND_ExecutionPolicy
 * 
 *  Types of execution policy that can be implemented by a backend.
 * 
 *    TRITONBACKEND_EXECUTION_BLOCKING: An instance of the model
 *      blocks in TRITONBACKEND_ModelInstanceExecute until it is ready
 *      to handle another inference. Upon returning from
 *      TRITONBACKEND_ModelInstanceExecute, Triton may immediately
 *      call TRITONBACKEND_ModelInstanceExecute for the same instance
 *      to execute a new batch of requests. Thus, most backends using
 *      this policy will not return from
 *      TRITONBACKEND_ModelInstanceExecute until all responses have
 *      been sent and all requests have been released. This is the
 *      default execution policy.
 * 
 *    TRITONBACKEND_EXECUTION_DEVICE_BLOCKING: An instance, A, of the
 *      model blocks in TRITONBACKEND_ModelInstanceExecute if the
 *      device associated with the instance is unable to handle
 *      another inference. Even if another instance, B, associated
 *      with the device, is available and ready to perform an
 *      inference, Triton will not invoke
 *      TRITONBACKEND_ModeInstanceExecute for B until A returns from
 *      TRITONBACKEND_ModelInstanceExecute. Triton will not be blocked
 *      from calling TRITONBACKEND_ModelInstanceExecute for instance
 *      C, which is associated with a different device than A and B,
 *      even if A or B has not returned from
 *      TRITONBACKEND_ModelInstanceExecute. This execution policy is
 *      typically used by a backend that can cooperatively execute
 *      multiple model instances on the same device.
 *  */
/** enum TRITONBACKEND_ExecutionPolicy */
public static final int
  TRITONBACKEND_EXECUTION_BLOCKING = 0,
  TRITONBACKEND_EXECUTION_DEVICE_BLOCKING = 1;

/** Get the name of the backend. The caller does not own the returned
 *  string and must not modify or delete it. The lifetime of the
 *  returned string extends only as long as 'backend'.
 * 
 *  @param backend The backend.
 *  @param name Returns the name of the backend.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONBACKEND_BackendName(
    TRITONBACKEND_Backend backend, @Cast("const char**") PointerPointer name);
public static native TRITONSERVER_Error TRITONBACKEND_BackendName(
    TRITONBACKEND_Backend backend, @Cast("const char**") @ByPtrPtr BytePointer name);
public static native TRITONSERVER_Error TRITONBACKEND_BackendName(
    TRITONBACKEND_Backend backend, @Cast("const char**") @ByPtrPtr ByteBuffer name);
public static native TRITONSERVER_Error TRITONBACKEND_BackendName(
    TRITONBACKEND_Backend backend, @Cast("const char**") @ByPtrPtr byte[] name);

/** Get the backend configuration.  The 'backend_config' message is
 *  owned by Triton and should not be modified or freed by the caller.
 * 
 *  The backend configuration, as JSON, is:
 * 
 *    {
 *      "cmdline" : {
 *        "<setting>" : "<value>",
 *        ...
 *      }
 *    }
 * 
 *  @param backend The backend.
 *  @param backend_config Returns the backend configuration as a message.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_BackendConfig(
    TRITONBACKEND_Backend backend, @Cast("TRITONSERVER_Message**") PointerPointer backend_config);
public static native TRITONSERVER_Error TRITONBACKEND_BackendConfig(
    TRITONBACKEND_Backend backend, @ByPtrPtr TRITONSERVER_Message backend_config);

/** Get the execution policy for this backend. By default the
 *  execution policy is TRITONBACKEND_EXECUTION_BLOCKING.
 * 
 *  @param backend The backend.
 *  @param policy Returns the execution policy.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_BackendExecutionPolicy(
    TRITONBACKEND_Backend backend, @Cast("TRITONBACKEND_ExecutionPolicy*") IntPointer policy);
public static native TRITONSERVER_Error TRITONBACKEND_BackendExecutionPolicy(
    TRITONBACKEND_Backend backend, @Cast("TRITONBACKEND_ExecutionPolicy*") IntBuffer policy);
public static native TRITONSERVER_Error TRITONBACKEND_BackendExecutionPolicy(
    TRITONBACKEND_Backend backend, @Cast("TRITONBACKEND_ExecutionPolicy*") int[] policy);

/** Set the execution policy for this backend. By default the
 *  execution policy is TRITONBACKEND_EXECUTION_BLOCKING. Triton reads
 *  the backend's execution policy after calling
 *  TRITONBACKEND_Initialize, so to be recognized changes to the
 *  execution policy must be made in TRITONBACKEND_Initialize.
 *  Also, note that if using sequence batcher for the model, Triton will
 *  use TRITONBACKEND_EXECUTION_BLOCKING policy irrespective of the
 *  policy specified by this setter function.
 * 
 *  @param backend The backend.
 *  @param policy The execution policy.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONBACKEND_BackendSetExecutionPolicy(
    TRITONBACKEND_Backend backend, @Cast("TRITONBACKEND_ExecutionPolicy") int policy);

/** Get the location of the files that make up the backend
 *  implementation. This location contains the backend shared library
 *  and any other files located with the shared library. The
 *  'location' communicated depends on how the backend is being
 *  communicated to Triton as indicated by 'artifact_type'.
 * 
 *    TRITONBACKEND_ARTIFACT_FILESYSTEM: The backend artifacts are
 *      made available to Triton via the local filesystem. 'location'
 *      returns the full path to the directory containing this
 *      backend's artifacts. The returned string is owned by Triton,
 *      not the caller, and so should not be modified or freed.
 * 
 *  @param backend The backend.
 *  @param artifact_type Returns the artifact type for the backend.
 *  @param path Returns the location.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_BackendArtifacts(
    TRITONBACKEND_Backend backend, @Cast("TRITONBACKEND_ArtifactType*") IntPointer artifact_type,
    @Cast("const char**") PointerPointer location);
public static native TRITONSERVER_Error TRITONBACKEND_BackendArtifacts(
    TRITONBACKEND_Backend backend, @Cast("TRITONBACKEND_ArtifactType*") IntPointer artifact_type,
    @Cast("const char**") @ByPtrPtr BytePointer location);
public static native TRITONSERVER_Error TRITONBACKEND_BackendArtifacts(
    TRITONBACKEND_Backend backend, @Cast("TRITONBACKEND_ArtifactType*") IntBuffer artifact_type,
    @Cast("const char**") @ByPtrPtr ByteBuffer location);
public static native TRITONSERVER_Error TRITONBACKEND_BackendArtifacts(
    TRITONBACKEND_Backend backend, @Cast("TRITONBACKEND_ArtifactType*") int[] artifact_type,
    @Cast("const char**") @ByPtrPtr byte[] location);

/** Get the memory manager associated with a backend.
 * 
 *  @param backend The backend.
 *  @param manager Returns the memory manager.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_BackendMemoryManager(
    TRITONBACKEND_Backend backend, @Cast("TRITONBACKEND_MemoryManager**") PointerPointer manager);
public static native TRITONSERVER_Error TRITONBACKEND_BackendMemoryManager(
    TRITONBACKEND_Backend backend, @ByPtrPtr TRITONBACKEND_MemoryManager manager);

/** Get the user-specified state associated with the backend. The
 *  state is completely owned and managed by the backend.
 * 
 *  @param backend The backend.
 *  @param state Returns the user state, or nullptr if no user state.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_BackendState(
    TRITONBACKEND_Backend backend, @Cast("void**") PointerPointer state);
public static native TRITONSERVER_Error TRITONBACKEND_BackendState(
    TRITONBACKEND_Backend backend, @Cast("void**") @ByPtrPtr Pointer state);

/** Set the user-specified state associated with the backend. The
 *  state is completely owned and managed by the backend.
 * 
 *  @param backend The backend.
 *  @param state The user state, or nullptr if no user state.
 *  @return a TRITONSERVER_Error indicating success or failure. */


///
///
///
///
public static native TRITONSERVER_Error TRITONBACKEND_BackendSetState(
    TRITONBACKEND_Backend backend, Pointer state);

/**
 *  TRITONBACKEND_Model
 * 
 *  Object representing a model implemented using the backend.
 * 
 <p>
 *  Get the name of the model. The returned string is owned by the
 *  model object, not the caller, and so should not be modified or
 *  freed.
 * 
 *  @param model The model.
 *  @param name Returns the model name.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelName(
    TRITONBACKEND_Model model, @Cast("const char**") PointerPointer name);
public static native TRITONSERVER_Error TRITONBACKEND_ModelName(
    TRITONBACKEND_Model model, @Cast("const char**") @ByPtrPtr BytePointer name);
public static native TRITONSERVER_Error TRITONBACKEND_ModelName(
    TRITONBACKEND_Model model, @Cast("const char**") @ByPtrPtr ByteBuffer name);
public static native TRITONSERVER_Error TRITONBACKEND_ModelName(
    TRITONBACKEND_Model model, @Cast("const char**") @ByPtrPtr byte[] name);

/** Get the version of the model.
 * 
 *  @param model The model.
 *  @param version Returns the model version.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONBACKEND_ModelVersion(
    TRITONBACKEND_Model model, @Cast("uint64_t*") LongPointer version);
public static native TRITONSERVER_Error TRITONBACKEND_ModelVersion(
    TRITONBACKEND_Model model, @Cast("uint64_t*") LongBuffer version);
public static native TRITONSERVER_Error TRITONBACKEND_ModelVersion(
    TRITONBACKEND_Model model, @Cast("uint64_t*") long[] version);

/** Get the location of the files that make up the model. The
 *  'location' communicated depends on how the model is being
 *  communicated to Triton as indicated by 'artifact_type'.
 * 
 *    TRITONBACKEND_ARTIFACT_FILESYSTEM: The model artifacts are made
 *      available to Triton via the local filesystem. 'location'
 *      returns the full path to the directory in the model repository
 *      that contains this model's artifacts. The returned string is
 *      owned by Triton, not the caller, and so should not be modified
 *      or freed.
 * 
 *  @param model The model.
 *  @param artifact_type Returns the artifact type for the model.
 *  @param path Returns the location.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelRepository(
    TRITONBACKEND_Model model, @Cast("TRITONBACKEND_ArtifactType*") IntPointer artifact_type,
    @Cast("const char**") PointerPointer location);
public static native TRITONSERVER_Error TRITONBACKEND_ModelRepository(
    TRITONBACKEND_Model model, @Cast("TRITONBACKEND_ArtifactType*") IntPointer artifact_type,
    @Cast("const char**") @ByPtrPtr BytePointer location);
public static native TRITONSERVER_Error TRITONBACKEND_ModelRepository(
    TRITONBACKEND_Model model, @Cast("TRITONBACKEND_ArtifactType*") IntBuffer artifact_type,
    @Cast("const char**") @ByPtrPtr ByteBuffer location);
public static native TRITONSERVER_Error TRITONBACKEND_ModelRepository(
    TRITONBACKEND_Model model, @Cast("TRITONBACKEND_ArtifactType*") int[] artifact_type,
    @Cast("const char**") @ByPtrPtr byte[] location);

/** Get the model configuration. The caller takes ownership of the
 *  message object and must call TRITONSERVER_MessageDelete to release
 *  the object. The configuration is available via this call even
 *  before the model is loaded and so can be used in
 *  TRITONBACKEND_ModelInitialize. TRITONSERVER_ServerModelConfig
 *  returns equivalent information but is not usable until after the
 *  model loads.
 * 
 *  @param model The model.
 *  @param config_version The model configuration will be returned in
 *  a format matching this version. If the configuration cannot be
 *  represented in the requested version's format then an error will
 *  be returned. Currently only version 1 is supported.
 *  @param model_config Returns the model configuration as a message.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelConfig(
    TRITONBACKEND_Model model, @Cast("const uint32_t") int config_version,
    @Cast("TRITONSERVER_Message**") PointerPointer model_config);
public static native TRITONSERVER_Error TRITONBACKEND_ModelConfig(
    TRITONBACKEND_Model model, @Cast("const uint32_t") int config_version,
    @ByPtrPtr TRITONSERVER_Message model_config);

/** Whether the backend should attempt to auto-complete the model configuration.
 *  If true, the model should fill the inputs, outputs, and max batch size in
 *  the model configuration if incomplete. If the model configuration is
 *  changed,  the new configuration must be reported to Triton using
 *  TRITONBACKEND_ModelSetConfig.
 * 
 *  @param model The model.
 *  @param auto_complete_config Returns whether the backend should auto-complete
 *  the model configuration.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelAutoCompleteConfig(
    TRITONBACKEND_Model model, @Cast("bool*") boolean[] auto_complete_config);
public static native TRITONSERVER_Error TRITONBACKEND_ModelAutoCompleteConfig(
    TRITONBACKEND_Model model, @Cast("bool*") BoolPointer auto_complete_config);

/** Set the model configuration in Triton server. This API should only be called
 *  when the backend implements the auto-completion of model configuration
 *  and TRITONBACKEND_ModelAutoCompleteConfig returns true in
 *  auto_complete_config. Only the inputs, outputs, max batch size, and
 *  scheduling choice can be changed. A caveat being scheduling choice can only
 *  be changed if none is previously set. Any other changes to the model
 *  configuration will be ignored by Triton. This function can only be called
 *  from TRITONBACKEND_ModelInitialize, calling in any other context will result
 *  in an error being returned. Additionally, Triton server can add some of the
 *  missing fields in the provided config with this call. The backend must get
 *  the complete configuration again by using TRITONBACKEND_ModelConfig.
 *  TRITONBACKEND_ModelSetConfig does not take ownership of the message object
 *  and so the caller should call TRITONSERVER_MessageDelete to release the
 *  object once the function returns.
 * 
 *  @param model The model.
 *  @param config_version The format version of the model configuration.
 *  If the configuration is not represented in the version's format
 *  then an error will be returned. Currently only version 1 is supported.
 *  @param model_config The updated model configuration as a message.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelSetConfig(
    TRITONBACKEND_Model model, @Cast("const uint32_t") int config_version,
    TRITONSERVER_Message model_config);

/** Get the TRITONSERVER_Server object that this model is being served
 *  by.
 * 
 *  @param model The model.
 *  @param server Returns the server.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelServer(
    TRITONBACKEND_Model model, @Cast("TRITONSERVER_Server**") PointerPointer server);
public static native TRITONSERVER_Error TRITONBACKEND_ModelServer(
    TRITONBACKEND_Model model, @ByPtrPtr TRITONSERVER_Server server);

/** Get the backend used by the model.
 * 
 *  @param model The model.
 *  @param model Returns the backend object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelBackend(
    TRITONBACKEND_Model model, @Cast("TRITONBACKEND_Backend**") PointerPointer backend);
public static native TRITONSERVER_Error TRITONBACKEND_ModelBackend(
    TRITONBACKEND_Model model, @ByPtrPtr TRITONBACKEND_Backend backend);

/** Get the user-specified state associated with the model. The
 *  state is completely owned and managed by the backend.
 * 
 *  @param model The model.
 *  @param state Returns the user state, or nullptr if no user state.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelState(
    TRITONBACKEND_Model model, @Cast("void**") PointerPointer state);
public static native TRITONSERVER_Error TRITONBACKEND_ModelState(
    TRITONBACKEND_Model model, @Cast("void**") @ByPtrPtr Pointer state);

/** Set the user-specified state associated with the model. The
 *  state is completely owned and managed by the backend.
 * 
 *  @param model The model.
 *  @param state The user state, or nullptr if no user state.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelSetState(
    TRITONBACKEND_Model model, Pointer state);

/** Report the memory usage of the model that will be released on
 *  TRITONBACKEND_ModelFinalize. The backend may call this function within the
 *  lifecycle of the TRITONBACKEND_Model object (between
 *  TRITONBACKEND_ModelInitialize and TRITONBACKEND_ModelFinalize) to report the
 *  latest usage. To report the memory usage of a model instance,
 *  see TRITONBACKEND_ModelInstanceReportMemoryUsage.
 * 
 *  @param model The model.
 *  @param usage The list of buffer attributes that records the memory usage,
 *  each entry should record the total memory usage of a given memory type and
 *  id. For example, if the model itself occupies 64 bytes on each of
 *  CUDA device 0 and CUDA device 1. Then 'usage' should have first two entries
 *  set, one has the buffer attributes of "type GPU, id 0, 64 bytes" and the
 *  other has "type GPU, id 1, 64 bytes". 'usage' is owned by the backend and
 *  may be released after the function returns.
 *  @param usage_size The number of entries in 'usage'.
 *  @return a TRITONSERVER_Error indicating success or failure. */


///
///
///
///
public static native TRITONSERVER_Error TRITONBACKEND_ModelReportMemoryUsage(
    TRITONBACKEND_Model model, @Cast("TRITONSERVER_BufferAttributes**") PointerPointer usage,
    @Cast("uint32_t") int usage_size);
public static native TRITONSERVER_Error TRITONBACKEND_ModelReportMemoryUsage(
    TRITONBACKEND_Model model, @ByPtrPtr TRITONSERVER_BufferAttributes usage,
    @Cast("uint32_t") int usage_size);

/**
 *  TRITONBACKEND_ModelInstance
 * 
 *  Object representing a model instance implemented using the
 *  backend.
 * 
 <p>
 *  Get the name of the model instance. The returned string is owned by the
 *  model object, not the caller, and so should not be modified or
 *  freed.
 * 
 *  @param instance The model instance.
 *  @param name Returns the instance name.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceName(
    TRITONBACKEND_ModelInstance instance, @Cast("const char**") PointerPointer name);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceName(
    TRITONBACKEND_ModelInstance instance, @Cast("const char**") @ByPtrPtr BytePointer name);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceName(
    TRITONBACKEND_ModelInstance instance, @Cast("const char**") @ByPtrPtr ByteBuffer name);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceName(
    TRITONBACKEND_ModelInstance instance, @Cast("const char**") @ByPtrPtr byte[] name);

/** Get the kind of the model instance.
 * 
 *  @param instance The model instance.
 *  @param kind Returns the instance kind.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceKind(
    TRITONBACKEND_ModelInstance instance,
    @Cast("TRITONSERVER_InstanceGroupKind*") IntPointer kind);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceKind(
    TRITONBACKEND_ModelInstance instance,
    @Cast("TRITONSERVER_InstanceGroupKind*") IntBuffer kind);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceKind(
    TRITONBACKEND_ModelInstance instance,
    @Cast("TRITONSERVER_InstanceGroupKind*") int[] kind);

/** Get the device ID of the model instance.
 * 
 *  @param instance The model instance.
 *  @param device_id Returns the instance device ID.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceDeviceId(
    TRITONBACKEND_ModelInstance instance, IntPointer device_id);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceDeviceId(
    TRITONBACKEND_ModelInstance instance, IntBuffer device_id);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceDeviceId(
    TRITONBACKEND_ModelInstance instance, int[] device_id);

/** Get the host policy setting.  The 'host_policy' message is
 *  owned by Triton and should not be modified or freed by the caller.
 * 
 *  The host policy setting, as JSON, is:
 * 
 *    {
 *      "<host_policy>" : {
 *        "<setting>" : "<value>",
 *        ...
 *      }
 *    }
 * 
 *  @param instance The model instance.
 *  @param host_policy Returns the host policy setting as a message.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceHostPolicy(
    TRITONBACKEND_ModelInstance instance, @Cast("TRITONSERVER_Message**") PointerPointer host_policy);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceHostPolicy(
    TRITONBACKEND_ModelInstance instance, @ByPtrPtr TRITONSERVER_Message host_policy);

/** Whether the model instance is passive.
 * 
 *  @param instance The model instance.
 *  @param is_passive Returns true if the instance is passive, false otherwise
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceIsPassive(
    TRITONBACKEND_ModelInstance instance, @Cast("bool*") boolean[] is_passive);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceIsPassive(
    TRITONBACKEND_ModelInstance instance, @Cast("bool*") BoolPointer is_passive);

/** Get the number of optimization profiles to be loaded for the instance.
 * 
 *  @param instance The model instance.
 *  @param count Returns the number of optimization profiles.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceProfileCount(
    TRITONBACKEND_ModelInstance instance, @Cast("uint32_t*") IntPointer count);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceProfileCount(
    TRITONBACKEND_ModelInstance instance, @Cast("uint32_t*") IntBuffer count);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceProfileCount(
    TRITONBACKEND_ModelInstance instance, @Cast("uint32_t*") int[] count);

/** Get the name of optimization profile. The caller does not own
 *  the returned string and must not modify or delete it. The lifetime
 *  of the returned string extends only as long as 'instance'.
 * 
 *  @param instance The model instance.
 *  @param index The index of the optimization profile. Must be 0
 *  <= index < count, where count is the value returned by
 *  TRITONBACKEND_ModelInstanceProfileCount.
 *  @param profile_name Returns the name of the optimization profile
 *  corresponding to the index.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceProfileName(
    TRITONBACKEND_ModelInstance instance, @Cast("const uint32_t") int index,
    @Cast("const char**") PointerPointer profile_name);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceProfileName(
    TRITONBACKEND_ModelInstance instance, @Cast("const uint32_t") int index,
    @Cast("const char**") @ByPtrPtr BytePointer profile_name);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceProfileName(
    TRITONBACKEND_ModelInstance instance, @Cast("const uint32_t") int index,
    @Cast("const char**") @ByPtrPtr ByteBuffer profile_name);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceProfileName(
    TRITONBACKEND_ModelInstance instance, @Cast("const uint32_t") int index,
    @Cast("const char**") @ByPtrPtr byte[] profile_name);

/** Get the number of secondary devices configured for the instance.
 * 
 *  @param instance The model instance.
 *  @param count Returns the number of secondary devices.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceSecondaryDeviceCount(
    TRITONBACKEND_ModelInstance instance, @Cast("uint32_t*") IntPointer count);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceSecondaryDeviceCount(
    TRITONBACKEND_ModelInstance instance, @Cast("uint32_t*") IntBuffer count);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceSecondaryDeviceCount(
    TRITONBACKEND_ModelInstance instance, @Cast("uint32_t*") int[] count);

/** Get the properties of indexed secondary device. The returned
 *  strings and other properties are owned by the instance, not the
 *  caller, and so should not be modified or freed.
 * 
 *  @param instance The model instance.
 *  @param index The index of the secondary device. Must be 0
 *  <= index < count, where count is the value returned by
 *  TRITONBACKEND_ModelInstanceSecondaryDeviceCount.
 *  @param kind Returns the kind of secondary device corresponding
 *  to the index.
 *  @param id Returns the id of secondary device corresponding to the index.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceSecondaryDeviceProperties(
    TRITONBACKEND_ModelInstance instance, @Cast("uint32_t") int index, @Cast("const char**") PointerPointer kind,
    @Cast("int64_t*") LongPointer id);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceSecondaryDeviceProperties(
    TRITONBACKEND_ModelInstance instance, @Cast("uint32_t") int index, @Cast("const char**") @ByPtrPtr BytePointer kind,
    @Cast("int64_t*") LongPointer id);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceSecondaryDeviceProperties(
    TRITONBACKEND_ModelInstance instance, @Cast("uint32_t") int index, @Cast("const char**") @ByPtrPtr ByteBuffer kind,
    @Cast("int64_t*") LongBuffer id);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceSecondaryDeviceProperties(
    TRITONBACKEND_ModelInstance instance, @Cast("uint32_t") int index, @Cast("const char**") @ByPtrPtr byte[] kind,
    @Cast("int64_t*") long[] id);

/** Get the model associated with a model instance.
 * 
 *  @param instance The model instance.
 *  @param backend Returns the model object.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceModel(
    TRITONBACKEND_ModelInstance instance, @Cast("TRITONBACKEND_Model**") PointerPointer model);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceModel(
    TRITONBACKEND_ModelInstance instance, @ByPtrPtr TRITONBACKEND_Model model);

/** Get the user-specified state associated with the model
 *  instance. The state is completely owned and managed by the
 *  backend.
 * 
 *  @param instance The model instance.
 *  @param state Returns the user state, or nullptr if no user state.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceState(
    TRITONBACKEND_ModelInstance instance, @Cast("void**") PointerPointer state);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceState(
    TRITONBACKEND_ModelInstance instance, @Cast("void**") @ByPtrPtr Pointer state);

/** Set the user-specified state associated with the model
 *  instance. The state is completely owned and managed by the
 *  backend.
 * 
 *  @param instance The model instance.
 *  @param state The user state, or nullptr if no user state.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceSetState(
    TRITONBACKEND_ModelInstance instance, Pointer state);

/** Report the memory usage of the model instance that will be released on
 *  TRITONBACKEND_ModelInstanceFinalize. The backend may call this function
 *  within the lifecycle of the TRITONBACKEND_Model object (between
 *  TRITONBACKEND_ModelInstanceInitialize and
 *  TRITONBACKEND_ModelInstanceFinalize) to report the latest usage. To report
 *  the memory usage of the model, see TRITONBACKEND_ModelReportMemoryUsage.
 * 
 *  @param instance The model instance.
 *  @param usage The list of buffer attributes that records the memory usage,
 *  each entry should record the total memory usage of a given memory type and
 *  id. For example, if the instance itself occupies 64 bytes on each of
 *  CUDA device 0 and CUDA device 1. Then 'usage' should have first two entries
 *  set, one has the buffer attributes of "type GPU, id 0, 64 bytes" and the
 *  other has "type GPU, id 1, 64 bytes". 'usage' is owned by the backend and
 *  may be released after the function returns.
 *  @param usage_size The number of entries in 'usage'.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
///
///
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceReportMemoryUsage(
    TRITONBACKEND_ModelInstance instance,
    @Cast("TRITONSERVER_BufferAttributes**") PointerPointer usage, @Cast("uint32_t") int usage_size);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceReportMemoryUsage(
    TRITONBACKEND_ModelInstance instance,
    @ByPtrPtr TRITONSERVER_BufferAttributes usage, @Cast("uint32_t") int usage_size);

/** Record statistics for an inference request.
 * 
 *  Set 'success' true to indicate that the inference request
 *  completed successfully. In this case all timestamps should be
 *  non-zero values reported in nanoseconds and should be collected
 *  using std::chrono::steady_clock::now().time_since_epoch() or the equivalent.
 *  Set 'success' to false to indicate that the inference request failed
 *  to complete successfully. In this case all timestamps values are
 *  ignored.
 * 
 *  For consistency of measurement across different backends, the
 *  timestamps should be collected at the following points during
 *  TRITONBACKEND_ModelInstanceExecute.
 * 
 *    TRITONBACKEND_ModelInstanceExecute()
 *      CAPTURE TIMESPACE (exec_start_ns)
 *      < process input tensors to prepare them for inference
 *        execution, including copying the tensors to/from GPU if
 *        necessary>
 *      CAPTURE TIMESPACE (compute_start_ns)
 *      < perform inference computations to produce outputs >
 *      CAPTURE TIMESPACE (compute_end_ns)
 *      < allocate output buffers and extract output tensors, including
 *        copying the tensors to/from GPU if necessary>
 *      CAPTURE TIMESPACE (exec_end_ns)
 *      return
 * 
 *  Note that these statistics are associated with a valid
 *  TRITONBACKEND_Request object and so must be reported before the
 *  request is released. For backends that release the request before
 *  all response(s) are sent, these statistics cannot capture
 *  information about the time required to produce the response.
 * 
 *  @param instance The model instance.
 *  @param request The inference request that statistics are being
 *  reported for.
 *  @param success True if the inference request completed
 *  successfully, false if it failed to complete.
 *  @param exec_start_ns Timestamp for the start of execution.
 *  @param compute_start_ns Timestamp for the start of execution
 *  computations.
 *  @param compute_end_ns Timestamp for the end of execution
 *  computations.
 *  @param exec_end_ns Timestamp for the end of execution.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceReportStatistics(
    TRITONBACKEND_ModelInstance instance, TRITONBACKEND_Request request,
    @Cast("const bool") boolean success, @Cast("const uint64_t") long exec_start_ns,
    @Cast("const uint64_t") long compute_start_ns, @Cast("const uint64_t") long compute_end_ns,
    @Cast("const uint64_t") long exec_end_ns);

/** Record statistics for the execution of an entire batch of
 *  inference requests.
 * 
 *  All timestamps should be non-zero values reported in nanoseconds
 *  and should be collected using
 *  std::chrono::steady_clock::now().time_since_epoch() or the equivalent.
 *  See TRITONBACKEND_ModelInstanceReportStatistics for more information about
 *  the timestamps.
 * 
 *  'batch_size' is the sum of the batch sizes for the individual
 *  requests that were delivered together in the call to
 *  TRITONBACKEND_ModelInstanceExecute. For example, if three requests
 *  are passed to TRITONBACKEND_ModelInstanceExecute and those
 *  requests have batch size 1, 2, and 3; then 'batch_size' should be
 *  set to 6.
 * 
 *  @param instance The model instance.
 *  @param batch_size Combined batch size of all the individual
 *  requests executed in the batch.
 *  @param exec_start_ns Timestamp for the start of execution.
 *  @param compute_start_ns Timestamp for the start of execution
 *  computations.
 *  @param compute_end_ns Timestamp for the end of execution
 *  computations.
 *  @param exec_end_ns Timestamp for the end of execution.
 *  @return a TRITONSERVER_Error indicating success or failure. */


///
///
///
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceReportBatchStatistics(
    TRITONBACKEND_ModelInstance instance, @Cast("const uint64_t") long batch_size,
    @Cast("const uint64_t") long exec_start_ns, @Cast("const uint64_t") long compute_start_ns,
    @Cast("const uint64_t") long compute_end_ns, @Cast("const uint64_t") long exec_end_ns);

/**
 *  The following functions can be implemented by a backend. Functions
 *  indicated as required must be implemented or the backend will fail
 *  to load.
 * 
 <p>
 *  Initialize a backend. This function is optional, a backend is not
 *  required to implement it. This function is called once when a
 *  backend is loaded to allow the backend to initialize any state
 *  associated with the backend. A backend has a single state that is
 *  shared across all models that use the backend.
 * 
 *  @param backend The backend.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_Initialize(
    TRITONBACKEND_Backend backend);

/** Finalize for a backend. This function is optional, a backend is
 *  not required to implement it. This function is called once, just
 *  before the backend is unloaded. All state associated with the
 *  backend should be freed and any threads created for the backend
 *  should be exited/joined before returning from this function.
 * 
 *  @param backend The backend.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_Finalize(
    TRITONBACKEND_Backend backend);

/** Initialize for a model. This function is optional, a backend is
 *  not required to implement it. This function is called once when a
 *  model that uses the backend is loaded to allow the backend to
 *  initialize any state associated with the model. The backend should
 *  also examine the model configuration to determine if the
 *  configuration is suitable for the backend. Any errors reported by
 *  this function will prevent the model from loading.
 * 
 *  @param model The model.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelInitialize(
    TRITONBACKEND_Model model);

/** Finalize for a model. This function is optional, a backend is not
 *  required to implement it. This function is called once for a
 *  model, just before the model is unloaded from Triton. All state
 *  associated with the model should be freed and any threads created
 *  for the model should be exited/joined before returning from this
 *  function.
 * 
 *  @param model The model.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelFinalize(
    TRITONBACKEND_Model model);

/** Initialize for a model instance. This function is optional, a
 *  backend is not required to implement it. This function is called
 *  once when a model instance is created to allow the backend to
 *  initialize any state associated with the instance.
 * 
 *  @param instance The model instance.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceInitialize(
    TRITONBACKEND_ModelInstance instance);

/** Finalize for a model instance. This function is optional, a
 *  backend is not required to implement it. This function is called
 *  once for an instance, just before the corresponding model is
 *  unloaded from Triton. All state associated with the instance
 *  should be freed and any threads created for the instance should be
 *  exited/joined before returning from this function.
 * 
 *  @param instance The model instance.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceFinalize(
    TRITONBACKEND_ModelInstance instance);

/** Execute a batch of one or more requests on a model instance. This
 *  function is required. Triton will not perform multiple
 *  simultaneous calls to this function for a given model 'instance';
 *  however, there may be simultaneous calls for different model
 *  instances (for the same or different models).
 * 
 *  If an error is returned the ownership of the request objects
 *  remains with Triton and the backend must not retain references to
 *  the request objects or access them in any way.
 * 
 *  If success is returned, ownership of the request objects is
 *  transferred to the backend and it is then responsible for creating
 *  responses and releasing the request objects. Note that even though
 *  ownership of the request objects is transferred to the backend, the
 *  ownership of the buffer holding request pointers is returned back
 *  to Triton upon return from TRITONBACKEND_ModelInstanceExecute. If
 *  any request objects need to be maintained beyond
 *  TRITONBACKEND_ModelInstanceExecute, then the pointers must be copied
 *  out of the array within TRITONBACKEND_ModelInstanceExecute.
 * 
 *  @param instance The model instance.
 *  @param requests The requests.
 *  @param request_count The number of requests in the batch.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceExecute(
    TRITONBACKEND_ModelInstance instance, @Cast("TRITONBACKEND_Request**") PointerPointer requests,
    @Cast("const uint32_t") int request_count);
public static native TRITONSERVER_Error TRITONBACKEND_ModelInstanceExecute(
    TRITONBACKEND_ModelInstance instance, @ByPtrPtr TRITONBACKEND_Request requests,
    @Cast("const uint32_t") int request_count);

/** Query the backend for different model attributes. This function is optional,
 *  a backend is not required to implement it. The backend is also not required
 *  to set all backend attribute listed. This function is called when
 *  Triton requires further backend / model information to perform operations.
 *  This function may be called multiple times within the lifetime of the
 *  backend (between TRITONBACKEND_Initialize and TRITONBACKEND_Finalize).
 *  The backend may return error to indicate failure to set the backend
 *  attributes, and the attributes specified in the same function call will be
 *  ignored. Triton will update the specified attributes if 'nullptr' is
 *  returned.
 * 
 *  @param backend The backend.
 *  @param backend_attributes Return the backend attribute.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONBACKEND_GetBackendAttribute(
    TRITONBACKEND_Backend backend,
    TRITONBACKEND_BackendAttribute backend_attributes);

/** TRITONBACKEND_BackendAttribute
 * 
 *  API to modify attributes associated with a backend.
 * 
 <p>
 *  Add the preferred instance group of the backend. This function
 *  can be called multiple times to cover different instance group kinds that
 *  the backend supports, given the priority order that the first call describes
 *  the most preferred group. In the case where instance group are not
 *  explicitly provided, Triton will use this attribute to create model
 *  deployment that aligns more with the backend preference.
 * 
 *  @param backend_attributes The backend attributes object.
 *  @param kind The kind of the instance group.
 *  @param count The number of instances per device. Triton default will be used
 *  if 0 is provided.
 *  @param device_ids The devices where instances should be available. Triton
 *  default will be used if 'nullptr' is provided.
 *  @param id_count The number of devices in 'device_ids'.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONBACKEND_BackendAttributeAddPreferredInstanceGroup(
    TRITONBACKEND_BackendAttribute backend_attributes,
    @Cast("const TRITONSERVER_InstanceGroupKind") int kind, @Cast("const uint64_t") long count,
    @Cast("const uint64_t*") LongPointer device_ids, @Cast("const uint64_t") long id_count);
public static native TRITONSERVER_Error TRITONBACKEND_BackendAttributeAddPreferredInstanceGroup(
    TRITONBACKEND_BackendAttribute backend_attributes,
    @Cast("const TRITONSERVER_InstanceGroupKind") int kind, @Cast("const uint64_t") long count,
    @Cast("const uint64_t*") LongBuffer device_ids, @Cast("const uint64_t") long id_count);
public static native TRITONSERVER_Error TRITONBACKEND_BackendAttributeAddPreferredInstanceGroup(
    TRITONBACKEND_BackendAttribute backend_attributes,
    @Cast("const TRITONSERVER_InstanceGroupKind") int kind, @Cast("const uint64_t") long count,
    @Cast("const uint64_t*") long[] device_ids, @Cast("const uint64_t") long id_count);

/** Sets whether or not the backend supports concurrently loading multiple
 *  TRITONBACKEND_ModelInstances in a thread-safe manner.
 * 
 *  Most backends are thread-safe for parallel execution of model instances as
 *  that is the primary use of concurrency in backends. However, not all
 *  backends are thread-safe when initializing or finalizing model instances. In
 *  order for Triton to know that it can safely load instances concurrently, the
 *  backend needs to opt-in by setting this backend attribute to true. By
 *  default, this attribute is false and calls to the
 *  TRITONBACKEND_ModelInstanceInitialize function will be made serially. If
 *  this attribute is set to true, then Triton will make calls to
 *  TRITONBACKEND_ModelInstanceInitialize concurrently.
 * 
 *  @param backend_attributes The backend attributes object.
 *  @param enabled Whether or not the backend supports loading model instances
 *  in parallel. */

///
///
///
///
public static native TRITONSERVER_Error TRITONBACKEND_BackendAttributeSetParallelModelInstanceLoading(
    TRITONBACKEND_BackendAttribute backend_attributes, @Cast("bool") boolean enabled);

/** TRITONBACKEND Batching
 * 
 *  API to add custom batching strategy
 * 
 *  The following functions can be implemented by a backend to add custom
 *  batching conditionals on top of the existing Triton batching strategy. The
 *  functions are optional but all or none must be implemented.
 * 
 <p>
 *  Create a new batcher for use with custom batching. This is called during
 *  model loading. The batcher will point to a user-defined data structure that
 *  holds read-only data used for custom batching.
 * 
 *  @param batcher User-defined placeholder for backend to store and
 *  retrieve information about the batching strategy for this
 *  model.RITONBACKEND_ISPEC return a TRITONSERVER_Error indicating success or
 *  failure. @param model The backend model for which Triton is forming a batch.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelBatcherInitialize(
    @Cast("TRITONBACKEND_Batcher**") PointerPointer batcher, TRITONBACKEND_Model model);
public static native TRITONSERVER_Error TRITONBACKEND_ModelBatcherInitialize(
    @ByPtrPtr TRITONBACKEND_Batcher batcher, TRITONBACKEND_Model model);

/** Free memory associated with batcher. This is called during model unloading.
 * 
 *  @param batcher User-defined placeholder for backend to store and
 *  retrieve information about the batching strategy for this model.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelBatcherFinalize(
    TRITONBACKEND_Batcher batcher);

/** Check whether a request should be added to the pending model batch.
 * 
 *  @param request The request to be added to the pending batch.
 *  @param userp The placeholder for backend to store and retrieve information
 *  about this pending batch. When the callback returns, this should reflect
 *  the latest batch information.
 *  @param should_include The pointer to be updated on whether the request
 *  should be included in the batch.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelBatchIncludeRequest(
    TRITONBACKEND_Request request, Pointer userp, @Cast("bool*") boolean[] should_include);
public static native TRITONSERVER_Error TRITONBACKEND_ModelBatchIncludeRequest(
    TRITONBACKEND_Request request, Pointer userp, @Cast("bool*") BoolPointer should_include);

/** Callback to be invoked when Triton has begun forming a batch.
 * 
 *  @param batcher The read-only placeholder for backend to retrieve */
// information about the batching strategy for this model.
/** @param userp The placeholder for backend to store and retrieve information
/** about this pending batch.
/** @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelBatchInitialize(
    @Const TRITONBACKEND_Batcher batcher, @Cast("void**") PointerPointer userp);
public static native TRITONSERVER_Error TRITONBACKEND_ModelBatchInitialize(
    @Const TRITONBACKEND_Batcher batcher, @Cast("void**") @ByPtrPtr Pointer userp);

/** Callback to be invoked when Triton has finishing forming a batch.
 * 
 *  @param userp The placeholder for backend to store and retrieve information
 *  about this pending batch.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_ModelBatchFinalize(
    Pointer userp);

/** Get all information about an output tensor by its name. The caller does
 *  not own any of the referenced return values and must not modify or delete
 *  them. The lifetime of all returned values extends until 'response' is
 *  deleted.
 * 
 *  @param response The response object.
 *  @param name The name of the output.
 *  @param datatype Returns the type of the output.
 *  @param shape Returns the shape of the output.
 *  @param dim_count Returns the number of dimensions of the returned
 *  shape.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONBACKEND_InferenceResponseOutputByName(
    TRITONBACKEND_Response response, String name,
    @Cast("TRITONSERVER_DataType*") IntPointer datatype, @Cast("const int64_t**") PointerPointer shape,
    @Cast("uint64_t*") LongPointer dim_count);
public static native TRITONSERVER_Error TRITONBACKEND_InferenceResponseOutputByName(
    TRITONBACKEND_Response response, String name,
    @Cast("TRITONSERVER_DataType*") IntPointer datatype, @Cast("const int64_t**") @ByPtrPtr LongPointer shape,
    @Cast("uint64_t*") LongPointer dim_count);
public static native TRITONSERVER_Error TRITONBACKEND_InferenceResponseOutputByName(
    TRITONBACKEND_Response response, @Cast("const char*") BytePointer name,
    @Cast("TRITONSERVER_DataType*") IntBuffer datatype, @Cast("const int64_t**") @ByPtrPtr LongBuffer shape,
    @Cast("uint64_t*") LongBuffer dim_count);
public static native TRITONSERVER_Error TRITONBACKEND_InferenceResponseOutputByName(
    TRITONBACKEND_Response response, String name,
    @Cast("TRITONSERVER_DataType*") int[] datatype, @Cast("const int64_t**") @ByPtrPtr long[] shape,
    @Cast("uint64_t*") long[] dim_count);
public static native TRITONSERVER_Error TRITONBACKEND_InferenceResponseOutputByName(
    TRITONBACKEND_Response response, @Cast("const char*") BytePointer name,
    @Cast("TRITONSERVER_DataType*") IntPointer datatype, @Cast("const int64_t**") @ByPtrPtr LongPointer shape,
    @Cast("uint64_t*") LongPointer dim_count);
public static native TRITONSERVER_Error TRITONBACKEND_InferenceResponseOutputByName(
    TRITONBACKEND_Response response, String name,
    @Cast("TRITONSERVER_DataType*") IntBuffer datatype, @Cast("const int64_t**") @ByPtrPtr LongBuffer shape,
    @Cast("uint64_t*") LongBuffer dim_count);
public static native TRITONSERVER_Error TRITONBACKEND_InferenceResponseOutputByName(
    TRITONBACKEND_Response response, @Cast("const char*") BytePointer name,
    @Cast("TRITONSERVER_DataType*") int[] datatype, @Cast("const int64_t**") @ByPtrPtr long[] shape,
    @Cast("uint64_t*") long[] dim_count);

/** Get all information about an output tensor by its index. The caller does
 *  not own any of the referenced return values and must not modify or delete
 *  them. The lifetime of all returned values extends until 'response' is
 *  deleted.
 * 
 *  @param response The response object.
 *  @param index The index of the output tensor, must be 0 <= index <
 *  count, where 'count' is the value returned by
 *  TRITONSERVER_InferenceResponseOutputCount.
 *  @param name Returns the name of the output.
 *  @param datatype Returns the type of the output.
 *  @param shape Returns the shape of the output.
 *  @param dim_count Returns the number of dimensions of the returned
 *  shape.
 *  @return a TRITONSERVER_Error indicating success or failure. */
public static native TRITONSERVER_Error TRITONBACKEND_InferenceResponseOutput(
    TRITONBACKEND_Response response, @Cast("const uint32_t") int index, @Cast("const char**") PointerPointer name,
    @Cast("TRITONSERVER_DataType*") IntPointer datatype, @Cast("const int64_t**") PointerPointer shape,
    @Cast("uint64_t*") LongPointer dim_count);
public static native TRITONSERVER_Error TRITONBACKEND_InferenceResponseOutput(
    TRITONBACKEND_Response response, @Cast("const uint32_t") int index, @Cast("const char**") @ByPtrPtr BytePointer name,
    @Cast("TRITONSERVER_DataType*") IntPointer datatype, @Cast("const int64_t**") @ByPtrPtr LongPointer shape,
    @Cast("uint64_t*") LongPointer dim_count);
public static native TRITONSERVER_Error TRITONBACKEND_InferenceResponseOutput(
    TRITONBACKEND_Response response, @Cast("const uint32_t") int index, @Cast("const char**") @ByPtrPtr ByteBuffer name,
    @Cast("TRITONSERVER_DataType*") IntBuffer datatype, @Cast("const int64_t**") @ByPtrPtr LongBuffer shape,
    @Cast("uint64_t*") LongBuffer dim_count);
public static native TRITONSERVER_Error TRITONBACKEND_InferenceResponseOutput(
    TRITONBACKEND_Response response, @Cast("const uint32_t") int index, @Cast("const char**") @ByPtrPtr byte[] name,
    @Cast("TRITONSERVER_DataType*") int[] datatype, @Cast("const int64_t**") @ByPtrPtr long[] shape,
    @Cast("uint64_t*") long[] dim_count);

// #ifdef __cplusplus
// #endif


// Parsed from tritonrepoagent.h

// Copyright (c) 2020-2021, NVIDIA CORPORATION. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of NVIDIA CORPORATION nor the names of its
//    contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// #pragma once

// #include <stddef.h>
// #include <stdint.h>

// #include "triton/core/tritonserver.h"

// #ifdef __cplusplus
// #endif

// #ifdef _COMPILING_TRITONREPOAGENT
// #if defined(_MSC_VER)
// #define TRITONREPOAGENT_DECLSPEC __declspec(dllexport)
// #define TRITONREPOAGENT_ISPEC __declspec(dllimport)
// #elif defined(__GNUC__)
// #define TRITONREPOAGENT_DECLSPEC __attribute__((__visibility__("default")))
// #define TRITONREPOAGENT_ISPEC
// #else
// #define TRITONREPOAGENT_DECLSPEC
// #define TRITONREPOAGENT_ISPEC
// #endif
// #else
// #if defined(_MSC_VER)
// #define TRITONREPOAGENT_DECLSPEC __declspec(dllimport)
// #define TRITONREPOAGENT_ISPEC __declspec(dllexport)
// #else
// #define TRITONREPOAGENT_DECLSPEC
// #define TRITONREPOAGENT_ISPEC
// Targeting ../tritonserver/TRITONREPOAGENT_Agent.java


// Targeting ../tritonserver/TRITONREPOAGENT_AgentModel.java



/**
 *  TRITONREPOAGENT API Version
 * 
 *  The TRITONREPOAGENT API is versioned with major and minor version
 *  numbers. Any change to the API that does not impact backwards
 *  compatibility (for example, adding a non-required function)
 *  increases the minor version number. Any change that breaks
 *  backwards compatibility (for example, deleting or changing the
 *  behavior of a function) increases the major version number. A
 *  repository agent should check that the API version used to compile
 *  the agent is compatible with the API version of the Triton server
 *  that it is running in. This is typically done by code similar to
 *  the following which makes sure that the major versions are equal
 *  and that the minor version of Triton is >= the minor version used
 *  to build the agent.
 * 
 *    uint32_t api_version_major, api_version_minor;
 *    TRITONREPOAGENT_ApiVersion(&api_version_major, &api_version_minor);
 *    if ((api_version_major != TRITONREPOAGENT_API_VERSION_MAJOR) ||
 *        (api_version_minor < TRITONREPOAGENT_API_VERSION_MINOR)) {
 *      return TRITONSERVER_ErrorNew(
 *        TRITONSERVER_ERROR_UNSUPPORTED,
 *        "triton repository agent API version does not support this agent");
 *    }
 *  */
public static final int TRITONREPOAGENT_API_VERSION_MAJOR = 0;

///
public static final int TRITONREPOAGENT_API_VERSION_MINOR = 1;

/** Get the TRITONREPOAGENT API version supported by Triton. This
 *  value can be compared against the
 *  TRITONREPOAGENT_API_VERSION_MAJOR and
 *  TRITONREPOAGENT_API_VERSION_MINOR used to build the agent to
 *  ensure that Triton is compatible with the agent.
 * 
 *  @param major Returns the TRITONREPOAGENT API major version supported
 *  by Triton.
 *  @param minor Returns the TRITONREPOAGENT API minor version supported
 *  by Triton.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
///
public static native TRITONSERVER_Error TRITONREPOAGENT_ApiVersion(
    @Cast("uint32_t*") IntPointer major, @Cast("uint32_t*") IntPointer minor);
public static native TRITONSERVER_Error TRITONREPOAGENT_ApiVersion(
    @Cast("uint32_t*") IntBuffer major, @Cast("uint32_t*") IntBuffer minor);
public static native TRITONSERVER_Error TRITONREPOAGENT_ApiVersion(
    @Cast("uint32_t*") int[] major, @Cast("uint32_t*") int[] minor);

/** TRITONREPOAGENT_ArtifactType
 * 
 *  The ways that the files that make up a model's repository content
 *  are communicated between Triton and the agent.
 * 
 *    TRITONREPOAGENT_ARTIFACT_FILESYSTEM: The model artifacts are
 *      communicated to and from the repository agent via a locally
 *      accessible filesystem. The agent can access these files using
 *      an appropriate filesystem API.
 * 
 *    TRITONREPOAGENT_ARTIFACT_REMOTE_FILESYSTEM: The model artifacts are
 *      communicated to and from the repository agent via a remote filesystem.
 *      The remote filesystem path follows the same convention as is used for
 *      repository paths, for example, "s3://" prefix indicates an S3 path.
 *  */
/** enum TRITONREPOAGENT_ArtifactType */
public static final int
  TRITONREPOAGENT_ARTIFACT_FILESYSTEM = 0,
  TRITONREPOAGENT_ARTIFACT_REMOTE_FILESYSTEM = 1;

/** TRITONREPOAGENT_ActionType
 * 
 *  Types of repository actions that can be handled by an agent.
 *  The lifecycle of a TRITONREPOAGENT_AgentModel begins with a call to
 *  TRITONREPOAGENT_ModelInitialize and ends with a call to
 *  TRITONREPOAGENT_ModelFinalize. Between those calls the current lifecycle
 *  state of the model is communicated by calls to TRITONREPOAGENT_ModelAction.
 *  Possible lifecycles are:
 * 
 *  LOAD -> LOAD_COMPLETE -> UNLOAD -> UNLOAD_COMPLETE
 *  LOAD -> LOAD_FAIL
 * 
 *    TRITONREPOAGENT_ACTION_LOAD: A model is being loaded.
 * 
 *    TRITONREPOAGENT_ACTION_LOAD_COMPLETE: The model load completed
 *      successfully and the model is now loaded.
 * 
 *    TRITONREPOAGENT_ACTION_LOAD_FAIL: The model load did not complete
 *      successfully. The model is not loaded.
 * 
 *    TRITONREPOAGENT_ACTION_UNLOAD: The model is being unloaded.
 * 
 *    TRITONREPOAGENT_ACTION_UNLOAD_COMPLETE: The model unload is complete.
 *  */
/** enum TRITONREPOAGENT_ActionType */
public static final int
  TRITONREPOAGENT_ACTION_LOAD = 0,
  TRITONREPOAGENT_ACTION_LOAD_COMPLETE = 1,
  TRITONREPOAGENT_ACTION_LOAD_FAIL = 2,
  TRITONREPOAGENT_ACTION_UNLOAD = 3,
  TRITONREPOAGENT_ACTION_UNLOAD_COMPLETE = 4;

/** Get the location of the files that make up the model. The
 *  'location' communicated depends on how the model is being
 *  communicated to the agent as indicated by 'artifact_type'.
 * 
 *    TRITONREPOAGENT_ARTIFACT_FILESYSTEM: The model artifacts are
 *      made available to the agent via the local
 *      filesystem. 'location' returns the full path to the directory
 *      in the model repository that contains the model's
 *      artifacts. The returned location string is owned by Triton,
 *      not the caller, and so should not be modified or freed. The
 *      contents of the directory are owned by Triton, not the agent,
 *      and so the agent should not delete or modify the contents. Use
 *      TRITONREPOAGENT_RepositoryAcquire to get a location that can be
 *      used to modify the model repository contents.
 * 
 *    TRITONREPOAGENT_ARTIFACT_REMOTE_FILESYSTEM: The model artifacts are
 *      made available to the agent via a remote filesystem.
 *      'location' returns the full path to the remote directory that contains
 *      the model's artifacts. The returned location string is owned by Triton,
 *      not the caller, and so should not be modified or freed. The contents of
 *      the remote directory are owned by Triton, not the agent,
 *      and so the agent should not delete or modify the contents.
 *      Use TRITONREPOAGENT_ModelRepositoryLocationAcquire to get a location
 *      that can be used to write updated model repository contents.
 * 
 *  @param agent The agent.
 *  @param model The model.
 *  @param artifact_type Returns the artifact type for the location.
 *  @param path Returns the location.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelRepositoryLocation(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("TRITONREPOAGENT_ArtifactType*") IntPointer artifact_type, @Cast("const char**") PointerPointer location);
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelRepositoryLocation(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("TRITONREPOAGENT_ArtifactType*") IntPointer artifact_type, @Cast("const char**") @ByPtrPtr BytePointer location);
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelRepositoryLocation(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("TRITONREPOAGENT_ArtifactType*") IntBuffer artifact_type, @Cast("const char**") @ByPtrPtr ByteBuffer location);
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelRepositoryLocation(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("TRITONREPOAGENT_ArtifactType*") int[] artifact_type, @Cast("const char**") @ByPtrPtr byte[] location);

/** Acquire a location where the agent can produce a new version of
 *  the model repository files. This is a convenience method to create
 *  a temporary directory for the agent. The agent is responsible for
 *  calling TRITONREPOAGENT_ModelRepositoryLocationDelete in
 *  TRITONREPOAGENT_ModelFinalize to delete the location. Initially the
 *  acquired location is empty. The 'location' communicated depends on
 *  the requested 'artifact_type'.
 * 
 *    TRITONREPOAGENT_ARTIFACT_FILESYSTEM: The location is a directory
 *      on the local filesystem. 'location' returns the full path to
 *      an empty directory that the agent should populate with the
 *      model's artifacts. The returned location string is owned by
 *      Triton, not the agent, and so should not be modified or freed.
 * 
 *  @param agent The agent.
 *  @param model The model.
 *  @param artifact_type The artifact type for the location.
 *  @param path Returns the location.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelRepositoryLocationAcquire(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("const TRITONREPOAGENT_ArtifactType") int artifact_type, @Cast("const char**") PointerPointer location);
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelRepositoryLocationAcquire(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("const TRITONREPOAGENT_ArtifactType") int artifact_type, @Cast("const char**") @ByPtrPtr BytePointer location);
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelRepositoryLocationAcquire(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("const TRITONREPOAGENT_ArtifactType") int artifact_type, @Cast("const char**") @ByPtrPtr ByteBuffer location);
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelRepositoryLocationAcquire(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("const TRITONREPOAGENT_ArtifactType") int artifact_type, @Cast("const char**") @ByPtrPtr byte[] location);

/** Discard and release ownership of a previously acquired location
 *  and its contents. The agent must not access or modify the location
 *  or its contents after this call.
 * 
 *  @param agent The agent.
 *  @param model The model.
 *  @param path The location to release.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelRepositoryLocationRelease(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    String location);
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelRepositoryLocationRelease(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("const char*") BytePointer location);

/** Inform Triton that the specified repository location should be used for
 *  the model in place of the original model repository. This method can only be
 *  called when TRITONREPOAGENT_ModelAction is invoked with
 *  TRITONREPOAGENT_ACTION_LOAD. The 'location' The 'location'
 *  communicated depends on how the repository is being
 *  communicated to Triton as indicated by 'artifact_type'.
 * 
 *    TRITONREPOAGENT_ARTIFACT_FILESYSTEM: The model artifacts are
 *      made available to Triton via the local filesystem. 'location' returns
 *      the full path to the directory. Ownership of the contents of the
 *      returned directory are transferred to Triton and the agent should not
 *      modified or freed the contents until TRITONREPOAGENT_ModelFinalize.
 *      The local filesystem directory can be created using
 *      TRITONREPOAGENT_ModelReopsitroyLocationAcquire or the agent can use
 *      its own local filesystem API.
 * 
 *    TRITONREPOAGENT_ARTIFACT_REMOTE_FILESYSTEM: The model artifacts are
 *      made available to Triton via a remote filesystem. 'location' returns
 *      the full path to the remote filesystem directory. Ownership of the
 *      contents of the returned directory are transferred to Triton and
 *      the agent should not modified or freed the contents until
 *      TRITONREPOAGENT_ModelFinalize.
 * 
 *  @param agent The agent.
 *  @param model The model.
 *  @param artifact_type The artifact type for the location.
 *  @param path Returns the location.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelRepositoryUpdate(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("const TRITONREPOAGENT_ArtifactType") int artifact_type, String location);
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelRepositoryUpdate(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("const TRITONREPOAGENT_ArtifactType") int artifact_type, @Cast("const char*") BytePointer location);

/** Get the number of agent parameters defined for a model.
 * 
 *  @param agent The agent.
 *  @param model The model.
 *  @param count Returns the number of input tensors.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelParameterCount(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("uint32_t*") IntPointer count);
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelParameterCount(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("uint32_t*") IntBuffer count);
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelParameterCount(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("uint32_t*") int[] count);

/** Get a parameter name and value. The caller does not own the
 *  returned strings and must not modify or delete them.
 * 
 *  @param agent The agent.
 *  @param model The model.
 *  @param index The index of the parameter. Must be 0 <= index <
 *  count, where count is the value returned by
 *  TRITONREPOAGENT_ModelParameterCount.
 *  @param parameter_name Returns the name of the parameter.
 *  @param parameter_value Returns the value of the parameter.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelParameter(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("const uint32_t") int index, @Cast("const char**") PointerPointer parameter_name,
    @Cast("const char**") PointerPointer parameter_value);
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelParameter(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("const uint32_t") int index, @Cast("const char**") @ByPtrPtr BytePointer parameter_name,
    @Cast("const char**") @ByPtrPtr BytePointer parameter_value);
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelParameter(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("const uint32_t") int index, @Cast("const char**") @ByPtrPtr ByteBuffer parameter_name,
    @Cast("const char**") @ByPtrPtr ByteBuffer parameter_value);
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelParameter(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("const uint32_t") int index, @Cast("const char**") @ByPtrPtr byte[] parameter_name,
    @Cast("const char**") @ByPtrPtr byte[] parameter_value);

/** Get the model configuration. The caller takes ownership of the
 *  message object and must call TRITONSERVER_MessageDelete to release
 *  the object. If the model repository does not contain a
 *  config.pbtxt file then 'model_config' is returned as nullptr.
 * 
 *  @param agent The agent.
 *  @param model The model.
 *  @param config_version The model configuration will be returned in
 *  a format matching this version. If the configuration cannot be
 *  represented in the requested version's format then an error will
 *  be returned. Currently only version 1 is supported.
 *  @param model_config Returns the model configuration as a message.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelConfig(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("const uint32_t") int config_version, @Cast("TRITONSERVER_Message**") PointerPointer model_config);
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelConfig(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("const uint32_t") int config_version, @ByPtrPtr TRITONSERVER_Message model_config);

/** Get the user-specified state associated with the model.
 * 
 *  @param model The agent model.
 *  @param state Returns the user state, or nullptr if no user state.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelState(
    TRITONREPOAGENT_AgentModel model, @Cast("void**") PointerPointer state);
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelState(
    TRITONREPOAGENT_AgentModel model, @Cast("void**") @ByPtrPtr Pointer state);

/** Set the user-specified state associated with the model.
 * 
 *  @param model The agent model.
 *  @param state The user state, or nullptr if no user state.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelSetState(
    TRITONREPOAGENT_AgentModel model, Pointer state);

/** Get the user-specified state associated with the agent.
 * 
 *  @param agent The agent.
 *  @param state Returns the user state, or nullptr if no user state.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONREPOAGENT_State(
    TRITONREPOAGENT_Agent agent, @Cast("void**") PointerPointer state);
public static native TRITONSERVER_Error TRITONREPOAGENT_State(
    TRITONREPOAGENT_Agent agent, @Cast("void**") @ByPtrPtr Pointer state);

/** Set the user-specified state associated with the agent.
 * 
 *  @param agent The agent.
 *  @param state The user state, or nullptr if no user state.
 *  @return a TRITONSERVER_Error indicating success or failure. */


///
///
///
public static native TRITONSERVER_Error TRITONREPOAGENT_SetState(
    TRITONREPOAGENT_Agent agent, Pointer state);

/**
 *  The following functions can be implemented by an agent. Functions
 *  indicated as required must be implemented or the agent will fail
 *  to load.
 * 
 <p>
 *  Initialize an agent. This function is optional. This function is
 *  called once when an agent is loaded to allow the agent to
 *  initialize any state associated with the agent. An agent has a
 *  single state that is shared across all invocations of the agent.
 * 
 *  @param agent The agent.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONREPOAGENT_Initialize(
    TRITONREPOAGENT_Agent agent);

/** Finalize for an agent. This function is optional. This function is
 *  called once, just before the agent is unloaded. All state
 *  associated with the agent should be freed and any threads created
 *  for the agent should be exited/joined before returning from this
 *  function.
 * 
 *  @param agent The agent.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONREPOAGENT_Finalize(
    TRITONREPOAGENT_Agent agent);

/** Initialize a model associated with an agent. This function is optional.
 *  This function is called once when an agent model's lifecycle begins to allow
 *  the agent model to initialize any state associated with it. An agent model
 *  has a single state that is shared across all the lifecycle of the agent
 *  model.
 * 
 *  @param agent The agent to be associated with the model.
 *  @param model The model.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelInitialize(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model);

/** Finalize for a model. This function is optional. This function is
 *  called once, just before the end of the agent model's lifecycle. All state
 *  associated with the agent model should be freed and any threads created
 *  for the agent model should be exited/joined before returning from this
 *  function. If the model acquired a model location using
 *  TRITONREPOAGENT_ModelRepositoryLocationAcquire, it must call
 *  TRITONREPOAGENT_ModelRepositoryLocationRelease to release that location.
 * 
 *  @param agent The agent associated with the model.
 *  @param model The model.
 *  @return a TRITONSERVER_Error indicating success or failure. */

///
///
///
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelFinalize(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model);

/** Handle an action for a specified model. This function is
 *  required. Triton will not perform multiple simultaneous calls to
 *  this function for a given agent and model; however, there may be
 *  simultaneous calls for the agent for different models.
 * 
 *  If the agent does not handle the action the agent should
 *  immediately return success (nullptr).
 * 
 *  Any modification to the model's repository must be made when 'action_type'
 *  is TRITONREPOAGENT_ACTION_LOAD.
 *  To modify the model's repository the agent must either acquire a mutable
 *  location via TRITONREPOAGENT_ModelRepositoryLocationAcquire
 *  or its own managed location, report the location to Triton via
 *  TRITONREPOAGENT_ModelRepositoryUpdate, and then return
 *  success (nullptr). If the agent does not need to make any changes
 *  to the model repository it should not call
 *  TRITONREPOAGENT_ModelRepositoryUpdate and then return success.
 *  To indicate that a model load should fail return a non-success status.
 * 
 *  @param agent The agent.
 *  @param model The model that is the target of the action.
 *  \action_type The type of action the agent should handle for the model.
 *  @return a TRITONSERVER_Error indicating success or failure. */
public static native TRITONSERVER_Error TRITONREPOAGENT_ModelAction(
    TRITONREPOAGENT_Agent agent, TRITONREPOAGENT_AgentModel model,
    @Cast("const TRITONREPOAGENT_ActionType") int action_type);

// #ifdef __cplusplus
// #endif


}
