// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tritonserver.tritondevelopertoolsserver;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.tritonserver.global.tritondevelopertoolsserver.*;


//==============================================================================
/** Structure to hold logging options for setting 'ServerOptions'.
 *  */
@Namespace("triton::developer_tools::server") @NoOffset @Properties(inherit = org.bytedeco.tritonserver.presets.tritondevelopertoolsserver.class)
public class LoggingOptions extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public LoggingOptions(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public LoggingOptions(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public LoggingOptions position(long position) {
        return (LoggingOptions)super.position(position);
    }
    @Override public LoggingOptions getPointer(long i) {
        return new LoggingOptions((Pointer)this).offsetAddress(i);
    }

  // The range of VerboseLevel is [0, INT_MAX].
  /** enum class triton::developer_tools::server::LoggingOptions::VerboseLevel */
  public static final int OFF = 0, MIN = 1, MAX = Integer.MAX_VALUE;
  /** enum class triton::developer_tools::server::LoggingOptions::LogFormat */
  public static final int DEFAULT = 0, ISO8601 = 1;

  public LoggingOptions() { super((Pointer)null); allocate(); }
  private native void allocate();

  public LoggingOptions(
        @Cast("const triton::developer_tools::server::LoggingOptions::VerboseLevel") int verbose, @Cast("const bool") boolean info, @Cast("const bool") boolean warn,
        @Cast("const bool") boolean error, @Cast("const triton::developer_tools::server::LoggingOptions::LogFormat") int format, @StdString BytePointer log_file) { super((Pointer)null); allocate(verbose, info, warn, error, format, log_file); }
  private native void allocate(
        @Cast("const triton::developer_tools::server::LoggingOptions::VerboseLevel") int verbose, @Cast("const bool") boolean info, @Cast("const bool") boolean warn,
        @Cast("const bool") boolean error, @Cast("const triton::developer_tools::server::LoggingOptions::LogFormat") int format, @StdString BytePointer log_file);
  public LoggingOptions(
        @Cast("const triton::developer_tools::server::LoggingOptions::VerboseLevel") int verbose, @Cast("const bool") boolean info, @Cast("const bool") boolean warn,
        @Cast("const bool") boolean error, @Cast("const triton::developer_tools::server::LoggingOptions::LogFormat") int format, @StdString String log_file) { super((Pointer)null); allocate(verbose, info, warn, error, format, log_file); }
  private native void allocate(
        @Cast("const triton::developer_tools::server::LoggingOptions::VerboseLevel") int verbose, @Cast("const bool") boolean info, @Cast("const bool") boolean warn,
        @Cast("const bool") boolean error, @Cast("const triton::developer_tools::server::LoggingOptions::LogFormat") int format, @StdString String log_file);

  public native void SetVerboseLevel(int verbose_level);

  // Verbose logging level. Default is OFF.
  public native @Cast("triton::developer_tools::server::LoggingOptions::VerboseLevel") int verbose_(); public native LoggingOptions verbose_(int setter);
  // Enable or disable info logging level. Default is true.
  public native @Cast("bool") boolean info_(); public native LoggingOptions info_(boolean setter);
  // Enable or disable warn logging level. Default is true.
  public native @Cast("bool") boolean warn_(); public native LoggingOptions warn_(boolean setter);
  // Enable or disable error logging level. Default is true.
  public native @Cast("bool") boolean error_(); public native LoggingOptions error_(boolean setter);
  // The format of logging. For "DEFAULT", the log severity (L) and
  // timestamp will be logged as "LMMDD hh:mm:ss.ssssss". For "ISO8601", the
  // log format will be "YYYY-MM-DDThh:mm:ssZ L". Default is 'DEFAULT'.
  public native @Cast("triton::developer_tools::server::LoggingOptions::LogFormat") int format_(); public native LoggingOptions format_(int setter);
  // Logging output file. If specified, log outputs will be saved to this file.
  // If not specified, log outputs will stream to the console. Default is an
  // empty string.
  public native @StdString BytePointer log_file_(); public native LoggingOptions log_file_(BytePointer setter);  // logging output file
}
