// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tritonserver.tritondevelopertoolsserver;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.tritonserver.global.tritondevelopertoolsserver.*;


//==============================================================================
/** Server options that are used to initialize Triton Server.
 *  */
@Namespace("triton::developer_tools::server") @NoOffset @Properties(inherit = org.bytedeco.tritonserver.presets.tritondevelopertoolsserver.class)
public class ServerOptions extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ServerOptions(Pointer p) { super(p); }

  public ServerOptions(@Const @ByRef StringVector model_repository_paths) { super((Pointer)null); allocate(model_repository_paths); }
  private native void allocate(@Const @ByRef StringVector model_repository_paths);

  public ServerOptions(
        @Const @ByRef StringVector model_repository_paths,
        @Const @ByRef LoggingOptions logging, @Const @ByRef MetricsOptions metrics,
        @StdVector BackendConfig be_config, @StdString BytePointer server_id,
        @StdString BytePointer backend_dir, @StdString BytePointer repo_agent_dir,
        @Cast("const bool") boolean disable_auto_complete_config,
        @Cast("const triton::developer_tools::server::ModelControlMode") int model_control_mode,
        int repository_poll_secs,
        @Const @ByRef StringSet startup_models,
        @StdVector RateLimitResource rate_limit_resource,
        @Cast("const int64_t") long pinned_memory_pool_byte_size,
        @StdVector CUDAMemoryPoolByteSize cuda_memory_pool_byte_size,
        @Cast("const uint64_t") long response_cache_byte_size,
        double min_cuda_compute_capability, @Cast("const bool") boolean exit_on_error,
        int exit_timeout_secs,
        int buffer_manager_thread_count,
        @Cast("const uint32_t") int model_load_thread_count,
        @StdVector ModelLoadGPULimit model_load_gpu_limit,
        @StdVector HostPolicy host_policy, @SharedPtr Trace trace) { super((Pointer)null); allocate(model_repository_paths, logging, metrics, be_config, server_id, backend_dir, repo_agent_dir, disable_auto_complete_config, model_control_mode, repository_poll_secs, startup_models, rate_limit_resource, pinned_memory_pool_byte_size, cuda_memory_pool_byte_size, response_cache_byte_size, min_cuda_compute_capability, exit_on_error, exit_timeout_secs, buffer_manager_thread_count, model_load_thread_count, model_load_gpu_limit, host_policy, trace); }
  private native void allocate(
        @Const @ByRef StringVector model_repository_paths,
        @Const @ByRef LoggingOptions logging, @Const @ByRef MetricsOptions metrics,
        @StdVector BackendConfig be_config, @StdString BytePointer server_id,
        @StdString BytePointer backend_dir, @StdString BytePointer repo_agent_dir,
        @Cast("const bool") boolean disable_auto_complete_config,
        @Cast("const triton::developer_tools::server::ModelControlMode") int model_control_mode,
        int repository_poll_secs,
        @Const @ByRef StringSet startup_models,
        @StdVector RateLimitResource rate_limit_resource,
        @Cast("const int64_t") long pinned_memory_pool_byte_size,
        @StdVector CUDAMemoryPoolByteSize cuda_memory_pool_byte_size,
        @Cast("const uint64_t") long response_cache_byte_size,
        double min_cuda_compute_capability, @Cast("const bool") boolean exit_on_error,
        int exit_timeout_secs,
        int buffer_manager_thread_count,
        @Cast("const uint32_t") int model_load_thread_count,
        @StdVector ModelLoadGPULimit model_load_gpu_limit,
        @StdVector HostPolicy host_policy, @SharedPtr Trace trace);
  public ServerOptions(
        @Const @ByRef StringVector model_repository_paths,
        @Const @ByRef LoggingOptions logging, @Const @ByRef MetricsOptions metrics,
        @StdVector BackendConfig be_config, @StdString String server_id,
        @StdString String backend_dir, @StdString String repo_agent_dir,
        @Cast("const bool") boolean disable_auto_complete_config,
        @Cast("const triton::developer_tools::server::ModelControlMode") int model_control_mode,
        int repository_poll_secs,
        @Const @ByRef StringSet startup_models,
        @StdVector RateLimitResource rate_limit_resource,
        @Cast("const int64_t") long pinned_memory_pool_byte_size,
        @StdVector CUDAMemoryPoolByteSize cuda_memory_pool_byte_size,
        @Cast("const uint64_t") long response_cache_byte_size,
        double min_cuda_compute_capability, @Cast("const bool") boolean exit_on_error,
        int exit_timeout_secs,
        int buffer_manager_thread_count,
        @Cast("const uint32_t") int model_load_thread_count,
        @StdVector ModelLoadGPULimit model_load_gpu_limit,
        @StdVector HostPolicy host_policy, @SharedPtr Trace trace) { super((Pointer)null); allocate(model_repository_paths, logging, metrics, be_config, server_id, backend_dir, repo_agent_dir, disable_auto_complete_config, model_control_mode, repository_poll_secs, startup_models, rate_limit_resource, pinned_memory_pool_byte_size, cuda_memory_pool_byte_size, response_cache_byte_size, min_cuda_compute_capability, exit_on_error, exit_timeout_secs, buffer_manager_thread_count, model_load_thread_count, model_load_gpu_limit, host_policy, trace); }
  private native void allocate(
        @Const @ByRef StringVector model_repository_paths,
        @Const @ByRef LoggingOptions logging, @Const @ByRef MetricsOptions metrics,
        @StdVector BackendConfig be_config, @StdString String server_id,
        @StdString String backend_dir, @StdString String repo_agent_dir,
        @Cast("const bool") boolean disable_auto_complete_config,
        @Cast("const triton::developer_tools::server::ModelControlMode") int model_control_mode,
        int repository_poll_secs,
        @Const @ByRef StringSet startup_models,
        @StdVector RateLimitResource rate_limit_resource,
        @Cast("const int64_t") long pinned_memory_pool_byte_size,
        @StdVector CUDAMemoryPoolByteSize cuda_memory_pool_byte_size,
        @Cast("const uint64_t") long response_cache_byte_size,
        double min_cuda_compute_capability, @Cast("const bool") boolean exit_on_error,
        int exit_timeout_secs,
        int buffer_manager_thread_count,
        @Cast("const uint32_t") int model_load_thread_count,
        @StdVector ModelLoadGPULimit model_load_gpu_limit,
        @StdVector HostPolicy host_policy, @SharedPtr Trace trace);

  public native void SetLoggingOptions(@Const @ByRef LoggingOptions logging);

  // Paths to model repository directory. Note that if a model is not unique
  // across all model repositories at any time, the model will not be available.
  // See here for more information:
  // https://github.com/triton-inference-server/server/blob/main/docs/user_guide/model_repository.md.
  public native @ByRef StringVector model_repository_paths_(); public native ServerOptions model_repository_paths_(StringVector setter);
  // Logging options. See the 'LoggingOptions' structure for more information.
  public native @ByRef LoggingOptions logging_(); public native ServerOptions logging_(LoggingOptions setter);
  // Metrics options. See the 'MetricsOptions' structure for more information.
  public native @ByRef MetricsOptions metrics_(); public native ServerOptions metrics_(MetricsOptions setter);
  // Backend configuration. See the 'BackendConfig' structure for more
  // information.
  public native @StdVector BackendConfig be_config_(); public native ServerOptions be_config_(BackendConfig setter);
  // The ID of the server.
  public native @StdString BytePointer server_id_(); public native ServerOptions server_id_(BytePointer setter);
  // The global directory searched for backend shared libraries. Default is
  // "/opt/tritonserver/backends". See here for more information:
  // https://github.com/triton-inference-server/backend#backends.
  public native @StdString BytePointer backend_dir_(); public native ServerOptions backend_dir_(BytePointer setter);
  // The global directory searched for repository agent shared libraries.
  // Default is "/opt/tritonserver/repoagents". See here for more information:
  // https://github.com/triton-inference-server/server/blob/main/docs/customization_guide/repository_agents.md.
  public native @StdString BytePointer repo_agent_dir_(); public native ServerOptions repo_agent_dir_(BytePointer setter);
  // If set, disables the triton and backends from auto completing model
  // configuration files. Model configuration files must be provided and
  // all required configuration settings must be specified. Default is false.
  // See here for more information:
  // https://github.com/triton-inference-server/server/blob/main/docs/user_guide/model_configuration.md#auto-generated-model-configuration.
  public native @Cast("bool") boolean disable_auto_complete_config_(); public native ServerOptions disable_auto_complete_config_(boolean setter);
  // Specify the mode for model management. Options are "NONE", "POLL" and
  // "EXPLICIT". Default is "NONE". See here for more information:
  // https://github.com/triton-inference-server/server/blob/main/docs/user_guide/model_management.md.
  public native @Cast("triton::developer_tools::server::ModelControlMode") int model_control_mode_(); public native ServerOptions model_control_mode_(int setter);
  // Interval in seconds between each poll of the model repository to check for
  // changes. Valid only when 'model_control_mode_' is set to "POLL". Default
  // is 15.
  public native int repository_poll_secs_(); public native ServerOptions repository_poll_secs_(int setter);
  // Specify the the models to be loaded on server startup. This will only take
  // effect if 'model_control_mode_' is set to 'EXPLICIT'.
  public native @ByRef StringSet startup_models_(); public native ServerOptions startup_models_(StringSet setter);
  // The number of resources available to the server. Rate limiting is disabled
  // by default, and can be enabled once 'rate_limit_resource_' is set. See the
  // 'RateLimitResource' structure for more information.
  public native @StdVector RateLimitResource rate_limit_resource_(); public native ServerOptions rate_limit_resource_(RateLimitResource setter);
  // The total byte size that can be allocated as pinned system memory. If GPU
  // support is enabled, the server will allocate pinned system memory to
  // accelerate data transfer between host and devices until it exceeds the
  // specified byte size.  If 'NUMA_NODE' is configured via 'host_policy_', the
  // pinned system memory of the pool size will be allocated on each numa node.
  // This option will not affect the allocation conducted by the backend
  // frameworks. Default is 256 MB.
  public native @Cast("int64_t") long pinned_memory_pool_byte_size_(); public native ServerOptions pinned_memory_pool_byte_size_(long setter);
  // The total byte size that can be allocated as CUDA memory for the GPU
  // device. See the 'CUDAMemoryPoolByteSize' structure for more information.
  public native @StdVector CUDAMemoryPoolByteSize cuda_memory_pool_byte_size_(); public native ServerOptions cuda_memory_pool_byte_size_(CUDAMemoryPoolByteSize setter);
  // The size in bytes to allocate for a request/response cache. When non-zero,
  // Triton allocates the requested size in CPU memory and shares the cache
  // across all inference requests and across all models. For a given model to
  // use request caching, the model must enable request caching in the model
  // configuration. See here for more information:
  // https://github.com/triton-inference-server/server/blob/main/docs/user_guide/model_configuration.md#response-cache.
  // By default, no model uses request caching even if the
  // 'response_cache_byte_size_' is set. Default is 0.
  public native @Cast("uint64_t") long response_cache_byte_size_(); public native ServerOptions response_cache_byte_size_(long setter);
  // The minimum supported CUDA compute capability. GPUs that don't support this
  // compute capability will not be used by the server. Default is 0.
  public native double min_cuda_compute_capability_(); public native ServerOptions min_cuda_compute_capability_(double setter);
  // If set, exit the inference server when an error occurs during
  // initialization. Default is true.
  public native @Cast("bool") boolean exit_on_error_(); public native ServerOptions exit_on_error_(boolean setter);
  // Timeout (in seconds) when exiting to wait for in-flight inferences to
  // finish. After the timeout expires the server exits even if inferences are
  // still in flight. Default is 30 secs.
  public native int exit_timeout_secs_(); public native ServerOptions exit_timeout_secs_(int setter);
  // The number of threads used to accelerate copies and other operations
  // required to manage input and output tensor contents. Default is 0.
  public native int buffer_manager_thread_count_(); public native ServerOptions buffer_manager_thread_count_(int setter);
  // The number of threads used to concurrently load models in model
  // repositories. Default is 2*<num_cpu_cores>.
  public native @Cast("uint32_t") int model_load_thread_count_(); public native ServerOptions model_load_thread_count_(int setter);
  // The GPU limit of model loading. See the 'ModelLoadGPULimit' structure for
  // more information.
  public native @StdVector ModelLoadGPULimit model_load_gpu_limit_(); public native ServerOptions model_load_gpu_limit_(ModelLoadGPULimit setter);
  // The host policy setting. See the 'HostPolicy' structure for more
  // information.
  public native @StdVector HostPolicy host_policy_(); public native ServerOptions host_policy_(HostPolicy setter);
  // The global trace setting. Default is nullptr, meaning that tracing is not
  // enabled. See the 'Trace' structure for more information.
  public native @SharedPtr Trace trace_(); public native ServerOptions trace_(Trace setter);
}
