// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tritonserver.tritondevelopertoolsserver;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.tritonserver.global.tritondevelopertoolsserver.*;


//==============================================================================
/** Structure to hold global trace setting for 'ServerOptions' and
 *  model-specific trace setting for 'InferOptions'. See here for more
 *  information:
 *  https://github.com/triton-inference-server/server/blob/main/docs/user_guide/trace.md. */
@Namespace("triton::developer_tools::server") @NoOffset @Properties(inherit = org.bytedeco.tritonserver.presets.tritondevelopertoolsserver.class)
public class Trace extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Trace(Pointer p) { super(p); }

  /** enum class triton::developer_tools::server::Trace::Level */
  public static final int OFF = 0, TIMESTAMPS = 1, TENSORS = 2;

  public Trace(@StdString BytePointer file, @Cast("const triton::developer_tools::server::Trace::Level") int level) { super((Pointer)null); allocate(file, level); }
  private native void allocate(@StdString BytePointer file, @Cast("const triton::developer_tools::server::Trace::Level") int level);
  public Trace(@StdString String file, @Cast("const triton::developer_tools::server::Trace::Level") int level) { super((Pointer)null); allocate(file, level); }
  private native void allocate(@StdString String file, @Cast("const triton::developer_tools::server::Trace::Level") int level);

  public Trace(
        @StdString BytePointer file, @Cast("const triton::developer_tools::server::Trace::Level") int level, @Cast("const uint32_t") int rate,
        int count, @Cast("const uint32_t") int log_frequency) { super((Pointer)null); allocate(file, level, rate, count, log_frequency); }
  private native void allocate(
        @StdString BytePointer file, @Cast("const triton::developer_tools::server::Trace::Level") int level, @Cast("const uint32_t") int rate,
        int count, @Cast("const uint32_t") int log_frequency);
  public Trace(
        @StdString String file, @Cast("const triton::developer_tools::server::Trace::Level") int level, @Cast("const uint32_t") int rate,
        int count, @Cast("const uint32_t") int log_frequency) { super((Pointer)null); allocate(file, level, rate, count, log_frequency); }
  private native void allocate(
        @StdString String file, @Cast("const triton::developer_tools::server::Trace::Level") int level, @Cast("const uint32_t") int rate,
        int count, @Cast("const uint32_t") int log_frequency);

  // The file where trace output will be saved. If 'log-frequency' is also
  // specified, this argument value will be the prefix of the files to save the
  // trace output.
  public native @StdString BytePointer file_(); public native Trace file_(BytePointer setter);
  // Specify a trace level. OFF to disable tracing, TIMESTAMPS to trace
  // timestamps, TENSORS to trace tensors.
  public native @Cast("triton::developer_tools::server::Trace::Level") int level_(); public native Trace level_(int setter);
  // The trace sampling rate. The value represents how many requests will one
  // trace be sampled from. For example, if the trace rate is "1000", 1 trace
  // will be sampled for every 1000 requests. Default is 1000.
  public native @Cast("uint32_t") int rate_(); public native Trace rate_(int setter);
  // The number of traces to be sampled. If the value is -1, the number of
  // traces to be sampled will not be limited. Default is -1.
  public native int count_(); public native Trace count_(int setter);
  // The trace log frequency. If the value is 0, Triton will only log the trace
  // output to 'file_' when shutting down. Otherwise, Triton will log the trace
  // output to 'file_.<idx>' when it collects the specified number of traces.
  // For example, if the log frequency is 100, when Triton collects the 100-th
  // trace, it logs the traces to file 'file_.0', and when it collects the
  // 200-th trace, it logs the 101-th to the 200-th traces to file file_.1'.
  // Default is 0.
  public native @Cast("uint32_t") int log_frequency_(); public native Trace log_frequency_(int setter);
}
