// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tritonserver.tritonserver;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.tritonserver.global.tritonserver.*;


/** Type for inference request release callback function. The callback
 *  indicates what type of release is being performed on the request
 *  and for some of these the callback function takes ownership of the
 *  TRITONSERVER_InferenceRequest object. The 'userp' data is the data
 *  provided as 'request_release_userp' in the call to
 *  TRITONSERVER_InferenceRequestSetReleaseCallback.
 * 
 *  One or more flags will be specified when the callback is invoked,
 *  and the callback must take the following actions:
 * 
 *    - TRITONSERVER_REQUEST_RELEASE_ALL: The entire inference request
 *      is being released and ownership is passed to the callback
 *      function. Triton will not longer access the 'request' object
 *      itself nor any input tensor data associated with the
 *      request. The callback should free or otherwise manage the
 *      'request' object and all associated tensor data.
 *    - TRITONSERVER_REQUEST_RELEASE_RESCHEDULE: This flag is currently being
 *      consumed internally and the callback is not expected to receive nor
 *      process this kind of release. The backend will call
 *      TRITONBACKEND_RequestRelease with this flag when it wishes to reschedule
 *      the request back to the model. An example is that the model is
 *      recursively performing inference of the request and use the rescheduling
 *      to proceed the recursive execution.
 * 
 *  Note that currently TRITONSERVER_REQUEST_RELEASE_ALL should always
 *  be set when the callback is invoked but in the future that may
 *  change, so the callback should explicitly check for the flag
 *  before taking ownership of the request object.
 *  */

///
///
@Properties(inherit = org.bytedeco.tritonserver.presets.tritonserver.class)
public class TRITONSERVER_InferenceRequestReleaseFn_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    TRITONSERVER_InferenceRequestReleaseFn_t(Pointer p) { super(p); }
    protected TRITONSERVER_InferenceRequestReleaseFn_t() { allocate(); }
    private native void allocate();
    public native void call(
    TRITONSERVER_InferenceRequest request, @Cast("const uint32_t") int flags,
    Pointer userp);
}
