// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.tritonserver.tritondevelopertoolsserver;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.tritonserver.global.tritondevelopertoolsserver.*;


//==============================================================================
/** Object that describes an inflight inference request.
 *  */
@Namespace("triton::developer_tools::server") @Properties(inherit = org.bytedeco.tritonserver.presets.tritondevelopertoolsserver.class)
public class GenericInferRequest extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public GenericInferRequest(Pointer p) { super(p); }

  /**  Create an InferRequest instance. */
  public static native @UniquePtr GenericInferRequest Create(
        @Const @ByRef InferOptions infer_options);

  /** Add an input tensor to be sent within an InferRequest object. The input
   *  data buffer within the 'Tensor' object must not be modified until
   *  inference is completed and result is returned.
   *  @param name The name of the input tensor.
   *  @param input A Tensor object that describes an input tensor. */
  public native @NoException(true) void AddInput(
        @StdString BytePointer name, @Const @ByRef Tensor input);
  public native @NoException(true) void AddInput(
        @StdString String name, @Const @ByRef Tensor input);

  /** Add a requested output to be sent within an InferRequest object.
   *  Calling this function is optional. If no output(s) are specifically
   *  requested then all outputs defined by the model will be calculated and
   *  returned. Pre-allocated buffer for each output should be specified within
   *  the 'Tensor' object.
   *  @param name The name of the output tensor.
   *  @param output A Tensor object that describes an output tensor containing
   *  its pre-allocated buffer. */
  public native void AddRequestedOutput(@StdString BytePointer name, @ByRef Tensor output);
  public native void AddRequestedOutput(@StdString String name, @ByRef Tensor output);

  /** Add a requested output to be sent within an InferRequest object.
   *  Calling this function is optional. If no output(s) are specifically
   *  requested then all outputs defined by the model will be calculated and
   *  returned.
   *  @param name The name of the output tensor. */
  public native void AddRequestedOutput(@StdString BytePointer name);
  public native void AddRequestedOutput(@StdString String name);

  /** Clear inputs and outputs of the request. This allows users to reuse the
   *  InferRequest object if needed. */
  public native void Reset();
}
