// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.tritonserver.tritondevelopertoolsserver;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.tritonserver.global.tritondevelopertoolsserver.*;


//==============================================================================
/** Object that encapsulates in-process C API functionalities.
 *  */
@Namespace("triton::developer_tools::server") @Properties(inherit = org.bytedeco.tritonserver.presets.tritondevelopertoolsserver.class)
public class GenericTritonServer extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public GenericTritonServer(Pointer p) { super(p); }

  /**  Create a GenericTritonServer instance. */
  public static native @UniquePtr GenericTritonServer Create(
        @Const @ByRef ServerOptions server_options);

  /** Load the requested model or reload the model if it is already loaded.
   *  @param model_name The name of the model. */
  public native void LoadModel(@StdString BytePointer model_name);
  public native void LoadModel(@StdString String model_name);

  /** Unload the requested model. Unloading a model that is not loaded
   *  on server has no affect.
   *  @param model_name The name of the model. */
  public native void UnloadModel(@StdString BytePointer model_name);
  public native void UnloadModel(@StdString String model_name);

  /** Get the set of names of models that are loaded and ready for inference.
   *  @return Returns the set of names of models that are
   *  loaded and ready for inference. */
  public native @ByVal StringSet LoadedModels();

  /** Get the index of model repository contents.
   *  @return Returns a vector of 'RepositoryIndex' object
   *  representing the repository index. */
  public native @StdVector RepositoryIndex ModelIndex();

  /** Get the metrics of the server.
   *  @return Returns a string representing the metrics. */
  public native @StdString BytePointer ServerMetrics();

  /** Get the inference statistics of the specified model.
   *  @param model_name The name of the model.
   *  @param model_version the version of the model requested.
   *  @return Returns a json string representing the model metrics. */
  public native @StdString BytePointer ModelStatistics(
        @StdString BytePointer model_name, @Cast("const int64_t") long model_version);
  public native @StdString String ModelStatistics(
        @StdString String model_name, @Cast("const int64_t") long model_version);

  /** Is the server live?
   *  @return Returns true if server is live, false otherwise. */
  public native @Cast("bool") boolean IsServerLive();

  /** Is the server ready?
   *  @return Returns true if server is ready, false otherwise. */
  public native @Cast("bool") boolean IsServerReady();

  /** Stop a server object. A server can't be restarted once it is
   *  stopped. */
  public native void ServerStop();

  /** Is the model ready?
   *  @param model_name The name of the model to get readiness for.
   *  @param model_version The version of the model to get readiness
   *  for.  If -1 then the server will choose a version based on the
   *  model's policy. This field is optional, default is -1.
   *  @return Returns true if server is ready, false otherwise. */
  public native @Cast("bool") boolean IsModelReady(
        @StdString BytePointer model_name, @Cast("const int64_t") long model_version/*=-1*/);
  public native @Cast("bool") boolean IsModelReady(
        @StdString BytePointer model_name);
  public native @Cast("bool") boolean IsModelReady(
        @StdString String model_name, @Cast("const int64_t") long model_version/*=-1*/);
  public native @Cast("bool") boolean IsModelReady(
        @StdString String model_name);

  /** Get the configuration of specified model.
   *  @param model_name The name of the model.
   *  @param model_version The version of the model to get configuration.
   *  The default value is -1 which means then the server will
   *  choose a version based on the model and internal policy. This field is
   *  optional. @return Returns JSON representation of model configuration as a
   *  string. */
  public native @StdString BytePointer ModelConfig(
        @StdString BytePointer model_name, @Cast("const int64_t") long model_version/*=-1*/);
  public native @StdString BytePointer ModelConfig(
        @StdString BytePointer model_name);
  public native @StdString String ModelConfig(
        @StdString String model_name, @Cast("const int64_t") long model_version/*=-1*/);
  public native @StdString String ModelConfig(
        @StdString String model_name);

  /** Get the metadata of the server.
   *  @return Returns JSON representation of server metadata as a string. */
  public native @StdString BytePointer ServerMetadata();

  /** Get the metadata of specified model.
   *  @param model_name The name of the model.
   *  @param model_version The version of the model to get configuration.
   *  The default value is -1 which means then the server will choose a version
   *  based on the model and internal policy. This field is optional.
   *  @return Returns JSON representation of model metadata as a string. */
  public native @StdString BytePointer ModelMetadata(
        @StdString BytePointer model_name, @Cast("const int64_t") long model_version/*=-1*/);
  public native @StdString BytePointer ModelMetadata(
        @StdString BytePointer model_name);
  public native @StdString String ModelMetadata(
        @StdString String model_name, @Cast("const int64_t") long model_version/*=-1*/);
  public native @StdString String ModelMetadata(
        @StdString String model_name);

  /** Register a new model repository. This function is not available in polling
   *  mode.
   *  @param new_model_repo The 'NewModelRepo' object contains the info of the
   *  new model repo to be registered. */
  public native void RegisterModelRepo(@Const @ByRef NewModelRepo new_model_repo);

  /** Unregister a model repository. This function is not available in polling
   *  mode.
   *  @param repo_path The full path to the model repository. */
  public native void UnregisterModelRepo(@StdString BytePointer repo_path);
  public native void UnregisterModelRepo(@StdString String repo_path);

  public native @UniquePtr GenericInferResult Infer(
        @ByRef GenericInferRequest infer_request);
}
