// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.tritonserver.tritonserver;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.tritonserver.global.tritonserver.*;


/** TRITONSERVER_ResponseAllocator
 * 
 *  Object representing a memory allocator for output tensors in an
 *  inference response.
 * 
 <p>
 *  Type for allocation function that allocates a buffer to hold an
 *  output tensor.
 * 
 *  @param allocator The allocator that is provided in the call to
 *  TRITONSERVER_InferenceRequestSetResponseCallback.
 *  @param tensor_name The name of the output tensor to allocate for.
 *  @param byte_size The size of the buffer to allocate.
 *  @param memory_type The type of memory that the caller prefers for
 *  the buffer allocation.
 *  @param memory_type_id The ID of the memory that the caller prefers
 *  for the buffer allocation.
 *  @param userp The user data pointer that is provided as
 *  'response_allocator_userp' in the call to
 *  TRITONSERVER_InferenceRequestSetResponseCallback.
 *  @param buffer Returns a pointer to the allocated memory.
 *  @param buffer_userp Returns a user-specified value to associate
 *  with the buffer, or nullptr if no user-specified value should be
 *  associated with the buffer. This value will be provided in the
 *  call to TRITONSERVER_ResponseAllocatorReleaseFn_t when the buffer
 *  is released and will also be returned by
 *  TRITONSERVER_InferenceResponseOutput.
 *  @param actual_memory_type Returns the type of memory where the
 *  allocation resides. May be different than the type of memory
 *  requested by 'memory_type'.
 *  @param actual_memory_type_id Returns the ID of the memory where
 *  the allocation resides. May be different than the ID of the memory
 *  requested by 'memory_type_id'.
 *  @return a TRITONSERVER_Error object if a failure occurs while
 *  attempting an allocation. If an error is returned all other return
 *  values will be ignored. */

///
@Properties(inherit = org.bytedeco.tritonserver.presets.tritonserver.class)
public class TRITONSERVER_ResponseAllocatorAllocFn_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    TRITONSERVER_ResponseAllocatorAllocFn_t(Pointer p) { super(p); }
    protected TRITONSERVER_ResponseAllocatorAllocFn_t() { allocate(); }
    private native void allocate();
    public native TRITONSERVER_Error call(
    TRITONSERVER_ResponseAllocator allocator, String tensor_name,
    @Cast("size_t") long byte_size, @Cast("TRITONSERVER_MemoryType") int memory_type,
    @Cast("int64_t") long memory_type_id, Pointer userp, @Cast("void**") PointerPointer buffer, @Cast("void**") PointerPointer buffer_userp,
    @Cast("TRITONSERVER_MemoryType*") IntPointer actual_memory_type,
    @Cast("int64_t*") LongPointer actual_memory_type_id);
}
