// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.tritonserver.tritonserver;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.tritonserver.global.tritonserver.*;


/** Type for function that is called when the server no longer holds
 *  any reference to a buffer allocated by
 *  TRITONSERVER_ResponseAllocatorAllocFn_t. In practice this function
 *  is typically called when the response object associated with the
 *  buffer is deleted by TRITONSERVER_InferenceResponseDelete.
 * 
 *  @param allocator The allocator that is provided in the call to
 *  TRITONSERVER_InferenceRequestSetResponseCallback.
 *  @param buffer Pointer to the buffer to be freed.
 *  @param buffer_userp The user-specified value associated
 *  with the buffer in TRITONSERVER_ResponseAllocatorAllocFn_t.
 *  @param byte_size The size of the buffer.
 *  @param memory_type The type of memory holding the buffer.
 *  @param memory_type_id The ID of the memory holding the buffer.
 *  @return a TRITONSERVER_Error object if a failure occurs while
 *  attempting the release. If an error is returned Triton will not
 *  attempt to release the buffer again. */

///
@Properties(inherit = org.bytedeco.tritonserver.presets.tritonserver.class)
public class TRITONSERVER_ResponseAllocatorReleaseFn_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    TRITONSERVER_ResponseAllocatorReleaseFn_t(Pointer p) { super(p); }
    protected TRITONSERVER_ResponseAllocatorReleaseFn_t() { allocate(); }
    private native void allocate();
    public native TRITONSERVER_Error call(
    TRITONSERVER_ResponseAllocator allocator, Pointer buffer,
    Pointer buffer_userp, @Cast("size_t") long byte_size, @Cast("TRITONSERVER_MemoryType") int memory_type,
    @Cast("int64_t") long memory_type_id);
}
