// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.tvm;

import org.bytedeco.tvm.Module;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.opencl.*;
import static org.bytedeco.opencl.global.OpenCL.*;
import org.bytedeco.dnnl.*;
import static org.bytedeco.dnnl.global.dnnl.*;
import org.bytedeco.llvm.LLVM.*;
import static org.bytedeco.llvm.global.LLVM.*;
import static org.bytedeco.mkl.global.mkl_rt.*;

import static org.bytedeco.tvm.global.tvm_runtime.*;


/**
 * \brief Object container class that backs NDArray.
 * \note do not use this function directly, use NDArray.
 */
@Name("tvm::runtime::NDArray::Container") @NoOffset @Properties(inherit = org.bytedeco.tvm.presets.tvm_runtime.class)
public class Container extends TVMObject {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Container(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public Container(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public Container position(long position) {
        return (Container)super.position(position);
    }
    @Override public Container getPointer(long i) {
        return new Container((Pointer)this).offsetAddress(i);
    }
    public ContainerBase asContainerBase() { return asContainerBase(this); }
    @Namespace public static native @Name("static_cast<tvm::runtime::NDArray::ContainerBase*>") ContainerBase asContainerBase(Container pointer);

  /** \brief default constructor */
  public Container() { super((Pointer)null); allocate(); }
  private native void allocate();

  public Container(Pointer data, @ByVal ShapeTuple shape, @ByVal DLDataType dtype, @ByVal @Cast("tvm::Device*") DLDevice dev) { super((Pointer)null); allocate(data, shape, dtype, dev); }
  private native void allocate(Pointer data, @ByVal ShapeTuple shape, @ByVal DLDataType dtype, @ByVal @Cast("tvm::Device*") DLDevice dev);
  /**
   * \brief Set the deleter field.
   * @param deleter The deleter.
   */
  public native void SetDeleter(FDeleter deleter);

  // Expose DecRef and IncRef as public function
  // NOTE: they are only for developer purposes only.

  // Information for object protocol.
  @MemberGetter public static native @Cast("const uint32_t") int _type_index();
  public static final int _type_index = _type_index();
  @MemberGetter public static native @Cast("const uint32_t") int _type_child_slots();
  public static final int _type_child_slots = _type_child_slots();
  @MemberGetter public static native @Cast("const bool") boolean _type_child_slots_can_overflow();
  public static final boolean _type_child_slots_can_overflow = _type_child_slots_can_overflow();
  @MemberGetter public static native @Cast("const char*") BytePointer _type_key();
  public static native @Cast("uint32_t") int RuntimeTypeIndex();
  public static native @Cast("uint32_t") int _GetOrAllocRuntimeTypeIndex();
}
