// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.tvm;

import org.bytedeco.tvm.Module;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.opencl.*;
import static org.bytedeco.opencl.global.OpenCL.*;
import org.bytedeco.dnnl.*;
import static org.bytedeco.dnnl.global.dnnl.*;
import org.bytedeco.llvm.LLVM.*;
import static org.bytedeco.llvm.global.LLVM.*;
import static org.bytedeco.mkl.global.mkl_rt.*;

import static org.bytedeco.tvm.global.tvm_runtime.*;

// #endif  // TVM_LOG_DEBUG

// #if (USE_FALLBACK_STL_MAP != 0)

/** \brief Shared content of all specializations of hash map */
@Namespace("tvm::runtime") @NoOffset @Properties(inherit = org.bytedeco.tvm.presets.tvm_runtime.class)
public class MapNode extends TVMObject {
    static { Loader.load(); }
    /** Default native constructor. */
    public MapNode() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public MapNode(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MapNode(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public MapNode position(long position) {
        return (MapNode)super.position(position);
    }
    @Override public MapNode getPointer(long i) {
        return new MapNode((Pointer)this).offsetAddress(i);
    }

  /** \brief Type of the keys in the hash map */
  /** \brief Type of the values in the hash map */
  /** \brief Type of the actual underlying container */
  /** \brief Iterator class */
  /** \brief Iterator class */
  /** \brief Type of value stored in the hash map */

  @MemberGetter public static native @Cast("const uint32_t") int _type_index();
  public static final int _type_index = _type_index();
  @MemberGetter public static native @Cast("const char*") BytePointer _type_key();
  @MemberGetter public static native @Cast("const bool") boolean _type_final();
  public static final boolean _type_final = _type_final();
  @MemberGetter public static native int _type_child_slots();
  public static final int _type_child_slots = _type_child_slots();
  public static native @Cast("uint32_t") int RuntimeTypeIndex();
  public static native @Cast("uint32_t") int _GetOrAllocRuntimeTypeIndex();

  /**
   * \brief Number of elements in the SmallMapNode
   * @return The result
   */
  public native @Cast("size_t") long size();
  /**
   * \brief Count the number of times a key exists in the hash map
   * @param key The indexing key
   * @return The result, 0 or 1
   */
  public native @Cast("size_t") long count(@Const @ByRef ObjectRef key);
  /**
   * \brief Index value associated with a key, throw exception if the key does not exist
   * @param key The indexing key
   * @return The const reference to the value
   */
  /**
   * \brief Index value associated with a key, throw exception if the key does not exist
   * @param key The indexing key
   * @return The mutable reference to the value
   */
  public native @ByRef ObjectRef at(@Const @ByRef ObjectRef key);
  /** @return begin iterator */
  public native @ByVal @Cast("tvm::runtime::MapNode::iterator*") Pointer begin();
  /** @return const begin iterator */
  /** @return end iterator */
  public native @ByVal @Cast("tvm::runtime::MapNode::iterator*") Pointer end();
  /** @return end iterator */
  /**
   * \brief Index value associated with a key
   * @param key The indexing key
   * @return The iterator of the entry associated with the key, end iterator if not exists
   */
  /**
   * \brief Index value associated with a key
   * @param key The indexing key
   * @return The iterator of the entry associated with the key, end iterator if not exists
   */
  public native @ByVal @Cast("tvm::runtime::MapNode::iterator*") Pointer find(@Const @ByRef ObjectRef key);
  /**
   * \brief Erase the entry associated with the iterator
   * @param position The iterator
   */
  public native void erase(@Cast("const tvm::runtime::MapNode::iterator*") @ByRef Pointer _position);
  /**
   * \brief Erase the entry associated with the key, do nothing if not exists
   * @param key The indexing key
   */
  public native void erase(@Const @ByRef ObjectRef key);
  /**
   * \brief Create an empty container
   * @return The object created
   */
  public static native @ByVal MapNodePtr Empty();
}
