// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.tvm;

import org.bytedeco.tvm.Module;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.opencl.*;
import static org.bytedeco.opencl.global.OpenCL.*;
import org.bytedeco.dnnl.*;
import static org.bytedeco.dnnl.global.dnnl.*;
import org.bytedeco.llvm.LLVM.*;
import static org.bytedeco.llvm.global.LLVM.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.tvm.global.tvm_runtime.*;

@Name("tvm::runtime::ObjectPtr<tvm::runtime::MapNode>") @NoOffset @Properties(inherit = org.bytedeco.tvm.presets.tvm_runtime.class)
public class MapNodePtr extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MapNodePtr(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public MapNodePtr(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public MapNodePtr position(long position) {
        return (MapNodePtr)super.position(position);
    }
    @Override public MapNodePtr getPointer(long i) {
        return new MapNodePtr((Pointer)this).offsetAddress(i);
    }

  /** \brief default constructor */
  public MapNodePtr() { super((Pointer)null); allocate(); }
  private native void allocate();
  /** \brief default constructor */  // NOLINT(*)
  /**
   * \brief copy constructor
   * @param other The value to be moved
   */
  public MapNodePtr(@Const @ByRef MapNodePtr other) { super((Pointer)null); allocate(other); }
  private native void allocate(@Const @ByRef MapNodePtr other);
  /**
   * \brief copy constructor
   * @param other The value to be moved
   */
  /**
   * \brief move constructor
   * @param other The value to be moved
   */
  /**
   * \brief move constructor
   * @param other The value to be moved
   */
  /** \brief destructor */
  /**
   * \brief Swap this array with another Object
   * @param other The other Object
   */
  public native void swap(@ByRef MapNodePtr other);
  /**
   * @return Get the content of the pointer
   */
  public native MapNode get();
  /**
   * @return The pointer
   */
  public native @Name("operator ->") MapNode access();
  /**
   * @return The reference
   */
  public native @ByRef @Name("operator *") MapNode multiply();
  /**
   * \brief copy assignment
   * @param other The value to be assigned.
   * @return reference to self.
   */
  public native @ByRef @Name("operator =") MapNodePtr put(@Const @ByRef MapNodePtr other);
  /**
   * \brief move assignment
   * @param other The value to be assigned.
   * @return reference to self.
   */
  /**
   * \brief nullptr check
   * @return result of comparison of internal pointer with nullptr.
   */
  public native @Cast("bool") @Name("operator bool") boolean asBoolean();
  /** \brief reset the content of ptr to be nullptr */
  public native void reset();
  /** @return The use count of the ptr, for debug purposes */
  public native int use_count();
  /** @return whether the reference is unique */
  public native @Cast("bool") boolean unique();
  /** @return Whether two ObjectPtr do not equal each other */
  public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef MapNodePtr other);
  /** @return Whether two ObjectPtr equals each other */
  public native @Cast("bool") @Name("operator !=") boolean notEquals(@Const @ByRef MapNodePtr other);
  /** @return Whether the pointer is nullptr */
  /** @return Whether the pointer is not nullptr */
}
