// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.tvm;

import org.bytedeco.tvm.Module;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.opencl.*;
import static org.bytedeco.opencl.global.OpenCL.*;
import org.bytedeco.dnnl.*;
import static org.bytedeco.dnnl.global.dnnl.*;
import org.bytedeco.llvm.LLVM.*;
import static org.bytedeco.llvm.global.LLVM.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.tvm.global.tvm_runtime.*;


/** \brief Base class of all object reference */
@Namespace("tvm::runtime") @NoOffset @Properties(inherit = org.bytedeco.tvm.presets.tvm_runtime.class)
public class ObjectRef extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ObjectRef(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ObjectRef(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public ObjectRef position(long position) {
        return (ObjectRef)super.position(position);
    }
    @Override public ObjectRef getPointer(long i) {
        return new ObjectRef((Pointer)this).offsetAddress(i);
    }

  /** \brief default constructor */
  public ObjectRef() { super((Pointer)null); allocate(); }
  private native void allocate();
  /** \brief Constructor from existing object ptr */
  public ObjectRef(@ByVal ObjectPtr data) { super((Pointer)null); allocate(data); }
  private native void allocate(@ByVal ObjectPtr data);
  /**
   * \brief Comparator
   * @param other Another object ref.
   * @return the compare result.
   */
  public native @Cast("bool") boolean same_as(@Const @ByRef ObjectRef other);
  /**
   * \brief Comparator
   * @param other Another object ref.
   * @return the compare result.
   */
  public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef ObjectRef other);
  /**
   * \brief Comparator
   * @param other Another object ref.
   * @return the compare result.
   */
  public native @Cast("bool") @Name("operator !=") boolean notEquals(@Const @ByRef ObjectRef other);
  /**
   * \brief Comparator
   * @param other Another object ref by address.
   * @return the compare result.
   */
  public native @Cast("bool") @Name("operator <") boolean lessThan(@Const @ByRef ObjectRef other);
  /**
   * @return whether the object is defined(not null).
   */
  public native @Cast("bool") boolean defined();
  /** @return the internal object pointer */
  public native @Const TVMObject get();
  /** @return the internal object pointer */
  public native @Const @Name("operator ->") TVMObject access();
  /** @return whether the reference is unique */
  public native @Cast("bool") boolean unique();
  /** @return The use count of the ptr, for debug purposes */
  public native int use_count();

  /**
   * \brief Try to downcast the internal Object to a
   *  raw pointer of a corresponding type.
   *
   *  The function will return a nullptr if the cast failed.
   *
   *      if (const AddNode *ptr = node_ref.as<AddNode>()) {
   *        // This is an add node
   *      }
   *
   * \tparam ObjectType the target type, must be a subtype of Object
   */

  /**
   * \brief Try to downcast the ObjectRef to a
   *    Optional<T> of the requested type.
   *
   *  The function will return a NullOpt if the cast failed.
   *
   *      if (Optional<Add> opt = node_ref.as<Add>()) {
   *        // This is an add node
   *      }
   *
   * \note While this method is declared in <tvm/runtime/object.h>,
   * the implementation is in <tvm/runtime/container/optional.h> to
   * prevent circular includes.  This additional include file is only
   * required in compilation units that uses this method.
   *
   * \tparam ObjectRefType the target type, must be a subtype of ObjectRef
   */

  /** \brief type indicate the container type. */
  // Default type properties for the reference class.
  @MemberGetter public static native @Cast("const bool") boolean _type_is_nullable();
  public static final boolean _type_is_nullable = _type_is_nullable();
}
