// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.tvm;

import org.bytedeco.tvm.Module;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.opencl.*;
import static org.bytedeco.opencl.global.OpenCL.*;
import org.bytedeco.dnnl.*;
import static org.bytedeco.dnnl.global.dnnl.*;
import org.bytedeco.llvm.LLVM.*;
import static org.bytedeco.llvm.global.LLVM.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.tvm.global.tvm_runtime.*;


/** \brief A utility class that adds methods useful for each POD type
 *
 * These cannot be provided in the base PODValue_ class, because
 * TVMArgValue and TVMRetValue have different semantics for kTVMStr
 * and kTVMBytes.
 *
 * kTVMStr:
 *
 *     For {@code TVMArgValue}, the active variant is {@code v_str}, a {@code const
 *     char*}.  For {@code TVMRetValue}, the active variant is {@code v_handle},
 *     and should be cast from {@code void*} to {@code std::string*}.
 *
 * kTVMBytes:
 *
 *     The active variant is {@code v_handle}, a {@code void*}.  For
 *     {@code TVMArgValue}, should be cast to {@code TVMByteArray*}.  For
 *     {@code TVMRetValue}, should be cast to {@code std::string*}.
 *
 * When converting into an {@code ObjectRef}, a string may be used to build
 * a {@code tvm::runtime::String}.  Because TVMArgValue and TVMRetValue use
 * different representations for strings, any utility funciton which
 * might attempt a conversion to an {@code ObjectRef} must be performed
 * within a context that is aware of the derived class.
 */
@Name("tvm::runtime::TVMPODValue_CRTP_<tvm::runtime::TVMArgValue>") @Properties(inherit = org.bytedeco.tvm.presets.tvm_runtime.class)
public class TVMPODArgValue extends TVMPODValue_ {
    static { Loader.load(); }
    /** Default native constructor. */
    public TVMPODArgValue() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public TVMPODArgValue(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TVMPODArgValue(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public TVMPODArgValue position(long position) {
        return (TVMPODArgValue)super.position(position);
    }
    @Override public TVMPODArgValue getPointer(long i) {
        return new TVMPODArgValue((Pointer)this).offsetAddress(i);
    }


  // ObjectRef handling

  public native @Name("operator double") double asDouble();
  public native @Cast("int64_t") @Name("operator int64_t") long asLong();
  public native @Name("operator int") int asInt();
  public native @Cast("bool") @Name("operator bool") boolean asBoolean();
}
