// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.tvm.global;

import org.bytedeco.tvm.*;

import org.bytedeco.tvm.Module;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.opencl.*;
import static org.bytedeco.opencl.global.OpenCL.*;
import org.bytedeco.dnnl.*;
import static org.bytedeco.dnnl.global.dnnl.*;
import org.bytedeco.llvm.LLVM.*;
import static org.bytedeco.llvm.global.LLVM.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

public class tvm_runtime extends org.bytedeco.tvm.presets.tvm_runtime {
    static { Loader.load(); }

// Targeting ..\StringVector.java


// Parsed from dlpack/dlpack.h

/**
 *  Copyright (c) 2017 by Contributors
 * \file dlpack.h
 * \brief The common header of DLPack.
 */
// #ifndef DLPACK_DLPACK_H_
// #define DLPACK_DLPACK_H_

/**
 * \brief Compatibility with C++
 */
// #ifdef __cplusplus
// #define DLPACK_EXTERN_C extern "C"
// #else
// #endif

/** \brief The current version of dlpack */
public static final int DLPACK_VERSION = 70;

/** \brief The current ABI version of dlpack */
public static final int DLPACK_ABI_VERSION = 1;

/** \brief DLPACK_DLL prefix for windows */
// #ifdef _WIN32
// #ifdef DLPACK_EXPORTS
// #define DLPACK_DLL __declspec(dllexport)
// #else
// #define DLPACK_DLL __declspec(dllimport)
// #endif
// #else
// #define DLPACK_DLL
// #endif

// #include <stdint.h>
// #include <stddef.h>

// #ifdef __cplusplus
// #endif
/**
 * \brief The device type in DLDevice.
 */
// #ifdef __cplusplus
/** enum DLDeviceType */
public static final int
// #else
// #endif
  /** \brief CPU device */
  kDLCPU = 1,
  /** \brief CUDA GPU device */
  kDLCUDA = 2,
  /**
   * \brief Pinned CUDA CPU memory by cudaMallocHost
   */
  kDLCUDAHost = 3,
  /** \brief OpenCL devices. */
  kDLOpenCL = 4,
  /** \brief Vulkan buffer for next generation graphics. */
  kDLVulkan = 7,
  /** \brief Metal for Apple GPU. */
  kDLMetal = 8,
  /** \brief Verilog simulator buffer */
  kDLVPI = 9,
  /** \brief ROCm GPUs for AMD GPUs */
  kDLROCM = 10,
  /**
   * \brief Pinned ROCm CPU memory allocated by hipMallocHost
   */
  kDLROCMHost = 11,
  /**
   * \brief Reserved extension device type,
   * used for quickly test extension device
   * The semantics can differ depending on the implementation.
   */
  kDLExtDev = 12,
  /**
   * \brief CUDA managed/unified memory allocated by cudaMallocManaged
   */
  kDLCUDAManaged = 13,
  /**
   * \brief Unified shared memory allocated on a oneAPI non-partititioned
   * device. Call to oneAPI runtime is required to determine the device
   * type, the USM allocation type and the sycl context it is bound to.
   *
   */
  kDLOneAPI = 14,
  /** \brief GPU support for next generation WebGPU standard. */
  kDLWebGPU = 15,
  /** \brief Qualcomm Hexagon DSP */
  kDLHexagon = 16;
// Targeting ..\DLDevice.java



/**
 * \brief The type code options DLDataType.
 */
/** enum DLDataTypeCode */
public static final int
  /** \brief signed integer */
  kDLInt = 0,
  /** \brief unsigned integer */
  kDLUInt = 1,
  /** \brief IEEE floating point */
  kDLFloat = 2,
  /**
   * \brief Opaque handle type, reserved for testing purposes.
   * Frameworks need to agree on the handle data type for the exchange to be well-defined.
   */
  kDLOpaqueHandle = 3,
  /** \brief bfloat16 */
  kDLBfloat = 4,
  /**
   * \brief complex number
   * (C/C++/Python layout: compact struct per complex number)
   */
  kDLComplex = 5;
// Targeting ..\DLDataType.java


// Targeting ..\DLTensor.java


// Targeting ..\DLManagedTensor.java


// #ifdef __cplusplus  // DLPACK_EXTERN_C
// #endif
// #endif  // DLPACK_DLPACK_H_


// Parsed from dmlc/base.h

/**
 *  Copyright (c) 2015 by Contributors
 * \file base.h
 * \brief defines configuration macros
 */
// #ifndef DMLC_BASE_H_
// #define DMLC_BASE_H_

/** \brief whether use glog for logging */
// #ifndef DMLC_USE_GLOG
public static final int DMLC_USE_GLOG = 0;
// #endif

/*
 * The preprocessor definition DMLC_USE_LOGGING_LIBRARY determines whether to
 * use a user-defined logging library. If defined, dmlc will not define the
 * macros CHECK() and LOG() and instead locate CHECK() and LOG() from the value
 * of DMLC_USE_LOGGING_LIBRARY. The DMLC_USE_LOGGING_LIBRARY macro shall be of
 * form <my_logging.h>:
 *
 * #define DMLC_USE_LOGGING_LIBRARY <my_logging.h>
 *
 * Make sure to define CHECK() and LOG() macros in the provided header;
 * otherwise the build will fail.
 */

/**
 * \brief whether throw dmlc::Error instead of
 *  directly calling abort when FATAL error occured
 *  NOTE: this may still not be perfect.
 *  do not use FATAL and CHECK in destructors
 */
// #ifndef DMLC_LOG_FATAL_THROW
public static final int DMLC_LOG_FATAL_THROW = 1;
// #endif

/**
 * \brief whether always log a message before throw
 * This can help identify the error that cannot be catched.
 */
// #ifndef DMLC_LOG_BEFORE_THROW
public static final int DMLC_LOG_BEFORE_THROW = 0;
// #endif

/**
 * \brief Whether to use customized logger,
 * whose output can be decided by other libraries.
 */
// #ifndef DMLC_LOG_CUSTOMIZE
public static final int DMLC_LOG_CUSTOMIZE = 0;
// #endif

/**
 * \brief Whether to enable debug logging feature.
 */
// #ifndef DMLC_LOG_DEBUG
// #ifdef NDEBUG
public static final int DMLC_LOG_DEBUG = 0;
// #else
// #endif
// #endif

/**
 * \brief Whether to disable date message on the log.
 */
// #ifndef DMLC_LOG_NODATE
public static final int DMLC_LOG_NODATE = 0;
// #endif

/** \brief whether compile with hdfs support */
// #ifndef DMLC_USE_HDFS
public static final int DMLC_USE_HDFS = 0;
// #endif

/** \brief whether compile with s3 support */
// #ifndef DMLC_USE_S3
public static final int DMLC_USE_S3 = 0;
// #endif

/** \brief whether or not use parameter server */
// #ifndef DMLC_USE_PS
public static final int DMLC_USE_PS = 0;
// #endif

/** \brief whether or not use c++11 support */
// #ifndef DMLC_USE_CXX11
// #if defined(__GXX_EXPERIMENTAL_CXX0X__) || defined(_MSC_VER)
public static final int DMLC_USE_CXX11 = 1;
// #else
// #endif
// #endif

/** \brief strict CXX11 support */
// #ifndef DMLC_STRICT_CXX11
// #if defined(_MSC_VER)
// #else
// #define DMLC_STRICT_CXX11 (__cplusplus >= 201103L)
// #endif
// #endif

/** \brief Whether cxx11 thread local is supported */
// #ifndef DMLC_CXX11_THREAD_LOCAL
// #if defined(_MSC_VER)
// #elif defined(__clang__)
// #define DMLC_CXX11_THREAD_LOCAL (__has_feature(cxx_thread_local))
// #else
// #define DMLC_CXX11_THREAD_LOCAL (__cplusplus >= 201103L)
// #endif
// #endif

/** \brief Whether to use modern thread local construct */
// #ifndef DMLC_MODERN_THREAD_LOCAL
public static final int DMLC_MODERN_THREAD_LOCAL = 1;
// #endif



/** \brief whether RTTI is enabled */
// #ifndef DMLC_ENABLE_RTTI
public static final int DMLC_ENABLE_RTTI = 1;
// #endif

/** \brief whether use fopen64 */
// #ifndef DMLC_USE_FOPEN64
public static final int DMLC_USE_FOPEN64 = 1;
// #endif

/** check for C++11 support */
// #if DMLC_USE_CXX11
// #if (!defined(_MSC_VER) && __cplusplus < 201103L) || (defined(_MSC_VER) && _MSC_VER < 1900)
// MSVC doesn't support __cplusplus macro properly until MSVC 2017
// We want to also support MSVC 2015, so manually check _MSC_VER

// #pragma message("Compiling without c++11, some features may be disabled")
// #undef DMLC_USE_CXX11

// #endif  // (!defined(_MSC_VER) && __cplusplus < 201103L) || (defined(_MSC_VER) && _MSC_VER < 1900)
// #endif  // DMLC_USE_CXX11

/**
 * \brief Use little endian for binary serialization
 *  if this is set to 0, use big endian.
 */
// #ifndef DMLC_IO_USE_LITTLE_ENDIAN
public static final int DMLC_IO_USE_LITTLE_ENDIAN = 1;
// #endif

/**
 * \brief Enable std::thread related modules,
 *  Used to disable some module in mingw compile.
 */
// #ifndef DMLC_ENABLE_STD_THREAD
public static final int DMLC_ENABLE_STD_THREAD = DMLC_USE_CXX11;
// #endif

/** \brief whether enable regex support, actually need g++-4.9 or higher*/
// #ifndef DMLC_USE_REGEX
public static native @MemberGetter int DMLC_USE_REGEX();
public static final int DMLC_USE_REGEX = DMLC_USE_REGEX();
// #endif

/** \brief helper macro to supress unused warning */
// #if defined(__GNUC__)
// #define DMLC_ATTRIBUTE_UNUSED __attribute__((unused))
// #else
// #define DMLC_ATTRIBUTE_UNUSED
// #endif

/** \brief helper macro to supress Undefined Behavior Sanitizer for a specific function */
// #if defined(__clang__)
// #define DMLC_SUPPRESS_UBSAN __attribute__((no_sanitize("undefined")))
// #elif defined(__GNUC__) && (__GNUC__ * 100 + __GNUC_MINOR__ >= 409)
// #define DMLC_SUPPRESS_UBSAN __attribute__((no_sanitize_undefined))
// #else
// #define DMLC_SUPPRESS_UBSAN
// #endif

/** \brief helper macro to generate string concat */
// #define DMLC_STR_CONCAT_(__x, __y) __x##__y
// #define DMLC_STR_CONCAT(__x, __y) DMLC_STR_CONCAT_(__x, __y)

/**
 * \brief Disable copy constructor and assignment operator.
 *
 * If C++11 is supported, both copy and move constructors and
 * assignment operators are deleted explicitly. Otherwise, they are
 * only declared but not implemented. Place this macro in private
 * section if C++11 is not available.
 */
// #ifndef DISALLOW_COPY_AND_ASSIGN
// #  if DMLC_USE_CXX11
// #    define DISALLOW_COPY_AND_ASSIGN(T)
//        T(T const&) = delete;
//        T(T&&) = delete;
//        T& operator=(T const&) = delete;
//        T& operator=(T&&) = delete
// #  else
// #  endif
// #endif

// #ifdef __APPLE__
// #endif

// #ifdef _MSC_VER
// #else
// #ifdef _FILE_OFFSET_BITS
// #if _FILE_OFFSET_BITS == 32
// #pragma message("Warning: FILE OFFSET BITS defined to be 32 bit")
// #endif
// #endif
// #include <sys/types.h>
// #endif

// #ifdef _MSC_VER
// #else
// #include <inttypes.h>
// #endif
// #include <string>
// #include <vector>

// #if defined(_MSC_VER) && _MSC_VER < 1900
// #endif

// #if defined(_MSC_VER)
// #else
// #define DMLC_NO_INLINE __attribute__((noinline))
// #endif

// #if defined(__GNUC__) || defined(__clang__)
// #define DMLC_ALWAYS_INLINE inline __attribute__((__always_inline__))
// #elif defined(_MSC_VER)
// #else
// #define DMLC_ALWAYS_INLINE inline
// #endif

// #if DMLC_USE_CXX11
public static native @MemberGetter int DMLC_THROW_EXCEPTION();
public static final int DMLC_THROW_EXCEPTION = DMLC_THROW_EXCEPTION();
public static native @MemberGetter int DMLC_NO_EXCEPTION();
public static final int DMLC_NO_EXCEPTION = DMLC_NO_EXCEPTION();
// #else
// #endif

/** \brief namespace for dmlc */
/**
 * \brief safely get the beginning address of a vector
 * @param vec input vector
 * @return beginning address of a vector
 */
/**
 * \brief get the beginning address of a const vector
 * @param vec input vector
 * @return beginning address of a vector
 */
/**
 * \brief get the beginning address of a string
 * @param str input string
 * @return beginning address of a string
 */
@Namespace("dmlc") public static native @Cast("char*") BytePointer BeginPtr(@StdString @ByRef BytePointer str);
/**
 * \brief get the beginning address of a const string
 * @param str input string
 * @return beginning address of a string
 */
@Namespace("dmlc") public static native String BeginPtr(@StdString String str);
  // namespace dmlc

// #if defined(_MSC_VER) && _MSC_VER < 1900
// #endif

/* If fopen64 is not defined by current machine,
   replace fopen64 with std::fopen. Also determine ability to print stack trace
   for fatal error and define DMLC_LOG_STACK_TRACE if stack trace can be
   produced. Always keep this include directive at the bottom of dmlc/base.h */
// #ifdef DMLC_CORE_USE_CMAKE
// #include <dmlc/build_config.h>
// #else
// #include <dmlc/build_config_default.h>
// #endif

// #endif  // DMLC_BASE_H_


// Parsed from dmlc/logging.h

/**
 *  Copyright (c) 2015 by Contributors
 * \file logging.h
 * \brief defines logging macros of dmlc
 *  allows use of GLOG, fall back to internal
 *  implementation when disabled
 */
// #ifndef DMLC_LOGGING_H_
// #define DMLC_LOGGING_H_
// #include <cstdio>
// #include <cstdlib>
// #include <string>
// #include <vector>
// #include <stdexcept>
// #include <memory>
// #include "./base.h"

// #if DMLC_LOG_STACK_TRACE
// #include <cxxabi.h>
// #include <sstream>
// #include DMLC_EXECINFO_H
// #endif
// Targeting ..\Error.java



// #if DMLC_LOG_STACK_TRACE
// get stack trace logging depth from env variable.
@Namespace("dmlc") public static native @Cast("size_t") long LogStackTraceLevel();



// By default skip the first frame because
// that belongs to ~LogMessageFatal
@Namespace("dmlc") public static native @StdString BytePointer StackTrace(
    @Cast("size_t") long start_frame/*=1*/,
    @Cast("const size_t") long stack_size/*=DMLC_LOG_STACK_TRACE_SIZE*/);
@Namespace("dmlc") public static native @StdString BytePointer StackTrace();

// #else  // DMLC_LOG_STACK_TRACE is off

// #endif  // DMLC_LOG_STACK_TRACE
  // namespace dmlc

// #if DMLC_USE_GLOG
// #include <glog/logging.h>
/**
 * \brief optionally redirect to google's init log
 * @param argv0 The arguments.
 */
@Namespace("dmlc") public static native void InitLogging(@Cast("const char*") BytePointer argv0);
@Namespace("dmlc") public static native void InitLogging(String argv0);
  // namespace dmlc

// #elif defined DMLC_USE_LOGGING_LIBRARY

// #include DMLC_USE_LOGGING_LIBRARY


// #else

// #endif
// #endif  // DMLC_LOGGING_H_


// Parsed from dmlc/io.h

/**
 *  Copyright (c) 2015 by Contributors
 * \file io.h
 * \brief defines serializable interface of dmlc
 */
// #ifndef DMLC_IO_H_
// #define DMLC_IO_H_
// #include <cstdio>
// #include <string>
// #include <cstring>
// #include <vector>
// #include <istream>
// #include <ostream>
// #include <streambuf>
// #include "./logging.h"

// include uint64_t only to make io standalone
// #ifdef _MSC_VER
// #else
// #include <inttypes.h>
// #endif

/** \brief namespace for dmlc */
// Targeting ..\Stream.java


// Targeting ..\SeekStream.java


// Targeting ..\Serializable.java


// Targeting ..\InputSplit.java


// Targeting ..\ostream.java


// Targeting ..\istream.java


// #endif
  // namespace dmlc

// #include "./serializer.h"
// implementations of inline functions







// #ifndef _LIBCPP_SGX_NO_IOSTREAMS
// implementations for ostream




// implementations for istream


// #endif
// Targeting ..\URI.java



/** \brief type of file */
/** enum dmlc::io::FileType */
public static final int
  /** \brief the file is file */
  kFile = 0,
  /** \brief the file is directory */
  kDirectory = 1;
// Targeting ..\FileInfo.java


// Targeting ..\FileSystem.java



  // namespace io
  // namespace dmlc
// #endif  // DMLC_IO_H_


// Parsed from dmlc/type_traits.h

/**
 *  Copyright (c) 2015 by Contributors
 * \file type_traits.h
 * \brief type traits information header
 */
// #ifndef DMLC_TYPE_TRAITS_H_
// #define DMLC_TYPE_TRAITS_H_

// #include "./base.h"
// #if DMLC_USE_CXX11
// #include <type_traits>
// #endif
// #include <string>
/**
 * \brief whether a type is pod type
 * \tparam T the type to query
 */


/**
 * \brief whether a type is integer type
 * \tparam T the type to query
 */

/**
 * \brief whether a type is floating point type
 * \tparam T the type to query
 */

/**
 * \brief whether a type is arithemetic type
 * \tparam T the type to query
 */

/**
 * \brief helper class to construct a string that represents type name
 *
 * Specialized this class to defined type name of custom types
 *
 * \tparam T the type to query
 */

/**
 * \brief the string representation of type name
 * \tparam T the type to query
 * @return a const string of typename.
 */

/**
 * \brief whether a type have save/load function
 * \tparam T the type to query
 */

/**
 * \brief template to select type based on condition
 * For example, IfThenElseType<true, int, float>::Type will give int
 * \tparam cond the condition
 * \tparam Then the typename to be returned if cond is true
 * \tparam Else typename to be returned if cond is false
*/

/** \brief macro to quickly declare traits information */
// #define DMLC_DECLARE_TRAITS(Trait, Type, Value)
//   template<>
//   struct Trait<Type> {
//     static const bool value = Value;
//   }

/** \brief macro to quickly declare traits information */
// #define DMLC_DECLARE_TYPE_NAME(Type, Name)
//   template<>
//   struct type_name_helper<Type> {
//     static inline std::string value() {
//       return Name;
//     }
//   }

/** \cond Doxygen_Suppress */
// declare special traits when C++11 is not available
// #if DMLC_USE_CXX11 == 0

// #endif
/** \endcond */
  // namespace dmlc
// #endif  // DMLC_TYPE_TRAITS_H_


// Parsed from dmlc/endian.h

/**
 *  Copyright (c) 2017 by Contributors
 * \file endian.h
 * \brief Endian testing, need c++11
 */
// #ifndef DMLC_ENDIAN_H_
// #define DMLC_ENDIAN_H_

// #include "./base.h"

// #ifdef DMLC_CMAKE_LITTLE_ENDIAN
  // If compiled with CMake, use CMake's endian detection logic
  public static native @MemberGetter int DMLC_LITTLE_ENDIAN();
  public static final int DMLC_LITTLE_ENDIAN = DMLC_LITTLE_ENDIAN();
// #else
// #endif

/** \brief whether serialize using little endian */
public static native @MemberGetter int DMLC_IO_NO_ENDIAN_SWAP();
public static final int DMLC_IO_NO_ENDIAN_SWAP = DMLC_IO_NO_ENDIAN_SWAP();

/**
 * \brief A generic inplace byte swapping function.
 * @param data The data pointer.
 * @param elem_bytes The number of bytes of the data elements
 * @param num_elems Number of elements in the data.
 * \note Always try pass in constant elem_bytes to enable
 *       compiler optimization
 */
@Namespace("dmlc") public static native void ByteSwap(Pointer data, @Cast("size_t") long elem_bytes, @Cast("size_t") long num_elems);

  // namespace dmlc
// #endif  // DMLC_ENDIAN_H_


// Parsed from dmlc/serializer.h

/**
 *  Copyright (c) 2015 by Contributors
 * \file serializer.h
 * \brief serializer template class that helps serialization.
 *  This file do not need to be directly used by most user.
 */
// #ifndef DMLC_SERIALIZER_H_
// #define DMLC_SERIALIZER_H_

// #include <vector>
// #include <string>
// #include <map>
// #include <set>
// #include <list>
// #include <deque>
// #include <utility>

// #include "./base.h"
// #include "./io.h"
// #include "./logging.h"
// #include "./type_traits.h"
// #include "./endian.h"

// #if DMLC_USE_CXX11
// #include <unordered_map>
// #include <unordered_set>
// #endif
/** \brief internal namespace for serializers */
/**
 * \brief generic serialization handler
 * \tparam T the type to be serialized
 * \tparam need_endian_swap Whether use little endian
 */

/** \cond Doxygen_Suppress
/**
 * \brief Serializer that redirect calls by condition
 * \tparam cond the condition
 * \tparam Then the serializer used for then condition
 * \tparam Else the serializer used for else condition
 * \tparam Return the type of data the serializer handles
 */

/** \brief Serializer for POD(plain-old-data) data */

/** \brief Serializer for arithmetic data, handle endianness */

// serializer for class that have save/load function

/**
 * \brief dummy class for undefined serialization.
 *   This is used to generate error message when user tries to
 *   serialize something that is not supported.
 * \tparam T the type to be serialized
 */

/**
 * \brief Serializer handler for std::vector<T> where T is POD type.
 * \tparam T element type
 */

/**
 * \brief Serializer handler for std::vector<T> where T can be composed type
 * \tparam T element type
 */

/**
 * \brief Serializer handler for std::basic_string<T> where T is POD type.
 * \tparam T element type
 */

/** \brief Serializer for std::pair */

// set type handler that can handle most collection type case


// handler that can handle most list type case
// this type insert function takes additional iterator

/** \endcond
<p>
/**
 * \brief generic serialization handler for type T
 *
 *  User can define specialization of this class to support
 *  composite serialization of their own class.
 *
 * \tparam T the type to be serialized
 */

/** \cond Doxygen_Suppress */

// #if DMLC_USE_CXX11
// #endif
/** \endcond */
  // namespace serializer
  // namespace dmlc
// #endif  // DMLC_SERIALIZER_H_


// Parsed from tvm/runtime/c_runtime_api.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * \file tvm/runtime/c_runtime_api.h
 * \brief TVM runtime library.
 *
 *  The philosophy of TVM project is to customize the compilation
 *  stage to generate code that can used by other projects transparently.
 *  So this is a minimum runtime code gluing, and some limited
 *  memory management code to enable quick testing.
 *
 *  The runtime API is independent from TVM compilation stack and can
 *  be linked via libtvm_runtime.
 *
 *  The common flow is:
 *   - Use TVMFuncListGlobalNames to get global function name
 *   - Use TVMFuncCall to call these functions.
 *
 *  Possible return values of the API functions:
 *  * 0: success
 *  * -1: the error can be retrieved through TVMGetLastError.
 *  * -2: a frontend error occurred and recorded in the frontend.
 */
// #ifndef TVM_RUNTIME_C_RUNTIME_API_H_
// #define TVM_RUNTIME_C_RUNTIME_API_H_

// Macros to do weak linking
// #ifdef _MSC_VER
// #else
// #define TVM_WEAK __attribute__((weak))
// #endif

// #ifdef __EMSCRIPTEN__
// #include <emscripten/emscripten.h>
// #define TVM_DLL EMSCRIPTEN_KEEPALIVE
// #endif

// helper macro to suppress unused warning
// #if defined(__GNUC__)
// #define TVM_ATTRIBUTE_UNUSED __attribute__((unused))
// #else
// #define TVM_ATTRIBUTE_UNUSED
// #endif

// #ifndef TVM_DLL
// #ifdef _WIN32
// #ifdef TVM_EXPORTS
// #define TVM_DLL __declspec(dllexport)
// #else
// #define TVM_DLL __declspec(dllimport)
// #endif
// #else
// #define TVM_DLL __attribute__((visibility("default")))
// #endif
// #endif

// TVM version
public static final String TVM_VERSION = "0.18.0";

// TVM Runtime is DLPack compatible.
// #include <dlpack/dlpack.h>

// #ifdef __cplusplus
// #endif
// #include <stdbool.h>
// #include <stddef.h>
// #include <stdint.h>

/** \brief type of array index. */

/** \brief Extension device types in TVM
 *
 * Additional enumerators to supplement those provided by
 * DLPack's {@code DLDeviceType} enumeration.
 *
 * MAINTAINERS NOTE #1: We need to ensure that the two devices
 * are identified by the same integer.
 * Currently this requires manual verification.
 * Discussed here: https://github.com/dmlc/dlpack/issues/111
 * As of DLPack v0.7, the highest-valued enumerator in
 * {@code DLDeviceType} is kDLHexagon = 16.
 *
 * MAINTAINERS NOTE #2: As of DLPack v0.7, the definition for
 * {@code DLDeviceType} specifies an underlying storage type of
 * {@code int32_t}.  That guarantees a variable of type
 * {@code DLDeviceType} is capable of holding any integers provided
 * by *either* of these enumerations.
 *
 * However, the {@code int32_t} specification only applies when the
 * header file is compiled as C++, and this header file is also
 * meant to work as C code.  So the unspecified storage type
 * could be a latent bug when compiled as C.
 */
// #ifdef __cplusplus
/** enum TVMDeviceExtType */
public static final int
// #else
// #endif
  // To help avoid accidental conflicts between `DLDeviceType`
  // and this enumeration, start numbering the new enumerators
  // a little higher than (currently) seems necessary.
  kDLAOCL = 32,
  kDLSDAccel = 33,
  kOpenGL = 34,
  kDLMicroDev = 35,
  TVMDeviceExtType_End = 36;  // sentinel value

// #ifdef __cplusplus
// Some other parts of TVM hardcode the integer identifier for
// some DLPack / TVM devices, rather then using the symbolic
// enumerator.   E.g., `2` rather than `kDLCUDA`.
// These asserts should alert us when that mapping breaks.
public static final String TVM_HARCODED_INTEGER_CHANGED_MSG =                                                          
  "Change in compile-time integer.  Make sure hardcoded uses of this integer throughout TVM are " +  
  "updated.";
// #undef TVM_HARCODED_INTEGER_CHANGED_MSG
// #endif

/**
 * \brief The type code in used and only used in TVM FFI for argument passing.
 *
 * DLPack consistency:
 * 1) kTVMArgInt is compatible with kDLInt
 * 2) kTVMArgFloat is compatible with kDLFloat
 * 3) kDLUInt is not in ArgTypeCode, but has a spared slot
 *
 * Downstream consistency:
 * The kDLInt, kDLUInt, kDLFloat are kept consistent with the original ArgType code
 *
 * It is only used in argument passing, and should not be confused with
 * DataType::TypeCode, which is DLPack-compatible.
 *
 * @see tvm::runtime::DataType::TypeCode
 */
/** enum TVMArgTypeCode */
public static final int
  kTVMArgInt = kDLInt,
  kTVMArgFloat = kDLFloat,
  kTVMOpaqueHandle = 3,
  kTVMNullptr = 4,
  kTVMDataType = 5,
  kDLDevice = 6,
  kTVMDLTensorHandle = 7,
  kTVMObjectHandle = 8,
  kTVMModuleHandle = 9,
  kTVMPackedFuncHandle = 10,
  kTVMStr = 11,
  kTVMBytes = 12,
  kTVMNDArrayHandle = 13,
  kTVMObjectRValueRefArg = 14,
  kTVMArgBool = 15,
  // Extension codes for other frameworks to integrate TVM PackedFunc.
  // To make sure each framework's id do not conflict, use first and
  // last sections to mark ranges.
  // Open an issue at the repo if you need a section of code.
  kTVMExtBegin = 16,
  kTVMNNVMFirst = 16,
  kTVMNNVMLast = 20,
  // The following section of code is used for non-reserved types.
  kTVMExtReserveEnd = 64,
  kTVMExtEnd = 128;

/** \brief the array handle */
// Targeting ..\TVMValue.java


// Targeting ..\TVMByteArray.java


// Targeting ..\TVMModuleHandle.java


// Targeting ..\TVMFunctionHandle.java


// Targeting ..\TVMRetValueHandle.java


// Targeting ..\TVMStreamHandle.java


// Targeting ..\TVMObjectHandle.java



/**
 * \brief Used for implementing C API function.
 *  Set last error message before return.
 * @param msg The error message to be set.
 */
public static native void TVMAPISetLastError(@Cast("const char*") BytePointer msg);
public static native void TVMAPISetLastError(String msg);

/**
 * \brief Used for implementing C API function.
 *  Set last exception before return.
 * @param py_object The python exception to be set
 */
public static native void TVMAPISetLastPythonError(Pointer py_object);

/** \brief Return the previous python error, if any.
 *
 * Used to propagate the original Python exception to a python
 * try/except, when there are C++ stack frames between the location thro
 *
 * @return The previous argument passed during the most recent call to
 *     TVMAPISetLastPythonError.  If TVMAPISetLastPythonError has not
 *     been called, or if TVMDropLastPythonError has been called since
 *     the most recent to TVMAPISetLastPythonError, returns nullptr.
 */
public static native Pointer TVMGetLastPythonError();

/**
 * \brief return str message of the last error
 *  all function in this file will return 0 when success
 *  and nonzero when an error occurred,
 *  TVMGetLastError can be called to retrieve the error
 *
 *  this function is threadsafe and can be called by different thread
 *  @return error info
 */
public static native @Cast("const char*") BytePointer TVMGetLastError();

/**
 * \brief Return the backtrace of the most recent error
 *
 * Returns the backtrace of the most recent error, if an error exists,
 * and the error contains a backtrace.  If no error exists or the
 * error does not contain a backtrace, returns nullptr.
 *
 *  @return The backtrace of the most recent error
 */
public static native @Cast("const char*") BytePointer TVMGetLastBacktrace();

/**
 * \brief Remove the propagated python error, if any
 *
 * Removes the TVM-held reference to a thrown python exception object.
 * Because these objects contain references to the stack frames from
 * which the exception was thrown, maintaining a reference to an
 * exception object prevents any local python variables from being
 * garbage-collected.  After retrieving the object using
 * TVMGetLastPythonError, the Python FFI interface uses this method to
 * clear the TVM-held reference to the exception, to allow garbage
 * collection to continue.
 */
public static native void TVMDropLastPythonError();

/** \brief Re-throw the most recent error.
 *
 * If an error was previously set using TVMAPISetLastError or
 * TVMAPISetLastPythonError, re-throw the error.  This is similar to
 * {@code LOG(FATAL) << TVMGetLastError()}, but includes handling to
 * propagate a python exception across C++ stack frames, or to append
 * a stack trace to an error message.
 */
public static native void TVMThrowLastError();

/**
 * \brief Load module from file.
 * @param file_name The file name to load the module from.
 * @param format The format of the module.
 * @param out The result module
 *
 * @return 0 when success, nonzero when failure happens
 * \note The resulting module do not contain import relation.
 *  It can be reconstructed by TVMModImport.
 */
public static native int TVMModLoadFromFile(@Cast("const char*") BytePointer file_name, @Cast("const char*") BytePointer format, @ByPtrPtr TVMModuleHandle out);
public static native int TVMModLoadFromFile(String file_name, String format, @ByPtrPtr TVMModuleHandle out);

/**
 * \brief Add dep to mod's dependency.
 *  This allows functions in this module to use modules.
 *
 * @param mod The module handle.
 * @param dep The dependent module to be imported.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMModImport(TVMModuleHandle mod, TVMModuleHandle dep);

/**
 * \brief Get function from the module.
 * @param mod The module handle.
 * @param func_name The name of the function.
 * @param query_imports Whether to query imported modules
 * @param out The result function, can be NULL if it is not available.
 * @return 0 when no error is thrown, nonzero when failure happens
 */
public static native int TVMModGetFunction(TVMModuleHandle mod, @Cast("const char*") BytePointer func_name, int query_imports,
                              @ByPtrPtr TVMFunctionHandle out);
public static native int TVMModGetFunction(TVMModuleHandle mod, String func_name, int query_imports,
                              @ByPtrPtr TVMFunctionHandle out);

/**
 * \brief Free the Module
 * @param mod The module to be freed.
 *
 * \note This may not free up the module's resources.
 *  If there is active TVMFunctionHandle uses the module
 *  Or if this module is imported by another active module.
 *
 *  The all functions remains valid until TVMFuncFree is called.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMModFree(TVMModuleHandle mod);

/**
 * \brief Free the function when it is no longer needed.
 * @param func The function handle
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMFuncFree(TVMFunctionHandle func);

/**
 * \brief Call a Packed TVM Function.
 *
 * @param func node handle of the function.
 * @param arg_values The arguments
 * @param type_codes The type codes of the arguments
 * @param num_args Number of arguments.
 *
 * @param ret_val The return value.
 * @param ret_type_code the type code of return value.
 *
 * @return 0 when success, nonzero when failure happens
 * \note TVM calls always exchanges with type bits=64, lanes=1
 *
 * \note API calls always exchanges with type bits=64, lanes=1
 *   If API call returns container handles (e.g. FunctionHandle)
 *   these handles should be managed by the front-end.
 *   The front-end need to call free function (e.g. TVMFuncFree)
 *   to free these handles.
 */
public static native int TVMFuncCall(TVMFunctionHandle func, TVMValue arg_values, IntPointer type_codes, int num_args,
                        TVMValue ret_val, IntPointer ret_type_code);
public static native int TVMFuncCall(TVMFunctionHandle func, TVMValue arg_values, IntBuffer type_codes, int num_args,
                        TVMValue ret_val, IntBuffer ret_type_code);
public static native int TVMFuncCall(TVMFunctionHandle func, TVMValue arg_values, int[] type_codes, int num_args,
                        TVMValue ret_val, int[] ret_type_code);

/**
 * \brief Set the return value of TVMPackedCFunc.
 *
 *  This function is called by TVMPackedCFunc to set the return value.
 *  When this function is not called, the function returns null by default.
 *
 * @param ret The return value handle, pass by ret in TVMPackedCFunc
 * @param value The value to be returned.
 * @param type_code The type of the value to be returned.
 * @param num_ret Number of return values, for now only 1 is supported.
 */
public static native int TVMCFuncSetReturn(TVMRetValueHandle ret, TVMValue value, IntPointer type_code, int num_ret);
public static native int TVMCFuncSetReturn(TVMRetValueHandle ret, TVMValue value, IntBuffer type_code, int num_ret);
public static native int TVMCFuncSetReturn(TVMRetValueHandle ret, TVMValue value, int[] type_code, int num_ret);

/**
 * \brief Inplace translate callback argument value to return value.
 *  This is only needed for non-POD arguments.
 *
 * @param value The value to be translated.
 * @param code The type code to be translated.
 * \note This function will do a shallow copy when necessary.
 *
 * @return 0 when success, nonzero when failure happens.
 */
public static native int TVMCbArgToReturn(TVMValue value, IntPointer code);
public static native int TVMCbArgToReturn(TVMValue value, IntBuffer code);
public static native int TVMCbArgToReturn(TVMValue value, int[] code);
// Targeting ..\TVMPackedCFunc.java


// Targeting ..\TVMPackedCFuncFinalizer.java


// Targeting ..\TVMExtensionFuncDeclarer.java



/**
 * \brief Wrap a TVMPackedCFunc to become a FunctionHandle.
 *
 * The resource_handle will be managed by TVM API, until the function is no longer used.
 *
 * @param func The packed C function.
 * @param resource_handle The resource handle from front-end, can be NULL.
 * @param fin The finalizer on resource handle when the FunctionHandle get freed, can be NULL
 * @param out the result function handle.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMFuncCreateFromCFunc(TVMPackedCFunc func, Pointer resource_handle,
                                   TVMPackedCFuncFinalizer fin, @ByPtrPtr TVMFunctionHandle out);

/**
 * \brief Register the function to runtime's global table.
 *
 * The registered function then can be pulled by the backend by the name.
 *
 * @param name The name of the function.
 * @param f The function to be registered.
 * @param override Whether allow override already registered function.
 */
public static native int TVMFuncRegisterGlobal(@Cast("const char*") BytePointer name, TVMFunctionHandle f, int override);
public static native int TVMFuncRegisterGlobal(String name, TVMFunctionHandle f, int override);

/**
 * \brief Get a global function.
 *
 * @param name The name of the function.
 * @param out the result function pointer, NULL if it does not exist.
 *
 * \note The function handle of global function is managed by TVM runtime,
 *  So TVMFuncFree is should not be called when it get deleted.
 */
public static native int TVMFuncGetGlobal(@Cast("const char*") BytePointer name, @ByPtrPtr TVMFunctionHandle out);
public static native int TVMFuncGetGlobal(String name, @ByPtrPtr TVMFunctionHandle out);

/**
 * \brief List all the globally registered function name
 * @param out_size The number of functions
 * @param out_array The array of function names.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMFuncListGlobalNames(IntPointer out_size, @Cast("const char***") @ByPtrPtr PointerPointer out_array);
public static native int TVMFuncListGlobalNames(IntBuffer out_size, @Cast("const char***") @ByPtrPtr PointerPointer out_array);
public static native int TVMFuncListGlobalNames(int[] out_size, @Cast("const char***") @ByPtrPtr PointerPointer out_array);

/**
 * \brief Remove a global function.
 * @param name The name of the function.
 */
public static native int TVMFuncRemoveGlobal(@Cast("const char*") BytePointer name);
public static native int TVMFuncRemoveGlobal(String name);

// Array related apis for quick proptyping
/**
 * \brief Allocate a nd-array's memory,
 *  including space of shape, of given spec.
 *
 * @param shape The shape of the array, the data content will be copied to out
 * @param ndim The number of dimension of the array.
 * @param dtype_code The type code of the dtype
 * @param dtype_bits The number of bits of dtype
 * @param dtype_lanes The number of lanes in the dtype.
 * @param device_type The device type.
 * @param device_id The device id.
 * @param out The output handle.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMArrayAlloc(@Cast("const tvm_index_t*") LongPointer shape, int ndim, int dtype_code, int dtype_bits,
                          int dtype_lanes, int device_type, int device_id, @Cast("TVMArrayHandle*") PointerPointer out);
public static native int TVMArrayAlloc(@Cast("const tvm_index_t*") LongBuffer shape, int ndim, int dtype_code, int dtype_bits,
                          int dtype_lanes, int device_type, int device_id, @ByPtrPtr @Cast("TVMArrayHandle*") DLTensor out);
public static native int TVMArrayAlloc(@Cast("const tvm_index_t*") long[] shape, int ndim, int dtype_code, int dtype_bits,
                          int dtype_lanes, int device_type, int device_id, @Cast("TVMArrayHandle*") PointerPointer out);
public static native int TVMArrayAlloc(@Cast("const tvm_index_t*") LongPointer shape, int ndim, int dtype_code, int dtype_bits,
                          int dtype_lanes, int device_type, int device_id, @ByPtrPtr @Cast("TVMArrayHandle*") DLTensor out);
public static native int TVMArrayAlloc(@Cast("const tvm_index_t*") LongBuffer shape, int ndim, int dtype_code, int dtype_bits,
                          int dtype_lanes, int device_type, int device_id, @Cast("TVMArrayHandle*") PointerPointer out);
public static native int TVMArrayAlloc(@Cast("const tvm_index_t*") long[] shape, int ndim, int dtype_code, int dtype_bits,
                          int dtype_lanes, int device_type, int device_id, @ByPtrPtr @Cast("TVMArrayHandle*") DLTensor out);

/**
 * \brief Free the TVM Array.
 * @param handle The array handle to be freed.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMArrayFree(@Cast("TVMArrayHandle") DLTensor handle);

/**
 * \brief Copy array data from CPU byte array.
 * @param handle The array handle.
 * @param data the data pointer
 * @param nbytes The number of bytes to copy.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMArrayCopyFromBytes(@Cast("TVMArrayHandle") DLTensor handle, Pointer data, @Cast("size_t") long nbytes);

/**
 * \brief Copy array data to CPU byte array.
 * @param handle The array handle.
 * @param data the data pointer
 * @param nbytes The number of bytes to copy.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMArrayCopyToBytes(@Cast("TVMArrayHandle") DLTensor handle, Pointer data, @Cast("size_t") long nbytes);

/**
 * \brief Copy the array, both from and to must be valid during the copy.
 * @param from The array to be copied from.
 * @param to The target space.
 * @param stream The stream where the copy happens, can be NULL.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMArrayCopyFromTo(@Cast("TVMArrayHandle") DLTensor from, @Cast("TVMArrayHandle") DLTensor to, TVMStreamHandle stream);

/**
 * \brief Produce an array from the DLManagedTensor that shares data memory
 * with the DLManagedTensor.
 * @param from The source DLManagedTensor.
 * @param out The output array handle.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMArrayFromDLPack(DLManagedTensor from, @Cast("TVMArrayHandle*") PointerPointer out);
public static native int TVMArrayFromDLPack(DLManagedTensor from, @ByPtrPtr @Cast("TVMArrayHandle*") DLTensor out);

/**
 * \brief Produce a DLMangedTensor from the array that shares data memory with
 * the array.
 * @param from The source array.
 * @param out The DLManagedTensor handle.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMArrayToDLPack(@Cast("TVMArrayHandle") DLTensor from, @Cast("DLManagedTensor**") PointerPointer out);
public static native int TVMArrayToDLPack(@Cast("TVMArrayHandle") DLTensor from, @ByPtrPtr DLManagedTensor out);

/**
 * \brief Delete (free) a DLManagedTensor's data.
 * @param dltensor Pointer to the DLManagedTensor.
 */
public static native void TVMDLManagedTensorCallDeleter(DLManagedTensor dltensor);

/**
 * \brief Create a new runtime stream.
 *
 * @param device_type The device type.
 * @param device_id The device id.
 * @param out The new stream handle.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMStreamCreate(int device_type, int device_id, @ByPtrPtr TVMStreamHandle out);

/**
 * \brief Free a created stream handle.
 *
 * @param device_type The device type.
 * @param device_id The device id.
 * @param stream The stream to be freed.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMStreamFree(int device_type, int device_id, TVMStreamHandle stream);

/**
 * \brief Set the runtime stream of current thread to be stream.
 *  The subsequent calls to the same device_type
 *  will use the setted stream handle.
 *  The specific type of stream is runtime device dependent.
 *
 * @param device_type The device type.
 * @param device_id The device id.
 * @param handle The stream handle.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMSetStream(int device_type, int device_id, TVMStreamHandle handle);

/**
 * \brief Wait until all computations on stream completes.
 *
 * @param device_type The device type.
 * @param device_id The device id.
 * @param stream The stream to be synchronized.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMSynchronize(int device_type, int device_id, TVMStreamHandle stream);

/**
 * \brief Synchronize two streams of execution.
 *
 * @param device_type The device type.
 * @param device_id The device id.
 * @param src The source stream to synchronize.
 * @param dst The destination stream to synchronize.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMStreamStreamSynchronize(int device_type, int device_id, TVMStreamHandle src,
                                       TVMStreamHandle dst);

/**
 * \brief Get the type_index from an object.
 *
 * @param obj The object handle.
 * @param out_tindex the output type index.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMObjectGetTypeIndex(TVMObjectHandle obj, @Cast("unsigned*") IntPointer out_tindex);
public static native int TVMObjectGetTypeIndex(TVMObjectHandle obj, @Cast("unsigned*") IntBuffer out_tindex);
public static native int TVMObjectGetTypeIndex(TVMObjectHandle obj, @Cast("unsigned*") int[] out_tindex);

/**
 * \brief Convert type key to type index.
 * @param type_key The key of the type.
 * @param out_tindex the corresponding type index.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMObjectTypeKey2Index(@Cast("const char*") BytePointer type_key, @Cast("unsigned*") IntPointer out_tindex);
public static native int TVMObjectTypeKey2Index(String type_key, @Cast("unsigned*") IntBuffer out_tindex);
public static native int TVMObjectTypeKey2Index(@Cast("const char*") BytePointer type_key, @Cast("unsigned*") int[] out_tindex);
public static native int TVMObjectTypeKey2Index(String type_key, @Cast("unsigned*") IntPointer out_tindex);
public static native int TVMObjectTypeKey2Index(@Cast("const char*") BytePointer type_key, @Cast("unsigned*") IntBuffer out_tindex);
public static native int TVMObjectTypeKey2Index(String type_key, @Cast("unsigned*") int[] out_tindex);

/**
 * \brief Convert type index to type key.
 * @param tindex The type index.
 * @param out_type_key The output type key.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMObjectTypeIndex2Key(@Cast("unsigned") int tindex, @Cast("char**") PointerPointer out_type_key);
public static native int TVMObjectTypeIndex2Key(@Cast("unsigned") int tindex, @Cast("char**") @ByPtrPtr BytePointer out_type_key);
public static native int TVMObjectTypeIndex2Key(@Cast("unsigned") int tindex, @Cast("char**") @ByPtrPtr ByteBuffer out_type_key);
public static native int TVMObjectTypeIndex2Key(@Cast("unsigned") int tindex, @Cast("char**") @ByPtrPtr byte[] out_type_key);

/**
 * \brief Increase the reference count of an object.
 *
 * @param obj The object handle.
 * \note Internally we increase the reference counter of the object.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMObjectRetain(TVMObjectHandle obj);

/**
 * \brief Free the object.
 *
 * @param obj The object handle.
 * \note Internally we decrease the reference counter of the object.
 *       The object will be freed when every reference to the object are removed.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMObjectFree(TVMObjectHandle obj);

/**
 * \brief Free a TVMByteArray returned from TVMFuncCall, and associated memory.
 * @param arr The TVMByteArray instance.
 * @return 0 on success, -1 on failure.
 */
public static native int TVMByteArrayFree(TVMByteArray arr);

/**
 * \brief Allocate a data space on device.
 * @param dev The device to perform operation.
 * @param nbytes The number of bytes in memory.
 * @param alignment The alignment of the memory.
 * @param type_hint The type of elements. Only needed by certain backends such
 *                   as nbytes & alignment are sufficient for most backends.
 * @param out_data The allocated device pointer.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMDeviceAllocDataSpace(@ByVal DLDevice dev, @Cast("size_t") long nbytes, @Cast("size_t") long alignment,
                                    @ByVal DLDataType type_hint, @Cast("void**") PointerPointer out_data);
public static native int TVMDeviceAllocDataSpace(@ByVal DLDevice dev, @Cast("size_t") long nbytes, @Cast("size_t") long alignment,
                                    @ByVal DLDataType type_hint, @Cast("void**") @ByPtrPtr Pointer out_data);

/**
 * \brief Allocate a data space on device with special memory scope.
 * \note The memory could use a special multi-dimensional memory layout.
 *       That is why we pass shape and dtype instead of raw number of bytes.
 * @param dev The device to perform operation.
 * @param ndim The number of dimension of the tensor.
 * @param shape The shape of the tensor.
 * @param dtype The type of elements.
 * @param mem_scope The memory scope of the tensor,
 *        can be nullptr, which indicate the default global DRAM
 * @param out_data The allocated device pointer.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMDeviceAllocDataSpaceWithScope(@ByVal DLDevice dev, int ndim, @Cast("const int64_t*") LongPointer shape,
                                             @ByVal DLDataType dtype, @Cast("const char*") BytePointer mem_scope,
                                             @Cast("void**") PointerPointer out_data);
public static native int TVMDeviceAllocDataSpaceWithScope(@ByVal DLDevice dev, int ndim, @Cast("const int64_t*") LongPointer shape,
                                             @ByVal DLDataType dtype, @Cast("const char*") BytePointer mem_scope,
                                             @Cast("void**") @ByPtrPtr Pointer out_data);
public static native int TVMDeviceAllocDataSpaceWithScope(@ByVal DLDevice dev, int ndim, @Cast("const int64_t*") LongBuffer shape,
                                             @ByVal DLDataType dtype, String mem_scope,
                                             @Cast("void**") @ByPtrPtr Pointer out_data);
public static native int TVMDeviceAllocDataSpaceWithScope(@ByVal DLDevice dev, int ndim, @Cast("const int64_t*") long[] shape,
                                             @ByVal DLDataType dtype, @Cast("const char*") BytePointer mem_scope,
                                             @Cast("void**") @ByPtrPtr Pointer out_data);
public static native int TVMDeviceAllocDataSpaceWithScope(@ByVal DLDevice dev, int ndim, @Cast("const int64_t*") LongPointer shape,
                                             @ByVal DLDataType dtype, String mem_scope,
                                             @Cast("void**") @ByPtrPtr Pointer out_data);
public static native int TVMDeviceAllocDataSpaceWithScope(@ByVal DLDevice dev, int ndim, @Cast("const int64_t*") LongBuffer shape,
                                             @ByVal DLDataType dtype, @Cast("const char*") BytePointer mem_scope,
                                             @Cast("void**") @ByPtrPtr Pointer out_data);
public static native int TVMDeviceAllocDataSpaceWithScope(@ByVal DLDevice dev, int ndim, @Cast("const int64_t*") long[] shape,
                                             @ByVal DLDataType dtype, String mem_scope,
                                             @Cast("void**") @ByPtrPtr Pointer out_data);

/**
 * \brief Free a data space on device.
 * @param dev The device to perform operation.
 * @param ptr The data space.
 * @return 0 when success, nonzero when failure happens
 */
public static native int TVMDeviceFreeDataSpace(@ByVal DLDevice dev, Pointer ptr);

/**
 * \brief Copy data from one place to another.
 * \note This API is designed to support special memory with shape dependent layout.
 *       We pass in DLTensor* with shape information to support these cases.
 * @param from The source tensor.
 * @param to The target tensor.
 * @param stream Optional stream object.
 * @return 0 when success, nonzero when failure happens.
 */
public static native int TVMDeviceCopyDataFromTo(DLTensor from, DLTensor to, TVMStreamHandle stream);

/**
 * \brief Check that an object is derived from another.
 * @param child_type_index The type index of the derived type.
 * @param parent_type_index The type index of the parent type.
 * @param is_derived A boolean representing whether this predicate holds.
 * @return 0 when success, nonzero when failure happens.
 */
public static native int TVMObjectDerivedFrom(@Cast("uint32_t") int child_type_index, @Cast("uint32_t") int parent_type_index,
                                 IntPointer is_derived);
public static native int TVMObjectDerivedFrom(@Cast("uint32_t") int child_type_index, @Cast("uint32_t") int parent_type_index,
                                 IntBuffer is_derived);
public static native int TVMObjectDerivedFrom(@Cast("uint32_t") int child_type_index, @Cast("uint32_t") int parent_type_index,
                                 int[] is_derived);

// #ifdef __cplusplus  // TVM_EXTERN_C
// #endif
// #endif  // TVM_RUNTIME_C_RUNTIME_API_H_


// Parsed from tvm/runtime/data_type.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/*
 * \file tvm/runtime/data_type.h
 * \brief Primitive runtime data type.
 */
// Acknowledgement: DataType structure design originates from Halide.
// #ifndef TVM_RUNTIME_DATA_TYPE_H_
// #define TVM_RUNTIME_DATA_TYPE_H_

// #include <tvm/runtime/c_runtime_api.h>
// #include <tvm/runtime/logging.h>

// #include <cstring>
// #include <string>
// #include <type_traits>
// Targeting ..\DataType.java



/**
 * \brief Get the number of bytes needed in a vector.
 * @param dtype The data type.
 * @return Number of bytes needed.
 */
@Namespace("tvm::runtime") public static native int GetVectorBytes(@ByVal DataType dtype);

/**
 * \brief Check whether type matches the given spec.
 * @param t The type
 * @param code The type code.
 * @param bits The number of bits to be matched.
 * @param lanes The number of lanes in the type.
 */
@Namespace("tvm::runtime") public static native @Cast("bool") boolean TypeMatch(@ByVal DLDataType t, int code, int bits, int lanes/*=1*/);
@Namespace("tvm::runtime") public static native @Cast("bool") boolean TypeMatch(@ByVal DLDataType t, int code, int bits);
/**
 * \brief Check whether two types are equal .
 * @param lhs The left operand.
 * @param rhs The right operand.
 */
@Namespace("tvm::runtime") public static native @Cast("bool") boolean TypeEqual(@ByVal DLDataType lhs, @ByVal DLDataType rhs);

/**
 * \brief Runtime utility for getting custom type name from code
 * @param type_code Custom type code
 * @return Custom type name
 */
@Namespace("tvm::runtime") public static native @StdString BytePointer GetCustomTypeName(@Cast("uint8_t") byte type_code);

/**
 * \brief Runtime utility for checking whether custom type is registered
 * @param type_code Custom type code
 * @return Bool representing whether type is registered
 */
@Namespace("tvm::runtime") public static native @Cast("bool") boolean GetCustomTypeRegistered(@Cast("uint8_t") byte type_code);

/**
 * \brief Runtime utility for parsing string of the form "custom[<typename>]"
 * @param s String to parse
 * @param scan pointer to parsing pointer, which is scanning across s
 * @return type code of custom type parsed
 */
@Namespace("tvm::runtime") public static native @Cast("uint8_t") byte ParseCustomDatatype(@StdString BytePointer s, @Cast("const char**") PointerPointer scan);
@Namespace("tvm::runtime") public static native @Cast("uint8_t") byte ParseCustomDatatype(@StdString BytePointer s, @Cast("const char**") @ByPtrPtr BytePointer scan);
@Namespace("tvm::runtime") public static native @Cast("uint8_t") byte ParseCustomDatatype(@StdString String s, @Cast("const char**") @ByPtrPtr ByteBuffer scan);
@Namespace("tvm::runtime") public static native @Cast("uint8_t") byte ParseCustomDatatype(@StdString BytePointer s, @Cast("const char**") @ByPtrPtr byte[] scan);
@Namespace("tvm::runtime") public static native @Cast("uint8_t") byte ParseCustomDatatype(@StdString String s, @Cast("const char**") @ByPtrPtr BytePointer scan);
@Namespace("tvm::runtime") public static native @Cast("uint8_t") byte ParseCustomDatatype(@StdString BytePointer s, @Cast("const char**") @ByPtrPtr ByteBuffer scan);
@Namespace("tvm::runtime") public static native @Cast("uint8_t") byte ParseCustomDatatype(@StdString String s, @Cast("const char**") @ByPtrPtr byte[] scan);

/**
 * \brief Convert type code to its name
 * @param type_code The type code .
 * @return The name of type code.
 */
@Namespace("tvm::runtime") public static native @Cast("const char*") BytePointer DLDataTypeCode2Str(@Cast("DLDataTypeCode") int type_code);

/**
 * \brief convert a string to TVM type.
 * @param s The string to be converted.
 * @return The corresponding tvm type.
 */
@Namespace("tvm::runtime") public static native @ByVal DLDataType String2DLDataType(@StdString BytePointer s);
@Namespace("tvm::runtime") public static native @ByVal DLDataType String2DLDataType(@StdString String s);

/**
 * \brief convert a TVM type to string.
 * @param t The type to be converted.
 * @return The corresponding tvm type in string.
 */
@Namespace("tvm::runtime") public static native @StdString BytePointer DLDataType2String(@ByVal DLDataType t);

// implementation details

@Namespace("tvm::runtime") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, @ByVal DLDataType t);

@Namespace("tvm::runtime") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, @Const @ByRef DataType dtype);

  // namespace runtime

  // namespace tvm
  // namespace std

// #endif  //  TVM_RUNTIME_DATA_TYPE_H_


// Parsed from tvm/runtime/object.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * \file tvm/runtime/object.h
 * \brief A managed object in the TVM runtime.
 */
// #ifndef TVM_RUNTIME_OBJECT_H_
// #define TVM_RUNTIME_OBJECT_H_

// #include <tvm/runtime/c_runtime_api.h>
// #include <tvm/runtime/logging.h>

// #include <string>
// #include <type_traits>
// #include <utility>

/**
 * \brief Whether or not use atomic reference counter.
 *  If the reference counter is not atomic,
 *  an object cannot be owned by multiple threads.
 *  We can, however, move an object across threads
 */
// #ifndef TVM_OBJECT_ATOMIC_REF_COUNTER
public static final int TVM_OBJECT_ATOMIC_REF_COUNTER = 1;
// #endif

// #if TVM_OBJECT_ATOMIC_REF_COUNTER
// #include <atomic>
// #endif  // TVM_OBJECT_ATOMIC_REF_COUNTER
// Targeting ..\TypeIndex.java


// Targeting ..\TVMObject.java



/**
 * \brief Get a reference type from a raw object ptr type
 *
 *  It is always important to get a reference type
 *  if we want to return a value as reference or keep
 *  the object alive beyond the scope of the function.
 *
 * @param ptr The object pointer
 * \tparam RefType The reference type
 * \tparam ObjectType The object type
 * @return The corresponding RefType
 */

/**
 * \brief Downcast a base reference type to a more specific type.
 *
 * @param ref The input reference
 * @return The corresponding SubRef.
 * \tparam SubRef The target specific reference type.
 * \tparam BaseRef the current reference type.
 */
// Targeting ..\ObjectPtr.java


// Targeting ..\ArrayNodePtr.java


// Targeting ..\MapNodePtr.java



// Forward declaration, to prevent circular includes.
// Targeting ..\ObjectRef.java



/**
 * \brief Get an object ptr type from a raw object ptr.
 *
 * @param ptr The object pointer
 * \tparam BaseType The reference type
 * \tparam ObjectType The object type
 * @return The corresponding RefType
 */
// Targeting ..\ObjectPtrHash.java


// Targeting ..\ObjectPtrEqual.java



/**
 * \brief helper macro to declare a base object type that can be inherited.
 * @param TypeName The name of the current type.
 * @param ParentType The name of the ParentType
 */
// #define TVM_DECLARE_BASE_OBJECT_INFO(TypeName, ParentType)
//   static_assert(!ParentType::_type_final, "ParentObj marked as final");
//   static uint32_t RuntimeTypeIndex() {
//     static_assert(TypeName::_type_child_slots == 0 || ParentType::_type_child_slots == 0 ||
//                       TypeName::_type_child_slots < ParentType::_type_child_slots,
//                   "Need to set _type_child_slots when parent specifies it.");
//     if (TypeName::_type_index != ::tvm::runtime::TypeIndex::kDynamic) {
//       return TypeName::_type_index;
//     }
//     return _GetOrAllocRuntimeTypeIndex();
//   }
//   static uint32_t _GetOrAllocRuntimeTypeIndex() {
//     static uint32_t tindex = Object::GetOrAllocRuntimeTypeIndex(
//         TypeName::_type_key, TypeName::_type_index, ParentType::_GetOrAllocRuntimeTypeIndex(),
//         TypeName::_type_child_slots, TypeName::_type_child_slots_can_overflow);
//     return tindex;
//   }

/**
 * \brief helper macro to declare type information in a final class.
 * @param TypeName The name of the current type.
 * @param ParentType The name of the ParentType
 */
// #define TVM_DECLARE_FINAL_OBJECT_INFO(TypeName, ParentType)
//   static const constexpr bool _type_final = true;
//   static const constexpr int _type_child_slots = 0;
//   TVM_DECLARE_BASE_OBJECT_INFO(TypeName, ParentType)

/** \brief helper macro to suppress unused warning */
// #if defined(__GNUC__)
// #define TVM_ATTRIBUTE_UNUSED __attribute__((unused))
// #else
// #define TVM_ATTRIBUTE_UNUSED
// #endif

// #define TVM_STR_CONCAT_(__x, __y) __x##__y
// #define TVM_STR_CONCAT(__x, __y) TVM_STR_CONCAT_(__x, __y)

// #define TVM_OBJECT_REG_VAR_DEF static TVM_ATTRIBUTE_UNUSED uint32_t __make_Object_tid

/**
 * \brief Helper macro to register the object type to runtime.
 *  Makes sure that the runtime type table is correctly populated.
 *
 *  Use this macro in the cc file for each terminal class.
 */
// #define TVM_REGISTER_OBJECT_TYPE(TypeName)
//   TVM_STR_CONCAT(TVM_OBJECT_REG_VAR_DEF, __COUNTER__) = TypeName::_GetOrAllocRuntimeTypeIndex()

/*
 * \brief Define the default copy/move constructor and assign operator
 * \param TypeName The class typename.
 */
// #define TVM_DEFINE_DEFAULT_COPY_MOVE_AND_ASSIGN(TypeName)
//   TypeName(const TypeName& other) = default;
//   TypeName(TypeName&& other) = default;
//   TypeName& operator=(const TypeName& other) = default;
//   TypeName& operator=(TypeName&& other) = default;

/*
 * \brief Define object reference methods.
 * \param TypeName The object type name
 * \param ParentType The parent type of the objectref
 * \param ObjectName The type name of the object.
 */
// #define TVM_DEFINE_OBJECT_REF_METHODS_WITHOUT_DEFAULT_CONSTRUCTOR(TypeName, ParentType,
//                                                                   ObjectName)
//   explicit TypeName(::tvm::runtime::ObjectPtr<::tvm::runtime::Object> n) : ParentType(n) {}
//   TVM_DEFINE_DEFAULT_COPY_MOVE_AND_ASSIGN(TypeName);
//   const ObjectName* operator->() const { return static_cast<const ObjectName*>(data_.get()); }
//   const ObjectName* get() const { return operator->(); }
//   using ContainerType = ObjectName;

/*
 * \brief Define object reference methods.
 * \param TypeName The object type name
 * \param ParentType The parent type of the objectref
 * \param ObjectName The type name of the object.
 */
// #define TVM_DEFINE_OBJECT_REF_METHODS(TypeName, ParentType, ObjectName)
//   TypeName() = default;
//   TVM_DEFINE_OBJECT_REF_METHODS_WITHOUT_DEFAULT_CONSTRUCTOR(TypeName, ParentType, ObjectName)

/*
 * \brief Define object reference methods that is not nullable.
 *
 * \param TypeName The object type name
 * \param ParentType The parent type of the objectref
 * \param ObjectName The type name of the object.
 */
// #define TVM_DEFINE_NOTNULLABLE_OBJECT_REF_METHODS(TypeName, ParentType, ObjectName)
//   explicit TypeName(::tvm::runtime::ObjectPtr<::tvm::runtime::Object> n) : ParentType(n) {}
//   TVM_DEFINE_DEFAULT_COPY_MOVE_AND_ASSIGN(TypeName);
//   const ObjectName* operator->() const { return static_cast<const ObjectName*>(data_.get()); }
//   const ObjectName* get() const { return operator->(); }
//   static constexpr bool _type_is_nullable = false;
//   using ContainerType = ObjectName;

/*
 * \brief Define object reference methods of whose content is mutable.
 * \param TypeName The object type name
 * \param ParentType The parent type of the objectref
 * \param ObjectName The type name of the object.
 * \note We recommend making objects immutable when possible.
 *       This macro is only reserved for objects that stores runtime states.
 */
// #define TVM_DEFINE_MUTABLE_OBJECT_REF_METHODS(TypeName, ParentType, ObjectName)
//   TypeName() = default;
//   TVM_DEFINE_DEFAULT_COPY_MOVE_AND_ASSIGN(TypeName);
//   explicit TypeName(::tvm::runtime::ObjectPtr<::tvm::runtime::Object> n) : ParentType(n) {}
//   ObjectName* operator->() const { return static_cast<ObjectName*>(data_.get()); }
//   using ContainerType = ObjectName;

/*
 * \brief Define object reference methods that is both not nullable and mutable.
 *
 * \param TypeName The object type name
 * \param ParentType The parent type of the objectref
 * \param ObjectName The type name of the object.
 */
// #define TVM_DEFINE_MUTABLE_NOTNULLABLE_OBJECT_REF_METHODS(TypeName, ParentType, ObjectName)
//   explicit TypeName(::tvm::runtime::ObjectPtr<::tvm::runtime::Object> n) : ParentType(n) {}
//   TVM_DEFINE_DEFAULT_COPY_MOVE_AND_ASSIGN(TypeName);
//   ObjectName* operator->() const { return static_cast<ObjectName*>(data_.get()); }
//   ObjectName* get() const { return operator->(); }
//   static constexpr bool _type_is_nullable = false;
//   using ContainerType = ObjectName;

/**
 * \brief Define CopyOnWrite function in an ObjectRef.
 * @param ObjectName The Type of the Node.
 *
 *  CopyOnWrite will generate a unique copy of the internal node.
 *  The node will be copied if it is referenced by multiple places.
 *  The function returns the raw pointer to the node to allow modification
 *  of the content.
 *
 * <pre>{@code
 *
 *  MyCOWObjectRef ref, ref2;
 *  ref2 = ref;
 *  ref.CopyOnWrite()->value = new_value;
 *  assert(ref2->value == old_value);
 *  assert(ref->value == new_value);
 *
 * }</pre>
 */
// #define TVM_DEFINE_OBJECT_REF_COW_METHOD(ObjectName)
//   static_assert(ObjectName::_type_final,
//                 "TVM's CopyOnWrite may only be used for "
//                 "Object types that are declared as final, "
//                 "using the TVM_DECLARE_FINAL_OBJECT_INFO macro.");
//   ObjectName* CopyOnWrite() {
//     ICHECK(data_ != nullptr);
//     if (!data_.nique()) {
//       auto n = make_object<ObjectName>(*(operator->()));
//       ObjectPtr<Object>(std::move(n)).swap(data_);
//     }
//     return static_cast<ObjectName*>(data_.get());
//   }

// Implementations details below
// Object reference counting.
// #if TVM_OBJECT_ATOMIC_REF_COUNTER







// #else

// #endif  // TVM_OBJECT_ATOMIC_REF_COUNTER







  // namespace runtime
  // namespace tvm

// #endif  // TVM_RUNTIME_OBJECT_H_


// Parsed from tvm/runtime/memory.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * \file tvm/runtime/memory.h
 * \brief Runtime memory management.
 */
// #ifndef TVM_RUNTIME_MEMORY_H_
// #define TVM_RUNTIME_MEMORY_H_

// #include <tvm/runtime/object.h>

// #include <cstdlib>
// #include <type_traits>
// #include <utility>
/**
 * \brief Allocate an object using default allocator.
 * @param args arguments to the constructor.
 * \tparam T the node type.
 * @return The ObjectPtr to the allocated object.
 */
@Namespace("tvm::runtime") public static native @ByVal @Name("make_object<tvm::runtime::ArrayNode>") ArrayNodePtr makeArrayNode();
// Targeting ..\SimpleObjAllocatorBase.java


// Targeting ..\SimpleObjAllocator.java



  // namespace runtime
  // namespace tvm
// #endif  // TVM_RUNTIME_MEMORY_H_


// Parsed from tvm/runtime/container/base.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * \file tvm/runtime/container/base.h
 * \brief Base utilities for common POD(plain old data) container types.
 */
// #ifndef TVM_RUNTIME_CONTAINER_BASE_H_
// #define TVM_RUNTIME_CONTAINER_BASE_H_

// #include <dmlc/logging.h>
// #include <tvm/runtime/logging.h>
// #include <tvm/runtime/memory.h>
// #include <tvm/runtime/object.h>

// #include <algorithm>
// #include <initializer_list>
// #include <utility>
// Targeting ..\ObjectHash.java


// Targeting ..\ObjectEqual.java


// Targeting ..\ADTObjBase.java


// Targeting ..\ArrayNodeBase.java


// Targeting ..\SmallMapNodeBase.java



/**
 * \brief iterator adapter that adapts TIter to return another type.
 * \tparam Converter a struct that contains converting function
 * \tparam TIter the content iterator type.
 */

/**
 * \brief iterator adapter that adapts TIter to return another type.
 * \tparam Converter a struct that contains converting function
 * \tparam TIter the content iterator type.
 */

  // namespace runtime

// expose the functions to the root namespace.
  // namespace tvm

// #endif  // TVM_RUNTIME_CONTAINER_BASE_H_


// Parsed from tvm/runtime/container/adt.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * \file tvm/runtime/container/adt.h
 * \brief Runtime ADT container types.
 */
// #ifndef TVM_RUNTIME_CONTAINER_ADT_H_
// #define TVM_RUNTIME_CONTAINER_ADT_H_

// #include <utility>
// #include <vector>

// #include "./base.h"
// Targeting ..\ADTObj.java


// Targeting ..\ADT.java


  // namespace runtime
  // namespace tvm
// #endif  // TVM_RUNTIME_CONTAINER_ADT_H_


// Parsed from tvm/runtime/container/array.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * \file tvm/runtime/container/array.h
 * \brief Runtime Array container types.
 */
// #ifndef TVM_RUNTIME_CONTAINER_ARRAY_H_
// #define TVM_RUNTIME_CONTAINER_ARRAY_H_

// #include <algorithm>
// #include <memory>
// #include <type_traits>
// #include <utility>
// #include <vector>

// #include "./base.h"
// #include "./optional.h"
// Targeting ..\ArrayNode.java



/** \brief Helper struct for type-checking
 *
 * is_valid_iterator<T,IterType>::value will be true if IterType can
 * be dereferenced into a type that can be stored in an Array<T>, and
 * false otherwise.
 */

/**
 * \brief Array, container representing a contiguous sequence of ObjectRefs.
 *
 *  Array implements in-place copy-on-write semantics.
 *
 * As in typical copy-on-write, a method which would typically mutate the array
 * instead opaquely copies the underlying container, and then acts on its copy.
 *
 * If the array has reference count equal to one, we directly update the
 * container in place without copying. This is optimization is sound because
 * when the reference count is equal to one this reference is guranteed to be
 * the sole pointer to the container.
 *
 *
 * operator[] only provides const access, use Set to mutate the content.
 * \tparam T The content ObjectRef type.
 */

/**
 * \brief Concat two Arrays.
 * @param lhs first Array to be concatenated.
 * @param rhs second Array to be concatenated.
 * @return The concatenated Array. Original Arrays are kept unchanged.
 */

// Specialize make_object<ArrayNode> to make sure it is correct.

  // namespace runtime

// expose the functions to the root namespace.
  // namespace tvm

// #endif  // TVM_RUNTIME_CONTAINER_ARRAY_H_


// Parsed from tvm/runtime/container/closure.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * \file tvm/runtime/container/closure.h
 * \brief Runtime Closure container types.
 */
// #ifndef TVM_RUNTIME_CONTAINER_CLOSURE_H_
// #define TVM_RUNTIME_CONTAINER_CLOSURE_H_

// #include "./base.h"
// Targeting ..\ClosureObj.java


// Targeting ..\Closure.java



  // namespace runtime
  // namespace tvm

// #endif  // TVM_RUNTIME_CONTAINER_CLOSURE_H_


// Parsed from tvm/runtime/container/optional.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * \file tvm/runtime/container/optional.h
 * \brief Runtime Optional container types.
 */
// #ifndef TVM_RUNTIME_CONTAINER_OPTIONAL_H_
// #define TVM_RUNTIME_CONTAINER_OPTIONAL_H_

// #include <utility>

// #include "./base.h"
// Targeting ..\NullOptType.java


// Targeting ..\TVMStringOptional.java





  // namespace runtime

// expose the functions to the root namespace.
@Namespace("tvm") @MemberGetter public static native @Const @ByRef NullOptType NullOpt();
  // namespace tvm

// #endif  // TVM_RUNTIME_CONTAINER_OPTIONAL_H_


// Parsed from tvm/runtime/container/map.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * \file tvm/runtime/container/map.h
 * \brief Runtime Map container types.
 */
// #ifndef TVM_RUNTIME_CONTAINER_MAP_H_
// #define TVM_RUNTIME_CONTAINER_MAP_H_

// #ifndef USE_FALLBACK_STL_MAP
public static final int USE_FALLBACK_STL_MAP = 0;
// #endif

// #include <algorithm>
// #include <unordered_map>
// #include <utility>

// #include "./base.h"
// #include "./optional.h"

// #if TVM_DEBUG_WITH_ABI_CHANGE
// #define TVM_MAP_FAIL_IF_CHANGED()
//   ICHECK(state_marker == self->state_marker) << "Concurrent modification of the Map";
// #else
// #define TVM_MAP_FAIL_IF_CHANGED()
// Targeting ..\MapNode.java



// #else

/** \brief Shared content of all specializations of hash map */
// Targeting ..\SmallMapNode.java


// Targeting ..\DenseMapNode.java



// #define TVM_DISPATCH_MAP(base, var, body)
//   {
//     using TSmall = SmallMapNode*;
//     using TDense = DenseMapNode*;
//     uint64_t slots = base->slots_;
//     if (slots <= SmallMapNode::kMaxSize) {
//       TSmall var = static_cast<TSmall>(base);
//       body;
//     } else {
//       TDense var = static_cast<TDense>(base);
//       body;
//     }
//   }

// #define TVM_DISPATCH_MAP_CONST(base, var, body)
//   {
//     using TSmall = const SmallMapNode*;
//     using TDense = const DenseMapNode*;
//     uint64_t slots = base->slots_;
//     if (slots <= SmallMapNode::kMaxSize) {
//       TSmall var = static_cast<TSmall>(base);
//       body;
//     } else {
//       TDense var = static_cast<TDense>(base);
//       body;
//     }
//   }





















// #undef TVM_DISPATCH_MAP
// #undef TVM_DISPATCH_MAP_CONST











// #endif

/**
 * \brief Map container of NodeRef->NodeRef in DSL graph.
 *  Map implements copy on write semantics, which means map is mutable
 *  but copy will happen when array is referenced in more than two places.
 *
 * operator[] only provide const acces, use Set to mutate the content.
 * \tparam K The key NodeRef type.
 * \tparam V The value NodeRef type.
 */

/**
 * \brief Merge two Maps.
 * @param lhs the first Map to merge.
 * @param rhs the second Map to merge.
 * @return The merged Array. Original Maps are kept unchanged.
 */

  // namespace runtime

// expose the functions to the root namespace.
  // namespace tvm

// #endif  // TVM_RUNTIME_CONTAINER_MAP_H_


// Parsed from tvm/runtime/container/shape_tuple.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * \file tvm/runtime/container/shape_tuple.h
 * \brief Runtime ShapeTuple container types.
 */
// #ifndef TVM_RUNTIME_CONTAINER_SHAPE_TUPLE_H_
// #define TVM_RUNTIME_CONTAINER_SHAPE_TUPLE_H_

// #include <ostream>
// #include <utility>
// #include <vector>

// #include "./base.h"
// Targeting ..\ShapeTupleObj.java



/** \brief An object representing shape tuple moved from std::vector. */
// Targeting ..\ShapeTuple.java







@Namespace("tvm::runtime") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, @Const @ByRef ShapeTuple shape);

  // namespace runtime

// expose the functions to the root namespace.
  // namespace tvm

// #endif  // TVM_RUNTIME_CONTAINER_SHAPE_TUPLE_H_


// Parsed from tvm/runtime/container/string.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * \file tvm/runtime/container/string.h
 * \brief Runtime String container types.
 */
// #ifndef TVM_RUNTIME_CONTAINER_STRING_H_
// #define TVM_RUNTIME_CONTAINER_STRING_H_

// #include <dmlc/endian.h>
// #include <dmlc/logging.h>
// #include <tvm/runtime/container/base.h>
// #include <tvm/runtime/logging.h>
// #include <tvm/runtime/memory.h>
// #include <tvm/runtime/object.h>

// #include <algorithm>
// #include <cstddef>
// #include <cstring>
// #include <initializer_list>
// #include <memory>
// #include <string>
// #include <string_view>
// #include <type_traits>
// #include <unordered_map>
// #include <utility>
// #include <vector>

// Forward declare TVMArgValue
// Targeting ..\StringObj.java


// Targeting ..\TVMString.java



/** \brief An object representing string moved from std::string. */







@Namespace("tvm::runtime") public static native @ByVal @Name("operator +") TVMString add(@Const @ByRef TVMString lhs, @Const @ByRef TVMString rhs);

@Namespace("tvm::runtime") public static native @ByVal @Name("operator +") TVMString add(@Const @ByRef TVMString lhs, @StdString BytePointer rhs);
@Namespace("tvm::runtime") public static native @ByVal @Name("operator +") TVMString add(@Const @ByRef TVMString lhs, @StdString String rhs);

@Namespace("tvm::runtime") public static native @ByVal @Name("operator +") TVMString add(@StdString BytePointer lhs, @Const @ByRef TVMString rhs);
@Namespace("tvm::runtime") public static native @ByVal @Name("operator +") TVMString add(@StdString String lhs, @Const @ByRef TVMString rhs);

// Overload < operator
@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator <") boolean lessThan(@Const @ByRef TVMString lhs, @StdString BytePointer rhs);
@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator <") boolean lessThan(@Const @ByRef TVMString lhs, @StdString String rhs);

@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator <") boolean lessThan(@StdString BytePointer lhs, @Const @ByRef TVMString rhs);
@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator <") boolean lessThan(@StdString String lhs, @Const @ByRef TVMString rhs);

@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator <") boolean lessThan(@Const @ByRef TVMString lhs, @Const @ByRef TVMString rhs);

// Overload > operator
@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator >") boolean greaterThan(@Const @ByRef TVMString lhs, @StdString BytePointer rhs);
@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator >") boolean greaterThan(@Const @ByRef TVMString lhs, @StdString String rhs);

@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator >") boolean greaterThan(@StdString BytePointer lhs, @Const @ByRef TVMString rhs);
@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator >") boolean greaterThan(@StdString String lhs, @Const @ByRef TVMString rhs);

@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator >") boolean greaterThan(@Const @ByRef TVMString lhs, @Const @ByRef TVMString rhs);

// Overload <= operator
@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator <=") boolean lessThanEquals(@Const @ByRef TVMString lhs, @StdString BytePointer rhs);
@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator <=") boolean lessThanEquals(@Const @ByRef TVMString lhs, @StdString String rhs);

@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator <=") boolean lessThanEquals(@StdString BytePointer lhs, @Const @ByRef TVMString rhs);
@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator <=") boolean lessThanEquals(@StdString String lhs, @Const @ByRef TVMString rhs);

@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator <=") boolean lessThanEquals(@Const @ByRef TVMString lhs, @Const @ByRef TVMString rhs);

// Overload >= operator
@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator >=") boolean greaterThanEquals(@Const @ByRef TVMString lhs, @StdString BytePointer rhs);
@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator >=") boolean greaterThanEquals(@Const @ByRef TVMString lhs, @StdString String rhs);

@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator >=") boolean greaterThanEquals(@StdString BytePointer lhs, @Const @ByRef TVMString rhs);
@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator >=") boolean greaterThanEquals(@StdString String lhs, @Const @ByRef TVMString rhs);

@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator >=") boolean greaterThanEquals(@Const @ByRef TVMString lhs, @Const @ByRef TVMString rhs);

// Overload == operator
@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef TVMString lhs, @StdString BytePointer rhs);
@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef TVMString lhs, @StdString String rhs);

@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator ==") boolean equals(@StdString BytePointer lhs, @Const @ByRef TVMString rhs);
@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator ==") boolean equals(@StdString String lhs, @Const @ByRef TVMString rhs);

@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef TVMString lhs, @Const @ByRef TVMString rhs);

// Overload != operator
@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator !=") boolean notEquals(@Const @ByRef TVMString lhs, @StdString BytePointer rhs);
@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator !=") boolean notEquals(@Const @ByRef TVMString lhs, @StdString String rhs);

@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator !=") boolean notEquals(@StdString BytePointer lhs, @Const @ByRef TVMString rhs);
@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator !=") boolean notEquals(@StdString String lhs, @Const @ByRef TVMString rhs);

@Namespace("tvm::runtime") public static native @Cast("bool") @Name("operator !=") boolean notEquals(@Const @ByRef TVMString lhs, @Const @ByRef TVMString rhs);

@Namespace("tvm::runtime") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer out, @Const @ByRef TVMString input);






  // namespace runtime

// expose the functions to the root namespace.
  // namespace tvm
  // namespace std

// #endif  // TVM_RUNTIME_CONTAINER_STRING_H_


// Parsed from tvm/runtime/ndarray.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * \file tvm/runtime/ndarray.h
 * \brief A device-independent managed NDArray abstraction.
 */
// #ifndef TVM_RUNTIME_NDARRAY_H_
// #define TVM_RUNTIME_NDARRAY_H_

// #include <tvm/runtime/c_runtime_api.h>
// #include <tvm/runtime/container/optional.h>
// #include <tvm/runtime/container/shape_tuple.h>
// #include <tvm/runtime/container/string.h>
// #include <tvm/runtime/data_type.h>
// #include <tvm/runtime/object.h>
// #include <tvm/runtime/serializer.h>

// #include <atomic>
// #include <functional>
// #include <utility>
// #include <vector>

// alias DLDevice
// Targeting ..\NDArray.java



/**
 * \brief Save a DLTensor to stream
 * @param strm The output stream
 * @param tensor The tensor to be saved.
 */
@Namespace("tvm::runtime") public static native @Cast("bool") boolean SaveDLTensor(Stream strm, @Const DLTensor tensor);
// Targeting ..\ContainerBase.java


// Targeting ..\Container.java



// implementations of inline functions
/**
 * \brief return the size of data the DLTensor hold, in term of number of bytes
 *
 *  @param arr the input DLTensor
 *  @return number of  bytes of data in the DLTensor.
 */
@Namespace("tvm::runtime") public static native @Cast("size_t") long GetDataSize(@Const @ByRef DLTensor arr);

/**
 * \brief check if a DLTensor is contiguous.
 * @param arr The input DLTensor.
 * @return The check result.
 */
@Namespace("tvm::runtime") public static native @Cast("bool") boolean IsContiguous(@Const @ByRef DLTensor arr);























@Namespace("tvm::runtime") public static native TVMObject TVMArrayHandleToObjectHandle(@Cast("TVMArrayHandle") DLTensor handle);

/** \brief Magic number for NDArray file */
@Namespace("tvm::runtime") @MemberGetter public static native @Cast("const uint64_t") long kTVMNDArrayMagic();





/**
 * \brief Get the preferred host device from the input device.
 * - For CUDA and ROCm, CUDAHost and ROCMHost will be returned for pinned memory,
 * since pinned memory reduces copy overhead.
 * - For other devices, CPU is returned as a fallback.
 */
@Namespace("tvm::runtime") public static native @ByVal @Cast("tvm::Device*") DLDevice GetPreferredHostDevice(@ByVal @Cast("tvm::Device*") DLDevice device);

  // namespace runtime
  // namespace tvm
  // namespace std

// #endif  // TVM_RUNTIME_NDARRAY_H_


// Parsed from tvm/runtime/serializer.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * \file tvm/runtime/serializer.h
 * \brief Serializer extension to support TVM data types
 *  Include this file to enable serialization of DLDataType, DLDevice
 */
// #ifndef TVM_RUNTIME_SERIALIZER_H_
// #define TVM_RUNTIME_SERIALIZER_H_

// #include <dmlc/io.h>
// #include <dmlc/serializer.h>
// #include <tvm/runtime/c_runtime_api.h>
// #include <tvm/runtime/ndarray.h>

  // namespace serializer
  // namespace dmlc
// #endif  // TVM_RUNTIME_SERIALIZER_H_


// Parsed from tvm/runtime/module.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * \file tvm/runtime/module.h
 * \brief Runtime container of the functions generated by TVM,
 *  This is used to support dynamically link, load and save
 *  functions from different convention under unified API.
 */
// #ifndef TVM_RUNTIME_MODULE_H_
// #define TVM_RUNTIME_MODULE_H_

// #include <dmlc/io.h>
// #include <tvm/runtime/c_runtime_api.h>
// #include <tvm/runtime/container/string.h>
// #include <tvm/runtime/memory.h>
// #include <tvm/runtime/object.h>

// #include <memory>
// #include <mutex>
// #include <string>
// #include <unordered_map>
// #include <vector>

/**
 * \brief Property of runtime module
 * We classify the property of runtime module into the following categories.
 */
/** enum tvm::runtime::ModulePropertyMask */
public static final int
  /** \brief kBinarySerializable
   *  we can serialize the module to the stream of bytes. CUDA/OpenCL/JSON
   * runtime are representative examples. A binary exportable module can be integrated into final
   * runtime artifact by being serialized as data into the artifact, then deserialized at runtime.
   * This class of modules must implement SaveToBinary, and have a matching deserializer registered
   * as 'runtime.module.loadbinary_<type_key>'.
   */
  kBinarySerializable = 0b001,
  /** \brief kRunnable
   * we can run the module directly. LLVM/CUDA/JSON runtime, executors (e.g,
   * virtual machine) runtimes are runnable. Non-runnable modules, such as CSourceModule, requires a
   * few extra steps (e.g,. compilation, link) to make it runnable.
   */
  kRunnable = 0b010,
  /** \brief kDSOExportable
   * we can export the module as DSO. A DSO exportable module (e.g., a
   * CSourceModuleNode of type_key 'c') can be incorporated into the final runtime artifact (ie
   * shared library) by compilation and/or linking using the external compiler (llvm, nvcc, etc).
   * DSO exportable modules must implement SaveToFile. In general, DSO exportable modules are not
   * runnable unless there is a special support like JIT for {@code LLVMModule}.
   */
  kDSOExportable = 0b100;
// Targeting ..\Module.java


// Targeting ..\ModuleNode.java



/**
 * \brief Check if runtime module is enabled for target.
 * @param target The target module name.
 * @return Whether runtime is enabled.
 */
@Namespace("tvm::runtime") public static native @Cast("bool") boolean RuntimeEnabled(@Const @ByRef TVMString target);

/** \brief namespace for constant symbols */
/** \brief A PackedFunc that retrieves exported metadata. */
@Namespace("tvm::runtime::symbol") @MemberGetter public static native @Cast("const char*") BytePointer tvm_get_c_metadata();
/** \brief Global variable to store module context. */
@Namespace("tvm::runtime::symbol") @MemberGetter public static native @Cast("const char*") BytePointer tvm_module_ctx();
/** \brief Global variable to store device module blob */
@Namespace("tvm::runtime::symbol") @MemberGetter public static native @Cast("const char*") BytePointer tvm_dev_mblob();
/** \brief global function to set device */
@Namespace("tvm::runtime::symbol") @MemberGetter public static native @Cast("const char*") BytePointer tvm_set_device();
/** \brief Auxiliary counter to global barrier. */
@Namespace("tvm::runtime::symbol") @MemberGetter public static native @Cast("const char*") BytePointer tvm_global_barrier_state();
/** \brief Prepare the global barrier before kernels that uses global barrier. */
@Namespace("tvm::runtime::symbol") @MemberGetter public static native @Cast("const char*") BytePointer tvm_prepare_global_barrier();
/** \brief Placeholder for the module's entry function. */
@Namespace("tvm::runtime::symbol") @MemberGetter public static native @Cast("const char*") BytePointer tvm_module_main();
/** \brief Prefix for parameter symbols emitted into the main program. */
@Namespace("tvm::runtime::symbol") @MemberGetter public static native @Cast("const char*") BytePointer tvm_param_prefix();
/** \brief A PackedFunc that looks up linked parameters by storage_id. */
@Namespace("tvm::runtime::symbol") @MemberGetter public static native @Cast("const char*") BytePointer tvm_lookup_linked_param();
/** \brief Model entrypoint generated as an interface to the AOT function outside of TIR */
@Namespace("tvm::runtime::symbol") @MemberGetter public static native @Cast("const char*") BytePointer tvm_entrypoint_suffix();
  // namespace symbol

// implementations of inline functions.







@Namespace("tvm::runtime") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer out, @Const @ByRef Module module);

  // namespace runtime
  // namespace tvm

// #include <tvm/runtime/packed_func.h>  // NOLINT(*)
// #endif                                // TVM_RUNTIME_MODULE_H_


// Parsed from tvm/runtime/packed_func.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * \file tvm/runtime/packed_func.h
 * \brief Type-erased function used across TVM API.
 */
// #ifndef TVM_RUNTIME_PACKED_FUNC_H_
// #define TVM_RUNTIME_PACKED_FUNC_H_

// #include <tvm/runtime/c_runtime_api.h>
// #include <tvm/runtime/container/array.h>
// #include <tvm/runtime/container/boxed_primitive.h>
// #include <tvm/runtime/container/map.h>
// #include <tvm/runtime/container/variant.h>
// #include <tvm/runtime/data_type.h>
// #include <tvm/runtime/logging.h>
// #include <tvm/runtime/module.h>
// #include <tvm/runtime/ndarray.h>
// #include <tvm/runtime/object.h>

// #include <functional>
// #include <limits>
// #include <memory>
// #include <optional>
// #include <string>
// #include <tuple>
// #include <type_traits>
// #include <utility>
// #include <vector>

// Whether use TVM runtime in header only mode.
// #ifndef TVM_RUNTIME_HEADER_ONLY
public static final int TVM_RUNTIME_HEADER_ONLY = 0;
// #endif

// forward declarations
// Targeting ..\PackedFuncObj.java



/** \brief Derived object class for constructing PackedFuncObj. */
// Targeting ..\PackedFunc.java


// Targeting ..\FSig.java



/**
 * \brief Please refer to \ref TypedPackedFuncAnchor "TypedPackedFunc<R(Args..)>"
 */

/**
 * \anchor TypedPackedFuncAnchor
 * \brief A PackedFunc wrapper to provide typed function signature.
 * It is backed by a PackedFunc internally.
 *
 * TypedPackedFunc enables compile time type checking.
 * TypedPackedFunc works with the runtime system:
 * - It can be passed as an argument of PackedFunc.
 * - It can be assigned to TVMRetValue.
 * - It can be directly converted to a type-erased PackedFunc.
 *
 * Developers should prefer TypedPackedFunc over PackedFunc in C++ code
 * as it enables compile time checking.
 * We can construct a TypedPackedFunc from a lambda function
 * with the same signature.
 *
 * <pre>{@code
 *  // user defined lambda function.
 *  auto addone = [](int x)->int {
 *    return x + 1;
 *  };
 *  // We can directly convert
 *  // lambda function to TypedPackedFunc
 *  TypedPackedFunc<int(int)> ftyped(addone);
 *  // invoke the function.
 *  int y = ftyped(1);
 *  // Can be directly converted to PackedFunc
 *  PackedFunc packed = ftype;
 * }</pre>
 * \tparam R The return value of the function.
 * \tparam Args The argument signature of the function.
 */
// Targeting ..\TVMArgs.java



/**
 * \brief Convert argument type code to string.
 * @param type_code The input type code.
 * @return The corresponding string repr.
 */
@Namespace("tvm::runtime") public static native @Cast("const char*") BytePointer ArgTypeCode2Str(int type_code);

  // NOLINT(*)

// #define TVM_LOG_INCORRECT_TYPE_CODE(CODE, T)
//   "expected " << ArgTypeCode2Str(T) << " but got " << ArgTypeCode2Str(CODE)

// macro to check type code.
// #define TVM_CHECK_TYPE_CODE(CODE, T) ICHECK_EQ(CODE, T) << TVM_LOG_INCORRECT_TYPE_CODE(CODE, T)

/**
 * \brief Type traits for runtime type check during FFI conversion.
 * \tparam T the type to be checked.
 */

// Additional overloads for PackedFunc checking.
// Targeting ..\TVMPODValue_.java


// Targeting ..\TVMPODArgValue.java


// Targeting ..\TVMPODMovableArgValue_.java


// Targeting ..\TVMPODRetValue.java


// Targeting ..\TVMArgValue.java


// Targeting ..\TVMMovableArgValue_.java



/**
 * \brief Internal auxiliary struct for TypedPackedFunc to indicate a movable argument with
 * additional context information (function name and argument index) for better error reporting.
 *
 * @see MovableArgValue_
 * \note For internal development purpose only.
 */
// Targeting ..\TVMRetValue.java



/**
 * \brief Type trait to specify special value conversion rules from
 *        TVMArgValue and TVMRetValue.
 *
 *  The trait can be specialized to add type specific conversion logic
 *  from the TVMArgvalue and TVMRetValue.
 *
 * \tparam TObjectRef the specific ObjectRefType.
 */

/**
 * \brief Export a function with the PackedFunc signature
 *        as a PackedFunc that can be loaded by LibraryModule.
 *
 * @param ExportName The symbol name to be exported.
 * @param Function The function with PackedFunc signature.
 * @see PackedFunc
 *
 * <pre>{@code
 *
 * void AddOne_(TVMArgs args, TVMRetValue* rv) {
 *   int value = args[0];
 *   *rv = value + 1;
 * }
 * // Expose the function as "AddOne"
 * TVM_DLL_EXPORT_PACKED_FUNC(AddOne, AddOne_);
 *
 * }</pre>
 */
// #define TVM_DLL_EXPORT_PACKED_FUNC(ExportName, Function)
//   extern "C" {
//   TVM_DLL int ExportName(TVMValue* args, int* type_code, int num_args, TVMValue* out_value,
//                          int* out_type_code, void* resource_handle);
//   int ExportName(TVMValue* args, int* type_code, int num_args, TVMValue* out_value,
//                  int* out_type_code, void* resource_handle) {
//     try {
//       ::tvm::runtime::TVMRetValue rv;
//       Function(::tvm::runtime::TVMArgs(args, type_code, num_args), &rv);
//       rv.MoveToCHost(out_value, out_type_code);
//       return 0;
//     } catch (const ::std::exception& _except_) {
//       TVMAPISetLastError(_except_.what());
//       return -1;
//     }
//   }
//   }

// #define TVM_MODULE_VTABLE_BEGIN(TypeKey)
//   const char* type_key() const final { return TypeKey; }
//   PackedFunc GetFunction(const String& _name, const ObjectPtr<Object>& _self) override {
//     using SelfPtr = std::remove_cv_t<decltype(this)>;
// #define TVM_MODULE_VTABLE_END()
//   return PackedFunc(nullptr);
//   }
// #define TVM_MODULE_VTABLE_END_WITH_DEFAULT(MemFunc)
//   {
//     auto f = (MemFunc);
//     return (this->*f)(_name);
//   }
//   }  // NOLINT(*)
// #define TVM_MODULE_VTABLE_ENTRY(Name, MemFunc)
//   if (_name == Name) {
//     return PackedFunc([_self](TVMArgs args, TVMRetValue* rv) -> void {
//       using Helper = ::tvm::runtime::detail::ModuleVTableEntryHelper<decltype(MemFunc)>;
//       SelfPtr self = static_cast<SelfPtr>(_self.get());
//       CHECK_EQ(args.size(), Helper::LenArgs)
//           << "Function `" << self->type_key() << "::" << Name << "` requires " << Helper::LenArgs
//           << " arguments, but got " << args.size();
//       Helper::Call(rv, self, MemFunc, args, Helper::IndexSeq{});
//     });
//   }
// #define TVM_MODULE_VTABLE_ENTRY_PACKED(Name, MemFunc)
//   if (_name == Name) {
//     return PackedFunc([_self](TVMArgs args, TVMRetValue* rv) -> void {
//       (static_cast<SelfPtr>(_self.get())->*(MemFunc))(args, rv);
//     });
//   }

/**
 * \brief Export typed function as a PackedFunc
 *        that can be loaded by LibraryModule.
 *
 * @param ExportName The symbol name to be exported.
 * @param Function The typed function.
 * \note ExportName and Function must be different,
 *       see code examples below.
 *
 * @see TypedPackedFunc
 *
 * <pre>{@code
 *
 * int AddOne_(int x) {
 *   return x + 1;
 * }
 *
 * // Expose the function as "AddOne"
 * TVM_DLL_EXPORT_TYPED_FUNC(AddOne, AddOne_);
 *
 * // Expose the function as "SubOne"
 * TVM_DLL_EXPORT_TYPED_FUNC(SubOne, [](int x) {
 *   return x - 1;
 * });
 *
 * // The following code will cause compilation error.
 * // Because the same Function and ExportName
 * // TVM_DLL_EXPORT_TYPED_FUNC(AddOne_, AddOne_);
 *
 * // The following code is OK, assuming the macro
 * // is in a different namespace from xyz
 * // TVM_DLL_EXPORT_TYPED_FUNC(AddOne_, xyz::AddOne_);
 *
 * }</pre>
 */
// #define TVM_DLL_EXPORT_TYPED_FUNC(ExportName, Function)
//   extern "C" {
//   TVM_DLL int ExportName(TVMValue* args, int* type_code, int num_args, TVMValue* out_value,
//                          int* out_type_code, void* resource_handle) {
//     try {
//       auto f = Function;
//       using FType = ::tvm::runtime::detail::function_signature<decltype(f)>::FType;
//       ::tvm::runtime::TVMRetValue rv;
//       ::tvm::runtime::detail::unpack_call_by_signature<FType>::run(
//           f, ::tvm::runtime::TVMArgs(args, type_code, num_args), &rv);
//       rv.MoveToCHost(out_value, out_type_code);
//       return 0;
//     } catch (const ::std::exception& _except_) {
//       TVMAPISetLastError(_except_.what());
//       return -1;
//     }
//   }
//   }











// internal namespace

/**
 * \brief The name of DLDeviceType.
 * @param type The device type.
 * @return the device name.
 */
@Namespace("tvm::runtime") public static native @Cast("const char*") BytePointer DLDeviceType2Str(int type);

  // namespace parameter_pack

/**
 * \brief Template class to get function signature of a function or functor.
 * \tparam T The function/functor type.
 */

/**
 * \brief Template class to get function signature of a function or functor.
 * \tparam T The function/functor type.
 */

// handle case of function.

// handle case of function ptr.

/**
 * \brief Template class to remove const, pointer and reference of original type.
 * \tparam T The original type.
 */

  // namespace type2str

/**
 * \brief Template class to generate static function outputting signature of a function or functor.
 * \tparam TSignature The function/functor signature type generated by {@code function_signature}.
 */

// Targeting ..\TVMArgsSetter.java




  // namespace detail

















// ObjectRef related conversion handling
// Object can have three possible type codes:
//      kTVMNDArrayHandle, kTVMModuleHandle, kTVMObjectHandle
//
// We use type traits to eliminate un-necessary checks.
















// specializations of PackedFuncValueConverter







  // namespace runtime // NOLINT(*)
  // namespace tvm // NOLINT(*)
// #endif  // TVM_RUNTIME_PACKED_FUNC_H_


// Parsed from tvm/runtime/registry.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * \file tvm/runtime/registry.h
 * \brief This file defines the TVM global function registry.
 *
 *  The registered functions will be made available to front-end
 *  as well as backend users.
 *
 *  The registry stores type-erased functions.
 *  Each registered function is automatically exposed
 *  to front-end language(e.g. python).
 *
 *  Front-end can also pass callbacks as PackedFunc, or register
 *  then into the same global registry in C++.
 *  The goal is to mix the front-end language and the TVM back-end.
 *
 * <pre>{@code
 *   // register the function as MyAPIFuncName
 *   TVM_REGISTER_GLOBAL(MyAPIFuncName)
 *   .set_body([](TVMArgs args, TVMRetValue* rv) {
 *     // my code.
 *   });
 * }</pre>
 */
// #ifndef TVM_RUNTIME_REGISTRY_H_
// #define TVM_RUNTIME_REGISTRY_H_

// #include <tvm/runtime/container/string.h>
// #include <tvm/runtime/packed_func.h>

// #include <type_traits>
// #include <utility>
// #include <vector>

/**
 * \brief Check if signals have been sent to the process and if so
 *  invoke the registered signal handler in the frontend environment.
 *
 *  When running TVM in another language (Python), the signal handler
 *  may not be immediately executed, but instead the signal is marked
 *  in the interpreter state (to ensure non-blocking of the signal handler).
 *
 *  This function can be explicitly invoked to check the cached signal
 *  and run the related processing if a signal is marked.
 *
 *  On Linux, when siginterrupt() is set, invoke this function whenever a syscall returns EINTR.
 *  When it is not set, invoke it between long-running syscalls when you will not immediately
 *  return to the frontend. On Windows, the same rules apply, but due to differences in signal
 *  processing, these are likely to only make a difference when used with Ctrl+C and socket calls.
 *
 *  Not inserting this function will not cause any correctness
 *  issue, but will delay invoking the Python-side signal handler until the function returns to
 *  the Python side. This means that the effect of e.g. pressing Ctrl+C or sending signals the
 *  process will be delayed until function return. When a C function is blocked on a syscall
 *  such as accept(), it needs to be called when EINTR is received.
 *  So this function is not needed in most API functions, which can finish quickly in a
 *  reasonable, deterministic amount of time.
 *
 * <pre>{@code
 *
 * int check_signal_every_k_iter = 10;
 *
 * for (int iter = 0; iter < very_large_number; ++iter) {
 *   if (iter % check_signal_every_k_iter == 0) {
 *     tvm::runtime::EnvCheckSignals();
 *   }
 *   // do work here
 * }
 *
 * }</pre>
 *
 * \note This function is a nop when no PyErr_CheckSignals is registered.
 *
 * @throws This function throws an exception when the frontend signal handler
 *         indicate an error happens, otherwise it returns normally.
 */
@Namespace("tvm::runtime") public static native void EnvCheckSignals();

/** \brief A class that wraps a Python object and preserves its ownership.
 <p>
 * This class is used to wrap a PyObject* from the Python API and preserve its ownership.
 * Allows for the creation of strong references to Python objects, which prevent them from being
 * garbage-collected as long as the wrapper object exists.
 */
// Targeting ..\Registry.java



// #define TVM_FUNC_REG_VAR_DEF static TVM_ATTRIBUTE_UNUSED ::tvm::runtime::Registry& __mk_##TVM

/**
 * \brief Register a function globally.
 * <pre>{@code
 *   TVM_REGISTER_GLOBAL("MyPrint")
 *   .set_body([](TVMArgs args, TVMRetValue* rv) {
 *   });
 * }</pre>
 */
// #define TVM_REGISTER_GLOBAL(OpName)
//   TVM_STR_CONCAT(TVM_FUNC_REG_VAR_DEF, __COUNTER__) = ::tvm::runtime::Registry::Register(OpName)

// #define TVM_STRINGIZE_DETAIL(x) #x
// #define TVM_STRINGIZE(x) TVM_STRINGIZE_DETAIL(x)
// #define TVM_DESCRIBE(...) describe(__VA_ARGS__ "\n\nFrom:" __FILE__ ":" TVM_STRINGIZE(__LINE__))
/**
 * \brief Macro to include current line as string
 */
// #define TVM_ADD_FILELINE "\n\nDefined in " __FILE__ ":L" TVM_STRINGIZE(__LINE__)

  // namespace runtime
  // namespace tvm
// #endif  // TVM_RUNTIME_REGISTRY_H_


}
