/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tvm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tvm.ArgTypeCode;
import org.apache.tvm.Base;
import org.apache.tvm.Module;
import org.apache.tvm.NDArrayBase;
import org.apache.tvm.TVMValue;

public class Function
extends TVMValue {
    final long handle;
    public final boolean isResident;
    private boolean isReleased = false;

    public static Function getFunction(String name) {
        for (String fullName : Function.listGlobalFuncNames()) {
            if (!fullName.equals(name)) continue;
            return Function.getGlobalFunc(fullName, true, false);
        }
        return null;
    }

    private static List<String> listGlobalFuncNames() {
        ArrayList<String> names = new ArrayList<String>();
        Base.checkCall(Base._LIB.tvmFuncListGlobalNames(names));
        return Collections.unmodifiableList(names);
    }

    private static Function getGlobalFunc(String name, boolean isResident, boolean allowMissing) {
        Base.RefLong handle = new Base.RefLong();
        Base.checkCall(Base._LIB.tvmFuncGetGlobal(name, handle));
        if (handle.value != 0L) {
            return new Function(handle.value, isResident);
        }
        if (allowMissing) {
            return null;
        }
        throw new IllegalArgumentException("Cannot find global function " + name);
    }

    Function(long handle, boolean isResident) {
        super(ArgTypeCode.FUNC_HANDLE);
        this.handle = handle;
        this.isResident = isResident;
    }

    Function(long handle) {
        this(handle, false);
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    @Override
    public Function asFunction() {
        return this;
    }

    @Override
    long asHandle() {
        return this.handle;
    }

    @Override
    public void release() {
        if (!this.isReleased && !this.isResident) {
            Base.checkCall(Base._LIB.tvmFuncFree(this.handle));
            this.isReleased = true;
        }
    }

    public TVMValue invoke() {
        Base.RefTVMValue ret = new Base.RefTVMValue();
        Base.checkCall(Base._LIB.tvmFuncCall(this.handle, ret));
        return ret.value;
    }

    public Function pushArg(int arg) {
        Base._LIB.tvmFuncPushArgLong(arg);
        return this;
    }

    public Function pushArg(long arg) {
        Base._LIB.tvmFuncPushArgLong(arg);
        return this;
    }

    public Function pushArg(float arg) {
        Base._LIB.tvmFuncPushArgDouble(arg);
        return this;
    }

    public Function pushArg(double arg) {
        Base._LIB.tvmFuncPushArgDouble(arg);
        return this;
    }

    public Function pushArg(String arg) {
        Base._LIB.tvmFuncPushArgString(arg);
        return this;
    }

    public Function pushArg(NDArrayBase arg) {
        int id = arg.isView ? ArgTypeCode.ARRAY_HANDLE.id : ArgTypeCode.NDARRAY_CONTAINER.id;
        Base._LIB.tvmFuncPushArgHandle(arg.handle, id);
        return this;
    }

    public Function pushArg(Module arg) {
        Base._LIB.tvmFuncPushArgHandle(arg.handle, ArgTypeCode.MODULE_HANDLE.id);
        return this;
    }

    public Function pushArg(Function arg) {
        Base._LIB.tvmFuncPushArgHandle(arg.handle, ArgTypeCode.FUNC_HANDLE.id);
        return this;
    }

    public Function pushArg(byte[] arg) {
        Base._LIB.tvmFuncPushArgBytes(arg);
        return this;
    }

    public TVMValue call(Object ... args) {
        for (Object arg : args) {
            Function.pushArgToStack(arg);
        }
        return this.invoke();
    }

    private static void pushArgToStack(Object arg) {
        if (arg instanceof Integer) {
            Base._LIB.tvmFuncPushArgLong(((Integer)arg).intValue());
        } else if (arg instanceof Long) {
            Base._LIB.tvmFuncPushArgLong((Long)arg);
        } else if (arg instanceof Float) {
            Base._LIB.tvmFuncPushArgDouble(((Float)arg).floatValue());
        } else if (arg instanceof Double) {
            Base._LIB.tvmFuncPushArgDouble((Double)arg);
        } else if (arg instanceof String) {
            Base._LIB.tvmFuncPushArgString((String)arg);
        } else if (arg instanceof byte[]) {
            Base._LIB.tvmFuncPushArgBytes((byte[])arg);
        } else if (arg instanceof NDArrayBase) {
            NDArrayBase nd = (NDArrayBase)arg;
            int id = nd.isView ? ArgTypeCode.ARRAY_HANDLE.id : ArgTypeCode.NDARRAY_CONTAINER.id;
            Base._LIB.tvmFuncPushArgHandle(nd.handle, id);
        } else if (arg instanceof Module) {
            Base._LIB.tvmFuncPushArgHandle(((Module)arg).handle, ArgTypeCode.MODULE_HANDLE.id);
        } else if (arg instanceof Function) {
            Base._LIB.tvmFuncPushArgHandle(((Function)arg).handle, ArgTypeCode.FUNC_HANDLE.id);
        } else if (arg instanceof TVMValue) {
            TVMValue tvmArg = (TVMValue)arg;
            switch (tvmArg.typeCode) {
                case UINT: 
                case INT: {
                    Base._LIB.tvmFuncPushArgLong(tvmArg.asLong());
                    break;
                }
                case FLOAT: {
                    Base._LIB.tvmFuncPushArgDouble(tvmArg.asDouble());
                    break;
                }
                case STR: {
                    Base._LIB.tvmFuncPushArgString(tvmArg.asString());
                    break;
                }
                case BYTES: {
                    Base._LIB.tvmFuncPushArgBytes(tvmArg.asBytes());
                    break;
                }
                case HANDLE: 
                case ARRAY_HANDLE: 
                case MODULE_HANDLE: 
                case FUNC_HANDLE: {
                    Base._LIB.tvmFuncPushArgHandle(tvmArg.asHandle(), tvmArg.typeCode.id);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid argument: " + arg);
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid argument: " + arg);
        }
    }

    public static void register(String name, Callback function, boolean override) {
        Base.RefLong createdFuncHandleRef = new Base.RefLong();
        Base.checkCall(Base._LIB.tvmFuncCreateFromCFunc(function, createdFuncHandleRef));
        int ioverride = override ? 1 : 0;
        Base.checkCall(Base._LIB.tvmFuncRegisterGlobal(name, createdFuncHandleRef.value, ioverride));
    }

    public static void register(String name, Callback function) {
        Function.register(name, function, false);
    }

    public static Function convertFunc(Callback function) {
        Base.RefLong createdFuncHandleRef = new Base.RefLong();
        Base.checkCall(Base._LIB.tvmFuncCreateFromCFunc(function, createdFuncHandleRef));
        return new Function(createdFuncHandleRef.value);
    }

    private static Object invokeRegisteredCbFunc(Callback cb, TVMValue[] args) {
        if (cb == null) {
            System.err.println("[ERROR] Failed to get registered function");
            return null;
        }
        return cb.invoke(args);
    }

    public static interface Callback {
        public Object invoke(TVMValue ... var1);
    }
}

